<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_mailtest', language 'eu', version '4.3'.
 *
 * @package     local_mailtest
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['additionalinfo'] = 'Informazio gehigarria:';
$string['alwaysshowlog'] = 'Erakutsi beti posta zerbitzariarekin egindako komunikazioen erregistroa, baita errorerik ez badago ere.';
$string['bimidmarcfailure'] = 'BIMI huts egitea DMARC menpekotasunen baten huts egitearen ondorioz.';
$string['bimiinvalidlogo'] = 'BIMI logoa falta da: {$a}.';
$string['biminorecordfound'] = 'BIMI erregistroa falta da.';
$string['bimipctinvalid'] = 'BIMIrentzako DMARC PCT balioan 100 zehaztu behar da.';
$string['bimirecordfound'] = 'BIMI erregistroa aurkitu da.';
$string['bimitagsfound'] = 'BIMI etiketak baliozkoak dira.';
$string['checkingdomain'] = 'DNS segurtasun egiaztapena {$a} domeinuarentzat:';
$string['commoncommissues'] = '<li>Firewall batek zure Moodle gunea blokeatu dezake, zure posta elektronikoko zerbitzariarekin komunikazioa galaraziz.</li>
<li>Baliteke zure webgunearen IP helbidea zure posta elektronikoko zerbitzariaren baimendutako IP helbideen zerrendara gehitu behar izatea.</li>
<li>Ziurtatu ezazu zure SMTP zerbitzaria piztuta eta martxan dagoela.</li>';
$string['commondeliveryissues'] = 'E-maila ez bada 15-30 minututan bidaltzen, egiaztatu itzazu hurrengoak:</p>
<ul>
<li>Ziurtatu TO ataleko helbide elektronikoa zuzena dela.</li>
<li>Egiaztatu jasotzailearen sarra-ontziko SPAM atala.</li>
<li>Egiaztatu jasotzailearen sarrera-ontzia ez dagoela beteta.</li>
<li>Egiaztatu zure no-reply helbide elektronikoaren sarrera-ontzia edozein arrazoirengatik mezua itzuli (entregatu ez) den ikusteko.</a></li>
<li>Egiaztatu zure e-mailaren edukia ez dela zure edo jasotzailearen posta elektronikoko zerbitzariaren iragazkietan SPAM gisa markatzen.</a></li>
<li>Ziurtatu zure posta elektronikoko zerbitzariaren IP helbidea ez dagoela posta-hornitzaileetakoren bateko zerrenda beltzean.</a></li>
{$a}
</ul>';
$string['connectionlog'] = 'Posta zerbitzariarekin egindako komunikazioen erregistroa';
$string['credit'] = 'Michael Milette - <a href="http://www.tngconsulting.ca/">TNG Consulting Inc.</a>';
$string['divertallemails'] = 'Desbideratu e-mail guztiak';
$string['divertedto'] = '{$a}(e)ra desbideratuta';
$string['dkiminvalidrecord'] = 'DKIM erregistroak baliozko v, k eta p etiketak eduki behar ditu.';
$string['dkimmissingselector'] = 'DKIM hautatzailearen ezarpena ez da konfiguratu.';
$string['dkimnorecordfound'] = 'DKIM erregistroa falta da.';
$string['dkimrecordfound'] = 'DKIM erregistroa aurkitu da.';
$string['dkimselectorconfigured'] = 'DKIM hautatzailearen ezarpena konfiguratuta dago.';
$string['dkimspffailed'] = 'DMARCek SPF eta DKIM erregistroak konfiguratuta egotea behar du.';
$string['dkimvalidrecord'] = 'DKIM erregistroaren formatua baliozkoa da.';
$string['dmarcnorecordfound'] = 'DMARC erregistroa falta da.';
$string['dmarcpctinvalid'] = 'DMARC PCT balioa ez dago tartearen barruan.';
$string['dmarcrecordfound'] = 'DMARC erregistroa aurkitu da.';
$string['dmarcruainvalid'] = 'DMARC RUA balioak ez dauka formatu egokia.';
$string['dmarcrufinvalid'] = 'DMARC RUF balioak ez dauka formatu egokia.';
$string['dmarctagsfound'] = 'Beharrezko DMARC etiketak aurkitu dira.';
$string['emailfail'] = 'E-mail mezua bidaltzeak huts egin du';
$string['errorcommunications'] = 'Moodlek ezin izan du komunikatu posta elektronikoko zerbitzariarekin.</p>
<p><strong>Gomedioa:</strong></p>
<p>Egiaztatu ezazu zure Moodleko <a href="{$a}" target="_blank">SMTP E-postaren ezarpenak</a>.</p>
<p>Ondo daudela badirudi, egiaztatu zure SMTP zerbitzariaren edo firewall-aren ezarpenak zure Moodle web zerbitzariko eta zure no-reply helbide elektronikotik SMTP konexioak onartzeko konfiguratuta daudela ziurtatzeko. Laguntza gehiagorako, ikusi dokumentazioko FAQ atala.';
$string['errorsend'] = 'Probarako e-mail mezua ezin izan da posta elektronikoko zerbitzarira bidali.</p>
<p><strong>Gomendioa:</strong></p>
<p>Egiaztatu zure Moodleko<a href="{$a}" target="blank">E-postaren ezarpenak</a>. Laguntza gehiagorako, ikusi dokumentazioko FAQ atala.';
$string['errorunknown'] = '<p>Diagnostikatu gabeko errorea gertatu da.</p>
<p><strong>Gomendioak:</strong></p>
<p>Ikusi azpiko komunikazio-erregistroa. Baliagarria izan ahal zaizu SMTP kodeen zerrendaren erreferentzia <a href="https://www.rfc-editor.org/rfc/rfc5321.html#section-4.2.3" target="_blank">RFC 5321ean</a> eta <a href="https://datatracker.ietf.org/doc/html/rfc4954#section-6" target="_blank">RFC 4954eab</a>.</p>';
$string['failaccessdenied'] = '<li>Posta-zerbitzariarekin konektatu da baina honek konexioa itxi egin du.</li>';
$string['failclosedport'] = 'Zerbitzariaren {$a} ataka itxita dago. :port zenbaki zuzena zehaztu duzu?';
$string['failcredentials'] = '<li>Autentifikazio kredentzialak falta ala baliogabeak dira. Ziurtatu saioa hasteko informazioa zuzena dela.</li>';
$string['faildnslookup'] = 'DNS bilaketak huts egin du. Ziurtatu \'<strong>{$a}</strong>\'(e)k posta-zerbitzariaren helbidea aurkitzen duela.';
$string['failmissingport'] = 'Baliteke "{$a}" motako konexioentzat :port zenbakia zehaztu behar izatea.';
$string['failmissingprotocol'] = 'Baliteke \'{$a}\' atakarekin protokolo-mota segurua (SSL/TLS) zehaztu behar izatea.';
$string['failoutboundsmtpblocked'] = 'Zerbait kanporako SMTP konexioak blokeatzen ari da. Baliteke firewall bat posta-zerbitzarirako zure konexioa blokeatzen aritzea?';
$string['failphpmailer'] = 'Baliteke Moodle LMSren zure instalazioak arazoak izatea. Arrazoietako bat aplikazio fitxategien jabe/talde baimen ezegokiak izan daitezke.';
$string['failphpmailerconfig'] = 'Baliteke zure Moodle zerbitzariko posta-zerbitzua martxan ez egotea edo gaizki konfiguratuta egotea.';
$string['failprotocolmismatch'] = 'Baliteke \'{$a->protocol}\' protokoloaren eta \'{$a->port}\' atakaren artean nahastu izana.';
$string['failunknownmailbox'] = '<li>FROM sarrera-ontzia ez da aurkitu, ez dago eskuragarri ala politikak direla-eta ukatua izan da. Ziurtatu ezazu TO eta FROM helbide elektronikoak existitzen direla eta baliozkoak direla, eta \'no-reply\' helbidea zure posta-zerbitzarian existitzen den benetako sarrera-ontzi bat dela.</li>';
$string['from'] = '{$a->type}: <strong>{$a->email}</strong> (<a href="{$a->url}">{$a->label}</a>)';
$string['fromemail'] = 'Igorlearen helbide elektronikoa';
$string['heading'] = 'Kanporako posta elektronikoaren konfigurazioaren proba';
$string['iconlabel'] = 'Segurtasun egiaztapena {$a}(r)entzat';
$string['message'] = '<p>Hau probarako mezu bat da. Ez egin jaramonik.</p>
<p>Mezu hau jaso baduzu, zure Moodle guneko e-postaren ezarpenak ondo konfiguratu dituzula esan nahi du.</p>
<hr><p><strong>Erabiltzaile-informazio gehigarria</strong></p>
<ul>
<li><strong>Erregistroaren egoera:</strong> {$a->regstatus}</li>
<li><strong>Hobetsitako hizkuntza:</strong> {$a->lang}</li>
<li><strong>Erabiltzailearen web nabigatzailea:</strong> {$a->browser}</li>
<li><strong>Mezuaren igorlea:</strong> {$a->referer}</li>
<li><strong>Moodle bertsioa:</strong> {$a->release}</li>
<li><strong>Erabiltzailearen IP helbidea:</strong> {$a->ip}</li>
</ul>';
$string['noemailever'] = '<p>Gune honetako posta desgaitu da <strong>$CFG-&gt;noemailever = true;</strong> ezarpenaren bitartez.</p>';
$string['nologavailable'] = '<p>Erregistratzea ez dago eskuragarri PHPko mail() funtzioa erabiltzen denean. Halere, baliteke zure zerbitzarian erregistroak aurkitu ahal izatea. Linux-eko kokapen ohikoenak hauek dira:</p>
<ul>
<li>/var/log/maillog</li>
<li>/var/log/mail.log</li>
<li>/var/adm/maillog</li>
<li>/var/adm/syslog/mail.log</li>
</ul>
<p>Bestela, kokapen pertsonalizatu bat zehaztu daiteke php.ini fitxategiko mail.log ezapenean.</p>';
$string['notregistered'] = 'Ez-erregistratua edo saioa hasi gabekoa.';
$string['phpmethod'] = 'PHP metodo lehenetsia';
$string['pluginname'] = 'Posta elektronikoaren konfigurazioaren proba';
$string['pluginname_help'] = 'Posta elektronikoaren konfigurazioaren probak Moodle gune honetako kanporako posta elektronikoaren ezarpenak egiaztatuko ditu zuk zehaztutako helbidera probarako email mezu bat bidalita. Guneko kudeatzaileentzako tresna da.';
$string['primaryadminemail'] = 'Kudeatzaile nagusiaren helbide elektronikoa';
$string['privacy:metadata'] = 'Posta elektronikoaren konfigurazioaren proba pluginak ez du datu pertsonalik biltzen.';
$string['recipientisrequired'] = 'Jasotzailearen helbide elektronikoa zehaztu behar duzu.';
$string['registered'] = 'Erregistratutako erabiltzailea ({$a}).';
$string['sendmethod'] = 'E-mailak bidaltzeko metodoa';
$string['sendtest'] = 'Bidali probarako mezu bat';
$string['sentmail'] = 'Moodlek probarako mezua ondo igorri du STMP posta-zerbitzarira.';
$string['sentmailphp'] = 'Moodleko probarako mezua ondo onartu du PHP Mail-ek.';
$string['server'] = 'Zerbitzaria: {$a}';
$string['smtpmethod'] = 'SMTP ostalariak: {$a}';
$string['spfinvalidrecord'] = 'SPF erregistroak gutxienez mekanismo bat eduki behar du.';
$string['spfnorecordfound'] = 'SPF erregistroa falta da.';
$string['spfrecordfound'] = 'SPF erregistroa aurkitu da.';
$string['spfvalidrecord'] = 'SPF erregistroaren formatua baliozkoa da.';
$string['testing'] = 'Posta elektronikoaren konfigurazioa probatzen';
$string['toemail'] = 'Jasotzailearen helbide elektronikoa';
$string['winsyslog'] = 'Windows-eko Ekitaldien Erregistroa';
$string['youremail'] = 'Zure helbide elektronikoa';
