<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'sl', version '4.3'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Dodajanje nove vloge';
$string['addrole'] = 'Dodaj novo vlogo';
$string['advancedoverride'] = 'Napredna preglasitev vloge';
$string['allow'] = 'Dovoli';
$string['allowassign'] = 'Dovoli dodelitev vlog';
$string['allowed'] = 'Dovoljeno';
$string['allowoverride'] = 'Dovoli preglasitve vlog';
$string['allowroletoassign'] = 'Dovoli uporabnikom z vlogo {$a->fromrole}, da določijo vlogo {$a->targetrole}';
$string['allowroletooverride'] = 'Dovoli uporabnikom z vlogo {$a->fromrole}, da preglasijo vlogo {$a->targetrole}';
$string['allowroletoswitch'] = 'Dovoli uporabnikom z vlogo {$a->fromrole}, da zamenjajo vloge na {$a->targetrole}';
$string['allowroletoview'] = 'Dovoli uporabnikom z vlogo {$a->fromrole}, da si ogledajo vlogo {$a->targetrole}';
$string['allowswitch'] = 'Dovoli zamenjave vlog';
$string['allowview'] = 'Dovoli vlogo za pogled';
$string['allsiteusers'] = 'Vsi uporabniki strani';
$string['analytics:listinsights'] = 'Seznam vpogledov';
$string['analytics:listowninsights'] = 'Seznam lastnih vpogledov';
$string['analytics:managemodels'] = 'Urejaj modele';
$string['archetype'] = 'Arhetip vloge';
$string['archetype_help'] = 'Arhetip vloge določa dovoljenja, kdaj je vloga ponastavljena na privzeto. Določa tudi nova dovoljenja za vlogo, ko je stran nadgrajena.';
$string['archetypecoursecreator'] = 'ARHETIP: Ustvarjalec predmeta';
$string['archetypeeditingteacher'] = 'ARHETIP: Učitelj (urejanje)';
$string['archetypefrontpage'] = 'ARHETIP: Overjeni uporabnik na prvi strani';
$string['archetypeguest'] = 'ARHETIP: Gost';
$string['archetypemanager'] = 'ARHETIP: Upravljalec';
$string['archetypestudent'] = 'ARHETIP: Udeleženec';
$string['archetypeteacher'] = 'ARHETIP: Učitelj (brez urejanja)';
$string['archetypeuser'] = 'ARHETIP: Overjeni uporabnik';
$string['assignanotherrole'] = 'Dodeli še eno vlogo';
$string['assignedroles'] = 'Dodeljene vloge';
$string['assignerror'] = 'Pri dodeljevanju vloge {$a->role} uporabniku {$a->user} je prišlo do napake.';
$string['assignglobalroles'] = 'Dodeli sistemske vloge';
$string['assignmentcontext'] = 'Kontekst dodeljevanja';
$string['assignmentoptions'] = 'Možnosti dodeljevanja';
$string['assignrole'] = 'Dodeli vlogo';
$string['assignrolenameincontext'] = 'Dodeli vlogo \'{$a->role}\' v {$a->context}';
$string['assignroles'] = 'Dodeli vloge';
$string['assignroles_help'] = 'Z določanjem vloge uporabniku v kontekstu mu dodelite dovoljenja določene vloge za trenutni kontekst in vse podrejene kontekste. Primer: če uporabniku v kontekstu Predmeta določite vlogo Udeleženca, bo imel uporabnik to vlogo v predmetu in tudi pri vseh blokih in dejavnostih v predmetu.';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesin'] = 'Dodeli vloge v {$a}';
$string['assignrolesrelativetothisuser'] = 'Dodeli vloge, relativne za tega uporabnika';
$string['backtoallroles'] = 'Nazaj na seznam vseh vlog';
$string['backup:anonymise'] = 'Anonimiziraj podatke o uporabniku v varnostnih kopijah';
$string['backup:backupactivity'] = 'Varnostno kopiraj dejavnosti';
$string['backup:backupcourse'] = 'Varnostno kopiraj predmete';
$string['backup:backupsection'] = 'Varnostno kopiraj odseke';
$string['backup:backuptargetimport'] = 'Varnostno kopiraj za uvoz';
$string['backup:configure'] = 'Konfiguriraj možnosti varnostnih kopij';
$string['backup:downloadfile'] = 'Prenesi datoteke iz področij varnostnih kopij';
$string['backup:userinfo'] = 'Varnostno kopiraj podatke o uporabniku';
$string['badges:awardbadge'] = 'Uporabniku podeli značko';
$string['badges:configurecriteria'] = 'Nastavi/določi kriterije za pridobivanje značke';
$string['badges:configuredetails'] = 'Nastavi/določi podrobnosti značke';
$string['badges:configuremessages'] = 'Konfiguriraj sporočila značke';
$string['badges:createbadge'] = 'Ustvari/podvoji značke';
$string['badges:deletebadge'] = 'Izbriši značke';
$string['badges:earnbadge'] = 'Pridobi značko';
$string['badges:manageglobalsettings'] = 'Upravljaj globalne nastavitve značk';
$string['badges:manageownbadges'] = 'Prikaži in upravljaj z mojimi pridobljenimi priznanji';
$string['badges:revokebadge'] = 'Razveljavi značko uporabnika';
$string['badges:viewawarded'] = 'Prikaži uporabnike, ki so pridobili določeno značko, ne da bi lahko podelili značko';
$string['badges:viewbadges'] = 'Prikaži možne značke, ne da bi jih pridobil';
$string['badges:viewotherbadges'] = 'Prikaži javne značke v profilih drugih uporabnikov';
$string['block:edit'] = 'Uredi nastavitve bloka';
$string['block:view'] = 'Ogled bloka';
$string['blog:create'] = 'Ustvari nove vpise v blog';
$string['blog:manageentries'] = 'Urejanje in upravljanje objav';
$string['blog:manageexternal'] = 'Uredi in upravljaj zunanje bloge';
$string['blog:search'] = 'Išči vpise v blog';
$string['blog:view'] = 'Prikaži vpise bloga';
$string['blog:viewdrafts'] = 'Prikaži osnutke vpisov bloga';
$string['calendar:manageentries'] = 'Upravljanje vseh vnosov koledarja';
$string['calendar:managegroupentries'] = 'Upravljanje skupinskih vnosov koledarja';
$string['calendar:manageownentries'] = 'Upravljanje lastnih vnosov koledarja';
$string['capabilities'] = 'Zmožnosti';
$string['capability'] = 'Zmožnost';
$string['category:create'] = 'Ustvarjanje kategorij';
$string['category:delete'] = 'Brisanje kategorij';
$string['category:manage'] = 'Upravljanje kategorij';
$string['category:update'] = 'Posodabljanje kategorij';
$string['category:viewcourselist'] = 'Prikaži seznam predmetov, v katere niste vpisani';
$string['category:viewhiddencategories'] = 'Ogled skritih kategorij';
$string['category:visibility'] = 'Ogled skritih kategorij';
$string['checkglobalpermissions'] = 'Preveri sistemska dovoljenja';
$string['checkpermissions'] = 'Preveri dovoljenja';
$string['checkpermissionsin'] = 'Preveri dovoljenja v {$a}';
$string['checksystempermissionsfor'] = 'Preveri sistemska dovoljenja za {$a->fullname}';
$string['checkuserspermissionshere'] = 'Preveri, katera dovoljenja ima {$a->fullname} za ta {$a->contextlevel}';
$string['chooseroletoassign'] = 'Izberite vlogo za dodelitev';
$string['cohort:assign'] = 'Dodaj in odstrani člane kohorte';
$string['cohort:manage'] = 'Ustvari, izbriši in premakni kohorte';
$string['cohort:view'] = 'Ogled kohort celotnega spletnega mesta';
$string['comment:delete'] = 'Izbriši komentarje';
$string['comment:post'] = 'Objavi komentarje';
$string['comment:view'] = 'Preberi komentarje';
$string['competency:competencygrade'] = 'Nastavi ocenjevanje kompetence';
$string['competency:competencymanage'] = 'Upravljaj ogrodja komptenc';
$string['competency:competencyview'] = 'Prikaži ogrodja kompetenc';
$string['competency:coursecompetencyconfigure'] = 'Konfiguriraj nastavitve kompetenc predmeta';
$string['competency:coursecompetencygradable'] = 'Prejmi točke kompetenc';
$string['competency:coursecompetencymanage'] = 'Upravljaj kompetence predmeta';
$string['competency:coursecompetencyview'] = 'Prikaži kompetence predmeta';
$string['competency:evidencedelete'] = 'Izbriši dokaz';
$string['competency:plancomment'] = 'Komentiraj učni načrt';
$string['competency:plancommentown'] = 'Komentiraj lastni učni načrt';
$string['competency:planmanage'] = 'Upravljaj učne načrte';
$string['competency:planmanagedraft'] = 'Upravljaj osnutke učnih načrtov';
$string['competency:planmanageown'] = 'Upravljaj lastne učne načrte';
$string['competency:planmanageowndraft'] = 'Upravljaj lastne osnutke učnih načrtov';
$string['competency:planrequestreview'] = 'Zahtevaj pregled učnega načrta';
$string['competency:planrequestreviewown'] = 'Zahtevaj pregled lastnega učnega načrta';
$string['competency:planreview'] = 'Preglej učni načrt';
$string['competency:planview'] = 'Prikaži vse učne načrte';
$string['competency:planviewdraft'] = 'Prikaži osnutke učnih načrtov';
$string['competency:planviewown'] = 'Prikaži lastne učne načrte';
$string['competency:planviewowndraft'] = 'Prikaži lastne osnutke učnih načrtov';
$string['competency:templatemanage'] = 'Upravljaj predloge učnega načrta';
$string['competency:templateview'] = 'Prikaži predloge učnega načrta';
$string['competency:usercompetencycomment'] = 'Komentiraj uporabnikove kompetence';
$string['competency:usercompetencycommentown'] = 'Komentiraj lastne uporabnikove kompetence';
$string['competency:usercompetencyrequestreview'] = 'Zahtevaj pregled uporabnikovih kompetenc';
$string['competency:usercompetencyrequestreviewown'] = 'Zahtevaj pregled lastnih uporabnikovih kompetenc';
$string['competency:usercompetencyreview'] = 'Preglej uporabnikove kompetence';
$string['competency:usercompetencyview'] = 'Prikaži uporabnikovo kompetenco';
$string['competency:userevidencemanage'] = 'Upravljaj dokaz predhodnega učenja';
$string['competency:userevidencemanageown'] = 'Upravljaj lastni dokaz predhodnega učenja';
$string['competency:userevidenceview'] = 'Prikaži dokaz predhodnega učenja uporabnika';
$string['confirmaddadmin'] = 'Res želite dodati uporabnika<strong>{$a}</strong> kot novega skrbnika strani?';
$string['confirmdeladmin'] = 'Res želite odstraniti uporabnika<strong>{$a}</strong> iz seznama skrbnikov sistema?';
$string['confirmroleprevent'] = 'Res želite odstraniti<strong>{$a->role}</strong> iz seznama dovoljenih vlog za kompatibilnost{$a->cap} v kontekstu {$a->context}?';
$string['confirmroleunprohibit'] = 'Res želite odstraniti <strong>{$a->role}</strong> iz seznama nedovoljenih vlog za kompatibilnost {$a->cap} v kontekst {$a->context}?';
$string['confirmunassign'] = 'Ste prepričani, da želite odstraniti to vlogo iz tega uporabnika?';
$string['confirmunassignno'] = 'Prekliči';
$string['confirmunassigntitle'] = 'Potrdi spremembo vloge';
$string['confirmunassignyes'] = 'Odstrani';
$string['contentbank:access'] = 'Dostop do zbirke vsebin';
$string['contentbank:deleteanycontent'] = 'Izbriši katerokoli vsebino iz zbirke vsebin';
$string['contentbank:deleteowncontent'] = 'Izbriši vsebino iz lastne zbirke vsebin';
$string['contentbank:downloadcontent'] = 'Prenesi vsebino iz zbirke vsebin';
$string['contentbank:manageanycontent'] = 'Upravljaj katerokoli vsebino iz zbirke vsebin';
$string['contentbank:manageowncontent'] = 'Upravljaj vsebino iz lastne zbirke vsebin';
$string['contentbank:upload'] = 'Naloži novo vsebino v zbirko vsebin';
$string['contentbank:useeditor'] = 'Ustvari ali uredi vsebino z urejevalnikom vrste vsebine';
$string['context'] = 'Kontekst';
$string['course:activityvisibility'] = 'Skrij/prikaži dejavnosti';
$string['course:bulkmessaging'] = 'Pošiljanje sporočil večim osebam';
$string['course:changecategory'] = 'Spremeni kategorijo predmeta';
$string['course:changefullname'] = 'Spreminjanje polnega imena predmeta';
$string['course:changeidnumber'] = 'Spreminjanje ID številke predmeta';
$string['course:changelockedcustomfields'] = 'Spremeni zaklenjeno polje po meri';
$string['course:changeshortname'] = 'Spreminjanje kratkega imena predmeta';
$string['course:changesummary'] = 'Spremeni povzetek predmeta';
$string['course:configurecustomfields'] = 'Konfiguriraj polja po meri';
$string['course:configuredownloadcontent'] = 'Konfiguriraj prenos vsebine predmeta';
$string['course:create'] = 'Ustvarjanje predmetov';
$string['course:creategroupconversations'] = 'Ustvari skupinske pogovore';
$string['course:delete'] = 'Brisanje predmetov';
$string['course:downloadcoursecontent'] = 'Prenesi vsebino predmeta';
$string['course:enrolconfig'] = 'Konfiguriraj vpisne primere v predmetih';
$string['course:enrolreview'] = 'Preglej vpise v predmet';
$string['course:ignoreavailabilityrestrictions'] = 'Prezri omejitve razpoložljivosti';
$string['course:ignorefilesizelimits'] = 'Uporabi datoteke, večje od omejitev velikosti datotek';
$string['course:isincompletionreports'] = 'Prikaži na poročilu o zaključku';
$string['course:manageactivities'] = 'Upravljanje dejavnosti';
$string['course:managefiles'] = 'Upravljanje datotek';
$string['course:managegrades'] = 'Upravljanje ocen';
$string['course:managegroups'] = 'Upravljanje skupin';
$string['course:managescales'] = 'Upravljanje lestvic';
$string['course:markcomplete'] = 'Označi uporabnike kot končane v zaključku predmeta';
$string['course:movesections'] = 'Premakni odseke';
$string['course:overridecompletion'] = 'Preglasi status zaključka dejavnosti';
$string['course:recommendactivity'] = 'Priporoči dejavnosti v izbirniku dejavnosti';
$string['course:renameroles'] = 'Preimenuj vloge';
$string['course:request'] = 'Zahtevanje novih predmetov';
$string['course:reset'] = 'Ponastavitev predmeta';
$string['course:reviewotherusers'] = 'Preglej druge uporabnike';
$string['course:sectionvisibility'] = 'Nadzor nad vidnostjo odsekov';
$string['course:setcurrentsection'] = 'Nastavitev trenutnega odseka';
$string['course:setforcedlanguage'] = 'Vsili jezik predmeta';
$string['course:tag'] = 'Spremeni oznake predmeta';
$string['course:togglecompletion'] = 'Ročno označi dejavnosti kot končane';
$string['course:update'] = 'Posodobitev nastavitev predmeta';
$string['course:useremail'] = 'Omogočanje/onemogočanje e-poštnih naslovov';
$string['course:view'] = 'Ogled predmetov brez sodelovanja';
$string['course:viewcoursegrades'] = 'Ogled ocen predmeta';
$string['course:viewhiddenactivities'] = 'Ogled skritih dejavnosti';
$string['course:viewhiddencourses'] = 'Ogled skritih predmetov';
$string['course:viewhiddensections'] = 'Ogled skritih odsekov';
$string['course:viewhiddenuserfields'] = 'Ogled skritih uporabniških polj';
$string['course:viewparticipants'] = 'Prikaži sodelujoče';
$string['course:viewscales'] = 'Ogled lestvic';
$string['course:viewsuspendedusers'] = 'Prikaži začasno onemogočene uporabnike';
$string['course:visibility'] = 'SKrij/prikaži predmete';
$string['createrolebycopying'] = 'Ustvari novo vlogo s kopiranjem {$a}';
$string['createthisrole'] = 'Ustvari to vlogo';
$string['currentcontext'] = 'Trenutni kontekst';
$string['currentrole'] = 'Trenutna vloga';
$string['customroledescription'] = 'Opis po meri';
$string['customroledescription_help'] = 'Če je opis po meri prazen, se opisi privzetih vlog lokalizirajo samodejno.';
$string['customrolename'] = 'Polno ime po meri';
$string['customrolename_help'] = 'Če je opis po meri prazen, se opisi privzetih vlog lokalizirajo samodejno. Za privzete vloge morate podati polno ime.';
$string['defaultrole'] = 'Privzeta vloga';
$string['defaultx'] = 'Privzeto: {$a}';
$string['defineroles'] = 'Določi vloge';
$string['deletecourseoverrides'] = 'Izbriši vse povozitve v predmetu';
$string['deletelocalroles'] = 'Izbriši vse lokalno določene vloge';
$string['deleterolesure'] = '<p>Ali ste prepričani, da želite izbrisati vlogo "{$a->name} ({$a->shortname})"?</p><p>Trenutno je ta vloga dodeljena {$a->count} uporabnikom.</p>';
$string['deletexrole'] = 'Izbriši vlogo {$a}';
$string['duplicaterole'] = 'Podvoji vlogo';
$string['duplicaterolesure'] = '<p>Ali ste prepričani, da želite podvojiti vlogo "{$a->name} ({$a->shortname})"?</p>';
$string['editingrolex'] = 'Urejanje vloge \'{$a}';
$string['editrole'] = 'Uredi vlogo';
$string['editxrole'] = 'Uredi vlogo {$a}';
$string['errorbadrolename'] = 'Nepravilno ime vloge';
$string['errorbadroleshortname'] = 'Nepravilno kratko ime vloge';
$string['errorexistsrolename'] = 'Vloga s tem imenom že obstaja';
$string['errorexistsroleshortname'] = 'Vloga s tem imenom že obstaja';
$string['errorroleshortnametoolong'] = 'Kratko ime ne sme biti daljše od 100 znakov.';
$string['eventcapabilityassigned'] = 'Dodeljena zmožnost';
$string['eventcapabilityunassigned'] = 'Nedodeljena zmožnost';
$string['eventroleallowassignupdated'] = 'Dovoli dodelitve vlog';
$string['eventroleallowoverrideupdated'] = 'Dovoli preglasitve vlog';
$string['eventroleallowswitchupdated'] = 'Dovoli zamenjave vlog';
$string['eventroleallowviewupdated'] = 'Dovoli ogled vloge';
$string['eventroleassigned'] = 'Dodeljena vloga';
$string['eventrolecapabilitiesupdated'] = 'Posodobljene zmožnosti vlog';
$string['eventroledeleted'] = 'Izbrisana vloga';
$string['eventroleunassigned'] = 'Nedodeljena vloga';
$string['eventroleupdated'] = 'Posodobljena vloga';
$string['existingadmins'] = 'Trenutni skrbniki strani';
$string['existingusers'] = '{$a} obstoječih uporabnikov';
$string['explanation'] = 'Razlaga';
$string['export'] = 'Izvozi';
$string['extusers'] = 'Obstoječi uporabniki';
$string['extusersmatching'] = 'Obstoječi uporabniki, ki se ujemajo z \'{$a}';
$string['filter:manage'] = 'Upravljaj lokalne nastavitve filtra';
$string['frontpageuser'] = 'Potrjeni uporabnik na prvi strani';
$string['frontpageuserdescription'] = 'Vsi prijavljeni uporabniki v predmetu na prvi strani.';
$string['globalrole'] = 'Sistemska vloga';
$string['globalroleswarning'] = 'OPOZORILO! Vloge, dodeljene preko te strani, bodo uporabnikom dodeljene za celotno spletno mesto, vključno z  vstopno stranjo in vsemi predmeti.';
$string['gotoassignroles'] = 'Pojdi na Dodeli vloge temu {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Pojdi na Dodelitev sistemskih vlog';
$string['grade:edit'] = 'Urejanje ocen';
$string['grade:export'] = 'Izvažanje ocen';
$string['grade:hide'] = 'Skrij/prikaži ocene ali postavke';
$string['grade:import'] = 'Uvažanje ocen';
$string['grade:lock'] = 'Zaklepanje ocen ali postavk';
$string['grade:manage'] = 'Upravljanje postavk ocen';
$string['grade:managegradingforms'] = 'Upravljaj napredne metode ocenjevanja';
$string['grade:manageletters'] = 'Upravljanje črkovnih ocen';
$string['grade:manageoutcomes'] = 'Upravljanje izidov ocen';
$string['grade:managesharedforms'] = 'Upravljaj napredne metode ocenjevanja s predlogami';
$string['grade:override'] = 'Preglasitev ocen';
$string['grade:sharegradingforms'] = 'Deli napredne metode ocenjevanja kot predlogo';
$string['grade:unlock'] = 'Odklepanje ocen ali postavk';
$string['grade:view'] = 'Ogled lastnih ocen';
$string['grade:viewall'] = 'Ogled ocen drugih uporabnikov';
$string['grade:viewhidden'] = 'Ogled skritih ocen za lastnika';
$string['h5p:deploy'] = 'Uvedi vsebino H5P';
$string['h5p:setdisplayoptions'] = 'Nastavi H5P možnosti prikaza';
$string['h5p:updatelibraries'] = 'Upravljaj tipe vsebine H5P';
$string['highlightedcellsshowdefault'] = 'Označena dovoljenja v spodnji tabeli so privzete vrednosti za arhetip vloge, označene zgoraj';
$string['highlightedcellsshowinherit'] = 'Poudarjene celice v spodnji tabeli prikazujejo dovoljenja (če obstajajo), ki bodo podedovana. Razen tistih  zmožnosti, katerih dovoljenja dejansko želite spremeniti, morate pustiti vse na podedovano.';
$string['inactiveformorethan'] = 'nedejaven več kot {$a->timeperiod}';
$string['ingroup'] = 'v skupini "{$a->group}"';
$string['inherit'] = 'Podeduj';
$string['invalidpresetfile'] = 'Neveljavna datoteka opredelitve vloge';
$string['legacy:admin'] = 'PODEDOVANA VLOGA: Skrbnik';
$string['legacy:coursecreator'] = 'PODEDOVANA VLOGA: Ustvajalec predmeta';
$string['legacy:editingteacher'] = 'PODEDOVANA VLOGA: Izvajalec (urednik)';
$string['legacy:guest'] = 'PODEDOVANA VLOGA: Gost';
$string['legacy:student'] = 'PODEDOVANA VLOGA: Udeleženec';
$string['legacy:teacher'] = 'PODEDOVANA VLOGA: Izvajalec (Ni urednik)';
$string['legacy:user'] = 'PODEDOVANA VLOGA: Overjeni uporabnik';
$string['legacytype'] = 'Vrsta podedovane vloge';
$string['listallroles'] = 'Seznam vseh vlog';
$string['localroles'] = 'Lokalno določene vloge';
$string['mainadmin'] = 'Glavni skrbnik';
$string['mainadminset'] = 'Določi glavnega skrbnika';
$string['manageadmins'] = 'Upravljaj s skrbniki strani';
$string['manager'] = 'Upravljalec';
$string['managerdescription'] = 'Upravljalec lahko dostopa do predmeta in ga spreminja. Po navadi ne sodeluje v predmetih.';
$string['manageroles'] = 'Upravljanje vlog';
$string['maybeassignedin'] = 'Vrste kontekstov, kamor je lahko ta vloga dodeljena';
$string['morethan'] = 'Več kot {$a}';
$string['multipleroles'] = 'Večkratne vloge';
$string['my:configsyspages'] = 'Nastavite sistemske predloge za Pregledno ploščo';
$string['my:manageblocks'] = 'Upravljanje blokov na Pregledni plošči';
$string['neededroles'] = 'Vloge z dovoljenjem';
$string['nocapabilitiesincontext'] = 'Ni dostopnih zmožnosti za ta kontekst';
$string['noneinthisx'] = 'Nič v tem {$a}';
$string['noneinthisxmatching'] = 'Ni uporabnikov, ki se ujemajo z \'{$a->search}\' v tem {$a->contexttype}';
$string['norole'] = 'Ni vloge';
$string['noroleassignments'] = 'Ta uporabnik nima dodeljenih vlog na spletnem mestu.';
$string['noroles'] = 'Ni vlog';
$string['notabletoassignroleshere'] = 'V tem kontekstu skrbnik ni omogočil dodeljevanja vlog.';
$string['notabletooverrideroleshere'] = 'Tukaj vam ni omogočeno preglasiti dovoljenj vlog';
$string['notes:manage'] = 'Upravljanje opomb';
$string['notes:view'] = 'Ogled opomb';
$string['notset'] = 'Ni določeno';
$string['novisibleroles'] = 'Ni vlog';
$string['overrideanotherrole'] = 'Preglasi drugo vlogo';
$string['overridecontext'] = 'Preglasi kontekst';
$string['overridepermissions'] = 'Preglasi dovoljenja';
$string['overridepermissions_help'] = 'Preglasitve dovoljenj omogočajo, da dovolite ali preprečite izbrane zmožnosti v specifičnem kontekstu.';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overridepermissionsforrole'] = 'Preglasi dovoljenja za vlogo \'{$a->role}\' v {$a->context}';
$string['overridepermissionsin'] = 'Preglasi dovoljenja v {$a}';
$string['overrideroles'] = 'Preglasi vloge';
$string['overriderolesin'] = 'Preglasi vloge v {$a}';
$string['overrides'] = 'Preglasitve';
$string['overridesbycontext'] = 'Preglasitve (v kontekstu)';
$string['payment:manageaccounts'] = 'Upravljaj račune';
$string['payment:viewpayments'] = 'Ogled plačil';
$string['permission'] = 'Dovoljenja';
$string['permission_help'] = 'Dovoljenja so nastavitve zmožnosti. Na voljo so 4 možnosti:

* Ni nastavljeno
* Dovoli - Dovoljenje za zmožnost je podeljeno
* Prepreči - Dovoljenje za zmožnost je odvzeto, četudi je dovoljeno na višjem kontekstu
* Prepovej - Dovoljenje je v celoti zavrnjeno in ga ni mogoče preglasiti na nižjem (bolj specifičnem) kontekstu';
$string['permissions'] = 'Dovoljenja';
$string['permissionsforuser'] = 'Dovoljenja za uporabnika {$a}';
$string['permissionsincontext'] = 'Dovoljenja v {$a}';
$string['portfolio:export'] = 'Izvozi v listovnik';
$string['potentialusers'] = '{$a} možnih uporabnikov';
$string['potusers'] = 'Potencialni uporabniki';
$string['potusersmatching'] = 'Potencialni uporabniki, ki se ujemajo \'{$a}';
$string['prevent'] = 'Prepreči';
$string['privacy:metadata:preference:showadvanced'] = 'Obravnavaj gumb za preklop za preklop na napredni način';
$string['privacy:metadata:role_assignments'] = 'Dodelitve vlog';
$string['privacy:metadata:role_assignments:component'] = 'Vtičnik, odgovoren za dodeljevanje vlog, izpraznjen, ko je ročno dodeljen.';
$string['privacy:metadata:role_assignments:itemid'] = 'ID vpisa/pristnega vpisa, odgovornega za to dodelitev vloge';
$string['privacy:metadata:role_assignments:modifierid'] = 'ID uporabnika, ki je ustvaril ali spremenil dodelitev vloge';
$string['privacy:metadata:role_assignments:roleid'] = 'ID vloge';
$string['privacy:metadata:role_assignments:tableexplanation'] = 'Ta tabela shranjuje dodeljene vloge v vsakem kontekstu.';
$string['privacy:metadata:role_assignments:timemodified'] = 'Datum, ko je bila dodelitev vloge ustvarjena ali spremenjena.';
$string['privacy:metadata:role_assignments:userid'] = 'ID uporabnika';
$string['privacy:metadata:role_capabilities'] = 'Zmožnosti vlog';
$string['privacy:metadata:role_capabilities:capability'] = 'Ime vloge.';
$string['privacy:metadata:role_capabilities:modifierid'] = 'ID uporabnika, ki je ustvaril ali spremenil zmožnost';
$string['privacy:metadata:role_capabilities:permission'] = 'Dovoljenje za zmožnost: prevzemi, dovoli, prepreči or prepovej.';
$string['privacy:metadata:role_capabilities:roleid'] = 'ID vloge';
$string['privacy:metadata:role_capabilities:tableexplanation'] = 'Zmožnosti in povozitvene zmožnosti za določeno vlogo v določenem kontekstu';
$string['privacy:metadata:role_capabilities:timemodified'] = 'Datum, ko je bila zmožnost ustvarjena ali spremenjena.';
$string['privacy:metadata:role_cohortroles'] = 'Vloge v kohorto';
$string['prohibit'] = 'Prepovej';
$string['prohibitedroles'] = 'Prepovedano';
$string['question:add'] = 'Dodajanje novih vprašanj';
$string['question:config'] = 'Nastavitev vrst vprašanj';
$string['question:editall'] = 'Urejanje vseh vprašanj';
$string['question:editmine'] = 'Urejanje lastnih vprašanj';
$string['question:flag'] = 'Označi vprašanja z zastavico med reševanjem';
$string['question:managecategory'] = 'Upravljanje kategorij vprašanj';
$string['question:moveall'] = 'Premikanje vseh vprašanj';
$string['question:movemine'] = 'Premikanje lastnih vprašanj';
$string['question:tagall'] = 'Označi vsa vprašanja';
$string['question:tagmine'] = 'Označi lastna vprašanja';
$string['question:useall'] = 'Uporaba vseh vprašanj';
$string['question:usemine'] = 'Uporaba lastnih vprašanj';
$string['question:viewall'] = 'Ogled vseh vprašanj';
$string['question:viewmine'] = 'Ogled lastnih vprašanj';
$string['rating:rate'] = 'Dodaj ocene na predmete';
$string['rating:view'] = 'Ogled vseh ocen, ki ste jih prejeli';
$string['rating:viewall'] = 'Ogled vseh surovih ocen, ki so jih dodelili posamezniki';
$string['rating:viewany'] = 'Ogled vseh ocen, ki jih je kdorkoli prejel';
$string['resetrole'] = 'Ponastavitev na privzeto';
$string['resettingrole'] = 'Ponovno nastavi vlogo \'{$a}\'';
$string['restore:configure'] = 'Nastavi obnovitvene možnosti';
$string['restore:createuser'] = 'Ustvari uporabnike pri obnovitvi';
$string['restore:restoreactivity'] = 'Obnovi dejavnosti';
$string['restore:restorecourse'] = 'Obnovi predmete';
$string['restore:restoresection'] = 'Obnovi odseke';
$string['restore:restoretargetimport'] = 'Obnovi iz datotek, označenih za uvoz';
$string['restore:rolldates'] = 'Ob obnovitvi je dovoljen vpis nastavitev konfiguracije';
$string['restore:uploadfile'] = 'Naloži datoteke na področje za varnostne kopije';
$string['restore:userinfo'] = 'Obnovi uporabniške podatke';
$string['restore:viewautomatedfilearea'] = 'Obnovi predmete iz avtomatskih varnostnih kopij';
$string['risks'] = 'Nevarnosti';
$string['role:assign'] = 'Dodeljevanje vlog uporabnikom';
$string['role:manage'] = 'Ustvarjanje in upravljanje vlog';
$string['role:override'] = 'Preglasitve dovoljenj za ostale';
$string['role:review'] = 'Preglej dovoljenja za ostale';
$string['role:safeoverride'] = 'Preglasitve varnih dovoljenj za ostale';
$string['role:switchroles'] = 'Preklapljanje v druge vloge';
$string['roleallowheader'] = 'Dovoli vlogo:';
$string['roleallowinfo'] = 'Izberite vlogo, ki bo dodana na seznam dovoljenih vlog v kontekstu {$a->context}, zmožnosti  {$a->cap}:';
$string['roleassignments'] = 'Dodeljevanje vlog';
$string['roledefinitions'] = 'Definicije vlog';
$string['rolefullname'] = 'Ime';
$string['roleincontext'] = '{$a->role} v {$a->context}';
$string['roleprohibitheader'] = 'Prepovej vlogo';
$string['roleprohibitinfo'] = 'Izberite vlogo, ki bo dodana na seznam nedovoljenih vlog v kontekstu {$a->context}, zmožnosti  {$a->cap}:';
$string['rolerepreset'] = 'Uporabi prednastavitev vloge';
$string['roleresetdefaults'] = 'Privzete vrednosti';
$string['roleresetrole'] = 'Uporabi vlogo ali arhetip';
$string['rolerisks'] = 'Nevarnosti vloge';
$string['roles'] = 'Vloge';
$string['roles_help'] = 'Vloga je zbirka dovoljenj, določenih za celotno spletno mesto, ki jih lahko dodelite določenim uporabnikom v določenih kontekstih.';
$string['roles_link'] = 'vloge';
$string['roleselect'] = 'Izberite vlogo';
$string['rolesforuser'] = 'Vloge za uporabnika {$a}';
$string['roleshortname'] = 'Kratko ime';
$string['roleshortname_help'] = 'Kratko ime vloge je identifikator vlog nizke stopnje, v katerem so dovoljeni samo alfanumerični znaki ASCII. Ne spreminjajte kratkih imen privzetih vlog.';
$string['roletoassign'] = 'Vloga za dodelitev';
$string['roletooverride'] = 'Vloga za preglasitev';
$string['safeoverridenotice'] = 'Pomni: Zmožnosti z višjim tveganjem so zaklenjene, saj imate dovoljenje samo za upravljanje varnih zmožnosti.';
$string['search:query'] = 'Izvedi  iskanje po vsem spletišču';
$string['selectanotheruser'] = 'Izberite drugega uporabnika';
$string['selectauser'] = 'Izberite uporabnika';
$string['selectrole'] = 'Izberite vlogo';
$string['showallroles'] = 'Pokaži vse vloge';
$string['showthisuserspermissions'] = 'Prikaži dovoljenja tega uporabnika';
$string['site:accessallgroups'] = 'Dostop do vseh skupin';
$string['site:approvecourse'] = 'Odobritev ustvarjanja predmeta';
$string['site:backup'] = 'Ustvarjanje varnostnih kopij predmeta';
$string['site:config'] = 'Spreminjanje konfiguracije spletnega mesta';
$string['site:configview'] = 'Ogled drevesa skrbništva spletnega mesta (a ne vseh strani v njem)';
$string['site:deleteanymessage'] = 'Izbriši vsa sporočila na spletnem mestu';
$string['site:deleteownmessage'] = 'Izbriši vsa uporabnikova sporočila';
$string['site:doanything'] = 'Dovoljenje za vsa dejanja';
$string['site:doclinks'] = 'Prikaz povezav na dokumente na drugih straneh';
$string['site:forcelanguage'] = 'Povozi jezik predmeta';
$string['site:import'] = 'Uvoz drugih predmetov v predmet';
$string['site:maintenanceaccess'] = 'Dostop do spletnega mesta v vzdrževalnem načinu';
$string['site:manageallmessaging'] = 'Dodaj, odstrani, blokiraj in odblokiraj kontakte kateregakoli uporabnika';
$string['site:manageblocks'] = 'Upravljaj z bloki na strani';
$string['site:managecontextlocks'] = 'Upravljaj zamrznitev kontekstov';
$string['site:messageanyuser'] = 'Nastavitve zasebnosti uporabnika z enkratnim dostopom za pošiljanje sporočil drugim uporabnikom';
$string['site:mnetloginfromremote'] = 'Prijava iz oddaljenega Moodla';
$string['site:mnetlogintoremote'] = 'Uporaba oddaljenih Moodlov preko MNet';
$string['site:readallmessages'] = 'Branje vseh sporočil na strani';
$string['site:restore'] = 'Ponastavitev predmetov';
$string['site:senderrormessage'] = 'Pošlji sporočilo uporabniku podpore s strani napake';
$string['site:sendmessage'] = 'Pošiljanje sporočil kateremukoli uporabniku';
$string['site:trustcontent'] = 'Zanesljivost objavljene vsebine';
$string['site:uploadusers'] = 'Nalaganje novih uporabnikov iz datoteke';
$string['site:viewanonymousevents'] = 'Ogled anonimnih dogodkov v poročilih';
$string['site:viewfullnames'] = 'Vedno vidi polna imena uporabnikov';
$string['site:viewparticipants'] = 'Prikaži sodelujoče';
$string['site:viewreports'] = 'Ogled poročil';
$string['site:viewuseridentity'] = 'Poglej ves uporabniški ID v seznamih';
$string['siteadministrators'] = 'Skrbniki strani';
$string['tag:edit'] = 'Urejanje obstoječih oznak';
$string['tag:editblocks'] = 'Urejanje blokov na straneh oznak';
$string['tag:flag'] = 'Obeleži oznake kot neprimerne';
$string['tag:manage'] = 'Upravljanje oznak';
$string['thisnewrole'] = 'Ta nova vloga';
$string['thisusersroles'] = 'Določene vloge za tega uporabnika';
$string['unassignarole'] = 'Odvzem vloge {$a}';
$string['unassignconfirm'] = 'Ali res želite odvzeti vlogo "{$a->role}" od uporabnika "{$a->user}"?';
$string['unassignerror'] = 'Pri odvzemanju vloge {$a->role} uporabniku {$a->user} je prišlo do napake.';
$string['user:changeownpassword'] = 'Spreminjanje lastnega gesla';
$string['user:create'] = 'Ustvarjanje uporabnikov';
$string['user:delete'] = 'Brisanje uporabnikov';
$string['user:editmessageprofile'] = 'Urejanje uporabnikovega sporočilnega profila';
$string['user:editownmessageprofile'] = 'Urejanje lastnega uporabniškega sporočilnega profila';
$string['user:editownprofile'] = 'Urejanje lastnega uporabniškega profila';
$string['user:editprofile'] = 'Urejanje uporabniškega profila';
$string['user:ignoreuserquota'] = 'Prezri omejitev uporabniške kvote';
$string['user:loginas'] = 'Prijava kot drugi uporabnik';
$string['user:manageblocks'] = 'Uredi bloke na uporabniškem profilu ostalih uporabnikov';
$string['user:manageownblocks'] = 'Uredi bloke na uporabniškem profilu ostalih uporabnikov';
$string['user:manageownfiles'] = 'Urejaj datoteke na vaših privatnih datotečnih področjih';
$string['user:managesyspages'] = 'Nastavite privzeto razporeditev strani za javne uporabniške profile';
$string['user:readuserblogs'] = 'Ogled vseh blogov uporabnikov';
$string['user:readuserposts'] = 'Ogled vseh objav uporabnikov';
$string['user:update'] = 'Posodobitev uporabniških profilov';
$string['user:viewalldetails'] = 'Ogled vseh uporabnikovih podatkov';
$string['user:viewdetails'] = 'Ogled uporabniških profilov';
$string['user:viewhiddendetails'] = 'Ogled skritih podrobnosti uporabnikov';
$string['user:viewlastip'] = 'Ogled zadnjega IP naslova uporabnika';
$string['user:viewuseractivitiesreport'] = 'Ogled poročil o dejavnosti uporabnikov';
$string['user:viewusergrades'] = 'Ogled ocen uporabnikov';
$string['usersfrom'] = 'Uporabniki iz {$a}';
$string['usersfrommatching'] = 'Uporabniki iz {$a->contextname}, ki se ujemajo \'{$a->search}';
$string['usersinthisx'] = 'Uporabniki v tem {$a}';
$string['usersinthisxmatching'] = 'Uporabniki v tem {$a->contexttype}, ki se ujemajo \'{$a->search}';
$string['userswithrole'] = 'Vsi uporabniki z vlogo';
$string['userswiththisrole'] = 'Uporabniki z vlogo';
$string['useshowadvancedtochange'] = 'Uporabi \'Prikaži napredno\' za spremembo';
$string['viewingdefinitionofrolex'] = 'Ogled definicije vloge \'{$a}';
$string['viewrole'] = 'Ogled podrobnosti vloge';
$string['webservice:createmobiletoken'] = 'Ustvari žeton spletne storitve za mobilni dostop';
$string['webservice:createtoken'] = 'Ustvari žeton spletne storitve';
$string['webservice:managealltokens'] = 'Upravljaj žetone spletne storitve vseh uporabnikov';
$string['whydoesuserhavecap'] = 'Zakaj ima {$a->fullname} zmožnost {$a->capability} v kontekstu {$a->context}?';
$string['whydoesusernothavecap'] = 'Zakaj nima {$a->fullname} zmožnosti {$a->capability} v kontekstu {$a->context}?';
$string['xroleassignments'] = 'Določene vloge za {$a}';
$string['xuserswiththerole'] = 'Uporabniki z vlogo "{$a->role}"';
