<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'sv', version '4.3'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptterms'] = 'Jag accepterar <a href=":url" target="_blank">användningsvillkoren</a>';
$string['accountdetailslinktext'] = 'här';
$string['action'] = 'Åtgärd';
$string['add'] = 'Lägg till';
$string['addedandupdatedpp'] = 'Lade till {$a->%new} nya H5P-bibliotek och uppdaterade {$a->%old} befintliga.';
$string['addedandupdatedps'] = 'Lade till {$a->%new} nya H5P-bibliotek och uppdaterade {$a->%old} befintligt.';
$string['addedandupdatedsp'] = 'Lade till {$a->%new} nytt H5P-bibliotek och uppdaterade {$a->%old} befintliga.';
$string['addedandupdatedss'] = 'Lade till {$a->%new} nytt H5P-bibliotek och uppdaterade {$a->%old} befintligt.';
$string['addednewlibraries'] = 'Lade till {$a->%new} nya H5P-bibliotek.';
$string['addednewlibrary'] = 'Lade till {$a->%new} nytt H5P-bibliotek.';
$string['additionalinfo'] = 'Ytterligare information';
$string['additionallicenseinfo'] = 'Ytterligare information om licensen';
$string['addlibraries'] = 'Lägg till bibliotek';
$string['address'] = 'Adress';
$string['age'] = 'Ålder';
$string['agedescription'] = 'Målgruppen för detta innehåll. Möjliga format, separerade med kommatecken: "1,34-45,-50,59-".';
$string['ajaxfailed'] = 'Misslyckades med att ladda data.';
$string['alttext'] = 'Alternativ text';
$string['anunexpectedsave'] = 'Något oväntat inträffade. Vi kan inte spara innehållet.';
$string['assistivetechnologieslabel'] = 'Hjälpmedelsettikett';
$string['attribution'] = 'Attribution 4.0';
$string['attributionnc'] = 'Attribution-NonCommercial 4.0';
$string['attributionncnd'] = 'Attribution-NonCommercial-NoDerivs 4.0';
$string['attributionncsa'] = 'Attribution-NonCommercial-ShareAlike 4.0';
$string['attributionnd'] = 'Attribution-NoDerivs 4.0';
$string['attributionsa'] = 'Attribution-ShareAlike 4.0';
$string['author'] = 'Författare';
$string['authorcomments'] = 'Författarkommentarer';
$string['authorcommentsdescription'] = 'Kommentarer för redaktören för innehållet (Denna text kommer inte att publiceras som en del av upphovsrättsinformationen)';
$string['authorname'] = 'Författare';
$string['authorrole'] = 'Roll';
$string['back'] = 'Bakåt';
$string['by'] = 'av';
$string['cancel'] = 'Avbryt';
$string['cancellabel'] = 'Ångra';
$string['cancelpublishconfirmationdialogcancelbuttontext'] = 'Nej';
$string['cancelpublishconfirmationdialogconfirmbuttontext'] = 'Ja';
$string['cancelpublishconfirmationdialogdescription'] = 'Är du säker på att du vill avbryta delningen?';
$string['cancelpublishconfirmationdialogtitle'] = 'Avbryt delning';
$string['ccattribution'] = 'Erkännande (CC BY)';
$string['ccattributionnc'] = 'Erkännande-IckeKommersiell (CC BY-NC)';
$string['ccattributionncnd'] = 'Erkännande-Ickekommersiell-IngaBearbetningar (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Erkännande-IckeKommersiell-DelaLika (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Erkännande-IngaBearbetningar (CC BY-ND)';
$string['ccattributionsa'] = 'Erkännande-DelaLika (CC BY-SA)';
$string['ccpdd'] = 'Public domain-dedikation (CC0)';
$string['ccpdm'] = 'Public Domain Mark (PDM)';
$string['changedby'] = 'Ändrad av';
$string['changedescription'] = 'Beskrivning av ändringen';
$string['changehasbeensubmitted'] = 'En ändring har lämnats in för';
$string['changelog'] = 'Ändringslogg';
$string['changeplaceholder'] = 'Bild beskuren, ändrad text etc.';
$string['city'] = 'Stad';
$string['close'] = 'Stäng';
$string['completionpass'] = 'Kräv godkännandebetyg';
$string['completionpass_help'] = 'Om aktiverad anses den här aktiviteten vara slutförd när deltagaren får ett godkänt resultat (enligt vad som anges i avsnittet Betyg i H5P-aktivitetsinställningarna) eller högre.';
$string['completionpassdesc'] = 'Studenten måste få ett godkänt betyg för att slutföra denna aktivitet';
$string['confirmdialogbody'] = 'Bekräfta att du vill fortsätta. Denna åtgärd kan inte ångras.';
$string['confirmdialogheader'] = 'Bekräfta åtgärd';
$string['confirmlabel'] = 'Bekräfta';
$string['connectionlost'] = 'Anslutningen förlorades. Resultaten kommer att lagras och skickas när anslutningen återupprättas.';
$string['connectionreestablished'] = 'Anslutning återupprättad';
$string['contactperson'] = 'Kontaktperson';
$string['contactpersondescription'] = 'H5P kommer att kontakta kontaktpersonen om det uppstår problem med innehållet som delas av utgivaren. Kontaktpersonens namn eller annan information kommer inte att publiceras eller delas med tredje part';
$string['contentavailable'] = 'Ditt innehåll kommer normalt att vara tillgängligt i hubben inom en arbetsdag.';
$string['contentchanged'] = 'Detta innehåll har förändrats sen du sist använde det.';
$string['contentcopied'] = 'Innehåll kopierat till urklipp';
$string['contenthub:changesettings'] = 'Ändra kontoinställningarna <a href="{$a}">här</a>';
$string['contenthub:licenseagreementdescription'] = 'Vänligen läs igenom följande licensavtal innan du fortsätter med';
$string['contenthub:licenseagreementmaintext'] = 'ATT GÖRA';
$string['contenthub:licenseagreementtitle'] = 'Slutanvändaravtal (EULA)';
$string['contenthub:nopermissions'] = 'Du har inte behörighet att registrera webbplatsen med innehållshubben.';
$string['contenthub:register'] = 'Registrera ett konto på H5P-Hubben <a href="{$a}">här</a>';
$string['contenthub:settings:box'] = 'Hubbkonto';
$string['contenthub:settings:heading'] = 'Kontoinställningar';
$string['contenthubeditsharing'] = 'Redigera delningsinformation';
$string['contenthuboptions'] = 'H5P OER alternativ';
$string['contenthubshare'] = 'Dela på H5P Hub';
$string['contenthubsharinginprogress'] = 'Delar...';
$string['contenthubsyncchanges'] = 'Synkronisera ändringar';
$string['contenthubunshare'] = 'Sluta dela';
$string['contentissyncing'] = 'Innehållet synkroniseras.';
$string['contentlicensetitle'] = 'Licensiformation';
$string['contentnotshared'] = 'Innehållet är inte delat på hubben.';
$string['contentstatefrequency'] = 'Frekvens för att spara tillstånd för innehåll';
$string['contentstatefrequency_help'] = 'Hur ofta vill du att användarens framsteg sparas automatiskt? Anges i sekunder. Öka värdet om du får problem vid många AJAX-förfrågningar';
$string['contenttype'] = 'Innehållstyp';
$string['contenttypecacheheader'] = 'Cacheminne för innehållstyper';
$string['contentupdatesoon'] = 'Ditt innehåll uppdateras snart';
$string['copyright'] = 'Användarrättigheter';
$string['copyrightinfo'] = 'Copyright-information';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'Visa copyright-information för detta innehåll.';
$string['copyrightwarning'] = 'Upphovsrättsskyddat material kan inte delas i H5P Content Hub. Om innehållet är licensierat med en OER-vänlig licens som Creative Commons, välj lämplig licens. Om inte det här innehållet inte kan delas.';
$string['couldnotcopy'] = 'Kunde inte kopiera fil.';
$string['couldnotparsejsonfromzip'] = 'Kan inte bearbeta JSON i paket: %fileName';
$string['couldnotparsepostdata'] = 'Kunde inte bearbetad post-data.';
$string['couldnotreadfilefromzip'] = 'Kan inte läsa fil från paket: %fileName';
$string['couldnotsave'] = 'Kunde inte spara fil.';
$string['country'] = 'Land';
$string['create'] = 'Skapa';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Uppdatera cache';
$string['ctcacheconnectionfailed'] = 'Kunde inte kommunicera med H5P-hubben. Försök igen senare.';
$string['ctcachedescription'] = 'Om du ser till att cacheminnet för innehållstypen är uppdaterat kan du vara säker på att du kan visa, hämta och använda de senaste biblioteken. Detta skiljer sig från att uppdatera biblioteken i sig.';
$string['ctcachelastupdatelabel'] = 'Senast uppdaterat';
$string['ctcacheneverupdated'] = 'Aldrig';
$string['ctcachenolibraries'] = 'Inga innehållstyper mottagna från H5P-hubben. Försök igen senare.';
$string['ctcachesuccess'] = 'Bibliotekscacheminnet uppdaterades!';
$string['ctcachetaskname'] = 'Uppdatera cacheminnet för innehållstyper';
$string['currentpage'] = 'Sida $current av $total';
$string['currentstep'] = 'Steg :step av :total';
$string['dataviewreportlabel'] = 'Visa svar';
$string['date'] = 'Datum';
$string['description'] = 'Beskrivning';
$string['disablefileextensioncheck'] = 'Inaktivera kontroll av filändelse';
$string['disablefileextensioncheckwarning'] = 'Varning! Att inaktivera kontrollen av filändelserna kan få konsekvenser för säkerheten eftersom det möjliggör uppladdning av PHP-filer. Det i sin tur skulle kunna göra det möjligt för angripare att köra skadlig kod på din webbplats. Vänligen se till att du vet exakt vad du laddar upp.';
$string['disablefullscreen'] = 'Inaktivera helskärm';
$string['disablehubconfirmationmsg'] = 'Vill du fortfarande aktivera hubben?';
$string['disablehubdescription'] = 'Det uppmuntras starkt att hålla det här alternativet aktiverat. <em>H5P Hub</em> är ett enkelt gränssnitt för att få nya innehållstyper och hålla befintliga innehållstyper uppdaterade. I framtiden kommer det också att göra det lättare att dela och återanvända innehåll. Om det här alternativet är inaktiverat måste du installera och uppdatera innehållstyper via filuppladdningsdialogen.';
$string['disciplinedescription'] = 'Du kan välja flera discipliner';
$string['disciplinelabel'] = 'Discipliner';
$string['disciplinelimitreachedmessage'] = 'Dunkande välja max :numDisciplines discipliner';
$string['disciplines'] = 'Discipliner';
$string['displayoptionalwaysshow'] = 'Visa alltid';
$string['displayoptionauthoroff'] = 'Kontrolleras av författaren, standard är av';
$string['displayoptionauthoron'] = 'Kontrolleras av författaren, standard är på';
$string['displayoptiondownloadalways'] = 'Alltid';
$string['displayoptiondownloadnever'] = 'Aldrig';
$string['displayoptiondownloadpermission'] = 'Endast om användaren har behörighet att exportera H5P.';
$string['displayoptionnevershow'] = 'Visa aldrig';
$string['displayoptionpermissions'] = 'Visa endast om användaren har rättighet att exportera H5P';
$string['displayoptionpermissionsembed'] = 'Visa endast om användaren har rättighet att bädda in H5P';
$string['displayoptions'] = 'Visningsalternativ';
$string['download'] = 'Ladda ned';
$string['downloadfailed'] = 'Nedladdning av biblioteket misslyckades.';
$string['downloadtitle'] = 'Ladda ned detta innehåll som en H5P-fil.';
$string['dropdownbutton'] = 'Menyknapp';
$string['editinfotitle'] = 'Redigera <strong>:title</strong>';
$string['editingfailed'] = 'Redigeringen misslyckades.';
$string['editor'] = 'Redigerare';
$string['emailaddress'] = 'E-postadress';
$string['emailaddressdescription'] = 'E-postadressen kommer att användas av H5P för att nå ut till utgivaren vid eventuella problem med innehållet eller om utgivaren behöver återställa sitt konto. Det kommer inte att publiceras eller delas med någon tredje part';
$string['emailconfirmbody'] = 'Hej {$a->username},

Tack för att du skickat in svaren för \'{$a->hvpname}\' i kursen \'{$a->coursename}\'.

Detta är en bekräftelse på att dina svar registrerats.

Du kan nå dessa här: {$a->hvpurl}.';
$string['emailconfirmsmall'] = 'Tack för att du skickat in dina svar för \'{$a->hvpname}\'';
$string['emailconfirmsubject'] = 'Bekräftelse på inskickade svar för: {$a->hvpname}';
$string['emailnotifybody'] = 'Hej {$a->username},

{$a->studentname} har slutfört \'{$a->hvpname}\' ({$a->hvpurl}) i kursen \'{$a->coursename}\'.

Du kan se svaren här: {$a->hvpreporturl}.';
$string['emailnotifysmall'] = '{$a->studentname} har slutfört {$a->hvpname}. Se{$a->hvpreporturl}';
$string['emailnotifysubject'] = '{$a->studentname} har slutfört {$a->hvpname}';
$string['embed'] = 'Bädda in';
$string['embedloginfailed'] = 'Du har inte rätt att nå detta innehåll. Pröva med att logga in.';
$string['embedtitle'] = 'Visa inbäddningskod för detta innehåll.';
$string['empty'] = 'Inga resultat tillgängliga';
$string['enableabout'] = 'Knapp för "Om H5P"';
$string['enablecopyright'] = 'Knapp för upphovsrättsinformation';
$string['enabledlrscontenttypes'] = 'Aktivera LRS-beroende innehållstyper';
$string['enabledlrscontenttypes_help'] = 'Gör det möjligt att använda innehållstyper som förlitar sig på att en <em>Learning Record Store</em> fungerar korrekt, till exempel innehållstypen <em>Enkät</em>.';
$string['enabledownload'] = 'Knapp för nedladdning';
$string['enableembed'] = 'Knapp för inbäddning';
$string['enableframe'] = 'Visa åtgärdsfält och ram';
$string['enablehublabel'] = 'Använd H5P-hubben';
$string['enablejavascript'] = 'Aktivera JavaScript.';
$string['enablesavecontentstate'] = 'Spara tillstånd för innehåll';
$string['enablesavecontentstate_help'] = 'Sparar automatiskt aktuellt tillstånd för interaktivt innehåll för varje användare. Detta innebär att användaren kan fortsätta där denne slutade.';
$string['failedtodownloadh5p'] = 'Misslyckades med att ladda ned begärd H5P.';
$string['fileexceedsmaxsize'] = 'En av filerna i paketet överskrider den maximalt tillåtna filstorleken. (%file %used > %max)';
$string['filenotfoundonserver'] = 'Fil hittades inte på servern. Kontrollera inställningarna för filuppladdning.';
$string['filenotimage'] = 'Filen är inte en bild.';
$string['filetypenotallowed'] = 'Filtypen är inte tillåten.';
$string['finished'] = 'Avslutad';
$string['fullscreen'] = 'Helskärm';
$string['gpl'] = 'General Public License v3';
$string['gradeheading'] = 'Resultat för {$a}';
$string['gradetopassmustbeset'] = 'Betygsgräns för godkänt kan inte vara noll eftersom denna H5P-aktivitet har sin slutförandemetod inställd på att kräva godkänt betyg. Vänligen ställ in ett värde som inte är noll.';
$string['gradetopassnotset'] = 'Denna H5P-aktivitet har ännu inte ett betyg för att bli godkänd inställt. Det kan vara ställas in i avsnittet <em>Betyg</em> i H5P-aktivitetsinställningarna.';
$string['h5pfile'] = 'H5P-fil';
$string['h5ptitle'] = 'Besök H5P.org för se mer inspirerande innehåll.';
$string['helpchoosinglicense'] = 'Hjälp mig välja en licens';
$string['hide'] = 'Dölj';
$string['hideadvanced'] = 'Dölj avancerat';
$string['hubcommunicationdisabled'] = 'H5P-hubbkommunikation har inaktiverats eftersom ett eller flera H5P-krav misslyckades.';
$string['hubisdisabled'] = 'Hubben är inaktiverad. Du kan återaktivera den i H5P-inställningarna.';
$string['hubisdisableduploadlibraries'] = 'H5P-hubben har inaktiverats tills detta problem har lösts. Du kan fortfarande ladda upp bibliotek via sidan "H5P-bibliotek".';
$string['hubsettingsheader'] = 'Innehållstyper';
$string['hvp:addinstance'] = 'Skapa nya H5P-aktiviteter';
$string['hvp:contenthubregistration'] = 'Registrera webbplatsen med  H5P-hubben';
$string['hvp:emailconfirmsubmission'] = 'Få ett bekräftelsemail då svar skickas in.';
$string['hvp:emailnotifysubmission'] = 'Få en notis då ett svar skickas in.';
$string['hvp:getcachedassets'] = 'Krävs för att se H5P-aktiviteter';
$string['hvp:getembedcode'] = 'Visa H5P-inbäddningskod när inställningen "kontrollerat av rättighet" är vald';
$string['hvp:getexport'] = 'Ladda ned .h5p-fil när inställningen "kontrollerat av rättighet" är vald';
$string['hvp:installrecommendedh5plibraries'] = 'Installera nya säkra H5P-innehållstyper rekommenderade av H5P.org';
$string['hvp:manage'] = 'Redigera befintliga H5P-aktiviteter';
$string['hvp:restrictlibraries'] = 'Begränsa tillgång till vissa H5P-innehållstyper';
$string['hvp:savecontentuserdata'] = 'Spara användarens framsteg för H5P-aktiviteter';
$string['hvp:saveresults'] = 'Spara resultaten från slutförda H5P-aktiviteter';
$string['hvp:share'] = 'Dela innehåll på H5P-hubben';
$string['hvp:updatelibraries'] = 'Installera nya H5P-innehållstyper eller uppdatera befintliga';
$string['hvp:userestrictedlibraries'] = 'Använd begränsade H5P-innehållstyper';
$string['hvp:view'] = 'Se och interagera med H5P-aktiviteter';
$string['hvp:viewallresults'] = 'Visa alla resultat för slutförda H5P-aktiviteter';
$string['hvp:viewresults'] = 'Visa egna resultat för genomförda H5P-aktiviteter';
$string['icon'] = 'Ikon';
$string['icondescription'] = '640x480px. Om inte valt använder innehåll kategoriikonen';
$string['in'] = 'i';
$string['installdenied'] = 'Du har inte rättigheter för att installera innehållstyper. Kontakta webbplatsadministratören.';
$string['installedlibraries'] = 'Installerade bibliotek';
$string['intro'] = 'Introduktion';
$string['invalidage'] = 'Ogiltigt inmatningsformat för <em>Typisk ålder</em>. Möjliga inmatningsformat åtskilda av kommatecken: "1, 34-45, -50, -59-".';
$string['invalidaudioformat'] = 'Ogiltigt ljudfilsformat. Använd mp3 eller wav.';
$string['invalidcontentfolder'] = 'Ogiltig innehållsmapp';
$string['invalidcontenttype'] = 'Den valda innehållstypen är inte giltig.';
$string['invalidfieldtype'] = 'Ogiltig fälttyp.';
$string['invalidfile'] = 'Fil "{$a->%filename}" inte tillåten. Endast filter med följande ändelser är tillåtna: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'Kunde inte nå postad H5P.';
$string['invalidimageformat'] = 'Ogiltigt filformat för bild. Använd jpg, png eller gif.';
$string['invalidlanguagefile'] = 'Ogiltig språkfil {$a->%file} i bibliotek {$a->%library}';
$string['invalidlanguagefile2'] = 'Ogiltig språkfil {$a->%languageFile} har inkluderats i biblioteket {$a->%name}';
$string['invalidlibrary'] = 'Ogiltigt bibliotek';
$string['invalidlibrarydata'] = 'Ogiltig data tillhandahälls för {$a->%property} i {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Ogiltig data tillhandahölls för {$a->%property} i {$a->%library}. Ett boolskt uttryck förväntades.';
$string['invalidlibraryname'] = 'Ogiltigt biblioteksnamn: {$a->%name}';
$string['invalidlibrarynamed'] = 'H5P-biblioteket \'{$a->%library}\' som användes i innehållet är ogiltigt.';
$string['invalidlibraryoption'] = 'Ogiltigt alternativ {$a->%option} i {$a->%library}';
$string['invalidlibraryproperty'] = 'Kan inte läsa egenskapen {$a->%property} i {$a->%library}';
$string['invalidmainjson'] = 'En giltigt huvudsaklig h5p.json-fil saknas.';
$string['invalidmultiselectoption'] = 'Ogiltigt angivet val i flerval.';
$string['invalidparameters'] = 'Ogiltiga parametrar.';
$string['invalidselectoption'] = 'Ogiltigt val angivet.';
$string['invalidsemanticsjson'] = 'En ogiltig semantics.json har inkluderats i biblioteket {$a->%name}';
$string['invalidsemanticstype'] = 'Internt H5P-fel: okänd innehållstyp "{$a->@type}" i semantik. Ta bort innehåll!';
$string['invalidstring'] = 'Den angivna strängen är inte giltig enligt regexp i semantik. (värde: \\"{$a->%value}\\", regexp: \\"{$a->%regexp}\\")';
$string['invalidtoken'] = 'Ogiltigt säkerhets-token.';
$string['invalidvideoformat'] = 'Ogiltigt format på videofil. Använd mp4 eller webm.';
$string['invalidxapiresult'] = 'Inga xAPI-resultat hittades för kombinationen av innehåll och användar-ID.';
$string['isnowsubmitted'] = 'Är nu inskickad till H5P-hubben';
$string['javascriptloading'] = 'Väntar på JavaScript...';
$string['keywordexists'] = 'Nyckelordet finns redan!';
$string['keywords'] = 'Nyckelord';
$string['keywordsdescription'] = 'Du kan lägga till flera nyckelord avgränsade med kommatecken. Tryck på "Retur" eller "Lägg till" för att bekräfta nyckelord';
$string['keywordsexists'] = 'Nyckelorden finns redan!';
$string['keywordsplaceholder'] = 'Lägg till nyckelord';
$string['language'] = 'Språk';
$string['level'] = 'Nivå';
$string['libraries'] = 'H5P-bibliotek';
$string['librarydirectoryerror'] = 'Namnet på bibliotekets katalog måste matcha machineName eller machineName-majorVersion.minorVersion (från library.json). (Directory: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Åtgärder';
$string['librarylistinstancedependencies'] = 'Instansberoenden';
$string['librarylistinstances'] = 'Instanser';
$string['librarylistlibrarydependencies'] = 'Biblioteksberoenden';
$string['librarylistrestricted'] = 'Begränsat';
$string['librarylisttitle'] = 'Titel';
$string['librarynotselected'] = 'Du måste välja en innehållstyp';
$string['license'] = 'Licens';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Public Domain Dedication';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Generic';
$string['licenseCC20'] = '2.0 Generic';
$string['licenseCC25'] = '2.5 Generic';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 International';
$string['licenseGPL'] = 'General Public License';
$string['licenseV1'] = 'Version 1';
$string['licenseV2'] = 'Version 2';
$string['licenseV3'] = 'Version 3';
$string['licensedescription'] = 'Välj en licens för innehållet';
$string['licensedetails'] = 'Licensdetaljer';
$string['licensedialogdescription'] = 'Klicka på en licens för att få information om korrekt användning';
$string['licensee'] = 'Licensierad';
$string['licenseextras'] = 'Extra licensinformation';
$string['licenseversion'] = 'Licensversion';
$string['licenseversiondescription'] = 'Välj licensversion';
$string['loadingdata'] = 'Laddar data';
$string['logouploadtext'] = 'Organisationens logotyp eller avatar';
$string['longdescription'] = 'Lång beskrivning';
$string['longdescriptionplaceholder'] = 'Lång beskrivning av innehållet';
$string['lookforupdates'] = 'Sök efter H5P-uppdateringar';
$string['maintitle'] = 'Delar <strong>:title</strong>';
$string['maximumgrade'] = 'Maxbetyg';
$string['maximumgradeerror'] = 'Ange ett giltigt positivt heltal som max poäng för denna aktivitet.';
$string['maxlength'] = 'Det maximala antalet tecken är :length';
$string['maxpostsizetoosmall'] = 'Din max-storlek för PHP-poster är ganska liten. Med nuvarande inställningar, så kan du inte ladda upp filer större än {$a->%number} MB. Detta kan bli ett problem när H5P:er, bilder eller video ska laddas upp. Överväg att öka max-storleken till mer än 5 MB.';
$string['maxscore'] = 'Max poäng';
$string['maxuploadsizetoosmall'] = 'Din max-storlek för PHP-uppladdningar är ganska liten. Med nuvarande inställningar, så kan du inte ladda upp filer större än {$a->%number} MB. Detta kan bli ett problem när H5P:er, bilder eller video ska laddas upp. Överväg att öka max-storleken till mer än 5 MB.';
$string['messageprovider:confirmation'] = 'Bekräftelse på dina egna H5P-inlämningar';
$string['messageprovider:submission'] = 'Notiser om H5P-inlämningar';
$string['missingcontentfolder'] = 'En giltig innehållsmapp saknas.';
$string['missingcontentuserdata'] = 'Fel: Kunde inte hitta användardata för innehåll';
$string['missingcoreversion'] = 'Det gick inte att installera komponenten {$a->%component} från paketet. Den kräver en nyare version av H5P-pluginmodulen. Den här webbplatsen använder för närvarande versionen {$a->%current}, medan den nödvändiga versionen är {$a->%required} eller högre. Du bör överväga att uppgradera och sedan försöka igen.';
$string['missingdependency'] = 'Beroende saknas {$a->@dep} som krävs av {$a->@lib}.';
$string['missinglibrary'] = 'Saknar krävt bibliotek  {$a->@library}';
$string['missinglibraryfile'] = 'Filen "{$a->%file}" saknas från bibliotek: "{$a->%name}"';
$string['missinglibraryjson'] = 'Det gick inte att hitta filen library.json med giltigt json-format för biblioteket {$a->%name}';
$string['missinglibraryproperty'] = 'Den nödvändiga egenskapen {$a->%property} saknas i {$a->%library}';
$string['missingmbstring'] = 'PHP-tillägget mbstring lästes inte in. H5P behöver detta för att fungera korrekt';
$string['missingparameters'] = 'Saknar parametrar';
$string['missinguploadpermissions'] = 'Notera att biblioteken kan finnas i filen som du laddade upp, men att du inte har tillåtelse att ladda upp nya bibliotek. Kontakta webbplatsadministratören angående detta.';
$string['modulename'] = 'Interaktivt innehåll';
$string['modulename_help'] = 'Aktiviteten H5P gör det möjligt att enkelt skapa olika former av interaktivt innehåll. Detta kan vara i form av interaktiv video, en mängd olika frågetyper och tester, interaktiva presentationer och mycket mer.

H5P gör det även möjligt att importera och exportera H5P-filer, vilket innebär att du effektivt kan dela och återanvända ditt innehåll, även till och från andra webbplatser som stödjer H5P.

Användares genomföranden och poäng spåras via xAPI och finns tillgängliga i betygsboken.

Du kan lägga till H5P-innehåll genom att använda det inbyggda författarverktyget, eller genom att ladda upp H5P-filer från andra webbplatser som stödjer H5P.';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'Interaktivt innehåll';
$string['next'] = 'Nästa';
$string['nextpage'] = 'Nästa sida';
$string['noanswersubmitted'] = 'Denna användare har ännu inte svarat på denna H5P';
$string['nocontent'] = 'Kunde inte hitta eller göra "parse" på content.json-filen';
$string['nocontenttype'] = 'Ingen innehållstyp angavs.';
$string['nocopyright'] = 'Ingen copyright-information tillgänglig för detta innehåll.';
$string['nodata'] = 'Det finns ingen data tillgänglig som matchar dina kriterier.';
$string['noexport'] = 'Saknad exportfil.';
$string['noextension'] = 'Filen du har laddat upp är inte ett giltigt HTML5 Paket (den har inte filändelsen .h5p)';
$string['noh5ps'] = 'Det finns inget interaktivt innehåll tillgängligt för denna kurs.';
$string['nojson'] = 'Den huvudsakliga h5p.json-filen är inte giltig';
$string['nombstringexteension'] = 'PHP-tillägget <code>mbstring</code> är inte laddat. H5P behöver detta för att fungera.';
$string['noparameters'] = 'Inga parametrar';
$string['noparse'] = 'Kunde inte göra "parse" på huvudsakliga h5p.json-filen';
$string['nopermissiontogettranslations'] = 'Du saknar behörighet att hämta översättningar';
$string['nopermissiontorestrict'] = 'Du har inte rättighet att begränsa bibliotek.';
$string['nopermissiontosavecontentuserdata'] = 'Du har inte rättighet att spara användardata för innehåll.';
$string['nopermissiontosaveresult'] = 'Du har inte rättighet att spara resultat för detta innehåll.';
$string['nopermissiontoupgrade'] = 'Du har inte rättighet att uppgradera bibliotek.';
$string['nopermissiontouploadcontent'] = 'Du har inte rättighet att ladda upp innehåll här.';
$string['nopermissiontouploadfiles'] = 'Du har inte rättighet att ladda upp filer här.';
$string['nopermissiontoviewcontenthubcache'] = 'Du har inte behörighet att visa metadata för innehållshubben.';
$string['nopermissiontoviewcontenttypes'] = 'Du har inte rättighet att visa innehållstyperna.';
$string['nopermissiontoviewresult'] = 'Du har inte rättighet att visa resultat för detta innehåll.';
$string['nosuchlibrary'] = 'Inget sådant bibliotek.';
$string['notapplicable'] = 'N/A';
$string['nounzip'] = 'Filen du laddade upp är inte ett giltigt HTML5 Paket (vi kan inte unzippa det)';
$string['noversionattribution'] = 'Attribution';
$string['noversionattributionnc'] = 'Attribution-NonCommercial';
$string['noversionattributionncnd'] = 'Attribution-NonCommercial-NoDerivs';
$string['noversionattributionncsa'] = 'Attribution-NonCommercial-ShareAlike';
$string['noversionattributionnd'] = 'Attribution-NoDerivs';
$string['noversionattributionsa'] = 'Attribution-ShareAlike';
$string['nowriteaccess'] = 'Ett problem med serverns skrivrättigheter identifierades. Kontrollera att din server kan skriva till din data-katalog.';
$string['noziparchive'] = 'Din PHP-version stödjer inte ZipArchive.';
$string['offlinedialogbody'] = 'Vi kunde inte skicka information om ditt slutförande av denna uppgift. Vänligen kontrollera din internetanslutning.';
$string['offlinedialogheader'] = 'Anslutningen till servern förlorades';
$string['offlinedialogretrybuttonlabel'] = 'Försök nu';
$string['offlinedialogretrymessage'] = 'Försöker om :num...';
$string['offlinesuccessfulsubmit'] = 'Resultaten skickades in.';
$string['oldphpversion'] = 'Din PHP-version är utdaterad. H5P kräver version 5.2 för att fungera korrekt. Version 5.6 eller senare rekommenderas.';
$string['olduploadoldcontent'] = 'Du försöker ladda upp innehåll från en äldre version av H5P. Uppgradera innehållet på servern som det härstammar från och försök att ladda upp igen eller aktivera H5P Hubben för att få den här servern att uppgradera det åt dig automatiskt.';
$string['onlyupdate'] = 'Uppdatera endast befintliga bibliotek';
$string['optionalinfo'] = 'Valfri information';
$string['options'] = 'Alternativ';
$string['originator'] = 'Upphovsman';
$string['pd'] = 'Public Domain';
$string['pddl'] = 'Public Domain Dedication and Licence';
$string['pdm'] = 'Public Domain Mark';
$string['phone'] = 'Telefon';
$string['pleasewait'] = 'Vänta...';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'Ett <code>POST</code>-meddelande krävs för åtkomst till ändpunkten';
$string['previouspage'] = 'Föregående sida';
$string['privacy:metadata:core_files'] = 'H5P-aktiviteten lagrar filer som laddats upp som en del av ett H5P-innehåll.';
$string['privacy:metadata:core_grades'] = 'H5P-aktiviteten lagrar betyg för användare som svarat på H5P-innehållet.';
$string['privacy:metadata:hvp_content_user_data'] = 'Beskriver nuvarande tillstånd för användarinnehållet. Används för att återställa innehållet till ett tidigare tillstånd.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'Användardata som lagrades.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Datatypsidentifierare.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Flagga som avgör om data skall raderas när innehåll ändras.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'ID för det H5P-innehåll som datat tillhör.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'ID för innehållsanvändare-data relationen';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Flagga som avgör om data skall förladdas i innehållet.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'Delinnehåll för H5P. 0 = inte delinnehåll.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'ID för användare som datat tillhör.';
$string['privacy:metadata:hvp_events'] = 'Bevakar loggade H5P-händelser.';
$string['privacy:metadata:hvp_events:content_id'] = 'ID för innehåll åtgärden utfördes på. 0 för nytt eller inget innehåll.';
$string['privacy:metadata:hvp_events:content_title'] = 'Innehållsrubrik';
$string['privacy:metadata:hvp_events:created_at'] = 'Tid för händelsen';
$string['privacy:metadata:hvp_events:id'] = 'Unikt händelseid';
$string['privacy:metadata:hvp_events:library_name'] = 'Bibliotek händelsen påverkade.';
$string['privacy:metadata:hvp_events:library_version'] = 'Biblioteksversion händelsen påverkade.';
$string['privacy:metadata:hvp_events:sub_type'] = 'Händelseundertyp eller händelseåtgärd.';
$string['privacy:metadata:hvp_events:type'] = 'Händelsetyp';
$string['privacy:metadata:hvp_events:user_id'] = 'ID:t för den användare som utförde åtgärden.';
$string['privacy:metadata:hvp_xapi_results'] = 'Lagrar xAPI-händelser i H5P-innehåll.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Ytterligare information som H5P kan skicka in.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'ID:t för innehållet som händelsen utfördes på.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'Det korrekta svarsmönstret.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'Beskrivning, uppgift eller fråga för innehållet som åtgärden utfördes på.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'Det unika ID:t för xAPI-händelsen.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'Interaktionstyp';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Högsta uppnåeliga poäng för händelsen.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'ID:t för det överordnade innehållet som händelsen utfördes på. Null om den inte har någon förälder.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Uppnådd poäng för händelsen.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'Svaret som användaren skickade in.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'ID:t för användaren som utförde åtgärden.';
$string['publisherdescription'] = 'Utgivarebeskrivning';
$string['publisherdescriptiontext'] = 'Detta visas under "Information om utgivare" på delat innehåll';
$string['publisherfielddescription'] = 'Detta visas under "Namn" på delat innehåll';
$string['publisherfieldtitle'] = 'Utgivare';
$string['question'] = 'Fråga';
$string['registeronhub'] = 'Registrera på H5P-hubben';
$string['registrationfailed'] = 'Ett fel inträffade';
$string['registrationfaileddescription'] = 'Vi kunde inte skapa ett konto vid denna tidpunkt. Något gick fel. Försök igen senare.';
$string['registrationtitle'] = 'H5P Hub-registrering';
$string['remove'] = 'Ta bort';
$string['removechip'] = 'Ta bort :chip från listan';
$string['removeimage'] = 'Ta bort bild';
$string['removeoldlogentries'] = 'Ta bort gamla H5P-loggposter';
$string['removeoldmobileauthentries'] = 'Ta bort gamla H5P mobilautentiseringsposter';
$string['removetmpfiles'] = 'Ta bort gamla tillfälliga H5P-filer';
$string['reportingquestionsremaininglabel'] = 'frågor kvar att betygsätta';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Poäng i betygsbok:';
$string['reportingscoredelimiter'] = 'av';
$string['reportingscorelabel'] = 'Poäng:';
$string['reportnotsupported'] = 'Stöds inte';
$string['reportsubmitgradelabel'] = 'Spara betyg';
$string['requiredinfo'] = 'Obligatorisk information';
$string['resizescript'] = 'Inkludera detta script på din webbplats om du vill ha dynamisk storlek på inbäddat innehåll:';
$string['resubmitscores'] = 'Försöker skicka lagrade resultat.';
$string['reuse'] = 'Återanvänd';
$string['reusecontent'] = 'Återanvänd innehåll';
$string['reusedescription'] = 'Återanvänd detta innehåll.';
$string['reveal'] = 'Avslöja';
$string['reviewandsave'] = 'Granska & Spara';
$string['reviewandshare'] = 'Granska & Dela';
$string['reviewinfo'] = 'Granska';
$string['reviewmessage'] = 'Vänligen granska informationen nedan innan du delar';
$string['reviseserversetupandretry'] = 'När du har sett över dina serverinställningar så kan du återaktivera H5P-hubbens kommunikation i H5P-inställningarna.';
$string['savechanges'] = 'Spara';
$string['score'] = 'Poäng';
$string['screenshots'] = 'Skärmdumpar';
$string['screenshotsdescription'] = 'Lägg till max fem skärmdumpar av ditt innehåll';
$string['search'] = 'Sök';
$string['searchplaceholder'] = 'Börja skriva för att söka efter discipliner';
$string['sendusagestatistics'] = 'Bidra med statistik om användning';
$string['sendusagestatistics_help'] = 'Statistik om användning kommer rapporteras automatiskt för att hjälpa utvecklarna att bättre förstå hur H5P används och för att hitta potentiella förbättringsområden. Läs mer om vilken <a {$a}>data som samlas in på h5p.org</a>.';
$string['settings'] = 'H5P-inställningar';
$string['share'] = 'Dela';
$string['shared'] = 'Delat';
$string['sharefailed'] = 'Delningen misslyckades.';
$string['sharetryagain'] = 'Något gick fel. Försök dela igen.';
$string['sharingnote'] = 'Alla innehållsdetaljer kan redigeras efter delning';
$string['shortdescription'] = 'Kort beskrivning';
$string['shortdescriptionplaceholder'] = 'Kort beskrivning av innehållet';
$string['showadvanced'] = 'Visa avancerat';
$string['showless'] = 'Visa mindre';
$string['showmore'] = 'Visa mer';
$string['sitecouldnotberegistered'] = 'Webbplatsen kunde inte registreras på hubben. Kontakta din webbplatsadministratör.';
$string['sitekey'] = 'Webbplatsnyckel';
$string['sitekeydescription'] = 'Webbplatsnyckeln är en hemlighet som unikt identifierar denna webbplats på hubben.';
$string['sitekeyregistered'] = 'Du har fått en unik nyckel som identifierar dig på hubben när du får nya uppdateringar. Nyckeln går att se på sidan "H5P-inställningar".';
$string['size'] = 'Storlek';
$string['somekeywordsexists'] = 'Några av dessa nyckelord finns redan';
$string['source'] = 'Källa';
$string['sslnotenabled'] = 'Din server har inte SSL aktiverat. SSL bör vara aktiverat för att säkerställa en säker anslutning till H5P-hubben.';
$string['startingover'] = 'Du kommer att starta om.';
$string['subcontentwarning'] = 'Underinnehåll (bilder, frågor etc.) delas under :license om inget annat anges i redigeringsverktyget';
$string['sublevel'] = 'Undernivå';
$string['submitted'] = 'Inskickat!';
$string['successfullyregisteredwithhub'] = 'Din webbplats registrerades på H5P-hubben.';
$string['successfullyregistred'] = 'Du har registrerat ett konto på H5P Hub';
$string['successfullyregistreddescription'] = 'Dina kontodetaljer kan ändras';
$string['successfullyupdated'] = 'Inställningarna för H5P Hub-kontot har ändrats';
$string['thumbnail'] = 'Miniatyr';
$string['title'] = 'Titel';
$string['unabletocreatedir'] = 'Kunde inte skapa katalog.';
$string['unabletogetfieldtype'] = 'Kunde inte få filtyp.';
$string['undisclosed'] = 'Icke avslöjat';
$string['unpackedfilesexceedsmaxsize'] = 'Den totala storleken hos de uppackade filerna överskrider den högsta tillåtna storleken. (%used > %max)';
$string['updatedlibraries'] = 'Uppdaterade {$a->%old} H5P-bibliotek.';
$string['updatedlibrary'] = 'Uppdaterade {$a->%old} H5P-bibliotek.';
$string['updatelibraries'] = 'Uppdatera alla bibliotek';
$string['updateregistrationonhub'] = 'Spara kontoinställningar';
$string['upgrade'] = 'Uppgradera H5P';
$string['upgradebuttonlabel'] = 'Uppgradera';
$string['upgradedone'] = 'Du har uppgraderat {$a} innehållsinstanser.';
$string['upgradeerror'] = 'Ett fel uppstod vid processning av parametrar:';
$string['upgradeerrorcontent'] = 'Kunde inte uppgradera innehåll %id:';
$string['upgradeerrordata'] = 'Kunde inte ladda data för bibliotek %lib.';
$string['upgradeerrormissinglibrary'] = 'Obligatoriskt bibliotek saknas %lib.';
$string['upgradeerrornotsupported'] = 'Parametrarna innehåller %used som inte stöds.';
$string['upgradeerrorparamsbroken'] = 'Parametrar är trasiga.';
$string['upgradeerrorscript'] = 'Kunde inte ladda upp uppgraderingsscript för %lib.';
$string['upgradeerrortoohighversion'] = 'Parametrarna innehåller %used medan endast %supported eller tidigare stöds.';
$string['upgradeheading'] = 'Uppgradera {$a} innehåll';
$string['upgradeinprogress'] = 'Uppgraderar till  %ver...';
$string['upgradeinvalidtoken'] = 'Fel: Ogiltig säkerhetstoken!';
$string['upgradelibrarycontent'] = 'Uppgraderar biblioteksinnehåll';
$string['upgradelibrarymissing'] = 'Fel: Ditt bibliotek saknas!';
$string['upgrademessage'] = 'Du är på väg att uppgradera {$a} innehållsinstanser. Välj uppgraderingsversion.';
$string['upgradenoavailableupgrades'] = 'Det finns inga tillgängliga uppgraderingar för detta bibliotek.';
$string['upgradenothingtodo'] = 'Det finns inga innehållsinstanser att uppgradera.';
$string['upgradereturn'] = 'Återgå';
$string['upload'] = 'Ladda upp';
$string['uploadlibraries'] = 'Ladda upp bibliotek';
$string['uploadsizelargerthanpostsize'] = 'Din maxstorlek för PHP-uppladdning är större än din maxstorlek för poster. Detta är en känd orsak till problem i vissa installationer.';
$string['user'] = 'Användare';
$string['validatingh5pfailed'] = 'Validering av h5p-paket misslyckades.';
$string['validationfailed'] = 'Begärd H5P var inte giltig';
$string['viewreportlabel'] = 'Rapport';
$string['welcomecommunity'] = 'Vi hoppas att du uppskattar H5P och blir engagerad i vårt växande community genom våra  <a {$a->forums}>forum</a>.';
$string['welcomecontactus'] = 'Om du har någon feedback, tveka inte att <a {$a}>kontakta oss</a>. Vi tar feedback väldigt seriöst och är hängivna i att göra H5P bättre varje dag!';
$string['welcomegettingstarted'] = 'För att komma igång med H5P i ditt LMS, ta en titt på vår <a {$a->moodle_tutorial}>tutorial</a> och kika på <a {$a->example_content}>exempel på innehåll</a> på H5P.org för inspiration.';
$string['welcomeheader'] = 'Välkommen till H5P-världen!';
$string['wrongversion'] = 'Versionen av H5P-biblioteket {$a->%machineName} som används i detta innehåll är inte giltig. Innehållet innehåller {$a->%contentLibrary}, men det bör vara {$a->%semanticsLibrary}.';
$string['year'] = 'År';
$string['years'] = 'År';
$string['yearsfrom'] = 'År (från)';
$string['yearsto'] = 'År (till)';
$string['zip'] = 'Postnr';
