<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'fr', version '4.3'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'TODO';
$string['activityisscheduledfordeletion'] = 'Suppression d’activité en cours…';
$string['agedigitalconsentmapinvalidage'] = '« {$a} » n’est pas une valeur valide pour l’âge.';
$string['agedigitalconsentmapinvalidcomma'] = '« {$a} » comporte plus ou moins d’une virgule comme séparateur.';
$string['agedigitalconsentmapinvalidcountry'] = '« {$a} » n’est pas une valeur valide de code de pays.';
$string['agedigitalconsentmapinvaliddefault'] = 'La valeur par défaut (*) n’est pas mentionnée.';
$string['agelocationverificationdisabled'] = 'Vérification de l’âge et du lieu désactivée';
$string['alreadyloggedin'] = 'Vous êtes déjà authentifié sous le nom {$a}. Veuillez vous déconnecter avant de vous connecter sous un autre nom.';
$string['authnotexisting'] = 'Le plugin d’autorisation n’existe pas';
$string['backupcontainexternal'] = 'Ce fichier de sauvegarde comporte des hôtes externes de MNet qui ne sont pas configurés localement';
$string['backuptablefail'] = 'Les tables de sauvegarde n’ont PAS pu être configurées !';
$string['blockcannotconfig'] = 'Ce bloc ne permet pas de configuration globale';
$string['blockcannotinistantiate'] = 'Problème lors de l’instantiation de l’objet bloc';
$string['blockcannotread'] = 'Impossible de lire les données pour l’identifiant de bloc {$a}';
$string['blockdoesnotexist'] = 'Ce bloc n’existe pas';
$string['blockdoesnotexistonpage'] = 'Ce bloc (id = {$a->instanceid}) n’existe pas sur cette page ({$a->url}).';
$string['blocknameconflict'] = 'Conflit de nom : le bloc {$a->name} a le même titre qu’un bloc existant : {$a->conflict}!';
$string['callbackrejectcomment'] = 'Le module a rejeté l’ajout de ce commentaire';
$string['cannotaddcoursemodule'] = 'Impossible d’ajouter un module de cours';
$string['cannotaddcoursemoduletosection'] = 'Impossible d’ajouter un module de cours à cette section';
$string['cannotaddmodule'] = 'Le module {$a} n’a pas pu être ajouté à la liste des modules !';
$string['cannotaddnewmodule'] = 'Impossible d’ajouter un nouveau module {$a}';
$string['cannotaddrss'] = 'Vous n’avez pas les des permissions requises pour ajouter des flux RSS';
$string['cannotaddthisblocktype'] = 'Vous ne pouvez pas ajouter un bloc {$a} à cette page.';
$string['cannotassignrole'] = 'Attribution du rôle dans le cours impossible';
$string['cannotassignrolehere'] = 'Il n’est pas possible d’attribuer ce rôle (id = {$a->roleid}) dans ce contexte ({$a->context})';
$string['cannotassignselfasparent'] = 'Impossible de se désigner soi-même comme parent !';
$string['cannotcallscript'] = 'Ce script ne peut pas être appelé ainsi';
$string['cannotcallusgetselecteduser'] = 'Vous ne pouvez pas appeler user_selector::get_selected_user si multiselect est vrai.';
$string['cannotcreatebackupdir'] = 'Impossible de créer le dossier backupdata. Veuillez demander à l’administrateur du site de corriger les droits d’accès aux fichiers';
$string['cannotcreatecategory'] = 'Erreur lors de la création de la catégorie';
$string['cannotcreatedboninstall'] = '<p>Impossible de créer la base de données.</p>
<p>La base de données indiquées n’existe pas et l’utilisateur spécifié n’a pas les permissions requises pour créer une base de données.</p>.
<p>L’administrateur du site doit revoir la configuration de la base de données.</p>';
$string['cannotcreategroup'] = 'Erreur lors de la création du groupe';
$string['cannotcreatelangbase'] = 'Erreur : création du dossier de base des langues impossible';
$string['cannotcreatelangdir'] = 'Création du dossier lang impossible';
$string['cannotcreateorfindstructs'] = 'Erreur pour trouver ou créer la structure des sections de ce cours';
$string['cannotcreatepopupwin'] = 'Élément non défini, impossible de créer la fenêtre surgissante';
$string['cannotcreatesitedir'] = 'Création du dossier du site impossible. L’administrateur du serveur doit corriger les droits d’accès aux fichiers';
$string['cannotcreatetempdir'] = 'Création du dossier temp impossible';
$string['cannotcreateuploaddir'] = 'Création du dossier de téléchargement impossible. L’administrateur du serveur doit corriger les droits d’accès aux fichiers';
$string['cannotcustomisefiltersblockuser'] = 'Vous ne pouvez pas personnaliser les réglages des filtres dans les contextes utilisateur ou bloc.';
$string['cannotdeletebackupids'] = 'Impossible de supprimer les identifiants des sauvegardes précédentes';
$string['cannotdeletecategorycourse'] = 'Échec de la suppression du cours « {$a} »';
$string['cannotdeletecategoryquestions'] = 'Impossible de supprimer des questions de la catégorie « {$a} »';
$string['cannotdeletecourse'] = 'Vous n’avez pas les permissions requises pour supprimer ce cours';
$string['cannotdeletecustomfield'] = 'Erreur lors de la suppression d’un champ personnalisé';
$string['cannotdeletedir'] = 'Suppression impossible ({$a})';
$string['cannotdeletefile'] = 'Impossible de supprimer ce fichier';
$string['cannotdeleterole'] = 'Le rôle ne peut pas être supprimé, parce que {$a}';
$string['cannotdeleterolewithid'] = 'Impossible de supprimer le rôle d’identifiant {$a}';
$string['cannotdeletethisrole'] = 'Vous ne pouvez pas supprimer ce rôle parce qu’il est utilisé par le système ou parce que c’est le dernier rôle comprenant les capacités d’administrateur.';
$string['cannotdisableformat'] = 'Le format par défaut ne peut pas être désactivé.';
$string['cannotdownloadcomponents'] = 'Téléchargement des composants impossible';
$string['cannotdownloadlanguageupdatelist'] = 'Téléchargement de la liste des mises à jour des langues impossible';
$string['cannotdownloadzipfile'] = 'Téléchargement du fichier ZIP impossible';
$string['cannoteditcomment'] = 'Vous ne pouvez pas modifier ce commentaire, qui n’est pas le vôtre !';
$string['cannoteditcommentexpired'] = 'Impossible de modifier ce commentaire. Le délai est échu !';
$string['cannoteditpostorblog'] = 'Vous ne pouvez pas écrire ou modifier de blogs';
$string['cannoteditsiteform'] = 'Vous ne pouvez pas modifier le cours du site par l’intermédiaire de ce formulaire';
$string['cannotedituserpreferences'] = 'Impossible de modifier les préférences de cet utilisateur';
$string['cannotedityourprofile'] = 'Vous ne pouvez pas modifier votre propre profil';
$string['cannotexecduringupgrade'] = 'Ne peut pas être lancé durant la mise à jour';
$string['cannotfindcategory'] = 'Enregistrement de la catégorie (ID {$a}) introuvable dans la base de données';
$string['cannotfindcomponent'] = 'Composant introuvable';
$string['cannotfindcontext'] = 'Impossible de trouver le contexte';
$string['cannotfindcourse'] = 'Cours introuvable';
$string['cannotfinddocs'] = 'Fichiers de documentation de la langue « {$a} » introuvables';
$string['cannotfindgradeitem'] = 'Élément d’évaluation introuvable';
$string['cannotfindgroup'] = 'Impossible de trouver le groupe';
$string['cannotfindhelp'] = 'Fichiers d’aide de la langue « {$a} » introuvables';
$string['cannotfindinfo'] = 'Impossible de trouver d’information pour « {$a} »';
$string['cannotfindlang'] = 'Paquetage de la langue « {$a} » introuvable';
$string['cannotfindteacher'] = 'Impossible de trouver un enseignant';
$string['cannotfinduser'] = 'Impossible de trouver l’utilisateur « {$a} »';
$string['cannotgeoplugin'] = 'Impossible de se connecter au serveur geoPlugin à l’adresse https://www.geoplugin.com. Veuillez vérifier les réglages du proxy ou installer le fichier MaxMind GeoLite City data.';
$string['cannotgetblock'] = 'Impossible de récupérer les blocs dans la base de données';
$string['cannotgetcats'] = 'Impossible d’obtenir l’enregistrement de la catégorie';
$string['cannotgetdata'] = 'Impossible d’obtenir les données';
$string['cannotgradeuser'] = 'Impossible d’évaluer cet utilisateur';
$string['cannothaveparentcate'] = 'La catégorie de cours ne peut pas avoir de parent !';
$string['cannotimport'] = 'Erreur d’importation';
$string['cannotimportformat'] = 'Désolé, l’importation de ce format n’est pas encore implémentée !';
$string['cannotimportgrade'] = 'Erreur d’importation des notes';
$string['cannotinsertgrade'] = 'Impossible d’insérer d’élément d’évaluation sans identifiant de cours !';
$string['cannotinsertrate'] = 'Impossible d’ajouter une évaluation ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Impossible d’insérer le nouvel enregistrement d’identifiant {$a}';
$string['cannotmailconfirm'] = 'Erreur lors de l’envoi du courriel de confirmation de modification de mot de passe';
$string['cannotmanualctrack'] = 'L’activité ne permet pas le suivi manuel de l’achèvement';
$string['cannotmapfield'] = 'Collision détectée : deux champs correspondent au même élément d’évaluation {$a}';
$string['cannotmarktopic'] = 'Impossible de marquer cette section';
$string['cannotmigratedatacomments'] = 'Impossible de migrer les commentaires du module base de données';
$string['cannotmodulename'] = 'Impossible d’obtenir le nom du module dans la navigation';
$string['cannotmoduletype'] = 'Impossible d’obtenir le type du module dans la navigation';
$string['cannotmovecategory'] = 'Impossible de déplacer la catégorie';
$string['cannotmovecourses'] = 'Impossible de déplacer des cours de leur catégorie actuelle vers une autre catégorie.';
$string['cannotmoverolewithid'] = 'Impossible de déplacer le rôle d’identifiant {$a}';
$string['cannotopencsv'] = 'Impossible d’ouvrir le fichier CSV';
$string['cannotopenfile'] = 'Impossible d’ouvrir le fichier ({$a})';
$string['cannotopenforwrit'] = 'Impossible d’ouvrir en écriture : {$a}';
$string['cannotopentemplate'] = 'Impossible d’ouvrir le fichier de modèle ({$a})';
$string['cannotopenzip'] = 'Impossible d’ouvrir le fichier zip. Il s’agit probablement d’un bogue de l’extension zip sur un système d’exploitation 64 bits';
$string['cannotoverridebaserole'] = 'Impossible de définir des dérogations sur les capacités des rôles de base';
$string['cannotoverriderolehere'] = 'Vous n’avez pas les permissions requises pour définir des dérogations au rôle (id = {$a->roleid}) dans ce contexte ({$a->context})';
$string['cannotreadfile'] = 'Impossible de lire le fichier ({$a})';
$string['cannotreadtmpfile'] = 'Erreur de lecture du fichier temporaire';
$string['cannotreaduploadfile'] = 'Impossible de lire le fichier déposé';
$string['cannotremovefrommeta'] = 'Impossible de retirer le cours sélectionné de de méta-cours !';
$string['cannotreprocessgrades'] = 'Impossible de traiter à nouveau les notes de cette activité {$a}';
$string['cannotresetguestpwd'] = 'Il n’est pas possible de réinitialiser le mot de passe du compte « Visiteur anonyme »';
$string['cannotresetmail'] = 'Erreur lors de la réinitalisation du mot de passe';
$string['cannotresetthisrole'] = 'Impossible de réinitialiser ce rôle';
$string['cannotrestore'] = 'Une erreur est survenue et la restauration n’a pas pu avoir lieu !';
$string['cannotrestoreadminorcreator'] = 'Vous devez être créateur de cours ou administrateur pour effectuer une restauration vers un nouveau cours !';
$string['cannotrestoreadminoredit'] = 'Vous devez être enseignant ou administrateur pour effectuer une restauration dans le cours sélectionné !';
$string['cannotsaveagreement'] = 'Impossible d’enregistrer votre accord';
$string['cannotsaveblock'] = 'Erreur lors de l’enregistrement de la configuration du bloc';
$string['cannotsavecomment'] = 'Impossible d’enregistrer le commentaire';
$string['cannotsavedata'] = 'Impossible d’enregistrer les données';
$string['cannotsavefile'] = 'Impossible d’enregistrer le fichier « {$a} »';
$string['cannotsavemd5file'] = 'Enregistrement du fichier md5 impossible';
$string['cannotsavezipfile'] = 'Enregistrement du fichier ZIP impossible';
$string['cannotservefile'] = 'Impossible de fournir le fichier en raison d’un problème de configuration du serveur.';
$string['cannotsetparentforcatoritem'] = 'Impossible d’établir le parent de la catégorie ou de l’élément d’évaluation !';
$string['cannotsetpassword'] = 'Impossible d’établir le mot de passe utilisateur !';
$string['cannotsetprefgrade'] = 'Impossible de régler la préférence « Vue de la tendance centrale » à {$a} pour cette catégorie de notes';
$string['cannotsettheme'] = 'Impossible de définir le thème !';
$string['cannotsetupblock'] = 'Les tables de blocs n’ont pas pu être configurées correctement !';
$string['cannotsetupcapformod'] = 'Impossible de configurer les capacités de {$a}';
$string['cannotsetupcapforplugin'] = 'Impossible de configurer les capacités de {$a}';
$string['cannotshowhidecoursesincategory'] = 'Impossible d’afficher/de cacher les cours dans la catégorie {$a}.';
$string['cannotsignup'] = 'Impossible de créer un nouveau compte, car vous êtes déjà connecté sous le nom « {$a} ».';
$string['cannotswitcheditmodeon'] = 'Impossible d’activer le mode d’édition';
$string['cannotunassigncap'] = 'Impossible de retirer l’attribution de la capacité obsolète {$a->cap} du rôle {$a->role}';
$string['cannotunassignrolefrom'] = 'Impossible de retirer l’attribution du rôle d’identifiant {$a} pour cet utilisateur';
$string['cannotunzipfile'] = 'Décompression du fichier ZIP impossible';
$string['cannotupdatemod'] = 'Impossible de modifier {$a}';
$string['cannotupdatepasswordonextauth'] = 'Échec de la modification du mot de passe dans la source d’authentification externe : {$a}. Consultez les journaux du serveur pour plus d’informations.';
$string['cannotupdateprofile'] = 'Erreur lors de la modification de l’enregistrement de l’utilisateur';
$string['cannotupdaterecord'] = 'Impossible de modifier l’enregistrement d’identifiant {$a}';
$string['cannotupdaterss'] = 'Impossible de modifier le flux RSS';
$string['cannotupdatesubcourse'] = 'Impossible de modifier un cours descendant !';
$string['cannotupdateusermsgpref'] = 'Échec de la modification des réglages de messagerie de l’utilisateur';
$string['cannotupdateuseronexauth'] = 'Échec de la modification des données de l’utilisateur dans la source d’authentification externe : {$a}. Consultez les journaux du serveur pour plus d’informations.';
$string['cannotuploadfile'] = 'Erreur de traitement du fichier déposé';
$string['cannotuseadmin'] = 'Vous devez être administrateur pour utiliser cette page';
$string['cannotuseadminadminorteacher'] = 'Vous devez être enseignant ou administrateur pour utiliser cette page';
$string['cannotusepage'] = 'Seuls les enseignants et les administrateurs peuvent utiliser cette page';
$string['cannotusepage2'] = 'Vous ne pouvez pas utiliser cette page';
$string['cannotviewcategory'] = 'Vous n’avez pas les permissions requises pour voir la liste des cours.';
$string['cannotviewprofile'] = 'Vous ne pouvez pas consulter le profil de cet utilisateur';
$string['cannotviewreport'] = 'Vous ne pouvez pas consulter ce rapport';
$string['cannotwritefile'] = 'Impossible d’écrire dans le fichier ({$a})';
$string['categoryerror'] = 'Erreur de catégorie';
$string['categoryidnumbertaken'] = 'Cet ID est déjà utilisé pour une autre catégorie';
$string['categorynamerequired'] = 'Un nom est requis pour la catégorie';
$string['categorytoolong'] = 'Nom de catégorie trop long';
$string['commentmisconf'] = 'L’identifiant du commentaire est mal configuré';
$string['componentisuptodate'] = 'Le composant est à jour';
$string['confirmationnotenabled'] = 'La confirmation utilisateur n’est pas activée sur ce site';
$string['confirmsesskeybad'] = 'Désolé, votre identifiant de session n’a pas pu être confirmé pour exécuter cette action. Cette sécurité vous protège contre l’exécution accidentelle ou malfaisante en votre nom de fonctions essentielles. Veuillez vérifier que vous avez vraiment voulu effectuer cette action';
$string['contenttypenotfound'] = 'Le type de contenus « {$a} » de la banque de contenus n’existe pas ou n’est pas reconnu.';
$string['contentvisibilitynotfound'] = 'Le contenu dont le réglage de visibilité est « {$a} » n’existe pas ou n’est pas reconnu.';
$string['couldnotassignrole'] = 'Une erreur inconnue, mais sérieuse, est survenue lors de l’attribution d’un rôle à vous-même';
$string['couldnotupdatenoexistinguser'] = 'Impossible de modifier l’utilisateur, qui n’existe pas';
$string['couldnotverifyagedigitalconsent'] = 'Une erreur est survenue lors de la vérification de l’âge de majorité numérique.<br />Veuillez contacter l’administrateur de la plateforme.';
$string['countriesphpempty'] = 'Erreur : le fichier countries.php du paquetage de langue {$a} est vide ou manquant.';
$string['coursedoesnotbelongtocategory'] = 'Le cours n’est pas dans cette catégorie';
$string['courseformatnotfound'] = 'Le format de cours « {$a} » n’existe pas ou n’est pas reconnu.';
$string['coursegroupunknown'] = 'Cours correspondant au groupe {$a} non indiqué';
$string['courseidnotfound'] = 'L’identifiant de cours n’existe pas.';
$string['courseidnumbertaken'] = 'L’identifiant est déjà utilisé pour un autre cours ({$a})';
$string['coursemisconf'] = 'Le cours est mal configuré';
$string['courserequestdisabled'] = 'Désolé, la demande d’ouverture de cours a été désactivée par l’administrateur.';
$string['csvcolumnduplicates'] = 'Colonnes identiques détectées';
$string['csvemptyfile'] = 'Le fichier CSV est vide';
$string['csvfewcolumns'] = 'Pas assez de colonnes. Veuillez vérifier le réglage du séparateur';
$string['csvfileerror'] = 'Il y a un problème avec le format du fichier CSV. Veuillez vérifier que le nombre de colonnes de l’en-tête et des données corresponde et que le séparateur et l’encodage du fichier soient corrects. {$a}';
$string['csvinvalidcols'] = '<b>Fichier CSV non valide !</b> La première ligne doit comporter l’en-tête de définition des champs et le fichier doit être du type <br />Champs étendus/Séparateur virgule<br />ou<br />Champs étendus avec code CAVV/Séparateur virgule';
$string['csvinvalidcolsnum'] = 'Fichier CSV non valide. Chaque ligne doit comporter 49 ou 70 champs';
$string['csvloaderror'] = 'Une erreur est survenue lors du chargement du fichier CSV : {$a}';
$string['csvnodata'] = 'Fichier CSV non valide – Le fichier CSV a un en-tête, mais ne comporte aucune donnée.';
$string['csvweirdcolumns'] = 'Format de fichier CSV non valide : le nombre de colonnes n’est pas toujours le même !';
$string['dbconnectionfailed'] = '<p>Erreur : la connexion à la base de données a échoué.</p><p>Il est possible que la base de données soit surchargée ou qu’elle ne fonctionne pas correctement.</p><p>L’administrateur du site doit vérifier que les informations concernant la base de données sont indiquées correctement dans le fichier <em>config.php</em></p>';
$string['dbdriverproblem'] = '<p>Erreur : problème avec le pilote de la base de données.</p><p>L’administrateur du site doit vérifier la configuration du serveur.</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Grave problème de session de base de données détecté.<br /><br />Veuillez en informer l’administrateur du serveur.';
$string['dbsessionhandlerproblem'] = 'Échec de la mise en place de la session de base de données. Veuillez en informer l’administrateur du serveur.';
$string['dbsessionmysqlpacketsize'] = 'Grave erreur de session détectée. Veuillez en informer l’administrateur du serveur. Ce problème est très probablement causé par une valeur trop faible du réglage MySQL max_allowed_packet.';
$string['dbupdatefailed'] = 'Échec de la mise à jour de la base de données';
$string['ddldependencyerror'] = '{$a->targettype} « {$a->targetname} » ne peut pas être modifié. Une dépendance a été trouvée avec {$a->offendingtype} « {$a->offendingname} »';
$string['ddlexecuteerror'] = 'Erreur d’exécution DDL sql';
$string['ddlfieldalreadyexists'] = 'Le champ « {$a} » n’existe pas';
$string['ddlfieldnotexist'] = 'Le champ « {$a->fieldname} » n’existe pas dans la table « {$a->tablename} »';
$string['ddltablealreadyexists'] = 'La table « {$a} » existe déjà';
$string['ddltablenotexist'] = 'La table « {$a} » n’existe pas';
$string['ddlunknownerror'] = 'Erreur inconnue de bibliothèque DDL';
$string['ddlxmlfileerror'] = 'XML database file errors found';
$string['ddsequenceerror'] = 'Définition incorrecte de la table « {$a} ». Il ne peut y avoir qu’une seule colonne automatique, qui doit être définie comme une clef.';
$string['destinationcmnotexit'] = 'Le module de cours de destination n’existe pas';
$string['detectedbrokenplugin'] = 'Le plugin {$a} est défectueux ou obsolète ; impossible de continuer.';
$string['dmlexceptiononinstall'] = '<p>Une erreur de base de données est survenue [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Erreur lors de l’analyse de la requête SQL';
$string['dmlreadexception'] = 'Erreur de lecture de la base de données';
$string['dmltransactionexception'] = 'Erreur de transaction de base de données';
$string['dmlwriteexception'] = 'Erreur d’écriture vers la base de données';
$string['dndmaxbytes'] = 'Le fichier est trop volumineux. La taille maximale autorisée est {$a->size}.';
$string['dndread'] = 'Erreur de lecture du fichier';
$string['dndunkownfile'] = 'Ce type de fichier n’est pas pris en charge';
$string['dndupload'] = 'Une erreur inconnue est survenue lors du dépôt du fichier';
$string['downgradedcore'] = 'Erreur ! Le code source que vous utilisez est plus ancien que la version qui a créé les bases de données !';
$string['downloadedfilecheckfailed'] = 'La vérification du fichier téléchargé à échoué';
$string['duplicatefieldname'] = 'Nom de champ à double « {$a} » détecté';
$string['duplicatenosupport'] = 'L’activité « {$a->modname} » n’a pas pu être dupliquée, car le module {$a->modtype} ne prend pas en charge la sauvegarde ni la restauration.';
$string['duplicateparaminsql'] = 'Erreur : nom de paramètre à double dans la requête SQL';
$string['duplicaterolename'] = 'Un rôle portant ce nom existe déjà !';
$string['duplicateroleshortname'] = 'Un rôle portant ce nom abrégé existe déjà !';
$string['duplicateusername'] = 'Nom d’utilisateur à double : ligne ignorée';
$string['editedpagenotfound'] = 'Impossible de déterminer la page actuelle. Veuillez actualiser et réessayer.';
$string['emailfail'] = 'Échec de l’envoi par courriel';
$string['encryption_decryptfailed'] = 'Échec du déchiffrement';
$string['encryption_encryptfailed'] = 'Échec du chiffrement';
$string['encryption_invalidkey'] = 'Clef non valide';
$string['encryption_keyalreadyexists'] = 'La clef existe déjà';
$string['encryption_nokey'] = 'Clef non trouvée';
$string['encryption_wrongmethod'] = 'Les données ne correspondent à aucune méthode de chiffrement';
$string['enddatebeforestartdate'] = 'La date de fin doit être postérieure à la date de début.';
$string['error'] = 'Une erreur est survenue';
$string['error_question_answers_missing_in_db'] = 'Impossible de trouver une réponse correspondant à « {$a->answer} » dans la table question_answers de la base de données. Cette erreur est survenue lors de la restauration de la question d’identifiant {$a->filequestionid} dans le fichier de sauvegarde, qui a été mis en correspondance avec la question existante d’identifiant {$a->dbquestionid} dans la base de données.';
$string['errorcleaningdirectory'] = 'Erreur lors du nettoyage du dossier « {$a} »';
$string['errorcopyingfiles'] = 'Erreur lors de la copie de fichiers';
$string['errorcreatingdirectory'] = 'Erreur lors de la création du dossier « {$a} »';
$string['errorcreatingfile'] = 'Erreur lors de la création du fichier « {$a} »';
$string['errorcreatingrole'] = 'Erreur lors de la création du rôle';
$string['errorfetchingrssfeed'] = 'Erreur lors de la récupération du flux RSS.';
$string['erroronline'] = 'Erreur à la ligne {$a}';
$string['erroroutput'] = 'Erreur de sortie. La redirection automatique a été désactivée.';
$string['errorparsingxml'] = 'Erreur d’analyse XML : {$a->errorstring} à la ligne {$a->errorline}, caractère {$a->errorchar}';
$string['errorprocessingarchive'] = 'Erreur lors du traitement du fichier d’archive';
$string['errorreadingfile'] = 'Erreur lors de la lecture du fichier « {$a} »';
$string['errorsavingrequest'] = 'Erreur lors de l’enregistrement de votre demande';
$string['errorsettinguserpref'] = 'Erreur lors de l’enregistrement de la préférence utilisateur';
$string['errorunzippingfiles'] = 'Erreur lors de la décompression de fichiers';
$string['expiredkey'] = 'Clef échue';
$string['externalauthpassworderror'] = 'Mot de passe non vide pour authentification externe';
$string['externalfilenolocation'] = 'Le fichier externe n’a pas de chemin d’accès';
$string['failtoloadblocks'] = 'Un ou plusieurs blocs sont enregistrés dans la base de données, mais une erreur est survenue lors de leur chargement !';
$string['fieldrequired'] = 'Le champ « {$a} » est obligatoire';
$string['fileexists'] = 'Le fichier existe déjà';
$string['filemismatch'] = 'Un nom de fichier ne correspond pas. Le fichier « {$a->current} » devrait être {$a->file}';
$string['filenotfound'] = 'Le fichier demandé n’a pas été trouvé';
$string['filenotreadable'] = 'Le fichier ne peut pas être lu';
$string['filterdoesnothavelocalconfig'] = 'Le filtre {$a} ne permet pas de configuration locale.';
$string['filternotactive'] = 'Le filtre {$a} n’est actuellement pas actif';
$string['filternotenabled'] = 'Le filtre n’est pas activé !';
$string['filternotinstalled'] = 'Le filtre {$a} n’est actuellement pas installé';
$string['forumblockingtoomanyposts'] = 'Vous avez dépassé le maximum de messages fixé pour ce forum';
$string['functionalityremoved'] = 'Vous tentez d’accéder à une fonctionnalité qui a été supprimée.';
$string['generalexceptionmessage'] = 'Exception : {$a}';
$string['gradecantregrade'] = 'Une erreur est survenue lors du calcul de la note : {$a}';
$string['gradepubdisable'] = 'Publication des notes désactivée';
$string['gradesneedregrading'] = 'Les notes du cours doivent être recalculées';
$string['groupalready'] = 'L’utilisateur appartient déjà au groupe {$a}';
$string['groupexistforcourse'] = 'Le groupe « {$a} » existe déjà dans ce cours';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup} : le groupe « {$a->name} » d’identifiant {$a->idnumber} existe déjà dans ce cours';
$string['grouphasidnumber'] = 'Le groupe « {$a} » a un identifiant et a été vraisemblablement créé automatiquement par un système externe. Vous n’avez pas les permissions requises pour le supprimer.';
$string['groupinghasidnumber'] = 'Le groupement « {$a} » a un identifiant et a été vraisemblablement créé automatiquement par un système externe. Vous n’avez pas les permissions requises pour le supprimer.';
$string['groupingnotaddederror'] = 'Groupement « {$a} » non ajouté';
$string['groupnotaddederror'] = 'Le groupe « {$a} » n’a pas été ajouté';
$string['groupnotaddedtogroupingerror'] = 'Groupe {$a->groupname} pas ajouté au groupement {$a->groupingname}';
$string['groupunknown'] = 'Le groupe {$a} n’est pas associé au cours indiqué';
$string['groupusernotmember'] = 'L’utilisateur n’est pas membre de ce groupe.';
$string['guestcantaccessprofiles'] = 'Les utilisateurs anonymes ne peuvent pas consulter les profils utilisateurs. Veuillez vous connecter avec un compte utilisateur pour continuer.';
$string['guestnocomment'] = 'Les visiteurs anonymes ne peuvent pas ajouter de commentaires';
$string['guestnoeditprofile'] = 'Les visiteurs anonymes ne peuvent pas modifier leur profil';
$string['guestnoeditprofileother'] = 'Le profil du compte « Visiteur anonyme » ne peut pas être modifié';
$string['guestnorate'] = 'Les visiteurs anonymes ne peuvent pas évaluer les articles';
$string['guestsarenotallowed'] = 'Les visiteurs anonymes ne peuvent pas faire ceci';
$string['hackdetected'] = 'Attaque détectée !';
$string['hashpoolproblem'] = 'Contenu incorrect {$a} de la collection de fichiers.';
$string['headersent'] = 'En-têtes déjà envoyés';
$string['idnumbertaken'] = 'Cet identifiant est déjà utilisé pour un autre cours';
$string['idnumbertoolong'] = 'Numéro d’identification trop long';
$string['importformatnotimplement'] = 'L’importation de ce format n’est pas encore implémentée !';
$string['incorrectext'] = 'Le fichier a une extension incorrecte';
$string['inplaceeditableerror'] = 'Erreur lors de l’appel du processus de modification';
$string['installproblem'] = 'Il n’est habituellement pas possible de rattraper une erreur survenue durant l’installation. Si vous voulez tenter une nouvelle installation, vous devrez probablement créer une nouvelle base de données ou utiliser un autre préfixe de base de données.';
$string['internalauthpassworderror'] = 'Mot de passe manquant ou politique de mots de passe non valide pour authentification interne';
$string['invalidaccess'] = 'L’accès à cette page n’est pas correct';
$string['invalidaccessparameter'] = 'Paramètre d’accès non valide';
$string['invalidaction'] = 'Paramètre d’action non valide';
$string['invalidactivityid'] = 'Indentifiant d’activité non valide';
$string['invalidadminsettingname'] = 'Réglage d’administration non valide ({$a})';
$string['invalidargorconf'] = 'Aucun paramètre valide fourni ou configuration serveur défectueuse';
$string['invalidarguments'] = 'Aucun paramètre valide fourni';
$string['invalidblockinstance'] = 'Instance de bloc non valide pour {$a}';
$string['invalidbulkenrolop'] = 'Opération d’inscription par lots non valide demandée.';
$string['invalidcategory'] = 'Catégorie incorrecte !';
$string['invalidcategoryid'] = 'Identifiant de catégorie incorrect !';
$string['invalidcomment'] = 'Commentaire non valide';
$string['invalidcommentarea'] = 'Zone de commentaire non valide';
$string['invalidcommentid'] = 'Identifiant de commentaire non valide';
$string['invalidcommentitemid'] = 'Identifiant d’élément (itemid) de commentaire non valide';
$string['invalidcommentparam'] = 'Paramètres de commentaire non valides';
$string['invalidcomponent'] = 'Nom de composant non valide';
$string['invalidconfirmdata'] = 'Données de confirmation non valides';
$string['invalidcontentid'] = 'ID de contenu non valide';
$string['invalidcontext'] = 'Contexte non valide';
$string['invalidcountrycode'] = 'Code de pays non valide : {$a}';
$string['invalidcourse'] = 'Cours non valide';
$string['invalidcourseformat'] = 'Format de cours non valide';
$string['invalidcourseid'] = 'Vous essayez d’utiliser un identifiant de cours non valable';
$string['invalidcourselevel'] = 'Niveau de contexte incorrect';
$string['invalidcoursemodule'] = 'Identifiant de module de cours non valide';
$string['invalidcoursemoduleid'] = 'ID de module de cours non valide : {$a}';
$string['invalidcoursenameshort'] = 'Le nom abrégé du cours n’est pas valide';
$string['invaliddata'] = 'Les données envoyées ne sont pas valides';
$string['invaliddatarootpermissions'] = 'Des droits d’accès non valides ont été détectés lors de la création d’un dossier. Veuillez activer le débogage pour plus d’informations.';
$string['invaliddevicetype'] = 'Type d’appareil non valide';
$string['invalidelementid'] = 'Identifiant d’élément incorrect !';
$string['invalidentry'] = 'Article non valide';
$string['invalidevent'] = 'Événement non valide';
$string['invalidfieldname'] = '« {$a} » n’est pas un nom de champ valide';
$string['invalidfiletype'] = '« {$a} » n’est pas un type de fichier valide';
$string['invalidformatpara'] = 'Format incorrect pour le paramètre à choisir';
$string['invalidformdata'] = 'Données du formulaire incorrectes';
$string['invalidfunction'] = 'Fonction incorrecte';
$string['invalidgradeitemid'] = 'Identifiant d’élément d’évaluation incorrect';
$string['invalidgroupid'] = 'Identifiant de groupe incorrect';
$string['invalidipformat'] = 'Format d’adresse IP non valide';
$string['invaliditemid'] = 'Identifiant d’élément incorrect !';
$string['invalidkey'] = 'Clef incorrecte';
$string['invalidlanguagecode'] = 'Code de langue non valide : {$a}';
$string['invalidlegacy'] = 'Définition de rôle historique incorrect pour le type {$a}';
$string['invalidmd5'] = 'Le code de contrôle md5 n’est pas valide';
$string['invalidmode'] = 'Mode non valide ({$a})';
$string['invalidmodule'] = 'Module non valide';
$string['invalidmoduleid'] = 'Identifiant de module non valide';
$string['invalidmodulename'] = 'Nom de module non valide  {$a}';
$string['invalidnum'] = 'Valeur numérique non valide';
$string['invalidnumkey'] = 'Le tableau $conditions ne doit pas contenir de clef numérique. Veuillez corriger le code !';
$string['invalidoutcome'] = 'Identifiant d’objectif incorrect';
$string['invalidpagesize'] = 'Taille de page non valide';
$string['invalidpasswordpolicy'] = 'Politique de mots de passe non valide';
$string['invalidpaymentmethod'] = 'Méthode de paiement non valide : {$a}';
$string['invalidpersistenterror'] = 'Erreur : {$a}';
$string['invalidqueryparam'] = 'Erreur : nombre de paramètres incorrect dans la requête. {$a->expected} paramètres attendus, actuellement {$a->actual} paramètres.';
$string['invalidratingarea'] = 'Zone d’évaluation non valide';
$string['invalidrecord'] = 'Impossible de trouver l’enregistrement de données dans la table {$a} de la base de données.';
$string['invalidrecordunknown'] = 'Impossible de trouver l’enregistrement de données dans la base de données.';
$string['invalidrequest'] = 'Requête non valide';
$string['invalidrole'] = 'Rôle non valide';
$string['invalidroleid'] = 'Identifiant de rôle incorrect';
$string['invalidscaleid'] = 'Identifiant de barème incorrect';
$string['invalidsection'] = 'L’enregistrement du module de cours contient une section non valide';
$string['invalidsesskey'] = 'Votre session est vraisemblablement échue. Veuillez vous reconnecter.';
$string['invalidshortname'] = 'Nom abrégé du cours non valide';
$string['invalidsourcefield'] = 'Le champ source du fichier brouillon n’est pas valide';
$string['invalidstatedetected'] = 'Quelque chose est allé de travers : {$a}. Normalement, ceci ne devrait jamais arriver.';
$string['invalidurl'] = 'URL non valide';
$string['invaliduser'] = 'Utilisateur non valide';
$string['invaliduserdata'] = 'Données utilisateur non valides : {$a}';
$string['invaliduserfield'] = 'Champ utilisateur non valide : {$a}';
$string['invaliduserid'] = 'Identifiant utilisateur non valide';
$string['invalidusername'] = 'Le nom indiqué comporte des caractères non valides';
$string['invalidusernameblank'] = 'Le nom d’utilisateur ne peut pas être vide';
$string['invalidxmlfile'] = '« {$a} » n’est pas un fichier XML valide';
$string['iplookupfailed'] = 'Aucune information géographique trouvée pour cette adresse IP {$a}';
$string['iplookupprivate'] = 'Impossible d’afficher des informations d’adresses IP privées';
$string['ipmismatch'] = 'L’adresse IP du client ne correspond pas';
$string['listcantmovedown'] = 'Échec du déplacement de l’élément vers le bas : il s’agit du dernier élément.';
$string['listcantmoveleft'] = 'Échec du déplacement de l’élément vers la gauche : il n’a pas de parent';
$string['listcantmoveright'] = 'Échec du déplacement de l’élément vers la droite : il n’y a pas d’élément du même niveau sous lequel le ranger. Déplacez-le sous un autre élément et vous pourrez alors le déplacer';
$string['listcantmoveup'] = 'Échec du déplacement de l’élément vers le haut : il s’agit du premier élément.';
$string['listnochildren'] = 'Aucun descendant trouvé pour cet élément';
$string['listnoitem'] = 'Élément non trouvé';
$string['listnopeers'] = 'Aucun élément de même niveau trouvé';
$string['listupdatefail'] = 'L’opération sur la base de données a échoué lors de la modification de la liste hiérarchique';
$string['logfilenotavailable'] = 'Journaux non disponibles';
$string['loginasnoenrol'] = 'Vous ne pouvez pas vous inscrire ou vous désinscrire d’un cours lorsque vous êtes « Connecté sous le nom » d’un autre participant';
$string['loginasonecourse'] = 'Vous ne pouvez pas entrer dans ce cours.<br />Vous devez d’abord terminer la session dans laquelle vous êtes « Connecté sous le nom » d’un autre participant';
$string['maxareabytes'] = 'Le fichier dépasse l’espace disponible dans cette zone.';
$string['maxbytesfile'] = 'La taille du fichier {$a->file} est trop grande. La taille maximale d’un fichier à déposer est de {$a->size}.';
$string['maxdraftitemids'] = 'Vos dépôts de fichiers sont temporairement limités après que vous avez déposé un important volume de fichiers. Veuillez essayer plus tard.';
$string['messageundeliveredbynotificationsettings'] = 'Le message n’a pas pu être envoyé, car l’échange de messages personnels entre utilisateurs (dans les réglages de notification) a été désactivé par un administrateur du site.';
$string['messagingdisable'] = 'La messagerie est désactivée sur ce site';
$string['mimetexisnotexist'] = 'Votre serveur n’est pas configuré pour lancer mimeTeX. Veuillez télécharger les sources en C du programme ici <a href="https://www.forkosh.com/mimetex.zip"> https://www.forkosh.com/mimetex.zip</a>, les compiler et placer le programme dans le dossier moodle/filter/tex/.';
$string['mimetexnotexecutable'] = 'Votre programme <em>mimetex</em> n’est pas exécutable !';
$string['missing_moodle_backup_xml_file'] = 'Fichier de sauvegarde XML manquant : {$a}';
$string['missingcategoryrole'] = 'Impossible d’attribuer le rôle à un utilisateur : rôle manquant pour la catégorie.';
$string['missingfield'] = 'Le champ « {$a} » est manquant';
$string['missingkeyinsql'] = 'Erreur : paramètre « {$a} » manquant dans la requête';
$string['missingparam'] = 'Un paramètre requis ({$a}) est manquant';
$string['missingparameter'] = 'Paramètre manquant';
$string['missingrequiredfield'] = 'Un champ obligatoire n’est pas renseigné';
$string['missinguseranditemid'] = 'Identifiants utilisateur et élément manquants';
$string['missingvarname'] = 'Nom de variable requis manquant !';
$string['mixedtypesqlparam'] = 'Erreur : différents types de paramètres dans la requête SQL !';
$string['mnetdisable'] = 'Le réseau MNET est désactivé';
$string['mnetlocal'] = 'Les utilisateurs distants MNet ne peuvent pas se connecter localement';
$string['moduledisable'] = 'Ce module ({$a}) a été désactivé dans ce cours';
$string['moduledoesnotexist'] = 'Ce module n’existe pas';
$string['moduleinstancedoesnotexist'] = 'L’instance de ce module n’existe pas';
$string['modulemissingcode'] = 'Le module {$a} ne possède pas le code source permettant d’effectuer cette fonction';
$string['moodlenet:invalidshareformat'] = 'Format de partage MoodleNet incorrect';
$string['moodlenet:invalidsharestatus'] = 'Statut de partage MoodleNet incorrect';
$string['moodlenet:invalidsharetype'] = 'Type de partage MoodleNet non valide';
$string['moodlenet:usernotconfigured'] = 'Vous n’avez pas les permissions requises pour partager du contenu vers MoodleNet, ou bien votre compte n’est pas configuré correctement.';
$string['movecatcontentstoroot'] = 'Il n’est pas permis de déplacer le contenu de cette catégorie à la racine. Vous devez déplacer ce contenu vers une catégorie existante !';
$string['movecatcontentstoselected'] = 'Certains contenus de la catégorie ne peuvent pas être déplacés dans la catégorie choisie.';
$string['movecategorynotpossible'] = 'Vous ne pouvez pas déplacer la catégorie « {$a} » dans la catégorie sélectionnée.';
$string['movecategoryownparent'] = 'Vous ne pouvez pas faire de la catégorie « {$a} » un parent d’elle-même.';
$string['movecategoryparentconflict'] = 'Vous ne pouvez pas faire de la catégorie « {$a} » une sous-catégorie de l’une de ses propres sous-catégories.';
$string['mssqlrcsmodemissing'] = 'La base de données n’utilise pas le mode attendu READ_COMMITTED_SNAPSHOT, ce qui peut conduire à des résultats erronés, particulièrement lors de situations avec de nombreux accès simultanés. Veuillez activer ce mode pour un fonctionnement correct. Vous trouverez plus d’informations à ce sujet sur <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">Moodle Docs (en anglais)</a>.';
$string['multiplerecordsfound'] = 'Plusieurs enregistrement trouvés, alors qu’un seul enregistrement est attendu.';
$string['multiplerestorenotallow'] = 'Pas les permissions requises pour effectuer des restaurations multiples !';
$string['mustbeloggedin'] = 'Vous devez être connecté pour faire ceci';
$string['mustbeteacher'] = 'Vous devez être enseignant pour voir cette page';
$string['myisamproblem'] = 'Les tables de la base de données utilisent le moteur MyISAM. Il est recommandé d’utiliser un moteur conforme au standard ACID, avec une prise en charge complète des transactions, par exemple InnoDB.';
$string['needcopy'] = 'Vous devez d’abord copier quelque chose !';
$string['needcoursecategroyid'] = 'Un identifiant de cours ou de catégorie doit être spécifié';
$string['needphpext'] = 'Vous devez ajouter à votre installation PHP la prise en charge de {$a}';
$string['noadmins'] = 'Aucun administrateur !';
$string['noblocks'] = 'Aucun bloc trouvé !';
$string['nocapabilitytousethisservice'] = 'L’utilisateur n’a pas les capacités requises pour utiliser ce service';
$string['nocategorydelete'] = 'La catégorie « {$a} » ne peut pas être supprimée !';
$string['nocontext'] = 'Désolé, ce cours n’est pas dans un contexte valide';
$string['nodata'] = 'Aucune donnée';
$string['noexistingcategory'] = 'Catégorie introuvable';
$string['nofile'] = 'Fichier non spécifié';
$string['nofiltersenabled'] = 'Aucun filtre n’est activé';
$string['nofolder'] = 'Le dossier demandé n’existe pas';
$string['noformdesc'] = 'Aucun fichier de description de formulaire formslib trouvé pour cette activité';
$string['noguest'] = 'Pas de visiteur anonyme ici !';
$string['noinstances'] = 'Il n’y a aucune instance de {$a} dans ce cours !';
$string['nologinas'] = 'Vous n’avez pas les permissions requises pour vous connecter avec ce nom d’utilisateur';
$string['nonmeaningfulcontent'] = 'Le contenu ne fait pas de sens';
$string['noparticipants'] = 'Aucun participant trouvé dans ce cours';
$string['noparticipatorycms'] = 'Désolé, aucun module de participation pour lequel faire un rapport';
$string['nopermissions'] = 'Désolé, vous n’avez actuellement pas les permissions requises pour effectuer ceci ({$a})';
$string['nopermissiontoaccesspage'] = 'Vous n’avez pas les permissions requises pour accéder à cette page.';
$string['nopermissiontocomment'] = 'Vous n’avez pas les permissions requises pour ajouter des commentaires !';
$string['nopermissiontodelentry'] = 'Vous ne pouvez pas supprimer ce commentaire !';
$string['nopermissiontoeditcomment'] = 'Vous n’avez pas les permissions requises pour modifier les commentaires d’autres utilisateurs !';
$string['nopermissiontohide'] = 'Vous n’avez pas les permissions requises pour cacher !';
$string['nopermissiontoimportact'] = 'Vous n’avez pas les les permissions requises pour importer des activités dans ce cours';
$string['nopermissiontolock'] = 'Vous n’avez pas les permissions requises pour verrouiller !';
$string['nopermissiontomanagegroup'] = 'Vous n’avez pas les permissions requises pour gérer les groupes';
$string['nopermissiontorate'] = 'Vous n’avez pas les permissions requises pour évaluer des articles !';
$string['nopermissiontoshow'] = 'Vous n’avez pas les permissions requises pour voir ceci !';
$string['nopermissiontounlock'] = 'Vous n’avez pas les permissions requises pour déverrouiller !';
$string['nopermissiontoupdatecalendar'] = 'Vous n’avez pas les permissions requises pour modifier un événement de calendrier.';
$string['nopermissiontoviewcalendar'] = 'Vous n’avez pas les permissions requises pour voir l’événement de calendrier.';
$string['nopermissiontoviewgrades'] = 'Vous n’avez pas les permissions requises pour voir les notes.';
$string['nopermissiontoviewletergrade'] = 'Vous n’avez pas les permissions requises pour voir les notes lettres';
$string['nopermissiontoviewpage'] = 'Vous n’avez pas les permissions requises pour voir cette page';
$string['nosite'] = 'Impossible de trouver le cours du site';
$string['nositeid'] = 'Aucun identifiant de site';
$string['nostartdatenoenddate'] = 'Une date de fin de cours ne peut être définie que si une date de début est également définie.';
$string['nostatstodisplay'] = 'Désolé, il n’y a aucune donnée à afficher';
$string['notallowedtoupdateprefremotely'] = 'Vous n’avez pas les permissions requises pour modifier cette préférence utilisateur à distance';
$string['notavailable'] = 'Ceci n’est actuellement pas disponible';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Vous n’êtes pas membre de ce groupe';
$string['notownerofkey'] = 'Vous n’êtes pas le possesseur de cette clef';
$string['nousers'] = 'Aucun utilisateur !';
$string['oauth1accesstoken'] = 'Erreur OAuth 1.0 : impossible de récupérer le jeton d’accès.';
$string['oauth1requesttoken'] = 'Erreur OAuth 1.0 : impossible de récupérer le jeton de requête. Le fournisseur de service est peut-être temporairement inatteignable.';
$string['oauth2refreshtokenerror'] = 'Impossible d’actualiser le jeton OAuth 2. Statut HTTP du point de terminaison distant : {$a}';
$string['oauth2refreshtokentaskerror'] = 'Impossible d’actualiser le jeton OAuth 2 pour un ou plusieurs fournisseurs. Consulter la sortie de la tâche pour plus d’informations';
$string['oauth2upgradetokenerror'] = 'Impossible de mettre à jour le jeton OAuth 2. Statut HTTP du point de terminaison distant : {$a}';
$string['onlyadmins'] = 'Seuls les administrateurs peuvent faire ceci';
$string['onlyeditingteachers'] = 'Seuls les enseignants (éditeurs) peuvent faire ceci';
$string['onlyeditown'] = 'Vous ne pouvez modifier que vos propres informations';
$string['opensslsealerror'] = 'OpenSSL ne peut pas crypter les données';
$string['opensslsignerror'] = 'OpenSSL ne peut pas signer les données';
$string['orderidnotfound'] = 'Identifiant de commande {$a} non trouvé';
$string['pagenotexist'] = '<p>Une erreur inhabituelle est survenue en essayant d’atteindre une page qui n’existe pas :</p>{$a}';
$string['pagenotexisttitle'] = 'Erreur 404 : fichier non trouvé';
$string['passwordexceeded'] = 'Le mot de passe ne peut pas contenir plus de {$a} caractères !';
$string['pathdoesnotstartslash'] = 'Paramètre non valide, le chemin indiqué ne commence pas par une barre oblique !';
$string['pleasereport'] = 'Merci de prendre un peu de temps pour nous faire savoir ce que vous essayiez de faire lorsque l’erreur est survenue :';
$string['pluginnotexist'] = 'Le plugin {$a} n’existe pas';
$string['pluginrequirementsnotmet'] = 'Le plugin « {$a->pluginname} » ({$a->pluginversion}) ne peut pas être installé. Il nécessite une version plus récente de Moodle (vous utilisez actuellement la version {$a->currentmoodle}, la version {$a->requiremoodle} est requise)';
$string['pluginunsupported'] = 'Le plugin « {$a->pluginname} » {$a->pluginversion} ne prend pas en charge cette version de Moodle {$a->moodleversion}. Veuillez consulter les informations du plugin pour trouver les versions prises en charge.';
$string['prefixcannotbeempty'] = '<p>Erreur : le préfixe des tables de la base de données ne peut pas être vide ({$a}).</p><p>L’administrateur du site doit corriger ce problème.</p>';
$string['prefixtoolong'] = '<p>Erreur : le préfixe des tables de la base de données est trop long ({$a->dbfamily}).</p><p>L’administrateur du site doit corriger ce problème. La longueur maximale pour le préfixe des tables dans {$a->dbfamily} est de {$a->maxlength} caractères.</p>';
$string['privatefilesupload'] = 'Le dépôt de fichier directement dans la zone des fichiers personnels n’est plus pris en charge. Veuillez déposer les fichiers vers la zone de brouillon, puis les déplacer avec core_user::add_user_private_files';
$string['processingstops'] = 'Le traitement s’arrête ici. Les enregistrements restant ont été ignorés';
$string['protected_cc_not_supported'] = 'Les paquetages protégés ne sont pas pris en charge.';
$string['querystringcannotbeempty'] = 'La chaîne de requête ne peut pas être vide.';
$string['redirecterrordetected'] = 'Redirection non prise en charge. L’exécution du script a été stoppée.';
$string['refoundto'] = 'Peut être remboursé à {$a}';
$string['refoundtoorigi'] = 'Remboursement au montant original : {$a}';
$string['registrationdisabled'] = 'L’enregistrement est désactivé sur ce site';
$string['remotedownloaderror'] = '<p>Le téléchargement du composant sur votre serveur a échoué. Veuillez vérifier les réglages de proxy. L’extension cURL de PHP est vivement recommandée.</p>
<p>Vous devez télécharger manuellement le fichier <a href="{$a->url}">{$a->url}</a>, le copier sur votre serveur à l’emplacement « {$a->dest} » et le décompresser à cet endroit.</p>';
$string['remotedownloadnotallowed'] = 'Le téléchargement de composants sur votre serveur n’est pas autorisé (l’option allow_url_fopen est désactivée).<br /><br />Vous devez télécharger manuellement le fichier <a href="{$a->url}">{$a->url}</a>, le copier vers « {$a->dest} » dans votre serveur et le décompresser';
$string['reportnotavailable'] = 'Ce type de rapport n’est disponible que pour le cours de site';
$string['requirecorrectaccess'] = 'Port ou URL non valide.';
$string['requireloginerror'] = 'Cours ou activité non disponible.';
$string['restore_path_element_missingmethod'] = 'La méthode de restauration {$a} est manquante. Elle doit être définie par un développeur.';
$string['restore_path_element_noobject'] = 'L’objet de restauration {$a} n’est pas un objet.';
$string['restorechecksumfailed'] = 'Un problème est survenu avec les informations de restauration stockées dans votre session. Veuillez vérifier la mémoire PHP et/ou les limites de taille de la base de données. La restauration a été interrompue.';
$string['restrictedcontextexception'] = 'L’exécution de fonctions externes viole la restriction de contexte.';
$string['restricteduser'] = 'Votre compte utilisateur « {$a} » ne vous permet pas d’effectuer cette opération';
$string['reverseproxyabused'] = 'Le proxy inverse est activé ; il n’est donc pas possible d’accéder au serveur de manière directe.<br />Veuillez contacter l’administrateur du serveur.';
$string['rpcerror'] = 'Votre communication MNET a échoué. Voici le message à communiquer à votre administrateur : {$a}';
$string['scheduledbackupsdisabled'] = 'Les sauvegardes automatiques ont été désactivées par l’administrateur du serveur';
$string['secretalreadyused'] = 'Le lien de confirmation du changement de mot de passe a déjà été utilisé. Le mot de passe n’a pas été modifié';
$string['sectionnotexist'] = 'Cette section n’existe pas';
$string['sendmessage'] = 'Envoyer message';
$string['sendmessagesent'] = 'Merci pour votre feedback sur :<br />{$a}';
$string['serverconnection'] = 'Erreur lors de la connexion au serveur';
$string['servicedonotexist'] = 'Le service n’existe pas';
$string['sessioncannotobtainlock'] = '<p>Impossible d’obtenir un verrou pour l’identifiant de session {$a->id} durant {$a->acquiretimeout}.</p>
<p>Il est probable qu’une autre page ({$a->whohaslock}) est active dans un autre onglet du navigateur ou qu’un verrou n’a pas été libéré suite à une erreur.</p>
<p>Vous pouvez attendre jusqu’à l’échéance du délai du verrou ({$a->lockexpire}) ou redémarrer la session de navigateur. Si l’erreur persiste, veuillez en informer l’administrateur du serveur.</p>';
$string['sessioncookiesdisable'] = 'Utilisation incorrecte de require_key_login(). Les cookies de session doivent être désactivés !';
$string['sessiondiskfull'] = 'La partition de session est pleine. Il n’est actuellement pas possible de se connecter. Veuillez contacter l’administrateur du serveur.';
$string['sessionerroruser'] = 'Votre session est échue. Veuillez vous reconnecter.';
$string['sessionerroruser2'] = 'Une erreur du serveur impactant votre session de connexion a été détectée. Veuillez vous connecter à nouveau ou relancer votre navigateur.';
$string['sessionexpired'] = 'Session échue';
$string['sessionhandlerproblem'] = 'Traitement des sessions mal configuré';
$string['sessionipnomatch'] = 'Votre adresse IP semble avoir changé depuis votre connexion. Cette sécurité empêche des pirates d’usurper votre identité lorsque vous êtes connecté sur ce site. Les utilisateurs ne rencontrent en principe pas message. Veuillez demander de l’aide à l’administrateur de ce site.';
$string['sessionipnomatch2'] = '<p>Votre adresse IP semble avoir changé depuis votre première connexion. Ce réglage de sécurité empêche des pirates d’usurper votre identité lorsque vous êtes connecté sur ce site. Cette erreur peut survenir lors de l’utilisation de réseaux sans fil ou si vous passez d’un réseau à un autre (itinérance). Pour plus d’informations, veuillez contacter votre administrateur.</p>
<p>Si vous voulez continuer, veuillez actualiser l’affichage de cette page.</p>';
$string['sessionwaiterr'] = 'Durée dépassée au cours de l’attente pour un verrouillage de session.<br />Veuillez attendre que vos requêtes actuelles se terminent et essayer plus tard.';
$string['shortnametaken'] = 'Ce nom abrégé est déjà utilisé pour un autre cours ({$a})';
$string['sitepolicynotagreed'] = 'Politique du site pas acceptée : <a href="{$a}">veuillez cliquer ici pour accéder à la politique du site</a>.';
$string['socksnotsupported'] = 'Le proxy SOCKS5 n’est pas pris en charge en PHP4';
$string['spellcheckernotconf'] = 'Le correcteur orthographique n’est pas configuré';
$string['sslonlyaccess'] = 'Pour des raisons de sécurité, seules les connexions sécurisées https sont autorisées.';
$string['statscatchupmode'] = 'Les statistiques sont en cours de traitement. Jusqu’ici, {$a->daysdone} jour(s) ont été traités. Il en reste {$a->dayspending} à traiter. Veuillez patienter et revenir plus tard !';
$string['statsdisable'] = 'Les statistiques ne sont pas activées.';
$string['statsnodata'] = 'Aucune donnée disponible pour ce cours et cette période';
$string['storedfilecannotcreatefile'] = 'Impossible de créer un fichier de pool de fichiers locaux. Veuillez vérifier les droits d’accès au dossier de données ainsi que l’espace disque disponible.';
$string['storedfilecannotcreatefiledirs'] = 'Impossible de créer les dossiers du pool de fichiers locaux. Veuillez vérifier les droits d’accès au dossier de données.';
$string['storedfilecannotread'] = 'Impossible de lire le fichier. Soit le fichier n’existe pas, soit il y a un problème de droits d’accès.';
$string['storedfilecannotreadfile'] = 'Impossible de lire « {$a} ». Soit le fichier n’existe pas, soit il y a un problème de droits d’accès.';
$string['storedfilenotcreated'] = 'Impossible de créer le fichier {$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}';
$string['storedfileproblem'] = 'Exception inconnue en rapport avec les fichiers locaux ({$a})';
$string['tagdisabled'] = 'Les tags sont désactivés !';
$string['tagnotfound'] = 'Le tag indiqué n’a pas été trouvé dans la base de données';
$string['targetdatabasenotempty'] = 'La base de données choisie n’est pas vide. Le transfert a été interrompu par sécurité.';
$string['textconditionsnotallowed'] = 'La comparaison des conditions de texte par colonne n’est pas permise. Veuillez utiliser sql_compare_text() dans votre requête.';
$string['themenotinstall'] = 'Ce thème n’est pas installé !';
$string['tokengenerationfailed'] = 'Impossible de générer un nouveau jeton';
$string['transactionvoid'] = 'La transaction ne peut pas être annulée, car cela a déjà été fait';
$string['unenrolerror'] = 'Une erreur est survenue lors de la tentative de désinscription de cet utilisateur';
$string['unicodeupgradeerror'] = 'Désolé, votre base de données n’est pas encore en Unicode, et cette version de Moodle n’est pas capable d’effectuer la migration de la base de données vers Unicode. Veuillez effectuer d’abord la mise à jour à Moodle 1.7.x, puis la migration Unicode sur la page d’administration. Ensuite seulement, vous pourrez effectuer la mise à jour à Moodle {$a}';
$string['unknowaction'] = 'Action inconnue !';
$string['unknowcategory'] = 'Catégorie inconnue !';
$string['unknowcontext'] = 'Ceci est un contexte inconnu ({$a}) dans get_child_contexts !';
$string['unknowformat'] = 'Format inconnu ({$a})';
$string['unknownbackupexporterror'] = 'Erreur inconnue lors de la préparation des information pour l’importation';
$string['unknownblockregion'] = 'La région de bloc « {$a} » n’est pas reconnue sur cette page.';
$string['unknowncategory'] = 'Catégorie inconnue d’ID de catégorie « {$a} »';
$string['unknowncontext'] = 'Contexte inconnu';
$string['unknowncourse'] = 'Le cours « {$a} » est inconnu';
$string['unknowncourseidnumber'] = 'L’identifiant de cours « {$a} » est inconnu';
$string['unknowncourserequest'] = 'Demande de cours inconnue';
$string['unknowncoursesection'] = 'Section inconnue dans le cours « {$a} »';
$string['unknownevent'] = 'Événement inconnu';
$string['unknownfiletype'] = 'Type de filtre inconnu';
$string['unknowngroup'] = 'Groupe « {$a} » inconnu';
$string['unknownhelp'] = 'Chapitre {$a} de l’aide inconnu';
$string['unknownjsinrequirejs'] = 'Impossible de trouver la bibliothèque JavaScript {$a}.';
$string['unknownmodulename'] = 'Nom de module inconnu pour le formulaire';
$string['unknownrole'] = 'Rôle « {$a} » inconnu';
$string['unknownsortcolumn'] = 'Colonne de tri {$a} inconnue';
$string['unknownuseraction'] = 'Désolé, je ne comprends pas ce que vous voulez faire';
$string['unknownuserselector'] = 'Sélecteur d’utilisateur inconnu';
$string['unknoworder'] = 'Ordre de tri inconnu';
$string['unknowparamtype'] = 'Type de paramètre inconnu : {$a}';
$string['unknowquestiontype'] = 'Type de question inconnu  {$a}';
$string['unknowuploadaction'] = 'Erreur : action de dépôt inconnue ({$a})';
$string['unspecifycourseid'] = 'Vous devez indiquer l’identifiant du cours, son nom abrégé ou son identifiant';
$string['unsupportedevent'] = 'Type d’événement non pris en charge';
$string['unsupportedstate'] = 'État d’achèvement non pris en charge';
$string['unsupportedwebserver'] = 'Ce logiciel serveur web ({$a}) n’est pas pris en charge.';
$string['upgraderequires19'] = 'Erreur ! Une nouvelle version de Moodle a été installée sur le serveur. Malheureusement, la mise à jour à partir de la version installée actuellement n’est pas prise en charge.<br />Veuillez effectuer d’abord une mise à jour vers la dernière version 1.9.x. Vous pouvez revenir à votre version actuelle en la réinstallant';
$string['upgraderunning'] = 'Ce site est en phase de mise à jour. Veuillez essayer plus tard.';
$string['urlnotdefinerss'] = 'URL du flux RSS non défini';
$string['useradmineditadmin'] = 'Les administrateurs sont seuls habilités à modifier d’autres comptes administrateurs';
$string['useradminodelete'] = 'Les comptes administrateurs ne peuvent pas être supprimés.';
$string['userautherror'] = 'Plugin d’authentification inconnu';
$string['userauthunsupported'] = 'Plugin d’authentification non pris en charge ici';
$string['useremailduplicate'] = 'Adresse de courriel en doublon';
$string['userisfilteredout'] = 'Cet utilisateur ne correspond pas aux préférences des filtres et de la table !';
$string['usermustbemnet'] = 'Les utilisateurs de la liste d’accès MNET doivent être des utilisateurs distants MNET';
$string['usernamelowercase'] = 'Le nom d’utilisateur doit être entièrement en caractères bas de casse';
$string['usernotaddederror'] = 'Utilisateur pas ajouté : erreur inconnue';
$string['usernotaddedregistered'] = 'Utilisateur pas ajouté : déjà enregistré';
$string['usernotaddedusernameexists'] = 'Utilisateur non ajouté – Le nom d’utilisateur existe avec une adresse de courriel';
$string['usernotavailable'] = 'Vous n’avez pas les permissions requises pour consulter les informations sur cet utilisateur';
$string['usernotdeletedadmin'] = 'Compte non supprimé ; il est impossible de supprimer les comptes administrateurs.';
$string['usernotdeleteddeleted'] = 'Cet utilisateur a déjà été supprimé.';
$string['usernotdeletederror'] = 'L’utilisateur n’a pas été supprimé : erreur inconnue';
$string['usernotdeletedmissing'] = 'L’utilisateur n’a pas été supprimé : le nom d’utilisateur n’a pas été trouvé';
$string['usernotdeletedoff'] = 'L’utilisateur n’a pas été supprimé : la suppression n’est pas autorisée';
$string['usernotfullysetup'] = 'Utilisateur pas complètement défini';
$string['usernotincourse'] = 'Cet utilisateur ne participe pas à ce cours !';
$string['usernotrenamedadmin'] = 'Impossible de modifier le nom des comptes administrateur';
$string['usernotrenamedexists'] = 'Le nom d’utilisateur n’a pas été modifié : le nouveau nom est déjà utilisé';
$string['usernotrenamedmissing'] = 'Le nom d’utilisateur n’a pas été modifié : l’ancien nom n’a pas été trouvé';
$string['usernotrenamedoff'] = 'Le nom d’utilisateur n’a pas été modifié : la modification du nom n’est pas autorisée';
$string['usernotupdatedadmin'] = 'Impossible de mettre à jour les comptes administrateur';
$string['usernotupdatederror'] = 'Utilisateur pas mis à jour : erreur inconnue';
$string['usernotupdatednotexists'] = 'Utilisateur pas mis à jour : le compte n’existe pas';
$string['userquotalimit'] = 'Vous avez atteint votre quota de fichiers.';
$string['userselectortoomany'] = 'Le script user_selector a reçu plus d’un utilisateur sélectionné, alors que multiselect est FAUX.';
$string['verifyagedigitalconsentnotpossible'] = 'La vérification de l’âge de majorité numérique n’est actuellement pas possible.';
$string['wrongcall'] = 'L’appel de ce script n’est pas correct';
$string['wrongcontextid'] = 'Identifiant du contexte incorrect (impossible de le trouver)';
$string['wrongdestpath'] = 'Chemin de destination incorrect';
$string['wrongroleid'] = 'Identifiant de rôle incorrect';
$string['wrongsourcebase'] = 'Adresse URL de base de la source incorrecte';
$string['wrongusernamepassword'] = 'Nom d’utilisateur ou mot de passe incorrect';
$string['wrongzipfilename'] = 'Nom de fichier ZIP incorrect';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Impossible de créer le cours - Pas de permission requise';
$string['wwwrootmismatch'] = 'Accès incorrect détecté. Ce serveur ne peut être contacté que via l’adresse « {$a} ».<br />Veuillez informer l’administrateur du serveur.';
$string['wwwrootslash'] = 'La variable $CFG->wwwroot est définie incorrectement dans config.php. Elle ne doit pas comprendre de barre oblique finale.<br />Veuillez informer l’administrateur du serveur.';
$string['xmldberror'] = 'Erreur XMLDB !';
$string['youcannotdeletecategory'] = 'Vous ne pouvez pas supprimer la catégorie « {$a} », parce que vous ne pouvez ni supprimer son contenu, ni le déplacer ailleurs.';
