<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'pt_br', version '4.3'.
 *
 * @package     local_moodleorg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutstatistics'] = 'O Moodle é gratuito para download e o seu registro é voluntário, portanto não temos informação completa sobre todos que o utilizam. No entanto, utilizando o que sabemos, podemos gerar automaticamente números e gráficos interessantes em nossa página de estatísticas.';
$string['aboutstatisticsheading'] = 'Estatísticas Moodle';
$string['aboutstatisticstitle'] = 'Moodle.org: Moodle estatísticas';
$string['activeusers24hours'] = 'Usuários registrados que acessaram nas últimas 24 horas:';
$string['activeuserspastmonth'] = 'Usuários registrados que acessaram no último mês:';
$string['browsegittitle'] = 'Navegue em nosso código-fonte';
$string['cachedef_frontpagecolumn'] = 'Colunas da página inicial';
$string['cachedef_usefulposts'] = 'Posts úteis';
$string['communities'] = 'Comunidades';
$string['communitiesmy'] = 'Minhas comunidades';
$string['community'] = 'Comunidade';
$string['communityadministration'] = 'Administração da comunidade';
$string['communitycurrent'] = 'Comunidade atual';
$string['communityenrolme'] = 'Tornar-se membro dessa comunidade';
$string['communityenrolmentoptions'] = 'Acessando uma comunidade';
$string['communityintro'] = 'Moodle tem uma comunidade de usuários grande e diversificada, com mais de <a href="http://moodle.org/userpics">{$a->usercount} usuários registrados</a>  que comunicam em <a href="http://download.moodle.org/langpack/">{$a->langcount} idiomas</a> em <a href="http://moodle.org/sites"> {$a->countrycount} países</a> (nós temos <a href="http://moodle.org/stats">mais estatísticas</a>  neste site).';
$string['communityjoinbyyourself'] = 'Acesse';
$string['communityjoinbyyourselfas'] = 'Acesse como {$a->rolename}';
$string['communitynoguestaccess'] = 'Visitantes não podem acessar essa área da comunidade, por favor tente fazer log in.';
$string['communitynotenrollable'] = 'Você não pode tornar-se um membro dessa comunidade sozinho. Por favor, contate o facilitador da comunidade.';
$string['communitysomeallowguest'] = 'Algumas comunidades podem permitir acesso de visitantes';
$string['communityunenrolme'] = 'Deixar a comunidade {$a}';
$string['conferencecenter'] = 'Centro de conferência Moodle';
$string['connectedsites'] = 'Alguns sites Moodle tem estão ligados ao moodle.org utilizando o Moodle Networking, então você pode entrar lá diretamente, uma vez que você está autenticado aqui.';
$string['donations10over'] = 'Outras doações de $10 ou mais';
$string['donationsassociation'] = 'Faça parte da <a href="https://moodleassociation.org/">Associação Moodle</a> - Ajude a decidir como as anuidades devem ser aplicadas no desenvolvimento do Moodle';
$string['donationsdevelopment'] = 'Porém, o desenvolvimento do Moodle e a manutenção de todos os sites da comunidade custam bastante e nós sempre podemos usar um suporte extra. Se você ama o Moodle ou achou ele útil para seu negócio, escola ou instituição, por favor, faça uma doação. Cada parte ajuda.';
$string['donationsdonatenow'] = 'Doe agora';
$string['donationsensure'] = 'Doações garantem que as engrenagens essenciais da Máquina Moodle (nossos desenvolvedores) continuem criando novas funcionalidades e corrigindo bugs, fazendo o Moodle melhor para todos nós.';
$string['donationsmoodle'] = 'Doando ao Moodle';
$string['donationsopensource'] = 'O Moodle é código aberto de verdade e completamente livre de obrigações financeiras para nossos usuários - é assim que software deveria ser!';
$string['donationsover1000'] = 'Doações anteriores acima de $1000';
$string['donationsover200'] = 'Outras doações acima de $200';
$string['donationsover500'] = 'Outras doações acima de $500';
$string['donationspartner'] = 'Use os serviços de um <a href="https://moodle.com/partners/">Moodle Partner certificado</a> - 10% de toda a receita deles é revertida para o Moodle.';
$string['donationsshop'] = 'Compre alguma coisa na nossa <a href="http://www.zazzle.com/moodle_hq/">Loja do Moodle</a> e use com orgulho!';
$string['donationsthankeveryone'] = 'Obrigado a todos e todas que contribuíram com o projeto Moodle.';
$string['donationsthankyou'] = 'Obrigado';
$string['donationstitle'] = 'Doações';
$string['donationsways'] = 'Outras formas de contribuir financeiramente com o Moodle:';
$string['download_activities'] = 'Atividades';
$string['download_admintools'] = 'Ferramentas administrativas';
$string['download_appdocumentation'] = 'Documentação do App';
$string['download_appreleasenotes'] = 'Notas de lançamento';
$string['download_browseall'] = 'Navegue em todos';
$string['download_forandroid'] = 'Para Android';
$string['download_forios'] = 'Para iOS';
$string['download_helpbox_installing'] = 'Instalando o Moodle';
$string['download_helpbox_partners'] = 'Moodle Partners';
$string['download_helpbox_title'] = 'Precisa de ajuda?';
$string['download_helpbox_upgrading'] = 'Atualizando o Moodle';
$string['download_hero_headline'] = 'Moodle é código aberto.';
$string['download_mobileapp'] = 'App Móvel';
$string['download_themes'] = 'Temas';
$string['downloadcore'] = 'Nosso principal método de distribuição é por meio de pacotes padronizados do núcleo do Moodle. Esses pacotes contém um certo número de módulos que são mantidos pelos desenvolvedores do projeto, e podem ser instalados em praticamente qualquer plataforma que disponha de PHP e uma base de dados.';
$string['downloadcoretitle'] = 'Pacotes padrão do Moodle';
$string['downloadintro'] = 'Moodle é código aberto sob a <a href="http://docs.moodle.org/en/License">licença GPL</a>. Tudo o que produzimos está disponível para você baixar e usar gratuitamente.';
$string['downloadlang'] = 'Nas versões atuais do Moodle, adição de suporte para novas línguas foram automatizadas a partir do menu de administração em seu site. No entanto, para algumas versões antigas do Moodle, novos pacotes de idiomas precisam ser baixado manualmente.';
$string['downloadlangtitle'] = 'Pacotes de idioma';
$string['downloadmac'] = 'Se você não possuir um servidor web já criado, estes pacotes "all-in-one" (tudo em um) tornam muito fácil de instalar o Moodle em qualquer computador da Apple com o Mac OS X.';
$string['downloadmactitle'] = 'Moodle para Mac OS X';
$string['downloadmodules'] = 'Navegue pela nossa base de dados repleta de módulos extras e plugins que podem ser adicionados ao seu site Moodle para dar-lhe a funcionalidade extra para além dos pacotes de distribuição.';
$string['downloadmodulestitle'] = 'Plugins';
$string['downloadthemes'] = 'A aparência de um site Moodle pode ser modificada totalmente utilizando-se um tema diferente. Nós mantemos um banco de dados com temas que os usuários Moodle podem criar e compartilhar.';
$string['downloadthemestitle'] = 'Temas';
$string['downloadwin'] = 'Se você não possuir um servidor web já criado, estes pacotes "all-in-one" (tudo em um) tornam muito fácil de instalar o Moodle em qualquer computador com Microsoft Windows.';
$string['downloadwintitle'] = 'Moodle para Windows';
$string['erroradminonly'] = 'Apenas administradores podem acessar esta interface.';
$string['erroralreadyvoted'] = 'Você já votou para {$a}';
$string['errormaxmessages'] = 'Desculpe, mas você não pode enviar mais de 3 mensagens.';
$string['errornomainnews'] = 'Não foi possível encontrar ou criar um fórum de notícias principal para o site';
$string['errorsendingmail'] = 'Houve um erro no envio de sua mensagem. Por favor, tente mais tarde ou contate o administrador do site.';
$string['eventdonation_submitted'] = 'Doação enviada';
$string['events'] = 'Embora nos especializamos na aprendizagem on-line, ainda é agradável se reunir em uma sala! Veja estes links para obter mais informações sobre nossas conferências (que chamamos de MoodleMoots) e outros eventos.';
$string['eventstitle'] = 'Eventos';
$string['feed_events'] = 'Eventos';
$string['feed_news'] = 'Anúncios';
$string['feed_news_more'] = 'Ver todos os anúncios';
$string['feed_resources'] = 'Recursos';
$string['feed_useful'] = 'Posts úteis';
$string['feed_useful_more'] = 'Mais posts';
$string['focusbox_community'] = 'Suporte e fóruns da comunidade';
$string['focusbox_community_text'] = 'Obtenha suporte e compartilhe idéias em seu próprio idioma';
$string['focusbox_community_viewall'] = 'Todas as comunidades';
$string['focusbox_future'] = 'Ajude a moldar o futuro do Moodle';
$string['focusbox_future_crowdfund'] = 'Projetos de financiamento coletivo';
$string['focusbox_future_gdf'] = 'Discussões de desenvolvedores';
$string['focusbox_future_research'] = 'Pesquisa em Moodle';
$string['focusbox_future_roadmap'] = 'Roadmap';
$string['focusbox_future_text'] = 'Encontre o que vem por aí e ajude a fazer a diferença';
$string['focusbox_settingup'] = 'Configurando';
$string['focusbox_settingup_community'] = 'Suporte da comunidade';
$string['focusbox_settingup_download'] = 'Download grátis';
$string['focusbox_settingup_hosting'] = 'Hospedagem';
$string['focusbox_settingup_install'] = 'Instalação';
$string['focusbox_settingup_own'] = 'Por voccê mesmo';
$string['focusbox_settingup_partner'] = 'Através de um Moodle Partner';
$string['focusbox_settingup_plugins'] = 'Plugins';
$string['focusbox_settingup_support'] = 'Suporte comercial';
$string['focusbox_teaching'] = 'Ensinando com o Moodle';
$string['focusbox_teaching_books'] = 'Livros';
$string['focusbox_teaching_courses'] = 'Cursos e conteúdo';
$string['focusbox_teaching_docs'] = 'Documentação';
$string['focusbox_teaching_text'] = 'Explore a grande variedade de funcionalizades e recursos disponíveis no Moodle.';
$string['focusbox_theproject'] = 'O projeto Moodle';
$string['focusbox_theproject_about'] = 'Sobre o Moodle';
$string['focusbox_theproject_devs'] = 'Desenvolvedores';
$string['focusbox_theproject_hq'] = 'Moodle HQ';
$string['focusbox_theproject_partners'] = 'Moodle Partners';
$string['focusbox_theproject_stats'] = 'Estatísticas';
$string['focusbox_theproject_text'] = 'Aprenda mais sobre o projeto Moodle e nossas parcerias abertas e colaborativas.';
$string['focusbox_uptodate'] = 'Fique por dentro';
$string['focusbox_uptodate_buzz'] = 'Moodle buzz';
$string['focusbox_uptodate_news'] = 'Anúncios oficiais';
$string['focusbox_uptodate_planet'] = 'Planeta Moodle';
$string['focusbox_uptodate_security'] = 'Avisos de segurança';
$string['focusbox_uptodate_social'] = 'Mídia social';
$string['focusbox_uptodate_text'] = 'Últimas notícias, atualizações e insights ao redor do mundo.';
$string['generaldeveloperforum'] = 'Fórum geral de desenvolvedores';
$string['graphpopulation'] = 'Gráfico populacional do Moodle';
$string['graphregistrationmap'] = 'Mapa de registros do Moodle';
$string['graphregistrationmapdesc'] = '10 primeiros dos sites registrados em {$a} países';
$string['graphusersites'] = 'Comparação Usuários Moodle X site';
$string['heroslide_community_description'] = 'Seja bem-vindo(a) à comunidade Moodle e descubra o valor de um esforço aberto e colaborativo de um dos maiores times de código-aberto do mundo.';
$string['heroslide_community_headline'] = 'Orientado para a comunidade, com suporte global.';
$string['heroslide_community_slidecontrol'] = 'Suportado por uma comunidade global';
$string['heroslide_donate_headline'] = 'Ajude-nos a fazer a diferença com educação aberta e de qualidade para todos';
$string['heroslide_getstarted40_description'] = 'O Moodle LMS tem uma nova personalidade e uma experiência de usuário redefinida que melhora o ensino e aprendizagem online para educadores, estudantes e administradores.';
$string['heroslide_getstarted40_headline'] = 'Moodle 4.0 - Novo visual, melhor experiência de usuário';
$string['heroslide_getstarted40_slidecontrol'] = 'O Moodle 4.0 está aqui!';
$string['heroslide_getstarted_description'] = 'O Moodle é o sistema de gestão da aprendizagem mais popular do mundo. Comece a criar seu site de aprendizado online em minutos!';
$string['heroslide_getstarted_headline'] = 'Começar é fácil';
$string['heroslide_getstarted_slidecontrol'] = 'Comece hoje';
$string['heroslide_global_description'] = 'Disponível em mais de 100 idiomas, o Moodle tem a confiança de organizações e instituições, grande e pequenas, com milhões de usuários no mundo todo';
$string['heroslide_global_headline'] = 'Potencializando ambientes de aprendizagem no mundo todo';
$string['heroslide_global_slidecontrol'] = 'Potencializando ambientes de aprendizagem no mundo todo';
$string['heroslide_link_demo'] = 'Demo';
$string['heroslide_link_donate'] = 'Faça uma doação';
$string['heroslide_link_features'] = 'Funcionalidades';
$string['heroslide_link_forums'] = 'Fóruns da comunidade';
$string['heroslide_link_getstarted'] = 'Comece hoje';
$string['heroslide_link_getstarted40'] = 'Aprenda sobre o Moodle 4.0';
$string['heroslide_link_sites'] = 'Sites registrados';
$string['heroslide_link_stats'] = 'Estatísticas';
$string['heroslide_link_stories'] = 'Leia mais';
$string['heroslide_power_description'] = 'A plataforma de aprendizagem livre que ajuda você a criar experiências de ensino e aprendizagem em um ambiente colaborativo e particular.';
$string['heroslide_power_headline'] = 'Potente. Seguro. Código aberto.';
$string['heroslide_power_slidecontrol'] = 'Plataforma de aprendizagem robusta de código aberto';
$string['heroslide_story1_headline'] = 'Melhorando o ensino e a aprendizagem em todos os lugares';
$string['heroslide_story2_headline'] = 'Alcance a excelência na aprendizagem corporativa';
$string['heroslide_story_slidecontrol'] = 'Histórias do Moodle ao redor do mundo';
$string['jobs'] = 'Visite nosso banco de dados de postos de trabalho para informações sobre as oportunidades de empregos relacionados a Moodle em todo o mundo.';
$string['moodlepartner_corporate'] = 'Treinamento corporativo';
$string['moodlepartner_other'] = 'Outros setores';
$string['moodlepartner_school'] = 'Escolas';
$string['moodlepartner_university'] = 'Universidades';
$string['networkinfo'] = 'Os sites a seguir foram conectados ao Moodle.org usando a rede então você pode acessá-los diretamente daqui.';
$string['networktitle'] = 'Sites conectados';
$string['newregistrations'] = 'Novas inscrições';
$string['newstitle'] = 'Anúncios oficiais';
$string['noenrolledcoursesyet'] = 'Você ainda não está inscrito em nenhum curso deste site.';
$string['partnerslogan'] = 'O projeto Moodle tem apoio de mais de 90 <a href="https://moodle.com/partners/">Moodle Partners</a> certificados ao redor do mundo.';
$string['permalink'] = 'Permalink';
$string['pluginname'] = 'Moodle.org site';
$string['popularissues'] = 'Questões mais populares';
$string['privacy:metadata:db:registerdonations'] = 'Guarda registros das doações ao Moodle';
$string['privacy:metadata:db:registerdonations:amount'] = 'Quantia doada';
$string['privacy:metadata:db:registerdonations:name'] = 'Nome do doador';
$string['privacy:metadata:db:registerdonations:org'] = 'Organização do doador';
$string['privacy:metadata:db:registerdonations:timedonated'] = 'Data e hora da doação';
$string['privacy:metadata:db:registerdonations:url'] = 'URL do doador';
$string['recentlyratedposts'] = 'Posts avaliados recentemente';
$string['recentpart'] = 'Esta página mostra algumas das pessoas que estão usando moodle.org hoje.';
$string['registeredsites'] = 'As instituições não são obrigadas a informar  quando utilizam o Moodle. pois o Moodle é open source. No entanto, alguns sites Moodle optaram por registrar-se conosco e nós mantemos uma lista deles.';
$string['registeredsitestitle'] = 'Sites registrados';
$string['registereduserslastday'] = 'Novos usuários nas últimas 24 horas:';
$string['registereduserstotal'] = 'Total de usuários registrados:';
$string['registrationgraphalt'] = 'Todos os registros do Moodle ao longo do tempo';
$string['registrationgraphdesc'] = 'Realizamos regularmente <a href="http://docs.moodle.org/en/Usage"> uma checagem geral dos sites </a> para nos certificarmos de que eles ainda existem.  Porisso você pode encontrar uma variação ou nesse número.';
$string['registrationslast6months'] = 'Registros nos últimos 6 meses';
$string['registrationslastmonths'] = 'Registros nos últimos {$a} meses';
$string['registrationstotal'] = 'Todos os registros atuais';
$string['resources_buzz'] = 'Buzz';
$string['resources_courses'] = 'Cursos';
$string['resources_jobs'] = 'Vagas';
$string['resources_plugins'] = 'Plugins';
$string['roadmap'] = 'Roteiro Moodle';
$string['rssdescription'] = 'Posts úteis ou novos dos fóruns do moodle.org';
$string['rssmoodlecommore'] = 'Veja todas as novidades';
$string['rsstitle'] = 'Posts do fóruns do Moodle.org';
$string['searchmoodleorg'] = 'Buscar no moodle.org';
$string['securitytitle'] = 'Avisos de segurança';
$string['shop'] = 'Procurando alguma forma de mostrar que você faz parte da nossa comunidade? Veja a loja de camisetas, canecas e todos os tipos de lembranças.';
$string['social-facebook-moodle'] = 'Página oficial do Moodle no Facebook';
$string['social-linkedin-moodle'] = 'Página oficial do Moodle no LinkedIn';
$string['social-twitter-moodledev'] = 'Notícias e atualizações sobre o desenvolvimento do Moodle';
$string['social-twitter-moodlehq'] = 'Tweets do Moodle HQ';
$string['social-twitter-moodleplugins'] = 'Plugins do Moodle publicados recentemente';
$string['social-twitter-moodlesecurity'] = 'Avisos de segurança do Moodle';
$string['social-twitter-moodlethemes'] = 'Temas do Moodle publicados recentemente';
$string['social-youtube-moodle'] = 'Canal oficial do Moodle no YouTube';
$string['socialtitle'] = 'Mídias sociais';
$string['statscountries'] = 'Países';
$string['statscourses'] = 'Cursos';
$string['statsenrolments'] = 'Inscrições';
$string['statsposts'] = 'Postagens no fórum';
$string['statsquestions'] = 'Questões do quiz';
$string['statsresources'] = 'Recursos';
$string['statsteachers'] = 'Professores';
$string['statsusers'] = 'Usuários';
$string['supportbooks'] = 'Nós temos uma lista de livros sobre o Moodle disponíveis para compra.';
$string['supportcommercial'] = 'Os Moodle Partners são fornecedores de serviço certificados no mundo todo que podem ajudar você com sua implementação do Moodle e outros serviços.';
$string['supportdocs1'] = 'Moodle Docs é um ótimo lugar para começar, especialmente nossas páginas de Perguntas Mais Frequentes (FAQ).';
$string['supportdocs2'] = 'Um bom modo de ter acesso à documentação relevante é usar o link "Ajuda para esta página no Moodle Docs" no rodapé de cada página do seu site Moodle.';
$string['supportdocsfaq'] = 'Perguntas Mais Frequentes';
$string['supportdocslang'] = 'Moodle Docs em outros idiomas';
$string['supportforums'] = 'Nossa comunidade de usuários comunica principalmente através de fóruns nos "cursos" disponíveis neste site Moodle. Você precisa "inscrever-se" no curso para enviar mensagens aos fóruns (a inscrição é totalmente gratuita).';
$string['supportforumsenglish'] = 'As discussões principais de suporte dos desenvolvedores a outros usuários estão (em inglês) aqui:';
$string['supportforumsenglishname'] = 'Usando o Moodle';
$string['supportforumslang'] = 'O fórum chave para os usuários do Moodle interagirem (em inglês) está aqui:';
$string['supportforumslangname'] = 'Moodle Lounge';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'Temos muitos outros fóruns também, em várias línguas:';
$string['supportforumslistname'] = 'Lista de todos os cursos';
$string['supportintro'] = 'Você não está sozinho! Há muitas maneiras de receber ajuda com o Moodle caso você precise.';
$string['top10countriesbyregistration'] = 'Top 10 países por registros';
$string['top10sitesbycourses'] = 'Top 10 sites por cursos';
$string['top10sitesbyusers'] = 'Top 10 sites por usuários';
$string['url-about'] = 'https://docs.moodle.org/all/pt_br/Sobre_o_Moodle';
$string['url-userdocs'] = 'http://docs.moodle.org/pt_br';
$string['versionsused'] = 'Versões usadas';
