<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'cachestore_redis', language 'da', version '4.3'.
 *
 * @package     cachestore_redis
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['ca_file'] = 'CA filsti';
$string['ca_file_help'] = 'Placering af certifikatmyndighedsfil på det lokale filsystem';
$string['compressor_none'] = 'Ingen komprimering.';
$string['compressor_php_gzip'] = 'Brug gzip-kompression.';
$string['compressor_php_zstd'] = 'Brug Zstandard-komprimering.';
$string['encrypt_connection'] = 'Brug TLS-kryptering.';
$string['encrypt_connection_help'] = 'Brug TLS til at oprette forbindelse til Redis. Brug ikke \'tls://\' i værtsnavnet for Redis, brug denne mulighed i stedet.';
$string['password'] = 'Adgangskode';
$string['password_help'] = 'Her sættes adgangskode til Redisserveren';
$string['pluginname'] = 'Redis';
$string['prefix'] = 'Nøglepræfiks';
$string['prefix_help'] = 'Dette præfiks bruges til alle nøglenavne på Redisserveren.

* Har du kun en Moodle på denne server kan du bruge standardværdien.
* Grundet begrænsning på nøglens længde, kan der kun bruges 5 tegn.';
$string['prefixinvalid'] = 'Ugyldigt præfiks. Du kan kun bruge a-z A-Z 0-9-_.';
$string['privacy:metadata:redis'] = 'Redis cachestore-plugin gemmer data kortvarigt som en del af sin cache-funktionalitet. Disse data gemmes på en Redis-server, hvor data regelmæssigt fjernes.';
$string['privacy:metadata:redis:data'] = 'De forskellige data, der er gemt i cachen';
$string['server'] = 'Server';
$string['server_help'] = 'Her angives hostnavn eller ip-adresse til den Redisserver der skal bruges';
$string['task_ttl'] = 'Frigør hukommelse brugt af udløbne poster i Redis-cacher';
$string['test_password'] = 'Testserver-adgangskode';
$string['test_password_desc'] = 'Adgangskode til Redis-testserveren.';
$string['test_serializer'] = 'Serializer';
$string['test_serializer_desc'] = 'Serializer der skal bruges til test.';
$string['test_server'] = 'Testserver';
$string['test_server_desc'] = 'Redis-server til brug for tests.';
$string['test_ttl'] = 'Test af TTL';
$string['test_ttl_desc'] = 'Kør ydelsestesten med en cache, der kræver TTL (langsommere sæt).';
$string['usecompressor'] = 'Brug kompressor';
$string['usecompressor_help'] = 'Angiver den kompressor, der skal bruges efter serialisering. Det udføres på Moodle Cache API-niveau, ikke på php-redis niveau.';
$string['useserializer'] = 'Brug serializer';
$string['useserializer_help'] = 'Angiver, hvilken serializer der skal bruges til serialisering.
De gyldige serializers er Redis::SERIALIZER_PHP eller Redis::SERIALIZER_IGBINARY.
Sidstnævnte understøttes kun, når phpredis er konfigureret med --enable-redis-igbinary optionen, og igbinary-udvidelsen er indlæst.';
