<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'zoom', language 'it', version '4.3'.
 *
 * @package     zoom
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Azioni';
$string['addtocalendar'] = 'Aggiungi al calendario';
$string['allmeetings'] = 'Tutti le riunioni';
$string['allmeetings_desc'] = 'Imposta la visibilità di un link all\'attività Zoom in fondo a ciascuna istanza dell\'attività. L\'impostazione influenza solamente la visibilità del link nella pagina introduttiva dell\'attività Zoom. Da notare che l\'utente può essere in grado di accedere alla pagina indice dell\'attività Zoom anche se il link non fosse visibile.';
$string['allmeetings_disable'] = 'Disabilita link Tutte le riunioni';
$string['allmeetings_enable'] = 'Disabilita link Tutte le riunioni';
$string['alternative_hosts'] = 'Host alternativo';
$string['alternative_hosts_desc'] = 'Imposta la visualizzazione dell\'opzione host alternativo. Sono disponibili due modalità: un campo input di testo che accetta un elenco di email separate da virgola, oppure un selettore di utenti che facilita la scelta degli utenti che sono iscritti al corso, che possiedono una account Zoom e hanno un ruolo tra {$a->roles}. Gli host alternativi eventualmente impostati direttamente in Zoom ma che non sono selezionabili da Moodle, verranno comunque visualizzati nella pagina introduttiva all\'attività e rimarranno host alternativi anche quando la riunione viene modificata da Moodle.';
$string['alternative_hosts_disable'] = 'Disabilita opzione Host alternativo';
$string['alternative_hosts_help'] = 'Consente di designare un altro Utente Zoom affinché possa avviare la riunione o il webinar. Questi utenti riceveranno un\'email da Zoom con la notifica che sono stati aggiunti come host alternativi, con un link per avviare la riunione. Per impostare host alternativi, inserire gli indirizzai email separati da una virgola.';
$string['alternative_hosts_inputfield'] = 'Visualizza l\'opzione Host alternativo come input di testo';
$string['alternative_hosts_picker'] = 'Visualizza l\'opzione Host alternativo come selettore utenti con completamento automatico';
$string['alternative_hosts_picker_help'] = 'Consente di designare un altro Utente Zoom iscritto al corso affinché possa avviare la riunione o il webinar. Questi utenti riceveranno un\'email da Zoom con la notifica che sono stati aggiunti come host alternativi, con un link per avviare la riunione. E\' possibile selezionare uno o più host alternativi, in funzione delle esigenze del meeting. Se non fosse possibile selezionare uno specifico utente, allora l\'utente non ha un ruolo appropriato nel corso oppure non ha un account Zoom idoneo.';
$string['alternative_hosts_picker_noneselected'] = 'Non è stato selezionato nessun host alternativo.';
$string['alternative_hosts_picker_placeholder'] = 'Seleziona utenti';
$string['apiendpoint'] = 'Endpoint API Zoom';
$string['apiendpoint_desc'] = 'Consente di selezionare l\'endpoint delle API Zoom. L\'endpoint globale solitamente funziona per tutti gli utenti. L\'endpoint dell\'Unione Europea (UE) è dedicato solamente agli utenti che possiedono una licenza Zoom rilasciata in Unione Europea. In caso di dubbio, utilizzare l\'endpoint globale.';
$string['apiendpoint_eu'] = 'Endpoint API EU';
$string['apiendpoint_global'] = 'Endpoint API Globali';
$string['apiidentifier'] = 'Identificativo API Zoom';
$string['apiidentifier_desc'] = 'Il campo identificativo da utilizzare per le chiamate alle API di Zoom';
$string['apiurl'] = 'URL API Zoom';
$string['apiurl_desc'] = 'L\'URL delle API Zoom';
$string['audio_both'] = 'Audio del computer e Telefono';
$string['audio_telephony'] = 'Solo telefono';
$string['audio_voip'] = 'Solo audio del computer';
$string['audiodefault'] = 'Audio di default';
$string['authentication'] = 'Autenticazione';
$string['cachedef_zoomid'] = 'ID Zoom dell\'utente';
$string['cachedef_zoommeetingsecurity'] = 'Impostazioni di sicurezza della riunione Zoom, inclusa la password dell\'incontro';
$string['calendardescriptionURL'] = 'URL di accesso alla riunione: {$a}.';
$string['calendardescriptionintro'] = '\\nDescrizione:\\n{\\$a}';
$string['calendariconalt'] = 'Icona calendario';
$string['changehost'] = 'Cambia host';
$string['clickjoin'] = 'Cliccato il pulsante di partecipazione alla riunione';
$string['connectionfailed'] = 'Connessione non riuscita:';
$string['connectionok'] = 'La connessione è funzionante.';
$string['connectionsettings'] = 'Impostazioni connessione';
$string['connectionsettings_desc'] = 'Imposta come Moodle si collegherà a Zoom';
$string['connectionstatus'] = 'Stato della connessione';
$string['day'] = 'Giorni';
$string['defaultsettings'] = 'Impostazioni di default di Zoom';
$string['defaultsettings_help'] = 'Le impostazioni predefinite delle attività riunione e webinar di Zoom.';
$string['deletemeetingrecordings'] = 'Elimina da Moodle le registrazioni delle riunioni';
$string['displayleadtime'] = 'Visualizza tempo mancante';
$string['displayleadtime_desc'] = 'Consente di visualizzare il tempo mancante agli utenti. In questo modo sarà possibile informare gli utenti del tempo mancante prima che possano accedere alla riunione, senza che abbiamo la necessità di ricaricare la pagina per verificare la possibilità di accedere al meeting.';
$string['displayleadtime_nohideif'] = 'Nota: l\'impostazione sarà tenuta in considerazione solo se l’impostazione \'{$a}\' è impostata ad un valore maggiore di zero.';
$string['displaypassword'] = 'Visualizza password';
$string['displaypassword_help'] = 'La password della riunione sarà visualizzata a coloro che non sono host.';
$string['downloadical'] = 'Scaricamento iCal';
$string['downloadical_desc'] = 'Consente di regolare la visualizzazione del link di scaricamento iCal nella pagina introduttiva dell’attività. L\'impostazione regola solamente la possibilità di caricamento del file iCal per l’utilizzo su calendari esterni. Indipendentemente da questa impostazione, l\'attività Zoom sarà inserita nel calendario Moodle non appena verrà impostata una data di inizio della riunione.';
$string['downloadical_disable'] = 'Disabilita link di scaricamento iCal';
$string['downloadical_enable'] = 'Abilita link di scaricamento iCal';
$string['duration'] = 'Durata (minuti)';
$string['encryptiontype'] = 'Tipo di crittografia';
$string['encryptiontype_alwaysshow'] = 'Visualizza sempre l\'impostazione Tipo di crittografia anche se l\'utente non può scegliere';
$string['encryptiontype_desc'] = 'L\'impostazione del tipo di crittografia sarà visualizzata indipendentemente dalla possibilità dell\'utente di scegliere la crittografia end-to-end o la crittografia avanzata. Visualizzando l\'impostazione, l’utente avrà bisogno comunque della crittografia end-to-end in Zoom per abilitare tale tipo di crittografia.';
$string['encryptiontype_disable'] = 'Disabilita selettore del tipo di crittografia';
$string['encryptiontype_showonlyife2epossible'] = 'Abilita selettore del tipo di crittografia solo se l\'utente può utilizzare la crittografia end-to-end';
$string['end_date_option_after'] = 'Dopo';
$string['end_date_option_by'] = 'Di';
$string['end_date_option_occurrences'] = 'eventi';
$string['enddate'] = 'Data di fine';
$string['endtime'] = 'Orario di fine';
$string['err_downloadicaldisabled'] = 'Lo scaricamento dei file iCal della riunione Zoom è stato disabilitato.';
$string['err_downloadicalrecurringempty'] = 'Non è possibile scaricare il file iCal di questa riunione Zoom poiché il file non contiene eventi.';
$string['err_downloadicalrecurringnofixed'] = 'Non è possibile scaricare il file iCal di questa riunione Zoom poiché è un meeting ricorrente senza orario definito.';
$string['err_duration_nonpositive'] = 'La durata deve essere un numero positivo.';
$string['err_duration_too_long'] = 'La durata non deve eccedere le 150 ore.';
$string['err_end_date'] = 'La data di fine della ricorrenza non può trovarsi nel passato.';
$string['err_end_date_before_start'] = 'La data di fine della ricorrenza non può essere antecedente alla data di inizio.';
$string['err_invalid_password'] = 'La password contiene caratteri non validi.';
$string['err_long_timeframe'] = 'Spazio di tempo troppo ampio, vengono visualizzati solo i risultati dell\'ultimo mese.';
$string['err_password'] = 'La password può contenere solo questi caratteri: [a-z A-Z 0-9 @ - _ *]. Max 10 caratteri.';
$string['err_password_required'] = 'La password è obbligatoria.';
$string['err_repeat_monthly_interval'] = 'L\'intervallo massimo delle riunioni mensili è 3 mesi';
$string['err_repeat_weekly_interval'] = 'L\'intervallo massimo delle riunioni settimanali è 3 mesi';
$string['err_start_time_past'] = 'La data di inizio non può essere nel passato.';
$string['err_weekly_days'] = 'Seleziona i giorni del meeting settimanale ricorrente';
$string['erroraddinstance'] = 'Non è stato possibile creare la riunione Zoom. Le impostazioni della riunione ricorrente non sono valide.';
$string['errorwebservice'] = 'Si è verificato un errore nel webservice Zoom: {$a}.';
$string['errorwebservice_badrequest'] = 'Zoom ha ricevuto una richiesta errata: {$a}';
$string['errorwebservice_notfound'] = 'La risorsa non esiste';
$string['export'] = 'Esporta';
$string['externaluser'] = 'Utente esterno';
$string['firstjoin'] = 'Primo partecipante';
$string['firstjoin_desc'] = 'Con quanto anticipo un utente può partecipare al meeting (minuti prima dell\'inizio).';
$string['getmeetingrecordings'] = 'Ricevi da Zoom i report delle riunioni';
$string['getmeetingreports'] = 'Ricevi da Zoom il report della riunione';
$string['globalsettings'] = 'Impostazioni globali';
$string['globalsettings_desc'] = 'Questi impostazioni si applicano a Zoom in modo globale.';
$string['host'] = 'Host';
$string['hostintro'] = 'Gli <a target="_blank" href="https://support.zoom.us/hc/en-us/articles/208220166">Host alternativi</a> possono avviare riunioni Zoom e gestire la sala d\'attesa.';
$string['indicator:cognitivedepth'] = 'Zoom congitivo';
$string['indicator:cognitivedepth_help'] = 'L\'indicatore è basato sulla profondità cognitiva toccata dallo studente svolgendo attività Zoom.';
$string['indicator:socialbreadth'] = 'Zoom sociale';
$string['indicator:socialbreadth_help'] = 'L\'indicatore è basato sulla dimensione sociale raggiunta dallo studente svolgendo attività Zoom.';
$string['invalid_status'] = 'Stato non valido, verificare il database.';
$string['invalidscheduleuser'] = 'Non puoi programmare riunioni per l\'utente specificato.';
$string['invitation_dialin'] = 'Modello del numero di chiamata telefonica';
$string['invitation_dialin_help'] = 'Il modello regex per trovare il numero di chiamata telefonica della riunione Zoom';
$string['invitation_h323'] = 'Modello messaggi H.323';
$string['invitation_h323_help'] = 'Il modello regex per trovare le informazioni H.323 della riunione Zoom. Se l\'invito non contiene elementi SIP o H.323, impostare il modello della regular expression con una stringa vuota. (Si applica specialmente ai server con la modalità debug abilitata in quanto l\'impostazione uò influire sui formati di tipi di file come i file iCal).';
$string['invitation_icallink'] = 'Modello messaggi link iCal';
$string['invitation_icallink_help'] = 'Lo schema regex per trovare il link iCal della riunione Zoom';
$string['invitation_invite'] = 'Modello del messaggio di invito';
$string['invitation_invite_help'] = 'Il modello regex per trovare il messaggio di invito della riunione Zoom';
$string['invitation_joinurl'] = 'Modello dell\'URL di parteciapzione';
$string['invitation_joinurl_help'] = 'Il modello regex per trovare l\'URL della partecipazione della riunione Zoom';
$string['invitation_onetapmobile'] = 'Modello mobile One tap';
$string['invitation_onetapmobile_help'] = 'Il modello regex per trovare i dettagli One Tap della riunione Zoom';
$string['invitation_sip'] = 'Modello SIP';
$string['invitation_sip_help'] = 'Il modello regex per trovare le informazioni SIP della riunione Zoom. Se l\'invito non contiene elementi SIP o H.323, impostare il modello della regular expression con una stringa vuota. (Si applica specialmente ai server con la modalità debug abilitata in quanto l\'impostazione uò influire sui formati di tipi di file come i file iCal).';
$string['invitationmatchnotfound'] = 'Non ci sono corrispondenze nell\'invito Zoom per l\'elemento {$a->element}" con il modello "{$a->pattern}".';
$string['invitationmodificationfailed'] = 'Si è verificato un errore nell\'invito Zoom per l\'elemento {$a->element}" con il modello "{$a->pattern}".';
$string['invitationregex'] = 'Regex e privilegi dell\'invito Zoom';
$string['invitationregex_help'] = 'Imposta il modello regex per islare ciascuna parte dell\'invito Zoom affinché l\'informazione venga controllata dai privilegi.';
$string['invitationregex_nohideif'] = 'Attenzione: il modello regex sarà usato solo se l\'impostazione \'{$a}\'  è abilitata.';
$string['invitationregexenabled'] = 'Abilita regex e privilegi dell\'invito Zoom';
$string['invitationregexenabled_help'] = 'Consente di suddividere l\'invito Zoom visualizzato nella pagina in tanti elementi in base ai seguenti regexp e capacità per decider quali parti visualizzare a ciascun utente. Vedere i privilegi zoom/viewjoinurl e zoom/viewdialin.';
$string['invitationremoveicallink'] = 'Rimuovi link iCal dell\'invito Zoom';
$string['invitationremoveicallink_help'] = 'Il link iCal eventualmente incluso nella mail d invito Zoom sarà rimosso utilizzando il modello regex invitation_icallink.';
$string['invitationremoveinvite'] = 'Rimuovi il messaggio di invito Zoom';
$string['invitationremoveinvite_help'] = 'LA frase introduttiva inlcusa nella mail d invito Zoom sarà rimosso utilizzando il modello regex invitation_invite.';
$string['join'] = 'Partecipa';
$string['join_meeting'] = 'Partecipa alla riunione';
$string['joinbeforehost'] = 'Partecipa alla riunione prima dell\'organizzatore';
$string['joinbeforehostenable'] = 'Consenti di partecipare alla riunione in qualsiasi momento';
$string['joinlink'] = 'Link di partecipazione';
$string['jointime'] = 'Orario d\'ingresso';
$string['leavetime'] = 'Orario d\'uscita';
$string['licenseonjoin'] = 'Selezionare l\'impostazione se si desidera che l\'host riceva una licenza all\'avvio della riunione e alla creazione di riunione';
$string['licensesettings'] = 'Impostazioni licenza';
$string['licensesettings_desc'] = 'Definisce come Moodle gesirà la licenza Zoom.';
$string['licensesnumber'] = 'Numero di licenze';
$string['lowlicenses'] = 'Se il numero delle licenze supera quello necessario, quando un utente crea una nuova attività gli verrà assegnata una licenza PRO abbassando il livello delle licenza di un altro utente. L\'opzione funzione quando il numero di licenze PRO attive è superiore a 5.';
$string['maskparticipantdata'] = 'Nascondi i dati dei partecipanti';
$string['maskparticipantdata_help'] = 'Evita la visualizzazione nei report dei dati  (utile per i siti che mascherano i dati dei partecipanti, per esempio per HIPAA).';
$string['media'] = 'Media';
$string['meeting_finished'] = 'Terminato';
$string['meeting_invite'] = 'Informazioni per la partecipazione telefonica';
$string['meeting_invite_hide'] = 'Nascondi invito alla riunione';
$string['meeting_invite_show'] = 'Visualizza invito alla riunione';
$string['meeting_nonexistent_on_zoom'] = 'Inesistente su Zoom';
$string['meeting_not_started'] = 'Non ancora iniziato';
$string['meeting_started'] = 'In corso';
$string['meeting_time'] = 'Orario d\'inizio';
$string['meetingcapacitywarning'] = 'Avviso sulla capienza del meeting';
$string['meetingcapacitywarning_desc'] = 'Consente di visualizzare un avviso se la capienza della licenza Zoom fosse inferiore al numero di iscritti e di partecipanti attivi al corso. L\'avviso sarà visualizzato all\'host e agli eventuali host alternativi nella pagina introduttiva dell\'attività. L\'avviso consiglierà all\'host di rivolgersi al proprietario dell\'account per ottenere una licenza più capiente. Il messaggio può essere personalizzato tramite l\'interfaccia di personalizzazione della lingua di Moodle.';
$string['meetingcapacitywarning_disable'] = 'Disabilita avviso sulla capienza';
$string['meetingcapacitywarning_enable'] = 'Abilita avviso sulla capienza';
$string['meetingcapacitywarningbodyalthost'] = 'La licenza Zoom dell\'host {$a->hostname} ha una capienza di <strong>{$a->meetingcapacity} partecipanti</strong> ma il corso ha <strong><a href="{$a->courseparticipantsurl}"> iscritti di cui {$a->eligiblemeetingparticipants} attivi.';
$string['meetingcapacitywarningbodyrealhost'] = 'La licenza Zoom ha una capienza di <strong><a href="{$a->zoomprofileurl}" target="_blank">{$a->meetingcapacity} partecipanti</strong> ma il corso ha <strong><a href="{$a->courseparticipantsurl}"> iscritti di cui {$a->eligiblemeetingparticipants} attivi.';
$string['meetingcapacitywarningcontactalthost'] = 'Per favore chiedere all\'host Zoom di utilizzare una licenza Zoom più capiente affinché tutti i partecipanti possano partecipare.';
$string['meetingcapacitywarningcontactrealhost'] = 'Per favore chiedere all\'host Zoom di utilizzare una licenza Zoom più capiente affinché tutti i partecipanti possano partecipare.';
$string['meetingcapacitywarningheading'] = 'A';
$string['modulename'] = 'Riunione Zoom';
$string['modulename_help'] = 'Zoom è una piattaforma video e web che consente agli utenti autorizzati di organizzare un meting.';
$string['modulenameplural'] = 'Riunioni Zoom';
$string['month'] = 'Mesi';
$string['month_day_text'] = 'del mese';
$string['newmeetings'] = 'Nuove riunioni';
$string['nextoccurrence'] = 'Prossima ricorrenza';
$string['nomeetinginstances'] = 'Non sono state trovate sessioni relative a questa riunione.';
$string['nooccurrenceleft'] = 'L\'ultima ricorrenza è già terminata';
$string['noparticipants'] = 'Non è stato trovato nessun partecipante per questa sessione.';
$string['norecordings'] = 'Non è stato trovato nessuna registrazione per questo meeting.';
$string['nosessions'] = 'Non è stata trovata nessuna sessione nell\'intervallo specificato.';
$string['nozooms'] = 'Non ci sono riunioni.';
$string['nozoomsfound'] = 'Non ci sono riunioni nel corso indicato.';
$string['occurson'] = 'Avviene il';
$string['off'] = 'Off';
$string['oldmeetings'] = 'Riunioni svolte';
$string['on'] = 'On';
$string['option_audio'] = 'Opzioni audio';
$string['option_audio_help'] = 'Consente la partecipazione attraverso il telefono, il computer, oppure entrambi.';
$string['option_authenticated_users'] = 'Richiedi autenticazione per partecipare';
$string['option_authenticated_users_help'] = 'I partecipanti dovranno autenticarsi con il proprio account Zoom, anche se sono già autenticati in Moodle.';
$string['option_encryption_type'] = 'Crittografia';
$string['option_encryption_type_endtoendencryption'] = 'Crittografia end-to-end';
$string['option_encryption_type_enhancedencryption'] = 'Crittografia avanzata';
$string['option_encryption_type_help'] = 'L\'impostazione controlla il livello di crittografia e privacy della riunione.
* Crittografia avanzata: la chiave crittografica è memorizzata nel cloud di Zoom
* Crittografia end-to-end: la chiave crittografica è memorizzata è memorizzata localmente nel dispositivo e nessun altro può ottenerla.
Da notare che abilitando la crittografia end-to-end molte funzionalità del meeting non saranno disponibili. Per maggiori informazioni: https://support.zoom.us/hc/en-us/articles/360048660871';
$string['option_host_video'] = 'Avvia video dell\'host';
$string['option_host_video_help'] = 'Il video dell\'host sarà avviato all\'accesso al meeting. Da tenere presente che anche selezionando Off, l\'host potrà comunque avviare il proprio video.';
$string['option_jbh'] = 'Abilita accesso prima dell\'organizzatore';
$string['option_jbh_help'] = 'I partecipanti potranno accedere alla riunione prima dell\'host o in assenza dell\'host. L\'impostazione è mutualmente esclusiva con l\'impostazione \'Sala d\'attesa\', selezionandone una si disabilita l\'altra,';
$string['option_mute_upon_entry'] = 'Microfono dei partecipanti muto all\'accesso';
$string['option_mute_upon_entry_help'] = 'Tutti i partecipanti avranno il microfono muto quando accederanno all riunione. Da tenere presente che i partecipanti potranno comunque attivare il microfono dopo l\'accesso.';
$string['option_participants_video'] = 'Video dei partecipanti';
$string['option_participants_video_help'] = 'Consente di abilitare il video dei partecipanti quando accederanno alla riunione. Da tenere presente che anche selezionando Off, i partecipanti potranno comunque avviare il proprio video.';
$string['option_proxyhost'] = 'Utilizza proxy';
$string['option_proxyhost_desc'] = 'Il proxy impostato come \'<code><hostname>:<port></code>\' è usato solo per le comunicazioni con Zoom. Lasciare vuoto se si vuole utilizzare le impostazioni Proxy di default di Moodle.';
$string['option_view_recordings'] = 'Consenti visualizzazione delle regsitrazioni';
$string['option_waiting_room'] = 'Abilita sala d\'attesa';
$string['option_waiting_room_help'] = 'L\'host avrà la possibilità di regolare l\'accesso dei partecipanti alla riunione. Da notare che l\'impostazione è mutamente esclusiva con l\'impostazione \'Abilita accesso prima dell\'organizzatore\', selezionandone una si disabilita l\'altra,';
$string['participantdatanotavailable'] = 'Dettagli non disponibili';
$string['participantdatanotavailable_help'] = 'I dati del partecipanti non sono disponibili per questa sessione Zoom (per esempio dovuto al protocollo HIPAA).';
$string['participants'] = 'Partecipanti';
$string['password'] = 'Password';
$string['password_allowed_char'] = 'La password può contenere solamente i seguenti caratteri: [a-z A-Z 0-9 @ - _ *].';
$string['password_consecutive'] = 'Numero massimo di {$a} caratteri consecutivi (abcd, 1111, 1234, etc.).';
$string['password_length'] = 'Numero massimo di {$a} caratteri';
$string['password_letter'] = 'La password deve contenere almeno 1 lettera.';
$string['password_lower_upper'] = 'La password deve contenere caratteri sia maiuscoli sia minuscoli.';
$string['password_max_length'] = 'Massimo di 10 caratteri.';
$string['password_number'] = 'La password deve contenere almeno 1 numero.';
$string['password_only_numeric'] = 'La password deve contenere solo numeri.';
$string['password_special'] = 'La password deve contenere almeno 1 carattere speciale (@-_*).';
$string['passwordprotected'] = 'Protetto da password';
$string['pluginadministration'] = 'Gestione riunioni Zoom';
$string['pluginname'] = 'Riunione Zoom';
$string['privacy:metadata:zoom_meeting_details'] = 'Tabella del database che memorizza informazioni su ciascuna istanza di riunioni.';
$string['privacy:metadata:zoom_meeting_details:topic'] = 'Nome della riunione a cui l\'utente ha partecipato.';
$string['privacy:metadata:zoom_meeting_participants'] = 'Tabella del database che memorizza informazioni sui partecipanti alla riunione.';
$string['privacy:metadata:zoom_meeting_participants:duration'] = 'Tempo di partecipazione è rimasto il partecipante alla riunione';
$string['privacy:metadata:zoom_meeting_participants:join_time'] = 'Ora in cui il partecipante è entrato nella riunione';
$string['privacy:metadata:zoom_meeting_participants:leave_time'] = 'Ora in cui il partecipante è uscito dalla riunione';
$string['privacy:metadata:zoom_meeting_participants:name'] = 'Nome del partecipante';
$string['privacy:metadata:zoom_meeting_participants:user_email'] = 'Indirizzo e-mail del partecipante';
$string['recording'] = 'Registrazione';
$string['recordingadd'] = 'Aggiungi registrazione';
$string['recordingdate'] = 'Data di registrazione';
$string['recordingdelete'] = 'Sei sicuro di eliminare la registrazione "{$a}"?';
$string['recordinghide'] = 'Nascondi registrazioni (Al momento sono visibili)';
$string['recordinglink'] = 'Link della registrazione';
$string['recordingname'] = 'Titolo';
$string['recordingnotfound'] = 'Non è stato possibile trovare registrazioni';
$string['recordingnotvisible'] = 'La registrazione non è visibile. Per favore contattare l’amministrato se si ritiene che dovrebbero vedersi,';
$string['recordingpasscode'] = 'Password regitrazione';
$string['recordings'] = 'Registrazioni';
$string['recordingshow'] = 'Visualizza registrazioni (Al momento non sono visibili)';
$string['recordingshowtoggle'] = 'Attiva/disattiva visualizza registrazioni';
$string['recordingurl'] = 'URL delle registrazione';
$string['recordingview'] = 'Visualizza regsitrazione';
$string['recordingvisibility'] = 'Visibilità di default delle registarzioni';
$string['recordingvisibility_help'] = 'Regola il default delle visualizzazione in Moodle delle registrazioni della riunione,';
$string['recreatesuccessful'] = 'La riunione è stata ricreata correttamente';
$string['recurrence_option_daily'] = 'Giornaliero';
$string['recurrence_option_monthly'] = 'Mensile';
$string['recurrence_option_no_time'] = 'Senza orario definito';
$string['recurrence_option_weekly'] = 'Settimanale';
$string['recurrencetype'] = 'Ricorrenza';
$string['recurringmeeting'] = 'Riunione ricorrente';
$string['recurringmeeting_help'] = 'Consente di impostare la riunione senza data o orario di fine. La riunione potrà essere acceduta in qualsiasi momento.';
$string['recurringmeetingexplanation'] = 'La riunione è senza data o orario di fine';
$string['recurringmeetinglong'] = 'Riunione ricorrente (riunione senza data o orario di fine)';
$string['recurringmeetingthisis'] = 'Questa è una riunione ricorrente';
$string['recycleonjoin'] = 'Riutilizza la licenza dopo l\'accesso';
$string['redefinelicenses'] = 'Ridefinisci le licenze';
$string['refreshreports'] = 'Ricarica i report della sessione';
$string['repeatinterval'] = 'Ripeti ogni';
$string['report'] = 'Report';
$string['reportapicalls'] = 'Report delle chiamate API esaurite';
$string['requirepasscode'] = 'Password riunione obbligatoria';
$string['requirepasscode_help'] = 'Gli host dovranno impostare obbligatoriamente la password delle riunione. I partecipanti dovranno  inserire la password per accedere alla riunione. Da notare che i partecipanti che entrano nella riunione direttamente da Moodle, non doveranno inserire la password';
$string['resetapicalls'] = 'Reimposta il numero chiamate API disponibili';
$string['schedule'] = 'Programmazione';
$string['schedulefor'] = 'Programma riunione per';
$string['schedulefor_help'] = 'E\' possibile programmare riunioni per se o in vece di altri. Prerequisito è il possesso di privilegi di programmazione in Zoom. L\'utente selezionato sarà l\'host della riunione e sarà utilizzata la sua licenza Zoom per svolgere la riunione.';
$string['scheduleforself'] = 'Per se';
$string['schedulingprivilege'] = 'Privilegi di programmazione';
$string['schedulingprivilege_desc'] = 'Consente di visualizzare agli utenti l\'impostazione dei privilegi di programmazione. L\'impostazione influenza solamente l\'interfaccia di Moodle, per potre sfruttare i privilegi un utente deve comunque ricevere i privilegi di programmazione da un altro utente Zoom affinché possa creare un meeting in vece dell\'utente.';
$string['schedulingprivilege_disable'] = 'Disabilita privilegi di programmazione';
$string['schedulingprivilege_enable'] = 'Abilita privilegi di programmazione';
$string['search:activity'] = 'Zoom - informazioni attività';
$string['security'] = 'Sicurezza';
$string['sessions'] = 'Sessioni';
$string['sessionsreport'] = 'Report delle sessioni';
$string['sesskeyinvalid'] = 'E\' stata rilevata una sessione non valida, non è possibile proseguire.';
$string['setpasscode'] = 'Imposta password';
$string['start'] = 'Avvia';
$string['start_meeting'] = 'Avvia riunione';
$string['start_time'] = 'Quando';
$string['starthostjoins'] = 'Avvia il video quando accede l\'organizzatore';
$string['startpartjoins'] = 'Avvia il video dopo l\'accesso dei partecipanti';
$string['starttime'] = 'Orario d\'inizio';
$string['status'] = 'Stato';
$string['supplementaryfeaturessettings'] = 'Impostazione funzionalità aggiuntive';
$string['supplementaryfeaturessettings_desc'] = 'Consente di controllare quali impostazioni aggiuntive di Zoom saranno visualizzate agli utenti.';
$string['title'] = 'Titolo';
$string['topic'] = 'Argomento';
$string['trackingfields'] = 'Campi di tracciamento';
$string['trackingfields_help'] = 'Per abilitare le attività Zoom, Inserire nome/etichetta del campo dei campi di tracciamento, sperata da virgola.';
$string['trackingfields_recommendedvalues'] = 'Valori consigliati:';
$string['unavailable'] = 'Al momento non è possibile partecipare.';
$string['unavailablefinished'] = 'La riunione è terminata.';
$string['unavailablefirstjoin'] = 'E\' possibile accedere {$a->mins} minuti prima dell\'inizio.';
$string['unavailablenotstartedyet'] = 'La riunione non è cominciata.';
$string['updatemeetings'] = 'Aggiorna le impostazioni della riunione Zoom';
$string['updatetrackingfields'] = 'Aggiorna campi di tracciamento da Zoom';
$string['usepersonalmeeting'] = 'Utilizza l\'ID della sala riunioni personale {$a}';
$string['waitingroom'] = 'Sala d\'attesa';
$string['waitingroomenable'] = 'Abilita sala d\'attesa';
$string['webinar'] = 'Webinar';
$string['webinar_already_false'] = '<p><b>Questa attività è stata precedentemente impostata come riunione, non come Webinar. Non è possibile cambiare questa impostazione dopo aver creato la riunione.</b></p>';
$string['webinar_already_true'] = '<p><b>Questa attività è stata precedentemente impostata come Webinar, non come riunione. Non è possibile cambiare questa impostazione dopo aver creato il Webinar.</b></p>';
$string['webinar_alwaysshow'] = 'Visualizza sempre le impostazioni del webinar anche se l\'utente non ha la licenza per organizzare webinar';
$string['webinar_desc'] = 'Consente di visualizzare la possibilità di creare webinar. L\'impostazione influenza solamente l\'interfaccia di Moodle, per configurare un webinar l\'utente deve disporre di una licenza Zoom che preveda anche i webinar.';
$string['webinar_disable'] = 'Disabilita webinar';
$string['webinar_help'] = 'I webinar forniscono all\'host strumenti di gestione aggiuntivi particolarmente utili quando si hanno grandi numeri di partecipanti. L\'impostazione è disponibile solo per gli account Zoom pre-autorizzati,';
$string['webinar_showonlyiflicense'] = 'Visualizza le impostazioni del webinar solo se l\'utente ha la licenza per organizzare webinar';
$string['webinarthisis'] = 'Questo è un webianr';
$string['week'] = 'Settimane';
$string['weekoption_first'] = 'Primo';
$string['weekoption_fourth'] = 'Quarto';
$string['weekoption_last'] = 'Ultimo';
$string['weekoption_second'] = 'Secondo';
$string['weekoption_third'] = 'Terzo';
$string['zoom:addinstance'] = 'Aggiungere riunione Zoom';
$string['zoom:eligiblealternativehost'] = 'Essere selezionato come host alternativo';
$string['zoom:refreshsessions'] = 'Ricaricare report delle riunioni zoom';
$string['zoom:view'] = 'Visualizzare riunioni Zoom';
$string['zoom:viewdialin'] = 'Visualizzare informazioni per la partecipazione telefonica';
$string['zoom:viewjoinurl'] = 'Visualizzare l\'URL Zoom di partecipazione';
$string['zoomerr'] = 'Zoom ha riscontrato un errore.';
$string['zoomerr_alternativehostusernotfound'] = 'L\'utente {$a} non è stati trovato su Zoom.';
$string['zoomerr_apilimit'] = 'E\' stato raggiunto il numero massimo di richieste giornaliere alle API. Riprovare tra {$a}';
$string['zoomerr_id_missing'] = 'E\' necessario specificare un course_module ID oppure un ID istanza';
$string['zoomerr_licensesnumber_missing'] = 'Sono state trovate le principali impostazioni di Zoom, ma non il numero della licenza.';
$string['zoomerr_maxretries'] = 'Sono stati effettuati {$a->maxretries} tentativi di chiamata, senza buon fine: {$a->response}';
$string['zoomerr_meetingnotfound'] = 'Questa riunione non è presente su Zoom. È possibile<a href="{$a->recreate}"> ricrearla qui</a> oppure <a href="{$a->delete}">eliminarla completamente</a>.';
$string['zoomerr_meetingnotfound_info'] = 'Questa riunione non è presente su Zoom. Si prega di contattare l\'host della riunione per dubbi o domande.';
$string['zoomerr_usernotfound'] = 'Non è stato possibile trovare il l\'account su Zoom. Se si sta utilizzando Zoom per la prima volta, è necessario attivare il proprio account su <a href="{$a}" target="_blank">{$a}</a>.
Una volta attivato l\'account Zoom, ricaricare la pagina e continuare a impostare la riunione. Verificare inoltre che l\'email in Zoom coincida con quella di Moodle.';
$string['zoomerr_viewrecordings_off'] = 'La visualizzazione delle registrazioni e disabilitata, l\'elaborazione non può essere eseguita';
$string['zoomurl'] = 'URL home page di Zoom';
$string['zoomurl_desc'] = 'L\'URL della home page di Zoom';
