<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'ja', version '4.3'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a11yTitle:label'] = '支援技術ラベル';
$string['acceptTerms'] = '私は<a href=":url" target="_blank">利用規約</a>に同意します。';
$string['accountDetailsLinkText'] = 'ここ';
$string['actions'] = '操作';
$string['add'] = '追加';
$string['addedandupdatedpp'] = '{$a->%new} 件の新しいH5Pライブラリを追加および {$a->%old} 件の古いライブラリを更新しました。';
$string['addedandupdatedps'] = '{$a->%new} 件の新しいH5Pライブラリを追加および {$a->%old} 件の古いライブラリを更新しました。';
$string['addedandupdatedsp'] = '{$a->%new} 件の新しいH5Pライブラリを追加および {$a->%old} 件の古いライブラリを更新しました。';
$string['addedandupdatedss'] = '{$a->%new} 件の新しいH5Pライブラリを追加および {$a->%old} 件の古いライブラリを更新しました。';
$string['addednewlibraries'] = '{$a->%new} 件の新しいH5Pライブラリを追加しました。';
$string['addednewlibrary'] = '{$a->%new} 件の新しいH5Pライブラリを追加しました。';
$string['additionallicenseinfo'] = 'ライセンスに関する追加情報';
$string['address'] = 'アドレス';
$string['age'] = '標準的な年齢';
$string['ageDescription'] = 'このコンテンツの対象者です。入力可能な形式をカンマで区切ってください: 1,34-45,-50,59-';
$string['altText'] = '代替テキスト';
$string['atto_h5p'] = 'H5Pボタンを追加する';
$string['atto_h5p_description'] = 'Attoエディタの「H5Pボタンを追加する」にでユーザはURLの入力、コードの埋め込みまたはH5PファイルのアップロードによるH5Pコンテンツ挿入ができるようになります。';
$string['author'] = '作成者';
$string['authorcomments'] = '作成者コメント';
$string['authorcommentsdescription'] = 'コンテンツ編集者のコメントです (このテキストは著作権情報の一部としては公開されません)。';
$string['authorname'] = '作成者名';
$string['authorrole'] = '作成者ロール';
$string['back'] = '戻る';
$string['by'] = 'by';
$string['cancelCrop'] = '切り取りをキャンセルする';
$string['cancelPublishConfirmationDialogCancelButtonText'] = 'No';
$string['cancelPublishConfirmationDialogConfirmButtonText'] = 'Yes';
$string['cancelPublishConfirmationDialogDescription'] = '本当に共有処理をキャンセルしてもよろしいですか?';
$string['cancelPublishConfirmationDialogTitle'] = '共有をキャンセルする';
$string['cancellabel'] = 'キャンセル';
$string['ccattribution'] = '表示 (CC BY)';
$string['ccattributionnc'] = '表示-非営利 (CC BY-NC)';
$string['ccattributionncnd'] = '表示-非営利-改変禁止 (CC BY-NC-ND)';
$string['ccattributionncsa'] = '表示-非営利-継承 (CC BY-NC-SA)';
$string['ccattributionnd'] = '表示-改変禁止 (CC BY-ND)';
$string['ccattributionsa'] = '表示-継承 (CC BY-SA)';
$string['ccpdd'] = '著作権なし (CC0)';
$string['changeHasBeenSubmitted'] = '次の変更が送信されました:';
$string['changedby'] = '変更';
$string['changedescription'] = '変更説明';
$string['changelog'] = '変更ログ';
$string['changeplaceholder'] = '写真トリミング、テキスト変更等です。';
$string['city'] = '市町村';
$string['close'] = '閉じる';
$string['confirmCrop'] = '切り取りを確認する';
$string['confirmdialogbody'] = 'あなたが続けたい場合、確認してください。この操作は元に戻せません。';
$string['confirmdialogheader'] = '操作確認';
$string['confirmlabel'] = '確認';
$string['connectionLost'] = '接続が切断されました。結果は保存された後、接続復帰時に送信されます。';
$string['connectionReestablished'] = '接続が再確立されました。';
$string['contactPerson'] = '担当者';
$string['contactPersonDescription'] = 'H5Pは発行者が共有するコンテンツに問題がある場合、担当者に連絡します。連絡した方の氏名またはその他の情報は第三者に公開または共有されることはありません。';
$string['contentAvailable'] = 'あなたののコンテンツは通常1営業日以内にHUBで利用可能となります。';
$string['contentCopied'] = 'コンテンツがクリップボードにコピーされます。';
$string['contentLicenseTitle'] = 'コンテンツライセンス情報';
$string['contentUpdateSoon'] = 'あなたのコンテンツはまもなく更新されます。';
$string['contentchanged'] = 'あなたが前回使用して以来、このコンテンツは変更されています。';
$string['contentinuse'] = 'このコンテンツは他の場所でも使用されている可能性があります。';
$string['contenttype'] = 'コンテンツタイプ';
$string['copyright'] = '使用権';
$string['copyrightWarning'] = '著作権で保護されたコンテンツはH5Pコンテンツハブで共有できません。コンテンツがクリエイティブコモンズのようなOERフレンドリなライセンスで提供されている場合、適切なライセンスを選択してください。そうでない場合、このコンテンツは共有できません。';
$string['copyrightinfo'] = '著作権情報';
$string['copyrightstring'] = '著作権';
$string['copyrighttitle'] = 'このコンテンツの著作権情報を表示します。';
$string['couldNotParseJSONFromZip'] = 'パッケージからのJSONを構文解析できません: {$a->%fileName}';
$string['couldNotReadFileFromZip'] = 'パッケージからのファイルを読み込めません: {$a->%fileName}';
$string['country'] = '国';
$string['creativecommons'] = 'クリエイティブ・コモンズ';
$string['cropImage'] = '画像を切り取る';
$string['currentStep'] = 'ステップ :step / :total';
$string['date'] = '日付';
$string['deletelibraryconfirm'] = '<p>本当にライブラリ「 {$a->name} 」からバージョン「 {$a->version} 」を削除してもよろしいですか? ライブラリおよびすべての使用が削除されます。</p><p>この処理は元に戻せません。</p>';
$string['deletelibraryversion'] = 'バージョンを削除する';
$string['deleting'] = 'ライブラリを削除する';
$string['description'] = '説明';
$string['disablefullscreen'] = 'フルスクリーンを無効にする';
$string['discipline:dropdownButton'] = 'ドロップダウンボタン';
$string['discipline:in'] = '-';
$string['discipline:searchPlaceholder'] = '領域を検索するために入力する';
$string['disciplineDescription'] = 'あなたは複数領域を選択きます。';
$string['disciplineLabel'] = '領域';
$string['disciplineLimitReachedMessage'] = 'あなたは最大 :numDisciplines 件の領域を設定できます。';
$string['disciplines'] = '領域';
$string['download'] = 'ダウンロード';
$string['downloadtitle'] = 'このコンテンツをH5Pファイルとしてダウンロードします。';
$string['editInfoTitle'] = '<strong>:title</strong> の情報を編集する';
$string['editcontent'] = 'H5Pコンテンツを編集する';
$string['editingFailed'] = '編集に失敗しました。';
$string['editor'] = 'エディタ';
$string['emailAddress'] = 'メールアドレス';
$string['emailAddressDescription'] = 'このメールアドレスはコンテンツに問題が発生した場合、または発行者がアカウントを回復する必要がある場合にH5Pが発行者に連絡する際に使用されます。このメールアドレスは第三者に公開または共有されることはありません。';
$string['embed'] = '埋め込み';
$string['embedtitle'] = 'このコンテンツの埋め込みコードを表示します。';
$string['error:emptycontentid'] = '指定されたURLが正しくないか、あなたはこのファイルを編集できません。';
$string['eventh5pdeleted'] = 'H5Pが削除されました。';
$string['eventh5pviewed'] = 'H5Pコンテンツが閲覧されました。';
$string['feature'] = '機能';
$string['fetchtypesfailure'] = '利用可能なH5Pコンテンツで取得できる情報はありません。H5Pリポジトリへの接続に失敗しました。';
$string['fileExceedsMaxSize'] = 'パッケージ内ファイルの1つが許可される最大ファイルサイズを超えました。 ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'H5Pフィルタを表示する';
$string['filter_displayh5p_description'] = '「H5Pフィルタを表示する」フィルタはURLを埋め込みH5Pコンテンツに変換します。';
$string['fullscreen'] = 'フルスクリーン';
$string['gpl'] = '一般公衆利用許諾書 v3';
$string['h5p'] = 'H5P';
$string['h5pcustomcss'] = 'カスタムCSS';
$string['h5pcustomcss_help'] = 'H5Pコンテンツに適用するCSSです。';
$string['h5peditor'] = 'H5Pエディタ';
$string['h5pfilenotfound'] = 'H5Pファイルが見つかりませんでした。';
$string['h5pinvalidurl'] = '無効なH5PコンテンツURLです。';
$string['h5plibraryhandler'] = 'H5Pフレームワークハンドラ';
$string['h5plibraryhandler_help'] = 'H5Pコンテンツの表示に使用されるH5Pフレームワークです。最新バージョンをお勧めします。';
$string['h5pmanage'] = 'H5Pコンテンツタイプを管理する';
$string['h5poverview'] = 'H5P概要';
$string['h5ppackage'] = 'H5Pコンテンツタイプ';
$string['h5ppackage_help'] = 'H5Pコンテンツタイプはコンテンツを表示するために必要なライブラリすべてを含むH5P拡張子またはZIP拡張子のファイルです。';
$string['h5pprivatefile'] = 'あなたは.h5pファイルにアクセスできないため、このH5Pコンテンツを表示できません。';
$string['h5psettings'] = 'H5P設定';
$string['h5ptitle'] = 'さらにコンテンツを確認するにはH5P.orgにアクセスしてください。';
$string['height'] = '高さ';
$string['helpChoosingLicense'] = 'ライセンス選択補助';
$string['hideadvanced'] = '拡張要素を隠す';
$string['icon'] = 'アイコン';
$string['iconDescription'] = '640 x 480pxです。選択されていない場合、コンテンツはカテゴリアイコンを使用します。';
$string['installedcontentlibraries'] = 'インストール済みH5Pライブラリ';
$string['installedcontenttypes'] = 'インストール済みH5Pコンテンツタイプ';
$string['installedh5p'] = 'インストール済みH5P';
$string['invalidAge'] = '典型的な年齢の入力形式が無効です。カンマ区切りで入力可能な形式は次のとおりです: 1, 34-45, -50, -59-';
$string['invalidcontextid'] = 'H5Pファイルが見つかりませんでした (無効なcontextid)。';
$string['invalidfile'] = 'ファイル「 {$a->%filename} 」は許可されていません。次の拡張子のファイルのみ許可されます: {$a->%files-allowed}';
$string['invalidlanguagefile'] = 'ライブラリ {$a->%library} の言語ファイル {$a->%file} が有効ではありません。';
$string['invalidlanguagefile2'] = '無効な言語ファイル {$a->%languageFile} がライブラリ {$a->%name} にインクルードされました。';
$string['invalidlibrarydata'] = '{$a->%library} の {$a->%property} に無効なデータが提供されました。';
$string['invalidlibrarydataboolean'] = '{$a->%library} の {$a->%property} に無効なデータが提供されました。ブール値を指定してください。';
$string['invalidlibraryname'] = '無効なライブラリ名: {$a->%name}';
$string['invalidlibrarynamed'] = 'コンテンツで使用されているH5Pライブラリ {$a->%library} が有効ではありません。';
$string['invalidlibraryoption'] = '{$a->%library} の オプション {$a->%option} が不正です。';
$string['invalidlibraryproperty'] = '{$a->%library} のプロパティ {$a->%property} を読み込めません。';
$string['invalidmainjson'] = '有効なメインh5p.jsonファイルがありません。';
$string['invalidmultiselectoption'] = 'multi-selectで選択されたオプションが無効です。';
$string['invalidpackage'] = '無効なH5Pコンテンツタイプです。';
$string['invalidselectoption'] = 'selectで選択されたオプションが無効です。';
$string['invalidsemanticsjson'] = 'ライブラリ {$a->%name} に無効なsemantics.jsonファイルがインクルードされています。';
$string['invalidsemanticstype'] = 'H5P内部エラー: セマンティクスの不明なコンテンツタイプ「 {$a->@type} 」です。コンテンツを削除します!';
$string['invalidstring'] = 'セマンティクスのregexpによれば提供されたストリングが有効ではありません。(値: "{$a->%value}", regexp: "{$a->%regexp}")';
$string['isNowSubmitted'] = 'H5Pハブに送信中';
$string['keywordExists'] = 'キーワードがすでに存在します!';
$string['keywords'] = 'キーワード';
$string['keywordsDescription'] = 'あなたはカンマ区切りで複数のキーワードを追加できます。キーワードを確定するには「Enter」または「追加」を押してください。';
$string['keywordsExits'] = 'キーワードがすでに存在します!';
$string['keywordsPlaceholder'] = 'キーワードを追加する';
$string['language'] = '言語';
$string['level'] = 'レベル';
$string['librariesmanagerdescription'] = '<p>H5Pでは特定の範囲のコンテンツタイプでユーザがインタラクティブなコンテンツを作成できるようにします。</p>
<p>信頼できるH5Pコンテンツタイプのみがあなたのサイトで使用されるようにするには以下のいずれかが必要です:</p>
<ul>
<li>h5p.orgからH5Pコンテンツタイプをアップロードする</li>
<li>スケジュールタスク「利用可能なH5Pコンテンツをh5p.orgからダウンロードする」を有効にする</li>
</ul>
<p>ユーザはあなたのサイトにインストールされたH5Pコンテンツタイプのみ利用できることに留意してください。</p>';
$string['librarydirectoryerror'] = 'ライブラリディレクトリ名はmachineNameまたはmachineName-majorVersion.minorVersion (library.jsonから) に合致する必要があります。(ディレクトリ: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['license'] = 'ライセンス';
$string['licenseCC010'] = 'CC0 1.0 全世界 (CC0 1.0) パブリックドメイン提供';
$string['licenseCC010U'] = 'CC0 1.0 全世界';
$string['licenseCC10'] = '1.0 一般';
$string['licenseCC20'] = '２.0 一般';
$string['licenseCC25'] = '2.5 一般';
$string['licenseCC30'] = '3.0 非移植';
$string['licenseCC40'] = '4.0 国際';
$string['licenseDescription'] = 'あなたのコンテンツのライセンスを選択してください。';
$string['licenseDetails'] = 'ライセンス詳細';
$string['licenseDialogDescription'] = '特定のライセンスをクリックした場合、正しい使用方法に関する情報が表示されます。';
$string['licenseGPL'] = '一般公衆利用許諾書';
$string['licenseV1'] = 'バージョン 1';
$string['licenseV2'] = 'バージョン 2';
$string['licenseV3'] = 'バージョン 3';
$string['licenseVersionDescription'] = 'ライセンスバージョンを選択する';
$string['licensee'] = 'ライセンス';
$string['licenseextras'] = '追加ライセンス';
$string['licenseversion'] = 'ライセンスバージョン';
$string['lockh5pdeploy'] = 'このH5Pコンテンツは展開中のためアクセスできません。後ほど再度お試しください。';
$string['logoUploadText'] = '組織のロゴまたはアバタ';
$string['longDescription'] = '長い説明';
$string['longDescriptionPlaceholder'] = 'あなたのコンテンツの長い説明です。';
$string['mainTitle'] = '<strong>:title</strong> 共有';
$string['mainlibrarydisabled'] = 'コンテンツタイプが無効にされているため、このファイルは表示できません。コンテンツタイプを有効にするにはあなたの管理者にご連絡ください。';
$string['maxLength'] = ':length は最大文字数です。';
$string['missingcontentfolder'] = '有効なコンテンツフォルダがありません。';
$string['missingcoreversion'] = '最新バージョンのH5Pプラグインを必要とするため、システムはパッケージから {$a->%component} コンポーネントをインストールできませんでした。現在、このサイトではバージョン {$a->%current} が実行されています。必須バージョンは {$a->%required} またはそれ以上です。アップグレード後の再試行をご検討ください。';
$string['missingdependency'] = '{$a->@lib} で必要な依存関係 {$a->@dep} がありません。';
$string['missinglibrary'] = '必要なライブラリ {$a->@library} がありません。';
$string['missinglibraryfile'] = 'ファイル「 {$a->%file} 」がライブラリにありません: {$a->%name}';
$string['missinglibraryjson'] = 'ライブラリ {$a->%name} に対して有効なJSONフォーマットのlibrary.jsonファイルが見つかりませんでした。';
$string['missinglibraryproperty'] = '{$a->%library} の必須プロパティ {$a->%property} がありません。';
$string['missingmainlibrary'] = 'メインライブラリ {$a->@library} がありません。';
$string['missingmbstring'] = 'PHP拡張モジュールmbstringが読み込まれていません。これはH5Pを正常に機能させるために必要です。';
$string['missinguploadpermissions'] = 'アップロードしたファイル内にライブラリが存在する可能性はありますが、あなたには新しいライブラリのアップロードが許可されていないことに留意してください。あなたのサイト管理者にご連絡ください。';
$string['next'] = '次へ';
$string['nocopyright'] = 'このコンテンツに利用できる著作権情報はありません。';
$string['noextension'] = 'あなたがアップロードしたファイルは有効なHTML5パッケージではありません (.h5pファイル拡張子がありません)。';
$string['noh5plibhandlerdefined'] = 'インストールされているH5Pフレームハンドラはありません。そのため、H5Pコンテンツを表示できません。';
$string['nojson'] = 'メインのh5p.jsonファイルが有効ではありません。';
$string['nopermissiontodeploy'] = 'H5Pコンテンツを配置するために必要なケイパビリティのないユーザがアップロードしたため、このファイルは表示できません。';
$string['nopermissiontoedit'] = 'あなたにはH5Pコンテンツを編集するためのパーミッションがありません。';
$string['notrustablefile'] = 'H5Pコンテンツタイプを更新できるケイパビリティのないユーザがアップロードしたため、このファイルは表示できません。コンテンツタイプのインストールを依頼するにはあなたの管理者にご連絡ください。';
$string['nounzip'] = 'あなたがアップロードしたファイルは有効なHTML5パッケージではありません (ファイルを展開できません)。';
$string['offlineDialogBody'] = '私たちはこのタスクのあなたの完了に関する情報を送信できませんでした。あなたのインターネット接続を確認してください。';
$string['offlineDialogHeader'] = 'あなたのサーバへの接続が切断されました。';
$string['offlineDialogRetryButtonLabel'] = '今すぐリトライする';
$string['offlineDialogRetryMessage'] = 'リトライ :num....';
$string['offlineSuccessfulSubmit'] = '結果を正常に送信しました。';
$string['optionalInfo'] = 'オプション情報';
$string['originator'] = 'オーガナイザ';
$string['pd'] = 'パブリックドメイン';
$string['pddl'] = 'パブリックドメインの献呈およびライセンス';
$string['pdm'] = 'パブリックドメインマーク (PDM)';
$string['phone'] = '電話';
$string['pleaseWait'] = 'お待ちください ...';
$string['pluginname'] = 'H5Pパッケージ';
$string['privacy:metadata'] = 'H5Pサブシステムはいかなる個人データも保存しません。';
$string['publisherDescription'] = '発行者説明';
$string['publisherDescriptionText'] = 'これは共有コンテンツの「発行者情報」に表示されます。';
$string['publisherFieldDescription'] = 'これは共有コンテンツに「発行者名」として表示されます。';
$string['publisherFieldTitle'] = '発行者';
$string['registerOnHub'] = 'H5Pハブに登録する';
$string['registrationFailed'] = 'エラーが発生しました。';
$string['registrationFailedDescription'] = 'この時点で私たちはアカウントを作成できませんでした。何か問題が発生したようです。後でもう一度お試しください。';
$string['registrationTitle'] = 'H5Pハブ登録';
$string['remove'] = '削除';
$string['removeChip'] = 'リストから :chip を削除する';
$string['removeImage'] = '画像を削除する';
$string['requiredInfo'] = '必須情報';
$string['resizescript'] = '埋め込みコンテンツを動的にサイズ変更したい場合、あなたのウェブサイトにこのスクリプトを組み込んでください:';
$string['resubmitScores'] = '保存された結果の送信を試みます。';
$string['reuse'] = '再利用';
$string['reuseContent'] = 'コンテンツを再利用する';
$string['reuseDescription'] = 'このコンテンツを再利用します。';
$string['reviewAndSave'] = 'レビュ & 保存';
$string['reviewAndShare'] = 'レビュ & 共有';
$string['reviewInfo'] = '情報レビュ';
$string['reviewMessage'] = 'あなたが共有する前に以下の情報をレビュしてください。';
$string['rotateLeft'] = '左に回転する';
$string['rotateRight'] = '右に回転する';
$string['saveChanges'] = '変更を保存する';
$string['screenshots'] = 'スクリーンショット';
$string['screenshotsDescription'] = 'あなたのコンテンツのスクリーンショットを最大5枚まで追加できます。';
$string['share'] = '共有';
$string['shareFailed'] = '共有に失敗しました。';
$string['shareTryAgain'] = '何か問題が発生したようです。もう一度共有してください。';
$string['shared'] = '共有済み';
$string['sharingNote'] = 'すべてのコンテンツ詳細は共有後に編集できます。';
$string['shortDescription'] = '短い説明';
$string['shortDescriptionPlaceholder'] = 'あなたのコンテンツの短い説明です。';
$string['showadvanced'] = '拡張要素を表示する';
$string['showless'] = '表示を減らす';
$string['showmore'] = 'さらに表示する';
$string['size'] = 'サイズ';
$string['someKeywordsExits'] = 'これらのキーワードの一部はすでに存在しています。';
$string['source'] = 'ソース';
$string['startingover'] = 'あなたは再開します。';
$string['status'] = 'ステータス';
$string['subContentWarning'] = 'サブコンテンツ (画像、問題等) はオーサリングツールで特に指定がない限り、:license の下で共有されます。';
$string['sublevel'] = 'サブレベル';
$string['submitted'] = '送信されました!';
$string['successfullyRegistred'] = 'あなたはH5Pハブにアカウントを正常に登録しました。';
$string['successfullyRegistredDescription'] = 'あなたのアカウント詳細を変更できます。';
$string['successfullyUpdated'] = 'あなたのH5Pハブアカウント設定が正常に変更されました。';
$string['task_h5p'] = 'H5Pスケジュールタスク';
$string['task_h5p_description'] = 'h5p.orgから利用可能なH5PコンテンツをダウンロードするためのH5Pスケジュールタスクです。';
$string['thumbnail'] = 'サムネイル';
$string['title'] = 'タイトル';
$string['undisclosed'] = '未公開';
$string['unpackedFilesExceedsMaxSize'] = '展開されたファイルの合計サイズが許可される最大サイズを超えました。 ({$a->%used} > {$a->%max})';
$string['updateRegistrationOnHub'] = 'アカウント設定を保存する';
$string['updatedlibraries'] = '{$a->%old} H5Pライブラリを更新しました。';
$string['updatedlibrary'] = '{$a->%old} H5Pライブラリを更新しました。';
$string['uploadlibraries'] = 'H5Pコンテンツタイプをアップロードする';
$string['uploadsuccess'] = 'H5Pコンテンツが正常にアップロードされました。';
$string['width'] = '幅';
$string['wrongversion'] = 'このコンテンツで使用されているH5Pライブラリ {$a->%machineName} のバージョンが有効ではありません。コンテンツに {$a->%contentLibrary} が含まれていますが、{$a->%semanticsLibrary} である必要があります。';
$string['year'] = '年';
$string['years'] = '年';
$string['yearsfrom'] = '年 (from)';
$string['yearsto'] = '年 (to)';
$string['zip'] = 'Zip';
