<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'sv', version '4.3'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Åtgärd';
$string['actionsmenu'] = 'Åtgärdsmeny';
$string['add'] = 'Ny post';
$string['addcomment'] = 'Lägg till kommentarer';
$string['addentries'] = 'Lägg till poster';
$string['addtemplate'] = 'Lägg till en mall för poster';
$string['advancedsearch'] = 'Avancerad sökning';
$string['allowcomments'] = 'Tillåt kommentarer för poster';
$string['alttext'] = 'Alternativ text';
$string['approvalstatus'] = 'Godkännandestatus';
$string['approve'] = 'Godkänn';
$string['approved'] = 'Godkänd';
$string['areacontent'] = 'Fält';
$string['ascending'] = 'Stigande';
$string['asearchtemplate'] = 'Avancerad sökmall';
$string['atmaxentry'] = 'Du har lagt till det maximala antal tillåtna poster!';
$string['authorfirstname'] = 'Författarens förnamn';
$string['authorlastname'] = 'Författarens efternamn';
$string['autogenallforms'] = 'Skapa alla standardmallar';
$string['autolinkurl'] = 'Autolänk till URLen';
$string['availablefromdate'] = 'Tillgänglig fr.o.m.';
$string['availabletags'] = 'Tillgängliga etiketter';
$string['availabletags_help'] = '<p align="center"><strong>Tillgängliga etiketter</strong></p>
<p>Etiketter är platshållare i mallen som kommer att ersättas av fält eller knappar när poster redigeras eller visas.</p>
<p>Fält har följande format: [[fieldname]]</p>
<p>Knappar har följande format: ##somebutton##</p>
<p>Endast de etiketter som finns in listan "Tillgängliga etiketter" kan användas för den aktuella mallen.</p>';
$string['availabletodate'] = 'Tillgänglig t.o.m.';
$string['availabletodatevalidation'] = 'Tillgänglig till-datum kan inte vara före tillgänglig-från datum.';
$string['blank'] = 'Tom';
$string['buttons'] = 'Åtgärder';
$string['bynameondate'] = 'av {$a->name} - {$a->date}';
$string['calendarend'] = '{$a} stänger';
$string['calendarstart'] = '{$a} öppnar';
$string['cancel'] = 'Avbryt';
$string['cannotaccesspresentsother'] = 'Du har inte behörighet att läsa andra användares förinställningar';
$string['cannotadd'] = 'Det går inte att lägga till poster';
$string['cannotdeletepreset'] = 'Fel vid borttagning av förinställning!';
$string['cannotoverwritepreset'] = 'Fel vid överskrivning av förinställning';
$string['cannotunziptopreset'] = 'Det går inte att packa upp till den förinställda katalogen';
$string['checkbox'] = 'Kryssruta';
$string['chooseexportfields'] = 'Välj de fält du vill exportera';
$string['chooseexportformat'] = 'Välj det format du vill exportera till';
$string['chooseorupload'] = 'Välj en fil';
$string['closebeforeopen'] = 'Du har angivit ett slutdatum som ligger innan startdatum.';
$string['columns'] = 'Kolumner';
$string['comment'] = 'Kommentar';
$string['commentdeleted'] = 'Kommentaren har tagits bort';
$string['commentempty'] = 'Kommentaren var tom';
$string['comments'] = 'Kommentarer';
$string['commentsaved'] = 'Kommentaren har sparats';
$string['commentsn'] = '{$a} kommentarer';
$string['commentsoff'] = 'Kommentarsfunktionen är inaktiverad';
$string['completiondetail:entries'] = 'Skapa poster: {$a}';
$string['completionentries'] = 'Kräv poster';
$string['completionentriescount'] = 'Antal poster';
$string['completionentriesdesc'] = 'Minsta antal poster som krävs: {$a}';
$string['configenablerssfeeds'] = 'Denna inställningen aktiverar möjligheten för RSS-flöden för alla databaser. Du kommer fortfarande att behöva aktivera flöden manuellt i inställningarna för varje databas.';
$string['confirmdeletefield'] = 'Du håller på att ta bort det här fältet, är du säker?';
$string['confirmdeleterecord'] = 'Är du säker på att du vill ta bort den här posten?';
$string['confirmdeleterecords'] = 'Är du säker på att du vill ta bort dessa poster?';
$string['createfields'] = 'Skapa egna fält för att samla in data, eller använd en förinställning som redan innehåller fält.';
$string['csstemplate'] = 'CSS-mall';
$string['csvfailed'] = 'Det går inte att läsa rådata från CSV-filen';
$string['csvfile'] = 'CVS-fil';
$string['csvimport'] = 'Import av CVS-fil';
$string['csvimport_help'] = 'Poster kan importeras via en vanlig textfil innehållandes en lista med fältnamn som första rad, sedan data, med en post per rad.';
$string['csvwithselecteddelimiter'] = '<abbr title="Kommaseparerade värden">CSV</abbr>';
$string['data:addinstance'] = 'Lägg till en ny databas';
$string['data:approve'] = 'Godkänn och ångra godkända poster';
$string['data:comment'] = 'Skriv kommentar';
$string['data:exportallentries'] = 'Exportera alla poster';
$string['data:exportentry'] = 'Exportera databaspost';
$string['data:exportownentry'] = 'Exportera egna databasposter';
$string['data:exportuserinfo'] = 'Exportera information om användare';
$string['data:managecomments'] = 'Hantera kommentarer';
$string['data:manageentries'] = 'Hantera poster';
$string['data:managetemplates'] = 'Hantera mallar';
$string['data:manageuserpresets'] = 'Hantera förinställningar för mallar';
$string['data:rate'] = 'Betygssätt poster';
$string['data:readentry'] = 'Läs poster';
$string['data:view'] = 'Visa databasaktivitet';
$string['data:viewallratings'] = 'Visa alla \'råa\' bedömningar från enskilda';
$string['data:viewalluserpresets'] = 'Visa förinställda från alla användare';
$string['data:viewanyrating'] = 'Visa de sammanlagda bedömningar som någon har fått';
$string['data:viewentry'] = 'Visa poster';
$string['data:viewrating'] = 'Visa de sammanlagda bedömningar som du har fått';
$string['data:writeentry'] = 'Skriv post';
$string['date'] = 'Datum';
$string['dateentered'] = 'Datum';
$string['defaultfielddelimiter'] = '(standard är kommatecknet)';
$string['defaultfieldenclosure'] = '(standard är ingen)';
$string['defaultsortfield'] = 'Standardfält vid sortering';
$string['delcheck'] = 'Kryssruta för massborttagning';
$string['delete'] = 'Ta bort';
$string['deleteallentries'] = 'Ta bort alla poster';
$string['deletecomment'] = 'Är du säker på att du vill ta bort den här kommentaren?';
$string['deleteconfirm'] = 'Ta bort förinställning <strong>{$a}</strong>?';
$string['deleted'] = 'borttagen';
$string['deleteentry'] = 'Ta bort post';
$string['deletefield'] = 'Ta bort fält';
$string['deletenotenrolled'] = 'Ta bort poster som kommer från användare som inte är registrerade';
$string['deletewarning'] = 'Är du säker på att du vill ta bort den här förinställningen?';
$string['descending'] = 'Fallande';
$string['directorynotapreset'] = '{$a->directory} Inte en förinställning: saknade filer: {$a->missing_files}';
$string['disapprove'] = 'Ångra godkännande';
$string['download'] = 'Ladda ner';
$string['edit'] = 'Redigera';
$string['editcomment'] = 'Redigera kommentar';
$string['editentry'] = 'Redigera poster';
$string['editfield'] = 'Redigera fält';
$string['editordisable'] = 'Inaktivera redigerare';
$string['editorenable'] = 'Aktivera redigerare';
$string['editpreset'] = 'Redigera förinställning';
$string['emptyadd'] = 'Mallen <em>Lägg till</em> är tom - skapar ett standardformulär...';
$string['emptyaddform'] = 'Du fyllde inte i några fält!';
$string['enabletemplateeditorcheck'] = 'Är du säker på att du vill aktivera redigeraren? Detta kan resultera i att innehållet ändras då mallen sparas.';
$string['entries'] = 'Poster';
$string['entrieslefttoadd'] = 'Du måste lägga till {$a->entriesleft} fler poster för att slutföra den här aktiviteten.';
$string['entrieslefttoaddtoview'] = 'Du måste lägga till {$a->entrieslefttoview} fler poster innan du kan få se de andra deltagarnas poster.';
$string['entry'] = 'Post';
$string['entrysaved'] = 'Posten har sparats';
$string['errormustbeteacher'] = 'Du måste vara lärare för att få använda den här sidan!';
$string['errormustsupplyvalue'] = 'Du måste fylla i ett värde här.';
$string['errorpresetexists'] = 'Det finns redan en förinställning med det namnet';
$string['errorpresetexistsbutnotoverwrite'] = 'Det finns redan en förinställning med detta namn. Välj ett annat namn.';
$string['eventfieldcreated'] = 'Fält skapat';
$string['eventfielddeleted'] = 'Fält borttaget';
$string['eventfieldupdated'] = 'Fält uppdaterat';
$string['eventrecordcreated'] = 'Post skapad';
$string['eventrecorddeleted'] = 'Post borttagen';
$string['eventrecordupdated'] = 'Post uppdaterad';
$string['eventtemplateupdated'] = 'Mall uppdaterad';
$string['eventtemplateviewed'] = 'Mall visad';
$string['example'] = 'Exempel för modulen databas';
$string['excel'] = 'Excel';
$string['expired'] = 'Den här aktiviteten stängdes tyvärr den {$a} och är inte längre tillgänglig.';
$string['export'] = 'Exportera';
$string['exportaszip'] = 'Exportera som ZIP';
$string['exportaszip_help'] = 'Med funktionen <em>Exportera som ZIP</em> kan du spara mallarna och fälten som en förinställning för nedladdning. ZIP-filen kan sedan importeras till en annan kurs.';
$string['exportedtozip'] = 'Exporterade som tillfällig zip...';
$string['exportentries'] = 'Exportera poster';
$string['exportformat'] = 'Exportformat';
$string['exportoptions'] = 'Exportalternativ';
$string['exportownentries'] = 'Exportera endast egna poster?
({$a->mine}/{$a->all})';
$string['exportpreset'] = 'Förinställningar för export';
$string['failedpresetdelete'] = 'Fel i samband med att en förinställning skulle tas bort';
$string['fieldadded'] = 'Fält tillagt';
$string['fieldallowautolink'] = 'Tillåt autolänk';
$string['fielddeleted'] = 'Fält borttaget';
$string['fielddelimiter'] = 'Fältavgränsare';
$string['fielddescription'] = 'Beskrivning av fält';
$string['fieldenclosure'] = 'Fältinramning';
$string['fieldheight'] = 'Höjd';
$string['fieldheightlistview'] = 'Höjd vid visning av lista';
$string['fieldheightsingleview'] = 'Höjd vid visning av ett enskild post';
$string['fieldids'] = 'Id för fält';
$string['fieldmappings'] = 'Fältmappning';
$string['fieldmappings_help'] = 'Med den här menyn kan du behålla data från den befintliga databasen. Om du vill bevara data i ett fält måste du mappa det till ett nytt fält, där data ska visas. Alla fält kan också lämnas tomma, utan att någon information kopieras till dem. Alla gamla fält som inte mappas till ett nytt kommer att gå förlorade och alla dess data tas bort.
Du kan bara mappa fält av samma typ, så varje listruta har olika fält i sig. Du måste också vara försiktig så att du inte försöker mappa ett gammalt fält till mer än ett nytt fält.';
$string['fieldname'] = 'Fältnamn';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'Följande fält i din fil saknas i den här databasen:{$a}';
$string['fieldoptions'] = 'Alternativ (ett per rad)';
$string['fields'] = 'Fält';
$string['fieldsnavigation'] = 'Övergripande fältnavigering';
$string['fieldupdated'] = 'Fält uppdaterat';
$string['fieldwidth'] = 'Bredd';
$string['fieldwidthlistview'] = 'Bredd vid visning av lista';
$string['fieldwidthsingleview'] = 'Bredd vid visning av enskild post';
$string['file'] = 'Fil';
$string['fileencoding'] = 'Teckenkodning';
$string['filesnotgenerated'] = 'Inte alla filer kunde skapas: {$a}';
$string['filtername'] = 'Auto-länkning av databas';
$string['footer'] = 'Sidfot';
$string['forcelinkname'] = 'Framtvingat länknamn';
$string['foundnorecords'] = 'Inga poster funna (<a href="{$a->reseturl}">Återställ filter</a>)';
$string['foundrecords'] = 'Funna poster: {$a->num}/{$a->max} (<a href="{$a->reseturl}">Återställ filter</a>)';
$string['fromfile'] = 'Importera från ZIP';
$string['fromfile_help'] = 'Importera från zip-filen gör att du kan leta efter och ladda upp en förinställd zip-fil av mallar och fält.';
$string['generateerror'] = 'Inte alla filer kunde skapas!';
$string['header'] = 'Sidhuvud';
$string['headeraddtemplate'] = 'Definierar det gränssnitt som ska användas för att lägga till och redigera poster';
$string['headerasearchtemplate'] = 'Definierar gränssnittet för avancerad sökning';
$string['headercsstemplate'] = 'Definierar de lokala CSS-stilarna för de andra mallarna';
$string['headerjstemplate'] = 'Definierar anpassat JavaScript för att hantera hur element visas i Listan, Enskild eller Lägg till mallar';
$string['headerlisttemplate'] = 'Definierar gränssnittet för att bläddra genom flera poster';
$string['headerrsstemplate'] = 'Definierar hur poster presenteras i RSS-flöden';
$string['headersingletemplate'] = 'Definierar gränssnittet för att bläddra genom enskilda poster';
$string['id'] = 'Post-ID';
$string['importentries'] = 'Importera poster';
$string['importpreset'] = 'Importera förinställningar';
$string['importsuccess'] = 'Förinställningen har tillämpats.';
$string['includeapproval'] = 'Inkludera godkännandestatus';
$string['includetags'] = 'Inkludera etiketter';
$string['includetime'] = 'Inkludera tidpunkt för tillagd/ändrad';
$string['includeuserdetails'] = 'Inkludera användardetaljer';
$string['indicator:cognitivedepth'] = 'Databas kognitiv';
$string['indicator:cognitivedepth_help'] = 'Denna indikator baseras på det kognitiva djup som uppnåtts av studenten i en Databasaktivitet.';
$string['indicator:cognitivedepthdef'] = 'Databas kognitiv';
$string['indicator:cognitivedepthdef_help'] = 'Deltagaren har nått denna procentandel av det kognitiva engagemang som erbjuds av Databas-aktiviteterna under detta analysintervall (Nivåer = Ingen visning, Visa, Skicka in)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Databas social';
$string['indicator:socialbreadth_help'] = 'Denna indikator baseras på den sociala bredd som uppnåtts av studenten i en Databasaktivitet.';
$string['indicator:socialbreadthdef'] = 'Databas social';
$string['indicator:socialbreadthdef_help'] = 'Deltagaren har nått denna procentandel av det sociala engagemanget som erbjuds av Databasaktiviteterna under detta analysintervall (Nivåer = Inget deltagande, Deltagaren ensamt)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insufficiententries'] = 'det behövs fler poster för att visa den här databasen';
$string['intro'] = 'Beskrivning';
$string['invalidaccess'] = 'Den här sidan visades inte på ett giltigt sätt';
$string['invalidfieldid'] = 'Fält-ID är felaktigt';
$string['invalidfieldname'] = 'Välj ett annat namn för det här fältet';
$string['invalidfieldtype'] = 'Felaktig fälttyp';
$string['invalidid'] = 'Data-ID är felaktigt';
$string['invalidpreset'] = '{$a} är inte en förinställning.';
$string['invalidrecord'] = 'Felaktig post';
$string['invalidurl'] = 'Den URL som du just matade in är inte giltig';
$string['jstemplate'] = 'Mall för Javascript';
$string['latitude'] = 'Latitud';
$string['latlong'] = 'Latitud/longitud';
$string['latlongboth'] = 'Både latitud och longitud krävs.';
$string['latlongdownloadallhint'] = 'Nedladdningslänk för alla poster i KML-format';
$string['latlongkmllabelling'] = 'Hur du sätter etiketter på komponenter i KML-filer (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Visning av tjänster som är länkade utåt';
$string['latlongotherfields'] = 'Övriga fält';
$string['list'] = 'Visa lista';
$string['listtemplate'] = 'Mall för lista';
$string['listview'] = 'Listvy';
$string['longitude'] = 'Longitud';
$string['manageapproved'] = 'Tillåt redigering av godkända poster';
$string['manageapproved_help'] = 'Om inaktiverat kan godkända poster inte längre redigeras eller tas bort av användaren som lade till dem. Den här inställningen har ingen effekt om inte "Godkännande krävs" är aktiverat.';
$string['managefields'] = 'Hantera fält';
$string['mapexistingfield'] = 'Koppla till {$a}';
$string['mapnewfield'] = 'Skapa ett nytt fält';
$string['mappingwarning'] = 'Alla gamla fält som inte är kartlagda till ett nytt fält kommer försvinna och alla data i det fältet kommer att tas bort.';
$string['maxentries'] = 'Maximalt antal poster';
$string['maxentries_help'] = 'Det maximala antalet poster som en deltagare kan skicka in för den här aktiviteten.';
$string['maxsize'] = 'Maximal storlek';
$string['menu'] = 'Meny';
$string['menuchoose'] = 'Välj...';
$string['missingdata'] = 'Det måste finnas ett data-ID eller objekt som tilldelas klassen för fältet';
$string['missingfield'] = 'Programmerarfel: Du måste ange fält och/eller data när du definierar klassen för fältet.';
$string['modulename'] = 'Databas';
$string['modulename_help'] = 'Aktiviteten <em>Databas</em> gör det möjligt för deltagarna att skapa, underhålla och söka i en samling databasposter. Poststrukturen definieras av läraren som ett antal fält. Fälttyper inkluderar kryssruta, alternativknappar, listruta, textfält, URL, bild och uppladdad fil.

Den visuella layouten för information när du listar, visar eller redigerar databasposter kan styras av databasmallar. Databasaktiviteter kan delas mellan kurser som förinställningar och en lärare kan också importera och exportera databasposter.

Om filtret för automatisk länkning av databasen är aktiverat länkas alla poster i en databas automatiskt där orden eller fraserna visas i kursen.

En lärare kan tillåta kommentarer på poster. Poster kan också betygsättas av lärare eller elever (peer evaluation). Betyg kan aggregeras för att bilda ett slutligt resultat som registreras i betygsboken.

Databasaktiviteter har många användningsområden, till exempel

* En kollaborativ samling av webblänkar, böcker, bokrecensioner, tidskriftsreferenser etc.
* För visning av studentskapade foton, affischer, webbplatser eller dikter för peer-kommentarer och recensioner.';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'Databaser';
$string['more'] = 'Fler';
$string['moreurl'] = 'Fler URLer';
$string['movezipfailed'] = 'Det gick inte att flytta zip-filen';
$string['multientry'] = 'Dubblettpost';
$string['multimenu'] = 'Meny (välj flera)';
$string['multipletags'] = 'Det fanns flerfaldiga taggar! Mallen har inte sparats';
$string['newentry'] = 'Ny post';
$string['newfield'] = 'Skapa ett nytt fält';
$string['newfield_help'] = 'Ett fält gör det möjligt att mata in data. Varje post i en databasaktivitet kan ha flera fält av flera typer, till exempel ett datumfält, som gör det möjligt för deltagarna att välja en dag, månad och år i en listruta, ett bildfält som gör det möjligt för deltagarna att ladda upp en bildfil, eller ett kryssrutefält som gör det möjligt för deltagarna att välja ett eller flera alternativ.

Varje fält måste ha ett unikt fältnamn. Fältbeskrivningen är valfri.';
$string['noaccess'] = 'Du har inte åtkomst till den här sidan';
$string['nodefinedfields'] = 'Den nya förinställningen har inga definierade fält!';
$string['nofieldcontent'] = 'Det gick inte att hitta innehållet i fältet';
$string['nofieldindatabase'] = 'Det finns inga fält definierade för den här databasen';
$string['nolisttemplate'] = 'Mallen för lista är ännu inte definierad';
$string['nomatch'] = 'Det gick inte att hitta några matchande poster!';
$string['nomaximum'] = 'Ingen maxgräns';
$string['nopreviewavailable'] = 'Det finns ingen förhandsgranskning tillgänglig för {$a}';
$string['norecords'] = 'Det finns inga poster i databasen';
$string['nosingletemplate'] = 'Det har inte definierats någon mall för enskilda poster ännu';
$string['notapproved'] = 'Posten är inte godkänd ännu.';
$string['notinjectivemap'] = 'Detta är inte en injektiv karta';
$string['notopenyet'] = 'Den här aktiviteten är tyvärr inte tillgänglig förrän {$a}';
$string['number'] = 'Tal';
$string['numberrssarticles'] = 'Poster i RSS-flödet';
$string['numnotapproved'] = 'Avvaktar';
$string['numrecords'] = '{$a} poster';
$string['ods'] = '<abbr title="OpenDocument Spreadsheet">ODS</abbr>&nbsp;(OpenOffice)';
$string['openafterclose'] = 'Du har angivit ett startdatum som infaller efter slutdatum';
$string['optionaldescription'] = 'Kort beskrivning (valfri)';
$string['optionalfilename'] = 'Filnamn (valfritt)';
$string['other'] = 'Övrigt';
$string['overrwritedesc'] = 'Skriv över förinställningen om den redan existerar';
$string['overwrite'] = 'Skriv över';
$string['overwritesettings'] = 'Skriv över de aktuella inställningarna';
$string['page-mod-data-x'] = 'Valfri sida för databasmodul';
$string['pagesize'] = 'Poster per sida';
$string['participants'] = 'Deltagare';
$string['picture'] = 'Bild';
$string['pleaseaddsome'] = 'Vänligen skapa några här nedan eller <a href="{$a}">välj en förinställd mall</a> för att komma igång.';
$string['pluginadministration'] = 'Administration av aktivitet av typ databas';
$string['pluginname'] = 'Databas';
$string['portfolionotfile'] = 'Exportera hellre till en portfolio än till en fil (endast csv och leap2)';
$string['presetdeleted'] = 'Förinställning borttagen.';
$string['presetinfo'] = 'Om du sparar detta som en förinställning så kommer mallen att göras öppet tillgänglig. Andra användare kommer att kunna använda den i sina databaser.';
$string['presetnotselected'] = 'Ingen förinställning vald.';
$string['presets'] = 'Förinställda mallar';
$string['presetshelp'] = 'Välj en förinställning att starta med.';
$string['preview'] = 'Förhandsgranska';
$string['privacy:metadata:commentpurpose'] = 'Kommentarer för databasposter';
$string['privacy:metadata:data_content'] = 'Representerar ett svar på ett fält i databas-aktivitetsmodulen';
$string['privacy:metadata:data_content:content'] = 'Innehåll';
$string['privacy:metadata:data_content:content1'] = 'Ytterligare kommentar 1';
$string['privacy:metadata:data_content:content2'] = 'Ytterligare kommentar 2';
$string['privacy:metadata:data_content:content3'] = 'Ytterligare kommentar 3';
$string['privacy:metadata:data_content:content4'] = 'Ytterligare kommentar 4';
$string['privacy:metadata:data_content:fieldid'] = 'Fältdefinitions-ID';
$string['privacy:metadata:data_records'] = 'Representerar poster i databasaktivitetsmodulen';
$string['privacy:metadata:data_records:approved'] = 'Godkännandestatus';
$string['privacy:metadata:data_records:groupid'] = 'Grupp';
$string['privacy:metadata:data_records:timecreated'] = 'Tid då posten skapades';
$string['privacy:metadata:data_records:timemodified'] = 'Tid då posten senast ändrades';
$string['privacy:metadata:data_records:userid'] = 'Användare som skapade posten';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Fält för databasaktivitetsmodulen';
$string['privacy:metadata:filepurpose'] = 'Fil bifogad till posten';
$string['privacy:metadata:ratingpurpose'] = 'Poäng för databasposten';
$string['privacy:metadata:tagpurpose'] = 'Etiketter på databasposter';
$string['radiobutton'] = 'Radioknappar';
$string['recordapproved'] = 'Posten har godkänts';
$string['recorddeleted'] = 'Posten har tagits bort';
$string['recorddisapproved'] = 'Posten har inte godkänts';
$string['recordsnotsaved'] = 'Inga poster sparades. Kontrollera formatet för uppladdningsfilen.';
$string['recordssaved'] = 'poster sparade';
$string['removealldatatags'] = 'Ta bort alla databasetiketter';
$string['requireapproval'] = 'Godkännande obligatoriskt';
$string['requireapproval_help'] = 'Om det här alternativet är aktiverat krävs det att en lärare godkänner posterna innan de blir synliga för alla.';
$string['required'] = 'Obligatoriskt';
$string['requiredentries'] = 'Poster som är obligatoriska för slutförande (äldre)';
$string['requiredentries_help'] = 'Om det här har angetts visas ett meddelande om antalet poster som krävs för att slutföra uppgiften. Observera att den här inställningen inte är kopplad till slutförande av aktivitet.

För antalet poster som krävs för att slutföra aktiviteten ska den nya inställningen för slutförande av aktivitet, "Kräv poster", användas. Om du vill ta bort den här inställningen helt ställer du in den på <em>Inga</em> och sparar.
Använd <em>Transaktioner som krävs </em> i avsnittet <em>Slutförande av aktivitet</em> i stället.';
$string['requiredentriestoview'] = 'Obligatoriskt antal poster innan visning';
$string['requiredentriestoview_help'] = 'Antalet poster som en deltagare måste skicka in innan de kan se poster från andra deltagare.

<b>OBS!</b> Om poster krävs innan visning bör filtret för automatisk länkning av databasen inaktiveras. Detta beror på att filtret för automatisk länkning av databasen inte kan avgöra om en användare har skickat det antal poster som krävs.';
$string['requiredentrieswarning'] = 'Denna inställning har ersatts av en Aktivitetsslutförandeinställning "Kräv poster"';
$string['requiredfield'] = 'Obligatoriskt fält';
$string['resetsettings'] = 'Återställ filter';
$string['resettemplate'] = 'Återställ mall';
$string['resizingimages'] = 'Återställer storleken på minibilder';
$string['rows'] = 'Rader';
$string['rssglobaldisabled'] = 'Inaktiverad. Se konfigurationsvariablerna för webbplatsen.';
$string['rsstemplate'] = 'RSS-mall';
$string['rsstitletemplate'] = 'Mall för titel på RSS';
$string['rsstype'] = 'RSS-flöde för denna aktivitet';
$string['save'] = 'Spara';
$string['saveandadd'] = 'Spara och lägg till ny';
$string['saveandview'] = 'Spara och visa';
$string['saveaspreset'] = 'Spara som en förinställning';
$string['saveaspreset_help'] = '<p align="center"><strong>Spara som en förinställd mall</strong></p>
<p>Detta publicerar den aktuella mallen som en förinställd sådan som vem som helst på webbplatsen kan visa och använda. Den kommer att dyka upp i listan över förinställda mallar. Du kommer att kunna ta bort den när du vill. </p>';
$string['saveaspresetmissingcapability'] = 'Användaren har inte behörighet att spara databasen som en förinställning.';
$string['savedataaspreset'] = 'Spara alla fält och mallar som förinställning';
$string['savesettings'] = 'Spara inställningar';
$string['savesuccess'] = 'Förinställningar sparades. Den kommer nu att vara tillgänglig på hela webbplatsen.';
$string['savetemplate'] = 'Spara mall';
$string['search'] = 'Sök';
$string['search:activity'] = 'Databas - aktivitetsinformation';
$string['search:entry'] = 'Databas - poster';
$string['selectedrequired'] = 'Alla valda är obligatoriska';
$string['selectexportoptions'] = 'Välj exportalternativ';
$string['selectfields'] = 'Välj fält';
$string['showall'] = 'Visa alla poster';
$string['showmore'] = 'Visa mer';
$string['single'] = 'Visa enskild post';
$string['singletemplate'] = 'Mall för enskild post';
$string['singleview'] = 'Enskild vy';
$string['startbuilding'] = 'Börja bygga din aktivitet';
$string['subplugintype_datafield'] = 'Fälttyp i databas';
$string['subplugintype_datafield_plural'] = 'Fälttyper i databas';
$string['subplugintype_datapreset'] = 'Förinställning';
$string['subplugintype_datapreset_plural'] = 'Förinställningar';
$string['tagarea_data_records'] = 'Databasposter';
$string['tags'] = 'Etiketter';
$string['tagsdeleted'] = 'Databasetiketter har tagits bort';
$string['teachersandstudents'] = '{$a->teachers} och  {$a->students}';
$string['templates'] = 'Mallar';
$string['templatesaved'] = 'Mallen har sparats';
$string['templatesnavigation'] = 'Övergripande mallnavigering';
$string['text'] = 'Text';
$string['textarea'] = 'Textfält';
$string['timeadded'] = 'Tillagd';
$string['timemodified'] = 'Modifierad';
$string['todatabase'] = 'till den här databasen';
$string['type'] = 'Fälttyp';
$string['undefinedprocessactionmethod'] = 'Ingen metod för händelser har definierats i Data_Preset för att hantera åtgärden "{$a}".';
$string['unsupportedfields'] = 'Fält som ej stöds';
$string['unsupportedfieldslist'] = 'Följande fält kan inte exporteras:';
$string['updatefield'] = 'Uppdatera ett befintligt fält';
$string['uploadfile'] = 'Ladda upp fil';
$string['uploadrecords'] = 'Ladda upp poster från fil';
$string['uploadrecords_help'] = 'Det går att ladda upp inlägg via en textfil. Filen bör ha något av följande format:

* Varje rad i filen innehåller en post
* Varje post består av en serie data som sinsemellan är kommaseparerade
* Den första posten innehåller en lista med fältnamn som definierar formatet på resten av filen.

Det som omsluter fältet är ett tecken som omsluter varje fält i varje post. Det går normalt sett att avstå från att ange detta tecken.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'URL';
$string['usedate'] = 'Inkludera i sökning.';
$string['usepredefinedset'] = 'Använd fördefinierad uppsättning';
$string['usepreset'] = 'Använd förinställning';
$string['usestandard'] = 'Använd en förinställd mall';
$string['usestandard_help'] = '<p align="center"><strong>Använd en förinställd mall</strong></p>
<p> Detta använder en mall som är tillgänglig på hela webbplatsen.</p>
<p> Om du dessutom har sparat mallen till en databas med hjälp av \'Spara som förinställd mall\' så kan du ta bort den när du vill.</p>';
$string['viewfromdate'] = 'Möjlig att endast läsa fr.o.m.';
$string['viewnavigation'] = 'Övergripande visningslägesnavigering';
$string['viewtodate'] = 'Möjlig att endast läsa t.o.m.';
$string['viewtodatevalidation'] = 'Till-datum kan inte komma före från-datum.';
$string['wrongdataid'] = 'Det data-id som har angivits är felaktigt';
