<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_kickstart', language 'fr', version '4.3'.
 *
 * @package     format_kickstart
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['automatictemplate'] = 'Modèle automatique';
$string['automatictemplate_desc'] = 'Si un seul modèle est disponible pour l’utilisateur, il sera automatiquement importé. L’utilisateur sera averti sur la page lorsque cela se produira.';
$string['automatictemplate_help'] = 'Le modèle de cours a été automatiquement appliqué. Si vous avez besoin d’un modèle différent, veuillez contacter l’administrateur système.';
$string['buypro'] = 'Acheter Kickstart Pro';
$string['buypromaxtemplates'] = 'Vous utilisez le nombre maximum (<b>4</b>) de modèles autorisés dans l’édition gratuite de Kickstart. Pour créer plus de modèles, achetez <a target="_blank" href="http://bdecent.de/kickstart">Kickstart Pro</a>.';
$string['buyprosummary'] = 'Pour déverrouiller toutes les fonctionnalités de Kickstart, achetez Kickstart Pro.';
$string['confirmtemplate'] = 'Voulez-vous vraiment utiliser ce modèle ?';
$string['course_backup'] = 'Fichier de sauvegarde du cours (.mbz)';
$string['course_backup_help'] = 'Lorsqu’un utilisateur sélectionne ce modèle dans un cours, cette sauvegarde de cours .mbz sera importée dans le cours.';
$string['course_templates'] = 'Modèles de cours';
$string['coursebackupnotset'] = 'Le modèle n’a pas de jeu de sauvegarde de cours.';
$string['coursecreatorinstructions'] = 'Instructions du créateur de cours';
$string['coursecreatorinstructions_default'] = '<p> Veuillez choisir un nom pour votre cours. Sélectionnez ensuite une catégorie. À l’étape suivante
vous pourrez inscrire des utilisateurs au cours. Dans la dernière étape, vous pouvez choisir un modèle pour votre cours.</p>';
$string['coursecreatorinstructions_desc'] = 'Contenu par défaut affiché pour le créateur du cours
Afficher la page « Créer à partir d’un modèle »';
$string['coursecreatorredirect'] = 'Redirection du créateur du cours';
$string['coursecreatorredirect_desc'] = 'Forcez les créateurs de cours à utiliser la page « Créer à partir d’un modèle » de Kickstart lors de la création de nouveaux cours. Par exemple, lorsqu’un créateur de cours clique sur « Ajouter un nouveau cours », il sera redirigé vers Kickstart.';
$string['courseformatoptions'] = 'Format de cours';
$string['create_template'] = 'Créer un modèle';
$string['createcoursefromtemplate'] = 'Créer un cours à partir d’un modèle';
$string['default_templatebackground'] = 'Images d’arrière-plan des gabarits par défaut';
$string['defaultteacherinstructions'] = 'Instructions par défaut de l’enseignant';
$string['defaultteacherinstructions_default'] = '<p>Actuellement, il n’y a rien ici, alors commencez à ajouter votre contenu. Nous avons rendu la création de cours vraiment facile pour vous. Tout d’abord, vous choisissez un modèle qui convient à votre cours, puis vous pouvez commencer à ajouter du contenu.</p>';
$string['defaultteacherinstructions_desc'] = 'Contenu par défaut affiché aux enseignants avant qu’un modèle ait été choisi.';
$string['defaulttemplatesview'] = 'Affichage des gabarits par défaut';
$string['defaulttemplatesview_desc'] = 'Gabarits par défaut affichés sous forme de tuiles ou de liste.';
$string['defaultuserinstructions'] = 'Instructions par défaut pour l’étudiant';
$string['defaultuserinstructions_default'] = '<p>Votre professeur n’a pas encore ajouté de contenu à ce cours. </p> <p> Si vous avez des questions, contactez votre enseignant.</p>';
$string['defaultuserinstructions_desc'] = 'Contenu par défaut affiché aux étudiants avant qu’un modèle ait été choisi par l’enseignant.';
$string['delete'] = 'Supprimer';
$string['delete_template'] = 'Supprimer le modèle';
$string['description'] = 'Description';
$string['disable'] = 'Désactiver';
$string['edit'] = 'Éditer';
$string['edit_template'] = 'Éditer le modèle';
$string['enrollmenthelp'] = 'Avant de continuer, vous pouvez inscrire des enseignants (ou tout autre utilisateur). Cliquez sur <b>Passer au contenu du cours</b> pour choisir un gabarit à importer.';
$string['general_settings'] = 'Paramètres généraux';
$string['getpro'] = 'Obtenez plus de modèles avec Kickstart Pro';
$string['goprotoenable'] = 'Allez à la version pro pour continuer';
$string['gotocourse'] = 'Aller au cours';
$string['importcourse'] = 'Importer un cours';
$string['importexplanation'] = 'Voici une liste des cours auxquels vous êtes inscrit en tant qu’enseignant. Vous pouvez importer le contenu de ces cours. Utilisez le champ de recherche pour affiner la liste des cours.';
$string['importtarget'] = 'Cible d’importation';
$string['importtarget_desc'] = 'Choisissez comment les modèles Kickstart doivent être importés dans les cours.';
$string['includesubcategories'] = 'Inclure les sous-catégories';
$string['includesubcategories_help'] = 'Si cette case est cochée, les sous-catégories des catégories choisies auront également accès à ce modèle.';
$string['kickstart:import_from_template'] = 'Importer à partir de modèles';
$string['kickstart:manage_templates'] = 'Gérer les modèles';
$string['learnmore'] = 'En savoir plus';
$string['manage_templates'] = 'Gérer les modèles';
$string['migratefromcourses'] = 'Migrer le contenu d’autres cours';
$string['missingcategory'] = 'Catégorie manquante';
$string['moreresults'] = 'Il y a davantage de résultats, entrez des critères plus précis';
$string['notemplates'] = 'Aucun gabarit n’est encore disponible.';
$string['pluginname'] = 'Format Kickstart';
$string['previewurl'] = 'Aperçu URL';
$string['previewurl_help'] = 'S’il est fourni, un bouton s’affichera sur le modèle qui ouvrira cette URL dans un nouvel onglet';
$string['privacy:metadata'] = 'Le plugin au format Kickstart n’enregistre aucune donnée personnelle.';
$string['restoretoexistingcourseadding'] = 'Fusionner les modèles Kickstart dans les cours';
$string['restoretoexistingcoursedeleting'] = 'Supprimer le contenu existant lors de l’importation de modèles Kickstart';
$string['restrictcategory'] = 'Restreindre par catégories';
$string['restrictcohort'] = 'Restreindre par cohortes';
$string['restrictrole'] = 'Restreindre par rôles';
$string['searchterm'] = 'Résultats de la recherche pour "{$a->term}"';
$string['sectionname'] = 'Kickstart';
$string['selectcategory'] = 'Choisir une catégorie';
$string['shortname'] = 'Nom abrégé :';
$string['showing'] = 'Affichage de {$a->count} cours';
$string['staffonthiscourse'] = 'Personnel de ce cours';
$string['strconfirmtemplate'] = 'Voulez-vous vraiment utiliser ce gabarit ?';
$string['strlist'] = 'Liste';
$string['strtile'] = 'Tuile';
$string['tagarea_kickstart_template'] = 'Modèles Kickstart';
$string['teacherinstructions'] = 'Instructions pour l’enseignant';
$string['teacherinstructions_help'] = 'Contenu affiché aux enseignants avant la sélection d’un modèle.';
$string['template_created'] = 'Le modèle a bien été créé';
$string['template_deleted'] = 'Le modèle a bien été supprimé';
$string['template_edited'] = 'Le modèle a bien été modifié';
$string['templateaccess'] = 'Accès au modèle';
$string['templatebackimg'] = 'Images d’arrière-plan du gabarit';
$string['templatebackimg_help'] = 'Autoriser le téléchargement d’images pour un gabarit.';
$string['templatesview'] = 'Affichage des gabarits';
$string['templatesview_help'] = 'Gabarits affichés sous forme de tuiles ou en liste';
$string['title'] = 'Titre';
$string['usedefault'] = 'Utiliser le paramètre de restauration par défaut';
$string['usedefault_help'] = 'Ces paramètres sont appliqués lors de l’importation d’un modèle.';
$string['userinstructions'] = 'Instructions pour l’étudiant';
$string['userinstructions_help'] = 'Contenu affiché aux étudiants avant qu’un modèle ne soit choisi par l’enseignant.';
$string['usetemplate'] = 'Utiliser le modèle';
$string['welcometo'] = 'Bienvenue à';
$string['welcometoyourcourse'] = 'Bienvenue dans votre nouveau cours';
