<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_generator', language 'cs', version '4.3'.
 *
 * @package     tool_generator
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['additionalmodules'] = 'Přídavné aktivity';
$string['additionalmodules_help'] = 'Vyberte další aktivity, které implementují funkci course_backend_generator_create_activity, které chcete zahrnout do testovacího kurzu.';
$string['bigfile'] = 'Velký soubor {$a}';
$string['courseexplanation'] = 'Tento nástroj vytváří standardní kurzy s testy, obsahující mnohé sekce, činnosti a soubory.

Jeho záměrem je poskytnout standardizovaný nástroj na kontrolu spolehlivosti a výkonu rozličných složek systému (jako je např. zálohování a obnovení).

Tento test je důležitý, protože v minulosti se vyskytlo mnoho případů, když kurzy v reální praxi (např. kurzy s 1000 aktivitami) nefungovaly.

Takové velké kurzy vytvořené pomocí tohoto nástroje mohou zabírat veliký objem databáze a prostoru v souborovém systému (desítky GB). Abyste tento prostor znovu uvolnil, budete potřebovat po použití kurzy odstranit (a čekat, dokud probíhají různé operace čištění).

**Nepoužívejte tuto vlastnost ve spuštěném systému**.
Použijte ji pouze na vývojářském serveru.
(Abyste se vyhnul náhodnému použití, je tato vlastnost deaktivována, dokud nezvolíte také úroveň ladění DEVELOPER).';
$string['coursesize_0'] = 'XS (~10KB; vytvořen za ~ 1 sekundu)';
$string['coursesize_1'] = 'S (~10MB;  vytvořen za ~30 sekúnd)';
$string['coursesize_2'] = 'M (~100MB; vytvořeno za ~2 minuty)';
$string['coursesize_3'] = 'L (~1GB; vytvořeno za  ~30 minut)';
$string['coursesize_4'] = 'XL (~10GB; vytvořeno za   ~2 hodiny)';
$string['coursesize_5'] = 'XXL (~20GB; vytvořeno za   ~4 hodiny)';
$string['coursewithoutusers'] = 'Vybraný kurz nemá žádné uživatele';
$string['createcourse'] = 'Vytvořit kurz';
$string['createtestplan'] = 'Vytvořit testovací plán';
$string['creating'] = 'Vytváření kurzu';
$string['done'] = 'hotovo  ({$a}s)';
$string['downloadtestplan'] = 'Stáhnout testovací plán';
$string['downloadusersfile'] = 'Stáhnout soubor uživatelů';
$string['error_nocourses'] = 'Pro generování testovacího plánu nejsou žádné kurzy';
$string['error_noforumdiscussions'] = 'Vybraný kurz neobsahuje diskusních fórum';
$string['error_noforuminstances'] = 'Vybraný kurz neobsahuje instance modulů fórum';
$string['error_noforumreplies'] = 'Vybraný kurz neobsahuje reakce ve fóru';
$string['error_nonexistingcourse'] = 'Uvedený kurz neexistuje';
$string['error_nopageinstances'] = 'Vybraný kurz neobsahuje instance modulu stranka';
$string['error_notdebugging'] = 'Na tomto serveru není k dispozici, protože ladění není nastavena na volbu DEVELOPER';
$string['error_nouserspassword'] = 'Musíte nastavit $CFG->tool_generator_users_password v souboru  config.php na generování testovacího plánu';
$string['fullname'] = 'Testovací kurz: {$a->size}';
$string['maketestcourse'] = 'Vytvořit testovací kurz';
$string['maketestplan'] = 'Vyrobit plán testování JMeter';
$string['notenoughusers'] = 'Vybraný kurz nemá dostatek uživatelů';
$string['pluginname'] = 'Generátor vývojových dat';
$string['privacy:metadata'] = 'Modul Generátor vývojových dat neukládá žádné osobní údaje.';
$string['progress_checkaccounts'] = 'Kontrola uživatelských účtů ({$a})';
$string['progress_coursecompleted'] = 'Dokončen kurz  ({$a}s)';
$string['progress_createaccounts'] = 'Vytváření uživatelských účtů ({$a->from} - {$a->to})';
$string['progress_createassignments'] = 'Vytvořeny úkoly ({$a})';
$string['progress_createbigfiles'] = 'Vytvořeny velké soubory ({$a})';
$string['progress_createcourse'] = 'Vytvořen kurz {$a}';
$string['progress_createforum'] = 'Vytvořeno fórum ({$a}  příspěvků)';
$string['progress_createpages'] = 'Vytvořeny stránky ({$a})';
$string['progress_createsmallfiles'] = 'Vytvořeny malé soubory ({$a})';
$string['progress_enrol'] = 'Zápis uživatelů do kurzu ({$a})';
$string['progress_sitecompleted'] = 'Dokončeny stránky ({$a}s)';
$string['shortsize_0'] = 'XS';
$string['shortsize_1'] = 'S';
$string['shortsize_2'] = 'M';
$string['shortsize_3'] = 'L';
$string['shortsize_4'] = 'XL';
$string['shortsize_5'] = 'XXL';
$string['sitesize_0'] = 'XS (~10MB; 3 kurzy,  vytvořen za ~30 sekund)';
$string['sitesize_1'] = 'S (~50MB; 8 kurzů,  vytvořen za ~2 minuty)';
$string['sitesize_2'] = 'M (~200MB; 73 kurzů,  vytvořen za ~10 minut)';
$string['sitesize_3'] = 'L (~1\'5GB; 277 kurzů,  vytvořen za ~1,5 hodiny)';
$string['sitesize_4'] = 'XL (~10GB; 1065 kurzů,  vytvořen za ~5 hodin)';
$string['sitesize_5'] = 'XXL (~20GB; 4177 kurzů,  vytvořen za ~10 hodin)';
$string['size'] = 'Velikost kurzu';
$string['smallfiles'] = 'Malé soubory';
$string['targetcourse'] = 'Cílový testovací kurz';
$string['testplanexplanation'] = 'Tento nástroj vytváří soubor plánu testování JMeter spolu se souborem user credentials.

Tento plán testování je určen na práci spolu s {$a}, který usnadňuje spuštění plánu testování v konkrétním Moodle prostředí, sbírá informace o spuštěních a porovnává výsledky, takže jej budete muset stáhnout a použít jeho skript test_runner.sh, nebo postupovat podle instalace a návodu na použití.

Musíte nastavit heslo pro uživatele kurzu v config.php (např. $CFG->tool_generator_users_password = \'moodle\';). Pro toto heslo neexistuje žádná standardní hodnota, aby se zabránilo neoprávněnému použití nástroje. Budete muset použít možnost aktualizace hesel v případě, že uživatelé vašich kurzů mají jiná hesla, nebo byla vytvořena pomocí tool_generator, ale bez nastavení hodnoty $CFG->tool_generator_users_password.

Je to součást souboru tool_generator, proto dobře funguje s generovanými kurzy a generátory portálu, může být také použitý s jakýmkoliv kurzem, který obsahuje alespoň:

* dost zapsaných uživatelů (závisí od velikosti plánu testování, jakou si zvolíte) s heslem obnoveným na výraz \'moodle\'
* Instanci modulu stránky
* Instanci modulu fóra s minimálně jednou diskusí a jednou odpovědí

Možná byste chtěl zvážit kapacitu vašich serverů, když průběh velkých plánů testování jako objem na nahrání generován nástrojem JMeter může být mimořádně velký. Byla nastavena perioda zrychlení podle počtu vláken (uživatelů), aby se zredukoval tento druh problémů, ale nahrávání je stále enormní.

**Nespouštějte plán testování ve spuštěném systému**. Tato vlastnost pouze vytváří soubory na zásobování nástroje JMeter, takže sama o sobě není nebezpečná, ale **NIKDY** byste neměl spouštět tento plán testování na produkčních stránkách.';
$string['testplansize_0'] = 'XS ({$a->users} uživatelů, {$a->loops} smyček a {$a->rampup} perioda zrychlení)';
$string['testplansize_1'] = 'S ({$a->users} uživatelů, {$a->loops} smyček a {$a->rampup} perioda zrychlení)';
$string['testplansize_2'] = 'M ({$a->users} uživatelů, {$a->loops} smyček a {$a->rampup} perioda zrychlení)';
$string['testplansize_3'] = 'L ({$a->users} uživatelů, {$a->loops} smyček a {$a->rampup} perioda zrychlení)';
$string['testplansize_4'] = 'XL ({$a->users} uživatelů, {$a->loops} smyček a {$a->rampup} perioda zrychlení)';
$string['testplansize_5'] = 'XXL ({$a->users} uživatelů, {$a->loops} smyček a {$a->rampup} perioda zrychlení)';
$string['updateuserspassword'] = 'Aktualizovat hesla uživatelů kurzu';
$string['updateuserspassword_help'] = 'Jmeter potřebuje přihlašovací jméno jako uživatelé kurzu. Uživatelská hesla můžete nastavit použitím $CFG->tool_generator_users_password v config.php; toto nastavení aktualizuje heslo uživatele kurzu podle $CFG->tool_generator_users_password. Může být užitečné v případě, že používáte kurz, který nebyl vytvořen v tool_generator nebo když $CFG->tool_generator_users_password nebylo nastavené, když jste vytvářel testovací kurzy.';
