<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'board', language 'es', version '4.3'.
 *
 * @package     board
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Cancel'] = 'Cancelar';
$string['Ok'] = 'Aceptar';
$string['acceptedfiletypeforbackground'] = 'Tipos de archivos aceptados para imágenes de fondo.';
$string['acceptedfiletypeforbackground_desc'] = 'Seleccione los tipos de archivos que se admitirán para las imágenes de fondo.';
$string['acceptedfiletypeforcontent'] = 'Tipos de archivos aceptados para imágenes de contenido.';
$string['acceptedfiletypeforcontent_desc'] = 'Seleccione los tipos de archivos que se admitirán para el contenido.';
$string['addcomment'] = 'Añadir comentario';
$string['addrating'] = 'Calificar publicaciones';
$string['addrating_all'] = 'por Todos';
$string['addrating_none'] = 'Desactivado';
$string['addrating_students'] = 'por Estudiantes';
$string['addrating_teachers'] = 'por Profesores';
$string['allowed_singleuser_modes'] = 'Modos de usuario único habilitados';
$string['allowed_singleuser_modes_desc'] = 'Permitir o deshabilitar el uso de determinados modos de usuario único. No afecta a los Tableros ya creados';
$string['allowyoutube'] = 'Permitir youtube';
$string['allowyoutube_desc'] = 'Si se activa, se admite un botón para agregar un vídeo de YouTube incrustado.';
$string['aria_addmedia'] = 'Agregar {type} para la publicación {post} de la columna {column}';
$string['aria_addmedianew'] = 'Agregar {type} para nueva publicación desde la columna {column}';
$string['aria_canceledit'] = 'Cancelar la edición de la publicación {post} de la columna {column}';
$string['aria_cancelnew'] = 'Cancelar nueva publicación para la columna {column}';
$string['aria_choosefileedit'] = 'Seleccionar archivo para la publicación {post} de la columna {column}';
$string['aria_choosefilenew'] = 'Seleccionar archivo para nueva publicación desde la columna {column}';
$string['aria_column_locked'] = 'Columna {$a} bloqueada';
$string['aria_column_unlocked'] = 'Columna {$a} desbloqueada';
$string['aria_deleteattachment'] = 'Eliminar archivo adjunto de la publicación {post} de la columna {column}';
$string['aria_deletecolumn'] = 'Eliminar columna {column}';
$string['aria_deletepost'] = 'Eliminar publicación {post} de la columna {column}';
$string['aria_editpost'] = 'Editar publicación {post}';
$string['aria_movecolumn'] = 'Mover columna {column}';
$string['aria_movepost'] = 'Mover publicación {post}';
$string['aria_newcolumn'] = 'Agregar nueva columna';
$string['aria_newpost'] = 'Agregar nueva publicación a la columna {column}';
$string['aria_postedit'] = 'Guardar la edición de la publicación {post} de la columna {column}';
$string['aria_postnew'] = 'Guardar nueva publicación para la columna {column}';
$string['aria_ratepost'] = 'Califica la publicación {post} de columna {column}';
$string['background_color'] = 'Color de fondo';
$string['background_color_help'] = 'Debe ser un color hexadecimal válido, como #00cc99';
$string['background_image'] = 'Imagen de fondo';
$string['blanktargetenabled'] = 'Este tablero ha sido configurado para lanzar todos sus URL / enlaces web en una nueva ventana o pestaña.';
$string['board:addinstance'] = 'Agregar un nuevo recurso de Tablero (Board)';
$string['board:deleteallcomments'] = 'Ver y eliminar todos los comentarios en las publicaciones';
$string['board:manageboard'] = 'Administrar columnas y administrar todas las publicaciones.';
$string['board:postcomment'] = 'Crear y ver comentarios en publicaciones';
$string['board:view'] = 'Ver el contenido del tablero y administrar las publicaciones propias.';
$string['board_column_locked'] = 'Esta columna está bloqueada y no se puede editar.';
$string['boardhasnotes'] = 'Este tablero ya tiene publicaciones, no se permite cambiar el modo de usuario';
$string['boardsettings'] = 'Configuración del Tablero';
$string['brickfieldlogo'] = 'logo Powered by Brickfield';
$string['cancel_button_text'] = 'Cancelar';
$string['choose_file'] = 'Elegir Archivo de Imagen';
$string['column_colours'] = 'Colores de Columna';
$string['column_colours_desc'] = 'Colores que se utilizan en la parte superior de cada columna. Son colores hexadecimales y deben colocarse uno por línea con 3 o 6 caracteres. Si alguno de estos valores no es igual a un color, se utilizarán los valores predeterminados.C';
$string['comment'] = 'Comentario';
$string['comments'] = '{$a} Comentarios';
$string['completiondetail:notes'] = 'Agregar notas: {$a}';
$string['completionnotes'] = 'Requerir a los estudiantes esta cantidad de notas para completar la actividad';
$string['completionnotesgroup'] = 'Requerir notas';
$string['default_column_heading'] = 'Encabezado';
$string['delete'] = 'Eliminar';
$string['deletecomment'] = 'Eliminar comentario';
$string['embed_height'] = 'Altura de inserción';
$string['embed_height_desc'] = 'Altura que se utilizará para el iframe al insertar el tablero dentro del curso. Este debería ser un valor CSS válido, p.e. px, rem, %, etc...';
$string['embed_width'] = 'Ancho de inserción';
$string['embed_width_desc'] = 'Ancho que se utilizará para el iframe al insertar el tablero dentro del curso. Este debería ser un valor CSS válido, p.e. px, rem, %, etc...';
$string['embedboard'] = 'Insertar el tablero en la página del curso.';
$string['enableblanktarget'] = 'Habilitar blank target  (abrir en ventana nueva)';
$string['enableblanktarget_help'] = 'Cuando esté habilitado, todos los enlaces se abrirán en una nueva pestaña/ventana';
$string['event_add_column'] = 'Columna añadida';
$string['event_add_column_desc'] = 'El usuario con id \'{$a->userid}\' creó la columna de tablero con id \'{$a->objectid}\' y nombre \'{$a->name}\'.';
$string['event_add_comment'] = 'Comentario añadido';
$string['event_add_comment_desc'] = 'El usuario con  id \'{$a->userid}\' añadió un comentario con id \'{$a->objectid}\', contenido \'{$a->content}\' en publicación con id \'{$a->noteid}\'.';
$string['event_add_note'] = 'Publicación añadida';
$string['event_add_note_desc'] = 'El usuario con id \'{$a->userid}\' creó una publicación de tablero con id \'{$a->objectid}\', encabezado \'{$a->heading}\', contenido \'{$a->content}\', medio \'{$a->media}\' en la columna con id \'{$a->columnid}\', grupo con id \'{$a->groupid}\'.';
$string['event_delete_column'] = 'Columna eliminada';
$string['event_delete_column_desc'] = 'El usuario con id \'{$a->userid}\' eliminó la columna de tablero con id \'{$a->objectid}\'.';
$string['event_delete_comment'] = 'Comentario eliminado';
$string['event_delete_comment_desc'] = 'El usuario con id \'{$a->userid}\' eliminó comentario publicado con id \'{$a->objectid}\' de publicación con id \'{$a->noteid}\'.';
$string['event_delete_note'] = 'Publicación eliminada';
$string['event_delete_note_desc'] = 'El usuario con id \'{$a->userid}\' eliminó publicación del tablero con id \'{$a->objectid}\' de la columna con id \'{$a->columnid}\'.';
$string['event_move_note'] = 'Publicación movida';
$string['event_move_note_desc'] = 'El usuario con id \'{$a->userid}\' movió la publicación del tablero con id \'{$a->objectid}\' a la columna con id \'{$a->columnid}\'.';
$string['event_rate_note'] = 'Publicación calificada';
$string['event_rate_note_desc'] = 'El usuario con id \'{$a->userid}\' calificó la publicación del tablero con id \'{$a->objectid}\' con valor \'{$a->rating}\'.';
$string['event_update_column'] = 'Columna actualizada';
$string['event_update_column_desc'] = 'El usuario con id \'{$a->userid}\' actualizó la columna del tablero con id \'{$a->objectid}\' a \'{$a->name}\'.';
$string['event_update_note'] = 'Publicación actualizada';
$string['event_update_note_desc'] = 'El usuario con id \'{$a->userid}\' actualizó la publicación del tablero con id \'{$a->objectid}\' al encabezado \'{$a->heading}\', contenido \'{$a->content}\', medio \'{$a->media}\' en la columna con id \'{$a->columnid}\'.';
$string['export'] = 'Exportar';
$string['export_backtoboard'] = 'Regresar a Tablero';
$string['export_board'] = 'Exportar Tablero';
$string['export_comment'] = 'Comentario';
$string['export_comments'] = 'Exportar Comentarios';
$string['export_comments_description'] = 'Elija los comentarios que desea exportar.';
$string['export_comments_include_deleted'] = 'Puede optar por exportar todos los comentarios, incluidos los que se han eliminado.';
$string['export_comments_include_deleted_button'] = 'Exportar comentarios (incluidos los eliminados)';
$string['export_content'] = 'Texto';
$string['export_deleted'] = 'Eliminado';
$string['export_email'] = 'Email';
$string['export_firstname'] = 'Nombre';
$string['export_heading'] = 'Encabezado de publicación';
$string['export_info'] = 'Título del Medio';
$string['export_lastname'] = 'Apellido(s)';
$string['export_submissions'] = 'Exportar envíos';
$string['export_timecreated'] = 'Fecha de creación';
$string['export_url'] = 'URL de medio';
$string['form_body'] = 'Contenido';
$string['form_image_file'] = 'Archivo de imagen';
$string['form_mediatype'] = 'Medio';
$string['form_title'] = 'Título de publicación';
$string['hideheaders'] = 'Ocultar a alumnos los encabezados de columna';
$string['history'] = 'Historial del Tablero';
$string['history_refresh'] = 'Temporizador de actualización del Tablero';
$string['history_refresh_desc'] = 'Tiempo de espera (timeout) en segundos entre actualizaciones automáticas del Tablero. Si se establece en 0 o está vacío, el Tablero solo se actualizará durante las acciones del Tablero (agregar/actualizar/etc.)';
$string['historyinfo'] = 'La tabla de historial del Tablero solo se usa para almacenar registros temporales, que los procesos javaScript utilizan para actualizar las vistas del Tablero y luego son eliminadas inmediatamente.';
$string['include_deleted'] = 'Incluir eliminados';
$string['invalid_file_extension'] = 'Extensión de archivo no aceptada para subida (upload).';
$string['invalid_file_size_max'] = 'El tamaño del archivo es demasiado grande para ser aceptado.';
$string['invalid_file_size_min'] = 'El tamaño del archivo es demasiado pequeño para ser aceptado.';
$string['invalid_youtube_url'] = 'URL de YouTube inválida';
$string['media_selection'] = 'Selección de medio';
$string['media_selection_buttons'] = 'Botones';
$string['media_selection_desc'] = 'Configure cómo se mostrará la selección de medio para publicaciones.';
$string['media_selection_dropdown'] = 'Menú desplegable';
$string['modal_title_edit'] = 'Editar publicación para columna {column}';
$string['modal_title_new'] = 'Nueva publicación para columna {column}';
$string['modulename'] = 'Tablero';
$string['modulename_help'] = 'Esta es una nueva actividad para Moodle que le permite al profesor/docente crear un nuevo tablero de notas tipo "Postit".';
$string['modulenameplural'] = 'Tableros';
$string['move_column_to_aftercolumn'] = 'Mover columna después de columna {$a}';
$string['move_column_to_firstplace'] = 'Mover columna al primer lugar';
$string['move_to_afterpost'] = 'Mover después de publicación {$a}';
$string['move_to_firstitemcolumn'] = 'Mover a columna {$a}';
$string['new_column_icon'] = 'Icono de nueva columna';
$string['new_column_icon_desc'] = 'Icono que se muestra en el botón "nueva columna"';
$string['new_note_icon'] = 'Ícono de nueva publicación';
$string['new_note_icon_desc'] = 'Icono que se muestra en el botón "nueva publicación"';
$string['nopermission'] = 'Usted no tiene permiso para ver este tablero.';
$string['note_changed_text'] = 'La publicación que estaba editando ha cambiado.';
$string['note_changed_title'] = 'Confirmar';
$string['note_deleted_text'] = 'La publicación que estaba editando fue eliminada.';
$string['nousers'] = 'Esta actividad del Tablero no tiene usuarios inscriptos';
$string['opensinnewwindow'] = 'Se abre en una ventana nueva';
$string['option_empty'] = 'Ninguno';
$string['option_image'] = 'Imagen';
$string['option_image_info'] = 'Título de la imagen';
$string['option_image_url'] = 'URL de la imagen';
$string['option_link'] = 'Enlace';
$string['option_link_info'] = 'Título del enlace';
$string['option_link_url'] = 'URL del enlace';
$string['option_youtube'] = 'Video (YouTube)';
$string['option_youtube_info'] = 'Título del video';
$string['option_youtube_url'] = 'URL de YouTube';
$string['pluginadministration'] = 'Administración del módulo Tablero';
$string['pluginname'] = 'Tablero';
$string['post_button_text'] = 'Publicación';
$string['post_max_length'] = 'Longitud máxima de la publicación';
$string['post_max_length_desc'] = 'La longitud máxima permitida del contenido. Todo lo que supere esta longitud será recortado.';
$string['postbydate'] = 'Publicación por fecha';
$string['postbyenabled'] = 'Limitar publicaciones de estudiantes por fecha';
$string['posts'] = 'Publicaciones';
$string['privacy:metadata:board_comments'] = 'Comentarios para cada publicación del tablero.';
$string['privacy:metadata:board_comments:content'] = 'El contenido del comentario en la publicación';
$string['privacy:metadata:board_comments:noteid'] = 'El ID de la publicación relacionada.';
$string['privacy:metadata:board_comments:timecreated'] = 'La hora de  cuando fue creado el comentario de la publicación';
$string['privacy:metadata:board_comments:userid'] = 'El ID del usuario que añadió el comentario en la publicación';
$string['privacy:metadata:board_history'] = 'El historial temporal del tablero registra información, utilizada por los procesos javaScript para actualizar las vistas del Tablero y luego eliminada inmediatamente.';
$string['privacy:metadata:board_history:action'] = 'Acción realizada';
$string['privacy:metadata:board_history:boardid'] = 'El ID del tablero';
$string['privacy:metadata:board_history:content'] = 'Los datos JSON de la acción realizada';
$string['privacy:metadata:board_history:timecreated'] = 'Hora en la cual la acción fue realizada';
$string['privacy:metadata:board_history:userid'] = 'El ID del usuario que realizó la acción';
$string['privacy:metadata:board_note_ratings'] = 'Información sobre las calificaciones individuales de cada publicación del Tablero.';
$string['privacy:metadata:board_note_ratings:noteid'] = 'El ID de la publicación relacionada';
$string['privacy:metadata:board_note_ratings:timecreated'] = 'Hora en que se creó la calificación de la publicación.';
$string['privacy:metadata:board_note_ratings:userid'] = 'El ID del usuario que creó la calificación de la publicación.';
$string['privacy:metadata:board_notes'] = 'Información sobre las publicaciones individuales de cada tablero.';
$string['privacy:metadata:board_notes:columnid'] = 'Ubicación de la columna de la publicación';
$string['privacy:metadata:board_notes:content'] = 'Contenido de la publicación';
$string['privacy:metadata:board_notes:heading'] = 'Encabezado del post';
$string['privacy:metadata:board_notes:info'] = 'Información del medio de la publicación';
$string['privacy:metadata:board_notes:timecreated'] = 'Hora en que se creó la publicación';
$string['privacy:metadata:board_notes:url'] = 'La URL del medio de la publicación';
$string['privacy:metadata:board_notes:userid'] = 'El ID del usuario que creó la publicación';
$string['rate_note_text'] = '¿Estás seguro de que quieres calificar esta publicación?';
$string['rate_note_title'] = 'Confirmar';
$string['rate_remove_note_text'] = '¿Estás seguro de que deseas eliminar la calificación de esta publicación?';
$string['ratings'] = 'Calificaciones';
$string['remove_column_text'] = '¿Está seguro de que desea eliminar esta columna "{$a}" y todas las publicaciones que contiene?';
$string['remove_column_title'] = 'Confirmar';
$string['remove_note_text'] = '¿Estás seguro de que deseas eliminar esta publicación y todos los datos que contiene, ya que esto afectará también a los demás usuarios?';
$string['remove_note_title'] = 'Confirmar';
$string['selectuser'] = 'Seleccionar usuario';
$string['selectuserplease'] = 'Por favor seleccione un usuario';
$string['singleusermode'] = 'Modo de usuario único';
$string['singleusermode_desc'] = 'En modo "usuario único", los usuarios solo pueden agregar publicaciones en su propio tablero. En "privado" los usuarios no pueden ver los Tableros de otros usuarios. En "público" los Tableros de usuarios están disponibles a través de un menú desplegable.';
$string['singleusermodenone'] = 'Desactivado';
$string['singleusermodenotembed'] = 'Tablero no permite insertar un tablero de usuario único. Por favor cambie su configuración.';
$string['singleusermodeprivate'] = 'Modo de usuario único (privado)';
$string['singleusermodepublic'] = 'Modo de usuario único (público)';
$string['sortby'] = 'Ordenar por';
$string['sortbydate'] = 'Fecha de creación';
$string['sortbynone'] = 'Ninguno';
$string['sortbyrating'] = 'Clasificación';
$string['userscanedit'] = 'Permitir a todos los usuarios editar la ubicación de sus propias publicaciones.';
$string['viewboard'] = 'Ver actividad del Tablero';
$string['warning'] = 'Notificación';
