<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'el', version '4.3'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Δραστηριότητες';
$string['addcategory'] = 'Προσθήκη Κατηγορίας';
$string['addcategoryerror'] = 'Δεν ήταν δυνατή η προσθήκη κατηγορίας.';
$string['addexceptionerror'] = 'Παρουσιάστηκε σφάλμα κατά την προσθήκη εξαίρεσης για το userid:gradeitem (αναγνωριστικό χρήστη:στοιχείο βαθμού)';
$string['addfeedback'] = 'Προσθήκη ανατροφοδότησης';
$string['addgradeletter'] = 'Προσθήκη ενός γράμματος βαθμού';
$string['addidnumbers'] = 'Προσθήκη αναγνωριστικών αριθμών';
$string['additem'] = 'Προσθήκη στοιχείου βαθμού';
$string['additionalfeedback'] = 'Επιπρόσθετη ανατροφοδότηση';
$string['addoutcome'] = 'Προσθήκη ενός μαθησιακού αποτελέσματος';
$string['addoutcomeitem'] = 'Προσθήκη ενός επιμέρους στοιχείου μαθησιακού αποτελέσματος';
$string['addscale'] = 'Προσθήκη μιας κλίμακας';
$string['adjustedweight'] = 'Ρύθμιση/προσαρμογή με συντελεστή βαρύτητας';
$string['aggregateextracreditmean'] = 'Μέσος όρος βαθμών (με πριμοδότηση)';
$string['aggregatemax'] = 'Υψηλότερος βαθμός';
$string['aggregatemean'] = 'Μέσος όρος βαθμών';
$string['aggregatemedian'] = 'Διάμεσος βαθμών';
$string['aggregatemin'] = 'Χαμηλότερος βαθμός';
$string['aggregatemode'] = 'Επικρατούσα τιμή βαθμολογιών';
$string['aggregatenotonlygraded'] = 'Να συμπεριληφθούν οι κενοί βαθμοί';
$string['aggregateonlygraded'] = 'Να μην συμπεριληφθούν οι κενοί βαθμοί';
$string['aggregateonlygraded_help'] = 'Ένας κενός βαθμός είναι ένας βαθμός που λείπει από το βαθμολόγιο. Μπορεί να αντιστοιχεί στην υποβολή μιας εργασίας η οποία δεν έχει βαθμολογηθεί ακόμα ή σε ένα κουίζ που δεν έχει απαντηθεί ακόμα κτλ. Αυτή η ρύθμιση καθορίζει αν οι κενοί βαθμοί δεν θα περιλαμβάνονται στην συνάθροιση ή θα υπολογίζονται ως ελάχιστοι βαθμοί, για παράδειγμα 0 για μια ανάθεση που βαθμολογείται μεταξύ 0 και 100.';
$string['aggregateoutcomes'] = 'Συμπερίληψη μαθησιακών αποτελεσμάτων στη συνάθροιση';
$string['aggregateoutcomes_help'] = 'Αν ενεργοποιηθεί, τα μαθησιακά αποτελέσματα περιλαμβάνονται στην συνάθροιση. Αυτό μπορεί να οδηγήσει σε ένα απροσδόκητο σύνολο κατηγορίας.';
$string['aggregatesonly'] = 'Αλλαγή μόνο σε συναθροίσεις';
$string['aggregatesubcatsupgradedgrades'] = 'Σημείωση: Η ρύθμιση συνάθροισης «Συνάθροιση με συμπερίληψη υποκατηγοριών» έχει αφαιρεθεί ως μέρος μιας αναβάθμισης του ιστοτόπου. Επειδή το «Συνάθροιση με συμπερίληψη υποκατηγοριών» χρησιμοποιήθηκε προηγουμένως στο παρόν μάθημα, συνιστάται να ξαναεξετάσετε αυτή την αλλαγή στο βαθμολόγιο.';
$string['aggregatesum'] = 'Φυσική συνάθροιση';
$string['aggregateweightedmean'] = 'Σταθμισμένος μέσος βαθμών';
$string['aggregateweightedmean2'] = 'Απλός σταθμισμένος μέσος βαθμών';
$string['aggregation'] = 'Συνάθροιση';
$string['aggregation_help'] = 'Η συνάθροιση καθορίζει πως συνδυάζονται οι βαθμοί σε μια κατηγορία, όπως:

* Μέσος όρος βαθμολογιών - Το σύνολο όλων των βαθμολογιών διαιρεμένο με τον συνολικό αριθμό των βαθμών.
* Διάμεσος βαθμολογιών - Ο μεσαίος βαθμός όταν οι βαθμοί είναι διατεταγμένοι κατά σειρά μεγέθους.
* Χαμηλότερος βαθμός.
* Υψηλότερος βαθμός.
* Επικρατούσα βαθμολογία - Ο βαθμός που εμφανίζεται πιο συχνά.
* Φυσική συνάθροιση - Το άθροισμα όλων των βαθμών, όπου κάθε βαθμός σταθμίζεται (πολλαπλασιάζεται) πρώτα με τον συντελεστή βαρύτητάς του.
 (Δείτε την βοήθεια για Grade aggregation.)';
$string['aggregation_link'] = '';
$string['aggregationcoef'] = 'Συντελεστής (βαρύτητας) στη συνάθροιση';
$string['aggregationcoefextra'] = 'Πριμοδότηση';
$string['aggregationcoefextra_help'] = 'Αν η συνάθροιση ορίστηκε σε «Φυσική συνάθροιση» ή «Απλός σταθμισμένος μέσος» και το πλαίσιο επιλογής πριμοδότησης είναι επιλεγμένο, τότε ο μέγιστος βαθμός του στοιχείου βαθμού δεν προστίθεται στο μέγιστο βαθμό της κατηγορίας.
Αυτό θα έχει σαν αποτέλεσμα την πιθανότητα να επιτευχθεί ο μέγιστος βαθμός στην κατηγορία χωρίς να έχει επιτευχθεί ο μέγιστος βαθμός σε όλα τα στοιχεία του βαθμού.
Αν ο διαχειριστής του ιστοτόπου έχει ενεργοποιήσει τους βαθμούς πάνω από το μέγιστο, μπορεί να υπάρξουν βαθμοί πάνω από το μέγιστο.
Αν η συνάθροιση είναι «Μέσος όρος βαθμών (με πριμοδότηση)» και η πριμοδότηση είναι ορισμένη σε μια τιμή μεγαλύτερη από μηδέν, τότε η πριμοδότηση είναι ο παράγοντας με τον οποίο ο βαθμός πολλαπλασιάζεται πριν προστεθεί στο σύνολο μετά από τον υπολογισμό του (σταθμισμένου) μέσου όρου.';
$string['aggregationcoefextra_link'] = '';
$string['aggregationcoefextrasum'] = 'Πριμοδότηση';
$string['aggregationcoefextrasum_help'] = 'Αν το πλαίσιο επιλογής πριμοδότησης είναι επιλεγμένο, τότε ο μέγιστος βαθμός του στοιχείου βαθμού δεν προστίθεται στον μέγιστο βαθμό της κατηγορίας, με αποτέλεσμα να είναι πιθανό να επιτευχθεί ο μέγιστος βαθμός (ή βαθμοί πάνω από το μέγιστο αν ενεργοποιήθηκε από τον διαχειριστή του ιστοτόπου) στην κατηγορία, χωρίς να έχει επιτευχθεί ο μέγιστος βαθμός σε όλα τα στοιχεία του βαθμού.';
$string['aggregationcoefextrasum_link'] = '';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Συντελεστής βαρύτητας της πριμοδότησης';
$string['aggregationcoefextraweight_help'] = 'Αν ο συντελεστής βαρύτητας της πριμοδότησης έχει τεθεί σε μια τιμή μεγαλύτερη από μηδέν, τότε ο βαθμός ενεργεί ως πριμοδότηση κατά την συνάθροιση. Ο αριθμός αυτός είναι ο παράγοντας με τον οποίο ο βαθμός θα πολλαπλασιαστεί πριν την πρόσθεσή του στο σύνολο για τον υπολογισμό του (σταθμισμένου) μέσου όρου.';
$string['aggregationcoefextraweight_link'] = '';
$string['aggregationcoefweight'] = 'Συντελεστής βαρύτητας στοιχείου';
$string['aggregationcoefweight_help'] = 'Ο συντελεστής βαρύτητας του στοιχείου βαθμού χρησιμοποιείται στην συνάθροιση κατηγορίας για να επηρεάσει την σπουδαιότητα του στοιχείου σε σύγκριση με άλλα στοιχεία στην ίδια κατηγορία.';
$string['aggregationcoefweight_link'] = '';
$string['aggregationhintdropped'] = '( Απορρίφθηκε )';
$string['aggregationhintexcluded'] = '( Εξαιρέθηκε )';
$string['aggregationhintextra'] = '( Πριμοδότηση )';
$string['aggregationhintnovalue'] = '( Κενό )';
$string['aggregationofa'] = 'Συνάθροιση από {$a}';
$string['aggregationposition'] = 'Θέση συνάθροισης';
$string['aggregationposition_help'] = 'Αυτή η ρύθμιση καθορίζει αν οι στήλες της κατηγορίας και του συνολικού βαθμού του μαθήματος θα εμφανίζονται πρώτα ή τελευταία στις αναφορές του βαθμολογίου.';
$string['aggregationsvisible'] = 'Διαθέσιμοι τύποι συνάθροισης';
$string['aggregationsvisiblehelp'] = 'Επιλέξτε όλους τους τύπους συνάθροισης που θα πρέπει να είναι διαθέσιμοι. Κρατήστε πατημένο το πλήκτρο Ctrl για να επιλέξετε πολλαπλά στοιχεία.';
$string['allgrades'] = 'Όλοι οι βαθμοί ανά κατηγορία';
$string['allstudents'] = 'Όλοι οι μαθητές';
$string['allusers'] = 'Όλοι οι χρήστες';
$string['autosort'] = 'Αυτόματη ταξινόμηση';
$string['availableidnumbers'] = 'Διαθέσιμοι αναγνωριστικοί αριθμοί';
$string['average'] = 'Μέσος όρος';
$string['averagesdecimalpoints'] = 'Δεκαδικά στους μέσους όρους στηλών';
$string['averagesdecimalpoints_help'] = 'Αυτή η ρύθμιση καθορίζει τον αριθμό δεκαδικών ψηφίων που θα εμφανίζονται για κάθε μέσο όρο ή αν θα χρησιμοποιείται (κληρονομείται) η γενική ρύθμιση δεκαδικών ψηφίων για την κατηγορία ή το στοιχείο βαθμού.';
$string['averagesdisplaytype'] = 'Τύπος εμφάνισης μέσων όρων στηλών';
$string['averagesdisplaytype_help'] = 'Αυτή η ρύθμιση καθορίζει αν ο μέσος όρος εμφανίζεται ως πραγματικός βαθμός, ποσοστό ή γράμμα, ή αν ο τύπος εμφάνισης για την κατηγορία ή το στοιχείο βαθμού χρησιμοποιείται (κληρονομεί).';
$string['backupwithoutgradebook'] = 'Το αντίγραφο ασφαλείας δεν περιέχει ρυθμίσεις βαθμολογίου';
$string['badgrade'] = 'Ο βαθμός που δόθηκε δεν είναι έγκυρος';
$string['badlyformattedscale'] = 'Παρακαλούμε εισάγεται μια λίστα τιμών χωρισμένες με κόμμα (απαιτούνται τουλάχιστον δύο τιμές).';
$string['baduser'] = 'Ο χρήστης που δόθηκε δεν είναι έγκυρος';
$string['bonuspoints'] = 'Βαθμοί Μπόνους';
$string['bulkcheckboxes'] = 'Μαζικά πλαίσια επιλογής';
$string['calculatedgrade'] = 'Υπολογισμένος βαθμός';
$string['calculation'] = 'Υπολογισμός';
$string['calculation_help'] = 'Ο υπολογισμός του βαθμού είναι ένας τύπος που χρησιμοποιείται για να καθορίζει τους βαθμούς. Ο τύπος πρέπει να αρχίζει με ένα ίσον «=» και μπορεί να χρησιμοποιεί κοινούς μαθηματικούς τελεστές όπως μέγιστο, ελάχιστο και άθροισμα. Αν είναι επιθυμητό, μπορούν να περιλαμβάνονται στον υπολογισμό και άλλα στοιχεία βαθμού πληκτρολογώντας τον αναγνωριστικό αριθμό τους μέσα σε διπλές αγκύλες.';
$string['calculation_link'] = '';
$string['calculationadd'] = 'Προσθήκη υπολογισμού';
$string['calculationedit'] = 'Επεξεργασία υπολογισμού';
$string['calculationsaved'] = 'Ο υπολογισμός αποθηκεύθηκε';
$string['calculationview'] = 'Εμφάνιση υπολογισμού';
$string['cannotaccessgroup'] = 'Αδυναμία πρόσβασης στους βαθμούς της επιλεγμένης ομάδας, συγγνώμη.';
$string['categories'] = 'Κατηγορίες';
$string['category'] = 'Κατηγορία';
$string['categoryedit'] = 'Επεξεργασία κατηγορίας';
$string['categoryname'] = 'Όνομα κατηγορίας';
$string['categorytotal'] = 'Σύνολο κατηγορίας';
$string['categorytotalfull'] = '{$a->category} συνολικά';
$string['categorytotalname'] = 'Συνολικό όνομα κατηγορίας';
$string['changedefaults'] = 'Αλλαγή προεπιλογών';
$string['changereportdefaults'] = 'Αλλαγή προεπιλογών αναφοράς';
$string['chooseaction'] = 'Επιλέξτε μια ενέργεια ...';
$string['choosecategory'] = 'Επιλογή Κατηγορίας';
$string['collapsecriterion'] = 'Κριτήριο σύμπτυξης';
$string['combo'] = 'Καρτέλες και πτυσσόμενο μενού';
$string['compact'] = 'Συμπαγής';
$string['componentcontrolsvisibility'] = 'Το αν αυτό το στοιχείο βαθμού είναι σε απόκρυψη ελέγχεται από τις ρυθμίσεις της δραστηριότητας.';
$string['contract'] = 'Συστολή κατηγορίας';
$string['contributiontocoursetotal'] = 'Συνεισφορά στον τελικό βαθμό';
$string['controls'] = 'Έλεγχοι';
$string['courseavg'] = 'Μέσος όρος μαθήματος';
$string['coursegradecategory'] = 'Κατηγορία βαθμού μαθήματος';
$string['coursegradedisplaytype'] = 'Τρόπος εμφάνισης βαθμού μαθήματος';
$string['coursegradedisplayupdated'] = 'Ο τρόπος εμφάνισης βαθμού μαθήματος ανανεώθηκε.';
$string['coursegradesettings'] = 'Ρυθμίσεις βαθμού μαθήματος';
$string['coursename'] = 'Όνομα μαθήματος';
$string['coursescales'] = 'Κλίμακες μαθήματος';
$string['coursesettings'] = 'Ρυθμίσεις μαθήματος';
$string['coursesettingsexplanation'] = 'Οι ρυθμίσεις βαθμών του μαθήματος καθορίζουν το πώς εμφανίζεται το βαθμολόγιο για όλους τους συμμετέχοντες στο μάθημα.';
$string['coursesiamtaking'] = 'Μαθήματα που παρακολουθώ';
$string['coursesiamteaching'] = 'Μαθήματα στα οποία διδάσκω';
$string['coursetotal'] = 'Σύνολο μαθήματος';
$string['createcategory'] = 'Δημιουργία κατηγορίας';
$string['createcategoryerror'] = 'Δεν ήταν δυνατή η δημιουργία μιας νέας κατηγορίας';
$string['creatinggradebooksettings'] = 'Δημιουργία ρυθμίσεων βαθμολογίου';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Τρέχουσα συνάθροιση γονέα';
$string['curveto'] = 'Καμπύλη προς';
$string['decimalpoints'] = 'Γενική ρύθμιση δεκαδικών ψηφίων';
$string['decimalpoints_help'] = 'Αυτή η ρύθμιση καθορίζει τον αριθμό δεκαδικών ψηφίων που θα εμφανίζονται για κάθε βαθμό. Δεν έχει καμία επίδραση στο βαθμό υπολογισμού, ο οποίος υπολογίζεται με ακρίβεια 5 δεκαδικών ψηφίων.';
$string['default'] = 'Προεπιλογή';
$string['defaultprev'] = 'Προεπιλογή ({$a})';
$string['deletecategory'] = 'Διαγραφή Κατηγορίας';
$string['disablegradehistory'] = 'Απενεργοποίηση ιστορικού βαθμών';
$string['disablegradehistory_help'] = 'Απενεργοποίηση του ιστορικού παρακολούθησης αλλαγών σε πίνακες σχετικούς με βαθμούς. Αυτό μπορεί να αυξήσει λίγο την ταχύτητα του εξυπηρετητή και να εξοικονομήσει χώρο στη βάση δεδομένων.';
$string['displaylettergrade'] = 'Εμφάνιση Γραμματικών Βαθμών';
$string['displaypercent'] = 'Εμφάνιση Ποσοστών';
$string['displaypoints'] = 'Εμφάνιση Πόντων';
$string['displayweighted'] = 'Εμφάνιση σταθμισμένων βαθμών';
$string['dropdown'] = 'Πτυσσόμενο μενού';
$string['droplow'] = 'Απόρριψη των χαμηλότερων';
$string['droplow_help'] = 'Αυτή η ρύθμιση επιτρέπει ένας καθοριζόμενος αριθμός από τις χαμηλότερες βαθμολογίες να εξαιρείται από τη συνάθροιση.';
$string['droplowestvalue'] = 'Ορίστε να απορρίπτεται ο βαθμός με τη χαμηλότερη τιμή';
$string['droplowestvalues'] = 'Να απορρίπτονται οι {$a} χαμηλότερες τιμές';
$string['dropped'] = 'Απορρίφθηκαν';
$string['dropxlowest'] = 'Απόρριψη Χ χαμηλότερων';
$string['dropxlowestwarning'] = 'Σημείωση: Εάν χρησιμοποιήσετε το Απόρριψη Χ χαμηλότερων η βαθμολόγηση υποθέτει ότι όλα τα αντικείμενα στην κατηγορία έχουν τους ίδιους πόντους. Εάν οι τιμές πόντων διαφέρουν, τα αποτελέσματα θα είναι απρόβλεπτα.';
$string['duplicatedgradeitem'] = '{$a} (αντίγραφο)';
$string['duplicatescale'] = 'Αντίγραφο κλίμακας';
$string['edit'] = 'Επεξεργασία';
$string['editcalculation'] = 'Επεξεργασία υπολογισμού';
$string['editcalculationverbose'] = 'Επεξεργασία υπολογισμού για {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Επεξεργασία ανατροφοδότησης';
$string['editgrade'] = 'Επεξεργασία βαθμού';
$string['editgradeletters'] = 'Επεξεργασία γραμμάτων βαθμολόγησης';
$string['editoutcome'] = 'Επεξεργασία μαθησιακού αποτελέσματος';
$string['editoutcomes'] = 'Επεξεργασία μαθησιακών αποτελεσμάτων';
$string['editscale'] = 'Επεξεργασία κλίμακας';
$string['edittree'] = 'Ρυθμίσεις (Κατηγορίες & στοιχεία)';
$string['editverbose'] = 'Επεξεργασία {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Ενεργοποίηση AJAX';
$string['enableajax_help'] = 'Προσθέτει ένα επίπεδο λειτουργικότητας AJAX στην αναφορά του βαθμολογητή, απλοποιώντας και επιταχύνοντας συχνές λειτουργίες. Εξαρτάται από την ενεργοποίηση της Javascript στον περιηγητή του χρήστη.';
$string['enableoutcomes'] = 'Ενεργοποίηση μαθησιακών αποτελεσμάτων';
$string['enableoutcomes_help'] = 'Αν ενεργοποιηθεί, τα στοιχεία βαθμού μπορούν να βαθμολογηθούν χρησιμοποιώντας μία ή περισσότερες κλίμακες που είναι συνδεδεμένες με δηλώσεις μαθησιακών αποτελεσμάτων (outcomes, εκβάσεις).';
$string['encoding'] = 'Κωδικοποίηση';
$string['encoding_help'] = 'Επιλέξτε την κωδικοποίηση χαρακτήρων που χρησιμοποιείται για τα δεδομένα. (Η τυπική κωδικοποίηση είναι UTF-8.) Εάν η εσφαλμένη κωδικοποίηση έχει επιλεγεί κατά λάθος, θα είναι εμφανής κατά την προεπισκόπηση των δεδομένων για εισαγωγή.';
$string['errorcalculationbroken'] = 'Πιθανόν κυκλική αναφορά ή εσφαλμένος τύπος υπολογισμού';
$string['errorcalculationnoequal'] = 'Ο τύπος πρέπει να ξεκινάει με το σημάδι του ίσον (=1+2)';
$string['errorcalculationunknown'] = 'Μη έγκυρος τύπος';
$string['errorgradevaluenonnumeric'] = 'Παραλήφθηκαν μη-αριθμητικά για χαμηλό ή υψηλό βαθμό για';
$string['errornocalculationallowed'] = 'Οι υπολογισμοί δεν επιτρέπονται για αυτό το στοιχείο';
$string['errornocategorisedid'] = 'Δεν ήταν δυνατή η λήψη ενός μη κατηγοριοποιημένου αναγνωριστικού!';
$string['errornocourse'] = 'Δεν ήταν δυνατή η ανάκτηση πληροφοριών μαθήματος';
$string['errorreprintheadersnonnumeric'] = 'Παραλήφθηκαν μη-αριθμητικές τιμές για κεφαλίδες επανεκτύπωσης';
$string['errorsavegrade'] = 'Δεν ήταν δυνατή η δυνατή η αποθήκευση βαθμού.';
$string['errorsettinggrade'] = 'Σφάλμα κατά την αποθήκευση «{$a->itemname}» βαθμού για το αναγνωριστικό χρήστη {$a->userid}';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Σφάλμα κατά την ενημέρωση της ρύθμισης «Συνάθροιση μόνο βαθμολογημένων στοιχείων» για την κατηγορία βαθμών με αναγνωριστικό (ID) {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Σφάλμα κατά την ενημέρωση της ρύθμισης «Συμπερίληψη μαθησιακών αποτελεσμάτων στη συνάθροιση» για την κατηγορία βαθμών με αναγνωριστικό (ID) {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Σφάλμα κατά την ενημέρωση του τύπου συνάθροισης για την κατηγορία βαθμών με αναγνωριστικό (ID) {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Σφάλμα κατά την ενημέρωση του συντελεστή (βαρύτητας ή πριμοδότησης) συνάθροισης για το στοιχείο βαθμού με αναγνωριστικό (ID) {$a->id}';
$string['eventgradedeleted'] = 'Ο βαθμός διαγράφηκε';
$string['eventgradeitemcreated'] = 'Το στοιχείο βαθμού δημιουργήθηκε';
$string['eventgradeitemdeleted'] = 'Το στοιχεία βαθμού διαγράφηκε';
$string['eventgradeitemupdated'] = 'Το στοιχείο βαθμού ενημερώθηκε';
$string['eventgradelettercreated'] = 'Ο βαθμός με γράμμα δημιουργήθηκε';
$string['eventgradeletterdeleted'] = 'Ο βαθμός με γράμμα διαγράφηκε';
$string['eventgradeletterupdated'] = 'Ο βαθμός με γράμμα ενημερώθηκε';
$string['eventgradeviewed'] = 'Οι βαθμοί προβλήθηκαν στο βαθμολόγιο';
$string['eventscalecreated'] = 'Η κλίμακα δημιουργήθηκε';
$string['eventscaledeleted'] = 'Η κλίμακα διαγράφηκε';
$string['eventscaleupdated'] = 'Η κλίμακα ενημερώθηκε';
$string['eventusergraded'] = 'Ο χρήστης βαθμολογήθηκε';
$string['excluded'] = 'Εξαιρέθηκε';
$string['excluded_help'] = 'Αν επιλεγεί, ο βαθμός δεν θα περιληφθεί σε καμία συνάθροιση.';
$string['expand'] = 'Ανάπτυξη κατηγορίας';
$string['expandcriterion'] = 'Κριτήριο ανάπτυξης';
$string['export'] = 'Εξαγωγή';
$string['exportalloutcomes'] = 'Εξαγωγή όλων των μαθησιακών αποτελεσμάτων';
$string['exportfeedback'] = 'Ενσωμάτωση ανατροφοδότησης στην εξαγωγή';
$string['exportfeedback_desc'] = 'Αυτό μπορεί να παρακαμφθεί κατά την εξαγωγή.';
$string['exportformatoptions'] = 'Επιλογές μορφής εξαγωγής';
$string['exportonlyactive'] = 'Εξαίρεση χρηστών σε αναστολή';
$string['exportonlyactive_help'] = 'Να συμπεριληφθούν στην εξαγωγή μόνο μαθητές των οποίων η εγγραφή είναι ενεργή και δεν έχει ανασταλεί';
$string['exportplugins'] = 'Πρόσθετα εξαγωγής';
$string['exportsettings'] = 'Εξαγωγή ρυθμίσεων';
$string['exportto'] = 'Εξαγωγή σε';
$string['externalurl'] = 'Εξωτερική διεύθυνση URL';
$string['externalurl_desc'] = 'Αν χρησιμοποιείται εξωτερικό βαθμολόγιο, η διεύθυνση URL πρέπει να καθοριστεί εδώ.';
$string['extracreditvalue'] = 'Τιμή πριμοδότησης για {$a}';
$string['extracreditwarning'] = 'Σημείωση: Η ρύθμιση όλων των αντικειμένων μίας κατηγορίας για έξτρα έπαινο, θα τα αφαιρέσει από τον υπολογισμό βαθμού. Καθώς δεν θα υπάρχει σύνολο πόντων.';
$string['fail'] = 'Αποτυχία';
$string['feedback'] = 'Ανατροφοδότηση';
$string['feedback_help'] = 'Αυτό το κουτάκι επιτρέπει οποιαδήποτε σχόλια σχετικά με την προσθήκη του βαθμού.';
$string['feedbackadd'] = 'Προσθήκη ανατροφοδότησης';
$string['feedbackedit'] = 'Επεξεργασία ανατροφοδότησης';
$string['feedbackfiles'] = 'Αρχεία ανατροφοδότησης';
$string['feedbackforgradeitems'] = 'Ανατροφοδότηση για {$a}';
$string['feedbackhistoryfiles'] = 'Αρχεία ιστορικού ανατροφοδότησης';
$string['feedbacks'] = 'Ανατροφοδοτήσεις';
$string['feedbacksaved'] = 'Η ανατροφοδότηση αποθηκεύτηκε';
$string['feedbackview'] = 'Εμφάνιση ανατροφοδότησης';
$string['finalgrade'] = 'Τελικός βαθμός';
$string['finalgrade_help'] = 'Εάν επιλεγεί το πλαίσιο επιλογής που έχει παρακαμφθεί, μπορεί να προστεθεί ή να τροποποιηθεί ένας βαθμός.';
$string['fixedstudents'] = 'Στατική στήλη μαθητών';
$string['fixedstudents_help'] = 'Επιτρέπει στους βαθμούς να κυλάνε οριζόντια χωρίς να χάνεται η οπτική της στήλης των μαθητών, κάνοντας την στατική.';
$string['forceimport'] = 'Υποχρεωτική εισαγωγή';
$string['forceimport_help'] = 'Υποχρεωτική εισαγωγή βαθμών ακόμα κι αν οι βαθμοί ενημερώθηκαν αφού το αρχείο εισαγωγής είχε εξαχθεί';
$string['forceoff'] = 'Επιβολή: απενεργοποίηση';
$string['forceon'] = 'Επιβολή: ενεργοποίηση';
$string['forelementtypes'] = 'για τους επιλεγμένους {$a}';
$string['forstudents'] = 'Για μαθητές';
$string['full'] = 'Πλήρες';
$string['fullmode'] = 'Εναλλαγή σε πλήρη εμφάνιση';
$string['generalsettings'] = 'Γενικές ρυθμίσεις';
$string['grade'] = 'Βαθμός';
$string['grade_help'] = 'Ο βαθμός που απονέμεται στον μαθητή για την εργασία του.';
$string['gradeadministration'] = 'Διαχείριση βαθμολογιών';
$string['gradealreadyupdated'] = 'Δεν έχουν εισαχθεί {$a} βαθμοί επειδή οι βαθμοί στο αρχείο εισαγωγής είναι παλαιότεροι από ότι στην αναφορά βαθμολογητή. Για να συνεχίσετε με την εισαγωγή βαθμού ούτως ή άλλως, χρησιμοποιήστε την επιλογή υποχρεωτικής εισαγωγής.';
$string['gradeanalysis'] = 'Ανάλυση βαθμού';
$string['gradebook'] = 'Βαθμολόγιο';
$string['gradebookcalculationsfixbutton'] = 'Αποδοχή αλλαγών βαθμού και διόρθωση σφαλμάτων υπολογισμού';
$string['gradebookcalculationsuptodate'] = 'Οι υπολογισμοί στο βαθμολόγιο είναι ενημερωμένοι. Ίσως χρειαστεί να φορτώσετε ξανά αυτή τη σελίδα για να δείτε τις αλλαγές.';
$string['gradebookcalculationswarning'] = 'Σημείωση: Έχουν εντοπιστεί ορισμένα σφάλματα κατά τον υπολογισμό των βαθμών που εμφανίζονται στο βαθμολόγιο. Εάν το μάθημά σας δεν έχει ξεκινήσει ή βρίσκεται σε εξέλιξη, συνιστάται να διορθωθούν τα σφάλματα κάνοντας κλικ στο παρακάτω κουμπί, αν και αυτό θα έχει ως αποτέλεσμα την αλλαγή ορισμένων βαθμών. Εάν το μάθημά σας έχει ήδη λήξει και έχουν υποβληθεί βαθμοί, πιθανώς δεν θέλετε να διορθώσετε αυτό το ζήτημα.

Η νεότερη έκδοση είναι {$a->currentversion}· χρησιμοποιείτε την έκδοση βαθμολογίου {$a->gradebookversion}. Μπορείτε να δείτε μια λίστα αλλαγών στις <a href="{$a->url}">Αλλαγές υπολογισμών βαθμολογίου</a>.';
$string['gradebookhiddenerror'] = 'Το βαθμολόγιο είναι αυτή τη στιγμή ρυθμισμένο να κρύβει τα πάντα από τους μαθητές.';
$string['gradebookhistories'] = 'Ιστορικά βαθμών';
$string['gradebooksetup'] = 'Ρύθμιση βαθμολογίου';
$string['gradeboundary'] = 'Όριο βαθμού με γράμματα';
$string['gradeboundary_help'] = 'Αυτή η ρύθμιση καθορίζει το ελάχιστο ποσοστό κατά το οποίο οι βαθμοί θα αποδίδονται στο βαθμό γράμμα.';
$string['gradecategories'] = 'Κατηγορίες βαθμού';
$string['gradecategory'] = 'Κατηγορία βαθμού';
$string['gradecategoryonmodform'] = 'Κατηγορία βαθμού';
$string['gradecategoryonmodform_help'] = 'Αυτή η ρύθμιση ελέγχει την κατηγορία, στην οποία οι βαθμοί της δραστηριότητας θα τοποθετηθούν, στο βαθμολόγιο.';
$string['gradecategorysettings'] = 'Ρυθμίσεις κατηγορίας βαθμού';
$string['gradedisplay'] = 'Εμφάνιση βαθμού';
$string['gradedisplaytype'] = 'Τρόπος εμφάνισης βαθμού';
$string['gradedisplaytype_help'] = 'Αυτή η ρύθμιση καθορίζει πως εμφανίζονται οι βαθμοί στις αναφορές βαθμολογητή και χρήστη.

* Γράμμα - Γράμματα ή λέξεις χρησιμοποιούνται που αντιπροσωπεύουν ένα εύρος βαθμών, όπως ορίζεται στα «Γράμματα» στη ρύθμιση του βαθμολογίου
* Ποσοστό - Σε σχέση με τους μέγιστους και τους ελάχιστους βαθμούς
* Πραγματικός βαθμός - Πραγματικές τιμές ή τιμές κλίμακας';
$string['gradedon'] = 'Βαθμολογημένα: {$a}';
$string['gradeexport'] = 'Εξαγωγή βαθμολογίας';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Προσαρμοσμένα πεδία προφίλ εξαγωγής βαθμών';
$string['gradeexportcustomprofilefields_desc'] = 'Συμπερίληψη αυτών των προσαρμοσμένων πεδίων προφίλ στην εξαγωγή βαθμών, διαχωρισμένων με κόμμα.';
$string['gradeexportdecimalpoints'] = 'Δεκαδικά ψηφία εξαγωγής βαθμών';
$string['gradeexportdecimalpoints_desc'] = 'Ο αριθμός δεκαδικών ψηφίων που θα εμφανίζονται κατά την εξαγωγή. Μπορεί να παρακαμφθεί κατά την εξαγωγή.';
$string['gradeexportdisplaytype'] = 'Τρόπος εμφάνισης εξαγωγής βαθμού';
$string['gradeexportdisplaytype_desc'] = 'Οι βαθμοί μπορούν να εμφανίζονται σαν πραγματικοί βαθμοί, σαν ποσοστά (σε σχέση με τον ελάχιστο και μέγιστο βαθμό) ή σαν γράμματα (A, B, C κλπ.) κατά την εξαγωγή. Αυτό μπορεί να παρακαμφθεί κατά την εξαγωγή.';
$string['gradeexportdisplaytypes'] = 'Τρόποι εμφάνισης εξαγωγής βαθμού';
$string['gradeexportuserprofilefields'] = 'Πεδία προφίλ χρήστη εξαγωγής βαθμών';
$string['gradeexportuserprofilefields_desc'] = 'Συμπερίληψη αυτών των πεδίων προφίλ χρήστη στην εξαγωγή βαθμών, διαχωρισμένων με κόμμα.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Αρχικοί ελάχιστοι και μέγιστοι βαθμοί';
$string['gradehelp'] = 'Βοήθεια βαθμών';
$string['gradehistorylifetime'] = 'Διάρκεια ζωής ιστορικού βαθμών';
$string['gradehistorylifetime_help'] = 'Ορίζει το μέγεθος του χρόνου για τον οποίο θέλετε να κρατάτε το ιστορικό των αλλαγών στους πίνακες που σχετίζονται με βαθμούς. Συνιστάται να κρατάτε το ιστορικό όσο γίνεται περισσότερο. Εάν αντιμετωπίσετε προβλήματα απόδοσης ή έχετε περιορισμένο χώρο βάσης δεδομένων, δοκιμάστε να το ρυθμίσετε σε μια χαμηλότερη τιμή.';
$string['gradeimport'] = 'Εισαγωγή βαθμολογίας';
$string['gradeimportfailed'] = 'Η εισαγωγή βαθμών απέτυχε κατά την αποδοχή. Λεπτομέρειες:';
$string['gradeitem'] = 'Στοιχείο βαθμού';
$string['gradeitemaddusers'] = 'Εξαίρεση από βαθμολόγηση';
$string['gradeitemadvanced'] = 'Προχωρημένες επιλογές στοιχείου βαθμού';
$string['gradeitemadvanced_help'] = 'Επιλέξτε όλα τα στοιχεία που πρέπει να εμφανίζονται σαν προχωρημένα όταν επεξεργάζεστε στοιχεία βαθμών.';
$string['gradeitemislocked'] = 'Αυτή η δραστηριότητα είναι κλειδωμένη στο βαθμολόγιο. Αλλαγές οι οποίες γίνονται σε βαθμούς σε αυτή τη δραστηριότητα δεν θα αντιγράφονται στο βαθμολόγιο μέχρι να ξεκλειδωθεί.';
$string['gradeitemlocked'] = 'Η βαθμολόγηση είναι κλειδωμένη';
$string['gradeitemmembersselected'] = 'Εξαιρούνται Βαθμολόγησης';
$string['gradeitemminmax'] = 'Ελάχιστοι και μέγιστοι βαθμοί όπως καθορίζονται στις ρυθμίσεις του στοιχείου βαθμού';
$string['gradeitemnonmembers'] = 'Περιλαμβάνονται στη Βαθμολογία';
$string['gradeitemremovemembers'] = 'Περιέλαβε στην βαθμολόγηση';
$string['gradeitems'] = 'Στοιχεία βαθμού';
$string['gradeitemsettings'] = 'Ρυθμίσεις στοιχείου βαθμού';
$string['gradeitemsinc'] = 'Στοιχεία βαθμού που θα περιληφθούν';
$string['gradeletter'] = 'Γράμμα Βαθμού';
$string['gradeletter_help'] = 'Οι βαθμοί γράμματα είναι τα γράμματα Α, Β, C, …, ή λέξεις, για παράδειγμα Άριστα, Μέτρια, Περνάς, …, χρησιμοποιούνται για να αντιπροσωπεύσουν ένα εύρος βαθμολογιών.';
$string['gradeletternote'] = 'Για να διαγράψετε ένα γράμμα βαθμού πρέπει να αδειάσετε οποιαδήποτε από<br /> τις τρείς περιοχές κειμένου που σχετίζονται με αυτό το γράμμα και να επιλέξετε υποβολή.';
$string['gradeletteroverridden'] = 'Τα προεπιλεγμένα γράμματα βαθμού προς το παρόν έχουν παρακαμφθεί.';
$string['gradeletters'] = 'Γράμματα βαθμού';
$string['gradelocked'] = 'Ο βαθμός είναι κλειδωμένος';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Μέγιστος βαθμός';
$string['grademax_help'] = 'Αυτή η ρύθμιση καθορίζει τον μέγιστο βαθμό όταν χρησιμοποιείται ο τύπος βαθμολογίας τιμής. Ο μέγιστος βαθμός για ένα στοιχείο βαθμού βασισμένο σε δραστηριότητα, ορίζεται στην σελίδα ρυθμίσεων της δραστηριότητας.';
$string['grademin'] = 'Ελάχιστος βαθμός';
$string['grademin_help'] = 'Αυτή η ρύθμιση καθορίζει την ελάχιστη βαθμολογία κατά τη χρήση του τύπου βαθμού (αριθμητικής) τιμής.';
$string['gradenotificationmessage'] = 'Έχετε νέα ανατροφοδότηση στην εργασία σας για «{$a}»';
$string['gradenotificationsubject'] = 'Έχετε βαθμολογηθεί';
$string['gradeoutcomeitem'] = 'Βαθμολόγηση επιμέρους στοιχείου μαθησιακού αποτελέσματος';
$string['gradeoutcomes'] = 'Μαθησιακά αποτελέσματα';
$string['gradeoutcomescourses'] = 'Μαθησιακά αποτελέσματα μαθήματος';
$string['gradepass'] = 'Ελάχιστος βαθμός επιτυχίας';
$string['gradepass_help'] = 'Αυτή η ρύθμιση καθορίζει τον ελάχιστο βαθμό που απαιτείται για να περάσει κανείς. Η τιμή χρησιμοποιείται στην ολοκλήρωση δραστηριότητας και μαθήματος, και στο βαθμολόγιο, όπου οι βαθμοί επιτυχίας φωτο-επισημαίνονται με πράσινο χρώμα και οι βαθμοί αποτυχίας με κόκκινο.';
$string['gradepassgreaterthangrade'] = 'Ο ελάχιστος βαθμός επιτυχίας δεν μπορεί να είναι μεγαλύτερος από τον μέγιστο βαθμό {$a}';
$string['gradepointdefault'] = 'Προεπιλεγμένοι πόντοι βαθμολογίας';
$string['gradepointdefault_help'] = 'Αυτή η ρύθμιση καθορίζει την προεπιλεγμένη τιμή για τους διαθέσιμες τιμές πόντων βαθμολόγησης σε ένα στοιχείο βαθμού.';
$string['gradepointdefault_validateerror'] = 'Αυτή η ρύθμιση πρέπει να είναι ένας ακέραιος από 1 μέχρι το μέγιστο των πόντων βαθμολογίας.';
$string['gradepointmax'] = 'Μέγιστος πόντων βαθμολογίας';
$string['gradepointmax_help'] = 'Αυτή η ρύθμιση καθορίζει τον αριθμό πόντων για μέγιστη βαθμολογία σε μια δραστηριότητα.';
$string['gradepointmax_validateerror'] = 'Αυτή η ρύθμιση πρέπει να είναι ακέραιος αριθμός μεταξύ 1 και 10000.';
$string['gradepreferences'] = 'Προτιμήσεις βαθμού';
$string['gradepreferenceshelp'] = 'Βοήθεια Επιλογών Βαθμού';
$string['gradepublishing'] = 'Ενεργοποίηση δημοσίευσης';
$string['gradepublishing_help'] = 'Η δημοσίευση βαθμών είναι ένας τρόπος εισαγωγής και εξαγωγής βαθμών μέσω μιας διεύθυνσης URL χωρίς να έχετε συνδεθεί στο Moodle. Εάν ενεργοποιηθεί, στους διαχειριστές και στους χρήστες με δικαίωμα δημοσίευσης βαθμών (από προεπιλογή, οι χρήστες με το ρόλο του διευθυντή μόνο) παρέχονται ρυθμίσεις έκδοσης εξαγωγής βαθμών σε κάθε βαθμολόγιο μαθήματος.';
$string['gradepublishinglink'] = 'Λήψη: {$a}';
$string['gradereport'] = 'Αναφορά βαθμολογίας';
$string['graderreport'] = 'Αναφορά βαθμολογητή';
$string['grades'] = 'Βαθμοί';
$string['gradesforuser'] = 'Βαθμοί για {$a->user}';
$string['gradesmoduledeletionpendingwarning'] = 'Προειδοποίηση: Διαγραφή δραστηριότητας σε εξέλιξη! Ορισμένοι βαθμοί πρόκειται να αφαιρεθούν.';
$string['gradesmoduledeletionprefix'] = '[Διαγραφή σε εξέλιξη]';
$string['gradesonly'] = 'Αλλαγή σε βαθμούς μόνο';
$string['gradessettings'] = 'Ρυθμίσεις βαθμού';
$string['gradetype'] = 'Τύπος βαθμού';
$string['gradetype_help'] = 'Υπάρχουν 4 τύποι βαθμολογίας:

* Καθόλου - Καμία βαθμολογία δεν είναι δυνατή.
* Τιμή - Μια αριθμητική τιμή με μέγιστο και ελάχιστο.
* Κλίμακα - Ένα στοιχείο σε μια λίστα.
* Κείμενο - Μόνο ανατροφοδότηση.

Μόνο τύποι βαθμολογίας τιμής και κλίμακας μπορούν να συναθροιστούν. Οι τύποι για μια βαθμολόγηση βασισμένη σε δραστηριότητα ορίζονται στην σελίδα ρυθμίσεων της δραστηριότητας.';
$string['gradevaluetoobig'] = 'Μία από τις τιμές βαθμού είναι μεγαλύτερη από το μέγιστο επιτρεπόμενο βαθμό {$a}';
$string['gradeview'] = 'Εμφάνιση βαθμού';
$string['gradewasmodifiedduringediting'] = 'Ο βαθμός που δόθηκε για το «{$a->itemname}» για τον/την «{$a->username}» αγνοήθηκε επειδή ενημερώθηκε πιο πρόσφατα από κάποιον άλλο.';
$string['gradeweighthelp'] = 'Βοήθεια με τους συντελεστές βαρύτητας βαθμών';
$string['gradingmodulename'] = 'Βαθμολόγηση ({$a})';
$string['groupavg'] = 'Μέσος όρος ομάδας';
$string['hidden'] = 'Κρυμμένο';
$string['hidden_help'] = 'Εάν επιλεχθεί, οι βαθμοί κρύβονται από τους μαθητές. Μια ρύθμιση απόκρυψης έως μια ημερομηνία, μπορεί να οριστεί εάν είναι επιθυμητό, ώστε να λήξει η απόκρυψη αφού ολοκληρωθούν όλες οι βαθμολογίες.';
$string['hiddenasdate'] = 'Εμφάνιση ημερομηνίας υποβολής για κρυφούς βαθμούς';
$string['hiddenasdate_help'] = 'Εάν ο χρήστης δεν μπορεί να δει τους κρυφούς βαθμούς εμφάνισε την ημερομηνία της υποβολής στη θέση του «-».';
$string['hiddenuntil'] = 'Κρυμμένο μέχρι';
$string['hiddenuntildate'] = 'Κρυμμένο μέχρι: {$a}';
$string['hideadvanced'] = 'Απόκρυψη προχωρημένων χαρακτηριστικών';
$string['hideaverages'] = 'Απόκρυψη μέσων όρων';
$string['hidecalculations'] = 'Απόκρυψη υπολογισμών';
$string['hidecategory'] = 'Κρυμμένο';
$string['hideeyecons'] = 'Απόκρυψη εικονιδίων εμφάνισης/απόκρυψης';
$string['hidefeedback'] = 'Απόκρυψη ανατροφοδότησης';
$string['hideforcedsettings'] = 'Απόκρυψη υποχρεωτικών ρυθμίσεων';
$string['hideforcedsettings_help'] = 'Να μην εμφανίζονται υποχρεωτικές ρυθμίσεις στην διεπαφή χρήστη (UI) της βαθμολόγησης.';
$string['hidegroups'] = 'Απόκρυψη ομάδων';
$string['hidelocks'] = 'Απόκρυψη κλειδωμάτων';
$string['hidenooutcomes'] = 'Εμφάνιση μαθησιακών αποτελεσμάτων';
$string['hidequickfeedback'] = 'Απόκρυψη γρήγορης ανατροφοδότησης';
$string['hideranges'] = 'Απόκρυψη διαστημάτων';
$string['hidetotalifhiddenitems'] = 'Απόκρυψη συνόλων αν περιέχουν κρυφά στοιχεία';
$string['hidetotalifhiddenitems_help'] = 'Αυτή η ρύθμιση καθορίζει αν τα σύνολα που περιέχουν κρυφά στοιχεία βαθμού εμφανίζονται στους μαθητές ή αντικαθίστανται από μία παύλα (-). Αν εμφανίζονται, το σύνολο μπορεί να υπολογιστεί είτε εξαιρουμένων είτε συμπεριλαμβανομένων των κρυφών στοιχείων. Αν εξαιρεθούν τα κρυφά στοιχεία, το σύνολο θα είναι διαφορετικό από το σύνολο που φαίνεται από τον διδάσκοντα στην αναφορά βαθμολογητή, δεδομένου ότι ο διδάσκων βλέπει πάντα τα σύνολα υπολογισμένα από όλα τα στοιχεία, κρυφά ή όχι. Αν τα κρυφά στοιχεία συμπεριλαμβάνονται, οι μαθητές θα έχουν την δυνατότητα να υπολογίσουν τα κρυφά στοιχεία.';
$string['hidetotalshowexhiddenitems'] = 'Εμφάνιση συνόλων εξαιρουμένων των κρυφών στοιχείων';
$string['hidetotalshowinchiddenitems'] = 'Εμφάνιση συνόλων συμπεριλαμβανομένων των κρυφών στοιχείων';
$string['hideverbose'] = 'Απόκρυψη {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Ταξινόμηση με αύξουσα σειρά υψηλών βαθμών';
$string['highgradedescending'] = 'Ταξινόμηση με φθίνουσα σειρά υψηλών βαθμών';
$string['highgradeletter'] = 'Υψηλό';
$string['identifier'] = 'Αναγνώριση χρήστη με';
$string['idnumbers'] = 'Αναγνωριστικοί αριθμοί';
$string['ignore'] = 'Αγνοήστε';
$string['import'] = 'Εισαγωγή';
$string['importcsv'] = 'Εισαγωγή CSV';
$string['importcsv_help'] = 'Οι βαθμοί μπορούν να εισαχθούν μέσω αρχείου CSV με μορφότυπο ως εξής:

* Κάθε γραμμή του αρχείου περιέχει μία εγγραφή.
* Κάθε εγγραφή είναι μια σειρά δεδομένων που χωρίζονται με κόμματα ή έναν εναλλακτικό διαχωριστή.
* Η πρώτη εγγραφή περιέχει μια λίστα με ονόματα πεδίων που καθορίζουν τον μορφότυπο του υπόλοιπου αρχείου.
* Απαιτείται ένα όνομα πεδίου που περιέχει δεδομένα ταυτότητας χρήστη - είτε όνομα χρήστη ή αναγνωριστικό αριθμό ή διεύθυνση ηλε.ταχυδρομείου.

Ένα αρχείο με τον σωστό μορφότυπο μπορεί να ληφθεί με την εξαγωγή ορισμένων βαθμών. Το αρχείο μπορείτε στη συνέχεια να το επεξεργαστείτε και να το αποθηκεύσετε ως αρχείο CSV.';
$string['importcsv_link'] = '';
$string['importcustom'] = 'Εισαγωγή ως προσαρμοσμένα μαθησιακά αποτελέσματα (μόνο αυτό το μάθημα)';
$string['importdata'] = 'Δεδομένα';
$string['importdata_help'] = 'Οι βαθμοί μπορούν να επικολληθούν απευθείας από ένα υπολογιστικό φύλλο OpenDocument ή Excel με μορφότυπο ως εξής:

* Τουλάχιστον μία στήλη πρέπει να περιέχει δεδομένα ταυτότητας χρήστη - όνομα χρήστη, διεύθυνση ηλε.ταχυδρομείου ή αναγνωριστικό αριθμό.
* Άλλες στήλες θα πρέπει να έχουν επικεφαλίδες όπως για υπάρχουσες δραστηριότητες ή στοιχεία βαθμού.

Ένα υπολογιστικό φύλλο με σωστό μορφότυπο μπορεί να ληφθεί μέσω μιας εξαγωγής κάποιων βαθμών. Το υπολογιστικό φύλλο μπορεί στη συνέχεια να τροποποιηθεί για να προστεθούν περισσότεροι βαθμοί και να αποθηκευτεί.

Επιλέξτε και αντιγράψτε τις στήλες που θέλετε να εισαγάγετε από το υπολογιστικό φύλλο και, στη συνέχεια, επικολλήστε τις σε αυτό το πεδίο.';
$string['importerror'] = 'Συνέβη ένα σφάλμα, αυτό το σενάριο δεν κλήθηκε με τις σωστές παραμέτρους.';
$string['importfailed'] = 'Η εισαγωγή απέτυχε. Δεν εισήχθησαν δεδομένα.';
$string['importfeedback'] = 'Εισαγωγή ανατροφοδότησης';
$string['importfile'] = 'Εισαγωγή αρχείου';
$string['importfilemissing'] = 'Δεν λήφθηκε κανένα αρχείο, πηγαίνετε πίσω στη φόρμα και βεβαιωθείτε ότι ανεβάζετε ένα έγκυρο αρχείο.';
$string['importfrom'] = 'Εισαγωγή από';
$string['importoutcomenofile'] = 'Το αρχείο που ανέβηκε είναι άδειο ή κατεστραμμένο. Παρακαλούμε, επαληθεύστε ότι είναι ένα έγκυρο αρχείο. Το πρόβλημα εντοπίστηκε στη γραμμή {$a}· προκλήθηκε από το ότι οι γραμμές δεδομένων δεν έχουν τόσες στήλες όσες η πρώτη γραμμή (η γραμμή κεφαλίδας) ή επειδή από το εισαγόμενο αρχείο λείπουν κάποιες αναμενόμενες κεφαλίδες. Κοιτάξτε ένα εξαχθέν αρχείο ως ένα παράδειγμα αρχείου με έγκυρες κεφαλίδες.';
$string['importoutcomes'] = 'Εισαγωγή μαθησιακών αποτελεσμάτων';
$string['importoutcomes_help'] = 'Μαθησιακά αποτελέσματα μπορούν να εισαχθούν μέσω αρχείων csv (Comma Separated Values text file: μορφότυπος αρχείου κειμένου τιμών διαχωρισμένων με κόμμα).';
$string['importoutcomes_link'] = '';
$string['importoutcomesuccess'] = 'Έγινε εισαγωγή του μαθησιακού αποτελέσματος «{$a->name}» με αναγνωριστικό (ID) #{$a->id}';
$string['importplugins'] = 'Πρόσθετα εισαγωγής';
$string['importpreview'] = 'Προεπισκόπηση εισαγωγής';
$string['importsettings'] = 'Ρυθμίσεις εισαγωγής';
$string['importskippednomanagescale'] = 'Δεν έχετε δικαίωμα προσθήκης μιας νέας κλίμακας, οπότε το μαθησιακό αποτέλεσμα «{$a}» παραλήφθηκε καθώς απαιτεί την δημιουργία μιας νέας κλίμακας';
$string['importskippedoutcome'] = 'Ένα μαθησιακό αποτέλεσμα με σύντομο όνομα «{$a}» υπάρχει ήδη σε αυτό το πλαίσιο, οπότε η αντίστοιχη στο αρχείο που εισάγεται παραλήφθηκε.';
$string['importstandard'] = 'Εισαγωγή ως τυπικά μαθησιακά αποτελέσματα';
$string['importsuccess'] = 'Επιτυχία εισαγωγής βαθμών';
$string['importxml'] = 'Εισαγωγή XML';
$string['includescalesinaggregation'] = 'Συμπερίληψη κλιμάκων στη συνάθροιση';
$string['includescalesinaggregation_help'] = 'Μπορείτε να αλλάξετε το εάν οι κλίμακες θα συμπεριλαμβάνονται σαν αριθμοί σε όλους τους συναθροιζόμενους βαθμούς σε όλα τα βαθμολόγια όλων των μαθημάτων. ΠΡΟΣΟΧΗ: η αλλαγή αυτής της ρύθμισης θα επιβάλει επανυπολογισμό όλων των συναθροιζόμενων βαθμών.';
$string['incorrectcourseid'] = 'Το αναγνωριστικό μαθήματος ήταν λάθος';
$string['incorrectcustomscale'] = '(Λανθασμένη προσαρμοσμένη κλίμακα. Παρακαλούμε τροποποιήστε τη.)';
$string['incorrectminmax'] = 'Το ελάχιστο πρέπει να είναι χαμηλότερα από το μέγιστο';
$string['inherit'] = 'Κληρονομικότητα';
$string['intersectioninfo'] = 'Πληροφορίες Μαθητή/Βαθμού';
$string['invalidgradeexporteddate'] = 'Η ημερομηνία εξαγωγής είναι άκυρη διότι είναι παλαιότερη από ένα έτος, ή στο μέλλον, ή διότι ο μορφότυπος είναι άκυρος.';
$string['item'] = 'Αντικείμενο';
$string['iteminfo'] = 'Πληροφορίες στοιχείου';
$string['iteminfo_help'] = 'Αυτή η ρύθμιση παρέχει χώρο για την εισαγωγή πληροφοριών σχετικά με το στοιχείο. Οι πληροφορίες δεν εμφανίζονται οπουδήποτε αλλού.';
$string['itemname'] = 'Όνομα στοιχείου';
$string['itemnamehelp'] = 'Το όνομα αυτού του στοιχείου, τοποθετημένο μέσα από το άρθρωμα.';
$string['items'] = 'Αντικείμενα';
$string['itemsedit'] = 'Επεξεργασία στοιχείου βαθμού';
$string['keephigh'] = 'Διατήρηση υψηλότερων';
$string['keephigh_help'] = 'Εάν ρυθμιστεί, αυτή η επιλογή θα διατηρήσει μόνο τους Χ υψηλότερους βαθμούς, όπου X είναι η επιλεγμένη τιμή για αυτή την επιλογή.';
$string['keephighestvalues'] = 'Διατηρήστε τις {$a} υψηλότερες τιμές';
$string['keymanager'] = 'Διαχειριστής κλειδιών';
$string['lessthanmin'] = 'Ο βαθμός που εισήχθη για το {$a->itemname} για τον {$a->username} είναι μικρότερος από τον ελάχιστο επιτρεπτό';
$string['letter'] = 'Γράμμα';
$string['lettergrade'] = 'Βαθμός με γράμμα';
$string['lettergradenonnumber'] = 'Χαμηλός και/ή Υψηλό βαθμός ήταν μη-αριθμητικός για';
$string['letterpercentage'] = 'Γράμμα (ποσοστό)';
$string['letterreal'] = 'Γράμμα (πραγματικό)';
$string['letters'] = 'Γράμματα';
$string['linkedactivity'] = 'Συνδεδεμένη δραστηριότητα';
$string['linkedactivity_help'] = 'Αυτή η ρύθμιση προσδιορίζει μια δραστηριότητα στην οποία αυτό το επιμέρους στοιχείο μαθησιακού αποτελέσματος συνδέεται. Αυτή μπορεί να χρησιμοποιηθει για την μέτρηση της απόδοσης μαθητών με κριτήρια που δεν αξιολογούνται κατά την βαθμολογία της δραστηριότητας.';
$string['linktoactivity'] = 'Σύνδεση με τη δραστηριότητα {$a->name} «{$a->title}»';
$string['lock'] = 'Κλείδωμα';
$string['locked'] = 'Κλειδωμένο';
$string['locked_help'] = 'Αν ενεργοποιηθεί, οι βαθμοί δεν μπορούν πλέον να ενημερώνονται αυτόματα από τη σχετική δραστηριότητα.';
$string['locktime'] = 'Κλείδωμα μετά από';
$string['locktimedate'] = 'Κλείδωμα μετά από: {$a}';
$string['lockverbose'] = 'Κλείδωμα {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Χαμηλότερο';
$string['lowgradeletter'] = 'Χαμηλό';
$string['manualitem'] = 'Χειροκίνητο στοιχείο';
$string['mapfrom'] = 'Αντιστοίχιση από';
$string['mapfrom_help'] = 'Επιλέξτε τη στήλη στο λογιστικό φύλλο που περιέχει δεδομένα για την αναγνώριση του χρήστη, όπως όνομα χρήστη, αναγνωριστικό χρήστη ή διεύθυνση ηλε.ταχυδρομείου.';
$string['mappings'] = 'Αντιστοιχήσεις στοιχείων βαθμού';
$string['mappings_help'] = 'Για κάθε στήλη βαθμών στο φύλλο εργασίας, επιλέξτε το αντίστοιχο στοιχείο βαθμού προς εισαγωγή των πληροφοριών βαθμού.';
$string['mapto'] = 'Αντιστοίχιση σε';
$string['mapto_help'] = 'Επιλέξτε τα ίδια στοιχεία ταυτοποίησης που έχετε επιλέξει για το «Αντιστοίχιση από».';
$string['max'] = 'Υψηλότερος';
$string['maxgrade'] = 'Μέγιστος βαθμός';
$string['meanall'] = 'Όλοι οι βαθμοί';
$string['meangraded'] = 'Οι βαθμοί που δεν είναι κενοί';
$string['meanselection'] = 'Βαθμοί που επιλέχθηκαν για το μέσο όρο των στηλών';
$string['meanselection_help'] = 'Εάν θα πρέπει τα κελιά χωρίς βαθμό να ενσωματώνονται όταν υπολογίζεται ο μέσος για κάθε στήλη.';
$string['median'] = 'Διάμεσος';
$string['min'] = 'Ελάχιστος';
$string['minimum_show'] = 'Εμφάνιση ελάχιστου βαθμού';
$string['minimum_show_help'] = 'Ο ελάχιστος βαθμός χρησιμοποιείται για τον υπολογισμό βαθμών και συντελεστών βαρύτητας. Αν δεν εμφανίζεται, ο ελάχιστος βαθμός θα είναι μηδέν από προεπιλογή και δεν θα είναι δυνατή η επεξεργασία του.';
$string['minmaxtouse'] = 'Ελάχιστοι και μέγιστοι βαθμοί που χρησιμοποιούνται στους υπολογισμούς';
$string['minmaxtouse_desc'] = 'Αυτή η ρύθμιση καθορίζει εάν θα χρησιμοποιηθούν οι αρχικοί ελάχιστοι και μέγιστοι βαθμοί από τότε που δόθηκε ο βαθμός, ή οι ελάχιστοι και μέγιστοι βαθμοί όπως είναι καθορισμένοι στις ρυθμίσεις για το στοιχείο βαθμού, όταν υπολογίζεται ο βαθμός που εμφανίζεται στο βαθμολόγιο. Συνιστάται αυτή η ρύθμιση να μην τροποποιείται σε ώρα αιχμής, καθώς όλοι οι βαθμοί θα επανυπολογιστούν, πράγμα που μπορεί να έχει ως αποτέλεσμα μεγάλο φόρτο στον εξυπηρετητή.';
$string['minmaxtouse_help'] = 'Αυτή η ρύθμιση καθορίζει εάν θα χρησιμοποιηθούν οι αρχικοί ελάχιστοι και μέγιστοι βαθμοί από τότε που δόθηκε ο βαθμός, ή οι ελάχιστοι και μέγιστοι βαθμοί όπως είναι καθορισμένοι στις ρυθμίσεις για το στοιχείο βαθμού, όταν υπολογίζεται ο βαθμός που εμφανίζεται στο βαθμολόγιο.';
$string['minmaxtouse_link'] = '';
$string['minmaxupgradedgrades'] = 'Σημείωση: Ορισμένοι βαθμοί έχουν αλλάξει προκειμένου να επιλυθεί μια ασυνέπεια στο βαθμολόγιο που προκαλείται από μια αλλαγή στις ελάχιστες και τις μέγιστες ποιότητες που χρησιμοποιούνται κατά τον υπολογισμό της βαθμολογίας που εμφανίζεται. Συνιστάται οι αλλαγές να επανεξεταστούν και να γίνουν αποδεκτές.';
$string['minmaxupgradefixbutton'] = 'Επίλυση ασυνεπειών';
$string['minmaxupgradewarning'] = 'Σημείωση: Έχει εντοπιστεί ασυνέπεια με κάποιες βαθμολογίες λόγω αλλαγής των ελάχιστων και μέγιστων βαθμών που χρησιμοποιούνται κατά τον υπολογισμό της βαθμολογίας που εμφανίζεται στο βαθμολόγιο. Συνιστάται η επίλυση της ασυνέπειας κάνοντας κλικ στο παρακάτω κουμπί, αν και αυτό θα έχει ως αποτέλεσμα την αλλαγή ορισμένων βαθμολογιών.';
$string['missingitemtypeoreid'] = 'Το κλειδί πίνακα (itemtype ή eid) λείπει από την 2η παράμετρο (της συνάρτησης) class_edit_tree_column_select::get_item_cell($item, $params)';
$string['missingscale'] = 'Πρέπει να επιλεχθεί κλίμακα';
$string['mode'] = 'Φάση';
$string['modgrade'] = 'Βαθμός';
$string['modgrade_help'] = 'Επιλέξτε τον τύπο βαθμολόγησης που θα χρησιμοποιείται για αυτή τη δραστηριότητα. Αν επιλεγεί «Κλίμακα», τότε μπορείτε κατόπιν να επιλέξετε την κλίμακα από το πτυσσόμενο μενού. Εάν επιλεγεί τύπος βαθμολόγησης «Πόντοι», μπορείτε στη συνέχεια να εισαγάγετε τη μέγιστη διαθέσιμη βαθμολογία για αυτή τη δραστηριότητα.';
$string['modgradecantchangegradetype'] = 'Δεν μπορείτε να αλλάξετε τον τύπο, καθώς υπάρχουν ήδη βαθμοί για αυτό το στοιχείο.';
$string['modgradecantchangegradetypemsg'] = 'Κάποιοι βαθμοί έχουν ήδη αποδοθεί κι έτσι ο τύπος βαθμολογίας δεν μπορεί να αλλάξει. Εάν επιθυμείτε να αλλάξετε τον μέγιστο βαθμό, πρέπει πρώτα να επιλέξετε αν θέλετε ή όχι να προσαρμόσετε όλες τις υπάρχουσες βαθμολογίες στη νέα κλίμακα.';
$string['modgradecantchangegradetyporscalemsg'] = 'Κάποιοι βαθμοί έχουν ήδη αποδοθεί, κι έτσι ο τύπος βαθμολογίας και η κλίμακα δεν μπορούν να αλλάξουν.';
$string['modgradecantchangeratingmaxgrade'] = 'Δεν μπορείτε να αλλάξετε το μέγιστο βαθμό, καθώς υπάρχουν ήδη βαθμοί για μια δραστηριότητα με βαθμολογίες.';
$string['modgradecantchangescale'] = 'Δεν μπορείτε να αλλάξετε την κλίμακα, καθώς κάποιοι βαθμοί υπάρχουν ήδη για αυτό το στοιχείο.';
$string['modgradecategorycantchangegradetypemsg'] = 'Αυτή η κατηγορία έχει συσχετισμένα στοιχεία βαθμών τα οποία έχουν παρακαμφθεί (overridden). Επομένως κάποιοι βαθμοί έχουν ήδη αποδοθεί κι έτσι ο τύπος βαθμολογίας δεν μπορεί να αλλάξει. Εάν επιθυμείτε να αλλάξετε τον μέγιστο βαθμό, πρέπει πρώτα να επιλέξετε αν θέλετε ή όχι να προσαρμόσετε όλες τις υπάρχουσες βαθμολογίες σε νέα κλίμακα.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Αυτή η κατηγορία έχει συσχετισμένα στοιχεία βαθμών τα οποία έχουν παρακαμφθεί (overridden). Επομένως κάποιοι βαθμοί έχουν ήδη αποδοθεί κι έτσι ο τύπος βαθμολογίας και η κλίμακα δεν μπορούν να αλλάξουν.';
$string['modgradecategoryrescalegrades'] = 'Προσαρμογή στη νέα κλίμακα των βαθμών που παρακάμπτονται';
$string['modgradecategoryrescalegrades_help'] = 'Κατά την αλλαγή των μέγιστων βαθμών σε ένα στοιχείο του βαθμολογίου πρέπει να καθορίσετε αν αυτό θα προκαλέσει ή όχι και την αλλαγή των υπαρχόντων ποσοστιαίων βαθμών.

Αν αυτό έχει οριστεί σε «Ναι», τυχόν υπάρχουσες παρακάμψεις βαθμών θα προσαρμοστούν στη νέα κλίμακα έτσι ώστε η ποσοστιαία βαθμολογία να παραμείνει η ίδια.

Για παράδειγμα, εάν η επιλογή αυτή έχει οριστεί σε «Ναι», η αλλαγή σε ένα στοιχείο της μέγιστης βαθμολογίας από 10 σε 20 θα προκαλούσε προσαρμογή ενός βαθμού από 6/10 (60%) σε 12/20 (60%) στη νέα κλίμακα. Με αυτή την επιλογή ορισμένη σε «Όχι», η βαθμολογία θα παραμείνει αμετάβλητη, απαιτώντας τη χειροκίνητη ρύθμιση/προσαρμογή των βαθμών για να διασφαλιστούν τα σωστά σκορ.';
$string['modgradedonotmodify'] = 'Μην τροποποιείτε τις υπάρχουσες βαθμολογίες';
$string['modgradeerrorbadpoint'] = 'Μη έγκυρη τιμή βαθμού. Πρέπει να είναι ένας ακέραιος μεταξύ 1 και {$a}';
$string['modgradeerrorbadscale'] = 'Επιλέχθηκε άκυρη κλίμακα. Παρακαλούμε βεβαιωθείτε ότι επιλέξατε μια κλίμακα από τις παρακάτω επιλογές.';
$string['modgrademaxgrade'] = 'Μέγιστος βαθμός';
$string['modgraderescalegrades'] = 'Προσαρμογή υπαρχόντων βαθμών, στη νέα κλίμακα';
$string['modgraderescalegrades_help'] = 'Κατά την αλλαγή των μέγιστων βαθμών σε ένα στοιχείο του βαθμολογίου πρέπει να καθορίσετε αν αυτό θα προκαλέσει ή όχι και την αλλαγή των υπαρχόντων ποσοστιαίων βαθμών.

Αν αυτό έχει οριστεί σε «Ναι», τυχόν υπάρχοντες βαθμοί θα προσαρμοστούν στη νέα κλίμακα έτσι ώστε η ποσοστιαία βαθμολογία να παραμείνει η ίδια.

Για παράδειγμα, εάν η επιλογή αυτή έχει οριστεί σε «Ναι», η αλλαγή σε ένα στοιχείο της μέγιστης βαθμολογίας από 10 σε 20 θα προκαλούσε προσαρμογή ενός βαθμού από 6/10 (60%) σε 12/20 (60%) στη νέα κλίμακα. Με αυτή την επιλογή ορισμένη σε «Όχι», η βαθμολογία (ουσιαστικά) θα άλλαζε από 6/10 (60%) σε 6/20 (30%), απαιτώντας τη χειροκίνητη προσαρμογή των στοιχείων βαθμών για να διασφαλιστούν σωστά σκορ.';
$string['modgradetype'] = 'Τύπος';
$string['modgradetypenone'] = 'Κανένα';
$string['modgradetypepoint'] = 'Πόντοι';
$string['modgradetypescale'] = 'Κλίμακα';
$string['morethanmax'] = 'Ο βαθμός που εισήχθη για το {$a->itemname} για τον {$a->username} είναι μεγαλύτερος από τον μέγιστο επιτρεπτό';
$string['moveselectedto'] = 'Μετακίνηση επιλεγμένων στοιχείων σε:';
$string['movingelement'] = 'Μετακινούνται {$a}';
$string['multfactor'] = 'Πολλαπλασιαστής';
$string['multfactor_help'] = 'Ο πολλαπλασιαστής είναι ο παράγοντας με τον οποίο όλοι οι βαθμοί για αυτό το στοιχείο βαθμού θα πολλαπλασιαστούν, με μέγιστη τιμή το μέγιστο βαθμό. Για παράδειγμα, αν ο πολλαπλασιαστής είναι 2 και ο μέγιστος βαθμός είναι 100, τότε όλοι οι βαθμοί που είναι μικρότεροι από 50 πολλαπλασιάζονται με το 2, και όλοι οι βαθμοί πάνω από 50 μετατρέπονται σε 100.';
$string['multfactorvalue'] = 'Αξία πολλαπλασιαστή για {$a}';
$string['mustchooserescaleyesorno'] = 'Πρέπει να επιλέξετε αν θα προσαρμόσετε όλες τις υπάρχουσες βαθμολογίες στη νέα κλίμακα ή όχι.';
$string['mygrades'] = 'Σύνδεσμος βαθμών στο μενού χρήστη';
$string['mygrades_desc'] = 'Αυτή η ρύθμιση επιτρέπει την επιλογή σύνδεσης με ένα εξωτερικό βαθμολόγιο από το μενού χρήστη.';
$string['mypreferences'] = 'Οι προτιμήσεις μου';
$string['myreportpreferences'] = 'Οι προτιμήσεις μου για αναφορές';
$string['navmethod'] = 'Μέθοδος πλοήγησης';
$string['neverdeletehistory'] = 'Το ιστορικό να μην διαγράφεται ποτέ';
$string['newcategory'] = 'Νέα κατηγορία';
$string['newitem'] = 'Νέο στοιχείο βαθμού';
$string['newoutcomeitem'] = 'Νέο επιμέρους στοιχείο μαθησιακού αποτελέσματος';
$string['no'] = 'Όχι';
$string['nocategories'] = 'Δεν ήταν δυνατή η προσθήκη κατηγοριών βαθμών για αυτό το μάθημα';
$string['nocategoryname'] = 'Δεν δόθηκε όνομα κατηγορίας.';
$string['nocategoryview'] = 'Δεν υπάρχουν κατηγορίες για εμφάνιση κατά κατηγορία';
$string['nocourses'] = 'Δεν υπάρχουν μαθήματα ακόμα';
$string['noforce'] = 'Χωρίς επιβολή';
$string['nogradeletters'] = 'Δεν έχουν οριστεί βαθμοί με γράμματα';
$string['nogradesreturned'] = 'Δεν επιστράφηκε κανένας βαθμός';
$string['noidnumber'] = 'Χωρίς αναγνωριστικό αριθμό';
$string['nolettergrade'] = 'Δεν υπάρχει βαθμός με γράμματα για';
$string['nomode'] = 'ΧΦ';
$string['nonnumericweight'] = 'Παραλήφθηκε μη-αριθμητική τιμή για';
$string['nonunlockableverbose'] = 'Αυτός ο βαθμός δεν μπορεί να ξεκλειδωθεί μέχρι να ξεκλειδωθεί το {$a->itemname}.';
$string['nonweightedpct'] = '% χωρίς συντελεστή βαρύτητας';
$string['nooutcome'] = 'Χωρίς μαθησιακά αποτελέσματα';
$string['nooutcomes'] = 'Τα επιμέρους στοιχεία αποτελέσματος πρέπει να συνδέονται με ένα αποτέλεσμα μαθήματος, αλλά δεν υπάρχουν μαθησιακά αποτελέσματα για αυτό το μάθημα. Θέλετε να προσθέσετε ένα;';
$string['nopermissiontoresetweights'] = 'Δεν υπάρχει το δικαίωμα για επαναρχικοποίηση των συντελεστών βαρύτητας';
$string['nopublish'] = 'Όχι δημοσίευση';
$string['noreports'] = 'Δεν είστε εγγεγραμμένοι, ούτε διδάσκετε μαθήματα σε αυτόν τον ιστότοπο.';
$string['norolesdefined'] = 'Δεν έχουν οριστεί ρόλοι στη σελίδα Διαχείριση > Βαθμοί > Γενικές ρυθμίσεις > Βαθμολογημένοι ρόλοι';
$string['noscales'] = 'Τα μαθησιακά αποτελέσματα πρέπει να συνδέονται με μια κλίμακα μαθήματος ή γενική κλίμακα αλλά δεν υπάρχει καμία. Θέλετε να προσθέσετε μια;';
$string['noselectedcategories'] = 'Δεν επιλέχθηκαν κατηγορίες.';
$string['noselecteditems'] = 'Δεν επιλέχθηκαν στοιχεία';
$string['notenrolled'] = 'Αυτή τη στιγμή δεν είστε εγγεγραμμένοι σε κανένα μάθημα.';
$string['notteachererror'] = 'Πρέπει να είστε διδάσκων για να χρησιμοποιήσετε αυτή τη λειτουργία/χαρακτηριστικό.';
$string['nousersloaded'] = 'Δεν φορτώθηκαν χρήστες';
$string['nouserstograde'] = 'Δεν υπάρχει κανένας χρήστης για να βαθμολογηθεί';
$string['numberofgrades'] = 'Αριθμός βαθμών';
$string['onascaleof'] = 'σε μια κλίμακα από {$a->grademin} έως {$a->grademax}';
$string['operations'] = 'Λειτουργίες';
$string['options'] = 'Επιλογές';
$string['others'] = 'Άλλοι';
$string['outcome'] = 'Μαθησιακό αποτέλεσμα';
$string['outcome_help'] = 'Αυτή η ρύθμιση καθορίζει το μαθησιακό αποτέλεσμα το οποίο αυτό το στοιχείο βαθμού θα αντιπροσωπεύει στο βαθμολόγιο.';
$string['outcomeassigntocourse'] = 'Ανάθεση κι άλλου μαθησιακού αποτελέσματος σε αυτό το μάθημα';
$string['outcomecategory'] = 'Δημιουργία μαθησιακών αποτελεσμάτων στην κατηγορία';
$string['outcomecategorynew'] = 'Νέα κατηγορία';
$string['outcomeconfirmdelete'] = 'Είστε σίγουροι ότι θέλετε να διαγράψετε το μαθησιακό αποτέλεσμα «{$a}»;';
$string['outcomecreate'] = 'Προσθήκη ενός νέου μαθησιακού αποτελέσματος';
$string['outcomedelete'] = 'Διαγραφή μαθησιακού αποτελέσματος';
$string['outcomefullname'] = 'Πλήρες όνομα';
$string['outcomeitem'] = 'Επιμέρους στοιχείο μαθησιακού αποτελέσματος';
$string['outcomeitemsedit'] = 'Επεξεργασία επιμέρους στοιχείου μαθησιακού αποτελέσματος';
$string['outcomereport'] = 'Αναφορά μαθησιακού αποτελέσματος';
$string['outcomes'] = 'Μαθησιακά αποτελέσματα';
$string['outcomescourse'] = 'Μαθησιακά αποτελέσματα που χρησιμοποιούνται στο μάθημα';
$string['outcomescoursecustom'] = 'Προσαρμοσμένη χρήση (χωρίς διαγραφή)';
$string['outcomescoursenotused'] = 'Το πρότυπο δεν χρησιμοποιείται';
$string['outcomescourseused'] = 'Χρήση προτύπου (χωρίς διαγραφή)';
$string['outcomescustom'] = 'Προσαρμοσμένα μαθησιακά αποτελέσματα';
$string['outcomeshortname'] = 'Σύντομο όνομα';
$string['outcomesstandard'] = 'Τυπικά μαθησιακά αποτελέσματα';
$string['outcomesstandardavailable'] = 'Διαθέσιμα τυπικά μαθησιακά αποτελέσματα';
$string['outcomestandard'] = 'Τυπικό μαθησιακό αποτέλεσμα';
$string['outcomestandard_help'] = 'Ένα τυπικό μαθησιακό αποτέλεσμα είναι διαθέσιμο σε ολόκληρο τον ιστότοπο, για όλα τα μαθήματα.';
$string['overallaverage'] = 'Γενικός μέσος όρος';
$string['overridden'] = 'Παρακάμφθηκε';
$string['overridden_help'] = 'Εάν επιλεγεί, ο βαθμός δεν μπορεί πλέον να αλλάξει μέσα από τη σχετική δραστηριότητα. Όταν τροποποιείται ένας βαθμός στην αναφορά βαθμολογητή, το πλαίσιο επιλογής παράκαμψης επιλέγεται αυτόματα. Εντούτοις, μπορεί να αποεπιλεγεί για να επιτραπεί η αλλαγή του βαθμού μέσω της σχετικής δραστηριότητας.';
$string['overriddennotice'] = 'Ο τελικός βαθμός από αυτή τη δραστηριότητα ρυθμίστηκε/προσαρμόστηκε χειροκίνητα.';
$string['overridecat'] = 'Να επιτρέπεται χειροκίνητη παράκαμψη βαθμών κατηγοριών';
$string['overridecat_help'] = 'Η απενεργοποίηση αυτής της ρύθμισης καθιστά αδύνατο για τους χρήστες να παρακάμπτουν τους βαθμούς κατηγορίας.';
$string['overridesitedefaultgradedisplaytype'] = 'Παράκαμψη προεπιλογών ιστοτόπου';
$string['overridesitedefaultgradedisplaytype_help'] = 'Εάν έχει επιλεγεί, μπορούν να οριστούν βαθμοί με γράμματα και όρια ειδικά για το μάθημα, αντί να χρησιμοποιηθούν οι προεπιλογές ιστοτόπου.';
$string['overrideweightofa'] = 'Παράκαμψη του συντελεστή βαρύτητας {$a}';
$string['parentcategory'] = 'Γονική κατηγορία';
$string['pass'] = 'Επιτυχία';
$string['pctoftotalgrade'] = '% του συνολικού βαθμού';
$string['percent'] = 'Ποσοστό';
$string['percentage'] = 'Ποσοστό';
$string['percentageletter'] = 'Ποσοστό (γράμμα)';
$string['percentagereal'] = 'Ποσοστό (πραγματικό)';
$string['percentascending'] = 'Αύξουσα ταξινόμηση με ποσοστό';
$string['percentdescending'] = 'Φθίνουσα ταξινόμηση με ποσοστό';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Μετατόπιση';
$string['plusfactor_help'] = 'Η μετατόπιση (offset) είναι ένας αριθμός που προστίθεται σε κάθε βαθμό για αυτό το στοιχείο βαθμού, αφού εφαρμοστεί ο πολλαπλασιαστής.';
$string['plusfactorvalue'] = 'Τιμή μετατόπισης για {$a}';
$string['points'] = 'πόντοι';
$string['pointsascending'] = 'Αύξουσα ταξινόμηση πόντων';
$string['pointsdescending'] = 'Φθίνουσα ταξινόμηση πόντων';
$string['positionfirst'] = 'Πρώτο';
$string['positionlast'] = 'Τελευταία';
$string['preferences'] = 'Προτιμήσεις';
$string['prefgeneral'] = 'Γενικά';
$string['prefletters'] = 'Γράμματα βαθμών και όρια';
$string['prefrows'] = 'Ειδικές γραμμές';
$string['prefshow'] = 'Διακόπτες εμφάνισης/απόκρυψης';
$string['previewrows'] = 'Προεπισκόπηση γραμμών';
$string['privacy:metadata:categorieshistory'] = 'Ιστορικό προηγούμενων εκδόσεων κατηγοριών βαθμού';
$string['privacy:metadata:filepurpose'] = 'Αρχεία ανατροφοδότησης που είναι αποθηκευμένα στο βαθμολόγιο για έναν χρήστη.';
$string['privacy:metadata:grade_import_newitem'] = 'Προσωρινός πίνακας για την αποθήκευση νέων ονομάτων στοιχείων βαθμού από την εισαγωγή βαθμών';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Ένας μοναδικός κωδικός δέσμης για τον προσδιορισμό μίας δέσμης εισαγωγών';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Ο χρήστης που εισάγει τα δεδομένα';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Νέο όνομα στοιχείου βαθμού';
$string['privacy:metadata:grade_import_values'] = 'Προσωρινός πίνακας για την εισαγωγή βαθμών';
$string['privacy:metadata:grade_import_values:feedback'] = 'Ανατροφοδότηση βαθμού';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Τιμή ακατέργαστου βαθμού';
$string['privacy:metadata:grade_import_values:importcode'] = 'Ένας μοναδικός κωδικός δέσμης για τον προσδιορισμό μίας δέσμης εισαγωγών';
$string['privacy:metadata:grade_import_values:importer'] = 'Ο χρήστης που εισάγει τα δεδομένα';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Σημαιοδότηση αν έγινε μόνο εισαγωγή ανατροφοδότησης';
$string['privacy:metadata:grade_import_values:userid'] = 'Ο χρήστης του οποίου εισήχθη ο βαθμός';
$string['privacy:metadata:grades'] = 'Ιστορικό βαθμών';
$string['privacy:metadata:grades:aggregationstatus'] = 'Η κατάσταση συνάθροισης';
$string['privacy:metadata:grades:aggregationweight'] = 'Ο συντελεστής βαρύτητας στην συνάθροιση';
$string['privacy:metadata:grades:feedback'] = 'Η ανατροφοδότηση';
$string['privacy:metadata:grades:finalgrade'] = 'Ο βαθμός';
$string['privacy:metadata:grades:information'] = 'Επιπρόσθετες πληροφορίες για τον βαθμό';
$string['privacy:metadata:grades:timemodified'] = 'Πότε τροποποιήθηκε τελευταία η βαθμολογία';
$string['privacy:metadata:grades:userid'] = 'Το αναγνωριστικό του χρήστη στον οποίο ανήκει ο βαθμός';
$string['privacy:metadata:grades:usermodified'] = 'Το αναγνωριστικό του χρήστη ο οποίος τροποποίησε τελευταία την εγγραφή';
$string['privacy:metadata:gradeshistory'] = 'Ιστορικό των προηγούμενων βαθμών';
$string['privacy:metadata:history:loggeduser'] = 'Το αναγνωριστικό του χρήστη που ήταν συνδεδεμένος κατά τον ορισμό του αριθμού της έκδοσης';
$string['privacy:metadata:history:timemodified'] = 'Πότε ορίστηκε ο αριθμός της έκδοσης βαθμών';
$string['privacy:metadata:itemshistory'] = 'Ιστορικό των προηγούμενων εκδόσεων των στοιχείων βαθμού';
$string['privacy:metadata:outcomes'] = 'Ιστορικό των μαθησιακών αποτελεσμάτων';
$string['privacy:metadata:outcomes:timemodified'] = 'Πότε τροποποιήθηκε το ιστορικό';
$string['privacy:metadata:outcomes:usermodified'] = 'Ο χρήστης που τροποποίησε τελευταία το ιστορικό';
$string['privacy:metadata:outcomeshistory'] = 'Ιστορικό προηγούμενων εκδόσεων των μαθησιακών αποτελεσμάτων';
$string['privacy:metadata:scale'] = 'Ιστορικό για τις κλίμακες';
$string['privacy:metadata:scale:timemodified'] = 'Πότε τροποποιήθηκε τελευταία το ιστορικό';
$string['privacy:metadata:scale:userid'] = 'Ο χρήστης που τροποποίησε τελευταία το ιστορικό';
$string['privacy:metadata:scalehistory'] = 'Ιστορικό προηγούμενων εκδόσεων για τις κλίμακες';
$string['privacy:path:relatedtome'] = 'Σχετικά με μένα';
$string['privacy:request:historyactiondelete'] = 'Διαγραφή';
$string['privacy:request:historyactioninsert'] = 'Παρεμβολή';
$string['privacy:request:historyactionupdate'] = 'Ενημέρωση';
$string['privacy:request:unknowndeletedgradeitem'] = 'Άγνωστο (το στοιχείο βαθμού διαγράφηκε)';
$string['profilereport'] = 'Αναφορά προφίλ χρήστη';
$string['profilereport_help'] = 'Η αναφορά βαθμού που χρησιμοποιείται στην σελίδα προφίλ του χρήστη.';
$string['publishing'] = 'Δημοσίευση';
$string['publishingoptions'] = 'Επιλογές δημοσίευσης βαθμών';
$string['quickfeedback'] = 'Γρήγορη ανατροφοδότηση';
$string['quickgrading'] = 'Γρήγορη βαθμολόγηση';
$string['quickgrading_help'] = 'Εάν ενεργοποιηθεί, όταν γίνεται επεξεργασία, ένα πλαίσιο εισαγωγής κειμένου εμφανίζεται για κάθε βαθμό, επιτρέποντας να γίνεται επεξεργασία πολλών βαθμών την ίδια στιγμή. Οι αλλαγές αποθηκεύονται και φωτο-επισημαίνονται όταν το κουμπί ενημέρωσης πατηθεί. Σημειώστε ότι όταν ένας βαθμός τροποποιηθεί στην αναφορά του βαθμολογητή, μια σημαιοδότηση παράκαμψης τίθεται, πράγμα που σημαίνει ότι ο βαθμός δεν μπορεί πλέον να αλλάξει μέσα από τη σχετική δραστηριότητα.';
$string['range'] = 'Εύρος';
$string['rangedecimals'] = 'Δεκαδικά ψηφία εύρους';
$string['rangedecimals_help'] = 'Ο αριθμός δεκαδικών ψηφίων που θα εμφανίζονται για το εύρος.';
$string['rangesdecimalpoints'] = 'Δεκαδικά που εμφανίζονται σε διαστήματα';
$string['rangesdecimalpoints_help'] = 'Καθορίζει τον αριθμό δεκαδικών ψηφίων που θα εμφανίζονται για κάθε εύρος ή αν θα χρησιμοποιείται (κληρονομείται) η γενική ρύθμιση δεκαδικών ψηφίων για την κατηγορία ή το στοιχείο βαθμού.';
$string['rangesdisplaytype'] = 'Τρόπος εμφάνισης εύρους';
$string['rangesdisplaytype_help'] = 'Αυτή η ρύθμιση καθορίζει αν το εύρος εμφανίζεται ως πραγματικός βαθμός, ποσοστό ή γράμμα, ή αν χρησιμοποιείται (κληρονομεί) ο τύπος εμφάνισης για την κατηγορία ή το στοιχείο βαθμού.';
$string['rank'] = 'Κατάταξη';
$string['rawpct'] = 'Αρχικό %';
$string['real'] = 'Πραγματικό';
$string['realletter'] = 'Πραγματικό (γράμμα)';
$string['realpercentage'] = 'Πραγματικό (ποσοστό)';
$string['recalculatinggrades'] = 'Επανυπολογισμός βαθμών';
$string['recovergradesdefault'] = 'Προεπιλογή ανάκτησης βαθμών';
$string['recovergradesdefault_help'] = 'Από προεπιλογή ανάκτηση παλιών βαθμών όταν επανεγγράφεται ένας μαθητής σε ένα μάθημα.';
$string['refreshpreview'] = 'Ανανέωση προεπισκόπησης';
$string['regradeanyway'] = 'Αναβαθμολόγηση έτσι κι αλλιώς';
$string['removeallcoursegrades'] = 'Διαγραφή όλων των βαθμών';
$string['removeallcoursegrades_help'] = 'Εάν επιλεγεί, θα διαγραφούν όλα τα στοιχεία βαθμού που προστέθηκαν χειροκίνητα στο βαθμολόγιο, μαζί με τους βαθμούς και τα δεδομένα για τους βαθμούς που παρακάμφθηκαν, εξαιρέθηκαν, αποκρύφθηκαν και κλειδώθηκαν. Θα παραμείνουν μόνο τα στοιχεία βαθμού που συσχετίζονται με δραστηριότητες.';
$string['removeallcourseitems'] = 'Διαγραφή όλων των στοιχείων και κατηγοριών';
$string['removeallcourseitems_help'] = 'Αν επιλεγεί, όλες οι κατηγορίες και στοιχεία βαθμού που προστέθηκαν χειροκίνητα στο βαθμολόγιο θα διαγραφούν, καθώς και βαθμοί και δεδομένα που παρακάμφθηκαν, εξαιρέθηκαν, αποκρύφθηκαν και κλειδώθηκαν. Θα παραμείνουν μόνο στοιχεία βαθμού συσχετισμένα με δραστηριότητες.';
$string['report'] = 'Αναφορά';
$string['reportdefault'] = 'Προεπιλογή αναφοράς ({$a})';
$string['reportplugins'] = 'Πρόσθετα αναφορών';
$string['reportsettings'] = 'Ρυθμίσεις αναφοράς';
$string['reprintheaders'] = 'Ξανατύπωσε τις επικεφαλίδες';
$string['resetweights'] = 'Επαναρχικοποίηση των συντελεστών βαρύτητας του «{$a->itemname}»';
$string['resetweightsshort'] = 'Επαναρχικοποίηση συντελεστών βαρύτητας';
$string['respectingcurrentdata'] = 'οι τρέχουσες ρυθμίσεις αφήνονται χωρίς αλλαγές';
$string['rowpreviewnum'] = 'Προεπισκόπηση γραμμών';
$string['rowpreviewnum_help'] = 'Πριν επιβεβαιώσετε την εισαγωγή, μπορείτε να προβάλετε τα δεδομένα προς εισαγωγή. Αυτή η ρύθμιση καθορίζει πόσες σειρές/γραμμές θα εμφανίζονται στην προεπισκόπηση.';
$string['savechanges'] = 'Αποθήκευση Αλλαγών';
$string['savepreferences'] = 'Αποθήκευση προτιμήσεων';
$string['scaleconfirmdelete'] = 'Είστε σίγουροι ότι θέλετε να διαγράψετε την κλίμακα «{$a}»;';
$string['scaledpct'] = 'Κλιμακωτό %';
$string['seeallcoursegrades'] = 'Εμφάνιση όλων των βαθμών μαθήματος';
$string['select'] = 'Επιλέξτε {$a}';
$string['selectalloroneuser'] = 'Επιλέξτε όλους ή έναν χρήστη';
$string['selectauser'] = 'Επιλέξτε ένα χρήστη';
$string['selectdestination'] = 'Επιλέξτε προορισμό του {$a}';
$string['separator'] = 'Διαχωριστής';
$string['separator_help'] = 'Επιλογή του διαχωριστικού που χρησιμοποιείται στο αρχείο CSV. (Κανονικά είναι το κόμμα.)';
$string['sepcolon'] = 'Άνω κάτω τελεία';
$string['sepcomma'] = 'Κόμμα';
$string['sepsemicolon'] = 'Άνω τελεία';
$string['septab'] = 'Στηλοθέτης';
$string['setcategories'] = 'Ορίστε κατηγορίες';
$string['setcategorieserror'] = 'Πρέπει πρώτα να ορίσετε τις κατηγορίες για το μάθημά σας πριν να τους αποδώσετε συντελεστές βαρύτητας.';
$string['setgradeletters'] = 'Ορίστε βαθμούς με γράμματα';
$string['setpreferences'] = 'Ορίστε προτιμήσεις';
$string['setting'] = 'Ρύθμιση';
$string['settings'] = 'Ρυθμίσεις';
$string['setweights'] = 'Ορίστε συντελεστές βαρύτητας';
$string['showactivityicons'] = 'Εμφάνιση εικονιδίων δραστηριότητας';
$string['showactivityicons_help'] = 'Εάν θα εμφανίζονται τα εικονίδια δραστηριότητας δίπλα στα ονόματα των δραστηριοτήτων.';
$string['showallhidden'] = 'Εμφάνιση όλων';
$string['showallstudents'] = 'Εμφάνιση όλων των μαθητών';
$string['showanalysisicon'] = 'Εμφάνιση του εικονιδίου ανάλυσης βαθμών';
$string['showanalysisicon_desc'] = 'Εάν πρόκειται να εμφανιστεί το εικονίδιο ανάλυσης βαθμού από προεπιλογή. Εάν το υποστηρίζει το άρθρωμα δραστηριότητας, το εικονίδιο ανάλυσης βαθμού συνδέεται με μια σελίδα με λεπτομερέστερη εξήγηση του βαθμού και με τον τρόπο με τον οποίο αποκτήθηκε.';
$string['showanalysisicon_help'] = 'Εάν το υποστηρίζει το άρθρωμα δραστηριότητας, το εικονίδιο ανάλυσης βαθμού συνδέεται με μια σελίδα με λεπτομερέστερη εξήγηση του βαθμού και με τον τρόπο με τον οποίο αποκτήθηκε.';
$string['showaverage'] = 'Εμφάνιση μέσου όρου';
$string['showaverage_help'] = 'Εμφάνιση της στήλης μέσου όρου; Σημειώστε ότι οι συμμετέχοντες έχουν την δυνατότητα να μαντέψουν τους βαθμούς άλλων μαθητών αν ο μέσος όρος είναι υπολογισμένος από μικρό αριθμό βαθμών. Για λόγους απόδοσης ο μέσος όρος είναι κατά προσέγγιση, αν εξαρτάται από τυχόν κρυφά στοιχεία.';
$string['showaverages'] = 'Εμφάνιση μέσων όρων στηλών';
$string['showaverages_help'] = 'Αν ενεργοποιηθεί, η αναφορά βαθμολογητή θα περιλαμβάνει μια επιπρόσθετη γραμμή που θα εμφανίζει τον μέσο όρο (μέση τιμή) για κάθε κατηγορία και στοιχείο βαθμού.';
$string['showcalculations'] = 'Εμφάνιση υπολογισμών';
$string['showcalculations_help'] = 'Εάν ενεργοποιηθεί, όταν γίνεται επεξεργασία, ένα εικονίδιο αριθμομηχανής εμφανίζεται για κάθε στοιχείο και κατηγορία βαθμού με έναν οπτικό δείκτη ότι ένα στοιχείο βαθμού υπολογίζεται.';
$string['showcontributiontocoursetotal'] = 'Εμφάνιση συνεισφοράς στον τελικό βαθμό';
$string['showcontributiontocoursetotal_help'] = 'Εάν θα εμφανίζεται μια στήλη ποσοστών που θα δείχνει πόσο κάθε στοιχείο βαθμού συμμετέχει στο συνολικό ποσοστό μαθήματος του χρήστη (αφού εφαρμοστεί ο συντελεστής βαρύτητας).';
$string['showeyecons'] = 'Εμφάνιση εικονιδίων εμφάνιση/απόκρυψης';
$string['showeyecons_help'] = 'Εάν θα εμφανίζεται ένα εικονίδιο εμφάνισης/απόκρυψης κοντά σε κάθε βαθμό (ελέγχοντας την εμφάνιση του στον χρήστη).';
$string['showfeedback'] = 'Εμφάνιση ανατροφοδότησης';
$string['showfeedback_help'] = 'Αν θα εμφανίζεται στήλη με ανατροφοδότηση.';
$string['showgrade'] = 'Εμφάνιση βαθμών';
$string['showgrade_help'] = 'Εάν θα εμφανίζεται μια στήλη για βαθμούς.';
$string['showgroups'] = 'Εμφάνιση ομάδων';
$string['showhiddenitems'] = 'Εμφάνιση κρυμμένων στοιχείων';
$string['showhiddenitems_help'] = 'Το αν τα κρυμμένα στοιχεία βαθμού θα είναι κρυμμένα εξ ολοκλήρου ή αν τα ονόματα των στοιχείων κρυφών βαθμών θα είναι ορατά στους μαθητές.

* Εμφάνιση κρυφών - Θα εμφανίζονται τα ονόματα κρυφών βαθμών, αλλά οι βαθμοί των μαθητών θα είναι κρυμμένοι
* Μόνο κρυμμένα μέχρι - Τα στοιχεία βαθμού με «απόκρυψη μέχρι» ορισμένη ημερομηνία θα είναι κρυμμένα τελείως μέχρι την καθορισμένη ημερομηνία, μετά την οποία θα εμφανίζεται ολόκληρο το στοιχείο
* Να μην εμφανίζονται - Τα στοιχεία κρυφών βαθμών θα είναι εντελώς κρυμμένα.';
$string['showhiddenuntilonly'] = 'Μόνο κρυμμένα μέχρι';
$string['showingaggregatesonly'] = 'Εμφανίζονται μόνο οι συναθροίσεις';
$string['showingfullmode'] = 'Εμφάνιση πλήρους προβολής';
$string['showinggradesonly'] = 'Εμφάνιση μόνο βαθμών';
$string['showlettergrade'] = 'Εμφάνιση βαθμών με γράμμα';
$string['showlettergrade_help'] = 'Εμφάνιση στήλης βαθμολογιών με γράμματα;';
$string['showlocks'] = 'Εμφάνιση κλειδωμάτων';
$string['showlocks_help'] = 'Εάν ενεργοποιηθεί, όταν η επεξεργασία είναι ενεργή, εμφανίζεται ένα εικονίδιο κλειδώματος/ξεκλειδώματος για κάθε βαθμό για να ελέγχετε αν ο βαθμός μπορεί να ενημερωθεί αυτόματα από τη σχετική δραστηριότητα.';
$string['shownohidden'] = 'Απόκρυψη';
$string['shownooutcomes'] = 'Απόκρυψη μαθησιακών αποτελεσμάτων';
$string['shownumberofgrades'] = 'Εμφάνιση αριθμού βαθμών στους μέσους όρους';
$string['shownumberofgrades_help'] = 'Εάν θα εμφανίζεται ο αριθμός των βαθμών που χρησιμοποιούνται κατά τον υπολογισμό του μέσου σε αγκύλες μετά από κάθε μέσο όρο, για παράδειγμα 45 (34).';
$string['showonlyactiveenrol'] = 'Εμφάνιση μόνο των ενεργών εγγραφών';
$string['showonlyactiveenrol_help'] = 'Αυτή η ρύθμιση καθορίζει, αν μόνο οι ενεργοί εγγεγραμμένοι χρήστες θα είναι ορατοί στην αναφορά βαθμολογίου. Εάν ενεργοποιηθεί, οι χρήστες σε αναστολή δεν θα εμφανιστούν στο βαθμολόγιο.';
$string['showpercentage'] = 'Εμφάνιση ποσοστού';
$string['showpercentage_help'] = 'Εάν θα εμφανίζεται το ποσοστό κάθε στοιχείου βαθμού.';
$string['showquickfeedback'] = 'Εμφάνιση γρήγορης ανατροφοδότησης';
$string['showquickfeedback_help'] = 'Εάν ενεργοποιηθεί, όταν γίνεται επεξεργασία, εμφανίζεται ένα πλαίσιο εισαγωγής κειμένου ανατροφοδότησης με ένα διάστικτο περίγραμμα για κάθε βαθμό, επιτρέποντας την επεξεργασία των σχολίων ανατροφοδότησης για πολλές βαθμολογήσεις την ίδια στιγμή. Οι αλλαγές αποθηκεύονται και φωτο-επισημαίνονται όταν κάνετε κλικ στο κουμπί ενημέρωσης.

Σημειώστε πως όταν μια ανατροφοδότηση τροποποιείται στην αναφορά βαθμολογητή, μια σημαιοδότηση παράκαμψης τίθεται, πράγμα που σημαίνει ότι η ανατροφοδότηση δεν μπορεί πλέον να αλλάξει μέσα από τη σχετική δραστηριότητα.';
$string['showrange'] = 'Εμφάνιση διαστημάτων (εύρος)';
$string['showrange_help'] = 'Εάν θα εμφανίζεται μια στήλη για το εύρος.';
$string['showranges'] = 'Εμφάνιση διαστημάτων (εύρος)';
$string['showranges_help'] = 'Εάν ενεργοποιηθεί, η αναφορά βαθμολογητή θα περιέχει μια επιπρόσθετη γραμμή που θα εμφανίζει το εύρος για κάθε κατηγορία και στοιχείο βαθμού.';
$string['showrank'] = 'Εμφάνιση κατάταξης';
$string['showrank_help'] = 'Εάν θα εμφανίζεται η θέση του χρήστη σε σχέση με την υπόλοιπη τάξη, για κάθε στοιχείο βαθμού.';
$string['showuserimage'] = 'Εμφάνιση εικόνων προφίλ χρήστη';
$string['showuserimage_help'] = 'Εάν θα εμφανίζεται η εικόνα του προφίλ του χρήστη δίπλα στο όνομα του στην αναφορά βαθμολογητή.';
$string['showverbose'] = 'Εμφάνιση {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Εμφάνιση συντελεστών βαρύτητας';
$string['showweight_help'] = 'Εάν θα εμφανίζεται μια στήλη για τον συντελεστή βαρύτητας του βαθμού.';
$string['simpleview'] = 'Ατομική προβολή';
$string['sitewide'] = 'Σε όλο τον ιστότοπο';
$string['sort'] = 'ταξινόμηση';
$string['sortasc'] = 'Ταξινόμηση σε αύξουσα σειρά';
$string['sortbyfirstname'] = 'Ταξινόμηση κατά (μικρό) όνομα';
$string['sortbylastname'] = 'Ταξινόμηση κατά επίθετο';
$string['sortdesc'] = 'Ταξινόμηση σε φθίνουσα σειρά';
$string['standarddeviation'] = 'Τυπική απόκλιση';
$string['stats'] = 'Στατιστικά';
$string['statslink'] = 'Στατ.';
$string['student'] = 'Μαθητής';
$string['studentsperpage'] = 'Μαθητές ανά σελίδα';
$string['studentsperpage_help'] = 'Ο αριθμός των μαθητών που θα εμφανίζονται ανά σελίδα στην αναφορά βαθμολογητή.';
$string['studentsperpagereduced'] = 'Ο μέγιστος αριθμός μαθητών ανά σελίδα μειώθηκε από {$a->originalstudentsperpage} σε {$a->studentsperpage}. Εξετάστε το ενδεχόμενο αύξησης της ρύθμισης PHP max_input_vars από {$a->maxinputvars}.';
$string['subcategory'] = 'Κανονική κατηγορία';
$string['submissions'] = 'Υποβολές';
$string['submittedon'] = 'Υποβλήθηκε: {$a}';
$string['sumofgradesupgradedgrades'] = 'Σημείωση: Η μέθοδος συνάθροισης «Σύνολο βαθμών» έχει αλλάξει σε «Φυσική» ως μέρος αναβάθμισης ιστοτόπου. Επειδή στο παρόν μάθημα χρησιμοποιήθηκε προηγουμένως το «άθροισμα βαθμών», συνιστάται να εξετάζετε αυτήν την αλλαγή στο βαθμολόγιο.';
$string['switchtofullview'] = 'Εναλλαγή σε πλήρη προβολή';
$string['switchtosimpleview'] = 'Εναλλαγή σε απλή προβολή';
$string['tabs'] = 'Καρτέλες';
$string['topcategory'] = 'Σούπερ κατηγορία';
$string['total'] = 'Συνολικό';
$string['totalweight100'] = 'Το σύνολο των συντελεστών βαρύτητας είναι ίσο με 100';
$string['totalweightnot100'] = 'Το σύνολο των συντελεστών βαρύτητας δεν είναι ίσο με 100';
$string['turnfeedbackoff'] = 'Απενεργοποίηση ανατροφοδότησης';
$string['turnfeedbackon'] = 'Ενεργοποίηση ανατροφοδότησης';
$string['typenone'] = 'Κανένα';
$string['typescale'] = 'Κλίμακα';
$string['typescale_help'] = 'Αυτή η ρύθμιση καθορίζει την κλίμακα που θα χρησιμοποιείται όταν χρησιμοποιείται ο τύπος βαθμού «Κλίμακα». Η κλίμακα για ένα στοιχείο βαθμού που βασίζεται σε μια δραστηριότητα καθορίζεται στη σελίδα ρυθμίσεων της δραστηριότητας.';
$string['typetext'] = 'Κείμενο';
$string['typevalue'] = 'Τιμή';
$string['uncategorised'] = 'Μη κατηγοριοποιημένο';
$string['unchangedgrade'] = 'Ο βαθμός δεν άλλαξε';
$string['unenrolledusersinimport'] = 'Αυτή η εισαγωγή συμπεριελάμβανε τους ακόλουθους βαθμούς για χρήστες οι οποίοι δεν είναι εγγεγραμμένοι προς το παρόν σε αυτό το μάθημα: {$a}';
$string['unlimitedgrades'] = 'Βαθμοί χωρίς όριο';
$string['unlimitedgrades_help'] = 'Από προεπιλογή οι βαθμοί περιορίζονται από μια μέγιστη και ελάχιστη τιμή του στοιχείου που βαθμολογείται. Ενεργοποιώντας αυτή τη ρύθμιση αφαιρείται το όριο και επιτρέπει βαθμούς πάνω από 100% που εισάγονται κατευθείαν στο βαθμολόγιο. Συνιστάται αυτή η ρύθμιση να μην ενεργοποιηθεί σε ώρα αιχμής, καθώς όλοι οι βαθμοί θα υπολογιστούν εκ νέου, το οποίο μπορεί να οδηγήσει σε υπερφόρτωση του εξυπηρετητή.';
$string['unlock'] = 'Ξεκλείδωμα';
$string['unlockverbose'] = 'Ξεκλείδωμα {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Μη χρησιμοποιούμενα';
$string['updatedgradesonly'] = 'Εξαγωγή νέων ή ανανεωμένων βαθμών μόνο';
$string['upgradedgradeshidemessage'] = 'Απόρριψη ειδοποίησης';
$string['upgradedminmaxrevertmessage'] = 'Αναίρεση των αλλαγών';
$string['uploadgrades'] = 'Ανέβασμα βαθμών';
$string['useadvanced'] = 'Χρήση προχωρημένων χαρακτηριστικών';
$string['usedcourses'] = 'Χρησιμοποιούμενα μαθήματα';
$string['usedgradeitem'] = 'Χρησιμοποιούμενα στοιχεία βαθμού';
$string['usenooutcome'] = 'Χωρίς χρήση μαθησιακών αποτελεσμάτων';
$string['usenoscale'] = 'Χωρίς χρήση κλίμακας';
$string['usepercent'] = 'Χρησιμοποίηση Ποσοστών';
$string['user'] = 'Χρήστης';
$string['userenrolmentsuspended'] = 'Η εγγραφή χρήστη έχει ανασταλεί';
$string['userfields_show'] = 'Εμφάνιση πεδίων χρήστη';
$string['userfields_show_help'] = 'Εμφάνιση επιπρόσθετων πεδίων χρηστών όπως η διεύθυνση ηλε.ταχυδρομείου στην αναφορά βαθμολογητή. Τα συγκεκριμένα πεδία που εμφανίζονται ελέγχονται από την ρύθμιση ιστοτόπου showuseridentity (εμφάνιση ταυτότητας χρήστη)';
$string['usergrade'] = 'Χρήστης {$a->fullname} ({$a->useridnumber}) στο στοιχείο {$a->gradeidnumber}';
$string['userid'] = 'Αναγνωριστικό χρήστη';
$string['useridnumberwarning'] = 'Οι χρήστες χωρίς αναγνωριστικό αριθμό εξαιρούνται από την εξαγωγή, καθώς δεν μπορούν να εισαχθούν';
$string['usermappingerror'] = 'Σφάλμα αντιστοίχισης χρήστη: Δεν βρέθηκε χρήστης με τιμή «{$a->value}» στο πεδίο «{$a->field}».';
$string['usermappingerrorcurrentgroup'] = 'Ο χρήστης δεν είναι μέλος της τρέχουσας ομάδας.';
$string['usermappingerrormultipleusersfound'] = 'Σφάλμα αντιστοίχισης χρήστη: Πολλοί χρήστες βρέθηκαν με τιμή «{$a->value}» στο πεδίο «{$a->field}». Χρησιμοποιήστε ένα πιο μοναδικό πεδίο χαρτογράφησης.';
$string['usermappingerrorusernotfound'] = 'Σφάλμα αντιστοίχισης χρήστη. Δεν ήταν δυνατή η εύρεση του χρήστη.';
$string['userpreferences'] = 'Προτιμήσεις χρήστη';
$string['useweighted'] = 'Χρήση συντελεστών βαρύτητας';
$string['verbosescales'] = 'Λεπτομερείς περιγραφικές κλίμακες';
$string['verbosescales_help'] = 'Μια περιγραφική (verbose) κλίμακα χρησιμοποιεί λέξεις αντί για αριθμούς.
Ορίστε το «Ναι» εάν πρόκειται να εισαγάγετε τόσο αριθμητικές όσο και περιγραφικές (verbose) κλίμακες.
Ορίστε το «Όχι» εάν πρόκειται να εισαχθούν μόνο αριθμητικές κλίμακες.';
$string['viewbygroup'] = 'Ομάδα';
$string['viewgrades'] = 'Εμφάνιση Βαθμών';
$string['weight'] = 'Συντελεστής βαρύτητας';
$string['weight_help'] = 'Μια τιμή που χρησιμοποιείται για να καθοριστεί η σχετική αξία πολλαπλών στοιχείων βαθμού σε μια κατηγορία ή μάθημα.';
$string['weightcourse'] = 'Χρήση σταθμισμένων βαθμών για το μάθημα';
$string['weightedascending'] = 'Αύξουσα ταξινόμηση κατά ποσοστά σταθμισμένων βαθμών';
$string['weighteddescending'] = 'Φθίνουσα ταξινόμηση κατά ποσοστά σταθμισμένων βαθμών';
$string['weightedpct'] = '% σταθμισμένου βαθμού';
$string['weightedpctcontribution'] = 'συνεισφορά % σταθμισμένου βαθμού';
$string['weightofa'] = 'Συντελεστής βαρύτητας του {$a}';
$string['weightorextracredit'] = 'Συντελεστής βαρύτητας ή πριμοδότηση';
$string['weightoverride'] = 'ρύθμιση/προσαρμογή συντελεστή βαρύτητας';
$string['weightoverride_help'] = 'Εάν αποεπιλεγεί θα επαναρχικοποιήσει τον συντελεστή βαρύτητας ενός στοιχείου βαθμού στην αυτόματα υπολογισμένη τιμή του. Εάν επιλεγεί θα αποτραπεί η αυτόματη ρύθμιση/προσαρμογή του συντελεστή βαρύτητας.';
$string['weights'] = 'Συντελεστές βαρύτητας';
$string['weightsadjusted'] = 'Οι συντελεστές βαρύτητάς σας ρυθμίστηκαν/προσαρμόστηκαν ώστε να έχουν σύνολο 100';
$string['weightsedit'] = 'Επεξεργασία βαρών και πριμοδότησης';
$string['weightuc'] = 'Υπολογιζόμενος συντελεστής βαρύτητας';
$string['writinggradebookinfo'] = 'Εγγραφή ρυθμίσεων βαθμολογίου';
$string['xml'] = 'XML';
$string['yes'] = 'Ναι';
$string['yourgrade'] = 'Ο βαθμός σας';
