<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_security', language 'sl', version '4.3'.
 *
 * @package     report_security
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['check_configrw_details'] = '<p>Priporočljivo je, da po namestitvi spremenite dovoljenja za dostop do datoteke <code>config.php</code>, tako da je spletni strežnik ne more spremeniti.
Upoštevajte, da to ne pripomore bistveno k varnosti strežnika, lahko pa omeji ali upočasni običajne napade na strežnik.</p>';
$string['check_configrw_name'] = 'Zapisljiv config.php';
$string['check_configrw_ok'] = 'PHP skripte ne morejo spremeniti config.php';
$string['check_configrw_warning'] = 'PHP skripte lahko spreminjajo config.php';
$string['check_cookiesecure_details'] = '<p>Če omogočite komunikacijo prek https, je priporočljivo, da omogočite tudi varne piškotke. Dodano bi morali imeti tudi stalno preusmeritev s http na https, ki bi v idealnem primeru služila tudi glavam HSTS.</p>';
$string['check_cookiesecure_error'] = 'Omogočite varne piškotke';
$string['check_cookiesecure_http'] = 'Če želite uporabljati varne piškotke, morate vklopiti https';
$string['check_cookiesecure_name'] = 'Varni piškotki';
$string['check_cookiesecure_ok'] = 'Varni piškotki omogočeni.';
$string['check_crawlers_details'] = '<p>Nastavitev »Odprto za iskalnike« omogoči iskalnikom dostop do predmetov z gostujočim dostopom. Če vaš strežnik ne podpira te vloge, vklop te funkcije ni smiseln.</p>';
$string['check_crawlers_error'] = 'Dostop iskalnikom je omogočen, vendar brez gostujočega dostopa.';
$string['check_crawlers_info'] = 'Iskalniki se lahko prijavijo kot gosti.';
$string['check_crawlers_name'] = 'Odprto za iskalnike';
$string['check_crawlers_ok'] = 'Dostop za iskalnike ni omogočen.';
$string['check_defaultuserrole_details'] = '<p>Vsi prijavljeni uporabniki pridobijo pravice privzete uporabniške vloge. Zagotovite, da ta vloga nima dostopa do tveganih funkcij.</p>
<p>Edini podprti podedovani tip za privzeto vlogo je <em>Overjeni uporabnik</em>. Možnost ogleda predmeta ne sme biti omogočena.</p>';
$string['check_defaultuserrole_error'] = 'Privzeta uporabniška vloga "{$a}" ni pravilno opredeljena!';
$string['check_defaultuserrole_name'] = 'Privzeta vloga vseh uporabnikov';
$string['check_defaultuserrole_notset'] = 'Privzeta vloga ni nastavljena';
$string['check_defaultuserrole_ok'] = 'Privzeta vloga za vse uporabnike je pravilno nastavljena.';
$string['check_displayerrors_details'] = '<p>Priporočljivo je, da na produkcijskih spletnih mestih ne omogočite PHP nastavitve <code>display_errors</code>, ker lahko sporočila o napakah odkrijejo občutljive informacije o vašem strežniku.</p>';
$string['check_displayerrors_error'] = 'Nastavitev PHP za prikaz napak je omogočena. Priporočljivo je, da jo onemogočite.';
$string['check_displayerrors_name'] = 'Prikaz PHP napak';
$string['check_displayerrors_ok'] = 'Prikaz PHP napak je onemogočen.';
$string['check_emailchangeconfirmation_details'] = '<p>Priporočljivo je, da od uporabnikov, ki spremenijo e-poštni naslov v profilu, zahtevate potrditev novega naslova. Če tega ne zahtevate, lahko zlonamerni uporabniki vaš strežnik uporabijo za pošiljanje neželene pošte.</p>
<p>Polje e-poštnega naslova lahko pred overitvenimi vtičniki tudi zaklenete, ta možnost tukaj ni upoštevana.</p>';
$string['check_emailchangeconfirmation_error'] = 'Uporabniki lahko vnesejo poljubni e-poštni naslov.';
$string['check_emailchangeconfirmation_info'] = 'Uporabniki lahko vnesejo e-poštni naslov samo z dovoljenih domen.';
$string['check_emailchangeconfirmation_name'] = 'Potrditev spremembe e-poštnega naslova';
$string['check_emailchangeconfirmation_ok'] = 'Potrditev spremembe e-poštnega naslova v profilu uporabnika.';
$string['check_embed_details'] = '<p>Podpora neomejenemu vključevanju objektov je zelo nevarna - katerikoli registrirani uporabnik lahko izvaja XSS napade na druge uporabnike strežnika. Na produkcijskih strežnikih bi morala biti ta nastavitev onemogočena.</p>';
$string['check_embed_error'] = 'Omogočeno neomejeno vključevanje objektov. To je zelo nevarno za večino strežnikov.';
$string['check_embed_name'] = 'Dovoli EMBED in OBJECT';
$string['check_embed_ok'] = 'Neomejeno vključevanje objektov ni dovoljeno.';
$string['check_frontpagerole_details'] = '<p>Privzeta vloga naslovne strani je dodeljena vsem registriranim uporabnikom za dejavnosti na naslovni strani. Prepričajte se, da vloga ne dovoljuje tveganih zmožnosti.</p>
<p>Priporočljivo je, da v ta namen ne uporabite podedovane vloge, ampak ustvarite posebno vlogo.</p>';
$string['check_frontpagerole_error'] = 'Zaznana nepravilna opredelitev vloge naslovne strani "{$a}".';
$string['check_frontpagerole_name'] = 'Vloga naslovne strani';
$string['check_frontpagerole_notset'] = 'Vloga naslovne strani ni določena.';
$string['check_frontpagerole_ok'] = 'Vloga naslovne strani je pravilno nastavljena.';
$string['check_guestrole_details'] = '<p>Vloga gosta se uporablja za goste, ki niso prijavljeni uporabniki in za začasni dostop do predmetov gostov. Zagotovite, da ta vloga nima dostopa do tveganih funkcij.</p>
<p>Edini podprti podedovani tip za vlogo gosta v predmetu je <em>Guest</em>.</p>';
$string['check_guestrole_error'] = 'Vloga gosta "{$a}" ni pravilno opredeljena!';
$string['check_guestrole_name'] = 'Vloga za goste';
$string['check_guestrole_notset'] = 'Vloga gosta ni nastavljena.';
$string['check_guestrole_ok'] = 'Vloga za goste je pravilno nastavljena.';
$string['check_mediafilterswf_details'] = '<p>Samodejno vključevanje vsebin swf je zelo nevarno - katerikoli registrirani uporabnik lahko izvaja XSS napade na druge uporabnike strežnika. Na produkcijskih strežnikih bi morala biti ta možnost onemogočena.</p>';
$string['check_mediafilterswf_error'] = 'Filter vsebin Flash je omogočen - za večino strežnikov je to zelo nevarno.';
$string['check_mediafilterswf_name'] = 'Filter vsebin .swf je omogočen';
$string['check_mediafilterswf_ok'] = 'Filter vsebin Flash ni omogočen.';
$string['check_nodemodules_details'] = '<p>Imenik <code>{$ a->path}</code> vsebuje module Node.js in njihove odvisnosti, ki jih običajno namesti pripomoček NPM. Ti moduli bodo morda potrebni za lokalni razvoj Moodla, na primer za uporabo ogrodja grunt. Niso potrebni za zagon spletnega mesta Moodle v produkciji in lahko vsebujejo potencialno nevarno kodo, ki izpostavlja vaše spletno mesto oddaljenim napadom. </p><p> Priporočljivo je odstraniti imenik, če je spletno mesto na voljo prek javnega URL-ja, ali vsaj prepovedati spletni dostop do njega v konfiguraciji spletnega strežnika.</p>';
$string['check_nodemodules_info'] = 'Imenik node_modules ne sme biti prisoten na javnih spletnih mestih.';
$string['check_nodemodules_name'] = 'Imenik modulov Node.js';
$string['check_openprofiles_details'] = 'Odprte profile uporabnikov lahko zlorabijo pošiljatelji neželene pošte. Priporočljivo je, da je omogočena ena od funkcij <code>Force users to log in for profiles</code> ali <code>Force users to log in</code>.';
$string['check_openprofiles_error'] = 'Vsi neprijavljeni uporabniki imajo dostop do uporabniških profilov.';
$string['check_openprofiles_name'] = 'Odprti uporabniški profili';
$string['check_openprofiles_ok'] = 'Pregledovanje uporabniških profilov je omogočeno samo prijavljenim uporabnikom.';
$string['check_passwordpolicy_details'] = '<p>Priporočljivo je, da nastavite varnostno politiko gesel. Ugibanje gesel je pogosto najbolj preprost način za pridobivanje nepooblaščenega dostopa do sistema.
Vendar pri politiki ne bodite preveč strogi, saj to lahko povzroči, da si uporabniki ne bodo zapomnili gesel ali pa si jih bodo zapisali.</p>';
$string['check_passwordpolicy_error'] = 'Varnostna politika gesel ni nastavljena.';
$string['check_passwordpolicy_name'] = 'Varnostna politika gesel';
$string['check_passwordpolicy_ok'] = 'Varnostna politika gesel je omogočena.';
$string['check_preventexecpath_details'] = '<p> Omogočanje nastavitve izvedljivih poti prek Admin GUI je vektor za stopnjevanje pravic. To mora biti vsiljeno v config.php: config.php:</p><p><code>$CFG->preventexecpath = true;<code></p>';
$string['check_preventexecpath_name'] = 'Izvedljive poti';
$string['check_preventexecpath_ok'] = 'Izvedljive poti je mogoče nastaviti samo v config.php.';
$string['check_preventexecpath_warning'] = 'Izvedljive poti lahko nastavite v Admin GUI.';
$string['check_riskadmin_detailsok'] = '<p>Prosimo, da preverite sledeči seznam sistemskih skrbnikov:</p>{$a}';
$string['check_riskadmin_detailswarning'] = '<p>Prosimo, da preverite sledeči seznam sistemskih skrbnikov:</p>{$a->admins}
<p>Priporočljivo je, da skrbniške vloge nastavite samo v sistemskem kontekstu. Sledeči uporabniki imajo dodeljene (nepodprte) skrbniške vloge v drugih kontekstih:</p>{$a->unsupported}';
$string['check_riskadmin_name'] = 'Skrbniki';
$string['check_riskadmin_ok'] = 'Najdeno {$a} skrbnikov strežnika.';
$string['check_riskadmin_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) review role assignment</a>';
$string['check_riskadmin_warning'] = 'Najdeno {$a->admincount} skrbnikov strežnika in {$a->unsupcount} nepodprtih dodelitev skrbniških vlog.';
$string['check_riskbackup_details_overriddenroles'] = '<p>Te aktivne preglasitve dajejo uporabnikom zmožnost vkjučitve uporabniških podatkov v varnostnih kopijah. Poskrbite, da je to dovoljenje potrebno.</p> {$a}';
$string['check_riskbackup_details_systemroles'] = '<p>Sledeče sistemske vloge trenutno omogočajo uporabnikom vključevanje uporabniških podatkov v varnostne kopije. Poskrbite, da bo to dovoljenje potrebno.</p> {$a}';
$string['check_riskbackup_details_users'] = '<p>Zaradi zgornjih vlog ali lokalnih preglasitev, imajo sledeči uporabniški računi dovoljenje za izdelavo varnostnih kopij, ki vključujejo zasebne podatke vseh uporabnikov, ki so vpisani v predmet. Poskrbite, da so (a) verodostojni in (b) zaščiteni z močnimi gesli:</p> {$a}';
$string['check_riskbackup_detailsok'] = 'Nobena vloga izrecno ne omogoča varnostnega kopiranja uporabniških podatkov. Upoštevajte pa, da bodo skrbniki, ki imajo možnost »doanything«, še vedno sposobni to storiti.';
$string['check_riskbackup_editoverride'] = '<a href="{$a->url}">{$a->name} v {$a->contextname}</a>';
$string['check_riskbackup_editrole'] = '<a href="{$a->url}">{$a->name}</a>';
$string['check_riskbackup_name'] = 'Varnostna kopija uporabniških podatkov';
$string['check_riskbackup_ok'] = 'Nobena vloga izrecno ne omogoča varnostnega kopiranja uporabniških podatkov';
$string['check_riskbackup_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) v {$a->contextname}</a>';
$string['check_riskbackup_warning'] = 'Najdenih {$a->rolecount} vlog, {$a->overridecount} preglasitev in {$a->usercount} uporabnikov z zmožnostjo varnostnega kopiranja uporabniških podatkov.';
$string['check_riskxss_details'] = '<p>RISK_XSS označuje vse nevarne zmožnosti, ki naj jih uporabljajo samo zaupanja vredni uporabniki.</p>
<p>Prosimo, da preverite, če popolnoma zaupate vsem uporabnikom s spodnjega seznama na tem strežniku:</p><p>{$a}</p>';
$string['check_riskxss_name'] = 'XSS zaupanja vredni uporabniki';
$string['check_riskxss_warning'] = 'RISK_XSS - najdeno {$a} zaupanja vrednih uporabnikov';
$string['check_unsecuredataroot_details'] = '<p>Korenski imenik ne sme biti dostopen na spletu. Najboljši način, da zagotovite, da imenik ni dostopen, je uporaba imenika zunaj javnega spletnega imenika.</p>
<p>Če premaknete imenik, morate posodobiti tudi <code>$CFG->dataroot</code> nastavitev v <code>config.php</code> accordingly.</p>';
$string['check_unsecuredataroot_error'] = 'Vaš korenski imenik <code>{$a}</code> je na napačni lokaciji in je viden na spletu!';
$string['check_unsecuredataroot_name'] = 'Nezavarovan korenski imenik';
$string['check_unsecuredataroot_ok'] = 'Korenski imenik ne sme biti dostopen na spletu.';
$string['check_unsecuredataroot_warning'] = 'Vaš korenski imenik <code>{$a}</code> je na napačni lokaciji in je morda dostopen na spletu.';
$string['check_vendordir_details'] = '<p>Imenik <code>{$ a->path}</code> vsebuje različne neodvisne knjižnice in njihove odvisnosti, ki jih običajno namesti PHP Composer. Te knjižnice bodo morda potrebne za lokalni razvoj Moodla, na primer za namestitev ogrodja PHPUnit. Niso potrebne za zagon spletnega mesta Moodle v produkciji in lahko vsebujejo potencialno nevarno kodo, ki izpostavlja vaše spletno mesto oddaljenim napadom. </p><p>Priporočljivo je odstraniti imenik, če je spletno mesto na voljo prek javnega URL-ja, ali vsaj prepovedati spletni dostop do njega v konfiguraciji spletnega strežnika.</p>';
$string['check_vendordir_info'] = 'Imenik prodajalcev ne sme biti prisoten na javnih spletnih mestih.';
$string['check_vendordir_name'] = 'Imenik prodajalcev';
$string['check_webcron_details'] = '<p>Če zaženete cron iz spletnega brskalnika, lahko anonimnim uporabnikom razkrijete privilegirane informacije. Priporočljivo je, da zaženete cron samo iz ukazne vrstice ali nastavite geslo za oddaljen dostop.</p>';
$string['check_webcron_name'] = 'Spletni cron';
$string['check_webcron_ok'] = 'Anonimni uporabniki ne morejo dostopati do crona.';
$string['check_webcron_warning'] = 'Anonimni uporabniki lahko dostopajo do crona.';
$string['configuration'] = 'Konfiguracija';
$string['description'] = 'Opis';
$string['details'] = 'Podrobnosti';
$string['eventreportviewed'] = 'Ogledano poročilo o varnostnem preverjanju';
$string['issue'] = 'Težava';
$string['pluginname'] = 'Pregled varnosti';
$string['privacy:metadata'] = 'Vtičnik za varnostni pregled ne hrani nobenih osebnih podatkov.';
$string['security:view'] = 'Prikaži varnostno poročilo';
$string['timewarning'] = 'Obdelovanje podatkov lahko traja dalj časa, prosimo bodite potrpežljivi...';
