<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_brickfield', language 'sr_cr', version '4.2'.
 *
 * @package     tool_brickfield
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'Приступачност';
$string['accessibilitydisabled'] = 'Brickfield комплет алата за приступачност није омогућен на овом сајту. Обратите се администратору сајта да га омогући.';
$string['accessibilityreport'] = 'Комплет алата за приступачност';
$string['accessibilitytool'] = 'Brickfield алат за приступачност';
$string['accessibilitytools'] = 'Brickfield алати за приступачност';
$string['activate'] = 'Активирај';
$string['activated'] = 'Додатак је активиран и спреман за употребу.';
$string['activationform'] = 'Brickfield регистрација';
$string['activationheader'] = 'Brickfield активација';
$string['activationinfo'] = '<p>Како бисте користили овај додатак, морате у овај образац унети важеће кључеве за овај сајт.</p><p>Молимо вас <a href="{$a}" data-action="send_info" target="_blank">да се региструјете на Brickfield порталу (отвара се у новом прозору)</a> како бисте добили те кључеве, уколико их већ немате.</p><p>Када се активирају, ваши кључеви ће бити проверени путем планираних крон задатака.</p>';
$string['activityresults:pluginname'] = 'Извештај алата за приступачност о грешкама у активностима';
$string['activityresults:toolname'] = 'Резиме грешака у активностима';
$string['activityresults:toolshortname'] = 'Грешке у активностима';
$string['advanced:pluginname'] = 'Извештај напредног алата за приступачност';
$string['advanced:toolname'] = 'Напредни резиме';
$string['advanced:toolshortname'] = 'Напредни';
$string['allcourses'] = 'Сви прегледани курсеви ({$a})';
$string['allcoursescat'] = 'Сви прегледани курсеви за категорију {$a->catname} ({$a->count})';
$string['analysis:byrequest'] = 'По захтеву';
$string['analysis:disabled'] = 'Онемогућено';
$string['analysistype'] = 'Омогући захтеве за анализу';
$string['analysistype_desc'] = 'Дозволите да се може затражити анализа приступачности садржаја';
$string['analysistypedisabled'] = 'Анализа садржаја је онемогућена';
$string['bannercontentone'] = 'Enterprise Accessibility Toolkit поседује читав сет функција које могу помоћи вашој организацији да унапреди приступачност ваших курсева. <a href="{$a}">Контактирајте Brickfield Education Labs</a> како бисте резервисали бесплатну демонстрацију напредних функција.';
$string['bannercontenttwo'] = 'Подигните ефикасну и инклузивну платформу за подучавање и учење тако што ћете пронаћи садржај који није у складу са препорукама, решити проблеме и припремити садржај свог Moodle курса за будућност помоћу приступачних датотека, едитора и побољшљних функција.';
$string['bannerheadingone'] = 'Надоградња на Enterprise Accessibility Toolkit';
$string['batch'] = 'Ограничење пакета';
$string['brickfield'] = 'Brickfield комплет алата';
$string['brickfield:viewcoursetools'] = 'Погледајте извештаје по курсевима';
$string['brickfield:viewsystemtools'] = 'Погледајте извештаје за све курсеве';
$string['bulkprocesscaches'] = 'Обрада масовног кеширање';
$string['bulkprocesscourses'] = 'Обрада масовних пакета за проверу приступачности';
$string['buttonone'] = 'Набавите бесплатну демо верзију';
$string['cachepending'] = 'У току је компајлирање збирних података';
$string['checkdesc:alinksdontopennewwindow'] = 'Линкови који се отварају у новом прозору требало би унапред да упозоре кориснике.';
$string['checkdesc:amustcontaintext'] = 'Линк мора да садржи текст да би био уочљив.';
$string['checkdesc:areadontopennewwindow'] = 'Области, које се користе у мапама слика, и које се отварају у новом прозору требало би унапред да упозоре кориснике.';
$string['checkdesc:areahasaltvalue'] = 'Областима, које се користе у мапама слика, не би требало да недостаје alt (алтернативни) текст, слично сликама.';
$string['checkdesc:asuspiciouslinktext'] = 'Текст линка треба да буде дескриптиван и да пружи контекст о свом одредишту.';
$string['checkdesc:basefontisnotused'] = 'HTML eлементи за основни фонт (тј. таг <basefont>), који се традиционално користе за форматирање, нису приступачни и не би требало да се користе.';
$string['checkdesc:blinkisnotused'] = 'Трепћући елементи, који се пале и гасе, нису приступачни и не би требало да се користе.';
$string['checkdesc:boldisnotused'] = 'HTML eлементи за болдовање (таг <b>) не би требало да се користе; уместо тога треба користити таг "strong"';
$string['checkdesc:contenttoolong'] = 'Укупна дужина садржаја странице не би требало да прелази 500 речи.';
$string['checkdesc:csstexthascontrast'] = 'Контраст боја између текста и позадине је недовољан.';
$string['checkdesc:embedhasassociatednoembed'] = 'HTML eлементима уградње (за уграђивање мултимедије) (таг <embed>) не би требало да недостају њихови одговарајући "noembed" елементи.';
$string['checkdesc:headerh3'] = 'Наслови који следе после наслова са HTML тагом H3  (опција великог наслова у едитору текста) не би требало да наруше хијерархију наслова странице.';
$string['checkdesc:headershavetext'] = 'Заглавље мора да садржи текст да би било уочљиво.';
$string['checkdesc:iisnotused'] = 'HTML eлементи за курзив (таг <i>) не би требало да се користе; уместо тога треба користити таг ”em”.';
$string['checkdesc:imgaltisdifferent'] = 'Алтернативни текст слике (атрибут alt) не би требало да буде назив датотеке.';
$string['checkdesc:imgaltistoolong'] = 'Алтернативни текст слике (атрибут alt) не би требало да буде дужи од максимално дозвољених (125) знакова.';
$string['checkdesc:imgaltnotemptyinanchor'] = 'Алтернативни текст слике (атрибут alt) не би требало да буде празан, посебно ако слика има линк која води негде другде.';
$string['checkdesc:imgaltnotplaceholder'] = 'Алтернативни текст слике (атрибут alt) не би требало да буде једноставан текст, попут нпр. "слика".';
$string['checkdesc:imghasalt'] = 'Алтернативни текст слике (атрибут alt) не би требало изоставити осим ако је слика чисто декоративна без икаквог значења.';
$string['checkdesc:imgwithmaphasusemap'] = 'Мапе слика са областима на које се може кликнути треба да имају одговарајуће елементе "usemap"и "map".';
$string['checkdesc:legendtextnotempty'] = 'HTML eлементи за легенде (таг <legend>), који се користе за означавање елемената скупа поља, треба да садрже текст.';
$string['checkdesc:marqueeisnotused'] = 'HTML eлементи за клизеће текстове (таг <marquee>), који се аутоматски померају, нису приступачни и не би требало да се користе.';
$string['checkdesc:noheadings'] = 'Без наслова садржај је мање структурисан и тежи за читање.';
$string['checkdesc:objectmusthaveembed'] = 'HTML eлементи за објекте, за уграђивање екстерних ресурса (таг <object>), не би требало да недостају њихови одговрајући елементи "embed".';
$string['checkdesc:objectmusthavetitle'] = 'HTML eлементима за објекте, за уграђивање екстерних ресурса (таг <object>), не би требало да недостају њихови одговарајући описи атрибута "title" .';
$string['checkdesc:objectmusthavevalidtitle'] = 'HTML eлементи за објекте, за уграђивање екстерних ресурса (таг <object>), требало би да имају одговарајући атрибут "title" са текстом.';
$string['checkdesc:strikeisnotused'] = 'HTML eлементи за прецртани текст (таг <s>) не би требало да се користе; уместо тога треба користити таг "del"';
$string['checkdesc:tabledatashouldhaveth'] = 'У табелама, идеално, не би требало да недостају заглавља.';
$string['checkdesc:tablesummarydoesnotduplicatecaption'] = 'Резимеи и наслови табела не би требало да буду идентични.';
$string['checkdesc:tabletdshouldnotmerge'] = 'Табеле, идеално, не би требало да имају спојене ћелије.';
$string['checkdesc:tablethshouldhavescope'] = 'Опсези редова или колона у табелама (који се користе за мапирање редова и колона за сваку ћелију) требало би да буду наведени.';
$string['checkidvalidation'] = 'Провера да ли постоје неисправне ID ознака провера';
$string['checkscompleted'] = 'Завршене провере: {$a}';
$string['checktype'] = 'Проверите групу';
$string['checktype:form'] = 'Образац';
$string['checktype:image'] = 'Слика';
$string['checktype:layout'] = 'Изглед';
$string['checktype:link'] = 'Линк';
$string['checktype:media'] = 'Медиј';
$string['checktype:table'] = 'Табела';
$string['checktype:text'] = 'Текст';
$string['checktyperesults:pluginname'] = 'Извештај алата за приступачност о типовима садржаја';
$string['checktyperesults:toolname'] = 'Резиме типова садржаја';
$string['checktyperesults:toolshortname'] = 'Типови садржаја';
$string['cmpercent'] = 'Свеукупни проценат активности';
$string['cmpercenterrors'] = 'Свеукупни проценат грешака';
$string['cmpercenttitle'] = 'Укупна % грешака у активностима у односу на грешке';
$string['confirmationmessage'] = 'За овај курс је заказана анализа. Анализа ће бити завршена најраније
за {$a}. Проверите поново после тога.';
$string['contactadmin'] = 'Молимо вас да контактирате администратора како бисте довршили регистрацију.';
$string['contactus'] = 'Контактирајте нас';
$string['contentfive'] = 'Аутоматски поправите застареле HTML ознаке.';
$string['contentfour'] = 'Идентификујте које активности имају највише проблема са приступачношћу како бисте одредили приоритете.';
$string['contentone'] = 'Аутоматски евалуирајте садржај свог курса и процене за проблеме приступачности.';
$string['contentsix'] = 'Дајте предавачима на време савете за креирање бољег садржаја.';
$string['contentthree'] = 'Обезбедите својим полазницима садржај у приступачним форматима укључујући аудио (Audio), електронску публикацију (ePub) и електронско Брајево писмо (Electronic Braille).';
$string['contenttwo'] = 'Масовно ажурирање је нејасно или недостаје текст за веб линкове, описе слика и титлове видео клипова.';
$string['contenttypeerrors'] = 'Укупни резултати тестова садржаја активности по курсу и по типу садржаја.';
$string['contentyperesults'] = 'Укупан број успешних/неуспешних тестова за области садржаја по курсу.';
$string['contextid'] = 'ID ознака контекста';
$string['core_course'] = 'Курс';
$string['core_question'] = 'Банке питања';
$string['count'] = 'Бројање';
$string['country'] = 'Држава';
$string['country_help'] = 'Држава сајта';
$string['coursecount'] = 'Број курсева';
$string['deletehistoricaldata'] = 'Избришите историју резултата провера';
$string['dependency'] = 'Зависи од';
$string['emptycategory'] = 'Није пронађен ниједан курс за категорију {$a}';
$string['emptytagcourses'] = 'Нису пронађени резултати за курсеве са конфигурисаним ознакама';
$string['enableaccessibilitytools'] = 'Омогућите алате за приступачност';
$string['enableaccessibilitytools_desc'] = 'Комплет алата за приступачност помаже у идентификовању проблема у вези са приступачношћу на курсевима.';
$string['error:nocoursespecified'] = 'За скраћени извештај је потребан исправан ID ознака курса. Приступите комплету алата за приступачност унутар курса.';
$string['errorlink'] = 'Уреди инстанцу грешке за {$a}';
$string['errors'] = 'Грешке: {$a}';
$string['errors:pluginname'] = 'Списак грешака алата за приступачност';
$string['errors:toolname'] = 'Резиме списка грешака';
$string['errors:toolshortname'] = 'Списак грешака';
$string['eventanalysis_requested'] = 'Затражена анализа садржаја';
$string['eventanalysis_requesteddesc'] = 'Затражена је анализа садржаја за курс {$a}.';
$string['eventreport_downloaded'] = 'Резиме извештаја о приступачности преузет';
$string['eventreport_downloadeddesc'] = 'Преузет је резиме извештаја о приступачности је преузет за ID ознаку курса {$a}.';
$string['eventreport_viewed'] = 'Извештај о приступачности приказан';
$string['eventreport_vieweddesc'] = 'Извештај о приступачности је приказан за курс са ID ознаком {$a->course}, категорију са ID ознаком {$a->category}, картицу {$a->tab}.';
$string['failed'] = 'Неуспешно';
$string['failedcount'] = 'Неуспешно: {$a}';
$string['footerheading'] = 'Секција подножја';
$string['fullcachedone'] = 'Онемогућите како бисте поново покренули кеширање';
$string['hashcorrect'] = 'Унети кôд је тачан.';
$string['hashincorrect'] = 'Унети кôд је нетачан.';
$string['headingfive'] = 'HTML исправке';
$string['headingfour'] = 'Фокусирајте напор - Aктивности са највише грешака';
$string['headingone'] = 'Процените садржај';
$string['headingsix'] = 'Подршка за перформансе';
$string['headingthree'] = 'Приступачни формати датотека';
$string['headingtwo'] = 'Поправка грешака';
$string['hideshow'] = 'Сакриј/прикажи';
$string['icon:analytics-custom'] = 'Иконица аналитике';
$string['icon:file-edit-custom'] = 'Уреди иконицу датотеке';
$string['icon:hands-helping-custom'] = 'Иконица руку за помоћ';
$string['icon:search-plus-custom'] = 'Иконица за претрагу';
$string['icon:tools-custom'] = 'Иконица алата';
$string['icon:wand-magic-custom'] = 'Иконица чаробног штапића';
$string['inactive'] = 'Додатак је неактиван и не може се користити. Унесите исправне регистрационе кључеве и притисните "Активирај".';
$string['innercontextid'] = 'ID ознака унутрашње контекста';
$string['installed'] = 'Додатак је инсталиран';
$string['installedcli'] = 'Додатак је инсталиран преко командне линије';
$string['installeddescription'] = 'Додатак је инсталиран, идите на образац за активацију.';
$string['invalidaccessibilitytool'] = 'Затражен је неисправан поддодатак за приступачност.';
$string['invalidcategoryid'] = 'Неисправна категорија, проверите свој унос';
$string['invalidcourseid'] = 'Неисправан курс, проверите свој унос';
$string['invalidlinkphrases'] = 'click|click here|here|more|more here|info|info here|information|information here|read more|read more here|further information|further information here|further details|further details here';
$string['language'] = 'Језик';
$string['language_help'] = 'Језик сајта';
$string['messageprovider:warningcheckid'] = 'Упозорење о неисправним ID ознака провера';
$string['mobileservice'] = 'Омогућени мобилни сервиси ({$a})';
$string['module'] = 'Модул';
$string['modulename'] = 'Назив';
$string['moreinfo'] = 'Више информација';
$string['newwindowphrases'] = 'нови прозор|нови-прозор|нови_прозор';
$string['noerrorsfound'] = 'Нису пронађене уобичајене грешке у приступачности за ваше параметре претраге. Честитамо!';
$string['norecords'] = 'Нису пронађени релевантни записи за ваше параметре претраге.';
$string['notregistered'] = 'Ваш комплет алата за приступачност мора бити регистрован.';
$string['notvalidated'] = 'Ваш комплет алата за приступачност је функционалан док се проверава његова исправност.';
$string['numcourses'] = 'Број курсева ({$a})';
$string['numfactivities'] = 'Број активности ({$a})';
$string['numfiles'] = 'Број датотека ({$a})';
$string['numinstances'] = 'Број инстанци';
$string['numusers'] = 'Број корисника ({$a})';
$string['pagedesc:checktype'] = '<p>Како би се сумирали и анализирали резултате спроведених провера, резултати ових провера се групишу у различите типове садржаја. Дакле, сви резултати провере приступачности у вези са сликама налазе се у групи типа садржаја "Слике", сви резултати провере приступачности у вези са изгледом странице налазе се у групи типа садржаја "Изглед" и тако даље.</p><p>Активности које су укључене у проверу обухватају активности, ресурсе или области са садржајем које се односе на саме курсеве.</p><p>Страници са графиконом типова садржаја приказује  анализу грешака по групама типова садржаја: Слике, Изглед, Линк, Мултимедијални садржај, Табела и Текст.</p>';
$string['pagedesc:pertarget'] = '<p>Како би се сумирали и анализирали резултате провере по активности, резултати ових провера се групишу у различите откривене активности.</p><p>Активности које су укључене у проверу обухватају активности, ресурсе или друге области са садржајем које се односе на саме курсеве. Свака активност код које нису откривене грешке се рачуна да је прошла проверу (успешне активности), док свака активност са једном или више откривених грешака се рачуна као да није прошла проверу (неуспешне активности). Затим се приказује однос између активности без и активности са грешком.</p><p>Страница са графиконом грешака у активностима приказује укупан однос успешних и неуспешних инстанци, по активности, као што су Задатак, Курс, Натпис, Лекција, Тест итд.</p>';
$string['pagedesctitle:checktype'] = 'Објашњени типови садржаја';
$string['pagedesctitle:pertarget'] = 'Објашњена грешака откривених у активностима';
$string['passed'] = 'Прошла проверу';
$string['passedcount'] = 'Прошла проверу: {$a}';
$string['passrate'] = 'Пролазност: {$a}%';
$string['pdf:filename'] = 'Brickfield_Summaryreport_CourseID-{$a}';
$string['percheckerrors'] = 'Број специфичних тестова и грешака по провери по курсу.';
$string['perpage'] = 'Број ставки за приказ по страници';
$string['pluginname'] = 'Комплет алата за приступачност';
$string['printable:downloadpdf'] = 'Преузми PDF';
$string['printable:pluginname'] = 'Скраћени извештај алата за приступачност';
$string['printable:printreport'] = 'Извештај за штампање';
$string['printable:toolname'] = 'Скраћени извештај';
$string['printable:toolshortname'] = 'Скраћени извештај';
$string['privacy:metadata'] = 'Додатак Извештај о провери приступачности не чува никакве личне податке.';
$string['processanalysisrequests'] = 'Обрада захтеве за анализу садржаја';
$string['registernow'] = 'Молимо вас да се региструјете сада.';
$string['registration'] = 'Образац за регистрацију';
$string['registrationinfo'] = '<p>Овај процес регистрације вам омогућава да користите почетну (стартер) верзију Brickfield комплета алата за приступачност за свој регистровани Moodle сајт.</p><p>Ова употреба подлеже <a href="{$a}" target="_blank">Brickfield Education Labs правилима и условима коришћења (отвара у новом прозору)</a> са којима се слажете самим коришћењем овог производа.</p>';
$string['release'] = 'Moodle издање ({$a})';
$string['remaining'] = '(преостало грешака: {$a})';
$string['response:0'] = 'Ова URL адреса не води нигде';
$string['response:404'] = 'Ова URL страница није пронађена';
$string['schedule:blocknotscheduled'] = '<p>Још увек није заказанан анализа овог курс, како би се пронашли уобичајени проблеми везани за приступачност.</p>';
$string['schedule:notscheduled'] = '<p>Још није заказана анализа овог курса, како би се пронашли уобичајени проблеми везани за приступачност.</p><p>Кликом на дугме "Пошаљи на анализу" потврђујете да желите да сав релевантни HTML садржај курса, као што су описи секција курса, описи активности, питања, странице, и још много тога, буде послат на анализу.</p><p>Ова анализа ће спровести вишеструке уобичајене провере приступачности HTML садржаја вашег курса, а резултати тих провера биће затим приказани на овим страницама извештаја алата за приступачност. Анализа ће бити обрађена у позадини, према заказаним задацима, тако да ће брзина њеног завршетка зависити од тајминга задатака и распореда њиховог извршавања.</p>';
$string['schedule:requestanalysis'] = 'Пошаљи на анализу';
$string['schedule:scheduled'] = 'За овај курс је заказана анализа.';
$string['schedule:sitenotscheduled'] = '<p>Још није заказана анализа глобалног садржаја (независног од курса) како би се пронашла уобичајени проблеми везани за приступачност.</p><p>Кликом на дугме "Пошаљи на анализу" потврђујете да желите свој релевантни глобални садржај (независан од курса) буде послат на анализу.</p><p>Ова анализа ће спровести вишеструке уобичајене провере приступачности овог садржаја, а резултати тих провера биће затим приказани на овим страницама извештаја алата за приступачност. Анализа ће бити обрађена у позадини, према заказаним задацима, тако да ће брзина њеног завршетка зависити од тајминга задатака и распореда њиховог извршавања.</p>';
$string['schedule:sitescheduled'] = 'За глобални (независан од курса) садржај заказана је анализа.';
$string['secretkey'] = 'API кључ';
$string['secretkey_help'] = 'Овај кôд се добија електронском поштом након регистрације.';
$string['sendfollowinginfo'] = '<p>Следеће информације ће се повремено слати само да би допринеле укупној статистици. Неће бити јавно објављен ни на једном централном списку.</p> {$a}';
$string['settings'] = 'Подешавања комплета алата за приступачност';
$string['sitehash'] = 'Тајни кључ';
$string['sitehash_help'] = 'Овај кôд се добија електронском поштом након регистрације.';
$string['taberrors'] = 'Проверите грешке';
$string['targetavetitle'] = 'Просечан број грешака по активности';
$string['targetpercentage'] = 'Проценат успешних/неуспешних инстанци по активности';
$string['targetratio'] = 'Однос успешности активности';
$string['tblcheck'] = 'Провера';
$string['tblcheckexample'] = 'Пример';
$string['tblcheckfailed'] = 'Неуспешне провере';
$string['tblchecksummary'] = 'Резиме';
$string['tbledit'] = 'Уреди';
$string['tblerrorcount'] = 'Грешке';
$string['tblhtmlcode'] = 'Постојећи HTML кôд';
$string['tblinstance'] = 'Инстанца';
$string['tblline'] = 'Ред';
$string['tbloverallpercentage'] = 'Свеукупан % грешака';
$string['tblpercentage'] = 'Проценат';
$string['tblpreview'] = 'Преглед';
$string['tbltarget'] = 'Активност';
$string['tblupdateto'] = 'Ажурирајте на';
$string['titleactivityresultsall'] = 'Резултати по активности: сви прегледани курсеви ({$a->count} courses)';
$string['titleactivityresultspartial'] = 'Резултати по активности: курс {$a->name}';
$string['titleall'] = 'Подаци о грешкама: сви прегледани курсеви ({$a->count} courses)';
$string['titlechecktyperesultsall'] = 'Резултати по типу садржаја: сви прегледани курсеви ({$a->count} courses)';
$string['titlechecktyperesultspartial'] = 'Резултати по типу садржаја: курс {$a->name}';
$string['titleerrorsall'] = 'Подаци о грешкама: сви прегледани курсеви ({$a->count} courses)';
$string['titleerrorscount'] = 'Подаци о грешкама:  (приказује се првих {$a} грешака)';
$string['titleerrorspartial'] = 'Подаци о грешкама: курс {$a->name}';
$string['titlepartial'] = 'Подаци о грешкама: курс {$a->name}';
$string['titleprintableall'] = 'Курс {$a->name}';
$string['titleprintablepartial'] = 'Курс {$a->name}';
$string['tools'] = 'Извештаји';
$string['toperrors'] = 'Најчешће грешке';
$string['toptargets'] = 'Неуспеле активности';
$string['totalactivities'] = 'Укупно активности';
$string['totalactivitiescount'] = 'Укупно активности: {$a}';
$string['totalareas'] = 'Укупно области са садржајем';
$string['totalerrors'] = 'Укупно грешака';
$string['totalgrouperrors'] = 'Укупно грешака по типу активности';
$string['updatesummarydata'] = 'Ажурирање резимеа сајта';
$string['usersmobileregistered'] = 'Број корисника са регистрованим мобилним уређајима ({$a})';
$string['validationerror'] = 'Провера исправности регистрационог кључа није успела. Проверите да ли су URL адреса и кључеви вашег регистрованог сајта исправан.';
$string['warningcheckidbody'] = 'Постоји проблем са Brickfield провером која је активна, али није наведена у бази података. Молимо вас да испитате о чему се ради.';
$string['warningcheckidsubject'] = 'Brickfield Toolkit checkID упозорење';
