<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_homework', language 'fr', version '4.2'.
 *
 * @package     block_homework
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['achievementactivity'] = 'Activité';
$string['achievementbehaviour'] = 'Réussite &amp; Comportement';
$string['achievementcomments'] = 'Commentaires';
$string['achievementpoints'] = 'Points';
$string['achievementreporter'] = 'Rapporté par';
$string['achievementtype'] = 'Type de réussite';
$string['actions'] = 'Actions';
$string['activity'] = 'Activité';
$string['activity_help'] = 'Vous pouvez créer une nouvelle activité ou en copier une existante';
$string['addfiles'] = 'Ajouter un/des fichier(s)';
$string['addfiles_help'] = 'Déposer un/des fichier(s) nécessaires au devoir';
$string['addingachievementfor'] = 'Ajout de succès pour';
$string['addingbehaviourfor'] = 'Ajout d’un comportement pour';
$string['additional'] = 'Additionnel';
$string['addsubmission'] = 'Ajouter une contribution';
$string['adminnotificationerror'] = 'Erreur lors de la tentative de notification à l’administrateur : {$a}';
$string['alldone'] = 'Terminé';
$string['allorfiltered'] = 'Veuillez sélectionner Tout ou Filtré avant de cliquer sur Exporter';
$string['allowshowdescription'] = 'Autoriser les utilisateurs à définir Afficher la description';
$string['allowshowdescription_help'] = 'Indique si les utilisateurs peuvent définir le paramètre Afficher la description';
$string['allxselected'] = 'Tous les {0} sélectionnés';
$string['anystaffmember'] = '(Tout membre du personnel)';
$string['assignment'] = 'Devoir';
$string['assignmentmarked'] = 'Devoir noté avec succès.';
$string['assignmentmarkedasdone'] = 'Le devoir a été marqué comme terminé';
$string['assignmentnotifications'] = 'Notifications du devoir';
$string['assignmentsaved'] = 'Devoir enregistré avec succès';
$string['assignmentsgraded'] = 'Devoirs notés';
$string['assignmentsgradedpermonth'] = 'Devoirs notés par mois';
$string['assignmentsset'] = 'Paramétrage des devoirs';
$string['assignmentssetpergroup'] = 'Paramétrage des devoirs par groupe';
$string['assignmentssetpermonth'] = 'Paramétrage des devoirs par mois';
$string['assignmentssetperstaffmember'] = 'Paramétrage des devoirs par membre du personnel';
$string['assignmentssetpersubject'] = 'Paramétrage des devoirs par sujet';
$string['available'] = 'Disponible';
$string['available_help'] = 'La date à partir de laquelle les devoirs deviennent visibles pour les participants';
$string['availablefrom'] = 'Disponible depuis';
$string['backtomarkinglist'] = 'Retour à la liste de marquage';
$string['basics'] = 'Basiques';
$string['behaviouractiontaken'] = 'Mesure prise';
$string['behaviouractivity'] = 'Activité';
$string['behaviourcomments'] = 'Commentaires';
$string['behaviourpoints'] = 'Points';
$string['behaviourreporter'] = 'Rapporté par';
$string['behaviourstatus'] = 'Statut';
$string['behaviourtype'] = 'Type de comportement';
$string['bulkachievementwriteback'] = 'Ajouter une marque de réussite pour ceux<br />qui ont déposé leur devoir';
$string['bulkbehaviourwriteback'] = 'Ajouter une marque de comportement pour ceux<br />qui n’ont pas déposé leur devoir';
$string['cachedef_participants'] = 'Listes des participants cachés pour chaque devoir';
$string['cancel'] = 'Annuler';
$string['changecourse'] = 'Changer';
$string['child'] = 'Enfant';
$string['clone_'] = 'Copie';
$string['cloneexistingactivity'] = 'Copier les activités existantes…';
$string['communicatormissing'] = 'Cette fonctionnalité n’est disponible que si vous disposez d’une licence pour <a href="http://www.overnetdata.com/products/edulink-communicator/introduction/"> EduLink Communicator </a>. Veuillez contacter Overnet Data ou votre revendeur.';
$string['community'] = 'Communauté';
$string['completed'] = 'Achevé';
$string['contactsupport'] = 'Veuillez signaler les bogues à votre service d’assistance si vous en avez un, sinon à <a href="mailto:support@overnetdata.com"> support@overnetdata.com </a>.';
$string['copyof_'] = 'Copie de';
$string['correcthighlightederrors'] = 'Corrigez les erreurs surlignées avant d’enregistrer';
$string['course'] = 'Cours';
$string['courselabel_help'] = 'C’est le cours auquel l’activité de devoir sera ajoutée. Seuls les étudiants inscrits dans ce cours auront accès à l’activité.';
$string['createdby'] = 'Créé par';
$string['createnewassignmentactivity'] = 'Nouveau devoir';
$string['creatorisparticipant'] = 'S’assurer que le créateur du devoir participe au devoir';
$string['creatorisparticipant_help'] = 'Toujours ajouter l’auteur du devoir à la liste des utilisateurs individuels participant';
$string['date'] = 'Date';
$string['dateavailable'] = 'Date de disponibilité';
$string['defaultnotifyparents'] = 'Paramètre par défaut pour Notifier les parents';
$string['defaultnotifyparents_help'] = 'Si le paramètre Notifier les parents est activé ou désactivé par défaut';
$string['defaultshowdescription'] = 'Paramètre par défaut pour Afficher la description';
$string['defaultshowdescription_help'] = 'Indique si le paramètre Afficher la description est activé ou désactivé par défaut';
$string['deletehomeworkitem'] = 'Supprimer les devoirs';
$string['description'] = 'Description';
$string['description_help'] = 'Une description détaillée du devoir';
$string['details'] = 'Détails';
$string['due'] = 'Échéance';
$string['due_help'] = 'La date à laquelle les devoirs doivent être soumis';
$string['duedate'] = 'Date d’échéance';
$string['duedateinvalid'] = 'La date d’échéance doit être postérieure à la date de disponibilité';
$string['dueon'] = 'Échéance le';
$string['dueondate'] = '{$a}';
$string['dueonlc'] = 'échéance le';
$string['duration'] = 'Durée';
$string['duration_10'] = '10 minutes';
$string['duration_120'] = '2 heures';
$string['duration_180'] = '3 heures';
$string['duration_20'] = '20 minutes';
$string['duration_240'] = '4 heures';
$string['duration_30'] = '30 minutes';
$string['duration_360'] = '6 heures +';
$string['duration_60'] = '1 heure';
$string['duration_help'] = 'La durée attendue';
$string['duration_notspecified'] = 'Non spécifiée';
$string['durationnotspecified'] = '(durée non spécifiée)';
$string['edithomework'] = 'Modifier les devoirs';
$string['edithomeworkitem'] = 'Modifier les devoirs';
$string['edulinkfeatureonly'] = 'Cette fonctionnalité n’est disponible que si vous avez installé <a href="http://www.overnetdata.com/products/edulink-moodle/introduction/"> EduLink for Moodle </a>';
$string['email'] = 'Courriel';
$string['emailerrors'] = '{$a->count} erreur(s), exemple de message d’erreur: {$a->exemple}';
$string['enableavailabilityoff'] = 'Activer l’accès restreint est désactivé dans la configuration Moodle, les devoirs seront définis pour tous les participants au cours';
$string['export'] = 'Exporter';
$string['exportall'] = 'Tout exporter';
$string['exportfiltered'] = 'Exportation flitrée';
$string['failedtoaddachievementfor'] = 'Échec de l’ajout du succès pour';
$string['failedtoaddbehaviourfor'] = 'Échec de l’ajout du comportement pour';
$string['failedtofetchdata'] = 'Impossible de récupérer les données';
$string['failedtosetmarkfor'] = 'Impossible de définir la note pour';
$string['feedback'] = 'Feedback';
$string['files'] = 'Fichiers';
$string['formgroup'] = 'Groupe de formulaires';
$string['from'] = 'De';
$string['grade'] = 'Note';
$string['graded'] = 'Noté';
$string['gradedsubmissions'] = 'Soumissions notées';
$string['gradenotapplicable'] = 'N / A - non participant';
$string['gradingassignmentfor'] = 'Devoir noté pour';
$string['gradingscale_help'] = 'Le type de notation à utiliser pour ce devoir - aucun, sur 100 points ou une échelle de notation spécifiée';
$string['gradingscalelink'] = '<a href="{$a}" target="_blank"> Des échelles de notation peuvent être créées en cliquant ici </a>';
$string['gradingtype'] = 'Échelle de notation';
$string['group'] = 'Groupe';
$string['groupgrades'] = 'Notes de groupe';
$string['groupmembergrades'] = 'Notes des membres du groupe';
$string['groups-none_help'] = 'Si vous avez des groupes sur votre cours, les groupes sélectionnés ici pourront voir l’activité, contrairement aux autres étudiants inscrits (cela peut être utile pour la différenciation)';
$string['groups_help'] = 'Si vous avez des groupes sur votre cours, les groupes sélectionnés ici pourront voir l’activité, contrairement aux autres étudiants inscrits (cela peut être utile pour la différenciation)';
$string['homework:addinstance'] = 'Ajouter un bloc de devoirs';
$string['homework:myaddinstance'] = 'Ajouter un bloc de devoirs à mon Moodle';
$string['homework:viewreports'] = 'Voir les rapports de devoirs';
$string['incompatibleassignment'] = '<div class = "ond_centered"><h2> Impossible de noter un devoir incompatible </h2><p> Ce devoir utilise des fonctionnalités non prises en charge par Devoir: </p><p> {$a->features} </p><p> Cela peut se produire si ce devoir a été créé ou modifié dans Moodle après sa création dans le bloc de devoirs. </p><p class = "ond_centered"> {$a->buttons} </p></div>';
$string['invalidcmid'] = 'ID de module de cours non valide';
$string['invalidcourse'] = 'ID de cours non valide';
$string['invaliddatesupplied'] = 'Date sélectionnée non valide';
$string['invalidgroupsupplied'] = 'Groupe sélectionné non valide';
$string['invalidstudentsupplied'] = 'Étudiant sélectionné non valide';
$string['inxdays'] = '{$a} jours';
$string['issued'] = 'Publié';
$string['learnernotificationerror'] = 'Erreur en essayant d’avertir les apprenants : {$a}';
$string['listview'] = 'Aperçu de la liste';
$string['loadingdata'] = 'Chargement des données…';
$string['lognotifications'] = 'Notifications de journal';
$string['lognotifications_help'] = 'Consigner les courriels de notification et inclure le journal sur l’écran des rapports';
$string['mark'] = 'Note';
$string['markanotherassignment'] = 'Noter un autre devoir';
$string['markanotherassignment_title'] = 'Noter une autre activité de devoir';
$string['markdone'] = 'Notation effectuée';
$string['markeddone'] = 'Notation effectuée';
$string['markhomework'] = 'Noter un devoir';
$string['marking'] = 'Notation';
$string['maxageemployee'] = 'Nombre maximal de jours pour afficher les devoirs en retard pour (employés)';
$string['maxageemployee_help'] = 'Le nombre de jours pendant lesquels les devoirs en retard doivent être répertoriés dans le bloc (vue enseignant / administrateur)';
$string['maxagefuture'] = 'Nombre de jours maximum à venir pour la liste de blocage (tous les utilisateurs)';
$string['maxagefuture_help'] = 'Le nombre de jours à venir qui devraient être inclus dans la liste des affectations de bloc (vue de tous les types d’utilisateurs)';
$string['maxageother'] = 'Nombre de jours maximum pour afficher les devoirs en retard pour (apprenants / parents)';
$string['maxageother_help'] = 'Le nombre de jours pendant lesquels les devoirs en retard doivent être répertoriés dans le bloc (vue apprenant / parent)';
$string['maxageviewall'] = 'Nombre de jours maximum d’affichage des devoirs en vue tout afficher / à noter';
$string['maxageviewall_help'] = 'Le nombre de jours pendant lesquels les devoirs doivent être répertoriés dans les vues tout afficher / à noter';
$string['messageprovider:new_assignment'] = 'Notification de nouveaux devoirs';
$string['messagesendfailed'] = 'L’envoi du message Moodle a échoué';
$string['mustrestrict'] = 'Vous devez limiter le devoir à au moins un groupe ou un utilisateur';
$string['name'] = 'Nom';
$string['name_help'] = 'Le nom sera visible sur les cours, le bloc de devoirs et le carnet de notes Moodle';
$string['newassignmentnotificationmessage'] = 'Nouveau message de notification de devoir';
$string['newassignmentnotificationmessage_help'] = 'Le message à envoyer au créateur du devoir ou à un tiers lorsqu’un nouveau devoir est créé';
$string['newassignmentnotificationmessagedefault'] = 'Le nouveau devoir suivant a été créé: \\n\\n <strong> <a href="[assignment_link["> [assignment_name] </a></strong> dans <strong>[course_name]</strong>';
$string['newassignmentnotificationsubject'] = 'Nouveau sujet de notification de devoir';
$string['newassignmentnotificationsubject_help'] = 'L’objet du message à envoyer au créateur du devoir ou à un tiers lorsqu’un nouveau devoir est créé';
$string['newassignmentnotificationsubjectdefault'] = 'Nouveau devoir créé dans [course_name]';
$string['newhomework'] = 'Nouveau devoir';
$string['noassignmentsfound'] = 'Aucun devoir trouvé';
$string['nocourses'] = 'Vous n’êtes dans aucun cours';
$string['nocoursesasteacher'] = 'Vous n’êtes dans aucun cours en tant que professeur et ne pouvez donc pas définir de devoir';
$string['nogroupmembersfound'] = 'Aucun membre de groupe trouvé';
$string['nogrouprestriction'] = 'Pas de restriction par groupe(s)';
$string['nogroups'] = 'Il n’y a aucun groupe dans vos cours';
$string['nogroupsoncourse'] = 'Aucun groupe dans le cours, les devoirs seront définis pour tous les participants au cours';
$string['nohomework'] = 'Aucun devoir trouvé';
$string['nohomeworkduewithintwoweeks'] = 'Rien à faire dans les deux semaines';
$string['nonotificationsfound'] = 'Aucun notification trouvée';
$string['noonlinesubmissionrequired'] = 'Aucune soumission en ligne requise';
$string['noonlinesubs'] = 'En classe';
$string['nopermission'] = 'Désolé, vous n’avez pas la permission d’accéder à cette page';
$string['nosubjectspecified'] = 'Aucun sujet spécifié ({$a})';
$string['notapplicable'] = 'N/A';
$string['note_to_learners_help'] = 'Corps du courriel de notification - vous pouvez utiliser les champs suivants dans votre texte: [learner_name], [learner_lastname], [learner_firstname], [assignment_name], [assignment_subject], [assignment_due_date], [assignment_duration], [assignment_link]';
$string['note_to_learners_subject_help'] = 'Sujet du courriel de notification - vous pouvez utiliser les champs suivants dans votre texte: [learner_name], [learner_lastname], [learner_firstname], [assignment_name], [assignment_subject], [assignment_due_date], [assignment_duration], [assignment_link]';
$string['note_to_parents_help'] = 'Corps du courriel de notification - vous pouvez utiliser les champs suivants dans votre texte: [parent_title], [parent_lastname], [parent_firstname], [child_name], [child_lastname], [child_firstname], [assignment_name], [assignment_subject], [assignment_due_date], [assignment_duration], [assignment_link]';
$string['note_to_parents_subject_help'] = 'Sujet du courriel de notification - vous pouvez utiliser les champs suivants dans votre texte: [parent_title], [parent_lastname], [parent_firstname], [child_name], [child_lastname], [child_firstname], [assignment_name], [assignment_subject], [assignment_due_date], [assignment_duration], [assignment_link]';
$string['notesforlearners'] = 'Corps du message';
$string['notesforlearnerssubject'] = 'Ligne d’objet';
$string['notesforparents'] = 'Corps du message';
$string['notesforparentssubject'] = 'Ligne d’objet';
$string['notgraded'] = 'Non évalué';
$string['nothingdone'] = 'Rien fait';
$string['nothingdonefull'] = 'Aucune évaluation ajoutée ou modifiée: rien à sauvegarder !';
$string['notificationslog'] = 'Historique des notifications';
$string['notifycreator'] = 'Informer le créateur du devoir des nouveaux devoirs';
$string['notifycreator_help'] = 'Envoyer un message Moodle au créateur du devoir chaque fois qu’il crée un nouveau devoir';
$string['notifylearners'] = 'Avertir les apprenants';
$string['notifylearners_help'] = 'Envoyez un courriel aux apprenants pour les avertir qu’un devoir a été défini';
$string['notifylearnersmessage'] = '<p>Cher [Learner_firstname] </p><p> Le devoir suivant <strong>[assignment_subject] </strong> a été défini pour vous: </p><p><strong>[assignment_name] </strong></p><p> Il est à faire pour le <strong> [assignment_due_date] </strong> et devrait prendre environ <strong>[assignment_duration]</strong>.</p><p>Le devoir peut être consulté ici : <a href="[assignment_link]"> [assignment_name] </a></p>';
$string['notifylearnersmessagesubject'] = 'Vous avez un nouveau devoir';
$string['notifyother'] = 'Informer un tiers';
$string['notifyother_help'] = 'Envoyer un courriel à un tiers chaque fois qu’une nouveau devoir est créé';
$string['notifyotheremail'] = 'Adresse courriel d’un tiers';
$string['notifyotheremail_help'] = 'Entrez ici l’adresse courriel d’un tiers';
$string['notifyparents'] = 'Informer les parents';
$string['notifyparents_help'] = 'Envoyez un courriel aux parents pour les avertir qu’un devoir a été défini';
$string['notifyparentsmessage'] = '<p>Cher [parent_title] [parent_lastname]</p><p>L’élément suivant de devoir <strong>[assignment_subject]</strong> a été défini pour <strong>[child_name]</strong>:</p><p><strong>[assignment_name]</strong></p><p>Il est à faire pour le <strong>[assignment_due_date]</strong> et devrait prendre approximativement <strong>[assignment_duration]</strong>.</p><p>Le devoir peut être consulté ici: <a href="[assignment_link]">[assignment_name]</a></p>';
$string['notifyparentsmessagesubject'] = '[child_firstname] a un nouveau devoir';
$string['notimetable'] = 'Aucune donnée de temps disponible';
$string['notselected'] = '';
$string['notselectedintegratorversionrequired'] = '';
$string['notspecified'] = 'Non spécifié';
$string['notsubmitted'] = 'Non soumis';
$string['nottracked'] = 'Non suivi';
$string['nottrackedfull'] = 'Non suivi (créé en dehors du bloc Devoir)';
$string['nouserrestriction'] = 'Pas de restriction par utilisateur(s)';
$string['nousersoncourse'] = 'Aucun utilisateur dans le cours, les devoirs seront définis pour tous les participants au cours';
$string['off'] = 'Arrêt';
$string['on'] = 'Marche';
$string['onallcourses'] = '(tous les cours)';
$string['oncourse'] = '(cours {$a})';
$string['onehour'] = '1 heure';
$string['onlinefilesubs'] = 'Fichier téléchargé';
$string['onlinetextorfilesubs'] = 'Téléchargement de texte ou de fichier en ligne';
$string['onlinetextsubs'] = 'Texte en ligne';
$string['oops'] = 'Oups…';
$string['pageerror'] = 'Désolé, il y a eu un petit problème: {$a}';
$string['parentalnotificationerror'] = 'Erreur en essayant d’informer les parents: {$a}';
$string['parentview'] = ', Vision des parents';
$string['participants'] = 'Participants';
$string['pleaseselectastudent'] = 'Veuillez sélectionner un étudiant';
$string['pluginname'] = 'Devoir';
$string['plusfiles'] = '(plus soumission de fichier)';
$string['pointsoutof100'] = 'Points (sur 100)';
$string['poweredby'] = 'Développé par Overnet Data';
$string['read'] = 'Lire';
$string['requiredfield'] = 'Champ requis';
$string['requirerestriction'] = 'Requiert une restriction';
$string['requirerestriction_help'] = 'Autoriser la création de devoir uniquement si il est limité à des groupes ou des utilisateurs spécifiques';
$string['restrictions'] = 'Restrictions';
$string['restricttogroups'] = 'Limité aux groupes';
$string['restricttousers'] = 'Limité aux utilisateurs';
$string['returntocourse'] = 'Retour au cours';
$string['returntocourse_title'] = 'Revenir au cours auquel ce devoir faisait partie';
$string['save'] = 'Enregistrer';
$string['saving'] = 'Enregistrement en cours…';
$string['savingachievement'] = 'Enregistrement du devoir…';
$string['savingbehaviour'] = 'Enregistrement du comportement…';
$string['savinggrades'] = 'Enregistrement des notes…';
$string['section'] = 'Section';
$string['section_help'] = 'La section ou le sujet du cours auquel l’activité de devoir sera ajoutée.';
$string['selectcourse'] = 'Sélectionner un cours';
$string['selectcourse_help'] = 'C’est le cours auquel l’activité de devoir sera ajoutée. Seuls les étudiants inscrits à ce cours auront accès à l’activité.';
$string['sendnotifications'] = 'Envoyer les notifications de devoir';
$string['sent'] = 'Envoyé';
$string['setanotherassignment'] = 'Définir un autre devoir';
$string['setanotherassignment_title'] = 'Ajouter une autre activité de devoir';
$string['setby'] = 'Défini par';
$string['sethomework'] = 'Définir un devoir';
$string['showdescription'] = 'Montrer la description dans le cours';
$string['showdescription_help'] = 'Soit indiquer la description de la page du cours';
$string['staffmember'] = 'Membre du personnel';
$string['staffstatistics'] = 'Statistiques du personnel';
$string['staffusage'] = 'Utilisation du personnel';
$string['status'] = 'Statut';
$string['student'] = 'Étudiant';
$string['studentgrades'] = 'Notes de l’étudiant';
$string['studentview'] = ', Vue de l’étudiant';
$string['subject'] = 'Sujet';
$string['subject_help'] = 'Ceci est utilisé dans la section de rapport de ce bloc';
$string['subjectsandstaff'] = 'Sujets et personnel';
$string['submission'] = 'Soumission';
$string['submissions'] = 'Soumissions';
$string['submissions_help'] = 'Comment voulez-vous que ces devoirs soient soumis - en classe ou en ligne sous forme de texte ou de fichier téléchargé';
$string['submissionsdefault'] = 'Par défaut pour les soumissions';
$string['submissionsdefault_help'] = 'Champ par défaut pour les soumissions lors de la création d’un nouveau devoir';
$string['submissionsgraded'] = 'Soumissions notées';
$string['submissionsvsparticipants'] = 'Soumissions';
$string['teacherview'] = ', Vue enseignant';
$string['thereishomeworkdue'] = 'Il y a des devoirs à faire pour ce cours';
$string['thereishomeworkset'] = 'Il y a des devoirs pour ce cours';
$string['thishomeworkisdone'] = 'Ce devoir a été terminé';
$string['thishomeworkisdue'] = 'Ce devoir est à faire';
$string['thishomeworkisset'] = 'Ce devoir est défini';
$string['timetableview'] = 'Affichage des horaires';
$string['to'] = 'De';
$string['today'] = 'aujourd’hui';
$string['tomorrow'] = 'demain';
$string['tryagain'] = 'Essayer encore';
$string['tryagain_title'] = 'Essayer d’ajouter un nouveau devoir';
$string['ungradedsubmissions'] = 'Soumissions non notées';
$string['unsupportedblindmarking'] = 'Noter à l’aveugle';
$string['unsupportedmarkingallocation'] = 'Noter les affectations';
$string['unsupportedmarkingworkflow'] = 'Noter le flux de travail';
$string['unsupportedteamsubmission'] = 'Soumissions d’équipe';
$string['users-none_help'] = 'Si vous avez des utilisateurs dans votre cours, les utilisateurs sélectionnés ici pourront voir l’activité, contrairement aux autres étudiants inscrits (cela peut être utile pour la différenciation)';
$string['users_help'] = 'Si vous avez des utilisateurs dans votre cours, les utilisateurs sélectionnés ici pourront voir l’activité, contrairement aux autres étudiants inscrits (cela peut être utile pour la différenciation)';
$string['userview'] = ', Vue utilisateur';
$string['valuerange'] = 'La valeur doit être comprise dans la fourchette';
$string['versionx'] = 'Version {$a}';
$string['viewhomework'] = 'Voir tous les devoirs';
$string['viewhomeworkitem'] = 'Voir les devoirs';
$string['viewhomeworkreports'] = 'Rapports de devoirs';
$string['viewreports'] = 'Voir les rapports';
$string['xdaysago'] = 'depuis {$a} jours';
$string['xhours'] = '{$a} heures';
$string['xminutes'] = '{$a} minutes';
$string['year'] = 'An';
$string['yesterday'] = 'hier';
