<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_fusion', language 'zh_cn', version '4.2'.
 *
 * @package     theme_fusion
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
	<div class="theme_screenshot">

		<h2>融合</h2>
		<img src="fusion/pix/screenshot.jpg" />

		<h3>主题讨论区：</h3>
		<p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>

		<h3>主题致谢</h3>
		<p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>

		<h3>主题文档：</h3>
		<p><a href="http://docs.moodle.org/en/Themes">http://docs.moodle.org/en/Themes</a></p><h3>报告bug：</h3><p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
	</div>

	<div class="theme_description">

		<h2>关于</h2>
		<p>融合是一个双列、可变宽的Moodle 2.0主题。它支持在每页网站标题上方显示自定义菜单。它还有一个基本的设置页面，可以修改链接颜色，在首页站名上添加标语，和添加底脚文本。</p>

		<h2>父主题</h2>
		<p>本主题基于Moodle核心的基本主题和画布主题构建。如果除了设置里提供的定制功能以外，您还想做其它修改，我们建议您创建一个新主题，并将本主题、基础和画布做为父主题。这样这三个核心主题中任意一个的更新都能反映到您的主题上。</p>

		<h2>致谢</h2>
		<p>本主题最初由Digital Nature (hello@digitalnature.ro)设计，Patrick Malley (patrick@newschoollearning.com)将其移植到Moodle 2.0。
		<h2>授权</h2>
		<p>Moodle核心提供的所有主题，包括此主题的授权协议都是<a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>。
	</div>
</div>';
$string['configtitle'] = '融合设置';
$string['customcss'] = '自定义CSS';
$string['customcssdesc'] = '您在此输入的所有CSS都会被附加到每个页面中，这样您就可以方便地定制此主题。';
$string['footertext'] = '页脚文本';
$string['footertextdesc'] = '设置脚注或页脚文本。';
$string['linkcolor'] = '链接颜色';
$string['linkcolordesc'] = '在此设置此主题的链接颜色。';
$string['pluginname'] = '融合';
$string['region-side-post'] = '右';
$string['region-side-pre'] = '左';
$string['tagline'] = '标语';
$string['taglinedesc'] = '在首页网站名下方显示的一小段标语。<br />';
