<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'webservice', language 'lo', version '4.2'.
 *
 * @package     webservice
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessexception'] = 'ຂໍ້ຍົກເວັ້ນການຄວບຄຸມການເຂົ້າເຖິງ';
$string['actwebserviceshhdr'] = 'ລະບຽບການບໍລິການເວັບທີ່ໃຊ້ງານ';
$string['addaservice'] = 'ເພີ່ມການບໍລິການ';
$string['addcapabilitytousers'] = 'ກວດສອບຄວາມສາມາດຜູ້ໃຊ້';
$string['addcapabilitytousersdescription'] = 'ຜູ້ໃຊ້ຄວນມີຄວາມສາມາດສອງຢ່າງ - webservice:createtoken ແລະ ຄວາມສາມາດທີ່ກົງກັບລະບຽບການທີ່ໃຊ້, ຕົວຢ່າງ webservice/rest:use, webservice/soap:use. ເພື່ອບັນລຸເປົ້າໝາຍນີ້, ສ້າງບົດບາດການບໍລິການເວັບທີ່ມີຄວາມສາມາດທີ່ເໝາະສົມທີ່ອະນຸຍາດ ແລະ ມອບໝາຍໃຫ້ຜູ້ໃຊ້ບໍລິການເວັບເປັນບົດບາດຂອງລະບົບ.';
$string['addexternalservice'] = 'ເພີ່ມການບໍລິການພາຍນອກ';
$string['addfunction'] = 'ເພີ່ມການທຳງານ';
$string['addfunctionhelp'] = 'ເລືອກການທຳງານທີ່ຈະເພີ່ມໃສ່ການບໍລິການ.';
$string['addfunctions'] = 'ເພີ່ມການທຳງານ';
$string['addfunctionsdescription'] = 'ເລືອກການທຳງານທີ່ຕ້ອງການສຳລັບການບໍລິການທີ່ໄດ້ສ້າງໃໝ່.';
$string['addrequiredcapability'] = 'ແຕ່ງຕັ້ງ/ຍົກເລີກການແຕ່ງຕັ້ງຄວາມສາມາດທີ່ຈຳເປັນ';
$string['addservice'] = 'ເພີ່ມການບໍລິການໃໝ່: {$a->name} (id: {$a->id})';
$string['addservicefunction'] = 'ເພີ່ມການທຳງານໄປຫາການບໍລິການ';
$string['allusers'] = 'ຜູ້ໃຊ້ທັງໝົດ';
$string['apiexplorer'] = 'ຕົວຄົ້ນຫາ API';
$string['apiexplorernotavalaible'] = 'ຕົວຄົ້ນຫາ API ບໍ່ມີໃຫ້ເທື່ອ';
$string['arguments'] = 'ອາກິວເມັ້ນ';
$string['authmethod'] = 'ວິທີການກວດສອບຄວາມຖືກຕ້ອງ';
$string['callablefromajax'] = 'ສາມາດໂທຫາໄດ້ຈາກ AJAX';
$string['cannotcreatetoken'] = 'ບໍ່ມີການອະນຸຍາດໃຫ້ສ້າງ ໂທເຄັນ ບໍລິການເວັບສໍາລັບການບໍລິການ {$a}.';
$string['cannotgetcoursecontents'] = 'ບໍ່ສາມາດເອົາເນື້ອຫາລາຍວິຊາໄດ້';
$string['checkusercapability'] = 'ກວດສອບຄວາມສາມາດຂອງຜູ້ໃຊ້';
$string['checkusercapabilitydescription'] = 'ຜູ້ໃຊ້ຄວນຈະມີຄວາມສາມາດທີ່ເໝາະສົມຕາມລະບຽບການທີ່ໃຊ້, ຕົວຢ່າງເຊັ່ນ: webservice/rest:use, webservice/soap:use. ເພື່ອບັນລຸເປົ້າໝາຍນີ້, ສ້າງບົດບາດການບໍລິການເວັບທີ່ມີຄວາມສາມາດຂອງລະບຽບການທີ່ອະນຸຍາດ ແລະ ມອບໝາຍໃຫ້ຜູ້ໃຊ້ບໍລິການເວັບເປັນບົດບາດຂອງລະບົບ.';
$string['configwebserviceplugins'] = 'ສໍາລັບເຫດຜົນດ້ານຄວາມປອດໄພ, ພຽງແຕ່ລະບຽບການທີ່ໃຊ້ຢູ່ຄວນຖືກເປີດໃຊ້.';
$string['context'] = 'ບໍລິບົດ';
$string['createservicedescription'] = 'ການບໍລິການແມ່ນຊຸດຂອງໜ້າທີ່ບໍລິການເວັບ. ທ່ານຈະອະນຸຍາດໃຫ້ຜູ້ໃຊ້ເຂົ້າເຖິງການບໍລິການໃໝ່. ໃນໜ້າ <strong>ເພີ່ມການບໍລິການ</strong> ໃຫ້ກວດເບິ່ງຕົວເລືອກ \'ເປີດໃຊ້ງານ\' ແລະ \'ຜູ້ໃຊ້ທີ່ໄດ້ຮັບອະນຸຍາດ\'. ເລືອກ \'ບໍ່ມີຄວາມສາມາດທີ່ຕ້ອງການ\'.';
$string['createserviceforusersdescription'] = 'ການບໍລິການແມ່ນຊຸດຂອງໜ້າທີ່ບໍລິການເວັບ. ທ່ານຈະອະນຸຍາດໃຫ້ຜູ້ໃຊ້ເຂົ້າເຖິງການບໍລິການໃໝ່. ໃນໜ້າ <strong>ເພີ່ມການບໍລິການ</strong> ໃຫ້ກວດເບິ່ງ \'ເປີດໃຊ້ງານ\' ແລະ ຍົກເລີກການເລືອກ \'ຜູ້ໃຊ້ທີ່ໄດ້ຮັບອະນຸຍາດ\'. ເລືອກ \'ບໍ່ມີຄວາມສາມາດທີ່ຕ້ອງການ\'.';
$string['createtoken'] = 'ສ້າງໂທເຄັນ';
$string['createtokenforuser'] = 'ສ້າງໂທເຄັນສຳລັບຜູ້ໃຊ້';
$string['createtokenforuserdescription'] = 'ສ້າງໂທເຄັນສຳລັບຜູ້ໃຊ້ການບໍລິການເວັບ.';
$string['createuser'] = 'ສ້າງຜູ້ໃຊ້ສະເພາະ';
$string['createuserdescription'] = 'ຜູ້ໃຊ້ບໍລິການເວັບແມ່ນຕ້ອງການເປັນຕົວແທນຂອງລະບົບຄວບຄຸມ Moodle.';
$string['criteriaerror'] = 'ບໍ່ມີສິດອະນຸຍາດໃນການຄົ້ນຫາຕາມເງື່ອນໄຂ.';
$string['default'] = 'ຄ່າເລີ່ມຕົ້ນໄປຫາ "{$a}"';
$string['deleteaservice'] = 'ລຶບການບໍລິການ';
$string['deleteservice'] = 'ລຶບການບໍລິການ: {$a->name} (id: {$a->id})';
$string['deleteserviceconfirm'] = 'ການລຶບການບໍລິການຈະເປັນການລຶບໂທເຄັນທີ່ກ່ຽວຂ້ອງກັບການບໍລິການນີ້ອອກນຳ. ທ່ານຕ້ອງການລຶບການບໍລິການພາຍນອກ "{$a}" ແທ້ໆບໍ?';
$string['deletetoken'] = 'ລຶບໂທເຄັນ';
$string['deletetokenconfirm'] = 'ທ່ານຕ້ອງການລຶບໂທເຄັນການບໍລິການເວັບນີ້ແທ້ໆສໍາລັບ <strong>{$a->ຜູ້ໃຊ້</strong> ໃນການບໍລິການ <strong>{$a->service</strong> ບໍ?';
$string['deprecated'] = 'ເຊົາໃຊ້';
$string['disabledwarning'] = 'ລະບຽບການການບໍລິການເວັບທັງໝົດຖືກປິດໃຊ້ງານ. ການຕັ້ງຄ່າ "ເປີດບໍລິການເວັບ" ສາມາດພົບໄດ້ໃນຄຸນສົມບັດຂັ້ນສູງ.';
$string['doc'] = 'ເອກະສານ';
$string['docaccessrefused'] = 'ທ່ານບໍ່ອະນຸຍາດໃຫ້ເບິ່ງເອກະສານສຳລັບໂທເຄັນນີ້';
$string['downloadfiles'] = 'ສາມາດດາວໂຫຼດໄຟລ໌';
$string['downloadfiles_help'] = 'ຖ້າເປີດໃຊ້, ຜູ້ໃຊ້ສາມາດດາວໂຫຼດໄຟລ໌ດ້ວຍລະຫັດຄວາມປອດໄພຂອງເຂົາເຈົ້າ. ແນ່ນອນພວກເຂົາຖືກຈໍາກັດຢູ່ໃນໄຟລ໌ທີ່ເຂົາເຈົ້າໄດ້ຖືກອະນຸຍາດໃຫ້ດາວໂຫຼດຢູ່ໃນເວັບໄຊທ໌.';
$string['editaservice'] = 'ແກ້ໄຂການບໍລິການ';
$string['editexternalservice'] = 'ແກ້ໄຂການບໍລິການພາຍນອກ';
$string['editservice'] = 'ແກ້ໄຂການບໍລິການ: {$a->name} (id: {$a->id})';
$string['enabled'] = 'ເປີດໃຊ້ງານແລ້ວ';
$string['enabledocumentation'] = 'ເປີດໃຊ້ງານເອກະສານນັກພັດທະນາ';
$string['enabledocumentationdescription'] = 'ເອກະສານການບໍລິການເວັບໄຊທ໌ລະອຽດແມ່ນມີໃຫ້ສໍາລັບລະບຽບການທີ່ເປີດໃຊ້.';
$string['enableprotocols'] = 'ເປີດໃຊ້ງານລະບຽບການ';
$string['enableprotocolsdescription'] = 'ຢ່າງໜ້ອຍໜຶ່ງລະບຽບການຄວນຈະຖືກເປີດໃຊ້. ສໍາລັບເຫດຜົນດ້ານຄວາມປອດໄພ, ພຽງແຕ່ລະບຽບການທີ່ຈະຖືກນໍາໃຊ້ຄວນຈະຖືກເປີດໃຊ້.';
$string['enablews'] = 'ເປີດໃຊ້ງານການບໍລິການເວັບ';
$string['enablewsdescription'] = 'ການບໍລິການເວັບຕ້ອງຖືກເປີດໃຊ້ໃນຄຸນສົມບັດຂັ້ນສູງ.';
$string['entertoken'] = 'ໃສ່ລະຫັດຄວາມປອດໄພ/ໂທເຄັນ:';
$string['error'] = 'ຜິດພາດ: {$a}';
$string['errorcatcontextnotvalid'] = 'ທ່ານບໍ່ສາມາດປະຕິບັດໜ້າທີ່ໃນສະພາບປະເພດປະເພດ (ລະຫັດປະຈຳຕົວປະເພດ:{$a->catid}). ຂໍ້ຄວາມຄວາມຜິດພາດໃນບໍລິບົດແມ່ນ: {$a->message}';
$string['errorcodes'] = 'ຂໍ້ຄວາມຜິດພາດ';
$string['errorcoursecontextnotvalid'] = 'ທ່ານບໍ່ສາມາດປະຕິບັດໜ້າທີ່ໃນບໍລິບົດຂອງລາຍວິຊາ (ລະຫັດປະຈຳຕົວລາຍວິຊາ:{$a->courseid}). ຂໍ້ຄວາມຄວາມຜິດພາດໃນບໍລິບົດແມ່ນ: {$a->message}';
$string['errorinvalidparam'] = 'param "{$a}" ບໍ່ຖືກຕ້ອງ';
$string['errornotemptydefaultparamarray'] = 'ຕົວກຳນົດລາຍລະອຽດການບໍລິການເວັບທີ່ມີຊື່ວ່າ \'{$a}\' ແມ່ນໂຄງສ້າງດຽວ ຫຼື ຫຼາຍອັນ. ຄ່າເລີ່ມຕົ້ນສາມາດເປັນ array ຫວ່າງເປົ່າເທົ່ານັ້ນ. ກວດເບິ່ງລາຍລະອຽດການບໍລິການເວັບ.';
$string['erroroptionalparamarray'] = 'ຕົວກຳນົດລາຍລະອຽດການບໍລິການເວັບທີ່ມີຊື່ວ່າ \'{$a}\' ແມ່ນໂຄງສ້າງດຽວ ຫຼື ຫຼາຍອັນ. ມັນບໍ່ສາມາດຕັ້ງເປັນ VALUE_OPTIONAL ໄດ້. ກວດເບິ່ງລາຍລະອຽດການບໍລິການເວັບ.';
$string['eventwebservicefunctioncalled'] = 'ການທຳງານການບໍລິການເວັບເອີ້ນວ່າ';
$string['eventwebserviceloginfailed'] = 'ການເຂົ້າສູ່ລະບົບການບໍລິການເວັບລົ້ມເຫຼວ';
$string['eventwebserviceservicecreated'] = 'ສ້າງການບໍລິການເວັບແລ້ວ';
$string['eventwebserviceservicedeleted'] = 'ລຶບການບໍລິການເວັບແລ້ວ';
$string['eventwebserviceserviceupdated'] = 'ປັບປຸງການບໍລິການເວັບແລ້ວ';
$string['eventwebserviceserviceuseradded'] = 'ເພີ່ມການບໍລິການເວັບແລ້ວ';
$string['eventwebserviceserviceuserremoved'] = 'ລຶບການບໍລິການເວັບຜູ້ໃຊ້ແລ້ວ';
$string['eventwebservicetokencreated'] = 'ສ້າງການບໍລິການເວັບໂທເຄັນແລ້ວ';
$string['eventwebservicetokensent'] = 'ສົ່ງການບໍລິການເວັບໂທເຄັນແລ້ວ';
$string['execute'] = 'ປະຕິບັດ';
$string['executewarnign'] = 'ຄໍາເຕືອນ: ຖ້າທ່ານກົດປະຕິບັດ ຖານຂໍ້ມູນຂອງທ່ານຈະຖືກດັດແກ້ ແລະ ການປ່ຽນແປງບໍ່ສາມາດຖືກກັບຄືນອັດຕະໂນມັດ!';
$string['externalservice'] = 'ການບໍລິການພາຍນອກ';
$string['externalservicefunctions'] = 'ການທຳງານການບໍລິການພາຍນອກ';
$string['externalservices'] = 'ການບໍລິການພາຍນອກ';
$string['externalserviceusers'] = 'ຜູ້ໃຊ້ການບໍລິການພາຍນອກ';
$string['failedtolog'] = 'ລົ້ມເຫຼວໃນການບັນທຶກ';
$string['filenameexist'] = 'ຊື່ໄຟລ໌ມີຢູ່ແລ້ວ: {$a}';
$string['forbiddenwsuser'] = 'ບໍ່ສາມາດສ້າງໂທເຄັນສໍາລັບຜູ້ໃຊ້ທີ່ບໍ່ໄດ້ຮັບການຢືນຢັນ, ລຶບແລ້ວ, ລະງັບແລ້ວ ຫຼື ຜູ້ໃຊ້ແຂກ.';
$string['function'] = 'ການທຳງານ';
$string['functions'] = 'ການທຳງານ';
$string['generalstructure'] = 'ໂຄງສ້າງທົ່ວໄປ';
$string['information'] = 'ຂໍ້ມູນ';
$string['installexistingserviceshortnameerror'] = 'ການບໍລິການເວັບທີ່ມີຊື່ຫຍໍ້ "{$a}" ມີຢູ່ແລ້ວ. ບໍ່ສາມາດຕິດຕັ້ງ/ປັບປຸງການບໍລິການເວັບອື່ນດ້ວຍຊື່ຫຍໍ້ນີ້ໄດ້.';
$string['installserviceshortnameerror'] = 'ຄວາມຜິດພາດການເຂົ້າລະຫັດ: ຊື່ຫຍໍ້ການບໍລິການ "{$a}" ສາມາດມີຕົວອັກສອນທີ່ເປັນຕົວເລກ (ຕົວອັກສອນ ແລະ ຕົວເລກ), ຂີດກ້ອງ (_), ຂີດຫຍໍ້ (-) ຫຼື ຈ້ຳເມັດ (.)';
$string['invalidextparam'] = 'ຕົວກຳນົດ api ພາຍນອກບໍ່ຖືກຕ້ອງ: {$a}';
$string['invalidextresponse'] = 'ການຕອບກັບ api ພາຍນອກບໍ່ຖືກຕ້ອງ: {$a}';
$string['invalidiptoken'] = 'ໂທເກັນບໍຖືກຕ້ອງ - IP ຂອງທ່ານບໍຮອງຮັບ';
$string['invalidtimedtoken'] = 'ໂທເກັນບໍຖືກຕ້ອງ - ໂທເຄັນໝົດອາຍຸ';
$string['invalidtoken'] = 'ໂທເກັນບໍຖືກຕ້ອງ - ບໍ່ພົບໂທເຄັນ';
$string['iprestriction'] = 'ການຈຳກັດ IP';
$string['iprestriction_help'] = 'ຜູ້ໃຊ້ຈະຕ້ອງໂທຫາບໍລິການເວັບຈາກ IPs ທີ່ລະບຸໄວ້ (ແຍກດ້ວຍເຄື່ອງໝາຍຈຸດ).';
$string['key'] = 'ລະຫັດ';
$string['keyshelp'] = 'ລະຫັດຖືກໃຊ້ເພື່ອເຂົ້າເຖິງບັນຊີ Moodle ຂອງທ່ານຈາກແອັບພລິເຄຊັນພາຍນອກ.';
$string['loginrequired'] = 'ຈຳກັດຫາຜູ້ໃຊ້ທີ່ໄດ້ລົງຊື່ເຂົ້າໃຊ້';
$string['manageprotocols'] = 'ຈັດການລະບຽບການ';
$string['managetokens'] = 'ຈັດການໂທເຄັນ';
$string['missingcaps'] = 'ຄວາມສາມາດຂາດຫາຍໄປ';
$string['missingcaps_help'] = 'ບັນຊີລາຍຊື່ຂອງຄວາມສາມາດປະກາດໂດຍການບໍລິການທີ່ຜູ້ໃຊ້ບໍ່ມີ. ການທຳງານການບໍລິການບາງຢ່າງອາດຈະບໍ່ມີໃຫ້ຖ້າບໍ່ມີຄວາມສາມາດເຫຼົ່ານີ້.';
$string['missingpassword'] = 'ລະຫັດຜ່ານຂາດຫາຍໄປ';
$string['missingrequiredcapability'] = 'ຄວາມສາມາດ {$a} ແມ່ນຈຳເປັນ.';
$string['missingusername'] = 'ຊື່ຜູ້ໃຊ້ຂາດຫາຍໄປ';
$string['missingversionfile'] = 'ການເຂົ້າລະຫັດຜິດພາດ: ໄຟລ໌ version.php ແມ່ນຂາດຫາຍໄປສຳລັບອົງປະກອບ {$a}';
$string['nameexists'] = 'ຊື່ນີ້ຖືກນຳໃຊ້ແລ້ວໂດຍການບໍລິການອັນອື່ນ';
$string['nocapabilitytouseparameter'] = 'ຜູ້ໃຊ້ບໍ່ມີຄວາມສາມາດໃນການໃຊ້ຕົວກຳນົດ {$a}.';
$string['nofunctions'] = 'ການບໍລິການນີ້ບໍ່ມີການທຳງານ';
$string['norequiredcapability'] = 'ບໍ່ຕ້ອງການຄວາມສາມາດ';
$string['notoken'] = 'ລາຍການໂທເກັ້ນແມ່ນເປົ່າຫວ່າງ.';
$string['onesystemcontrolling'] = 'ອະນຸຍາດລະບົບພາຍນອກເພື່ອຄວບຄຸມ Moodle';
$string['onesystemcontrollingdescription'] = 'ຂັ້ນຕອນຕໍ່ໄປນີ້ ຊ່ວຍໃຫ້ທ່ານສາມາດຕັ້ງຄ່າບໍລິການເວັບ Moodle ເພື່ອໃຫ້ລະບົບພາຍນອກສາມາດພົວພັນກັບ Moodle ໄດ້. ນີ້ຮວມເຖິງການຕັ້ງວິທີການພິສູດຢືນຢັນໂຕເຄນ (ລະຫັດຄວາມປອດໄພ).';
$string['onlyseecreatedtokens'] = 'ທ່ານພຽງແຕ່ເບິ່ງໂທເຄັນທີ່ທ່ານໄດ້ສ້າງ.';
$string['operation'] = 'ການດຳເນີນການ';
$string['optional'] = 'ທາງເລືອກ';
$string['passwordisexpired'] = 'ລະຫັດຜ່ານໝົດອາຍຸແລ້ວ.';
$string['phpparam'] = 'XML-RPC (ໂຄງຮ່າງ PHP)';
$string['phpresponse'] = 'XML-RPC (ໂຄງຮ່າງ PHP)';
$string['postrestparam'] = 'ລະຫັດ PHP ສຳລັບ REST (ການຮ້ອງຂໍ POST)';
$string['potusers'] = 'ຜູ້ໃຊ້ທີ່ບໍ່ໄດ້ຮັບອະນຸຍາດ';
$string['potusersmatching'] = 'ຜູ້ໃຊ້ບໍ່ໄດ້ຮັບອະນຸຍາດກົງກັນ';
$string['print'] = 'ພິມທັງໝົດ';
$string['protocol'] = 'ລະບຽບການ';
$string['removefunction'] = 'ຍ້າຍອອກ';
$string['removefunctionconfirm'] = 'ທ່ານຕ້ອງການຍ້າຍການທຳງານ "{$a->function}" ອອກຈາກ "{$a->service}" ແທ້ບໍ?';
$string['requireauthentication'] = 'ວິທີການນີ້ຕ້ອງການການກວດສອບຄວາມຖືກຕ້ອງກັບການອະນຸຍາດ xxx';
$string['required'] = 'ຈຳເປັນ';
$string['requiredcapability'] = 'ຄວາມສາມາດທີ່ຕ້ອງການ';
$string['requiredcapability_help'] = 'ຖ້າຕັ້ງຄ່າ, ຜູ້ໃຊ້ທີ່ມີຄວາມສາມາດທີ່ຕ້ອງການເທົ່ານັ້ນສາມາດເຂົ້າຫາການບໍລິການໄດ້.';
$string['requiredcaps'] = 'ຄວາມສາມາດທີ່ຕ້ອງການ';
$string['resettokencomplete'] = 'ໂທເຄັນທີ່ເລືອກຖືກຕັ້ງຄ່າຄືນໃໝ່';
$string['resettokenconfirm'] = 'ທ່ານຕ້ອງການຕັ້ງຄ່າຄືນໃໝ່ລະຫັດບໍລິການເວັບນີ້ສໍາລັບ <strong>{$a->ຜູ້ໃຊ້</strong> ຢູ່ໃນບໍລິການ <strong>{$a->service</strong> ບໍ?';
$string['resettokenconfirmsimple'] = 'ທ່ານຕ້ອງການຕັ້ງຄ່າຄືນໃໝ່ລະຫັດນີ້ແທ້ບໍ? ລິ້ງທີ່ບັນທຶກໄວ້ທີ່ມີລະຫັດເກົ່າຈະບໍ່ເຮັດວຽກອີກຕໍ່ໄປ.';
$string['response'] = 'ການຕອບກັບ';
$string['restcode'] = 'REST';
$string['restexception'] = 'REST';
$string['restoredaccountresetpassword'] = 'ບັນຊີທີ່ຟື້ນຟູຕ້ອງໄດ້ຕັ້ງລະຫັດຜ່ານໃໝ່ກ່ອນທີ່ຈະໄດ້ຮັບໂທເຄັນ.';
$string['restparam'] = 'REST (ຕົວກຳນົດ POST)';
$string['restrictedusers'] = 'ຜູ້ໃຊ້ທີ່ໄດ້ຮັບອະນຸຍາດເທົ່າ';
$string['restrictedusers_help'] = 'ການຕັ້ງຄ່ານີ້ກໍານົດວ່າ ຜູ້ໃຊ້ທຸກຄົນທີ່ມີການອະນຸຍາດສ້າງໂທເຄັນບໍລິການເວັບສາມາດສ້າງໂທເຄັນ ສໍາລັບການບໍລິການນີ້ຜ່ານໜ້າລະຫັດຄວາມປອດໄພຂອງເຂົາເຈົ້າ ຫຼື ວ່າມີພຽງແຕ່ຜູ້ໃຊ້ທີ່ໄດ້ຮັບອະນຸຍາດເທົ່ານັ້ນສາມາດເຮັດໄດ້.';
$string['securitykey'] = 'ລະຫັດຄວາມປອດໄພ';
$string['securitykeys'] = 'ລະຫັດຄວາມປອດໄພ';
$string['selectauthorisedusers'] = 'ເລືອກຜູ້ໃຊ້ມາຮາາມ';
$string['selectedcapability'] = 'ເລືອກແລ້ວ';
$string['selectedcapabilitydoesntexit'] = 'ຄວາມສາມາດທີ່ກໍານົດໄວ້ໃນປັດຈຸບັນ ({$a}) ບໍ່ມີອີກແລ້ວ. ກະລຸນາປ່ຽນມັນ ແລະບັນທຶກການປ່ຽນແປງ.';
$string['selectservice'] = 'ເລືອກການບໍລິການ';
$string['selectspecificuser'] = 'ເລືອກແຂກສະເພາະ';
$string['selectspecificuserdescription'] = 'ເພີ່ມເວັບການບໍລິການຜູ້ິໃຊ້ເປັນຜູ້ໃຊ້ໄດຮັບ';
$string['service'] = 'ການບໍລິການ';
$string['servicehelpexplanation'] = 'ການບໍລິການແມ່ນຊຸດຂອງໜ້າທີ່. ບໍລິການສາມາດເຂົ້າເຖິງໄດ້ໂດຍຜູ້ໃຊ້ທັງໝົດ ຫຼື ພຽງແຕ່ຜູ້ໃຊ້ທີ່ລະບຸໄວ້.';
$string['servicename'] = 'ຊື່ການບໍລິການ';
$string['servicenotavailable'] = 'ບໍລິການເວັບບໍ່ສາມາດໃຊ້ໄດ້. (ມັນບໍ່ມີຢູ່ ຫຼື ອາດຈະຖືກປິດໃຊ້ງານ.)';
$string['servicerequireslogin'] = 'ບໍລິການເວັບບໍ່ສາມາດໃຊ້ໄດ້. (ຊ່ວງເວລາໄດ້ອອກຈາກລະບົບ ຫຼື ໝົດອາຍຸແລ້ວ.)';
$string['servicesbuiltin'] = 'ການບໍລິການມີພ້ອມໃນເຄື່ອງ';
$string['servicescustom'] = 'ການບໍລິການແບບກຳນົດເອງ';
$string['serviceusers'] = 'ຜູ້ໃຊ້ທີ່ໄດ້ຮັບອະນຸຍາດ';
$string['serviceusersettings'] = 'ການຕັ້ງຄ່າຜູ້ໃຊ້';
$string['serviceusersmatching'] = 'ການຈັບຄູ່ຜູ້ໃຊ້ທີ່ໄດ້ຮັບອະນຸຍາດ';
$string['serviceuserssettings'] = 'ການຕັ້ງຄ່າການປ່ຽນແປງສໍາລັບຜູ້ໃຊ້ທີ່ໄດ້ຮັບອະນຸຍາດ';
$string['shortnametaken'] = 'ຊື່ສັ້ນຖືກໃຊ້ແລ້ວສໍາລັບການບໍລິການອື່ນ ({$a})';
$string['simpleauthlog'] = 'ການເຂົ້າສູ່ລະບົບການກວດສອບຄວາມຖືກຕ້ອງແບບງ່າຍ';
$string['step'] = 'ຂັ້ນຕອນ';
$string['supplyinfo'] = 'ລາຍລະອຽດເພີ່ມຕື່ມ';
$string['testauserwithtestclientdescription'] = 'ຈໍາລອງການເຂົ້າເຖິງພາຍນອກກັບການບໍລິການໂດຍໃຊ້ລູກຄ້າທົດສອບການບໍລິການເວັບ. ກ່ອນທີ່ຈະເຮັດແນວນັ້ນ, ເຂົ້າສູ່ລະບົບເປັນຜູ້ໃຊ້ທີ່ມີຄວາມສາມາດ moodle/webservice:createtoken ແລະ ໄດ້ຮັບລະຫັດຄວາມປອດໄພ (ໂທເຄັນ) ຜ່ານໜ້າຄວາມມັກຂອງຜູ້ໃຊ້. ທ່ານຈະໃຊ້ໂທເຄັນນີ້ໃນລູກຄ້າທົດສອບ. ໃນລູກຄ້າທົດສອບ, ເລືອກລະບຽບການທີ່ເປີດໃຊ້ແລ້ວດ້ວຍການພິສູດຢືນຢັນໂຕເຄນ. <strong>ຄຳເຕືອນ: ຟັງຊັນທີ່ທ່ານທົດສອບຈະຖືກປະຕິບັດສຳລັບຜູ້ໃຊ້ນີ້, ສະນັ້ນ ຈົ່ງລະວັງສິ່ງທີ່ທ່ານເລືອກທົດສອບ!</strong>';
$string['testclient'] = 'ລູກຄ້າທົດສອບການບໍລິການເວັບ';
$string['testclientdescription'] = '* ລູກຄ້າທົດສອບການບໍລິການເວັບ <strong>ປະຕິບັດ</strong> ໜ້າທີ່ສໍາລັບ <strong>ຈິງ</strong>. ຢ່າທົດສອບຟັງຊັນທີ່ທ່ານບໍ່ຮູ້. <br/>* ຟັງຊັນການບໍລິການເວັບທັງໝົດແມ່ນຍັງບໍ່ທັນຖືກປະຕິບັດຢູ່ໃນລູກຄ້າທົດສອບ. <br/>* ເພື່ອກວດເບິ່ງວ່າຜູ້ໃຊ້ບໍ່ສາມາດເຂົ້າເຖິງບາງການທຳງານໄດ້, ທ່ານສາມາດທົດສອບບາງຟັງຊັນທີ່ທ່ານບໍ່ອະນຸຍາດໄດ້.<br/>* ເພື່ອເບິ່ງຂໍ້ຄວາມສະແດງຂໍ້ຜິດພາດທີ່ຊັດເຈນຂຶ້ນຕັ້ງຄ່າການດີບັກເປັນ <strong>{$a- >ໂໝດ</strong> ເຂົ້າໄປໃນ {$a->atag}.';
$string['testwithtestclient'] = 'ທົດສອບການບໍລິການ';
$string['testwithtestclientdescription'] = 'ຈໍາລອງການເຂົ້າເຖິງພາຍນອກກັບການບໍລິການໂດຍໃຊ້ລູກຄ້າທົດສອບການບໍລິການເວັບ. ໃຊ້ໂປຣໂຕຄໍທີ່ເປີດໃຊ້ແລ້ວດ້ວຍການພິສູດຢືນຢັນໂທເຄັນ. <strong>ຄຳເຕືອນ: ຟັງຊັນທີ່ທ່ານທົດສອບຈະຖືກປະຕິບັດ, ສະນັ້ນ ຈົ່ງລະວັງສິ່ງທີ່ທ່ານເລືອກທົດສອບ!</strong>';
$string['token'] = 'ໂທເຄັນ';
$string['tokenauthlog'] = 'ການກວດສອບຄວາມຖືກຕ້ອງຂອງໂທເຄັ້ນ';
$string['tokencreatedbyadmin'] = 'ສາມາດຖືກຕັ້ງຄ່າຄືນໃໝ່ໂດຍຜູ້ຄວບຄຸມລະບົບ (*)';
$string['tokencreator'] = 'ຜູ້ສ້າງ';
$string['tokenfilter'] = 'ໂທເຄັນ';
$string['tokenfilterreset'] = 'ສະແດງໂທເຄັນທັງໝົດ';
$string['tokenfiltersubmit'] = 'ສະແດງໂທເຄັນ';
$string['unknownoptionkey'] = 'ລະຫັດທາງເລືອກບໍ່ຮູ້ຈັກ ({$a})';
$string['unnamedstringparam'] = 'ສະຄຣິງຕົວຊີ້ວັດບໍ່ໄດ້ໃສ່ຊື່.';
$string['updateusersettings'] = 'ປັບປຸງ';
$string['uploadfiles'] = 'ສາມາດອັບໂຫຼດໄຟລ໌ໃໝ່ດ້ານ';
$string['uploadfiles_help'] = 'ຖ້າເປີດໃຊ້ງານ, ຜູ້ໃຊ້ທຸກຄົນສາມາດອັບໂຫຼດໄຟລ໌ ດ້ວຍລະຫັດຄວາມປອດໄພຂອງເຂົາເຈົ້າໃສ່ພື້ນທີ່ໄຟລ໌ສ່ວນຕົວຂອງເຂົາເຈົ້າ ຫຼື ພື້ນທີ່ໄຟລ໌ສະບັບຮ່າງ. ໂຄຕ້າໄຟລ໌ຜູ້ໃຊ້ໃດກໍໄດ້ນຳໃຊ້.';
$string['userasclients'] = 'ຜູ້ໃຊ້ເປັນລູກຄ້າພ້ອມກັບໂທເຄັນ';
$string['userasclientsdescription'] = 'ຂັ້ນຕອນຕໍ່ໄປນີ້ຊ່ວຍໃຫ້ທ່ານສາມາດຕັ້ງຄ່າບໍລິການເວັບ Moodle ສໍາລັບຜູ້ໃຊ້ເປັນລູກຄ້າ. ຂັ້ນຕອນເຫຼົ່ານີ້ ຍັງຊ່ວຍໃນການຕັ້ງຄ່າໂທເຄັນແນະນໍາ (ລະຫັດຄວາມປອດໄພ) ວິທີການກວດສອບຄວາມຖືກຕ້ອງ. ໃນກໍລະນີນີ້, ຜູ້ໃຊ້ຈະສ້າງໂທເຄັນຂອງເຂົາເຈົ້າ ຈາກໜ້າລະຫັດຄວາມປອດໄພຜ່ານໜ້າການຕັ້ງຄ່າຂອງເຂົາເຈົ້າ.';
$string['usermissingcaps'] = 'ຄວາມສາມາດຂາດຫາຍໄປ: {$a}';
$string['usernameorid'] = 'ຊື່ຜູ້ໃຊ້ / ລະຫັດປະຈຳຕົວຜູ້ໃຊ້';
$string['usernameorid_help'] = 'ໃສ່ຊື່ຜູ້ໃຊ້ ຫຼື ລະຫັດປະຈຳຕົວຜູ້ໃຊ້.';
$string['usernameoridnousererror'] = 'ບໍ່ພົບຜູ້ໃຊ້ພ້ອມກັບບັນຊື່ຜູ້ໃຊ້ / ລະຫັດປະຈຳຕົວຜູ້ໃຊ້ນີ້';
$string['usernameoridoccurenceerror'] = 'ພົບເຫັນຜູ້ໃຊ້ຫຼາຍກວ່າໜຶ່ງຄົນທີ່ມີຊື່ຜູ້ໃຊ້ນີ້. ກະລຸນາໃສ່ ID ຜູ້ໃຊ້.';
$string['usernotallowed'] = 'ຜູ້ໃຊ້ບໍ່ໄດ້ຮັບອະນຸຍາດສໍາລັບການບໍລິການນີ້. ທໍາອິດ ທ່ານຈໍາເປັນຕ້ອງອະນຸຍາດໃຫ້ຜູ້ໃຊ້ນີ້ຢູ່ໃນໜ້າບໍລິຫານຜູ້ໃຊ້ທີ່ອະນຸຍາດຂອງ {$a}.';
$string['userservices'] = 'ການບໍລິການຜູ້ໃຊ້: {$a}';
$string['usersettingssaved'] = 'ບັນທຶກການຕັ້ງຄ່າຜູ້ໃຊ້ແລ້ວ';
$string['validuntil'] = 'ໃຊ້ໄດ້ເຖິງ';
$string['validuntil_help'] = 'ຖ້າຕັ້ງໄວ້, ການບໍລິການຈະຖືກປິດໃຊ້ງານຫຼັງຈາກວັນທີນີ້ສໍາລັບຜູ້ໃຊ້ນີ້.';
$string['webservice'] = 'ການບໍລິການເວັບ';
$string['webservices'] = 'ການບໍລິການເວັບ';
$string['webservicesoverview'] = 'ພາບລວມ';
$string['webservicetokens'] = 'ໂທເຄັນການບໍລິການເວັບ';
$string['wrongusernamepassword'] = 'ຊື່ຜູ້ໃຊ້ ແລະ ລະຫັດຜ່ານບໍ່ຖືກຕ້ອງ';
$string['wsaccessuserdeleted'] = 'ປະຕິເສດການເຂົ້າເຖິງການບໍລິການເວັບສໍາລັບຊື່ຜູ້ໃຊ້ທີ່ຖືກລົບ: {$a}';
$string['wsaccessuserexpired'] = 'ປະຕິເສດການເຂົ້າເຖິງການບໍລິການເວັບສໍາລັບຊື່ຜູ້ໃຊ້ທີ່ລະຫັດຜ່ານໝົດອາຍຸ: {$a}';
$string['wsaccessusernologin'] = 'ປະຕິເສດການເຂົ້າເຖິງການບໍລິການເວັບສໍາລັບຊື່ຜູ້ໃຊ້ທີ່ການກວດສອບຄວາມຖືກຕ້ອງບໍ່ໄດ້ເຂົ້າສູ່ລະບົບ: {$a}';
$string['wsaccessusersuspended'] = 'ປະຕິເສດການເຂົ້າເຖິງການບໍລິການເວັບສໍາລັບຊື່ຜູ້ໃຊ້ທີ່ຖືກລະງັບ: {$a}';
$string['wsaccessuserunconfirmed'] = 'ປະຕິເສດການເຂົ້າເຖິງການບໍລິການເວັບສໍາລັບຊື່ຜູ້ໃຊ້ທີ່ບໍ່ໄດ້ຢືນຢັນ: {$a}';
$string['wsclientdoc'] = 'ເອກະສານລູກຄ້າການບໍລິການເວັບ Moodle';
$string['wsdocapi'] = 'ເອກະສານ API';
$string['wsdocumentation'] = 'ເອກະສານບໍລິການເວັບ';
$string['wsdocumentationdisable'] = 'ເອກະສານບໍລິການເວັບຖືກປິດການໃຊ້ງານ.';
$string['wsdocumentationintro'] = 'ເພື່ອສ້າງລູກຄ້າ ພວກເຮົາແນະນຳທ່ານໃຫ້ອ່ານ {$a->doclink}';
$string['wsdocumentationlogin'] = 'ຫຼື ໃສ່ຊື່ຜູ້ໃຊ້ ແລະ ລະຫັດຜ່ານການບໍລິການເວັບຂອງທ່ານ:';
$string['wspassword'] = 'ລະຫັດຜ່ານການບໍລິການເວັບ';
$string['wsusername'] = 'ຊື່ຜູ້ໃຊ້ການບໍລິການເວັບ';
