<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_brickfield', language 'de', version '4.2'.
 *
 * @package     tool_brickfield
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'Barrierefreiheit';
$string['accessibilitydisabled'] = 'Die Brickfield-Tools zur Barrierefreiheit sind für diese Website nicht aktiviert. Wenden Sie sich an den/die Administrator/in der Website, um die Tools zu aktivieren.';
$string['accessibilityreport'] = 'Tools zur Barrierefreiheit';
$string['accessibilitytool'] = 'Brickfield-Tool zur Barrierefreiheit';
$string['accessibilitytools'] = 'Brickfield-Tools zur Barrierefreiheit';
$string['activate'] = 'Aktivieren';
$string['activated'] = 'Das Plugin ist aktiviert und zur Nutzung bereit.';
$string['activationform'] = 'Brickfield-Registrierung';
$string['activationheader'] = 'Brickfield-Aktivierung';
$string['activationinfo'] = '<p>Um dieses Plugin verwenden zu können, müssen Sie in diesem Formular gültige Schlüssel für diese Website angeben. <a href="{$a}" data-action="send_info" target="_blank">Registrieren Sie Ihre Daten (öffnet in neuem Fenster)</a>, um diese Schlüssel zu erhalten, falls Sie noch keine haben.</p>
<p>Nach der Aktivierung werden Ihre Schlüssel über geplante Cron-Tasks validiert.</p>';
$string['activityresults:pluginname'] = 'Bericht zur Barrierefreiheit mit einer Aktivitätsaufschlüsselung';
$string['activityresults:toolname'] = 'Zusammenfassung zur Aktivitätsaufschlüsselung';
$string['activityresults:toolshortname'] = 'Aktivitätsaufschlüsselung';
$string['advanced:pluginname'] = 'Erweiterter Bericht zur Barrierefreiheit';
$string['advanced:toolname'] = 'Erweiterte Zusammenfassung';
$string['advanced:toolshortname'] = 'Erweitert';
$string['allcourses'] = 'Alle geprüften Kurse ({$a})';
$string['allcoursescat'] = 'Alle geprüften Kurse im Kursbereich {$a->catname} ({$a->count})';
$string['analysis:byrequest'] = 'Auf Wunsch';
$string['analysis:disabled'] = 'Deaktiviert';
$string['analysistype'] = 'Analyseanforderungen aktivieren';
$string['analysistype_desc'] = 'Anforderung der Inhaltsanalyse zur Barrierefreiheit erlauben';
$string['analysistypedisabled'] = 'Die Inhaltsanalyse ist deaktiviert.';
$string['bannercontentone'] = 'Das Enterprise-Toolkit zur Barrierefreiheit verfügt über ein vollständiges Set an Funktionen, mit denen Ihre Organisation die Barrierefreiheit der Kurse weiter verbessern kann. <a href="{$a}">Kontaktieren Sie die Brickfield Education Labs</a>, um eine kostenlose Demo der erweiterten Funktionen zu buchen.';
$string['bannercontenttwo'] = 'Erstellen Sie eine Plattform für effektives und integratives Lehren und Lernen. Spüren Sie Inhalte auf, die nicht den Vorgaben für Barrierefreiheit entsprechen. Beheben Sie Probleme und machen Sie Ihre Kursinhalte mit barrierefreien Dateien, Editor und erweiterten Funktionen zukunftssicher.';
$string['bannerheadingone'] = 'Auf das Enterprise-Toolkit zur Barrierefreiheit upgraden';
$string['batch'] = 'Batch-Limit';
$string['brickfield'] = 'Brickfield-Tools';
$string['brickfield:viewcoursetools'] = 'Berichte kursweise anzeigen';
$string['brickfield:viewsystemtools'] = 'Berichte für alle Kurse anzeigen';
$string['bulkprocesscaches'] = 'Bulk-Caching verarbeiten';
$string['bulkprocesscourses'] = 'Barrierefreiheitsprüfung mit Bulk-Caching verarbeiten';
$string['buttonone'] = 'Eine kostenfreie Demo erhalten';
$string['cachepending'] = 'Die Zusammenfassung wird zusammengestellt.';
$string['checkdesc:alinksdontopennewwindow'] = 'Links, die sich in einem neuen Fenster öffnen, sollten im Voraus einen Hinweis zeigen.';
$string['checkdesc:amustcontaintext'] = 'Ein Link muss Text enthalten, um wahrnehmbar zu sein.';
$string['checkdesc:areadontopennewwindow'] = 'Bereiche, die für Imagemaps verwendet werden und Links in einem neuen Fenster öffnen, sollten im Voraus einen Hinweis zeigen.';
$string['checkdesc:areahasaltvalue'] = 'Bereiche, die in Imagemaps verwendet werden, sollten einen alternativen Text \'alt\' bereitstellen, ähnlich wie Bilder.';
$string['checkdesc:asuspiciouslinktext'] = 'Ein Linktext sollte beschreibend sein und einen Kontext zu seinem Ziel enthalten.';
$string['checkdesc:basefontisnotused'] = 'Basefont-Elemente (normalerweise zum Formatieren verwendet) sind nicht barrierefrei und sollten nicht verwendet werden.';
$string['checkdesc:blinkisnotused'] = 'Blink-Elemente, die ein- und ausgeschaltet werden, sind nicht barrierefrei und sollten nicht verwendet werden.';
$string['checkdesc:boldisnotused'] = 'Bold-Elemente \'b\' sollten nicht verwendet werden Besser ist stattdessen \'strong.';
$string['checkdesc:contenttoolong'] = 'Die Gesamtlänge des Seiteninhalts sollte 500 Wörter nicht überschreiten.';
$string['checkdesc:csstexthascontrast'] = 'Der Farbkontrast zwischen Text und Hintergrund ist zu gering.';
$string['checkdesc:embedhasassociatednoembed'] = 'Bei \'embed\'-Elementen (zum Einbetten von Multimedia) sollten die entsprechenden \'noembed\'-Elemente nicht fehlen.';
$string['checkdesc:headerh3'] = 'Überschriften, die nach h3-Überschriften folgen (große Überschriften im Editor), sollten die Hierarchie der Seitenüberschriften nicht durchbrechen.';
$string['checkdesc:headershavetext'] = 'Eine Überschrift \'h3 ... h5\' muss Text enthalten, um wahrnehmbar zu sein.';
$string['checkdesc:iisnotused'] = 'Italic-Elemente \'i\' sollten nicht verwendet werden. Besser ist stattdessen \'em\' (emphasis).';
$string['checkdesc:imgaltisdifferent'] = 'Der alternative Text \'alt\' bei Bildern sollte nicht der Dateiname des Bildes sein.';
$string['checkdesc:imgaltistoolong'] = 'Der alternative Text \'alt\' bei Bildern sollte nicht länger als die maximal erlaubten 125 Zeichen sein.';
$string['checkdesc:imgaltnotemptyinanchor'] = 'Der alternative Text \'alt\' bei Bildern sollte nicht leer sein, vor allem wenn das Bild ein Link nach irgendwo ist.';
$string['checkdesc:imgaltnotplaceholder'] = 'Der alternative Text \'alt\' bei Bildern sollte kein beliebiger Platzhaltertext wie etwa \'Bild\' oder \'image\' sein.';
$string['checkdesc:imghasalt'] = 'Der alternative Text \'alt\' bei Bildern sollte bei Bildelemente immer vorhanden sein, außer die Bilder sind rein dekorativ oder haben keine Bedeutung.';
$string['checkdesc:imgwithmaphasusemap'] = 'Imagemaps mit anklickbaren Bereichen brauchen übereinstimmende \'usemap\'- und \'map\'-Elemente';
$string['checkdesc:legendtextnotempty'] = '\'legend\' -Elemente, die zur Beschriftung von Feldsatzelementen verwendet werden, sollten Text enthalten.';
$string['checkdesc:marqueeisnotused'] = '\'Marquee\'-Elemente (auto-scrolling) sind nicht barrierefrei und sollten nicht verwendet werden.';
$string['checkdesc:noheadings'] = 'Fehlende Überschriften machen Inhalte weniger strukturiert und schwerer lesbar.';
$string['checkdesc:objectmusthaveembed'] = 'Bei \'object\'-Elementen (zum Einbetten externer Ressourcen) sollten die entsprechenden \'embed\' -Elemente nicht fehlen.';
$string['checkdesc:objectmusthavetitle'] = 'Bei \'object\'-Elementen (zum Einbetten externer Ressourcen) sollten die entsprechenden \'title\'-Beschreibungen nicht fehlen.';
$string['checkdesc:objectmusthavevalidtitle'] = '\'object\'-Elemente (zum Einbetten externer Ressourcen) sollten entsprechende \'title\' mit Text haben';
$string['checkdesc:strikeisnotused'] = '\'Strike\'-Elemente  (strike-through) sollten nicht verwendet werden. Besser ist stattdessen \'del\' (deleted).';
$string['checkdesc:tabledatashouldhaveth'] = 'Bei Tabellen sollten idealerweise die Header nicht fehlen.';
$string['checkdesc:tablesummarydoesnotduplicatecaption'] = 'Bei Tabellen sollten \'summaries\' und \'captions\' nicht identisch sein.';
$string['checkdesc:tabletdshouldnotmerge'] = 'Tabellen sollten idealerweise keine verbundenen Zellen haben.';
$string['checkdesc:tablethshouldhavescope'] = 'In Tabellen sollten Zeilen- oder Spalten-\'scopes\' (zum Zuordnen von Zeilen und Spalten zu jeder Zelle) deklariert werden.';
$string['checkidvalidation'] = 'Task zur Prüfung aller ungültigen checkIDs';
$string['checkscompleted'] = 'Prüfungen abgeschlossen: {$a}';
$string['checktype'] = 'Gruppe prüfen';
$string['checktype:form'] = 'Formular';
$string['checktype:image'] = 'Bild';
$string['checktype:layout'] = 'Darstellung';
$string['checktype:link'] = 'Link';
$string['checktype:media'] = 'Medien';
$string['checktype:table'] = 'Tabelle';
$string['checktype:text'] = 'Text';
$string['checktyperesults:pluginname'] = 'Bericht zur Barrierefreiheit der Inhaltstypen';
$string['checktyperesults:toolname'] = 'Zusammenfassung der Inhaltstypen';
$string['checktyperesults:toolshortname'] = 'Inhaltstypen';
$string['cmpercent'] = 'Prozentsatz aller Aktivitäten';
$string['cmpercenterrors'] = 'Prozentsatz aller Fehler';
$string['cmpercenttitle'] = 'Gesamtaufschlüsselung der Aktivitäten im Vergleich zu Fehlern';
$string['confirmationmessage'] = 'Dieser Kurs ist für die Analyse vorgesehen. Die Analyse wird frühestens {$a} abgeschlossen sein. Versuchen Sie es dann noch einmal.';
$string['contactadmin'] = 'Wenden Sie sich bitte an Ihre/n Administrator/in, um die Registrierung abzuschließen.';
$string['contactus'] = 'Kontaktieren Sie uns';
$string['contentfive'] = 'Veraltete HTML-Tags automatisch reparieren.';
$string['contentfour'] = 'Identifizieren Sie, welche Aktivitäten die meisten Probleme bezüglich der Barrierefreiheit aufweisen, um den Aufwand zu priorisieren.';
$string['contentone'] = 'Bewerten Sie die Kursinhalte und mögliche Probleme bezüglich der Barrierefreiheit automatisch.';
$string['contentsix'] = 'Geben Sie den Trainer/innen rechtzeitig Tipps, um bessere Inhalte zu erstellen.';
$string['contentthree'] = 'Stellen Sie Ihren Teilnehmer/innen alle Inhalte in zugänglichen Formaten zur Verfügung, einschließlich Audio, ePub und elektronische Blindenschrift.';
$string['contenttwo'] = 'Bulk-Aktualisierung unklarer oder fehlender Texte für Weblinks, Bildbeschreibungen und Video-Untertitel.';
$string['contenttypeerrors'] = 'Gesamtergebnisse der Aktivitätsinhaltstests pro Kurs und Inhaltstyp.';
$string['contentyperesults'] = 'Gesamtbewertung bestanden / nicht bestanden für Inhaltsbereiche pro Kurs.';
$string['contextid'] = 'Kontext-ID';
$string['core_course'] = 'Kurs';
$string['core_question'] = 'Fragesammlung';
$string['count'] = 'Anzahl';
$string['country'] = 'Land';
$string['country_help'] = 'Land der Website';
$string['coursecount'] = 'Anzahl der Kurse';
$string['deletehistoricaldata'] = 'Alte Prüfergebnisse löschen';
$string['dependency'] = 'Abhängig von';
$string['emptycategory'] = 'Keine Kurse im Kursbereich {$a} gefunden';
$string['emptytagcourses'] = 'Für Kurse mit konfigurierten Tags wurden keine Ergebnisse gefunden.';
$string['enableaccessibilitytools'] = 'Tools zur Barrierefreiheit aktivieren';
$string['enableaccessibilitytools_desc'] = 'Die Tools zur Barrierefreiheit unterstützen Sie, in Ihren Kursen barrierefreie Inhalte bereitzustellen.';
$string['error:nocoursespecified'] = 'Für diesen zusammenfassenden Bericht ist eine gültige Kurs-ID erforderlich. Greifen Sie bitte innerhalb eines Kurses auf die Tools zur Barrierefreiheit zu.';
$string['errorlink'] = 'Fehlerinstanz für {$a} bearbeiten';
$string['errors'] = 'Fehler: {$a}';
$string['errors:pluginname'] = 'Fehlerliste zur Barrierefreiheit';
$string['errors:toolname'] = 'Zusammenfassung der Fehlerliste';
$string['errors:toolshortname'] = 'Fehlerliste';
$string['eventanalysis_requested'] = 'Inhaltsanalyse notwendig';
$string['eventanalysis_requesteddesc'] = 'Für den Kurs {$a} wurde eine Inhaltsanalyse angefordert.';
$string['eventreport_downloaded'] = 'Bericht zur Barrierefreiheit heruntergeladen';
$string['eventreport_downloadeddesc'] = 'Ein Bericht zur Barrierefreiheit wurde für den Kurs {$a} heruntergeladen';
$string['eventreport_viewed'] = 'Bericht zur Barrierefreiheit angezeigt';
$string['eventreport_vieweddesc'] = 'Ein Bericht zur Barrierefreiheit wurde für den Kurs {$a->course} heruntergeladen, Kursbereich  {$a->category}, Tab {$a->tab}.';
$string['failed'] = 'Fehlgeschlagen';
$string['failedcount'] = 'Fehlgeschlagen: {$a}';
$string['footerheading'] = 'Fußbereich';
$string['fullcachedone'] = 'Deaktivieren Sie das erneute Ausführen des Cachings.';
$string['hashcorrect'] = 'Der eingegebene Code ist richtig.';
$string['hashincorrect'] = 'Der eingegebene Code ist nicht richtig.';
$string['headingfive'] = 'HTML-Korrekturen';
$string['headingfour'] = 'Prüfung einstellen';
$string['headingone'] = 'Inhalt auswerten';
$string['headingsix'] = 'Leistungsunterstützung';
$string['headingthree'] = 'Barrierefreie Dateiformate';
$string['headingtwo'] = 'Sanierung';
$string['hideshow'] = 'Anzeigen / verbergen';
$string['icon:analytics-custom'] = 'Analytics-Icon';
$string['icon:file-edit-custom'] = 'Bearbeiten-Icon';
$string['icon:hands-helping-custom'] = 'Hilfe-Icon';
$string['icon:search-plus-custom'] = 'Such-Icon';
$string['icon:tools-custom'] = 'Tools-Icon';
$string['icon:wand-magic-custom'] = 'Zauberstab-Icon';
$string['inactive'] = 'Das Plugin ist inaktiv und kann nicht verwendet werden. Geben Sie bitte gültige Registrierungsschlüssel ein und klicken Sie auf "Aktivieren".';
$string['innercontextid'] = 'Innere Kontext-ID';
$string['installed'] = 'Plugin installiert';
$string['installedcli'] = 'Plugin installiert über die Kommandozeile';
$string['installeddescription'] = 'Das Plugin wurde installiert. Weiterleitung zur Aktivierung.';
$string['invalidaccessibilitytool'] = 'Ungültiges Subplugin für Barrierefreiheit angefordert.';
$string['invalidcategoryid'] = 'Ungültiger Kursbereich. Prüfen Sie Ihre Eingabe.';
$string['invalidcourseid'] = 'Ungültiger Kurs. Prüfen Sie Ihre Eingabe.';
$string['invalidlinkphrases'] = 'click|click here|here|more|more here|info|info here|information|information here|read more|read more here|further information|further information here|further details|further details here|klicken|hier klicken|mehr hier|info|info hier|information|information hier|mehr lesen|hier mehr lesen|weitere Informationen|weitere Informationen hier|weitere Details|weitere Details hier';
$string['language'] = 'Sprache';
$string['language_help'] = 'Sprache der Website';
$string['messageprovider:warningcheckid'] = 'Warnung zu ungültigen checkIDs';
$string['mobileservice'] = 'Mobile Services aktiviert  ({$a})';
$string['module'] = 'Modul';
$string['modulename'] = 'Name';
$string['moreinfo'] = 'Weitere Infos';
$string['noerrorsfound'] = 'Für Ihre Suchparameter wurden keine Probleme zur Barrierefreiheit gefunden. Glückwunsch!';
$string['norecords'] = 'Für Ihre Suchparameter wurden keine relevanten Datensätze gefunden.';
$string['notregistered'] = 'Die Tools zur Barrierefreiheit müssen registriert werden.';
$string['notvalidated'] = 'Die Tools zur Barrierefreiheit sind während der Validierung funktionsfähig.';
$string['numcourses'] = 'Anzahl der Kurse ({$a})';
$string['numfactivities'] = 'Anzahl der Aktivitäten ({$a})';
$string['numfiles'] = 'Anzahl der Dateien ({$a})';
$string['numinstances'] = 'Anzahl der Instanzen';
$string['numusers'] = 'Anzahl der Nutzer/innen ({$a})';
$string['pagedesc:checktype'] = '<p>Um die Ergebnisse der verschiedenen durchgeführten Prüfungen zu analysieren, gruppieren wir diese Prüfungen in verschiedene Inhaltstypen. Daher befinden sich alle Ergebnisse der bildbezogenen Zugänglichkeitsprüfung in der Inhaltstypgruppe "Bild", alle Ergebnisse der layoutbezogenen Zugänglichkeitsprüfung in der Inhaltstypgruppe "Layout" usw.</p><p>Aktivitäten sind enthalten als Aktivitäten, Ressourcen oder Inhaltsbereiche, die sich auf die Kurse selbst beziehen.</p><p>Auf der Seite mit dem Inhaltstypdiagramm wird die Fehleraufschlüsselung nach Inhaltstypen gruppiert: Bild, Layout, Link, Medien, Tabelle und Text.</p>';
$string['pagedesc:pertarget'] = '<p>Um die Prüfergebnisse pro Aktivität zusammenzufassen und zu analysieren, gruppieren wir diese Prüfergebnisse in die verschiedenen erkannten Aktivitäten.</p>
<p>Aktivitäten werden entweder als Aktivitäten, Ressourcen oder andere Inhaltsbereiche bezüglich der Kurse eingeschlossen. Jede Aktivität ohne erkannte Fehler wird als bestanden gezählt, jede Aktivität mit einem oder mehreren erkannten Fehlern wird als fehlgeschlagen gezählt. Das Verhältnis von bestandenen zu fehlgeschlagenen Aktivitäten wird dann angezeigt. </p>
<p>Auf der Seite mit dem Aktivitätsdiagramm wird das Verhältnis von bestandenen zu fehlgeschlagenen Instanzen insgesamt pro Aktivität angezeigt, z.B. Aufgabe, Kurs, Textfeld usw.</p>';
$string['pagedesctitle:checktype'] = 'Inhaltstypen festgelegt';
$string['pagedesctitle:pertarget'] = 'Aktivitätsaufschlüsselung festgelegt';
$string['passed'] = 'Bestanden';
$string['passedcount'] = 'Bestanden: {$a}';
$string['passrate'] = 'Erfolgsquote: {$a}%';
$string['pdf:filename'] = 'Brickfield_Summaryreport_CourseID-{$a}';
$string['percheckerrors'] = 'Anzahl spezifischer Tests und Fehler pro Prüfung pro Kurs';
$string['perpage'] = 'Elemente pro Seite';
$string['pluginname'] = 'Tools zur Barrierefreiheit';
$string['printable:downloadpdf'] = 'PDF herunterladen';
$string['printable:pluginname'] = 'Zusammenfassender Bericht für Tools zur Barrierefreiheit';
$string['printable:printreport'] = 'Druckbarer Bericht';
$string['printable:toolname'] = 'Berichtszusammenfassung';
$string['printable:toolshortname'] = 'Berichtszusammenfassung';
$string['privacy:metadata'] = 'Das Plugin "Tools zur Barrierefreiheit" speichert keine personenbezogenen Daten.';
$string['processanalysisrequests'] = 'Inhaltsanalyseanforderungen verarbeiten';
$string['registernow'] = 'Registrieren Sie bitte jetzt.';
$string['registration'] = 'Registrierungsformular';
$string['registrationinfo'] = '<p>Mit dieser Registrierung können Sie die Startversion der Brickfield Tools zur Barrierefreiheit für Ihre Moodle-Website verwenden.</p> <p>Die Nutzung unterliegt den <a href="{$a}" target="_blank">Allgemeinen Geschäftsbedingungen (öffnet in neuem Fenster)</a>, denen Sie durch die Verwendung dieses Produkts zustimmen.</p>';
$string['release'] = 'Moodle Release ({$a})';
$string['remaining'] = '({$a} verbleibende Fehler)';
$string['response:0'] = 'Diese URL zeigt nach nirgendwo.';
$string['response:404'] = 'Diese URL-Seite wurde nicht gefunden.';
$string['schedule:blocknotscheduled'] = '<p>Dieser Kurs ist noch nicht für die Analyse vorgesehen, um auftretende Probleme mit der Barrierefreiheit zu finden.</p>';
$string['schedule:notscheduled'] = '<p>Dieser Kurs ist noch nicht für die Analyse vorgesehen, um Probleme mit der Barrierefreiheit zu ermitteln.</p>
<p>Durch Klicken auf die Taste "Zur Analyse einreichen" bestätigen Sie, dass Sie alle relevanten HTML-Inhalte des Kurses prüfen lassen möchten, z.B. Beschreibungen von Kursabschnitten oder Aktivitäten, Fragen, Textseiten und mehr.</p>
<p>Die Analyse führt mehrere Prüfungen zur Barrierefreiheit durch, deren Ergebnisse werden dann auf den Berichtsseiten des Tools zur Barrierefreiheit angezeigt. Diese Analyse wird im Hintergrund über die geplanten Tasks verarbeitet, so dass die Fertigstellung von den Task-Zeitplänen und der Task-Ausführungsdauer abhängt.</p>';
$string['schedule:requestanalysis'] = 'Zur Analyse einreichen';
$string['schedule:scheduled'] = 'Dieser Kurs wurde für die Analyse eingeplant.';
$string['schedule:sitenotscheduled'] = '<p>Der globale (kursunabhängige) Inhalt ist noch nicht für die Analyse vorgesehen, um Probleme mit der Barrierefreiheit zu ermitteln.</p>
<p>Durch Klicken auf die Taste "Zur Analyse einreichen" bestätigen Sie, dass Sie alle relevanten globalen (kursunabhängiger) Inhalte vorsehen möchten.</p>
<p>Die Analyse führt mehrere Prüfungen zur Barrierefreiheit durch, deren Ergebnisse werden dann auf den Berichtsseiten des Tools zur Barrierefreiheit angezeigt. Diese Analyse wird im Hintergrund über die geplanten Tasks verarbeitet, so dass die Fertigstellung von den Task-Zeitplänen und der Task-Ausführungsdauer abhängt.</p>';
$string['schedule:sitescheduled'] = 'Der globale (kursunabhängige) Inhalt wurde zur Analyse eingeplant.';
$string['secretkey'] = 'API Key';
$string['secretkey_help'] = 'Dieser Code kann als E-Mail nach der Registrierung empfangen werden.';
$string['sendfollowinginfo'] = '<p>Die folgenden Infos werden regelmäßig gesendet, um zur Gesamtstatistik beizutragen. Sie werden in keiner zentralen Liste veröffentlicht.</p> {$a}';
$string['settings'] = 'Tool-Einstellungen zur Barrierefreiheit';
$string['sitehash'] = 'Secret Key';
$string['sitehash_help'] = 'Dieser Code kann als E-Mail nach der Registrierung empfangen werden.';
$string['taberrors'] = 'Fehler prüfen';
$string['targetavetitle'] = 'Durchschnittliche Fehler pro Aktivität';
$string['targetpercentage'] = 'Prozent der bestandenen / nicht bestandenen Instanzen pro Aktivität';
$string['targetratio'] = 'Aktivitäts-Bestehens-Verhältnis';
$string['tblcheck'] = 'Prüfen';
$string['tblcheckexample'] = 'Beispiel';
$string['tblcheckfailed'] = 'Prüfen fehlgeschlagen';
$string['tblchecksummary'] = 'Zusammenfassung';
$string['tbledit'] = 'Bearbeiten';
$string['tblerrorcount'] = 'Fehler';
$string['tblhtmlcode'] = 'Vorhandener HTML-Code';
$string['tblinstance'] = 'Instanz';
$string['tblline'] = 'Zeile';
$string['tbloverallpercentage'] = 'Gesamtfehler %';
$string['tblpercentage'] = 'Prozent';
$string['tblpreview'] = 'Vorschau';
$string['tbltarget'] = 'Aktivität';
$string['tblupdateto'] = 'Aktualisieren auf';
$string['titleactivityresultsall'] = 'Ergebnisse pro Aktivität: alle überprüften Kurse ({$a->count} Kurse)';
$string['titleactivityresultspartial'] = 'Ergebnisse pro Aktivität: Kurs {$a->name}';
$string['titleall'] = 'Fehlerdetails: Alle überprüften Kurse ({$a->count} Kurse)';
$string['titlechecktyperesultsall'] = 'Ergebnisse pro Inhaltstyp: alle überprüften Kurse ({$a->count} Kurse)';
$string['titlechecktyperesultspartial'] = 'Ergebnisse pro Inhaltstyp: Kurs {$a->name}';
$string['titleerrorsall'] = 'Fehlerdetails: Alle überprüften Kurse ({$a->count} Kurse)';
$string['titleerrorscount'] = 'Fehlerdetails: (zeigt die ersten {$a} Fehler)';
$string['titleerrorspartial'] = 'Fehlerdetails: Kurs {$a->name}';
$string['titlepartial'] = 'Fehlerdetails: Kurs {$a->name}';
$string['titleprintableall'] = 'Kurs {$a->name}';
$string['titleprintablepartial'] = 'Kurs {$a->name}';
$string['tools'] = 'Berichte';
$string['toperrors'] = 'Hauptfehler';
$string['toptargets'] = 'Fehlgeschlagene Aktivitäten';
$string['totalactivities'] = 'Alle Aktivitäten';
$string['totalactivitiescount'] = 'Alle Aktivitäten: {$a}';
$string['totalareas'] = 'Alle Bereiche';
$string['totalerrors'] = 'Alle Fehler';
$string['totalgrouperrors'] = 'Gesamt- (Summen-) Fehler pro Inhaltstyp';
$string['updatesummarydata'] = 'Zusammengefassung für die Website aktualisieren';
$string['usersmobileregistered'] = 'Anzahl von Nutzer/innen mit mobilen Endgeräten ({$a})';
$string['validationerror'] = 'Die Überprüfung des Registrierungsschlüssels ist fehlgeschlagen. Prüfen Sie bitte, dass die registrierte Website und die Schlüssel richtig sind.';
$string['warningcheckidbody'] = 'Es gibt ein Problem mit einer Brickfield-Prüfung, die aktiv aber nicht in der Datenbank aufgeführt ist. Überprüfen Sie das bitte.';
$string['warningcheckidsubject'] = 'Warnung zum Brickfield Tool checkID';
