<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'sk', version '4.2'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Tento test si môžete pozrieť, ale v prípade reálneho spustenia testu by ste boli blokovaní, pretože:';
$string['action'] = 'Akcia';
$string['activityoverview'] = 'Máte jeden alebo viac nových testov (kliknite sem pre ich zobrazenie)';
$string['adaptive'] = 'Adaptívny režim';
$string['adaptive_help'] = 'Ak je zapnuté, je možné odpovedať na otázku viac krát v tom istom pokuse urobiť test. Napríklad v prípade, že odpoveď je označená ako nesprávna, študent bude môcť okamžite skúsiť inú odpoveď. Avšak, v závislosti od nastavenia penalizácií, budú sa odpočítavať penalizačné body za každý chybný pokus.';
$string['add'] = 'Pridať';
$string['addaquestion'] = 'novú otázku';
$string['addarandomquestion'] = 'náhodnú otázku';
$string['addarandomquestion_help'] = 'Ak pridáte náhodnú otázku, vyberie sa z danej kategórie náhodne jedna otázka a vloží sa do testu. To znamená, že rozdielni študenti pravdepodobne dostanú rozdielne otázky. Ak test umožňuje viaceré pokusy, potom v každom z nich dostanú iný výber otázok.';
$string['addarandomselectedquestion'] = 'Pridať náhodnú vybranú otázku';
$string['addasection'] = 'záhlavie novej sekcie';
$string['adddescriptionlabel'] = 'Pridať opis';
$string['addingquestion'] = 'Pridávanie otázky';
$string['addingquestions'] = '<p>V tejto časti stránky si udržiavate databázu vašich otázok. Aby sa otázky lepšie organizované, sú zoskupené v kategóriách. Otázky môžu byť použité v ľubovoľnom teste v kurze, alebo dokonca ak aj v iných kurzov, ak sa rozhodnete ich "publikovať".</p>
Aby bolo otázky možné udržať usporiadané a aby mohli byť použité v ľubovoľnom teste vo Vašom kurze, alebo dokonca aj inými kurzami, ak sa rozhodnete publikovať ich, sú uložené v kategóriách.</p>
<p>Keď vyberiete alebo vytvoríte kategóriu otázok, budete môcť tvoriť alebo meniť otázky. Môžete vybrať ktorúkoľvek z týchto otázok a pridať ju do testu na ostatných častiach tejto stránky.</p>';
$string['addmoreoverallfeedbacks'] = 'Pridať ešte {N} polí so spätnou väzbou';
$string['addnewgroupoverride'] = 'Pridať prestavenie skupiny';
$string['addnewpagesafterselected'] = 'Pridať nové strany po vybraných otázkach';
$string['addnewquestionsqbank'] = 'Pridať otázky do kategórie {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Pridať prestavenie používateľa';
$string['addpagebreak'] = 'Pridať zlom strany';
$string['addpagehere'] = 'Pridať sem stranu';
$string['addquestion'] = 'Pridať otázku';
$string['addquestionfrombankatend'] = 'Pridať z banky otázok na koniec';
$string['addquestionfrombanktopage'] = 'Pridať z banky otázok na stránku {$a}';
$string['addquestions'] = 'Pridať otázky';
$string['addquestionstoquiz'] = 'Pridať otázky do testu';
$string['addrandom'] = 'Pridať {$a} náhodných otázok';
$string['addrandom1'] = '<< Pridať';
$string['addrandom2'] = 'náhodné otázky';
$string['addrandomfromcategory'] = 'Pridať náhodné otázky z kategórie:';
$string['addrandomquestion'] = 'Pridať náhodnú otázku';
$string['addrandomquestionatend'] = 'Pridať náhodnú otázku na koniec';
$string['addrandomquestiontopage'] = 'Pridať náhodnú otázku na stránku {$a}';
$string['addrandomquestiontoquiz'] = 'Pridať náhodnú otázku do testu {$a}';
$string['addselectedquestionstoquiz'] = 'Priať vybrané otázky do testu';
$string['addselectedtoquiz'] = 'Vybrané pridať do testu';
$string['addtoquiz'] = 'Pridať do testu';
$string['affectedstudents'] = 'Ovplyvnený {$a}';
$string['aftereachquestion'] = 'Po pridaní každej otázky';
$string['afternquestions'] = 'Po pridaní {$a} otázok';
$string['age'] = 'vek';
$string['allattempts'] = 'Všetky pokusy';
$string['allinone'] = 'Neobmedzený';
$string['allowreview'] = 'Povoliť prehľad';
$string['alreadysubmitted'] = 'Je pravdepodobné, že už ste sa pokúsili urobiť tento test';
$string['alternativeunits'] = 'Alternatívne jednotky';
$string['alwaysavailable'] = 'Vždy dostupné';
$string['alwayslatest'] = 'Vždy najnovšie';
$string['analysisoptions'] = 'Možnosti analýzy';
$string['analysistitle'] = 'Tabuľka položkovej analýzy';
$string['answer'] = 'Odpoveď';
$string['answered'] = 'Odpovedané';
$string['answerhowmany'] = 'Jedna, alebo viacero odpovedí?';
$string['answers'] = 'Riešenia';
$string['answersingleno'] = 'Povolené viacero odpovedí';
$string['answersingleyes'] = 'Iba jedna odpoveď';
$string['answertoolong'] = 'Odpoveď je veľmi dlhá po riadku {$a} (max. 255 znakov)';
$string['anytags'] = 'Akékoľvek kľúčové slová (tagy)';
$string['aon'] = 'Formát AON';
$string['areyousureremoveselected'] = 'Naozaj chcete vymazať všetky označené otázky?';
$string['asshownoneditscreen'] = 'Ako zobrazené na upravovacej stránke';
$string['attempt'] = 'Pokus {$a}';
$string['attemptalreadyclosed'] = 'Tento pokus už bol ukončený';
$string['attemptclosed'] = 'Pokus ešte nebol ukončený';
$string['attemptduration'] = 'Použitý čas';
$string['attemptedon'] = 'Test sa pokúsil robiť používateľ dňa';
$string['attempterror'] = 'Nemôžete sa teraz pokúsiť vypracovať tento test, pretože: {$a}';
$string['attempterrorcontentchange'] = 'Tento náhľad testu už neexistuje. (Keď sa upraví kvíz, všetky predchádzajúce náhľady sa automaticky odstránia.)';
$string['attempterrorcontentchangeforuser'] = 'Tento pokus o urobenie testu už neexistuje.';
$string['attempterrorinvalid'] = 'Neplatný identifikátor pokusu o urobenie testu';
$string['attemptfirst'] = 'Prvý pokus';
$string['attemptgradeddelay'] = 'Oneskorenie oznámenia o hodnotení pokusu';
$string['attemptgradeddelay_desc'] = 'Pred odoslaním upozornení na pokus o hodnotenie sa použije oneskorenie, aby mal učiteľ čas na úpravu známky.';
$string['attemptincomplete'] = 'Pokus používateľa {$a} nie je ešte ukončený';
$string['attemptlast'] = 'Posledný pokus';
$string['attemptnumber'] = 'Pokus';
$string['attemptquiz'] = 'Pokus testu';
$string['attemptquiznow'] = 'Pokúste sa teraz urobiť  test';
$string['attemptreviewtitle'] = '{$a}: Prehľad pokusu';
$string['attemptreviewtitlepaged'] = '{$a->name}: Prehľad pokusu (strana {$a->currentpage} z {$a->totalpages})';
$string['attempts'] = 'Pokusy';
$string['attempts_help'] = 'Celkový počet povolených pokusov (nie počet pokusov, ktoré sú navyše).';
$string['attemptsallowed'] = 'Povolený počet pokusov';
$string['attemptsdeleted'] = 'Vymazané pokusy';
$string['attemptselection'] = 'Vyberte, ktoré pokusy sa majú analyzovať u používateľa:';
$string['attemptsexist'] = 'Tento test sa už používatelia pokúsili urobiť';
$string['attemptsnum'] = 'Pokusy: {$a}';
$string['attemptsnumthisgroup'] = 'Pokusy: {$a->total} ({$a->group} z tejto skupiny)';
$string['attemptsnumyourgroups'] = 'Pokusy: {$a->total} ({$a->group} z vašich skupín)';
$string['attemptsonly'] = 'Ukázať iba študentov s pokusmi';
$string['attemptstate'] = 'Stav';
$string['attemptstillinprogress'] = 'Pokus stále prebieha';
$string['attemptsummarytitle'] = '$a}: Súhrn pokusu';
$string['attemptsunlimited'] = 'Neobmedzené pokusy';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (strana {$a->currentpage} z {$a->totalpages})';
$string['autosaveperiod'] = 'Oneskorenie automatického ukladania';
$string['autosaveperiod_desc'] = 'Odpovede študentov môžu byť automaticky ukladané počas testu každých pár minút. Na jednej strane ukladanie odpovedí zvyšuje zaťaženie serveru, na druhej strane ale znižuje možnosť toho, že študenti stratia svoju prácu.';
$string['back'] = 'Späť na náhľad otázky';
$string['backtocourse'] = 'Späť do kurzu';
$string['backtoquestionlist'] = 'Späť k zoznamu úloh';
$string['backtoquiz'] = 'Späť na zapisovanie testu';
$string['basicideasofquiz'] = 'Základné myšlienky pre tvorbu testov';
$string['bestgrade'] = 'Najlepšia známka';
$string['bothattempts'] = 'Ukázať všetkých študentov';
$string['browsersecurity'] = 'Bezpečnosť prehliadača';
$string['browsersecurity_help'] = 'Ak je vybraná možnosť " Vyskakovacie okno na celú obrazovku zabezpečené pomocou JavaScriptu",

* Test začne iba vtedy, ak má študent vo webovom prehliadači povolený JavaScript
* Test sa zobrazí v celoobrazovkovom vyskakovacom okne, ktoré sa zobrazí cez všetky ostatné okná a nemá žiadne navigačné ovládacie prvky
* Študenti majú zakázané, pokiaľ je to možné, používať vlastnosti ako je "skopírovať a vložiť"';
$string['cachedef_overrides'] = 'Informácia o prenastavení používateľa a skupiny';
$string['calculated'] = 'Výpočtová';
$string['calculatedquestion'] = 'Výpočtová otázka na riadku {$a} nie je podporovaná. Táto otázka bude ignorovaná.';
$string['cannotcreatepath'] = 'Cestu nie je možné vytvoriť ({$a})';
$string['cannoteditafterattempts'] = 'Nemôžete pridať alebo odobrať otázky, pretože už test už bol niekým vypracovaný. ({$a})';
$string['cannotfindprevattempt'] = 'Nie je možné nájsť predchádzajúc pokus, na ktorom by sa dalo stavať.';
$string['cannotfindquestionregard'] = 'Nepodarilo sa získať otázky pre preznámkovanie!';
$string['cannotinsert'] = 'Nie je možné vložiť otázku';
$string['cannotinsertrandomquestion'] = 'Nebolo možné vložiť novú náhodnú otázku!';
$string['cannotloadquestion'] = 'Nebolo možné nahrať možnosti otázky';
$string['cannotloadtypeinfo'] = 'Nie je možné nahrať špecifické informácie daného typu otázky';
$string['cannotopen'] = 'Nie je možné otvoriť exportovaný súbor ({$a})';
$string['cannotremoveallsectionslots'] = 'Vybrali ste všetky otázky v časti „{$a}“. Nie je dovolené odstrániť všetky otázky pod nadpisom.';
$string['cannotremoveslots'] = 'Nie je možné odstrániť otázky';
$string['cannotrestore'] = 'Nebolo možné obnoviť sedenia otázok';
$string['cannotreviewopen'] = 'Nemôžete si prezerať tento pokus, ešte stále je otvorený';
$string['cannotsavelayout'] = 'Nepodarilo sa uložiť usporiadanie';
$string['cannotsavenumberofquestion'] = 'Nebolo možné uložiť počet otázok na strane';
$string['cannotsavequestion'] = 'Nie je možné uložiť zoznam otázok';
$string['cannotsetgrade'] = 'Nebolo možné nastaviť novú maximálnu známku za test';
$string['cannotsetsumgrades'] = 'Nepodarilo sa nastaviť celkové hodnotenie';
$string['cannotstartgradesmismatch'] = 'V tomto teste sa nedajú zahájiť pokusy. Test je nastavený, aby bol vyhodnotený s hodnotením {$a->grade}, ale žiadna z otázok v teste nemá ohodnotenie. Toto je možné opraviť na stránke \'Editovať test\'.';
$string['cannotstartmissingquestion'] = 'Nie je možné spustiť pokus v teste. Definícia testu obsahuje úlohu, ktorá neexistuje.';
$string['cannotstartnoquestions'] = 'Nie je možné spustiť pokus v teste. Test ešte nebol nastavený a neobsahuje žiadne otázky.';
$string['cannotwrite'] = 'Nie je možné zapisovať do súboru pre export ({$a})';
$string['canredoquestions'] = 'Povoliť novú odpoveď v pokuse';
$string['canredoquestions_desc'] = 'Ak je táto možnosť aktivovaná, potom študenti pri dokončení pokusu konkrétnej otázky uvidia tlačidlo Nová odpoveď. Toto im umožní pokúsiť sa o inú odpoveď na tú istú otázku bez toho, že by museli odoslať celý pokus testu a začať ďalší pokus. Táto možnosť je užitočná hlavne pre praktické testy.

Toto nastavenie ovplyvňuje iba otázky a správanie (napríklad okamžitú spätnú väzbu alebo interaktívne s niekoľkými pokusmi), kde je možné, aby študent dokončil otázku pred odoslaním pokusu.';
$string['canredoquestions_help'] = 'Ak je táto možnosť aktivovaná, potom študenti pri dokončení pokusu konkrétnej otázky uvidia tlačidlo Nová odpoveď. Toto im umožní pokúsiť sa o inú odpoveď na tú istú otázku bez toho, že by museli odoslať celý pokus testu a začať  ďalší pokus. Táto možnosť je užitočná hlavne pre praktické testy.

Toto nastavenie ovplyvňuje iba otázky a správanie (napríklad okamžitú spätnú väzbu alebo interaktívne s niekoľkými pokusmi), kde je možné, aby študent dokončil otázku pred odoslaním pokusu.';
$string['canredoquestionsyes'] = 'Ano, poskytnite možnosť vyskúšať inú otázku';
$string['caseno'] = 'Nie, používanie veľkých a malých písmen nie je dôležité';
$string['casesensitive'] = 'Citlivosť na rozlišovanie veľkých a malých písmen';
$string['caseyes'] = 'Áno, veľké a malé písmená musia sedieť';
$string['categoryadded'] = 'Kategória \'{$a}\' bola pridaná';
$string['categorydeleted'] = 'Kategória \'{$a}\' bola odstránená';
$string['categorynoedit'] = 'Nemáte právo na úpravu kategórie \'{$a}\'';
$string['categoryupdated'] = 'Táto kategória bola úspešne aktualizovaná';
$string['close'] = 'Zavrieť okno';
$string['closebeforeopen'] = 'Aktualizácia testu nebola možná. Zvolili ste dátum ukončenia pred dátumom začatia.';
$string['closed'] = 'Uzavretý';
$string['closepreview'] = 'Zavrieť náhľad';
$string['closereview'] = 'Ukončiť revíziu';
$string['comment'] = 'Komentár';
$string['commentorgrade'] = 'Vložte komentár, alebo prepíšte body';
$string['comments'] = 'Komentáre';
$string['completedon'] = 'Dokončené dňa';
$string['completionattemptsexhausted'] = 'Alebo boli dokončené dostupné pokusy';
$string['completionattemptsexhausted_help'] = 'Hodnotenie testu bolo dokončené, študent vyčerpal maximálny počet pokusov';
$string['completionattemptsexhausteddesc'] = 'Dokončené, ak sú vyčerpané všetky dostupné pokusy';
$string['completiondetail:minattempts'] = 'Vytvoriť pokusy: {$a}';
$string['completiondetail:passgrade'] = 'Získať známku';
$string['completiondetail:passorexhaust'] = 'Získať potrebnú známku alebo dokončiť všetky dostupné pokusy';
$string['completionminattempts'] = 'Minimálny počet pokusov:';
$string['completionminattemptsdesc'] = 'Minimálny požadovaný počet pokusov: {$a}';
$string['completionminattemptserror'] = 'Minimálny počet pokusov musí byť nižší alebo rovný povoleným pokusom.';
$string['completionminattemptsgroup'] = 'Vyžadovať pokusy';
$string['completionpass'] = 'Vyžadovať minimálnu známku';
$string['completionpass_help'] = 'Ak je táto možnosť aktivovaná, táto aktivita sa považuje za splnenú, keď študent dostane hodnotenie potrebné k splneniu (nastavené v časti Známky v nastavení testu) alebo vyššie.';
$string['completionpassdesc'] = 'Študent musí dosiahnuť minimálnu známku pre ukončenie tejto aktivity';
$string['completionpassorattemptsexhausteddesc'] = 'Pre dokončenie tejto aktivity musí študent získať potrebnú známku alebo vyčerpať všetky dostupné pokusy';
$string['configadaptive'] = 'Ak v tejto voľbe zvolíte Áno, potom bude môcť študent odpovedať na jednu otázku počas jedného testu aj viackrát.';
$string['configattemptsallowed'] = 'Obmedzenie na počet pokusov, koľkokrát môžu študenti absolvovať test.';
$string['configdecimaldigits'] = 'Počet desatinných číslic, ktorý má byť zobrazený pri hodnoteniach.';
$string['configdecimalplaces'] = 'Počet desatinných číslic, ktorý má byť zobrazený pri hodnoteniach testu.';
$string['configdecimalplacesquestion'] = 'Počet desatinných číslic, ktorý má byť zobrazený pri hodnoteniach jednotlivých otázok.';
$string['configdelay1'] = 'Ak nastavíte časové oneskorenie, potom bude študent po prvom pokuse musieť čakať tento čas.';
$string['configdelay1st2nd'] = 'Ak nastavíte časové oneskorenie, potom bude študent po ukončení prvého pokusu musieť čakať tento čas do začiatku druhého pokusu.';
$string['configdelay2'] = 'Ak nastavíte časové oneskorenie, potom bude študent pred tretím alebo neskorším pokusom musieť čakať tento čas.';
$string['configdelaylater'] = 'Ak nastavíte časové oneskorenie, potom bude študent nebude môcť spustiť svoj tretí, štvrtý, .. pokus, kým neuplynie tento čas od konca predošlého pokusu.';
$string['configeachattemptbuildsonthelast'] = 'Ak sú povolené viaceré pokusy, potom každý nasledujúci obsahuje výsledky predchádzajúceho pokusu.';
$string['configgrademethod'] = 'Ak sú povolené viaceré pokusy, je treba určiť spôsob, akým sa bude počítať výsledná známka študenta v tomto teste.';
$string['configintro'] = 'Hodnoty, ktoré tu nastavíte, definujú východzie hodnotu, ktoré sú potom používané vo formulári nového testu. Tiež môžete určiť, ktoré nastavenia sú chápané ako pokročilé.';
$string['configmaximumgrade'] = 'Východzia maximálna známka z testu.';
$string['confignavmethod'] = 'Pri "Voľnej navigácii" je možné na otázky odpovedať pomocou navigácie v ľubovoľnom poradí. V "Sekvenčnej navigácii" sa na otázky musí odpovedať v presnom poradí.';
$string['confignewpageevery'] = 'Pri pridávaní úloh do testu sa budú automaticky vkladať konce strán podľa nastavenia, ktoré si vyberiete tu.';
$string['configoutcomesadvanced'] = 'Ak je táto možnosť zapnutá, potom majú Výstupy vo formulári editovania testu pokročilé nastavenia.';
$string['configpenaltyscheme'] = 'Penalizácia odčítaná za každú nesprávnu odpoveď v prípade adaptívneho režimu.';
$string['configpopup'] = 'Vynútiť, aby sa pokus otváral vo vyskakovacom okne a používať nástroje JavaScriptu na obmedzenie použitia "skopírovať a vložiť", hlavne počas pokusov o absolvovanie testu.';
$string['configrequirepassword'] = 'Študenti musia zadať toto heslo predtým, ako sa môžu pokúsiť vykonať test.';
$string['configrequiresubnet'] = 'Študenti môžu vykonať test iba z týchto počítačov.';
$string['configreviewoptions'] = 'Tieto možnosti riadia, aké informácie používatelia vidia pri prezeraní si pokusu testu alebo štatistiky testov.';
$string['configshowblocks'] = 'Zobraziť bloky počas pokusu o test.';
$string['configshowuserpicture'] = 'Zobraziť obrázok používateľa na obrazovke počas pokusov.';
$string['configshufflewithin'] = 'Ak aktivujete túto možnosť, potom časti tvoriace jednotlivé otázky budú náhodne premiešané každý raz, keď študent začne pokus o absolvovanie testu, za predpokladu, že táto možnosť je aktivovaná aj v nastaveniach úloh.';
$string['configtimelimit'] = 'Východzí časový limit pre testy v minútach. 0 znamená bez obmedzenia.';
$string['configtimelimitsec'] = 'Východzí časový limit pre testy v sekundách. 0 znamená bez obmedzenia.';
$string['configurerandomquestion'] = 'Konfigurovať otázku';
$string['confirmclose'] = 'Po ukončení pokusu už nebudete mať možnosť zmeniť svoje odpovede.';
$string['confirmremovequestion'] = 'Naozaj chcete odstrániť túto {$a} otázku?';
$string['confirmremovesectionheading'] = 'Naozaj chcete odstrániť záhlavie sekcie "{$a}"?';
$string['confirmserverdelete'] = 'Naozaj chcete odstrániť server <b>{$a}</b> zo zoznamu?';
$string['connectionerror'] = 'Strata sieťového pripojenia (Automatické ukladanie neúspešné).

Poznamenajte si vaše odpovede na tejto stránke za posledných niekoľko minút a potom sa pokúste o opätovné spojenie.

Len čo sa spojenie obnoví, vaše odpovede budú uložené a táto správa zmizne.';
$string['connectionok'] = 'Pripojenie k sieti bolo obnovené, môžete bezpečne pokračovať.';
$string['containercategorycreated'] = 'Táto kategória bola vytvorená na uchovanie všetkých pôvodných kategórií presunutých do úrovne stránky z dôvodov uvedených dolu.';
$string['continueattemptquiz'] = 'Pokračujte v poslednom pokuse';
$string['continuepreview'] = 'Pokračujte v poslednom náhľade';
$string['copyingfrom'] = 'Vytvára sa kópia otázky \'{$a}\'';
$string['copyingquestion'] = 'Kopíruje sa otázka';
$string['correct'] = 'Správna odpoveď';
$string['correctanswer'] = 'Správna odpoveď';
$string['correctanswerformula'] = 'Vzorec správnej odpovede';
$string['correctansweris'] = 'Správna odpoveď: {$a}';
$string['correctanswerlength'] = 'Platné číslice';
$string['correctanswers'] = 'Správne odpovede';
$string['correctanswershows'] = 'U správnych odpovedí sa zobrazujú';
$string['corrresp'] = 'Správna odpoveď';
$string['countdown'] = 'Odpočítavanie';
$string['countdownfinished'] = 'Test sa uzatvára, teraz môžete zasielať svoje odpovede.';
$string['countdowntenminutes'] = 'Test sa uzavrie o 10 minút.';
$string['coursetestmanager'] = 'Formát Course Test  Manager';
$string['createcategoryandaddrandomquestion'] = 'Vytvoriť kategóriu a pridať náhodnú otázku';
$string['createfirst'] = 'Najprv musíte vytvoriť otázky s krátkou odpoveďou.';
$string['createmultiple'] = 'Vytvoriť viacero náhodných otázok do testu';
$string['createnewquestion'] = 'Vytvoriť novú otázku';
$string['createquestionandadd'] = 'Vytvoriť novú náhodnú otázku a vložiť ju do testu.';
$string['custom'] = 'Používateľský formát';
$string['dataitemneed'] = 'Pre vytvorenie platnej úlohy musíte vložiť najmenej jednu dátovú sadu.';
$string['datasetdefinitions'] = 'Znovu použiteľné definície nastavenia dát pre kategóriu {$a}';
$string['datasetnumber'] = 'Číslo';
$string['daysavailable'] = 'Dostupné dni, počas ktorých je možné urobiť test';
$string['decimaldigits'] = 'Desatinné čísla v známkach';
$string['decimalplaces'] = 'Desatinné miesta v známkach';
$string['decimalplaces_help'] = 'Použitím tohto nastavenia môžete zvoliť počet desatinných miest, ktoré sa zobrazia v bodovom skóre alebo v známkach študentov. Toto nastavenie ovplyvňuje iba zobrazenie známok a nemá vplyv na vnútorné výpočty, ktoré sú vykonávané s plnou presnosťou.';
$string['decimalplacesquestion'] = 'Desatinné miesta v hodnotení otázok';
$string['decimalplacesquestion_help'] = 'Toto nastavenie určuje počet číslic po desatinnej bodke pri zobrazení bodov pre jednotlivé otázky.';
$string['decimalpoints'] = 'Počet desatinných miest';
$string['default'] = 'Východiskové nastavenie';
$string['defaultgrade'] = 'Prednastavená hodnota známky';
$string['defaultinfo'] = 'Nastavená kategória pre otázky.';
$string['delay1'] = 'Časové oneskorenie medzi prvým a druhým pokusom';
$string['delay1st2nd'] = 'Vynútiť časový odstup medzi 1. a 2. pokusom';
$string['delay1st2nd_help'] = 'Ak nastavíte časové oneskorenie, tak študent musí počkať predtým, než sa bude môcť pokúsiť o druhé splnenie testu.';
$string['delay2'] = 'Časové oneskorenie medzi ďalšími pokusmi';
$string['delaylater'] = 'Vynútiť časový odstup medzi ďalšími pokusmi';
$string['delaylater_help'] = 'Ak tu nastavíte časové oneskorenie, tak študent musí počkať
  pred tým, než sa bude môcť pokúsiť o tretie alebo ďalšie
  splnenie testu.';
$string['deleteattemptcheck'] = 'Naozaj chcete úplne vymazať všetky pokusy o urobenie testu?';
$string['deleteselected'] = 'Odstrániť vybraté';
$string['deletingquestionattempts'] = 'Vymazávanie pokusov otázky';
$string['description'] = 'Opis';
$string['disabled'] = 'Nepovolené';
$string['displayoptions'] = 'Nastavenia zobrazenia';
$string['donotuseautosave'] = 'Nepoužívať automatické ukladanie';
$string['download'] = 'Kliknite pre nahratie súboru s exportovanou kategóriou';
$string['downloadextra'] = '(súbory sú tiež uložené v súboroch kurzu v adresári /quiz)';
$string['dragtoafter'] = 'Za {$a}';
$string['dragtostart'] = 'Na začiatok';
$string['duplicateresponse'] = 'Váš odoslaný test na vyhodnotenie bol ignorovaný, pretože ste už predtým zaslali rovnaké odpovede.';
$string['eachattemptbuildsonthelast'] = 'Každý pokus je postavený na minulom';
$string['eachattemptbuildsonthelast_help'] = '<p>Ak je povolené viac pokusov a toto nastavenie je nastavené
na <b>Áno</b>, potom každý nový pokus zahŕňa výsledok predchádzajúceho pokusu. Toto umožňuje, aby bol test dokončený na viacero pokusov.</p>

<p>Ak chcete, aby bol študentovi pri každom pokuse ukázaný test bez odpovedí, zvoľte v nastaveniach <b>Nie</b> pre toto nastavenie.</p>';
$string['editcategories'] = 'Upraviť kategórie';
$string['editcategory'] = 'Upraviť kategóriu';
$string['editcatquestions'] = 'Upraviť kategórie otázok';
$string['editingquestion'] = 'Zapisovanie otázky';
$string['editingquiz'] = 'Zapisovanie testu';
$string['editingquiz_help'] = 'Pri vytváraní testu sú hlavné nasledujúce pojmy:

* Test, obsahujúci úlohy na jednej alebo viacerých stránkach
* Banka úloh, ktorá ukladá kópie všetkých úloh organizované do kategórií
* Náhodne volené úlohy - Študent dostane rôzne úlohy pri každom pokuse o absolvovanie testu a rôzni študenti dostanú odlišné úlohy';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Úprava testu: {$a}';
$string['editmaxmark'] = 'Upraviť maximálnu známku';
$string['editoverride'] = 'Upraviť prestavenie';
$string['editqcats'] = 'Upraviť kategórie úloh';
$string['editquestion'] = 'Upraviť otázku';
$string['editquestions'] = 'Upraviť otázky';
$string['editquiz'] = 'Upraviť test';
$string['editquizquestions'] = 'Upraviť testové úlohy';
$string['emailconfirmautosubmitsmall'] = 'Ďakujeme za odoslanie vašich odpovedí na \'{$a->quizname}\'';
$string['emailconfirmbody'] = 'Dobrý deň {$a->username},

Ďakujeme za odoslanie odpovedí v teste \'{$a->quizname}\'
v kurze \'{$a->coursename}\' dňa {$a->submissiontime}.

Táto správa potvrdzuje, že Vaše odpovede boli zaznamenané v poriadku.

Test je dostupný na stránke {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Dobrý deň, {$a->username},

Čas pre test \'{$a->quizname}\' v kurze \'{$a->coursename}\' vypršal. Vaše odpovede boli odoslané automaticky o {$a->submissiontime}.

Táto správa potvrdzuje, že vaše odpovede boli uložené.

K tomuto testu máte prístup na {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Ďakujeme za odovzdanie odpovedí na test \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Potvrdenie odoslania testu: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Dobrý deň, {$a->studentname},

Vaše odpovede na \'{$a->quizname}\' v kurze \'{$a->coursename}\' na {$a->attempttimefinish} boli teraz ohodnotené.

Svoje skóre a spätnú väzbu si budete môcť pozrieť tak, že navštívite \'{$a->quizurl}\' a skontrolujete svoj pokus.';
$string['emailmanualgradedsubject'] = 'Váš pokus o {$a->quizname} bol ohodnotený';
$string['emailnotifybody'] = 'Dobrý deň {$a->username},

Študent (používateľ) {$a->studentname} odovzdal test \'{$a->quizname}\'  ({$a->quizurl}) v kurze \'{$a->coursename}\'.

Tieto výsledky sú dostupné na stránke {$a->quizreviewurl}.';
$string['emailnotifysmall'] = 'Študent {$a->studentname} ukončil test {$a->quizname}. Viac na {$a->quizreviewurl}';
$string['emailnotifysubject'] = 'Študent {$a->studentname} odovzdal test
{$a->quizname}';
$string['emailoverduebody'] = 'Vážený/vážená {$a->studentname},

začali ste pokus v teste \'{$a->quizname}\' v kurze \'{$a->coursename}\', ale test ste neodoslali.Test má byť odoslaný do {$a->attemptduedate}.

Ak by ste stále chceli odoslať tento pokus, prosím prejdite na {$a->attemptsummaryurl} a kliknite na tlačidlo Odoslať.
Musíte tak urobiť najneskôr do {$a->attemptgraceend}. V opačnom prípade sa Váš pokus už nebude počítať.';
$string['emailoverduesmall'] = 'Neodoslali ste pokus v teste {$a->quizname}. Ak ho chcete odoslať, prejdite na {$a->attemptsummaryurl} pred {$a->attemptgraceend}.';
$string['emailoverduesubject'] = 'Pokus je po časovom limite: {$a->quizname}';
$string['empty'] = 'Prázdny';
$string['enabled'] = 'Povolené';
$string['endtest'] = 'Ukončiť pokus ...';
$string['erroraccessingreport'] = 'Nemôžete sa dostať k tejto správe';
$string['errorinquestion'] = 'Chyba v otázke';
$string['errormissingquestion'] = 'Chyba: V systéme chýba otázka s id {$a}';
$string['errornotnumbers'] = 'Chyba - odpoveď musí byť číselného typu';
$string['errorunexpectedevent'] = 'Neočakávaná udalosť kód {$a->event} nájdená pre otázku {$a->questionid} v pokuse {$a->attemptid}.';
$string['essay'] = 'Esej';
$string['essayquestions'] = 'Zadanie';
$string['eventattemptautosaved'] = 'Pokus testu sa automaticky uloží';
$string['eventattemptdeleted'] = 'Pokus testu bol odstránený';
$string['eventattemptmanualgradingcomplete'] = 'Ručné hodnotenie pokusu testu dokončené';
$string['eventattemptpreviewstarted'] = 'Zahájený náhľad pokusu testu';
$string['eventattemptquestionrestarted'] = 'Otázka testu bola reštartovaná';
$string['eventattemptreviewed'] = 'Prehľad pokusu testu';
$string['eventattemptsummaryviewed'] = 'Zobrazený súhrn pokusov testu';
$string['eventattemptupdated'] = 'Otázka testu bola aktualizovaná';
$string['eventattemptviewed'] = 'Zobrazený pokus testu';
$string['eventeditpageviewed'] = 'Zobrazená stránka úpravy testu';
$string['eventoverridecreated'] = 'Schválené vytvorenie testu';
$string['eventoverridedeleted'] = 'Schválené odstránenie testu';
$string['eventoverrideupdated'] = 'Schválené aktualizovanie testu';
$string['eventpagebreakcreated'] = 'Zlom stránky bol vytvorený';
$string['eventpagebreakdeleted'] = 'Zlom stránky bol odstránený';
$string['eventquestionmanuallygraded'] = 'Manuálne známkované otázky';
$string['eventquizattemptabandoned'] = 'Prerušený pokus';
$string['eventquizattemptregraded'] = 'Pokus testu bol  znova ohodnotený';
$string['eventquizattemptstarted'] = 'Zahájený pokus';
$string['eventquizattemptsubmitted'] = 'Odoslaný pokus testu';
$string['eventquizattempttimelimitexceeded'] = 'Vypršal časový limit pokusu';
$string['eventquizgradeupdated'] = 'Hodnotenie testu bolo aktualizované';
$string['eventquizrepaginated'] = 'Test bol prestránkovaný';
$string['eventreportviewed'] = 'Zobrazená správa o teste';
$string['eventsectionbreakcreated'] = 'Bol vytvorený koniec sekcie';
$string['eventsectionbreakdeleted'] = 'Bol odstránený koniec sekcie';
$string['eventsectionshuffleupdated'] = 'Miešanie poradia sekcií bolo aktualizované';
$string['eventsectiontitleupdated'] = 'Názov sekcie bol aktualizovaný';
$string['eventslotcreated'] = 'Slot bol vytvorený';
$string['eventslotdeleted'] = 'Slot bol odstránený';
$string['eventslotmarkupdated'] = 'Značka slotu bola aktualizovaná';
$string['eventslotmoved'] = 'Slot bol presunutý';
$string['eventslotrequirepreviousupdated'] = 'Slot vyžaduje predchádzajúcu aktualizáciu';
$string['everynquestions'] = 'Každých {$a} otázok';
$string['everyquestion'] = 'Každá otázka';
$string['everythingon'] = 'Všetko';
$string['existingcategory'] = 'Existujúca kategória';
$string['exportcategory'] = 'exportovať kategóriu';
$string['exporterror'] = 'V priebehu exportu sa objavila chyba';
$string['exportingquestions'] = 'Otázky sa exportujú do súboru';
$string['exportname'] = 'Názov súboru';
$string['exportquestions'] = 'Exportovať otázky do súboru';
$string['extraattemptrestrictions'] = 'Extra obmedzenia na pokusy';
$string['false'] = 'Nie';
$string['feedback'] = 'Spätná väzba';
$string['feedbackerrorboundaryformat'] = 'Hranice hodnotenia musia byť alebo percentá alebo čísla. Hodnota, ktorú ste zadali (poloha {$a}) nie je správna.';
$string['feedbackerrorboundaryoutofrange'] = 'Hranice hodnotenia musia byť medzi 0% a 100%. Hodnota, ktorú ste zadali (poloha {$a}) je mimo rozsahu.';
$string['feedbackerrorjunkinboundary'] = 'Musíte zadať hranice hodnotenia tak, aby medzi nimi neboli medzery.';
$string['feedbackerrorjunkinfeedback'] = 'Musíte zadať spätné väzby tak, aby medzi nimi neboli medzery.';
$string['feedbackerrororder'] = 'Hranice hodnotenia musia byť zadávané v klesajúcom poradí. Hodnota, ktorú ste zadali (poloha {$a}) nie je v poradí.';
$string['file'] = 'Súbor';
$string['fileformat'] = 'Formát súboru';
$string['fillcorrect'] = 'Vyplňte správne';
$string['filloutnumericalanswer'] = 'Definujete aspoň jednu možnú odpoveď a toleranciu. Prvá zhodná odpoveď bude použitá na výpočet známky a spätnej väzby. Ak zadáte spätnú väzbu bez odpovede na úplný koniec, táto bude ukázaná v prípade, že študent zadal odpoveď, ktorá sa nezhoduje so zadanými.';
$string['filloutoneanswer'] = 'Musíte vyplniť aspoň jednu možnú odpoveď. Nevyplnené odpovede nebudú použité. Môžete použiť \'*\' ako divoký znak pre zhodu s ľubovoľnými znakmi. Prvá zhodná odpoveď bude použitá na určenie známky a spätnej väzby.';
$string['filloutthreequestions'] = 'Musíte vyplniť aspoň tri otázky. Nevyplnené otázky nebudú použité.';
$string['fillouttwochoices'] = 'Musíte uviesť aspoň dve možnosti. Nevyplnené možnosti nebudú použité.';
$string['finishattemptdots'] = 'Dokončiť pokus';
$string['finishreview'] = 'Ukončiť prehľad';
$string['forceregeneration'] = 'obnova nastavení';
$string['formatnotfound'] = 'Nie je možné nájsť formát pre export/import: {$a}';
$string['formulaerror'] = 'Chyby vo vzorci!';
$string['fractionsaddwrong'] = 'Kladné známky, ktoré ste uviedli nemajú súčet 100%

<br />ale ich súčet je {$a}%

<br />Chcete ísť späť a opraviť túto otázku?';
$string['fractionsnomax'] = 'Jedna z odpovedí musí byť 100%, aby bolo

<br />možné získať plný počet za túto otázku.

<br />Chcete ísť späť a opraviť túto otázku?';
$string['fromfile'] = 'zo súboru:';
$string['functiondisabledbysecuremode'] = 'Táto funkcia je v súčastnosti zablokovaná';
$string['generalfeedback'] = 'Všeobecná spätná väzba';
$string['generalfeedback_help'] = 'Celková spätná väzba je text, ktorý sa zobrazí študentovi po ukončení testu. Oproti spätnej väzbe, ktorá závisí na type otázky a na odpovedi študenta, text celkovej spätnej väzby je zobrazený všetkým študentom.';
$string['gobacktoquiz'] = 'Späť';
$string['graceperiod'] = 'Termín pre odovzdanie';
$string['graceperiod_desc'] = 'Ak je položka Čo robiť, keď vyprší čas, nastavená na možnosť „Existuje doba odkladu ...“, potom je toto predvolená povolená doba navyše.';
$string['graceperiod_help'] = 'Ak je to, čo robiť, keď vyprší čas, nastavené na „Existuje deoba odkladu ...“, potom je tu povolený ďalší čas.';
$string['graceperiodmin'] = 'Posledný termín na odovzdanie';
$string['graceperiodmin_desc'] = 'Na konci testu je potenciálny problém. Na jednej strane chceme, aby študenti pracovali až do poslednej sekundy - pomocou časovača, ktorý test automaticky odošle, keď čas vyprší. Na druhej strane server potom môže byť preťažený a zaberie nejaký čas, kým sa odpovede spracujú. Preto sa budú akceptovať odpovede aj niekoľko sekúnd po vypršaní termínu, takže nie sú penalizovaní za to, že je server pomalý. Avšak študent by mohol podvádzať a získavať takto sekundy na odpovedanie v teste. Musíte urobiť kompromis založený na tom, do akej miery veríte výkonu vášho serveru počas vypĺňania a odosielania testov.';
$string['graceperiodtoosmall'] = 'Časový termín musí byť viac ako {$a}.';
$string['grade'] = 'Známka';
$string['gradeall'] = 'Oznámkovať všetko';
$string['gradeaverage'] = 'Priemerná známka';
$string['gradeboundary'] = 'Hranica hodnotenia';
$string['gradeessays'] = 'Oznámkovať eseje';
$string['gradehighest'] = 'Najvyššia známka';
$string['grademethod'] = 'Metóda známkovania';
$string['grademethod_help'] = 'Ak je povolených viacero pokusov, na výpočet konečného hodnotenia testu sú k dispozícii nasledujúce metódy:

* Najvyššia známka zo všetkých pokusov
* Priemerná (priemer) známka všetkých pokusov
* Prvý pokus (všetky ostatné pokusy sú ignorované)
* Posledný pokus (všetky ostatné pokusy sú ignorované)';
$string['gradesdeleted'] = 'Vymazané hodnotenia testu';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Potrebná známka nemôže byť nulová, keďže kritérium pre uznanie absolvovania testu vyžaduje potrebunú známku. Prosím nastavte nenzulovú hodnotu.';
$string['gradetopassnotset'] = 'Tento test nemá nastavenú minimálnu potrebnú známku. Tá môže byť nastavená známkovej časti nastavenia testu.';
$string['gradetopassoutof'] = 'Požadovaná známka: {$a->grade} z {$a->maxgrade}';
$string['gradingdetails'] = 'Známky za odoslaný test:
{$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'S predošlými trestnými bodmi je výsledok
<strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Za odoslanie odpovede vám bolo pridelených {$a} trestných bodov.';
$string['gradingdetailszeropenalty'] = 'Za odoslaný test Vám nebol pridelený žiaden trestný bod.';
$string['gradingmethod'] = 'Metóda hodnotenia: {$a}';
$string['groupoverrides'] = 'Skupinové prestavenia';
$string['groupoverridesdeleted'] = 'Prestavenia skupiny vymazané';
$string['groupsnone'] = 'Nie sú dostupné žiadne skupiny.';
$string['guestsno'] = 'Prepáčte, hostia  si nemôžu prezerať alebo skúšať testy';
$string['hidebreaks'] = 'Skryť zlomy strany';
$string['hidereordertool'] = 'Skryť nástroj pre zmenu poradia';
$string['history'] = 'História odpovedí:';
$string['howquestionsbehave_desc'] = 'Východzie správanie otázok v teste.';
$string['imagedisplay'] = 'Obrázok  na znázornenie';
$string['import_help'] = 'Táto funkcia vám umožňuje importovať úlohy z externých textových súborov.

Ak váš súbor obsahuje iné ako ASCII znaky, potom musíte použiť kódovanie UTF-8. Buďte zvlášť opatrní pri súboroch generovaných aplikáciami Microsoft Office, pretože tieto zvyčajne používajú špeciálne kódovanie, ktoré nebude spracované správne.

Import a export formátov sú zásuvný zdroj. Iné voliteľné formáty môžu byť dostupné v Databáze modulov a doplnkov.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'importovať kategóriu';
$string['importerror'] = 'V priebehu importu sa objavila chyba';
$string['importfilearea'] = 'Importovať zo súboru v kurze';
$string['importfileupload'] = 'Importovať zo súboru na vašom počítači';
$string['importfromthisfile'] = 'Importovať z tohto súboru';
$string['importingquestions'] = 'Importujem {$a} úloh zo súboru';
$string['importmax10error'] = 'Chybná definícia úlohy: úloha nesmie obsahovať viac ako desať odpovedí.';
$string['importmaxerror'] = 'Chybná definícia úlohy: príliš mnoho odpovedí.';
$string['importquestions'] = 'Import otázok zo súboru';
$string['inactiveoverridehelp'] = '* Toto prepísanie nie je aktívne, pretože prístup používateľa k aktivite je obmedzený. Dôvodom môže byť priradenie skupín alebo rolí, iné obmedzenia prístupu alebo skrytá aktivita.';
$string['incorrect'] = 'Nesprávna odpoveď';
$string['indicator:cognitivedepth'] = 'Kognitívny Test';
$string['indicator:cognitivedepth_help'] = 'Tento indikátor je založený na kognitívnej hĺbke, ktorú dosiahol študentka v aktivite Test.';
$string['indicator:cognitivedepthdef'] = 'Kognitívny test';
$string['indicator:cognitivedepthdef_help'] = 'Účastník dosiahol toto percento kognitívnej angažovanosti ponúkanej aktivitami Test počas tohto intervalu analýzy (Úrovne = Žiadne zobrazenie, Zobraziť, Odoslať, Zobraziť spätnú väzbu, Komentár k spätnej väzbe, Znovu odoslať po zhliadnutí spätnej väzby)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sociálny test';
$string['indicator:socialbreadth_help'] = 'Tento ukazovateľ je založený na spoločenskej šírke dosiahnutej študentom v testovej aktivite.';
$string['indicator:socialbreadthdef'] = 'Sociálny test';
$string['indicator:socialbreadthdef_help'] = 'Počas tohto intervalu analýzy dosiahol účastník percentuálny podiel sociálnej angažovanosti ponúkanej aktivitami v teste (úrovne = žiadna účasť, účastník sám, účastník s ostatnými).';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Odpovede používateľov na každú otázku';
$string['info'] = 'Informácia';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Počiatočný počet celkových polí spätnej väzby';
$string['initialnumfeedbacks_desc'] = 'Pri vytváraní nového testu poskytnite niekoľko prázdnych políčok na spätnú väzbu. Akonáhle bol test vytvorený, formulár zobrazuje počet polí požadovaných pre počet spätných väzieb v teste. Nastavenie musí byť aspoň 1.';
$string['inprogress'] = 'Prebieha';
$string['introduction'] = 'Opis';
$string['invalidattemptid'] = 'Pokus s týmto ID neexistuje';
$string['invalidcategory'] = 'ID kategórie je nesprávne';
$string['invalidoverrideid'] = 'Neplatný identifikátor prestavenia';
$string['invalidquestionid'] = 'Nesprávny identifikátor otázky';
$string['invalidquizid'] = 'Nesprávny identifikátor testu';
$string['invalidrandomslot'] = 'Neplatné číslo slotu pre náhodnú otázku.';
$string['invalidsource'] = 'Tento zdroj nie je akceptovaný ako platný.';
$string['invalidsourcetype'] = 'Neplatný typ zdroja.';
$string['invalidstateid'] = 'Neplatné ID stavu';
$string['lastanswer'] = 'Vaša posledná odpoveď bola';
$string['layout'] = 'Usporiadanie';
$string['layoutasshown'] = 'Usporiadanie na strane ako zobrazené.';
$string['layoutasshownwithpages'] = 'Usporiadanie na strane ako zobrazené.<small>(Automatická nová strana každých {$a} otázok.)</small>';
$string['layoutshuffledandpaged'] = 'Náhodne zamiešané otázky, počet otázok na jednej strane: {$a}.';
$string['layoutshuffledsinglepage'] = 'Náhodne zamiešané otázky, všetky na jednej strane.';
$string['legacyquizaccessrulescron'] = 'Pravidlá prístupu ku testov od starého cron procesu';
$string['legacyquizreportscron'] = 'Správy testu v podaní starého cron procesu';
$string['link'] = 'Odkaz';
$string['listitems'] = 'Zoznam položiek testu';
$string['literal'] = 'Písmeno';
$string['loadingquestionsfailed'] = 'Nepodarilo sa nahrať otázky: {$a}';
$string['makecopy'] = 'Ulož ako novú otázku';
$string['managetypes'] = 'Spravovať typy otázok a serverov';
$string['manualgradequestion'] = 'Ručne známkované úlohy {$a->question} v {$a->quiz} používateľom {$a->user}';
$string['manualgrading'] = 'Známkovanie';
$string['mark'] = 'Odoslať';
$string['markall'] = 'Odoslať stránku';
$string['marks'] = 'Známky';
$string['marks_help'] = 'Známka za každú otázku a celkové skóre pokusu.';
$string['match'] = 'Zodpovedajúca';
$string['matchanswer'] = 'Zodpovedajúca odpoveď';
$string['matchanswerno'] = 'Zodpovedajúca odpoveď {$a}';
$string['max'] = 'Maximálny';
$string['maxmark'] = 'Najvyššia známka';
$string['messageprovider:attempt_grading_complete'] = 'Oznámenie, že váš pokus bol ohodnotený';
$string['messageprovider:attempt_overdue'] = 'Upozornenie na časový termín pre odovzdanie testu';
$string['messageprovider:confirmation'] = 'Potvrdenie odoslania testu';
$string['messageprovider:submission'] = 'Oznámenie o vypracovaní testu vašich študentov';
$string['min'] = 'Minimálny';
$string['minutes'] = 'Minúty';
$string['missingcorrectanswer'] = 'Musíte označiť  správnu odpoveď';
$string['missingitemtypename'] = 'Chýba názov';
$string['missingquestion'] = 'Zdá sa, že táto otázka už neexistuje';
$string['modulename'] = 'Test';
$string['modulename_help'] = 'Modul Test umožňuje lektorovi vytvárať testy obsahujúce úlohy rôznych typov, vrátane úloh s voľbou viacnásobnej odpovede, porovnávacích úloh, úloh s tvorenou krátkou odpoveďou a číselných úloh.

Lektor môže povoliť viacnásobné pokusy o absolvovanie testu, s úlohami premiešanými alebo náhodne vybranými z Banky úloh. Je možné nastaviť časový limit.

Každý pokus sa hodnotí automaticky, s výnimkou úloh typu Esej (s tvorenou dlhou odpoveďou) a hodnotenie sa zaznamenáva do klasifikačného výkazu.

Lektor môže vybrať, kedy a či sa študentom zobrazia tipy, spätná väzby a správne odpovede.

Testy môžu byť použité

* ako testy v kurze
* ako minitesty pri samoštúdiu alebo na konci preberanej témy
* ako súborná skúška s využitím úloh z minulých skúšok
* na dodanie okamžitej spätnej väzby o výkone používateľa
* na sebahodnotenie používateľa';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Testy';
$string['moveselectedonpage'] = 'Presunúť vybrané otázky na stranu: {$a}';
$string['multichoice'] = 'Viaceré možnosti';
$string['multipleanswers'] = 'Vyberte aspoň jednu odpoveď.';
$string['mustbesubmittedby'] = 'Tento pokus musí byť odoslaný najneskôr: {$a}.';
$string['name'] = 'Meno';
$string['navigatenext'] = 'Ďalšia strana';
$string['navigateprevious'] = 'Predchádzajúca strana';
$string['navmethod'] = 'Spôsob navigácie';
$string['navmethod_free'] = 'Voľná';
$string['navmethod_help'] = 'Ak je aktivovaná sekvenčná navigácia, študent musí postupovať testom v určenom poradí a nesmie sa vrátiť na predchádzajúce stránky, ani preskakovať úlohy.';
$string['navmethod_seq'] = 'Sekvenčná';
$string['navnojswarning'] = 'Upozornenie: tieto odkazy neuložia Vaše odpovede. Použite tlačidlo Ďalší na spodku strany.';
$string['neverallononepage'] = 'Nikdy, všetky otázky na jednej strane';
$string['newattemptfail'] = 'Chyba: Nebolo možné začať nový pokus v tomto teste';
$string['newcategory'] = 'Nová kategória';
$string['newpage'] = 'Nová strana';
$string['newpage_help'] = 'V prípade dlhšieho testu je lepšie ho rozložiť na viacej stránok, tak že sa obmedzí počet otázok na stránku. Ak pridávate otázky do testu, rozdelenie stránky bude automaticky vložené podľa nastavenia stránky. Tieto rozdelenia stránky je možné neskôr posúvať ručne a to
na stránke pre úpravu textu.';
$string['newpageevery'] = 'Automaticky začať novú stranu';
$string['newsectionheading'] = 'Nový nadpis';
$string['noanswers'] = 'Neboli vybraté žiadne odpovede!';
$string['noattempts'] = 'Nikto sa nepokúsil urobiť tento test';
$string['noattemptsfound'] = 'Neboli nájdené žiadne pokusy';
$string['noattemptstoshow'] = 'Nie sú žiadne pokusy na zobrazenie';
$string['nocategory'] = 'Nebola určená kategória, alebo bola určená nesprávne.';
$string['noclose'] = 'Neexistuje dátum uzavretia';
$string['nocommentsyet'] = 'Zatiaľ bez komentára';
$string['noconnection'] = 'Momentálne nie je k dispozícii žiadne pripojenie k službe na webe, ktoré by dokázalo spracovať a vyhodnotiť túto otázku. Prosím, kontaktujte svojho administrátora.';
$string['nodataset'] = 'nič - nie je to divoká karta';
$string['nodatasubmitted'] = 'Neboli vložené žiadne údaje.';
$string['noessayquestionsfound'] = 'Neboli nájdené žiadne ručne známkované otázky.';
$string['nogradewarning'] = 'Tento test nie je hodnotený, takže nie je možné nastaviť celkovú spätnú väzbu, ktorá sa líši hodnotením.';
$string['nomoreattempts'] = 'Nie je povolené viac pokusov';
$string['none'] = 'Žiadne';
$string['noopen'] = 'Neexistuje dátum otvorenia';
$string['nooverridedata'] = 'Musíte prestaviť aspoň jedno z nastavení testu.';
$string['nopossibledatasets'] = 'Nie je možné nastavovať dáta';
$string['noquestionintext'] = 'Otázka v teste neobsahuje žiadne možnosti výberu odpovedí';
$string['noquestions'] = 'Zatiaľ neboli pridané žiadne otázky';
$string['noquestionsfound'] = 'Žiadna odpoveď';
$string['noquestionsinquiz'] = 'V tomto teste nie sú žiadne otázky.';
$string['noquestionsnotinuse'] = 'Táto náhodná otázka sa nepoužije, pretože jej kategória je prázdna.';
$string['noquestionsonpage'] = 'Prázdna strana';
$string['noresponse'] = 'Žiadna odpoveď';
$string['noreview'] = 'Nemáte oprávnenie prehliadať tento test';
$string['noreviewattempt'] = 'Tento pokus nemáte povolenie skontrolovať.';
$string['noreviewshort'] = 'Nemáte oprávnenie';
$string['noreviewuntil'] = 'Nemáte oprávnenie prehliadať tento test do {$a}';
$string['noreviewuntilshort'] = 'Dostupné {$a}';
$string['noscript'] = 'Musíte mať nainštalovanú podporu JavaScriptu, aby ste mohli pokračovať ďalej!';
$string['notavailabletostudents'] = 'Poznámka: Tento test nie je momentálne prístupný pre študentov.';
$string['notenoughrandomquestions'] = 'V tejto kategórii {$a->category} nie je dosť úloh na vytvorenie úlohy {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Nebolo definovaných dosť podotázok (možností).<br />
Chcete sa vrátiť a opraviť túto otázku?';
$string['notifyattemptsgradedtask'] = 'Odoslať oznámenie o hodnotení pokusov testu';
$string['notimedependentitems'] = 'Položky, ktoré sú časovo obmedzené, nie sú podporované v tomto testovom module. Môžete si nastaviť časový limit pre celý kurz. Chcete si vybrať inú položku (alebo chcete pracovať s touto položkou)?';
$string['notyetgraded'] = 'Zatiaľ nie je ohodnotené';
$string['notyetviewed'] = 'Doteraz neprezrené';
$string['notyourattempt'] = 'Toto nie je Váš pokus!';
$string['noview'] = 'Prihlásený používateľ nemôže prezerať tento test';
$string['numattempts'] = '{$a->studentstring}: {$a->studentnum}, pokusov: {$a->attemptnum}';
$string['numberabbr'] = '#';
$string['numerical'] = 'Rozsahová';
$string['numquestionsx'] = 'Otázky: {$a}';
$string['oneminute'] = '1 minúta';
$string['onlyteachersexport'] = 'Iba učitelia môžu exportovať úlohy.';
$string['onlyteachersimport'] = 'Iba učitelia s právom upravovať obsah kurzu môžu importovať úlohy.';
$string['onthispage'] = 'Táto stránka';
$string['open'] = 'Nezodpovedané';
$string['openafterclose'] = 'Nemôžem aktualizovať test. Nastavili ste dátum otvorenia testu po dátume jeho uzavretia.';
$string['openclosedatesupdated'] = 'Dátumy otvorenia a uzatvorenia testu sú aktualizované';
$string['optional'] = 'voliteľný';
$string['orderandpaging'] = 'Poradie a stránkovanie';
$string['orderandpaging_help'] = 'Čísla 10, 20, 30, ... pri každej úlohe označujú poradie úloh. Prírastok čísel v krokoch po 10 necháva priestor na vloženie prípadných ďalších úloh.  Pre zmenu poradia úloh zmeňte čísla a potom kliknite na tlačidlo "Zmeniť poradie úloh".

Na pridanie konca stránky po konkrétnej úlohe, zaškrtnite políčko vedľa úlohy, potom kliknite na tlačidlo "Po zvolených úlohách pridať novú stránku".

Na usporiadanie úloh na určitom počte stránok kliknite na tlačidlo "Prestránkovať" a zvoľte požadovaný počet úloh na stránku.';
$string['orderingquiz'] = 'Poradie a stránkovanie';
$string['orderingquizx'] = 'Triedenie a stránkovanie: {$a}';
$string['outcomesadvanced'] = 'Ciele sú pokročilé nastavenia';
$string['outof'] = '{$a->grade} z možných {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} z možných {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Celková spätná väzba';
$string['overallfeedback_help'] = '<p>Celková spätná väzba je text, ktorý sa zobrazí študentovi po ukončení pokusu testu. Text, ktorý je ukázaný, môže závisieť na známke, ktorú študent dostane.</p>

<p>Napríklad, ak vložíte:</p>

<p>Hranica hodnotenia: 100%<br />
Spätná väzba: Výborne<br />
Hranica hodnotenia: 40%<br />
Spätná väzba: Prosím preštudujte si znova prácu z tohto týždňa.<br />
...<br />
Hranica hodnotenia: 0%</p>

<p>Potom študenti, ktorí získali medzi 100% a 40% uvidia správu "Výborne", a študenti, ktorí získali medzi 39.99% and 0% uvidia druhú správu. Bodový zisk definuje rozsahy známok a každá spätná väzba je zobrazená podľa skóre v príslušnom rozsahu.</p>

<p>Bodový zisk môže byť špecifikovaný buď percentom, napríklad "31.41%", alebo ako číslo, napríklad "7". Ak váš test je do 10 bodov, bodový zisk 7 znamená 7/10 alebo viac.</p>';
$string['overdue'] = 'Oneskorený';
$string['overduehandling'] = 'Keď vyprší čas';
$string['overduehandling_desc'] = 'Čo by sa malo stať vo východzom nastavení, ak študent neodovzdá test pred vypršaním času.';
$string['overduehandling_help'] = 'Toto nastavenie ovláda to, čo sa stane, ak sa študentovi nepodarí odoslať svoj pokus o absolvovanie testu pred vypršaním časového limitu. Ak v tom čase študent aktívne pracuje na teste, potom mu časovač pokus automaticky odošle, ale ak sa medzitým odhlásil, potom toto nastavenie určí, čo sa stane.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Pokusy musia byť odoslané pred vypršaním času, inak nebudú uznané.';
$string['overduehandlingautosubmit'] = 'Otvorené pokusy sú odoslané automaticky';
$string['overduehandlinggraceperiod'] = 'Existuje určitý časový interval, keď môžu byť odoslané otvorené pokusy, ale nie je možné odpovedať na ďalšie otázky';
$string['overduemustbesubmittedby'] = 'Tento pokus má teraz meškanie. Mal by už byť odoslaný. Ak by ste chceli, aby bol tento test vyhodnotený, musíte ho odoslať do {$a}. Ak ho dovtedy neodošlete, z tohto pokusu sa nezapočíta žiadne hodnotenie.';
$string['override'] = 'Prestavenie';
$string['overridedeletegroupsure'] = 'Naozaj chcete vymazať prestavenie pre skupinu {$a}?';
$string['overridedeleteusersure'] = 'Naozaj chcete vymazať prestavenie pre používateľa {$a}?';
$string['overridegroup'] = 'Prestaviť skupinu';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Prestavenia';
$string['overridesforquiz'] = 'Prepísať prestavenie: {$a}';
$string['overridesnoneforgroups'] = 'Pre tento test neboli vytvorené žiadne prestavenia skupiny.';
$string['overridesnoneforusers'] = 'Pre tento test neboli vytvorené žiadne prestavenia používateľov.';
$string['overridessummary'] = 'Existujú prestavenia ({$a})';
$string['overridessummarygroup'] = 'Skupiny: {$a}';
$string['overridessummarythisgroup'] = 'Pre túto skupinu existujú prestavenia ({$a})';
$string['overridessummaryuser'] = 'Používatelia: {$a}';
$string['overridessummaryyourgroups'] = 'Pre vaše skupiny existujú prestavenia ({$a})';
$string['overrideuser'] = 'Prestaviť používateľa';
$string['overrideusereventname'] = '{$a->quiz} - prestavenie';
$string['page-mod-quiz-attempt'] = 'Stránka pokusu testu';
$string['page-mod-quiz-edit'] = 'Stránka pre úpravu testu';
$string['page-mod-quiz-report'] = 'Stránka správy testu';
$string['page-mod-quiz-review'] = 'Stránka revízie pokusu';
$string['page-mod-quiz-summary'] = 'Stránka prehľadu pokusu testu';
$string['page-mod-quiz-view'] = 'Informační stránka testu';
$string['page-mod-quiz-x'] = 'Ľubovoľná stránka modulu test';
$string['pageshort'] = 'P';
$string['pagesize'] = 'Stránkovať po';
$string['parent'] = 'Rodičovský';
$string['parentcategory'] = 'Nadradená (rodičovská) kategória';
$string['parsingquestions'] = 'Čítam otázky zo súboru importu.';
$string['partiallycorrect'] = 'Čiastočne správna odpoveď';
$string['penalty'] = 'Penalizácia';
$string['penaltyscheme'] = 'Použiť trestné body';
$string['penaltyscheme_help'] = '<p>Ak test prebieha v adaptívnom režime, študent má povolené po nesprávnej odpovedi skúsiť znova odpovedať. V tomto prípade môžete požadovať trestné body za každú nesprávnu odpoveď, ktoré budú odčítané z výslednej známky za danú úlohu. Výška trestných bodov je vyberaná individuálne pre každú úlohu pri nastavení alebo úprave tejto úlohy.</p>

<p>Toto nastavenie nemá vplyv, ak nie je v teste povolený adaptívny režim.</p>';
$string['percentcorrect'] = 'Správne percentá';
$string['pleaseclose'] = 'Vaša požiadavka bola spracovaná. Teraz už môžete zavrieť toto okno.';
$string['pluginadministration'] = 'Administrácia testu';
$string['pluginname'] = 'Test';
$string['popup'] = 'Zobraziť test v "zabezpečenom" okne';
$string['popupblockerwarning'] = 'Táto časť testu je v bezpečnom móde, takže potrebujete urobiť test v bezpečnom okne. Prosím vypnite blokovanie vyskakovacích okien. Ďakujeme.';
$string['popupnotice'] = 'Študenti budú vidieť test v "bezpečnom" okne';
$string['preprocesserror'] = 'Počas predspracovania sa vyskytla chyba!';
$string['preview'] = 'Náhľad';
$string['previewquestion'] = 'Náhľad otázky';
$string['previewquiz'] = 'Náhľad  {$a}';
$string['previewquiznow'] = 'Náhľad testu teraz';
$string['previewquizstart'] = 'Náhľad testu';
$string['previous'] = 'Predchádzajúci stav';
$string['privacy:metadata:core_question'] = 'Aktivita test ukladá informácie o použití otázok do subsystému core_question.';
$string['privacy:metadata:quiz'] = 'Testová aktivita využíva správy o testoch.';
$string['privacy:metadata:quiz_attempts'] = 'Podrobnosti o každom pokuse urobiť test.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Číslo pokusu.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Aktuálna stránka, na ktorej sa používateľ nachádza.';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'Čas, kedy bol používateľ upozornený, že ručné hodnotenie jeho pokusu bolo dokončené';
$string['privacy:metadata:quiz_attempts:preview'] = 'Či je to ukážka testu.';
$string['privacy:metadata:quiz_attempts:state'] = 'Aktuálny stav pokusu.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Suma známok pri pokuse.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Čas kontroly stavu.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Čas ukončenia pokusu.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Čas, kedy bol pokus aktualizovaný.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Čas, kedy bol pokus aktualizovaný prostredníctvom offline aktualizácie.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Čas začatia pokusu.';
$string['privacy:metadata:quiz_grades'] = 'Podrobnosti o celkovej známke pre tento test.';
$string['privacy:metadata:quiz_grades:grade'] = 'Celková známka za tento test.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Test, ktorý bol hodnotený.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Čas, kedy bola známka upravená.';
$string['privacy:metadata:quiz_grades:userid'] = 'Používateľ, ktorý bol klasifikovaný.';
$string['privacy:metadata:quiz_overrides'] = 'Podrobnosti o prepísaniach tohto testu';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Test s prepísanými informáciami';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Nový čas ukončenia testu.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Nový časový limit na test.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Nový čas otvorenia pre test.';
$string['privacy:metadata:quiz_overrides:userid'] = 'Používateľ je prepísaný';
$string['privacy:metadata:quizaccess'] = 'Testová aktivita využíva pravidlá prístupu ku testom.';
$string['publish'] = 'Publikovať';
$string['publishedit'] = 'Musíte mať povolenie na tvorbu kurzu, aby ste mohli pridávať alebo upravovať otázky v tejto kategórii.';
$string['qbrief'] = 'Úloha. {$a}';
$string['qname'] = 'názov';
$string['qti'] = 'Formát IMS QTI';
$string['qtypename'] = 'typ, názov';
$string['question'] = 'Otázka';
$string['questionbank'] = 'existujúcu otázku z banky otázok';
$string['questionbankmanagement'] = 'Správa banky otázok';
$string['questionbehaviour'] = 'Správanie otázky';
$string['questioncats'] = 'Kategórie otázok';
$string['questiondeleted'] = 'Tato úloha bola odstránená. Prosím, kontaktujte vášho vyučujúceho';
$string['questiondependencyadd'] = 'Žiadne obmedzenia pre odpoveď na otázku {$a->thisq} • Ak toto chcete zmeniť, kliknite';
$string['questiondependencyfree'] = 'Žiadne obmedzenia pre túto otázku';
$string['questiondependencyremove'] = 'Otázka {$a->thisq} môže byť odpovedaná až po dokončení predchádzajúcej {$a->previousq} • Ak toto chcete zmeniť, kliknite';
$string['questiondependsonprevious'] = 'Otázka môže byť spustená až po ukončení predchádzajúcej.';
$string['questioninuse'] = 'Otázka \'{$a->questionname}\' je práve používaná:<br  />{$a->quiznames}<br />Otázky nebudú vymazané z týchto testov ale iba zo zoznamu kategórií.';
$string['questionmissing'] = 'Otázka pre toto sedenie chýba';
$string['questionname'] = 'Názov otázky';
$string['questionnonav'] = '<span class="accesshide">Úloha </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informácia </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Otázka {$a} nebola nahraná z databázy';
$string['questionorder'] = 'Poradie otázok';
$string['questionposition'] = 'Nové poradie otázky {$a} v teste';
$string['questions'] = 'Otázky';
$string['questionsetpreview'] = 'Ukážka súboru otázok';
$string['questionsinclhidden'] = 'Úlohy (včítane skrytých)';
$string['questionsinthisquiz'] = 'Otázky v tomto teste';
$string['questionsmatchingfilter'] = 'Otázky zodpovedajúce tomuto filtru: {$a}';
$string['questionsperpage'] = 'Maximálny počet otázok na stranu';
$string['questionsperpageselected'] = 'Počet úloh na stránku bol nastavený tak, že stránkovanie je v súčasnosti nemenné. V dôsledku toho boli zakázané ovládacie prvky stránkovania. Toto nastavenie môžete zmeniť v {$a}.';
$string['questionsperpagex'] = 'Počet otázok na stranu: {$a}';
$string['questiontext'] = 'Text otázky';
$string['questiontextisempty'] = '[Prázdny test otázky]';
$string['questiontype'] = 'Otázka typu  {$a}';
$string['questiontypesetupoptions'] = 'Možnosti nastavenia pre typy otázok:';
$string['questionversion'] = 'v{$a}';
$string['questionversionlatest'] = 'v{$a} (najnovší)';
$string['quiz:addinstance'] = 'Pridať nový test';
$string['quiz:attempt'] = 'Byť testovaný';
$string['quiz:deleteattempts'] = 'Vymazať všetky pokusy testov';
$string['quiz:emailconfirmsubmission'] = 'Dostať potvrdzovací mail po odovzdaní testu';
$string['quiz:emailnotifyattemptgraded'] = 'Dostať upozornenie, keď bol váš pokus ohodnotený';
$string['quiz:emailnotifysubmission'] = 'Získavať emailové upozornenie na odovzdané úlohy študentov';
$string['quiz:emailwarnoverdue'] = 'Dostávať upozornenie na blížiaci sa koniec pre pokus testu';
$string['quiz:grade'] = 'Ohodnotiť testy manuálne';
$string['quiz:ignoretimelimits'] = 'Ignorovať časové obmedzenie v testoch';
$string['quiz:manage'] = 'Spravovať testy';
$string['quiz:manageoverrides'] = 'Spravovať prestavenia kurzu';
$string['quiz:preview'] = 'Náhľad testov';
$string['quiz:regrade'] = 'Preznámkovať pokusy testu';
$string['quiz:reviewmyattempts'] = 'Prehľad vlastných pokusov';
$string['quiz:view'] = 'Prezerať informáciu o teste';
$string['quiz:viewoverrides'] = 'Zobraziť prestavenia testu';
$string['quiz:viewreports'] = 'Prezerať správy o teste';
$string['quizavailable'] = 'Test je dostupný do: {$a}';
$string['quizclose'] = 'Zatvoriť test';
$string['quizclosed'] = 'Tento test bol zatvorený {$a}';
$string['quizcloses'] = 'Test je uzatvorený';
$string['quizcloseson'] = 'Tento test sa zatvára dňa {$a}';
$string['quizeventcloses'] = '{$a} sa uzavrie';
$string['quizeventopens'] = '{$a} sa otvorí';
$string['quizisclosed'] = 'Tento test je uzavretý';
$string['quizisclosedwillopen'] = 'Test je uzavretý (otvorí sa {$a})';
$string['quizisopen'] = 'Tento test je otvorený';
$string['quizisopenwillclose'] = 'Test sa otvára (zatvára {$a})';
$string['quiznavigation'] = 'Navigácia v teste';
$string['quizopen'] = 'Otvoriť test';
$string['quizopenclose'] = 'Dátum sprístupnenia a uzavrenia';
$string['quizopenclose_help'] = 'Študenti môžu začať svoj pokus po dátume sprístupnenia a musia odovzdať test pred dátumom uzavrenia.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopened'] = 'Tento test je otvorený';
$string['quizopenedon'] = 'Tento test bol otvorený dňa {$a}';
$string['quizopens'] = 'Test sa otvára';
$string['quizopenwillclose'] = 'Tento test je otvorený, bude uzavretý dňa {$a} o';
$string['quizordernotrandom'] = 'Poradie testu nie je zamiešané';
$string['quizorderrandom'] = '* Poradie testu je zamiešané';
$string['quizreport'] = 'Report testu';
$string['quizsettings'] = 'Nastavenia testu';
$string['quiztimer'] = 'Časomiera testu';
$string['quizwillopen'] = 'Tento test bude otvorený dňa {$a}';
$string['random'] = 'Náhodná otázka';
$string['randomcreate'] = 'Vytvoriť náhodné otázky';
$string['randomediting'] = 'Úpravy náhodnej otázky';
$string['randomfromcategory'] = 'Náhodná otázka z kategórie:';
$string['randomfromexistingcategory'] = 'Náhodná otázka z existujúcej kategórie';
$string['randomfromunavailabletag'] = '{$a} (nedostupný)';
$string['randomnosubcat'] = 'Otázky pochádzajúce iba z tejto kategórie, nie jej podkategórií.';
$string['randomnumber'] = 'Počet náhodných otázok';
$string['randomquestion'] = 'Náhodná otázka';
$string['randomquestion_help'] = 'Náhodná otázka je spôsob vloženia náhodne zvolenej otázky buď z určitej kategórie otázok alebo cez špecifikovanie značky (tágu), ktorý je priradený určitým otázkam.';
$string['randomquestiontags'] = 'Značky (tágy, kľúčové slová)';
$string['randomquestiontags_help'] = 'Ďalšie kritériá výberu otázok môžete obmedziť zadaním niektorých značiek (tágov).

"Náhodné" otázky budú vybrané z otázok, ktoré obsahujú všetky tieto značky (tágy).';
$string['randomquestionusinganewcategory'] = 'Náhodná otázka z novej kategórie';
$string['randomwithsubcat'] = 'Otázky pochádzajúce z tejto kategórie a jej podkategórií.';
$string['readytosend'] = 'Pripravujete sa na posielanie celého vášho testu na ohodnotenie. Naozaj chcete pokračovať?';
$string['reattemptquiz'] = 'Opätovný pokus o test';
$string['recentlyaddedquestion'] = 'Nedávno pridaná otázka!';
$string['recurse'] = 'Zahrňte aj otázky z podkategórií';
$string['redoesofthisquestion'] = 'Ďalšie pokusy sú: {$a}';
$string['redoquestion'] = 'Skúste inú otázku, ako je táto';
$string['regrade'] = 'Preznámkovať všetky pokusy';
$string['regradecomplete'] = 'Všetky pokusy boli preznámkované';
$string['regradecount'] = '{$a->changed} z {$a->attempt} boli zmenené známky';
$string['regradedisplayexplanation'] = 'Pokusy, ktoré budú zmenené počas opätovného známkovania, sa budú zobrazovať ako odkazy na okno s prehľadom jednotlivých testových otázok.';
$string['regradenotallowed'] = 'Nemáte oprávnenie prehodnotiť tento test';
$string['regradingquestion'] = 'Opätované známkovanie otázky  "{$a}".';
$string['regradingquiz'] = 'Opätované známkovanie testu  "{$a}"';
$string['remove'] = 'Odstrániť';
$string['removeallgroupoverrides'] = 'Odstrániť všetky prestavenia skupiny';
$string['removeallquizattempts'] = 'Odstrániť všetky pokusy testov';
$string['removealluseroverrides'] = 'Odstrániť všetky prestavenia používateľov';
$string['removeemptypage'] = 'Odstrániť prázdnu stranu';
$string['removepagebreak'] = 'Odstrániť zlom stránky';
$string['removeselected'] = 'Odstrániť vybrané';
$string['rename'] = 'Premenovať';
$string['renderingserverconnectfailed'] = 'Server {$a} nedokázal spracovať RQP požiadavku. Skontrolujte, či je URL adresa zadaná správne.';
$string['reorderquestions'] = 'Zmeniť poradie otázok';
$string['reordertool'] = 'Zobrazovať pomôcku pre zmenu poradia';
$string['repaginate'] = 'Znovu zadefinovať počet otázok na stránke: {$a}';
$string['repaginatecommand'] = 'Prestránkovať';
$string['repaginatenow'] = 'Prestránkovať teraz';
$string['replace'] = 'Nahradiť';
$string['replacementoptions'] = 'Možnosti nahradzovania';
$string['report'] = 'Zápisy';
$string['reportanalysis'] = 'Analýza položky';
$string['reportattemptsfrom'] = 'Pokusy od';
$string['reportattemptsthatare'] = 'Pokusy, ktoré sú';
$string['reportdisplayoptions'] = 'Možnosti zobrazenia';
$string['reportfullstat'] = 'Detailná štatistika';
$string['reportmulti_percent'] = 'Viacpercentuálna hodnota';
$string['reportmulti_q_x_student'] = 'Možnosť výberu viacerými študentmi';
$string['reportmulti_resp'] = 'Odpovede individuálnych používateľov';
$string['reportmustselectstate'] = 'Musíte vybrať najmenej jeden stav';
$string['reportnotfound'] = 'Správa je neznáma pre ({$a})';
$string['reportoverview'] = 'Celkový prehľad';
$string['reportregrade'] = 'Preznámkovať pokusy';
$string['reportresponses'] = 'Odpovede podrobne';
$string['reports'] = 'Správy';
$string['reportshowonly'] = 'Zobraziť iba pokusy';
$string['reportshowonlyfinished'] = 'Zobraziť maximálne jeden ukončený pokus používateľa ({$a})';
$string['reportsimplestat'] = 'Jednoduchá štatistika';
$string['reportusersall'] = 'všetci používatelia, ktorí majú pokus v teste';
$string['reportuserswith'] = 'zapísaní používatelia, ktorí majú pokus v teste';
$string['reportuserswithorwithout'] = 'zapísaní používatelia';
$string['reportuserswithout'] = 'zapísaní používatelia bez pokusu v teste';
$string['reportwhattoinclude'] = 'Čo treba zahrnúť do správy';
$string['requirepassword'] = 'Vyžaduje sa heslo';
$string['requirepassword_help'] = '<p>Toto pole je voliteľné.</p>

<p>Ak tu špecifikujete heslo, budú ho študenti musieť zadať pred každým pokusom o vykonanie testu.</p>';
$string['requiresubnet'] = 'Vyžaduje sa adresa siete';
$string['requiresubnet_help'] = '<p>Toto pole je voliteľné.</p>

<p>Špecifikovaním zoznamu úplných alebo neúplných IP adries oddelených čiarkou môžete obmedziť prístup k testu pre konkrétne podsiete v rámci siete LAN alebo Internetu.</p>

<p>Toto je obzvlášť užitočné pre zabezpečené testy, pri ktorých chcete mať istotu, že k testu budú mať prístup iba študenti v danej miestnosti.</p>

<p>Napríklad: <b>192.168. , 231.54.211.0/20, 231.3.56.211, 231.3.56.10-20</b></p>

<p>Môžete použiť štyri typy čísiel (nemôžete použiť textové mená domén ako example.com):</p>

<ol>
<li>Úplné IP adresy, ako <b>192.168.10.1</b>, ktoré zodpovedajú jednému počítaču (alebo proxy serveru).</li>
<li>Neúplné adresy, ako <b>192.168</b>, ktoré zodpovedajú všetkým umiestneniam, ktoré začínajú na tieto čísla.</li>
<li>CIDR zápis, ako <b>231.54.211.0/20</b>, ktorý Vám povoľuje podrobnejšie špecifikovať určenie podsietí.</li>
<li>Rozsah IP adries <b>231.3.56.10-20</b>. Rozsah sa vzťahuje na poslednú časť adresy, to znamená na celú IP adresu od 231.3.56.10 do 231.3.56.20.</li>
</ol>

<p>Medzery sú ignorované.</p>';
$string['response'] = 'Odpoveď';
$string['responses'] = 'Odpovede';
$string['results'] = 'Výsledky';
$string['returnattempt'] = 'Vráťte sa k pokusu';
$string['reuseifpossible'] = 'znovu použiť predtým odstránené';
$string['reverttodefaults'] = 'Vrátiť sa k východzím nastaveniam testu';
$string['review'] = 'Prehľad';
$string['reviewafter'] = 'Povoliť prehľad aj po uzatvorení testu';
$string['reviewalways'] = 'Povoliť prehľad kedykoľvek';
$string['reviewattempt'] = 'Prezrieť pokus';
$string['reviewbefore'] = 'Povoliť prehľad pokým je test otvorený';
$string['reviewclosed'] = 'Po tom, ako sa uzatvorí test';
$string['reviewduring'] = 'Počas pokusu';
$string['reviewimmediately'] = 'Hneď po pokuse';
$string['reviewnever'] = 'Nikdy nepovoliť prehľad';
$string['reviewofquestion'] = 'Kontrola úlohy {$a->question} v {$a->quiz} používateľom {$a->user}';
$string['reviewopen'] = 'Neskôr, keď je test stále otvorený';
$string['reviewoptions'] = 'Študenti majú možnosť revízie';
$string['reviewoptionsheading'] = 'Možnosti prehľadu';
$string['reviewoptionsheading_help'] = 'Tieto možnosti určujú, aké informácie môžu študenti vidieť pri kontrole pokusu o vykonanie testu alebo pri prezeraní správ o teste.

** Počas pokusu ** nastavenia sú relevantné iba pre určité správanie, napríklad „interaktívne s viacerými pokusmi“, ktoré môžu počas pokusu zobrazovať spätnú väzbu.

** Ihneď po pokuse ** Nastavenia platia počas prvých dvoch minút po kliknutí na \'Odoslať všetko a ukončiť\'.

** Neskôr, kým je test stále otvorený **, nastavenia sa použijú až po tomto dátume a pred dátumom ukončenia testu.

** Po uzavretí testu ** nastavenia platia po uplynutí dátumu ukončenia testu. Ak kvíz nemá dátum uzávierky, tento stav sa nikdy nedosiahne.';
$string['reviewoverallfeedback'] = 'Celková spätná väzba';
$string['reviewoverallfeedback_help'] = 'Celková spätná väzba je uvedená na konci pokusu v závislosti od celkovej známky študenta';
$string['reviewresponse'] = 'Zhodnotiť odpoveď';
$string['reviewresponsetoq'] = 'Zhodnotiť odpoveď (otázka {$a})';
$string['reviewthisattempt'] = 'Prezrieť svoje odpovede v tomto pokuse';
$string['rqp'] = 'Vzdialená otázka';
$string['rqps'] = 'Vzdialené otázky';
$string['sameasoverall'] = 'Rovnako ako v známkach';
$string['save'] = 'Uložiť';
$string['saveandedit'] = 'Uložiť odpovede a upraviť otázky';
$string['saveattemptfailed'] = 'Nepodarilo sa uložiť aktuálny pokus testu';
$string['savedfromdeletedcourse'] = 'Uložené z vymazaného kurzu "{$a}"';
$string['savegrades'] = 'Uložiť známky';
$string['savemyanswers'] = 'Uložiť moje odpovede';
$string['savenosubmit'] = 'Uložiť bez odoslania';
$string['saveoverrideandstay'] = 'Uložiť a zadať ďalšie prestavenie';
$string['savequiz'] = 'Uložiť tento celý test';
$string['saving'] = 'Ukladanie';
$string['savingnewgradeforquestion'] = 'Ukladanie nového hodnotenia úlohy id {$a}.';
$string['savingnewmaximumgrade'] = 'Ukladanie nového maxima hodnotenia.';
$string['score'] = 'Hrubé skóre';
$string['scores'] = 'Skóre';
$string['search:activity'] = 'Test - informácie o činnosti';
$string['sectionheadingedit'] = 'Upraviť záhlavie "{$a}"';
$string['sectionheadingremove'] = 'Odstrániť záhlavie "{$a}"';
$string['sectionnoname'] = 'Sekcia bez názvu';
$string['seequestions'] = '(Viď otázky)';
$string['select'] = 'Vybrať';
$string['selectall'] = 'Vybrať všetko';
$string['selectattempt'] = 'Vyberte pokus';
$string['selectcategory'] = 'Vybrať kategóriu';
$string['selectedattempts'] = 'Vybrať pokusy...';
$string['selectmultipleitems'] = 'Výber viacerých položiek';
$string['selectmultipletoolbar'] = 'Vyberte viac panelov s nástrojmi';
$string['selectnone'] = 'Odznačiť všetky';
$string['selectquestiontype'] = '-- Výber typu otázky --';
$string['serveradded'] = 'Pridaný server';
$string['serveridentifier'] = 'Identifikátor';
$string['serverinfo'] = 'Informácie o serveri';
$string['servers'] = 'Servery';
$string['serverurl'] = 'URL servera';
$string['shortanswer'] = 'Krátka odpoveď';
$string['show'] = 'Ukázať';
$string['showall'] = 'Zobraziť všetky otázky na jednej stránke';
$string['showblocks'] = 'Zobraziť bloky počas vypracovania testu';
$string['showblocks_help'] = 'Ak je voľba nastavená, budú počas vypracovania testu zobrazené normálne bloky';
$string['showbreaks'] = 'Znázorniť zlomy na stránke';
$string['showcategorycontents'] = 'Ukázať obsah kategórie {$a->arrow}';
$string['showcorrectanswer'] = 'V spätnej väzbe zobraziť správne odpovede?';
$string['showdetailedmarks'] = 'Znázorniť detaily známok';
$string['showeachpage'] = 'Zobraziť jednu stránku po druhej';
$string['showfeedback'] = 'Po zodpovedaní ukážte spätnú väzbu?';
$string['showinsecurepopup'] = 'Používať \'bezpečné\' vyskakovanie okno pre vypracovanie testu';
$string['showlargeimage'] = 'Veľký obrázok';
$string['shownoattempts'] = 'Ukázať študentov bez pokusov';
$string['shownoattemptsonly'] = 'Zobrazovať iba študentov, ktorí sa o test nepokúsili';
$string['shownoimage'] = 'Bez obrázku';
$string['showreport'] = 'Zobraziť správu';
$string['showsmallimage'] = 'Malý obrázok';
$string['showteacherattempts'] = 'Ukázať pokusy učiteľov';
$string['showuserpicture'] = 'Ukázať obrázok používateľa';
$string['showuserpicture_help'] = 'Ak je táto možnosť aktivovaná, zobrazí sa počas pokusu na obrazovke meno študenta a jeho fotka, súčasne sa zobrazí na obrazovke prehľad, aby sa dohliadajúcemu ľahšie kontrolovalo, že je študent skutočne ten, ktorý je prihlásený na dôležitej skúške.';
$string['shuffle'] = 'Zamiešať';
$string['shuffleanswers'] = 'Zamiešať odpovede';
$string['shuffledrandomly'] = 'Náhodne poprehadzovať';
$string['shufflequestions'] = 'Zamiešať otázky';
$string['shufflequestions_help'] = 'Ak túto možnosť zapnete, potom sa v tejto sekcii vždy po pokuse o zvládnutie testu zamiešajú otázky v rôznom náhodne zvolenom poradí.

Tým sa študentom sťaží zdieľanie odpovedí, ale tiež diskusia s vami o konkrétnej otázke.';
$string['shufflewithin'] = 'Zamiešať v rámci úloh';
$string['shufflewithin_help'] = '<p>Ak zapnete túto voľbu, potom jednotlivé časti úloh budú náhodne
zamiešané pri každom pokuse študenta, ak to umožňuje nastavenie
konkrétnej úlohy.</p>

<p>Zámer je v tom, aby študenti nemohli tak ľahko opisovať jeden od
druhého.</p>

<p>Nastavenie je iba pre úlohy, ktoré majú možnosť výberu, ako úlohy z
výberom odpovedí a priradzovacie úlohy. Pre úlohy s výberom odpovedí
platí, že poradie odpovedí bude zamiešané, iba ak je táto možnosť je
nastavená na &quot;Áno&quot;. Pre priradzovacie úlohy budú odpovede
vždy zamiešané a toto nastavenie určuje, či má byť zamiešané aj poradie
otázka - odpoveď.</p>

<p>Táto voľba nie je spojená s použitím náhodne vybratých otázok.</p>';
$string['singleanswer'] = 'Vyberte jednu odpoveď';
$string['sortage'] = 'Triediť podľa dátumu';
$string['sortalpha'] = 'Triediť abecedne podľa názvu';
$string['sortquestionsbyx'] = 'Triediť otázky podľa: {$a}';
$string['sortsubmit'] = 'Triediť úlohy';
$string['sorttypealpha'] = 'Triediť abecedne podľa typu';
$string['specificapathnotonquestion'] = 'Zadaná cesta k súboru nie je v určenej otázke';
$string['specificquestionnotonquiz'] = 'Daná otázka nie je v určenom teste';
$string['startagain'] = 'Začať znovu';
$string['startattempt'] = 'Začať pokus';
$string['startedon'] = 'Začiatok';
$string['startnewpreview'] = 'Začať nový náhľad';
$string['stateabandoned'] = 'Nikdy neodoslané';
$string['statefinished'] = 'Hotovo';
$string['statefinisheddetails'] = 'Odoslané {$a}';
$string['stateinprogress'] = 'Prebieha';
$string['statenotloaded'] = 'Stav otázky: {$a} nebol nahraný z databázy.';
$string['stateoverdue'] = 'Po termíne';
$string['stateoverduedetails'] = 'Musí byť odoslané do {$a}';
$string['status'] = 'Stav';
$string['stoponerror'] = 'Zastaviť na chybe';
$string['submission_confirmation'] = 'Odoslať všetky odpovede a ukončiť?';
$string['submission_confirmation_unanswered'] = 'Otázky bez odpovede: {$a}';
$string['submitallandfinish'] = 'Odoslať všetko a ukončiť';
$string['subneterror'] = 'Prepáčte, ale tento kurz bol uzamknutý a je možné do neho vstúpiť iba z určitých lokalít. Váš počítač je jeden z tých, ktoré nemajú povolenie vstupu do testu.';
$string['subnetnotice'] = 'Tento test bol uzamknutý a je prístupný iba z niektorých miest. Váš počítač bohužiaľ medzi ne nepatrí. Ako učiteľ máte možnosť prehliadnuť si čokoľvek.';
$string['subplugintype_quiz'] = 'Zostava';
$string['subplugintype_quiz_plural'] = 'Zostavy';
$string['subplugintype_quizaccess'] = 'Prístupové pravidlo';
$string['subplugintype_quizaccess_plural'] = 'Prístupové pravidlá';
$string['substitutedby'] = 'bude nahradené';
$string['summaryofattempt'] = 'Zhrnutie pokusu';
$string['summaryofattempts'] = 'Sumár vašich predošlých pokusov';
$string['temporaryblocked'] = 'Dočasne vám nie je dovolené pokúsiť sa o ďalšie zvládnutie testu.<br />Ďalší pokus budete môcť absolvovať:';
$string['theattempt'] = 'Tento pokus';
$string['theattempt_help'] = 'Či si študent môže vôbec pozrieť svoj pokus.';
$string['time'] = 'Čas';
$string['timecompleted'] = 'Ukončený';
$string['timedelay'] = 'Nie je vám dovolené absolvovať tento test, pretože vám doposiaľ neuplynulo nastavené oneskorenie medzi dvomi testami.';
$string['timeleft'] = 'Zvyšný čas';
$string['timelimit'] = 'Časový limit';
$string['timelimit_help'] = 'Ak je povolené, časový limit je uvedený na úvodnej testovej stránke a odpočítavací časovač je zobrazený v navigačnom bloku testu.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Prepáčte, ale čas už vypršal!';
$string['timestr'] = '%H:%M:%S dňa %d/%m/%y';
$string['timesup'] = 'Končíme!';
$string['timetaken'] = 'Strávený čas';
$string['timing'] = 'Časovanie';
$string['tofile'] = 'do súboru';
$string['tolerance'] = 'Tolerancia';
$string['toomanyrandom'] = 'Požadovaný počet náhodných otázok je väčší, než je obsiahnuté v tejto kategórii! ({$a})';
$string['top'] = 'Vrch';
$string['totalmarksx'] = 'Súčet hodnotení: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Celkom {$a} otázok v kategórii.';
$string['true'] = 'Áno';
$string['truefalse'] = 'Áno/Nie';
$string['type'] = 'Typ';
$string['unfinished'] = 'otvorený';
$string['ungraded'] = 'Neznámkovaný';
$string['unit'] = 'Jednotka';
$string['unknowntype'] = 'Typ otázky nie je podporovaný na riadku {$a}. Otázka bude ignorovaná';
$string['updateoverdueattemptstask'] = 'Aktualizácia pokusov o test po splatnosti';
$string['updatequizslotswithrandomxofy'] = 'Aktualizácia slotov testu s "náhodnými" otázkovými dátami  ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Aktualizovať nastavenie testu';
$string['updatingatttemptgrades'] = 'Aktualizujú sa hodnotenia pokusov.';
$string['updatingfinalgrades'] = 'Aktualizácia výsledného hodnotenia.';
$string['updatingthegradebook'] = 'Aktualizácia výkazu známok.';
$string['upgradesure'] = '<div>Tento test čaká rozsiahla zmena databázových tabuliek a táto aktualizácia ešte nebola dostatočne otestovaná. Odporúčame Vám, aby ste si zálohovali databázové tabuľky predtým, ako budete pokračovať.</div>';
$string['upgradingquizattempts'] = 'Aktualizujú sa pokusy testov : test {$a->done}/{$a->outof} (Test id {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Aktualizujú sa veľmi staré pokusy testov: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Táto kategória bola presunutá do úrovne stránky, pretože po vymazaní kurzu sa otázky v použité v tejto kategórii používali aj v ostatných testoch na serveri.';
$string['useroverrides'] = 'Používateľské prestavenia';
$string['useroverridesdeleted'] = 'Prestavenie používateľa bolo odstránené';
$string['usersnone'] = 'K tomuto testu nemajú prístup žiadni študenti';
$string['validate'] = 'Overiť';
$string['viewallanswers'] = 'Zobraziť {$a} celých testov';
$string['viewallreports'] = 'Prezrieť zápisy {$a} pokusov';
$string['viewed'] = 'Prezrené';
$string['warningmissingtype'] = '<p><b>Tento typ úloh nie je na vašom serveri nainštalovaný.<br />Prosím, upozornite vášho správcu Moodle.</b></p>';
$string['wheregrade'] = 'Kde je moja známka?';
$string['wildcard'] = 'Divoká karta';
$string['windowclosing'] = 'Toto okno sa čoskoro zavrie';
$string['withsummary'] = 'so súhrnnou štatistikou';
$string['wronguse'] = 'Nemôžete používať túto stránku len tak';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Tento test môžete začať až potom, keď sa zapíšete do tohto kurzu.';
$string['yourfinalgradeis'] = 'Vaša konečná známka za tento test je {$a}.';
