<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'plugin', language 'sk', version '4.2'.
 *
 * @package     plugin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Akcie';
$string['availability'] = 'Dostupnosť';
$string['cancelinstallall'] = 'Zrušiť nové inštalácie ({$a})';
$string['cancelinstallhead'] = 'Zrušenie inštalácie zásuvných modulov';
$string['cancelinstallinfo'] = 'Následujúce doplnky ešte nie sú úplne nainštalované, takže ich inštalácie môžu byť zrušené. Ak tak chcete urobiť, musí byť priečinok zásuvného modulu teraz zo serveru odstránený. Uistite sa, že je to naozaj to, čo chcete, aby sa zabránilo náhodnej strate údajov (ako sú vlastné úpravy kódu).';
$string['cancelinstallinfodir'] = 'Priečinok, ktorý má byť odstránený: {$a}';
$string['cancelinstallone'] = 'Zrušiť túto inštaláciu';
$string['cancelupgradeall'] = 'Zrušiť aktualizáciu  ({$a})';
$string['cancelupgradehead'] = 'Obnovenie predošlej verzie zásuvných modulov';
$string['cancelupgradeone'] = 'Zrušiť túto aktualizáciu';
$string['checkforupdates'] = 'Kontrolovať dostupné aktualizácie';
$string['checkforupdateslast'] = 'Posledná kontrola bola uskutočnená dňa {$a}';
$string['dependencyavailable'] = 'Dostupné';
$string['dependencyfails'] = 'Chyba';
$string['dependencyinstall'] = 'Inštalovať';
$string['dependencyinstallhead'] = 'Nainštaluje chýbajúce závislosti';
$string['dependencyinstallmissing'] = 'Nainštaluje chýbajúce závislosti ({$})';
$string['dependencymissing'] = 'Chýbajúci';
$string['dependencyunavailable'] = 'Nedostupné';
$string['dependencyupload'] = 'Nahrať';
$string['dependencyuploadmissing'] = 'Nahrať ZIP súbor';
$string['detectedmisplacedplugin'] = 'Zásuvný modul "{$a->component}" je nainštalovaný v nesprávnom umiestnení "{$a->current}". Očakávané umiestnenie je "{$a->expected}"';
$string['displayname'] = 'Názov modulu';
$string['err_response_curl'] = 'Nie je možné stiahnuť dostupné údaje aktualizácií - neočakávaná chyba cURL.';
$string['err_response_format_version'] = 'Neočakávaná verzia formátu odpovede. Prosím, skúste znovu skontrolovať dostupné aktualizácie.';
$string['err_response_http_code'] = 'Nie je možné stiahnuť dostupné údaje aktualizácií - neočakávaný kód HTTP odpovede.';
$string['filterall'] = 'Zobraziť všetko';
$string['filtercontribonly'] = 'Zobraziť iba dodatočné zásuvné moduly';
$string['filterupdatesonly'] = 'Zobraziť iba aktualizovateľné';
$string['incompatibleversion'] = 'Nekompatibilná verzia Moodle: {$a}';
$string['isenabled'] = 'Povolené?';
$string['misdepinfoplugin'] = 'Informácia o zásuvnom module';
$string['misdepinfoversion'] = 'Informácia o verzii';
$string['misdepsavail'] = 'Existujú nevyriešené závislosti, ktoré sú dostupné';
$string['misdepsunavail'] = 'Existujú nevyriešené závislosti, ktoré sú nedostupné';
$string['misdepsunavaillist'] = 'Nie je zistená verzia pre splnenie požiadaviek na závislostiach {$a}.';
$string['misdepsunknownlist'] = 'Nie je v adresári zásuvných modulov: <strong>{$a}</strong>.';
$string['moodlebranch'] = 'Moodle {$a->min} - {$a->max}';
$string['moodleversion'] = 'Moodle {$a}';
$string['noneinstalled'] = 'Nie je nainštalovaný žiadny zásuvný modul tohto typu';
$string['notdownloadable'] = 'Balíček nie je možné stiahnuť';
$string['notdownloadable_help'] = 'ZIP balíček s aktualizáciou nie je možné automaticky stiahnuť';
$string['notdownloadable_link'] = 'admin/mdeploy/notdownloadable';
$string['notes'] = 'Poznámky';
$string['notsupported'] = 'Doplnok nemusí byť kompatibilný s verziou Moodle {$a}';
$string['notwritable'] = 'Súbory zásuvného modulu nie sú prepisovateľné';
$string['notwritable_help'] = 'Súbory zásuvného modulu nie sú zapisovateľné webovým serverom do priečinka doplnkov, takže  teraz nie je možné aktualizácie nainštalovať.

Aby bolo možné nainštalovať dostupnú aktualizáciu automaticky, nastavte priečinok zásuvného modulu a jeho obsah ako zapisovateľný. Tiež môže byť vyžadovaný prístup do koreňového priečinka daného typu zásuvného modulu.';
$string['otherplugin'] = '{$a->component}';
$string['otherpluginversion'] = '{$a->component} ({$a->version})';
$string['overviewall'] = 'Všetky zásuvné moduly';
$string['overviewext'] = 'Dodatočné zásuvné moduly';
$string['overviewupdatable'] = 'Dostupné aktualizácie';
$string['packagesdebug'] = 'Povolený výstup ladenia';
$string['packagesdownloading'] = 'Sťahujem {$a}';
$string['packagesextracting'] = 'Rozbaľujem {$a}';
$string['packagesvalidating'] = 'Overujem {$a}';
$string['packagesvalidatingfailed'] = 'Inštalácia bola prerušená z dôvodu zlyhania overenia';
$string['packagesvalidatingok'] = 'Overenie bolo úspešné, inštalácia môže pokračovať';
$string['plugincheckall'] = 'Všetky zásuvné moduly';
$string['plugincheckattention'] = 'Zásuvné moduly vyžadujúce pozornosť';
$string['pluginchecknone'] = 'Vašu pozornosť nevyžaduje žiaden zásuvný modul';
$string['pluginchecknotice'] = 'Táto stránka zobrazuje zoznam modulov, ktoré môžu vyžadovať vašu pozornosť počas tejto aktualizácie. Zvýraznené položky sú nové moduly, ktoré budú nainštalované, novšie verzie modulov, ktoré budú aktualizované a chýbajúce moduly. Zásuvné moduly tretích strán sú zvýraznené vždy. Doporučuje sa, aby ste skontrolovali, či nie je dostupná novšia verzia všetkých zásuvných modulov a prípadne túto novšiu verziu nahrali na váš server predtým, ako budete pokračovať s touto aktualizáciou Moodle.';
$string['plugindisable'] = 'Zakázať';
$string['plugindisabled'] = 'Zakázaný';
$string['pluginenable'] = 'Povoliť';
$string['pluginenabled'] = 'Povolený';
$string['release'] = 'Vydanie';
$string['requiredby'] = 'Je vyžadovaný modulom: {$a}';
$string['requires'] = 'Vyžaduje';
$string['rootdir'] = 'Adresár';
$string['settings'] = 'Nastavenia';
$string['source'] = 'Zdroj';
$string['sourceext'] = 'Dodatočný';
$string['sourcestd'] = 'Štandardný';
$string['status'] = 'Status';
$string['status_delete'] = 'Na odstránenie';
$string['status_downgrade'] = 'Vyššia verzia je už nainštalovaná';
$string['status_missing'] = 'Chýba na disku';
$string['status_new'] = 'Bude nainštalovaný';
$string['status_nodb'] = 'Žiadna databáza';
$string['status_upgrade'] = 'Bude aktualizovaný';
$string['status_uptodate'] = 'Nainštalovaný';
$string['supportedconversions'] = 'Podporované konverzie dokumentov';
$string['supportedmoodleversions'] = 'Podporované verzie Moodle';
$string['systemname'] = 'Identifikátor';
$string['type_antivirus'] = 'Antivírus';
$string['type_antivirus_plural'] = 'Antivírové zásuvné moduly';
$string['type_auth'] = 'Overovací modul';
$string['type_auth_plural'] = 'Overovacie zásuvné moduly';
$string['type_availability'] = 'Obmedzenie dostupnosti';
$string['type_availability_plural'] = 'Obmedzenia dostupnosti';
$string['type_block'] = 'Blok';
$string['type_block_plural'] = 'Bloky';
$string['type_cachelock'] = 'Ovládač zámku vyrovnávacej pamäte';
$string['type_cachelock_plural'] = 'Ovládače zámku vyrovnávacej pamäte';
$string['type_cachestore'] = 'Vyrovnávacia pamäť';
$string['type_cachestore_plural'] = 'Vyrovnávacie pamäte';
$string['type_calendartype'] = 'Typ kalendárov';
$string['type_calendartype_plural'] = 'Typy kalendárov';
$string['type_contentbank'] = 'Banka obsahu';
$string['type_contentbank_plural'] = 'Zásuvné moduly banky obsahu';
$string['type_contenttype'] = 'Banka obsahu';
$string['type_contenttype_plural'] = 'Zásuvné moduly banky obsahu';
$string['type_coursereport'] = 'Výkaz kurzu';
$string['type_coursereport_plural'] = 'Výkazy kurzu';
$string['type_customfield'] = 'Vlastné pole';
$string['type_customfield_plural'] = 'Vlastné polia';
$string['type_dataformat'] = 'Formát údajov';
$string['type_dataformat_plural'] = 'Formáty údajov';
$string['type_editor'] = 'Editor';
$string['type_editor_plural'] = 'Editory';
$string['type_enrol'] = 'Modul pre riadenie zápisu do kurzu';
$string['type_enrol_plural'] = 'Metódy zápisu';
$string['type_fileconverter'] = 'Konvertor dokumentov';
$string['type_fileconverter_plural'] = 'Konvertory dokumentov';
$string['type_fileconvertermanage'] = 'Správa konvertorov dokumentov';
$string['type_filter'] = 'Textový filter';
$string['type_filter_plural'] = 'Textové filtre';
$string['type_format'] = 'Formát kurzu';
$string['type_format_plural'] = 'Formáty kurzu';
$string['type_gradeexport'] = 'Metóda exportu známok';
$string['type_gradeexport_plural'] = 'Metódy exportu známok';
$string['type_gradeimport'] = 'Metóda importu známok';
$string['type_gradeimport_plural'] = 'Metódy importu známok';
$string['type_gradereport'] = 'Zostava výkazu známok';
$string['type_gradereport_plural'] = 'Zostavy výkazu známok';
$string['type_gradingform'] = 'Pokročilá metóda hodnotenia';
$string['type_gradingform_plural'] = 'Pokročilé metóda hodnotenia';
$string['type_h5plib'] = 'H5P framework';
$string['type_h5plib_plural'] = 'H5P frameworky';
$string['type_local'] = 'Lokálny zásuvný modul';
$string['type_local_plural'] = 'Lokálne rozsírenia';
$string['type_media'] = 'Prehrávač médií';
$string['type_media_plural'] = 'Prehrávače médií';
$string['type_message'] = 'Zásuvný modul oznámení';
$string['type_message_plural'] = 'Zásuvné moduly oznámení';
$string['type_mlbackend'] = 'Strojové učenie na pozadí';
$string['type_mlbackend_plural'] = 'Strojové učenia na pozadí';
$string['type_mnetservice'] = 'Služba MNet';
$string['type_mnetservice_plural'] = 'Služby MNet';
$string['type_mod'] = 'Modul aktivít';
$string['type_mod_plural'] = 'Moduly aktivít';
$string['type_paygw'] = 'Platobná brána';
$string['type_paygw_plural'] = 'Platobné brány';
$string['type_paygwmanage'] = 'Správa platobných brán';
$string['type_plagiarism'] = 'Zásuvný modul prevencie plagiátorstva';
$string['type_plagiarism_plural'] = 'Zásuvné moduly prevencie plagiátorstva';
$string['type_portfolio'] = 'Portfólio';
$string['type_portfolio_plural'] = 'Portfóliá';
$string['type_profilefield'] = 'Typ poľa profilu používateľa';
$string['type_profilefield_plural'] = 'Typ poli profilu používateľa';
$string['type_qbank'] = 'Modul banky otázok';
$string['type_qbank_plural'] = 'Moduly banky otázok';
$string['type_qbehaviour'] = 'Správanie otázky';
$string['type_qbehaviour_plural'] = 'Správanie otázok';
$string['type_qformat'] = 'Formát importu a exportu testových úloh';
$string['type_qformat_plural'] = 'Formáty importu a exportu testových úloh';
$string['type_qtype'] = 'Typ otázky';
$string['type_qtype_plural'] = 'Typy otázok';
$string['type_report'] = 'Zostava portálu';
$string['type_report_plural'] = 'Zostavy';
$string['type_repository'] = 'Úložisko';
$string['type_repository_plural'] = 'Úložiská';
$string['type_search'] = 'Vyhľadávač';
$string['type_search_plural'] = 'Vyhľadávače';
$string['type_theme'] = 'Téma';
$string['type_theme_plural'] = 'Témy';
$string['type_tool'] = 'Administrátorský nástroj';
$string['type_tool_plural'] = 'Administrátorské nástroje';
$string['type_webservice'] = 'Protokol webovej služby';
$string['type_webservice_plural'] = 'Protokoly webových služieb';
$string['uninstall'] = 'Odinštalovať';
$string['uninstallconfirm'] = 'Chystáte sa odinštalovať zásuvný modul <em>{$a->name}</em>. To odstráni v databáze úplne všetko spojené s týmto modulom, vrátane jeho konfigurácie, záznamy logov, používateľské súbory riadené modulom, atď. Neexistuje žiadny spôsob, ako toto vrátiť späť a Moodle sám o sebe nevytvára žiadnu zálohu pre obnovu. Naozaj chcete pokračovať?';
$string['uninstalldelete'] = 'Všetky údaje súvisiace so zásuvným modulom <em>{$a->name}</em>  boli odstránené z databázy. Aby sa zabránilo opätovnej reinštalácii modulu, jeho priečinok <em>{$a->rootdir}</em> musí byť teraz manuálne zo serveru odstránený. Moodle sám o sebe nemôže priečinok odstrániť z dôvodu oprávnení k zápisu.';
$string['uninstalldeleteconfirm'] = 'Všetky údaje spojené so zásuvným modulom <em>{$a->name}</em> boli odstránené z databázy. Pre zamedzenie opätovnej inštalácie modulu, jeho priečinok <em>{$a->rootdir}</em> musí byť odstránený zo serveru. Chcete odstrániť teraz priečinok s modulom?';
$string['uninstalldeleteconfirmexternal'] = 'Zdá se, že aktuálna verzia zásuvného modulu bola získaná pomocou systému správy zdrojového kódu ({$a}). Ak odstránite priečinok s modulom, môžete stratiť dôležité lokálne modifikácie kódu. Prosím, uistite sa, že chcete naozaj odstrániť priečinok s modulom predtým, ako budete pokračovať.';
$string['uninstallextraconfirmblock'] = 'Počet inštancií tohto bloku: {$a->instances}';
$string['uninstallextraconfirmenrol'] = 'Počet zapísaných používateľov: {$a->enrolments}';
$string['uninstallextraconfirmmod'] = 'Celkový počet inštancií tohto modulu: {$a->instances}, počet kurzov obsahujúcich tento modul: {$a->courses}';
$string['uninstalling'] = 'Odinštalovanie {$a->name}';
$string['updateavailable'] = 'Je dostupná nová verzia {$a}!';
$string['updateavailable_moreinfo'] = 'Viac informácií ...';
$string['updateavailable_release'] = 'Verzia {$a}';
$string['updatepluginconfirm'] = 'Potvrdenie aktualizácie modulu';
$string['updatepluginconfirmexternal'] = 'Zdá se, že súčasná verzia zásuvného modulu bola získaná pomocou systému správy zdrojového kódu ({$a}). Ak si nainštalujete túto aktualizáciu, nebudete ďalej môcť získať aktualizácie modulu zo správy zdrojového kódu. Prosím uistite sa, že chcete naozaj nainštalovať túto aktualizáciu, než budete pokračovať.';
$string['updatepluginconfirminfo'] = 'Chystáte sa nainštalovať novú verziu zásuvného modulu <strong>{$a->name}</strong>. ZIP balíček s verziou {$a->version} modulu bude stiahnutý z <a href="{$a->url}">{$a->url}</a> a bude rozbalený do vašej insšalácie Moodle.';
$string['updatepluginconfirmwarning'] = 'Prosím zoberte na vedomie, že Moodle nevytvorí pred aktualizáciou databázy záložnú kópiu. Preto Vám odporúčame, aby ste si teraz rýchlo vytvorili úplnú zálohu databázy a súborov. Tak sa budete môcť vysporiadať s výnimočným prípadom, že nový kód obsahuje chyby, ktoré spôsobia neprístupnosť portálu alebo dokonca poškodia vašu databázu. Pokračujte ďalej na vaše vlastné riziko.';
$string['validationmsg_componentmatch'] = 'Celý názov komponentu';
$string['validationmsg_componentmismatchname'] = 'Nesúlad názvu zásuvného modulu';
$string['validationmsg_componentmismatchname_help'] = 'Niektoré ZIP balíčky, ako sú generované GitHubom, môžu obsahovať nesprávny názov koreňového priečinka Je potrebné opraviť názov koreňového priečinka, aby odpovedal deklarovanému názvu modulu.';
$string['validationmsg_componentmismatchname_info'] = 'Zásuvný modul deklaruje svoj názov ako "{$a}" , ale to neodpovedá názvu jeho priečinka.';
$string['validationmsg_componentmismatchtype'] = 'Nesúlad typu zásuvného modulu';
$string['validationmsg_componentmismatchtype_info'] = 'Vybrali ste typ "{$a->expected}", ale zásuvný modul deklaruje, že je typu "{$a->found}".';
$string['validationmsg_filenotexists'] = 'Rozbalený súbor nebol nájdený';
$string['validationmsg_filesnumber'] = 'V balíčku nebolo nájdených dosť súborov';
$string['validationmsg_filestatus'] = 'Niektoré súbory nie je možné rozbaliť';
$string['validationmsg_filestatus_info'] = 'Pri pokuse o rozbalenie súboru {$a->file} nastala chyba "{$a->status}".';
$string['validationmsg_foundlangfile'] = 'Nájdený jazykový súbor';
$string['validationmsg_maturity'] = 'Deklarovaná úroveň vyspelosti';
$string['validationmsg_maturity_help'] = 'Zásuvný modul môže deklarovať svoju vyspelosť. V prípade, že tvorca považuje modul za stabilný, budeprehlásený s úrovňou MATURITY_STABLE. Všetky ostatné úrovne (napr. alfa alebo beta) by mali byť považované za nestabilné a je vydaná výstraha.';
$string['validationmsg_missingcomponent'] = 'Zásuvný modul nedeklaruje názov svojho komponentu';
$string['validationmsg_missingcomponent_help'] = 'Všetky zásuvné moduly musia poskytnúť svoje celé meno komponentu prostredníctvom deklarácie "$plugin->component" v súbore  version.php.';
$string['validationmsg_missingcomponent_link'] = 'Development:version.php';
$string['validationmsg_missingexpectedlangenfile'] = 'Chyba v názve súboru pre anglický jazyk';
$string['validationmsg_missingexpectedlangenfile_info'] = 'Tento zásuvný modul neobsahuje očakávaný anglický jazykový súbor {$a}.';
$string['validationmsg_missinglangenfile'] = 'Nebol nájdený súbor pre anglický jazyk';
$string['validationmsg_missinglangenfolder'] = 'Chýba adresár pre anglický jazyk';
$string['validationmsg_missingversion'] = 'Zásuvný modul nedeklaruje svoju verziu';
$string['validationmsg_missingversionphp'] = 'Súbor version.php nebol nájdený';
$string['validationmsg_multiplelangenfiles'] = 'Bolo nájdených viacero súborov pre anglický jazyk';
$string['validationmsg_onedir'] = 'Chybná štruktúra ZIP súboru';
$string['validationmsg_onedir_help'] = 'Balíček ZIP musí obsahovať iba jeden koreňový priečinok, ktorý obsahuje kód modulu. Názov tohto koreňového priečinka sa musí zhodovať s názvom modulu.';
$string['validationmsg_pathwritable'] = 'Kontrola prístupu na zápis';
$string['validationmsg_pluginversion'] = 'Verzia zásuvného modulu';
$string['validationmsg_pluginversiontoolow'] = 'Už je nainštalovaná vyššia verzia tohto zásuvného modulu';
$string['validationmsg_release'] = 'Vydanie zásuvného modulu';
$string['validationmsg_requiresmoodle'] = 'Požadovaná verzia Moodle';
$string['validationmsg_rootdir'] = 'Názov inštalovaného zásuvného modulu';
$string['validationmsg_rootdir_help'] = 'Názov koreňového priečinka v balíčku ZIP tvorí názov modulu, ktorý má byť inštalovaný. V prípade, že názov nie je správny, budete možno chcieť premenovať pred inštaláciou zásuvného modulu koreňový priečinok v ZIP .';
$string['validationmsg_rootdirinvalid'] = 'Nesprávny názov zásuvného modulu';
$string['validationmsg_rootdirinvalid_help'] = 'Názov koreňového priečinka v balíčku ZIP porušuje formálne požiadavky syntaxe. Niektoré ZIP balíčky, ako sú tie vygenerované GitHubom, môžu obsahovať nesprávny názov koreňového adresára. Je potrebné opraviť názov koreňového priečinka tak, aby odpovedal názvu modulu.';
$string['validationmsg_targetexists'] = 'Cieľové umiestnenie existuje a bude odstránené';
$string['validationmsg_targetexists_help'] = 'Adresár zásuvného modulu už existuje a bude nahradený obsahom balíčku modulu.';
$string['validationmsg_targetnotdir'] = 'Cieľové umiestnenie obsahuje súbor';
$string['validationmsg_unknowntype'] = 'Neznámy typ zásuvného modulu';
$string['validationmsg_versionphpsyntax'] = 'Bola zistená nepodporovaná syntax v súbore version.php';
$string['validationmsglevel_debug'] = 'Ladenie';
$string['validationmsglevel_error'] = 'Chyba';
$string['validationmsglevel_info'] = 'OK';
$string['validationmsglevel_warning'] = 'Varovanie';
$string['version'] = 'Verzia';
$string['versiondb'] = 'Súčasná verzia';
$string['versiondisk'] = 'Nová verzia';
