<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'es', version '4.2'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Puede previsualizar este cuestionario, pero si éste fuera un intento real, podría ser bloqueado debido a:';
$string['action'] = 'Acción';
$string['activityoverview'] = 'Tiene cuestionarios disponibles';
$string['adaptive'] = 'Modo adaptativo';
$string['adaptive_help'] = 'Si se activa, se permite más de un intento de respuesta a una pregunta dentro del mismo intento de resolver el cuestionario.
Por ejemplo, si una respuesta se marca como incorrecta, el alumno podrá volver a intentarlo de inmediato. Sin embargo, según se establezca  "Aplicar penalizaciones", se restará una penalización por cada intento equivocado.';
$string['add'] = 'Agregar';
$string['addaquestion'] = 'una nueva pregunta';
$string['addarandomquestion'] = 'una pregunta aleatoria';
$string['addarandomquestion_help'] = 'Cuando se añade una pregunta aleatoria, se traduce en que en el cuestionario se inserta una pregunta seleccionada aleatoriamente de entre las que componen la categoría. Esto significa que los distintos alumnos tendrán probablemente una selección distinta de preguntas. Por otra parte, cuando el cuestionario permite múltiples intentos, cada uno de ellos probablemente contendrá una nueva selección de preguntas.';
$string['addarandomselectedquestion'] = 'Agregar una pregunta seleccionada aleatoria ...';
$string['addasection'] = 'un nuevo encabezado para la sección';
$string['adddescriptionlabel'] = 'Agregar una descripción/etiqueta';
$string['addingquestion'] = 'Agregando una pregunta';
$string['addingquestions'] = 'Esta parte de la página es donde puede gestionar su base de datos de preguntas. Las preguntas se agrupan en categorías para obtener una mejor organización, pero pueden ser utilizadas por cualquier cuestionario en su curso o en otro curso si usted decide \'publicarlas\'.<br />Después seleccionar o crear una categoría podrá crear o editar preguntas. Puede seleccionar cualquiera de estas preguntas para agregarlas a su cuestionario en el otro lado de esta página.';
$string['addmoreoverallfeedbacks'] = 'Agregar {no} campos más de retroalimentación';
$string['addnewgroupoverride'] = 'Agregar excepción de grupo';
$string['addnewpagesafterselected'] = 'Agregar nuevas páginas después de las preguntas seleccionadas';
$string['addnewquestionsqbank'] = 'Agregar preguntas a la categoría {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Agregar excepción de usuario';
$string['addpagebreak'] = 'Añadir salto de página';
$string['addpagehere'] = 'Agregar una página aquí';
$string['addquestion'] = 'Agregar pregunta';
$string['addquestionfrombankatend'] = 'Añadir del banco de preguntas al final';
$string['addquestionfrombanktopage'] = 'Agregar del banco de preguntas a la página {$a}';
$string['addquestions'] = 'Agregar preguntas';
$string['addquestionstoquiz'] = 'Agregar preguntas al presente cuestionario';
$string['addrandom'] = 'Agregar {$a} preguntas aleatorias';
$string['addrandom1'] = '<< Agregar';
$string['addrandom2'] = 'preguntas aleatorias';
$string['addrandomfromcategory'] = 'Agregar preguntas aleatorias de la categoría:';
$string['addrandomquestion'] = 'Agregar pregunta aleatoria';
$string['addrandomquestionatend'] = 'Añadir una pregunta aleatoria al final';
$string['addrandomquestiontopage'] = 'Añadir una pregunta aleatoria a la página {$a}';
$string['addrandomquestiontoquiz'] = 'Agregar pregunta aleatoria al cuestionario {$a}';
$string['addselectedquestionstoquiz'] = 'Añadir preguntas seleccionadas para el cuestionario';
$string['addselectedtoquiz'] = 'Agregar al cuestionario';
$string['addtoquiz'] = 'Añadir a cuestionario';
$string['affectedstudents'] = '{$a} afectados';
$string['aftereachquestion'] = 'Después de agregar cada pregunta';
$string['afternquestions'] = 'Después de agregar {$a} preguntas';
$string['age'] = 'edad';
$string['allattempts'] = 'Todos los intentos';
$string['allinone'] = 'Sin límite';
$string['allowreview'] = 'Permitir revisión';
$string['alreadysubmitted'] = 'Parece que usted ya respondió este cuestionario';
$string['alternativeunits'] = 'Unidades alternativas';
$string['alwaysavailable'] = 'Siempre disponible';
$string['alwayslatest'] = 'Siempre el último';
$string['analysisoptions'] = 'Opciones de análisis';
$string['analysistitle'] = 'Tabla de análisis de elementos';
$string['answer'] = 'Respuesta';
$string['answered'] = 'Contestadas';
$string['answerhowmany'] = '¿Una o varias respuestas?';
$string['answers'] = 'Soluciones -';
$string['answersingleno'] = 'Se permiten varias respuestas';
$string['answersingleyes'] = 'Sólo una respuesta';
$string['answertoolong'] = 'Respuesta demasiado larga después de la línea {$a} (máx. 255 caracteres)';
$string['anytags'] = 'Cualquier etiqueta';
$string['aon'] = 'Formato AON';
$string['areyousureremoveselected'] = '¿Está seguro de que quiere eliminar todas las preguntas seleccionadas?';
$string['asshownoneditscreen'] = 'Tal como se muestra en la pantalla de edición';
$string['attempt'] = 'Intento {$a}';
$string['attemptalreadyclosed'] = 'Este intento ya ha sido finalizado.';
$string['attemptclosed'] = 'El intento aún no está cerrado';
$string['attemptduration'] = 'Tiempo requerido';
$string['attemptedon'] = 'Intentado el';
$string['attempterror'] = 'No tiene autorización para intentar resolver este cuestionario debido a: {$a}';
$string['attempterrorcontentchange'] = 'Esta vista previa del cuestionario ya no existe. (Cuando se edita un cuestionario, cualquier vista previa en curso se borra automáticamente).';
$string['attempterrorcontentchangeforuser'] = 'Este intento de examen ya no existe.';
$string['attempterrorinvalid'] = 'Identificador del intento de cuestionario no válido';
$string['attemptfirst'] = 'Primer intento';
$string['attemptgradeddelay'] = 'Retraso antes de enviar notificaciones de intento calificado';
$string['attemptgradeddelay_desc'] = 'Se aplica un retraso antes de enviar un correo electrónico al estudiante para dar tiempo al profesor para editar la calificación.';
$string['attemptincomplete'] = 'Este intento (de {$a}) no se ha completado aún.';
$string['attemptlast'] = 'Último intento';
$string['attemptnumber'] = 'Intento';
$string['attemptquiz'] = 'Intento de cuestionario';
$string['attemptquiznow'] = 'Intente resolver el cuestionario ahora';
$string['attemptreviewtitle'] = '{$a}: Revisión del intento';
$string['attemptreviewtitlepaged'] = '{$a->name}: Revisión del intento (página {$a->currentpage} de {$a->totalpages})';
$string['attempts'] = 'Intentos';
$string['attempts_help'] = 'El número total de intentos permitidos (no el número de intentos adicionales).';
$string['attemptsallowed'] = 'Intentos permitidos';
$string['attemptsdeleted'] = 'Eliminados intentos de resolver el cuestionario';
$string['attemptselection'] = 'Seleccionar qué intentos analizar por usuario:';
$string['attemptsexist'] = 'Ya ha intentado contestar este cuestionario';
$string['attemptsnum'] = 'Intentos: {$a}';
$string['attemptsnumthisgroup'] = 'Intentos: {$a->total} ({$a->group} de este grupo)';
$string['attemptsnumyourgroups'] = 'Intentos: {$a->total} ({$a->group} de sus grupos)';
$string['attemptsonly'] = 'Mostrar solamente estudiantes con intentos';
$string['attemptstate'] = 'Estado';
$string['attemptstillinprogress'] = 'Intento aún en curso';
$string['attemptsummarytitle'] = '{$a}: Resumen del intento';
$string['attemptsunlimited'] = 'Intentos ilimitados';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (página {$a->currentpage} de {$a->totalpages})';
$string['autosaveperiod'] = 'Retardo de guardado automático';
$string['autosaveperiod_desc'] = 'Las respuestas de los estudiantes se pueden guardar automáticamente durante los intentos del cuestionario. Las respuestas se guardan cada vez que se cambie una, y entonces tras este lapso. Hay una contraprestación: un lapso menor aumenta la carga del servidor, pero reduce la probabilidad de que los estudiantes pierdan su trabajo.
Si usted va a hacer este lapso mucho más breve, debería cambiarlo gradualmente y monitorizar la carga del servidor. Si la carga es demasiado alta, amplíe el lapso de nuevo. Ajustarlo a 0 lo deja en modo de guardado automático.';
$string['back'] = 'Volver a la vista previa de la pregunta';
$string['backtocourse'] = 'Volver al curso';
$string['backtoquestionlist'] = 'Volver a lista de preguntas';
$string['backtoquiz'] = 'Volver a la edición de cuestionarios';
$string['basicideasofquiz'] = 'Ideas básicas sobre la realización del cuestionario';
$string['bestgrade'] = 'Calificación máxima';
$string['bothattempts'] = 'Mostrar estudiantes con y sin intentos';
$string['browsersecurity'] = 'Seguridad del navegador';
$string['browsersecurity_help'] = 'Si está seleccionada la "Pantalla completa emergente con cierta seguridad JavaScript",

* El cuestionario sólo se iniciará si el estudiante tiene un navegador con JavaScript activado
* El cuestionario aparece en una ventana emergente  a pantalla completa que cubre todas las otras ventanas y no tiene controles de navegación
* Se impide a los estudiantes, en la medida de lo posible, el uso de acciones como copiar y pegar';
$string['cachedef_overrides'] = 'Información de anulación de usuarios y grupos';
$string['calculated'] = 'Calculadas';
$string['calculatedquestion'] = 'La pregunta calculada no se admite en la línea {$a}. La pregunta será ignorada';
$string['cannotcreatepath'] = 'No se puede crear la ruta ({$a})';
$string['cannoteditafterattempts'] = 'No puede agregar o quitar preguntas porque este cuestionario ya ha sido respondido. ({$a})';
$string['cannotfindprevattempt'] = 'No se puede encontrar un intento previo en el que basarse';
$string['cannotfindquestionregard'] = 'Error al intentar conseguir preguntas para recalificación.';
$string['cannotinsert'] = 'No se puede insertar pregunta';
$string['cannotinsertrandomquestion'] = 'No se pudo insertar una nueva pregunta aleatoria.';
$string['cannotloadquestion'] = 'No se pudieron cargar las opciones de pregunta';
$string['cannotloadtypeinfo'] = 'Imposible cargar información sobre pregunta específica';
$string['cannotopen'] = 'No se puede exportar el archivo ({$a})';
$string['cannotremoveallsectionslots'] = 'Ha seleccionado todas las preguntas bajo el encabezado de la sección \'{$a}\'. No está permitido eliminar todas las preguntas de un título de sección.';
$string['cannotremoveslots'] = 'No se pueden eliminar las preguntas';
$string['cannotrestore'] = 'Imposible restaurar sesiones de pregunta';
$string['cannotreviewopen'] = 'No puede revisar este intento: aún está abierto.';
$string['cannotsavelayout'] = 'Imposible guardar el esquema';
$string['cannotsavenumberofquestion'] = 'Imposible guardar el número de preguntas por página';
$string['cannotsavequestion'] = 'No se pudo guardar la lista de preguntas';
$string['cannotsetgrade'] = 'No se pudo ajustar una nueva calificación máxima para el cuestionario';
$string['cannotsetsumgrades'] = 'No se pudo ajustar la suma de calificaciones';
$string['cannotstartgradesmismatch'] = 'No se puede iniciar un intento de resolver este cuestionario. Este cuestionario está configurado para ser calificado hasta {$a->grade}, pero ninguna de las preguntas tienen una calificación. Esto se puede solucionar en la página \'Editar cuestionario\'';
$string['cannotstartmissingquestion'] = 'No se puede iniciar el intento de resolver el cuestionario. La definición del cuestionario incluye una pregunta que no existe.';
$string['cannotstartnoquestions'] = 'No se puede iniciar un intento en este cuestionario. El cuestionario aún no se ha construido. Todavía no se han añadido las preguntas.';
$string['cannotwrite'] = 'No se puede escribir al archivo exportado ({$a})';
$string['canredoquestions'] = 'Habilitar la opción de rehacer en un intento';
$string['canredoquestions_desc'] = 'Si esta opción está habilitada, cuando los estudiantes hayan terminado de realizar un intento en una pregunta concreta, verán un botón de interrogación denominado "Probar otra pregunta similar". Este botón les permitirá realizar un intento con una versión similar de la misma pregunta (seleccionada aleatoriamente), o la misma pregunta otra vez, sin tener que enviar el intento del cuestionario completo e iniciar uno nuevo. Esta opción resulta útil principalmente para los cuestionarios de práctica.

Esta configuración solo afecta a las preguntas (p. ej., las preguntas que no sean ensayos) y las actuaciones (por ejemplo, los comentarios inmediatos o los interactivos con múltiples intentos) en las que el estudiante puede finalizar la pregunta antes de que se envíe el intento.';
$string['canredoquestions_help'] = 'Si esta opción está habilitada, cuando los estudiantes hayan terminado de realizar un intento en una pregunta concreta, verán un botón de interrogación denominado "Probar otra pregunta similar". Este botón les permitirá realizar un intento con otra versión de la misma pregunta sin tener que enviar el intento del cuestionario completo e iniciar uno nuevo. Esta opción resulta útil principalmente para los cuestionarios de práctica.

Esta configuración solo afecta a las preguntas (p. ej., las preguntas que no sean ensayos) y las actuaciones (por ejemplo, los comentarios inmediatos o los interactivos con múltiples intentos) en las que el estudiante puede finalizar la pregunta antes de que se envíe el intento.';
$string['canredoquestionsyes'] = 'Sí, proporcionar la opción de intentar otra pregunta';
$string['caseno'] = 'Igual mayúsculas que minúsculas';
$string['casesensitive'] = 'Diferencia entre mayúsculas y minúsculas';
$string['caseyes'] = 'Mayúsculas y minúsculas deben coincidir';
$string['categoryadded'] = 'Se añadió la categoría \'{$a}\'';
$string['categorydeleted'] = 'Se eliminó la categoría\'{$a}\'';
$string['categorynoedit'] = 'You do not have editing privileges in the category \'{$a}\'.';
$string['categoryupdated'] = 'Categoría actualizada con éxito';
$string['close'] = 'Cerrar vista previa';
$string['closebeforeopen'] = 'No se pudo actualizar el cuestionario: la fecha de cierre es anterior a la de apertura.';
$string['closed'] = 'Cerrado';
$string['closepreview'] = 'Cerrar vista previa';
$string['closereview'] = 'Cerrar revisión';
$string['comment'] = 'Comentario';
$string['commentorgrade'] = 'Hacer comentario o evitar calificación';
$string['comments'] = 'Comentarios';
$string['completedon'] = 'Finalizado en';
$string['completionattemptsexhausted'] = 'O todos los intentos disponibles completados';
$string['completionattemptsexhausted_help'] = 'Marcar el cuestionario como completo cuando el estudiante haya agotado el máximo número de intentos.';
$string['completionattemptsexhausteddesc'] = 'Completar si se agotan todos los intentos disponibles';
$string['completiondetail:minattempts'] = 'Hacer intentos: {$a}';
$string['completiondetail:passgrade'] = 'Recibir una calificación aprobatoria';
$string['completiondetail:passorexhaust'] = 'Recibir una calificación aprobatoria o completar todos los intentos disponibles';
$string['completionminattempts'] = 'Número mínimo de intentos:';
$string['completionminattemptsdesc'] = 'Número mínimo de intentos requerido: {$a}';
$string['completionminattemptserror'] = 'El número mínimo de intentos debe ser menor o igual a los intentos permitidos.';
$string['completionminattemptsgroup'] = 'Intentos requeridos';
$string['completionpass'] = 'Requerir calificación aprobatoria';
$string['completionpass_help'] = 'Si está habilitado, esta actividad se considera completa cuando el estudiante recibe una calificación de aprobado (tal y como se especifica en la sección de Calificación de los ajustes del cuestionario) o superior.';
$string['completionpassdesc'] = 'El estudiante debe obtener una calificación aprobatoria para completar esta actividad';
$string['completionpassorattemptsexhausteddesc'] = 'El estudiante debe alcanzar una calificación de aprobado o agotar todos los intentos disponibles para completar esta actividad';
$string['configadaptive'] = 'Si selecciona Sí en esta opción, el estudiante podrá dar múltiples respuestas a una pregunta incluso dentro del mismo intento de resolver el cuestionario.';
$string['configattemptsallowed'] = 'Restricción del número de intentos que los estudiantes tienen para resolver el cuestionario.';
$string['configdecimaldigits'] = 'Número de dígitos a mostrar después del punto decimal cuando se muestran las calificaciones.';
$string['configdecimalplaces'] = 'Número de dígitos a mostrar después del punto decimal cuando se muestren las calificaciones del cuestionario.';
$string['configdecimalplacesquestion'] = 'Número de dígitos a mostrar después de la coma decimal cuando se muestren las calificaciones de las preguntas individuales.';
$string['configdelay1'] = 'Si ajusta una demora, el estudiante deberá esperar ese tiempo antes de que pueda intentar resolver el cuestionario tras el primer intento.';
$string['configdelay1st2nd'] = 'Si aquí se fija un tiempo de demora, el estudiante no puede comenzar su segundo intento hasta que haya transcurrido ese tiempo después de terminar su primer intento.';
$string['configdelay2'] = 'Si establece aquí una demora, el estudiante tendrá que esperar ese tiempo antes de efectuar su tercer intento (o posteriores) de resolver el cuestionario.';
$string['configdelaylater'] = 'Si aquí se fija un tiempo de demora, el estudiante no puede comenzar su tercero, cuarto... intento hasta que haya transcurrido ese tiempo después de terminar su anterior intento.';
$string['configeachattemptbuildsonthelast'] = 'Si se permiten múltiples intentos, cada nuevo intento contendrá los resultados del intento previo.';
$string['configgrademethod'] = 'Método que se usará para calcular la calificación final del estudiante en el cuestionario cuando se permiten múltiples intentos.';
$string['configintro'] = 'Los valores que especifique aquí definen los valores por defecto usados en el formulario de especificaciones cuando usted crea un nuevo cuestionario. Puede asimismo configurar qué ajustes de cuestionario se consideran avanzados.';
$string['configmaximumgrade'] = 'Valor por defecto a la que se ajustará la calificación del cuestionario.';
$string['confignavmethod'] = 'En navegación libre, las preguntas pueden ser contestadas en cualquier orden utilizando la navegación. En navegación secuencial, las preguntas deben ser contestadas en la secuencia establecida.';
$string['confignewpageevery'] = 'Cuando se agregan preguntas al cuestionario, los saltos de página se insertarán automáticamente de acuerdo con el valor que elija aquí.';
$string['configoutcomesadvanced'] = 'Si esta opción está activada, entonces los resultados en el formulario del cuestionario serán los de los ajustes avanzados.';
$string['configpenaltyscheme'] = 'Penalización sustraída por cada respuesta errónea en el modo adaptativo.';
$string['configpopup'] = 'Usar \'tricks\' de JavaScript para tratar de restringir copiar y pegar, etc., durante los intentos de resolver este cuestionario.';
$string['configrequirepassword'] = 'Los estudiantes deben escribir su contraseña antes de intentar resolver el cuestionario.';
$string['configrequiresubnet'] = 'Los estudiantes únicamente pueden intentar resolver el cuestionario desde estos ordenadores.';
$string['configreviewoptions'] = 'Estas opciones controlan qué información pueden ver los usuarios cuando revisan un intento de resolver el cuestionario o cuando examinan los informes del cuestionario.';
$string['configshowblocks'] = 'Mostrar bloques durante los intentos de responder al cuestionario.';
$string['configshowuserpicture'] = 'Mostrar en pantalla la imagen del usuario durante los intentos.';
$string['configshufflewithin'] = 'Si habilita esta opción, las respuestas se ordenarán al azar cada vez que un estudiante intente resolver este cuestionario, en el supuesto de que la opción esté también habilitada en los ajustes de la pregunta.';
$string['configtimelimit'] = 'Tiempo límite por defecto en minutos. 0 significa que no hay límite de tiempo.';
$string['configtimelimitsec'] = 'Tiempo límite (en segundos) predeterminado para resolver los cuestionarios. \'0\' significa que no hay límite de tiempo.';
$string['configurerandomquestion'] = 'Configurar pregunta';
$string['confirmclose'] = 'Una vez que haga el envío, no podrá cambiar sus respuestas de este intento de resolver el cuestionario..';
$string['confirmremovequestion'] = '¿Seguro que quieres eliminar esta pregunta de tipo {$a}?';
$string['confirmremovesectionheading'] = '¿Está seguro de que desea eliminar el encabezado de la sección \'{$a}\'?';
$string['confirmserverdelete'] = '¿Está seguro de que desea eliminar el servidor  <b>{$a}</b> de la lista?';
$string['connectionerror'] = 'La conexión de red se ha perdido. (Ha fallado el guardado automático).

Anote las respuestas introducidas en esta página en los últimos minutos, y trate de volver a conectarse.

Una vez que la conexión se haya restablecido, sus respuestas deben ser guardados y este mensaje desaparecerá.';
$string['connectionok'] = 'La conexión de red se ha recuperado. Puede continuar de forma segura.';
$string['containercategorycreated'] = 'Esta categoría se ha creado para almacenar todas las categorías originales trasladadas al sitio debido a causas especificadas más abajo.';
$string['continueattemptquiz'] = 'Continuar el último intento';
$string['continuepreview'] = 'Continuar la previsualización anterior';
$string['copyingfrom'] = 'Creando una copia de la pregunta \'{$a}\'';
$string['copyingquestion'] = 'Copiando una pregunta';
$string['correct'] = 'Correcto';
$string['correctanswer'] = 'Respuesta correcta';
$string['correctanswerformula'] = 'Fórmula para calcular la respuesta correcta';
$string['correctansweris'] = 'Respuesta correcta: {$a}';
$string['correctanswerlength'] = 'Cifras significativas';
$string['correctanswers'] = 'Respuestas correctas';
$string['correctanswershows'] = 'La respuesta correcta muestra';
$string['corrresp'] = 'Respuesta correcta';
$string['countdown'] = 'Cuenta atrás';
$string['countdownfinished'] = 'Este cuestionario se está cerrando, debe enviar sus respuestas ahora.';
$string['countdowntenminutes'] = 'El cuestionario se cerrará en diez minutos.';
$string['coursetestmanager'] = 'Formato de Administración de Test de Curso';
$string['createcategoryandaddrandomquestion'] = 'Crear la categoría y añadir pregunta aleatoria';
$string['createfirst'] = 'Antes debe crear algunas preguntas de respuesta corta.';
$string['createmultiple'] = 'Añadir varias preguntas aleatorias al cuestionario';
$string['createnewquestion'] = 'Crear una pregunta nueva';
$string['createquestionandadd'] = 'Crear una nueva pregunta y agregarla al cuestionario.';
$string['custom'] = 'Formato personalizado';
$string['dataitemneed'] = 'Necesita agregar al menos un conjunto de ítems para obtener una pregunta válida';
$string['datasetdefinitions'] = 'Definiciones reutilizables del conjunto de datos para la categoría {$a}';
$string['datasetnumber'] = 'Número';
$string['daysavailable'] = 'Días disponible';
$string['decimaldigits'] = 'Número de decimales en calificaciones';
$string['decimalplaces'] = 'Decimales en las calificaciones';
$string['decimalplaces_help'] = 'Esta opción especifica el número de decimales mostrados en la calificación de cada intento. Sólo afecta a la visualización de las calificaciones, no a las notas almacenadas en la base de datos, ni a los cálculos internos, que son realizados con la máxima precisión.';
$string['decimalplacesquestion'] = 'Decimales en las calificaciones de las preguntas';
$string['decimalplacesquestion_help'] = 'Número de decimales mostrados después de la coma decimal cuando se muestren las calificaciones de preguntas individuales.';
$string['decimalpoints'] = 'Puntos decimales';
$string['default'] = 'Por defecto';
$string['defaultgrade'] = 'Calificación por defecto de la pregunta';
$string['defaultinfo'] = 'Categoría por defecto para las preguntas.';
$string['delay1'] = 'Tiempo entre el primer y el segundo intento';
$string['delay1st2nd'] = 'Forzar demora entre los intentos primero y segundo';
$string['delay1st2nd_help'] = '<p>Si especifica un lapso de tiempo, el estudiante tendrá que esperar ese tiempo antes de poder volver a contestar el cuestionario después del primer intento.</p>';
$string['delay2'] = 'Tiempo entre los intentos posteriores';
$string['delaylater'] = 'Forzar demora entre intentos posteriores';
$string['delaylater_help'] = '<p>Si especifica un lapso de tiempo, el estudiante tendrá que esperar a que transcurra ese tiempo antes de poder intentar contestar el cuestionario por tercera vez o en lo sucesivo.</p>';
$string['deleteattemptcheck'] = '¿Está totalmente seguro que quiere borrar definitivamente estos intentos?';
$string['deleteselected'] = 'Eliminar seleccionados';
$string['deletingquestionattempts'] = 'Eliminando intentos de resolver el cuestionario';
$string['description'] = 'Descripción';
$string['disabled'] = 'Deshabilitado';
$string['displayoptions'] = 'Mostrar opciones';
$string['donotuseautosave'] = 'No use guardado automático';
$string['download'] = 'Haga clic para descargar el archivo de categorías exportadas';
$string['downloadextra'] = '(el archivo se almacena también en el directorio /quiz de archivos del curso)';
$string['dragtoafter'] = 'Después de {$a}';
$string['dragtostart'] = 'Para el inicio';
$string['duplicateresponse'] = 'Este envío ha sido pasado por alto debido a que usted dio una respuesta equivalente con anterioridad.';
$string['eachattemptbuildsonthelast'] = 'Cada intento se basa en el anterior';
$string['eachattemptbuildsonthelast_help'] = '<p>Si se permiten varios intentos y se selecciona <B>Sí</B>, cada nuevo intento contendrá el resultado del anterior. Esto permite completar un cuestionario haciendo varios intentos partiendo en cada uno del resultado anterior.</p>
';
$string['edit_slotdisplaynumber_hint'] = 'Editar número de pregunta (máximo 16 caracteres)';
$string['edit_slotdisplaynumber_label'] = 'Nuevo valor para {$a}';
$string['editcategories'] = 'Editar categorías';
$string['editcategory'] = 'Editar categoría';
$string['editcatquestions'] = 'Editar preguntas categóricas';
$string['editingquestion'] = 'Editando pregunta';
$string['editingquiz'] = 'Editando cuestionario';
$string['editingquiz_help'] = 'Cuando se crea un cuestionario, los conceptos básicos son:

* El cuestionario, que contiene preguntas en una o más páginas
* El banco de preguntas, que almacena copias de todas las preguntas organizadas en categorías
* Preguntas aleatorias: Cada vez que se intenta resolver el cuestionario aparecen preguntas diferentes (cada uno de los estudiantes debe contestar preguntas diferentes)';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Editando cuestionario: {$a}';
$string['editmaxmark'] = 'Editar marca de máximo';
$string['editoverride'] = 'Anular edición';
$string['editqcats'] = 'Editar categorías de preguntas';
$string['editquestion'] = 'Editar pregunta';
$string['editquestions'] = 'Editar preguntas';
$string['editquiz'] = 'Editar cuestionario';
$string['editquizquestions'] = 'Editar preguntas del cuestionario';
$string['emailconfirmautosubmitsmall'] = 'Gracias por enviar sus respuestas a \'{$a->quizname}\'';
$string['emailconfirmbody'] = 'Hola, {$a->username},

Gracias por enviar sus respuestas al cuestionario \'{$a->quizname}\' del curso \'{$a->coursename}\' a las {$a->submissiontime}.

Este correo confirma que sus respuestas han sido guardadas.

Puede acceder a este cuestionario en {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Hola, {$a->username}:

El tiempo para el cuestionario \'{$a->quizname}\' en el curso \'{$a->coursename}\' expiró. Sus respuestas se enviaron automáticamente a las {$a->submittime}.

Este mensaje confirma que se han guardado sus respuestas.

Puede acceder a este cuestionario en {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Gracias por enviar sus respuestas a  \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Confirmación del envío: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Hola {$a->studentname},

Sus respuestas a \'{$a->quizname}\' en el curso \'{$a->coursename}\' realizado el {$a->attempttimefinish} ahora han sido calificadas.

Podrá ver su puntuación y comentarios visitando \'{$a->quizurl}\' y revisando su intento.';
$string['emailmanualgradedsubject'] = 'Su intento en {$a->quizname} ha sido calificado';
$string['emailnotifybody'] = 'Hola {$a->username},

{$a->studentname} ha completado el cuestionario \'{$a->quizname}\' ({$a->quizurl}) del curso \'{$a->coursename}\'

Puede revisar este intento en {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} ha completado {$a->quizname}. Ver en {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} ha completado {$a->quizname}';
$string['emailoverduebody'] = 'Hola {$a->studentname},

Comenzó un intento en \'{$a->quizname}\' en el curso \'{$a->coursename}\', pero nunca lo envió. Debería haber sido enviado antes de {$a->attemptduedate}.

Si todavía desea enviar este intento, por favor vaya a {$a->attemptsummaryurl} y haga clic en el botón de envío. Debe hacerlo antes de {$a->attemptgraceend}, de lo contrario su intento no se contabilizará.';
$string['emailoverduesmall'] = 'Usted no envió su intento de {$a->quizname}. Por favor, vaya a {$a->attemptsummaryurl} antes de {$a->attemptgraceend} si usted todavía desea enviarlo.';
$string['emailoverduesubject'] = 'Intento caducado: {$a->quizname}';
$string['empty'] = 'Vacío';
$string['enabled'] = 'Habilitado';
$string['endtest'] = 'Terminar intento...';
$string['erroraccessingreport'] = 'No puede acceder a este informe';
$string['errorinquestion'] = 'Error en la pregunta';
$string['errormissingquestion'] = 'Error: el sistema ha perdido la pregunta con id {$a}';
$string['errornotnumbers'] = 'Error - las respuestas deben ser numéricas';
$string['errorunexpectedevent'] = 'Código de evento inesperado {$a->event} encontrado en la pregunta {$a->questionid} en el intento {$a->attemptid}.';
$string['essay'] = 'Ensayo';
$string['essayquestions'] = 'Preguntas';
$string['eventattemptautosaved'] = 'Intento de cuestionario guardado automáticamente';
$string['eventattemptdeleted'] = 'Intento del cuestionario eliminado';
$string['eventattemptmanualgradingcomplete'] = 'Calificación manual del intento de cuestionario completada';
$string['eventattemptpreviewstarted'] = 'Vista previa del intento iniciada';
$string['eventattemptquestionrestarted'] = 'Pregunta de intento de cuestionario reiniciada';
$string['eventattemptreviewed'] = 'Intento del cuestionario revisado';
$string['eventattemptsummaryviewed'] = 'Resumen del intento de cuestionario visualizado';
$string['eventattemptupdated'] = 'Intento de cuestionario actualizado';
$string['eventattemptviewed'] = 'Intento de cuestionario visualizado';
$string['eventeditpageviewed'] = 'Página de edición del cuestionario visitada';
$string['eventoverridecreated'] = 'Excepción de cuestionario creada';
$string['eventoverridedeleted'] = 'Anulación de cuestionario eliminada';
$string['eventoverrideupdated'] = 'Anulación de cuestionario actualizada';
$string['eventpagebreakcreated'] = 'Salto de página creado';
$string['eventpagebreakdeleted'] = 'Salto de página eliminado';
$string['eventquestionmanuallygraded'] = 'Pregunta calificada manualmente';
$string['eventquizattemptabandoned'] = 'Intento abandonado';
$string['eventquizattemptregraded'] = 'Intento de cuestionario recalificado';
$string['eventquizattemptreopened'] = 'Intento de cuestionario reabierto';
$string['eventquizattemptstarted'] = 'Ha comenzado el intento';
$string['eventquizattemptsubmitted'] = 'Intento enviado';
$string['eventquizattempttimelimitexceeded'] = 'Tiempo límite del cuestionario excedido';
$string['eventquizgradeupdated'] = 'Calificación del cuestionario actualizada';
$string['eventquizrepaginated'] = 'Cuestionario re-paginado';
$string['eventreportviewed'] = 'Informe de cuestionario visto';
$string['eventsectionbreakcreated'] = 'Salto de sección creado';
$string['eventsectionbreakdeleted'] = 'Salto de sección eliminado';
$string['eventsectionshuffleupdated'] = 'Mezcla aleatoria de secciones actualizada';
$string['eventsectiontitleupdated'] = 'Título de sección actualizado';
$string['eventslotcreated'] = 'Creada ranura';
$string['eventslotdeleted'] = 'Ranura eliminada';
$string['eventslotdisplayedquestionnumberupdated'] = 'Puesto donde mostrar el número de la pregunta actualizado';
$string['eventslotmarkupdated'] = 'Marca de espacio actualizada';
$string['eventslotmoved'] = 'Espacio movido';
$string['eventslotrequirepreviousupdated'] = 'El espacio necesita una actualización previa';
$string['everynquestions'] = 'Cada {$a} preguntas';
$string['everyquestion'] = 'Cada pregunta';
$string['everythingon'] = 'Todo activado';
$string['existingcategory'] = 'Categoría existente';
$string['exportcategory'] = 'categoría de exportación';
$string['exporterror'] = 'Ocurrió un error durante el procesamiento de la exportación';
$string['exportingquestions'] = 'Se están exportando las preguntas al archivo';
$string['exportname'] = 'Nombre del archivo';
$string['exportquestions'] = 'Exportar preguntas a un archivo';
$string['extraattemptrestrictions'] = 'Restricciones extra sobre los intentos';
$string['false'] = 'Falso';
$string['feedback'] = 'Comentario -';
$string['feedbackerrorboundaryformat'] = 'Los límites de la calificación de la retroalimentación deben ser un porcentaje o un número. El valor introducido en el límite {$a} no ha sido reconocido.';
$string['feedbackerrorboundaryoutofrange'] = 'Los límites de la calificación de la retroalimentación deben estar entre 0% y 100%. El valor introducido en el límite {$a} está fuera de límites.';
$string['feedbackerrorjunkinboundary'] = 'Debe rellenar las casillas de los límites de la calificación de la retroalimentación sin dejar huecos.';
$string['feedbackerrorjunkinfeedback'] = 'Debe rellenar las casillas de retroalimentación sin dejar huecos.';
$string['feedbackerrororder'] = 'Los límites de los grados de retroalimentación deben estar en orden, los más altos primero. El valor que introdujo en el límite {$a} está fuera de secuencia.';
$string['file'] = 'Archivo';
$string['fileformat'] = 'Formato de archivo';
$string['fillcorrect'] = 'Rellene con la opción correcta';
$string['filloutnumericalanswer'] = 'Usted proporciona al menos una posible respuesta y la tolerancia. La primera respuesta de coincidencias se utiliza para determinar la calificación y la retroalimentación. Si usted proporciona alguna retroalimentación sin respuesta en el final, este se mostrará a los estudiantes cuya respuesta no se corresponda con ninguna de las otras respuestas .';
$string['filloutoneanswer'] = 'Debe llenar al menos una respuesta posible. Las respuestas en blanco no serán utilizadas. El asterisco "*" se puede usar como un comodín para cualquier carácter. La primera respuesta que coincida se usará para determinar la calificación y la retroalimentación';
$string['filloutthreequestions'] = 'Debe llenar al menos tres preguntas. Las que deje en blanco no serán utilizadas.';
$string['fillouttwochoices'] = 'Debe elegir al menos dos opciones. Las opciones en blanco no serán utilizadas.';
$string['finishattemptdots'] = 'Terminar intento...';
$string['finishreview'] = 'Finalizar revisión';
$string['forceregeneration'] = 'forzar regeneración';
$string['formatnotfound'] = 'No se encuentra el formato {$a} de exportación/importación';
$string['formulaerror'] = 'Errores en la fórmula.';
$string['fractionsaddwrong'] = 'Las calificaciones positivas otorgadas no suman 100% sino {$a}%<br />¿Desea regresar y corregir esta pregunta?';
$string['fractionsnomax'] = 'Una de las preguntas debe ser 100% para que sea<br />posible alcanzar la calificación máxima<br />¿Desea regresar y corregir esta pregunta?';
$string['fromfile'] = 'desde archivo:';
$string['functiondisabledbysecuremode'] = 'Esta funcionalidad está actualmente deshabilitada';
$string['generalfeedback'] = 'Retroalimentación general';
$string['generalfeedback_help'] = '<p>La retroalimentación general sobre las preguntas es un texto que se muestra al estudiante una vez que ha intentado responder a una pregunta. A diferencia de la retroalimentación, que depende del tipo de pregunta y de la respuesta dada por el estudiante, aquí se muestra el mismo texto de retroalimentación general a todos los estudiantes.</p>

<p>Usted puede controlar cuándo se muestra a los estudiantes la retroalimentación general utilizando las casillas de verificación "Los estudiantes pueden revisar:" del formulario de edición del cuestionario.</p>

<p>Puede usar la retroalimentación general para dar a los estudiantes información sobre qué conocimientos tratan de comprobar las preguntas, o bien para suministrarles un enlace a más información que podrían usar en el caso de no entender las preguntas.</p>';
$string['gobacktoquiz'] = 'Ir atrás';
$string['graceperiod'] = 'Periodo de gracia para el envío';
$string['graceperiod_desc'] = 'Si se configura que cuando se agote el tiempo a "Hay un período de gracia para enviar el intento, pero no pueden cambiarse las respuestas", esta es la cantidad por defecto de tiempo extra que se permite, en segundos. 300 = 5 minutos; 86400 = 24 horas.';
$string['graceperiod_help'] = 'Si lo que se debe hacer cuando expire el tiempo se establece en "Hay un período de gracia ...", entonces esta es la cantidad de tiempo adicional que se permite.';
$string['graceperiodmin'] = 'Ultimo periodo de gracia para el envío';
$string['graceperiodmin_desc'] = 'Existe un problema potencial al final de la realización de los cuestionarios. Por un lado, queremos permitir a los estudiantes que trabajen hasta el último segundo de la prueba (con la ayuda del temporizador que envía automáticamente el cuestionario cuando finaliza el tiempo). Por otra parte, el servidor puede estar sobrecargado y entonces tardar algún tiempo para procesar las respuestas. Por lo tanto, aceptaremos las respuestas enviadas este número de segundos después de que el tiempo haya expirado, por lo que no se producirán sanciones por causa de un servidor lento. Sin embargo, el estudiante puede engañarnos y utilizar estos segundos extras para seguir contestando el cuestionario. Usted debe establecer el valor de esta compensación en función del nivel de confianza que tenga en el rendimiento del servidor durante la realización de los cuestionarios.';
$string['graceperiodtoosmall'] = 'El periodo de gracia debe se mayor que {$a}';
$string['grade'] = 'Calificación';
$string['gradeall'] = 'Calificar todo';
$string['gradeaverage'] = 'Promedio de calificaciones';
$string['gradeboundary'] = 'Límites de calificación';
$string['gradeessays'] = 'Calificar ensayos';
$string['gradehighest'] = 'Calificación más alta';
$string['grademethod'] = 'Método de calificación';
$string['grademethod_help'] = '<P>Cuando se permiten múltiples intentos, hay diferentes maneras en las que puede
usar las distintas calificaciones obtenidas para calcular la puntuación final del examen.

<P><B>Calificación más alta</B><P>
<UL>
<P>La puntuación final es la más alta en cualquiera de los intentos.
</UL>

<P><B>Puntuación media</B><P>
<UL>
<P> La puntuación final es el promedio (la media simple) de la puntuación de
todos los intentos.</UL>

<P><B>Primera calificación</B><P>
<UL>
<P>La puntuación final es la obtenida en el primer intento (se ignoran los
demás intentos).</UL>

<P><B>Última calificación</B><P>
<UL>
<P>La calificación final es la obtenida en el intento más reciente.</UL>';
$string['gradesdeleted'] = 'Eliminadas calificaciones del cuestionario';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'La nota para aprobar no puede ser cero, este cuestionario tiene como método establecido una calificación para aprobar. Por favor establezca un número que no sea cero.';
$string['gradetopassnotset'] = 'Este cuestionario no tiene configurada una calificación aprobatoria, por lo que Usted no puede usar esta opción. Por favor, use en cambio la configuración de requerir calificación.';
$string['gradetopassoutof'] = 'Calificación para aprobar: {$a->grade} de {$a->maxgrade}';
$string['gradingdetails'] = 'Puntos para este envío:
{$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Con las penalizaciones previas da como resultado
<strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Este envío conlleva una penalización de {$a}.';
$string['gradingdetailszeropenalty'] = 'Usted no ha sido penalizado por este envío.';
$string['gradingmethod'] = 'Método de calificación: {$a}';
$string['groupoverrides'] = 'Excepciones de grupo';
$string['groupoverridesdeleted'] = 'Excepciones de grupo eliminadas';
$string['groupsnone'] = 'No hay grupos a los que pueda acceder.';
$string['guestsno'] = 'Lo sentimos, los invitados no pueden ver o responder cuestionarios';
$string['hidebreaks'] = 'Ocultar saltos de página';
$string['hidereordertool'] = 'Ocultar herramienta de reordenamiento';
$string['history'] = 'Historial de respuestas:';
$string['howquestionsbehave_desc'] = 'Configuración predeterminada del comportamiento de las preguntas en un cuestionario.';
$string['imagedisplay'] = 'Imagen a mostrar';
$string['import_help'] = 'Esta función permite importar preguntas de archivos externos.

Si su archivo contiene caracteres no ascii, utilice la codificación UTF-8. Sea especialmente cuidadoso con los archivos generados por aplicaciones Microsoft Office, puesto que normalmente utilizan una codificación especial que puede no ser manejada correctamente.

Los formatos de Importar y Exportar son un recurso extensible. Pueden encontrarse disponibles otros formatos opcionales en la base de datos de Módulos y Extensiones.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'importar categoría';
$string['importerror'] = 'Ha ocurrido un error durante el procesamiento de la importación';
$string['importfilearea'] = 'Importar de un archivo que ya está en los archivos del curso...';
$string['importfileupload'] = 'Importar de subida de archivo...';
$string['importfromthisfile'] = 'Importar de este archivo';
$string['importingquestions'] = 'Importando {$a} preguntas del archivo';
$string['importmax10error'] = 'Hay un error en la pregunta. Usted no puede tener más de diez respuestas';
$string['importmaxerror'] = 'Hay un error en la pregunta.
Hay demasiadas respuestas.';
$string['importquestions'] = 'Importar preguntas de un archivo';
$string['inactiveoverridehelp'] = '* Esta anulación está inactiva porque el acceso del usuario a la actividad está restringido. Esto puede ser por asignación de rol o grupo, por otras restricciones de acceso, o porque la actividad esté oculta.';
$string['incorrect'] = 'Incorrecta';
$string['indicator:cognitivedepth'] = 'Cuestionario cognitivo';
$string['indicator:cognitivedepth_help'] = 'Este indicador está basado en la profundidad cognitiva alcanzada por el estudiante en una actividad Cuestionario.';
$string['indicator:cognitivedepthdef'] = 'Cuestionario cognitivo';
$string['indicator:cognitivedepthdef_help'] = 'El participante ha alcanzado este porcentaje del compromiso cognitivo ofrecido por las actividades de Cuestionario durante este intervalo de análisis (Niveles = Sin vista, Ver, Enviar, Ver comentarios, Comentar comentarios, Reenviar después de ver comentarios)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Cuestionario social';
$string['indicator:socialbreadth_help'] = 'Este indicador está basado en la amplitud social alcanzada por el estudiante en una actividad Cuestionario.';
$string['indicator:socialbreadthdef'] = 'Cuestionario social';
$string['indicator:socialbreadthdef_help'] = 'El participante ha alcanzado este porcentaje de compromiso social ofrecido por las actividades de Cuestionario durante este intervalo de análisis (Niveles = Sin participación, Participante solo, Participante con otros)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Respuestas de los individuos a cada elemento';
$string['info'] = 'Información';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Número inicial de campos de retroalimentación global';
$string['initialnumfeedbacks_desc'] = 'Al crear un nuevo cuestionario, proporcione este número de cajas de retroalimentación global vacías. Una vez que el cuestionario haya sido creado, el formulario muestra el número de campos requeridos para el número de retroalimentaciones en el examen. La configuración debe de ser al menos de 1.';
$string['inprogress'] = 'En curso';
$string['introduction'] = 'Descripción';
$string['invalidattemptid'] = 'No existe un intento con esa ID';
$string['invalidcategory'] = 'El ID de la categoría no es válido';
$string['invalidoverrideid'] = 'ID de excepción no válido';
$string['invalidquestionid'] = 'ID de pregunta no válida';
$string['invalidquizid'] = 'ID de cuestionario no válido';
$string['invalidrandomslot'] = 'ID de espacio de pregunta aleatorio no válido.';
$string['invalidsource'] = 'No se acepta la fuente como válida';
$string['invalidsourcetype'] = 'Tipo de fuente no válido.';
$string['invalidstateid'] = 'ID de estado no válida';
$string['lastanswer'] = 'Su última respuesta fue';
$string['layout'] = 'Esquema';
$string['layoutasshown'] = 'Diseño de página como se muestra.';
$string['layoutasshownwithpages'] = 'Diseño de página como se muestra. <small>(Página nueva automática cada {$a} preguntas.)</small>';
$string['layoutshuffledandpaged'] = 'Preguntas presentadas aleatoriamente, {$a} en cada página.';
$string['layoutshuffledsinglepage'] = 'Preguntas presentadas aleatoriamente, todas en en una sola página.';
$string['legacyquizaccessrulescron'] = 'Reglas de acceso de pruebas cron heredadas';
$string['legacyquizreportscron'] = 'Informes de pruebas cron heredadas';
$string['link'] = 'Enlace';
$string['listitems'] = 'Lista de elementos en el cuestionario';
$string['literal'] = 'Literal';
$string['loadingquestionsfailed'] = 'Fallo en la carga de preguntas: {$a}';
$string['makecopy'] = 'Guardar como nueva pregunta';
$string['managetypes'] = 'Gestionar tipos de preguntas y servidores';
$string['manualgradequestion'] = 'Pregunta calificada manualmente {$a->question} en {$a->quiz} por {$a->user}';
$string['manualgrading'] = 'Calificación';
$string['mark'] = 'Enviar';
$string['markall'] = 'Enviar página';
$string['marks'] = 'Puntos';
$string['marks_help'] = 'Las marcas numéricas de cada pregunta, y la puntuación del intento global.';
$string['match'] = 'Emparejamiento';
$string['matchanswer'] = 'Respuesta emparejada';
$string['matchanswerno'] = 'Respuesta emparejada {$a}';
$string['max'] = 'Máx';
$string['maxmark'] = 'Nota máxima';
$string['messageprovider:attempt_grading_complete'] = 'Notificación de que su intento se ha calificado';
$string['messageprovider:attempt_overdue'] = 'Advertencia cuando su intento de resolver el cuestionario se retrase';
$string['messageprovider:confirmation'] = 'Confirmación de su envío del cuestionario';
$string['messageprovider:submission'] = 'Notificación del envío de cuestionarios de sus estudiantes';
$string['min'] = 'Mín';
$string['minutes'] = 'Minutos';
$string['missingcorrectanswer'] = 'Debe especificar la respuesta correcta';
$string['missingitemtypename'] = 'Nombre perdido';
$string['missingquestion'] = 'Parece que no existe ya esta pregunta';
$string['modulename'] = 'Cuestionario';
$string['modulename_help'] = 'La actividad Cuestionario permite al profesor diseñar y plantear cuestionarios con preguntas tipo opción múltiple, verdadero/falso, coincidencia, respuesta corta y respuesta numérica

El profesor puede permitir que el cuestionario se intente resolver varias veces, con las preguntas ordenadas o seleccionadas aleatoriamente del banco de preguntas. Se puede establecer un tiempo límite.

Cada intento se califica automáticamente, con la excepción de las preguntas de tipo "ensayo", y el resultado se guarda en el libro de calificaciones.

El profesor puede determinar si se muestran y cuándo se muestran al usuario los resultados, los comentarios de retroalimentación y las respuestas correctas.

Los cuestionario pueden usarse para hacer

* Exámenes del curso
* Mini Test para tareas de lectura o al final de un tema
* Exámenes de práctica con preguntas de exámenes anteriores
* Para ofrecer información inmediata sobre el rendimiento * Para auto-evaluación';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Cuestionarios';
$string['moveselectedonpage'] = 'Mover las preguntas seleccionadas a la página: {$a}';
$string['multichoice'] = 'Opción múltiple';
$string['multipleanswers'] = 'Seleccione  al menos una respuesta.';
$string['mustbesubmittedby'] = 'Este intento debe ser presentado el {$a}.';
$string['name'] = 'Nombre';
$string['navigatenext'] = 'Siguiente página';
$string['navigateprevious'] = 'Página anterior';
$string['navmethod'] = 'Método de navegación';
$string['navmethod_free'] = 'Libre';
$string['navmethod_help'] = 'Cuando la navegación secuencial está activada el estudiante debe avanzar a través del cuestionario en un orden determinado y no puede volver a las páginas anteriores ni saltar hacia delante.';
$string['navmethod_seq'] = 'Secuencial';
$string['navnojswarning'] = 'Advertencia: estos vínculos no guardarán sus respuestas. Utilice el botón siguiente en la zona inferior de la página.';
$string['neverallononepage'] = 'Nunca, todas las preguntas en una página';
$string['newattemptfail'] = 'Error: No se ha podido comenzar un nuevo intento en el cuestionario';
$string['newcategory'] = 'Nueva categoría';
$string['newpage'] = 'Página nueva';
$string['newpage_help'] = '<p>En los cuestionarios más extensos tiene sentido alargar el cuestionario en varias páginas limitando el número de preguntas por página. Cuando se añaden preguntas al cuestionario se insetarán automáticamente saltos de página de acuerdo con el ajuste que se introduzca aquí. Sin embargo, uster podrá cambiar a mano los saltos de página más tarde en la página de edición.
</p>';
$string['newpageevery'] = 'Comenzar automáticamente una nueva página';
$string['newsectionheading'] = 'Nuevo título';
$string['noanswers'] = 'No se seleccionó ninguna respuesta';
$string['noattempts'] = 'No se ha intentado responder este cuestionario';
$string['noattemptsfound'] = 'No se han encontrado intentos.';
$string['noattemptstoshow'] = 'No hay intentos que mostrar';
$string['nocategory'] = 'Categoría incorrecta o no especificada';
$string['noclose'] = 'Sin fecha de cierre';
$string['nocommentsyet'] = 'Aún no hay comentarios.';
$string['noconnection'] = 'En este momento no existe conexión a un servicio web que pueda procesar esta pregunta. Por favor, contacte con su administrador.';
$string['nodataset'] = 'nada - no es un comodín';
$string['nodatasubmitted'] = 'No se han enviado datos.';
$string['noessayquestionsfound'] = 'No se encuentran preguntas calificadas manualmente';
$string['nogradewarning'] = 'Este cuestionario no está calificado, por lo que no puede escribir una retroalimentación global en función de la calificación.';
$string['nomoreattempts'] = 'No se permiten más intentos';
$string['none'] = 'Ninguno';
$string['noopen'] = 'Sin fecha de apertura';
$string['nooverridedata'] = 'Debe reemplazar al menos uno de los ajustes del cuestionario.';
$string['nopossibledatasets'] = 'No datos posibles';
$string['noquestionintext'] = 'El enunciado de la pregunta no contiene ninguna pregunta anidada';
$string['noquestions'] = 'Aún no se han agregado preguntas';
$string['noquestionsfound'] = 'No se han encontrado respuestas';
$string['noquestionsinquiz'] = 'No hay preguntas en este cuestionario.';
$string['noquestionsnotinuse'] = 'Esta pregunta aleatoria no está en uso puesto que su categoría está vacía.';
$string['noquestionsonpage'] = 'Página vacía';
$string['noresponse'] = 'Sin respuesta';
$string['noreview'] = 'No está autorizado para revisar este cuestionario';
$string['noreviewattempt'] = 'Usted no tiene permiso para revisar este intento.';
$string['noreviewshort'] = 'No permitido';
$string['noreviewuntil'] = 'No está autorizado para revistar este cuestionario hasta el {$a}';
$string['noreviewuntilshort'] = 'Disponible {$a}';
$string['noscript'] = 'Para continuar, JavaScript debe estar habilitado';
$string['notavailabletostudents'] = 'Nota: Este cuestionario no está disponible actualmente para sus estudiantes.';
$string['notenoughrandomquestions'] = 'No hay suficientes preguntas en la categoría {$a->category} para crear la pregunta {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'No se han definido suficientes subpreguntas.<br /> ¿Quiere regresar y arreglar esta pregunta?';
$string['notifyattemptsgradedtask'] = 'Enviar notificaciones de intentos calificados';
$string['notimedependentitems'] = 'Actualmente el módulo Cuestionario no permite ítems de tiempo limitado. Como alternativa, fije un tiempo límite para todo el cuestionario. ¿Desea elegir un ítem diferente o usar el actual?';
$string['notyetgraded'] = 'Sin calificar aún';
$string['notyetviewed'] = 'Aún no se ha visto';
$string['notyourattempt'] = '¡Éste no es su intento!';
$string['noview'] = 'Al usuario identificado no se le permite ver este cuestionario.';
$string['numattempts'] = '{$a->studentnum}
{$a->studentstring} ha hecho
{$a->attemptnum} intentos';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numérico';
$string['numquestionsx'] = 'Preguntas:{$a}';
$string['oneminute'] = '1 minuto';
$string['onlyteachersexport'] = 'Sólo los profesores pueden exportar preguntas';
$string['onlyteachersimport'] = 'Sólo los profesores con permiso de edición pueden importar preguntas';
$string['onthispage'] = 'Esta página';
$string['open'] = 'Sin contestar';
$string['openafterclose'] = 'No se puede actualizar el cuestionario. Ha indicado una fecha de apertura posterior a la fecha de cierre.';
$string['openclosedatesupdated'] = 'Actualizadas fechas de apertura y cierre del cuestionario';
$string['optional'] = 'opcional';
$string['orderandpaging'] = 'Orden y paginación';
$string['orderandpaging_help'] = 'Los números 10, 20, 30, ... al lado de cada pregunta indican su orden. Los números aumentan en franjas de 10 para dejar espacio a las preguntas adicionales que se insertan posteriormente. Para cambiar el orden de las preguntas, cambie los números haciendo clic en el botón "Volver a ordenar las preguntas".

Para agregar saltos de página después de determinadas cuestiones, marque la casilla junto a las preguntas y haga clic en el botón "Agregar nuevas páginas después de las preguntas seleccionadas".

Para ordenar las preguntas por un número de páginas, haga clic en el botón "Paginar de nuevo" y seleccione el número deseado de preguntas por página.';
$string['orderingquiz'] = 'Orden y paginación';
$string['orderingquizx'] = 'Orden y paginación: {$a}';
$string['outcomesadvanced'] = 'Los resultados son ajustes avanzados';
$string['outof'] = '{$a->grade} de {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} de {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Retroalimentación global';
$string['overallfeedback_help'] = '<p>La retroalimentación global consiste en un texto que se muestra al estudiante una vez que ha completado un intento de resolver el cuestionario. El texto puede
depender de la calificación que el estudiante haya obtenido.</p>

<p>Por ejemplo, si usted escribe "¡Buen trabajo!" en la primera caja de retroalimentación,
escribe 40% en la primera caja de límites de la calificación y escribe "Por favor, vuelve a
revisar el trabajo de esta semana", los estudiantes que puntúen 40% o más verán el mensaje
"¡Buen trabajo!", en tanto que los que hayan puntuado menos del 40% verán el otro mensaje.</p>

<p>Los límites de las calificaciones pueden especificarse en forma de porcentajes, por ejemplo
"31.41%", o en forma de números, por ejemplo "7". Si el cuestionario tiene 10 notas, un límite
de calificación de 7 significa 7/10 o superior.</p>';
$string['overdue'] = 'Vencido';
$string['overduehandling'] = 'Cuando el tiempo ha terminado';
$string['overduehandling_desc'] = '¿Qué debe suceder  por defecto si un estudiante no envía el cuestionario antes de que expire el plazo de entrega.?';
$string['overduehandling_help'] = 'Este ajuste controla qué sucede si el alumno no envía su intento de resolver el cuestionario antes de que el tiempo expire. Si el estudiante está trabajando activamente en el cuestionario en ese momento, entonces el temporizador enviará automáticamente el intento, pero en caso de haber cerrado la sesión, esta opción controla lo que sucede.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'El envío debe hacerse antes de que el tiempo termine, de lo contrario, no se contabilizará';
$string['overduehandlingautosubmit'] = 'El envío se realiza automáticamente';
$string['overduehandlinggraceperiod'] = 'Hay un periodo de gracia para enviar el cuestionario, pero no para responder a más preguntas';
$string['overduemustbesubmittedby'] = 'Este intento ha caducado. Debería ya haber sido presentado. Si quiere que este cuestionario se califique, debería presentarlo en {$a}. Si no lo presenta para entonces, no se contarán las puntuaciones de este intento.';
$string['override'] = 'Excepción';
$string['overridedeletegroupsure'] = '¿Está seguro que desea eliminar la modificación del grupo {$a}?';
$string['overridedeleteusersure'] = '¿Está seguro que desea eliminar la modificación del usuario {$a}?';
$string['overridegroup'] = 'Reemplazar grupo';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Excepciones';
$string['overridesforquiz'] = 'Anulaciones de configuración: {$a}';
$string['overridesnoneforgroups'] = 'No se han creado anulaciones de configuración de grupo para este cuestionario.';
$string['overridesnoneforusers'] = 'No se han creado anulaciones de configuración de usuario para este cuestionario.';
$string['overridessummary'] = 'Existen anulaciones de configuración ({$a})';
$string['overridessummarygroup'] = 'Grupos: {$a}';
$string['overridessummarythisgroup'] = 'Existen anulaciones de configuración ({$a}) para este grupo';
$string['overridessummaryuser'] = 'Usuarios: {$a}';
$string['overridessummaryyourgroups'] = 'Existen anulaciones de configuración ({$a}) para tus grupos';
$string['overrideuser'] = 'Sobrescribir usuario';
$string['overrideusereventname'] = '{$a->quiz} - Excepción';
$string['page-mod-quiz-attempt'] = 'Página del intento del cuestionario';
$string['page-mod-quiz-edit'] = 'Editar página del cuestionario';
$string['page-mod-quiz-report'] = 'Cualquier página de informe del cuestionario';
$string['page-mod-quiz-review'] = 'Página de revisión del intento del cuestionario';
$string['page-mod-quiz-summary'] = 'Página de resumen del intento del cuestionario';
$string['page-mod-quiz-view'] = 'Página de información del cuestionario';
$string['page-mod-quiz-x'] = 'Cualquier página del módulo Cuestionario';
$string['pageshort'] = 'P';
$string['pagesize'] = 'Tamaño de página';
$string['parent'] = 'Padre';
$string['parentcategory'] = 'Categoría padre';
$string['parsingquestions'] = 'Analizando preguntas del archivo de importación.';
$string['partiallycorrect'] = 'Parcialmente correcto';
$string['penalty'] = 'Penalización';
$string['penaltyscheme'] = 'Aplicar penalizaciones';
$string['penaltyscheme_help'] = '<p>Si un cuestionario se ejecuta en modo adaptativo, se permitirá al estudiante intentar responder de nuevo tras una respuesta errónea. En este caso, tal vez usted quiera imponer una penalización por cada respuesta equivocada que sea substraída de la puntuación final de la pregunta. La cantidad de penalización se elige individualmente para cada pregunta cuando se formula o se edita la pregunta.</p>

<p>Este ajuste no tiene efecto a menos que el cuestionario se administre en modo adaptativo.</p>';
$string['percentcorrect'] = 'Porcentaje correcto';
$string['pleaseclose'] = 'Su petición ha sido procesada. Puede ahora cerrar la ventana';
$string['pluginadministration'] = 'Administración del cuestionario';
$string['pluginname'] = 'Cuestionario';
$string['popup'] = 'Mostrar el cuestionario en una ventana \'segura\'';
$string['popupblockerwarning'] = 'Esta sección del test está en modo seguro, lo que significa que usted necesita completar el cuestionario en una ventana segura. Por favor, desactive el bloqueo de ventanas emergentes. Gracias.';
$string['popupnotice'] = 'Los estudiantes verán este cuestionario en una ventana segura';
$string['preprocesserror'] = 'Ha ocurrido un error durante el procesamiento previo.';
$string['preview'] = 'Vista previa';
$string['previewquestion'] = 'Vista previa de la pregunta';
$string['previewquiz'] = 'Vista previa {$a}';
$string['previewquiznow'] = 'Previsualizar el cuestionario ahora';
$string['previewquizstart'] = 'Vista previa del cuestionario';
$string['previous'] = 'Estado previo';
$string['privacy:metadata:core_question'] = 'La actividad de cuestionario almacena información sobre el uso de las preguntas en el subsistema core_question.';
$string['privacy:metadata:quiz'] = 'La actividad de cuestionario utiliza informes de cuestionario.';
$string['privacy:metadata:quiz_attempts'] = 'Detalles sobre cada intento en un cuestionario.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'El número de intento.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'La página actual en la que se encuentra el usuario.';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'La hora a la que se notificó al usuario que se completó la calificación manual de su intento';
$string['privacy:metadata:quiz_attempts:preview'] = 'Si se trata de una vista previa del cuestionario.';
$string['privacy:metadata:quiz_attempts:state'] = 'El estado actual del intento.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'La suma de calificaciones en el intento.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'La hora en la cual fue revisado el estado.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'El momento en el que se completó el intento.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'El momento en el que se actualizó el intento.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'La hora de actualización del intento fuera de línea.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'El momento en el que se inició el intento.';
$string['privacy:metadata:quiz_grades'] = 'Detalles sobre la calificación general de este cuestionario.';
$string['privacy:metadata:quiz_grades:grade'] = 'La calificación general de este cuestionario.';
$string['privacy:metadata:quiz_grades:quiz'] = 'El cuestionario que fue calificado.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'El momento en el que se modificó la calificación.';
$string['privacy:metadata:quiz_grades:userid'] = 'El usuario que fue calificado.';
$string['privacy:metadata:quiz_overrides'] = 'Detalles sobre anulaciones para este cuestionario';
$string['privacy:metadata:quiz_overrides:quiz'] = 'El cuestionario con información de anulación';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'La nueva hora de cierre del cuestionario.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'El nuevo límite de tiempo para el cuestionario.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'La nueva hora de apertura del cuestionario.';
$string['privacy:metadata:quiz_overrides:userid'] = 'El usuario que se anula';
$string['privacy:metadata:quizaccess'] = 'La actividad de la prueba hace uso de las reglas de acceso a la prueba.';
$string['publish'] = 'Publicar';
$string['publishedit'] = 'Necesita tener permiso en el curso para añadir o editar preguntas en esta categoría';
$string['qbrief'] = 'P. {$a}';
$string['qname'] = 'nombre';
$string['qti'] = 'Formato IMS QTI';
$string['qtypename'] = 'tipo, nombre';
$string['question'] = 'Pregunta';
$string['questionbank'] = 'del banco de preguntas';
$string['questionbankmanagement'] = 'Gestión del banco de preguntas';
$string['questionbehaviour'] = 'Comportamiento de las preguntas';
$string['questioncats'] = 'Categorías de pregunta';
$string['questiondeleted'] = 'Esta pregunta ha sido eliminada. Por favor póngase en contacto con su profesor.';
$string['questiondependencyadd'] = 'Sin restricción cuando la pregunta  {$a->thisq} se pueda intentar - Clic aquí para cambiarlo';
$string['questiondependencyfree'] = 'Sin restricciones para esta pregunta';
$string['questiondependencyremove'] = 'No se pueden realizar intentos en la pregunta {$a->thisq} hasta que se haya completado la pregunta {$a->previousq} anterior • Haga clic para cambiar';
$string['questiondependsonprevious'] = 'No se pueden realizar intentos en esta pregunta hasta que se haya completado la pregunta anterior.';
$string['questiondraftonly'] = 'La pregunta "{$a}" tiene todas sus versiones en borrador, así que no puede usarse. Visite el banco de preguntas y cambie su estado a "Listo".';
$string['questiondraftwillnotwork'] = 'Esta pregunta está en borrador. Para usarla en el cuestionario, vaya al banco de preguntas y cambie su estado a "Listo".';
$string['questioninuse'] = 'La pregunta \'{$a}\' está en uso:';
$string['questionmissing'] = 'La pregunta de esta sesión está ausente';
$string['questionname'] = 'Nombre de la pregunta';
$string['questionnonav'] = '<span class="accesshide">Pregunta </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Información </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'La pregunta {$a} no se ha cargado desde la base de datos';
$string['questionorder'] = 'Orden de las preguntas';
$string['questionposition'] = 'Nueva posición en el orden de la pregunta {$a}';
$string['questions'] = 'Preguntas';
$string['questionsetpreview'] = 'Vista previa del conjunto de preguntas';
$string['questionsinclhidden'] = 'Preguntas (incluídas las ocultas)';
$string['questionsinthisquiz'] = 'Preguntas en este cuestionario';
$string['questionsmatchingfilter'] = 'Preguntas que cumplen este filtro:  {$a}';
$string['questionsperpage'] = 'Número máximo de preguntas por página';
$string['questionsperpageselected'] = 'Se ha establecido el número de respuestas por página (la paginación está fijada actualmente). Como resultado, se han desactivado los controles de paginación. Puede cambiar esto en {$a}.';
$string['questionsperpagex'] = 'Preguntas por página: {$a}';
$string['questiontext'] = 'Enunciado de la pregunta';
$string['questiontextisempty'] = '[Texto de pregunta vacía]';
$string['questiontype'] = 'Tipo de pregunta {$a}';
$string['questiontypesetupoptions'] = 'Ajuste de opciones para los tipos de pregunta:';
$string['questionversion'] = 'v{$a}';
$string['questionversionlatest'] = 'v{$a} (última)';
$string['quiz:addinstance'] = 'Añadir un nuevo cuestionario';
$string['quiz:attempt'] = 'Intentar resolver cuestionarios';
$string['quiz:deleteattempts'] = 'Eliminar intentos';
$string['quiz:emailconfirmsubmission'] = 'Recibir información de sus envíos de cuestionario';
$string['quiz:emailnotifyattemptgraded'] = 'Recibir notificación cuando tu intento haya sido calificado';
$string['quiz:emailnotifysubmission'] = 'Recibir notificaciones de los envíos de cuestionarios de sus estudiantes';
$string['quiz:emailwarnoverdue'] = 'Recibir una advertencia cuando su intento de prueba esté vencido';
$string['quiz:grade'] = 'Calificar cuestionarios manualmente';
$string['quiz:ignoretimelimits'] = 'Ignorar el límite de tiempo de cuestionario';
$string['quiz:manage'] = 'Gestionar cuestionarios';
$string['quiz:manageoverrides'] = 'Gestionar anulaciones de la configuración del cuestionario';
$string['quiz:preview'] = 'Vista previa de cuestionarios';
$string['quiz:regrade'] = 'Recalificar los intentos de resolver el cuestionario';
$string['quiz:reopenattempts'] = 'Reabrir intentos de cuestionario no entregados';
$string['quiz:reviewmyattempts'] = 'Revisar sus propios intentos';
$string['quiz:view'] = 'Ver información sobre el cuestionario';
$string['quiz:viewoverrides'] = 'Ver anulaciones de la configuración del cuestionario';
$string['quiz:viewreports'] = 'Ver informes de cuestionarios';
$string['quizavailable'] = 'El cuestionario está disponible hasta: {$a}';
$string['quizclose'] = 'Cerrar cuestionario';
$string['quizclosed'] = 'Este cuestionario se cerró el {$a}';
$string['quizcloses'] = 'El cuestionario se cerrará el';
$string['quizcloseson'] = 'Este cuestionario se cerrará el {$a}.';
$string['quizeventcloses'] = 'Se cierra {$a}';
$string['quizeventopens'] = 'Se abre {$a}';
$string['quizisclosed'] = 'Este cuestionario está cerrado';
$string['quizisclosedwillopen'] = 'Cuestionario cerrado (se abrirá el {$a})';
$string['quizisopen'] = 'Este cuestionario está abierto';
$string['quizisopenwillclose'] = 'Cuestionario abierto (se cerrará el {$a})';
$string['quiznavigation'] = 'Navegación por el cuestionario';
$string['quizopen'] = 'Abrir cuestionario';
$string['quizopenclose'] = 'Fechas de apertura y cierre';
$string['quizopenclose_help'] = 'Los estudiantes sólo podrán comenzar un intento de resolver el cuestionario después de la apertura y deben completarlo antes de la hora de cierre.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopened'] = 'Este cuestionario está abierto';
$string['quizopenedon'] = 'Este cuestionario se abrió el {$a}';
$string['quizopens'] = 'El cuestionario se abrirá el';
$string['quizopenwillclose'] = 'Este cuestionario está abierto, se cerrará en {$a}';
$string['quizordernotrandom'] = 'Orden no aleatorio';
$string['quizorderrandom'] = 'Orden aleatorio';
$string['quizreport'] = 'Informe del cuestionario';
$string['quizsettings'] = 'Ajustes del cuestionario';
$string['quiztimer'] = 'Temporizador del cuestionario';
$string['quizwillopen'] = 'Este cuestionario se abrirá el {$a}';
$string['random'] = 'Pregunta aleatoria';
$string['randomcreate'] = 'Crear preguntas aleatorias';
$string['randomediting'] = 'Editando pregunta aleatoria';
$string['randomfromcategory'] = 'Pregunta aleatoria de la categoría.';
$string['randomfromexistingcategory'] = 'Pregunta aleatoria desde una categoría existente';
$string['randomfromunavailabletag'] = '{$a} (no disponible)';
$string['randomnosubcat'] = 'Preguntas sólo de esta categoría, no de sus sub-categorías.';
$string['randomnumber'] = 'Número de preguntas aleatorias';
$string['randomquestion'] = 'Pregunta aleatoria';
$string['randomquestion_help'] = 'Una pregunta aleatoria es una forma de añadir una pregunta seleccionada al azar de una categoría o una por una marca específica dentro de una actividad.';
$string['randomquestiontags'] = 'Marcas';
$string['randomquestiontags_help'] = 'Aquí puede restringir el criterio de selección por marcas específicas de las preguntas.

Las preguntas "aleatorias" serán seleccionadas entre las preguntas que tengan estas marcas.';
$string['randomquestionusinganewcategory'] = 'Pregunta aleatoria utilizando una categoría nueva';
$string['randomwithsubcat'] = 'Preguntas de esta categoría y de sus sub-categorías.';
$string['readytosend'] = 'Está a punto de enviar su cuestionario para que sea evaluado. ¿Está seguro de que desea continuar?';
$string['reattemptquiz'] = 'Reintentar el cuestionario';
$string['recentlyaddedquestion'] = 'Pregunta agregada recientemente';
$string['recurse'] = 'Incluir también preguntas de subcategorías';
$string['redoesofthisquestion'] = 'Otras preguntas para las que se hayan realizado intentos aquí: {$a}';
$string['redoquestion'] = 'Probar otra pregunta similar';
$string['regrade'] = 'Recalificar todos los intentos';
$string['regradecomplete'] = 'Todos los intentos han sido recalificados';
$string['regradecount'] = 'Se han cambiado {$a->changed} de {$a->attempt} calificaciones';
$string['regradedisplayexplanation'] = 'Los intentos que cambian durante la recalificación se muestran como hiperenlaces a la ventana de revisión de preguntas';
$string['regradenotallowed'] = 'No dispone de permiso para recalificar este cuestionario';
$string['regradingquestion'] = 'Recalificando "{$a}".';
$string['regradingquiz'] = 'Recalificando el cuestionario "{$a}"';
$string['remove'] = 'Quitar';
$string['removeallgroupoverrides'] = 'Eliminar todas las excepciones de grupo';
$string['removeallquizattempts'] = 'Eliminar todos los intentos de resolver el cuestionario';
$string['removealluseroverrides'] = 'Eliminar todas las excepciones de usuario';
$string['removeemptypage'] = 'Eliminar la página vacía';
$string['removepagebreak'] = 'Retire salto de página';
$string['removeselected'] = 'Eliminar las seleccionadas';
$string['rename'] = 'Renombrar';
$string['renderingserverconnectfailed'] = 'El servidor {$a} no ha podido procesar una petición RQP. Compruebe que la URL es correcta.';
$string['reopenattempt'] = 'Reabrir';
$string['reopenattemptareyousuremessage'] = 'Esto reabrirá el intento {$a->attemptnumber} de {$a->attemptuser}.';
$string['reopenattemptareyousuretitle'] = '¿Reabrir intento?';
$string['reopenattemptwrongstate'] = 'Intento {$a->attemptid} en estado equivocado ({$a->state})';
$string['reopenedattemptwillbeinprogress'] = 'El intento permanecerá abierto y puede continuar.';
$string['reopenedattemptwillbeinprogressuntil'] = 'El intento permanecerá abierto y puede continuar hasta que el cuestionario cierre el {$a}';
$string['reopenedattemptwillbesubmitted'] = 'El intento será enviado para calificar inmediatamente.';
$string['reorderquestions'] = 'Volver a ordenar las preguntas';
$string['reordertool'] = 'Mostrar herramienta de reordenación';
$string['repaginate'] = 'Repaginar con {$a} preguntas por página';
$string['repaginatecommand'] = 'Paginar de nuevo';
$string['repaginatenow'] = 'Repaginar ahora';
$string['replace'] = 'Reemplazar';
$string['replacementoptions'] = 'Opciones de reemplazar';
$string['report'] = 'Informes';
$string['reportanalysis'] = 'Análisis de ítems';
$string['reportattemptsfrom'] = 'Intentos de';
$string['reportattemptsthatare'] = 'Los intentos que hay';
$string['reportdisplayoptions'] = 'Mostrar opciones';
$string['reportfullstat'] = 'Estadísticas detalladas';
$string['reportmulti_percent'] = 'Porcentajes mútiples';
$string['reportmulti_q_x_student'] = 'Opciones multi-estudiante';
$string['reportmulti_resp'] = 'Respuestas individuales';
$string['reportmustselectstate'] = 'Debes elegir al menos un estado.';
$string['reportnotfound'] = 'Informe no conocido ({$a})';
$string['reportoverview'] = 'Vista general';
$string['reportregrade'] = 'Recalificar intentos';
$string['reportresponses'] = 'Respuestas detalladas';
$string['reports'] = 'Informes';
$string['reportshowonly'] = 'Mostrar únicamente intentos';
$string['reportshowonlyfinished'] = 'Mostrar a lo más un intento final por usuario ({$a})';
$string['reportsimplestat'] = 'Estadística simple';
$string['reportusersall'] = 'todos los usuarios que han hecho intentos de resolver el cuestionario';
$string['reportuserswith'] = 'usuarios matriculados que han hecho intentos de resolver el cuestionario';
$string['reportuserswithorwithout'] = 'usuarios matriculados que han hecho intentos, o no, de resolver el cuestionario';
$string['reportuserswithout'] = 'usuarios matriculados que no han hecho intentos de resolver el cuestionario';
$string['reportwhattoinclude'] = 'Qué incluir en el informe';
$string['requirepassword'] = 'Se requiere contraseña';
$string['requirepassword_help'] = 'Si se especifica una contraseña, los estudiantes deben introducirla para poder intentar resolver el cuestionario.';
$string['requiresubnet'] = 'Se requiere dirección de red';
$string['requiresubnet_help'] = 'Se puede restringir el acceso a un cuestionario a una subred particular en una LAN o en Internet especificando una lista separada por comas de los números parciales o completos del dirección IP. Puede ser útil para casos de cuestionarios sin vigilancia, para asegurar que solo las personas en ciertas ubicaciones pueden acceder al cuestionario';
$string['response'] = 'Respuesta';
$string['responses'] = 'Respuestas -';
$string['results'] = 'Resultados';
$string['returnattempt'] = 'Volver al intento';
$string['reuseifpossible'] = 'volver a usar las eliminadas previamente';
$string['reverttodefaults'] = 'Volver al cuestionario por defecto';
$string['review'] = 'Revisión';
$string['reviewafter'] = 'Permitir revisión tras cerrar el cuestionario';
$string['reviewalways'] = 'Permitir revisión en cualquier momento';
$string['reviewattempt'] = 'Revisión del intento';
$string['reviewbefore'] = 'Permitir revisión mientras el cuestionario está abierto';
$string['reviewclosed'] = 'Después de cerrar el cuestionario';
$string['reviewduring'] = 'Durante el intento';
$string['reviewimmediately'] = 'Inmediatamente después de cada intento';
$string['reviewnever'] = 'No permitir revisión';
$string['reviewofquestion'] = 'Revisión de la pregunta {$a->question} en {$a->quiz} por {$a->user}';
$string['reviewopen'] = 'Más tarde, mientras el cuestionario está aún abierto';
$string['reviewoptions'] = 'Los estudiantes pueden revisar';
$string['reviewoptionsheading'] = 'Opciones de revisión';
$string['reviewoptionsheading_help'] = 'Estas opciones controlan qué información pueden ver los estudiantes cuando revisan un intento del cuestionario o cuando consultan los informes del cuestionario.

** Durante el intento** los ajustes solo son relevantes en algunas situaciones, como en el caso  "interactivo con varios intentos", que pueden mostrar información durante el intento.

** Inmediatamente después del intento** los ajustes se aplican los dos primeros minutos después de que se haya pulsado "Enviar todo y terminar".

** Posteriormente, cuando el intento aún está abierto** los ajustes se aplican después de esto, y antes de la fecha de cierre del cuestionario.

** Una vez el cuestionario esté cerrado** los ajustes se aplican después de que la fecha de cierre del cuestionario haya pasado. Si la prueba no tiene una fecha de cierre, este estado no se alcanza nunca.';
$string['reviewoverallfeedback'] = 'Retroalimentación global';
$string['reviewoverallfeedback_help'] = 'La retroalimentación que se da al final del intento, según la puntuación final del alumno.';
$string['reviewresponse'] = 'Revisar respuesta';
$string['reviewresponsetoq'] = 'Revisar respuesta (pregunta {$a})';
$string['reviewthisattempt'] = 'Revisar sus respuestas en este intento';
$string['rqp'] = 'Pregunta remota';
$string['rqps'] = 'Preguntas remotas';
$string['sameasoverall'] = 'Los mismos que para las calificaciones';
$string['save'] = 'Guardar';
$string['saveandedit'] = 'Guardar cambios y editar preguntas';
$string['saveattemptfailed'] = 'No se ha podido guardar el intento de resolver el cuestionario.';
$string['savedfromdeletedcourse'] = 'Guardado del curso eliminado "{$a}"';
$string['savegrades'] = 'Guardar calificaciones';
$string['savemyanswers'] = 'Guardar mis respuestas';
$string['savenosubmit'] = 'Guardar sin enviar';
$string['saveoverrideandstay'] = 'Guardar e introducir otra excepción';
$string['savequiz'] = 'Guardar todo el cuestionario';
$string['saving'] = 'Guardando';
$string['savingnewgradeforquestion'] = 'Guardando la nueva calificación en la pregunta con id {$a}';
$string['savingnewmaximumgrade'] = 'Guardando la nueva calificación máxima';
$string['score'] = 'Puntuación bruta';
$string['scores'] = 'Puntuaciones -';
$string['search:activity'] = 'Examen - información de actividad';
$string['sectionheadingedit'] = 'Editar cabecera \'{$a}\'';
$string['sectionheadingremove'] = 'Borrar cabecera \'{$a}\'';
$string['sectionnoname'] = 'Sección sin título';
$string['seequestions'] = '(Vea las preguntas)';
$string['select'] = 'Seleccionar';
$string['selectall'] = 'Seleccionar todos';
$string['selectattempt'] = 'Seleccionar intento';
$string['selectcategory'] = 'Seleccionar categoría';
$string['selectedattempts'] = 'Intentos seleccionados...';
$string['selectmultipleitems'] = 'Seleccionar varios elementos';
$string['selectmultipletoolbar'] = 'Seleccionar barra de herramientas múltiple';
$string['selectnone'] = 'Omitir todos';
$string['selectquestionslot'] = 'Seleccionar pregunta {$a}';
$string['selectquestiontype'] = '-- Seleccionar tipo de pregunta --';
$string['serveradded'] = 'Servidor añadido';
$string['serveridentifier'] = 'Identificador';
$string['serverinfo'] = 'Información del servidor';
$string['servers'] = 'Servidores';
$string['serverurl'] = 'URL del servidor';
$string['shortanswer'] = 'Respuesta corta';
$string['show'] = 'Mostrar';
$string['showall'] = 'Mostrar todas las preguntas en una página';
$string['showblocks'] = 'Mostrar bloques durante los intentos';
$string['showblocks_help'] = 'Si se selecciona SÍ, se mostrarán los bloques normales durante los intentos de resolver el cuestionario';
$string['showbreaks'] = 'Mostrar saltos de página';
$string['showcategorycontents'] = 'Mostrar el contenido de la categoría {$a->arrow}';
$string['showcorrectanswer'] = '¿Mostrar la respuesta correcta al finalizar?';
$string['showdetailedmarks'] = 'Mostrar detalles de la puntuación';
$string['showeachpage'] = 'Mostrar una página cada vez';
$string['showfeedback'] = '¿Mostrar resultado al finalizar?';
$string['showinsecurepopup'] = 'Utilizar una ventana emergente \'segura\'';
$string['showlargeimage'] = 'Imagen grande';
$string['shownoattempts'] = 'Mostrar estudiantes sin intentos';
$string['shownoattemptsonly'] = 'Mostrar solamente estudiantes sin intentos';
$string['shownoimage'] = 'sin imagen';
$string['showreport'] = 'Mostrar informe';
$string['showsmallimage'] = 'Imagen pequeña';
$string['showteacherattempts'] = 'Mostrar intentos del profesor';
$string['showuserpicture'] = 'Mostrar la imagen del usuario';
$string['showuserpicture_help'] = 'Si está habilitado, el nombre y la imagen de un estudiante se mostrarán en la pantalla durante el intento y en la pantalla de revisión, lo que facilitará la verificación de que el estudiante haya iniciado sesión como él mismo en un examen vigilado (supervisado).';
$string['shuffle'] = 'Orden al azar';
$string['shuffleanswers'] = 'Respuestas ordenadas al azar';
$string['shuffledrandomly'] = 'Presentadas al azar';
$string['shufflequestions'] = 'Reordenar las preguntas al azar';
$string['shufflequestions_help'] = 'Si está habilitado, cada vez que se intenta realizar el cuestionario, el orden de las preguntas de esta sección se barajará en un orden aleatorio diferente.

Esto puede dificultar que los estudiantes compartan las respuestas, pero también dificulta que los estudiantes discutan una pregunta en particular con el maestro.';
$string['shufflewithin'] = 'Ordenar al azar las respuestas';
$string['shufflewithin_help'] = 'Si habilita esta opción, las respuestas se ordenarán al azar cada vez que un estudiante comience a contestar el cuestionario, suponiendo que la opción también esté habilitada en los ajustes de la pregunta.
Esta opción sólo es aplicable a preguntas que tienen elementos  múltiples, como las preguntas de elección múltiple o de emparejamiento.';
$string['singleanswer'] = 'Seleccione una respuesta.';
$string['sortage'] = 'Ordenar por edad';
$string['sortalpha'] = 'Ordenar alfabéticamente';
$string['sortquestionsbyx'] = 'Ordenar preguntas por: {$a}';
$string['sortsubmit'] = 'Ordenar preguntas';
$string['sorttypealpha'] = 'Ordenar por tipo, nombre';
$string['specificapathnotonquestion'] = 'La ruta al archivo especificado no está en la pregunta especificada';
$string['specificquestionnotonquiz'] = 'La pregunta especificada no está en el cuestionario especificado';
$string['startagain'] = 'Comenzar de nuevo';
$string['startattempt'] = 'Comenzar intento';
$string['startedon'] = 'Comenzado el';
$string['startnewpreview'] = 'Comenzar una nueva previsualización';
$string['stateabandoned'] = 'Nunca enviado';
$string['statefinished'] = 'Finalizado';
$string['statefinisheddetails'] = 'Enviado: {$a}';
$string['stateinprogress'] = 'En curso';
$string['statenotloaded'] = 'El estado de la pregunta {$a} no ha sido cargado desde la base de datos';
$string['stateoverdue'] = 'Atrasados';
$string['stateoverduedetails'] = 'Debe ser presentado por {$a}';
$string['status'] = 'Estatus';
$string['stoponerror'] = 'Parar al encontrar un error';
$string['submission_confirmation'] = '¿Entregar todas sus respuestas y terminar?';
$string['submission_confirmation_unanswered'] = 'Preguntas sin ninguna respuesta: {$a}';
$string['submitallandfinish'] = 'Enviar todo y terminar';
$string['subneterror'] = 'Lo sentimos, este cuestionario ha sido bloqueado de modo que sólo es accesible desde ciertas direcciones. En este momento su ordenador no está autorizado para usar este cuestionario.';
$string['subnetnotice'] = 'Este cuestionario ha sido bloqueado, de modo que sólo es accesible desde ciertas ubicaciones. Su ordenador no está en una sub-red habilitada. Como profesor, puede acceder en cualquier caso a la vista previa.';
$string['subplugintype_quiz'] = 'Informe';
$string['subplugintype_quiz_plural'] = 'Informes';
$string['subplugintype_quizaccess'] = 'Regla de acceso';
$string['subplugintype_quizaccess_plural'] = 'Reglas de acceso';
$string['substitutedby'] = 'serán sustituídas por';
$string['summaryofattempt'] = 'Resumen del intento';
$string['summaryofattempts'] = 'Resumen de sus intentos previos';
$string['temporaryblocked'] = 'Durante cierto tiempo no está autorizado a intentar de nuevo resolver el cuestionario.<br /> Podrá intentarlo nuevamente en:';
$string['theattempt'] = 'El intento';
$string['theattempt_help'] = 'Si el estudiante puede revisar el intento.';
$string['time'] = 'Tiempo';
$string['timecompleted'] = 'Finalizado';
$string['timedelay'] = 'No se le permite realizar el cuestionario debido a que no ha transcurrido el tiempo necesario anterior a un nuevo intento.';
$string['timeleft'] = 'Tiempo restante';
$string['timelimit'] = 'Límite de tiempo';
$string['timelimit_help'] = 'Si está habilitado, el tiempo límite se indica en la página inicial del cuestionario y un temporizador con el tiempo restante se muestra en el bloque de navegación del cuestionario.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Lo sentimos. Se ha sobrepasado el límite de tiempo.';
$string['timestr'] = '%H:%M:%S on %d/%m/%y';
$string['timesup'] = '¡Se ha pasado el tiempo!';
$string['timetaken'] = 'Tiempo empleado';
$string['timing'] = 'Temporalización';
$string['tofile'] = 'al archivo';
$string['tolerance'] = 'Tolerancia';
$string['toomanyrandom'] = '¡El número solicitado de preguntas aleatorias es mayor de las que contiene esta categoría!';
$string['top'] = 'Arriba';
$string['totalmarksx'] = 'Puntuación total: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Total de {$a} preguntas en la categoría.';
$string['true'] = 'Verdadero';
$string['truefalse'] = 'Verdadero/Falso';
$string['type'] = 'Tipo';
$string['unfinished'] = 'abierto';
$string['ungraded'] = 'Sin calificar';
$string['unit'] = 'Unidad';
$string['unknowntype'] = 'Tipo de pregunta no permitida en la línea {$a}. La pregunta no se tendrá en cuenta';
$string['updateoverdueattemptstask'] = 'Actualizando intentos de cuestionario vencidos';
$string['updatequizslotswithrandomxofy'] = 'Actualizando espacios de cuestionarios con datos de preguntas "aleatorias" ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Actualizar ajustes del cuestionario';
$string['updatingatttemptgrades'] = 'Actualizando calificaciones de los intentos';
$string['updatingfinalgrades'] = 'Actualizando calificaciones finales';
$string['updatingthegradebook'] = 'Actualizar el libro de calificaciones.';
$string['upgradesure'] = '<div> En particular, el módulo cuestionario ha sufrido  un amplio cambio en su tabla de la base de datos, y esta actualización no ha sido aún suficientemente probada. Se le recomienda encarecidamente que realice una copia de seguridad de las tablas de base de datos antes de continuar. </div>';
$string['upgradingquizattempts'] = 'Actualizando intentos de cuestionario: cuestionario {$a->done}/{$a->outof} (Quiz id {$a->info})s';
$string['upgradingveryoldquizattempts'] = 'Actualizando intentos de cuestionario muy antiguos:  {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Esta categoría ha sido trasladada al sitio porque, tras eliminar el curso, sus preguntas estaban en uso por otros cuestionarios del servidor.';
$string['useroverrides'] = 'Excepciones de usuario';
$string['useroverridesdeleted'] = 'Excepciones de usuario eliminadas';
$string['usersnone'] = 'Ningún estudiante tiene acceso a este cuestionario';
$string['validate'] = 'Validar';
$string['viewallanswers'] = 'Ver {$a} cuestionarios resueltos';
$string['viewallreports'] = 'Ver los informes de {$a} intentos';
$string['viewed'] = 'Visto';
$string['warningmissingtype'] = '<p><b>Este tipo de pregunta aún no ha sido instalado en su Moodle.<br />Por favor, comuníquelo a su administrador.</b></p>';
$string['wheregrade'] = '¿Dónde está mi calificación?';
$string['wildcard'] = 'Comodín';
$string['windowclosing'] = 'Esta ventana se cerrará en breve.';
$string['withsummary'] = 'con estadísticas resumidas';
$string['wronguse'] = 'Usted no puede usar esta página así';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Necesita matricularse en este curso antes de responder al cuestionario';
$string['yourfinalgradeis'] = 'Su calificación final en este cuestionario es {$a}.';
