<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_training', language 'es_mx', version '4.2'.
 *
 * @package     theme_training
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['banner'] = 'Banner';
$string['bannerdesc'] = 'Active esta casilla si los logos que siguen son de hecho imágenes de banner de ancho completo. Estos deberían de tener un mínimo de 1920 pixeles de ancho.<br>Sugerencia: Si Usted quiere tener su logo y el banner, incorpore su logo adentro de la imagen del banner. ¿Quiere texto en el banner? Inclúyalo en el banner y asegúrese de aplicar el mismo texto para el nombre completo del sitio tal y como está usado para el texto ALTernativo de la imagen.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Entrenamiento (Training)</h2>
<p><img class=img-polaroid src="training/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>Acerca de</h3>
<p>Entrenamiento (Training) es un tema moderno de aspecto simple y fácil que no está amontonado por muchas opciones, lo que es fantástico para principiantes o cuando Usted solamente necesita obtener rápidamente algo que se vea bien.</p>
<h3>hecho por humano</h3>
<p>Entrenamiento (Training) está basado en los temas Bootstrap y Clean , temas responsivos basados en HTML5/Bootstrap 2.3, que inicialmente fueron creados para Moodle 2.5 con la ayuda de:<br>
Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans, Bas Brands y David Scotson.</p>
<h3>Créditos del Tema</h3>
<p>Autores: TNG Consulting Inc. - Michael Milette<br>
Sitio web: <a href="http://www.tngconsulting.ca">www.tngconsulting.ca</a>
</p>
<h3>Reportar problemas:</h3>
<p><a href="https://www.github.com/michael-milette/moodle-theme_training/issues">https://www.github.com/michael-milette/moodle-theme_training/issues</a></p>
</div></div>';
$string['configtitle'] = 'Training (Entrenamiento)';
$string['customcss'] = 'CSS Personalizado';
$string['customcssdesc'] = 'Las reglas CSS serán reflejadas en todas las páginas, haciendo más fácil la personalización de este tema.';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'El favicon )ícono favorito) aparece en las pestañas de algunos navegadores web y también puede aparecer en el escritorio si Usted crea un ícono de un atajo. Los Favicons deberían de ser de 16 pixeles por 16 pixeles en formato de archivo PNG o ICO.<br>Valor por defecto: Ícono de Moodle';
$string['footnote'] = 'Nota al pie';
$string['footnotedesc'] = 'Lo que Usted añada a esta área de texto se mostrará en el pie de página en todo su sitio Moodle.<br>Sugerencia: Usted puede crear columnas en su pie de página al usar <a href="https://getbootstrap.com/2.3.2/scaffolding.html"</a>Bootstrap Scaffolding</a>.';
$string['gridview'] = 'Mampostería (estilo rejilla)';
$string['gridviewdesc'] = 'Mostrar lista de cursos en un estilo de mampostería. Cuando no se activa, el estilo por defecto es ancho completo, en donde la imagen destacada del curso está a la izquierda del resumen del curso. Tenga en cuenta que esta opción no afecta a los listados de la <strong>Lista Combo</strong>';
$string['hidefrontsitepages'] = 'Ocultar páginas del sitio en la Portada';
$string['hidefrontsitepagesdesc'] = 'Ocultar las páginas del sitio en la Portada. Esto le permite crear páginas accesibles públicamente sin habilitarles el acceso de invitados a los usuarios.';
$string['invert'] = 'Invertir BarradeNavegaión';
$string['invertdesc'] = 'Añternar entre blanco y negro el texto y el fondo para la Barra de Navegación en la parte superior de la página';
$string['logo'] = 'Logo';
$string['logodesc'] = 'El logo estándar solamente es mostrado en el encabezado de la Portada y de la página para ingresar.<br>Sugerencia: Los logos pueden ser hasta de 700 pixeles de ancho. No hay límite para la altura, aunque podría comenzar a verse extraño si fuera muy alto.<br>Si aquí no se añade un logo, se usará cualquier logo que esté en Apariencia > Logos. Si eso no existiera, entonces en su lugar aparecerá el Nombre del sitio.';
$string['navbarabove'] = 'Barra de Navegación arriba';
$string['navbarabovedesc'] = 'Poner la Barra de navegación arriba del logo/banner';
$string['pluginname'] = 'Training (Entrenamiento )';
$string['privacy:metadata'] = 'El tema Training no almacena ningún dato personal acerca de ningún usuario.';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['sitelogo'] = 'Logo del sitio';
$string['smalllogo'] = 'Logo pequeño';
$string['smalllogodesc'] = 'El logo pequeño es mostrado en el encabezado de todas las páginas diferentes de la Portada y la página para ingresar al sitio.<br>Sugerencia: Si Usted quiere que el logo sea del mismo tamaño en todas las páginas, suba el mismo tamaño de logo para ambos, el <strong>Logo</strong> y el <strong>Logo pequeño</strong>.<br>Comportamiento por defecto: Si no se añade aquí un logo, se usará el Logo compacto en Apariencia > Logos. Si ese no existiera, en su lugar aparecerá el Nombre del sitio.';
