<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'ru', version '4.2'.
 *
 * @package     local_moodleorg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutstatistics'] = 'Систему Moodle можно загрузить бесплатно и регистрация является добровольной, поэтому у нас нет полной информации обо всех, кто её  использует. Однако, на основе той информации, что у нас есть, мы автоматически генерируем интересные графики и цифры на странице статистики.';
$string['aboutstatisticsheading'] = 'Статистика Moodle';
$string['aboutstatisticstitle'] = 'Moodle.org: Статистика Moodle';
$string['activeusers24hours'] = 'Зарегистрированные пользователи, заходившие на сайт за последние 24 часа:';
$string['activeuserspastmonth'] = 'Зарегистрированные пользователи, заходившие на сайт за последний месяц:';
$string['browsegittitle'] = 'Посмотрите наш исходный код';
$string['cachedef_frontpagecolumn'] = 'Столбцы на главной странице';
$string['cachedef_usefulposts'] = 'Полезные сообщения';
$string['communities'] = 'Сообщества';
$string['communitiesmy'] = 'Мои сообщества';
$string['community'] = 'Сообщество';
$string['communityadministration'] = 'Управление сообществом';
$string['communitycurrent'] = 'Текущее сообщество';
$string['communityenrolme'] = 'Стать членом этого сообщества';
$string['communityenrolmentoptions'] = 'Присоединиться к сообществу';
$string['communityintro'] = 'У Moodle большое и разнообразное сообщество пользователей с более чем <a href="http://moodle.org/userpics">{$a->usercount} зарегистрированными пользователями</a> (и это только на этом сайте) из <a href="http://moodle.org/sites">{$a->countrycount} стран</a>, говорящими более чем на <a href="http://download.moodle.org/langpack/">{$a->langcount} языках</a> (у нас есть <a href="http://moodle.org/stats">подробная статистика</a>).';
$string['communityjoinbyyourself'] = 'Присоединяйтесь самостоятельно';
$string['communityjoinbyyourselfas'] = 'Присоединяйтесь самостоятельно как {$a->rolename}';
$string['communitynoguestaccess'] = 'Гости не могут получить доступ к этой зоне сообщества, попробуйте войти в систему.';
$string['communitynotenrollable'] = 'Вы не можете стать участником этого сообщества самостоятельно. Пожалуйста, свяжитесь с фасилитатором сообщества.';
$string['communitysomeallowguest'] = 'Некоторые сообщества могут разрешить гостевой доступ';
$string['communityunenrolme'] = 'Покинуть сообщество  {$a}';
$string['conferencecenter'] = 'Центр конференций Moodle';
$string['connectedsites'] = 'Некоторые сайты подключены к moodle.org c помощью Moodle Networking, поэтому Вы можете зайти на них как только пройдете аутентификацию здесь.';
$string['donations10over'] = 'Другие пожертвования на сумму от $10';
$string['donationsassociation'] = 'Присоединяйтесь к <a href="https://moodleassociation.org/">Moodle Association</a> и помогайте решать, на развитие каких функций Moodle должны быть направлены членские взносы.';
$string['donationsdevelopment'] = 'Тем не менее, разработка Moodle и обслуживание всех сайтов нашего сообщества стоит немалых денег, и мы всегда рады дополнительной поддержке. Если вам нравится Moodle или считаете его полезным для вашего бизнеса, школы или учреждения, сделайте пожертвование. Даже небольшая сумма будет полезна.';
$string['donationsdonatenow'] = 'Пожертвовать сейчас';
$string['donationsensure'] = 'Пожертвования гарантируют, что наши разработчики продолжат создавать новые функции и исправлять ошибки, делая Moodle лучше для всех нас.';
$string['donationsmoodle'] = 'Пожертвовать для Moodle';
$string['donationsopensource'] = 'Moodle - это по-настоящему открытый исходный код и полная свобода от финансовых обязательств для наших пользователей - именно таким и должно быть программное обеспечение!';
$string['donationsover1000'] = 'Предыдущие пожертвования на сумму более $1000';
$string['donationsover200'] = 'Другие пожертвования свыше $200';
$string['donationsover500'] = 'Другие пожертвования свыше $500';
$string['donationspartner'] = 'Используйте для получения услуг <a href="https://moodle.com/partners/">сертифицированного партнера Moodle</a> — 10% их дохода направляется в проект Moodle.';
$string['donationsshop'] = 'Купите что-нибудь в нашем <a href="http://www.zazzle.com/moodle_hq/">магазине Moodle</a> и пользуйтесь этим с гордостью!';
$string['donationsthankeveryone'] = 'Спасибо всем, кто внес свой вклад в проект Moodle.';
$string['donationsthankyou'] = 'Спасибо!';
$string['donationstitle'] = 'Пожертвования';
$string['donationsways'] = 'Другие способы внести финансовый вклад в Moodle:';
$string['download_activities'] = 'Активные элементы';
$string['download_admintools'] = 'Инструменты администрирования';
$string['download_appdocumentation'] = 'Документация по приложению';
$string['download_appreleasenotes'] = 'Примечания к релизу';
$string['download_browseall'] = 'Просмотреть все';
$string['download_downloadosx'] = 'Скачать Moodle для OS X (содержит Moodle, Apache, MySQL и PHP для работы в Mac OS)';
$string['download_downloadwindows'] = 'Скачать Moodle для Windows (содержит Moodle, Apache, MySQL и PHP для работы в ОС Windows)';
$string['download_forandroid'] = 'Для Android';
$string['download_forios'] = 'Для iOS';
$string['download_helpbox_description'] = 'Прочтите документацию, чтобы начать работу, и посетите форумы наших сообществ, или просто свяжитесь с партнером Moodle для хостинга, установки и других услуг.';
$string['download_helpbox_installing'] = 'Установка Moodle';
$string['download_helpbox_partners'] = 'Партнеры Moodle';
$string['download_helpbox_support'] = 'Форумы поддержки';
$string['download_helpbox_title'] = 'Нужна помощь?';
$string['download_helpbox_upgrading'] = 'Обновление Moodle';
$string['download_hero_description'] = 'Moodle предоставляется на условиях <a class="link" href="http://docs.moodle.org/dev/License">лицензии GPL</a>. Это означает, что любой безвозмездно получает право использовать наше программное обеспечение со всеми его возможностями.<br><br>Ознакомьтесь с последней версией Moodle.';
$string['download_hero_headline'] = 'У Moodle открытый исходный код.';
$string['download_langpackinfo'] = 'Языковые пакеты создаются автоматически в результате работы переводчиков на <a href="http://lang.moodle.org/">сайте перевода</a>. Дополнительные сведения см. <a href="https://docs.moodle.org/dev/Translation">в документации по переводу</a>.';
$string['download_langpackinstallinfo'] = 'Дополнительные языковые пакеты можно установить на свой сайт Moodle через <em> Администрирование > Язык> Языковые пакеты</em> или вручную. Дополнительные сведения см. <a href="https://docs.moodle.org/en/Language_packs">в документации по языковым пакетам</a>.';
$string['download_langpackinstalltitle'] = 'Установка языкового пакета';
$string['download_langpacktitle'] = 'Языковые пакеты для Moodle {$a}';
$string['download_mobileapp'] = 'Мобильное приложение';
$string['download_themes'] = 'Темы';
$string['download_viewallbuilds'] = 'Просмотреть все сборки (для работы требуется веб-сервер, PHP и база данных)';
$string['downloadcore'] = 'Система Moodle распространения в виде доступных для загрузки стандартных пакетов. В них содержится ряд основных модулей, поддерживаемых разработчиками ядра системы. Стандартный пакет можно легко установить практически на любой платформе, где есть PHP и база данных.';
$string['downloadcoretitle'] = 'Стандартные пакеты Moodle';
$string['downloadintro'] = 'Moodle - это свободное ПО, распространяемое по <a href="http://docs.moodle.org/dev/License">лицензии GPL</a>. Все, что мы создаем, доступно Вам для загрузки и использования совершенно бесплатно.';
$string['downloadlang'] = 'В текущих версиях Moodle добавление поддержки для новых языков выполняется через пункт меню «Администрирование» на Вашем сайте. Тем не менее, для некоторых старых версий Moodle, может потребоваться вручную загрузить языковые пакеты.';
$string['downloadlangtitle'] = 'Языковые пакеты';
$string['downloadmac'] = 'Если у Вас нет настроенного веб-сервера, то с помощью этих пакетов «все-в-одном» можно легко установить Moodle на компьютер Apple под управлением Mac OS X.';
$string['downloadmactitle'] = 'Moodle для Mac OS X';
$string['downloadmodules'] = 'Просмотрите нашу всеобъемлющую базу дополнительных модулей и плагинов. Их можно добавить на Ваш с Moodle помимо основных модулей для реализации дополнительного функционала.';
$string['downloadmodulestitle'] = 'Плагины';
$string['downloadthemes'] = 'Внешний вид сайта Moodle может быть быстро изменен с помощью различных тем оформления. У нас есть база тех тем оформления, которые создали и разместили пользователи Moodle.';
$string['downloadthemestitle'] = 'Темы оформления';
$string['downloadviagitcvs'] = 'Другие способы получения Moodle включают <a href="http://docs.moodle.org/en/Git_for_Administrators">загрузку через Git</a> и <a href = "http://docs.moodle.org/22/en/CVS_for_Administrators ">загрузку через CVS</a>.';
$string['downloadwin'] = 'Если у Вас нет настроенного веб-сервера, то с помощью этих пакетов "все-в-одном" можно легко установить Moodle на компьютер под управлением Microsoft Windows.';
$string['downloadwintitle'] = 'Moodle для Windows';
$string['erroradminonly'] = 'Только администраторы могут пользоваться этим интерфейсом.';
$string['erroralreadyvoted'] = 'Вы уже голосовали за {$a}';
$string['errormaxmessages'] = 'Извините, но Вы не можете отправлять больше трех сообщений.';
$string['errornomainnews'] = 'Не удалось найти или создать главный новостной форум для сайта';
$string['errorsendingmail'] = 'Произошла ошибка при отправке сообщения. Пожалуйста, повторите попытку позже или свяжитесь с администратором сайта.';
$string['eventdonation_created'] = 'Список пожертвований создан';
$string['eventdonation_submitted'] = 'Пожертвование отправлено';
$string['events'] = 'Хотя мы и специализируемся на онлайн-обучении, все-таки здорово собраться вместе в одной комнате! Пройдите по этим ссылкам для получения подробной информации о наших конференциях (мы называем их MoodleMoot) и других событиях.';
$string['eventstitle'] = 'События';
$string['feed_events'] = 'События';
$string['feed_events_more'] = 'Больше записей в календаре';
$string['feed_news'] = 'Анонсы';
$string['feed_news_more'] = 'Посмотреть все анонсы';
$string['feed_resources'] = 'Ресурсы';
$string['feed_useful'] = 'Полезные сообщения';
$string['feed_useful_more'] = 'Больше сообщений';
$string['focusbox_community'] = 'Поддержка и форумы сообщества';
$string['focusbox_community_text'] = 'Получите поддержку и поделитесь идеями на своем родном языке.';
$string['focusbox_community_viewall'] = 'Все сообщества';
$string['focusbox_future'] = 'Помогите сформировать будущее Moodle';
$string['focusbox_future_crowdfund'] = 'Проекты на пожертвования';
$string['focusbox_future_gdf'] = 'Форум разработчиков';
$string['focusbox_future_research'] = 'Исследования Moodle';
$string['focusbox_future_roadmap'] = 'План развития';
$string['focusbox_future_text'] = 'Узнайте, что будет дальше, и помогите изменить мир к лучшему.';
$string['focusbox_future_ux'] = 'Обсуждения восприятия пользователей';
$string['focusbox_settingup'] = 'Установка';
$string['focusbox_settingup_community'] = 'Поддержка сообщества';
$string['focusbox_settingup_download'] = 'Скачать бесплатно';
$string['focusbox_settingup_hosting'] = 'Хостинг';
$string['focusbox_settingup_install'] = 'Установка';
$string['focusbox_settingup_own'] = 'Самостоятельно';
$string['focusbox_settingup_partner'] = 'Через партнера Moodle';
$string['focusbox_settingup_plugins'] = 'Плагины';
$string['focusbox_settingup_support'] = 'Коммерческая поддержка';
$string['focusbox_teaching'] = 'Обучение с помощью Moodle';
$string['focusbox_teaching_books'] = 'Книги';
$string['focusbox_teaching_courses'] = 'Курсы и образовательный контент';
$string['focusbox_teaching_docs'] = 'Документация';
$string['focusbox_teaching_text'] = 'Взгляните на широкий спектр возможностей Moodle и доступных ресурсов.';
$string['focusbox_theproject'] = 'Проект Moodle';
$string['focusbox_theproject_about'] = 'О Moodle';
$string['focusbox_theproject_devs'] = 'Разработчики';
$string['focusbox_theproject_hq'] = 'Штаб-квартира Moodle';
$string['focusbox_theproject_mua'] = 'Ассоциация пользователей Moodle';
$string['focusbox_theproject_partners'] = 'Партнеры Moodle';
$string['focusbox_theproject_stats'] = 'Статистика';
$string['focusbox_theproject_text'] = 'Узнайте больше о проекте Moodle и наших открытых партнерских отношениях.';
$string['focusbox_uptodate'] = 'В ногу со временем';
$string['focusbox_uptodate_buzz'] = 'Публикации о Moodle';
$string['focusbox_uptodate_news'] = 'Объявления';
$string['focusbox_uptodate_planet'] = 'Планета Moodle';
$string['focusbox_uptodate_security'] = 'Извещения, связанные с безопасностью';
$string['focusbox_uptodate_social'] = 'Социальные медиа';
$string['focusbox_uptodate_text'] = 'Последние новости, обновления и прогнозы о Moodle со всего света.';
$string['generaldeveloperforum'] = 'Основной форум разработчиков';
$string['graphpopulation'] = 'График численности Moodle';
$string['graphregistrationmap'] = 'Карта регистрации Moodle';
$string['graphregistrationmapdesc'] = 'Первая десятка стран по числу зарегистрированных сайтов (всего стран: {$a})';
$string['graphusersites'] = 'Сравнение «пользователей Moodle / сайт»';
$string['heroslide_community_description'] = 'Добро пожаловать в сообщество Moodle! Откройте для себя результат совместных усилий одной из крупнейших в мире команд разработчиков ПО с открытым исходным кодом.';
$string['heroslide_community_headline'] = 'Управляется сообществом, поддерживается всем миром.';
$string['heroslide_community_slidecontrol'] = 'Поддерживается глобальным сообществом пользователей';
$string['heroslide_donate_headline'] = 'Помогите нам в поддержке открытого и качественного образования для всех';
$string['heroslide_getstarted40_description'] = 'Moodle обладает новой индивидуальностью и переопределенный пользовательский интерфейс совершенствует онлайн-обучение для преподавателей, учащихся и администраторов.';
$string['heroslide_getstarted40_headline'] = 'Moodle 4.0 - новый внешний вид, лучший пользовательский интерфейс!';
$string['heroslide_getstarted40_slidecontrol'] = 'Moodle 4.0 уже здесь!';
$string['heroslide_getstarted_description'] = 'Moodle — самая популярная в мире система управления обучением. Начните создавать свой сайт онлайн-обучения уже через несколько минут!';
$string['heroslide_getstarted_headline'] = 'Легкое начало';
$string['heroslide_getstarted_slidecontrol'] = 'Начните сегодня';
$string['heroslide_global_description'] = 'Доступная более чем на 100 языках, система Moodle пользуется доверием организаций и учреждений, больших и малых, и насчитывает миллионы пользователей по всему миру.';
$string['heroslide_global_headline'] = 'Используется для создания образовательных сред во всем мире';
$string['heroslide_global_slidecontrol'] = 'В основе образовательных систем по всему миру';
$string['heroslide_link_demo'] = 'Демонстрация';
$string['heroslide_link_donate'] = 'Пожертвования';
$string['heroslide_link_features'] = 'Функции';
$string['heroslide_link_forums'] = 'Форумы сообщества';
$string['heroslide_link_getstarted'] = 'Начните сегодня';
$string['heroslide_link_getstarted40'] = 'Узнайте о Moodle 4.0';
$string['heroslide_link_sites'] = 'Зарегистрированные сайты';
$string['heroslide_link_stats'] = 'Статистика';
$string['heroslide_link_stories'] = 'Прочесть больше';
$string['heroslide_power40_description'] = 'Легко, быстро и интуитивно понятно! Ознакомьтесь с улучшенным пользовательским интерфейсом и новыми функциями Moodle 4.0.';
$string['heroslide_power40_headline'] = 'Опыт Moodle 4.0';
$string['heroslide_power40_slidecontrol'] = 'Опыт Moodle 4.0';
$string['heroslide_power_description'] = 'Распространенная во всем мире бесплатная образовательная платформа, которая помогает эффективно преподавать и учиться в совместной частной среде.';
$string['heroslide_power_headline'] = 'Мощная. Безопасная. Открытый исходный код.';
$string['heroslide_power_slidecontrol'] = 'Надежная платформа для обучения с открытым исходным кодом';
$string['heroslide_story1_description'] = '«Использование лидирующих технологий в обучении позволяет нам раскрыть творческие способности учащихся». — профессор Даррелл Эванс, проректор (обучение и преподавание) университета Монаш';
$string['heroslide_story1_headline'] = 'Улучшение преподавания и обучения повсюду';
$string['heroslide_story2_description'] = 'GAC — глобальный поставщик услуг в области доставки, логистики и морских услуг через свою Корпоративную Академию предоставляет возможности по обучению и развитию более 10 000 сотрудников в более чем 70 странах.';
$string['heroslide_story2_headline'] = 'Достижение совершенства в корпоративном обучении';
$string['heroslide_story3_description'] = 'Колледж Форт-Вэлли, один из крупнейших колледжей Шотландии, размещает на своих сайтах более 750 курсов для более чем 20 000 активных пользователей.';
$string['heroslide_story3_headline'] = 'Обеспечение всестороннего гибкого образования';
$string['heroslide_story4_description'] = 'Волонтерская организация Voluntary Service Overseas (VSO) обеспечивает интерактивное обучение и поддержку волонтерам по всему миру, чтобы сделать возможными глобальные подходы к обучению.';
$string['heroslide_story4_headline'] = 'Волонтерская помощь в реализации программ по борьбе с бедностью';
$string['heroslide_story_slidecontrol'] = 'Истории о Moodle со всего мира';
$string['jobs'] = 'В нашей базе данных содержится информация со всего мира о вакансиях, связанных с Moodle.';
$string['logoinfo'] = 'Название Moodle ™ является зарегистрированным товарным знаком Moodle Trust.

Если вы намереваетесь использовать название и/или логотип для рекламы услуг, связанных с Moodle (например, хостинг Moodle, поддержка Moodle, сертификация Moodle, обучение работе с Moodle, консультирование по Moodle, настройка Moodle, разработка обучающих систем с Moodle, разработка тем для Moodle, интеграция Moodle, установка Moodle и т. д.) или в качестве названия программного пакета, то вы должны запросить и получить прямое письменное разрешение от Moodle Trust через [moodle.com helpdesk] (http://moodle.com/helpdesk/) в соответствии с обычными ограничениями на товарный знак.

Нет никаких ограничений на то, как вы используете имя в других случаях (например, если вы используете Moodle только для предоставления курсов, тогда вы можете свободно использовать имя для ссылки на него). Если вы не уверены в каком-то конкретном случае, пожалуйста, задайте вопрос через [службу поддержки moodle.com](http://moodle.com/helpdesk/). Мы будем рады предоставить вам официальное письменное разрешение или помочь скорректировать вашу формулировку.';
$string['logotitle'] = 'Логотип Moodle';
$string['manageads'] = 'Управление партнерской рекламой';
$string['managedonations'] = 'Управление пожертвованиями';
$string['moodleorg:manageads'] = 'Управлять партнерской рекламой';
$string['moodleorg:managedonations'] = 'Управлять реестром пожертвований';
$string['moodlepartner_corporate'] = 'Корпоративное обучение';
$string['moodlepartner_other'] = 'Другие заведения';
$string['moodlepartner_school'] = 'Школа';
$string['moodlepartner_university'] = 'Университет';
$string['networkinfo'] = 'Следующие сайты Moodle были подключены к moodle.org через сеть Moodle, так что вы можете войти на них прямо отсюда.';
$string['networktitle'] = 'Подключенные сайты';
$string['newregistrations'] = 'Новые регистрации';
$string['newstitle'] = 'Анонсы';
$string['noenrolledcoursesyet'] = 'Вы еще не записаны ни на один курс на этом сайте';
$string['partnerslogan'] = 'Проект Moodle поддерживают более 90 сертифицированных <a href="https://moodle.com/partners/">партнеров Moodle</a> во всем мире.';
$string['permalink'] = 'Постоянная ссылка';
$string['pluginname'] = 'Сайт Moodle.org';
$string['popularissues'] = 'Самые популярные ошибки';
$string['privacy:metadata:db:registerdonations'] = 'Ведет учет пожертвований Moodle';
$string['privacy:metadata:db:registerdonations:amount'] = 'Пожертвованная сумма';
$string['privacy:metadata:db:registerdonations:name'] = 'Имя благотворителя';
$string['privacy:metadata:db:registerdonations:org'] = 'Организация-благотворитель';
$string['privacy:metadata:db:registerdonations:timedonated'] = 'Отметка времени пожертвования';
$string['privacy:metadata:db:registerdonations:url'] = 'URL-адрес благотворителя';
$string['recentlyratedposts'] = 'Недавно оцененные сообщения';
$string['recentpart'] = 'На этой странице показаны некоторые люди, которые сегодня используют moodle.org';
$string['registeredsites'] = 'Образовательные учреждения не обязаны информировать кого-либо, если они используют Moodle, так как Moodle — это свободное ПО. Однако, некоторые сайты решили зарегистрироваться, и у нас есть их список.';
$string['registeredsitestitle'] = 'Зарегистрированные сайты';
$string['registereduserslastday'] = 'Новые пользователи за последние 24 часа:';
$string['registereduserstotal'] = 'Всего зарегистрированных пользователей:';
$string['registrationgraphalt'] = 'Регистрации Moodle за все время';
$string['registrationgraphdesc'] = 'Мы <a href="http://docs.moodle.org/en/Usage">регулярно проверяем сайты</a>, чтобы быть уверенными, что они еще работают. Поэтому, возможно, вы увидите сокращение их числа.';
$string['registrationslast6months'] = 'Регистрации за последние 6 месяцев';
$string['registrationslastmonths'] = 'Регистрации за последние {$a} мес.';
$string['registrationstotal'] = 'Все текущие регистрации';
$string['resources_buzz'] = 'Публикации';
$string['resources_courses'] = 'Курсы';
$string['resources_jobs'] = 'Вакансии';
$string['resources_plugins'] = 'Плагины';
$string['roadmap'] = 'План развития Moodle';
$string['rssdescription'] = 'Недавние или оцененные полезные сообщения на форуме сайта moodle.org.';
$string['rssmoodlecommore'] = 'Посмотреть все последние новости';
$string['rssmoodlecomtitle'] = 'Последние новости';
$string['rsstitle'] = 'Сообщения на форумах Moodle.org';
$string['searchmoodleorg'] = 'Поиск на moodle.org';
$string['securitytitle'] = 'Извещения, связанные с безопасностью';
$string['shop'] = 'Ищите способ показать себя частью сообщества? Посетите магазины футболок, кружек и других вещей.';
$string['social-facebook-moodle'] = 'Официальная страница Moodle в Facebook';
$string['social-googleplus-community'] = 'Официальная страница сообщества Moodle в Google+';
$string['social-googleplus-moodle'] = 'Официальная страница Moodle в Google+';
$string['social-linkedin-moodle'] = 'Официальная страница Moodle в LinkedIn';
$string['social-twitter-moodle'] = 'Официальные объявления Moodle, сводные новости разделов «Планета Moodle» и «Публикации о Moodle», а также полезные сообщения на форуме';
$string['social-twitter-moodledev'] = 'Обновления и новости о разработке Moodle';
$string['social-twitter-moodlehq'] = 'Твиты от штаб-квартиры Moodle';
$string['social-twitter-moodlejobs'] = 'Предлагаются вакансии, связанные с Moodle';
$string['social-twitter-moodlenet'] = 'Общедоступные курсы и контент Moodle';
$string['social-twitter-moodleplugins'] = 'Недавно выпущенные дополнения Moodle';
$string['social-twitter-moodleresearch'] = 'Новости и обновления о ежегодной исследовательской конференции Moodle и исследованиях, связанных с Moodle';
$string['social-twitter-moodlesecurity'] = 'Извещения, связанные с информационной безопасностью Moodle';
$string['social-twitter-moodlesites'] = 'Обновления состояния сети сайтов и сервисов штаб-квартиры Moodle';
$string['social-twitter-moodlethemes'] = 'Недавно выпущенные темы Moodle';
$string['social-youtube-moodle'] = 'Официальный канал Moodle на YouTube';
$string['socialinfo'] = 'Мы присутствуем на сайтах нескольких социальных сетей, чтобы улучшить осведомленность о проекте Moodle и поделиться последними новостями и событиями в мире Moodle. Подписывайтесь, чтобы оставаться в курсе и знакомиться с другими участниками сообщества!';
$string['socialtitle'] = 'Социальные медиа';
$string['statscountries'] = 'Стран';
$string['statscourses'] = 'Курсов';
$string['statsenrolments'] = 'Записей на курсы';
$string['statsposts'] = 'Сообщений в форумах';
$string['statsquestions'] = 'Вопросов для тестов';
$string['statsresources'] = 'Ресуров';
$string['statsteachers'] = 'Преподавателей';
$string['statsusers'] = 'Пользователей';
$string['supportbooks'] = 'У нас есть список книг про Moodle, доступных для покупки.';
$string['supportcommercial'] = 'Партнеры Moodle — это сертифицированные поставщики услуг по всему миру, которые могут помочь вам с внедрением Moodle.';
$string['supportdocs1'] = 'Лучше всего начать с Документации Moodle, особенно со страниц с часто задаваемыми вопросами (FAQ).';
$string['supportdocs2'] = 'Хороший путь получения нужной документации — использование ссылки «Документация Moodle для этой страницы» в нижней части каждой страницы вашего сайта Moodle.';
$string['supportdocsfaq'] = 'Часто задаваемые вопросы (FAQ)';
$string['supportdocslang'] = 'Документация Moodle на других языках';
$string['supportforums'] = 'Наше сообщество пользователей общается на форумах в составе «курсов» на этом сайте, работающем на Moodle. Вы можете «записаться» на курс, чтобы писать в форуме (запись полностью бесплатна).';
$string['supportforumsenglish'] = 'Основные обсуждения связанные с поддержкой и разработкой проходят между пользователями и разработчиками на английском языке здесь:';
$string['supportforumsenglishname'] = 'Использование Moodle';
$string['supportforumslang'] = 'Главный форум пользователей Moodle для общения на английском языке здесь:';
$string['supportforumslangname'] = 'Гостиная Moodle';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=25';
$string['supportforumslist'] = 'Также есть другие форумы, на разных языках:';
$string['supportforumslistname'] = 'Список всех курсов';
$string['supportintro'] = 'Вы не одиноки! Есть несколько способов получить помощь по работе с Moodle, когда она Вам понадобится.';
$string['syncregistrationstask'] = 'Синхронизация обновлений регистрации сайта 1.9 с moodle.net';
$string['top10countriesbyregistration'] = 'Топ-10 стран по количеству регистраций';
$string['top10sitesbycourses'] = 'Первая десятка сайтов по числу курсов';
$string['top10sitesbyusers'] = 'Первая десятка сайтов по числу пользователей';
$string['url-about'] = 'http://docs.moodle.org/en/About_Moodle';
$string['url-features'] = 'http://docs.moodle.org/en/Features';
$string['url-install'] = 'http://docs.moodle.org/en/Installation';
$string['url-standards'] = 'http://docs.moodle.org/en/Standards';
$string['url-userdocs'] = 'http://docs.moodle.org/en/';
$string['versionsused'] = 'Используемые версии';
