<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_hub', language 'de', version '4.2'.
 *
 * @package     local_hub
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Aktivitäten';
$string['additionaladmindesc'] = 'Registriert: {$a->timeregistered} - Verändert: {$a->timemodified} - Datenschutz: {$a->privacy} -
    Kontaktierbar: {$a->contactable} - Email: {$a->emailalert}';
$string['additionaldesc'] = 'Kurse: {$a->courses} - Nutzer: {$a->users} - Einschreibungen: {$a->enrolments} -  Arbeitsmaterialien:{$a->resources} - Beiträge: {$a->posts}
    - Fragen: {$a->questions} - Durchschnittliche Teilnehmerzahl: {$a->participantnumberavg} - Durchschnittliche Anzahl Kursmodule: {$a->modulenumberavg}';
$string['addscreenshots'] = 'Screenshots hinzufügen';
$string['addscreenshots_help'] = 'Neue Screenshots hinzufügen.';
$string['allowglobalsearch'] = 'Diesen Hub veröffentlichen und globale Suche aller Kurse zulassen';
$string['allowpublicsearch'] = 'Diesen Hub veröffentlichen und Einschreibung erlauben';
$string['audience'] = 'Ausgelegt für';
$string['audience_help'] = 'Nach welcher Art Kurse suchen Sie? Sie können nach traditionellen Kursen für Lerner suchen, aber auch nach Communities für Lehrer oder Moodle-Administratoren';
$string['audienceadmins'] = 'Moodle Administratoren';
$string['audienceeducators'] = 'Lehrer';
$string['audiencestudents'] = 'Lerner';
$string['badurlformat'] = 'Ungültiges URL Format';
$string['blocks'] = 'Blöcke';
$string['bulkdelete'] = 'Löschen';
$string['bulknotvisible'] = 'Unsichtbar machen';
$string['bulkoperation'] = 'Auswählen';
$string['bulkoperationperform'] = 'Durchführen';
$string['bulkselectoperation'] = 'Mit ausgewählten Kursen...';
$string['bulkvisible'] = 'Sichtbar machen';
$string['cannotregisternotavailablesite'] = 'Dieser Hub kann nicht auf Ihre Website zugreifen.';
$string['cannotregisterprivatehub'] = 'Sie können diesen Hub nicht registrieren. Ändern Sie Ihre Datenschutzeinstellungen.';
$string['cannotsetpasswordforpublichub'] = 'Kann kein Passwort für den öffentlichen Hub setzen. Löschen Sie Ihr Passwort oder setzen Sie den Hub auf privat.';
$string['comments'] = 'Kommentare';
$string['community'] = 'Community';
$string['confirmbulkdelete'] = 'Bestätigungen löschen';
$string['confirmbulknotvisible'] = 'Bulk unsichtbare Bestätigungen';
$string['confirmbulkvisible'] = 'Bulk sichtbare Bestätigungen';
$string['confirmforceunregistration'] = 'Auf dem Hubverzeichnis werden keine Informationen geändert. Sind Sie sicher, dass Sie die Löschung der Registrierung erzwingen wollen?';
$string['confirmmessagebulkdelete'] = 'Sind Sie sicher, dass Sie die folgenden Kurse löschen wollen?';
$string['confirmmessagebulknotvisible'] = 'Sind Sie sicher, dass Sie die folgenden Kurse unsichtbar machen wollen?:';
$string['confirmmessagebulkvisible'] = 'Sind Sie sicher, dass Sie die folgenden Kurse sichtbar machen wollen?:';
$string['confirmregistration'] = 'Registrierung bestätigen';
$string['confirmunregistration'] = 'Sind Sie sicher, dass Sie die Registrierung im Hubverzeichnis entfernen wollen??';
$string['contactemail'] = 'Kontakt Email';
$string['contactemail_help'] = 'Die Kontakt-Email wird der Administrator des Hub-Verzeichnisses benutzen, um bei wichtigen Problemen Kontakt zum Hub-Administrator aufzunehmen.';
$string['contactname'] = 'Kontakt Name';
$string['contactname_help'] = 'Der Hub-Administrator ist die Person, die der Administrator des Hubverzeichnisses bei wichtigen Problemen kontaktiert.';
$string['contentinfo'] = 'Fach: {$a->subject} - Zielgruppe: {$a->audience} - Ausbildungsniveau: {$a->educationallevel}';
$string['contributornames'] = 'Namen der Beiträger';
$string['contributornames_help'] = 'andere Beiträger zum Kurs.';
$string['contributors'] = 'Beiträger: {$a}';
$string['copied'] = 'Eine neue Instanz registrieren';
$string['country'] = 'Land';
$string['country_help'] = 'Nur Instanzen aus dem gewählten Land anzeigen.';
$string['coursedesc'] = 'Beschreibung';
$string['coursedesc_help'] = 'Kursbeschreibung';
$string['courselang'] = 'Sprache';
$string['courselang_help'] = 'Kurssprache';
$string['coursemap'] = 'Kursschema';
$string['coursename'] = 'Name';
$string['coursename_help'] = 'Kursname';
$string['coursenotvisible'] = '{$a} ist im Moment nicht sichtbar.';
$string['courseprivate'] = 'Privat';
$string['coursepublic'] = 'Öffentlich';
$string['coursepublished'] = 'Kurs veröffentlicht';
$string['coursesettings'] = 'Kurseinstellungen';
$string['coursesettingsform'] = '"{$a}" Einstellungen';
$string['coursesettingsupdated'] = '{$a} wurden aktualisiert.';
$string['courseshortname'] = 'Kurzname';
$string['coursesnumber'] = 'Anzahl der Kurse ({$a})';
$string['coursetimemodified'] = 'Zeitpunkt der Veränderung: {$a}';
$string['coursetotal'] = '{$a} Kurse wurden gefunden.';
$string['coursetype'] = 'Typ: {$a}';
$string['courseurl'] = 'Kurs URL';
$string['courseurl_help'] = 'Kurs URL';
$string['coursevisibility'] = 'Sichtbar';
$string['coursevisibility_help'] = 'Wenn aktiviert, wird der Kurs in den Suchergebnissen gezeigt.';
$string['coursevisible'] = '{$a} ist jetzt sichtbar.';
$string['coverage'] = 'Tags: {$a}';
$string['creatorname'] = 'Name des Kurserstellers';
$string['creatorname_help'] = 'der Ersteller des Kurses.';
$string['creatornotes'] = 'Notizen Kursersteller';
$string['creatornotes_help'] = 'einige Notizen zur Benutzung des Kurses.';
$string['deleteconfirmation'] = 'Der Administrator wird eine Mail mit Erläuterungen zum Löschen der Registrierung seiner Instanz bekommen.';
$string['deletecourseconfirmation'] = 'Den {$a} Kurs wirklich löschen ?';
$string['deleterelatedcourseslink'] = 'ähnliche Kurse';
$string['deletesite'] = 'Registrierung löschen {$a}';
$string['demourl'] = 'Demo URL';
$string['demourl_help'] = 'Das könnte eine von Ihnen installierte Demo-Site sein; ein Demo-Link wird in den Suchergebnissen angezeigt..';
$string['description'] = 'Beschreibung';
$string['description_help'] = 'Die Hub-Beschreibung wird immer im Hub-Verzeichnis sichtbar sein.';
$string['donotdeleteormodify'] = 'DIESEN NUTZER NICHT LÖSCHEN ODER VERÄNDERN!';
$string['downloadable'] = 'Kurse zum Download';
$string['editcourse'] = 'Editieren';
$string['educationallevel'] = 'Bildungsniveau';
$string['educationallevel_help'] = 'Nach welchem Bildungsniveau suchen Sie? Im Falle von Lehrer-Communities beschreibt dies das Niveau, auf dem sie unterrichten.';
$string['edulevelassociation'] = 'Vereinigung';
$string['edulevelcorporate'] = 'Firma';
$string['edulevelgovernment'] = 'Regierung / Verwaltung';
$string['edulevelother'] = 'Andere';
$string['edulevelprimary'] = 'Primarstufe';
$string['edulevelsecondary'] = 'Sekundarstufe';
$string['eduleveltertiary'] = 'Tertiärstufe';
$string['emailmessage'] = 'Nachricht';
$string['emailmessage_help'] = 'Inhalt der Nachricht.';
$string['emailmessagesiteadded'] = 'Eine neue Instanz hat sich gerade am Hub registriert unter {$a->huburl}

Name: {$a->name}
URL: {$a->url}
Admin: {$a->contactname} ({$a->contactemail})
Sprache {$a->language}

Um registrierte Instanzen zu verwalten gehe zu: {$a->managesiteurl}';
$string['emailmessagesitedeleted'] = 'Ein Administrator von {$a->hubname} ({$a->huburl}) entfernte {$a->sitename} ({$a->siteurl}) aus der Hubliste.
Wenn Sie sich wieder auf dem Hub registrieren wollen, müssen Sie erst Ihre Registrierung auf Ihrem Server zurücksetzen. Gehen Sie zu {$a->unregisterpagelink}.';
$string['emailmessagesiteurlchanged'] = '{$a->name} Instanz wurde aktualisiert. (previous name: {$a->oldname})
Die neue URL {$a->url} wurde aktualisiert von ({$a->oldurl}).

Name: {$a->name}
URL: {$a->url}
Admin: {$a->contactname} ({$a->contactemail})
Sprache {$a->language}

Um registrierte Instanzen zu verwalten, gehe zu: {$a->managesiteurl}';
$string['emailmessageurlalreadyexists'] = 'Nicht klicken ohne verstanden zu haben, dass es ein Versuch sein könnte, die Registrierung der Instanz zu stehlen!

{$a->hubname} Der Hub erkennt eine Instanz, die sich mit der  {$a->existingsite}\'s URL zu registrieren versucht.
Das passiert üblicherweise, wenn man versucht eine Moodleinstanz zu registrieren auf einer URL die schon mit einer anderen Moodleinstanz registriert ist ({$a->url}) .
Um eine neu installierte oder verschobene Moodleinstanz zu registrieren muss zunächst die vorherige Registrierung gelöscht werden: {$a->deletesiteregistration}';
$string['emailtitlesiteadded'] = '{$a} Instanz wurde zum Hub hinzugefügt';
$string['emailtitlesitedeleted'] = '{$a->sitename}wurde vom Hub {$a->hubname} gelöscht';
$string['emailtitlesiteurlchanged'] = '{$a} Instanz hat Namen oder URL geändert. Bitte überprüfen.';
$string['emailtitleurlalreadyexists'] = 'Eine andere Instanz versucht sich mit der URL {$a->existingsite} zu registrieren.';
$string['enabled'] = 'Aktiviert';
$string['enabled_help'] = 'Sie können den Hubserver aktivieren / deaktivieren.';
$string['enablerssfeeds'] = 'RSS feeds';
$string['enablerssfeeds_help'] = 'Wenn aktiviert, wird ein RSS-Symbol am unteren Rand der Suchseite angezeit. Wenn deaktiviert, kann RSS nicht gelesen werden.';
$string['enroldownload'] = 'Finde';
$string['enroldownload_help'] = 'Einige Kurse in diesem Verzeichnis werden hier beworben, so dass man sie auf der originalen Instanz nutzen kann.

Andere sind Kurs-Muster, die Sie downloaden und in Ihrer eigenen Moodleinstanz nutzen können.';
$string['enrollable'] = 'Kurse, in die ich mich einschreiben kann';
$string['errorbadimageheightwidth'] = 'Die Grafik sollte eine maximale Größe von {$a->width} X {$a->height}haben';
$string['errorlangnotrecognized'] = 'Moodle kennt den Sprachcode nicht. Bitte kontaktieren Sie{$a}';
$string['errormaxpublication'] = 'Entschuldigung. Ihre Instanz hat heute bereits mehr als {$a->maxpublication} Kurse veröffentlicht. Sie können weitere Kurse veröffentlichen in: {$a->time}.';
$string['errornopublication'] = 'Der Hubserver weist alle neuen Veröffentlichungen ab.';
$string['errorregistration'] = 'Ein Fehler ist bei der Registrierung aufgetreten. Bitte versuchen Sie es später noch einmal. ({$a})';
$string['errorunregistration'] = 'Ein Fehler ist bei der Löschung der Registrierung aufgetreten. Bitte versuchen Sie es später noch einmal. ({$a})';
$string['errorwrongpostdata'] = 'Einige POST Daten fehlen. Bitte nutzen Sie das Moodle-Registrierungsformular.';
$string['failunregistrationofprivate'] = 'Konnte die Registrierung vom Hub nicht löschen, bitte versuchen Sie es auf der Registrierungsseite ({$a}).';
$string['fileinfo'] = 'Sprache: {$a->lang} - Lizenz: {$a->license} -  Zeit des Updates: {$a->timeupdated}';
$string['freshmoodleconfmsg'] = 'Sind Sie sicher, dass die vorherige Registrierung durch die neue ersetzt werden soll?';
$string['freshmoodleregistrationerror'] = 'Sie versuchen eine Instanz zu registrieren mit einer URL die vorher mit einer registrierten Instanz benutzt wurde. Dieser Administrator kann die vorherige Registrierung vom Hub löschen.
Wenn er / sie dies tut, können Sie Ihre Instanz registrieren. Hinweis: Normalerweise sollten Sie dieser Administrator sein. Dieser Schritt soll vor Hacken der Instanz schützen. Danke.';
$string['freshmoodleregistrationerror2'] = 'Sie versuchen eine Instanz zu registrieren mit einer URL die vorher mit einer registrierten Instanz benutzt wurde. Eine Anfrage wurde bereits an den Administrator dieser anderen Instanz geschickt.';
$string['freshtokenerror'] = 'Entschuldigung, der Token ist ungültig oder wurde bereits benutzt.';
$string['hideguestbutton'] = 'Moodle hat die Option \'Guest login button\' zu  \'Hide\'verändert.';
$string['hub'] = 'Hub';
$string['hub:registercourse'] = 'Einen Kurs auf dem Hub registrieren oder aktualisieren.';
$string['hub:unregistercourse'] = 'Einen Kurs vom Hub löschen.';
$string['hub:updateinfo'] = 'Registrierte Instanz aktualisieren.';
$string['hub:view'] = 'Zeige Kurse / Instanzen.';
$string['hub:viewinfo'] = 'Zeige detaillierte Informationen zum Hub (Kontakte, Statistiken).';
$string['hub:viewsmallinfo'] = 'Zeige Hub-Informationen.';
$string['hubcoursessearch'] = 'Hub Kurse';
$string['hubdetails'] = 'Hub Details';
$string['hubforceunregister'] = 'Löschen der Registrierung erzwingen';
$string['hubimage'] = 'Image';
$string['hubimage_help'] = 'Dieses Bild wird auf Ihrem Hub gespeichert. Wenn Ihr Hub registriert ist, wird das Hubverzeichnis versuchen, darauf über http zuzugreifen um es zu cachen. Wenn dies keinen Erfolg hat, wird im Hubverzeichnis kein Bild angezeigt.';
$string['hublang'] = 'Sprache';
$string['hublang_help'] = 'Die Hauptsprache des Hubs.';
$string['hubpassword'] = 'Passwort';
$string['hubpassword_help'] = 'Wenn Sie hier ein Passwort angeben, muss jede Instanz dieses Passwort bei der Registrierung angeben. Wir empfehlen, dieses Passwort den jeweiligen Administratoren persönlich mitzuteilen. Nur ein privater Hub kann ein Passwort setzen.';
$string['hubregister'] = 'Registrieren Sie Ihren Hub bei moodle.org';
$string['hubregisterupdate'] = 'Aktualisieren Sie Ihre Registrierung bei Moodle.org';
$string['hubregistrationcomment'] = 'Sie sind dabei Ihren Hub bei Moodle.org zu registrieren.  Moodle.org wird diesen Hub periodisch kontaktieren um sicherzustellen, dass er noch aktiv ist, und dabei diese Information aktualisieren.';
$string['hubunregister'] = 'Registrierung löschen';
$string['hubversion'] = 'Hub version';
$string['hubwsroledescription'] = 'WARNUNG: DIESE ROLLE NICHT LÖSCHEN. SIE IST INTERN FÜR EINE REGISTRIERTE INSTANZ; EINEN HUBSERVER ODER MOODLE:ORG GESETZT WORDEN.';
$string['hubwsuserdescription'] = 'WARNuNG: DIESEN NUTZER NICHT LÖSCHEN ODER VERÄNDERN: Er IST INTERN FÜR EINE REGISTRIERTE INSTANZ; EINEN HUBSERVER ODER MOODLE:ORG GESETZT WORDEN.';
$string['image'] = 'Bild';
$string['information'] = 'Information';
$string['keepcurrentimage'] = 'Derzeitiges Bild behalten';
$string['keepcurrentimage_help'] = 'Derzeitiges Bild auf dem Speicher behalten. Auch wenn Sie unten ein Bild wählen, wird dieses Bild behalten. Wenn Sie die Markierung entfernen und kein neues Bild wählen, wird das jetzuge Bild gelöscht.';
$string['keepscreenshot'] = 'Screenshot behalten';
$string['keepscreenshot_help'] = 'Markierung entfernen um Screenshot zu löschen.';
$string['keywords'] = 'Schlagworte';
$string['keywords_help'] = 'Sie können nach Kursen suchen mit spezifischem Text in Name, Beschreibung oder anderen Datenbankfeldern.';
$string['language'] = 'Sprache';
$string['language_help'] = 'Sie können nach Kursen in einer bestimmten Sprache suchen.';
$string['lastmodified'] = 'Zuletzt geändert';
$string['lastmodified_help'] = 'Die zuletzt geänderten Kurse in einem vorgegebenen Zeitraum zeigen.';
$string['licence'] = 'Lizenz';
$string['licence_help'] = 'Sie können nach Kursen mit einer bestimmten Lizenz suchen.';
$string['logourl'] = 'Logo URL';
$string['managecourses'] = 'Kurse verwalten';
$string['managesites'] = 'Instanzen verwalten';
$string['maxcoursesperday'] = 'Maximale Kursveröffentlichungen pro Tag';
$string['maxcoursesperday_help'] = 'Die Maxamilzahl an Kursen, die pro Tag veröffentlicht werden können. Diese Einstellung soll automatisierten Spam vermeiden. Wenn die Maximalzahl erreicht wurde, wird auf der registrierten Instanz für 24 Stunden eine Fehlermeldung angezeigt. (0 =keine, empty = unbegrenzt)';
$string['maxmessagesent'] = 'Sie können heute keine weiteren Nachrichten schicken. Versuchen Sie es morgen wieder.';
$string['maxwscourseresult'] = 'Maximum der zu entfernten Instanzen zurückgemeldeten Kurse.';
$string['maxwscourseresult_help'] = 'Geben Sie die Maximalzahl an Kursen an, die der Hub auf die Anfrage einer entfernten Instanz zurückmeldet. (0 oder leer: keine Kurse zurückgemeldet)';
$string['maxwscourseresultempty'] = 'Das Maximum der Kursergebnisse muss  > 0 sein';
$string['messagesentsuccess'] = 'Nachricht erfolgreich gesendet';
$string['modulenumberaverage'] = 'Durchschnittliche Anzahl Kursmodule ({$a})';
$string['moodleorg'] = 'Moodle.org';
$string['moved'] = 'Registrierungs-URL für eine existierende Instanz aktualisieren';
$string['movedorcopiedmsg'] = 'Wir haben festgestellt, dass Sie versuchen eine bereits mit einer anderen URL registrierten Moodle2-Instanz anzumelden. Wenn Sie eine bereits bestehende Moodle2-Instanz auf eine andere URL verschoben haben, klicken Sie bitte \'Registrierung für vorhandene Instanz aktualisieren\'.
Ihre ursprüngliche Moodle2-Registrierung wird aktualisiert. In anderen Fällen (Duplizierung einer vorhandenen Instanz, Verschieben einer Moodle 1.9-Instanz auf diese URL, Neuinstallation...) klicken Sie bitte  \'Eine neue Instanz registrieren\'.
Sie werden auf Ihre Instanz zurückgeleitet, um Ihre Instanzenidentifizierung zu regenerieren und eine saubere Registrierung zu bearbeiten.';
$string['msgforcourse'] = 'Sie haben eine neue Nachricht zu einem Kurs auf "{$a->hubname}" ({$a->huburl}):

--------------------------------------------------------------------------------------
Von: {$a->userfullname}
Betreff: \'{$a->fullname}\', {$a->hubcourseurl}
Nachricht:

{$a->message}
--------------------------------------------------------------------------------------

Sie können direkt per Mail antworten oder das Mitteilungssystem auf dem Hub benutzen
({$a->userurl}).';
$string['msgforcoursetitle'] = 'Nachricht über {$a}';
$string['msgforcoursetitlewithlink'] = 'Nachricht über \'{$a->fullname}\'';
$string['msgtopublisher'] = 'Sende Nachricht über {$a}';
$string['msgtype'] = 'Kategorie';
$string['msgtype_help'] = 'Wählen Sie eine allgemeine Kategorie, die Ihre Nachricht beschreibt.';
$string['msgtypeappreciation'] = 'Anerkennung / Gratulation';
$string['msgtypeimprovement'] = 'Verbesserungsvorschlag';
$string['msgtypeissue'] = 'Problembericht';
$string['msgtypequestion'] = 'Frage';
$string['mustbeemail'] = 'Muss eine Email sein.';
$string['mustbeinteger'] = 'Muss eine ganze Zahl sein.';
$string['mustbetext'] = 'Nur Text, kein HTML.';
$string['mustbeurl'] = 'Muss eine URL sein.';
$string['name'] = 'Name';
$string['name_help'] = 'Der Hubname wird im Hubverzeichnis gezeigt.';
$string['never'] = 'niemals';
$string['newregistration'] = 'Neue Registrierung';
$string['no'] = 'Nein';
$string['nocomments'] = 'Keine Kommentare';
$string['nocourse'] = 'Keine Kurs, der Ihrer Suche entspricht.';
$string['nocoursereturn'] = 'Der Hub ist so konfiguriert, dass er keine Kurse an den Webservice zurückmeldet.';
$string['none'] = 'Kein';
$string['noratings'] = 'Keine Bewertung';
$string['nosearch'] = 'Diesen Hub oder diese Kurse nicht veröffentlichen (Privater Hub)';
$string['nosite'] = 'Keine Instanzen sind  registriert oder entsprechen Ihrer Suche.';
$string['notregisteredonhub'] = 'Sie können diesen Kurs auf keinem anderen Hub veröffentlichen, weil diese Instanz nicht bei anderen Hubs registriert ist. Kontaktieren Sie Ihren Administrator, damit er weitere Hubs registriert.';
$string['notregisteredonmoodleorg'] = 'Sie können diesen Kurs nicht auf MOOCH, dem Moodle.org Community Hub, registrieren, weil diese Instanz dort noch nicht registriert ist. Ihr Administrator muss diese Instanz erst bei Mooch registrieren.';
$string['operation'] = 'Operation';
$string['orderby'] = 'Sortiere nach';
$string['orderby_help'] = 'Die Reihenfolge, in der die Suchergebnisse gezeigt werden.';
$string['orderbyeldest'] = 'Älteste';
$string['orderbyname'] = 'Name';
$string['orderbynewest'] = 'Neueste';
$string['orderbypublisher'] = 'Veröffentlicher';
$string['orderbyratingaverage'] = 'Bewertung';
$string['orenterprivatehub'] = 'oder URL eines privaten Hub eingeben:';
$string['outcomes'] = 'Ergebnisse: {$a}';
$string['participantnumberaverage'] = 'Durchschnittliche Teilnehmerzahl ({$a})';
$string['password'] = 'Passwort';
$string['periodforteennight'] = 'Letzte 14 Tage';
$string['periodmonth'] = 'Letzte 30 Tage';
$string['periodweek'] = 'Letzte 7 Tage';
$string['permalink'] = 'Permalink';
$string['pluginname'] = 'Hub';
$string['postaladdress'] = 'Anschrift';
$string['postsnumber'] = 'Anzahl Posts ({$a})';
$string['previousregistration'] = 'Frühere Registrierung';
$string['prioritise'] = 'Bevorzugt';
$string['prioritise_help'] = 'Nur bevorzugte Instanzen zeigen.';
$string['prioritiseno'] = 'Nein';
$string['prioritiseyes'] = 'Ja';
$string['privacy'] = 'Datenschutz';
$string['privacy_help'] = 'Sie können wählen, wie sichtbar Ihr Hub im Hubverzeichnis ist. Ein privater Hub wird nirgends im Hubverzeichnis aufgeführt, aber Instanzen können sich dennoch registrieren, wenn sie Ihre URL und das  (optionale) Nur registrierte Instanzen oder eingeloggte Nutzer können einen privaten Hub durchsuchen.';
$string['private'] = 'Privat';
$string['privatehuburl'] = 'Private Hub URL';
$string['publicationinfo'] = 'Information zur Kursveröffentlichung';
$string['publicationmax'] = 'Maximalzahl der pro Tag veröffentlichten Kurse';
$string['publicationmax_help'] = 'Die Maxamilzahl an Kursen, die pro Tag veröffentlicht werden können. Diese Einstellung soll automatisierten Spam vermeiden. Wenn die Maximalzahl erreicht wurde, wird auf der registrierten Instanz für 24 Stunden eine Fehlermeldung angezeigt. (0 = keine, leer = Hubeinstellung wird benutzt)';
$string['publichub'] = 'Öffentlicher Hub';
$string['publishcourseon'] = 'Veröffentlichung am {$a}';
$string['publisheremail'] = 'Email des Veröffentlichenden';
$string['publisheremail_help'] = 'Das Kurs-Kontaktformular sendet die Nutzernachrichten an diese Email.';
$string['publishername'] = 'Veröffentlicher';
$string['publishername_help'] = 'Der Name des Veröffentlichenden wird im Kurs-Kontaktformular angezeigt.';
$string['publishon'] = 'Veröffentliche auf';
$string['publishonmoodleorg'] = 'Veröffentliche auf MOOCH, dem Moodle.org Community Hub';
$string['publishonspecifichub'] = 'Veröffentliche auf einem Hub';
$string['questionsnumber'] = 'Zahl der Fragen ({$a})';
$string['rating'] = 'Bewertung';
$string['recaptcha'] = 'Recaptcha Einstellungen';
$string['recaptchadisable'] = 'Recaptcha Schlüssel nicht gesetzt, bitte ändere die  {$a}';
$string['registeredcourses'] = 'Registrierte Kurse';
$string['registeredsites'] = 'Registrierte Instanzen';
$string['registeron'] = 'Registriere auf';
$string['registeronmoodleorg'] = 'Registriere auf Moodle.org';
$string['registeronspecifichub'] = 'Registriere auf einen bestimmten Hub';
$string['registersite'] = 'Registriere auf {$a}';
$string['registration'] = 'Hub Server Registrrierung';
$string['registrationconfirmed'] = 'Registrierung erfolgreich';
$string['registrationinfo'] = 'Registrierungsinformation';
$string['registrationupdated'] = 'Registrierung wurde aktualisiert.';
$string['registrationupdatedfailed'] = 'Aktualisierung der Registrierung ist fehlgeschlagen.';
$string['replaceregistrationbutton'] = 'REGISTRIERUNG ERSETZEN!';
$string['resourcesnumber'] = 'Anzahl der Arbeitsmaterialien ({$a})';
$string['roleassignmentsnumber'] = 'Anzahl der Rollenzuweisungen ({$a})';
$string['rsssecret'] = 'RSS secret';
$string['rsssecret_help'] = 'Wenn das RSS secret die RSS URL  ist (füge hinzu \'?rsssecret=YOUR_RSS_SECRET\'), meldet der RSS-Feed nicht veröffentlichte Kurse anstelle der veröffentlichten. Das ist besonders nützlich für den Hub-Administrator, um über neue Kurse benachrichtigt zu werden. Sie benötigen einen RSS Feed für Kurse zur Einschreibung und einen für downloadbare Kurse.';
$string['rsstooltip'] = 'RSS Feed Ihrer Suche - die zuletzt veröffentlichen downloadbaren oder einschreibfähigen Kurse werden gemeldet, wenn keine Suche durchgeführt wird.';
$string['screenshots'] = 'Screenshots';
$string['search'] = 'Nach Kursen suchen';
$string['searchfornologin'] = 'Suche auf der öffentlichen Startseite';
$string['searchfornologin_help'] = 'Wenn aktiviert, wird die Suche auf der Startseite auch für nicht eingeloggte Nutzer gezeigt. Wenn der Hub als privater Hub gesetzt ist, wird diese Einstellung ignoriert und nur eingeloggte Nutzer können das Suchformular sehen.';
$string['seecreatornotes'] = 'Siehe Bemerkungen des Kursautoren';
$string['selecthub'] = 'Hub auswählen';
$string['sendfollowinginfo'] = 'Sende folgende Information:';
$string['sendmessage'] = 'Sende Nachricht';
$string['sendto'] = 'Sende an';
$string['sentto'] = 'Gesendet an';
$string['senttohub'] = '{$a} Hub Administrator';
$string['senttopublisher'] = 'Kurs-Veröffentlichender: {$a}';
$string['settings'] = 'Einstellungen';
$string['settingsupdated'] = 'Einstellungen aktualisiert.';
$string['site'] = 'Instanz';
$string['site_help'] = 'Nur Kurse von dieser Instanz zeigen.';
$string['siteadmin'] = 'Administrator';
$string['siteadmin_help'] = 'Administrator Name zum Kontaktieren';
$string['siteadminemail'] = 'Administrator Email';
$string['siteadminemail_help'] = 'Administrator Email';
$string['sitecountry'] = 'Land';
$string['sitecountry_help'] = 'Land, in dem sich die Organisation befindet';
$string['sitecreated'] = 'Instanz geschaffen';
$string['sitedesc'] = 'Beschreibung';
$string['sitedesc_help'] = 'Beschreibung, die in Suchergebnissen angezeigt wird.';
$string['sitehelpexplanation'] = 'Liste der registrierten Instanzen auf Ihrem Hubserver. Um eine Instanz oben in der Liste anzuzeigen, setzen Sie sie auf bevorzugt. Vertrauenswürdige Instanzen werden als vertrauenswürdig in der Liste und den Suchergebnissen ausgewiesen und vor anderen Instanzen angezeigt. Bevorzugte Instanzen gelten automatisch als vertrauenswürdig. Nur als sichtbar markierte Instanzen werden angezeigt, Instanzen, die länger als 1 Monat nicht erreichbar sind, werden automatisch aus der Datenbank gelöscht, außer sie sind als vertrauenswürdig bzw. bevorzugt markiert.';
$string['sitekeywords'] = 'Schlagworte';
$string['sitekeywords_help'] = 'Sie können nach Instanzen suchen, die einen bestimmten Text in Namen, Beschreibung oder anderen Datenbankfeldern haben.';
$string['sitelang'] = 'Sprache';
$string['sitelang_help'] = 'Nur nach Instanzen der ausgewählten Sprache suchen.';
$string['sitelanguage'] = 'Sprache';
$string['sitelanguage_help'] = 'Hauptsprache der Instanz.';
$string['sitelinkpublished'] = 'Link veröffentlicht';
$string['sitelist'] = 'Liste der Instanzen';
$string['sitename'] = 'Name';
$string['sitename_help'] = 'Instanzenname angezeigt in Suchergebnissen.';
$string['sitenamepublished'] = 'Name der Veröffentlichung';
$string['sitenotpublished'] = 'Nicht veröffentlicht';
$string['siteoperation'] = 'Instanzenoperation';
$string['siteprivacy'] = 'Datenschutz';
$string['siteregconfcomment'] = 'Ihre Instanz benötigt eine endgültige Bestätigung auf {$a} (zur Vermeidung von Spam auf {$a})';
$string['siteregistration'] = 'Registrierung der Instanz';
$string['siteregistrationupdated'] = 'Registrierung der Instanz aktualisiert';
$string['sitesearch'] = 'Nach Instanzen suchen';
$string['sitesecretalreadyexist'] = 'Der Hub konnte die Registrierung nicht bearbeiten, da bereits eine andere Instanz mit derselben Identifizierung registriert ist.';
$string['sitesettings'] = 'Einstellungen der Instanz';
$string['sitesettingsform'] = '"{$a}" Einstellungen';
$string['sitesettingsupdated'] = '{$a} Einstellungen wurden aktualisiert.';
$string['siteupdated'] = '{$a} wurde erfolgreich aktualisiert.';
$string['siteurl'] = 'URL der Instanz';
$string['siteurl_help'] = 'URL der Instanz, die in Suchergebnissen angezeigt wird.';
$string['sitevisibility'] = 'Sichtbarkeit';
$string['sitevisibility_help'] = 'Zeige sichtbare, unsichtbare oder beide Arten von Instanzen gleichzeitig.';
$string['specifichub'] = 'Bestimmter Hub';
$string['specifichubpublicationdetail'] = 'Sie können auf einem anderen Hub veröffentlichen.';
$string['specifichubregistrationdetail'] = 'Sie können sich auf einem anderen Hub registrieren.';
$string['statistics'] = 'Datenschutzeinstellungen für Statistiken';
$string['subject'] = 'Bildungs-Fach';
$string['subject_help'] = 'Um die Suche auf Kurse eines bestimmten Faches einzuschränken, wählen Sie eines aus der Liste.';
$string['subjects'] = 'Fächer';
$string['tags'] = 'Tags';
$string['tags_help'] = 'Kurse können nach Tags gesucht werden';
$string['trusted'] = 'Vertrauenswürdig';
$string['trusted_help'] = 'Nur als vertrauenswürdig markierte Instanzen anzeigen.';
$string['trustedno'] = 'Nein';
$string['trustedyes'] = 'Ja';
$string['trustme'] = 'Vertrauenswürdig';
$string['typedownloadable'] = 'Downloadbar';
$string['typeenrollable'] = 'Einschreibbar';
$string['unlistedurl'] = 'Nicht gelistete Hub-URL';
$string['unprioritise'] = 'Bevorzugung entfernen';
$string['unregistersite'] = 'Registrierung der Instanz löschen';
$string['unregistersiteandcourses'] = 'Diese Instanz und alle Kurse aus der Registrierung löschen';
$string['unregistrationofprivate'] = 'Der Hub wurde aus dem Hubverzeichnis entfernt.';
$string['untrustme'] = 'Markierung als vertrauenswürdig entfernen';
$string['updatesite'] = 'Aktualisiere Registrierung auf {$a}';
$string['url'] = 'Hub URL';
$string['urlalreadyexist'] = 'Ihre neue Instanzen-URL esxistiert bereits auf {$a}. Das kann an einem Datenbankfehler auf {$a} liegen oder an einer früheren Registrierung. Kontaktieren Sie den Administrator des Hubs. Möglicherweise müssen Sie die Registrierung entfernen und sich neu registrieren. Sie müssen den Hub-Administrator informieren, ob Sie bereits veröffentlichte Kurse behalten wollen, weil er die frühere Registrierung entfernen muss. .';
$string['userinfo'] = 'Kursautor: {$a->creatorname} - Veröffentlichender: {$a->publishername}';
$string['usersnumber'] = 'Anzahl der Nutzer ({$a})';
$string['visibility'] = 'Sichtbarkeit';
$string['visibility_help'] = 'Zeige sichtbare Kurse, unsichtbare, oder beide Arten gleichzeitig.';
$string['visibilityall'] = 'Alle';
$string['visibilityno'] = 'Unsichtbare';
$string['visibilityyes'] = 'Sichtbare';
$string['visitdemo'] = 'Besuche Demo';
$string['visitsite'] = 'Besuche Instanz';
$string['wronghubpassword'] = 'Falsches Hub-Passwort, klicken Sie Fortsetzen und versuchen Sie es noch einmal.';
$string['wrongurlformat'] = 'Ungültiges URL-Format';
$string['xmlrpcdisabled'] = 'Die XML-RPC Erweiterung ist auf dem Server nicht aktiviert. Sie können Ihren Hub nicht verwalten, bis diese Option aktiviert wurde.';
$string['yeswithmoodle'] = 'Ja, mit Moodle';
$string['yeswithoutmoodle'] = 'Ja, ohne Moodle';
