<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_coursemanager', language 'cs', version '4.2'.
 *
 * @package     report_coursemanager
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admin_course_managerinfo'] = '<p>Tato stránka poskytuje přístup k nástroji pro správce Moodle. Pro nastavení Správce kurzu přejděte na Moduly > Sestavy > Správce kurzu.</p>';
$string['admin_files_distribution_info'] = '<p>Tento nástroj poskytuje zprávu o různých komponentách v úložišti souborů a celkové velikosti každé z nich.</p>';
$string['admin_no_teacher_courses_info'] = '<p>Tento nástroj uvádí seznam všech kurzů, ve kterých není zapsán žádný uživatel jako učitel, a v případě potřeby je může přesunout do kategorie bin.</p>';
$string['admin_orphan_submissions_info'] = '<p>Osiřelé příspěvky jsou soubory odeslané studenty, kteří již nejsou zapsáni do kurzu.
<b>Tyto soubory jsou pro učitele neviditelné a mohou je zobrazit pouze studenti, kteří je znovu zapíší.</b> Pokud se úkoly používají každý rok, aniž by byly resetovány, tyto skryté soubory může v Moodlu představovat důležitou váhu.<br />
Tento nástroj dokáže odstranit tyto skryté soubory <b>bez smazání souborů odeslaných studenty, kteří jsou stále zapsáni do kurzu.<b></p>';
$string['admin_stats_info'] = '<p>Tato stránka zobrazuje statistiky, které se nejvíce zakládají na přehledech vytvořených pluginy Manažera kurzů. Nabízí také statistiky o několika aspektech funkcí Manažera kurzů, jako jsou kurzy bez učitelů nebo kurzy v kategorii koše.</p>';
$string['adminnoteachercoursesnote'] = '<ul class="alert alert-info"><li>Informace týkající se váhy kurzu a počtu aktivit se nepočítají v reálném čase.</li>
<li>Informace týkající se posledního deníku učitele jsou založeny na úrovni edulevel uložené v databázi logstore. Upravená oprávnění mohou tento výsledek narušit.</li></ul>';
$string['advices_for_course'] = 'doporučení';
$string['all_courses'] = 'Všechny kurzy';
$string['button_delete_cohort_confirm'] = 'Zrušit zápis globální skupiny';
$string['button_move_confirm'] = 'Potvrdit vymazání';
$string['button_restore_confirm'] = 'Potvrdit obnovení kurzu';
$string['button_save_course'] = 'Zálohovat kurz';
$string['button_save_questionbank'] = 'Zálohovat banku úloh';
$string['capability_problem'] = 'k zobrazení této stránky nemáte oprávnění.';
$string['category_bin'] = 'Kategorie pro přihrádku';
$string['category_bin_desc'] = 'Pokud učitel smaže kurz přes dashboard, přesune se do této kategorie před skutečným smazáním administrátorem.';
$string['closereportmodal'] = 'Zavřít okno';
$string['collapse_show_report'] = 'Zobrazit zprávu';
$string['comment'] = 'Doporučení';
$string['configtitle'] = 'Nastavení Správce kurzu';
$string['confirm_cohort_unenrolled_message'] = 'Všechny globální skupiny byly z kurzu odhlášeny.';
$string['confirm_cohort_unenrolled_title'] = 'Globální skupiny byly smazány';
$string['confirm_course_deleted_message'] = 'Kurz byl přesunut do kategorie koše a bude později smazán administrátorem';
$string['confirm_course_deleted_title'] = 'Kurz smazán';
$string['confirm_course_restored_message'] = 'Kurz byl přesunut z kategorie bin. Upozorňujeme, že obnovený kurz je pro studenty stále skrytý, v případě potřeby zvažte změnu nastavení.';
$string['confirm_course_restored_title'] = 'Kurz obnoven';
$string['course_alert_empty'] = 'Tento kurz nemá žádný obsah, případně kromě nativního fóra. Zvažte prosím smazání tohoto kurzu, pokud se již nepoužívá.<br /><b>{$a->delete_link}</b>';
$string['course_alert_heavy'] = 'Celková velikost souborů v tomto kurzu je ve skutečnosti <b>{$a->size} Mo</b>. Zvažte řazení souborů nebo resetování tohoto kurzu.<br /><b>{$a->heavy_link}</b>';
$string['course_alert_no_student'] = '<b>Do tohoto kurzu není zapsán žádný student</b>. Zvažte prosím smazání tohoto kurzu, pokud se již nepoužívá.<br /><b>{$a->delete_link}</b>';
$string['course_alert_no_visit_student'] = 'Žádný student nenavštívil tento kurz od více než {$a->no_teacher_time} dnů</b>. Zvažte prosím smazání tohoto kurzu, pokud již není používán.<br /><b>{$a->delete_link} | {$a->reset_link}</b>';
$string['course_alert_no_visit_teacher'] = 'Žádný učitel nenavštívil tento kurz po více než {$a->no_teacher_time} dnů</b>. Zvažte prosím smazání tohoto kurzu, pokud se již nepoužívá.<br /><b>{$a->delete_link}</b>';
$string['course_alert_orphan_submissions'] = 'Tento kurz obsahuje úkoly s neviditelnými úkolů nahranými nezapsanými studenty. Pokud můžete, zvažte prosím resetování tohoto kurzu.';
$string['course_cohort_unenrolled'] = 'Globální skupiny vyšktnuty';
$string['course_dashboard_viewed'] = 'Nástěnka učitele navštívena';
$string['course_files_viewed'] = 'Navštívená stránka přehledu souborů';
$string['course_global_reset'] = 'Kurz byl resetován pomocí funkce Manažera kurzu';
$string['course_restored'] = 'Kurz obnoven z kategorie koše';
$string['course_state_hidden'] = 'Skryté';
$string['course_state_trash'] = 'Vymazat';
$string['course_state_visible'] = 'Viditelné';
$string['course_trash_moved'] = 'Kurz přesunut do kategorie bin';
$string['coursemanager:admintools'] = 'Použijte nástroje pro správu v sekci Sestavy';
$string['coursemanager:viewreport'] = 'Zobrazit zprávy v kurzu, pokud je povoleno';
$string['coursesize'] = 'Velikost kurzu';
$string['delete_already_moved'] = 'Tento kurz je již v kategorii bin.';
$string['delete_cohort_confirm'] = 'Tato funkce zruší zápis všech globálních skupin do vašeho kurzu.<br /> Upozorňujeme, že zrušením registrace globálních skupin zmizí data ve formě zpráv ve fóru, </b> ale nikoli pokusy o testy nebo příspěvky úkolů</b>. Zvažte prosím použití funkce reset k odstranění osobních údajů. <p class="alert alert-primary"><i class="fa fa-question-circle-o"></i> <b>UPOZORNĚNÍ:</b> v závislosti na počtu globálních skupin, které mají být odhlášeny, tento proces může chvíli trvat.</p>';
$string['delete_period'] = 'Indikace času pro smazání kurzu';
$string['delete_period_desc'] = 'Tato informace poskytuje přibližnou dobu pro smazání kurzu z kategorie bin.
Můžete napsat něco jako "začátkem července" nebo "na konci roku". Tyto informace se zobrazí v e-mailu, když učitel smaže kurz a na stránce pro smazání kurzu.';
$string['delete_send_mail'] = 'Role, kterým je třeba zabránit v mazání kurzu';
$string['delete_send_mail_desc'] = 'Vyberte role, které budou upozorněny e-mailem, když bude kurz smazán';
$string['delete_several_teachers'] = '<h4><i class="fa fa-exclamation-triangle"></i> VAROVÁNÍ: V TOMTO KURZU JE VÍCE UČITELŮ!</h4>
Pokud tito učitelé nejsou informováni, udělejte to prosím nyní.<br/>Smazání kurzu pošle <b>automatické e-mailové upozornění pro každého učitele v tomto kurzu</b>, aby je varovalo.<br /><br /> <h5>Další učitelé v tomto kurzu:</h5>';
$string['delete_wish'] = 'Co chcete dělat ?';
$string['deletecoursewithoutteachersconfirm'] = 'Chcete přesunout tento kurz do kategorie bin?';
$string['deleteorphans'] = 'Smazat osiřelé příspěvky';
$string['deleteorphansubmissionsconfirm'] = 'Chcete smazat osiřelé příspěvky v tomto úkolu? Tato akce je nevratná.';
$string['empty_course_alert'] = '<b>Prázdný kurz.</b>Tento kurz obsahuje pouze nativní fórum. Pokud nebude přidán žádný obsah, zvažte smazání tohoto kurzu.';
$string['empty_files_course'] = 'Zdá se, že tento kurz zatím neobsahuje žádné soubory.';
$string['empty_settings'] = 'Pro tento plugin chybí některá nastavení; kontaktujte prosím svého správce Moodle';
$string['empty_student_alert'] = '<b>Není zapsán žádný student</b><br />V tomto kurzu nejsou jako studenti zapsáni žádní uživatelé. Pokud se již nepoužívá, popřemýšlejte o jeho smazání!';
$string['emptytablenoteacherincourses'] = 'Žádný výsledek: všechny kurzy mají učitele';
$string['enablemailing'] = 'Aktivovat zasílání zpráv';
$string['enablemailing_desc'] = 'Pokud je zaškrtnuto, aktivuje automatickou úlohu pro zasílání zpráv. Výchozí periodicita je každých 30 dní.';
$string['error_category'] = 'Byla vybrána špatná kategorie';
$string['filesdistributiontablecomponent'] = 'Komponenta';
$string['filesdistributiontotalfiles'] = 'Počet souborů';
$string['filesdistributiontotalweight'] = 'Celková velikost souborů v M';
$string['global_chart'] = 'Rozdělení vah souborů podle činností';
$string['heavy_course'] = 'Těžké kurzy';
$string['last_access_multiple_teacher_alert'] = '<b>Žádný učitel nenavštívil od {$a->limit_visit} měsíců.</b><br />Tento kurz již dlouho nenavštívil žádný učitel. Pokud jej žádný učitel nepoužívá, popřemýšlejte o jeho smazání!';
$string['last_access_student'] = 'Limit pro poslední přístup studenta (ve dnech)';
$string['last_access_student_alert'] = '<b>Žádná návštěva studentů od {$a->limit_visit} měsíců.</b><br />Tento kurz již dlouho nenavštívili žádní studenti. V případě potřeby smažte';
$string['last_access_student_desc'] = 'několik dní od doby, kdy student nenavštívil žádný kurz';
$string['last_access_teacher'] = 'Limit pro poslední přístup učitele (ve dnech)';
$string['last_access_teacher_desc'] = 'Počet dní od doby, kdy učitel nenavštívil kurz';
$string['last_access_unique_teacher_alert'] = '<b>Tento kurz jste nenavštívili od {$a->limit_visit} měsíců.</b><br />Jste jediným učitelem v tomto kurzu. Pokud jej již nepoužíváte, popřemýšlejte o jeho smazání.';
$string['mail_message_delete_main_teacher'] = 'Zdravíme,<br />
Kurz {$a->course} byl přesunut do kategorie koše před úplným smazáním v {$a->delete_period}. Předtím máte stále přístup k tomuto kurzu, pokud chcete získat data.<br />
Pokud chcete tento kurz obnovit, přesuňte jej z kategorie přihrádky na řídicím panelu Manažera kurzů.
POZNÁMKA: Bylo zapsáno {$a->count_teacher} dalších učitelů. Byl jim zaslán e-mail s upozorněním, že jste tento kurz smazali. Protože jsou také učiteli, mohou je v případě potřeby obnovit nebo obnovit data.';
$string['mail_message_delete_oneteacher'] = 'Dobrý den,<br />
Kurz {$a->course} byl přesunut do kategorie koše před úplným smazáním v {$a->delete_period}. Před tímto, stále máte přístup k tomuto kurzu, pokud chcete získat data.<br /> Pokud chcete tento kurz obnovit, přesuňte jej z kategorie přihrádky na řídicím panelu Manažera kurzů.';
$string['mail_message_delete_other_teacher'] = 'Dobrý den,<br />
Kurz {$a->course} byl přesunut do kategorie koše uživatelem {$a->deleter} před úplným smazáním v {$a->delete_period}. Předtím máte stále přístup k tomuto kurzu, pokud chcete získat data.<br />
Pokud chcete tento kurz obnovit, přesuňte jej z kategorie přihrádky na hlavním panelu Správce kurzů.<br />';
$string['mail_subject_delete'] = 'Kurz smazán – {$a->course}';
$string['mailingddescreportempty'] = 'Tyto kurzy nemají žádný obsah, případně kromě nativního fóra Moodle.';
$string['mailingddescreportheavy'] = 'Celková velikost souborů v tomto kurzu se zdá být těžká. Kliknutím na název kurzu zobrazíte přehled souborů.';
$string['mailingddescreportnostudent'] = 'V těchto kurzech nejsou zapsáni žádní studenti.';
$string['mailingddescreportnovisitstudent'] = 'Studenti již dlouhou dobu nenavštívili kurzy diplomových prací.</b>';
$string['mailingddescreportnovisitteacher'] = 'Učitelé, včetně vás, dlouho nenavštívili tyto kurzy';
$string['mailingddescreportorphansubmissions'] = 'Některé úkoly v těchto kurzech mají skryté příspěvky nahrané nezapsanými studenty. Tyto soubory mohou představovat velkou váhu.';
$string['mailingintro'] = '<p>Dobrý den %userfirstname%,</p>
<p>Správce kurzů je nástrojová sestava, která učitelům pomáhá řídit jejich kurzy pomocí vypočítaných sestav. Tento e-mail shrnuje tyto zprávy a uvádí, které kurzy se týkají problémů.</p>
<p><b>Tyto zprávy jsou určeny pouze k tomu, aby upoutaly vaši pozornost na určité aspekty správy vašich kurzů a aby vám poskytly klíče k osvědčeným postupům při používání Moodle</b></p>
 <p>Další informace naleznete na svém osobním <a href="%coursemanagerlink%">panelu manažera kurzu</a>';
$string['mailingintro_setting'] = 'Obsah e-mailu';
$string['mailingintro_setting_desc'] = 'Zavedení zasílání zpráv.<br>
Můžete použít následující proměnné :<br>
%userfirstname% : Křestní jméno uživatele<br>
 %userlastname% : Příjmení uživatele<br>
%coursemanagerlink% : Odkaz na manažera kurzu';
$string['mailingoutro'] = '<p>Pro více informací o těchto přehledech kontaktujte administrátora Moodle nebo službu podpory.';
$string['mailingtask'] = 'E-mailové zprávy pro učitele pro Správce kurzu';
$string['mailingtitle'] = 'Správce kurzu – sestavy pro vaše kurzy';
$string['menucoursefilesinfo'] = 'Viz soubory v kurzu';
$string['menucourseparameters'] = 'Nastavení kurzu';
$string['menudeletecourse'] = 'Smazat kurz';
$string['menuenrolcohorts'] = 'Přidat globální skupiny';
$string['menureset'] = 'Resetovat kurz';
$string['menurestorecourse'] = 'Obnovit kurz';
$string['menuunenrolcohorts'] = 'Hromadné vyškrtnutí globálních skupin';
$string['more_information'] = 'Více informací';
$string['move_confirm'] = '<div class="alert alert-danger"><h5>před smazáním si pozorně přečtěte</h5></div>
<p><b>Tato stránka vám umožňuje umístit do koše kurz, který již nepoužíváte.</b><br/>Pokud to potvrdíte, bude tento kurz přesunut do konkrétní kategorie a skryt studentům. Poté bude smazán administrátorem Moodle <b>{$a->delete_period}</b>.</p>
<p> Před smazáním máte stále přístup k tomuto kurzu nebo jej v případě potřeby můžete obnovit. Použijte akci obnovení kurzu na hlavním panelu Manažera kurzů.</p>
<p> Před odstraněním zvažte vytvoření zálohy důležitých souborů nebo banky otázek. Tato data nelze po úplném smazání obnovit.';
$string['no_advices'] = '<b>Žádné konkrétní zprávy.</b><br />Blahopřejeme, tento kurz se zdá být v pořádku!';
$string['no_cohort'] = '<p class="alert alert-info">Do tohoto kurzu není zapsána žádná globální skupina!</p>';
$string['no_content'] = 'Prázdné kurzy';
$string['no_course_to_show'] = '<h2>Žádné kurzy</h2>Nejste zapsáni do kurzů s rolí učitele.';
$string['no_student'] = 'Nejsou zapsáni žádní studenti';
$string['no_visit_student'] = 'Žádné návštěvy studentů';
$string['no_visit_teacher'] = 'Žádné návštěvy učitelů';
$string['noassign'] = 'V této instanci Moodle není žádný úkol.';
$string['number_of_files'] = 'Počet souborů';
$string['ok'] = 'Žádné zprávy';
$string['orphan_submissions_alert'] = 'b>Osiřelé příspěvky ({$a->filesize} Mo)</b><br />Tento kurz obsahuje jeden nebo více úkolů obsahujících soubory odeslané nezapsanými studenty. Tyto soubory mohou představovat velký objem. Přemýšlejte o resetování nebo odstranění těchto aktivit.';
$string['orphan_submissions_button'] = 'Osiřelé příspěvky';
$string['plugin'] = 'Typ aktivity';
$string['pluginname'] = 'Manažer kurzu';
$string['privacy:no_data_reason'] = 'Doplněk Manažer kurzu neukládá žádné osobní údaje. Výkazy vypočítává pouze na základě studia obsahu kurzů (nastavení, zapsaní studenti a učitelé, počet aktivit...).';
$string['reset_info'] = '<p class="alert alert-success"><i class="fa fa-info-circle"></i> Funkce Reset může smazat osobní údaje studentů ve vašem kurzu. <b>Nesmaže vaše soubory ani aktivity</b></p>
 <p>použitím tohoto obnovení kurzu se smaže :<ul>
<li><b>údaje o dokončení</b> ;</li>
<li><b>hodnocení v přehledu hodnocení</b> ;</li>
<li><b>skupiny a seskupení</b> ;</li>
<li><b>příspěvky v části aktivity Úkol</b> ;</li>
<li><b>zprávy ve fóru</b> ;</li>
<li><b>pokusy o test</b> ;</li>
<li><b>zapsané globální skupiny</b> (<span class="text-danger"><b>UPOZORNĚNÍ</b>: tato funkce může trvat dlouho, pokud je studentů mnoho!).</span ></li>
</ul></p>
 <p>Žádná další data nebudou smazána.</p>
<p>Pokud chcete resetovat další aktivity, použijte prosím <a href="/course/view.php?id="><b>funkci reset ve vašem kurzu</b></a>.<br /> </p>
<h5 class="alert alert-primary"><i class="fa fa-question-circle-o"></i> <b>Co chcete dělat?</b></h5>';
$string['reset_result'] = '<p><b>Kurz byl resetován.</b></p>
<p><b>Připomenutí</b>: nebyly smazány žádné soubory ani aktivity. Pokud chcete resetovat všechny nebo jiné aktivity, použijte samozřejmě funkci reset.</p>';
$string['restore_already_moved'] = 'Tento kurz není v kategorii bin!.';
$string['restore_confirm'] = '<p>Tato stránka převezme kurz z kategorie bin a obnoví jej v jiné kategorii.</p>
<p class="alert alert-info"><i class="fa fa-info-circle"></i> POZNÁMKA: Neobnovujte tento kurz v <b>"{$a->trash_category}"< /b> : tato kategorie je vyhrazena pro kurzy, které mají být smazány za <b>{$a->delete_period}</b>.</p>';
$string['runreportstask'] = 'Výpočet sestav pro Manažera kurzu';
$string['see_advices'] = 'Sestava přehledů';
$string['select_restore_category'] = 'Vyberte kategorii pro přesun kurzu';
$string['show_report_in_course'] = 'Zobrazení zprávy v kurzu';
$string['show_report_in_course_choices_collapse'] = 'Rolovací nabídka v nabídce správce kurzu';
$string['show_report_in_course_choices_none'] = 'Nezobrazovat zprávy v kurzu';
$string['show_report_in_course_choices_popover'] = 'Ikony vedle názvu kurzu';
$string['show_report_in_course_desc'] = 'Definuje místo v kurzu, kde se zobrazují zprávy';
$string['size'] = 'Velikost v Mo';
$string['stats_count_courses'] = 'Počet kurzů';
$string['stats_count_courses_desc'] = 'Počet kurzů na instanci Moodle.';
$string['stats_count_courses_trash'] = 'Kurzy v koši';
$string['stats_count_courses_trash_desc'] = 'Počítat kurzy v kategorii koše Manažera kurzů.';
$string['stats_count_courses_without_students'] = 'Kurzy bez studentů';
$string['stats_count_courses_without_students_desc'] = 'Počet kurzů bez uživatelů zapsaných jako studenti.';
$string['stats_count_courses_without_teachers'] = 'Kurzy bez učitelů';
$string['stats_count_courses_without_teachers_desc'] = 'Počet kurzů bez uživatelů zapsaných jako učitel.';
$string['stats_count_courses_without_visit_students'] = 'Kurzy bez návštěv studentů';
$string['stats_count_courses_without_visit_students_desc'] = 'Počet kurzů bez návštěvy studentů od {$a->lastaccessstudents} dnů.';
$string['stats_count_courses_without_visit_teachers'] = 'Kurzy bez návštěv učitelů';
$string['stats_count_courses_without_visit_teachers_desc'] = 'Počet kurzů bez návštěvy učitele od {$a->lastaccessteacher} dnů.';
$string['stats_empty_courses'] = 'Prázdné kurzy';
$string['stats_empty_courses_desc'] = 'Počet kurzů, které mají pouze nativní fórum pro aktivitu.';
$string['stats_heaviest_course'] = 'Nejtěžší kurz';
$string['stats_heaviest_course_desc'] = 'Nejtěžší kurz na instanci Moodle, podle zpráv Manažera kurzů.';
$string['stats_heavy_courses'] = 'Těžké kurzy';
$string['stats_heavy_courses_desc'] = 'Kurzy vážící více než {$a->totalfilesizethreshold} Mo (práh definovaný v nastavení Manažera kurzu).';
$string['stats_title_contents'] = 'Obsah kurzů a váhy';
$string['stats_title_courses'] = 'Statistiky kurzů';
$string['stats_title_enrolls_visits'] = 'Zápis do kurzů a návštěvy';
$string['stats_weight_courses_orphan_submissions'] = 'Váha pro osiřelé příspěvky';
$string['stats_weight_courses_orphan_submissions_desc'] = 'Celková velikost souborů pro osiřelé příspěvky';
$string['stats_weight_courses_trash'] = 'Celková hmotnost Koše';
$string['stats_weight_courses_trash_desc'] = 'Celková velikost souborů aktivit z kurzů v koši Manažera kurzů.';
$string['studentrolereport'] = 'Role studenta v kurzech';
$string['studentrolereport_desc'] = 'Definuje roli studenta pro výpočet sestav. Výchozí role je student Moodle.';
$string['table_actions'] = 'Akce';
$string['table_assign_name'] = 'Přiřadit jméno';
$string['table_course_name'] = 'Název kurzu';
$string['table_course_state'] = 'Viditelnost';
$string['table_enrolled_cohorts'] = 'Globální skupiny';
$string['table_enrolled_students'] = 'Studenti';
$string['table_enrolled_teachers'] = 'Učitelé';
$string['table_files_count'] = 'Počet skrytých souborů';
$string['table_files_weight'] = 'Celková velikost souborů';
$string['table_recommendation'] = 'Zprávy';
$string['table_tool_description'] = '<p>Popis</p>';
$string['table_tool_name'] = '<p>Nástroj</p>';
$string['tablecountenrolledstudents'] = 'Studenti';
$string['tablecountmodules'] = 'Počet aktivit';
$string['tablecourseweight'] = 'Váha kurzu';
$string['tablehascontents'] = 'Počet obsahů';
$string['tablelastaccess'] = 'Poslední přístup do kurzu';
$string['tablelastteacher'] = 'Poslední aktivní učitel';
$string['tablelastteacherlog'] = 'Záznam posledního učitele';
$string['teacherroledashboard'] = 'Role učitele v kurzech';
$string['teacherroledashboard_desc'] = 'Definuje roli učitele, která může zobrazit seznam kurzů na nástěnce Manažera kurzů. Výchozí role je učitel Moodle.';
$string['text_filter'] = 'Zadejte několik znaků názvu kurzu';
$string['text_link_delete'] = 'Smazat kurz';
$string['text_link_reset'] = 'Resetovat kurz';
$string['title'] = 'Manažer kurzu pro učitele';
$string['title_admin_files_distribution'] = '<b>Distribuce souborů podle komponent</b>';
$string['title_admin_no_teacher_courses'] = '<b>Správa kurzů bez učitelů</b>';
$string['title_admin_orphan_submissions'] = '<b>Správa osiřelých příspěvků</b>';
$string['title_admin_stats'] = '<b>Statistiky</b>';
$string['title_delete_cohort_confirm'] = 'Vyškrtnout globální skupiny';
$string['title_move_confirm'] = 'Smazání kurzu';
$string['title_restore_confirm'] = 'Obnovit kurz';
$string['total_filesize_alert'] = '<b>Tento kurz je těžký.</b><br />Nejtěžší soubory naleznete v <a href="course_files.php?courseid={$a->courseid}">přehledu souborů kurzu</a>.';
$string['total_filesize_threshold'] = 'Maximální velikost kurzu (Mo)';
$string['total_filesize_threshold_desc'] = 'Pokud celková velikost souborů překročí tento limit, bude pro příslušné kurzy vypočítána zpráva.';
$string['totalsize'] = 'Celková velikost souborů:';
$string['trash'] = 'Tento kurz je v kategorii pro smazané kurzy.';
$string['unique_filesize_threshold'] = 'Maximální velikost souboru (Mo)';
$string['unique_filesize_threshold_desc'] = 'Pokud velikost souboru překročí tento limit, zobrazí se v seznamu těžkých souborů v celkové sestavě souborů kurzu.';
$string['unknown'] = 'Neznámý';
$string['warn_big_files'] = 'Tyto soubory mají <b>důležitou váhu</b>:';
$string['warn_big_files_help'] = 'Pokud je velikost souboru důležitá, zvažte:
<ul> <li>zazipování;</li>
 <li>pokud obsahuje obrázky, zkuste snížit jejich rozlišení ;</li> <li>pokud můžete, použijte externí úložiště.</li>
<li></li> </ul>';
$string['warn_heavy_assign'] = 'Tato přiřazení představují velké soubory velikosti:';
$string['warn_heavy_assign_help'] = '<b>Dejte si pozor na tato přiřazení</b> a zvažte jejich resetování nebo smazání, když je již nebudete používat.';
$string['warn_orphans'] = 'Tyto úkoly obsahují <b>osiřelé příspěvky</b>:';
$string['warn_orphans_help'] = '<p>Soubory odeslané od nezapsaných studentů jsou stále zde.</p>
<p>Zvažte prosím: <ul>
<li>mazání úkolů s osiřelými příspěvky ;</li>
<li>resetování aktivit nebo celého kurzu.</li>
</ul></p>';
$string['warn_recyclebin'] = '<p class="alert alert-info"><i class="fa fa-info-circle"></i> <b>Všimněte si, že</b> je na Moodle aktivován koš. Smazané soubory budou zahrnuty do této tabulky, pokud učitel nevysype koš.</p>';
$string['warn_videos'] = 'Tyto soubory jsou <b>videa</b>, zvažte přesunutí:';
$string['warn_videos_help'] = 'Videa mohou být velmi těžká. Pokud můžete, nahrajte je na konkrétní službu pro videa (WebTV, YouTube...).';
$string['watchedfilessize'] = 'Celková velikost nejsledovanějších souborů:';
$string['watchedfilessizedetails'] = 'Tyto soubory pocházejí z nejpoužívanějších činností: Úkol, Zdroj, Fórum, Složka a Popisek.';
