<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'plugin', language 'da', version '4.2'.
 *
 * @package     plugin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Handlinger';
$string['availability'] = 'Tilgængelighed';
$string['cancelinstallall'] = 'Fortryd nye installationer ({$a})';
$string['cancelinstallhead'] = 'Fortryd installation af plugins';
$string['cancelinstallinfo'] = 'Følgende plugins er endnu ikke fuldt installeret, så deres installation kan annulleres. For at gøre det, er du nødt til at fjerne plugin-mappen fra serveren med det samme. Vær sikker på at det er det du ønsker for ikke at miste data ved et uheld (såsom dine egne kodeændringer).';
$string['cancelinstallinfodir'] = 'Mappe der skal slettes: {$a}';
$string['cancelinstallone'] = 'Fortryd denne installation';
$string['cancelupgradeall'] = 'Annuller opdateringer ({$a})';
$string['cancelupgradehead'] = 'Gendan forrige version af plugins';
$string['cancelupgradeone'] = 'Fortryd denne opgradering';
$string['checkforupdates'] = 'Se efter tilgængelige opdateringer';
$string['checkforupdateslast'] = 'Sidste tjek var den {$a}';
$string['dependencyavailable'] = 'Tilgængelige';
$string['dependencyfails'] = 'Fejler';
$string['dependencyinstall'] = 'Installer';
$string['dependencyinstallhead'] = 'Installerer manglende afhængigheder';
$string['dependencyinstallmissing'] = 'Installer manglende afhængigheder ({$a})';
$string['dependencymissing'] = 'Mangler';
$string['dependencyunavailable'] = 'Ikke tilgængelig';
$string['dependencyupload'] = 'Upload';
$string['dependencyuploadmissing'] = 'Upload ZIP-filer';
$string['detectedmisplacedplugin'] = 'Plugin\'et "{$a->component}" er installeret et forkert sted "{$a->current}", forventet sted er "{$a->expected}"';
$string['displayname'] = 'Plugin-navn';
$string['err_response_curl'] = 'Kan ikke hente tilgængelige opdateringsdata - uventet cURL-fejl.';
$string['err_response_format_version'] = 'Uventet version på responsformatet. Prøv igen at tjekke for tilgængelige opdateringer.';
$string['err_response_http_code'] = 'Kan ikke hente tilgængelige opdateringsdata - uventet http-responskode.';
$string['filterall'] = 'Vis alle';
$string['filtercontribonly'] = 'Vis kun yderligere plugins';
$string['filterupdatesonly'] = 'Vis kun dem der kan opdateres';
$string['incompatibleversion'] = 'Inkompatibel Moodleversion: {$a}';
$string['isenabled'] = 'Aktiveret?';
$string['misdepinfoplugin'] = 'Plugin-info';
$string['misdepinfoversion'] = 'Versions-info';
$string['misdepsavail'] = 'Tilgængelige manglende afhængigheder';
$string['misdepsunavail'] = 'Utilgængelige manglende afhængigheder';
$string['misdepsunavaillist'] = 'Der blev ikke fundet en version der opfylder afhængighedskravene: {$a}.';
$string['misdepsunknownlist'] = 'Ikke i plugin-mappen: <strong>{$a}</strong>.';
$string['moodlebranch'] = 'Moodle {$a->min} - {$a->max}';
$string['moodleversion'] = 'Moodle {$a}';
$string['noneinstalled'] = 'Der er ikke installeret nogen plugins af denne type';
$string['notdownloadable'] = 'Kan ikke downloade denne pakke';
$string['notdownloadable_help'] = 'ZIP-pakken med opdateringen kan ikke downloades automatisk.';
$string['notdownloadable_link'] = 'admin/mdeploy/notdownloadable';
$string['notes'] = 'Noter';
$string['notsupported'] = 'Plugin\'et er måske ikke kompatibelt med Moodleversion {$a}';
$string['notwritable'] = 'Plugin-filer er skrivebeskyttede';
$string['notwritable_help'] = 'Plugin-filer er skrivebeskyttede af webserveren. Webserverprocessen skal have skriveadgang til plugin-mappen og dens indhold. Skriveadgang til root-mappen til den givne plugin-type er også påkrævet.';
$string['otherplugin'] = '{$a->component}';
$string['otherpluginversion'] = '{$a->component} ({$a->version})';
$string['overviewall'] = 'Alle plugins';
$string['overviewext'] = 'Yderligere plugins';
$string['overviewupdatable'] = 'Tilgængelige opdateringer';
$string['packagesdebug'] = 'Debugging-output aktiveret';
$string['packagesdownloading'] = 'Downloader {$a}';
$string['packagesextracting'] = 'Udpakker {$a}';
$string['packagesvalidating'] = 'Validerer {$a}';
$string['packagesvalidatingfailed'] = 'Installationen mislykkedes grundet valideringsfejl';
$string['packagesvalidatingok'] = 'Validering lykkedes, installationen kan fortsætte';
$string['plugincheckall'] = 'Alle plugins';
$string['plugincheckattention'] = 'Plugins der kræver opmærksomhed';
$string['pluginchecknone'] = 'Ingen plugins kræver din opmærksomhed nu.';
$string['pluginchecknotice'] = 'Denne side viser plugins der nok kræver din opmærksomhed under opgraderingen, såsom nye plugins der skal installeres, plugins der skal opgraderes, manglende plugins osv. Ekstra plugins vises hvis der er en opdatering til dem.
Det anbefales at du tjekker om der findes nyere versioner af plugins og opdaterer deres kildekode før du fortsætter med opgraderingen af Moodle.';
$string['plugindisable'] = 'Deaktiver';
$string['plugindisabled'] = 'Deaktiveret';
$string['pluginenable'] = 'Aktiver';
$string['pluginenabled'] = 'Aktiveret';
$string['release'] = 'Udgivelse';
$string['requiredby'] = 'Krævet af: {$a}';
$string['requires'] = 'Kræver';
$string['rootdir'] = 'Mappe';
$string['settings'] = 'Indstillinger';
$string['source'] = 'Kilde';
$string['sourceext'] = 'Ekstra';
$string['sourcestd'] = 'Standard';
$string['status'] = 'Status';
$string['status_delete'] = 'Skal slettes';
$string['status_downgrade'] = 'Der er allerede installeret en nyere version!';
$string['status_missing'] = 'Mangler på disken';
$string['status_new'] = 'Skal installeres';
$string['status_nodb'] = 'Ingen database';
$string['status_upgrade'] = 'Skal opgraderes';
$string['status_uptodate'] = 'Installeret';
$string['supportedconversions'] = 'Understøttet dokumentkonvertering';
$string['supportedmoodleversions'] = 'Understøttede Moodleversioner';
$string['systemname'] = 'Identifikator';
$string['type_antivirus'] = 'Antivirus-plugin';
$string['type_antivirus_plural'] = 'Antivirus-plugins';
$string['type_auth'] = 'Godkendelsesmetode';
$string['type_auth_plural'] = 'Godkendelsesmetoder';
$string['type_availability'] = 'Adgangsbetingelse';
$string['type_availability_plural'] = 'Adgangsbetingelser';
$string['type_block'] = 'Blok';
$string['type_block_plural'] = 'Blokke';
$string['type_cachelock'] = 'Cache lock-håndtering';
$string['type_cachelock_plural'] = 'Cache lock-håndteringer';
$string['type_cachestore'] = 'Cachelager';
$string['type_cachestore_plural'] = 'Cachelagre';
$string['type_calendartype'] = 'Kalendertype';
$string['type_calendartype_plural'] = 'Kalendertyper';
$string['type_contentbank'] = 'Indholdsbank';
$string['type_contentbank_plural'] = 'Indholdsbank-plugins';
$string['type_contenttype'] = 'Indholdsbank';
$string['type_contenttype_plural'] = 'Indholdsbank-plugins';
$string['type_coursereport'] = 'Kursusrapport';
$string['type_coursereport_plural'] = 'Kursusrapporter';
$string['type_customfield'] = 'Brugerdefineret felt';
$string['type_customfield_plural'] = 'Brugerdefinerede felter';
$string['type_dataformat'] = 'Dataformat';
$string['type_dataformat_plural'] = 'Dataformater';
$string['type_editor'] = 'Editor';
$string['type_editor_plural'] = 'Editorer';
$string['type_enrol'] = 'Tilmeldingsmetode';
$string['type_enrol_plural'] = 'Tilmeldingsmetoder';
$string['type_fileconverter'] = 'Dokumentkonvertering';
$string['type_fileconverter_plural'] = 'Dokumentkonvertering';
$string['type_fileconvertermanage'] = 'Håndter værktøjer til dokumentkonvertering';
$string['type_filter'] = 'Tekstfilter';
$string['type_filter_plural'] = 'Tekstfiltre';
$string['type_format'] = 'Kursusformat';
$string['type_format_plural'] = 'Kursusformater';
$string['type_gradeexport'] = 'Eksportmetode til karakterer';
$string['type_gradeexport_plural'] = 'Eksportmetoder til karakterer';
$string['type_gradeimport'] = 'Importmetode til karakterer';
$string['type_gradeimport_plural'] = 'Importmetoder til karakterer';
$string['type_gradereport'] = 'Karakterbogsrapport';
$string['type_gradereport_plural'] = 'Karakterbogsrapporter';
$string['type_gradingform'] = 'Avanceret karaktergivningsmetode';
$string['type_gradingform_plural'] = 'Avancerede karaktergivningsmetoder';
$string['type_h5plib'] = 'H5P-ramme';
$string['type_h5plib_plural'] = 'H5P-rammer';
$string['type_local'] = 'Lokalt plugin';
$string['type_local_plural'] = 'Lokale plugins';
$string['type_media'] = 'Medieafspiller';
$string['type_media_plural'] = 'Medieafspillere';
$string['type_message'] = 'Notifikationsplugin';
$string['type_message_plural'] = 'Underretningsplugins';
$string['type_mlbackend'] = 'Maskinlæring backend';
$string['type_mlbackend_plural'] = 'Maskinlæring backend';
$string['type_mnetservice'] = 'MNet-service';
$string['type_mnetservice_plural'] = 'MNet-servicer';
$string['type_mod'] = 'Aktivitetsmodul';
$string['type_mod_plural'] = 'Aktivitetsmoduler';
$string['type_paygw'] = 'Betalingsgateway';
$string['type_paygw_plural'] = 'Betalingsgateways';
$string['type_paygwmanage'] = 'Håndter betalingsgateways';
$string['type_plagiarism'] = 'Plagierings-plugin';
$string['type_plagiarism_plural'] = 'Plagierings-plugins';
$string['type_portfolio'] = 'Portefolio';
$string['type_portfolio_plural'] = 'Portefolios';
$string['type_profilefield'] = 'Type profilfelt';
$string['type_profilefield_plural'] = 'Typer profilfelter';
$string['type_qbank'] = 'Spørgsmålsbanksplugin';
$string['type_qbank_plural'] = 'Spørgsmålsbanksplugins';
$string['type_qbehaviour'] = 'Spørgsmåls opførsel';
$string['type_qbehaviour_plural'] = 'Spørgsmåls opførsel';
$string['type_qformat'] = 'Format til import/eksport af spørgsmål';
$string['type_qformat_plural'] = 'Import-/eksportformater til spørgsmål';
$string['type_qtype'] = 'Spørgsmålstype';
$string['type_qtype_plural'] = 'Spørgsmålstyper';
$string['type_report'] = 'Site-rapport';
$string['type_report_plural'] = 'Rapporter';
$string['type_repository'] = 'Filarkiv';
$string['type_repository_plural'] = 'Arkiver';
$string['type_search'] = 'Søgemaskine';
$string['type_search_plural'] = 'Søgemaskiner';
$string['type_theme'] = 'Layout';
$string['type_theme_plural'] = 'Layouts';
$string['type_tool'] = 'Admin-værktøj';
$string['type_tool_plural'] = 'Admin-værktøjer';
$string['type_webservice'] = 'Webservice-protokol';
$string['type_webservice_plural'] = 'Webservice-protokoller';
$string['uninstall'] = 'Afinstaller';
$string['uninstallconfirm'] = 'Du er ved at slette plugin\'et <em>{$a->name}</em>. Derved slettes alt i databasen vedrørende dette plugin, det gælder konfiguration, log-poster, brugerfiler håndteret af plugin\'et osv. Der er ingen fortrydelsesret og Moodle opretter ikke en gendannelsesbackup. Er du SIKKER på at du vil fortsætte?';
$string['uninstalldelete'] = 'Alle data vedrørende plugin\'et <em>{$a->name}</em> er slettet fra databasen. Undgå at det geninstallerer sig selv ved manuelt at slette dets mappe <em>{$a->rootdir}</em> fra serveren nu. Moodle kan ikke slette mappen grundet skriveadgangsindstillingerne.';
$string['uninstalldeleteconfirm'] = 'Alle data vedrørende plugin\'et <em>{$a->name}</em> er slettet fra databasen. For at undgå at det geninstallerer sig selv skal dets mappe <em>{$a->rootdir}</em> slettes fra serveren. Vil du gøre det nu?';
$string['uninstalldeleteconfirmexternal'] = 'Det lader til at den aktuelle version af plugin\'et er erhvervet via "source code management system ({$a}) checkout". Sletter du plugin-mappen, kan du miste vigtige lokale ændringer af koden. Forsikr dig om at du definitivt vil slette plugin-mappen før du fortsætter.';
$string['uninstallextraconfirmblock'] = 'Der er {$a->instances} forekomster af denne blok.';
$string['uninstallextraconfirmenrol'] = 'Der er {$a->enrolments} brugertilmeldinger.';
$string['uninstallextraconfirmmod'] = 'Der er {$a->instances} forekomster af dette modul i {$a->courses} kurser.';
$string['uninstalling'] = 'Afinstallerer {$a->name}';
$string['updateavailable'] = 'En ny version {$a} er tilgængelig!';
$string['updateavailable_moreinfo'] = 'Yderligere information...';
$string['updateavailable_release'] = 'Udgivelse {$a}';
$string['updatepluginconfirm'] = 'Bekræftelse af plugin-opdatering';
$string['updatepluginconfirmexternal'] = 'Det lader til at den aktuelle version af plugin\'et er erhvervet via "source code management system ({$a}) checkout". Installerer du denne opdatering, vil du ikke længere kunne få plugin-opdateringer fra kildekode-håndteringssystemet. Forsikr dig om at du definitivt vil opdatere plugin\'et før du fortsætter.';
$string['updatepluginconfirminfo'] = 'Du er ved at installere en ny version af plugin\'et <strong>{$a->name}</strong>. En zip-pakke med version {$a->version} af plugin\'et bliver downloadet fra <a href="{$a->url}">{$a->url}</a> og pakket ud i din Moodleinstallation så den kan opgradere din installation.';
$string['updatepluginconfirmwarning'] = 'Bemærk at Moodle ikke automatisk tager backup af din database før opgraderingen. Vi anbefaler på det kraftigste at du laver en fuld backup nu, så du kan håndtere det hvis det helt undtagelsesvis skulle ske, at den nye kode har fejl som gør dit site utilgængeligt, eller måske korrumperer databasen. Fortsæt på egen risiko.';
$string['validationmsg_componentmatch'] = 'Fulde navn på komponenten';
$string['validationmsg_componentmismatchname'] = 'Plugin-navnekonflikt';
$string['validationmsg_componentmismatchname_help'] = 'Nogle zip-pakker såsom dem Github genererer, kan indeholde forkert navn på rod-mappen. Du bliver nødt til at rette rod-mapens navn så det matcher pluginnavnet.';
$string['validationmsg_componentmismatchname_info'] = 'Plugin\'et opgiver dets navn som "{$a}", men det matcher ikke navnet på rod-mappen.';
$string['validationmsg_componentmismatchtype'] = 'Kludder i plugin-type';
$string['validationmsg_componentmismatchtype_info'] = 'Forventet type "{$a->expected}", men plugin\'et erklærer at dets type er "{$a->found}".';
$string['validationmsg_filenotexists'] = 'Udpakket fil ikke fundet';
$string['validationmsg_filesnumber'] = 'Der blev ikke fundet nok filer i pakken';
$string['validationmsg_filestatus'] = 'Ikke alle filer kunne udpakkes';
$string['validationmsg_filestatus_info'] = 'Forsøg på at udpakke filen {$a->file} resulterede i fejlen "{$a->status}".';
$string['validationmsg_foundlangfile'] = 'Sprogfil fundet';
$string['validationmsg_maturity'] = 'Angivet modenhedsniveau';
$string['validationmsg_maturity_help'] = 'Dette plugin kan angive dets modenhedsniveau. Hvis den der vedligeholder plugin\'et anser det for stabilt, vil dette angives som MATURITY_STABLE. Alle andre modenhedsniveauer (eksempelvis alpha eller betal) bør anses som værende ustabile og en advarsel vil blive rejst.';
$string['validationmsg_missingcomponent'] = 'Plugin\'et opgiver ikke dets navn';
$string['validationmsg_missingcomponent_help'] = 'Alle plugins skal opgive deres fulde komponentnavn via "$plugin->component"-deklarationen i filen version.php.';
$string['validationmsg_missingcomponent_link'] = 'Development:version.php';
$string['validationmsg_missingexpectedlangenfile'] = 'Navnekludder på engelsk sprogfil';
$string['validationmsg_missingexpectedlangenfile_info'] = 'Den givne plugin-type mangler den forventede engelske sprogfil {$a}.';
$string['validationmsg_missinglangenfile'] = 'Ingen engelsk sprogfil fundet.';
$string['validationmsg_missinglangenfolder'] = 'Mangler engelsk sprogmappe';
$string['validationmsg_missingversion'] = 'Plugin\'et angiver ikke dets version';
$string['validationmsg_missingversionphp'] = 'Filen version.php blev ikke fundet';
$string['validationmsg_multiplelangenfiles'] = 'Der er fundet flere engelske sprogfiler';
$string['validationmsg_onedir'] = 'Zip-pakken har en ugyldig struktur';
$string['validationmsg_onedir_help'] = 'Zip-pakken må kun indeholde en rod-mappe med plugin-koden. Navnet på mappen skal matche plugin-navnet.';
$string['validationmsg_pathwritable'] = 'Tjek af skriveadgang';
$string['validationmsg_pluginversion'] = 'Plugin-version';
$string['validationmsg_pluginversiontoolow'] = 'Dette plugin er allerede installeret i en nyere version';
$string['validationmsg_release'] = 'Plugin-udgivelse';
$string['validationmsg_requiresmoodle'] = 'Krævet Moodleversion';
$string['validationmsg_rootdir'] = 'Navnet på det plugin der installeres';
$string['validationmsg_rootdir_help'] = 'Navnet på rod-mappen i zip-pakken er det samme som navnet på plugin\'et der skal installeres. Hvis navnet ikke er korrekt, kan du omdøbe rod-mappen i zip-filen inden installationen.';
$string['validationmsg_rootdirinvalid'] = 'Ugyldigt plugin-navn';
$string['validationmsg_rootdirinvalid_help'] = 'Navnet på rod-mappen i zip-pakken overholder ikke de formelle syntaks-krav. Nogle zip-pakker, såsom dem der er generet af Github, kan indeholde forkert navn på rod-mappen. Du må omdøbe navnet på rod-mappen så det matcher plugin-navnet';
$string['validationmsg_targetexists'] = 'Destinationslokationen eksisterer allerede og vil blive slettet';
$string['validationmsg_targetexists_help'] = 'Plugin-mappen eksisterer allerede og bliver erstattet af plugin-pakkens indhold.';
$string['validationmsg_targetnotdir'] = 'Destinationslokationen er optaget af en fil';
$string['validationmsg_unknowntype'] = 'Ukendt plugin-type';
$string['validationmsg_versionphpsyntax'] = 'Ikke understøttet syntaks i filen version.php';
$string['validationmsglevel_debug'] = 'Debug';
$string['validationmsglevel_error'] = 'Fejl';
$string['validationmsglevel_info'] = 'OK';
$string['validationmsglevel_warning'] = 'Advarsel';
$string['version'] = 'Version';
$string['versiondb'] = 'Aktuelle version';
$string['versiondisk'] = 'Ny version';
