<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'url', language 'no', version '4.2'.
 *
 * @package     url
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['chooseavariable'] = 'Velg en variabel...';
$string['clicktoopen'] = 'Klikk på {$a} for å åpne ressursen.';
$string['configdisplayoptions'] = 'Velg hvilke muligheter som skal være tilgjengelige for nye instanser, eksisterende innstillinger endres ikke. Hold CTRL-tasten for å velge mer enn ett felt.';
$string['configframesize'] = 'Når en webside eller opplastet fil vises i en ramme, er det denne verdien som bestemmer høyden på navigasjonslinjen på toppen av siden.';
$string['configrolesinparams'] = 'Bør tilpassede rollenavn (fra kursinnstillingene) være tilgjengelige som variabler for URL-parametere?';
$string['configsecretphrase'] = 'Denne hemmelige frasen brukes til å kryptere kode som kan bli sendt til andre servere som en parameter. Den krypterte koden sendes som md5 og er en kobling mellom gjeldende brukers IP-adresse og den hemmelige frasen.  (code=md5(IP.secretphrase). Vennligst merk at dette ikke er veldig sikkert siden IP-adresser kan endres og mange deler også IP-adresse.';
$string['contentheader'] = 'Innhold';
$string['createurl'] = 'Opprett en URL';
$string['displayoptions'] = 'Tilgjengelige visningsalternativer';
$string['displayselect'] = 'Visning';
$string['displayselect_help'] = 'Denne innstillingen, sammen med URL filtype og hvorvidt nettleseren tillater innebygging, bestemmer hvordan URL-en skal vises. Opsjonenene kan inkludere:

* Automatisk - Beste visningsalternativ for URL-en bestemmes automatisk.
* Innebygg - URL-en vises som en del av siden under navigsjonsmenyen og sammen med URL-beskrivelsen og evt. blokker.
* Åpne - Du blir sendt fra denne siden og til URL-en.
* I et popup-vindu - URL-en vises i et nytt vindu uten menyer, adresslinje og statusfelt.
* I en ramme - URL-en vises i en ramme under navigasjonsmenyen og med URL-beskrivelsen.
* Nytt vindu - URL-en vises i et nytt vanlig nettleservindu.';
$string['displayselectexplain'] = 'Velg visningstype - ikke alle typer passer til alle URL-er.';
$string['externalurl'] = 'Ekstern URL';
$string['framesize'] = 'Rammehøyde';
$string['indicator:cognitivedepth'] = 'Kognitiv URL';
$string['indicator:cognitivedepth_help'] = 'Denne indikatoren er basert på den kognitive dybden som studenten viste i en URL-ressurs.';
$string['indicator:cognitivedepthdef'] = 'URL - kognitivt engasjement';
$string['indicator:cognitivedepthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det kognitive engasjementet som tilbys av URL-ressursene i løpet av dette analyseintervallet (Nivåer = Ingen visning, visning)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sosial URL';
$string['indicator:socialbreadth_help'] = 'Denne indikatoren er basert på den sosiale bredden vist av studenten i en URL-ressurs.';
$string['indicator:socialbreadthdef'] = 'URL - sosialt engasjement';
$string['indicator:socialbreadthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det sosiale engasjementet som tilbys av URL-ressursene i løpet av dette analyseintervallet (Nivåer = Ingen deltakelse, deltaker alene)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidstoredurl'] = 'Kan ikke vise denne ressursen. URL-en er ugyldig.';
$string['invalidurl'] = 'Oppgitt URL er ugyldig';
$string['modulename'] = 'URL';
$string['modulename_help'] = 'URL-modulen gjør det mulig for læreren å legge ut nettlenker som kursressurser. Tilgjengelige nettressurser av alle slag kan lenkes til, f.eks. dokumenter eller bilder. URLen trenger altså ikke være hjemmesiden til et nettsted. URLen til en bestemt nettside kan kopieres og limes inn, eller så kan læreren bruke filvelgeren og velge en lenke fra et filområde som f.eks. Flickr, YouTube eller Wikimedia (avhengig av hvilke filområder som er aktivert for portalen).

Det finnes en rekke visningsvalg for URL, som f.eks. integrert (embedded) eller åpne i nytt vindu. Det er også avanserte valg for sending av informasjon til URLen hvis ønskelig (som f.eks. en students navn).

Vær oppmerksom på at URLer kan også legges til andre ressurs- eller aktivitetstyper via editoren.';
$string['modulename_link'] = 'mod/url/view';
$string['modulenameplural'] = 'URL-er';
$string['name'] = 'Navn';
$string['name_help'] = 'Dette vil fungere som lenketeksten for URL-en.

Skriv inn en meningsfull tekst som kort beskriver nettadressens formål.

Unngå å bruke ordet "lenke". Dette vil hjelpe brukere av skjermlesere når skjermlesere annonserer linker (f.eks. "Moodle.org, link"), så det er ikke nødvendig å inkludere ordet "lenke" i navnefeltet.';
$string['page-mod-url-x'] = 'Alle sider i URL-modulen';
$string['parameterinfo'] = '&amp;parameter=variable';
$string['parametersheader'] = 'URL-variabler';
$string['parametersheader_help'] = 'Denne delen lar deg overføre intern informasjon som en del av URL-en. Dette er nyttig hvis URL-en er en interaktiv webside som tar parametere, og du for eksempel vil sende noe som navnet på den nåværende brukeren. Skriv inn navnet på URL-parameteren i tekstboksen, og velg deretter den aktuelle nettstedvariabelen.';
$string['pluginadministration'] = 'URL moduladministrasjon';
$string['pluginname'] = 'URL';
$string['popupheight'] = 'Popup-vinduets høyde (i pixler)';
$string['popupheightexplain'] = 'Angir standard høyde for popup-vinduer.';
$string['popupwidth'] = 'Popup-vinduets bredde (i pixler)';
$string['popupwidthexplain'] = 'Angir standard bredde for popup-vinduer.';
$string['printintro'] = 'Vis URL-beskrivelse';
$string['printintroexplain'] = 'Vise URL-beskrivelsen under innholdet? Noen visningstyper kan utelate beskrivelsen selv om visningen er aktivert.';
$string['privacy:metadata'] = 'Modulen URL lagrer ikke noen persondata.';
$string['rolesinparams'] = 'Rollenavn som URL-variabler';
$string['search:activity'] = 'URL';
$string['serverurl'] = 'Server URL';
$string['url:addinstance'] = 'Legg til ny URL-ressurs';
$string['url:view'] = 'Vis URL';
