<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_ldap', language 'no', version '4.2'.
 *
 * @package     auth_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_ldap_ad_create_req'] = 'Kan ikke lage ny konto i Active Directory. Pass på at du har fått med alle ting nødvendig for att dette skal virke (LDAPS forbindelse, bind bruker med nødvendige rettigheter osv.)';
$string['auth_ldap_attrcreators'] = 'Liste med grupper eller kontekster hvor medlemmene kan lage egenskaper. Separer flere grupper med \';\'. Vanligvis noe i likhet med \'cn=lærere,ou=stab,o=minorg\'';
$string['auth_ldap_attrcreators_key'] = 'Egenskap oppretter';
$string['auth_ldap_auth_user_create_key'] = 'Lag brukere eksternt';
$string['auth_ldap_bind_dn'] = 'Hvis du vil bruke bind-user for å søke blant brukere skal det angis her. (Noe som f.eks. \'cn=ldapuser,ou=public,o=org\')';
$string['auth_ldap_bind_dn_key'] = 'Særpreget navn';
$string['auth_ldap_bind_pw'] = 'Passord for bind-user';
$string['auth_ldap_bind_pw_key'] = 'Passord';
$string['auth_ldap_bind_settings'] = 'Bind instillinger';
$string['auth_ldap_changepasswordurl_key'] = 'URL for å endre passord';
$string['auth_ldap_contexts'] = 'Innholdsliste over hvor brukerne er. Del ulike sammenhenger med \';\'. (F.eks. \'ou=users,o=org; ou=others,o=org\')';
$string['auth_ldap_contexts_key'] = 'Kontekster';
$string['auth_ldap_create_context'] = 'Hvis du lar brukere registrere seg med e-postbekreftelse, spesifiser sammenhengen de registreres. Dette må være ulikt andre brukere for å forhindre sikkerhetsproblemer. Du trenger ikke å legge denne sammenhengen til variabelen ldap_context, Moodle vil automatisk søke etter brukere fra denne sammenhengen.';
$string['auth_ldap_create_context_key'] = 'Kontekst for nye brukere';
$string['auth_ldap_create_error'] = 'Feil ved opprettelse av bruker i LDAP';
$string['auth_ldap_expiration_desc'] = 'Velg \'{$a->no}\' for å slå av sjekking av utgått passord eller \'{$a->ldapserver}\' for å lese passwordexpiration time direkte fra LDAP-serveren.';
$string['auth_ldap_expiration_key'] = 'Utløper';
$string['auth_ldap_expiration_warning_desc'] = 'Antall dager før passordutløpsadvarselet sendes.';
$string['auth_ldap_expiration_warning_key'] = 'Advarsel om utløp';
$string['auth_ldap_expireattr_desc'] = 'Valgfritt: overstyrer LDAP-egenskapen som lagrer passord ved utløpstid.';
$string['auth_ldap_expireattr_key'] = 'Utløpsegenskap';
$string['auth_ldap_graceattr_desc'] = 'Valgfritt: Overstyrer attributten for "tilgivende" innlogging';
$string['auth_ldap_gracelogin_key'] = 'Egenskap for påloggingsforsøk';
$string['auth_ldap_gracelogins_desc'] = 'Slå på støtte for LDAP-utløpsperiode. Etter at passordet er utløpt kan utløpt bruker logge på til antall påloggingsforsøk er nede i 0. Ved å slå på denne innstillinger vises brukere en beskjed om at passordet er utløpt.';
$string['auth_ldap_gracelogins_key'] = 'Antall påloggingsforsøk';
$string['auth_ldap_groupecreators'] = 'Medlemmene i disse gruppene er tillatt å opprette grupper. Del forskjellige grupper med \';\'. Ser vanligvis ut som \'cn=teachers,ou=staff,o=myorg\'';
$string['auth_ldap_groupecreators_key'] = 'Gruppe opprettere';
$string['auth_ldap_host_url'] = 'Angi LDAP-vert i URL-form, f.eks. \'ldap://ldap.myorg.com/\' eller \'ldaps://ldap.myorg.com/\'. Atskill flere servere med \';\' for å få redundant-støtte.';
$string['auth_ldap_host_url_key'] = 'Vert URL';
$string['auth_ldap_ldap_encoding'] = 'Angi koding som blir brukt av LDAP-serveren. Sannsynligvis utf-8. Hvis LDAP v2 er valgt, vil Active Directory bruker kodesettet for serveren som vanligvis er cp1252 eller cp1250.';
$string['auth_ldap_ldap_encoding_key'] = 'LDAP koding';
$string['auth_ldap_login_settings'] = 'Logginn-innstillinger';
$string['auth_ldap_memberattribute'] = 'Spesifiser atributt for medlemmer i en gruppe, f.eks. \'medlem\'';
$string['auth_ldap_memberattribute_isdn'] = 'Overstyrer håndtering av medlemsattributtverdier';
$string['auth_ldap_memberattribute_isdn_key'] = 'Medlemsegenskap bruker dn';
$string['auth_ldap_memberattribute_key'] = 'Medlemsegenskap';
$string['auth_ldap_no_mbstring'] = 'Du trenger mbstring tillegget for å opprette brukere i Active Directory.';
$string['auth_ldap_noconnect'] = 'LDAP-modulen kan ikke kontakte server: {$a}';
$string['auth_ldap_noconnect_all'] = 'LDAP-modulen kan ikke kontakte noen servere: {$a}';
$string['auth_ldap_noextension'] = 'PHP LDAP-modulen ser ikke ut til å være aktivert. Forsikre deg om at den er installert og aktivert hvis du vil bruke denne autentiseringsmodulen.';
$string['auth_ldap_objectclass'] = 'Valgfritt: Overstyrer objectClass brukt for å gi navn/søke etter brukere med ldap_user_type. Vanligvis trenger du ikke å endre denne.';
$string['auth_ldap_objectclass_key'] = 'Objektklasse';
$string['auth_ldap_opt_deref'] = 'Angir hvordan aliaser blir behandlet ved søking. Velg en av følgende verdier: "No" (LDAP_DER_NEVER) eller "Yes" (LDAP_DEREF_ALWAYS)';
$string['auth_ldap_opt_deref_key'] = 'Avreferanse aliaser';
$string['auth_ldap_passtype'] = 'Angi format for nye eller endrede passord i LDAP serveren.';
$string['auth_ldap_passtype_key'] = 'Passordformat';
$string['auth_ldap_passwdexpire_settings'] = 'Utløpsinnstillinger for LDAP-passord';
$string['auth_ldap_preventpassindb'] = 'Velg ja for å forhindre at passord blir lagret i Moodle\'s database.';
$string['auth_ldap_preventpassindb_key'] = 'Forhindre mellomlagring av passord';
$string['auth_ldap_rolecontext'] = '{$a->localname} kontekst';
$string['auth_ldap_rolecontext_help'] = 'LDAP-kontekst brukes til å velge for <i> {$a->localname} </i> kartlegging. Skill flere grupper med \';\'. Vanligvis noe sånt som "cn={$a->shortname},ou=first-ou-with-role-groups,o=myorg; cn={$a->shortname},ou=second-ou-with-role-groups,o=myorg".';
$string['auth_ldap_search_sub'] = 'Sett verdi <> 0 hvis du vil søke etter brukere fra underkontekster.';
$string['auth_ldap_search_sub_key'] = 'Velg underkontekster';
$string['auth_ldap_server_settings'] = 'LDAP serverinnstillinger';
$string['auth_ldap_suspended_attribute'] = 'Valgfritt: Når angitt skal dette attributtet brukes til å aktivere / suspendere lokalt opprettet brukerkonto.';
$string['auth_ldap_suspended_attribute_key'] = 'Suspendert attibutt';
$string['auth_ldap_unsupportedusertype'] = 'auth: ldap user_create() støtter ikke valgte brukertype: {$a} (...ennå)';
$string['auth_ldap_update_userinfo'] = 'Oppdater brukerinfo (fornavn, etternavn, adresse...) fra LDAP til Moodle. Se /auth/ldap/attr_mappings.php for informasjon';
$string['auth_ldap_user_attribute'] = 'Atributten for å navngi og søke etter brukere (vanligvis \'cn\').';
$string['auth_ldap_user_attribute_key'] = 'Brukeregenskap';
$string['auth_ldap_user_exists'] = 'LDAP brukernavn eksisterer allerede';
$string['auth_ldap_user_settings'] = 'Innstillinger for brukeroppslag';
$string['auth_ldap_user_type'] = 'Velg hvordan brukere lagres i LDAP. Denne innstillingen angir også hvordan passordutløp, pålogging ved utløpt passord og brukeropprettelse virker.';
$string['auth_ldap_user_type_key'] = 'Brukertype';
$string['auth_ldap_usertypeundefined'] = 'config.user_type er ikke definert eller funksjonen ldap_expirationtime2unix støtter ikke valgt type!';
$string['auth_ldap_usertypeundefined2'] = 'config.user_type er ikke definert eller funksjonen ldap_unixi2expirationtime støtter ikke valgte type.';
$string['auth_ldap_version'] = 'Versjonen av LDAP-protokoll serveren din bruker.';
$string['auth_ldap_version_key'] = 'Versjon';
$string['auth_ldapdescription'] = 'Denne metoden krever godkjenning opp mot en ekstern LDAP-server. Hvis det gitte brukernavnet/passordet er gyldig, oppretter Moodle en ny bruker i databasen. Denne modulen kan lese brukerinfo fra LDAP og forhåndsutfylle ønskede felter i Moodle. For senere innlogging blir kun brukernavn og passord kontrollert.';
$string['auth_ldapextrafields'] = 'Disse feltene er valgfrie.  Du kan velge å forhåndsutfylle noen brukerfelter i Moodle på forhånd fra <b>LDAP-felterne</b> som du spesifiserer her. <p>Hvis du ikke skriver noe her, vil det ikke overføres noe fra LDAP og standardene i Moodle vil bli brukt i stedet.<p>Uansett vil brukeren være i stand til å endre disse feltene etter at de har logget inn.';
$string['auth_ldapnotinstalled'] = 'Kan ikke bruke LDAP autentisering. PHP LDAP modulen er ikke installert.';
$string['auth_ntlmsso'] = 'NTLM SSO';
$string['auth_ntlmsso_enabled'] = 'Sett til ja for å forsøke Single Sign On på NTLM domenet. <strong>Merk:</strong> dette krever tilleggsinnstillinger på webserveren for å fungere, se <a href="http://docs.moodle.org/en/NTLM_authentication">NTLM authentication</a>.';
$string['auth_ntlmsso_enabled_key'] = 'Slå på';
$string['auth_ntlmsso_ie_fastpath'] = 'Settes til JA for å aktivere NTLM SSO snarvei som går utenom noen trinn og BARE virker med MS Internet Explorer.';
$string['auth_ntlmsso_ie_fastpath_attempt'] = 'Forsøk NTLM med alle nettlesere';
$string['auth_ntlmsso_ie_fastpath_key'] = 'MS IE snarvei?';
$string['auth_ntlmsso_ie_fastpath_yesattempt'] = 'Ja, prøv NTLM med andre nettlesere';
$string['auth_ntlmsso_ie_fastpath_yesform'] = 'Ja, alle andre nettlesere bruker standard innloggingsside';
$string['auth_ntlmsso_maybeinvalidformat'] = 'Kunne ikke hente ut brukernavnet fra overskriften EKSTERN_BRUKER. Er det konfigurerte formatet riktig?';
$string['auth_ntlmsso_missing_username'] = 'Du må i det minste angi %brukernavn% i formatet for eksterne brukernavn.';
$string['auth_ntlmsso_remoteuserformat'] = 'Hvis du har valgt \'NTLM\' i \'Autentiseringstype\', kan du angi formatet for eksterne brukernavn her. Hvis du lar feltet stå tomt, blir standardvalget formatet DOMENE\\brukernavn brukt. Du kan bruke den valgfrie <b>%domene%</b>plassjolderen for å angi hvor domenenavnet skal vises, og den obligatoriske <b>%brukernavn%</b>plassholderen for å angi hvor brukernavnet skal vises. <br /><br />Noen mye brukte formater er <tt>%domene%%brukernavn%</tt> (standard for MS Windows), <tt>%domene%/%brukernavn%</tt>, <tt>%domene%+%brukernavn%</tt> og kun <tt>%brukernavn%</tt> (hvis det ikke finnes noen domenedel).';
$string['auth_ntlmsso_remoteuserformat_key'] = 'Format for eksterne brukernavn';
$string['auth_ntlmsso_subnet'] = 'Hvis påslått, vil en bare forsøke SSO med klienter i dette subnettet. Formatet skal være xxx.xxx.xxx.xxx/bitmaske. Flere subnett legges til atskilt med komma ",".';
$string['auth_ntlmsso_subnet_key'] = 'Subnet';
$string['auth_ntlmsso_type'] = 'Autentiseringsmetoden som er satt opp på webserveren for å autentisere brukerne (hvis du er i tvil - bruk NTLM)';
$string['auth_ntlmsso_type_key'] = 'Autentiseringstype';
$string['cannotmaprole'] = 'Rollen "{$a->rolename}" kan ikke mappes fordi kortnavnet "{$a->shortname}" er for langt og/eller inneholder en bindestrek. For at den skal mappes må du reduseres kortnavnet til maksimalt {$->charlimit} tegn eller fjerne bindestrekene. <a href="{$a->link}">Rediger rollen her</a>';
$string['connectingldap'] = 'Kobler til LDAP-server...';
$string['connectingldapsuccess'] = 'Tilkoblingen til LDAP-serveren var vellykket';
$string['creatingtemptable'] = 'Oppretter midlertidig tabell {$a}';
$string['diag_contextnotfound'] = 'Konteksten {$a} eksisterer ikke eller kan ikke leses av bind DN.';
$string['diag_emptycontext'] = 'Fant tom kontekst';
$string['diag_genericerror'] = 'LDAP feil {$a->code} leser {$a->subject}: {$a->message}.';
$string['diag_rolegroupnotfound'] = 'Gruppe $a->group} for rolle {$a->localname} eksisterer ikke eller kan ikke leses av bind DN.';
$string['diag_toooldversion'] = 'Det er veldig usannsynlig at en moderne LDAP server bruker LDAPv2-protokollen. Feil innstillinger kan korrumpere verdiene i brukerfeltene. Sjekk med din LDAP-administrator.';
$string['didntfindexpiretime'] = 'password_expire()  fant ingen utløpstid.';
$string['didntgetusersfromldap'] = 'Fikk ikke hentet noen brukere fra LDAP - feil? - avslutter.';
$string['gotcountrecordsfromldap'] = 'Hentet {$a} poster fra LDAP';
$string['invalidusererrors'] = 'Advarsel: Oppretting av {$a} brukerkontoer ble hoppet over.';
$string['invaliduserexception'] = 'Feil: Kan ikke opprette ny brukerkonto. Detaljer og årsak:
{$a}
Hopper over denne brukeren.';
$string['ldapnotconfigured'] = 'Verst-URL til LDAP-serveren er foreløpig ikke konfigurert';
$string['morethanoneuser'] = 'Mer enn en brukerkonto ble funnet i LDAP. Bruker kun den første.';
$string['needbcmath'] = 'Du trenger BCMath-tillegget for å bruke utløpt passordtest fra Active Directory';
$string['needmbstring'] = 'Du trenger mbstring-tillegget for å endre passord i Active Directory';
$string['nodnforusername'] = 'Feil i user_update_password(). Ingen DN for: {$a->username}';
$string['noemail'] = 'Prøvde å sende deg en epost men fikk ikke til!';
$string['notcalledfromserver'] = 'Burde ikke kalles fra webserveren!';
$string['noupdatestobedone'] = 'Ingen oppdateringer som trenger å bli gjort';
$string['nouserentriestoremove'] = 'Ingen brukeroppføringer å slette';
$string['nouserentriestorevive'] = 'Ingen brukeroppføringer mottatt';
$string['nouserstobeadded'] = 'Ingen brukeroppføringer skal legges til';
$string['ntlmsso_attempting'] = 'Forsøker Singel Sign on via NTLM...';
$string['ntlmsso_failed'] = 'Auto-login feilet, prøv vanlig loginside.';
$string['ntlmsso_isdisabled'] = 'NTLM SSO er slått av.';
$string['ntlmsso_unknowntype'] = 'Ukjent ntlmmsso type!';
$string['pagedresultsnotsupp'] = 'LDAP-paginerte sider støttes ikke (enten mangler PHP-versjonen din støtte eller så har du konfigurert Moodle til å bruke LDAP-protokoll versjon 2 eller så er Moodle ikke i stand til å kontakt LDAP-serveren din for å sjekke om paginert støtte er tilgjengelig)';
$string['pagesize'] = 'Pass på at denne verdien er mindre enn den satte størrelsesgrensen til ditt LDAP-serverresultat (det høyeste antall oppføringer som kan hentes opp i en spørring)';
$string['pagesize_key'] = 'Sidestørrelse';
$string['pluginname'] = 'Bruk en LDAP-server';
$string['pluginnotenabled'] = 'Modul ikke slått på!';
$string['privacy:metadata'] = 'Modulen "LDAP server autentisering" lagrer ikke noen persondata.';
$string['renamingnotallowed'] = 'Endring av brukernavn ikke tillatt i LDAP';
$string['rootdseerror'] = 'Feil ved spørring i rootDSE i Active Directory';
$string['start_tls'] = 'Bruk vanlig LDAP-tjeneste (port 389) med TLS-kryptering';
$string['start_tls_key'] = 'Bruk TLS';
$string['syncroles'] = 'Synkroniser portalroller fra LDAP';
$string['synctask'] = 'Synkroniseringsjobb for LDAP brukere';
$string['systemrolemapping'] = 'Systemrollemapping';
$string['updatepasserror'] = 'Feil i user_update_password(). Feilkode: {$a->errno}; Feilstreng: {$a->errstring}';
$string['updatepasserrorexpire'] = 'Feil i user_update_password() når passordets utløpsdata leses. Feilkode: {$a->errno}; Feilstreng: {$a->errstring}';
$string['updatepasserrorexpiregrace'] = 'Feil i user_update_password() når utløpstid og/eller gracelogins skal modifiseres. Feilkode: {$a->errno}; Feilstreng: {$a->errstring}';
$string['updateremfail'] = 'Feil ved oppdatering av LDAP oppføringen. Feilkode: {$a->errno}; Feilstreng: {$a->errstring}<br/>Nøkkel ({$a->key}) - tidligere Moodle-verdi: \'{$a->ouvalue}\' ny verdi: \'{$a->nuvalue}\'';
$string['updateremfailamb'] = 'Feil ved oppdatering av LDAP med tvetydig felt {$a->key}; tidligere Moodle-verdi: \'{$a->ouvalue}\', ny verdi: \'{$a->nuvalue}\'';
$string['updateusernotfound'] = 'Fant ikke brukeren i den eksterne oppdateringen. Detaljer:  søkebase: \'{$a->userdn}\'; søkefilter: \'(objectClass=*)\'; søkeattributter: {$a->attribs}';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() støtter ikke valgte brukertype: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() støtter ikke valgte brukertype: {$a}';
$string['useracctctrlerror'] = 'Feil ved userAccountControl for {$a}';
$string['userentriestoadd'] = 'Brukerinformasjon som legges til: {$a}';
$string['userentriestoremove'] = 'Brukerinformasjon som fjernes: {$a}';
$string['userentriestorevive'] = 'Brukerinformasjon som bør sees over: {$a}';
$string['userentriestoupdate'] = 'Brukerinformasjon som vil bli oppdatert: {$a}';
$string['usernotfound'] = 'Bruker ikke funnet i LDAP';
