<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'sr_cr', version '4.2'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Акције за интерфејс оцењивача';
$string['actionsforpost'] = 'Акције за пост';
$string['activitydate:due'] = 'Рок:';
$string['activityoverview'] = 'Има нових порука на форуму';
$string['addanewdiscussion'] = 'Додај тему за дискусију';
$string['addanewquestion'] = 'Додај ново питање';
$string['addanewtopic'] = 'Додај нову тему';
$string['addreply'] = 'Додај одговор';
$string['addtofavourites'] = 'Означи ову дискусију звездицом';
$string['advancedsearch'] = 'Напредно претраживање';
$string['alldiscussions'] = 'Све дискусије';
$string['allforums'] = 'Сви форуми';
$string['allowdiscussions'] = 'Да ли {$a} може слати поруке на овај форум?';
$string['allowsallsubscribe'] = 'Овај форум дозвољава свима да одаберу да ли ће се претплатити или не.';
$string['allowsdiscussions'] = 'Овај форум дозвољава свакој особи да започне једну дискусију';
$string['allsubscribe'] = 'Претплатите се на све форуме';
$string['allunsubscribe'] = 'Одјавите се са свих форума';
$string['allusers'] = 'Сви корисници';
$string['alreadyfirstpost'] = 'Ово је већ прва порука у дискусији';
$string['anyfile'] = 'Било која датотека';
$string['areaattachment'] = 'Прилози';
$string['areapost'] = 'Поруке';
$string['attachment'] = 'Прилог';
$string['attachment_help'] = 'Поруци можете да приложите једну или више датотека. Ако приложите слику, она ће бити приказана на крају поруке.';
$string['attachmentname'] = 'Прилог {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Не можете да извезете прилоге без идентификатора поруке';
$string['attachments'] = 'Прилози';
$string['attachmentswordcount'] = 'Прилози и број речи';
$string['authorreplyingprivatelytoauthor'] = 'Корисник {$a->respondant} одговара приватно кориснику {$a->author}';
$string['authorreplyingtoauthor'] = 'Корисник {$a->respondant} одговара кориснику {$a->author}';
$string['availability'] = 'Доступност';
$string['blockafter'] = 'Гранична вредност броја порука која доводи до блокирања';
$string['blockafter_help'] = 'Ово подешавање одређује највећи број порука које корисник може да пошаље на форум у датом временском периоду. Ово ограничење не важи за кориснике који имају способност mod/forum:postwithoutthrottling.';
$string['blockperiod'] = 'Временски период након ког се врши блокирање';
$string['blockperiod_help'] = 'Могуће је ограничити број порука које полазници могу послати унутар датог временског периода. Ово ограничење не важи за кориснике који имају овлашћења mod/forum:postwithoutthrottling.';
$string['blockperioddisabled'] = 'Не блокирати';
$string['blogforum'] = 'Стандардни форум приказан у формату сличном блогу';
$string['bynameondate'] = 'написао/ла {$a->name} - {$a->date}';
$string['cachedef_forum_count_discussions'] = 'Број дискусија на форуму';
$string['cachedef_forum_is_tracked'] = 'Статус праћења форума за корисника';
$string['calendardue'] = 'Истиче крајњи рок за слање порука на {$a}';
$string['cancelreply'] = 'Откажи одговор';
$string['cannotadd'] = 'Није могуће додати дискусију на овом форуму';
$string['cannotadddiscussion'] = 'Додавање дискусије у оквиру овог форума захтева групно чланство.';
$string['cannotadddiscussionall'] = 'Немате дозволу да додајете нову тему за дискусију за све учеснике.';
$string['cannotadddiscussiongroup'] = 'Нисте у могућности да креирате дискусију зато што нисте члан ниједне групе.';
$string['cannotaddsubscriber'] = 'Није било могуће додати претплатника са идентификатором {$a} на овај форум!';
$string['cannotaddteacherforumto'] = 'Није било могуће додати инстанцу измењеног форума предавача у секцију 0 овога курса';
$string['cannotcreatediscussion'] = 'Није било могуће отворити нову дискусију';
$string['cannotcreateinstanceforteacher'] = 'Није било могуће крерати нову инстанцу модула за предавачки форум';
$string['cannotdeletepost'] = 'Не можете да обришете ову поруку!';
$string['cannoteditposts'] = 'Не можете да уређујете поруке других корисника!';
$string['cannotexportforum'] = 'Не можете да извезете овај форум';
$string['cannotfavourite'] = 'Жао нам је, али немате овлашћења да означите дискусије звездицом.';
$string['cannotfinddiscussion'] = 'Није било могуће наћи дискусију на овом форуму';
$string['cannotfindfirstpost'] = 'Није било могуће наћи прву поруку на овом форуму';
$string['cannotfindorcreateforum'] = 'Није било могуће наћи или креирати главни форум за обавештења на овом сајту';
$string['cannotfindparentpost'] = 'Није било могуће наћи надређену поруку за поруку {$a}';
$string['cannotmovefromsingleforum'] = 'Није могуће преместити дискусију из форума типа \'једна обична дискусија\'';
$string['cannotmovenotvisible'] = 'Форум није видљив';
$string['cannotmovetonotexist'] = 'Не можете да преместите у тај форум јер он не постоји!';
$string['cannotmovetonotfound'] = 'Циљни форум није пронађен на овом курсу.';
$string['cannotmovetosingleforum'] = 'Није могуће преместити дискусију у форум типа једна обична дискусија';
$string['cannotpindiscussions'] = 'Жао нам је, немате овлашћења да фиксирате дискусије.';
$string['cannotpurgecachedrss'] = 'Није било могуће очистити RSS доводе из кеша за изворни и/или одредишни(е) форум(е) - проверите Вашу датотеку за дозволе форума';
$string['cannotremovesubscriber'] = 'Није било могуће уклонити претплатника са идентификатором {$a} са овог форума!';
$string['cannotreply'] = 'Не можете да одговорите на ову поруку';
$string['cannotsplit'] = 'Дискусије са овог форума не могу бити раздвојене';
$string['cannotsubscribe'] = 'Опростите, али морате бити члан групе да бисте се претплатили.';
$string['cannottrack'] = 'Није могуће престати с праћењем овог форума';
$string['cannotunsubscribe'] = 'Није могуће одјавити се са тог форума';
$string['cannotupdatepost'] = 'Не можете да ажурирате ову поруку';
$string['cannotuseseperategroupsandsingletopic'] = 'Одвојене групе се не могу користити на форуму са једном обичном дискусијом.';
$string['cannotusesingletopicandseperategroups'] = 'Форум \'Једна обична дискусија\' се не може користити са одвојеним групама.';
$string['cannotviewpostyet'] = 'Још увек не можете да читате поруке других полазника у овој дискусији јер нисте послали ниједну поруку';
$string['cannotviewusersposts'] = 'Не постоје поруке овог корисника које можете да видите';
$string['cleanreadtime'] = 'Време када се старе поруке обележавају као прочитане';
$string['clicktofavourite'] = 'Нисте обележили ову дискусију звездицом. Кликните како бисте је означили.';
$string['clicktolockdiscussion'] = 'Кликните да бисте закључали ову дискусију';
$string['clicktosubscribe'] = 'Нисте претплаћени на ову дискусију. Кликните како бисте се претплатили.';
$string['clicktounfavourite'] = 'Означили сте ову дискусију звездицом. Кликните како бисте уклонили звездицу.';
$string['clicktounlockdiscussion'] = 'Кликните да бисте откључали ову дискусију';
$string['clicktounsubscribe'] = 'Претплаћени сте на ову дискусију. Кликните да се одјавите.';
$string['close'] = 'Затвори';
$string['closegrader'] = 'Затвори уређивачки приказ оцена';
$string['completiondetail:discussions'] = 'Започните дискусије: {$a}';
$string['completiondetail:posts'] = 'Објавите поруке на форуму: {$a}';
$string['completiondetail:replies'] = 'Одговорите на поруку: {$a}';
$string['completiondiscussions'] = 'Полазник мора да креира дискусију:';
$string['completiondiscussionsdesc'] = 'Најмањи број дискусија које полазник мора да креира: {$a}';
$string['completiondiscussionsgroup'] = 'Захтевај дискусије';
$string['completiondiscussionshelp'] = 'неопходно је креирање дискусије за завршетак активности';
$string['completionposts'] = 'Полазник мора да пошаље поруку или одговор:';
$string['completionpostsdesc'] = 'Најмањи број дискусија или одговора које полазник мора да постује: {$a}';
$string['completionpostsgroup'] = 'Захтевај поруке';
$string['completionpostshelp'] = 'неопходно је слање поруке или одговора за завршетак активности';
$string['completionreplies'] = 'Полазник мора да пошаље одговор:';
$string['completionrepliesdesc'] = 'Најмањи број одговора које полазник мора да постује: {$a}';
$string['completionrepliesgroup'] = 'Захтевај одговоре';
$string['completionreplieshelp'] = 'неопходан је одговор на поруку за завршетак активности';
$string['configcleanreadtime'] = 'Време у току дана када се бришу старе поруке из табеле "прочитано".';
$string['configdigestmailtime'] = 'Корисници који изаберу да им се поруке са форума шаљу електронском поштом у скраћеном облику, добијаће једну поруку дневно. Ово подешавање задаје време у току дана када ће наведена порука бити послата (први следећи крон који се покрене након задатог времена ће их послати).';
$string['configdisplaymode'] = 'Подразумевани начин приказивања странице са дискусијама уколико исти није подешен.';
$string['configenablerssfeeds'] = 'Овај прекидач ће омогућити коришћења RSS сервиса за све форуме. Ипак, мораћете ручно да укључите RSS подршку у подешавањима за сваки форум посебно.';
$string['configenabletimedposts'] = 'Изаберите \'да\' ако желите да дозволите подешавање периода приказивања поруке приликом отварања нове дискусије на форуму.';
$string['configlongpost'] = 'Било која порука дужа од ове вредности (изражене у броју знакова, не рачунајући HTML ознаке) сматра се предугом. Поруке приказане на насловној страници сајта, страницама курсева у друштвеном формату, или корисничким профилима скраћују се природно на дужину која се креће између вредности за forum_shortpost и forum_longpost.';
$string['configmanydiscussions'] = 'Максималан број дискусија приказаних на форуму по страници';
$string['configmaxattachments'] = 'Подразумевани максимални број прилога дозвољен по једној поруци.';
$string['configmaxbytes'] = 'Подразумевана максимална величина прилога за све форуме на сајту (зависно од ограничења курсева и осталих локалних подешавања)';
$string['configoldpostdays'] = 'Број дана након којег се све старе поруке сматрају прочитаним.';
$string['configreplytouser'] = 'Када се порука са форума шаље електронском поштом, хоће ли она садржати електронску адресу аутора поруке, тако да прималац поруке може на њу да одговори лично а не преко форума? Чак и када је ова опција подешена на "Да", корисници могу да, у оквиру свог корисничког профила, одаберу да њихова електронска адреса буде сакривена од осталих корисника.';
$string['configrssarticlesdefault'] = 'Ако је RSS сервис омогућен, подешава подразумевани број чланака (било дискусија или постова).';
$string['configrsstypedefault'] = 'Ако су RSS извори вести омогућени, подешава подразумевани тип активности.';
$string['configshortpost'] = 'Свака порука краћа од ове вредности (изражене у броју знакова, не рачунајући HTML ознаке) сматра се кратком (види испод).';
$string['configsubscriptiontype'] = 'Подразумевано подешавање за режим претплате.';
$string['configtrackingtype'] = 'Подразумевано подешавање за праћење прочитаних/непрочитаних порука.';
$string['configtrackreadposts'] = 'Подесите на "Да" ако желите да пратите прочитане/непрочитане поруке за сваког корисника.';
$string['configusermarksread'] = 'Ако је изабрана опција "да" корисник мора ручно да обележи поруку као прочитану, у супротном (опција "не") оног тренутка када је корисник видео поруку она ће бити обележена као прочитана.';
$string['confirmsubscribe'] = 'Да ли стварно желите да се претплатите на форум \'{$a}\'?';
$string['confirmsubscribediscussion'] = 'Да ли стварно желите да се претплатите на дискусију \'{$a->discussion}\' у оквиру форума \'{$a->forum}\'?';
$string['confirmunsubscribe'] = 'Да ли заиста желите да се одјавите са форума \'{$a}\'?';
$string['confirmunsubscribediscussion'] = 'Да ли стварно желите да се одјавите са дискусије \'{$a->discussion}\' у оквиру форума \'{$a->forum}\'?';
$string['couldnotadd'] = 'Нажалост, није могуће додати вашу поруку због непознате грешке';
$string['couldnotdeletereplies'] = 'Жао нам је, ова порука се не може обрисати пошто су други корисници одговорили на њу';
$string['couldnotupdate'] = 'Ваша порука не може бити ажурирана због непознате грешке';
$string['created'] = 'Креирана';
$string['crontask'] = 'Слање поште са форума и редовно одржавање платформе';
$string['cutoffdate'] = 'Дефинитивни рок';
$string['cutoffdate_help'] = 'Ако је подешено, форум неће прихватити поруке након овог датума.';
$string['cutoffdatereached'] = 'Дефинитивни рок за слање порука на овај форум је достигнут тако да више не можете да шаљете поруке.';
$string['cutoffdatevalidation'] = 'Дефинитивни рок не може бити пре крајњег рока за предају рада.';
$string['delete'] = 'Обриши';
$string['deleteddiscussion'] = 'Ова тема је обрисана';
$string['deletedpost'] = 'Порука је обрисана';
$string['deletedposts'] = 'Те поруке су обрисане';
$string['deleteduser'] = 'Обрисан корисник';
$string['deletesure'] = 'Јесте ли сигурни да желите да обришете ову поруку?';
$string['deletesureplural'] = 'Јесте ли сигурни да желите да обришете ову поруку и СВЕ одговоре на њу? ({$a} порука)';
$string['digestmailheader'] = 'Ово је ваш дневни скраћени приказ нових порука са {$a->sitename} форума. Да би сте променили начин на који ће вам бити слате поруке са форума идите на {$a->userprefs}.';
$string['digestmailpost'] = 'Промените своје преференције везане за резиме порука са форума';
$string['digestmailpostlink'] = 'Промените своје преференције везане за резиме порука са форума: {$a}';
$string['digestmailprefs'] = 'Ваш кориснички профил';
$string['digestmailsubject'] = '{$a}: скраћен приказ порука са форума';
$string['digestmailtime'] = 'Време за слање е-поште са скраћеним извештајима';
$string['digestsentusers'] = 'Скраћен приказ порука са форума успешно је послат на електронске адресе {$a} корисника';
$string['disallowsubscribe'] = 'Претплате нису дозвољене';
$string['disallowsubscribeteacher'] = 'Претплате нису дозвољене (осим предавачима)';
$string['disallowsubscription'] = 'Претплата';
$string['disallowsubscription_help'] = 'Овај форум је тако подешен да не можете да се претплатите на дискусије.';
$string['discussion'] = 'Дискусија';
$string['discussionlistsortbycreatedasc'] = 'Сортирајте по датуму креирања растућим редоследом';
$string['discussionlistsortbycreateddesc'] = 'Сортирајте по датуму креирања опадајућим редоследом';
$string['discussionlistsortbydiscussionasc'] = 'Сортирај према називу дискусије растућим редоследом';
$string['discussionlistsortbydiscussiondesc'] = 'Сортирај према називу дискусије опадајућим редоследом';
$string['discussionlistsortbygroupasc'] = 'Сортирај према групи растућим редоследом';
$string['discussionlistsortbygroupdesc'] = 'Сортирај према групи опадајућим редоследом';
$string['discussionlistsortbylastpostasc'] = 'Сортирајте по датуму креирања последње поруке растућим редоследом';
$string['discussionlistsortbylastpostdesc'] = 'Сортирајте по датуму креирања последње поруке опадајућим редоследом';
$string['discussionlistsortbyrepliesasc'] = 'Сортирајте по броју одговора растућим редоследом';
$string['discussionlistsortbyrepliesdesc'] = 'Сортирајте по броју одговора опадајућим редоследом';
$string['discussionlistsortbystarterasc'] = 'Сортирајте према имену полазника који је започео дискусију растућим редоследом';
$string['discussionlistsortbystarterdesc'] = 'Сортирајте према имену полазника који је започео дискусију опадајућим редоследом';
$string['discussionlocked'] = 'Ова дискусија је закључана тако да више не можете одговарати на њој.';
$string['discussionlockingdisabled'] = 'Не закључавај дискусије';
$string['discussionlockingheader'] = 'Закључавање дискусија';
$string['discussionmoved'] = 'Ова дискусија је премештена на \'{$a}\'.';
$string['discussionmovedpost'] = 'Ова дискусија је премештена <a href="{$a->discusshref}">овде</a> у форуму <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Назив дискусије';
$string['discussionnownotsubscribed'] = '{$a->name} НЕЋЕ добијати обавештења о новим порукама на дискусији \'{$a->discussion}\' унутар форума \'{$a->forum}\'';
$string['discussionnowsubscribed'] = 'Бићете обавештавани о новим порукама на дискусији \'{$a->discussion}\' унутар форума \'{$a->forum}\'.';
$string['discussionpin'] = 'Фиксирај';
$string['discussionpinned'] = 'Фиксирана';
$string['discussionpinned_help'] = 'Фиксиране дискусије ће се појавити на врху форума.';
$string['discussions'] = 'Дискусије';
$string['discussionsplit'] = 'Дискусија је раздвојена';
$string['discussionsstartedby'] = 'Дискусију започео/ла {$a}';
$string['discussionsstartedbyrecent'] = 'Дискусије које је корисник {$a} започео у скорије време';
$string['discussionsstartedbyuserincourse'] = 'Дискусија коју је започео/ла {$a->fullname} на курсу {$a->coursename}';
$string['discussionsstartedincourse'] = 'Дискусија је започела на курсу {$a}';
$string['discussionstartedby'] = 'Дискусију је започео/ла {$a}';
$string['discussionsubscribed'] = 'Сада сте претплаћени на ову дискусију.';
$string['discussionsubscribestart'] = 'Шаљи ми обавештења о новим порукама у овој дискусији.';
$string['discussionsubscribestop'] = 'Не желим да добијам обавештења о новим порукама у овој дискусији';
$string['discussionsubscription'] = 'Претплата на дискусију';
$string['discussionsubscription_help'] = 'Претплаћивање на дискусију значи да ћете примити обавештења о новим постовима у тој дискусији.';
$string['discussionunpin'] = 'Уклони фиксирање';
$string['discussionunsubscribed'] = 'Отказали сте претплату на ову дискусију.';
$string['discussthistopic'] = 'Дискусија о овој теми';
$string['discusstopicname'] = 'Дискутујте на тему: {$a}';
$string['displayend'] = 'Крај приказивања';
$string['displayend_help'] = 'Ово подешавање одређује да ли ће порука на форуму бити сакривене након одређеног датума. Напомена: администратори увек могу да виде поруке на форуму.';
$string['displayenddate'] = 'Прикажи датум завршетка: {$a}.';
$string['displaymode'] = 'Начин приказивања';
$string['displayperiod'] = 'Период приказивања';
$string['displaystart'] = 'Почетак приказивања';
$string['displaystart_help'] = 'Ово подешавање одређује да ли ће порука на форуму бити приказана од одређеног датума. Напомена: администратори увек могу да виде поруке на форуму.';
$string['displaystartdate'] = 'Прикажи датум почетка: {$a}.';
$string['displaywordcount'] = 'Прикажи број речи';
$string['displaywordcount_help'] = 'Ово подешавање одређује да ли треба приказати број речи сваке поруке.';
$string['duedate'] = 'Крајњи рок';
$string['duedate_help'] = 'Овај датум представља крајњи рок за слање порука на форум. Иако се овај датум приказује у календару као крајњи рок за слање порука на форум, поруке ће моћи да се шаљу и након овог датума. Да бисте у спречили слање порука на форум након одређеног датума подесите дефинитивни рок за слање порука.';
$string['duedatetodisplayincalendar'] = 'Крајњи рок за приказ у календару';
$string['eachuserforum'] = 'Свака особа може започети једну дискусију';
$string['edit'] = 'Уреди';
$string['editdiscussion'] = 'Уреди дискусију';
$string['editdiscussiontopic'] = 'Уреди тему дискусије';
$string['editedby'] = 'Уредио/ла  {$a->name} - изворно објављено {$a->date}';
$string['editedpostupdated'] = 'Порука коју је постовао/ла {$a} је ажурирана';
$string['editing'] = 'Уређивање';
$string['emaildigestcompleteshort'] = 'Комплетне поруке';
$string['emaildigestdefault'] = 'Подразумевано ({$a})';
$string['emaildigestoffshort'] = 'Без резимеа';
$string['emaildigestsubjectsshort'] = 'Само наслови';
$string['emaildigesttype'] = 'Опције везане за резиме који се шаље електронском поштом';
$string['emaildigesttype_help'] = 'Тип обавештења који ћете добијати са сваког форума.

* Подразумевани - пратиће се преференције постављене у вашем корисничком профилу. Ако ажурирате свој профил промене ће се одразити и на ово подешавање;
* Без резимеа - добијаћете једну електронску поруку по објави на форуму;
* Резиме - комплетне објаве - добијаћете једну електронску поруку на дан која ће садржати комплетан садржај свих објава на форуму;
* Резиме - само теме - добијаћете једну електронску поруку на дан која ће садржати само теме свих објава на форуму.';
$string['emptymessage'] = 'Нешто није у реду са вашом поруком. Можда сте оставили празна поља, или је прилог био превелик. Ваше промене НИСУ сачуване.';
$string['errorcannotlock'] = 'Немате овлашћења за закључавање дискусија.';
$string['errordiscussionnotfound'] = 'Дискусија није пронађена';
$string['erroremptymessage'] = 'Тело поруке не може бити празно';
$string['erroremptysubject'] = 'Тема (наслов) поруке не може бити празна';
$string['errorenrolmentrequired'] = 'Да бисте приступили овом садржају морате бити уписани на овај курс';
$string['errorforumnotfound'] = 'Форум коме припада ова дискусија није пронађен';
$string['errorwhiledelete'] = 'Дошло је до грешке у току брисања записа';
$string['eventassessableuploaded'] = 'Објављен је неки садржај.';
$string['eventcoursesearched'] = 'Курс претражен';
$string['eventdiscussioncreated'] = 'Дискусија креирана';
$string['eventdiscussiondeleted'] = 'Дискусија обрисана';
$string['eventdiscussionmoved'] = 'Дискусија премештена';
$string['eventdiscussionpinned'] = 'Дискусија је фиксирана';
$string['eventdiscussionsubscriptioncreated'] = 'Претплата на дискусију креирана';
$string['eventdiscussionsubscriptiondeleted'] = 'Претплата на дискусију обрисана';
$string['eventdiscussionunpinned'] = 'Дискусији је уклоњено фиксирање';
$string['eventdiscussionupdated'] = 'Дискусија ажурирана';
$string['eventdiscussionviewed'] = 'Дисусија приказана';
$string['eventpostcreated'] = 'Порука креирана';
$string['eventpostdeleted'] = 'Порука на форуму обрисана';
$string['eventpostupdated'] = 'Порука ажурирана';
$string['eventreadtrackingdisabled'] = 'Праћење прочитаних/непрочитаних порука онемогућено';
$string['eventreadtrackingenabled'] = 'Праћење прочитаних/непрочитаних порука омогућено';
$string['eventsubscribersviewed'] = 'Претплатници форума приказани';
$string['eventsubscriptioncreated'] = 'Претплата креирана';
$string['eventsubscriptiondeleted'] = 'Претплата обрисана';
$string['eventuserreportviewed'] = 'Извештај о кориснику приказан';
$string['everyonecanchoose'] = 'Свако може изабрати да буде претплаћен';
$string['everyonecannowchoose'] = 'Свако може сада да изабере да ли ће бити претплаћен на овај форум ';
$string['everyoneisnowsubscribed'] = 'Сви су сада претплаћени на овај форум';
$string['everyoneissubscribed'] = 'Сви су претплаћени на овај форум';
$string['existingsubscribers'] = 'Постојећи претплатници';
$string['export'] = 'Извези';
$string['exportattachmentname'] = 'Извезите прилог {$a} у портфолио';
$string['exportdiscussion'] = 'Извези целу дискусију у портфолио';
$string['exporthumandates'] = 'Датуми у читљивом формату';
$string['exporthumandates_help'] = 'Да ли датуме треба експортовати у читљивом формату или као временску ознаку (низ бројева).';
$string['exportoptions'] = 'Опције за извоз';
$string['exportstriphtml'] = 'Уклони HTML';
$string['exportstriphtml_help'] = 'Да ли HTML ознаке попут "<p>" и "<br>" треба уклонити из поруке на форуму.';
$string['favourites'] = 'Означено звездицом';
$string['favouriteupdated'] = 'Ваша опција за означавање звездицом је ажурирана.';
$string['firstpost'] = 'Прва порука';
$string['forcedreadtracking'] = 'Дозволи обавезно праћење прочитаних/непрочитаних порука';
$string['forcedreadtracking_desc'] = 'Ова опција дозвољава да форуми буду подешени тако да се обавезно прате прочитане/непрочитане поруке. Ово ће довести до смањења перформанси система за неке кориснике, нарочито на курсевима са великим бројем форума и порука. Када се искључи, сви форуми, претходно подешени на "обавезно", биће пребачени на опционо праћење прочитаних/непрочитаних порука.';
$string['forcesubscribed'] = 'Претплата на овај форум је обавезно за све';
$string['forcesubscribed_help'] = 'Овај форум је тако подешен да не можете да се одјавите са дискусија.';
$string['forum'] = 'Форум';
$string['forum:addinstance'] = 'Додај нови форум';
$string['forum:addnews'] = 'Додај обавештења';
$string['forum:addquestion'] = 'Додај питање';
$string['forum:allowforcesubscribe'] = 'Дозвољава принудну претплату на форум';
$string['forum:canoverridecutoff'] = 'Слање порука на форум након дефинитивног рока';
$string['forum:canoverridediscussionlock'] = 'Одговарање на закључаним дискусијама';
$string['forum:canposttomygroups'] = 'Слање порука свим групама којима имате приступ';
$string['forum:cantogglefavourite'] = 'Означавање дискусија звездицом';
$string['forum:createattachment'] = 'Креирај прилоге';
$string['forum:deleteanypost'] = 'Обриши све поруке (у било које време)';
$string['forum:deleteownpost'] = 'Обриши своје поруке (у задатом року)';
$string['forum:editanypost'] = 'Уреди било коју поруку';
$string['forum:exportdiscussion'] = 'Извези комплетну дискусију';
$string['forum:exportforum'] = 'Извези форум';
$string['forum:exportownpost'] = 'Извези своју поруку';
$string['forum:exportpost'] = 'Извези поруку';
$string['forum:grade'] = 'Оцени форум';
$string['forum:managesubscriptions'] = 'Управљање претплатницима';
$string['forum:movediscussions'] = 'Премести дискусије';
$string['forum:pindiscussions'] = 'Фиксирај дискусије';
$string['forum:postprivatereply'] = 'Одговорите приватно на поруке';
$string['forum:postwithoutthrottling'] = 'Изузет од ограничења броја порука';
$string['forum:rate'] = 'Оцени поруке';
$string['forum:readprivatereplies'] = 'Приказ приватних порука';
$string['forum:replynews'] = 'Одговори на обавештења';
$string['forum:replypost'] = 'Одговори на поруке';
$string['forum:splitdiscussions'] = 'Подели дискусије';
$string['forum:startdiscussion'] = 'Започни нове дискусије';
$string['forum:viewallratings'] = 'Погледај све необрађене оцене које су дали појединци';
$string['forum:viewanyrating'] = 'Погледај све оцене које је добио било ко';
$string['forum:viewdiscussion'] = 'Преглед дискусија';
$string['forum:viewhiddentimedposts'] = 'Погледај скривене, временски ограничене поруке';
$string['forum:viewqandawithoutposting'] = 'Увек види поруке на форуму "Питања и одговори"';
$string['forum:viewrating'] = 'Погледајте све оцене које сте добили';
$string['forum:viewsubscribers'] = 'Преглед претплатника';
$string['forumauthorhidden'] = 'Аутор (скривено)';
$string['forumblockingalmosttoomanyposts'] = 'Приближавате се максималном могућем броју порука на овом форуму. Објавили сте {$a->numposts} порука у последњих {$a->blockperiod} а лимит је {$a->blockafter} порука.';
$string['forumbodydeleted'] = 'Садржај ове поруке на форуму је уклоњен и више му се не може приступити.';
$string['forumbodyhidden'] = 'Ова порука је тренутно сакривена, највероватније зато што прво морате да постујете своју поруку унутар дискусије, а обавештења о порукама на форуму морају бити послата. Друга могућност је да тренутно време није у оквиру временског периода приказивања, које је подешено за поруку.';
$string['forumgrader'] = 'Оцењивач форума';
$string['forumgradingnavigation'] = 'Навигација за оцењивање дискусија';
$string['forumgradingpanel'] = 'Панел за оцењивање форума';
$string['forumintro'] = 'Опис';
$string['forumname'] = 'Назив форума';
$string['forumposts'] = 'Поруке на форуму';
$string['forums'] = 'Форуми';
$string['forumsubjectdeleted'] = 'Ова порука на форуму је уклоњена';
$string['forumsubjecthidden'] = 'Тема (скривено)';
$string['forumtracked'] = 'Непрочитане поруке се прате';
$string['forumtrackednot'] = 'Непрочитане поруке се не прате';
$string['forumtype'] = 'Тип форума';
$string['forumtype_help'] = 'Постоји 5 типова форума:

* Једна обична дискусија - форум у облику само једне теме о којој сви могу дискутовати и слати своје одговоре (не може се користити са одвојеним групама)
* Сваки учесник покреће једну дискусију - сваки полазник може покренути само једну нову тему за дискусију, на коју сви могу да одговарају
* Форум питања и одговора - полазник мора прво да пошаље свој одговор на питање које је поставио предавач, пре него што види одговоре других
* Стандарни форум у облику блога - отворени форум у којем свако у било ком тренутку може започети нову дискусију, и у ком су теме за дискусију приказане на једној страници са линком "Дискутуј о овој теми"
* Стандардни форум за општу употребу - отворени форум у којем свако може започети нову дискусију у било ком тренутку';
$string['generalforum'] = 'Стандардни форум за општу употребу';
$string['generalforums'] = 'Општи форуми';
$string['grade_forum_header'] = 'Оцењивање целог форума';
$string['grade_forum_name'] = 'Оцена за цео форум';
$string['grade_forum_title'] = 'Оцена';
$string['grade_rating_name'] = 'Оцена за појединачне поруке';
$string['graded'] = 'Ocenjeno';
$string['gradedby'] = 'Оценио/ла';
$string['gradeforrating'] = 'Оцена за процену: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Оцена процене је сакривена';
$string['gradeforwholeforum'] = 'Оцена за форум: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Оцена за форум скривена';
$string['gradeitem:forum'] = 'Форум';
$string['gradeitemnameforrating'] = 'Процена за {$a->name}';
$string['gradeitemnameforwholeforum'] = '{$a->name} цео форум';
$string['grades:gradesavedfor'] = 'Оцена је сачувана за {$a->fullname}';
$string['grades:gradesavefailed'] = 'Није могуће сачувати оцену за {$a->fullname}: {$a->error}';
$string['gradeusers'] = 'Оцени кориснике';
$string['grading'] = 'Оцењивање';
$string['gradingstatus'] = 'Статус оцене:';
$string['hiddenforumpost'] = 'Сакривена порука на форуму';
$string['hidegraderpanel'] = 'Сакриј панел за оцењивање';
$string['hidepreviousrepliescount'] = 'Сакриј претходне одговоре ({$a})';
$string['hideusersearch'] = 'Сакриј претрагу корисника';
$string['indexoutoftotal'] = '{$a->index} од укупно {$a->total}';
$string['indicator:cognitivedepth'] = 'Форум - когнитивни аспект';
$string['indicator:cognitivedepth_help'] = 'Овај индикатор се заснива на когнитивној дубини коју је полазник постигао у оквиру активности \'Форум\'.';
$string['indicator:cognitivedepthdef'] = 'Форум - когнитивни аспект';
$string['indicator:cognitivedepthdef_help'] = 'Учесник је постигао овај проценат когнитивног ангажмана који нуде активности Форум током овог интервала анализе (Нивои = Без прегледа, Преглед, Слање постова, Преглед повратних информација, Коментар на повратне информације, Понова слање постова након прегледа повратних информација)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Форум - социјални аспект';
$string['indicator:socialbreadth_help'] = 'Овај индикатор се заснива на обиму социјалних интеракција који је полазник постигао у оквиру активности \'Форум\'.';
$string['indicator:socialbreadthdef'] = 'Форум - социјални аспект';
$string['indicator:socialbreadthdef_help'] = 'Учесник је постигао овај проценат социјалног ангажмана који нуде активности Форум током овог интервала анализе (Нивои = Без учешћа, Учесник сâм, Учесник са другима)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = 'у {$a}';
$string['inreplyto'] = 'У одговору на {$a}';
$string['introblog'] = 'Поруке у овом форуму су аутоматски овде копиране из блога корисника на овом курсу зато што ти чланци блога нису више доступни';
$string['intronews'] = 'Опште новости и обавештења';
$string['introsocial'] = 'Отворени форум за разговор о било којој теми';
$string['introteacher'] = 'Форум резервисан за белешке и дускусије предавача';
$string['invalidaccess'] = 'Овој страни није исправно приступљено';
$string['invaliddigestsetting'] = 'Подешавање резимеа објава које се шаљу електронском поштом које је дато није валидно';
$string['invaliddiscussionid'] = 'Идентификатор дискусије није био исправан или више не постоји';
$string['invalidforcesubscribe'] = 'Неисправан начин обавезне претплате';
$string['invalidforumid'] = 'ID форума није био тачан';
$string['invalidparentpostid'] = 'ID ознака надређене поруке је неисправна';
$string['invalidpostid'] = 'Неисправан ID поруке - {$a}';
$string['lastpost'] = 'Последња порука';
$string['learningforums'] = 'Форуми за учење';
$string['lockdiscussion'] = 'Закључај ову дискусију';
$string['lockdiscussionafter'] = 'Закључај дискусије након периода неактивности';
$string['lockdiscussionafter_help'] = 'Дискусије могу бити аутоматски закључане након што прође специфицирано време од последњег одговора на њима.

Корисници са способношћу да дају одговоре на закључаним дискусијама могу откључати било коју дискусију једним својим одговором на њој.';
$string['locked'] = 'Закључано';
$string['lockupdated'] = 'Опција за закључавања је ажурирана.';
$string['longpost'] = 'Дугачкa порука';
$string['mailnow'] = 'Пошаљи обавештење о поруци на форуму одмах, не чекајући време дозвољено за уређивање поруке';
$string['managesubscriptionsoff'] = 'Заврши управљање претплатама';
$string['managesubscriptionson'] = 'Управљање претплатницима';
$string['manydiscussions'] = 'Број дискусија по страници';
$string['markalldread'] = 'Означи све поруке ове дискусије као прочитане.';
$string['markallread'] = 'Означи све поруке на овом форуму као прочитане.';
$string['markasread'] = 'Означи као прочитано';
$string['markasreadonnotification'] = 'При слању обавештења са објавама са форума';
$string['markasreadonnotification_help'] = 'Када сте обавештени о објави на форуму, можете одабрати да ли ће то означити објаву прочитаном у сврху праћења форума.';
$string['markasreadonnotificationno'] = 'Немој означити објаву прочитаном';
$string['markasreadonnotificationyes'] = 'Означи објаву прочитаном';
$string['markread'] = 'Означи као прочитано';
$string['markreadbutton'] = 'Означи као<br /> прочитано';
$string['markunread'] = 'Означи као непрочитано';
$string['markunreadbutton'] = 'Означи као<br /> непрочитано';
$string['maxattachments'] = 'Максималан број прилога';
$string['maxattachments_help'] = 'Ово подешавање одређује максималан број датотека које могу бити приложене уз поруку.';
$string['maxattachmentsize'] = 'Максимална величина прилога';
$string['maxattachmentsize_help'] = 'Ово подешавање одређује максималну величину датотеке која може бити приложена уз поруку.';
$string['maxtimehaspassed'] = 'Нажалост, максимално време за уређивање ове поруке ({$a}) је истекло!';
$string['message'] = 'Порука';
$string['messageinboundattachmentdisallowed'] = 'Није могуће послати ваш одговор, зато што садржи прилог, а форум не дозвољава прилоге.';
$string['messageinboundfilecountexceeded'] = 'Није могуће послати ваш одговор, зато што садржи више од максималног броја прилога који форум дозвољава ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Није могуће послати ваш одговор, зато што је укупна величина прилога ({$a->filesize}) већа од максималне величине коју форум дозвољава ({$a->maxbytes})..';
$string['messageinboundforumhidden'] = 'Није могуће послати ваш одговор, зато што је форум тренутно недоступан.';
$string['messageinboundnopostforum'] = 'Није могуће послати ваш одговор, зато што немате овлашћења да постујете поруке на форуму {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'Није могуће послати ваш одговор. Премашили сте дозвољени број порука  за овај форум.';
$string['messageprovider:digests'] = 'Изводи порука са форума са претплатом';
$string['messageprovider:posts'] = 'Поруке са форума са претплатом';
$string['missingsearchterms'] = 'Следећи тражени термини се јављају искључиво унутар HTML ознака ове поруке:';
$string['modeflatnewestfirst'] = 'Прикажи одговоре, почевши с најновијим';
$string['modeflatoldestfirst'] = 'Прикажи одговоре, почевши с најстаријим';
$string['modenested'] = 'Прикажи одговоре у угнежђеној форми';
$string['modenestedv2'] = 'Прикажи одговоре у експерименталном угнежђеном облику';
$string['modethreaded'] = 'Прикажи одговоре у низу';
$string['modulename'] = 'Форум';
$string['modulename_help'] = 'Модул активности \'Форум\' омогућава учесницима да воде асинхроне дискусије тј, да дискутују на различите теме у дужем временском периоду.

Постоји неколико типова форума који се могу изабрати, као што су стандардни форуму где свако може да започне нову дискусију у било ком тренутку; форум где сваки полазник може да покрене само једну дискусију, или форум \'Питање и одговор\' где полазници морају прво да постују свој одговор пре него што буде у могућности да виде одговоре других полазника. Предавач може да дозволи полазницима да уз своје поруке на форумима прилажу датотеке. Приложене слике се приказују унутар саме поруке.

Учесници могу да се претплате (пријаве) на форум како би редовно примали обавештења о новим порукама. Предавач може да подеси режим претплате на опциони, обавезни или аутоматски, или да потпуно спречи могућност претплате на форум. Ако је потребно, могуће је, такође, спречити да полазници шаљу више од одређеног броја порука, у датом временском периоду; на овај начин може се спречити да појединци доминирају дискусијама.

Поруке на форумима могу бити оцењиване како од стране предавача, тако и од стране полазника (вршњачка евалуација). Оцене могу да се сабирају како би се формирала финална оцена која се бележи у књигу оцена.

Форуми могу да се користе на врло различите начине, као на пример:

* друштвени простор за међусобно упознавање и дружење полазника
* за објављивање важних обавештења на курсу (користећи форум \'Вести\' на који су, стандардно, сви полазници претплаћени)
* за дискутовање о садржају односно темама које курс покрива
* за наставак дискусије у онлајн окружењу, о темама које се претходно започете у учионици
* за дискусије намењене само предавачима (користећи опцију за сакривање форума од полазника)
* као центар за помоћ, где полазници могу да добију помоћ и савет од стране предавача и искуснијих полазника
* за додатне активности, на пример \'мозгалице\' за полазнике o којима они треба да размисле и понуде решења';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Форуми';
$string['more'] = 'још';
$string['movedmarker'] = '(Премештено)';
$string['movethisdiscussionlabel'] = 'Преместите тренутну дискусију у наведени форум';
$string['movethisdiscussionto'] = 'Премести ову дискусију у ...';
$string['mustprovidediscussionorpost'] = 'Морате навести ID ознаку дискусије или поруке да бисте их извезли';
$string['myprofileotherdis'] = 'Дискусије на форуму';
$string['myprofileowndis'] = 'Моје дискусије на форуму';
$string['myprofileownpost'] = 'Моје објаве на форуму';
$string['namenews'] = 'Обавештења';
$string['namenews_help'] = 'Форум \'Обавештења\' је специјални форум за обавештења који се аутоматски креира када се отвара нови курс. Курс можете имати само један овакав форум на који обавештења могу да постављају само предавачи и администратори. Блок "Најновија обавештења" ће приказивати најновија обавештења.';
$string['namesocial'] = 'Друштвени форум';
$string['nameteacher'] = 'Форум предавача';
$string['newforumposts'] = 'Нове поруке на форуму';
$string['nextdiscussiona'] = 'Следећа дискусија: {$a}';
$string['nextuser'] = 'Сачувај промене и настави са следећим корисником';
$string['noattachments'] = 'Ова порука нема прилога';
$string['nodiscussions'] = 'Још нема тема за дискусију на овом форуму';
$string['nodiscussionsstartedby'] = '{$a} није започео/ла ниједну дискусију';
$string['nodiscussionsstartedbyyou'] = 'Још нисте започели ниједну диксусију';
$string['noguestpost'] = 'Само пријављени корисници могу слати поруке на овом форуму.';
$string['noguestpost:title'] = 'Пријавите се да бисте наставили';
$string['noguestsubscribe'] = 'Нажалост, гостима није дозвољено да се претплате на форуме.';
$string['noguesttracking'] = 'Нажалост, гостима није дозвољено да подешавају опције за праћење порука.';
$string['nomorepostscontaining'] = 'Нема више порука које садрже \'{$a}\'';
$string['nonews'] = 'Није објављено још ниједно обавештење.';
$string['noonecansubscribenow'] = 'Претплате тренутно нису дозвољене';
$string['nopermissiontosubscribe'] = 'Немате дозволу да видите ко се претплатио на форум';
$string['nopermissiontoview'] = 'Немате дозволу да видите ову поруку';
$string['nopostforum'] = 'Опростите, али није вам дозвољено слање порука на овај форум';
$string['noposts'] = 'Нема порука';
$string['nopostsmadebyuser'] = '{$a} није послао/ла ниједну поруку';
$string['nopostsmadebyyou'] = 'Нисте написали ниједну поруку';
$string['noquestions'] = 'Још нема питања на овом форуму';
$string['nosubscribers'] = 'Још увек нема претплатника за овај форум';
$string['notexists'] = 'Дискусија више не постоји';
$string['notgraded'] = 'Није оцењено';
$string['nothingnew'] = 'Ништа ново за {$a}';
$string['notingroup'] = 'Нажалост, морате бити део групе да бисте видели овај форум.';
$string['notinstalled'] = 'Модул Форум није инсталиран';
$string['notlocked'] = 'Закључај';
$string['notpartofdiscussion'] = 'Ова порука није део дискусије';
$string['notrackforum'] = 'Не прати непрочитане поруке';
$string['notsubscribed'] = 'Претплати се';
$string['nousersmatch'] = 'Није пронађен ниједан корисник за задате критеријуме';
$string['noviewdiscussionspermission'] = 'Немате дозволу да видите дискусије на овом форуму';
$string['nowallsubscribed'] = 'Сада сте претплаћени на све форуме на {$a}.';
$string['nowallunsubscribed'] = 'Сада сте одјављени са свих форума на {$a}.';
$string['nowgradinguser'] = 'Сада се оцењује {$a}';
$string['nownotsubscribed'] = '{$a->name} НЕЋЕ бити обавештаван о новим порукама на форуму \'{$a->forum}\'.';
$string['nownottracking'] = '{$a->name} више не прати поруке на форуму \'{$a->forum}\'.';
$string['nowsubscribed'] = 'Бићете обавештавани о о новим порукама на форуму \'{$a->forum}\'.';
$string['nowtracking'] = '{$a->name} прати поруке на форуму \'{$a->forum}\'.';
$string['numberofreplies'] = 'Број одговора: {$a}';
$string['numposts'] = 'Број порука: {$a}';
$string['olderdiscussions'] = 'Старије дискусије';
$string['oldertopics'] = 'Старије теме';
$string['oldpostdays'] = 'Број дана након којих се старе поруке сматрају прочитаним';
$string['page-mod-forum-discuss'] = 'Страница са дискусијом модула \'Форум\'';
$string['page-mod-forum-view'] = 'Главна страница форума';
$string['page-mod-forum-x'] = 'Било која страница форума';
$string['parent'] = 'Прикажи надређену поруку';
$string['parentofthispost'] = 'Порука надређена овој поруци';
$string['permalink'] = 'Перманентни линк';
$string['permanentlinktoparentpost'] = 'Перманентни линк на надређену поруку';
$string['permanentlinktopost'] = 'Перманентни линк на овај пост';
$string['pindiscussion'] = 'Фиксирај ову дискусију';
$string['pinupdated'] = 'Опција за фиксирање је ажурирана.';
$string['pluginadministration'] = 'Администрација форума';
$string['pluginname'] = 'Форум';
$string['postadded'] = '<p>Ваша порука је успешно додата.</p> <p>Имате {$a} за промену садржаја исте, уколико то желите.</p>';
$string['postaddedsuccess'] = 'Ваша порука је успешно додата.';
$string['postaddedtimeleft'] = 'Имате {$a} минута да уредите поруку ако желите да направите било какве измене.';
$string['postbymailsuccess'] = 'Ваш одговор на тему "{$a->subject}" успешно је постован: {$a->discussionurl}.';
$string['postbymailsuccess_html'] = 'Ваш одговор на дискусију <a href="{$a->discussionurl}">{$a->subject}</a> успешно је постован.';
$string['postbyuser'] = '{$a->post} написао/ла {$a->user}';
$string['postincontext'] = 'Погледај поруку у контексту';
$string['postisprivatereply'] = 'Ово је приватни одговор (предавачи и други корисници који имају одговарајући способност могу такође да виде приватне одговоре).';
$string['postmailinfo'] = 'Ово је копија поруке објављене на форуму на веб сајту {$a}.';
$string['postmailinfolink'] = 'Ово је копија поруке са форума на курсу {$a->coursename}.

Да бисте одговорили поруку кликните на овај линк: {$a->replylink}';
$string['postmailnow'] = '<p>Ова порука ће бити одмах послата свима који су претплаћени на овај форум.</p>';
$string['postmailreply'] = 'Да одговорите, кликните на овај линк: {$a}';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Углавном одвојено знање';
$string['postrating2'] = 'Одвојено и повезано';
$string['postrating3'] = 'Углавном повезано знање';
$string['posts'] = 'Поруке';
$string['postsfrom'] = 'Поруке од';
$string['postsmadebyuser'] = 'Порука коју је послао/ла {$a}';
$string['postsmadebyuserincourse'] = 'Порука коју је послао/ла {$a->fullname} на курсу {$a->coursename}';
$string['postsmadeincourse'] = 'Поруке објављене на курсу {$a}';
$string['poststo'] = 'Пошаљи поруку на';
$string['posttoforum'] = 'Пошаљи поруку на форум';
$string['posttomygroups'] = 'Објави копију свим групама';
$string['posttomygroups_help'] = 'Објављује копију ове поруке свим групама којима имате приступ. Учесници у групама којима немате приступ неће видети ову поруку.';
$string['postupdated'] = 'Ваша порука је ажурирана';
$string['potentialsubscribers'] = 'Потенцијални претплатници';
$string['prevdiscussiona'] = 'Претходна дискусија: {$a}';
$string['previoususer'] = 'Сачувајте промене и наставите са претходним корисником';
$string['privacy:digesttypenone'] = 'Не чувамо никакве податке који се тичу преферираног типа сажетка порука за овај форум.';
$string['privacy:digesttypepreference'] = 'Изабрали сте да примате следећи тип сажетка порука са форума: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Изабрали сте следеће параметре за претплату на дискусије за овај форум: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Форум користи подсистем за оцењивање како би подржао оцењивање постова.';
$string['privacy:metadata:core_tag'] = 'Форум користи подсистем за ознаке како би подржао означавање постова.';
$string['privacy:metadata:forum_digests'] = 'Форум користи подсистем за ознаке како би подржао означавање постова.';
$string['privacy:metadata:forum_digests:forum'] = 'Форум на који се корисник претплатио.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Параметри за сажетак порука.';
$string['privacy:metadata:forum_digests:userid'] = 'ID ознака корисника са параметрима за скраћени приказ порука.';
$string['privacy:metadata:forum_discussion_subs'] = 'Информације о претплатама на појединачне дискусије на форуму';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'ID ознака дискусије на коју постоји претплата.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Време почетка претплате.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'ID ознака корисника са претплатом на дискусију.';
$string['privacy:metadata:forum_discussions'] = 'Информације о појединачним дискусијама на форуму које је корисник креирао';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - шта ово поље чува';
$string['privacy:metadata:forum_discussions:name'] = 'Назив дискусије, по избору аутора.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Време када је дискусија последњи пут измењена.';
$string['privacy:metadata:forum_discussions:userid'] = 'ID ознака корисника који је креирао дискусију';
$string['privacy:metadata:forum_discussions:usermodified'] = 'ID ознака корисника који је на неки начин последњи изменио дискусију.';
$string['privacy:metadata:forum_grades'] = 'Подаци о оцени за форум';
$string['privacy:metadata:forum_grades:forum'] = 'Форум који је оцењен';
$string['privacy:metadata:forum_grades:grade'] = 'Додељена оцена';
$string['privacy:metadata:forum_grades:userid'] = 'Корисник који је оцењен';
$string['privacy:metadata:forum_posts'] = 'Информације о параметрима за резиме порука за сваки форум.';
$string['privacy:metadata:forum_posts:created'] = 'Време када је пост креиран.';
$string['privacy:metadata:forum_posts:discussion'] = 'Дискусија у којој је пост.';
$string['privacy:metadata:forum_posts:message'] = 'Порука поста на форуму.';
$string['privacy:metadata:forum_posts:modified'] = 'Време када је пост последњи пут измењен.';
$string['privacy:metadata:forum_posts:parent'] = 'Надређени пост на који је послат одговор.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'ID  ознака корисника којем је послат овај одговор.';
$string['privacy:metadata:forum_posts:subject'] = 'Тема поста на форуму.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Порука поста на форуму.';
$string['privacy:metadata:forum_posts:userid'] = 'ID ознака корисника који је аутор поста на форуму.';
$string['privacy:metadata:forum_queue'] = 'Привремени запис порука са форума који ће бити послати у сажетом облику';
$string['privacy:metadata:forum_queue:discussionid'] = 'ID ознака дискусије на форуму';
$string['privacy:metadata:forum_queue:postid'] = 'ID ознака поста на форуму';
$string['privacy:metadata:forum_queue:timemodified'] = 'Време измене оригиналне објаве';
$string['privacy:metadata:forum_queue:userid'] = 'Корисник ког је потребно обавестити о објави';
$string['privacy:metadata:forum_read'] = 'Информације о томе које објаве је корисник прочитао.';
$string['privacy:metadata:forum_read:discussionid'] = 'Дискусија у којој је објава.';
$string['privacy:metadata:forum_read:firstread'] = 'Време када је објава први пут прочитана.';
$string['privacy:metadata:forum_read:lastread'] = 'Најскорије време када је објава прочитана.';
$string['privacy:metadata:forum_read:postid'] = 'Објава је прочитана.';
$string['privacy:metadata:forum_read:userid'] = 'Идентификатор корисника на ког се односи овај запис.';
$string['privacy:metadata:forum_subscriptions'] = 'Информације о томе на које форуме је корисник претплаћен.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Форум на који је корисник претплаћен.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'Идентификатор корисника на ког се односи претплата на овај форум.';
$string['privacy:metadata:forum_track_prefs'] = 'Информације о томе на којим форумима је корисник одабрао да прати прочитаност порука.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Форум на ком је омогућено праћење прочитаности порука.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'Идентификатор корисника на ког се односи преференција о праћењу овог форума.';
$string['privacy:metadata:preference:autosubscribe'] = 'Да ли да се уради претплата на дискусије када се одговара на објаве унутар њих.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'Жељени редослед сортирања списка дискусија';
$string['privacy:metadata:preference:maildigest'] = 'Параметри за слање скраћеног приказа порука е-поштом на нивоу сајта';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Да ли да се објаве на форуму означе прочитаним када се примају њихове копије електронском поштом.';
$string['privacy:metadata:preference:trackforums'] = 'Да ли да се омогући праћење прочитаности.';
$string['privacy:postwasread'] = 'Ова објава је први пут прочитана дана {$a->firstread} а последњи пут дана {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Изабрали сте да не пратите поруке које сте прочитали у овом форуму.';
$string['privacy:request:delete:discussion:name'] = 'Брисање на захтев аутора';
$string['privacy:request:delete:post:message'] = 'Садржај ове објаве је обрисан на захтев његовог аутора.';
$string['privacy:request:delete:post:subject'] = 'Обриши на захтев аутора';
$string['privacy:subscribedtoforum'] = 'Претплаћени сте на овај форум.';
$string['privatereply'] = 'Одговори приватно';
$string['privatereply_help'] = 'Када одговарате приватно, ваша порука такође је видљива корисницима који имају способност да виде приватне одговоре, као што су предавачи.';
$string['processingdigest'] = 'Слање извода путем е-поште кориснику {$a}';
$string['processingpost'] = 'Обрађује се порука {$a}';
$string['prune'] = 'Раздвој';
$string['prunediscussion'] = 'Раздвојите дискусију';
$string['prunedpost'] = 'Од ове поруке креирана је нова дискусија';
$string['pruneheading'] = 'Раздвој дискусију и премести ову поруку у нову дискусију';
$string['qandaforum'] = 'Форум питања и одговора';
$string['qandanotify'] = 'Ово је форум питања и одговора. Да бисте видели одговоре других, морате прво послати свој одговор';
$string['re'] = 'Одговор:';
$string['readtherest'] = 'Прочитајте остатак ове теме';
$string['removeallforumtags'] = 'Уклони све ознаке форума';
$string['removefromfavourites'] = 'Уклоните звездицу са ове дискусије';
$string['replies'] = 'Одговори';
$string['repliesmany'] = '{$a} одговора до сада';
$string['repliesone'] = '{$a} одговор до сада';
$string['reply'] = 'Одговори';
$string['reply_handler'] = 'Одговори на поруке са форума путем е-поште.';
$string['reply_handler_name'] = 'Одговори на поруке са форума';
$string['replyauthorself'] = '{$a} (ви)';
$string['replyforum'] = 'Одговори на форуму';
$string['replyingtoauthor'] = 'Одговарање на {$a}...';
$string['replyplaceholder'] = 'Напишите одговор ...';
$string['replypostdiscussion'] = 'Одговорите на дискусију';
$string['replytopostbyemail'] = 'Можете одговорити на ову поруку електронском поштом.';
$string['replytouser'] = 'Користи адресу е-поште у одговору';
$string['resetdigests'] = 'Обриши све преференције корисника везане за резиме порука са форума';
$string['resetforums'] = 'Обриши поруке са';
$string['resetforumsall'] = 'Обриши све поруке';
$string['resetsubscriptions'] = 'Обриши све претплате на форум';
$string['resettrackprefs'] = 'Обриши сва подешавања за праћење форума';
$string['rssarticles'] = 'Број скорашњих RSS чланака';
$string['rssarticles_help'] = 'Ово подешавање одређује број чланака (дискусија или порука) који ће бити укључени у RSS извор вести. За већину форума је прихватљиво да то буде између 5 и 20 чланака.';
$string['rsssubscriberssdiscussions'] = 'RSS извор дискусија';
$string['rsssubscriberssposts'] = 'RSS извор порука';
$string['rsstype'] = 'RSS извор за ову активност';
$string['rsstype_help'] = 'Да бисте укључили RSS извор вести за ову активност одаберите дискусије или поруке које ће бити укључен у овај извор.';
$string['rsstypedefault'] = 'Тип RSS извора вести';
$string['search'] = 'Претраживање';
$string['search:activity'] = 'Форум - информације о активности';
$string['search:post'] = 'Форум - постови';
$string['searchdatefrom'] = 'Поруке морају бити свежије од';
$string['searchdateto'] = 'Поруке морају бити старије од';
$string['searchforumintro'] = 'Молимо да унесете термине претраживања у једно или више од следећих поља:';
$string['searchforums'] = 'Претражи форуме';
$string['searchfullwords'] = 'Ове речи треба да се појаве као целе речи';
$string['searchnotwords'] = 'Ове речи НЕ треба да буду укључене';
$string['searcholderposts'] = 'Претражи старије поруке...';
$string['searchphrase'] = 'Ова конкретна фраза се мора наћи у поруци';
$string['searchresults'] = 'Резултати претраге';
$string['searchsubject'] = 'Ове речи треба да буду у теми поруке';
$string['searchtags'] = 'Означен је са';
$string['searchuser'] = 'Ово име треба да одговара имену аутора поруке';
$string['searchuserid'] = 'Moodle идентификатор аутора поруке';
$string['searchusers'] = 'Претражи кориснике';
$string['searchwhichforums'] = 'Изаберите које форуме треба претражити';
$string['searchwords'] = 'Ове речи се могу појавити било где у поруци';
$string['seeallposts'] = 'Погледај све поруке овог корисника';
$string['sendstudentnotificationsdefault'] = 'Подразумевано подешавање за опцију "Обавести полазнике"';
$string['sendstudentnotificationsdefault_help'] = 'Подесите подразумевану вредност за поље "Обавести полазнике" на обрасцу за оцењивање.';
$string['sendstudentnotificationsno'] = 'Не';
$string['sendstudentnotificationsyes'] = 'Да, пошаљи обавештење студенту';
$string['settings'] = 'Подешавања';
$string['shortpost'] = 'Кратка порука';
$string['showgraderpanel'] = 'Прикажи панел за оцењивање';
$string['showingcountoftotaldiscussions'] = 'Списак дискусија. Приказује се {$a->count} од укупно {$a->total} дискусије/а';
$string['showmoreusers'] = 'Прикажи више корисника';
$string['showpreviousrepliescount'] = 'Прикажи претходне одговоре ({$a})';
$string['showsubscribers'] = 'Прикажи/уреди списак тренутних претплатника';
$string['showusersearch'] = 'Прикажи претрагу корисника';
$string['singleforum'] = 'Једна обична дискусија';
$string['smallmessage'] = '{$a->user} је послао/ла поруку на {$a->forumname}';
$string['smallmessagedigest'] = 'Број порука  са форума који садржи сажети приказ: {$a}';
$string['starredonly'] = 'Претражи само означене дискусије';
$string['startedby'] = 'Започео/ла';
$string['subject'] = 'Тема';
$string['subplugintype_forumreport'] = 'Извештај са форума';
$string['subplugintype_forumreport_plural'] = 'Извештаји са форума';
$string['subscribe'] = 'Претплатите се на форум';
$string['subscribeall'] = 'Пријави све кориснике на овај форум';
$string['subscribed'] = 'Претплаћени';
$string['subscribediscussion'] = 'Пријави се за ову дискусију';
$string['subscribeenrolledonly'] = 'Нажалост, само корисници уписани на неки од курсева могу да се претплате да примају обавештења са форума е-поштом.';
$string['subscribenone'] = 'Одјави све кориснике са овог форума';
$string['subscribers'] = 'Претплатници';
$string['subscriberstowithcount'] = 'Пријављени на "{$a->name}" ({$a->count})';
$string['subscribestart'] = 'Пошаљите ми обавештења о новим порукама на овом форуму';
$string['subscribestop'] = 'Не желим да добијам обавештења о новим порукама на овом форуму';
$string['subscription'] = 'Претплата';
$string['subscription_help'] = 'Ако сте претплаћени на форум, то значи да ћете примати обавештења о новим порукама на форуму. Обично можете да изаберете да ли желите да се претплатите на форум. Међутим, понекад предавач може подесити да претплата буде обавезна. У том случају сви корисници ће примати обавештења.';
$string['subscriptionandtracking'] = 'Претплата и праћење';
$string['subscriptionauto'] = 'Аутоматска претплата';
$string['subscriptiondisabled'] = 'Претплата је онемогућена';
$string['subscriptionforced'] = 'Обавезна претплата';
$string['subscriptionmode'] = 'Режим претплате';
$string['subscriptionmode_help'] = 'Када је корисник претплаћен на форум, то значи да ће добијати обавештења о порукама на форуму.
Постоје 4 могућа начина за претплату:

* Опциона претплата - корисници могу да изаберу да ли желе да буду претплаћени на форум или не
* Обавезна претплата - сви корисници су претплаћени и не могу се одјавити
* Аутоматска претплата - сви корисници су иницијално претплаћени али, уколико желе, могу да изаберу да се одјаве у било ком тренутку
* Претплата онемогућена - претплата на форум није дозвољена';
$string['subscriptionmodeconfirm'] = 'Да ли сте сигурни да желите да промените режим претплате на {$a}?';
$string['subscriptionoptional'] = 'Опциона претплата';
$string['subscriptions'] = 'Претплате';
$string['tagarea_forum_posts'] = 'Постови на форуму';
$string['tagsdeleted'] = 'Ознаке форума су обрисане';
$string['thisforumhasduedate'] = 'Крајњи рок за слање порука на овај форум је {$a}.';
$string['thisforumisdue'] = 'Крајњи рок за слање порука на овај форум био је {$a}.';
$string['thisforumisthrottled'] = 'Овај форум има ограничење у броју порука које можете послати у датом временском периоду - тренутно је ово ограничење подешено на {$a->blockafter} порука унутар {$a->blockperiod}';
$string['timed'] = 'Временски ограничено';
$string['timeddiscussion'] = 'Временски ограничена дискусија';
$string['timedhidden'] = 'Временски статус: сакривено од студената';
$string['timedposts'] = 'Временски одређени постови';
$string['timedvisible'] = 'Временски статус: видљиво свим корисницима';
$string['timestartenderror'] = 'Крај приказа не може бити подешен на датум ранији од почетка приказа';
$string['togglediscussionmenu'] = 'Укључи/искључи мени дискусије';
$string['togglefullscreen'] = 'Укључи/искључи приказ преко целог екрана';
$string['togglesettingsdrawer'] = 'Прекидач подешавања фиоке';
$string['trackforum'] = 'Прати непрочитане поруке';
$string['tracking'] = 'Прати';
$string['trackingoff'] = 'Искључено';
$string['trackingon'] = 'Обавезно';
$string['trackingoptional'] = 'Опционо';
$string['trackingtype'] = 'Праћење прочитаних/непрочитаних порукана';
$string['trackingtype_help'] = 'Праћење прочитаних/непрочитаних порука на форумима и унутар дискусија, омогућава учесницима да лако провере које поруке нису још видели, тако што ће нове поруке бити истакнуте.

Ако је подешено  на опционо праћење, учесници могу да изаберу да ли ће укључити или искључити праћење прочитаних/непрочитаних порука на форуму (корисници морају, такође, да омогуће праћење прочитаних порука у својим параметрима форума).

Ако је на нивоу администрације сајта укључена опција \'Дозволи обавезно праћење прочитаних/непрочитаних порука\', онда је још једна опција доступна - обавезно праћење. То значи да је праћење увек укључено, без обзира на подешавања корисника.';
$string['trackreadposts_header'] = 'Праћење форума';
$string['unlockdiscussion'] = 'Откључај ову дискусију';
$string['unpindiscussion'] = 'Уклони фиксирање са ова дискусије';
$string['unread'] = 'Непрочитано';
$string['unreadpost'] = 'Непрочитани пост';
$string['unreadposts'] = 'Непрочитане поруке';
$string['unreadpostsnumber'] = 'Број непрочитаних порука: {$a}';
$string['unreadpostsone'] = '1 непрочитана порука';
$string['unsubscribe'] = 'Одјавите се са форума';
$string['unsubscribeall'] = 'Одјавите се са свих форума';
$string['unsubscribeallconfirm'] = 'Тренутно сте претплаћени на {$a->forums} форум/а и {$a->discussions} дискусију/е/а. Да ли заиста желите да се одјавите са свих форума и дискусија, и да искључите аутоматску претплату на дискусије?';
$string['unsubscribeallconfirmdiscussions'] = 'Тренутно сте претплаћени на {$a->discussions} дискусију/е/а. Да ли заиста желите да се одјавите са свих дискусија, и да искључите аутоматску претплату на дискусије?';
$string['unsubscribeallconfirmforums'] = 'Тренутно сте претплаћени на {$a->forums} форум/а. Да ли заиста желите да се одјавите са свих форума, и да искључите аутоматску претплату на дискусије?';
$string['unsubscribealldone'] = 'Све опционе претплате на форуме су поништене. И даље ћете примати обавештења са форума на којима је претплата обавезна. Ако желите да подесите опције везане за обавештења са форума у корисничком менију изаберите опцију Параметри а затим Параметри обавештења.';
$string['unsubscribeallempty'] = 'Нисте претплаћени ни на један форум. Ако желите да онемогућите сва обавештења са овог сервера у корисничком менију изаберите опцију Параметри а затим Параметри обавештења.';
$string['unsubscribed'] = 'Одјављени сте са овог форума';
$string['unsubscribediscussion'] = 'Одјави се са ове дискусије';
$string['unsubscribediscussionlink'] = 'Одјавите се са ове дискусије: {$a}';
$string['unsubscribelink'] = 'Одјавите се са овог форума: {$a}';
$string['unsubscribeshort'] = 'Одјави се';
$string['useexperimentalui'] = 'Користите експериментални угнежђени приказ дискусије';
$string['usermarksread'] = 'Ручно обележавање прочитаних порука';
$string['usernavigation'] = 'Навигација корисника';
$string['usersforumposts'] = 'Постови корисника на форуму';
$string['viewalldiscussions'] = 'Погледај све дискусије';
$string['viewconversation'] = 'Погледај дискусију';
$string['viewgrades'] = 'Погледај оцене';
$string['viewparentpost'] = 'Погледај надређени пост';
$string['viewthediscussion'] = 'Погледај дискусију';
$string['warnafter'] = 'Гранична вредност броја порука за слање упозорења';
$string['warnafter_help'] = '<p>Полазници могу бити упозорени када се приближе максималном броју порука дозвоњених у датом временском периоду. Ово подешавање одређује након колико порука ће бити упозорени.</p>

<p>Корисници са овлашћењем mod/forum:postwithoutthrottling су изузети од овог ограничења.</p>';
$string['warnformorepost'] = 'Упозорење! Постоји више од једне дискусије на овом форуму - користите најновију';
$string['yournewquestion'] = 'Ваше ново питање';
$string['yournewtopic'] = 'Ваша нова тема за дискусију';
$string['yourreply'] = 'Ваш одговор';
