<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_topcoll', language 'fr', version '4.2'.
 *
 * @package     format_topcoll
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsection'] = 'Ajouter une section';
$string['arrow'] = 'Flèche';
$string['bulb'] = 'Ampoule';
$string['cachedef_activitymodulecountcache'] = 'Met en cache le nombre d’étudiants qui peuvent accéder à un module donné dans un cours donné.';
$string['cachedef_activitystudentrolescache'] = 'Met en cache les rôles des étudiants.';
$string['cachedef_activitystudentscache'] = 'Met en cache les identifiants des étudiants d’un cours donné.';
$string['cachedef_activityusercreatedcache'] = 'Met en cache les identifiants des nouveaux utilisateurs d’un cours donné.';
$string['cannotgetactivitycacheslock'] = 'Impossible d’obtenir le verrouillage des caches d’activité pour l’identifiant de cours {$a}.';
$string['center'] = 'Centre';
$string['cloud'] = 'Nuage';
$string['colourrule'] = 'Veuillez entrer une couleur RVB valide, six chiffres hexadécimaux ou « - » par défaut.';
$string['columndynamic'] = 'Dynamique';
$string['columnhorizontal'] = 'Horizontal';
$string['columnvertical'] = 'Vertical';
$string['configurationheadingsub'] = 'Configuration';
$string['configurationheadingsubdesc'] = 'Paramètres de configuration au niveau du site';
$string['courseadditionalmoddatamaxstudents'] = 'Définir le nombre maximum d’étudiants d’un cours auquel s’appliquera l’option « Afficher les informations supplémentaires »';
$string['courseadditionalmoddatamaxstudentsdesc'] = 'Les informations supplémentaires peuvent prendre du temps à calculer, en particulier pour les cours de grande taille. Vous pouvez donc définir ici le nombre maximum d’étudiants qu’un cours peut avoir pour que la fonctionnalité s’affiche sur ce cours.  Au-delà de cette valeur, les « Informations supplémentaires » ne seront PAS calculées ni affichées, quels que soient les paramètres du cours !  Une valeur à « 0 » signifie « illimité ».  Remarque : Il faut purger les caches lorsqu’ils sont modifiés.';
$string['courseadditionalmoddatastudentsinfo'] = 'Statut d’information supplémentaire :';
$string['courseadditionalmoddatastudentsinfolimitednoshow'] = 'Les informations supplémentaires ne seront PAS affichées pour les activités activées pour les étudiants {$a->étudiants} car le nombre dépasse le maximum « {$a->maxstudents} » défini par l’administrateur dans le paramètre « courseadditionalmoddatamaxstudents » du format de cours Sections Réduites.';
$string['courseadditionalmoddatastudentsinfolimitedshow'] = 'Des informations supplémentaires seront affichées pour les activités activées pour les  {$a->étudiants} étudiants si le nombre ne dépasse pas le maximum « {$a->maxstudents} » défini par l’administrateur dans le paramètre « courseadditionalmoddatamaxstudents » du format de cours Sections Réduites.';
$string['courseadditionalmoddatastudentsinfounlimited'] = 'Des informations supplémentaires s’afficheront pour les activités activées pour {$a} étudiants.';
$string['coursesectionactivityfurtherinformation'] = 'Page du cours pour plus d’informations';
$string['coursesectionactivityfurtherinformation_desc'] = 'Paramètres de la page de cours au niveau du site pour plus d’informations';
$string['coursesectionactivityfurtherinformationassign'] = 'Afficher les informations sur le devoir';
$string['coursesectionactivityfurtherinformationassigndesc'] = 'Permet de sélectionner les informations sur les devoirs à afficher dans un cours. Pour les enseignants/administrateurs, afficher le nombre de rendus.';
$string['coursesectionactivityfurtherinformationchoice'] = 'Afficher les choix';
$string['coursesectionactivityfurtherinformationchoicedesc'] = 'Permet de sélectionner les informations de choix à afficher sur un cours. Pour les enseignants/administrateurs, afficher le nombre de rendus.';
$string['coursesectionactivityfurtherinformationdata'] = 'Afficher les informations sur la base de données';
$string['coursesectionactivityfurtherinformationdatadesc'] = 'Permet de sélectionner les informations sur les données à afficher sur un cours. Pour les enseignants/administrateurs, afficher le nombre de rendus.';
$string['coursesectionactivityfurtherinformationfeedback'] = 'Afficher les informations de retour (feedback)';
$string['coursesectionactivityfurtherinformationfeedbackdesc'] = 'Permet de sélectionner les informations sur les retours à afficher sur un cours. Pour les enseignants/administrateurs, afficher le nombre de rendus.';
$string['coursesectionactivityfurtherinformationforum'] = 'Afficher les informations du forum';
$string['coursesectionactivityfurtherinformationforumdesc'] = 'Permet aux informations du forum d’être sélectionnées pour être affichées sur un cours.  Pour les enseignants/administrateurs, afficher le nombre de contributions lorsque le classement du forum entier est activé.';
$string['coursesectionactivityfurtherinformationlesson'] = 'Afficher les informations sur la leçon';
$string['coursesectionactivityfurtherinformationlessondesc'] = 'Permet de sélectionner les informations sur les leçons à afficher sur un cours. Pour les enseignants/administrateurs, afficher le nombre de rendus.';
$string['coursesectionactivityfurtherinformationquiz'] = 'Afficher les informations du quiz';
$string['coursesectionactivityfurtherinformationquizdesc'] = 'Permet de sélectionner les informations sur les tests à afficher sur un cours. Pour les enseignants/administrateurs, afficher le nombre de rendus.';
$string['ctreset'] = 'Réinitialisation des options des sections réduites';
$string['ctreset_help'] = 'Rétablir les paramètres par défaut des sections réduites.';
$string['currentsection'] = 'Cette section';
$string['default'] = 'Défaut - {$a}';
$string['defaultdisplayblocks'] = 'Blocs à afficher';
$string['defaultdisplayblocks_desc'] = 'Choisir les blocs à afficher dans le cours lorsqu’il est créé pour la première fois et que ce format est sélectionné.  Utilisez la touche « Ctrl » en combinaison avec la souris pour en sélectionner plusieurs ou aucun.  Remarque : ce paramètre ne s’appliquera qu’à la création du cours et à aucun autre moment, par exemple si vous passez d’un autre format à celui de Section Réduite.';
$string['defaultdisplayblocksloc'] = 'Emplacement d’affichage du bloc';
$string['defaultdisplayblocksloc_desc'] = 'Choisir l’emplacement d’affichage des blocs choisis ci-dessus, avant ou après le côté.';
$string['defaultdisplayinstructions'] = 'Afficher les instructions aux utilisateurs';
$string['defaultdisplayinstructions_desc'] = 'Afficher des instructions aux utilisateurs les informant de la manière d’utiliser les boutons.  Peut être oui ou non.';
$string['defaultheadingsub'] = 'Défauts';
$string['defaultheadingsubdesc'] = 'Paramètres par défaut qui peuvent être remplacés au niveau du cours.';
$string['defaultlayoutcolumnorientation'] = 'Orientation de la colonne';
$string['defaultlayoutcolumnorientation_desc'] = 'Orientation de la colonne par défaut : <br>Dynamique - Le nombre de sections par « ligne » s’ajuste à la taille de la fenêtre, le paramètre « Colonne » n’est pas utilisé actuellement.<br>Horizontal - Les sections vont de gauche à droite.<br>Vertical - Les sections vont de haut en bas.';
$string['defaultlayoutcolumns'] = 'Nombre de colonnes';
$string['defaultlayoutcolumns_desc'] = 'Nombre de colonne entre un et quatre';
$string['defaultlayoutelement'] = 'Mise en page';
$string['defaultlayoutelement_desc'] = 'Le réglage de la mise en page peut être : <br />« Par défaut » avec tout qui s’affiche.<br />Pas de « Sujet x » / « Semaine x » / « Jour x ».<br />Pas de numéro de section.<br />Pas de « Sujet x » / « Semaine x » / « Jour x » ni aucun numéro de section.<br />Pas de mention de « Basculer ».<br />Pas de mention de « Basculer », ni de « Sujet x » / « Semaine x » / « Jour x ».<br />Pas de mention de « Basculer », ni de « Sujet x » / « Semaine x » / « Jour x », ni aucun numéro de section.';
$string['defaultlayoutelement_descpositive'] = 'Le réglage de la mise en page peut être : <br />« Basculer », « Sujet x » / « Semaine x » / « Jour x » et numéro de section.<br />« Basculer » et « Sujet x » / « Semaine x » / « Jour x ».<br />« Basculer » et  numéro de section.<br />« Sujet x » / « Semaine x » / « Jour x » et numéro de section.<br />« Basculer ».<br />« Sujet x » / « Semaine x » / « Jour x ».<br />Numéro de section.<br />Sans ajout.';
$string['defaultlayoutstructure'] = 'Configuration de la structure';
$string['defaultlayoutstructure_desc'] = 'Le paramètre de structure peut être l’un des suivants : <br />Sujet<br />Semaine<br />Dernière semaine en premier<br />Sujet actuel en premier<br />Jour';
$string['defaultonesection'] = 'Une section';
$string['defaultonesection_desc'] = 'Indique si une seule section devrait être ouverte à la fois. Note : ce paramètre est ignoré en mode édition pour permettre le déplacement d’éléments entre les sections.';
$string['defaultonesectioniconfont'] = 'Police d’icônes d’une section';
$string['defaultonesectioniconfont_desc'] = 'Indiquer la classe de police d’icônes à utiliser pour l’icône de lien d’une section, par exemple, voir les classes d’icône de FontAwesome.  S’il est vide, l’icône par défaut « one_section » du dossier « pix » du format sera utilisée.';
$string['defaultshowadditionalmoddata'] = 'Cours par défaut « Afficher des informations supplémentaires »';
$string['defaultshowadditionalmoddatadesc'] = 'Si une activité est définie au niveau du site (ci-dessous) pour afficher des informations supplémentaires, ce paramètre indique l’état par défaut de l’instance spécifique au cours.';
$string['defaultshowsectionsummary'] = 'Afficher le résumé de la section lorsqu’elle est réduite';
$string['defaultshowsectionsummary_desc'] = 'Fixe le résumé de la section toujours affiché même si la section est réduite.';
$string['defaulttgbgcolour'] = 'Changer la couleur d’arrière-plan';
$string['defaulttgbgcolour_desc'] = 'Définit la couleur du fond de la section réduite.';
$string['defaulttgbghvrcolour'] = 'Changer la couleur du survol de la souris';
$string['defaulttgbghvrcolour_desc'] = 'Définit la couleur de la section réduite au passage de la souris.';
$string['defaulttgbghvropacity'] = 'Opacité de la couleur d’arrière-plan au passage de la souris.';
$string['defaulttgbghvropacity_desc'] = 'Définit l’opacité de l’arrière-plan par survol entre 0 et 1 par incréments de 0,1.';
$string['defaulttgbgopacity'] = 'Opacité de l’arrière-plan';
$string['defaulttgbgopacity_desc'] = 'Définit l’opacité de l’arrière-plan entre 0 et 1 par incréments de 0,1.';
$string['defaulttgfgcolour'] = 'Changer la couleur de premier plan';
$string['defaulttgfgcolour_desc'] = 'Définit la couleur du texte de la section réduite.';
$string['defaulttgfghvrcolour'] = 'Changer la couleur de premier plan du survol de la souris';
$string['defaulttgfghvrcolour_desc'] = 'Couleur du texte en format RGB hexadécimal.';
$string['defaulttgfghvropacity'] = 'Activer l’opacité du survol du premier plan';
$string['defaulttgfghvropacity_desc'] = 'Définit l’opacité du texte de premier plan par survol entre 0 et 1 par incréments de 0,1.';
$string['defaulttgfgopacity'] = 'Opacité du premier plan';
$string['defaulttgfgopacity_desc'] = 'Définit l’opacité du texte du premier plan entre 0 et 1 par incréments de 0,1.';
$string['defaulttogglealignment'] = 'Changer l’alignement du texte';
$string['defaulttogglealignment_desc'] = '« Gauche », « Centré » ou « Droite »';
$string['defaulttoggleallenabled'] = 'Tout basculer activé';
$string['defaulttoggleallenabled_desc'] = 'Indiquer si toutes les fonctionnalités doivent être activées.';
$string['defaulttoggleallhover'] = 'Changer tous les survols d’icônes';
$string['defaulttoggleallhover_desc'] = '« Non » ou « Oui »';
$string['defaulttoggleborderradiusbl'] = 'Rayon du coin en bas à gauche';
$string['defaulttoggleborderradiusbl_desc'] = 'Arrondi de la bordure en bas à gauche';
$string['defaulttoggleborderradiusbr'] = 'Rayon du coin en bas à droite';
$string['defaulttoggleborderradiusbr_desc'] = 'Arrondi de la bordure en bas à droite';
$string['defaulttoggleborderradiustl'] = 'Rayon du coin en haut à gauche';
$string['defaulttoggleborderradiustl_desc'] = 'Arrondi de la bordure en haut à gauche';
$string['defaulttoggleborderradiustr'] = 'Rayon du coin en haut à droite';
$string['defaulttoggleborderradiustr_desc'] = 'Arrondi de la bordure en haut à droite';
$string['defaulttoggleiconfontclosed'] = 'Police de l’icône pour section repliée';
$string['defaulttoggleiconfontclosed_desc'] = 'Lorsque « defaulttoggleiconset » est défini sur « Police d’icônes », cela indique les classes CSS par défaut à utiliser pour l’icône repliée, c’est-à-dire les classes d’icônes de FontAwesome.';
$string['defaulttoggleiconfontopen'] = 'Police de l’icône pour section dépliée';
$string['defaulttoggleiconfontopen_desc'] = 'Lorsque « defaulttoggleiconset » est défini sur « Police d’icônes », cela indique les classes CSS par défaut à utiliser pour l’icône dépliée, c’est-à-dire les classes d’icône de FontAwesome.';
$string['defaulttoggleiconposition'] = 'Position des icônes';
$string['defaulttoggleiconposition_desc'] = 'Précise si les icônes doivent être à droite ou à gauche du mot « Basculer ».';
$string['defaulttoggleiconset'] = 'Changer le jeu d’icônes';
$string['defaulttoggleiconset_desc'] = '<table><tbody><tr><td>Flèche</td><td>{$a->arrow}</td></tr><tr><td>Ampoule</td><td>{$a->bulb} </td> </tr> <tr> <td>Nuage</td> <td> {$a->cloud} </td> </tr> <tr> <td>Œil</td><td>{$a->eye}</td></tr><tr><td>Dossier</td> <td> {$a->folder} </td> </ tr > <tr> <td>Signal de masse</td> <td> {$a->groundsignal} </td> </tr> <tr> <td>Diode électroluminescente</td> <td> {$a->led} </td> </tr> <tr> <td>Point</td> <td> {$a->point} </td> </tr> <tr> <td>Puissance</ td> <td> {$a->power} </td> </tr> <tr> <td>Radio</td> <td> {$a->radio} </td> </tr> < tr> <td>Smiley</td> <td> {$a->smiley} </td> </tr> <tr> <td>Carré</td> <td> {$a->square} < /td> </tr> <tr> <td>Soleil / Lune</td> <td> {$a->sunmoon} </td> </tr> <tr> <td>Interrupteur</td> <td> {$a->switch} </td> </tr>
<tr><td>Police d’icônes</td><td>{$a->tif}</td></tr>
</tbody> </table>';
$string['defaulttoggleiconsize'] = 'Taille des icônes';
$string['defaulttoggleiconsize_desc'] = 'Taille des icônes : petit = 16px, moyen = 24px et grand = 32px ou Police d’icône : Petite = 0.8em, Moyenne = 1.2em et Grande = 1.8em.';
$string['defaulttogglepersistence'] = 'Persistance de la bascule';
$string['defaulttogglepersistence_desc'] = '« On » ou « Off ». Mettre sur « Off » pour améliorer la performance AJAX, mais la position des sections basculées par l’utilisateur ne sera pas rappelée à l’actualisation de la page.<br /> Remarque : Lorsque vous désactivez la persistance, veuillez supprimer toutes les lignes contenant « topcoll_toggle_x » dans le champ « name » de la table « user_preferences » de la base de données.  Le « x » de « topcoll_toggle_x » correspond à l’identifiant du cours.  Ceci permet de gagner de la place si vous n’avez pas l’intention de le réactiver.';
$string['defaultuserpreference'] = 'État initial des bascules';
$string['defaultuserpreference_desc'] = 'Indique ce qu’il faut faire avec les boutons à bascule lorsque l’utilisateur accède au cours pour la première fois, l’état des sections supplémentaires lorsqu’elles sont ajoutées ou que la persistance des boutons à bascule est désactivée.';
$string['defaultviewsinglesectionenabled'] = 'Afficher une seule section active';
$string['defaultviewsinglesectionenabled_desc'] = 'Indique si la fonctionnalité d’affichage d’une seule section doit être activée.';
$string['deletesection'] = 'Supprimer la section';
$string['displayinstructions'] = 'Afficher les instructions';
$string['displayinstructions_help'] = 'Définit si les instructions seront affichées aux utilisateurs';
$string['donotshowdate'] = 'Ne pas afficher la date';
$string['donotshowdate_help'] = 'Ne pas afficher la date lors de l’utilisation d’une structure hebdomadaire avec l’option ­« nom de la section par défaut » décochée.';
$string['editsection'] = 'Modifier la section';
$string['editsectionname'] = 'Modifier le nom de la section';
$string['em0_0'] = '0.0em';
$string['em0_1'] = '0.1em';
$string['em0_2'] = '0.2em';
$string['em0_3'] = '0.3em';
$string['em0_4'] = '0.4em';
$string['em0_5'] = '0.5em';
$string['em0_6'] = '0.6em';
$string['em0_7'] = '0.7em';
$string['em0_8'] = '0.8em';
$string['em0_9'] = '0.9em';
$string['em1_0'] = '1.0em';
$string['em1_1'] = '1.1em';
$string['em1_2'] = '1.2em';
$string['em1_3'] = '1.3em';
$string['em1_4'] = '1.4em';
$string['em1_5'] = '1.5em';
$string['em1_6'] = '1.6em';
$string['em1_7'] = '1.7em';
$string['em1_8'] = '1.8em';
$string['em1_9'] = '1.9em';
$string['em2_0'] = '2.0em';
$string['em2_1'] = '2.1em';
$string['em2_2'] = '2.2em';
$string['em2_3'] = '2.3em';
$string['em2_4'] = '2.4em';
$string['em2_5'] = '2.5em';
$string['em2_6'] = '2.6em';
$string['em2_7'] = '2.7em';
$string['em2_8'] = '2.8em';
$string['em2_9'] = '2.9em';
$string['em3_0'] = '3.0em';
$string['em3_1'] = '3.1em';
$string['em3_2'] = '3.2em';
$string['em3_3'] = '3.3em';
$string['em3_4'] = '3.4em';
$string['em3_5'] = '3.5em';
$string['em3_6'] = '3.6em';
$string['em3_7'] = '3.7em';
$string['em3_8'] = '3.8em';
$string['em3_9'] = '3.9em';
$string['em4_0'] = '4.0em';
$string['enableadditionalmoddata'] = 'Activer les informations supplémentaires';
$string['enableadditionalmoddatadesc'] = 'Il s’agit d’un paramétrage au « niveau du site » permettant d’activer ou de désactiver les informations sur les activités.  Il doit être activé pour que les paramètres associés qui fonctionnent au niveau du cours prennent effet.  Comme cette fonctionnalité peut être coûteuse en termes de calcul, il est fortement conseillé d’effectuer des tests complets avant de l’utiliser sur un système de production.  Note : I faut purger les caches lorsqu’ils sont modifiés.';
$string['eye'] = 'Œil';
$string['feedbackavailable'] = 'Commentaire (feedback) disponible';
$string['folder'] = 'Dossier';
$string['formatresponsive'] = 'Format responsive';
$string['formatresponsive_desc'] = 'Activez cette option si vous utilisez un thème non réactif et le format s’adaptera à la taille de l’écran/du périphérique.  Désactivez cette option si vous utilisez un thème réactif.  La prise en charge de Bootstrap 2.3.2 est intégrée. Pour les autres cadres et versions, remplacez les méthodes « get_row_class() » et « get_column_class() » dans renderer.php.';
$string['formatsettings'] = 'Réinitialisation des réglages du format';
$string['formatsettingsinformation'] = '<br />Pour modifier les paramètres du format du cours, cliquez sur l’icône à droite.';
$string['four'] = 'Quatre';
$string['groundsignal'] = 'Signal de base';
$string['hidefromothers'] = 'Cacher la section';
$string['information'] = 'Information';
$string['informationsettings'] = 'Paramètres d’information';
$string['informationsettingsdesc'] = 'Informations sur le format des Sections Réduites';
$string['instructions'] = 'Instruction : un clic sur le titre de la section affiche ou masque cette section';
$string['large'] = 'Grand';
$string['layoutstructuredays'] = 'jours';
$string['layoutstructuretopics'] = 'sujets';
$string['layoutstructureweeks'] = 'semaines';
$string['led'] = 'Diode émettrice de lumière';
$string['left'] = 'Gauche';
$string['love'] = 'amour';
$string['maincoursepage'] = 'Page principale du cours';
$string['markedthissection'] = 'Cette section est mise en évidence comme section actuelle';
$string['markthissection'] = 'Mettre en évidence cette section comme section actuelle';
$string['medium'] = 'Moyen';
$string['newsectionname'] = 'Nouveau nom pour la section {$a}';
$string['numbersections'] = 'Nombre de section';
$string['off'] = 'Off';
$string['on'] = 'On';
$string['one'] = 'Une';
$string['onesection'] = 'Une section';
$string['onesection_help'] = 'Indique si une seule section doit être ouverte à un moment donné. Remarque : ce réglage est ignoré lors de l’édition pour permettre le déplacement des activités et des ressources dans les sections.';
$string['page-course-view-topcoll'] = 'Toutes les pages du cours principal au format sections réduites';
$string['page-course-view-topcoll-x'] = 'Toutes les pages du cours au format sections réduites';
$string['pluginname'] = 'Sections réduites';
$string['point'] = 'Point';
$string['power'] = 'Power';
$string['privacy:metadata:preference:toggle'] = 'L’état des bascules dans un cours.';
$string['privacy:request:preference:toggle'] = 'L’identifiant du cours « {$a->name} » a la valeur « {$a->value} » qui représente « {$a->decoded} » pour l’état des bascules.';
$string['radio'] = 'Radio';
$string['readme_desc'] = 'Veuillez cliquer sur « {$a->url} » pour plus d’informations sur les Sections Réduites.';
$string['readme_title'] = 'Fichier « lisez-moi » (en anglais)';
$string['resetactivitymeta'] = 'Informations complémentaires sur les modules';
$string['resetactivitymeta_help'] = 'Réinitialise les informations du module supplémentaire pour suivre la valeur par défaut du site.';
$string['resetallactivitymeta'] = 'Toutes les informations supplémentaires sur les modules';
$string['resetallactivitymeta_help'] = 'Réinitialise toutes les informations supplémentaires du module pour suivre la valeur par défaut du site.';
$string['resetallcolour'] = 'Les couleurs';
$string['resetallcolour_help'] = 'Réinitialise les couleurs et les opacités pour suivre la valeur par défaut du site.';
$string['resetalldisplayinstructions'] = 'L’affichage des instructions';
$string['resetalldisplayinstructions_help'] = 'Réinitialise les instructions d’affichage pour suivre la valeur par défaut du site.';
$string['resetallgrp'] = 'Tout réinitialiser :';
$string['resetalllayout'] = 'La mise en page';
$string['resetalllayout_help'] = 'Réinitialise l’élément de mise en page, la structure, les colonnes, le basculement de tous les éléments, l’affichage d’une seule section, la position de l’icône, une section et le résumé de la section affichée pour suivre la valeur par défaut du site.';
$string['resetalltogglealignment'] = 'L’alignement du texte';
$string['resetalltogglealignment_help'] = 'Réinitialise tous les alignements de bascule pour suivre la valeur par défaut du site.';
$string['resetalltoggleiconset'] = 'Le jeu d’icônes';
$string['resetalltoggleiconset_help'] = 'Réinitialise l’ensemble des icônes de bascule et le survol de toutes les icônes de bascule pour suivre la valeur par défaut du site.';
$string['resetcolour'] = 'Couleur';
$string['resetcolour_help'] = 'Réinitialise les couleurs et les opacités pour suivre la valeur par défaut du site.';
$string['resetdisplayinstructions'] = 'L’affichage des instructions';
$string['resetdisplayinstructions_help'] = 'Réinitialise les instructions d’affichage pour suivre la valeur par défaut du site.';
$string['resetgrp'] = 'Réinitialiser :';
$string['resetlayout'] = 'La mise en page';
$string['resetlayout_help'] = 'Réinitialise l’élément de mise en page, la structure, les colonnes, le basculement de tous les éléments, l’affichage d’une seule section, la position de l’icône, une section et le résumé de la section affichée pour suivre la valeur par défaut du site.';
$string['resettogglealignment'] = 'L’alignement du texte';
$string['resettogglealignment_help'] = 'Réinitialise tous les alignements de bascule pour suivre la valeur par défaut du site.';
$string['resettoggleiconset'] = 'Le jeu d’icônes';
$string['resettoggleiconset_help'] = 'Réinitialise l’ensemble des icônes de bascule et le survol de toutes les icônes de bascule pour suivre la valeur par défaut du site.';
$string['right'] = 'Droite';
$string['sctcloseall'] = 'Tout fermer {$a}';
$string['sctopenall'] = 'Tout ouvrir {$a}';
$string['section0name'] = 'Général';
$string['sectionname'] = 'Section';
$string['setcolour'] = 'Couleur';
$string['setcolour_help'] = 'Contient les réglages pour paramétrer les couleurs du format sections réduites.';
$string['setlayout'] = 'Paramètres de base';
$string['setlayout_all'] = 'Mention de « Basculer », « Section x » / « Semaine x » / « Jour x à basculer » et numéro de section';
$string['setlayout_default'] = 'Par défaut';
$string['setlayout_help'] = 'Contient les réglages pour paramétrer le format sections réduites.';
$string['setlayout_no_additions'] = 'Pas d’ajout';
$string['setlayout_no_section_no'] = 'Pas de numéro de section';
$string['setlayout_no_toggle_section_x'] = 'Pas de « section x à basculer »';
$string['setlayout_no_toggle_section_x_section_no'] = 'Pas de « section x à basculer » ni de numéro de section';
$string['setlayout_no_toggle_word'] = 'Pas de mot « Basculer »';
$string['setlayout_no_toggle_word_toggle_section_x'] = 'Pas de mot « Basculer » ni de « section x à basculer »';
$string['setlayout_no_toggle_word_toggle_section_x_section_no'] = 'Pas de mot, pas de section x ni de numéro de section à basculer';
$string['setlayout_section_number'] = 'Nombre de sections';
$string['setlayout_toggle_section_x'] = 'Mention de « Sujet x » / « Semaine x » / « Jour x à basculer »';
$string['setlayout_toggle_section_x_section_number'] = 'Mention de « Sujet x » / « Semaine x » / « Jour x à basculer » et numéro de section';
$string['setlayout_toggle_word'] = 'Mention de « Basculer »';
$string['setlayout_toggle_word_section_number'] = 'Mention de « Basculer » et numéro de section';
$string['setlayout_toggle_word_section_x'] = 'Mention de « Basculer » et « Section x » / « Semaine x » / « Jour x à basculer »';
$string['setlayoutcolumnorientation'] = 'Orientation des colonnes';
$string['setlayoutcolumnorientation_help'] = 'Dynamique - Le nombre de sections par « ligne » s’ajuste à la taille de la fenêtre, le paramètre « Colonne » n’est pas utilisé actuellement.<br>Horizontal - Les sections vont de gauche à droite.<br>Vertical - Les sections vont de haut en bas.';
$string['setlayoutcolumns'] = 'Colonnes';
$string['setlayoutcolumns_help'] = 'Définit le nombre de colonnes à utiliser.';
$string['setlayoutelements'] = 'Éléments';
$string['setlayoutelements_help'] = 'Quelles informations souhaitez-vous afficher sur le bandeau ?';
$string['setlayoutstructure'] = 'Structure';
$string['setlayoutstructure_help'] = 'La structure de mise en page du cours. Vous pouvez choisir entre :<br />« Sujets » - où chaque section est présentée comme un sujet dans l’ordre des numéros de section.<br />« Semaines » - où chaque section est présentée comme une semaine dans l’ordre croissant des semaines à partir de la date de début du cours.<br />« Semaine en cours en premier » - qui est identique à semaines mais la semaine en cours est affichée en haut et les semaines précédentes par ordre décroissant sont affichées en dessous sauf en mode édition où la structure est la même que « Semaines ».<br />« Sujet actuel en premier » - qui est identique à « Sujets » sauf que le sujet actuel est affiché en haut s’il a été défini.<br />« Jour » - où chaque section est présentée par jour dans l’ordre croissant des jours à partir de la date de début du cours.';
$string['setlayoutstructurecurrenttopicfirst'] = 'Sujet actuel en premier';
$string['setlayoutstructureday'] = 'Jour';
$string['setlayoutstructurelatweekfirst'] = 'Semaine actuelle en premier';
$string['setlayoutstructuretopic'] = 'Section';
$string['setlayoutstructureweek'] = 'Semaine';
$string['setshowsectionsummary'] = 'Afficher le résumé de la section si réduite';
$string['setshowsectionsummary_help'] = 'Fixe le résumé de la section toujours affiché même si la section est réduite.';
$string['settings'] = 'Paramètres';
$string['settingssettings'] = 'Réglages des paramètres';
$string['settingssettingsdesc'] = 'Paramètres du format Sections Réduites';
$string['settogglealignment'] = 'Changer l’alignement du texte';
$string['settogglealignment_help'] = 'Définit l’alignement du texte dans le bandeau de la section réduite';
$string['settoggleallenabled'] = 'Tout basculer activé';
$string['settoggleallenabled_help'] = 'Activer toutes les fonctionnalités.';
$string['settoggleallhover'] = 'Changer le survol de toutes les icônes';
$string['settoggleallhover_help'] = 'Définit la positon des icônes dans le bandeau de la section réduite';
$string['settogglebackgroundcolour'] = 'Couleur du fond (bandeau)';
$string['settogglebackgroundcolour_help'] = 'Définit la couleur du fond de la section réduite.';
$string['settogglebackgroundhovercolour'] = 'Couleur du bandeau au survol de la souris';
$string['settogglebackgroundhovercolour_help'] = 'Définit la couleur de la section réduite au passage de la souris.';
$string['settogglebackgroundhoveropacity'] = 'Opacité du survol de l’arrière-plan';
$string['settogglebackgroundhoveropacity_help'] = 'Définit l’opacité de l’arrière-plan lors du survol de la bascule entre 0 et 1 par incréments de 0,1.';
$string['settogglebackgroundopacity'] = 'Opacité de l’arrière-plan';
$string['settogglebackgroundopacity_help'] = 'Définit l’opacité de l’arrière-plan sur la bascule entre 0 et 1 par incréments de 0,1.';
$string['settoggleforegroundcolour'] = 'Couleur du premier plan (texte)';
$string['settoggleforegroundcolour_help'] = 'Définit la couleur du texte de la section réduite.';
$string['settoggleforegroundhovercolour'] = 'Couleur du premier plan (texte au survol)';
$string['settoggleforegroundhovercolour_help'] = 'Définit la couleur du texte de la section réduite lorsque le pointeur de la souris le survole.';
$string['settoggleforegroundhoveropacity'] = 'Opacité du survol du premier plan';
$string['settoggleforegroundhoveropacity_help'] = 'Définit l’opacité du texte au survol de la bascule entre 0 et 1 par incréments de 0,1.';
$string['settoggleforegroundopacity'] = 'Opacité du premier plan';
$string['settoggleforegroundopacity_help'] = 'Définit l’opacité du texte sur la bascule entre 0 et 1 par incréments de 0,1.';
$string['settoggleiconfontclosed'] = 'Police de l’icône pour section repliée';
$string['settoggleiconfontclosed_help'] = 'Lorsque « defaulttoggleiconset » est défini sur « Icon font », cela indique les classes CSS par défaut à utiliser pour l’icône repliée, c’est-à-dire les classes d’icône de FontAwesome. Si la valeur est « - », la valeur par défaut est utilisée.';
$string['settoggleiconfontopen'] = 'Police de l’icône pour section dépliée';
$string['settoggleiconfontopen_help'] = 'Lorsque « defaulttoggleiconset » est défini sur « Icon font », cela indique les classes CSS par défaut à utiliser pour l’icône dépliée, c’est-à-dire les classes d’icône de FontAwesome. Si la valeur est « - », la valeur par défaut est utilisée.';
$string['settoggleiconposition'] = 'Position des icônes';
$string['settoggleiconposition_help'] = 'Indique que l’icône doit se trouver à gauche ou à droite du texte de basculement.';
$string['settoggleiconset'] = 'Jeu d’icônes';
$string['settoggleiconset_help'] = 'Définit le type d’icônes dans le bandeau de la section réduite';
$string['setviewsinglesectionenabled'] = 'Afficher une seule section activée';
$string['setviewsinglesectionenabled_help'] = 'La fonctionnalité d’affichage d’une seule section est activée.';
$string['showadditionalmoddata'] = 'Afficher des informations supplémentaires pour : {$a} dans le cours';
$string['showadditionalmoddata_help'] = 'Autoriser tous les utilisateurs à voir la date limite de l’activité et les utilisateurs disposant d’une autorisation de notation à voir le nombre de dépôts sur la page du cours pour les activités.';
$string['showfromothers'] = 'Afficher la section';
$string['sidepost'] = 'Après';
$string['sidepre'] = 'Avant';
$string['small'] = 'Petit';
$string['smiley'] = 'Smiley';
$string['square'] = 'Carré';
$string['sunmoon'] = 'Soleil / Lune';
$string['switch'] = 'Interrupteur';
$string['three'] = 'Trois';
$string['tif'] = 'Police d’icônes';
$string['toggleclose'] = 'Fermer';
$string['toggleopen'] = 'Ouvrir';
$string['topcoll:changeactivitymeta'] = 'Modifier ou réinitialiser l’activité meta';
$string['topcoll:changecolour'] = 'Modifier ou réinitialiser les couleurs';
$string['topcoll:changelayout'] = 'Modifier ou réinitialiser la configuration';
$string['topcoll:changetogglealignment'] = 'Modifier ou réinitialiser l’alignement du texte';
$string['topcoll:changetoggleiconset'] = 'Modifier ou réinitialiser les icônes';
$string['topcollall'] = 'toutes les sections.';
$string['topcollclosed'] = 'Tout fermer';
$string['topcollopened'] = 'Tout ouvrir';
$string['topcollsidewidthlang'] = 'en-28px';
$string['topcolltoggle'] = 'Basculer';
$string['two'] = 'Deux';
$string['versionalpha'] = 'Version alpha - Contient très certainement des bogues.  Il s’agit d’une version de développement pour les développeurs « uniquement » !  Ne pensez même pas à l’installer sur un serveur de production !';
$string['versionbeta'] = 'Version bêta - Susceptible de contenir des bogues. Prêt à être testé par les administrateurs sur un serveur de test uniquement.';
$string['versioninfo'] = 'Version {$a->release}, version {$a->version} sur Moodle {$a->moodle}. Fabriqué avec {$a->love} en Grande-Bretagne.';
$string['versionrc'] = 'Version Release Candidate - Peut contenir des bogues.  Vérifiez-la complètement sur un serveur de test avant de l’envisager sur un serveur de production.';
$string['versionstable'] = 'Version stable - Peut contenir des bogues.  Vérifiez sur un serveur de test avant d’installer sur votre serveur de production.';
$string['viewonly'] = 'Voir seulement « {$a->sectionname} »';
$string['xanswered'] = '{$a->completed} ont répondu';
$string['xattempted'] = '{$a->completed} ont tenté';
$string['xcontributed'] = '{$a->completed} ont contribué';
$string['xofyanswered'] = '{$a->completed} sur {$a->participants} ont répondu';
$string['xofyattempted'] = '{$a->completed} sur {$a->participants} ont tenté';
$string['xofycontributed'] = '{$a->completed} sur {$a->participants} ont contribué';
$string['xofyposted'] = '{$a->completed} sur {$a->participants} postés';
$string['xofysubmitted'] = '{$a->completed} sur {$a->participants} ont rendu';
$string['xposted'] = '{$a->completed} postés';
$string['xsubmitted'] = '{$a->completed} ont rendu';
$string['xungraded'] = '{$a} non notés';
