<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'sl', version '4.2'.
 *
 * @package     attendance
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Aacronym'] = 'I';
$string['Afull'] = 'Izostanek';
$string['Eacronym'] = 'O';
$string['Efull'] = 'Opravičilo';
$string['Lacronym'] = 'Z';
$string['Lfull'] = 'Zamuda';
$string['Pacronym'] = 'P';
$string['Pfull'] = 'Prisoten';
$string['absenteereport'] = 'Poročilo o izostanku';
$string['acronym'] = 'Kratica';
$string['add'] = 'Dodaj';
$string['addedrecip'] = 'Dodan {$a} nov prejemnik';
$string['addedrecips'] = 'Dodani novi prejemniki: {$a}';
$string['addmultiplesessions'] = 'Večkratne seje';
$string['addsession'] = 'Dodaj sejo';
$string['adduser'] = 'Dodaj uporabnika';
$string['addwarning'] = 'Dodaj opozorilo';
$string['all'] = 'Vse';
$string['allcourses'] = 'Vsi predmeti';
$string['allpast'] = 'Vse pretekle';
$string['allsessions'] = 'Vse seje';
$string['attendance:addinstance'] = 'Dodajanje: Prisotnost';
$string['attendance:canbelisted'] = 'Se pojavlja na seznamu';
$string['attendance:changeattendances'] = 'Sprememba prisotnosti';
$string['attendance:changepreferences'] = 'Sprememba nastavitev';
$string['attendance:export'] = 'Izvoz poročil';
$string['attendance:manageattendances'] = 'Upravljanje prisotnosti';
$string['attendance:managetemporaryusers'] = 'Upravljanje začasnih uporabnikov';
$string['attendance:takeattendances'] = 'Beleženje prisotnosti';
$string['attendance:view'] = 'Pregled prisotnosti';
$string['attendance:viewreports'] = 'Pregled poročil';
$string['attendance:viewsummaryreports'] = 'Ogled poročil s povzetki predmeta';
$string['attendance:warningemails'] = 'Možno je naročanje na e-sporočila za odsotne udeležence';
$string['attendance_already_submitted'] = 'Prisotnost je že bila zabeležena.';
$string['attendance_no_status'] = 'Veljaven status ni na voljo. Eden od vzrokov je lahko zamujen rok za oddajo prisotnosti.';
$string['attendancedata'] = 'Podatki o prisotnosti';
$string['attendancegrade'] = 'Ocena za prisotnost';
$string['attendancenotset'] = 'Zabeležiti je treba svojo prisotnost';
$string['attendancenotstarted'] = 'Prisotnost pri tem predmetu se še ni začela beležiti';
$string['attendancepercent'] = 'Odstotek prisotnosti';
$string['attendancereport'] = 'Poročilo o prisotnosti';
$string['attendanceslogged'] = 'Prisotnost zabeležena';
$string['attendancestaken'] = 'Zabeležene prisotnosti';
$string['attendancesuccess'] = 'Prisotnost uspešno zabeležena';
$string['attendanceupdated'] = 'Prisotnost uspešno posodobljena';
$string['attrecords'] = 'Zapisi prisotnosti';
$string['autoassignstatus'] = 'Samodejno izberi najvišji možen status';
$string['autoassignstatus_help'] = 'Če je možnost izbrana, se udeležencem samodejno dodelijo najvišje možne točke.';
$string['automark'] = 'Samodejno beleženje';
$string['automark_help'] = 'Omogoča samodejno beleženje prisotnosti.
Če je izbrana možnost "Da", bodo udeleženci samodejno označeni glede na njihov prvi dostop v predmetu.
Če je izbrana možnost "Na koncu seje nastavi kot neoznačeno", se bo vsem udeležencem, ki prisotnosti niso potrdili ročno, samodejno zapisala vrednost, ki je določena v nastavitvah pod zavihkom "Nastavitev statusa" (stolpec "Samodejno izpolni za neoznačene").';
$string['automarkall'] = 'Da';
$string['automarkclose'] = 'Na koncu seje nastavi kot neoznačeno';
$string['autorecorded'] = 'samodejno zabeležil sistem';
$string['averageattendance'] = 'Povprečna prisotnost';
$string['averageattendancegraded'] = 'Povprečna prisotnost';
$string['backtoparticipants'] = 'Nazaj na seznam sodelujočih';
$string['below'] = 'Pod {$a} %';
$string['calclose'] = 'Zapri';
$string['calendarevent'] = 'Za sejo ustvari dogodek v koledarju';
$string['calendarevent_help'] = 'Če je možnost omogočena, bo ustvarjen dogodek v koledarju. Če se možnost naknadno onemogoči, se izbriše tudi morebitni obstoječi dogodek za izbrano sejo.';
$string['caleventcreated'] = 'Dogodek v koledarju za sejo je uspešno ustvarjen.';
$string['caleventdeleted'] = 'Dogodek v koledarju za sejo je uspešno izbrisan.';
$string['calmonths'] = 'januar,februar,marec,april,maj,junij,julij,avgust,september,oktober,november,december';
$string['calshow'] = 'Izberi datum';
$string['calweekdays'] = 'ned,pon,tor,sre,čet,pet,sob';
$string['cannottakeforgroup'] = 'Za skupino "{$a}" ni možno zabeležiti zapisa o prisotnosti.';
$string['cantaddstatus'] = 'Za dodajanje novega statusa je treba zapisati kratico in opis.';
$string['categoryreport'] = 'Poročilo o kategoriji';
$string['changeattendance'] = 'Spremeni prisotnost';
$string['changeduration'] = 'Spremeni trajanje';
$string['changesession'] = 'Spremeni sejo';
$string['checkweekdays'] = 'Izberi delovnike, ki sodijo v izbrano časovno obdobje seje.';
$string['closed'] = 'Ta seja trenutno ne omogoča samostojnega beleženja prisotnosti';
$string['column'] = 'stolpec';
$string['columns'] = 'stolpci';
$string['commonsession'] = 'Vsi udeleženci';
$string['commonsessions'] = 'Vsi udeleženci';
$string['confirm'] = 'Potrdi';
$string['confirmcolumnmappings'] = 'Potrdi preslikavo stolpcev';
$string['confirmdeletehiddensessions'] = 'Ste prepričani, da želite izbrisati seje ({$a->count}), načrtovane pred datumom ({$a->date}) začetka predmeta?';
$string['confirmdeleteuser'] = 'Ste prepričani, da želite izbrisati uporabnika \'{$a->fullname}\' ({$a->email})?<br/>Vsi njegovi zapisi o prisotnosti bodo trajno izbrisani.';
$string['copyfrom'] = 'Kopiraj podatke o prisotnosti iz';
$string['countofselected'] = 'Preštej izbrane';
$string['course'] = 'Predmet';
$string['coursemessage'] = 'Sporočilo udeležencem';
$string['courseshortname'] = 'Kratko ime predmeta';
$string['coursesummary'] = 'Poročilo povzetka predmeta';
$string['createmultiplesessions'] = 'Ustvari večkratne seje';
$string['createmultiplesessions_help'] = 'Ta funkcija omogoča ustvarjanje večkratnih sej v enem preprostem koraku.
Seje se začnejo na datum osnovne seje in se nadaljujejo do datuma pod \'Ponavljaj do\'.

  * <strong>Ponovi v</strong>: izberite dneve v tednu, ko bodo potekala srečanja (npr. ponedeljek, sreda, petek).
  * <strong>Ponovi vsak</strong>: nastavite frekvenco srečanj (npr. 1 za tedenska srečanja, 2 za srečanja vsak drugi teden, 3 za vsak tretji teden).
  * <strong> Ponavljaj do</strong>: izberite datum zadnjega srečanja (na katerem želite preverjati prisotnost).';
$string['createonesession'] = 'Ustvari eno sejo za predmet';
$string['csvdelimiter'] = 'Ločilo za format CSV';
$string['currentlyselectedusers'] = 'Trenutno izbrani uporabniki';
$string['date'] = 'Datum';
$string['days'] = 'Dnevi';
$string['defaultdisplaymode'] = 'Privzet način prikaza';
$string['defaults'] = 'Privzete nastavitve';
$string['defaultsessionsettings'] = 'Privzete nastavitve sej';
$string['defaultsessionsettings_help'] = 'Te nastavitve določajo privzete vrednosti za vse nove seje';
$string['defaultsettings'] = 'Privzete nastavitve za prisotnost';
$string['defaultsettings_help'] = 'Te nastavitve določajo privzete vrednosti za vse nove udeležence';
$string['defaultstatus'] = 'Nastavitev privzetega statusa prisotnosti';
$string['defaultsubnet'] = 'Privzet omrežni naslov';
$string['defaultsubnet_help'] = 'Beleženje prisotnosti je lahko omejeno na podomrežja, ki so določena na seznamu
(z vejico ločenih) delnih ali celotnih IP naslovov. To je privzeta vrednost, ki se uporablja pri ustvarjanju novih sej.';
$string['defaultview'] = 'Privzeti pogled ob prijavi';
$string['defaultview_desc'] = 'To je privzeti pogled za izvajalce ob prvi prijavi.';
$string['defaultwarnings'] = 'Privzeto opozorilo nastavljeno';
$string['defaultwarningsettings'] = 'Nastavitev privzetih opozoril';
$string['defaultwarningsettings_help'] = 'Te nastavitve določajo privzete vrednosti za vsa nova opozorila';
$string['delete'] = 'Izbriši';
$string['deletecheckfull'] = 'Ali ste popolnoma prepričani, da želite v celoti izbrisati {$a}? Izbrisani bodo tudi uporabniški podatki.';
$string['deletedgroup'] = 'S to sejo povezana skupina je bila izbrisana';
$string['deletehiddensessions'] = 'Izbris vseh skritih sej';
$string['deletelogs'] = 'Izbriši podatke o prisotnosti';
$string['deleteselected'] = 'Izbriši izbrano';
$string['deletesession'] = 'Izbriši sejo';
$string['deletesessions'] = 'Izbriši vse seje';
$string['deleteuser'] = 'Izbriši uporabnika';
$string['deletewarningconfirm'] = 'Ali ste prepričani, da želite izbrisati izbrano opozorilo?';
$string['deletingsession'] = 'Brisanje seje v predmetu';
$string['deletingstatus'] = 'Brisanje statusa predmeta';
$string['description'] = 'Opis';
$string['display'] = 'Prikaz';
$string['displaymode'] = 'Način prikaza';
$string['donotusepaging'] = 'Ne prikazuj po straneh';
$string['downloadexcel'] = 'Prenesi kot datoteko Excel';
$string['downloadooo'] = 'Prenesi kot datoteko OpenOffice';
$string['downloadtext'] = 'Prenesi kot besedilno datoteko';
$string['duration'] = 'Trajanje';
$string['editsession'] = 'Uredi sejo';
$string['edituser'] = 'Uredi uporabnika';
$string['emailcontent'] = 'Vsebina e-sporočila';
$string['emailcontent_default'] = 'Pozdravljeni %userfirstname%.

Prisotnost v %coursename%, %attendancename%, je %percent% (odstotek).
Za uspešnost pri predmetu je potrebno prisotnost izboljšati (vsaj na %warningpercent%). Za dodatno pomoč ali morebitna vprašanja sem na voljo.

Želim uspešno nadaljevanje.';
$string['emailcontent_help'] = 'E-sporočilo z opozorilom udeležencu se polni z vsebino iz tega polja. Pri tem je možno uporabiti naslednje spremenljivke:
<ul>
<li>%coursename%</li>
<li>%userfirstname%</li>
<li>%userlastname%</li>
<li>%userid%</li>
<li>%warningpercent%</li>
<li>%attendancename%</li>
<li>%cmid%</li>
<li>%numtakensessions%</li>
<li>%points%</li>
<li>%maxpoints%</li>
<li>%percent%</li>
</ul>';
$string['emailsubject'] = 'Zadeva e-sporočila';
$string['emailsubject_default'] = 'Opozorilo o prisotnosti';
$string['emailsubject_help'] = 'Ko je udeležencu poslano opozorilo, se za e-sporočilo uporabi zadeva iz tega polja.';
$string['emailuser'] = 'Pošlji sporočilo';
$string['emailuser_help'] = 'Če je možnost omogočena, bo udeležencu poslano opozorilo.';
$string['emptyacronym'] = 'Prazne kratice niso dovoljene. Zapis stanja ni posodobljen.';
$string['emptydescription'] = 'Prazni opisi niso dovoljeni. Zapis stanja ni posodobljen.';
$string['enablecalendar'] = 'Ustvari dogodke v koledarju';
$string['enablecalendar_desc'] = 'Če je možnost omogočena, se za vsako sejo v koledarju ustvari dogodek. Po spremembi te nastavitve je potrebno ponastaviti poročilo koledarja.';
$string['enablewarnings'] = 'Omogoči opozorila';
$string['enablewarnings_desc'] = 'Ta možnost omogoča nastavitev opozoril glede prisotnosti, ki udeležencem pošlje e-sporočila z obvestili, če prisotnost pade pod nastavljen prag.<br/><strong>OPOZORILO: Gre za novo funkcionalnost, ki še ni bila temeljito preizkušena. Prosimo, da jo uporabite na lastno odgovornost in o njeni uporabnosti poročate na forumih Moodlove skupnosti.</strong>';
$string['encoding'] = 'Kodiranje';
$string['endofperiod'] = 'Konec obdobja';
$string['endtime'] = 'Čas zaključka seje';
$string['enrolmentend'] = 'Vpis udeležencev se zaključi {$a}';
$string['enrolmentstart'] = 'Vpis udeležencev se začne {$a}';
$string['enrolmentsuspended'] = 'Vpis onemogočen';
$string['enterpassword'] = 'Vnos gesla';
$string['error:coursehasnoattendance'] = 'Predmet s kratkim imenom {$a} nima aktivnosti za beleženje prisotnosti.';
$string['error:coursenotfound'] = 'Predmeta s kratkim imenom {$a} ni mogoče najti.';
$string['error:qrcode'] = 'Za uporabo QR kode mora biti udeležencem omogočeno samostojno beleženje prisotnosti. Ukaz ni upoštevan.';
$string['error:sessioncourseinvalid'] = 'Seja predmeta ni veljavna. Ukaz ni upoštevan.';
$string['error:sessiondateinvalid'] = 'Datum seje je neveljaven. Ukaz ni upoštevan.';
$string['error:sessionendinvalid'] = 'Čas zaključka seje je neveljaven. Ukaz ni upoštevan.';
$string['error:sessionstartinvalid'] = 'Čas začetka seje je neveljaven. Ukaz ni upoštevan.';
$string['errorgroupsnotselected'] = 'Izberite eno ali več skupin';
$string['errorinaddingsession'] = 'Napaka pri dodajanju seje';
$string['erroringeneratingsessions'] = 'Napaka pri tvorjenju sej';
$string['eventdurationupdated'] = 'Trajanje seje posodobljeno';
$string['eventreportviewed'] = 'Poročilo o prisotnosti ogledano';
$string['eventscreated'] = 'Dogodek v koledarju ustvarjen';
$string['eventsdeleted'] = 'Dogodek v koledarju izbrisan';
$string['eventsessionadded'] = 'Seja dodana';
$string['eventsessiondeleted'] = 'Seja izbrisana';
$string['eventsessionipshared'] = 'Pri samostojnem beleženju prisotnosti je nastal konflikt z IP naslovom';
$string['eventsessionsimported'] = 'Seja uvožena';
$string['eventsessionupdated'] = 'Seja posodobljena';
$string['eventstatusadded'] = 'Status dodan';
$string['eventstatusupdated'] = 'Status posodobljen';
$string['eventstudentattendancesessionsviewed'] = 'Poročilo o seji ogledano';
$string['eventtaken'] = 'Prisotnost zabeležena';
$string['eventtakenbystudent'] = 'Prisotnost zabeležena s strani udeleženca';
$string['export'] = 'Izvoz';
$string['extrarestrictions'] = 'Dodatne omejitve';
$string['formattexttype'] = 'Oblikovanje';
$string['from'] = 'od:';
$string['gradebookexplanation'] = 'Ocena v redovalnici';
$string['graded'] = 'Točkovane seje';
$string['gridcolumns'] = 'Stolpci mreže';
$string['group'] = 'Skupina';
$string['groups'] = 'Skupine';
$string['groupsession'] = 'Skupina udeležencev';
$string['hiddensessions'] = 'Skrite seje';
$string['hiddensessions_help'] = 'Seje so skrite, če je njihova izvedba pred datumom začetka predmeta.

Na ta način so stare (neaktualne) seje skrite, brez da bi jih bilo potrebno izbrisati. V Redovalnici so upoštevane zgolj aktualne seje.';
$string['hiddensessionsdeleted'] = 'Vse skrite seje so bile izbrisane';
$string['hideextrauserdetails'] = 'Skrij podrobnosti o uporabniku';
$string['hidensessiondetails'] = 'Skrij podrobnosti o seji';
$string['identifyby'] = 'Identificiraj udeležence po';
$string['import'] = 'Uvoz';
$string['importfile'] = 'Uvoz datoteke';
$string['importfile_help'] = 'Uvoz datoteke';
$string['importsessions'] = 'Uvoz seje';
$string['includeabsentee'] = 'Vključi sejo v izračune poročila o izostanku';
$string['includeabsentee_help'] = 'Če je možnost izbrana, bo ta seja upoštevana v izračunih poročila o izostanku.';
$string['includeall'] = 'Izberi vse seje';
$string['includenottaken'] = 'Upoštevaj neizvedene seje';
$string['includeqrcode'] = 'Vključi QR kodo';
$string['includeremarks'] = 'Vključi pripombe';
$string['incorrectpassword'] = 'Vpisano je bilo nepravilno geslo, zato prisotnost ni zabeležena. Potrebno je vpisati pravilno geslo.';
$string['incorrectpasswordshort'] = 'Nepravilno geslo. Prisotnost ni zabeležena.';
$string['indetail'] = 'Podrobnosti ...';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidaction'] = 'Izbrati je potrebno dejanje';
$string['invalidemails'] = 'Določiti je potrebno naslove obstoječih uporabniških računov. Najti ni bilo možno: {$a}';
$string['invalidimportfile'] = 'Format datoteke ni veljaven.';
$string['invalidsessionenddate'] = 'Ta datum ne sme biti pred datumom izvedbe seje';
$string['invalidsessionendtime'] = 'Ura zaključka mora biti kasnejša od ure začetka';
$string['invalidstatus'] = 'Izbran je bil neveljaven status. Poskusite znova.';
$string['iptimemissing'] = 'Neveljavne minute do izvedbe';
$string['jumpto'] = 'Skok na';
$string['keepsearching'] = 'Nadaljuj z iskanjem';
$string['maxpossible'] = 'Možno (max.)';
$string['maxpossible_help'] = 'Prikaže rezultat, ki ga lahko doseže udeleženec, če v vseh neizvedenih sejah (pretekle in prihodnje) prejme vse možne točke:
    <ul>
    <li><strong>Točke</strong>: najvišje možno število točk, ki jih lahko uporabnik doseže v vseh sejah.</li>
    <li><strong>Odstotek</strong>: največji možen odstotek, ki ga lahko uporabnik doseže v vseh sejah.</li>
    </ul>';
$string['maxpossiblepercentage'] = 'Najvišji možen odstotek';
$string['maxpossiblepoints'] = 'Najvišje možno število točk';
$string['maxwarn'] = 'Najvišje možno število e-sporočil z opozorili';
$string['maxwarn_help'] = 'Največje dovoljeno število opozoril (samo eno opozorilo na sejo)';
$string['mergeuser'] = 'Združi uporabnika';
$string['modulename'] = 'Prisotnost';
$string['modulename_help'] = 'Dejavnost Prisotnost omogoča izvajalcu beleženje in točkovanje prisotnosti na ustvarjenih sejah. Evidenco prisotnosti spremljajo tudi udeleženci.

Izvajalec ustvari eno ali večkratne seje in za prisotnost na le-teh udeležencem določi privzete statuse kot so "prisoten", "izostanek", "zamuda" in "opravičilo". Pripraviti je možno tudi statuse po meri.

Za potrebe spremljanja udeležencev so na voljo poročila o prisotnosti za vse sodelujoče skupine ali izbrane posameznike.';
$string['modulenameplural'] = 'Prisotnosti';
$string['months'] = 'Meseci';
$string['moreattendance'] = 'Prisotnost na strani je uspešno zabeležena';
$string['moveleft'] = 'Premakni levo';
$string['moveright'] = 'Premakni desno';
$string['multisessionexpanded'] = 'Večkratne seje razširjene';
$string['multisessionexpanded_desc'] = 'Pri ustvarjanju novih sej prikaži nastavitve večkratnih sej (razširjeno kot privzeto možnost).';
$string['mustselectusers'] = 'Potrebno je izbrati udeležence za izvoz';
$string['newdate'] = 'Nov datum';
$string['newduration'] = 'Novo trajanje';
$string['newstatusset'] = 'Nov nabor statusov';
$string['noabsentstatusset'] = 'Manjka dodeljen status za samodejno določitev vrednosti pri neoznačenih prisotnostih.';
$string['noattendanceusers'] = 'Podatkov ni mogoče izvoziti, saj v predmet ni vpisanih udeležencev.';
$string['noattforuser'] = 'Za udeleženca ni zapisov o prisotnosti';
$string['noautomark'] = 'Onemogočeno';
$string['nodescription'] = 'Redna seja';
$string['noeventstoreset'] = 'V koledarju ni dogodkov, ki bi zahtevali posodobitev.';
$string['nogroups'] = 'Ni mogoče dodati skupinske seje, saj v predmetu ni ustvarjenih skupin.';
$string['noguest'] = 'Gostom je ogled prisotnosti onemogočen.';
$string['noofdaysabsent'] = 'Število dni izostanka';
$string['noofdaysexcused'] = 'Število opravičenih dni';
$string['noofdayslate'] = 'Število dni zamud';
$string['noofdayspresent'] = 'Število dni prisotnosti';
$string['nosessiondayselected'] = 'Ni izbranega dneva seje';
$string['nosessionexists'] = 'V tem predmetu ni ustvarjenih sej';
$string['nosessionsselected'] = 'Ni izbranih sej';
$string['notfound'] = 'Aktivnosti za beleženje prisotnosti ni mogoče najti v tem predmetu!';
$string['notifytask'] = 'Udeležencem pošlji opozorila';
$string['numsessions'] = 'Število sej';
$string['olddate'] = 'Star datum';
$string['onlyselectedusers'] = 'Izvozi informacije izbranih udeležencev';
$string['overallsessions'] = 'Vse seje';
$string['overallsessions_help'] = 'Prikaže statistiko vseh sej, vključno s tistimi, ki še niso bili izvedene (pretekle in prihodnje):
    <ul>
    <li><strong>Seje</strong>: skupno število sej.</li>
    <li><strong>Točke</strong>: točke, podeljene na podlagi izvedenih sej.</li>
    <li><strong>Odstotek</strong>: odstotek točk, podeljen na podlagi najvišjega možnega števila točk za vse seje.</li>
    </ul>';
$string['oversessionstaken'] = 'Izvedene seje';
$string['oversessionstaken_help'] = 'Prikaže statistiko izvedenih sej:
    <ul>
    <li><strong>Seje</strong>: skupno število izvedenih sej.</li>
    <li><strong>Točke</strong>: točke, podeljene na podlagi izvedenih sej.</li>
    <li><strong>Odstotek</strong>: odstotek točk, podeljen na podlagi najvišjega možnega števila točk za izvedene seje.</li>
    </ul>';
$string['participant'] = 'Udeleženec';
$string['password'] = 'Geslo';
$string['passwordgrp'] = 'Geslo za udeležence';
$string['passwordgrp_help'] = 'Če je možnost omogočena, bodo morali udeleženci vnesti geslo, preden bodo lahko samostojno zabeležili prisotnost na seji. Če je polje prazno, gesla ni potrebno vnesti.';
$string['passwordrequired'] = 'Pred oddajo prisotnosti je potrebno vpisati geslo seje.';
$string['percentage'] = 'Odstotek';
$string['percentageallsessions'] = 'Odstotek vseh sej';
$string['percentagesessionscompleted'] = 'Odstotek izvedenih sej';
$string['pluginadministration'] = 'Administracija modula Prisotnost';
$string['pluginname'] = 'Prisotnost';
$string['points'] = 'Točke';
$string['pointsallsessions'] = 'Točke vseh sej';
$string['pointssessionscompleted'] = 'Točke izvedenih sej';
$string['preferences_desc'] = 'Sprememba nastavitev statusov bo vplivala tudi na obstoječe seje in lahko spremeni točke za prisotnost udeležencev.';
$string['preventsharederror'] = 'Samostojno beleženje prisotnosti v seji je onemogočeno, saj je bila ta naprava zaznana v povezavi s potrjevanjem prisotnosti drugega udeleženca.';
$string['preventsharedip'] = 'Udeležencem prepreči deljenje IP naslova';
$string['preventsharedip_help'] = 'Nastavitev udeležencem prepreči uporabo iste naprave (identificirano z uporabo naslova IP), tako da bi na primer posameznik potrdil še prisotnost za drugo osebo.';
$string['preventsharediptime'] = 'Čas do ponovne uporabe IP naslova (v minutah)';
$string['preventsharediptime_help'] = 'Čas, po katerem je spet dovoljeno ponovno uporabiti IP naslov v izbrani seji.';
$string['priorto'] = 'Izbran datum seje je pred datumom začetka predmeta ({$a}), zato bo načrtovana seja(e) razvrščena med skrite seje, ki niso dostopne. Datum začetka predmeta lahko sicer spremenite kadarkoli (v levem meniju pod Uredi nastavitve), s čimer pridobite dostop do prejšnjih sej.<br><br>Prosimo, spremenite datum izbrane seje ali pa za potrditev znova kliknite gumb "Dodaj sejo".';
$string['privacy:metadata:attendancelog'] = 'Dnevnik z zapisi prisotnosti uporabnika.';
$string['privacy:metadata:attendancesessions'] = 'Seje, na katerih bo zabeležena prisotnost.';
$string['privacy:metadata:attendancewarningdone'] = 'Dnevnik poslanih opozoril v zvezi z zapisi prisotnosti uporabnika.';
$string['privacy:metadata:duration'] = 'Trajanje seje v sekundah';
$string['privacy:metadata:groupid'] = 'S sejo povezan ID skupine.';
$string['privacy:metadata:ipaddress'] = 'IP naslov, s katerega je bila zabeležena prisotnost.';
$string['privacy:metadata:lasttaken'] = 'Časovni žig, ko se je v seji nazadnje preverjala prisotnost.';
$string['privacy:metadata:lasttakenby'] = 'ID uporabnika, ki je zadnji označil prisotnost';
$string['privacy:metadata:notifyid'] = 'ID seje, s katero je povezano opozorilo o prisotnosti.';
$string['privacy:metadata:remarks'] = 'Komentarji na udeleženčevo prisotnost.';
$string['privacy:metadata:sessdate'] = 'Časovni žig začetka seje.';
$string['privacy:metadata:sessionid'] = 'ID seje prisotnosti.';
$string['privacy:metadata:statusid'] = 'ID statusa prisotnosti udeleženca';
$string['privacy:metadata:statusset'] = 'Nabor statusa s pripadajočo ID.';
$string['privacy:metadata:studentid'] = 'ID udeleženca, ki je zabeležil prisotnost.';
$string['privacy:metadata:takenby'] = 'ID uporabnika, ki je zabeležil prisotnost za drugega udeleženca.';
$string['privacy:metadata:timemodified'] = 'Časovni žig zadnje posodobitve seje.';
$string['privacy:metadata:timesent'] = 'Časovni žig, ko je bilo poslano opozorilo.';
$string['privacy:metadata:timetaken'] = 'Časovni žig, ko je bila zabeležena prisotnost udeleženca.';
$string['privacy:metadata:userid'] = 'ID uporabnika, ki mu bo poslano opozorilo.';
$string['processingfile'] = 'Obdelava datoteke';
$string['qr_cookie_error'] = 'QR koda za sejo je potekla.';
$string['qr_pass_wrong'] = 'QR geslo je napačno ali je poteklo.';
$string['qrcode'] = 'QR koda';
$string['randompassword'] = 'Naključno geslo';
$string['remark'] = 'Pripomba za: {$a}';
$string['remarks'] = 'Pripombe';
$string['repeatasfollows'] = 'Ponovi zgornjo sejo na naslednji način';
$string['repeatevery'] = 'Ponovi vsak';
$string['repeaton'] = 'Ponovi v';
$string['repeatuntil'] = 'Ponavljaj do';
$string['report'] = 'Poročilo';
$string['required'] = 'Zahtevano*';
$string['requiredentries'] = 'Začasni zapisi lahko prepišejo zapise o prisotnosti udeležencev';
$string['requiredentry'] = 'Vodič za združitev začasnih uporabnikov';
$string['requiredentry_help'] = '<p align="center"><b>Prisotnost</b></p>
<p align="left"><strong>Združi račune</strong></p>
<p align="left">
<table border="2" cellpadding="4">
<tr>
<th>Moodlov udeleženec</th>
<th>Začasni uporabnik</th>
<th>Dejanje</th>
</tr>
<tr>
<td>Podatki o prisotnosti</td>
<td>Podatki o prisotnosti</td>
<td>Podatki začasnega uporabnika prepišejo podatke Moodlovega udeleženca</td>
</tr>
<tr>
<td>Ni podatkov</td>
<td>Podatki o prisotnosti</td>
<td>Podatki o prisotnosti začasnega uporabnika se prenesejo k Moodlovemu udeležencu</td>
</tr>
<tr>
<td>Podatki o prisotnosti</td>
<td>Ni podatkov</td>
<td>Začasni uporabnik bo izbrisan</td>
</tr>
<tr>
<td>Ni podatkov</td>
<td>Ni podatkov</td>
<td>Začasni uporabnik bo izbrisan</td>
</tr>
</table>

</p>
<p align="left"><strong>Začasni uporabnik bo izbrisan v vseh primerih združevanja uporabnikov.</strong></p>';
$string['requiresubnet'] = 'Zahtevan je naslov omrežja';
$string['requiresubnet_help'] = 'Beleženje prisotnosti je lahko omejeno na podomrežja, ki so določena na seznamu
(z vejico ločenih) delnih ali celotnih IP naslovov.';
$string['resetcaledarcreate'] = 'Dogodki v koledarju so omogočeni, kljub temu pa številne obstoječe seje niso vpisane mednje. Ali želite v koledarju ustvariti dogodke za vse obstoječe seje?';
$string['resetcaledardelete'] = 'Dogodki v koledarju so onemogočeni, kljub temu pa imajo številne obstoječe seje še vedno vpisane dogodke, ki bi morali biti izbrisani. Ali želite v koledarju izbrisati vse obstoječe dogodke?';
$string['resetcalendar'] = 'Ponastavi koledar';
$string['resetdescription'] = 'Brisanje podatkov o prisotnosti bo izbrisalo podatke iz zbirke. Stare seje lahko skrijete, če spremenite datum začetka predmeta!';
$string['resetstatuses'] = 'Ponastavi statuse na privzete';
$string['restoredefaults'] = 'Obnovi privzeto';
$string['resultsperpage'] = 'Rezultatov na stran';
$string['resultsperpage_desc'] = 'Število prikazanih udeležencev na stran';
$string['rotateqrcode'] = 'Menjava QR kode';
$string['rotateqrcode_cleartemppass_task'] = 'Počisti začasna gesla, ki jih ustvari funkcija vrtenja QR kode.';
$string['rotateqrcodeexpirymargin'] = 'Mejni čas (v sekundah) za vrtenje QR kode oz. iztek gesla';
$string['rotateqrcodeexpirymargin_desc'] = 'Časovni interval (v sekundah) za uporabo pretekle QR kode oz. gesla.';
$string['rotateqrcodeinterval'] = 'Čas (v sekundah) za vrtenje QR kode oz. zamenjavo gesla';
$string['rotateqrcodeinterval_desc'] = 'Časovni interval (v sekundah) za vrtenje QR kode oz. zamenjavo gesla.';
$string['save'] = 'Shrani prisotnost';
$string['search:activity'] = 'Prisotnost – informacije o dejavnosti';
$string['session'] = 'Seja';
$string['session_help'] = 'Seja';
$string['sessionadded'] = 'Seja uspešno dodana';
$string['sessionalreadyexists'] = 'Seja za izbran datum že obstaja';
$string['sessiondate'] = 'Datum';
$string['sessiondays'] = 'Sejni dnevi';
$string['sessiondeleted'] = 'Seja uspešno izbrisana';
$string['sessionduplicate'] = 'Za ({$a->course}) je zaznan duplikat seje: {$a->activity}';
$string['sessionexist'] = 'Seja ni bila dodana, saj že obstaja.';
$string['sessiongenerated'] = 'Seja je bila uspešno ustvarjena.';
$string['sessions'] = 'Seje';
$string['sessionscompleted'] = 'Izvedene seje';
$string['sessionsgenerated'] = 'Uspešno dodane seje: {$a}';
$string['sessionsids'] = 'ID številke sej:';
$string['sessionsnotfound'] = 'V izbranem časovnem obdobju ni sej';
$string['sessionstartdate'] = 'Datum začetka seje';
$string['sessionstotal'] = 'Skupno število sej';
$string['sessiontype'] = 'Vrsta';
$string['sessiontype_help'] = 'Seje se lahko dodajajo za vse udeležence ali za izbrane skupine udeležencev. Pravica za dodajanje različnih vrst sej je odvisna od nastavitev skupinskega dela:

* V načinu "Brez skupin" se lahko dodaja zgolj seje za vse udeležence.
* V načinu "Ločene skupine" se lahko dodaja zgolj seje za skupine udeležencev.
* V načinu "Vidne skupine" se lahko dodajata obe vrsti sej.';
$string['sessiontypeshort'] = 'Vrsta';
$string['sessionunknowngroup'] = 'Seja navaja neznano skupino(e): {$a}';
$string['sessionupdated'] = 'Seja uspešno posodobljena';
$string['set_by_student'] = 'zabeleženo samostojno';
$string['setallstatuses'] = 'Nastavi status za';
$string['setallstatusesto'] = 'Nastavi status na «{$a}»';
$string['setperiod'] = 'V minutah določen čas do sprostitve IP naslova';
$string['settings'] = 'Nastavitve';
$string['setunmarked'] = 'Samodejno izpolni za neoznačene';
$string['setunmarked_help'] = 'Če je v seji omogočena možnost "Na koncu seje nastavi kot neoznačeno", se udeležencem, ki prisotnosti niso potrdili samostojno, samodejno zapiše izbrana vrednost.';
$string['showdefaults'] = 'Prikaži privzete nastavitve';
$string['showduration'] = 'Prikaži trajanje';
$string['showextrauserdetails'] = 'Pokaži podrobnosti o uporabniku';
$string['showqrcode'] = 'Pokaži QR kodo';
$string['showsessiondescriptiononreport'] = 'Pokaži opis seje v poročilu';
$string['showsessiondescriptiononreport_desc'] = 'Prikaži opis seje v seznamu poročil o prisotnosti.';
$string['showsessiondetails'] = 'Pokaži podrobnosti seje';
$string['somedisabledstatus'] = '(S pričetkom seje so bile nekatere možnosti odstranjene.)';
$string['sortedgrid'] = 'Razvrščena mreža';
$string['sortedlist'] = 'Razvrščen seznam';
$string['startofperiod'] = 'Začetek obdobja';
$string['starttime'] = 'Čas začetka';
$string['status'] = 'Status';
$string['statusall'] = 'vsi';
$string['statusdeleted'] = 'Status izbrisan';
$string['statuses'] = 'Statusi';
$string['statusset'] = 'Nastavitev statusa {$a}';
$string['statussetsettings'] = 'Nastavitev statusa';
$string['statusunselected'] = 'neizbrano';
$string['strftimedm'] = '%d. %b';
$string['strftimedmw'] = '<nobr>%a %d. %b</nobr>';
$string['strftimedmy'] = '%d. %b %Y';
$string['strftimedmyhm'] = '%d. %b %Y %H.%M';
$string['strftimedmyw'] = '<nobr>%a %d. %b %Y</nobr>';
$string['strftimeh'] = '%H';
$string['strftimehm'] = '%H:%M';
$string['strftimeshortdate'] = '%d.%m.%Y';
$string['studentid'] = 'ID udeleženca';
$string['studentmarked'] = 'Prisotnost v tej seji je zabeležena.';
$string['studentmarking'] = 'Zapis udeleženca';
$string['studentpassword'] = 'Geslo za udeležence';
$string['studentrecordingexpanded'] = 'Razširjen zapis udeleženca';
$string['studentrecordingexpanded_desc'] = 'Pri ustvarjanju novih sej prikaži nastavitve za zapis udeležencev, privzeto razširjeno.';
$string['studentscanmark'] = 'Udeležencem omogoči samostojno beleženje prisotnosti';
$string['studentscanmark_desc'] = 'Če je možnost omogočena, lahko izvajalci dovolijo udeležencem samostojno beleženje prisotnosti.';
$string['studentscanmark_help'] = 'Če je možnost omogočena, lahko udeleženci spremenijo svoj status prisotnosti za sejo.';
$string['studentscanmarksessiontime'] = 'Udeleženci zabeležijo prisotnost med trajanjem seje';
$string['studentscanmarksessiontime_desc'] = 'Če je možnost omogočena, lahko udeleženci zabeležijo prisotnost le med trajanjem seje.';
$string['studentscanmarksessiontimeend'] = 'Zaključek seje (v minutah)';
$string['studentscanmarksessiontimeend_desc'] = 'Nastavitev časa (v minutah) za označitev prisotnosti, če seja nima nastavljenega časa zaključka.';
$string['submitattendance'] = 'Oddaj prisotnost';
$string['subnet'] = 'Podomrežje';
$string['subnetactivitylevel'] = 'Dovoli konfiguracijo podomrežja na ravni dejavnosti';
$string['subnetactivitylevel_desc'] = 'Če je možnost omogočena, lahko izvajalci ob ustvarjanju dejavnosti preglasijo privzete nastavitve podomrežja. V nasprotnem primeru se pri ustvarjanju seje uporabi privzete nastavitve spletnega mesta.';
$string['subnetwrong'] = 'Prisotnost se lahko zabeleži le z izbranih lokacij. Ta naprava ni na seznamu dovoljenih.';
$string['summary'] = 'Povzetek';
$string['tactions'] = 'Dejanje';
$string['takeattendance'] = 'Označi prisotnost';
$string['takensessions'] = 'Označene seje';
$string['tcreated'] = 'Ustvarjeno';
$string['tempaddform'] = 'Dodaj začasnega uporabika';
$string['tempexists'] = 'Začasni uporabnik s tem e-naslovom že obstaja';
$string['temptable'] = 'Seznam začasnih uporabnikov';
$string['tempuser'] = 'Začasni uporabnik';
$string['tempusermerge'] = 'Združi začasnega uporabnika';
$string['tempusers'] = 'Začasni uporabniki';
$string['tempusersedit'] = 'Uredi začasnega uporabnika';
$string['tempuserslist'] = 'Začasni uporabniki';
$string['thirdpartyemails'] = 'Obvesti ostale uporabnike';
$string['thirdpartyemails_help'] = 'Seznam drugih uporabnikov, ki bodo obveščeni. (zahtevan je mod/attendance:viewreports)';
$string['thirdpartyemailsubject'] = 'Opozorilo o prisotnosti';
$string['thirdpartyemailtext'] = '{$a->firstname} {$a->lastname} prisotnost v {$a->coursename} {$a->aname} je nižja od {$a->warningpercent} ({$a->percent})';
$string['thirdpartyemailtextfooter'] = 'To sporočilo je bilo poslano, ker je izvajalec predmeta dodal tvoj e-poštni naslov na seznam prejemnikov';
$string['thiscourse'] = 'Ta predmet';
$string['time'] = 'Ura';
$string['timeahead'] = 'Večkratnih sej, ki presegajo obdobje enega leta, ni mogoče ustvariti. Potrebno je prilagoditi datum začetka in zaključka seje.';
$string['to'] = 'do:';
$string['triggered'] = 'Prvo obvestilo';
$string['tuseremail'] = 'E-naslov';
$string['tusername'] = 'Celotno ime';
$string['ungraded'] = 'Neocenjene seje';
$string['unknowngroup'] = 'Neznana skupina';
$string['update'] = 'Posodobi';
$string['usedefaultsubnet'] = 'Uporabi privzeto';
$string['usemessageform'] = 'ali uporabi spodnji obrazec za pošiljanje sporočila izbranim udeležencem';
$string['userexists'] = 'Uporabnik s tem e-naslovom že obstaja';
$string['users'] = 'Udeleženci za izvoz';
$string['usestatusset'] = 'Nabor statusov';
$string['variable'] = 'spremenljivka';
$string['variablesupdated'] = 'Spremenljivke uspešno posodobljene';
$string['versionforprinting'] = 'različica za tisk';
$string['viewmode'] = 'Način pogleda';
$string['warnafter'] = 'Število udeležb na sejah pred opozorilom';
$string['warnafter_help'] = 'Opozorila se bodo sprožila šele, ko se bo udeleženec udeležil vsaj tega števila sej.';
$string['warningdeleted'] = 'Opozorilo izbrisano';
$string['warningdesc'] = 'Ta opozorila bodo samodejno dodana novim dejavnostim s prisotnostjo. Če se hkrati sproži več kot eno opozorilo, bo poslano samo opozorilo z nižjim pragom opozorila.';
$string['warningdesc_course'] = 'Tukaj postavljeni opozorilni pragi vplivajo na poročilo o izostanku ter omogočajo obveščanje udeležencev in tretjih oseb. Če se hkrati sproži več kot eno opozorilo, bo poslano samo opozorilo z nižjim pragom opozorila.';
$string['warningfailed'] = 'Ni možno ustvariti opozorila, ki uporablja enak odstotek in število sej.';
$string['warningpercent'] = 'Opozori, če odstotek pade pod';
$string['warningpercent_help'] = 'Opozorilo bo poslano, ko odstotek skupne prisotnosti pade pod to vrednost.';
$string['warnings'] = 'Opozorilo nastavljeno';
$string['warningthreshold'] = 'Prag opozorila';
$string['warningupdated'] = 'Posodobljena opozorila';
$string['week'] = 'Teden(i)';
$string['weeks'] = 'Tedni';
