<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'plugin', language 'lo', version '4.2'.
 *
 * @package     plugin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'ການປະຕິບັດ';
$string['availability'] = 'ການມີໃຫ້';
$string['cancelinstallall'] = 'ຍົກເລີກການຕິດຕັ້ງ ({$a}) ໃໝ່';
$string['cancelinstallhead'] = 'ການຍົກເລີກການຕິດຕັ້ງຂອງປລັກອິນ';
$string['cancelinstallinfo'] = 'ປລັກອິນຕໍ່ໄປນີ້ ຍັງບໍ່ໄດ້ຕິດຕັ້ງຢ່າງຄົບຖ້ວນເທື່ອ, ດັ່ງນັ້ນ ການຕິດຕັ້ງຂອງພວກມັນອາດຈະຖືກຍົກເລີກ. ເພື່ອເຮັດສິ່ງນີ້, ໂຟນເດີປລັກອິນ ຕ້ອງຖືກລຶບອອກຈາກເຊີເວີໃນປັດຈຸບັນ. ໃຫ້ແນ່ໃຈວ່າ ນີ້ແມ່ນສິ່ງທີ່ທ່ານຕ້ອງການເພື່ອປ້ອງກັນການສູນເສຍຂໍ້ມູນໂດຍບັງເອີນ (ເຊັ່ນ: ການດັດແກ້ລະຫັດຂອງທ່ານເອງ).';
$string['cancelinstallinfodir'] = 'ໂຟນເດີທີ່ຈະຖືກລຶບ: {$a}';
$string['cancelinstallone'] = 'ຍົກເລີກການຕິດຕັ້ງນີ້';
$string['cancelupgradeall'] = 'ຍົກເລີກການຍົກລະດັບ';
$string['cancelupgradehead'] = 'ຟື້ນຟູສະບັບກ່ອນໜ້າຂອງປລັກອິນ';
$string['cancelupgradeone'] = 'ຍົກເລີກການຍົກລະດັບ';
$string['checkforupdates'] = 'ກວດສອບສຳລັບການປັບປຸງທີ່ມີໃຫ້';
$string['checkforupdateslast'] = 'ການກວດສອບສຳເລັດຫຼ້າສຸດໃນ {$a}';
$string['dependencyavailable'] = 'ມີໃຫ້';
$string['dependencyfails'] = 'ລົ້ມເຫຼວ';
$string['dependencyinstall'] = 'ຕິດຕັ້ງ';
$string['dependencyinstallhead'] = 'ການຕິດຕັ້ງຂາດຫາຍການເພິ່ງພາອາໄສ';
$string['dependencyinstallmissing'] = 'ການຕິດຕັ້ງຂາດຫາຍການເພິ່ງພາອາໄສ ({$a})';
$string['dependencymissing'] = 'ຂາດຫາຍ';
$string['dependencyunavailable'] = 'ບໍ່ມີໃຫ້';
$string['dependencyupload'] = 'ອັບໂຫຼດ';
$string['dependencyuploadmissing'] = 'ອັບໂຫຼດໄຟລ໌ ZIP';
$string['detectedmisplacedplugin'] = 'ປລັກອິນ "{$a->component}" ຖືກຕິດຕັ້ງໃນສະຖານທີ່ບໍ່ຖືກຕ້ອງ "{$a->current}", ສະຖານທີ່ທີ່ຄາດການໄວ້ແມ່ນ "{$a->expected}"';
$string['displayname'] = 'ຊື່ປລັກອິນ';
$string['err_response_curl'] = 'ບໍ່ສາມາດດຶງຂໍ້ມູນການປັບປຸງທີ່ມີຢູ່ໄດ້ - ຄວາມຜິດພາດ cURL ທີ່ບໍ່ຄາດຄິດ.';
$string['err_response_format_version'] = 'ຮູບແບບການຕອບໂຕ້ສະບັບທີ່ບໍ່ຄາດຄິດ. ກະລຸນາລອງກວດເບິ່ງການປັບປຸງໃໝ່.';
$string['err_response_http_code'] = 'ບໍ່ສາມາດດຶງຂໍ້ມູນການອັບເດດທີ່ມີຢູ່ໄດ້ - ລະຫັດຕອບຮັບ HTTP ທີ່ບໍ່ຄາດຄິດ.';
$string['filterall'] = 'ສະແດງທັງໝົດ';
$string['filtercontribonly'] = 'ສະແດງປລັກອິນເພີ່ມເຕີມເທົ່ານັ້ນ';
$string['filterupdatesonly'] = 'ສະແດງພຽງແຕ່ທີ່ສາມາດປັບປຸງໄດ້';
$string['incompatibleversion'] = 'ສະບັບ Moodle ທີ່ບໍ່ເຂົ້າກັນ: {$a}';
$string['isenabled'] = 'ເປີດໃຊ້ງານບໍ?';
$string['misdepinfoplugin'] = 'ຂໍ້ມູນປລັກອິນ';
$string['misdepinfoversion'] = 'ຂໍ້ມູນສະບັບ';
$string['misdepsavail'] = 'ການເພິ່ງພາອາໄສທີ່ຂາດຫາຍໄປທີ່ມີໃຫ້';
$string['misdepsunavail'] = 'ການເພິ່ງພາອາໄສທີ່ຂາດຫາຍໄປທີ່ບໍ່ມີໃຫ້';
$string['misdepsunavaillist'] = 'ບໍ່ພົບສະບັບໃດເພື່ອຕອບສະໜອງຄວາມຕ້ອງການການເພິ່ງພາອາໄສ: {$a}.';
$string['misdepsunknownlist'] = 'ບໍ່ມີບັນຊີລາຍການປລັກອິນ: <strong>{$a}</strong>.';
$string['moodlebranch'] = 'Moodle {$a->min} - {$a->max}';
$string['moodleversion'] = 'Moodle {$a}';
$string['noneinstalled'] = 'ບໍ່ມີປລັກອິນຂອງປະເພດນີ້ຖືກຕິດຕັ້ງ';
$string['notdownloadable'] = 'ບໍ່ສາມາດດາວໂຫຼດແພັກເກດ';
$string['notdownloadable_help'] = 'ແພັກເກດ ZIP ທີ່ມີການປັບປຸງບໍ່ສາມາດດາວໂຫຼດໄດ້ໂດຍອັດຕະໂນມັດ.';
$string['notdownloadable_link'] = 'admin/mdeploy/notdownloadable';
$string['notes'] = 'ບັນທຶກ';
$string['notsupported'] = 'ປລັກອິນອາດຈະບໍ່ເຂົ້າກັນກັບສະບັບ Moodle {$a}';
$string['notwritable'] = 'ໄຟລ໌ປລັກອິນບໍ່ສາມາດຂຽນໄດ້';
$string['notwritable_help'] = 'ໄຟລ໌ປລັກອິນບໍ່ສາມາດຂຽນໄດ້ໂດຍເຊີບເວີເວັບ. ຂະບວນການຂອງເຊີເວີເວັບໄຊທ໌ຕ້ອງມີການເຂົ້າເຖິງການຂຽນໄປຫາໂຟນເດີປລັກອິນ ແລະ ເນື້ອຫາທັງໝົດຂອງມັນ. ການຂຽນການເຂົ້າເຖິງໂຟນເດີຮາກຂອງປະເພດປລັກອິນທີ່ໃຫ້ມາອາດຈະຕ້ອງການ.';
$string['otherplugin'] = '{$a->component}';
$string['otherpluginversion'] = '{$a->component} ({$a->version})';
$string['overviewall'] = 'ປລັກອິນທັງໝົດ';
$string['overviewext'] = 'ປລັກອິນເພີ່ມເຕີມ';
$string['overviewupdatable'] = 'ການປັບປຸງທີ່ມີໃຫ້';
$string['packagesdebug'] = 'ເປີດໃຊ້ການດີບັກຜົນອອກແລ້ວ';
$string['packagesdownloading'] = 'ກຳລັງດາວໂຫຼດ {$a}';
$string['packagesextracting'] = 'ກຳລັງແຍກ {$a}';
$string['packagesvalidating'] = 'ກຳລັງຢືນຢັນ {$a}';
$string['packagesvalidatingfailed'] = 'ການຕິດຕັ້ງຖືກຍົກເລີກເນື່ອງຈາກຄວາມລົ້ມເຫຼວໃນການກວດສອບ';
$string['packagesvalidatingok'] = 'ການກວດສອບສຳເລັດແລ້ວ, ການຕິດຕັ້ງສາມາດສືບຕໍ່ໄດ້';
$string['plugincheckall'] = 'ປລັກອິນທັງໝົດ';
$string['plugincheckattention'] = 'ປລັກອິນທີ່ຕ້ອງການຄວາມສົນໃຈ';
$string['pluginchecknone'] = 'ບໍ່ມີປລັກອິນທີ່ຕ້ອງການຄວາມສົນໃຈໃນຕອນນີ້';
$string['pluginchecknotice'] = 'ໜ້ານີ້ສະແດງປລັກອິນທີ່ອາດຈະຕ້ອງການຄວາມສົນໃຈຂອງທ່ານໃນລະຫວ່າງການຍົກລະດັບ ເຊັ່ນ: ປລັກອິນໃໝ່ທີ່ຈະຕິດຕັ້ງ, ປລັກອິນທີ່ຈະຍົກລະດັບ, ປລັກອິນທີ່ຂາດຫາຍໄປ ແລະ ອື່ນໆ. ປລັກອິນເພີ່ມເຕີມຈະສະແດງຖ້າມີການປັບປຸງໃຫ້ກັບພວກມັນ. ຂໍແນະນຳໃຫ້ທ່ານກວດເບິ່ງວ່າ ມີປລັກອິນລຸ້ນລ້າສຸດທີ່ມີຢູ່ຫຼືບໍ່ ແລະ ປັບປຸງລະຫັດແຫຼ່ງຂອງມັນກ່ອນທີ່ຈະສືບຕໍ່ການຍົກລະດັບ Moodle ນີ້.';
$string['plugindisable'] = 'ປິດໃຊ້ງານ';
$string['plugindisabled'] = 'ປິດໃຊ້ງານແລ້ວ';
$string['pluginenable'] = 'ເປີດໃຊ້ງານ';
$string['pluginenabled'] = 'ເປີດໃຊ້ງານແລ້ວ';
$string['release'] = 'ປົດປ່ອຍ';
$string['requiredby'] = 'ຕ້ອງການໂດຍ: {$a}';
$string['requires'] = 'ຕ້ອງການ';
$string['rootdir'] = 'ບັນຊີລາຍການ';
$string['settings'] = 'ການຕັ້ງຄ່າ';
$string['source'] = 'ແຫຼ່ງຂໍ້ມູນ';
$string['sourceext'] = 'ເພີ່ມຕື່ມ';
$string['sourcestd'] = 'ມາດຕະຖານ';
$string['status'] = 'ສະຖານະ';
$string['status_delete'] = 'ຈະຖືກລຶບ';
$string['status_downgrade'] = 'ສະບັບທີ່ສູງກວ່າຖືກຕິດຕັ້ງແລ້ວ!';
$string['status_missing'] = 'ສູນເສຍຈາກແຜ່ນດີສກ໌!';
$string['status_new'] = 'ຈະຖືກຕິດຕັ້ງ';
$string['status_nodb'] = 'ບໍ່ມີຖານຂໍ້ມູນ';
$string['status_upgrade'] = 'ຈະຖືກອັບເກຼດ';
$string['status_uptodate'] = 'ຕິດຕັ້ງແລ້ວ';
$string['supportedconversions'] = 'ປ່ຽນເອກະສານທີ່ຮອງຮັບ';
$string['supportedmoodleversions'] = 'ສະບັບ Moodle ທີ່ຮອງຮັບ';
$string['systemname'] = 'ຕົວລະບຸ';
$string['type_antivirus'] = 'ປລັກອິນຕ້ານໄວຣັສ';
$string['type_antivirus_plural'] = 'ປລັກອິນຕ້ານໄວຣັສ';
$string['type_auth'] = 'ວິທີການກວດສອບຄວາມຖືກຕ້ອງ';
$string['type_auth_plural'] = 'ວິທີການກວດສອບຄວາມຖືກຕ້ອງ';
$string['type_availability'] = 'ຂໍ້ຈຳກັດທີ່ມີໃຫ້';
$string['type_availability_plural'] = 'ຂໍ້ຈຳກັດທີ່ມີໃຫ້';
$string['type_block'] = 'ບລັອກ';
$string['type_block_plural'] = 'ບລັອກ';
$string['type_cachelock'] = 'ຕົວຈັດການລັອກແຄດ';
$string['type_cachelock_plural'] = 'ຕົວຈັດການລັອກແຄດ';
$string['type_cachestore'] = 'ເກັບຮັກສາແຄດ';
$string['type_cachestore_plural'] = 'ເກັບຮັກສາແຄດ';
$string['type_calendartype'] = 'ປະເພດປະຕິທິນ';
$string['type_calendartype_plural'] = 'ປະເພດປະຕິທິນ';
$string['type_contentbank'] = 'ທະນາຄານເນື້ອຫາ';
$string['type_contentbank_plural'] = 'ປລັກອິນທະນາຄານເນື້ອຫາ';
$string['type_contenttype'] = 'ທະນາຄານເນື້ອຫາ';
$string['type_contenttype_plural'] = 'ປລັກອິນທະນາຄານເນື້ອຫາ';
$string['type_coursereport'] = 'ລາຍງານລາຍວິຊາ';
$string['type_coursereport_plural'] = 'ລາຍງານລາຍວິຊາ';
$string['type_customfield'] = 'ຊ່ອງຂໍ້ມູນກຳນົດເອງ';
$string['type_customfield_plural'] = 'ຊ່ອງຂໍ້ມູນກຳນົດເອງ';
$string['type_dataformat'] = 'ຮູບແບບຂໍ້ມູນ';
$string['type_dataformat_plural'] = 'ຮູບແບບຂໍ້ມູນ';
$string['type_editor'] = 'ຕົວແກ້ໄຂ';
$string['type_editor_plural'] = 'ຕົວແກ້ໄຂ';
$string['type_enrol'] = 'ວິທີການລົງທະບຽນຮຽນ';
$string['type_enrol_plural'] = 'ວິທີການລົງທະບຽນຮຽນ';
$string['type_fileconverter'] = 'ຕົວປ່ຽນເອກະສານ';
$string['type_fileconverter_plural'] = 'ຕົວປ່ຽນເອກະສານ';
$string['type_fileconvertermanage'] = 'ຈັດການຕົວປ່ຽນເອກະສານ';
$string['type_filter'] = 'ຕົວກັ່ນຕອງຂໍ້ຄວາມ';
$string['type_filter_plural'] = 'ຕົວກັ່ນຕອງຂໍ້ຄວາມ';
$string['type_format'] = 'ຮູບແບບລາຍວິຊາ';
$string['type_format_plural'] = 'ຮູບແບບລາຍວິຊາ';
$string['type_gradeexport'] = 'ວິທີການສົ່ງອອກຄະແນນ';
$string['type_gradeexport_plural'] = 'ວິທີການສົ່ງອອກຄະແນນ';
$string['type_gradeimport'] = 'ວິທີການນຳເຂົ້າຄະແນນ';
$string['type_gradeimport_plural'] = 'ວິທີການນຳເຂົ້າຄະແນນ';
$string['type_gradereport'] = 'ລາຍງານປື້ມຄະແນນ';
$string['type_gradereport_plural'] = 'ລາຍງານປື້ມຄະແນນ';
$string['type_gradingform'] = 'ວິທີການໃຫ້ຄະແນນຂັ້ນສູງ';
$string['type_gradingform_plural'] = 'ວິທີການໃຫ້ຄະແນນຂັ້ນສູງ';
$string['type_h5plib'] = 'ກອບວຽກ H5P';
$string['type_h5plib_plural'] = 'ກອບວຽກ H5P';
$string['type_local'] = 'ປລັກອິນໃນເຄື່ອງ';
$string['type_local_plural'] = 'ປລັກອິນໃນເຄື່ອງ';
$string['type_media'] = 'ເຄື່ອງຫຼິ້ນສື່';
$string['type_media_plural'] = 'ເຄື່ອງຫຼິ້ນສື່';
$string['type_message'] = 'ປລັກອິນການແຈ້ງເຕືອນ';
$string['type_message_plural'] = 'ປລັກອິນການແຈ້ງເຕືອນ';
$string['type_mlbackend'] = 'ເບື້ອງຫຼັງການຮຽນຮູ້ເຄື່ອງຈັກ';
$string['type_mlbackend_plural'] = 'ເບື້ອງຫຼັງການຮຽນຮູ້ເຄື່ອງຈັກ';
$string['type_mnetservice'] = 'ການບໍລິການ MNet';
$string['type_mnetservice_plural'] = 'ການບໍລິການ MNet';
$string['type_mod'] = 'ຊຸດກິດຈະກຳ';
$string['type_mod_plural'] = 'ຊຸດກິດຈະກຳ';
$string['type_paygw'] = 'ປະຕູການຊຳລະເງິນ';
$string['type_paygw_plural'] = 'ປະຕູການຊຳລະເງິນ';
$string['type_paygwmanage'] = 'ຈັດການປະຕູການຊຳລະເງິນ';
$string['type_plagiarism'] = 'ປລັກອິນການລອກຮຽນແບບ';
$string['type_plagiarism_plural'] = 'ປລັກອິນການລອກຮຽນແບບ';
$string['type_portfolio'] = 'ເອກະສານຜົນງານ';
$string['type_portfolio_plural'] = 'ເອກະສານຜົນງານ';
$string['type_profilefield'] = 'ປະເພດຊ່ອງຂໍ້ມູນໂປຼໄຟລ໌';
$string['type_profilefield_plural'] = 'ປະເພດຊ່ອງຂໍ້ມູນໂປຼໄຟລ໌';
$string['type_qbank'] = 'ປລັກອິນທະນາຄານຄຳຖາມ';
$string['type_qbank_plural'] = 'ປລັກອິນທະນາຄານຄຳຖາມ';
$string['type_qbehaviour'] = 'ພຶດຕິກຳຄຳຖາມ';
$string['type_qbehaviour_plural'] = 'ພຶດຕິກຳຄຳຖາມ';
$string['type_qformat'] = 'ຮູບແບບການນຳເຂົ້າ/ສົ່ງອອກຄຳຖາມ';
$string['type_qformat_plural'] = 'ຮູບແບບການນຳເຂົ້າ/ສົ່ງອອກຄຳຖາມ';
$string['type_qtype'] = 'ປະເພດຄຳຖາມ';
$string['type_qtype_plural'] = 'ປະເພດຄຳຖາມ';
$string['type_report'] = 'ລາຍງານເວັບໄຊທ໌';
$string['type_report_plural'] = 'ລາຍງານ';
$string['type_repository'] = 'ຄັງເກັບມ້ຽນ';
$string['type_repository_plural'] = 'ບ່ອນເກັບມ້ຽນ';
$string['type_search'] = 'ເຄື່ອງຈັກຄົ້ນຫາ';
$string['type_search_plural'] = 'ເຄື່ອງຈັກຄົ້ນຫາ';
$string['type_theme'] = 'ຮູບແບບສີສັນ';
$string['type_theme_plural'] = 'ຮູບແບບສີສັນ';
$string['type_tool'] = 'ເຄື່ອງມືບໍລິຫານ';
$string['type_tool_plural'] = 'ເຄື່ອງມືບໍລິຫານ';
$string['type_webservice'] = 'ລະບຽບການການບໍລິການເວັບ';
$string['type_webservice_plural'] = 'ລະບຽບການການບໍລິການເວັບ';
$string['uninstall'] = 'ຖອນການຕິດຕັ້ງ';
$string['uninstallconfirm'] = 'ທ່ານກຳລັງຈະຖອນການຕິດຕັ້ງປລັກອິນ <em>{$a->name}</em>. ນີ້ຈະລຶບທຸກຢ່າງໃນຖານຂໍ້ມູນທີ່ກ່ຽວຂ້ອງກັບປລັກອິນນີ້ຢ່າງສົມບູນ, ລວມທັງການຕັ້ງຄ່າຂອງມັນ, ບັນທຶກຂອງບັນທຶກ, ໄຟລ໌ຜູ້ໃຊ້ທີ່ຈັດການໂດຍປລັກອິນ ແລະອື່ນໆ. ບໍ່ມີທາງກັບຄືນ ແລະ Moodle ຕົວຂອງມັນເອງບໍ່ໄດ້ສ້າງການສໍາຮອງຂໍ້ມູນການຟື້ນຟູໃດໆ. ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການສືບຕໍ່?';
$string['uninstalldelete'] = 'ຂໍ້ມູນທັງໝົດທີ່ກ່ຽວຂ້ອງກັບປລັກອິນ <em>{$a->name}</em> ໄດ້ຖືກລຶບອອກຈາກຖານຂໍ້ມູນແລ້ວ. ເພື່ອປ້ອງກັນບໍ່ໃຫ້ປລັກອິນຕິດຕັ້ງຄືນໃໝ່ເອງ, ໂຟນເດີຂອງມັນ <em>{$a->rootdir}</em> ຕ້ອງຖືກເອົາອອກຈາກເຊີບເວີຂອງທ່ານດຽວນີ້. Moodle ຕົວຂອງມັນເອງບໍ່ສາມາດເອົາໂຟນເດີອອກໄດ້ເນື່ອງຈາກການອະນຸຍາດການຂຽນ.';
$string['uninstalldeleteconfirm'] = 'ຂໍ້ມູນທັງໝົດທີ່ກ່ຽວຂ້ອງກັບປລັກອິນ <em>{$a->name}</em> ໄດ້ຖືກລຶບອອກຈາກຖານຂໍ້ມູນແລ້ວ. ເພື່ອປ້ອງກັນບໍ່ໃຫ້ປລັກອິນຕິດຕັ້ງຄືນໃໝ່ເອງ, ໂຟນເດີຂອງມັນ <em>{$a->rootdir}</em> ຕ້ອງຖືກລຶບອອກຈາກເຊີບເວີຂອງທ່ານ. ທ່ານຕ້ອງການລຶບໂຟນເດີປລັກອິນດຽວນີ້ບໍ?';
$string['uninstalldeleteconfirmexternal'] = 'ປະກົດວ່າປລັກອິນສະບັບປັດຈຸບັນໄດ້ຮັບຜ່ານລະບົບການຈັດການລະຫັດແຫຼ່ງ ({$a}). ຖ້າທ່ານເອົາໂຟນເດີປລັກອິນ, ທ່ານອາດຈະສູນເສຍການດັດແກ້ທ້ອງຖິ່ນທີ່ສໍາຄັນຂອງລະຫັດ. ກະລຸນາໃຫ້ແນ່ໃຈວ່າ ທ່ານຕ້ອງການລຶບໂຟນເດີປລັກອິນກ່ອນທີ່ຈະສືບຕໍ່.';
$string['uninstallextraconfirmblock'] = 'ມີຕົວຢ່າງ {$a->instances} ຂອງບລັອກນີ້.';
$string['uninstallextraconfirmenrol'] = 'ມີຜູ້ໃຊ້ {$a->enrolments} ຂອງການລົງທະບຽນຮຽນ.';
$string['uninstallextraconfirmmod'] = 'ມີຕົວຢ່າງ {$a->instances} ຂອງຊຸດນີ້ໃນ {$a->courses} ລາຍວິຊາ.';
$string['uninstalling'] = 'ຍົກເລີກການຕິດຕັ້ງ {$a->name}';
$string['updateavailable'] = 'ມີສະບັບໃໝ່  {$a} ໃຫ້!';
$string['updateavailable_moreinfo'] = 'ຂໍ້ມູນເພີ່ມເຕີມ...';
$string['updateavailable_release'] = 'ປົດປ່ອຍ {$a}';
$string['updatepluginconfirm'] = 'ການຢັ້ງຢືນປັບປຸງປລັກອິນ';
$string['updatepluginconfirmexternal'] = 'ປະກົດວ່າປລັກອິນລຸ້ນປັດຈຸບັນໄດ້ຮັບຜ່ານລະບົບການຈັດການລະຫັດແຫຼ່ງ ({$a}). ຖ້າທ່ານຕິດຕັ້ງການປັບປຸງນີ້, ທ່ານຈະບໍ່ສາມາດໄດ້ຮັບການປັບປຸງປລັກອິນຈາກລະບົບການຄຸ້ມຄອງລະຫັດແຫຼ່ງໄດ້. ກະລຸນາຮັບປະກັນວ່າ ທ່ານຕ້ອງການປັບປຸງປລັກອິນຢ່າງແນ່ນອນກ່ອນທີ່ຈະສືບຕໍ່.';
$string['updatepluginconfirminfo'] = 'ທ່ານກຳລັງຈະຕິດຕັ້ງປລັກອິນສະບັບໃໝ່ <strong>{$a->name}</strong>. ແພັກເກດ zip ທີ່ມີສະບັບ {$a->version} ຂອງປລັກອິນຈະຖືກດາວໂຫຼດຈາກ <a href="{$a->url}">{$a->url}</a> ແລະ ຖືກແຍກໃສ່ການຕິດຕັ້ງ Moodle ຂອງທ່ານ. ສະນັ້ນ ມັນສາມາດຍົກລະດັບການຕິດຕັ້ງຂອງທ່ານໄດ້.';
$string['updatepluginconfirmwarning'] = 'ກະລຸນາຮັບຊາບວ່າ Moodle ຈະບໍ່ເຮັດການສໍາຮອງຖານຂໍ້ມູນຂອງທ່ານໂດຍອັດຕະໂນມັດກ່ອນທີ່ຈະຍົກລະດັບ. ພວກເຮົາຂໍແນະນໍາໃຫ້ທ່ານເຮັດການສໍາຮອງຮູບເຕັມທີ່ໃນປັດຈຸບັນ, ເພື່ອຮັບມືກັບກໍລະນີທີ່ຫາຍາກທີ່ລະຫັດໃໝ່ມີຂໍ້ບົກພ່ອງທີ່ເຮັດໃຫ້ເວັບໄຊທ໌ຂອງທ່ານບໍ່ສາມາດໃຊ້ໄດ້ ຫຼື ແມ້ກະທັ້ງການທໍາລາຍຖານຂໍ້ມູນຂອງທ່ານ. ດໍາເນີນການຢູ່ໃນຄວາມສ່ຽງຂອງທ່ານເອງ.';
$string['validationmsg_componentmatch'] = 'ຊື່ອົງປະກອບເຕັມ';
$string['validationmsg_componentmismatchname'] = 'ຊື່ປລັກອິນບໍ່ກົງກັນ';
$string['validationmsg_componentmismatchname_help'] = 'ບາງແພັກເກັດ ZIP, ເຊັ່ນທີ່ສ້າງໂດຍ Github, ອາດຈະມີຊື່ບັນຊີລາຍການຮາກທີ່ບໍ່ຖືກຕ້ອງ. ທ່ານຈໍາເປັນຕ້ອງໄດ້ແກ້ໄຂຊື່ບັນຊີລາຍການຮາກ ເພື່ອໃຫ້ກົງກັບຊື່ປລັກອິນທີ່ໄດ້ແຈ້ງ.';
$string['validationmsg_componentmismatchname_info'] = 'ປລັກອິນປະກາດຊື່ຂອງມັນຄື \'{$a}\' ແຕ່ມັນບໍ່ກົງກັບຊື່ຂອງບັນຊີລາຍຊື່ຮາກ.';
$string['validationmsg_componentmismatchtype'] = 'ປະເພດປລັກອິນບໍ່ກົງກັນ';
$string['validationmsg_componentmismatchtype_info'] = 'ປະເພດ \'{$a->expected}\' ທີ່ຄາດຫວັງແຕ່ ການແຈ້ງປລັກອິນປະເພດຂອງຕົນແມ່ນ \'{$a->found}\'.';
$string['validationmsg_filenotexists'] = 'ບໍ່ພົບໄຟລ໌ທີ່ຖືກແຍກ';
$string['validationmsg_filesnumber'] = 'ບໍ່ພົບໄຟລ໌ພຽງພໍໃນແພັກເກດ';
$string['validationmsg_filestatus'] = 'ບໍ່ສາມາດແຍກໄຟລ໌ທັງໝົດ';
$string['validationmsg_filestatus_info'] = 'ກຳລັງພະຍາຍາມແຍກໄຟລ໌ {$a->file} ມີຜົນໃນຄວາມຜິດພາດ \'{$a->status}\'.';
$string['validationmsg_foundlangfile'] = 'ພົບໄຟລ໌ພາສາ';
$string['validationmsg_maturity'] = 'ແຈ້ງລະດັບທີ່ຄົບກຳນົດ';
$string['validationmsg_maturity_help'] = 'ປລັກອິນສາມາດປະກາດລະດັບການຄົບກຳນົດຂອງມັນໄດ້. ຖ້າຜູ້ຮັກສາຖືວ່າປລັກອິນຄົງຕົວ, ລະດັບຄົບກຳນົດທີ່ແຈ້ງໄວ້ຈະອ່ານ MATURITY_STABLE. ລະດັບຄົບກຳນົດອື່ນໆທັງໝົດ (ເຊັ່ນ: ແອວຟາ ຫຼື ເບຕ້າ) ຄວນຖືກພິຈາລະນາວ່າບໍ່ໝັ້ນຄົງ ແລະ ມີການເຕືອນຂຶ້ນ.';
$string['validationmsg_missingcomponent'] = 'ປລັກອິນບໍ່ໄດ້ແຈ້ງຊື່ອົງປະກອບຂອງຕົນ';
$string['validationmsg_missingcomponent_help'] = 'ປັ໊ກອິນທັງໝົດຈະຕ້ອງໃຫ້ຊື່ອົງປະກອບເຕັມຂອງເຂົາເຈົ້າຜ່ານການແຈ້ງ `$plugin->component` ໃນໄຟລ໌ version.php.';
$string['validationmsg_missingcomponent_link'] = 'Development:version.php';
$string['validationmsg_missingexpectedlangenfile'] = 'ຊື່ໄຟລ໌ພາສາອັງກິດບໍ່ກົງກັນ';
$string['validationmsg_missingexpectedlangenfile_info'] = 'ປະເພດປລັກອິນທີ່ໃຫ້ນັ້ນບໍ່ມີໄຟລ໌ພາສາອັງກິດທີ່ຄາດໄວ້ {$a}.';
$string['validationmsg_missinglangenfile'] = 'ບໍ່ພົບໄຟລ໌ພາສາອັງກິດ';
$string['validationmsg_missinglangenfolder'] = 'ໂຟນເດີພາສາອັງກິດຂາດຫາຍໄປ';
$string['validationmsg_missingversion'] = 'ປລັກອິນບໍ່ໄດ້ແຈ້ງສະບັບຂອງມັນ';
$string['validationmsg_missingversionphp'] = 'ບໍ່ພົບໄຟລ໌ version.php';
$string['validationmsg_multiplelangenfiles'] = 'ພົບຫຼາຍໄຟລ໌ພາສາອັງກິດ';
$string['validationmsg_onedir'] = 'ໂຄງຮ່າງຂອງແພັດເກດ ZIP ບໍ່ຖືກຕ້ອງ.';
$string['validationmsg_onedir_help'] = 'ຊຸດ ZIP ຕ້ອງມີພຽງບັນຊີລາຍຊື່ຮາກອັນດຽວທີ່ຖືລະຫັດປລັກອິນ. ຊື່ຂອງບັນຊີລາຍຊື່ຮາກນັ້ນຕ້ອງກົງກັບຊື່ຂອງປລັກອິນ.';
$string['validationmsg_pathwritable'] = 'ຂຽນເຊັກເຂົ້າຫາ';
$string['validationmsg_pluginversion'] = 'ສະບັບປລັກອິນ';
$string['validationmsg_pluginversiontoolow'] = 'ສະບັບທີ່ສູງກວ່າຂອງປລັກອິນນີ້ຖືກຕິດຕັ້ງແລ້ວ';
$string['validationmsg_release'] = 'ປົດປ່ອຍປລັກອິນ';
$string['validationmsg_requiresmoodle'] = 'ຕ້ອງການສະບັບ Moodle';
$string['validationmsg_rootdir'] = 'ຊື່ຂອງປລັກອິນທີ່ຈະຖືກຕິດຕັ້ງ';
$string['validationmsg_rootdir_help'] = 'ຊື່ຂອງບັນຊີລາຍຊື່ຮາກຢູ່ໃນຊຸດ ZIP ປະກອບເປັນຊື່ຂອງປລັກອິນທີ່ຈະຕິດຕັ້ງ. ຖ້າຊື່ບໍ່ຖືກຕ້ອງ, ທ່ານອາດຈະຕ້ອງການປ່ຽນຊື່ບັນຊີລາຍຊື່ຮາກ ໃນ ZIP ກ່ອນທີ່ຈະຕິດຕັ້ງປລັກອິນ.';
$string['validationmsg_rootdirinvalid'] = 'ຊື່ປລັກອິນບໍ່ຖືກຕ້ອງ';
$string['validationmsg_rootdirinvalid_help'] = 'ຊື່ຂອງບັນຊີລາຍຊື່ຮາກຢູ່ໃນຊຸດ ZIP ລະເມີດຂໍ້ກໍານົດຂອງ syntax ຢ່າງເປັນທາງການ. ບາງແພັກເກັດ ZIP, ເຊັ່ນ: ທີ່ສ້າງໂດຍ Github, ອາດຈະມີຊື່ບັນຊີລາຍຊື່ຮາກທີ່ບໍ່ຖືກຕ້ອງ. ທ່ານຈໍາເປັນຕ້ອງໄດ້ແກ້ໄຂຊື່ຂອງບັນຊີລາຍຊື່ຮາກເພື່ອໃຫ້ກົງກັບຊື່ປລັກອິນ.';
$string['validationmsg_targetexists'] = 'ສະຖານທີ່ເປົ້າໝາຍທີ່ມີຢູ່ແລ້ວ ແລະ ຈະຖືກລຶບ';
$string['validationmsg_targetexists_help'] = 'ບັນຊີລາຍຊື່ປລັກອິນທີ່ມີຢູ່ແລ້ວ ແລະ ຈະຖືກປ່ຽນແທນໂດຍເນື້ອຫາແພັດເກດປລັກອິນ.';
$string['validationmsg_targetnotdir'] = 'ສະຖານທີ່ເປົ້າໝາຍທີ່ຖືກຄວບຄອງໂດຍໄຟລ໌';
$string['validationmsg_unknowntype'] = 'ປະເພດປລັກອິນທີ່ບໍ່ຮູ້ຈັກ';
$string['validationmsg_versionphpsyntax'] = 'ກວດຈັບ syntax ທີ່ບໍ່ຮອງຮັບໃນໄຟລ໌ version.php';
$string['validationmsglevel_debug'] = 'ດີບັກ';
$string['validationmsglevel_error'] = 'ຜິດພາດ';
$string['validationmsglevel_info'] = 'ຕົກລົງ';
$string['validationmsglevel_warning'] = 'ການເຕືອນ';
$string['version'] = 'ສະບັບ';
$string['versiondb'] = 'ສະບັບປະຈຸບັນ';
$string['versiondisk'] = 'ສະບັບໃໝ່';
