<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'sk', version '4.2'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Aktivity';
$string['addcategory'] = 'Pridať kategóriu';
$string['addcategoryerror'] = 'Nepodarilo sa pridať kategóriu';
$string['addexceptionerror'] = 'Pri pridávaní výnimky pre userid:gradeitem sa vyskytla chyba';
$string['addfeedback'] = 'Pridať komentár';
$string['addgradeletter'] = 'Pridať slovnú známku';
$string['addidnumbers'] = 'Pridať identifikátory';
$string['additem'] = 'Pridať položku hodnotenia';
$string['additionalfeedback'] = 'Dodatočná spätná väzba';
$string['addoutcome'] = 'Pridať očakávaný cieľ';
$string['addoutcomeitem'] = 'Pridať hodnotený cieľ';
$string['addscale'] = 'Pridať stupnicu';
$string['adjustedweight'] = 'Prispôsobená váha';
$string['aggregateextracreditmean'] = 'Priemer známok (s extra bodmi)';
$string['aggregatemax'] = 'Najvyššia známka';
$string['aggregatemean'] = 'Priemer známok';
$string['aggregatemedian'] = 'Medián známok';
$string['aggregatemin'] = 'Najnižšia známka';
$string['aggregatemode'] = 'Početnosť známok';
$string['aggregatenotonlygraded'] = 'Vrátane prázdnych známok';
$string['aggregateonlygraded'] = 'Súhrnná známka iba z neprázdnych známok';
$string['aggregateonlygraded_help'] = '';
$string['aggregateoutcomes'] = 'Zahrnúť ciele do súhrnnej známky';
$string['aggregateoutcomes_help'] = '<p>Zahrnutie cieľov do súhrnnej známky nemusí viesť k žiadanému výsledku. Preto je možnosť ich zahrnúť alebo nie.</p>';
$string['aggregatesonly'] = 'Zmeniť iba súhrnné známky';
$string['aggregatesubcatsupgradedgrades'] = 'Poznámka: Nastavení agregácie "Súhrn zahrňujúci podkategórie" bola odstránená v rámci aktualizácie portálu. Vzhľadom k tomu,  že predtým bola použitá v tomto kurze  "Súhrn zahrňujúci podkategórie", odporúčame, aby ste si skontrolovali túto zmenu vo výkaze známok.';
$string['aggregatesum'] = 'Prirodzené váhovanie';
$string['aggregateweightedmean'] = 'Vážený priemer známok';
$string['aggregateweightedmean2'] = 'Jednoduchý vážený priemer známok';
$string['aggregation'] = 'Súhrnná známka';
$string['aggregation_help'] = 'Výpočet celkovej známky určuje, ako sa kombinujú známky v kategórii:

* Priemer známok - súčet všetkých známok vydelený celkovým počtom známok
* Medián známok - stredná hodnota známok, keď ich usporiadame od najmenšej po najväčšiu
* Najnižšia známka
* Najvyššia známka
* Početnosť známok - známka, ktorá sa vyskytuje najčastejšie
* Prirodzené váhovanie - súčet váhovaných známok';
$string['aggregation_link'] = 'grade/aggregation';
$string['aggregationcoef'] = 'Násobiaci koeficient';
$string['aggregationcoefextra'] = 'Extra body';
$string['aggregationcoefextra_help'] = 'Ak je súhrnná známka počítaná metódou "Prirodzené váženie" alebo "Jednoduchý vážený priemer" môžu byť vybrané položky hodnotenia byť chápané ako bonusové. Znamená to, že najvyššia možná známka za túto položku nebude pripočítaná k celkovej maximálnej známke za celú kategóriu, ale samotná známka bude. Ak administrátor portálu nastavil možnosť, že známky môžu byť vačšie ako maximálne, potom sa to tu môže stať.

Ak je používaná súhrnná známka "Priemer známok (včitane extra bodov)" a sem zadáte hodnotu väčšiu ako nula, potom známky za túto položku hodnotenia budú chápané ako známka naviac.  Nastavená hodnota je chápaná ako súčiniteľ, ktorým je známka vynásobená predtým, ako je pripočítaná k celku pri výpočte priemeru. Zároveň nie je započítaná do počtu položiek v menovateli.';
$string['aggregationcoefextra_link'] = 'grade/aggregation';
$string['aggregationcoefextrasum'] = 'Extra body';
$string['aggregationcoefextrasum_help'] = 'Ak sa použije položka extra body, potom sa maximálna hodnota položky známkovania nepripočítava do maxima kategórie. Môže sa potom stať, že bude dosiahnutá maximálna známka (alebo aj väčšia ako maximálna, ako to administrátor povolil) v kategórii bez toho, aby mali všetky známky maximálny hodnotu.';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Váha pre extra body';
$string['aggregationcoefextraweight_help'] = 'Ak je extra kredit nastavený na hodnotu väčšiu ako nula, potom je položka chápaná ako extra body počas výpočtu celkovej známky. Toto číslo je multiplikátor, ktorým bude hodnota známky vynásobená predtým, ako sa pripočíta k celku pri výpočte priemeru.';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = 'Váha položky';
$string['aggregationcoefweight_help'] = '<p>Percentuálny podiel všetkých hodnotení tejto kategórie vzhľadom k ostatným kategóriám.</p>';
$string['aggregationcoefweight_link'] = 'grade/aggregation';
$string['aggregationhintdropped'] = '(Ignorované)';
$string['aggregationhintexcluded'] = '(Vylúčené)';
$string['aggregationhintextra'] = '(Extra body)';
$string['aggregationhintnovalue'] = '(Prázdne)';
$string['aggregationofa'] = 'Agregácia {$a}';
$string['aggregationposition'] = 'Umiestnenie súhrnnej známky';
$string['aggregationposition_help'] = '<p>Určuje pozíciu stĺpca súhrnnej známky v známkovom výkaze vzhľadom na známky, z ktorých je vypočítavaný súhrn. </p>';
$string['aggregationsvisible'] = 'Dostupné súhrnné známky';
$string['aggregationsvisiblehelp'] = 'Vyznačte všetky typy súhrnných známok, ktoré majú byť dostupné. Používajte klávesu CTRL na výber viacerých položiek.';
$string['allgrades'] = 'Všetky známky podľa kategórie';
$string['allstudents'] = 'Všetci študenti';
$string['allusers'] = 'Všetci používatelia';
$string['aria-toggledropdown'] = 'Prepnite nasledujúcu rozbaľovaciu ponuku';
$string['autosort'] = 'Automatické triedenie';
$string['availableidnumbers'] = 'Dostupné identifikátory';
$string['average'] = 'Priemer';
$string['averagesdecimalpoints'] = 'Počet desatinných miest v stĺpcových priemeroch';
$string['averagesdecimalpoints_help'] = 'Určuje počet desatinných miest v stĺpcových priemeroch. Ak je zvolené Zdediť, použije sa rovnaké zobrazenie ako pre každý stĺpec.';
$string['averagesdisplaytype'] = 'Typ zobrazenia stĺpcových priemerov';
$string['averagesdisplaytype_help'] = '<p>Určuje spôsob zobrazenia priemerov stĺpcov. Ak je zvolené Zdediť, použije sa rovnaké zobrazenie ako pre každý stĺpec. </p>';
$string['backupwithoutgradebook'] = 'Záloha neobsahuje konfiguráciu známok';
$string['badgrade'] = 'Dodaná známka je neplatná';
$string['badlyformattedscale'] = 'Zadajte zoznam oddelený čiarkami (je potrebné zadať minimálne dve položky)';
$string['baduser'] = 'Dodaný používateľ je neplatný';
$string['bonuspoints'] = 'Body naviac (bonus)';
$string['bulkcheckboxes'] = 'Hromadné checkboxy';
$string['calculatedgrade'] = 'Vypočítaná známka';
$string['calculation'] = 'Výpočet';
$string['calculation_help'] = 'Výpočet známky je vzorec. Musí začínať rovnítkom a môže využívať štandardné matematické operácie ako max, min, sum. Ak je potrebné, môžu byť do známky vybrané individuálne položky známok na základe svojho identifikátora v dvojitých hranatých zátvorkách.';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = 'Pridať výpočet';
$string['calculationedit'] = 'Upraviť výpočet';
$string['calculationsaved'] = 'Výpočet uložený';
$string['calculationview'] = 'Prezrieť výpočet';
$string['cannotaccessgroup'] = 'Ľutujem, známky vybranej skupiny nie sú dostupné.';
$string['categories'] = 'Kategórie';
$string['category'] = 'Kategória';
$string['categoryedit'] = 'Upraviť kategóriu';
$string['categoryname'] = 'Názov kategórie';
$string['categorytotal'] = 'Kategória spolu';
$string['categorytotalfull'] = '{$a->category} spolu';
$string['categorytotalname'] = 'Názov celkového súčtu kategórie';
$string['changedefaults'] = 'Zmeniť predvoľby';
$string['changereportdefaults'] = 'Zmeniť predvoľby výkazu';
$string['chooseaction'] = 'Vyberte činnosť ...';
$string['choosecategory'] = 'Vyberte kategóriu';
$string['collapsecriterion'] = 'Zbaliť kritérium';
$string['combo'] = 'Záložky a rozbaľovacie menu';
$string['compact'] = 'Kompaktný';
$string['componentcontrolsvisibility'] = 'Nastavenie aktivity určuje, či je táto známka skrytá';
$string['contract'] = 'Zbaliť kategóriu';
$string['contributiontocoursetotal'] = 'Podiel z celkovej známky';
$string['controls'] = 'Nastavenia';
$string['courseavg'] = 'Priemer kurzu';
$string['coursegradecategory'] = 'Kategória známok kurzu';
$string['coursegradedisplaytype'] = 'Typ zobrazovania známok kurzu';
$string['coursegradedisplayupdated'] = 'Typ zobrazovania známok kurzu bol aktualizovaný.';
$string['coursegradesettings'] = 'Nastavenia známok kurzu';
$string['coursename'] = 'Názov kurzu';
$string['coursescales'] = 'Stupnice kurzu';
$string['coursesettings'] = 'Nastavenia kurzu';
$string['coursesettingsexplanation'] = 'Nastavenia kurzu, ktoré určujú výzor známkového výkazy účastníkom kurzu.';
$string['coursesiamtaking'] = 'Zapísané kurzy';
$string['coursesiamteaching'] = 'Učím v kurzoch';
$string['coursetotal'] = 'Súčet kurzu';
$string['createcategory'] = 'Vytvoriť kategóriu';
$string['createcategoryerror'] = 'Nebolo možné vytvoriť novú kategóriu';
$string['creatinggradebooksettings'] = 'Vytvára sa nastavenie klasifikácie';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Typ výpočtu sumárnej známky v nadradenej kategórii';
$string['curveto'] = 'Prepočítať na';
$string['decimalpoints'] = 'Celkové desatinné miesta';
$string['decimalpoints_help'] = 'Určuje počet desatinných miest zobrazovaných v každej známke. Nastavenie nemá vplyv na výpočty známok, ktoré sú s presnosťou na 5 desatinných miest.';
$string['default'] = 'Predvolené';
$string['defaultprev'] = 'Predvolené ({$a})';
$string['deletecategory'] = 'Vymazať kategóriu';
$string['deletescale'] = 'Vymazať stupnicu';
$string['disablegradehistory'] = 'Vypnúť históriu známok';
$string['disablegradehistory_help'] = 'Zakázať históriu sledovania zmien v tabuľkách súvisiacich so známkovaním. Toto môže zrýchliť server a zmenšiť potrebné miesto v databáze.';
$string['displaylettergrade'] = 'Zobraziť slovné známky';
$string['displaypercent'] = 'Zobraziť známky v percentách';
$string['displaypoints'] = 'Zobraziť body';
$string['displayweighted'] = 'Zobraziť vážené známky';
$string['dropdown'] = 'Rozbaľovací zoznam';
$string['droplow'] = 'Ignorovať najnižšie';
$string['droplow_help'] = '<p>Ak je táto voľba nastavená, nebude sa pri výpočte uvažovať X najnižších hodnotení, kde X je zvolená hodnota tejto voľby.</p>';
$string['droplowestvalue'] = 'Nastaviť najnižšiu hodnotu známky';
$string['droplowestvalues'] = 'Ignorovať {$a} najnižších hodnôt';
$string['dropped'] = 'Ignorované';
$string['dropxlowest'] = 'Ignorovať X najnižších';
$string['dropxlowestwarning'] = 'Poznámka: Ak použijete ignorovať X najnižšich, systém známkovania si bude myslieť, že všetky položky v kategórii budú mať tú istú bodovú hodnotu. Ak sa bodové hodnoty odlišujú, výsledky budú nepredvídateľné.';
$string['duplicatedgradeitem'] = '{$a} (kópia)';
$string['duplicatescale'] = 'Duplikovať stupnicu';
$string['edit'] = 'Upraviť';
$string['editcalculation'] = 'Upraviť výpočet';
$string['editcalculationverbose'] = 'Upraviť výpočet pre {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Upraviť komentár';
$string['editgrade'] = 'Upraviť známku';
$string['editgradeletters'] = 'Upraviť slovné známky';
$string['editoutcome'] = 'Upraviť cieľ';
$string['editoutcomes'] = 'Upraviť ciele';
$string['editscale'] = 'Upraviť stupnicu';
$string['edittree'] = 'Nastavenie';
$string['editverbose'] = 'Upraviť {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Povoliť AJAX';
$string['enableajax_help'] = 'Pridať funkcionalitu AJAX pri práci so známkami - zjednodušenie a zrýchlenie základných operácií. Závisí od zapnutia Javascriptu v prehliadači používateľa.';
$string['enableoutcomes'] = 'Povoliť ciele';
$string['enableoutcomes_help'] = 'Ak je povolené, je možné používať hodnotenia činnosti študentov pomocou jednej alebo viacerých stupníc, ktoré sú zviazané s očakávaným cieľom.';
$string['encoding'] = 'Kódovanie';
$string['encoding_help'] = 'Vyberte kódovanie znakov použité pre údaje. (Štandardné kódovanie je UTF-8). Ak je omylom vybrané nesprávne kódovanie, bude to vidieť pri prehliadaní importovaných údajov.';
$string['errorcalculationbroken'] = 'Chyba vo výpočte položky známky {$a}';
$string['errorcalculationnoequal'] = 'Vzorec musí začať značkou rovná sa (=1+2)';
$string['errorcalculationunknown'] = 'Chybný vzorec';
$string['errorgradevaluenonnumeric'] = 'Nenumerická hodnota známky:';
$string['errornocalculationallowed'] = 'Pre túto položku nie sú povolené výpočty';
$string['errornocategorisedid'] = 'Nebolo možné získať nekategorizovaný identifikátor';
$string['errornocourse'] = 'Nebolo možné získať informácie o kurze';
$string['errorreprintheadersnonnumeric'] = 'Hodnota nenumerického typu pre opakujúcu sa hlavičku';
$string['errorsavegrade'] = 'Ľutujeme, nebolo možné uložiť známku.';
$string['errorsettinggrade'] = 'Chyba ukladania "{$a->itemname}" známok používateľa {$a->userid}';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Chyba pri aktualizácii nastavenia "Výpočty iba na neprázdnych známkach" v kategórii s ID {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Chyba pri aktualizácii nastavenia "Zahrnúť ciele vo výpočtoch" v kategórii s ID {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Chyba pri aktualizácii typu výpočtu v kategórii s ID {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Chyba pri aktualizácii výpočtového koeficienta (váha alebo extra body) v položke hodnotenia s ID {$a->id}';
$string['eventgradedeleted'] = 'Známka odstránená';
$string['eventgradeitemcreated'] = 'Vytvorená položka známky';
$string['eventgradeitemdeleted'] = 'Položka známky bola vymazaná';
$string['eventgradeitemupdated'] = 'Položka známky bola aktualizovaná';
$string['eventgradelettercreated'] = 'Vytvorené písmeno slovnej známky';
$string['eventgradeletterdeleted'] = 'Odstránené písmeno slovnej známky';
$string['eventgradeletterupdated'] = 'Aktualizované písmeno slovnej známky';
$string['eventgradeviewed'] = 'Známky boli zobrazené v prehľade';
$string['eventscalecreated'] = 'Stupnica bola vytvorená';
$string['eventscaledeleted'] = 'Stupnica bola odstránená';
$string['eventscaleupdated'] = 'Stupnica bola aktualizovaná';
$string['eventusergraded'] = 'Používateľ bol oznámkovaný';
$string['excluded'] = 'Vyňatá';
$string['excluded_help'] = '<p>Ak je toto nastavenie zapnuté, táto známka nebude uvažovaná pri žiadnych výpočtoch v nadradených položkách a kategóriách.</p>';
$string['expand'] = 'Rozbaliť kategóriu';
$string['expandcriterion'] = 'Rozbaliť kritérium';
$string['export'] = 'Export';
$string['exportalloutcomes'] = 'Exportovať všetky ciele';
$string['exportfeedback'] = 'Zahrnúť komentáre v exporte';
$string['exportfeedback_desc'] = 'Toto môže byť prepísané počas exportu';
$string['exportformatoptions'] = 'Voľby formátu exportu';
$string['exportonlyactive'] = 'Nezahrnúť suspendovaných používateľov';
$string['exportonlyactive_help'] = 'Zahrnúť iba študentov, ktorí sú zapísaní do kurzu a ich učet nebol pozastavený';
$string['exportplugins'] = 'Zásuvné moduly pre export';
$string['exportsettings'] = 'Nastavenia exportu';
$string['exportto'] = 'Exportovať do';
$string['externalurl'] = 'Externá adresa URL';
$string['externalurl_desc'] = 'Ak je použité externé známkovanie, zadajte sem adresu URL.';
$string['extracreditvalue'] = 'Hodnota extra bodov pre {$a}';
$string['extracreditwarning'] = 'Poznámka: Nastavenie všetkých položiek pre kategóriu na kredit naviac efektívne odstráni všetky tieto položky z výpočtu známok. Tu nebude teda žiaden celkový počet bodov';
$string['fail'] = 'Zlyhanie';
$string['feedback'] = 'Komentár';
$string['feedback_help'] = '<p>Poznámky, ktoré ku známke pridáva učiteľ. Môžu byť obsiahle, zosobnené jednotlivým študentom, alebo jednoduché.</p>';
$string['feedbackadd'] = 'Pridať komentár';
$string['feedbackedit'] = 'Upraviť komentár';
$string['feedbackfiles'] = 'Súbory spätnej väzby';
$string['feedbackforgradeitems'] = 'Komentár pre {$a}';
$string['feedbackhistoryfiles'] = 'Súbory histórie spätnej väzby';
$string['feedbacks'] = 'Komentáre';
$string['feedbacksaved'] = 'Komentár uložený';
$string['feedbackview'] = 'Prezrieť komentár';
$string['filterbothactive'] = 'Prvý ({$a->first}) Posledný ({$a->last})';
$string['filterbyname'] = 'Filtrujte podľa názvu';
$string['filterfirstactive'] = 'Prvý ({$a->first})';
$string['filterlastactive'] = 'Posledný ({$a->last})';
$string['finalgrade'] = 'Výsledná známka';
$string['finalgrade_help'] = '<p>Výsledná známka po aplikovaní všetkých výpočtov.</p>';
$string['fixedstudents'] = 'Statický stĺpec s menami';
$string['fixedstudents_help'] = 'Umožňuje posúvať tabuľku horizontálne bez toho, aby sa stratil statický stĺpec s menami študentov';
$string['forceimport'] = 'Vynútiť import';
$string['forceimport_help'] = 'Vynúti import známok, aj keď boli známky aktualizované po exporte súboru.';
$string['forceoff'] = 'Vnútiť: vypnuté';
$string['forceon'] = 'Vnútiť: zapnuté';
$string['forelementtypes'] = 'pre vybrané {$a}';
$string['forstudents'] = 'Pre študentov';
$string['full'] = 'Úplný';
$string['fullmode'] = 'Prepnúť na plný režim';
$string['generalsettings'] = 'Všeobecné nastavenia';
$string['grade'] = 'Známka';
$string['grade_help'] = 'Získaná známka študenta za jeho prácu';
$string['gradeadministration'] = 'Administratíva známok';
$string['gradealreadyupdated'] = '{$a} známok nebolo importovaných, pretože známky v importovanom súbore sú staršie ako v systéme. Ak ich chcete aj napriek tomu načítať, použite vynútený import.';
$string['gradeanalysis'] = 'Analýza hodnotenia';
$string['gradebook'] = 'Klasifikácia';
$string['gradebookcalculationsfixbutton'] = 'Akceptovať zmeny známok a opraviť chyby pri výpočte';
$string['gradebookcalculationsuptodate'] = 'Výpočty vo výkaze známok sú aktuálne. Možno je treba obnoviť stránku, aby sa zobrazili zmeny';
$string['gradebookcalculationswarning'] = 'Poznámka: Vo výpočte hodnotenia zobrazených vo výkaze známok boli zistené niektoré chyby. Ak váš kurz nezačal alebo prebieha, odporúča sa opraviť chyby kliknutím na tlačidlo nižšie, aj keď to vedie k tomu, že niektoré hodnotenia sa zmenia. Ak už váš kurz skončil a hodnotenia boli odoslané, pravdepodobne tento problém nebudete chcieť opraviť.

Novšia verzia je {$a->currentversion}; vy používate verziu výkazu známok {$a->gradebookversion}. Zoznam zmien si môžete pozrieť na <a href="{$a->url}">Zmeny výpočtu výkazu známok</a>.';
$string['gradebookhiddenerror'] = 'Systém klasifikácie je momentálne nastavený tak, že pred študentmi je všetko skryté.';
$string['gradebookhistories'] = 'História známok';
$string['gradebooksetup'] = 'Nastavenie hodnotenia';
$string['gradeboundary'] = 'Rozsah slovnej známky';
$string['gradeboundary_help'] = '<p>Ide o percentuálne rozmedzie hodnotenia, v ktorom bude hodnoteniu priradená slovná známka (ak sa používa spôsob zobrazovania výsledkov v slovných známkach)</p>';
$string['gradecategories'] = 'Kategórie známok';
$string['gradecategory'] = 'Kategória známok';
$string['gradecategoryonmodform'] = 'Kategória známok';
$string['gradecategoryonmodform_help'] = 'Toto nastavenie určuje kategóriu známok, v ktorej sa bude nachádzať hodnotenie tejto aktivity v známkovom výkaze.';
$string['gradecategorysettings'] = 'Nastavenie kategorizácie známok';
$string['gradedisplay'] = 'Zobrazenie známok';
$string['gradedisplaytype'] = 'Typ zobrazenia známok';
$string['gradedisplaytype_help'] = 'Toto nastavenie určuje, ako budú zobrazené známky v celkovom prehľade hodnotenia a v prehľade hodnotenia jedného používateľa.

* Slovná známka - Písmeno alebo slová sú používané k reprezentácii rozsahu známok, ako definované v \'slovné známky\' v nastavení hodnotenia
* Percento - vo vzťahu k najnižšej a najvyššej možnej hodnote
* Reálne číslo - Skutočná známka alebo hodnota';
$string['gradedon'] = 'Hodnotené: {$a}';
$string['gradeexport'] = 'Export známok';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Export vlastných polí profilu.';
$string['gradeexportcustomprofilefields_desc'] = 'Zoznam vlastných polí používateľského profilu, ktoré majú byť zahrnuté do exportu známok. Názvy polí oddeľte čiarkami.';
$string['gradeexportdecimalpoints'] = 'Počet desatinných miest pri exporte známok';
$string['gradeexportdecimalpoints_desc'] = 'Počet desatinných miest v zobrazení pre export. Počas exportu môže byť zmenené.';
$string['gradeexportdisplaytype'] = 'Typ zobrazenia  pri exporte známok';
$string['gradeexportdisplaytype_desc'] = 'Známky môžu byť zobrazené ako skutočné hodnoty, percentá (vzhľadom na minimálne a maximálne body) alebo ako slovné známky. Počas exportu môže byť zmenené.';
$string['gradeexportdisplaytypes'] = 'Typy zobrazenia exportu známok';
$string['gradeexportuserprofilefields'] = 'Pole používateľského profilu v exporte známok';
$string['gradeexportuserprofilefields_desc'] = 'Zahrnúť tieto polia používateľského profilu v exporte známok, oddelené čiarkou.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Počiatočné minimálne a maximálne známky';
$string['gradehelp'] = 'Nápoveda pre známkovanie';
$string['gradehistorylifetime'] = 'Životnosť histórie známok';
$string['gradehistorylifetime_help'] = 'Toto určuje časový interval, počas ktorého sa ukladajú informácie o zmenách v tabuľkách súvisiacich zo známkovaním. Doporučuje sa nastaviť čo najdlhší. Znížte, iba ak sú problémy s výkonnosťou servera či veľkosťou databázy.';
$string['gradeimport'] = 'Import známok';
$string['gradeimportfailed'] = 'Import známok nebol úspešný. Podrobné informácie:';
$string['gradeitem'] = 'Položka hodnotenia';
$string['gradeitemaddusers'] = 'Vyňať zo známkovania';
$string['gradeitemadvanced'] = 'Pokročilé voľby položky známkovania';
$string['gradeitemadvanced_help'] = 'Vyberte všetky položky, ktoré majú byť zobrazené pri úprave položiek známok ako pokročilé nastavenia.';
$string['gradeitemislocked'] = 'Táto aktivita je vo výkaze uzamknutá. Zmeny, ktoré budú vykonané v tejto aktivite, nebudú skopírované do výkazu známok, kým nebude odomknutý.';
$string['gradeitemlocked'] = 'Známkovanie zamknuté';
$string['gradeitemmembersselected'] = 'Vyňatie zo známkovania';
$string['gradeitemminmax'] = 'Počiatočné minimálne a maximálne známky, ako uvedené v nastaveniach položky hodnotenia';
$string['gradeitemnonmembers'] = 'Zahrnutie do známkovania';
$string['gradeitemremovemembers'] = 'Zahrnúť do známkovania';
$string['gradeitems'] = 'Položky známkovania';
$string['gradeitemsettings'] = 'Nastavenia položky známkovania';
$string['gradeitemsinc'] = 'Zahrnuté položky známkovania';
$string['gradeletter'] = 'Slovná známka';
$string['gradeletter_help'] = '<p>Môže sa použiť písmeno alebo iný symbol, ktorý reprezentuje rozsah hodnotenia.</p>';
$string['gradeletternote'] = 'Ak chcete vymazať slovnú známku, jednoducho vymažte ktorúkoľvek z <br />troch textových oblastí pre ten výpis a kliknite na tlačidlo odoslať.';
$string['gradeletteroverridden'] = 'Východzie hodnoty Slovných známok sú aktuálne prepísané.';
$string['gradeletters'] = 'Slovné známky';
$string['gradelocked'] = 'Známka je zamknutá';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Najvyššia známka';
$string['grademax_help'] = '<p>Ak je typ známky hodnota, potom možno nastaviť jej maximum. Najvyššia známka pre položku hodnotenia založenú na aktivite je nastaviteľný na jej aktualizačnej stránke.</p>';
$string['grademin'] = 'Minimálna možná známka';
$string['grademin_help'] = '<p>Ak je typ známky hodnota, potom možno nastaviť jej minimum.</p>';
$string['gradenotificationmessage'] = 'Máte novú spätnú väzbu o svojej práci pre „{$a}“';
$string['gradenotificationsubject'] = 'Boli ste hodnotení';
$string['gradeoutcomeitem'] = 'Položka hodnotenia - cieľ';
$string['gradeoutcomes'] = 'Ciele';
$string['gradeoutcomescourses'] = 'Ciele kurzu';
$string['gradepass'] = 'Potrebná známka';
$string['gradepass_help'] = 'Toto nastavenie určuje minimálnu potrebnú hodnotu známky, ktorú musia účastníci kurzu získať. Táto hodnota je používaná pri plnení aktivít a absolvovaní kurzu, kde úspešné známky sú vysvietené zelenou a neúspešné červenou.';
$string['gradepassgreaterthangrade'] = 'Požadovaná známka nemôže byť väčšia, ako je maximálna možná známka {$a}';
$string['gradepointdefault'] = 'Východzie body známky';
$string['gradepointdefault_help'] = 'Toto nastavenie určuje východziu hodnotu bodov, ktorá je v položke dostupná.';
$string['gradepointdefault_validateerror'] = 'Toto nastavenie musí byť číslo medzi 1 a maximálnou hodnotou známky.';
$string['gradepointmax'] = 'Maximálna hodnota bodov';
$string['gradepointmax_help'] = 'Toto nastavenie určuje maximálnu bodovú hodnotu známky, ktorá je v aktivite dostupná.';
$string['gradepointmax_validateerror'] = 'Toto nastavenie musí byť celé číslo medzi 1 a 10000.';
$string['gradepreferences'] = 'Preferencie hodnotenia';
$string['gradepreferenceshelp'] = 'Nápoveda pre preferencie v známkovaní';
$string['gradepublishing'] = 'Povoliť zverejnenie';
$string['gradepublishing_help'] = 'Publikovanie známok je spôsob importovania a exportovania známok cez URL bez prihlásenia do Moodle. Ak je táto možnosť povolená, správcovia a používatelia s povolením zverejňovať známky (v predvolenom nastavení iba používatelia s rolou manažéra) budú mať k dispozícii nastavenia zverejňovania exportu známok v každom výkaze klasifikácie.';
$string['gradepublishinglink'] = 'Stiahnuť: {$a}';
$string['gradereport'] = 'Správa o známkach';
$string['graderreport'] = 'Známkový výkaz';
$string['grades'] = 'Známky';
$string['gradesforuser'] = 'Známky pre používateľa {$a->user}';
$string['gradesmoduledeletionpendingwarning'] = 'Varovanie: Prebieha odstraňovanie činnosti! Niektoré známky nemusia byť odstránené.';
$string['gradesmoduledeletionprefix'] = '[Prebieha odstraňovanie]';
$string['gradesonly'] = 'Zmeniť iba známky';
$string['gradessettings'] = 'Nastavenia známok';
$string['gradetype'] = 'Typ známky';
$string['gradetype_help'] = '<p>Určuje typ známky: žiaden (bez hodnotenia), hodnota (povoľuje nastavenia maximálnej a minimálnej známky), stupnica (povoľuje nastavenia stupníc) alebo text (iba komentáre). Iba typy hodnota a stupnica môžu byť ďalej využívané vo výpočtoch. Typ známky pre položku hodnotenia založenú na aktivite je nastaviteľný na jej aktualizačnej stránke.</p>';
$string['gradevaluetoobig'] = 'Jedna zo známok je väčšia, ako je povolená maximálna hodnota {$a}';
$string['gradeview'] = 'Zobraziť známku';
$string['gradewasmodifiedduringediting'] = 'Známka z aktivity {$a->itemname} pre používateľa {$a->username} bola ignorovaná, pretože ju niekto medzitým zmenil.';
$string['gradeweighthelp'] = 'Nápoveda pre vážené známkovanie';
$string['gradingmodulename'] = 'Hodnotenie ({$a})';
$string['groupavg'] = 'Priemer skupiny';
$string['hidden'] = 'Skrytá';
$string['hidden_help'] = 'Ak je nastavené, známky budú pred študentmi skryté. Niekedy je vyhovujúce nastaviť "skryť až do", kedy sa známky ukážu až po určitom dátume.';
$string['hiddenasdate'] = 'Ukázať dátum odovzdania pre skryté známky';
$string['hiddenasdate_help'] = 'Ak používateľ nemôže vidieť skryté známky, zobraz dátum odovzdania miesto \'-\'.';
$string['hiddenuntil'] = 'Skryť do';
$string['hiddenuntildate'] = 'Skryté do: {$a}';
$string['hideadvanced'] = 'Skryť rozšírené voľby';
$string['hideaverages'] = 'Skryť priemery';
$string['hidecalculations'] = 'Skryť výpočty';
$string['hidecategory'] = 'Skryté';
$string['hideeyecons'] = 'Skryť ikony viditeľnosti';
$string['hidefeedback'] = 'Skryť komentár';
$string['hideforcedsettings'] = 'Skryť vnútené nastavenia';
$string['hideforcedsettings_help'] = 'Nezobrazovať predstavené položky v užívateľskom rozhraní známok.';
$string['hidegroups'] = 'Skryť skupiny';
$string['hidelocks'] = 'Skryť zámky';
$string['hidenooutcomes'] = 'Zobraziť ciele';
$string['hidequickfeedback'] = 'Skryť rýchly komentár';
$string['hideranges'] = 'Skryť rozsahy';
$string['hidetotalifhiddenitems'] = 'Skryť súhrnné známky, ak obsahujú skryté položky';
$string['hidetotalifhiddenitems_help'] = '<p>Toto nastavenie určuje, či sumárne známky, ktoré obsahujú skryté položky známok, sú zobrazené študentom alebo sú nahradené pomlčkou (-). Ak sú zobrazené, sumárne známky môžu byť vypočítavané s alebo bez skrytých položiek.</p>
<p>Ak sú skryté položky nezahrnuté, sumárna známka bude pre študenta rozdielna, pretože učiteľ vidí aj skryté známky. </p>
<p>Ak sú skryté známky zahrnuté, študenti môžu byť schopní skrytú položku dopočítať.</p>';
$string['hidetotalshowexhiddenitems'] = 'Zobraziť súhrnné známky nezahrňujúc skryté položky';
$string['hidetotalshowinchiddenitems'] = 'Zobraziť súhrnné známky zahrňujúc skryté položky';
$string['hideverbose'] = 'Skryť {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Triediť podľa známok vzostupne';
$string['highgradedescending'] = 'Triediť podľa známok zostupne';
$string['highgradeletter'] = 'Do';
$string['identifier'] = 'Identifikovať účastníka podľa';
$string['idnumbers'] = 'Identifikátory';
$string['ignore'] = 'Ignorovať';
$string['import'] = 'Import';
$string['importas'] = 'Importovať ako';
$string['importcsv'] = 'Import CSV';
$string['importcsv_help'] = 'Známky je možné importovať pomocou CSV súboru s nasledujúcim formátom:

* Každý záznam je na samostatnom riadku
* Každý záznam je tvorený postupnosťou údajov oddelených čiarkami alebo iným oddeľovačom
* Prvý záznam predstavuje záhlavie a obsahuje požadované identifikačné údaje používateľa - alebo používateľské meno alebo identifikačné číslo alebo e-mailovú adresu.

Správny formát súboru je možné získať tak, že najprv vyexportujete niektoré známky. Súbor je potom možné upraviť a uložiť ako súbor vo formáte CSV.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Importovať ako ciele iba pre tento kurz';
$string['importdata'] = 'Údaje';
$string['importdata_help'] = 'Známky je možné prilepiť priamo z tabuľky OpenDocument alebo Excel v nasledujúcom formáte:

* Aspoň jeden stĺpec by mal obsahovať údaje o identite používateľa – používateľské meno, e-mailovú adresu alebo identifikačné číslo.
* Ostatné stĺpce by mali mať nadpisy ako pre existujúce aktivity alebo položky známok.

Správne naformátovanú tabuľku je možné získať tak, že najskôr exportujete niektoré známky. Tabuľku je možné následne upraviť, pridať ďalšie známky a uložiť.

Vyberte a skopírujte stĺpce, ktoré chcete importovať z tabuľky a potom ich prilepte do tohto poľa.';
$string['importerror'] = 'Vyskytla sa chyba, skript nebol zavolaný so správnymi parametrami';
$string['importfailed'] = 'Importovanie zlyhalo. Žiadne údaje neboli načítané.';
$string['importfeedback'] = 'Importovať komentáre';
$string['importfile'] = 'Importovať súbor';
$string['importfilemissing'] = 'Nebol prijatý súbor. Vráťte sa naspäť a nahrajte správny súbor';
$string['importfrom'] = 'Importovať z';
$string['importoutcomenofile'] = 'Importovaný súbor je prázdny alebo nesprávny. Skontrolujte, že je v správnom formáte. Problém bol zistený na riadku {$a}. Možno nemá rovnaký počet stĺpcov ako prvý riadok (hlavička súboru) alebo chýba hlavička súboru. Skúste exportovať súbor ako príklad správnej hlavičky.';
$string['importoutcomes'] = 'Importovať ciele';
$string['importoutcomes_help'] = 'Ciele môžu byť importované pomocou csv súboru s formátom totožným s csv súborom z exportu.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'Importovaný cieľ "{$a->name}" s identifikátorom #{$a->id}';
$string['importplugins'] = 'Zásuvné moduly pre import';
$string['importpreview'] = 'Náhľad importu';
$string['importsettings'] = 'Nastavenia importu';
$string['importskippednomanagescale'] = 'Nemáte oprávnenie pridať novú stupnicu, takže cieľ "{$a}" preskočený (vyžaduje vytvorenie novej stupnice).';
$string['importskippedoutcome'] = 'Cieľ s krátkym menom "{$a}" už v tomto kontexte existuje, a preto bol v tomto importovanom súbore preskočený.';
$string['importstandard'] = 'Importovať ako štandardné ciele';
$string['importsuccess'] = 'Import prebehol úspešne';
$string['importxml'] = 'Importovať XML';
$string['includescalesinaggregation'] = 'Zahrnúť stupnice vo výpočtoch súhrnnej známky';
$string['includescalesinaggregation_help'] = 'Môžete zmeniť, či majú byť stupnice zahrnuté ako hodnoty vo všetkých súhrnných známkach vo všetkých klasifikáciách vo všetkých kurzoch. UPOZORNENIE: zmena tohto nastavenia spôsobí prepočítanie všetkých výpočtových známok.';
$string['incorrectcourseid'] = 'ID kurzu bolo nesprávne';
$string['incorrectcustomscale'] = '(Neplatná vlastná stupnica - zvoľte inú)';
$string['incorrectminmax'] = 'Minimum musí byť menšie ako maximum';
$string['inherit'] = 'Zdediť';
$string['intersectioninfo'] = 'Študent/známka';
$string['invalidgradeexporteddate'] = 'Dátum exportu je neplatný: alebo je starší ako rok, alebo je v budúcnosti, alebo má neplatný formát.';
$string['item'] = 'Položka';
$string['iteminfo'] = 'Informácia o položke';
$string['iteminfo_help'] = '<p>Miesto pre vloženie informácie o tejto položke. Text sem vložený sa nebude zobrazovať nikde inde.</p>';
$string['itemname'] = 'Názov položky';
$string['itemnamehelp'] = 'Názov položky zaslaný modulom.';
$string['items'] = 'Položky';
$string['itemsedit'] = 'Upraviť položku hodnotenia';
$string['keephigh'] = 'Ponechať najvyššie';
$string['keephigh_help'] = 'Ak sa táto položka nastaví, bude ponechaných iba X najvyšších známok (X je zvolená hodnota)';
$string['keephighestvalues'] = 'Ponechať {$a} najvyšších známok';
$string['keymanager'] = 'Správa kľúčov';
$string['lessthanmin'] = 'Známka vložená pre {$a->itemname} pre {$a->username} je nižšia ako povolené minimum.';
$string['letter'] = 'Slovná známka';
$string['lettergrade'] = 'Slovná známka';
$string['lettergradenonnumber'] = 'Nenumerická hodnota v Od a/alebo Do';
$string['letterpercentage'] = 'Slovná známka (percentuálna hodnota)';
$string['letterreal'] = 'Slovná známka (skutočná hodnota)';
$string['letters'] = 'Slovné známky';
$string['linkedactivity'] = 'Odkazovaná aktivita';
$string['linkedactivity_help'] = '<p>Špecifikuje voliteľnú aktivitu, s ktorou je spojený cieľ predmetu. Spojené aktivity sa používajú na meranie výkonu študenta s nehodnotenými kritériami aktivít.</p>';
$string['linktoactivity'] = 'Odkaz {$a->name} na aktivitu {$a->title}';
$string['lock'] = 'Zamknúť';
$string['locked'] = 'Zamknutá';
$string['locked_help'] = 'Ak je nastavené, známky už nebudú môcť byť automaticky aktualizované príslušnou aktivitou.';
$string['locktime'] = 'Zamknúť po';
$string['locktimedate'] = 'Zamknuté po: {$a}';
$string['lockverbose'] = 'Zamknúť {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Najhorší';
$string['lowgradeletter'] = 'Od';
$string['manageoutcomes'] = 'Spravovať výsledky';
$string['manualitem'] = 'Manuálna položka';
$string['mapfrom'] = 'Namapovať z';
$string['mapfrom_help'] = 'Vyberte stĺpec v údajoch tabuľky obsahujúci identifikáciu používateľa, ako je používateľské meno, ID používateľa, alebo e-mailovú adresu.';
$string['mappings'] = 'Mapovania položiek hodnotenia';
$string['mappings_help'] = 'Pre každý stĺpec známok v tabuľke vyberte príslušnú položku známky pre import známok.';
$string['mapto'] = 'Namapovať na';
$string['mapto_help'] = 'Vyberte rovnaké identifikačné údaje ako vybrané pre "Mapovať z".';
$string['max'] = 'Najlepší';
$string['maxgrade'] = 'Najlepšia možná známka';
$string['meanall'] = 'Všetky známky';
$string['meangraded'] = 'Neprázdne známky';
$string['meanselection'] = 'Známky vybrané pre stĺpcové priemery';
$string['meanselection_help'] = 'Zvoliť, či sa bunky bez známky majú zahrnúť do výpočtov priemeru každého stĺpca.';
$string['median'] = 'Prostredná hodnota (medián)';
$string['min'] = 'Najhorší';
$string['minimum_show'] = 'Zobraziť minimálnu známku';
$string['minimum_show_help'] = 'Najnižšia známka je použitá pre výpočet známok a váh. Ak nie je zobrazená, bude nastavená štandardne na nulu a nebude možné ju upravovať.';
$string['minmaxtouse'] = 'Minimálne a maximálne známky používané vo výpočtoch';
$string['minmaxtouse_desc'] = 'Toto nastavenie určuje, či sa majú použiť počiatočné minimálne a maximálne známky z doby, keď bola známka nastavená, alebo minimálne a maximálne známky, ako je uvedené v nastavení pre položku známky, pri výpočte známky zobrazenej vo výkaze známok. Odporúča sa, aby toto nastavenie bolo modifikované mimo vyťaženia servera, pretože prepočet všetkých známok môže mať za následok vysoká záťaž serveru.';
$string['minmaxtouse_help'] = 'Toto nastavenie určuje, či sa majú použiť počiatočné minimálne a maximálne známky z doby, keď bola známka nastavená, alebo minimálne a maximálne známky, ako je uvedené v nastavení pre položku známky, pri výpočte známky zobrazenej vo výkaze známok.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Poznámka: Niektoré hodnotenia sa zmenili, aby sa vyriešili nekonzistencie vo výkaze známok spôsobené zmenou minimálneho a maximálneho hodnotenia používaného pri výpočte zobrazeného hodnotenia. Odporúča sa, aby ste tieto zmeny posúdili a prijali.';
$string['minmaxupgradefixbutton'] = 'Vyriešiť nezrovnalosti';
$string['minmaxupgradewarning'] = 'Poznámka: U niektorých hodnoteniach bola zistená nekonzistencia z dôvodu zmeny minimálneho a maximálneho hodnotenia používaného pri výpočte hodnotenia zobrazeného vo výkaze známok. Odporúča sa túto nekonzistenciu vyriešiť stlačením tlačidla nižšie, aj keď to povedie k tomu, že niektoré hodnotenia sa zmenia.';
$string['missingitemtypeoreid'] = 'Kľúčové pole (itemtype alebo eid) chýba v 2. parametri grade_edit_tree_column_select::get_item_cell($item, $params)';
$string['missingscale'] = 'Stupnica musí byť vybraná';
$string['mode'] = 'Režim (mód)';
$string['modgrade'] = 'Známka';
$string['modgrade_help'] = 'Zvoľte typ známkovania pre túto činnosť. Ak použijete stupnicu, môžete potom zvoliť jej typ pomocou rozbaľovacej ponuky v možnosti Stupnica. Ak zvolíte body, môžete pre túto aktivitu nastaviť maximálny počet bodov.';
$string['modgradecantchangegradetype'] = 'Nemôžete zmeniť typ, pretože známky pre túto položku už existujú.';
$string['modgradecantchangegradetypemsg'] = 'Už boli vložené niektoré známky, takže typ známky nie je možné zmeniť. Ak chcete zmeniť maximálny počet bodov, je potrebné najprv zvoliť, či nemá byť uskutočnené nové známkovanie, ktoré aktuálne známky zmení.';
$string['modgradecantchangegradetyporscalemsg'] = 'Už boli vložené niektoré známky, takže typ známky alebo stupnice nie je možné zmeniť.';
$string['modgradecantchangeratingmaxgrade'] = 'Maximálny počet bodov nie je možné zmeniť, pretože pre niektorú aktivitu už existujú známky.';
$string['modgradecantchangescale'] = 'Stupnica nemôže byť zmenená, pretože pre túto položku už existujú známky.';
$string['modgradecategorycantchangegradetypemsg'] = 'Táto kategória je spojená klasifikovanými položkami, ktoré boli prepísané. Z tohto dôvodu už prebehlo známkovanie, takže typ známky nie je možné zmeniť. Ak chcete zmeniť maximálny počet bodov, je potrebné najprv zvoliť, či má alebo nemá prebehnúť nové známkovanie, ktoré zmení existujúce známky.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Táto kategória je spojená klasifikovanými položkami, ktoré boli prepísané. Z tohto dôvodu už prebehlo známkovanie, takže typ známky nie je možné zmeniť.';
$string['modgradecategoryrescalegrades'] = 'Zmeniť stupnice prepísaných známok';
$string['modgradecategoryrescalegrades_help'] = 'Pri zmene maximálnej známky v položke hodnotenia je treba určiť, či to spôsobí alebo nespôsobí rovnakú percentuálnu zmenu u existujúcich známok.

Ak je táto voľba nastavená na "Áno", budú upravené všetky existujúce známky tak, že percento známky zostáva rovnaké.

Napríklad, ak je táto možnosť nastavená na "Áno", zmena maximálneho počtu bodov  položky z 10 na 20 by zmenila známku zo 6/10 (60%) na 12/20 (60%). S touto voľbou nastavenou na "Nie", zostane známka bez zmeny, pre zachovanie správnej známky je vyžadované manuálne nastavenie položiek známok .';
$string['modgradedonotmodify'] = 'Neupravujte existujúce známky.';
$string['modgradeerrorbadpoint'] = 'Neplatná hodnota známky. Musí to byť celé číslo medzi 1 a {$a}';
$string['modgradeerrorbadscale'] = 'Neplatná stupnica. Vyberte stupnicu z uvedeného výberu.';
$string['modgrademaxgrade'] = 'Maximum bodov';
$string['modgraderescalegrades'] = 'Zmeniť stupnicu existujúcich známok';
$string['modgraderescalegrades_help'] = 'Pri zmene maximálnej známky v položke hodnotenia je treba určiť, či to spôsobí alebo nespôsobí rovnakú percentuálnu zmenu u existujúcich známok.

Ak je táto voľba nastavená na "Áno", budú upravené všetky existujúce známky tak, že percento známky zostáva rovnaké.

Napríklad, ak je táto možnosť nastavená na "Áno", zmena maximálneho počtu bodov  položky z 10 na 20 by zmenila známku zo 6/10 (60%) na 12/20 (60%). S touto voľbou nastavenou na "Nie", zostane známka bez zmeny, pre zachovanie správnej známky je vyžadované manuálne nastavenie položiek známok .';
$string['modgradetype'] = 'Typ';
$string['modgradetypenone'] = 'Žiadna';
$string['modgradetypepoint'] = 'Body';
$string['modgradetypescale'] = 'Stupnica';
$string['morethanmax'] = 'Známka vložená pre {$a->itemname} pre {$a->username} je vyššia ako povolené maximum.';
$string['moveselectedto'] = 'Presunúť vybrané položky do';
$string['movingelement'] = 'Presúvanie {$a}';
$string['multfactor'] = 'Násobiaci koeficient';
$string['multfactor_help'] = '<p>Koeficient, ktorým sú vynásobené všetky položky hodnotenia tento položky, pričom maximálnou hodnotou bode maximum známky.</p>';
$string['multfactorvalue'] = 'Hodnota multiplikátoru {$a}';
$string['mustchooserescaleyesorno'] = 'Musíte vybrať, či chcete zmeniť stupnicu existujúcich známok, alebo nie.';
$string['mygrades'] = 'Odkaz na známky v používateľskom menu';
$string['mygrades_desc'] = 'Toto nastavenie umožňuje možnosť prepojenia s externým zadávaním z používateľského menu.';
$string['mypreferences'] = 'Moje preferencie';
$string['myreportpreferences'] = 'Moje preferencie výkazu';
$string['myself'] = 'Ja sám';
$string['navmethod'] = 'Metóda navigácie';
$string['neverdeletehistory'] = 'Nikdy nevymazať históriu';
$string['newcategory'] = 'Nová kategória';
$string['newitem'] = 'Nová položka hodnotenia';
$string['newoutcomeitem'] = 'Nový hodnotený cieľ';
$string['no'] = 'Nie';
$string['nocategories'] = 'Kategórie známkovania nemohli byť pridané alebo nájdené pre tento kurz';
$string['nocategoryname'] = 'Nebolo zadané meno kategórie';
$string['nocategoryview'] = 'Žiadna kategória na prezretie podľa';
$string['nocourses'] = 'Nie sú zatiaľ žiadne kurzy';
$string['noexistingoutcomes'] = 'Neexistujú žiadne výsledky.';
$string['noexistingscales'] = 'Neexistujú žiadne stupnice.';
$string['noforce'] = 'Nevnútiť';
$string['nogradeletters'] = 'Nenastavené slovné známky';
$string['nogradesreturned'] = 'Žiadne známky vrátené';
$string['noidnumber'] = 'Žiaden identifikátor';
$string['nolettergrade'] = 'Žiadne slovné známky pre';
$string['nomode'] = 'NA';
$string['nonnumericweight'] = 'Prijatá hodnota nečíselného typu pre';
$string['nonunlockableverbose'] = 'Táto známka nemôže byť odomknutá, kým nebude odomknutá položka {$a->itemname}';
$string['nonweightedpct'] = 'nevážené %';
$string['nooutcome'] = 'Neexistuje cieľ';
$string['nooutcomes'] = 'Položky cieľov musia byť viazané k cieľom kurzu. V tomto kurze však nie sú definované žiadne ciele. Chceli by ste nejaký cieľ pridať?';
$string['nopermissiontoresetweights'] = 'Nemáte oprávnenie k vymazaniu váhy známky';
$string['nopublish'] = 'Nepublikovať';
$string['noreports'] = 'Nie ste zapísaný do žiadneho kurzu alebo neučíte v kurzoch.';
$string['norolesdefined'] = 'Nie sú definované roly v menu Administratíva > Známky > Všeobecné nastavenia > Roly pre známky';
$string['noscales'] = 'Ciele musia byť viazané na stupnice v kurze alebo na portáli. Žiadne však neexistujú- Chceli by ste nejakú stupnicu pridať?';
$string['noselectedcategories'] = 'neboli vybrané kategórie';
$string['noselecteditems'] = 'neboli vybrané položky';
$string['notenrolled'] = 'Aktuálne nie ste zapísaní v žiadnom kurze.';
$string['notteachererror'] = 'Prístup k týmto údajom majú iba učitelia';
$string['nousersloaded'] = 'Nie sú nahraní žiadni používatelia';
$string['nouserstograde'] = 'Žiadni používatelia na hodnotenie';
$string['numberofgrades'] = 'Počet známok';
$string['onascaleof'] = 'na stupnici od {$a->grademin} do {$a->grademax}';
$string['operations'] = 'Operácie';
$string['options'] = 'Voľby';
$string['others'] = 'Ostatné';
$string['otheruser'] = 'Používateľ';
$string['outcome'] = 'Cieľ';
$string['outcome_help'] = 'Určuje cieľ, ktorý bude táto položka známkovania reprezentovať vo výkaze. Dostupné sú iba ciele v tomto kurze a globálne ciele na portáli.';
$string['outcomeassigntocourse'] = 'Pridať k kurzu ďalší cieľ';
$string['outcomecategory'] = 'Vytvoriť ciele v kategórii';
$string['outcomecategorynew'] = 'Nová kategória';
$string['outcomeconfirmdelete'] = 'Naozaj chcete vymazať cieľ "{$a}"?';
$string['outcomecreate'] = 'Pridať nový cieľ';
$string['outcomedelete'] = 'Vymazať cieľ';
$string['outcomefullname'] = 'Celý názov';
$string['outcomeitem'] = 'Hodnotený cieľ';
$string['outcomeitemsedit'] = 'Upraviť cieľ';
$string['outcomereport'] = 'Výkaz cieľov';
$string['outcomes'] = 'Ciele';
$string['outcomescourse'] = 'Ciele použité v kurze';
$string['outcomescoursecustom'] = 'Používateľské ciele (neodstraňovať)';
$string['outcomescoursenotused'] = 'Nepoužité štandardné ciele';
$string['outcomescourseused'] = 'Použité štandardné ciele (neodstrániť)';
$string['outcomescustom'] = 'Používateľské ciele';
$string['outcomesdisabled'] = 'Výsledky nie sú povolené';
$string['outcomeshortname'] = 'Skrátené meno';
$string['outcomesstandard'] = 'Štandardné ciele';
$string['outcomesstandardavailable'] = 'Dostupné štandardné ciele';
$string['outcomestandard'] = 'Štandardný cieľ';
$string['outcomestandard_help'] = 'Štandardný cieľ je dostupný pre všetky kurzy.';
$string['overallaverage'] = 'Celkový priemer';
$string['overridden'] = 'Prestavená';
$string['overridden_help'] = '<p>Ak je položka prestavená, nie je možné ju v budúcnosti automaticky nastavovať, ale iba manuálne. Najčastejšie túto voľbu zapína samotný modul známok. Tento formulár umožňuje jeho manuálne prestavenie.</p>';
$string['overriddennotice'] = 'Výsledná známka z tejto aktivity bola manuálne zmenená.';
$string['overridecat'] = 'Povoliť ručný prepis známky kategórie';
$string['overridecat_help'] = 'Zákaz tohto nastavenia znemožňuje používateľom prepísať známky kategórie';
$string['overridesitedefaultgradedisplaytype'] = 'Prestavenie východzích nastavení portálu';
$string['overridesitedefaultgradedisplaytype_help'] = '<p>Zvolením tejto voľby sa umožní prepísať prednastavenie celého portálu pre zobrazovanie hodnotenia vo výkaze známok.  Táto voľba aktivuje formulár prvkov, ktorý umožní určenie slovných známok a ich rozsah.</p>';
$string['overrideweightofa'] = 'Prepísať váhu {$a}';
$string['parentcategory'] = 'Rodičovská kategória';
$string['pass'] = 'Úspech';
$string['pctoftotalgrade'] = '% z celkovej známky';
$string['percent'] = 'Percento';
$string['percentage'] = 'Percentuálna hodnota';
$string['percentageletter'] = 'Percentuálna hodnota (slovná známka)';
$string['percentagereal'] = 'Percentuálna hodnota (skutočná hodnota)';
$string['percentascending'] = 'Triediť podľa percent vzostupne';
$string['percentdescending'] = 'Triediť podľa percent zostupne';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Posun';
$string['plusfactor_help'] = '<p>Číslo, ktoré bude pripočítané k každej známke tejto položky známkovania potom, čo bol aplikovaný Násobiaci koeficient.</p>';
$string['plusfactorvalue'] = 'Pripočítaná hodnota {$a}';
$string['points'] = 'body';
$string['pointsascending'] = 'Triediť podľa bodov vzostupne';
$string['pointsdescending'] = 'Triediť podľa bodov zostupne';
$string['positionfirst'] = 'Prvý';
$string['positionlast'] = 'Posledný';
$string['preferences'] = 'Preferencie';
$string['prefgeneral'] = 'Všeobecné';
$string['prefletters'] = 'Slovné známky a ich rozsahy';
$string['prefrows'] = 'Špeciálne riadky';
$string['prefshow'] = 'Zobraziť/skryť prepínače';
$string['previewrows'] = 'Náhľad riadkov';
$string['privacy:metadata:categorieshistory'] = 'Záznam predchádzajúcich verzií kategórií známok';
$string['privacy:metadata:filepurpose'] = 'Súbory spätnej väzby uložené v známkach používateľa.';
$string['privacy:metadata:grade_import_newitem'] = 'Dočasná tabuľka pre ukladanie nových názvov grade_item z importu známok';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Jedinečný identifikátor pre určenie jednej dávky importu';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Používateľ importujúci údaje';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Názov novej položky známok';
$string['privacy:metadata:grade_import_values'] = 'Dočasná tabuľka pre import známok';
$string['privacy:metadata:grade_import_values:feedback'] = 'Komentár známky';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Prvotná hodnota známky';
$string['privacy:metadata:grade_import_values:importcode'] = 'Jedinečný kód dávky pre identifikáciu jednej dávky importu';
$string['privacy:metadata:grade_import_values:importer'] = 'Používateľ importujúci údaje';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Príznak, či boli importované iba komentáre';
$string['privacy:metadata:grade_import_values:userid'] = 'Používateľ, ktorého známka bola importovaná';
$string['privacy:metadata:grades'] = 'Záznam známok';
$string['privacy:metadata:grades:aggregationstatus'] = 'Stav agregácie';
$string['privacy:metadata:grades:aggregationweight'] = 'Váha v agregácii';
$string['privacy:metadata:grades:feedback'] = 'Komentár';
$string['privacy:metadata:grades:finalgrade'] = 'Známka';
$string['privacy:metadata:grades:information'] = 'Ďalšie informácie o hodnotení';
$string['privacy:metadata:grades:timemodified'] = 'Čas poslednej zmeny známky';
$string['privacy:metadata:grades:userid'] = 'ID používateľa tejto známky';
$string['privacy:metadata:grades:usermodified'] = 'ID používateľa, ktorý naposledy zmenil záznam';
$string['privacy:metadata:gradeshistory'] = 'Záznam predchádzajúcich známok';
$string['privacy:metadata:history:loggeduser'] = 'ID používateľa, ktorý bol prihlásený pre vykonaní verzionovania';
$string['privacy:metadata:history:timemodified'] = 'Čas, kedy došlo k verzionovaniu';
$string['privacy:metadata:itemshistory'] = 'Záznam predchádzajúcich verzií položiek známky';
$string['privacy:metadata:outcomes'] = 'Záznam očakávaných výstupov';
$string['privacy:metadata:outcomes:timemodified'] = 'Čas zmeny záznamu';
$string['privacy:metadata:outcomes:usermodified'] = 'Používateľ, ktorý naposledy zmenil záznam';
$string['privacy:metadata:outcomeshistory'] = 'Záznam predchádzajúcich verzií očakávaných výstupov';
$string['privacy:metadata:scale'] = 'Záznam stupníc';
$string['privacy:metadata:scale:timemodified'] = 'Čas poslednej zmeny záznamu';
$string['privacy:metadata:scale:userid'] = 'Používateľ, ktorý zmenil záznam naposledy';
$string['privacy:metadata:scalehistory'] = 'Záznam predchádzajúcich verzií stupníc';
$string['privacy:path:relatedtome'] = 'Súvisiaci so mnou';
$string['privacy:request:historyactiondelete'] = 'Vymazať';
$string['privacy:request:historyactioninsert'] = 'Vložiť';
$string['privacy:request:historyactionupdate'] = 'Upraviť';
$string['privacy:request:unknowndeletedgradeitem'] = 'Neznáme (položka hodnotenia bola vymazaná)';
$string['profilereport'] = 'Používateľský výkaz';
$string['profilereport_help'] = 'Typ známkového výkazu použitého na profilovej stránke používateľa';
$string['publishing'] = 'Publikovanie';
$string['publishingoptions'] = 'Nastavenie publikovania známok';
$string['quickfeedback'] = 'Rýchly komentár';
$string['quickgrading'] = 'Rýchle hodnotenie';
$string['quickgrading_help'] = '<p>Rýchle hodnotenie pridáva vstupné textové pole v každej hodnotenej položke známkového výkazu. Takto sa jednoduchšie zadáva viacero hodnotení naraz. Po ich zadaní kliknite na tlačidlo Aktualizovať a všetky zadané hodnotenia budú uložené naraz.</p>';
$string['range'] = 'Rozsah';
$string['rangedecimals'] = 'Desatinné miesta v rozsahoch';
$string['rangedecimals_help'] = 'Počet desatinných miest pre zobrazenie rozsahu známky';
$string['rangesdecimalpoints'] = 'Desatinné miesta v rozsahoch';
$string['rangesdecimalpoints_help'] = 'Určuje počet desatinných miest v každom rozsahu. Toto nastavenie môže byť zmenené pri každej položke známok.';
$string['rangesdisplaytype'] = 'Typ zobrazenia rozsahu';
$string['rangesdisplaytype_help'] = '<p>Určuje spôsob zobrazenia rozsahov stĺpcov. Ak je zvolené Zdediť, použije sa rovnaké zobrazenie ako pre každý stĺpec. </p>';
$string['rank'] = 'Poradie';
$string['rawpct'] = 'Hrubé  %';
$string['real'] = 'Skutočná hodnota';
$string['realletter'] = 'Skutočná hodnota (slovná známka)';
$string['realpercentage'] = 'Skutočná hodnota (percentuálna hodnota)';
$string['recalculatinggrades'] = 'Prepočítať známky';
$string['recovergradesdefault'] = 'Východzie nastavenie obnovenia známok';
$string['recovergradesdefault_help'] = 'Pri obnovenom zápise študenta do kurzu sa obnoví staré hodnotenie.';
$string['refreshpreview'] = 'Obnoviť náhľad';
$string['regradeanyway'] = 'Preznámkovať v každom prípade';
$string['removeallcoursegrades'] = 'Vymazať všetky známky';
$string['removeallcoursegrades_help'] = 'Vybraním poľa odstránite všetky známky, ktoré boli manuálne vložené do výkazu známok v kurze, zároveň s prepísanými, vylúčenými, skrytými a zamknutými známkami. Zachovajú sa iba položky známok súvisiace s aktivitami.';
$string['removeallcourseitems'] = 'Vymazať všetky položky a kategórie';
$string['removeallcourseitems_help'] = 'Vybraním poľa odstránite všetky kategórie a známky, ktoré boli manuálne vložené do výkazu známok v kurze, zároveň s prepísanými, vylúčenými, skrytými a zamknutými známkami a údajmi. Zachovajú sa iba položky známok súvisiace s aktivitami.';
$string['report'] = 'Výkaz';
$string['reportdefault'] = 'Štandardný pre výkaz ({$a})';
$string['reportplugins'] = 'Zásuvné moduly výkazov';
$string['reportsettings'] = 'Nastavenia výkazov';
$string['reprintheaders'] = 'Opakovať hlavičky';
$string['resetweights'] = 'Obnoviť váhu {$a->itemname}';
$string['resetweightsshort'] = 'Obnoviť váhy';
$string['respectingcurrentdata'] = 'ponechanie súčasnej konfigurácie nezmenenej';
$string['rowpreviewnum'] = 'Náhľad riadkov';
$string['rowpreviewnum_help'] = 'Pred potvrdením importu údajov si môžete zobraziť náhľad údajov k importu. Toto nastavenie určuje, koľko riadkov má byť zobrazených v rámci náhľadu.';
$string['savechanges'] = 'Uložiť zmeny';
$string['savepreferences'] = 'Uložiť preferencie';
$string['scaleconfirmdelete'] = 'Naozaj chcete vymazať stupnicu "{$a}"?';
$string['scaledpct'] = 'Škálované %';
$string['searchgroups'] = 'Hľadať skupiny';
$string['searchusers'] = 'Vyhľadajte používateľov';
$string['seeallcoursegrades'] = 'Vidieť všetky známky v kurze';
$string['select'] = 'Vyberte {$a}';
$string['selectalloroneuser'] = 'Vybrať všetkých alebo jedného používateľa';
$string['selectauser'] = 'Vybrať používateľa';
$string['selectdestination'] = 'Vybrať cieľ pre {$a}';
$string['selectgrouplink'] = 'Vyberte skupinu';
$string['selectuserlink'] = 'Vyberte používateľa';
$string['separator'] = 'Oddeľovač';
$string['separator_help'] = 'Vyberte oddeľovač použitý v súboru CSV. (Obvykle je to čiarka).';
$string['sepcolon'] = 'Dvojbodka';
$string['sepcomma'] = 'Čiarka';
$string['sepsemicolon'] = 'Bodkočiarka';
$string['septab'] = 'Tabulátor';
$string['setcategories'] = 'Nastaviť kategórie';
$string['setcategorieserror'] = 'Predtým, ako dáte kategóriám určitú váhu, musíte najprv nastaviť kategórie pre Váš kurz.';
$string['setgradeletters'] = 'Nastaviť slovné známky';
$string['setpreferences'] = 'Nastaviť preferencie';
$string['setting'] = 'Nastavenie';
$string['settings'] = 'Nastavenia';
$string['setup'] = 'Nastavenie';
$string['setweights'] = 'Nastaviť váhy';
$string['showactivityicons'] = 'Zobraziť ikony aktivít';
$string['showactivityicons_help'] = '<p>Či zobraziť ikony aktivít spolu s ich názvami.</p>';
$string['showallgrades'] = 'Zobraziť všetky známky';
$string['showallhidden'] = 'Zobraziť skryté';
$string['showallstudents'] = 'Zobraziť všetkých študentov';
$string['showanalysisicon'] = 'Zobraziť ikonu analýzy hodnotenia';
$string['showanalysisicon_desc'] = 'Či sa má zobraziť ikona analýzy hodnotenia. Ak daná aktivita podporuje hodnotenie, ikona odkazuje na stránku s detailným vysvetlením, ako bolo hodnotenie získané.';
$string['showanalysisicon_help'] = 'Ak to podporuje modul aktivity, ikona analýza známky odkazuje na stránku s podrobnejším vysvetlením známky a ako  bola získaná.';
$string['showaverage'] = 'Zobraziť priemer';
$string['showaverage_help'] = 'Či sa má zobrazovať stĺpec s priemernou hodnotou. Študenti môžu byť schopní odhadnúť známky ostatných študentov, ak je priemer počítaný z malého množstva známok. Z dôvodov výkonnosti je priemer iba približný, ak závisí na nejakej skrytej položke.';
$string['showaverages'] = 'Zobraziť priemery stĺpcov';
$string['showaverages_help'] = 'Zobraziť priemery pre každý stĺpec.';
$string['showcalculations'] = 'Zobraziť výpočty';
$string['showcalculations_help'] = 'Zobraziť ikonu kalkulačky vedľa každej hodnotenej položky a kategórie, tooltipy pre vypočítavané položky a vizuálny indikátor, že stĺpec je vypočítavaný.';
$string['showcontributiontocoursetotal'] = 'Zobraziť podiel z celkovej známky kurzu';
$string['showcontributiontocoursetotal_help'] = 'Zobraziť ďalší stĺpec, ktorý obsahuje vypočítaný podiel z celkovej známky kurzu (po použití váhy známky)?';
$string['showeyecons'] = 'Zobraziť ikony viditeľnosti';
$string['showeyecons_help'] = 'Zobraziť ikonu "ukázať/schovať" pri každej známke (určenie viditeľnosti pre daného používateľa).';
$string['showfeedback'] = 'Zobraziť komentár';
$string['showfeedback_help'] = 'Či sa má zobraziť stĺpec obsahujúci doplňujúce komentáre ku známkam.';
$string['showgrade'] = 'Zobraziť známky';
$string['showgrade_help'] = 'Či sa má zobraziť stĺpec známok?';
$string['showgroups'] = 'Zobraziť skupiny';
$string['showhiddenitems'] = 'Zobraziť skryté položky';
$string['showhiddenitems_help'] = 'Určuje, ako sú zobrazené skryté známky. Môžu byť úplne skryté, alebo je vidno aspoň ich názvy.

* Zobraziť skryté - názvy skrytých položiek sú zobrazené, ale samotné známky nie
* Iba skryté do - Do určitého dátumu sú známky úplne skryté a potom úplne zobrazené
* Nezobraziť - Nie je vidno ani známky, ani názvy.';
$string['showhiddenuntilonly'] = 'Skryté iba do';
$string['showingaggregatesonly'] = 'Zobraziť iba súhrny';
$string['showingfullmode'] = 'Zobraziť celkový prehľad';
$string['showinggradesonly'] = 'Zobraziť iba známky';
$string['showlettergrade'] = 'Zobraziť slovné známky';
$string['showlettergrade_help'] = 'Ukázať stĺpec slovných známok?';
$string['showlocks'] = 'Zobraziť zámky';
$string['showlocks_help'] = 'Zobraziť ikonu zamknúť/odomknúť pri každej známke.';
$string['shownohidden'] = 'Nezobraziť';
$string['shownooutcomes'] = 'Skryť ciele';
$string['shownumberofgrades'] = 'Zobraziť počet známok v známkach';
$string['shownumberofgrades_help'] = 'Zobraziť počet známok použitých pri výpočte priemeru v zátvorkách, napríklad  45 (34).';
$string['showonlyactiveenrol'] = 'Zobraziť iba aktívnych zapísaných študentov';
$string['showonlyactiveenrol_help'] = 'Toto nastavenie určuje, či budú v zostave známok zobrazení iba aktívne zapísaní používatelia. Ak sú povolení pozastavení používatelia, nebudú v zostave známok uvedení.';
$string['showpercentage'] = 'Zobraziť percentá';
$string['showpercentage_help'] = 'Či zobraziť percentuálnu hodnotu každej položky známkovania.';
$string['showquickfeedback'] = 'Zobraziť rýchly komentár';
$string['showquickfeedback_help'] = 'Rýchly komentár pridáva formulár do každej bunky hodnotenia v známkovom výkaze. Pomocou neho možno upravovať komentár pre viacero známok naraz. Po ukončení úprav je potrebné kliknúť na tlačidlo Aktualizovať, aby sa všetky zmeny uložili.';
$string['showrange'] = 'Zobraziť rozsahy';
$string['showrange_help'] = 'Či zobraziť stĺpec rozsahu?';
$string['showranges'] = 'Zobraziť rozsahy';
$string['showranges_help'] = 'Zobraziť rozsah bodov pre každý stĺpec v novom riadku.';
$string['showrank'] = 'Zobraziť poradie';
$string['showrank_help'] = 'Či zobraziť pozíciu účastníka vzhľadom k celému kurzu pre každú položku známkovania?';
$string['showuserimage'] = 'Zobraziť fotografie účastníkov';
$string['showuserimage_help'] = 'Zobraziť obrázok používateľa spolu s menom v známkovom výkaze.';
$string['showverbose'] = 'Zobraziť {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Zobraziť váhy';
$string['showweight_help'] = 'Či zobraziť stĺpec s váhami známok.';
$string['simpleview'] = 'Režim jedného používateľa';
$string['sitewide'] = 'Pre celý portál';
$string['sort'] = 'triediť';
$string['sortasc'] = 'Triediť vzostupne';
$string['sortbyfirstname'] = 'Triediť podľa krstného mena';
$string['sortbylastname'] = 'Triediť podľa priezviska';
$string['sortdesc'] = 'Triediť zostupne';
$string['standarddeviation'] = 'Štandardná odchýlka';
$string['stats'] = 'Štatistika';
$string['statslink'] = 'Štatistiky';
$string['student'] = 'Študent';
$string['studentsperpage'] = 'Počet študentov na stránku';
$string['studentsperpage_help'] = 'Počet študentov na strane v známkovom výkaze.';
$string['studentsperpagereduced'] = 'Znížte maximálny počet študentov na stránke z {$a->originalstudentsperpage} na {$a->studentsperpage}. Zvážte zvýšenie PHP max_input_vars z {$a->maxinputvars}.';
$string['subcategory'] = 'Normálna kategória';
$string['submissions'] = 'Odovzdané zadania';
$string['submittedon'] = 'Odovzdaných: {$a}';
$string['sumofgradesupgradedgrades'] = 'Poznámka: Metóda výpočtu "Súčet známok" bola počas aktualizácie portálu zmenená na "Prirodzené váhovanie". Vzhľadom k tomu, že táto metóda bola v tomto kurze použitá, doporučujeme, aby ste skontrolovali výpočet známok.';
$string['switchtofullview'] = 'Prepnúť do plného režimu';
$string['switchtosimpleview'] = 'Prepnúť do zjednodušeného režimu';
$string['tabs'] = 'Záložky';
$string['topcategory'] = 'Superkategória';
$string['total'] = 'Celkom';
$string['totalweight100'] = 'Celková váha sa rovná 100';
$string['totalweightnot100'] = 'Celková váha nie je rovná 100';
$string['turnfeedbackoff'] = 'Vypnúť komentáre';
$string['turnfeedbackon'] = 'Zapnúť komentáre';
$string['typenone'] = 'Žiaden';
$string['typescale'] = 'Stupnica';
$string['typescale_help'] = '<p>Stupnica môže byť vybraná ak je zvolená položka tohto typu. Typ stupnice pre položku hodnotenia založenú na aktivite je nastaviteľný na jej aktualizačnej stránke.</p>';
$string['typetext'] = 'Text';
$string['typevalue'] = 'Hodnota';
$string['uncategorised'] = 'Nezaradené';
$string['unchangedgrade'] = 'Známka je nezmenená';
$string['unenrolledusersinimport'] = 'Tento import zahrnul nasledovné známky používateľov, ktorí nie sú účastníkmi tohto kurzu: {$a}';
$string['unlimitedgrades'] = 'Neobmedzené známky';
$string['unlimitedgrades_help'] = 'Východzie nastavenie zámok je ohraničené minimálnou a maximálnou hodnotou položky známky. Ak povolíte toto nastavenie, bude možné zadávať vo výkaze známok aj známky  na viac ako 100%.';
$string['unlock'] = 'Odomknúť';
$string['unlockverbose'] = 'Odomknúť {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Nepoužité';
$string['updatedgradesonly'] = 'Exportovať iba nové alebo aktualizované známky';
$string['upgradedgradeshidemessage'] = 'OK';
$string['upgradedminmaxrevertmessage'] = 'Vrátiť zmeny';
$string['uploadgrades'] = 'Nahrať známky';
$string['useadvanced'] = 'Použiť rozšírené voľby';
$string['usedcourses'] = 'Používané kurzy';
$string['usedgradeitem'] = 'Používané položky hodnotenia';
$string['usenooutcome'] = 'Nepoužívať žiaden cieľ';
$string['usenoscale'] = 'Nepoužívať žiadnu stupnicu';
$string['usepercent'] = 'Použiť percentá';
$string['user'] = 'Používateľ';
$string['userenrolmentsuspended'] = 'Zápis používateľa pozastavený';
$string['userfields_show'] = 'Zobraziť používateľské polia';
$string['userfields_show_help'] = 'Do zostavy známok zobraziť ďalšie používateľské polia, ako je e-mailová adresa.  Zobrazenie vybraných polí  je riadené nastavením stránky zobraziť identitu.';
$string['usergrade'] = 'Používateľ {$a->fullname} ({$a->useridnumber}) na položke {$a->gradeidnumber}';
$string['userid'] = 'Identifikátor používateľa';
$string['useridnumberwarning'] = 'Používatelia bez identifikačného čísla sú vylúčení z exportu, preto nie je možné importovať.';
$string['usermappingerror'] = 'Chyba mapovania používateľa: Nie je možné nájsť používateľa s {$a->field} z "{$a->value}".';
$string['usermappingerrorcurrentgroup'] = 'Používateľ nie je členom aktuálnej skupiny.';
$string['usermappingerrormultipleusersfound'] = 'Chyba mapovania používateľa: Viac používateľov nájdených s {$a->field} s "{$a->value}". Použite prosím unikátne pole pre mapovanie.';
$string['usermappingerrorusernotfound'] = 'Chyba mapovania používateľa: Nie je možné nájsť používateľa.';
$string['userpreferences'] = 'Používateľské preferencie';
$string['useweighted'] = 'Použiť vážené';
$string['verbosescales'] = 'Doslovné stupnice';
$string['verbosescales_help'] = 'Podrobná stupnica používa skôr slová ako čísla. Nastavte "Áno", ak majú byť importované numerické známky a stupnice. Nastavte "Nie", ak sú importované iba číselné známky.';
$string['viewbygroup'] = 'Skupina';
$string['viewgrades'] = 'Zobraziť známky';
$string['weight'] = 'Váha';
$string['weight_help'] = 'Hodnota použitá pre stanovenie relatívnej hodnoty známok v kategórii alebo kurze.';
$string['weightcourse'] = 'Použiť vážené známky v kurze';
$string['weightedascending'] = 'Triediť podľa váženého percenta vzostupne';
$string['weighteddescending'] = 'Triediť podľa váženého percenta zostupne';
$string['weightedpct'] = 'vážené %';
$string['weightedpctcontribution'] = 'vážené % príspevku';
$string['weightofa'] = 'Váha {$a}';
$string['weightorextracredit'] = 'Váha alebo extra body';
$string['weightoverride'] = 'upravenie váhy';
$string['weightoverride_help'] = 'Aby ste resetovali automaticky vypočítanú váhu svojej známky, zrušte výber. Zabránite tým automatickému nastaveniu váh.';
$string['weights'] = 'Váhy';
$string['weightsadjusted'] = 'Vaše váhy boli upravené na celkových 100.';
$string['weightsedit'] = 'Upraviť váhy a extra body';
$string['weightuc'] = 'Vypočítaná váha';
$string['writinggradebookinfo'] = 'Zapisujem nastavenia písomnej klasifikácie';
$string['xml'] = 'XML';
$string['yes'] = 'Áno';
$string['yourgrade'] = 'Vaša známka';
