<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'feedback', language 'lo', version '4.1'.
 *
 * @package     feedback
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_item'] = 'ເພີ່ມຄຳຖາມ';
$string['add_pagebreak'] = 'ເພີ່ມການຂັ້ນໜ້າ';
$string['adjustment'] = 'ການດັດປັບ';
$string['after_submit'] = 'ຫຼັງຈາກການສົ່ງ';
$string['allowfullanonymous'] = 'ອະນຸຍາດຜູ້ບໍ່ປະສົງອອກນາມເຕັມຮູບແບບ';
$string['analysis'] = 'ວິເຄາະ';
$string['anonymous'] = 'ຜູ້ບໍ່ປະສົງອອກນາມ';
$string['anonymous_edit'] = 'ບັນທຶກຊື່ຜູ້ໃຊ້';
$string['anonymous_entries'] = 'ລາຍການຜູ້ບໍ່ປະສົງອອກນາມ ({$a})';
$string['anonymous_user'] = 'ຜູ້ໃຊ້ບໍ່ປະສົງອອກນາມ';
$string['answerquestions'] = 'ຕອບຄຳຖາມ';
$string['append_new_items'] = 'ຕິດຄັດລາຍການໃໝ່';
$string['autonumbering'] = 'ຈຳນວນຄຳຖາມອັດຕະໂນມັດ';
$string['autonumbering_help'] = 'ເປີດໃຊ້ງານ ຫຼື ປິດໃຊ້ງານຈຳນວນອັດຕະໂນມັດສຳລັບແຕ່ລະຄຳຖາມ';
$string['average'] = 'ສະເລ່ຍ';
$string['bold'] = 'ຕົວໜາ';
$string['calendarend'] = '{$a} ປິດ';
$string['calendarstart'] = '{$a} ເປີດ';
$string['cannotaccess'] = 'ທ່ານສາມາດເຂົ້າຫາຄຳຕິຊົມນີ້ຈາກລາຍວິຊາເທົ່ານັ້ນ';
$string['cannotsavetempl'] = 'ບໍ່ອະນຸຍາດໃຫ້ບັນທຶກແມ່ແບບ';
$string['captcha'] = 'Captcha';
$string['captchanotset'] = 'Captcha ບໍ່ໄດ້ຖືກຕັ້ງຄ່າ';
$string['check'] = 'ຫຼາຍຕົວເລືອກ - ຫຼາຍຄຳຕອບ';
$string['check_values'] = 'ການໂຕ້ຕອບທີ່ເປັນໄປໄດ້';
$string['checkbox'] = 'ອະນຸຍາດໃຫ້ຕອບໄດ້ທັງຫຼາຍຕົວເລືອກ - ຫຼາຍຄໍາຕອບ (ກ່ອງໝາຍຖືກ)';
$string['choosefile'] = 'ເລືອກໄຟລ໌';
$string['chosen_feedback_response'] = 'ຄຳຕອບຄຳຕິຊົມທີ່ເລືອກ';
$string['closebeforeopen'] = 'ທ່ານໄດ້ລະບຸວັນສິ້ນສຸດກ່ອນວັນທີ່ເລີ່ມຕົ້ນ.';
$string['complete_the_form'] = 'ຕອບຄຳຖາມ';
$string['completed'] = 'ສຳເລັດ';
$string['completed_feedbacks'] = 'ສົ່ງຄຳຕອບ';
$string['completedon'] = 'ສຳເລັດໃນ {$a}';
$string['completiondetail:submit'] = 'ສົ່ງຄຳຕິຊົມ';
$string['completionsubmit'] = 'ເບິ່ງວ່າສຳເລັດແລ້ວຖ້າມີການສົ່ງຄຳຕິຊົມ';
$string['configallowfullanonymous'] = 'ຖ້າຕັ້ງເປັນ \'ແມ່ນ\', ຜູ້ໃຊ້ສາມາດເຮັດສໍາເລັດກິດຈະກໍາການຕໍານິຕິຊົມຢູ່ໜ້າຫຼັກໂດຍບໍ່ຈໍາເປັນຕ້ອງເຂົ້າສູ່ລະບົບ.';
$string['confirmdeleteentry'] = 'ທ່ານແນ່ໃຈບໍວ່າທ່ານຕ້ອງການລຶບລາຍການນີ້?';
$string['confirmdeleteitem'] = 'ທ່ານແນ່ໃຈບໍວ່າທ່ານຕ້ອງການລຶບອົງປະກອບນີ້?';
$string['confirmdeletetemplate'] = 'ທ່ານແນ່ໃຈບໍວ່າທ່ານຕ້ອງການລຶບແມ່ແບບນີ້?';
$string['confirmusetemplate'] = 'ທ່ານແນ່ໃຈບໍວ່າທ່ານຕ້ອງການໃຊ້ແມ່ແບບນີ້?';
$string['continue_the_form'] = 'ສືບຕໍ່ຕອບຄຳຖາມ';
$string['count_of_nums'] = 'ນັບຈຳນວນ';
$string['courseid'] = 'ລະຫັດປະຈຳຕົວລາຍວິຊາ';
$string['creating_templates'] = 'ບັນທຶກຄຳຖາມເຫຼົ່ານີ້ເປັນແມ່ແບບໃໝ່';
$string['delete_entry'] = 'ລຶບລາຍການ';
$string['delete_item'] = 'ລຶບຄຳຖາມ';
$string['delete_old_items'] = 'ລຶບລາຍການເກົ່າ';
$string['delete_pagebreak'] = 'ລຶບການຂັ້ນໜ້າ';
$string['delete_template'] = 'ລຶບແມ່ແບບ';
$string['delete_templates'] = 'ລຶບແມ່ແບບ...';
$string['depending'] = 'ຄວາມເພິ່ງພາອາໃສ';
$string['depending_help'] = 'ມັນເປັນໄປໄດ້ທີ່ຈະສະແດງລາຍການໜຶ່ງຂຶ້ນກັບມູນຄ່າຂອງລາຍການອື່ນ.<br />
<strong>ນີ້ແມ່ນຕົວຢ່າງ.</strong><br />
<ul>
<li>ທຳອິດ, ສ້າງລາຍການທີ່ລາຍການອື່ນຈະຂຶ້ນກັບ.</li>
<li>ຕໍ່ໄປ, ເພີ່ມການຂັ້ນໜ້າ.</li>
<li>ຈາກນັ້ນຕື່ມລາຍການທີ່ຂຶ້ນກັບມູນຄ່າຂອງລາຍການທີ່ສ້າງຂື້ນມາກ່ອນ. ເລືອກລາຍການຈາກລາຍການທີ່ຕິດປ້າຍ "ລາຍການເພິ່ງພາອາໄສ" ແລະ ຂຽນຄ່າທີ່ຕ້ອງການໃສ່ໃນກ່ອງຂໍ້ຄວາມທີ່ມີຊື່ວ່າ "ມູນຄ່າການເພິ່ງພາອາໃສ".</li>
</ul>
<strong>ໂຄງຮ່າງລາຍການຄວນເປັນແນວນີ້.</strong>
<ol>
<li>ລາຍການ ຖາມ: ທ່ານມີລົດໃຫຍ່ບໍ? ຕອບ: ແມ່ນ/ບໍ່ແມ່ນ</li>
<li>ຂັ້ນໜ້າ</li>
<li>ລາຍການ ຖາມ: ລົດຂອງທ່ານສີຫຍັງ?<br />
(ລາຍການນີ້ຂື້ນກັບລາຍການ 1 ທີ່ມີມູນຄ່າ = ແມ່ນແລ້ວ)</li>
<li>ລາຍການ ຖາມ: ເປັນຫຍັງທ່ານຈຶ່ງບໍ່ມີລົດໃຫຍ່?<li>
(ລາຍການນີ້ຂື້ນກັບລາຍການ 1 ທີ່ມີມູນຄ່າ = ແມ່ນແລ້ວ)</li>
<li> ...ລາຍານອທື່ນໆ</li>
</ol>';
$string['dependitem'] = 'ລາຍການເພິ່ງພາອາໃສ';
$string['dependvalue'] = 'ມູນຄ່າຂື້ນກັບ';
$string['description'] = 'ຄໍາອະທິບາຍ';
$string['do_not_analyse_empty_submits'] = 'ຢ່າວິເຄາະການສົ່ງທີ່ຫວ່າງເປົ່າ';
$string['downloadresponseas'] = 'ດາວໂຫຼດການໂຕ້ຕອບທັງໝົດເປັນ';
$string['drop_feedback'] = 'ຍົກຍ້າຍຈາກລາຍວິຊານີ້';
$string['dropdown'] = 'ອະນຸຍາດໃຫ້ຕອບໄດ້ທັງຫຼາຍຕົວເລືອກ - ຄໍາຕອບດ່ຽວ (ເມນູເລື່ອນລົງ)';
$string['dropdown_values'] = 'ຄຳຕອບ';
$string['dropdownlist'] = 'ຫຼາຍຕົວເລືອກ - ຄຳຕອບດ່ຽວ (ເມນູເລື່ອນລົງ)';
$string['dropdownrated'] = 'ເມນູເລື່ອນລົງ (ໄດ້ຄະແນນ)';
$string['edit_item'] = 'ແກ້ໄຂຄຳຖາມ';
$string['edit_items'] = 'ແກ້ໄຂຄຳຖາມ';
$string['email_notification'] = 'ເປີດໃຊ້ງານແຈ້ງເຕືອນຂອງການສົ່ງ';
$string['email_notification_help'] = 'ຖ້າເປີດໃຊ້ງານ, ອາຈານຈະໄດ້ຮັບການແຈ້ງເຕືອນຂອງຄຳຕິຊົມການສົ່ງ';
$string['emailteachermail'] = '{$a->username} ໄດ້ສໍາເລັດການເຄື່ອນໄຫວຄໍາຕິຊົມ: \'{$a->feedback}\'

ເຈົ້າສາມາດເບິ່ງມັນໄດ້ທີ່ນີ້:

{$a->url}';
$string['emailteachermailhtml'] = '<p>{$a->username} ໄດ້ສຳເລັດກິດຈະກຳຄຳຕິຊົມ: <i>\'{$a->feedback}\'</i>.</p>
<p>It is <a href="{$a->url}">ມີໃຫ້ເທິງເວັບໄຊທ໌</a>.</p>';
$string['entries_saved'] = 'ຄຳຕອບຂອງທ່ານຖືກບັນທຶກແລ້ວ. ຂໍຂອບໃຈ.';
$string['eventresponsedeleted'] = 'ລຶບການຕອບໂຕ້ແລ້ວ';
$string['eventresponsesubmitted'] = 'ສົ່ງການຕອບໂຕ້ແລ້ວ';
$string['export_questions'] = 'ສົ່ງອອກຄຳຖາມ';
$string['export_to_excel'] = 'ສົ່ງອອກຫາ Excel';
$string['feedback:addinstance'] = 'ເພີ່ມຄຳຕິຊົມໃໝ່';
$string['feedback:complete'] = 'ສຳເລັດຄຳຕິຊົມ';
$string['feedback:createprivatetemplate'] = 'ສ້າງແມ່ແບບສ່ວນຕົວ';
$string['feedback:createpublictemplate'] = 'ສ້າງແມ່ແບບສາທາລະນະ';
$string['feedback:deletesubmissions'] = 'ລຶບການສົ່ງທີ່ສຳເລັດແລ້ວ';
$string['feedback:deletetemplate'] = 'ລືບແມ່ແບບ';
$string['feedback:edititems'] = 'ແກ້ໄຂລາຍການ';
$string['feedback:mapcourse'] = 'ແຜນທີ່ວິຊາຫາຄຳຕິຊົມທົ່ວໂລກ';
$string['feedback:receivemail'] = 'ຮັບອີເມລການແຈ້ງເຕືອນ';
$string['feedback:view'] = 'ເບິ່ງຄຳຕິຊົມ';
$string['feedback:viewanalysepage'] = 'ເບິ່ງໜ້າວິເຄາະຫຼັງຈາກສົ່ງ';
$string['feedback:viewreports'] = 'ເບິ່ງລາຍງານ';
$string['feedback_is_not_for_anonymous'] = 'ຄຳຕິຊົມບໍ່ແມ່ນສຳລັບຜູ້ບໍ່ປະສົງອອກນາມ';
$string['feedback_is_not_open'] = 'ຄຳຕິຊົມຍັງບໍ່ເປີດ';
$string['feedbackclose'] = 'ອະນຸຍາດຕອບຄຳຖາມຫາ';
$string['feedbackcompleted'] = '{$a->username} ສຳເລັດ {$a->feedbackname}';
$string['feedbackopen'] = 'ອະນຸຍາດຕອບຄຳຖາມຈາກ';
$string['feedbackupdated'] = 'ປັບປຸງຄຳຕິຊົມແລ້ວ.';
$string['file'] = 'ໄຟລ໌';
$string['filter_by_course'] = 'ຕົວກັ່ນຕອງໂດຍລາຍວິຊາ';
$string['handling_error'] = 'ມີຂໍ້ຜິດພາດເກີດຂື້ນໃນການຮັບມືກັບການປະຕິບັດຊຸດຄຳຕິຊົມ';
$string['hide_no_select_option'] = 'ເຊື່ອງທາງເລືອກ "ບໍ່ໄດ້ເລືອກ"';
$string['horizontal'] = 'ທາງຂວາງ';
$string['import_questions'] = 'ຄຳຖາມສຳຄັນ';
$string['import_successfully'] = 'ນຳເຂົ້າສຳເລັດ';
$string['importfromthisfile'] = 'ນຳເຂົ້າຈາກໄຟລ໌ນີ້';
$string['includeuserinrecipientslist'] = 'ລວມທັງ {$a} ໃນລາຍການຂອງຜູ້ຮັບ';
$string['indicator:cognitivedepth'] = 'ຄວາມຮູ້ດ້ານຄຳຕິຊົມ';
$string['indicator:cognitivedepth_help'] = 'ຕົວຊີ້ວັດນີ້ແມ່ນອີງໃສ່ຄວາມເຂົ້າໃຈເລິກເຊິ່ງຂອງນັກຮຽນທີ່ເຂົ້າເຖິງໃນກິດຈະກໍາຄໍາຕິຊົມ.';
$string['indicator:cognitivedepthdef'] = 'ການຮັບຮູ້ຄຳຕິຊົມ';
$string['indicator:cognitivedepthdef_help'] = 'ຜູ້ເຂົ້າຮ່ວມໄດ້ບັນລຸອັດຕາສ່ວນຂອງການມີສ່ວນຮ່ວມທາງດ້ານຄວາມຮູ້ທີ່ສະເໜີ ໂດຍກິດຈະກໍາຄໍາຕິຊົມໃນລະຫວ່າງໄລຍະການວິເຄາະນີ້ (ລະດັບ = ບໍ່ມີມຸມມອງ, ເບິ່ງ, ສົ່ງ)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'ສັງຄົມຄຳຕິຊົມ';
$string['indicator:socialbreadth_help'] = 'ຕົວຊີ້ວັດນີ້ແມ່ນອີງໃສ່ຄວາມກວ້າງທາງສັງຄົມທີ່ນັກຮຽນບັນລຸໄດ້ໃນກິດຈະກໍາການໃຫ້ຄໍາຄິດເຫັນ.';
$string['indicator:socialbreadthdef'] = 'ສັງຄົມຄຳຕິຊົມ';
$string['indicator:socialbreadthdef_help'] = 'ຜູ້ເຂົ້າຮ່ວມໄດ້ບັນລຸອັດຕາສ່ວນຂອງການມີສ່ວນຮ່ວມທາງສັງຄົມທີ່ສະເໜີ ໂດຍກິດຈະກໍາຄໍາຕິຊົມໃນລະຫວ່າງໄລຍະເວລາການວິເຄາະນີ້ (ລະດັບ = ບໍ່ມີການເຂົ້າຮ່ວມ, ຜູ້ເຂົ້າຮ່ວມຢ່າງດຽວ, ຜູ້ເຂົ້າຮ່ວມກັບຜູ້ອື່ນ)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'ຂໍ້ມູນ';
$string['infotype'] = 'ປະເພດຂໍ້ມູນ';
$string['insufficient_responses'] = 'ການໂຕ້ຕອບບໍ່ພຽງພໍ';
$string['insufficient_responses_for_this_group'] = 'ມີການໂຕ້ຕອບບໍ່ພຽງພໍສຳລັບກຸ່ມນີ້';
$string['insufficient_responses_help'] = 'ເພື່ອໃຫ້ຄຳຕິຊົມບໍ່ເປີດເຜີຍຊື່, ຈະຕ້ອງມີຢ່າງໜ້ອຍ 2 ຄຳຕອບ.';
$string['item_label'] = 'ປ້າຍ';
$string['item_name'] = 'ຄຳຖາມ';
$string['label'] = 'ປ້າຍ';
$string['labelcontents'] = 'ເນື້ອໃນ';
$string['mapcourse'] = 'ແຜນທີຄຳຕິຊົມຫາວິຊາ';
$string['mapcourse_help'] = 'ໂດຍຄ່າເລີ່ມຕົ້ນ, ແບບຟອມຄຳຕິຊົມທີ່ສ້າງຂຶ້ນຢູ່ໃນໜ້າຫຼັກຂອງທ່ານແມ່ນມີໃຫ້ທົ່ວເວັບໄຊທ໌
ແລະ ຈະປາກົດຢູ່ໃນຫຼັກສູດທັງໝົດໂດຍໃຊ້ບລັອກຄຳຕິຊົມ. ທ່ານສາມາດບັງຄັບແບບຟອມຄຳຕິຊົມໃຫ້ປາກົດ ໂດຍການເຮັດໃຫ້ມັນເປັນບລັອກໜຽວ ຫຼື ຈຳກັດວິຊາທີ່ຮູບແບບຄຳຕິຊົມຈະປາກົດໂດຍການສ້າງແຜນທີ່ໃສ່ກັບວິຊາສະເພາະ.';
$string['mapcourseinfo'] = 'ນີ້ແມ່ນຄຳຕິຊົມທັງໝົດໃນທົ່ວເວັບໄຊທ໌ທີ່ມີໃຫ້ກັບລາຍວິຊາທັງໝົດໂດຍໃຊ້ບລັອກ ຄຳຕິຊົມ. ແນວໃດກໍ່ຕາມ ທ່ານສາມາດຈໍາກັດລາຍວິຊາທີ່ຈະປະກົດຂຶ້ນໄດ້ໂດຍການສ້າງແຜນທີ່ໃຫ້ເຂົາເຈົ້າ. ຄົ້ນຫາຫຼັກສູດ ແລະ ສ້າງແຜນທີ່ໃຫ້ກັບຄຳຕິຊົມນີ້.';
$string['mapcoursenone'] = 'ບໍ່ມີແຜນທີ່ວິຊາ. ຄຳຕິຊົມທີ່ມີໃຫ້ຫາວິຊາທັງໝົດ';
$string['mapcourses'] = 'ແຜນທີ່ຄຳຕິຊົມຫາລາຍວິຊາ';
$string['mappedcourses'] = 'ວິຊາແຜນທີ່';
$string['mappingchanged'] = 'ການສ້າງແຜນທີ່ລາຍວິຊາຖືກປ່ຽນແປງແລ້ວ';
$string['maximal'] = 'ສູງສຸດ';
$string['messageprovider:message'] = 'ເຕືອນຄຳຕິຊົມ';
$string['messageprovider:submission'] = 'ແຈ້ງເຕືອນຄຳຕິຊົມ';
$string['minimal'] = 'ຕ່ຳສຸດ';
$string['mode'] = 'ໂໝດ';
$string['modulename'] = 'ຄຳຕິຊົມ';
$string['modulename_help'] = 'ຊຸດກິດຈະກໍາຄໍາຕິຊົມຊ່ວຍໃຫ້ຄູສອນສ້າງແບບສໍາຫຼວດ ສໍາລັບເກັບກໍາຄໍາຕິຊົມຈາກຜູ້ເຂົ້າຮ່ວມ ໂດຍໃຊ້ປະເພດຄໍາຖາມທີ່ຫຼາກຫຼາຍລວມທັງທາງເລືອກຫຼາຍອັນ, ແມ່ນ/ບໍ່ ຫຼື ການປ້ອນຂໍ້ຄວາມເຂົ້າ.

ການຕອບຮັບຄຳຕິຊົມ ອາດຈະບໍ່ລະບຸຊື່ ຖ້າຕ້ອງການ ແລະ ຜົນການຊອກຫາອາດຈະສະແດງໃຫ້ຜູ້ເຂົ້າຮ່ວມທັງໝົດ ຫຼື ຈຳກັດໃຫ້ສະເພາະຄູສອນເທົ່ານັ້ນ. ກິດຈະກໍາຄໍາຕິຊົມຢູ່ໃນໜ້າທໍາອິດຂອງເວັບໄຊທ໌ ອາດຈະຖືກເຮັດສໍາເລັດໂດຍຜູ້ໃຊ້ທີ່ບໍ່ໄດ້ເຂົ້າສູ່ລະບົບ.

ກິດຈະກໍາຄຳຕິຊົມອາດຈະຖືກນໍາໃຊ້

* ສໍາລັບການປະເມີນຫຼັກສູດ, ຊ່ວຍປັບປຸງເນື້ອໃນສໍາລັບຜູ້ເຂົ້າຮ່ວມໃນພາຍຫຼັງ
* ເພື່ອໃຫ້ຜູ້ເຂົ້າຮ່ວມສາມາດລົງທະບຽນເຂົ້າຮຽນລາຍວິຊາ, ເຫດການ ແລະ ອື່ນໆ.
* ສຳລັບການສຳຫຼວດແຂກກ່ຽວກັບການເລືອກລາຍວິຊາ, ນະໂຍບາຍຂອງໂຮງຮຽນ ແລະ ອື່ນໆ.
* ສໍາລັບການສໍາຫຼວດຕ້ານການຂົ່ມເຫັງ ເຊິ່ງນັກຮຽນສາມາດລາຍງານເຫດການໂດຍບໍ່ເປີດເຜີຍຊື່';
$string['modulename_link'] = 'mod/feedback/view';
$string['modulenameplural'] = 'ຄຳຕິຊົມ';
$string['move_item'] = 'ຍ້າຍຄຳຖາມນີ້';
$string['multichoice'] = 'ຫຼາຍຕົວເລືອກ';
$string['multichoice_values'] = 'ມູນຄ່າຫຼາຍຕົວເລືອກ';
$string['multichoiceoption'] = '<span class="weight">({$a->weight}) </span>{$a->name}';
$string['multichoicerated'] = 'ຫຼາຍຕົວເລືອກ (ໄດ້ຄະແນນ)';
$string['multichoicetype'] = 'ປະເພດຫຼາຍຕົວເລືອກ';
$string['multiplesubmit'] = 'ອະນຸຍາດຫຼາຍການສົ່ງ';
$string['multiplesubmit_help'] = 'ຖ້າເປີດໃຊ້ສໍາລັບການສໍາຫຼວດບໍ່ເປີດເຜີຍຊື່, ຜູ້ໃຊ້ສາມາດສົ່ງຄໍາຕິຊົມໄດ້ບໍ່ຈໍາກັດຄັ້ງ.';
$string['name'] = 'ຊື່';
$string['name_required'] = 'ຊື່ແມ່ນຕ້ອງການ';
$string['nameandlabelformat'] = '({$a->label}) {$a->name}';
$string['next_page'] = 'ໜ້າຕໍ່ໄປ';
$string['no_handler'] = 'ບໍ່ມີຕົວຮັບມືປະຕິບັດການທີ່ມີຢູ່ສຳລັບ';
$string['no_itemlabel'] = 'ບໍ່ມີປ້າຍ';
$string['no_itemname'] = 'ບໍ່ມີຊື່ລາຍການ';
$string['no_items_available_yet'] = 'ບໍ່ມີຄຳຖາມຖືກສ້າງຕັ້ງຂື້ນເທື່ອ';
$string['no_templates_available_yet'] = 'ບໍ່ມີແມ່ແບບໃຫ້ເທື່ອ';
$string['non_anonymous'] = 'ຊື່ຜູ້ໃຊ້ຈະຖືກລົງຊື່ເຂົ້າໃຊ້ ແລະ ສະແດງພ້ອມກັບຄຳຖາມ';
$string['non_anonymous_entries'] = 'ບໍ່ແມ່ນລາຍການຜູ້ບໍ່ປະສົງອອກນາມ ({$a})';
$string['non_respondents_students'] = 'ນັກຮຽນບໍ່ຕອບສະໜອງ ({$a})';
$string['not_completed_yet'] = 'ຍັງບໍ່ສຳເລັດເທື່ອ';
$string['not_selected'] = 'ບໍ່ໄດ້ເລືອກ';
$string['not_started'] = 'ຍັງບໍ່ໄດ້ເລີ່ມ';
$string['numberoutofrange'] = 'ຕົວເລກຢູ່ນອກຂອບເຂດ';
$string['numeric'] = 'ຄຳຕອບເປັນຕົວເລກ';
$string['numeric_range_from'] = 'ໄລຍະຈາກ';
$string['numeric_range_to'] = 'ໄລຍະຫາ';
$string['of'] = 'ຂອງ';
$string['oldvaluespreserved'] = 'ຄຳຖາມເກົ່າທັງໝົດ ແລະ ຄ່າທີ່ໄດ້ມອບໝາຍຈະຖືກຮັກສາໄວ້';
$string['oldvalueswillbedeleted'] = 'ຄຳຖາມປະຈຸບັນ ແລະ ການໂຕ້ຕອບທັງໝົດຈະຖືກລືບ.';
$string['only_one_captcha_allowed'] = 'ອະນຸຍາດໃຫ້ໃຊ້ຄຳຕອບ captcha ອັນດຽວຄຳຕິຊົມເທົ່ານັ້ນ';
$string['openafterclose'] = 'ເຈົ້າໄດ້ລະບຸວັນທີເປີດຫຼັງຈາກວັນທີປິດ';
$string['overview'] = 'ພາບລວມ';
$string['page'] = 'ໜ້າ';
$string['page-mod-feedback-x'] = 'ໜ້າຊຸດຄຳຕິຊົມໃດໜຶ່ງ';
$string['page_after_submit'] = 'ຂໍ້ຄວາມສຳເລັດ';
$string['pagebreak'] = 'ຂັ້ນໜ້າ';
$string['pluginadministration'] = 'ການບໍລິຫານຄຳຕິຊົມ';
$string['pluginname'] = 'ຄຳຕິຊົມ';
$string['position'] = 'ຕຳແໜ່ງ';
$string['previewquestions'] = 'ເບິ່ງຕົວຢ່າງຄຳຖາມ';
$string['previous_page'] = 'ໜ້າກ່ອນໜ້າ';
$string['privacy:metadata:completed'] = 'ບັນທຶກຂອງການສົ່ງຫາຄຳຕິຊົມ';
$string['privacy:metadata:completed:anonymousresponse'] = 'ບໍ່ວ່າການສົ່ງຈະຖືກນຳໃຊ້ແບບບໍ່ປະສົງອອກນາມ.';
$string['privacy:metadata:completed:timemodified'] = 'ເວລາເມື່ອການສົ່ງຖືກດັດແກ້ຄັ້ງສຸດທ້າຍ.';
$string['privacy:metadata:completed:userid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ສຳເລັດກິດຈະກຳຄຳຕິຊົມ.';
$string['privacy:metadata:completedtmp'] = 'ບັນທຶກຂອງການສົ່ງທີ່ຍັງຄົງດຳເນີນການ.';
$string['privacy:metadata:value'] = 'ບັນທຶກຂອງຄຳຕອບຫາຄຳຖາມ.';
$string['privacy:metadata:value:value'] = 'ຄຳຕອບທີ່ເລືອກ.';
$string['privacy:metadata:valuetmp'] = 'ບັນທຶກຂອງຄຳຕອບຫາຄຳຖາມໃນການສົ່ງທີ່ກຳລັງດຳເນີນ.';
$string['public'] = 'ສາທາລະນະ';
$string['question'] = 'ຄຳຖາມ';
$string['questionandsubmission'] = 'ການຕັ້ງຄ່າຄຳຖາມ ແລະ ການສົ່ງ';
$string['questions'] = 'ຄຳຖາມ';
$string['questionslimited'] = 'ສະແດງພຽງແຕ່ {$a} ຄຳຖາມທຳອິດ, ເບິ່ງຄຳຕອບສະເພາະ ຫຼື ດາວໂຫຼດຂໍ້ມູນຕາຕະລາງເພື່ອເບິ່ງທັງໝົດ.';
$string['radio'] = 'ຫຼາຍຕົວເລືອກ - ຄຳຕອບດຽວ';
$string['radio_values'] = 'ການໂຕ້ຕອບ';
$string['ready_feedbacks'] = 'ການໂຕ້ຕອບກຽມພ້ອມ';
$string['required'] = 'ຈຳເປັນ';
$string['resetting_data'] = 'ຕັ້ງການໂຕ້ຕອບຄຳຕິຊົມຄືນໃໝ່';
$string['resetting_feedbacks'] = 'ກຳລັງຕັ້ງຄຳຕິຊົມຄືນໃໝ່';
$string['response_nr'] = 'ໝາຍເລກໂຕ້ຕອບ';
$string['responses'] = 'ໂຕ້ຕອບ';
$string['responsetime'] = 'ເວລາໂຕ້ຕອບ';
$string['save_as_new_item'] = 'ບັນທຶກຄຳຖາມໃໝ່';
$string['save_as_new_template'] = 'ບັນທຶກເປັນແມ່ແບບໃໝ່';
$string['save_entries'] = 'ສົ່ງຄຳຕອບຂອງທ່ານ';
$string['save_item'] = 'ບັນທຶກຄຳຖາມ';
$string['saving_failed'] = 'ການບັນທຶກລົ້ມເຫຼວ';
$string['search:activity'] = 'ຄຳຕິຊົມ - ຂໍ້ມູນກິດຈະກຳ';
$string['search_course'] = 'ຄົ້ນຫາລາຍວິຊາ';
$string['searchcourses'] = 'ຄົ້ນຫາວິຊາ';
$string['searchcourses_help'] = 'ຄົ້ນຫາລະຫັດ ຫຼື ຊື່ຂອງລາຍວິຊາທີ່ທ່ານຕ້ອງການເຊື່ອມໂຍງກັບຄຳຕິຊົມນີ້.';
$string['selected_dump'] = 'ດັດສະນີທີ່ເລືອກຂອງຕົວແປ $SESSION ແມ່ນຖີ້ມລົງທາງລຸ່ມນີ້:';
$string['send'] = 'ສົ່ງ';
$string['send_message'] = 'ສົ່ງການແຈ້ງເຕືອນ';
$string['show_all'] = 'ສະແດງທັງໝົດ';
$string['show_analysepage_after_submit'] = 'ສະແດງໜ້າວິເຄາະ';
$string['show_entries'] = 'ສະແດງການໂຕ້ຕອບ';
$string['show_entry'] = 'ສະແດງການໂຕ້ຕອບ';
$string['show_nonrespondents'] = 'ສະແດງຜູ້ບໍ່ຕອບກັບ';
$string['site_after_submit'] = 'ເວັບໄຊທ໌ຫຼັງຈາກສົ່ງ';
$string['sort_by_course'] = 'ລຽງໂດຍລາຍວິຊາ';
$string['started'] = 'ເລີ່ມຕົ້ນແລ້ວ';
$string['startedon'] = 'ເລີ່ມໃນ {$a}';
$string['subject'] = 'ເລື່ອງ';
$string['switch_item_to_not_required'] = 'ຕັ້ງເປັນບໍ່ຈຳເປັນ';
$string['switch_item_to_required'] = 'ຕັ້ງວ່າຈຳເປັນ';
$string['template'] = 'ແມ່ແບບ';
$string['template_deleted'] = 'ລຶບແມ່ແບບ';
$string['template_saved'] = 'ບັນທຶກແມ່ແບບ';
$string['templates'] = 'ແມ່ແບບ';
$string['textarea'] = 'ຂໍ້ຄວາມຄຳຕອບຍາວກວ່າ';
$string['textarea_height'] = 'ຈຳນວນແຖວ';
$string['textarea_width'] = 'ກວ້າງ';
$string['textfield'] = 'ຂໍ້ຄວາມຄຳຕອບສັ້ນ';
$string['textfield_maxlength'] = 'ຈຳນວນຕົວໜັງສືສູງສຸດທີ່ຍອມຮັບ';
$string['textfield_size'] = 'ຄວາມກວ້າງຊ່ອງຂໍ້ຄວາມ';
$string['there_are_no_settings_for_recaptcha'] = 'ບໍ່ມີການຕັ້ງຄ່າສຳລັບ captcha';
$string['this_feedback_is_already_submitted'] = 'ທ່ານໄດ້ສຳເລັດກິດຈະກຳນີ້ແລ້ວ.';
$string['typemissing'] = 'ມູນຄ່າຂາດຫາຍໄປ "ປະເພດ"';
$string['update_item'] = 'ບັນທຶກການປ່ຽນແປງຫາຄຳຖາມ';
$string['url_for_continue'] = 'ລິ້ງໄປຫາກິດຈະກຳຕໍ່ໄປ';
$string['url_for_continue_help'] = 'ຫຼັງຈາກສົ່ງຄຳຕິຊົມ, ປຸ່ມສືບຕໍ່ໄດ້ສະແດງ, ທີ່ເຊື່ອມຕໍ່ກັບລາຍວິຊາ. ມັນອາດຈະເຊື່ອມຕໍ່ກັບກິດຈະກຳຕໍ່ໄປຖ້າຫາກ URL ຂອງກິດຈະກຳໄດ້ປ້ອນເຂົ້າທີ່ນີ້.';
$string['use_one_line_for_each_value'] = 'ນຳໃຊ້ແຖວດຽວສຳລັບແຕ່ລະຄຳຕອບ!';
$string['use_this_template'] = 'ນຳໃຊ້ແມ່ແບບນີ້';
$string['using_templates'] = 'ນຳໃຊ້ແມ່ແບບ';
$string['vertical'] = 'ລວງຕັ້ງ';
$string['whatfor'] = 'ທ່ານຕ້ອງການເຮັດຫຍັງ?';
