<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scheduler', language 'cs', version '4.1'.
 *
 * @package     scheduler
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akce';
$string['actions'] = 'Akce';
$string['addappointment'] = 'Přidat dalšího studenta';
$string['addcommands'] = 'Přidat termíny';
$string['addondays'] = 'Zapsat se na termín';
$string['addsession'] = 'Přidat opakované termíny';
$string['addsingleslot'] = 'Přidat termín';
$string['addslot'] = 'Další temíny můžete přidat později.';
$string['addstudenttogroup'] = 'Přidat tohoto studenta do skupiny';
$string['allappointments'] = 'Všechny schůzky';
$string['allononepage'] = 'Všechny termíny na jedné stránce';
$string['allowgroup'] = 'Vyhrazený termín - klikněte pro změnu';
$string['alreadyappointed'] = 'Nemohu vás zapsat, termín je již plně obsazen.';
$string['appointagroup_help'] = 'Vyberte, jestli se chcete zapsat sami, nebo jestli chcete zapsat celou skupinu.';
$string['appointfor'] = 'Vytvořit schůzku pro';
$string['appointforgroup'] = 'Vytvořit schůzky pro: {$a}';
$string['appointingstudent'] = 'Termín schůzky';
$string['appointingstudentinnew'] = 'Nový termín schůzky';
$string['appointment'] = 'Schůzka';
$string['appointmentmode'] = 'Nastavení módu schůzky';
$string['appointmentmode_help'] = '<p>Zde si můžete vybrat několik variant způsobu, jakým lze schůzky přijímat. </p>
<p><ul>
<li><strong>„<emph>n</emph> schůzek v tomto plánovači“:</strong> Student si může v této aktivitě rezervovat pouze pevný počet schůzek. I když je učitel označí jako „viděné“, nebude si moci rezervovat další schůzky. Jediný způsob, jak resetovat možnost studenta rezervovat, je smazat staré záznamy o „viděných“.</li>
<li><strong>„<emph>n</emph> schůzek najednou“:</strong> Student si může rezervovat pevný počet schůzek. Jakmile schůzka skončí a učitel označí studenta jako „viděného“, může si student rezervovat další schůzky. Student je však omezen na <emph>n</emph> „otevřených“ (neviděných) termínů v daném okamžiku.
</li>
</ul>
</p>';
$string['appointmentno'] = 'Schůzka {$a}';
$string['appointmentnote'] = 'Poznámky ke schůzce (viditelné studentovi)';
$string['appointments'] = 'Schůzky';
$string['appointmentsgrouped'] = 'Schůzky sdružené podle termínů';
$string['appointmentsummary'] = 'Schůzka {$a->startdate} od {$a->starttime} do {$a->endtime} s {$a->teacher}';
$string['appointsolo'] = 'jen já';
$string['appointsomeone'] = 'Přidat nový termín';
$string['areaappointmentnote'] = 'Soubory v poznámkách ke schůzce';
$string['areaslotnote'] = 'Soubory v poznámkách k termínu';
$string['areateachernote'] = 'Důvěrné poznámky';
$string['attendable'] = 'Sledovat docházku';
$string['attendablelbl'] = 'Celkový počet studentů se kterými plánujete schůzku.';
$string['attended'] = 'Zúčastnil/a se';
$string['attendedlbl'] = 'Počet studentů, kteří se zúčastnili';
$string['attendedslots'] = 'Využitých míst';
$string['availableslots'] = 'Dostupné termíny';
$string['availableslotsall'] = 'Všechny termíny';
$string['availableslotsnotowned'] = 'Nevlastněno';
$string['availableslotsowned'] = 'Vlastněno';
$string['bookaslot'] = 'Rezervovat termín';
$string['bookingdetails'] = 'Detaily rezervace';
$string['bookingformoptions'] = 'Rezervační formulář a informace zaslané od studentů';
$string['bookinginstructions'] = 'Informace o rezervaci';
$string['bookinginstructions_help'] = 'Tento text se zobrazí studentům než si zamluví termín. Můžete sem například napsat pokyny studentům, co si mají připravit, co vám napsat a jaké soubory poslat.';
$string['bookslot'] = 'Rezervovat termín';
$string['bookwithteacher'] = 'Učitel';
$string['bookwithteacher_help'] = 'Vybrat učitele pro zkoušku';
$string['break'] = 'Přestávka mezi termíny';
$string['breaknotnegative'] = 'Délka přestávky nesmí být záporná';
$string['canbook1appointment'] = 'V tomto plánovači si můžete rezervovat ještě jednu schůzku.';
$string['canbooknappointments'] = 'V tomto plánovači si můžete rezervovat ještě {$a} schůzek.';
$string['canbooknofurtherappointments'] = 'V tomto plánovači si již nemůžete rezervovat další schůzky.';
$string['canbooksingleappointment'] = 'V tomto plánovači si můžete rezervovat jednu schůzku.';
$string['canbookunlimitedappointments'] = 'V tomto plánovači si můžete rezervovat libovolný počet schůzek.';
$string['cancelbooking'] = 'Zrušit přihlášení';
$string['chooseexisting'] = 'Vyberte existující';
$string['choosingslotstart'] = 'Výběr času začátku termínu (pro prvního studenta)';
$string['choosingslotstart_help'] = 'Změňte nebo vyberte čas začátku termínu. Pokud schůzka koliduje s jinými termíny dost zobrazí se vám dotaz, jestli chcete tímto novým termínem nahradit všechny schůzky, které jsou v konfliktu. Nové nastavení termínu přepíše všechna předchozí nastavení.';
$string['comments'] = 'Komentáře';
$string['complete'] = 'Přihlášen';
$string['confirmbooking'] = 'Potvrdit přihlášení';
$string['confirmdelete-all'] = 'Tímto se smažou <b>všechny</b> termíny v tomto plánovači. Smazání nelze vrátit zpět. Chcete i tak pokračovat?';
$string['confirmdelete-mine'] = 'Tímto smažete všechny termíny v tomto plánovači. Smazání nelze vrátit zpět. Chcete i tak pokračovat?';
$string['confirmdelete-myunused'] = 'Tímto smažete všechny nepoužívané termíny v tomto plánovači. Smazání nelze vrátit zpět. Chcete i tak pokračovat?';
$string['confirmdelete-one'] = 'Opravdu chcete tento termín schůzky smazat?';
$string['confirmdelete-selected'] = 'Opravdu chcete vybrané termíny schůzek smazat?';
$string['confirmdelete-unused'] = 'Tímto se smažou všechny nepoužívané termíny v tomto plánovači. Smazání nelze vrátit zpět. Chcete i tak pokračovat?';
$string['confirmrevoke'] = 'Zrušit všechny schůzky v aktuálním termínu?';
$string['conflictingslots'] = 'Termín na {$a} nelze vytvořit z důvodu konfliktu termínů:';
$string['conflictlocal'] = '{$a->datetime} ({$a->duration} minut) v tomto plánovači';
$string['conflictremote'] = '{$a->datetime} ({$a->duration} minut) v kurzu {$a->courseshortname}, plánovač {$a->schedulername}';
$string['contentformat'] = 'Formát';
$string['contentformat_help'] = '<p>Existují tři základní možnosti exportního formátu, které se liší v tom, jak jsou zpracovávány termíny s několika schůzkami.
<dl>
<dt>Jeden řádek na termín</dt>:
<dd>
Výstupní soubor bude obsahovat jeden řádek pro každý termín. Pokud termín obsahuje více schůzek, pak se místo jména studenta atd. zobrazí značka „(více)“.
</dd>
<dt>Jeden řádek na schůzku</dt>:
<dd>
Výstupní soubor bude obsahovat jeden řádek pro každou schůzku. Pokud termín obsahuje více schůzek, pak se v seznamu objeví několikrát (s opakovanými údaji).
</dd>
<dt>Schůzky seskupené podle termínu</dt>:
<dd>
Všechny schůzky jednoho termínu jsou seskupeny dohromady, před nimiž je řádek záhlaví, který označuje daný termín. To nemusí dobře fungovat s výstupním formátem souboru CSV, protože počet sloupců není konstantní.
 </dd>
</dl>
Vliv těchto možností si můžete prohlédnout pomocí tlačítka „Náhled“.</p>';
$string['copytomyself'] = 'Poslat si kopii';
$string['course'] = 'Kurz';
$string['createexport'] = 'Vytvořit soubor pro export';
$string['csvfieldseparator'] = 'CSV oddělovač';
$string['csvformat'] = 'CSV';
$string['cumulatedduration'] = 'Součet trvání všech schůzek';
$string['datatoinclude'] = 'Data, která mají být zahrnuta';
$string['datatoinclude_help'] = 'Vyberte pole, která mají být zahrnuta do exportu. Každé z nich se zobrazí v jednom sloupci výstupního souboru.';
$string['date'] = 'Datum';
$string['datelist'] = 'Přehled';
$string['defaultslotduration'] = 'Výchozí délka schůzky';
$string['defaultslotduration_help'] = 'Výchozí délka (v minutách) pro nastavené časové úseky schůzek';
$string['deleteallslots'] = 'Smazat všechny termíny';
$string['deleteallunusedslots'] = 'Smazat neosazené termíny';
$string['deletecommands'] = 'Smazat termíny';
$string['deletedconflictingslots'] = 'Pro termín na {$a} byly smazány konfliktní termíny:';
$string['deletemyslots'] = 'Smazat všechny mé termíny';
$string['deleteonsave'] = 'Smazat tuto schůzku (při ukládání formuláře)';
$string['deleteselection'] = 'Smazat vybrané termíny';
$string['deletetheseslots'] = 'Smazat tyto termíny';
$string['deleteunusedslots'] = 'Smazat mé nepoužívané termíny';
$string['department'] = 'Odkud?';
$string['disengage'] = 'Zrušit mé schůzky';
$string['displayfrom'] = 'Zobrazit termín studentům od';
$string['distributetoslot'] = 'Rozeslat celé skupině';
$string['divide'] = 'Rozdělit do termínů?';
$string['duration'] = 'Trvání';
$string['durationrange'] = 'Délka termínu musí být mezi {$a->min} a {$a->max} minutami.';
$string['editbooking'] = 'Upravit rezervaci';
$string['email_applied_html'] = '<p>Student <a href="{$a->attendee_url}">{$a->attendee</a> si zažádal o termín na {$a->date} v {$a->time},<br/>
pro kurz:

<p>{$a->course_short}: <a href="{$a->course_url}">{$a->course</a></p>

<p>pomocí plánovače s názvem "<em><a href="{$a->scheduler_url}">{$a->module</a></em>" na webových stránkách: <a href="{$a->site_url}">{$a->site</a>.</p>';
$string['email_applied_plain'] = 'Student {$a->attendee} si zažádal o schůzku na {$a->date} v {$a->time} pro kurz:

{$a->course_short}: {$a->course}

pomocí plánovače s názvem „{$a->module}“ na webových stránkách: {$a->site}.';
$string['email_applied_subject'] = '{$a->course_short}: Nová schůzka';
$string['email_cancelled_html'] = '<p>Váš termín na <strong>{$a->date</strong> v <strong>{$a->time</strong>,<br/>
se studentem <strong><a href="{$a->attendee_url}">{$a->attendee</a></strong> pro kurz :</p>

<p><strong>{$a->course_short} : <a href="{$a->course_url}">{$a->course</a></strong></p>

<p>v plánovači s názvem "<em><a href="{$a->scheduler_url}">{$a->module</a></em>" na webových stránkách : <strong><a href="{$a->site_url}">{$a->site</a></strong></p>

<p><strong><span class="error">byl zrušen nebo přesunut</span></strong>.</p>';
$string['email_cancelled_plain'] = 'Vaše schůzka na {$a->date} v {$a->time},
se studentem {$a->attendee} pro kurz:

{$a->course_short} : {$a->course}

v plánovači s názvem „{$a->module}“ na webových stránkách : {$a->site}

byla zrušena nebo přesunuta.';
$string['email_cancelled_subject'] = '{$a->course_short}: Schůzka zrušena nebo přesunuta studentem';
$string['email_invite_html'] = '<p>Vyberte si prosím časový úsek pro schůzku na adrese:</p> <p>{$a->scheduler_url}<p>';
$string['email_invite_subject'] = 'Pozvánka: {$a->module}';
$string['email_invitereminder_html'] = '<p>Toto je jen připomínka, že jste si ještě nenaplánovali schůzku. Vyberte si prosím časový úsek co nejdříve na adrese:</p><p>{$a->scheduler_url}<p>';
$string['email_invitereminder_subject'] = 'Připomínka: {$a->module}';
$string['email_reminder_html'] = '<p>Máte nadcházející schůzku dne <strong>{$a->date</strong>
od <strong>{$a->time</strong> do <strong>{$a->endtime</strong><br/>
s <strong><a href="{$a->attendant_url}">{$a->attendant</a></strong>.</p>

<p>Místo: <strong>{$a->location</strong></p>';
$string['email_reminder_plain'] = 'Máte nadcházející schůzku
na {$a->date} od {$a->time} do {$an->end time}
s {$an->attendant}.
Místo: {$a->location}';
$string['email_reminder_subject'] = '{$a->course_short}: Připomenutí schůzky';
$string['email_teachercancelled_html'] = '<p>Vaše schůzka na <strong>{$a->date</strong> v <strong>{$a->time} </strong>,<br/>
s rolí {$a->staffrole} <strong><a href="{$a->attendant_url}">{$a->attendant</a></strong> pro kurz:</p>

<p><strong>{$a->course_short}: <a href="{$a->course_url}">{$a->course</a></strong></p>

<p>v plánovači "<em><a href="{$a->scheduler_url}">{$a->module</a></em>" na webu: <strong><a href="{$a->site_url}">{$a->site</a></strong></p>

<p><strong><span class="error">byl zrušen</span></strong>.  Prosím, zažádejte si o nový termín.</p>';
$string['email_teachercancelled_plain'] = 'Vaše schůzka na {$a->date} v {$a->time},
s {$a->staffrole} {$a->attendant} pro kurz:

{$a->course_short}: {$a->course}

v plánovači s názvem "{$a->module}" na webových stránkách: {$a->site}

byla zrušena. Prosím, zažádejte si o nový termín.';
$string['email_teachercancelled_subject'] = '{$a->course_short}: Schůzka zrušena učitelem';
$string['emailreminder'] = 'Poslat připomenutí e-mailem';
$string['emailreminderondate'] = 'Poslat připomenutí e-mailem na';
$string['end'] = 'Konec';
$string['enddate'] = 'Opakujte časové úseky, dokud';
$string['event_appointmentlistviewed'] = 'Zobrazen seznam schůzek plánovače';
$string['event_bookingadded'] = 'Přidána rezervace plánovače';
$string['event_bookingformviewed'] = 'Zobrazen rezervační formulář plánovače';
$string['event_bookingremoved'] = 'Rezervace plánovače odstraněna';
$string['event_slotadded'] = 'Přidán termín plánovače';
$string['event_slotdeleted'] = 'Termín plánovače smazán';
$string['everyone'] = 'Každý';
$string['excelformat'] = 'Excel';
$string['exclusive'] = 'Exkluzivní';
$string['exclusivity'] = 'Exkluzivita';
$string['exclusivity_help'] = '<p>Můžete nastavit limit počtu studentů, kteří se mohou na daný termín přihlásit. </p>
<p>Nastavení limitu 1 (výchozí) bude znamenat, že termín bude výhradně pro jednoho studenta.</p>
<p>Nastavení limitu, např. 3, bude znamenat, že se na termín mohou přihlásit až tři studenti.</p>
<p>Pokud je tato možnost zakázána, může si termín rezervovat libovolný počet studentů; nikdy nebude považován za „plný“.</p>';
$string['exclusivityoverload'] = 'Termín má {$a} jmenovaných studentů, což je více, než je povoleno tímto nastavením.';
$string['exclusivitypositive'] = 'Počet studentů na jedno místo musí být 1 nebo více.';
$string['explaingeneralconfig'] = 'Tyto možnosti lze nastavit pouze na úrovni webu a budou platit pro všechny plánovače v této instalaci Moodlu.';
$string['export'] = 'Export';
$string['exporthdr'] = 'Exportovat termíny  a schůzky';
$string['exporttimerange'] = 'Časové rozpětí';
$string['exporttimerangeall'] = 'Budoucí a minulé termíny';
$string['exporttimerangefuture'] = 'Pouze budoucí termíny';
$string['exporttimerangepast'] = 'Pouze minulé termíny';
$string['field-appointmentnote'] = 'Poznámka k termínu (pro studenta)';
$string['field-attended'] = 'Zúčastnil/a se';
$string['field-date'] = 'Datum';
$string['field-endtime'] = 'Čas ukončení';
$string['field-filecount'] = 'Počet nahraných souborů';
$string['field-grade'] = 'Známka';
$string['field-groupsmulti'] = 'Skupiny (několik sloupců)';
$string['field-groupssingle'] = 'Skupiny';
$string['field-groupssingle-label'] = 'Skupiny (jeden sloupec)';
$string['field-location'] = 'Místo';
$string['field-maxstudents'] = 'Max. studentů';
$string['field-slotnotes'] = 'Poznámky ke termínu';
$string['field-starttime'] = 'Čas zahájení';
$string['field-studentemail'] = 'E-mail studenta';
$string['field-studentfirstname'] = 'Jméno studenta';
$string['field-studentfullname'] = 'Celé jméno studenta';
$string['field-studentidnumber'] = 'ID studenta';
$string['field-studentlastname'] = 'Příjmení studenta';
$string['field-studentnote'] = 'Zpráva od studenta';
$string['field-studentusername'] = 'Uživatelské jméno studenta';
$string['field-teachernote'] = 'Důvěrná poznámka (pouze pro učitele)';
$string['fileformat'] = 'Formát souboru';
$string['fileformat_help'] = 'K dispozici jsou následující formáty souborů:
<ul>
<li>Textové soubory oddělené čárkami (CSV). Oddělovač polí, ve výchozím nastavení čárka, lze zvolit níže.

Soubory CSV lze otevřít ve většině tabulkových aplikací;</li>
<li>Soubory Microsoft Excel (formát Excel 2007);</li>
<li>Tabulky Open Document (ODS);</li>
<li>Formát HTML – webová stránka zobrazující výstupní tabulku,
kterou lze vytisknout pomocí funkce tisku v prohlížeči;</li>
<li>Dokumenty PDF. Můžete si vybrat mezi orientací na šířku a na výšku.</li>
</ul>';
$string['forcewhenoverlap_link'] = 'mod/scheduler/conflict';
$string['ignoreconflicts_link'] = 'mod/scheduler/conflict';
$string['modulename_link'] = 'mod/scheduler/view';
$string['now'] = 'Nyní';
$string['usebookingform_link'] = 'mod/scheduler/bookingform';
