<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'id', version '4.1'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Address';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Insert/edit anchor';
$string['advanced:backcolor_desc'] = 'Select background color';
$string['advanced:block'] = 'Format';
$string['advanced:blockquote'] = 'Kutipan';
$string['advanced:blockquote_desc'] = 'Kutipan';
$string['advanced:bold_desc'] = 'Bold (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Sisipkan/hapus daftar berpoin';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Sisipkan karakter spesial';
$string['advanced:cleanup_desc'] = 'Cleanup messy code';
$string['advanced:clipboard_msg'] = 'Salin/potong/tempel tidak tersedia di Mozilla dan Firefox. Apakah Anda ingin informasi lebih lanjut tentang masalah ini?';
$string['advanced:code'] = 'Code';
$string['advanced:code_desc'] = 'Edit kode HTML';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Copy';
$string['advanced:custom1_desc'] = 'Deskripsi tersuai Anda di sini';
$string['advanced:cut_desc'] = 'Cut';
$string['advanced:dd'] = 'Definition description';
$string['advanced:div'] = 'DIV';
$string['advanced:dt'] = 'Definition term';
$string['advanced:font_size'] = 'Font size';
$string['advanced:fontdefault'] = 'Font family';
$string['advanced:forecolor_desc'] = 'Select text color';
$string['advanced:h1'] = 'Heading 1';
$string['advanced:h2'] = 'Heading 2';
$string['advanced:h3'] = 'Heading 3';
$string['advanced:h4'] = 'Heading 4';
$string['advanced:h5'] = 'Heading 5';
$string['advanced:h6'] = 'Heading 6';
$string['advanced:help_desc'] = 'Help';
$string['advanced:help_shortcut'] = 'Tekan ALT-F10 untuk bilah alat. Tekan ALT-0 untuk bantuan';
$string['advanced:hr_desc'] = 'Sisip garis horisontal';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Insert/edit image';
$string['advanced:image_props_desc'] = 'Image properties';
$string['advanced:indent_desc'] = 'Indentasi maju';
$string['advanced:italic_desc'] = 'Italic (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Align center';
$string['advanced:justifyfull_desc'] = 'Align full';
$string['advanced:justifyleft_desc'] = 'Align left';
$string['advanced:justifyright_desc'] = 'Align right';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Insert/edit link';
$string['advanced:more_colors'] = 'Warna lainnya...';
$string['advanced:newdocument'] = 'Are you sure you want clear all contents?';
$string['advanced:newdocument_desc'] = 'New document';
$string['advanced:numlist_desc'] = 'Sisipkan/hapus daftar bernomor';
$string['advanced:outdent_desc'] = 'Indentasi mundur';
$string['advanced:paragraph'] = 'Paragraph';
$string['advanced:paste_desc'] = 'Paste';
$string['advanced:path'] = 'Path';
$string['advanced:pre'] = 'Preformatted';
$string['advanced:redo_desc'] = 'Redo (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Remove formatting';
$string['advanced:rich_text_area'] = 'Area \'Rich Text\'';
$string['advanced:samp'] = 'Code sample';
$string['advanced:shortcuts_desc'] = 'Bantuan aksesibilitas';
$string['advanced:striketrough_desc'] = 'Strikethrough';
$string['advanced:style_select'] = 'Styles';
$string['advanced:sub_desc'] = 'Subscript';
$string['advanced:sup_desc'] = 'Superscript';
$string['advanced:toolbar'] = 'Bilah alat';
$string['advanced:toolbar_focus'] = 'Lompat ke tombol alat - Alt+Q, lompat ke editor - Alt-Z, lompat ke jalur elemen - Alt-X';
$string['advanced:underline_desc'] = 'Underline (Ctrl+U)';
$string['advanced:undo_desc'] = 'Undo (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Unlink';
$string['advanced:visualaid_desc'] = 'Tampilkan/sembunyikan pedoman/elemen tak terlihat';
$string['advanced_dlg:'] = 'Lanjutan';
$string['advanced_dlg:about_author'] = 'Author';
$string['advanced_dlg:about_general'] = 'About';
$string['advanced_dlg:about_help'] = 'Help';
$string['advanced_dlg:about_license'] = 'Lisensi';
$string['advanced_dlg:about_loaded'] = 'Loaded plugins';
$string['advanced_dlg:about_plugin'] = 'Plugin';
$string['advanced_dlg:about_plugins'] = 'Plugins';
$string['advanced_dlg:about_title'] = 'About TinyMCE';
$string['advanced_dlg:about_version'] = 'Version';
$string['advanced_dlg:accessibility_help'] = 'Bantuan aksesibilitas';
$string['advanced_dlg:accessibility_usage_title'] = 'Penggunaan umum';
$string['advanced_dlg:anchor_invalid'] = 'Harap tentukan nama jangkar yang valid.';
$string['advanced_dlg:anchor_name'] = 'Anchor name';
$string['advanced_dlg:anchor_title'] = 'Insert/edit anchor';
$string['advanced_dlg:charmap_title'] = 'Pilih karakter spesial';
$string['advanced_dlg:charmap_usage'] = 'Gunakan panah kiri dan kanan untuk menavigasi.';
$string['advanced_dlg:code_title'] = 'Editor kode HTML';
$string['advanced_dlg:code_wordwrap'] = 'Word wrap';
$string['advanced_dlg:colorpicker_color'] = 'Color:';
$string['advanced_dlg:colorpicker_name'] = 'Name:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Named';
$string['advanced_dlg:colorpicker_named_title'] = 'Named colors';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Palette';
$string['advanced_dlg:colorpicker_palette_title'] = 'Palette colors';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Picker';
$string['advanced_dlg:colorpicker_picker_title'] = 'Color picker';
$string['advanced_dlg:colorpicker_title'] = 'Select a color';
$string['advanced_dlg:image_align'] = 'Alignment';
$string['advanced_dlg:image_align_baseline'] = 'Baseline';
$string['advanced_dlg:image_align_bottom'] = 'Bottom';
$string['advanced_dlg:image_align_left'] = 'Left';
$string['advanced_dlg:image_align_middle'] = 'Middle';
$string['advanced_dlg:image_align_right'] = 'Right';
$string['advanced_dlg:image_align_textbottom'] = 'Text bottom';
$string['advanced_dlg:image_align_texttop'] = 'Text top';
$string['advanced_dlg:image_align_top'] = 'Top';
$string['advanced_dlg:image_alt'] = 'Image description';
$string['advanced_dlg:image_border'] = 'Border';
$string['advanced_dlg:image_dimensions'] = 'Dimensions';
$string['advanced_dlg:image_hspace'] = 'Horizontal space';
$string['advanced_dlg:image_list'] = 'Image list';
$string['advanced_dlg:image_src'] = 'URL gambar';
$string['advanced_dlg:image_title'] = 'Insert/edit image';
$string['advanced_dlg:image_vspace'] = 'Vertical space';
$string['advanced_dlg:invalid_color_value'] = 'Nilai warna tidak valid';
$string['advanced_dlg:link_is_email'] = 'URL yang Anda masukan sepertinya sebuah alamat surel, apakah Anda ingin menambahkan prefiks mailto:?';
$string['advanced_dlg:link_is_external'] = 'URL yang Anda masukan sepertinya sebuah tautan eksternal, apakah Anda ingin menambahkan prefiks http:// ?';
$string['advanced_dlg:link_list'] = 'Link list';
$string['advanced_dlg:link_target'] = 'Target';
$string['advanced_dlg:link_target_blank'] = 'Open link in a new window';
$string['advanced_dlg:link_target_same'] = 'Open link in the same window';
$string['advanced_dlg:link_title'] = 'Insert/edit link';
$string['advanced_dlg:link_titlefield'] = 'Title';
$string['advanced_dlg:link_url'] = 'Link URL';
$string['advhr:advhr_desc'] = 'Sisip baris horisontal';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Normal';
$string['advhr_dlg:noshade'] = 'No shadow';
$string['advhr_dlg:size'] = 'Height';
$string['advhr_dlg:width'] = 'Width';
$string['advhr_dlg:widthunits'] = 'Unit';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = 'Insert/edit image';
$string['advimage_dlg:align'] = 'Alignment';
$string['advimage_dlg:align_baseline'] = 'Baseline';
$string['advimage_dlg:align_bottom'] = 'Bottom';
$string['advimage_dlg:align_left'] = 'Left';
$string['advimage_dlg:align_middle'] = 'Middle';
$string['advimage_dlg:align_right'] = 'Right';
$string['advimage_dlg:align_textbottom'] = 'Text bottom';
$string['advimage_dlg:align_texttop'] = 'Text top';
$string['advimage_dlg:align_top'] = 'Top';
$string['advimage_dlg:alt'] = 'Image description';
$string['advimage_dlg:alt_image'] = 'Alternative image';
$string['advimage_dlg:border'] = 'Border';
$string['advimage_dlg:classes'] = 'Classes';
$string['advimage_dlg:constrain_proportions'] = 'Constrain proportions';
$string['advimage_dlg:dialog_title'] = 'Insert/edit image';
$string['advimage_dlg:dimensions'] = 'Dimensions';
$string['advimage_dlg:example_img'] = 'Tampilan pratinjau gambar';
$string['advimage_dlg:general'] = 'General';
$string['advimage_dlg:height'] = 'Tinggi';
$string['advimage_dlg:hspace'] = 'Horizontal space';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Image list';
$string['advimage_dlg:langcode'] = 'Language code';
$string['advimage_dlg:langdir'] = 'Language direction';
$string['advimage_dlg:list'] = 'Image list';
$string['advimage_dlg:long_desc'] = 'Long description link';
$string['advimage_dlg:ltr'] = 'Left to right';
$string['advimage_dlg:map'] = 'Image map';
$string['advimage_dlg:misc'] = 'Miscellaneous';
$string['advimage_dlg:missing_alt'] = 'Yakin ingin melanjutkan tanpa menyertakan deskripsi gambar? Tanpa itu gambar mungkin tidak dapat diakses oleh beberapa pengguna penyandang cacat, atau mereka yang menggunakan peramban teks, atau menjelajahi web dengan gambar dimatikan.';
$string['advimage_dlg:mouseout'] = 'for mouse out';
$string['advimage_dlg:mouseover'] = 'for mouse over';
$string['advimage_dlg:preview'] = 'Pratinjau';
$string['advimage_dlg:rtl'] = 'Right to left';
$string['advimage_dlg:src'] = 'URL gambar';
$string['advimage_dlg:style'] = 'Style';
$string['advimage_dlg:swap_image'] = 'Swap image';
$string['advimage_dlg:tab_advanced'] = 'Advanced';
$string['advimage_dlg:tab_appearance'] = 'Appearance';
$string['advimage_dlg:tab_general'] = 'General';
$string['advimage_dlg:title'] = 'Title';
$string['advimage_dlg:vspace'] = 'Vertical space';
$string['advimage_dlg:width'] = 'Lebar';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'Insert/edit link';
$string['advlink_dlg:accesskey'] = 'Kunci akses';
$string['advlink_dlg:advanced_props'] = 'Advanced properties';
$string['advlink_dlg:advanced_tab'] = 'Advanced';
$string['advlink_dlg:anchor_names'] = 'Anchors';
$string['advlink_dlg:classes'] = 'Classes';
$string['advlink_dlg:encoding'] = 'Karakter target pengodean';
$string['advlink_dlg:event_props'] = 'Events';
$string['advlink_dlg:events_tab'] = 'Events';
$string['advlink_dlg:general_props'] = 'General properties';
$string['advlink_dlg:general_tab'] = 'General';
$string['advlink_dlg:height'] = 'Tinggi';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'URL yang Anda masukan sepertinya sebuah alamat surel, apakah Anda ingin menambahkan prefiks mailto:?';
$string['advlink_dlg:is_external'] = 'URL yang Anda masukan sepertinya sebuah tautan eksternal, apakah Anda ingin menambahkan prefiks http:// ?';
$string['advlink_dlg:langcode'] = 'Language code';
$string['advlink_dlg:langdir'] = 'Language direction';
$string['advlink_dlg:link_list'] = 'Link list';
$string['advlink_dlg:list'] = 'Link list';
$string['advlink_dlg:ltr'] = 'Left to right';
$string['advlink_dlg:mime'] = 'Target MIME type';
$string['advlink_dlg:popup'] = 'Sembulan Javascript';
$string['advlink_dlg:popup_dependent'] = 'Dependent (Mozilla/Firefox only)';
$string['advlink_dlg:popup_location'] = 'Show location bar';
$string['advlink_dlg:popup_menubar'] = 'Show menu bar';
$string['advlink_dlg:popup_name'] = 'Window name';
$string['advlink_dlg:popup_opts'] = 'Options';
$string['advlink_dlg:popup_position'] = 'Position (X/Y)';
$string['advlink_dlg:popup_props'] = 'Properti sembulan';
$string['advlink_dlg:popup_resizable'] = 'Make window resizable';
$string['advlink_dlg:popup_return'] = 'Insert \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'Show scrollbars';
$string['advlink_dlg:popup_size'] = 'Size';
$string['advlink_dlg:popup_statusbar'] = 'Show status bar';
$string['advlink_dlg:popup_tab'] = 'Sembulan';
$string['advlink_dlg:popup_toolbar'] = 'Show toolbars';
$string['advlink_dlg:popup_url'] = 'URL Sembulan';
$string['advlink_dlg:rel'] = 'Relationship page to target';
$string['advlink_dlg:rev'] = 'Relationship target to page';
$string['advlink_dlg:rtl'] = 'Right to left';
$string['advlink_dlg:style'] = 'Style';
$string['advlink_dlg:tabindex'] = 'Tabindeks';
$string['advlink_dlg:target'] = 'Target';
$string['advlink_dlg:target_blank'] = 'Open in new window';
$string['advlink_dlg:target_langcode'] = 'Target language';
$string['advlink_dlg:target_name'] = 'Target name';
$string['advlink_dlg:target_parent'] = 'Buka di jendela/bingkai induk';
$string['advlink_dlg:target_same'] = 'Buka di jendela/bingkai ini';
$string['advlink_dlg:target_top'] = 'Open in top frame (replaces all frames)';
$string['advlink_dlg:title'] = 'Insert/edit link';
$string['advlink_dlg:titlefield'] = 'Title';
$string['advlink_dlg:url'] = 'URL Tautan';
$string['advlink_dlg:width'] = 'Lebar';
$string['advlist:circle'] = 'Lingkaran';
$string['advlist:def'] = 'Bawaan';
$string['advlist:disc'] = 'Diska';
$string['advlist:lower_alpha'] = 'Alfa kecil';
$string['advlist:lower_greek'] = 'Yunani kecil';
$string['advlist:lower_roman'] = 'Romawi kecil';
$string['advlist:square'] = 'Kotak';
$string['advlist:types'] = 'Jenis';
$string['advlist:upper_alpha'] = 'Alfa besar';
$string['advlist:upper_roman'] = 'Romawi besar';
$string['aria:rich_text_area'] = 'Area \'rich text\'';
$string['autosave:restore_content'] = 'Pulihkan konten yang disimpan secara otomatis';
$string['autosave:unload_msg'] = 'The changes you made will be lost if you navigate away from this page.';
$string['autosave:warning_message'] = 'Jika Anda memulihkan konten yang disimpan, Anda akan kehilangan semua konten yang saat ini ada di editor.

Apakah Anda yakin ingin memulihkan konten yang disimpan?';
$string['availablebuttons'] = 'Tombol yang tersedia';
$string['colors:000000'] = 'Hitam';
$string['colors:000080'] = 'Biru laut';
$string['colors:0000FF'] = 'Biru';
$string['colors:003300'] = 'Hijau tua';
$string['colors:003366'] = 'Biru tua';
$string['colors:008000'] = 'Hijau';
$string['colors:008080'] = 'Teal';
$string['colors:00CCFF'] = 'Biru langit';
$string['colors:00FF00'] = 'Lime';
$string['colors:00FFFF'] = 'Aqua';
$string['colors:333300'] = 'Zaitun gelap';
$string['colors:333333'] = 'Abu-abu sangat gelap';
$string['colors:333399'] = 'Nila';
$string['colors:3366FF'] = 'Biru indah';
$string['colors:339966'] = 'Hijau laut';
$string['colors:33CCCC'] = 'Pirus';
$string['colors:666699'] = 'Biru keabu-abuan';
$string['colors:800000'] = 'Merah tua';
$string['colors:800080'] = 'Ungu';
$string['colors:808000'] = 'Zaitun';
$string['colors:808080'] = 'Abu-abu';
$string['colors:993300'] = 'Jingga terbakar';
$string['colors:993366'] = 'Cokelat';
$string['colors:999999'] = 'Abu-abu sedang';
$string['colors:99CC00'] = 'Kuning hijau';
$string['colors:99CCFF'] = 'Biru langit cerah';
$string['colors:C0C0C0'] = 'Perak';
$string['colors:CC99FF'] = 'Prem';
$string['colors:CCFFCC'] = 'Hijau pucat';
$string['colors:CCFFFF'] = 'Cyan pucat';
$string['colors:FF0000'] = 'Merah';
$string['colors:FF00FF'] = 'Magenta';
$string['colors:FF6600'] = 'Jingga';
$string['colors:FF9900'] = 'Kuning sawo';
$string['colors:FF99CC'] = 'Merah muda';
$string['colors:FFCC00'] = 'Emas';
$string['colors:FFCC99'] = 'Persik';
$string['colors:FFFF00'] = 'Kuning';
$string['colors:FFFF99'] = 'Kuning muda';
$string['colors:FFFFFF'] = 'Putih';
$string['common:apply'] = 'Apply';
$string['common:browse'] = 'Browse';
$string['common:cancel'] = 'Cancel';
$string['common:class_name'] = 'Class';
$string['common:clipboard_msg'] = 'Salin/potong/tempel tidak tersedia di Mozilla dan Firefox. Apakah Anda ingin informasi lebih lanjut tentang masalah ini?';
$string['common:clipboard_no_support'] = 'Saat ini tidak didukung oleh peramban Anda, gunakan pintasan papan ketik saja.';
$string['common:close'] = 'Close';
$string['common:edit_confirm'] = 'Do you want to use the WYSIWYG mode for this textarea?';
$string['common:insert'] = 'Insert';
$string['common:invalid_data'] = 'Error: Invalid values entered, these are marked in red.';
$string['common:invalid_data_min'] = '{#field} harus berupa angka yang lebih besar dari {#min}';
$string['common:invalid_data_number'] = '{#field} harus berupa angka';
$string['common:invalid_data_size'] = '{#field} harus berupa angka atau persentase';
$string['common:more_colors'] = 'Warna lainnya';
$string['common:not_set'] = '-- Not set --';
$string['common:popup_blocked'] = 'Maaf, tetapi kami melihat bahwa pemblokir sembulan Anda telah menonaktifkan jendela yang menyediakan fungsionalitas aplikasi. Anda harus menonaktifkan pemblokiran sembulan di situs ini agar dapat menggunakan alat ini sepenuhnya.';
$string['common:update'] = 'Update';
$string['common:value'] = '(nilai)';
$string['contextmenu:align'] = 'Alignment';
$string['contextmenu:center'] = 'Center';
$string['contextmenu:full'] = 'Full';
$string['contextmenu:left'] = 'Left';
$string['contextmenu:right'] = 'Right';
$string['customconfig'] = 'Konfigurasi tersuai';
$string['customconfig_desc'] = 'Konfigurasi TinyMCE lanjutan tersuai dalam format JSON, misalnya: {"option1" : "value2", "option2" : "value2"}. Opsi apa pun yang ditentukan di sini mengesampingkan setelan standar dan pengaya.';
$string['customtoolbar'] = 'Bilah alat editor';
$string['customtoolbar_desc'] = 'Setiap baris berisi daftar nama tombol yang dipisahkan koma, gunakan "wrap" sebagai pemisah grup, baris kosong diabaikan. Lihat <a href="{$a}" target="_blank">{$a}</a> untuk daftar tombol TinyMCE bawaan.<br />Baris pertama akan selalu ditampilkan, sedangkan visibilitas bilah alat kedua dan ketiga dapat diaktifkan.';
$string['directionality:ltr_desc'] = 'Direction left to right';
$string['directionality:rtl_desc'] = 'Direction right to left';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'Emotions';
$string['emotions_dlg:cool'] = 'Cool';
$string['emotions_dlg:cry'] = 'Cry';
$string['emotions_dlg:desc'] = 'Emotions';
$string['emotions_dlg:embarassed'] = 'Embarassed';
$string['emotions_dlg:foot_in_mouth'] = 'Foot in mouth';
$string['emotions_dlg:frown'] = 'Frown';
$string['emotions_dlg:innocent'] = 'Innocent';
$string['emotions_dlg:kiss'] = 'Kiss';
$string['emotions_dlg:laughing'] = 'Laughing';
$string['emotions_dlg:money_mouth'] = 'Money mouth';
$string['emotions_dlg:sealed'] = 'Sealed';
$string['emotions_dlg:smile'] = 'Smile';
$string['emotions_dlg:surprised'] = 'Surprised';
$string['emotions_dlg:title'] = 'Insert emotion';
$string['emotions_dlg:tongue_out'] = 'Tongue out';
$string['emotions_dlg:undecided'] = 'Undecided';
$string['emotions_dlg:usage'] = 'Gunakan panah kiri dan kanan untuk menavigasi.';
$string['emotions_dlg:wink'] = 'Wink';
$string['emotions_dlg:yell'] = 'Yell';
$string['fontselectlist'] = 'Daftar fonta yang tersedia';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Document properties';
$string['fullpage_dlg:active_color'] = 'Active color';
$string['fullpage_dlg:add'] = 'Add new element';
$string['fullpage_dlg:add_base'] = 'Base element';
$string['fullpage_dlg:add_comment'] = 'Comment node';
$string['fullpage_dlg:add_link'] = 'Link element';
$string['fullpage_dlg:add_meta'] = 'Meta element';
$string['fullpage_dlg:add_script'] = 'Script element';
$string['fullpage_dlg:add_style'] = 'Style element';
$string['fullpage_dlg:add_title'] = 'Title element';
$string['fullpage_dlg:advanced_props'] = 'Advanced';
$string['fullpage_dlg:advanced_tab'] = 'Advanced';
$string['fullpage_dlg:appearance_bgprops'] = 'Background properties';
$string['fullpage_dlg:appearance_linkprops'] = 'Link colors';
$string['fullpage_dlg:appearance_marginprops'] = 'Body margins';
$string['fullpage_dlg:appearance_style'] = 'Stylesheet and style properties';
$string['fullpage_dlg:appearance_tab'] = 'Appearance';
$string['fullpage_dlg:appearance_textprops'] = 'Text properties';
$string['fullpage_dlg:author'] = 'Author';
$string['fullpage_dlg:base_element'] = 'Base element';
$string['fullpage_dlg:bgcolor'] = 'Background color';
$string['fullpage_dlg:bgimage'] = 'Background image';
$string['fullpage_dlg:bottom_margin'] = 'Bottom margin';
$string['fullpage_dlg:charset'] = 'Charset';
$string['fullpage_dlg:comment_element'] = 'Comment';
$string['fullpage_dlg:content'] = 'Content';
$string['fullpage_dlg:copyright'] = 'Copyright';
$string['fullpage_dlg:defer'] = 'Defer';
$string['fullpage_dlg:doctypes'] = 'Doctype';
$string['fullpage_dlg:encoding'] = 'Pengodean karakter';
$string['fullpage_dlg:font_face'] = 'Font face';
$string['fullpage_dlg:font_size'] = 'Font size';
$string['fullpage_dlg:fontface'] = 'Font family';
$string['fullpage_dlg:fontsize'] = 'Font size';
$string['fullpage_dlg:general_props'] = 'General';
$string['fullpage_dlg:head_elements'] = 'Head elements';
$string['fullpage_dlg:hover_color'] = 'Hover color';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF lang';
$string['fullpage_dlg:info'] = 'Information';
$string['fullpage_dlg:langcode'] = 'Language code';
$string['fullpage_dlg:langdir'] = 'Language direction';
$string['fullpage_dlg:langprops'] = 'Bahasa dan pengodean';
$string['fullpage_dlg:language'] = 'Language';
$string['fullpage_dlg:left_margin'] = 'Left margin';
$string['fullpage_dlg:link_color'] = 'Link color';
$string['fullpage_dlg:link_element'] = 'Link element';
$string['fullpage_dlg:ltr'] = 'Left to right';
$string['fullpage_dlg:media'] = 'Media';
$string['fullpage_dlg:meta_description'] = 'Description';
$string['fullpage_dlg:meta_element'] = 'Meta element';
$string['fullpage_dlg:meta_index_follow'] = 'Index and follow the links';
$string['fullpage_dlg:meta_index_nofollow'] = 'Index and don\'t follow the links';
$string['fullpage_dlg:meta_keywords'] = 'Keywords';
$string['fullpage_dlg:meta_noindex_follow'] = 'Do not index but follow the links';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Jangan mengindeks dan jangan ikuti tautan';
$string['fullpage_dlg:meta_props'] = 'Meta information';
$string['fullpage_dlg:meta_robots'] = 'Robots';
$string['fullpage_dlg:meta_tab'] = 'General';
$string['fullpage_dlg:meta_title'] = 'Title';
$string['fullpage_dlg:movedown'] = 'Move selected element down';
$string['fullpage_dlg:moveup'] = 'Move selected element up';
$string['fullpage_dlg:name'] = 'Name';
$string['fullpage_dlg:properties'] = 'Properties';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Remove selected element';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Right margin';
$string['fullpage_dlg:rtl'] = 'Right to left';
$string['fullpage_dlg:script_element'] = 'Script element';
$string['fullpage_dlg:src'] = 'Sumber';
$string['fullpage_dlg:style'] = 'Style';
$string['fullpage_dlg:style_element'] = 'Style element';
$string['fullpage_dlg:stylesheet'] = 'Stylesheet';
$string['fullpage_dlg:target'] = 'Target';
$string['fullpage_dlg:text_color'] = 'Text color';
$string['fullpage_dlg:textcolor'] = 'Color';
$string['fullpage_dlg:title'] = 'Document properties';
$string['fullpage_dlg:title_element'] = 'Title element';
$string['fullpage_dlg:top_margin'] = 'Top margin';
$string['fullpage_dlg:type'] = 'Type';
$string['fullpage_dlg:value'] = 'Value';
$string['fullpage_dlg:visited_color'] = 'Visited color';
$string['fullpage_dlg:xml_pi'] = 'XML declaration';
$string['fullscreen:desc'] = 'Beralih ke mode layar penuh';
$string['iespell:download'] = 'ieSpell not detected. Do you want to install it now?';
$string['iespell:iespell_desc'] = 'Periksa ejaan';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = 'Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday,Sunday';
$string['insertdatetime:day_short'] = 'Sun,Mon,Tue,Wed,Thu,Fri,Sat,Sun';
$string['insertdatetime:insertdate_desc'] = 'Insert date';
$string['insertdatetime:inserttime_desc'] = 'Insert time';
$string['insertdatetime:months_long'] = 'January,February,March,April,May,June,July,August,September,October,November,December';
$string['insertdatetime:months_short'] = 'Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Toggle absolute positioning';
$string['layer:backward_desc'] = 'Move backward';
$string['layer:content'] = 'New layer...';
$string['layer:forward_desc'] = 'Move forward';
$string['layer:insertlayer_desc'] = 'Insert new layer';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Sisipkan/edit media yang disematkan';
$string['media:edit'] = 'Edit embedded media';
$string['media_dlg:advanced'] = 'Advanced';
$string['media_dlg:align'] = 'Align';
$string['media_dlg:align_bottom'] = 'Bottom';
$string['media_dlg:align_bottom_left'] = 'Bottom left';
$string['media_dlg:align_bottom_right'] = 'Bottom right';
$string['media_dlg:align_center'] = 'Center';
$string['media_dlg:align_left'] = 'Left';
$string['media_dlg:align_right'] = 'Right';
$string['media_dlg:align_top'] = 'Top';
$string['media_dlg:align_top_left'] = 'Top left';
$string['media_dlg:align_top_right'] = 'Top right';
$string['media_dlg:altsource1'] = 'Sumber alternatif 1';
$string['media_dlg:altsource2'] = 'Sumber alternatif 2';
$string['media_dlg:audio'] = 'Audio HTML5';
$string['media_dlg:autogotourl'] = 'Auto goto URL';
$string['media_dlg:autohref'] = 'Auto HREF';
$string['media_dlg:autostart'] = 'Auto start';
$string['media_dlg:balance'] = 'Balance';
$string['media_dlg:base'] = 'Base';
$string['media_dlg:baseurl'] = 'URL Basis';
$string['media_dlg:bgcolor'] = 'Background';
$string['media_dlg:cache'] = 'Singgahan';
$string['media_dlg:captioningid'] = 'ID Takarir';
$string['media_dlg:center'] = 'Center';
$string['media_dlg:class_name'] = 'Class';
$string['media_dlg:console'] = 'Console';
$string['media_dlg:constrain_proportions'] = 'Constrain proportions';
$string['media_dlg:controller'] = 'Controller';
$string['media_dlg:controls'] = 'Controls';
$string['media_dlg:correction'] = 'No correction';
$string['media_dlg:currentmarker'] = 'Current marker';
$string['media_dlg:currentposition'] = 'Current position';
$string['media_dlg:defaultframe'] = 'Default frame';
$string['media_dlg:embedded_audio_options'] = 'Opsi audio tersemat';
$string['media_dlg:embeddedaudio'] = 'Audio tersemat';
$string['media_dlg:enabled'] = 'Enabled';
$string['media_dlg:enablejavascript'] = 'Enable JavaScript';
$string['media_dlg:endtime'] = 'End time';
$string['media_dlg:file'] = 'Berkas/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Flash options';
$string['media_dlg:flashvars'] = 'Flash vars';
$string['media_dlg:fullscreen'] = 'Layar penuh';
$string['media_dlg:general'] = 'General';
$string['media_dlg:hidden'] = 'Hidden';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'H-Space';
$string['media_dlg:html5_audio_options'] = 'Opsi audio';
$string['media_dlg:html5_video_options'] = 'Opsi video HTML5';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'iframe';
$string['media_dlg:imagestatus'] = 'Image status';
$string['media_dlg:invokeurls'] = 'Minta URL';
$string['media_dlg:kioskmode'] = 'Kiosk mode';
$string['media_dlg:list'] = 'List';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Loop';
$string['media_dlg:maintainaspect'] = 'Maintain aspect';
$string['media_dlg:menu'] = 'Show menu';
$string['media_dlg:mute'] = 'Mute';
$string['media_dlg:name'] = 'Name';
$string['media_dlg:nojava'] = 'Tanpa JAVA';
$string['media_dlg:numloop'] = 'Num loops';
$string['media_dlg:play'] = 'Auto play';
$string['media_dlg:playcount'] = 'Play count';
$string['media_dlg:playeveryframe'] = 'Play every frame';
$string['media_dlg:poster'] = 'Poster';
$string['media_dlg:prefetch'] = 'Prefetch';
$string['media_dlg:preload'] = 'Pramuat';
$string['media_dlg:preload_auto'] = 'Biarkan peramban pengguna memutuskan';
$string['media_dlg:preload_metadata'] = 'Pramuat metadata video';
$string['media_dlg:preload_none'] = 'Jangan pramuat';
$string['media_dlg:preview'] = 'Pratinjau';
$string['media_dlg:progress'] = 'Progress';
$string['media_dlg:qt_options'] = 'Opsi Quicktime';
$string['media_dlg:qt_stream_warn'] = 'Sumber daya RTSP yang dialirkan harus ditambahkan ke bidang sumber QT di bawah tab lanjutan.
Anda juga harus menambahkan versi non-streaming ke bidang sumber.';
$string['media_dlg:qtsrc'] = 'Sumber QT';
$string['media_dlg:qtsrcchokespeed'] = 'Choke speed';
$string['media_dlg:quality'] = 'Quality';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Rate';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Opsi Pemutar Real Media';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'Scale';
$string['media_dlg:scriptcallbacks'] = 'Script callbacks';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Shockwave options';
$string['media_dlg:shuffle'] = 'Shuffle';
$string['media_dlg:size'] = 'Dimensions';
$string['media_dlg:sound'] = 'Sound';
$string['media_dlg:source'] = 'Sumber';
$string['media_dlg:starttime'] = 'Start time';
$string['media_dlg:stretchtofit'] = 'Stretch to fit';
$string['media_dlg:swstretchhalign'] = 'Stretch H-Align';
$string['media_dlg:swstretchstyle'] = 'Gaya rentang';
$string['media_dlg:swstretchvalign'] = 'Stretch V-Align';
$string['media_dlg:target'] = 'Target';
$string['media_dlg:targetcache'] = 'Target singgahan';
$string['media_dlg:title'] = 'Sisipkan/edit media yang disematkan';
$string['media_dlg:type'] = 'Type';
$string['media_dlg:uimode'] = 'Mode UI';
$string['media_dlg:video'] = 'Video HTML5';
$string['media_dlg:volume'] = 'Volume';
$string['media_dlg:vspace'] = 'V-Space';
$string['media_dlg:windowlessvideo'] = 'Windowless video';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Opsi Windows Media Player';
$string['nonbreaking:nonbreaking_desc'] = 'Insert non-breaking space character';
$string['pagebreak:desc'] = 'Sisipkan jeda halaman untuk dicetak';
$string['paste:paste_text_desc'] = 'Tempel sebagai Teks biasa';
$string['paste:paste_word_desc'] = 'Paste from Word';
$string['paste:plaintext_mode'] = 'Tempel sekarang dalam mode teks biasa. Klik lagi untuk beralih kembali ke mode tempel biasa. Setelah Anda menempelkan sesuatu, Anda akan kembali ke mode tempel biasa.';
$string['paste:plaintext_mode_stick'] = 'Tempel sekarang dalam mode teks biasa. Klik lagi untuk beralih kembali ke mode tempel biasa.';
$string['paste:selectall_desc'] = 'Select All';
$string['paste_dlg:text_linebreaks'] = 'Keep linebreaks';
$string['paste_dlg:text_title'] = 'Gunakan Ctrl+V pada papan ketik Anda untuk menempelkan teks ke dalam jendela.';
$string['paste_dlg:word_title'] = 'Gunakan Ctrl+V pada papan ketik Anda untuk menempelkan teks ke dalam jendela.';
$string['pluginname'] = 'Editor HTML TinyMCE (lawas)';
$string['preview:preview_desc'] = 'Pratinjau';
$string['print:print_desc'] = 'Print';
$string['privacy:metadata'] = 'Pengaya editor TinyMCE tidak menyimpan data pribadi apa pun.';
$string['save:cancel_desc'] = 'Cancel all changes';
$string['save:save_desc'] = 'Save';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = 'Temukan/Ganti';
$string['searchreplace:search_desc'] = 'Find';
$string['searchreplace_dlg:allreplaced'] = 'All occurrences of the search string were replaced.';
$string['searchreplace_dlg:direction'] = 'Direction';
$string['searchreplace_dlg:down'] = 'Down';
$string['searchreplace_dlg:findnext'] = 'Find next';
$string['searchreplace_dlg:findwhat'] = 'Find what';
$string['searchreplace_dlg:mcase'] = 'Match case';
$string['searchreplace_dlg:notfound'] = 'The search has been completed. The search string could not be found.';
$string['searchreplace_dlg:replace'] = 'Replace';
$string['searchreplace_dlg:replace_title'] = 'Temukan/Ganti';
$string['searchreplace_dlg:replaceall'] = 'Replace all';
$string['searchreplace_dlg:replacewith'] = 'Replace with';
$string['searchreplace_dlg:search_title'] = 'Find';
$string['searchreplace_dlg:searchnext_desc'] = 'Find again';
$string['searchreplace_dlg:up'] = 'Up';
$string['settings'] = 'Setelan umum';
$string['simple:bold_desc'] = 'Bold (Ctrl+B)';
$string['simple:bullist_desc'] = 'Daftar tak berurut';
$string['simple:cleanup_desc'] = 'Cleanup messy code';
$string['simple:italic_desc'] = 'Italic (Ctrl+I)';
$string['simple:numlist_desc'] = 'Daftar berurut';
$string['simple:redo_desc'] = 'Redo (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Strikethrough';
$string['simple:underline_desc'] = 'Underline (Ctrl+U)';
$string['simple:undo_desc'] = 'Undo (Ctrl+Z)';
$string['spellchecker:desc'] = 'Beralih pengeja';
$string['spellchecker:ignore_word'] = 'Ignore word';
$string['spellchecker:ignore_words'] = 'Ignore all';
$string['spellchecker:langs'] = 'Languages';
$string['spellchecker:learn_word'] = 'Pelajari kata';
$string['spellchecker:menu'] = 'Setelan pengeja';
$string['spellchecker:no_mpell'] = 'No misspellings found.';
$string['spellchecker:no_sug'] = 'Tidak ada saran';
$string['spellchecker:sug'] = 'Suggestions';
$string['spellchecker:wait'] = 'Please wait...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Edit gaya CSS';
$string['style_dlg:apply'] = 'Apply';
$string['style_dlg:background'] = 'Latar belakang';
$string['style_dlg:background_attachment'] = 'Attachment';
$string['style_dlg:background_color'] = 'Background color';
$string['style_dlg:background_hpos'] = 'Horizontal position';
$string['style_dlg:background_image'] = 'Background image';
$string['style_dlg:background_repeat'] = 'Repeat';
$string['style_dlg:background_tab'] = 'Background';
$string['style_dlg:background_vpos'] = 'Vertical position';
$string['style_dlg:block'] = 'Blok';
$string['style_dlg:block_display'] = 'Display';
$string['style_dlg:block_letterspacing'] = 'Letter spacing';
$string['style_dlg:block_tab'] = 'Block';
$string['style_dlg:block_text_align'] = 'Text align';
$string['style_dlg:block_text_indent'] = 'Text indent';
$string['style_dlg:block_vertical_alignment'] = 'Vertical alignment';
$string['style_dlg:block_whitespace'] = 'Whitespace';
$string['style_dlg:block_wordspacing'] = 'Word spacing';
$string['style_dlg:border'] = 'Batas';
$string['style_dlg:border_tab'] = 'Border';
$string['style_dlg:bottom'] = 'Bottom';
$string['style_dlg:box'] = 'Box';
$string['style_dlg:box_clear'] = 'Clear';
$string['style_dlg:box_float'] = 'Float';
$string['style_dlg:box_height'] = 'Height';
$string['style_dlg:box_tab'] = 'Box';
$string['style_dlg:box_width'] = 'Width';
$string['style_dlg:bullet_image'] = 'Bullet image';
$string['style_dlg:clip'] = 'Clip';
$string['style_dlg:color'] = 'Color';
$string['style_dlg:height'] = 'Height';
$string['style_dlg:left'] = 'Left';
$string['style_dlg:list'] = 'Daftar';
$string['style_dlg:list_tab'] = 'List';
$string['style_dlg:list_type'] = 'Type';
$string['style_dlg:margin'] = 'Margin';
$string['style_dlg:overflow'] = 'Overflow';
$string['style_dlg:padding'] = 'Padding';
$string['style_dlg:placement'] = 'Placement';
$string['style_dlg:position'] = 'Position';
$string['style_dlg:positioning_tab'] = 'Positioning';
$string['style_dlg:positioning_type'] = 'Type';
$string['style_dlg:right'] = 'Right';
$string['style_dlg:same'] = 'Same for all';
$string['style_dlg:style'] = 'Style';
$string['style_dlg:text'] = 'Teks';
$string['style_dlg:text_blink'] = 'blink';
$string['style_dlg:text_case'] = 'Case';
$string['style_dlg:text_color'] = 'Color';
$string['style_dlg:text_decoration'] = 'Decoration';
$string['style_dlg:text_font'] = 'Font';
$string['style_dlg:text_lineheight'] = 'Line height';
$string['style_dlg:text_none'] = 'none';
$string['style_dlg:text_overline'] = 'overline';
$string['style_dlg:text_props'] = 'Text';
$string['style_dlg:text_size'] = 'Size';
$string['style_dlg:text_striketrough'] = 'Strikethrough';
$string['style_dlg:text_style'] = 'Style';
$string['style_dlg:text_tab'] = 'Text';
$string['style_dlg:text_underline'] = 'Garis bawah';
$string['style_dlg:text_variant'] = 'Variant';
$string['style_dlg:text_weight'] = 'Weight';
$string['style_dlg:title'] = 'Edit gaya CSS';
$string['style_dlg:toggle_insert_span'] = 'Sisip span pada pilihan';
$string['style_dlg:top'] = 'Top';
$string['style_dlg:visibility'] = 'Visibility';
$string['style_dlg:width'] = 'Width';
$string['style_dlg:zindex'] = 'Z-index';
$string['subplugintype_tinymce'] = 'Pengaya';
$string['subplugintype_tinymce_plural'] = 'Pengaya';
$string['table:cell'] = 'Cell';
$string['table:cell_desc'] = 'Table cell properties';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Column';
$string['table:col_after_desc'] = 'Insert column after';
$string['table:col_before_desc'] = 'Insert column before';
$string['table:copy_row_desc'] = 'Copy table row';
$string['table:cut_row_desc'] = 'Cut table row';
$string['table:del'] = 'Hapus tabel';
$string['table:delete_col_desc'] = 'Hapus kolom';
$string['table:delete_row_desc'] = 'Delete row';
$string['table:desc'] = 'Sisip/edit tabel';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Merge table cells';
$string['table:paste_row_after_desc'] = 'Paste table row after';
$string['table:paste_row_before_desc'] = 'Paste table row before';
$string['table:props_desc'] = 'Table properties';
$string['table:row'] = 'Row';
$string['table:row_after_desc'] = 'Insert row after';
$string['table:row_before_desc'] = 'Insert row before';
$string['table:row_desc'] = 'Table row properties';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Split merged table cells';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = 'Advanced properties';
$string['table_dlg:advanced_tab'] = 'Advanced';
$string['table_dlg:align'] = 'Alignment';
$string['table_dlg:align_bottom'] = 'Bottom';
$string['table_dlg:align_default'] = 'Default';
$string['table_dlg:align_left'] = 'Left';
$string['table_dlg:align_middle'] = 'Center';
$string['table_dlg:align_right'] = 'Right';
$string['table_dlg:align_top'] = 'Top';
$string['table_dlg:bgcolor'] = 'Background color';
$string['table_dlg:bgimage'] = 'Background image';
$string['table_dlg:border'] = 'Border';
$string['table_dlg:bordercolor'] = 'Border color';
$string['table_dlg:caption'] = 'Takarir tabel';
$string['table_dlg:cell_all'] = 'Update all cells in table';
$string['table_dlg:cell_cell'] = 'Update current cell';
$string['table_dlg:cell_col'] = 'Perbarui semua sel di kolom';
$string['table_dlg:cell_limit'] = 'You\'ve exceeded the maximum number of cells of {$cells}.';
$string['table_dlg:cell_row'] = 'Update all cells in row';
$string['table_dlg:cell_title'] = 'Table cell properties';
$string['table_dlg:cell_type'] = 'Cell type';
$string['table_dlg:cellpadding'] = 'Cell padding';
$string['table_dlg:cellspacing'] = 'Cell spacing';
$string['table_dlg:col_limit'] = 'You\'ve exceeded the maximum number of columns of {$cols}.';
$string['table_dlg:colgroup'] = 'Col Group';
$string['table_dlg:cols'] = 'Kolom';
$string['table_dlg:frame'] = 'Frame';
$string['table_dlg:frame_all'] = 'all';
$string['table_dlg:frame_cols'] = 'cols';
$string['table_dlg:frame_groups'] = 'groups';
$string['table_dlg:frame_none'] = 'none';
$string['table_dlg:frame_rows'] = 'rows';
$string['table_dlg:general_props'] = 'General properties';
$string['table_dlg:general_tab'] = 'General';
$string['table_dlg:height'] = 'Height';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Language code';
$string['table_dlg:langdir'] = 'Language direction';
$string['table_dlg:ltr'] = 'Left to right';
$string['table_dlg:merge_cells_title'] = 'Merge table cells';
$string['table_dlg:mime'] = 'Target MIME type';
$string['table_dlg:missing_scope'] = 'Apakah Anda yakin ingin melanjutkan tanpa menentukan cakupan untuk sel header tabel ini? Tanpa itu, mungkin sulit bagi beberapa pengguna penyandang disabilitas untuk memahami konten atau data yang ditampilkan dari tabel.';
$string['table_dlg:row_all'] = 'Update all rows in table';
$string['table_dlg:row_even'] = 'Update even rows in table';
$string['table_dlg:row_limit'] = 'You\'ve exceeded the maximum number of rows of {$rows}.';
$string['table_dlg:row_odd'] = 'Update odd rows in table';
$string['table_dlg:row_row'] = 'Update current row';
$string['table_dlg:row_title'] = 'Table row properties';
$string['table_dlg:rowgroup'] = 'Grup baris';
$string['table_dlg:rows'] = 'Rows';
$string['table_dlg:rowtype'] = 'Row type';
$string['table_dlg:rtl'] = 'Right to left';
$string['table_dlg:rules'] = 'Rules';
$string['table_dlg:rules_above'] = 'above';
$string['table_dlg:rules_below'] = 'below';
$string['table_dlg:rules_border'] = 'border';
$string['table_dlg:rules_box'] = 'box';
$string['table_dlg:rules_hsides'] = 'hsides';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'void';
$string['table_dlg:rules_vsides'] = 'vsides';
$string['table_dlg:scope'] = 'Scope';
$string['table_dlg:style'] = 'Style';
$string['table_dlg:summary'] = 'Ringkasan';
$string['table_dlg:tbody'] = 'Body';
$string['table_dlg:td'] = 'Data';
$string['table_dlg:tfoot'] = 'Footer';
$string['table_dlg:th'] = 'Header';
$string['table_dlg:thead'] = 'Header';
$string['table_dlg:title'] = 'Sisip/Edit tabel';
$string['table_dlg:valign'] = 'Vertical alignment';
$string['table_dlg:width'] = 'Width';
$string['template:desc'] = 'Insert predefined template content';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday,Sunday';
$string['template_dlg:day_short'] = 'Sun,Mon,Tue,Wed,Thu,Fri,Sat,Sun';
$string['template_dlg:desc'] = 'Insert predefined template content';
$string['template_dlg:desc_label'] = 'Description';
$string['template_dlg:label'] = 'Template';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'January,February,March,April,May,June,July,August,September,October,November,December';
$string['template_dlg:months_short'] = 'Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec';
$string['template_dlg:preview'] = 'Pratinjau';
$string['template_dlg:select'] = 'Select a template';
$string['template_dlg:title'] = 'Templates';
$string['template_dlg:warning'] = 'Warning: Updating a template with a different one may cause data loss.';
$string['visualblocks:desc'] = 'Tampilkan/sembunyikan elemen blok';
$string['visualchars:desc'] = 'Tampilkan/sembunyikan karakter kontrol visual';
$string['wordcount:words'] = 'Kata:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Abbreviation';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Acronym';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Sisipkan/edit atribut';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Citation';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Deletion';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Insertion';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Attributes';
$string['xhtmlxtras_dlg:attribs_title'] = 'Sisipkan/edit atribut';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Attributes';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Events';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'AccessKey';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Cite';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Class';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Tanggal/Waktu';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Language';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Arah teks';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Style';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'TabIndex';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Title';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Left to right';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Right to left';
$string['xhtmlxtras_dlg:events_tab'] = 'Events';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Atribut elemen';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Elemen even';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Setelan umum';
$string['xhtmlxtras_dlg:general_tab'] = 'General';
$string['xhtmlxtras_dlg:insert_date'] = 'Insert current date/time';
$string['xhtmlxtras_dlg:option_ltr'] = 'Left to right';
$string['xhtmlxtras_dlg:option_rtl'] = 'Right to left';
$string['xhtmlxtras_dlg:remove'] = 'Remove';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Elemen singkatan';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Elemen akronim';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Elemen sitasi';
$string['xhtmlxtras_dlg:title_del_element'] = 'Elemen penghapusan';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Eleman sisipan';
