<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'studentquiz', language 'sk', version '4.1'.
 *
 * @package     studentquiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abort_button'] = 'Prerušiť';
$string['add_comment'] = 'Pridať komentár';
$string['add_reply'] = 'Pridaj odpoveď';
$string['addprivatecomment'] = 'Pridať súkromný komentár (tieto sú viditeľné len medzi študentom a tútorom)';
$string['addprivatecomment_help'] = 'Tieto komentáre sú viditeľné výlučne medzi autorom otázky a administrátorom aktivity. Toto vlákno je skôr pre administrátora, aby mohol poskytnúť spätnú väzbu, ak a kedy niekto zmení stav otázky.';
$string['addpubliccomment'] = 'Pridanie verejného komentára';
$string['after_answering_end_date'] = 'StudentQuiz je uzavretý pre odpovede od {$a}.';
$string['after_submission_end_date'] = 'StudentQuiz je uzavretý pre odoslanie odpovedí od {$a}.';
$string['anonymous_user_name'] = 'Anonymný používateľ #{$a}';
$string['answeringndbeforestart'] = 'Uzávierku pre odpovede nemožno nastaviť pred otvorením dátumom pre odpovede';
$string['api_state_change_error_content'] = 'Túto otázku už nemožno odstrániť, pretože bola schválená.';
$string['api_state_change_error_title'] = 'Chyba pri vymazávaní otázky';
$string['api_state_change_success_content'] = 'Stav otázky / viditeľnosť otázky sa úspešne zmenila';
$string['api_state_change_success_title'] = 'Úspech';
$string['approve'] = 'Schváliť';
$string['approve_toggle'] = 'Zrušiť schválenie / Schváliť';
$string['approved'] = '✓';
$string['approved_column_name'] = 'Schválená (S)';
$string['approved_veryshort'] = 'S';
$string['approveselectedscheck'] = 'Naozaj chcete zrušiť schválenie/schváliť dané otázky ? <br /><br />{$a}';
$string['average_column_name'] = 'Priemerný';
$string['back_to_course_button'] = 'Návrat do kurzu';
$string['before_answering_end_date'] = 'StudentQuiz sa uzatvára  pre odpovede od {$a}.';
$string['before_answering_start_date'] = 'Otvorené pre odpovedanie od  {$a}.';
$string['before_submission_end_date'] = 'StudentQuiz sa uzatvára pre odoslanie odpovedí od {$a}.';
$string['before_submission_start_date'] = 'Otvorené pre odoslanie odpovedí od  {$a}.';
$string['cachedef_permissionssync'] = 'Sledovanie synchronizácie povolení StudentQuiz-u';
$string['cannotcapturecommenthistory'] = 'Nie je možné zaznamenať záznam histórie komentárov';
$string['changecurrentstate'] = 'Zmena stavu z <b>{$a}</b> na:';
$string['changestateto'] = 'Zmeňte stav na:';
$string['collapseall'] = 'Zbaliť všetky komentáre';
$string['collapsecomment'] = 'Zbaliť komentár';
$string['comment'] = 'Komentár';
$string['comment_author'] = 'Autor';
$string['comment_cannot_update'] = 'Nemožno aktualizovať komentár';
$string['comment_column_name'] = 'Komentáre';
$string['comment_error'] = 'Prosím komentujte';
$string['comment_error_unsaved'] = 'Chcete tento komentár uložiť ako prvý?';
$string['comment_help'] = 'Napíšte komentár';
$string['comment_help_help'] = 'Napíšte komentár k otázke.';
$string['comment_veryshort'] = 'K';
$string['commentcolumnexplainprivate'] = 'Počet súkromných komentárov. Modré pozadie vyjadruje, že máte aspoň jeden neprečítaný komentár.';
$string['commentcolumnexplainpublic'] = 'Počet verejných komentárov. Modré pozadie znamená, že máte aspoň jeden neprečítaný komentár.';
$string['commenthistory'] = 'História komentárov';
$string['commentplural'] = 'Komentáre';
$string['confirmdeletecomment'] = 'Naozaj chcete odstrániť tento komentár?';
$string['createnewquestion'] = 'Vytvorte novú otázku';
$string['createnewquestionfirst'] = 'Vytvorte prvú otázku';
$string['creator_anonym_fullname'] = 'Anonymný študent';
$string['current_of_total'] = '{$a->current} z {$a->total}';
$string['current_state'] = 'Aktuálny stav';
$string['daily'] = 'denne';
$string['delete'] = 'Zmaž';
$string['deletecomment'] = 'Zmažte komentár';
$string['deleted'] = 'Zmazené';
$string['deletedbyauthor'] = 'Tento príspevok bol odstránený dňa {$a}.';
$string['deletedbyuser'] = 'Tento príspevok bol odstránený používateľom <a href="{$a->profileurl}" >{$a->user} dňa {$a->date}.';
$string['deletedcomment'] = 'Príspevokk bol odstránený.';
$string['deleteorphanedquestions'] = 'Odstrániť osirotené otázky';
$string['deleteorphanedquestionserrormdlquestion'] = '<font color="red">chyba</font>: nedá sa vymazať z mdl_question tabuľky. Otázka sa pravdepodobne niekdy používa. <br><font color="red">chyba</font>: vymazanie z  tabuliek mdl_studentquiz* tables bolo preskočené.<br>';
$string['deleteorphanedquestionserrorstudentquiz'] = '<font color="red">error</font>:  nemôže vymazať z tabuliek mdl_studentquiz* .<br>';
$string['deleteorphanedquestionsfullmessage'] = 'Otázky, ktoré sú zamietnuté alebo označené na odstránenie: <ul>{$a->fullmessage}</ul>';
$string['deleteorphanedquestionsnonefound'] = '<b>žiadne nenájdené</b>';
$string['deleteorphanedquestionsquestioninfo'] = '<li><b>{$a->name}</b> (Typ otázky: {$a->qtype}, ID: {$a->questionid})</li>';
$string['deleteorphanedquestionssmallmessage'] = 'StudentQuiz: Úloha na odstránenie osirotených otázok bola spustená';
$string['deleteorphanedquestionssubject'] = 'StudentQuiz';
$string['deleteorphanedquestionssuccessmdlquestion'] = '<font color="green">úspech</font>: vymazané z tabuľky mdl_question <br>';
$string['deleteorphanedquestionssuccessstudentquiz'] = '<font color="green">úspech</font>: vymazané z tabuliek mdl_studentquiz* .<br>';
$string['describe_already_deleted'] = 'Tento komentár je už odstránený.';
$string['describe_not_creator'] = 'Toto nie je Váš komentár.';
$string['describe_out_of_time_delete'] = 'Tomuto komentáru už uplynul čas na jeho odstránenie';
$string['describe_out_of_time_edit'] = 'Tento komentár nie je možné upraviť';
$string['descriptioncofstate'] = 'Otázka nastavená na \'{$a->state}\'';
$string['descriptionofstatenew'] = 'Otázka bola uložená („Koncept“)';
$string['descriptionofvisibility'] = 'Viditeľnosť otázky nastavená na \'{$a->visibility}\'';
$string['difficulty_all_column_name'] = 'Obtiažnosť v komunite';
$string['difficulty_level_column_name'] = 'Obtiažnosť';
$string['difficulty_title'] = 'Ukazovateľ obtiažnosti';
$string['editcomment'] = 'Upraviť komentár';
$string['editedcomment_last_edit'] = 'Naposledy upravené:';
$string['editedcommenthistory'] = 'Editované {$a->lastesteditedcommentauthorname} v čase {$a->lastededitedcommenttime}';
$string['editedcommenthistorylinktext'] = 'História';
$string['editedcommenthistorywithuserlink'] = 'Editované <a href="{$a->lastesteditedcommentauthorprofileurl}">{$a->lastesteditedcommentauthorname}</a>   v čase {$a->lastededitedcommenttime}';
$string['editorplaceholder'] = 'Sem zadajte svoj komentár ...';
$string['emailautomationnote'] = 'Vezmite prosím na vedomie, že toto je automatizová správa systému - táto emailová adresa nie je monitorovaná.';
$string['emailcommentaddedbody'] = 'Vážený/vážená  {$a->recepientname},

Vaša otázka  \'{$a->questionname}\'  v kurze \'{$a->coursename}\' v aktivite  StudentQuiz \'{$a->modulename}\' bola komentovaná  \'{$a->actorname}\'  dňa   \'{$a->timestamp}\'.

Komentár je :  \'{$a->commenttext}\'

Vašu otázku si môžete pozrieť na : {$a->questionurl}.';
$string['emailcommentaddedsmall'] = 'Vaša otázka \'{$a->questionname}\'  bola okomentovaná {$a->actorname}.';
$string['emailcommentaddedsubject'] = 'Bola okomentovaná otázka:  {$a->questionname}';
$string['emailcommentdeletedbody'] = 'Vážený/Vážená{$a->recepientname},

Komentár  \'{$a->commenttime}\' k Vašej otázke \'{$a->questionname}\' v aktivite StudentQuiz \'{$a->modulename}\'  kurzu  \'{$a->coursename}\' bol zmazaný  \'{$a->actorname}\', a to  \'{$a->timestamp}\'.

Komentár bol: \'{$a->commenttext}\'

Otázku si môžete prehliadnuť na : {$a->questionurl}.';
$string['emailcommentdeletedsmall'] = 'Komentár k Vašej otázke  \'{$a->questionname}\' bol vymazaný  {$a->actorname}.';
$string['emailcommentdeletedsubject'] = 'Bol vymazaný komentár k otázke:  {$a->questionname}';
$string['emaildigestbody'] = 'Toto je váš {$a->digesttype} súhrn upozornení pre aktivitu StudentQuiz  <b>{$a->modulename}</b>, ktorá je k dispozícii tu:';
$string['emaildigestbody_section_content'] = 'Vaša otázka <b>{$a->questionname}</b> bola <b>{$a->actiontype}</b> od <b>{$a->actorname}</b>';
$string['emaildigestbody_section_title'] = 'Notifikácia {$a->seq}, {$a->timestamp}';
$string['emaildigestsubject'] = 'Oznámenie o súhrne oznamov pre StudentQuiz';
$string['emailminecommentdeletedbody'] = 'Vážený/Vážená {$a->recepientname},

Váš komentár  \'{$a->commenttime}\' k otázke  \'{$a->questionname}\' v aktivite StudentQuiz  \'{$a->modulename}\' kurzu  \'{$a->coursename}\'  bol vymazaný  \'{$a->actorname}\' v čase  \'{$a->timestamp}\'.

Obsah komentára bol: \'{$a->commenttext}\'

Vašu otázku si môžete prehliadnuť na : {$a->questionurl}.';
$string['emailminecommentdeletedsmall'] = 'Váš komentár k otázke  \'{$a->questionname}\'  bol zmazaný recenzentom  {$a->actorname}.';
$string['emailminecommentdeletedsubject'] = 'Komentár bol zmazaný pre otázku:  {$a->questionname}';
$string['emailnoityfyreviewablequestion_section_content'] = 'Otázka „<b>{$a->questionname}</b>“ bola nastavená ako „<b>Reviewable</b>“ od <b>{$a->actorname}</b>';
$string['emailnoityfyreviewablequestionsinglebody'] = '<b>{$a->courseshortname}</b> Aktivita StudentQuiz (<b>"{$a->modulename}"</b>): otázka <b>"{$a->questionname}"</ b> bola nastavené na "<b>Reviewable</b>" od <b>{$a->actorname}, {$a->timestamp}.</b>';
$string['emailsalutation'] = 'Vážený/vážená {$a},';
$string['emailsinglebody'] = 'Vaša otázka <b>{$a->questionname}</b> v aktivite StudentQuiz <b>{$a->modulename}</b> v kurze <b>{$a->coursename}</b>  bola {$a->eventname} od <b>{$a->actorname}</b> v <b>{$a->timestamp}</b>.';
$string['emailsinglebody_reviewlink'] = 'Túto otázku môžete skontrolovať na:';
$string['error_form_validation'] = '{$a}';
$string['error_permission'] = 'Prepáčte, ale pre zobrazenie tejto stránky musíte byť súčasťou skupiny.';
$string['error_sendalert'] = 'Pri odosielaní vášho prehľadu na adresu {$a} sa vyskytla chyba. Prehľad sa nepodarilo odoslať.';
$string['expandall'] = 'Rozbaľte všetky komentáre';
$string['expandcomment'] = 'Rozbaliť komentár';
$string['filter'] = 'Filter';
$string['filter_advanced_element'] = '{$a} (Pokročilý prvok)';
$string['filter_comment_label_date'] = 'Dátum';
$string['filter_comment_label_forename'] = 'Krstné meno';
$string['filter_comment_label_sort_by'] = 'Triediť podľa:';
$string['filter_comment_label_sort_toggle'] = 'Triediť podľa: {$a->field} {$a->type}';
$string['filter_comment_label_surname'] = 'Priezvisko';
$string['filter_ishigher'] = 'je väčší ako';
$string['filter_islower'] = 'je menší ako';
$string['filter_label_approved'] = 'Schválené otázky';
$string['filter_label_comment'] = 'Komentáre';
$string['filter_label_createdate'] = 'Vytvorenie';
$string['filter_label_difficulty_level'] = 'Náročnosť';
$string['filter_label_fast_filters'] = 'Rýchly filter na otázky';
$string['filter_label_myattempts'] = 'Moje pokusy';
$string['filter_label_mydifficulty'] = 'Moja náročnosť';
$string['filter_label_mylastattempt'] = 'Môj posledný pokus';
$string['filter_label_myrate'] = 'Moje hodnotenie';
$string['filter_label_onlyapproved'] = 'Schválené';
$string['filter_label_onlyapproved_help'] = 'Otázky schválené Vaším učiteľom';
$string['filter_label_onlydifficult'] = 'Náročné pre všetkých';
$string['filter_label_onlydifficult_help'] = 'Otázka s priemernou náročnosťou viac ako  {$a}%';
$string['filter_label_onlydifficultforme'] = 'Náročné pre mňa';
$string['filter_label_onlydifficultforme_help'] = 'Otázka s osobnou náročnosťou viac ako {$a}%';
$string['filter_label_onlygood'] = 'Dobré';
$string['filter_label_onlygood_help'] = 'Otázka s priemerným hodnotením aspoň {$a} hviezdičky';
$string['filter_label_onlymine'] = 'Moje';
$string['filter_label_onlymine_help'] = 'Vami vytvorené otázky';
$string['filter_label_onlynew'] = 'Nezodpovedané';
$string['filter_label_onlynew_help'] = 'Otázky nikdy predtým nezodpovedané';
$string['filter_label_question'] = 'Názov otázky';
$string['filter_label_question_creation_item'] = '{$a->creationtext} {$a->rowtext} {$a->inputtext}';
$string['filter_label_question_creation_item_inputtext'] = '{$a->inputtext} {$a->inputtype}';
$string['filter_label_questiontext'] = 'Obsah otázky';
$string['filter_label_rates'] = 'Hodnotenie';
$string['filter_label_show_mine'] = 'Moje otázky';
$string['filter_label_tags'] = 'Značka (tág)';
$string['finish_button'] = 'Ukončené';
$string['hidden'] = 'Skrytý';
$string['history'] = 'História';
$string['includingunread'] = '(vrátane neprečítaných)';
$string['invalidcomment'] = 'neplatný komentár';
$string['invalidemail'] = 'Táto e-mailová adresa nie je platná. Zadajte jednu e-mailovú adresu.';
$string['lastattempt_right'] = '✓';
$string['lastattempt_right_label'] = 'Posledný správny pokus';
$string['lastattempt_wrong'] = '✗';
$string['lastattempt_wrong_label'] = 'Posledný nesprávny pokus';
$string['latest_column_name'] = 'Posledný';
$string['manager_anonym_fullname'] = 'Anonymný správca';
$string['message'] = 'Správa';
$string['messageprovider:commentadded'] = 'Notifikácia pridania komentára';
$string['messageprovider:commentdeleted'] = 'Notifikácia vymazania komentára';
$string['messageprovider:deleteorphanedquestions'] = 'Upozornenie o vymazanej otázke';
$string['messageprovider:minecommentdeleted'] = 'Notifikácia vymazania môjho komentára';
$string['messageprovider:questionchanged'] = 'Upozornenie na vymazanie otázky';
$string['migrate_already_done'] = 'Nič sa neuskutočnilo, pretože táto aktivita už bola presunutá !';
$string['migrate_ask'] = 'Rýchlosť StudentQuiz sa síce zlepšila s verziou 3.2.1, ale táto otázka je stále založená na predchádzajúcej verzii. Otázky a kvízy sa načítajú rýchlejšie, ak spustíte túto zrýchlenú migráciu. Budete mať rýchlejšie načítavanie; inak nič sa nezmení.';
$string['migrate_studentquiz'] = 'Migrovať otázky služby StudentQuiz pred verziou 3.2.1 na rýchlejšiu verziu s agregovanými hodnotami';
$string['migrate_studentquiz_short'] = 'Urýchliť túto sadu otázok';
$string['migrated_successful'] = 'Táto aktivita bola úspešne migrovaná!';
$string['mine_column_name'] = 'Moje';
$string['missingparam'] = 'Požadovaný parameter chýba alebo je nesprávny';
$string['moderator'] = 'Moderátor';
$string['modulename'] = 'StudentQuiz';
$string['modulename_help'] = 'Aktivita StudentQuiz umožňuje študentom kolektívne pridávať otázky. V prehľade StudentQuiz-u môžu študenti filtrovať otázky. Tiež môžu použiť filtrované otázky na precvičenie. Učiteľ má možnosť anonymizovať stĺpec vytvorený v stĺpci. <br> <br> Aktivita StudentQuiz udeľuje študentom body, ktoré ich motivujú k tomu, aby pridávali otázky a precvičovali sa s nimy. Body sú uvedené v tabuľke hodnotenia.';
$string['modulename_link'] = 'mod/studentquiz/view';
$string['modulenameplural'] = 'StudentQuizzes';
$string['more'] = 'Viac';
$string['myattempts_column_name'] = 'Moje pokusy';
$string['mydifficulty_column_name'] = 'Moja náročnosť';
$string['mylastattempt_column_name'] = 'Môj posledný pokus';
$string['myrate_column_name'] = 'Moje hodnotenie';
$string['nav_export'] = 'Export';
$string['nav_import'] = 'Import';
$string['nav_question_no'] = 'Otázka  {$a->current} z  {$a->total}';
$string['needtoallowatleastoneqtype'] = 'Musíte povoliť aspoň jeden typ otázky';
$string['next_button'] = 'Ďalší';
$string['no_comment'] = 'žiadne';
$string['no_comments'] = 'Žiadne komentáre';
$string['no_difficulty_level'] = 'žiadne';
$string['no_myattempts'] = 'žiadne';
$string['no_mylastattempt'] = 'žiadne';
$string['no_mylastattempt_label'] = 'Táto otázka nie je zodpovedaná';
$string['no_questions_add'] = 'V  tomto StudentQuiz-e nie sú žiadne otázky. Môžete nejaké pridať.';
$string['no_questions_filter'] = 'Žiadne otázky nespadajú do Vašich kritérii výberu. Zrušte výber, aby ste videli všetky otázky.';
$string['no_questions_selected_message'] = 'Prosím vyberte si aspoň jednu otázku pre začatie testu.';
$string['no_rates'] = 'žiadne';
$string['no_tags'] = 'žiadne';
$string['nocommenthistoryexist'] = 'Neexistuje zatiaľ žiadna história komentárov pre tento komentár.';
$string['nofurtherprivatecomments'] = 'Po \'schválení\' otázky nie sú povolené žiadne ďalšie súkromné komentáre';
$string['noquestionsselectedtodoaction'] = 'Pred výberom tejto akcie prosím vyberte jednu alebo viac otázok.';
$string['not_approved'] = '✗';
$string['notshowratingcomment'] = 'Hodnotenie a verejné komentáre nie sú k dispozícii pre Vašu vlastnú otázku v režime Náhľad';
$string['num_questions'] = '{$a} otázky';
$string['number_column_name'] = 'Číslo';
$string['numberreply'] = '{$a} Odpovede';
$string['onlyrootcommentcanreply'] = 'Možno odpovedať len na prvú úroveň komentára';
$string['pagesize'] = 'Veľkosť strany:';
$string['pagesize_invalid_input'] = 'Chyba: špecifikovaná veľkosť strany musí byť platné číslo.';
$string['pin'] = 'Pripnúť otázku';
$string['please_enrole_message'] = 'Prosím, zapíšte sa do kurzu, aby ste mohli vidieť Vaše osobné napredovanie';
$string['pluginadministration'] = 'Administrácia StudentQuiz-u';
$string['pluginname'] = 'StudentQuiz';
$string['previous_button'] = 'Predchádzajúci';
$string['privacy:metadata:mod_studentquiz_comment_sort'] = 'Predvoľba používateľa pre typ filtra komentárov.';
$string['privacy:metadata:mod_studentquiz_question_active_tab'] = 'Predvoľba používateľa pre aktuálnu aktívnu stránku s otázkami.';
$string['privacy:metadata:studentquiz_attempt'] = 'Predstavuje pokusy používateľov odpovedať na súbor otázok.';
$string['privacy:metadata:studentquiz_attempt:categoryid'] = 'ID kategórie.';
$string['privacy:metadata:studentquiz_attempt:questionusageid'] = 'ID použitia otázky.';
$string['privacy:metadata:studentquiz_attempt:studentquizid'] = 'ID StudenQuiz-u.';
$string['privacy:metadata:studentquiz_attempt:userid'] = 'ID používateľa.';
$string['privacy:metadata:studentquiz_comment'] = 'Uložte komentáre k otázkam.';
$string['privacy:metadata:studentquiz_comment:comment'] = 'Komentár otázky.';
$string['privacy:metadata:studentquiz_comment:created'] = 'Čas vytvorenia komentára.';
$string['privacy:metadata:studentquiz_comment:deleted'] = 'Čas vymazania komentára.';
$string['privacy:metadata:studentquiz_comment:deleteuserid'] = 'ID používateľa vymazaného komentára.';
$string['privacy:metadata:studentquiz_comment:edited'] = 'Časom upravený časový komentár.';
$string['privacy:metadata:studentquiz_comment:edituserid'] = 'ID používateľa upraveného komentára';
$string['privacy:metadata:studentquiz_comment:parentid'] = 'ID rodičovského komentára. 0: komentár najvyššej úrovne.';
$string['privacy:metadata:studentquiz_comment:status'] = 'Stav komentára';
$string['privacy:metadata:studentquiz_comment:studentquizquestionid'] = 'ID otázky zo StudentQuiz.';
$string['privacy:metadata:studentquiz_comment:timemodified'] = 'Čas úpravy komentára';
$string['privacy:metadata:studentquiz_comment:type'] = 'Typ komentára';
$string['privacy:metadata:studentquiz_comment:userid'] = 'ID používateľa.';
$string['privacy:metadata:studentquiz_comment:usermodified'] = 'ID používateľa upraveného komentára';
$string['privacy:metadata:studentquiz_comment_history'] = 'Ukladajte históriu komentárov';
$string['privacy:metadata:studentquiz_comment_history:action'] = 'Typ histórie 0 - vytvoriť | 1 - editovať | 2 - vymazať';
$string['privacy:metadata:studentquiz_comment_history:commentid'] = 'ID komentára';
$string['privacy:metadata:studentquiz_comment_history:content'] = 'Obsah histórie komentárov';
$string['privacy:metadata:studentquiz_comment_history:timemodified'] = 'Upravený čas komentára';
$string['privacy:metadata:studentquiz_comment_history:userid'] = 'ID používateľa, ktorý edituje komentár';
$string['privacy:metadata:studentquiz_notification'] = 'Poradie oznámení';
$string['privacy:metadata:studentquiz_notification:content'] = 'Obsah oznámenia';
$string['privacy:metadata:studentquiz_notification:recipientid'] = 'ID príjemcu';
$string['privacy:metadata:studentquiz_notification:status'] = 'Stav oznámenia';
$string['privacy:metadata:studentquiz_notification:studentquizid'] = 'StudentQuiz ID';
$string['privacy:metadata:studentquiz_notification:timetosend'] = 'Čas zaslať oznámenie';
$string['privacy:metadata:studentquiz_progress'] = 'Uložte informácie o napredovaní študenta s touto otázkou.';
$string['privacy:metadata:studentquiz_progress:attempts'] = 'Počet pokusov zodpovedať túto otázku.';
$string['privacy:metadata:studentquiz_progress:correctattempts'] = 'Počet správnych odpovedí';
$string['privacy:metadata:studentquiz_progress:lastanswercorrect'] = '0: posledná odpoveď bola nesprávna alebo nedefinovaná, 1: posledná odpoveď bola správna.';
$string['privacy:metadata:studentquiz_progress:lastreadprivatecomment'] = 'Čas, kedy si používateľ naposledy prečítal súkromné komentáre';
$string['privacy:metadata:studentquiz_progress:lastreadpubliccomment'] = 'Čas, kedy si používateľ naposledy prečítal verejné komentáre';
$string['privacy:metadata:studentquiz_progress:studentquizid'] = 'ID StudentQuiz-u.';
$string['privacy:metadata:studentquiz_progress:studentquizquestionid'] = 'ID otázky zo StudentQuiz-u.';
$string['privacy:metadata:studentquiz_progress:userid'] = 'ID používateľa.';
$string['privacy:metadata:studentquiz_question'] = 'Uložiť vlastnosti súvisiace s otázkami';
$string['privacy:metadata:studentquiz_question:groupid'] = 'ID skupiny, do ktorej patrí otázka';
$string['privacy:metadata:studentquiz_question:hidden'] = 'Vlastnosť, či je otázka skrytá alebo nie';
$string['privacy:metadata:studentquiz_question:pinned'] = 'Vlastnosť, či je otázka pripnutá alebo nie';
$string['privacy:metadata:studentquiz_question:state'] = 'Vlastnosť, či je otázka schválená, neschválená, nová alebo zmenená';
$string['privacy:metadata:studentquiz_question:studentquizid'] = 'ID StudentQuiz-u.';
$string['privacy:metadata:studentquiz_rate'] = 'Uložte hodnotenia otázok.';
$string['privacy:metadata:studentquiz_rate:rate'] = 'Ohodnoťte otázku.';
$string['privacy:metadata:studentquiz_rate:studentquizquestionid'] = 'ID pre „studentquizquestion".';
$string['privacy:metadata:studentquiz_rate:userid'] = 'ID používateľa.';
$string['privacy:metadata:studentquiz_state_history:state'] = 'Vlastnosť, či je otázka schválená, neschválená, nová alebo zmenená';
$string['privacy:metadata:studentquiz_state_history:studentquizquestionid'] = 'ID pre „studentquizquestion“.';
$string['privacy:metadata:studentquiz_state_history:timecreated'] = 'Čas na vytvorenie akcie.';
$string['privacy:metadata:studentquiz_state_history:userid'] = 'ID používateľa.';
$string['private'] = 'Súkromné';
$string['privatecomments'] = 'Súkromné komentáre';
$string['progress_bar_caption'] = 'Váš pokrok v aktivite StudentQuiz';
$string['public'] = 'Verejné';
$string['publiccomments'] = 'Verejné komentáre';
$string['questionchangedlowercase'] = 'zmenené';
$string['questionsinuse'] = '(* Otázky označené hviezdičkou sa už používajú v niektorých testoch.)';
$string['ranking_block_title'] = 'Poradie';
$string['ranking_block_title_anonymised'] = 'Poradie (anonymizované)';
$string['rate_all_column_name'] = 'Skupinové hodnotenie';
$string['rate_column_name'] = 'Hodnotenie';
$string['rate_error'] = 'Prosím, ohodnoťte';
$string['rate_help'] = 'Ohodnoťte túto otázku';
$string['rate_help_help'] = 'Ohodnoťte túto otázku. <br /> 1 hviezdička znamená veľmi zle a 5 hviezdičiek znamenajú veľmi dobre';
$string['rate_multi_stars_desc'] = 'Vybraných {$a} hviezdičiek';
$string['rate_one_star_desc'] = 'Zvolená jedna hviezdička';
$string['rate_points'] = 'Body';
$string['rate_title'] = 'Zhodnoťte';
$string['ratingbar_title'] = 'Hodnotiaci ukazovateľ';
$string['remove_comment'] = 'Odstránenie';
$string['remove_comment_label'] = 'Odstránenie komentára';
$string['replies'] = 'Odpovede';
$string['reply'] = 'Odpoveď';
$string['replycomment'] = 'Odpoveď';
$string['report_comment_condition1'] = 'Je to urážlivé';
$string['report_comment_condition2'] = 'Je to obťažovanie';
$string['report_comment_condition3'] = 'Obsahuje obscénny obsah, napríklad pornografiu';
$string['report_comment_condition4'] = 'Je to urážlivé alebo hanlivé';
$string['report_comment_condition5'] = 'Porušuje autorské práva';
$string['report_comment_condition6'] = 'Je to proti pravidlám z iného dôvodu';
$string['report_comment_condition_more'] = 'Ďalšie informácie (nepovinné)';
$string['report_comment_emailappendix'] = 'Tento e-mail ste dostali, pretože vaša e-mailová adresa bola zadaná v StudentQuiz pre nahlásenie neprijateľného komentára.';
$string['report_comment_emailpreface'] = 'Komentár bol nahlásený používateľom  {$a->fullname} ({$a->username},
{$a->email}).';
$string['report_comment_emailsubject'] = 'Nahlásenie komentára  {$a->commentid}: {$a->coursename} {$a->studentquizname}';
$string['report_comment_feedback'] = 'Vaša správa bola úspešne odoslaná. Zamestnanec vyšetrí  tento problém.';
$string['report_comment_info'] = 'Funkcia „Nahlásiť“ môže odoslať tento komentár zamestnancovi, ktorý to prešetrí. <strong>Túto funkciu použite, iba ak si myslíte, že komentár porušuje Pravidlá </strong>.';
$string['report_comment_invalid'] = 'Musíte uviesť dôvod nahlásenia tohto komentára.';
$string['report_comment_invalid_checkbox'] = 'Musíte označiť aspoň jedno z políčok.';
$string['report_comment_link_text'] = 'Ukážka tu';
$string['report_comment_not_available'] = 'Funkcia komentára k hláseniu nie je k dispozícii.';
$string['report_comment_pagename'] = 'Nahlásiť komentár ako neprijateľný';
$string['report_comment_reasons'] = 'Dôvody nahlásenia komentára:';
$string['report_comment_reporter_detail'] = '{$a->fullname} ({$a->username}; {$a->email}; {$a->ip})';
$string['report_comment_reporter_info'] = '<strong>Podrobnosti reportéra</strong>:';
$string['report_comment_submit'] = 'Odoslať správu';
$string['reportcomment'] = 'Správa';
$string['reportcomment_title'] = 'Nahlásiť komentár ako neprijateľný';
$string['reportquiz_admin_title'] = 'Štatistika študentov';
$string['reportquiz_stats_all_last_attempt_correct'] = 'Priemer komunity za posledné správne odpovede';
$string['reportquiz_stats_all_last_attempt_incorrect'] = 'Priemer komunity za posledné nesprávne odpovede';
$string['reportquiz_stats_all_percentage_correct_answers'] = 'Percentuálny podiel komunity za správne odpovede';
$string['reportquiz_stats_all_percentage_correct_answers_help'] = 'Súčet správnych odpovedí / súčet všetkých odpovedí.';
$string['reportquiz_stats_all_progress'] = 'Priemerný pokrok komunity';
$string['reportquiz_stats_all_progress_help'] = 'Priemerný pokrok v komunite založený na všetkých členoch komunity.';
$string['reportquiz_stats_all_question_attempts_correct'] = 'Priemer komunity za posledné správne odpovede';
$string['reportquiz_stats_all_question_attempts_incorrect'] = 'Priemer komunity za posledné nesprávne odpovede';
$string['reportquiz_stats_all_questions_answered'] = 'Priemer komunity zo všetkých odpovedí';
$string['reportquiz_stats_all_questions_answered_help'] = 'Priemerný počet odpovedí poskytnutých všetkými členmi komunity.';
$string['reportquiz_stats_all_questions_approved'] = 'Počet schválených otázok';
$string['reportquiz_stats_all_questions_approved_help'] = 'Učitelia môžu schvaľovať otázky na overenie správnosti. Toto je počet všetkých schválených otázok v rámci tohto StudentQuiz-u.';
$string['reportquiz_stats_all_questions_created'] = 'Počet otázok v tomto StudentQuiz-e.';
$string['reportquiz_stats_all_questions_created_help'] = 'Počet otázok vytvorených komunitou.';
$string['reportquiz_stats_all_rates_average'] = 'Priemer hodnotenia zo všetkých otázok';
$string['reportquiz_stats_all_rates_average_help'] = 'Hodnotenie každej otázky je priemerom hviezdičiek, ktoré získala od komunity. Príklad: Komunita vytvorila 4 otázky. Ak bola otázka A  v komunite hodnotená 3 hviezdičkami, otázka B dostala 4 hviezdičky, otázka C  2 hviezdičky a otázka D  5 hviezdičiek, potom je priemer všetkých otázok 3,5.';
$string['reportquiz_stats_own_last_attempt_correct'] = 'Počet Vašich posledných správnych odpovedí';
$string['reportquiz_stats_own_last_attempt_incorrect'] = 'Počet Vašich posledných nesprávnych odpovedí';
$string['reportquiz_stats_own_percentage_correct_answers'] = 'Percentuálny podiel Vašich správnych odpovedí';
$string['reportquiz_stats_own_percentage_correct_answers_help'] = 'Percento všetkých Vašich správnych odpovedí z množiny všetkých vašich odpovedí v tomto StudentQuiz-e. Čiastočne správne odpovede sa považujú za nesprávne odpovede.';
$string['reportquiz_stats_own_progress'] = 'Osobný pokrok';
$string['reportquiz_stats_own_progress_help'] = 'Percento všetkých Vašich správnych odpovedí z množiny všetkých vašich odpovedí v tomto StudentQuiz-e. Čiastočne správne odpovede sa považujú za nesprávne odpovede.';
$string['reportquiz_stats_own_question_attempts_correct'] = 'Celkový počet Vašich správnych odpovedí';
$string['reportquiz_stats_own_question_attempts_incorrect'] = 'Celkový počet Vašich nesprávnych odpovedí';
$string['reportquiz_stats_own_questions_answered'] = 'Celkový počet vštkých Vašich odpovedí';
$string['reportquiz_stats_own_questions_answered_help'] = 'Počet všetkých Vašich odpovedí v rámci tohto StudentQuiz-u.';
$string['reportquiz_stats_own_questions_approved'] = 'Počet Vašich schválených otázok';
$string['reportquiz_stats_own_questions_approved_help'] = 'Učitelia môžu schvaľovať otázky na overenie ich správnosti. Toto je počet Vašich schválených otázok v tomto StudentQuiz-e.';
$string['reportquiz_stats_own_questions_created'] = 'Počet otázok, ktorými ste prispeli';
$string['reportquiz_stats_own_questions_created_help'] = 'Počet otázok, ktorými ste prispeli do tohoto StudentQuiz-u.';
$string['reportquiz_stats_own_rates_average'] = 'Váš získaný hodnotiaci priemer';
$string['reportquiz_stats_own_rates_average_help'] = 'Hodnotenie každej otázky je priemerom hviezdičiek, ktoré získala od komunity. Príklad: Komunita vytvorila 4 otázky. Ak bola otázka A  v komunite hodnotená 3 hviezdičkami, otázka B = 4 hviezdičky, otázka C = 2 hviezdičky a otázka D = 5 hviezdičiek, potom je priemer všetkých otázok 3,5.';
$string['reportquiz_stats_title'] = 'Štatistika';
$string['reportquiz_total_attempt'] = 'Celkový čas používateľa strávený v teste';
$string['reportquiz_total_obtained_marks'] = 'Celková známka';
$string['reportquiz_total_questions_answered'] = 'Celkový počet odpovedí';
$string['reportquiz_total_questions_right'] = 'Celkový počet správnych odpovedí';
$string['reportquiz_total_questions_wrong'] = 'Nesprávne odpovede';
$string['reportquiz_total_users'] = 'Počet účastníkov';
$string['reportrank_table_column_approvedquestions'] = 'Body za schválené otázky';
$string['reportrank_table_column_communitystatus'] = 'Štatistika komunity';
$string['reportrank_table_column_correctanswers'] = 'Správne odpovede';
$string['reportrank_table_column_countquestions'] = 'Body za otázky sú zverejnené';
$string['reportrank_table_column_description'] = 'Opis';
$string['reportrank_table_column_factor'] = 'Faktor';
$string['reportrank_table_column_fullname'] = 'Celé meno';
$string['reportrank_table_column_incorrectanswers'] = 'Nesprávne odpovede';
$string['reportrank_table_column_lastcorrectanswers'] = 'Body za posledné správne pokusy';
$string['reportrank_table_column_lastincorrectanswers'] = 'Body za posledné nesprávne pokusy';
$string['reportrank_table_column_points'] = 'Body';
$string['reportrank_table_column_progress'] = 'Osobný pokrok';
$string['reportrank_table_column_quantifier_name'] = 'Meno';
$string['reportrank_table_column_rank'] = 'Poradie';
$string['reportrank_table_column_summeanrates'] = 'Body za obržané hviezdičky';
$string['reportrank_table_column_total_points'] = 'Celkový počet bodov';
$string['reportrank_table_column_value'] = 'Hodnota';
$string['reportrank_table_column_yourstatus'] = 'Osobná štatistika';
$string['reportrank_table_quantifier_caption'] = 'Ako sú počítané Vaše body';
$string['reportrank_table_title'] = 'Poriadie študentov - najlepších 10';
$string['reportrank_table_title_for_manager'] = 'Poradie študentov';
$string['reportrank_title'] = 'Poradie';
$string['review_button'] = 'Zhodnotenie';
$string['savechanges'] = 'Uložiť zmeny';
$string['scheduled_task_send_digest_notification'] = 'Poslať súhrnné oznámenie';
$string['setting_question_publishing'] = 'Publikovanie otázok';
$string['setting_question_publishing_automatic'] = 'Automaticky zverejňovať nové otázky';
$string['setting_question_publishing_help'] = 'Publikované otázky sa objavia v skupine otázok, aby ich mohli prijať ostatní študenti. Povoľte, aby boli všetky otázky uverejňované automaticky, alebo si pred ich zverejnením musíte vyžiadať súhlas. <br> Upozorňujeme, že toto nastavenie nie je možné zmeniť po vytvorení otázky v StudentQuiz.';
$string['setting_question_publishing_require_approval'] = 'Pred zverejnením požadovať súhlas';
$string['settings_allowallqtypes'] = 'Povoiiť všetky typy otázok';
$string['settings_allowedqtypes'] = 'Povolené typy otázok';
$string['settings_allowedqtypes_help'] = 'Obmedzte povolené typy otázok na vybrané záznamy';
$string['settings_allowedrolestoshow'] = 'Vylúčte roly, ktoré môžu byť pri každej aktivite zmenené.';
$string['settings_allowedrolestoshow_help'] = 'Toto sa týka predchádzajúceho nastavenia. Nie všetky roly v systéme sú relevantné pre StudentQuiz, takže môžete použiť toto nastavenie na zníženie počtu rolí uvedených vo formulári nastavení aktivity. Roly, ktoré si tu zvolíte, sa objavia vo formulári pre každú ďalšiu aktivitu, takže učiteľ môže zmeniť nastavenia. Roly, ktoré tu nie sú vybraté, budú vylúčené z prehľadov v závislosti od toho, či sú vylúčené v predvolenom nastavení uvedenom vyššie.';
$string['settings_anonymous'] = 'Anonymizácia študentov';
$string['settings_anonymous_help'] = 'Študenti nemôžu vidieť mená ostatných.';
$string['settings_anonymous_label'] = 'Anonymizujte študentov';
$string['settings_approvedquantifier'] = 'Príspevok za schválenú otázku';
$string['settings_approvedquantifier_help'] = 'Body za každú schválenú otázku';
$string['settings_approvedquantifier_label'] = 'Body za každú schválenú otázku';
$string['settings_availability_close_answering_from'] = 'Uzatvorené pre prijímanie odpovedí od';
$string['settings_availability_close_submission_from'] = 'Zavreté pre odoslanie odpovedí od';
$string['settings_availability_open_answering_from'] = 'Otvorené pre odpovede od';
$string['settings_availability_open_submission_from'] = 'Otvorené pre odoslanie odpovedí od';
$string['settings_comment_editor_toolbar'] = 'Konfigurácia panela nástrojov editora komentárov';
$string['settings_comment_editor_toolbar_des'] = 'Zoznam doplnkov a poradie v ktorom sú zobrazené môže byť konfigurované tu';
$string['settings_commentdeletionperiod'] = 'Čas pre odstránenia komentára (minúty)';
$string['settings_commentdeletionperiod_help'] = 'Nastavte časové obdobie (v minútach), počas ktorého bude tlačidlo Odstrániť k dispozícii pre študentov, aby po uverejnení príspevku mohli odstrániť svoj vlastný komentár (alebo odpoveď na komentár). Povolené sú hodnoty medzi 0 a 60 minútami, pričom predvolená hodnota je 10. Ak je interval vymazania nastavený na 0, študenti nemôžu vymazať svoje vlastné komentáre. Upozorňujeme, že učitelia a správcovia budú vždy schopní odstrániť komentáre študentov a tiež zobraziť obsah všetkých odstránených komentárov.';
$string['settings_email_digest_first_day'] = 'Prvý deň v týždni?';
$string['settings_email_digest_first_day_help'] = 'Ak ste si zvolili týždenný prehľad, táto možnosť Vám umožňuje vybrať si prvý deň (začiatkom o 00h:00m:00s daného dňa) počas siedmych dní. Táto možnosť je obzvlášť užitočná, ak aktivita začína napríklad v strede týždňa.';
$string['settings_email_digest_type'] = 'Typ súhrnu e-mailu';
$string['settings_email_digest_type_daily_digest'] = 'Denný prehľad';
$string['settings_email_digest_type_help'] = 'StudentQuiz má rôzne upozornenia, ktoré môžete povoliť, ako napríklad informovanie študenta, autora otázok o zmene stavu (napr. učiteľ schválil jednu z jeho otázok). Toto nastavenie môžete použiť na určenie frekvencie týchto upozornení. Súhrnné e-maily sa budú odosielať iba vtedy, keď je v nastavenom období aspoň jedno upozornenie.';
$string['settings_email_digest_type_no_digest'] = 'Žiadny prehľad (samostatný email pre každú akciu)';
$string['settings_email_digest_type_weekly_digest'] = 'Týždenný prehľad';
$string['settings_excluderoles'] = 'Predvolené roly, ktoré sa majú vylúčiť z hodnotenia';
$string['settings_excluderoles_help'] = 'V každom StudentQuiz-e môže učiteľ vidieť, ktoré roly sú vylúčené z hodnotenia. Tu nastavený zoznam rolí je predvolený pre každý novovytvorený StudentQuiz';
$string['settings_excluderoles_label'] = 'Roly pre hodnotenie na vylúčenie';
$string['settings_forcecommenting'] = 'Vynútenie komentovania';
$string['settings_forcecommenting_help'] = 'Vynútiť komentovanie pri pokuse zodpovedať otázku';
$string['settings_forcerating'] = 'Vynútenie hodnotenia (ratingu))';
$string['settings_forcerating_help'] = 'Vynútenie hodnotenia zodpovedanej otázky';
$string['settings_lastcorrectanswerquantifier'] = 'Príspevok za poslednú správnu odpoveď';
$string['settings_lastcorrectanswerquantifier_help'] = 'Body za každú správnu odpoveď pri poslednom pokuse';
$string['settings_lastcorrectanswerquantifier_label'] = 'Body za posledné správne odpovede';
$string['settings_lastincorrectanswerquantifier'] = 'Príspevok za poslednú nesprávnu odpoveď';
$string['settings_lastincorrectanswerquantifier_help'] = 'Body za každú nesprávnu alebo čiastočne nesprávnu odpoveď pri poslednom pokuse';
$string['settings_lastincorrectanswerquantifier_label'] = 'Body za posledné nesprávne odpovede';
$string['settings_notification'] = 'Nastavenia oznámení';
$string['settings_privatecomment'] = 'Vysvetlenie súkromného komentára.';
$string['settings_privatecomment_help'] = 'Tu môžete upraviť vysvetľujúci text v závislosti od toho, ako vaša organizácia využíva diskusie medzi študentom a poradcom/učiteľom/administrátorom aktivity.';
$string['settings_privatecommenting'] = 'Povoliť súkromné komentovanie';
$string['settings_privatecommenting_help'] = 'Súkromné diskusné vlákno, ktoré je prístupné pri zobrazení ukážky otázky, kým nie je otázka schválená, umožňuje diskusiu medzi autorom otázky a správcom aktivity. Ak je režim StudentQuiz nastavený na „Automaticky publikovať nové otázky“, potom autor otázky nemusí vždy vidieť toto konkrétne vlákno. Zostáva však k dispozícii správcovi aktivity bez ohľadu na to, kto ho môže použiť na vysvetlenie, prečo skryl alebo odstránil otázku. Predvolené súkromné komentovanie je nastavené v nastaveniach doplnku na úrovni servera.';
$string['settings_questionquantifier'] = 'Zverejnený faktor otázky';
$string['settings_questionquantifier_help'] = 'Body za každú zverejnenú otázku';
$string['settings_questionquantifier_label'] = 'Body za každú zverejnenú otázku';
$string['settings_ratequantifier'] = 'Príspevok za hodnotenie';
$string['settings_ratequantifier_help'] = 'Body za každú získanú hviezdičku.';
$string['settings_ratequantifier_label'] = 'Multiplikátor pre priemer hviezdičiek získaných pre danú otázku';
$string['settings_removeqbehavior'] = 'Odstrániť zásuvný modul pre správanie otázok StudentQuiz';
$string['settings_removeqbehavior_help'] = 'Táto informácia by sa mala objaviť iba raz počas aktualizácie. Upozorňujeme vás, že sme zistili, že je nainštalovaný doplnok (plugin) pre správanie otázok StudentQuiz-u. Tento plugin sa už nevyžaduje a snažíme sa ho automaticky odstrániť. Ak sa stále zobrazuje toto nastavenie, prosím odinštalujte ten plugin pre správanie otázok ručne <a href="{$a}"> tu </a>.';
$string['settings_removeqbehavior_label'] = 'Odstráňte zásuvný modul pre správanie otázok StudentQuiz-u';
$string['settings_reportingemail'] = 'E-mail na nahlásenie urážlivých komentárov';
$string['settings_reportingemail_help'] = 'Ak je táto e-mailová adresa zadaná, zobrazí sa odkaz Nahlásiť
vedľa každého komentára. Používatelia môžu kliknutím na odkaz nahlásiť urážlivé komentáre. Informácie budú zaslané na túto adresu.

Ak tento e-mail zostane prázdny, funkcia Prehľad sa nebude zobrazovať (pokiaľ to nie je úroveň webu) adresa bola nahlásená).

Je možné pridať viac ako jednu e-mailovú adresu, pokiaľ sú oddelené bodkočiarkou.';
$string['settings_section_description_default'] = 'Tieto hodnoty definujú predvolené hodnoty pri vytváraní novej aktivity StudentQuiz.';
$string['settings_section_header_comment_rating'] = 'Nastavenia komentárov a hodnotenia';
$string['settings_section_header_commenting'] = 'Nastavenia komentárov';
$string['settings_section_header_question'] = 'Nastavenie otázok';
$string['settings_section_header_ranking'] = 'Nastavenia hodnotenia';
$string['settings_showprivatecomment'] = 'Povoliť súkromnú diskusiu v komentároch';
$string['settings_showprivatecomment_help'] = 'Táto možnosť umožňuje pokročilú diskusiu medzi študentom a tútorom (mená sa môžu líšiť v závislosti od organizácie) v náhľade otázky.';
$string['settingsdeleteorphaned'] = 'Vymazať osamotené otázky';
$string['settingsdeleteorphaned_help'] = 'Aktivuje naplánovanú úlohu, ktorá sa bude spúšťať každý deň, aby sa odstránili všetky osamotené/neschválené otázky z databázy.';
$string['settingsdeleteorphanedtime1y'] = 'Jeden rok';
$string['settingsdeleteorphanedtime2y'] = 'Dva roky';
$string['settingsdeleteorphanedtime3y'] = 'Tri roky';
$string['settingsdeleteorphanedtime6m'] = 'Šesť mesiacov';
$string['settingsdeleteorphanedtimelimit'] = 'Rozpätie pre čas vymazania osamotenej otázky';
$string['settingsdeleteorphanedtimelimit_help'] = 'Zvoľte časové rozpätie pre vymazanie osamotenej/nepovolenej otázky. Staršie otázky budú zmazané.';
$string['show_less'] = 'Ukázať menej';
$string['show_more'] = 'Ukázať viac';
$string['slot_of_slot'] = 'Otázka {$a-> slot} z {$a-> slots} v tejto sade';
$string['start_quiz_button'] = 'Začnite test';
$string['state_approved'] = 'Schválené';
$string['state_approvedlowercase'] = 'schválené';
$string['state_approvedplural'] = 'Schválené';
$string['state_change_tooltip_approved'] = 'Otázka je schválená. Kliknutím sem zmeníte stav tejto otázky';
$string['state_change_tooltip_changed'] = 'Otázka sa zmenila. Kliknutím sem zmeníte stav tejto otázky';
$string['state_change_tooltip_disapproved'] = 'Otázka bola zamietnutá. Kliknutím sem zmeníte stav tejto otázky';
$string['state_change_tooltip_new'] = 'Otázka je nová. Kliknutím sem zmeníte stav tejto otázky';
$string['state_change_tooltip_reviewable'] = 'Otázku je možné prezerať. Kliknite sem pre zmenu stavu otázky';
$string['state_changed'] = 'Zmenené';
$string['state_changedlowercase'] = 'Zmenené.';
$string['state_changedplural'] = 'Zmenené';
$string['state_column_name'] = 'Stav';
$string['state_column_name_veryshort'] = 'S';
$string['state_deleted'] = 'Zmazané';
$string['state_deletedlowercase'] = 'zmazané';
$string['state_deletedplural'] = 'Zmazané';
$string['state_disapproved'] = 'Neschválená';
$string['state_disapprovedlowercase'] = 'neschválené';
$string['state_disapprovedplural'] = 'Neschválené';
$string['state_hidden'] = 'Skryté';
$string['state_hiddenlowercase'] = 'skryté';
$string['state_hiddenplural'] = 'Skryté';
$string['state_new'] = 'Nová';
$string['state_newplural'] = 'Nové';
$string['state_pinned'] = 'Pripnuté';
$string['state_pinnedplural'] = 'Pripnuté';
$string['state_reviewable'] = 'Preskúmateľné';
$string['state_reviewablelowercase'] = 'preskúmateľné';
$string['state_reviewableplural'] = 'Preskúmateľné';
$string['state_shown'] = 'Ukázané';
$string['state_shownlowercase'] = 'Ukázané';
$string['state_shownplural'] = 'Ukázané';
$string['state_toggle'] = 'Zmena stavu';
$string['statehistory'] = 'Uviesť históriu';
$string['statistic_block_approvals'] = 'Schválené otázky';
$string['statistic_block_created'] = 'Vytvorené otázky';
$string['statistic_block_disapprovals'] = 'Otázky neschválené';
$string['statistic_block_new_changed'] = 'Nové/zmenené otázky';
$string['statistic_block_progress_available'] = 'Dostupné otázky';
$string['statistic_block_progress_last_attempt_correct'] = 'Posledný správny pokus';
$string['statistic_block_progress_last_attempt_incorrect'] = 'Posledný nesprávny pokus';
$string['statistic_block_progress_never'] = 'Nikdy nezodpovedané otázky';
$string['statistic_block_title'] = 'Môj pokrok';
$string['studentquiz'] = 'studentquiz';
$string['studentquiz:addinstance'] = 'Pridajte novú inštanciu pre StudentQuiz';
$string['studentquiz:cancommentprivately'] = 'Súkromne okomentujte ktorúkoľvek otázku';
$string['studentquiz:canselfcommentprivately'] = 'Súkromne komentujte vlastnú otázku';
$string['studentquiz:canselfratecomment'] = 'Hodnotiť a verejne komentovať vlastné otázky v ukážke';
$string['studentquiz:changestate'] = 'Nastavte stav otázky v StudentQuiz';
$string['studentquiz:emailnotifyapproved'] = 'Oznámenie o schválení otázky';
$string['studentquiz:emailnotifychanged'] = 'Upozornenie na zmenu otázky';
$string['studentquiz:emailnotifycommentadded'] = 'Notifikácia pridania komentára';
$string['studentquiz:emailnotifycommentdeleted'] = 'Notifikácia o odstránení komentára';
$string['studentquiz:emailnotifyquestion'] = 'Používateľ dostane upozornenie e-mailom o zmene stavu otázky';
$string['studentquiz:emailnotifyreviewablequestion'] = 'Používateľ dostane upozornenie emailom, ak študent zmení ich otázku na preskúmateľnú';
$string['studentquiz:manage'] = 'Upraviť a vymazať otázky v StudentQuiz';
$string['studentquiz:organize'] = 'Presuň otázky do kategórií v StudentQuiz';
$string['studentquiz:pinquestion'] = 'Pripni otázky v StudentQuiz';
$string['studentquiz:preview'] = 'Prehľad otázok';
$string['studentquiz:previewothers'] = 'Náhľad otázok ostatných v StudentQuiz-e';
$string['studentquiz:submit'] = 'Vytvorte otázky v StudentQuiz';
$string['studentquiz:systemnotifytaskdeleteorphanedquestions'] = 'Upozornenia o vymazaní osamotených otázok';
$string['studentquiz:unhideanonymous'] = 'Vidieť skutočné mená, aj keď je aktívna anonymizácia';
$string['studentquiz:view'] = 'Pozrite si a používajte otázky v StudentQuiz';
$string['studentquizname'] = 'Názov StudentQuiz-u';
$string['studentquizname_help'] = 'Názov tejto aktivity StudentQuiz-u';
$string['submissionendbeforestart'] = 'Termín pre odoslanie nemôže byť nastavený pred časom otvorenia na odoslanie';
$string['tags'] = 'Značky (tágy)';
$string['unapprove'] = 'Neschváliť';
$string['unpin'] = 'Zrušiť pripnutie otázky';
$string['visiblegroupnotyetsupport'] = '„Viditeľné skupiny" ešte nie sú podporované. Prosím, zvoľte iný skupinový režim.';
$string['weekly'] = 'Týždenne';
