<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_wp', language 'da', version '4.1'.
 *
 * @package     tool_wp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alldata'] = 'Alle data';
$string['certificates'] = 'Certifikater';
$string['certificatetemplates'] = 'Certifikatskabeloner';
$string['certificatetemplates_help'] = 'Medtag certifikatskabeloner, sider og elementer. Bemærk, at udstedte certifikater ikke er inkluderet';
$string['certificatetemplatesdetails'] = 'Certifikatskabelon-detaljer';
$string['change'] = 'Ændring';
$string['cleanupexpiredimportsexports'] = 'Ryd op i udløbne eksporter og importer';
$string['codechanged'] = 'Udstedelseskode blev ændret fra \'{$a->from}\' til \'{$a->to}\'';
$string['cohortdetails'] = 'Brugergruppedetaljer';
$string['cohortdetails_help'] = 'Brugergruppedetaljer for hver valgt instans';
$string['cohortdetailswithmembers'] = 'Brugergruppedetaljer inklusive medlemmer';
$string['cohortdetailswithmembers_help'] = 'Brugergruppedetaljer inklusive medlemskabsinformation. Bemærk, at brugere ikke er inkluderet';
$string['cohortmembers'] = 'Brugergruppemedlemmer';
$string['cohortmembers_help'] = 'Kun medlemskabsinformation for brugergruppen vil blive inkluderet, men de faktiske brugere vil ikke';
$string['confighideparentlang'] = 'Skjul Workplace-parentpakker';
$string['confighideparentlangdesc'] = 'Hvis aktiveret, vises den overordnede (parent) til enhver installeret Workplace-sprogpakke ikke i sprogmenuen. For eksempel vises \'Engelsk (en)\' ikke, hvis \'Engelsk til Workplace (en_wp)\' er installeret';
$string['confirmdeleteexport'] = 'Er du sikker på, at du vil slette denne eksport';
$string['confirmdeleteimport'] = 'Er du sikker på, at du vil slette denne import';
$string['confirmprevbutton'] = 'Forlad site? Ændringer, du har foretaget, bliver muligvis ikke gemt';
$string['confirmprocess'] = 'Ved at klikke på "Fortsæt" vil processen starte kort efter. Du modtager en notifikation, når den er afsluttet';
$string['conflictidnumber'] = 'Tilføj et numerisk suffiks til brugergruppe-id-nummeret';
$string['conflicts'] = 'Konflikter';
$string['conflictshortname'] = 'Tilføj et numerisk suffiks til kursuskortnavnet';
$string['content'] = 'Indhold';
$string['copiedtoclipboard'] = 'Tekst kopieret til udklipsholder';
$string['copytoclipboard'] = 'Kopier til udklipsholder';
$string['coursecontentbackup'] = 'Tillad kursusindholdsbackup';
$string['coursecontentbackupdesc'] = 'Denne indstilling styrer, om brugere, der kan tage backup af kurser, har tilladelse til at medtage kursusindhold som en del af en eksport. Hvis den ikke er aktiveret, kan kun brugere, der kan redigere sitekonfigurationen, eksportere kursusindhold som en del af en migrering. At holde denne indstilling deaktiveret vil hjælpe med at reducere størrelsen på den eksporterede fil';
$string['coursereset'] = 'Kursusnulstilling for individuel bruger';
$string['coursesadmintab'] = 'Læring';
$string['createdby'] = 'Oprettet af';
$string['csvcolumn'] = 'CSV-kolonne';
$string['csvdefaultvalue'] = 'Standardværdi';
$string['csvmappingnotspecified'] = 'Ikke angivet';
$string['deletegradeshistory'] = 'Slet karakterhistorik under kursusnulstilling';
$string['deletegradeshistory_desc'] = 'Det anbefales at slette karakterhistorikken under kursusnulstilling, især når indstillingen "Gendan karakterer som standard" er aktiveret. Hvis karakterhistorikken ikke slettes under kursusnulstilling, vil processen med at gendanne kursuskarakterer ved gentilmelding gendanne karaktererne, men al information om aktivitetsfuldførelse vil ikke længere være til stede';
$string['descriptionformat'] = 'Beskrivelsesformat';
$string['descriptionformatdefault'] = 'Standard beskrivelsesformat';
$string['doexport'] = 'Eksport';
$string['doimport'] = 'Import';
$string['doyouagreelicense'] = 'Har du læst disse vilkår og underskrevet den proprietære Moodle Workplace™-licens';
$string['entitiescountpostfix'] = '({$a})';
$string['entitycertificateissues'] = 'Certifikatudstedelser';
$string['entitycertificateissueuser'] = 'Certifikatudstedelse: {$a}';
$string['entitycoursereset'] = 'Data for kursusnulstilling';
$string['entityidentifier'] = '{$a->name} ({$a->idnumber})';
$string['errorcantdeleteexport'] = 'Kan ikke slette eksport';
$string['errorcantdeleteimport'] = 'Kan ikke slette import';
$string['errorcohortsameidnumber'] = 'Brugergrupper med samme id-nummer findes allerede';
$string['errorcouldnotallocatecohort'] = 'Kunne ikke tildele bruger \'{$a->originaluserfullname}\' til brugergruppe \'{$a->name}\'';
$string['errorcouldnotimportissue'] = 'Kunne ikke importere udstedt certifikat for \'{$a}\'';
$string['errorcoursesdonotexist'] = 'Nogle kurser findes ikke';
$string['errorcoursessameshortname'] = 'Kurser med samme kortnavn findes allerede';
$string['errorcustomfielddoesnotexist'] = 'Brugerdefineret felt findes ikke, kunne ikke importere data \'{$a}\'';
$string['errorcustomfieldnotfound'] = 'Brugerdefineret feltinstans blev ikke fundet';
$string['errorcustomfieldnotfounddetail'] = 'Brugerdefineret felt \'{$a}\' blev ikke fundet';
$string['errornegativenumber'] = 'Du skal indtaste et ikke-negativt tal her';
$string['eventcoursemodulereset'] = 'Kursusmodulnulstilling for individuel bruger';
$string['eventcoursereset'] = 'Kursusnulstilling for individuel bruger';
$string['eventexportcreated'] = 'Eksport oprettet';
$string['eventexportdeleted'] = 'Eksport slettet';
$string['eventexportupdated'] = 'Eksport opdateret';
$string['eventimportcreated'] = 'Import oprettet';
$string['eventimportdeleted'] = 'Import slettet';
$string['eventimportupdated'] = 'Import opdateret';
$string['export_content'] = 'Certifikatskabelon-detaljer';
$string['export_content_help'] = 'Certifikatskabeloner, sider og elementer';
$string['export_issued'] = 'Udstedte certifikater';
$string['export_issued_help'] = 'Certifikater udstedt til brugere. En kopi af selve brugerne vil ikke blive inkluderet';
$string['exportcoursecategoriescontent'] = 'Kursuskategoridetaljer';
$string['exportcoursecategoriescontent_help'] = 'Medtag kursuskategoridetaljer. Kategoriernes rolle-tildelinger og filtre vil ikke blive inkluderet';
$string['exportcoursecontent'] = 'Kursusstruktur';
$string['exportcoursecontent_help'] = 'Dette inkluderer alt i kurset undtagen dets indhold.

Den eksporterede fil vil indeholde de samme indstillinger som dem, der er angivet som standard på dette site, når der oprettes en standard kursusbackup. Ingen brugerdata vil blive inkluderet';
$string['exported'] = 'Eksporteret';
$string['exporter'] = 'Eksportør';
$string['exportercreatefrom'] = 'Opret eksport fra';
$string['exportercreatefrom_help'] = 'Denne indstilling giver dig mulighed for at definere, om du vil eksportere enheder fra hele sitet, eller kun dem der er knyttet til den nuværende Tentant';
$string['exportercreatefromcurrenttenant'] = 'Nuværende Tentant';
$string['exporterdesc'] = 'Udstedte certifikater og skabeloner';
$string['exporterdescription'] = 'Kurser uden brugerdata, bruger standardkonfigurationen for kursusbackup';
$string['exporterdescriptioncategories'] = 'Kurser uden brugerdata, der bruger standardkonfigurationen for kursusbackup';
$string['exporterdescriptioncohorts'] = 'Brugergrupper, inklusive brugergruppemedlemmer uden brugerdata';
$string['exporterdescriptionreports'] = 'Brugerdefinerede rapporter, inklusive målgruppe- og tidsplandata';
$string['exporternotavailable'] = 'Eksportør \'{$a}\' er ikke tilgængelig her';
$string['exporternotfound'] = 'Kunne ikke finde eksportør \'{$a}\'';
$string['exporterrequirestenant'] = 'Eksportør \'{$a}\' kræver en Tentant';
$string['exportersettingsinvalid'] = 'Eksportørindstillinger er ikke i gyldigt JSON-format';
$string['exportersettingsvalidationfailed'] = 'Validering af eksportørindstillinger mislykkedes: {$a}';
$string['exportersunavailable'] = 'Der er ingen tilgængelige eksportører, du kan bruge';
$string['exportgeneralsettings'] = 'Generelle indstillinger';
$string['exportgeneralsettingsdesc'] = 'Vælg hvilken eksportør du vil bruge. I næste trin vil du kunne indsnævre dit udvalg og angive, hvilke elementer du ønsker at eksportere';
$string['exportimport'] = 'Migrering';
$string['exportimportconflictsuffix'] = 'Tilføj et numerisk suffiks til \'{$a}\'-feltet';
$string['exportimportentityunavailable'] = '{$a} (Ikke tilgængelig)';
$string['exportimporterrorentityexists'] = 'En instans med den samme \'{$a}\' findes allerede';
$string['exportimportfieldchanged'] = 'Ændrede felt \'{$a->field}\' fra \'{$a->from}\' til \'{$a->to}\'';
$string['exportimportsettings'] = 'Migreringsindstillinger';
$string['exportimportsitecontent'] = 'Indhold: kurser, kategorier, programmer og certificeringer';
$string['exportimportsitedescription'] = 'Hele siteindholdet inklusive alle Tentant samt alle enheder indeholdt deri. Kursusbackups vil inkludere alt indhold og brugerdata undtagen logs';
$string['exportimportsiteerror'] = 'Kunne ikke importere site';
$string['exportimportsitesame'] = 'Kan ikke importere til det samme site, som eksporten stammer fra';
$string['exportimportsitesuccess'] = 'Importeret site';
$string['exportimportstatuscompleted'] = 'Success';
$string['exportimportstatuscreated'] = 'Ikke klar';
$string['exportimportstatuserror'] = 'Fejl';
$string['exportimportstatusinprogress'] = 'I gang';
$string['exportimportstatusscheduled'] = 'Planlagt';
$string['exportimportuserfieldserror'] = 'Kunne ikke importere brugerprofilfelt \'{$a}\'';
$string['exportimportusersall'] = 'Vælg alle brugere';
$string['exportimportusersdescription'] = 'Site- og Tentant-brugere';
$string['exportimportuserserror'] = 'Kunne ikke oprette bruger \'{$a}\'';
$string['exportimportuserslanguseselected'] = 'Brug valgt sprog';
$string['exportimportusersmanual'] = 'Vælg brugere manuelt...';
$string['exportimportusersmissinglangerror'] = 'Brugersprog mangler i systemet';
$string['exportimportusersmissinglangerrorlog'] = 'Brugersproget \'{$a->lang}\' mangler i systemet';
$string['exportimportusersmnetconflict'] = 'MNet-hostværdi er forskellig';
$string['exportimportusersmnetmatchlocal'] = 'Opdater værdien, så den matcher sitet';
$string['exportimportusersmnetuseexisting'] = 'Importer med eksisterende værdi';
$string['exportimportuserspicture'] = 'Brugerbilleder';
$string['exportimportusersprofile'] = 'Brugerprofiler';
$string['exportimportuserssuccess'] = 'Oprettede bruger \'{$a}\'';
$string['exportimportuserssuspended'] = 'Medtag suspenderede brugere';
$string['exportimportuserstenant'] = 'Vælg alle brugere fra \'{$a}\'';
$string['exportnotfound'] = 'Eksport blev ikke fundet';
$string['exportnotfoundornotready'] = 'Eksport blev ikke fundet eller er ikke klar til import';
$string['exportnotready'] = 'Eksport ikke klar til import';
$string['exportoptions'] = 'Indstillinger';
$string['exportoptionsdesc'] = 'Angiv hvilke elementer du ønsker at eksportere ved at vælge dem';
$string['exportreview'] = 'Gennemse';
$string['exportreviewdesc'] = 'Kontroller, om alt er korrekt, før du eksporterer filen';
$string['exports'] = 'Eksporter';
$string['exportselectallreports'] = 'Eksporter alle brugerdefinerede rapporter';
$string['exportselectlimitreports'] = 'Eksporter specifikke brugerdefinerede rapporter...';
$string['exportstatus'] = 'Status';
$string['filecontent'] = 'Fil-indhold';
$string['grade'] = 'Karakter';
$string['idnumberchanged'] = 'ID-nummer blev ændret fra \'{$a->from}\' til \'{$a->to}\'';
$string['import_content'] = 'Certifikatskabelon-detaljer';
$string['import_content_help'] = 'Certifikatskabeloner, sider og elementer';
$string['import_issued'] = 'Udstedte certifikater';
$string['import_issued_help'] = 'Udstedelser af dette certifikat til brugere';
$string['importallselectedcategory'] = 'Importer alt i den valgte kategori';
$string['importallsystemcontext'] = 'Importer alt i systemkontekst';
$string['importaudiencelogerror'] = 'Kunne ikke importere målgruppepost';
$string['importaudiencelogsuccess'] = 'Målgruppepost importeret';
$string['importchoosetenant'] = 'Vælg tenant';
$string['importconflictcreatecourse'] = 'Opret tomt kursus';
$string['importconflictcreatecourseincategory'] = 'Opret tomt kursus i kategorien \'{$a}\'';
$string['importconflictincategory'] = 'i kategori';
$string['importconflictinstances'] = 'Instanser ({$a}):';
$string['importconflicts'] = 'Konflikter';
$string['importconflictsdesc'] = 'Løs konflikterne, hvis nødvendigt';
$string['importconflictskip'] = 'Importér ikke';
$string['importcoursecontent'] = 'Kursusbackups uden brugerdata';
$string['importcoursecontent_help'] = 'Importer kursusbackups for hver valgt instans';
$string['importdestination'] = 'Destination';
$string['imported'] = 'Importeret';
$string['importeitherexportidorfile'] = 'Enten skal exportid eller fil angives, men ikke begge';
$string['importer'] = 'Importør';
$string['importernotfound'] = 'Importør {$a} blev enten ikke fundet eller er ikke tilgængelig';
$string['importerrequired'] = 'Mere end én importør er tilgængelig, importør skal angives';
$string['importerrequirestenant'] = 'Importør \'{$a}\' kræver en Tentant';
$string['importersettingsinvalid'] = 'Importørindstillinger er ikke i gyldig JSON-format';
$string['importersettingsvalidationfailed'] = 'Validering af importørindstillinger mislykkedes: {$a}';
$string['importformat'] = 'Filformat';
$string['importformatauto'] = 'Registrer automatisk';
$string['importformatcsv'] = 'CSV';
$string['importformatworkplace'] = 'Workplace-format';
$string['importfromfile'] = 'Ny import fra denne fil';
$string['importgeneralsettings'] = 'Generelle indstillinger';
$string['importgeneralsettingsalt'] = 'Vælg destinationen for de importerede data. Du vil kunne angive, hvilke elementer du ønsker at importere i næste trin';
$string['importhasconflits'] = 'Import har konflikter: {$a}';
$string['importincrementidnumber'] = 'Tilføj et numerisk suffiks til ID-nummeret';
$string['importintothecurrenttenant'] = 'Importer til den nuværende Tentant';
$string['importlogerror'] = 'Kunne ikke importere certifikatskabelon \'{$a->name}\'';
$string['importlogerrorinvalidaudience'] = 'Manglende eller ugyldig målgruppe';
$string['importlogerrorinvalidreportsource'] = 'Manglende eller ugyldig rapportkilde';
$string['importlogerrorinvalidreporttype'] = 'Ugyldig rapporttype';
$string['importlogerrorinvalidscheduleformat'] = 'Manglende eller ugyldigt tidsplansformat';
$string['importlogexception'] = 'Undtagelse: {$a}';
$string['importlogfailed'] = 'Kunne ikke importere kursus \'{$a->fullname}\'';
$string['importlogfailedcohort'] = 'Kunne ikke importere brugergruppe \'{$a->name}\'';
$string['importlogfailedcoursecategory'] = 'Kunne ikke importere kursuskategori \'{$a->name}\'';
$string['importlogsuccess'] = 'Oprettede nyt kursus \'<a href="{$a->url}">{$a->fullname}</a>\'';
$string['importlogsuccesscertificates'] = 'Oprettede nyt kursus \'<a href="{$a->url}">{$a->fullname}</a>\'';
$string['importlogsuccesscohort'] = 'Oprettede ny brugergruppe \'<a href="{$a->url}">{$a->name}</a>\'';
$string['importlogsuccesscohortallocations'] = 'Tildelte bruger \'{$a->userfullname}\' til brugergruppe \'{$a->name}\'';
$string['importlogsuccesscoursecategory'] = 'Oprettede ny kursuskategori \'<a href="{$a->url}">{$a->name}</a>\'';
$string['importlogsuccessissue'] = 'Oprettede ny certifikatudstedelse på \'{$a->template}\' til bruger: \'{$a->originaluserfullname}\'';
$string['importnotenant'] = 'Tilgængelig for alle Tentant';
$string['importnotfound'] = 'Import blev ikke fundet';
$string['importoptions'] = 'Indstillinger';
$string['importoptionsdesc'] = 'Angiv hvilke elementer du ønsker at importere ved at vælge dem';
$string['importproblem'] = 'Problem: {$a}';
$string['importproblemaffects'] = 'Det påvirker:';
$string['importreportlogerror'] = 'Kunne ikke importere rapport \'{$a}\'';
$string['importreportlogsuccess'] = 'Oprettede ny rapport \'<a href="{$a->url}">{$a->name}</a>\' med {$a->columncount} kolonner, {$a->conditioncount} betingelser og {$a->filtercount} filtre';
$string['importreview'] = 'Gennemse';
$string['importreviewdesc'] = 'Kontroller, om alt er korrekt, før du importerer filen';
$string['imports'] = 'Importer';
$string['importschedulelogerror'] = 'Kunne ikke importere tidsplanpost';
$string['importschedulelogsuccess'] = 'Tidsplanpost importeret';
$string['importselectallreports'] = 'Importer alle brugerdefinerede rapporter';
$string['importselectlimitreports'] = 'Importer specifikke brugerdefinerede rapporter...';
$string['importselectsource'] = 'Vælg kilde';
$string['importselectsourcedesc'] = 'Upload en gyldig CSV- eller Moodle Workplace-fil. I de næste trin vil du kunne definere, hvilke elementer du ønsker at importere fra filen';
$string['importselecttenant'] = 'Vælg Tentant...';
$string['importsetidnumbertoempty'] = 'Sæt ID-nummer til tom streng';
$string['importsolution'] = 'Løsning:';
$string['importstatus'] = 'Status';
$string['importunknownerror'] = 'Ukendt fejl {$a}';
$string['importunknownformat'] = 'Kan ikke registrere filformatet ud fra filendelsen, vælg venligst format';
$string['includecoursecontent'] = 'Medtag kursusindhold';
$string['includecoursecontent_help'] = 'Medtag alt kursusindhold såsom aktiviteter, filtre, kalenderbegivenheder osv.

Den eksporterede fil vil indeholde de samme indstillinger som dem, der er angivet som standard på dette site, når der oprettes en standard kursusbackup. Ingen brugerdata vil blive inkluderet';
$string['instances'] = 'Instanser';
$string['instancescount'] = 'Instanser ({$a}):';
$string['invaliddevice'] = 'Du forsøger at tilgå et Moodle Workplace-site ved hjælp af Moodle-appen. Download venligst Moodle Workplace-appen for at fortsætte';
$string['loading'] = 'Indlæser...';
$string['log'] = 'Log';
$string['managecoursecategories'] = 'Administrer kursuskategorier';
$string['mappingerrorbadgeheader'] = 'Nogle badges findes ikke';
$string['mappingerrorbadgelog'] = 'Badge {$a} blev ikke fundet';
$string['mappingerrorcertificateheader'] = 'Nogle certifikatskabeloner findes ikke';
$string['mappingerrorcertificatelog'] = 'Certifikat {$a} blev ikke fundet';
$string['mappingerrorcohortheader'] = 'Nogle brugergrupper findes ikke';
$string['mappingerrorcohortlog'] = 'Brugergruppe {$a} blev ikke fundet';
$string['mappingerrorcompetencyheader'] = 'Nogle kompetencer findes ikke';
$string['mappingerrorcompetencylog'] = 'Kompetence {$a} blev ikke fundet';
$string['mappingerrorcontextnotfound'] = 'Kontekst blev ikke fundet';
$string['mappingerrorcoursenotfound'] = 'Kursus {$a} blev ikke fundet';
$string['mappingerrorlpheader'] = 'Nogle læringsplansskabeloner findes ikke';
$string['mappingerrorlplog'] = 'Læringsplansskabelon {$a} blev ikke fundet';
$string['mappingerroruserfieldheader'] = 'Nogle brugerprofilfelter findes ikke';
$string['mappingerroruserfieldlog'] = 'Brugerprofilfelt {$a} blev ikke fundet';
$string['mappingerrorusernotfound'] = 'Kunne ikke finde bruger {$a} i nuværende Tentant';
$string['mappingnoticecoursecreated'] = 'Tomt kursus <a href="{$a->courseurl}">{$a->fullname}</a> blev oprettet';
$string['mappingnoticecourseidnumber'] = 'Et kursus med kortnavnet \'{$a->shortname}\' blev ikke fundet. <a href="{$a->courseurl}">Et andet kursus</a> med id-nummer \'{$a->idnumber}\' blev fundet, men dette kursus har et andet kortnavn';
$string['mappingnoticeuseremail'] = 'En bruger med brugernavnet \'{$a->username}\' blev ikke fundet. <a href="{$a->profileurl}">En anden bruger</a> med e-mailen {$a->email} blev fundet, men denne bruger har et andet brugernavn';
$string['messagefullexportcomplete'] = 'Din eksport blev fuldført den {$a->date}

Status: {$a->status}

Klik <a href="{$a->url}">her</a> for at se detaljerne';
$string['messagefullimportcomplete'] = 'Din import blev fuldført den {$a->date}

Status: {$a->status}

Klik <a href="{$a->url}">her</a> for at se detaljerne';
$string['messageprovider:exportcomplete'] = 'Eksport fuldført';
$string['messageprovider:importcomplete'] = 'Import fuldført';
$string['migrationcannotswitchtenant'] = 'Tentant med id eller id-nummer {$a} blev ikke fundet, eller du har ikke tilladelse til at skifte til den';
$string['migrationnotenanterror'] = 'Indstillingerne Tentant og ingen Tentant kan ikke bruges sammen';
$string['migrationreportaudiences'] = 'Målgrupper';
$string['migrationreportdefinition'] = 'Rapportdefinition';
$string['migrationreportdefinition_help'] = 'Medtag rapportkolonner, betingelser og filtre';
$string['migrationreportschedules'] = 'Tidsplaner';
$string['migrationschoosefrom'] = 'Vælg fra';
$string['noavailableimporter'] = 'Vi kunne ikke finde en tilgængelig importør til denne fil';
$string['noavailableimporters'] = 'Ingen tilgængelige importører';
$string['nocategoriesavailable'] = 'Der er ingen tilgængelige kategorier';
$string['noconflictsfound'] = 'Ingen konflikter blev fundet';
$string['nodetails'] = 'Ingen detaljer fundet';
$string['nonproductionsite'] = 'Ikke-produktionssite';
$string['nonproductionsitemessage'] = 'Dette site er ikke til undervisningsbrug';
$string['nopermissioncategoryimport'] = 'Du har ikke tilladelse til at importere i denne kategori';
$string['nopermissioncategoryrestore'] = 'Du har ikke tilladelse til at gendanne i denne kategori';
$string['nopermissionform'] = 'Du har ikke tilladelse til at tilgå denne formular';
$string['nopermissiontab'] = 'Du har ikke tilladelse til at tilgå denne side';
$string['nothing'] = 'Ingenting';
$string['nothingtoexport'] = 'Intet at eksportere';
$string['nothingtoimport'] = 'Intet at importere';
$string['notpossible'] = 'Ikke muligt';
$string['numhour'] = '{$a} time';
$string['outcomes'] = 'Resultater';
$string['performanceinfo'] = 'Fanebladsydelsesinformation (DB-læsninger/skrivninger: {$a->reads}/{$a->writes})';
$string['pluginname'] = 'Workplace';
$string['privacy:metadata:certificationid'] = 'Certificerings-id\'et, hvor dette kursus kommer fra';
$string['privacy:metadata:courseid'] = 'Kurset, der blev nulstillet';
$string['privacy:metadata:exportcreatedby'] = 'ID\'et på brugeren, der udførte eksporten';
$string['privacy:metadata:exportstatus'] = 'Status for eksporten';
$string['privacy:metadata:grade'] = 'Karakteren brugeren havde på kurset, før det blev nulstillet';
$string['privacy:metadata:importcreatedby'] = 'ID\'et på brugeren, der udførte importen';
$string['privacy:metadata:importstatus'] = 'Status for importen';
$string['privacy:metadata:programid'] = 'Program-id\'et, hvor dette kursus kommer fra';
$string['privacy:metadata:reason'] = 'Årsagen til, at dette kursus blev nulstillet';
$string['privacy:metadata:resetinfo'] = 'Information om, hvad der er blevet nulstillet i kurset';
$string['privacy:metadata:resetstatus'] = 'Status for nulstillingen';
$string['privacy:metadata:tenantid'] = 'ID\'et på den relaterede Tentant';
$string['privacy:metadata:timecreated'] = 'Oprettelsestidspunktet';
$string['privacy:metadata:timemodified'] = 'Ændringstidspunktet';
$string['privacy:metadata:timerequested'] = 'Tidspunkt hvor nulstilling blev anmodet';
$string['privacy:metadata:tool_wp_course_reset'] = 'Kursus nulstillet';
$string['privacy:metadata:tool_wp_export'] = 'Information om eksporter udført på sitet';
$string['privacy:metadata:tool_wp_import'] = 'Information om importer udført på sitet';
$string['privacy:metadata:userid'] = 'Brugeren, der fik kurset nulstillet';
$string['privacy:metadata:usermodified'] = 'Brugeren blev ændret';
$string['privacy:metadata:userrequested'] = 'Bruger, der anmodede om kursusnulstilling';
$string['privacy:metadata:wascompleted'] = 'Om kurset var gennemført af brugeren før nulstilling';
$string['problem'] = 'Problem';
$string['proceed'] = 'Fortsæt';
$string['processing'] = 'Behandler';
$string['productionsite'] = 'Produktionssite';
$string['productionstate'] = 'Produktionsstatus';
$string['productionstatedesc'] = 'Ikke-produktionssites vil vise en ansvarsfraskrivelse i nederste højre hjørne af skærmen';
$string['quotedentity'] = '\'{$a}\'';
$string['reason'] = 'Årsag til nulstilling';
$string['recovercoursegrades'] = 'Når du aktiverer denne indstilling, skal du sikre dig også at aktivere indstillingen \'Slet karakterhistorik under kursusnulstilling\'';
$string['refresh'] = 'Opdater';
$string['reg_moodleproduct'] = 'Moodle-produkt ({$a})';
$string['reg_wpcertificates'] = 'Antal certifikater ({$a})';
$string['reg_wpcertificatesissues'] = 'Antal udstedte certifikater ({$a})';
$string['reg_wpplugins'] = 'Liste over installerede og aktiverede plugins, antal instanser ({$a})';
$string['reg_wpproductionstate'] = 'Produktionsstatus ({$a})';
$string['resetinfo'] = 'Nulstil information';
$string['resetstatus'] = 'Nulstil status';
$string['safenavigation'] = 'Det er sikkert at fortsætte med at navigere på sitet';
$string['selectallcategoriesinthisfile'] = 'Vælg alle kursuskategorier i denne fil';
$string['selectallcohortsinthisfile'] = 'Vælg alle brugergrupper i denne fil';
$string['selectallcoursesinthisfile'] = 'Vælg alle kurser i denne fil';
$string['selectalltemplates'] = 'Vælg alle certifikatskabeloner';
$string['selectalltemplatesinfile'] = 'Vælg alle certifikatskabeloner i denne fil';
$string['selectatleastonecategory'] = 'Vælg mindst én kategori';
$string['selectatleastonecohort'] = 'Vælg mindst én brugergruppe';
$string['selectatleastonecourse'] = 'Vælg mindst ét kursus';
$string['selectatleastonetemplate'] = 'Vælg mindst én skabelon';
$string['selectcoursecategory'] = 'Vælg kursuskategori';
$string['selectcoursesmanually'] = 'Vælg kurser manuelt...';
$string['selectedcoursecategory'] = 'Valgt kursuskategori: {$a}';
$string['selectexporter'] = 'Vælg eksportør';
$string['selectimporter'] = 'Vælg importør';
$string['selectmanually'] = 'Vælg manuelt...';
$string['selectmanuallycategories'] = 'Vælg kategorier og underkategorier manuelt';
$string['selectmanuallycertificates'] = 'Vælg certifikatskabeloner manuelt';
$string['shortnamechanged'] = 'Kortnavn ændret fra \'{$a->from}\' til \'{$a->to}\'';
$string['showless'] = 'Vis mindre';
$string['showxmore'] = 'Vis {$a} mere...';
$string['solution'] = 'Løsning';
$string['stepx'] = 'Trin {$a}';
$string['tenant'] = 'Tentant';
$string['thissite'] = '(Dette site)';
$string['timerequested'] = 'Tidspunkt anmodet';
$string['timereseted'] = 'Tidspunkt nulstillet';
$string['uploadimportfile'] = 'Upload en fil';
$string['userrequested'] = 'Bruger der anmodede';
$string['viewexport'] = 'Vis eksport';
$string['viewimport'] = 'Vis import';
$string['viewlicense'] = 'Vis licens';
$string['wascompleted'] = 'Blev fuldført';
$string['willbeimported'] = 'Vil blive importeret';
$string['workplacelicenseheader'] = 'Moodle Workplace-licens';
$string['workplacelicensenotagreed'] = 'Du kan ikke se dette indhold, før site-administratoren accepterer Moodle Workplace-licensen';
$string['wp:manageexportimport'] = 'Administrer Workplace-eksport/import';
$string['wp:useexportimport'] = 'Brug Workplace-eksport/import';
