<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_mobile', language 'da', version '4.1'.
 *
 * @package     tool_mobile
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['adodbdebugwarning'] = 'ADOdb debugging er aktiveret. Det bør være deaktiveret i den eksterne databasegodkendelse eller i indstillingerne til dens plugin til tilmeldinger.';
$string['androidappid'] = 'Android-app\'s identifikator';
$string['androidappid_desc'] = 'Standardindstillingen kan bruges med mindre du bruger en skræddersyet Android-app.';
$string['apppolicy'] = 'URL til app-politik';
$string['apppolicy_help'] = 'URL på politikken for app-brugere som vises på siden Om appen. Er feltet tomt, bruges URL\'en til webstedets politik i stedet.';
$string['apprequired'] = 'Denne funktionalitet er kun tilgængelig, når der opnås adgang til den via Moodle-mobil- eller computerappen.';
$string['autologinkeygenerationlockout'] = 'Nøglegenering til auto-login er blokeret. Du kan prøve igen om {$a} minutter.';
$string['autologinmintimebetweenreq'] = 'Minimumstid mellem automatiske logins';
$string['autologinmintimebetweenreq_desc'] = 'Minimumstiden mellem anmodninger om automatisk login fra mobilappen. Hvis app-brugere ofte bliver bedt om at indtaste deres legitimationsoplysninger, når de ser indhold der er indlejret fra webstedet, skal du vælge en lavere værdi.';
$string['autologinnotallowedtoadmins'] = 'Auto-login kan ikke bruges af administratorer.';
$string['cachedef_plugininfo'] = 'Dette gemmer listen over plugins med mobile addons';
$string['cachedef_subscriptiondata'] = 'Sette gemmer information om Moodle app-abonnement';
$string['clickheretolaunchtheapp'] = 'Klik her hvis ikke appen åbner automatisk';
$string['configmobilecssurl'] = 'En CSS-fil til tilpasning af din mobilapps interface.';
$string['customlangstrings'] = 'Tilpassede sprogstrenge';
$string['customlangstrings_desc'] = 'Ord og fraser vist i appen kan tilpasses her. Indtast hver sprogstreng på en ny linje i formatet: strengnavn, tilpassetsprogstreng og sprogdode, adskilt af "|"-tegn. For eksempel: <pre>mm.user.student|Learner|en
mm.user.student|Kursist|da </pre>';
$string['custommenuitems'] = 'Brugerdefinerede menupunkter';
$string['custommenuitems_desc'] = 'Her kan tilføjes ekstra punkter til appens hovedmenu. Indtast hvert menupunkt på en ny linje i formatet: menupunkt, link-URL, åbnemetode og sprogkode (valgfri, kun til visning af punktet til brugere i et specificeret sprog), adskilt af "|"-tegn.

Metoder til åbning af links er: app (til at åbne et link til en aktivitet der understøttes af appen), inappbrowser (til at åbne et link i en browser uden at forlade appen), browser (til at åbne linket i enhedens standardbrowser udenfor appen) og embedded (til visning af linket i en iframe på en ny side i appen).

Hvis der mangler oversættelse til et menupunkt i et givent sprog, vil en andet sprog anvendes i stedet - med mindre "_only" er tilføjet sprogkoden.

Eksempel:
<pre>
App-hjælp|https://domæne.tld/help|inappbrowser|da
OSS|https://domæne.tld/oss|browser|da
Mine karakterer|https://domæne.tld/local/mygrades/index.php|embedded|da
You will only see this in English|https://domæne.tld/english|browser|en_only
</pre>';
$string['darkmode'] = 'Mørk tilstand';
$string['disabledfeatures'] = 'Deaktiverede funktioner';
$string['disabledfeatures_desc'] = 'Vælg dem her hvis du vil deaktivere funktioner i mobilappen. Bemærk at nogle funktioner allerede kan være deaktiveret på sitet. Du vil skulle logge ud og ind igen i appen for at se ændringerne.';
$string['displayerrorswarning'] = 'Vis debug-beskeder (debugdisplay) er aktiveret. Det bør være deaktiveret.';
$string['downloadcourse'] = 'Download kursus';
$string['downloadcourses'] = 'Download kurser';
$string['enablesmartappbanners'] = 'Aktiver app-bannere';
$string['enablesmartappbanners_desc'] = 'Et banner der reklamerer for mobilappen kan vises når siden ses i en mobil-browser.';
$string['filetypeexclusionlist'] = 'Liste over udeladelser af filtyper';
$string['filetypeexclusionlist_desc'] = 'Vælg alle filtyper, der ikke er til brug på en mobil enhed. Sådanne filer vil blive oplistet på kurset, så hvis en bruger forsøger at åbne dem, vil en advarsel blive vist om at filtypen ikke er beregnet til brug på en mobil enhed. Brugeren kan derefter annullere eller ignorere advarslen og åbne filen alligevel.';
$string['filetypeexclusionlistplaceholder'] = 'Mobil-liste over udeladelser af filtyper';
$string['forcedurlscheme'] = 'Hvis din egen skræddersyede app må åbnes via en browser, kan du indtaste URL\'en her. Indtast standardindstillingen hvis du bruger den officielle app. Lad ellers feltet stå tomt.';
$string['forcedurlscheme_key'] = 'URL-scheme.';
$string['forcelogout'] = 'Gennemtving log af';
$string['forcelogout_desc'] = 'Er indstillingen aktiveret, vil brugerne altid blive logget helt ud, selv når de skifter konto. De skal så indtaste deres adgangskode igen, næste gang de ønsker at få adgang til webstedet.';
$string['getmoodleonyourmobile'] = 'Hent mobilappen';
$string['h5poffline'] = 'Vis H5P-indhold offline';
$string['httpsrequired'] = 'HTTPS er påkrævet';
$string['insecurealgorithmwarning'] = 'Det ser ud til at HTTPS-certifikatet bruger en usikker algoritme til signering (SHA-1). Prøv at opdatere certifikatet.';
$string['invalidcertificatechainwarning'] = 'Det ser ud til, at certifikatkæden er ugyldig. Dette certifikat kan måske fungere for en browser, men ikke for en mobilapp.';
$string['invalidcertificateexpiredatewarning'] = 'Det ser ud til at dette domænes HTTPS-certifikat er udløbet.';
$string['invalidcertificatestartdatewarning'] = 'Det ser ud til at dette domænes HTTPS-certifikat endnu ikke er gyldigt (startdag i fremtidem).';
$string['invalidprivatetoken'] = 'Ugyldig privat token. Token må ikke være tom eller overføres via GET-parameteren.';
$string['invaliduserquotawarning'] = 'Brugerkvoten (userquota) er sat til et ugyldigt tal. Det skal være et gyldigt heltal under "Sikkerhedsindstillinger".';
$string['iosappid'] = 'iOS-app\'s identifikator';
$string['iosappid_desc'] = 'Standardindstillingen kan bruges med mindre du bruger en skræddersyet iOS-app.';
$string['launchviasiteinbrowser'] = 'Start via site i systembrowseren.';
$string['loginintheapp'] = 'Via appen';
$string['logininthebrowser'] = 'Via et browservindue (til SSO-plugins)';
$string['loginintheembeddedbrowser'] = 'Via en indlejret browser (til SSO-plugins)';
$string['logoutconfirmation'] = 'Er du sikker på, at du vil logge ud af mobilappen på dine mobile enheder? Logger du ud, vil du senere skulle genindtaste dit brugernavn og din adgangskode i mobilappen på alle enheder, hvor du har appen installeret.';
$string['mainmenu'] = 'Hovedmenu';
$string['managefiletypes'] = 'Administrer filtyper';
$string['minimumversion'] = 'Hvis en app-version er angivet (3.8.0 eller højere), vil brugere der bruger en ældre app, blive bedt om at opgradere inden de får adgang til webstedet.';
$string['minimumversion_key'] = 'Minimum krævet app-version';
$string['mobileapp'] = 'Mobilapp';
$string['mobileappconnected'] = 'Mobilappen forbundet';
$string['mobileappearance'] = 'Mobil udseende';
$string['mobileappenabled'] = 'Der er adgang til dette websted med Moodles mobilapp<br /><a href="{$a}">Download appen her</a>.';
$string['mobileappsubscription'] = 'Moodle app-abonnement';
$string['mobileauthentication'] = 'Mobil godkendelse';
$string['mobilecssurl'] = 'CSS';
$string['mobilefeatures'] = 'Mobil-funktioner';
$string['mobilenotificationsdisabledwarning'] = 'Mobile underretninger er ikke aktiveret. De skal aktiveres under "Indstillinger for notifikationer"';
$string['mobilesettings'] = 'Mobil-indstillinger';
$string['moodleappsportalfeatureswarning'] = 'Bemærk at nogle funktioner kan være begrænsede på dit Moodle app-abonnement. Se mere på siden <a href="{$a}" target="_blank">Moodle Apps Portal</a>.';
$string['notifications'] = 'Underretninger';
$string['notificationsactivedevices'] = 'Aktive enheder';
$string['notificationscurrentactivedevices'] = 'Enheder der får underretninger denne måned';
$string['notificationsignorednotifications'] = 'Underretninger ikke sendt';
$string['notificationslimitreached'] = 'Grænsen for aktive brugerenheder pr. måned er overskredet. Nogle brugere vil ikke få tilsendt underretninger. Du anbefales at opgradere din app-plan på sidene <a href="{$a}" target="_blank">Moodle Apps Portal</a>.';
$string['notificationsmissingwarning'] = 'Statistik for Moodle app-underretninger blev ikke modtaget. Det er nok fordi app-underretninger endnu ikke er aktiveret. Du kan aktivere dem under Siteadministration / Beskedsystem / Mobil';
$string['notificationsnewdevices'] = 'Nye enheder';
$string['notificationsseemore'] = 'Bemærk: Moodle app-brugsstatistikker er ikke beregnet i realtid. Hvis du vil have adgang til mere detaljerede statistikker, herunder data fra tidligere måneder, skal du logge på <a href="{$a}" target="_blank">Moodle Apps Portal</a>';
$string['notificationssentnotifications'] = 'Underretninger sendt';
$string['oauth2identityproviders'] = 'OAuth 2 identitetsudbydere';
$string['offlineuse'] = 'Offline brug';
$string['openusingembeddedbrowser'] = 'Åbn ved hjælp af integreret browser';
$string['pluginname'] = 'Moodles Mobil-værktøjer';
$string['pluginnotenabledorconfigured'] = 'Plugin ikke aktiveret eller konfigureret.';
$string['privacy:metadata:core_userkey'] = 'Brugerens nøgler, der bruges til at oprette auto-login-nøgle for den aktuelle bruger.';
$string['privacy:metadata:preference:tool_mobile_autologin_request_last'] = 'Datoen for den sidste auto-login-nøgleanmodning. Der kræves 6 minutter mellem hver anmodning.';
$string['qrcodedisabled'] = 'Adgang via QR-kode deaktiveret';
$string['qrcodeformobileappaccess'] = 'QR-kode til mobilapp-adgang';
$string['qrcodeformobileapploginabout'] = 'Scan QR-koden med din mobilapp og du vil automatisk blive logget ind. QR-koden udløber efter {$a}.';
$string['qrcodeformobileappurlabout'] = 'Udfyld URL\'en ved at scanne QR-koden med din mobilapp.';
$string['qrcodetype'] = 'QR-kode-adgang';
$string['qrcodetype_desc'] = 'Brugere af mobil-appen kan få vist en QR-kode til at scanne så de automatisk kan få udfyldt sidens URL eller blive logget ind, uden selv at skulle indtaste deres loginoplysninger.';
$string['qrcodetypelogin'] = 'QR-kode med automatisk login';
$string['qrcodetypeurl'] = 'QR-kode med site-URL';
$string['qrkeyttl'] = 'Varighed af QR-autentifikationsnøglen';
$string['qrkeyttl_desc'] = 'Det tidsrum, en QR-kode til automatisk login er gyldig i.';
$string['qrsameipcheck'] = 'QR-godkendelse samme IP-kontrol.';
$string['qrsameipcheck_desc'] = 'Om brugere skal bruge det samme netværk både til at generere og scanne en QR-kode for login. Deaktiver det kun, hvis brugere rapporterer problemer med QR-login.';
$string['qrsiteadminsnotallowed'] = 'Af sikkerhedsmæssige årsager tillades login via QR-kode ikke for administratorer eller hvis du er logget ind som en anden bruger.';
$string['readingthisemailgettheapp'] = 'Læser du dette i en mail? <a href="{$a}">Download mobil-appen og få beskeder i din mobile enhed</a>';
$string['remoteaddons'] = 'Eksterne add-ons';
$string['responsivemainmenuitems'] = 'Responsive menupunkter';
$string['scanqrcode'] = 'Scan QR-kode';
$string['selfsignedoruntrustedcertificatewarning'] = 'Det ser ud til at dette domænes HTTPS-certifikat er selvsigneret eller ikke betroet. Mobilappen vil kun fungere med betroede websteder. Brug en online SSL-checker til at diagnosticere problemet. Hvis den viser, at dit certifikat er i orden, kan du ignorere denne advarsel.';
$string['setuplink'] = 'Appens download-side';
$string['setuplink_desc'] = 'URL til siden med mulighed for download af mobilappen fra App Store og Google Play. Linket vises i sidefoden og på en brugers profilside. Lad feltet stå tomt hvis ikke der skal vises et link.';
$string['smartappbanners'] = 'App-bannere';
$string['subscription'] = 'Abonnement';
$string['subscriptioncreated'] = 'Startdato';
$string['subscriptionerrorrequest'] = 'Der opstod en uventet fejl under forsøg på at hente dine Moodle-apps abonnementsoplysninger.';
$string['subscriptionexpiration'] = 'Udløbsdato';
$string['subscriptionfeaturenotapplied'] = 'Denne funktion er konfigureret på dit website, men den er ikke inkluderet i din Moodle-appplan. Således vil indstillingen ikke have nogen effekt.';
$string['subscriptionfeatures'] = 'Abonnementsfunktioner';
$string['subscriptionlimitsurpassed'] = 'Abonnementsgrænsen er overskredet';
$string['subscriptionregister'] = 'Du kan finde flere oplysninger om de forskellige appplaner og få adgang til statistik for brug af Moodle-apps på <a href="{$a}" target="_blank""Moodle Apps Portal</a>.';
$string['subscriptionsseemore'] = 'Bemærk: De viste oplysninger opdateres ikke i realtid. Du skal muligvis logge ud og logge ind igen for at se opdateringer. Du kan finde oplysninger om opgradering af din appplan ved at logge på <a href="{$a}" target="_blank">Moodle Apps Portal</a>.';
$string['switchaccount'] = 'Skift konto';
$string['typeoflogin'] = 'Logintype';
$string['typeoflogin_desc'] = 'Hvis siden bruger en SSO-godkendelse, kan den vælges via et browservindue eller via en indlejret browser. En Indlejret browser giver en bedre brugeroplevelse, men kan ikke bruges med alle plugins.';
$string['viewqrcode'] = 'Se QR-kode';
