<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'jazzquiz', language 'no', version '4.1'.
 *
 * @package     jazzquiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a_out_of_b_responded'] = '{$a->a} / {$a->b} har svart';
$string['a_out_of_b_voted'] = '{$a->a} / {$a->b} har stemt';
$string['a_responses'] = '{$a} svar';
$string['a_students_answered'] = '<b>{$a}</b> studenter har svart på minst ett spørsmål';
$string['a_students_joined_quiz'] = '<b>{$a}</b> studenter deltok i økten';
$string['add'] = 'Legg til';
$string['add_question'] = 'Legg til spørsmål';
$string['add_to_quiz'] = 'Legg til i quiz';
$string['allow_guests'] = 'Tillat gjester å delta';
$string['anonymous'] = 'Anonym';
$string['anonymous_answers'] = 'Anonyme svar (Deltakelse kan sees)';
$string['anonymous_answers_info'] = 'Svar er anonyme i denne økten. Din deltakelse vil fortsatt bli dokumentert.';
$string['answer'] = 'Svar';
$string['attempt_started'] = 'Et forsøk på har allerede blitt startet av deg denne økten. Vennligst klikk nedenfor for å fortsette.';
$string['attempts'] = 'Forsøk';
$string['attendance'] = 'Deltakelse';
$string['attendance_list'] = 'Liste over deltakelse';
$string['click_to_show_original_results'] = 'Klikk for å vise opprinnelige resultater';
$string['click_to_show_vote_results'] = 'Klikk for å vise stemmeresultater';
$string['closing_session'] = 'Stenger økt...';
$string['create_new_question'] = 'Opprett nytt spørsmål';
$string['default_question_time'] = 'Standard spørsmålstid';
$string['default_question_time_help'] = 'Standard tid for å vise hvert spørsmål.<br>Dette kan bli overstyrt av individuelle spørsmål.';
$string['delete_question'] = 'Slett spørsmål {$a}';
$string['download_attendance_list'] = 'Last ned liste over deltakelse';
$string['download_report'] = 'Last ned rapport';
$string['download_responses'] = 'Last ned besvarelser';
$string['edit'] = 'Rediger';
$string['edit_page_open_session_error'] = 'Du kan ikke redigere quizzen når en økt er åpen.';
$string['edit_question'] = 'Rediger spørsmål';
$string['end'] = 'Avslutt';
$string['error_getting_current_results'] = 'En feil oppstod ved innhenting av besvarelser.';
$string['error_getting_vote_results'] = 'En feil oppstod ved henting av avstemningsresultater.';
$string['error_saving_vote'] = 'En feil oppstod under lagring av stemmen.';
$string['error_starting_vote'] = 'En feil oppstod. Kan ikke starte stemming.';
$string['error_with_request'] = 'En feil oppstod under spørringen.';
$string['event_attempt_started'] = 'Besvarelse påbegynt';
$string['event_question_answered'] = 'Spørsmål besvart';
$string['exit'] = 'Steng økt';
$string['failed_to_end_question'] = 'Kunne ikke avslutte spørsmål.';
$string['fullscreen'] = 'Fullskjerm';
$string['fully_anonymous'] = 'Helt anonymt';
$string['fully_anonymous_info'] = 'Både svar og deltakelse vil være helt anonymt i denne økten.';
$string['goto_session'] = 'Gå til nåværende økt';
$string['improvise'] = 'Improviser';
$string['instructions_for_instructor'] = '<h3>Vennligst les instruksene:</h3>
    <p>Det finnes forskjellige snarveier. Disse kan bli brukt når inputfeltet ikke er aktivt.</p>
    <table>
        <tr>
               <th>Kontroll</th>
               <th>Snarvei</th>
               <th>Beskrivelse</th>
        </tr>
        <tr>
            <td>
                <i class="fa fa-repeat"></i> Spør på nytt
            </td>
            <td>r</td>
            <td>
               Lar instruktøren spørre det samme spørsmålet på nytt.
                Dette er det samme som å starter et nytt spørsmål fra listen <i class="fa fa-bars"></i> Spørsmål.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-bar-chart"></i> Stem
            </td>
            <td>v</td>
            <td>
                 La studentene stemme på svarene.
                 Instruktøren kan trykke på et svar for å velge om det skal være inkludert i avstemningen.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-edit"></i> Improviser
            </td>
            <td>i</td>
            <td>
                Viser en liste med spørsmål, lagd for improvisering.
                Skriv spørsmålet på tavla, og spør om svar med disse spørsmålene.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-bars"></i> Spørsmål
            </td>
            <td>j</td>
            <td>
                Viser en liste med alle planlagte spørsmål for denne quizzen.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-forward"></i> Neste
            </td>
            <td>n</td>
            <td>
                Fortsett til neste spørsmål på listen over planlagte spørsmål.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-close"></i> Avslutt
            </td>
            <td>e</td>
            <td>
                Avslutt det nåværende spørsmålet.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-expand"></i> Fullskjerm
            </td>
            <td>f</td>
            <td>
                Viser aktiviteten i fullskjerm.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-square-o"></i> / <i class="fa fa-check-square-o"></i> Fasit
            </td>
            <td>a</td>
            <td>
                Viser korrekt svar for spørsmålet.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-square-o"></i> / <i class="fa fa-check-square-o"></i> Besvarelser
            </td>
            <td>t (toggle)</td>
            <td>
                Skjul eller vis besvarelsene til studentene.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-window-close"></i> Steng økt
            </td>
            <td></td>
            <td>
                Avslutt den nåværende økten.
            </td>
        </tr>
    </table>';
$string['instructions_for_student'] = '<p>Vennligst vent til instruktøren har startet økten.</p>';
$string['instructor_sessions_going'] = 'Det er allerede en pågående økt. Vennligst trykk på knappen nedenfor for å gå til økten.';
$string['invalid_question_time'] = 'Spørsmålstid må være et heltall på 0 eller høyere.';
$string['jazzquiz:addinstance'] = 'Legge til en instans av JazzQuiz';
$string['jazzquiz:attempt'] = 'Forsøke på en JazzQuiz';
$string['jazzquiz:control'] = 'Kontroller en JazzQuiz. (Vanligvis bare for instruktører)';
$string['jazzquiz:editquestions'] = 'Rediger spørsmål for en JazzQuiz.';
$string['jazzquizsettings'] = 'Generelle innstillinger for JazzQuiz';
$string['join_quiz'] = 'Delta i økten';
$string['join_quiz_instructions'] = 'Klikk nedenfor for å delta i økten.';
$string['jump'] = 'Spørsmål';
$string['loading'] = 'Laster inn...';
$string['modulename'] = 'JazzQuiz';
$string['modulename_help'] = '<p>
    JazzQuiz lar instruktøren lage og administrere sanntidsquizzer.
    Alle vanlige spørsmålstyper kan bli brukt i JazzQuiz.
</p>
<p>
    Instruktøren har mulighet for å hoppe til forskjellige spørsmål under en økt.
    Besvarelsene blir vist i sanntid sammen med en bargraf, optimalisert for prosjektører.
    Fullskjermsmodus er også tilgjengelig.
    En tidsgrense kan bli satt for å automatisk avslutte et spørsmål, men instruktøren kan også manuelt avslutte spørsmålet og fortsette til neste.
</p>';
$string['modulenameplural'] = 'JazzQuizzer';
$string['multichoice_options'] = 'Valg';
$string['next'] = 'Neste';
$string['no_attempts_found'] = 'Ingen forsøk funnet.';
$string['no_session'] = 'Det finnes ingen pågående økt.';
$string['no_sessions_exist'] = 'Ingen økter har blitt lagd enda.';
$string['no_students_have_joined'] = 'Ingen studenter deltar.';
$string['no_time_limit'] = 'Ingen tidsgrense';
$string['no_time_limit_help'] = 'Velg dette feltet for å ikke ha med tidsgrense for dette spørsmålet.
<p>Instruktøren må da manuelt avslutte spørsmålet.</p>';
$string['nonanonymous_session'] = 'Ikke-anonym økt';
$string['nonanonymous_session_info'] = 'Dette er en ikke-anonym økt. Både svar og deltakelse blir dokumentert.';
$string['one_student_has_joined'] = '1 student deltar.';
$string['pluginadministration'] = 'JazzQuiz administrering';
$string['pluginname'] = 'JazzQuiz';
$string['privacy:metadata:core_question'] = 'JazzQuiz lagrer spørsmålsbesvarelser i core_question subsystemet.';
$string['privacy:metadata:jazzquiz_attempts'] = 'Detaljer om forsøk under en økt i JazzQuiz.';
$string['privacy:metadata:jazzquiz_attempts:responded'] = 'Om det siste spørsmålet i en økt ble besvart eller ikke.';
$string['privacy:metadata:jazzquiz_attempts:timefinish'] = 'Tidspunktet da siste spørsmål ble besvart i en økt.';
$string['privacy:metadata:jazzquiz_attempts:timemodified'] = 'Tidspunktet da siste spørsmål ble modifisert i en økt.';
$string['privacy:metadata:jazzquiz_attempts:timestart'] = 'Tidspunktet da siste spørsmål ble påbegynt i en økt.';
$string['privacy:metadata:jazzquiz_attempts:userid'] = 'Brukeren som opprettet et forsøk i en økt';
$string['question'] = 'Spørsmål';
$string['question_move_down'] = 'Flytt spørsmål {$a} ned';
$string['question_move_up'] = 'Flytt spørsmål {$a} opp';
$string['question_time'] = 'Spørsmålstid';
$string['question_time_help'] = 'Spørsmålstid i sekunder';
$string['question_will_end_in_x_seconds'] = 'Spørsmålet vil avsluttes om {$a} sekunder';
$string['question_will_start_in_x_seconds'] = 'Spørsmålet vil begynne om {$a} sekunder';
$string['question_will_start_now'] = 'Spørsmålet vil nå starte';
$string['questions'] = 'Spørsmål';
$string['quit'] = 'Steng økt';
$string['quiz_not_running'] = '<p>Vent på at instruktøren skal starte økten.</p>
<p>Bruk omlastingsknappen for å sjekke om den har startet.</p>';
$string['repoll'] = 'Spør på nytt';
$string['reports'] = 'Rapporter';
$string['responses'] = 'Besvarelser';
$string['review'] = 'Gjennomgå';
$string['save_question'] = 'Lagre spørsmål';
$string['select_session'] = 'Velg økten du vil gjennomgå:';
$string['session'] = 'Økt';
$string['session_closed'] = 'Økten er nå stengt';
$string['session_name'] = 'Navn på økten';
$string['session_name_required'] = 'Navn på økten er nødvendig';
$string['short_answer'] = 'Kortsvar';
$string['short_math_answer'] = 'Kortsvar i matematikk';
$string['showing_original_results'] = 'Vise opprinnelige besvarelser';
$string['showing_vote_results'] = 'Vis resultater etter avstemming';
$string['start_session'] = 'Start økten';
$string['startquiz'] = 'Start økten';
$string['student'] = 'Student';
$string['teacher_start_instructions'] = '<p>Start en quiz som studentene skal delta i.</p>
<p>Definer et navn på økten nedenfor, som vil hjelpe deg å gjennomgå resultatene senere.</p>';
$string['unable_to_create_session'] = 'Klarte ikke å lage opprette en ny økt';
$string['view'] = 'Vis';
$string['vote'] = 'Stem';
$string['wait_for_instructor'] = 'Vennligst vent på at instruktøren skal starte det neste spørsmålet.';
$string['wait_for_question_time'] = 'Tid for å vente på spørsmål';
$string['wait_for_question_time_help'] = 'Tid for å vente på at et spørsmål skal starte.';
$string['wait_for_students'] = 'Venter på at studenter skal delta';
$string['x_seconds_left'] = '{$a}s gjenstår';
$string['x_students_have_joined'] = '{$a} studenter deltar';
$string['you_already_voted'] = 'Beklager, men du har allerede stemt.';
