<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'no', version '4.1'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Handlinger for vurderingsgrensesnittet';
$string['actionsforpost'] = 'Handlinger for innlegg';
$string['activitydate:due'] = 'Forfall:';
$string['activityoverview'] = 'Det er nye foruminnlegg';
$string['addanewdiscussion'] = 'Legg til diskusjonsemne';
$string['addanewquestion'] = 'Legg til et nytt spørsmål';
$string['addanewtopic'] = 'Skriv i dette forumet';
$string['addreply'] = 'Legg til svar';
$string['addtofavourites'] = 'Merk diskusjonen som favoritt';
$string['advancedsearch'] = 'Avansert søk';
$string['alldiscussions'] = 'Alle diskusjoner';
$string['allforums'] = 'Alle forum';
$string['allowdiscussions'] = 'Kan en {$a} skrive i dette forumet?';
$string['allowsallsubscribe'] = 'Dette forumet tillater at alle kan velge å abonnere eller ikke';
$string['allowsdiscussions'] = 'Dette forumet tillater alle å starte nye diskusjoner.';
$string['allsubscribe'] = 'Abonnere på alle fora';
$string['allunsubscribe'] = 'Avslutt alle abonnement';
$string['allusers'] = 'Alle brukere';
$string['alreadyfirstpost'] = 'Det finnes allerede en første post i diskusjonen';
$string['anyfile'] = 'Hvilken som helst fil';
$string['areaattachment'] = 'Vedlegg';
$string['areapost'] = 'Meldinger';
$string['attachment'] = 'Vedlegg';
$string['attachment_help'] = 'Du kan velge å legge til en eller flere filer til en forumpost. Hvis du legger ved et bilde, vil det bli vist etter meldingen.';
$string['attachmentname'] = 'Vedlegg {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Du kan ikke eksportere vedlegge uten en post-id';
$string['attachments'] = 'Vedlegg';
$string['attachmentswordcount'] = 'Vedlegg og ordtelling';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} svarer {$a->author} privat';
$string['authorreplyingtoauthor'] = '{$a->respondant} svarer {$a->author}';
$string['availability'] = 'Tilgjengelighet';
$string['blockafter'] = 'Legg inn grense for blokkering';
$string['blockafter_help'] = 'Denne innstillingen angir et maks. antall poster en bruker kan poste innenfor angitt tidsperiode. Brukere med egenskapen mod/forum: postwithoutthrottling er unntak fra postbegrensing';
$string['blockperiod'] = 'Tidsperiode for blokkering';
$string['blockperiod_help'] = 'Studenter kan stenges ute fra å poste flere enn et visst antall poster i løpet av en angitt periode. Brukere med egenskapen mod/forum: postwithoutthrottling er unntak fra postbegrensing';
$string['blockperioddisabled'] = 'Ikke blokker';
$string['blogforum'] = 'Standardforum vist i blogglignende format';
$string['bynameondate'] = 'av {$a->name} - {$a->date}';
$string['cachedef_forum_is_tracked'] = 'Forumsporingsstatus for bruker';
$string['calendardue'] = '{$a} er forfalt';
$string['cancelreply'] = 'Avbryt svar';
$string['cannotadd'] = 'Kan ikke legge til diskusjon i dette forumet';
$string['cannotadddiscussion'] = 'Du må være medlem av en gruppe for å legge til ny diskusjon i dette forumet.';
$string['cannotadddiscussionall'] = 'Du har ikke tillatelse til å legge til et nytt diskusjonsemne for alle deltakerne.';
$string['cannotadddiscussiongroup'] = 'Du kan ikke opprette en diskusjon siden du ikke er medlem av noen grupper.';
$string['cannotaddsubscriber'] = 'Kan ikke legge til abonnent med brukerid {$a} til dette forumet.';
$string['cannotaddteacherforumto'] = 'Ikke mulig å legge til konvertert lærerforum-instans i seksjon 0 i kurset.';
$string['cannotcreatediscussion'] = 'Kan ikke lage ny diskusjon';
$string['cannotcreateinstanceforteacher'] = 'Kunne ikke opprette ny instans av kursmodulen lærerforum.';
$string['cannotdeletepost'] = 'Du kan ikke slette dette innlegget!';
$string['cannoteditposts'] = 'Du kan ikke redigere andre folks innlegg';
$string['cannotexportforum'] = 'Du kan ikke eksportere dette forumet';
$string['cannotfavourite'] = 'Beklager, men du kan ikke merke diskusjoner som favoritt';
$string['cannotfinddiscussion'] = 'Kan ikke finne diskusjonen i dette forumet';
$string['cannotfindfirstpost'] = 'Kan ikke finne første innlegg i dette forumet';
$string['cannotfindorcreateforum'] = 'Kunne ikke finne eller opprette et nyhetsforum for forsiden';
$string['cannotfindparentpost'] = 'Kunne ikke finne overordnet nivå for innlegg {$a}';
$string['cannotmovefromsingleforum'] = 'Kan ikke flytte diskusjoner fra forumtypen "Diskusjonsforum for ett enkelt tema".';
$string['cannotmovenotvisible'] = 'Forum ikke synlig';
$string['cannotmovetonotexist'] = 'Du kan ikke flytte til det forumet - det eksisterer ikke!';
$string['cannotmovetonotfound'] = 'Fant ikke målforumet i dette kurset.';
$string['cannotmovetosingleforum'] = 'Kan ikke flytte diskusjoner til forumtypen "Diskusjonsforum for ett enkelt tema".';
$string['cannotpindiscussions'] = 'Beklager, men du har ikke rettigheter til å feste diskusjoner.';
$string['cannotpurgecachedrss'] = 'Kunne ikke tømme mellomlagrede RSS-agenter for kilden og/eller målforumene - sjekk filtillatelsene.';
$string['cannotremovesubscriber'] = 'Kunne ikke fjerne abonnenten med id {$a} fra dette forumet!';
$string['cannotreply'] = 'Du kan ikke svare på dette innlegget';
$string['cannotsplit'] = 'Diskusjoner fra dette forumet kan ikke splittes';
$string['cannotsubscribe'] = 'Beklager, men du må være gruppemedlem for å abonnere.';
$string['cannottrack'] = 'Kunne ikke slå av sporing for det forumet';
$string['cannotunsubscribe'] = 'Kunne ikke stoppe abonnementet ditt på det forumet';
$string['cannotupdatepost'] = 'Du kan ikke oppdatere dette innlegget';
$string['cannotuseseperategroupsandsingletopic'] = 'Separate grupper kan ikke brukes med forumtypen en enkelt diskusjon.';
$string['cannotusesingletopicandseperategroups'] = 'Forumtypen en enkelt diskusjon kan ikke kombineres med separate grupper.';
$string['cannotviewpostyet'] = 'Du kan ikke lese andre studenters spørsmål i denne diskusjonen ennå fordi du ikke har lagt inn noe selv.';
$string['cannotviewusersposts'] = 'Denne brukeren har ikke postet noen innlegg som du har tilgang til å se.';
$string['cleanreadtime'] = 'Tidspunkt for merking av gamle innlegg som lest';
$string['clicktofavourite'] = 'Du har ikke merket diskusjonen som favoritt. Klikk for å merke som favoritt';
$string['clicktolockdiscussion'] = 'Klikk for å låse denne diskusjonen';
$string['clicktosubscribe'] = 'Du abonnerer ikke på denne diskusjonen. Klikk for å abonnere.';
$string['clicktounfavourite'] = 'Du har merket diskusjonen som favoritt. Klikk for å fjerne favorittmerkingen.';
$string['clicktounlockdiscussion'] = 'Klikk for å låse opp diskusjonen';
$string['clicktounsubscribe'] = 'Du abonnerer på innlegg fra denne diskusjonen. Klikk for å fjerne abonnementet.';
$string['close'] = 'Lukk';
$string['closegrader'] = 'Lukk vurderingsvindu';
$string['completiondetail:discussions'] = 'Start diskusjoner: {$a}';
$string['completiondetail:posts'] = 'Lag foruminnlegg: {$a}';
$string['completiondetail:replies'] = 'Post svar: {$a}';
$string['completiondiscussions'] = 'Studenter må lage diskusjoner:';
$string['completiondiscussionsdesc'] = 'Deltakeren må opprette minst {$a} diskusjon(er)';
$string['completiondiscussionsgroup'] = 'Krever diskusjoner';
$string['completiondiscussionshelp'] = 'krever at diskusjonene skal fullføres';
$string['completionposts'] = 'Studenten må poste diskusjoner eller svar:';
$string['completionpostsdesc'] = 'Deltakeren må opprette minste {$a} diskusjon(er) eller svar.';
$string['completionpostsgroup'] = 'Trenger innlegg';
$string['completionpostshelp'] = 'krever at diskusjoner eller svar skal fullføres';
$string['completionreplies'] = 'Studenter må svare på innlegg:';
$string['completionrepliesdesc'] = 'Deltakeren må skrive minst {$a} svar';
$string['completionrepliesgroup'] = 'Behøver svar';
$string['completionreplieshelp'] = 'trenger svar for å fullføre';
$string['configcleanreadtime'] = 'Tidspunkt for sletting av gamle, leste innlegg.';
$string['configdigestmailtime'] = 'Brukere som velger å få epost tilsendt i en samlesending vil få den en gang daglig. Denne settingen kontrollerer når på dagen samlesendingen vil bli sendt ut (neste gang cron kjører etter dette tidspunktet vil sende den ut).';
$string['configdisplaymode'] = 'Standard visningsmåte for diskusjoner dersom dette ikke er valgt.';
$string['configenablerssfeeds'] = 'Denne bryteren vil gjøre det mulig å få RSS matinger for alle fora. Du må allikevel manuelt slå på nating manuelt i innstillingene for hvert forum.';
$string['configenabletimedposts'] = 'Settes til "JA" dersom du vil tillate innstilling av når nye foruminnlegg skal bli synlige.';
$string['configlongpost'] = 'Ethvert innlegg over denne lengden (med tegn ikke inkludert HTML) anses som lange. Innlegg som vises på portalens startside, kurssider i sosialt format eller brukerprofiler er forkortet til en naturlig pause et sted mellom verdiene for forum_shortpost og forum_longpost.';
$string['configmanydiscussions'] = 'Maksimum antall diskusjoner vist i et forum per side';
$string['configmaxattachments'] = 'Standardverdi for maks antall tillatte vedlegg pr. innlegg';
$string['configmaxbytes'] = 'Standard maksimum størrelse for alle forumvedleggene på portalen (overordnet klassenes grenser og andre lokale innstillinger)';
$string['configoldpostdays'] = 'Hvor mange dager gamle et innlegg må være for at det skal betraktes som lest.';
$string['configreplytouser'] = 'Når et innlegg i et forum er sendt ut, skal det inneholde brukerens epostadresse slik at mottakere kan svare personlig istedenfor via forumet?';
$string['configrssarticlesdefault'] = 'Setter standard antall artikler (eller diskusjoner eller innlegg) som vises når RSS er aktivert';
$string['configrsstypedefault'] = 'Setter standard aktivitetstype for RSS-feeder';
$string['configshortpost'] = 'Alle innlegg under denne lengden (ikke inkludert HTML) blir regnet som korte.';
$string['configsubscriptiontype'] = 'Standardinnstilling for abonnementsmodus';
$string['configtrackingtype'] = 'Standard innstilling for lesesporing';
$string['configtrackreadposts'] = 'Sett til \'ja\' hvis du ønsker å spore lest/ulest for hver bruker.';
$string['configusermarksread'] = 'Hvis \'ja\', må brukeren manuelt merke et innlegg som lest. Hvis \'nei\', blir innlegget merket som lest når det blir sett.';
$string['confirmsubscribe'] = 'Ønsker du virkelig å abonnere på forumet {$a}?';
$string['confirmsubscribediscussion'] = 'Ønsker du virkelig å abonnere på diskusjonen \'{$a->discussion}\' i forumet \'{$a->forum}\'?';
$string['confirmunsubscribe'] = 'Ønsker du virkelig å avslutte abonnementet på forumet {$a}?';
$string['confirmunsubscribediscussion'] = 'Ønsker du virkelig å avslutte abonnementet på diskusjonen \'{$a->discussion}\' i forumet \'{$a->forum}\'?';
$string['couldnotadd'] = 'Kunne ikke legge ut innlegget ditt pga. en ukjent feil';
$string['couldnotdeletereplies'] = 'Beklager, innlegget kan ikke slettes siden noen allerede har svart på det';
$string['couldnotupdate'] = 'Kunne ikke oppdatere innlegget pga. en ukjent feil';
$string['created'] = 'Opprettet';
$string['crontask'] = 'Utsendelse av mail og vedlikeholdsjobber for forumet';
$string['cutoffdate'] = 'Siste dato for innlevering';
$string['cutoffdate_help'] = 'Hvis aktivert vil ikke forumet akseptere innlegg etter denne datoen.';
$string['cutoffdatereached'] = 'Det er etter forumets avslutningsdato og du kan ikke lengre skrive innlegg i';
$string['cutoffdatevalidation'] = 'Siste dato for innlevering må være etter innleveringsfristen.';
$string['delete'] = 'Slett';
$string['deleteddiscussion'] = 'Diskusjonen er slettet';
$string['deletedpost'] = 'Innlegget er slettet';
$string['deletedposts'] = 'Disse innleggene er slettet';
$string['deleteduser'] = 'Slettet bruker';
$string['deletesure'] = 'Er du sikker på at du vil slette dette innlegget?';
$string['deletesureplural'] = 'Er du sikker på at du vil slette dette innlegget og alle svarene({$a} innlegg)';
$string['digestmailheader'] = 'Her kommer din daglige samlepost fra forumene på {$a->sitename}. Gå til {$a->userprefs} hvis du vil endre innstillingene for epostutsendelse.';
$string['digestmailpost'] = 'Endre innstillinger for samleutsending av forummeldinger';
$string['digestmailpostlink'] = 'Endre innstillinger for samleeposter fra forum';
$string['digestmailprefs'] = 'Din brukerprofil';
$string['digestmailsubject'] = 'Samlepost fra forumet {$a}';
$string['digestmailtime'] = 'Samlesending av epost sendes ut kl:';
$string['digestsentusers'] = 'Sendte samlepost til {$a} brukere.';
$string['disallowsubscribe'] = 'Abonnementer er ikke tillatt';
$string['disallowsubscribeteacher'] = 'Abonnementer er ikke tillatt (med unntak av lærere)';
$string['disallowsubscription'] = 'Abonnementer er ikke tillatt (med unntak av lærere)';
$string['disallowsubscription_help'] = 'Dette forumet tillater ikke diskusjonsabonnement.';
$string['discussion'] = 'Diskusjon';
$string['discussionlistsortbycreatedasc'] = 'Sorter etter opprettelsesdato i stigende rekkefølge';
$string['discussionlistsortbycreateddesc'] = 'Sorter etter opprettelsesdato i synkende rekkefølge';
$string['discussionlistsortbydiscussionasc'] = 'Sorter stigende basert på diskusjonsnavn';
$string['discussionlistsortbydiscussiondesc'] = 'Sorter synkende basert på diskusjonsnavn';
$string['discussionlistsortbygroupasc'] = 'Sorter stigende basert på gruppe';
$string['discussionlistsortbygroupdesc'] = 'Sorter synkende basert på gruppe';
$string['discussionlistsortbylastpostasc'] = 'Sorter etter siste opprettingsdato i stigende rekkefølge';
$string['discussionlistsortbylastpostdesc'] = 'Sorter etter siste opprettingsdato i synkende rekkefølge';
$string['discussionlistsortbyrepliesasc'] = 'Sorter diskusjonslisten stigende etter antall innlegg';
$string['discussionlistsortbyrepliesdesc'] = 'Sorter diskusjonslisten synkende etter antall innlegg';
$string['discussionlistsortbystarterasc'] = 'Sorter stigende basert på navnet til diskusjonsstarteren';
$string['discussionlistsortbystarterdesc'] = 'Sorter synkende basert på navnet til diskusjonsstarteren';
$string['discussionlocked'] = 'Denne diskusjonen har blitt stengt, og du kan derfor ikke svare i den lengre.';
$string['discussionlockingdisabled'] = 'Ikke steng diskusjoner';
$string['discussionlockingheader'] = 'Diskusjonstenging';
$string['discussionmoved'] = 'Denne diskusjonen er flyttet til \'{$a}\'.';
$string['discussionmovedpost'] = 'Denne diskusjonen er blitt flyttet <a href="{$a->discusshref}">hit</a> i forumet <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Navn på diskusjon';
$string['discussionnownotsubscribed'] = '{$a->name} vil IKKE få påminnelser om nye innlegg i \'{$a->discussion}\' på \'{$a->forum}\'';
$string['discussionnowsubscribed'] = '{$a->name} vil få påminnelser om nye innlegg i \'{$a->discussion}\' på \'{$a->forum}\'';
$string['discussionpin'] = 'Fest';
$string['discussionpinned'] = 'Festet';
$string['discussionpinned_help'] = 'Festede diskusjoner vil vises øverst i forumet';
$string['discussions'] = 'Diskusjoner';
$string['discussionsplit'] = 'Diskusjonen har blitt splittet';
$string['discussionsstartedby'] = 'Diskusjoner startet av {$a}';
$string['discussionsstartedbyrecent'] = 'Diskusjoner nylig startet av {$a}';
$string['discussionsstartedbyuserincourse'] = 'Diskusjoner startet av {$a->fullname} i {$a->coursename}';
$string['discussionsstartedincourse'] = 'Diskusjoner startet i {$a}';
$string['discussionstartedby'] = 'Diskusjon startet av {$a}';
$string['discussionsubscribed'] = 'Du abonnerer nå på denne diskusjonen';
$string['discussionsubscribestart'] = 'Send meg varsler om nye innlegg i denne diskusjonen';
$string['discussionsubscribestop'] = 'Jeg ønsker ikke varsler om nye innlegg i denne diskusjonen';
$string['discussionsubscription'] = 'Diskusjonsabonnement';
$string['discussionsubscription_help'] = 'Et diskusjonsabonnement vil si at du får påminnelser når det kommer nye innlegg i diskusjonen.';
$string['discussionunpin'] = 'Fjern festing';
$string['discussionunsubscribed'] = 'Du abonnerer ikke lengre på denne diskusjonen.';
$string['discussthistopic'] = 'Diskuter dette emnet';
$string['discusstopicname'] = 'Diskuter emnet: {$a}';
$string['displayend'] = 'Synlig til';
$string['displayend_help'] = 'Denne innstillingen angir hvorvidt et foruminnlegg skal skjules etter en gitt dato. Merk at administratorer alltid kan se foruminnlegg.';
$string['displayenddate'] = 'Synlig til: {$a}';
$string['displaymode'] = 'Visningsmodus';
$string['displayperiod'] = 'Visningsmodus';
$string['displaystart'] = 'Synlig fra';
$string['displaystart_help'] = '<p>Du kan velge om dine foruminnlegg skal vises fra en bestemt dato, skjules fra en bestemt dato eller bare vises en angitt periode.</p> <p>Fjern hakene fra Deaktiver-boksene for å vise start og/eller sluttdato.</p> <p>Merk at brukere med admnistratorrettigheter vil se meldinger før og etter datobegrensninger som er satt.</p>';
$string['displaystartdate'] = 'Vis start: {$a}';
$string['displaywordcount'] = 'Vis ordtelling';
$string['displaywordcount_help'] = 'Denne innstillingen bestemmer hvorvidt ordtellingen for hver post skal vises eller ikke.';
$string['duedate'] = 'Innleveringsfrist';
$string['duedate_help'] = 'Dette er fristen for å poste innlegg i forumet. Selv om denne datoen vises i kalenderen som forfallsdato for forumet, vil det fortsatt være tillatt å legge ut etter denne datoen. Angi en blokkeringsdato for å forhindre oppslag på forumet etter en bestemt dato.';
$string['duedatetodisplayincalendar'] = 'Visning av frist i kalender';
$string['eachuserforum'] = 'Hver bruker starter en diskusjon';
$string['edit'] = 'Redigere';
$string['editdiscussion'] = 'Rediger diskusjon';
$string['editdiscussiontopic'] = 'Rediger diskusjonsemne';
$string['editedby'] = 'Redigert av {$a->name} - orginalinnlegg {$a->date}';
$string['editedpostupdated'] = '{$a}s poster ble oppdatert';
$string['editing'] = 'Redigerer';
$string['emaildigestcompleteshort'] = 'Hele innlegg';
$string['emaildigestdefault'] = 'Standard ({$a})';
$string['emaildigestoffshort'] = 'Ingen oppsummering';
$string['emaildigestsubjectsshort'] = 'Kun emnefelt';
$string['emaildigesttype'] = 'Valg for oppsummeringseposter';
$string['emaildigesttype_help'] = 'Hva slags varslinger du skal motta for hvert forum.

* Standard - følger samleinnstillingene gitt i din brukerprofil. Når du oppdaterer brukerprofilen din vil endringene være gjeldende her også.
* Ingen oppsamling: Du vil da få en epost pr. foruminnlegg.
* Samlesending med komplette bidrag: Du vil få en daglig epost med fullt innhold fra alle nye bidrag i forumene.
* Samlesending med opplisting av bidrag: Du vil få en daglig epost som inneholder titlene på alle bidrag denne dagen.';
$string['emptymessage'] = 'Noe var galt med innlegget ditt. Kanskje det var blankt, eller vedlegget var for stort. Endringene dine ble ikke lagret. ';
$string['errorcannotlock'] = 'Du har ikke rettigheter til å låse diskusjoner';
$string['errordiscussionnotfound'] = 'Diskusjonen ble ikke funnet';
$string['erroremptymessage'] = 'Innleggsmeldingen kan ikke være tom';
$string['erroremptysubject'] = 'Innleggstittel kan ikke være tom.';
$string['errorenrolmentrequired'] = 'Du må være påmeldt dette kurset for å få tilgang til dette innholdet';
$string['errorforumnotfound'] = 'Forumet som denne diskusjonen tilhører ble ikke funnet';
$string['errorwhiledelete'] = 'Det oppsto en feil under slettingen av posten.';
$string['eventassessableuploaded'] = 'Noe innhold er blitt postet.';
$string['eventcoursesearched'] = 'Ferdig å søke gjennom kurset';
$string['eventdiscussioncreated'] = 'Diskusjon opprettet';
$string['eventdiscussiondeleted'] = 'Diskusjon slettet';
$string['eventdiscussionmoved'] = 'Diskusjon flyttet';
$string['eventdiscussionpinned'] = 'Diskusjon festet';
$string['eventdiscussionsubscriptioncreated'] = 'Diskusjonsabonnement opprettet';
$string['eventdiscussionsubscriptiondeleted'] = 'Diskusjonsabonnement slettet';
$string['eventdiscussionunpinned'] = 'Diskusjonsfesting fjernet';
$string['eventdiscussionupdated'] = 'Diskusjon oppdatert';
$string['eventdiscussionviewed'] = 'Diskusjon vist';
$string['eventpostcreated'] = 'Innlegg opprettet';
$string['eventpostdeleted'] = 'Innlegg slettet';
$string['eventpostupdated'] = 'Innlegg oppdatert';
$string['eventreadtrackingdisabled'] = 'Sporing deaktivert';
$string['eventreadtrackingenabled'] = 'Sporing aktivert';
$string['eventsubscribersviewed'] = 'Abonnenter vist';
$string['eventsubscriptioncreated'] = 'Abonnement opprettet';
$string['eventsubscriptiondeleted'] = 'Abonnement slettet';
$string['eventuserreportviewed'] = 'Brukerrapport vist';
$string['everyonecanchoose'] = 'Alle kan velge om de vil abonnere';
$string['everyonecannowchoose'] = 'Abonnere er nå valgfritt for alle';
$string['everyoneisnowsubscribed'] = 'Alle er nå abonnenter på dette forumet';
$string['everyoneissubscribed'] = 'Alle abonnerer på dette forumet';
$string['existingsubscribers'] = 'Esksisterende abonnenter';
$string['export'] = 'Eksporter';
$string['exportattachmentname'] = 'Eksporter vedlegg {$a} til portefølje';
$string['exportdiscussion'] = 'Eksporter hele diskusjonen til portefølje';
$string['exporthumandates'] = 'Direkte lesbar dato';
$string['exporthumandates_help'] = 'Om datoer skal eksporteres i et direkte lesbart format eller som en tidsstempel (rekkefølge av tall).';
$string['exportoptions'] = 'Eksportvalg';
$string['exportstriphtml'] = 'Fjern HTML';
$string['exportstriphtml_help'] = 'Hvorvidt HTML-koder som p og br bør fjernes fra forumposter.';
$string['favourites'] = 'Favorittmerket';
$string['favouriteupdated'] = 'Ditt favorittvalg har blitt oppdatert';
$string['firstpost'] = 'Første innlegg';
$string['forcedreadtracking'] = 'Tillatt tvungen sporing av uleste innlegg';
$string['forcedreadtracking_desc'] = 'Tillater forum til å bli satt opp med tvungen sporing av uleste innlegg. Dette kan medføre dårligere ytelse for noen brukere, spesielt i kurs som har mange forum og foruminnlegg. Hvis deaktivert - vil alle forum som tidligere har vært angitt som tvunget bli behandlet som frivillig sporing.';
$string['forcesubscribed'] = 'Dette forumet tvinger alle til å abonnere';
$string['forcesubscribed_help'] = 'Innstillingene for dette forumet gjør at du ikke kan avslutte diskusjonsabonnementer.';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Legg til et nytt forum';
$string['forum:addnews'] = 'Legg til nyheter';
$string['forum:addquestion'] = 'Legg til spørsmål';
$string['forum:allowforcesubscribe'] = 'Tillat å tvinge abonnement';
$string['forum:canoverridecutoff'] = 'Skriv innlegg i forum etter avslutningsdatoen.';
$string['forum:canoverridediscussionlock'] = 'Svar på stengte diskusjoner';
$string['forum:canposttomygroups'] = 'Post til alle grupper du har tilgang til';
$string['forum:cantogglefavourite'] = 'Favorittdiskusjoner';
$string['forum:createattachment'] = 'Sett inn vedlegg';
$string['forum:deleteanypost'] = 'Slett ethvert innlegg (når som helst)';
$string['forum:deleteownpost'] = 'Slett egne innlegg (innen fristen)';
$string['forum:editanypost'] = 'Redigert ethvert innlegg';
$string['forum:exportdiscussion'] = 'Eksporter hele diskusjonen';
$string['forum:exportforum'] = 'Eksporter forum';
$string['forum:exportownpost'] = 'Eksporter eget innlegg';
$string['forum:exportpost'] = 'Eksporter innlegg';
$string['forum:grade'] = 'Vurder forum';
$string['forum:managesubscriptions'] = 'Administrer abonnenter';
$string['forum:movediscussions'] = 'Flytte diskusjoner';
$string['forum:pindiscussions'] = 'Fest diskusjoner';
$string['forum:postprivatereply'] = 'Private svar på innlegg';
$string['forum:postwithoutthrottling'] = 'Unntak fra innleggsbegrensning';
$string['forum:rate'] = 'Vurder innlegg';
$string['forum:readprivatereplies'] = 'Vis private svar';
$string['forum:replynews'] = 'Svar på nyheter';
$string['forum:replypost'] = 'Svar på innlegg';
$string['forum:splitdiscussions'] = 'Del opp diskusjoner';
$string['forum:startdiscussion'] = 'Start nye diskusjoner';
$string['forum:viewallratings'] = 'Vis alle vurderinger gitt av brukere';
$string['forum:viewanyrating'] = 'Se alle vurderinger';
$string['forum:viewdiscussion'] = 'Se diskusjoner';
$string['forum:viewhiddentimedposts'] = 'Se innlegg før redigeringsfristen er ute';
$string['forum:viewqandawithoutposting'] = 'Alltid vise Q og A innlegg';
$string['forum:viewrating'] = 'Se dine vurderinger';
$string['forum:viewsubscribers'] = 'Se abonnentene';
$string['forumauthorhidden'] = 'Forfatter (skjult)';
$string['forumblockingalmosttoomanyposts'] = 'Du er i ferd med å nå grensen for innlegg. Du har sendt inn {$a->numposts} ganger på den siste {$a->blockperiod} og grensen er {$a->blockafter} innlegg.';
$string['forumbodydeleted'] = 'Innholdet i dette foruminnlegget har blitt fjernet og er ikke lengre tilgjengelig.';
$string['forumbodyhidden'] = 'Dette innlegget kan du ikke se, sannsynligvis fordi du ikke har postet noe innlegg i diskusjonen ennå, fordi ventetiden før publisering ikke er utløpt ennå (vanligvis 30 minutter), fordi diskusjonen ikke har startet ennå eller fordi diskusjonen er utgått.';
$string['forumgrader'] = 'Forumvurdering';
$string['forumgradingnavigation'] = 'Forumvurderingsnavigasjon';
$string['forumgradingpanel'] = 'Forumvurderingspanel';
$string['forumintro'] = 'Forumbeskrivelse';
$string['forumname'] = 'Forumnavn';
$string['forumposts'] = 'Foruminnlegg';
$string['forums'] = 'Forumat';
$string['forumsubjectdeleted'] = 'Dette foruminnlegget har blitt fjernet';
$string['forumsubjecthidden'] = 'Tema (skjult)';
$string['forumtracked'] = 'Uleste innlegg skal spores';
$string['forumtrackednot'] = 'Uleste innlegg skal ikke spores';
$string['forumtype'] = 'Forumtype';
$string['forumtype_help'] = 'Det finnes fem forskjellige forumtyper:

* En enkel diskusjon - kun ett diskusjonstema, alt på en side. Passer bra for korte, fokuserte diskusjoner.
* Hver bruker starter en diskusjon - alle brukerne kan starte en ny diskusjon. Alle (dersom dette ikke begrenses i andre innstillinger) kan likevel svare på hvert enkelt diskusjonsinnlegg. Dette passer bra når du vil at hver enkelt deltaker i klassen skal skrive ett diskusjonsinnlegg f.eks. om deres refleksjoner om ukens emne, og alle andre skal evt. kunne gi respons til disse.
*Spørsmål og svar forum - Denne forumtypen krever at brukerne poster sitt svar før de får se hva andre har svart på samme spørsmålet. Når de har bidratt, åpnes forumet for visning av andres innlegg og de kan poste innlegg på andre bidrag på vanlig måte. Denne forumtypen åpner derfor for like vilkår for alle brukerne og oppmuntrer til utforming av originale og uavhengige bidrag fra hver enkelt.
*Standard forum i et blogg-lignende format. Dette er et åpent forum hvor alle kan starte nye diskusjoner når som helst.
* Vanlig forum - er et åpent forum der alle (dersom dette ikke begrenses i andre innstillinger) kan starte nye diskusjoner. Dette egner seg for de fleste formål.';
$string['generalforum'] = 'Vanlig forum (Passer i de fleste sammenhenger)';
$string['generalforums'] = 'Generelle forum';
$string['grade_forum_header'] = 'Vurdering av hele forumet';
$string['grade_forum_name'] = 'Hele forumet';
$string['grade_forum_title'] = 'Vurder';
$string['grade_rating_name'] = 'Vurdering';
$string['graded'] = 'Vurdert';
$string['gradedby'] = 'Vurdert av';
$string['gradeforrating'] = 'Karakter for vurdering: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Karakter for vurdering skjul';
$string['gradeforwholeforum'] = 'Vurdering for forum : {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Vurdering for forum skjult';
$string['gradeitem:forum'] = 'Forum';
$string['gradeitemnameforrating'] = '{$a->name} vurdering';
$string['gradeitemnameforwholeforum'] = '{$a->name} hele forumet';
$string['grades:gradesavedfor'] = 'Vurdering lagret for {$a->fullname}';
$string['grades:gradesavefailed'] = 'Kunne ikke lagre vurdering for {$a->fullname}: {$a->error}';
$string['gradeusers'] = 'Vurder brukere';
$string['grading'] = 'Vurdering';
$string['gradingstatus'] = 'Karakterstatus';
$string['hiddenforumpost'] = 'Skjulte foruminnlegg';
$string['hidegraderpanel'] = 'Skjul vurderingspanel';
$string['hidepreviousrepliescount'] = 'Skjul tidligere svar ({$a})';
$string['hideusersearch'] = 'Skjul brukersøk';
$string['indexoutoftotal'] = '{$a->index} av {$a->total}';
$string['indicator:cognitivedepth'] = 'Kognitivt forum';
$string['indicator:cognitivedepth_help'] = 'Denne indikatoren er basert på kognitiv dybde vist av studenten i en Forum-aktivitet.';
$string['indicator:cognitivedepthdef'] = 'Forum - kognitivt engasjement';
$string['indicator:cognitivedepthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det kognitive engasjementet som tilbys av Forumaktivitetene i løpet av dette analysen.';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sosialt forum';
$string['indicator:socialbreadth_help'] = 'Denne indikatoren er basert på sosial bredde vist av studenten i en Forum-aktivitet.';
$string['indicator:socialbreadthdef'] = 'Sosialt forum';
$string['indicator:socialbreadthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det sosiale engasjementet som tilbys av forumaktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen deltakelse, deltaker alene, deltaker med andre)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = 'i {$a}';
$string['inreplyto'] = 'Som svar til {$a}';
$string['introblog'] = 'Innleggene i dette forumet blir automatisk kopiert hit fra brukerbloggene koblet til dette kurset siden blogginnleggene ikke lenger er tilgjengelige.';
$string['intronews'] = 'Her vil det komme nyheter og kunngjøringer.';
$string['introsocial'] = 'Et åpent nettpratforum der du kan skrive om hva du vil';
$string['introteacher'] = 'Et forum kun for lærere';
$string['invalidaccess'] = 'TIlgangen din til denne siden er feil';
$string['invaliddigestsetting'] = 'En ugyldig innstilling for samlesendinger ble angitt.';
$string['invaliddiscussionid'] = 'Diskusjons ID var feil eller eksisterer ikke lenger';
$string['invalidforcesubscribe'] = 'Feil tvangsinnmeldingsmodus';
$string['invalidforumid'] = 'Forum ID var feil';
$string['invalidparentpostid'] = 'Overordnet innleggs ID var feil';
$string['invalidpostid'] = 'Ugyldig post ID - {$a}';
$string['lastpost'] = 'Siste innlegg';
$string['learningforums'] = 'Læringsforum';
$string['lockdiscussion'] = 'Lås denne diskusjonen';
$string['lockdiscussionafter'] = 'Steng diskusjoner etter en periode med inaktivitet.';
$string['lockdiscussionafter_help'] = 'Diskusjoner kan automatisk bli stengt en viss tid etter siste innlegg. Brukere med rettigheten til å svare på stengte diskusjoner kan åpne en diskusjon på nytt ved å skrive et nytt innlegg i diskusjonen.';
$string['locked'] = 'Låst';
$string['lockupdated'] = 'Låsevalget har blitt oppdatert';
$string['longpost'] = 'Langt innlegg';
$string['mailnow'] = 'Send umiddelbart';
$string['managesubscriptionsoff'] = 'Fullfør abonnementsadministrasjonen.';
$string['managesubscriptionson'] = 'Administrer abonnenter';
$string['manydiscussions'] = 'Diskusjoner pr.side';
$string['markalldread'] = 'Marker alle innlegg i denne diskusjonen som lest';
$string['markallread'] = 'Marker alle innleggene i dette forumet som lest';
$string['markasread'] = 'Marker som lest';
$string['markasreadonnotification'] = 'Ved sending av forumvarsler';
$string['markasreadonnotification_help'] = 'Når du blir varslet om et foruminnlegg, kan du velge om dette skal markere innlegget som lest i forbindelse med forumsporing';
$string['markasreadonnotificationno'] = 'Ikke marker innlegget som lest';
$string['markasreadonnotificationyes'] = 'Marker innlegget som lest';
$string['markread'] = 'Marker som lest';
$string['markreadbutton'] = 'Marker <br /> som lest';
$string['markunread'] = 'Marker som ulest';
$string['markunreadbutton'] = 'Marker <br /> som ulest';
$string['maxattachments'] = 'Maks antall vedlegg';
$string['maxattachments_help'] = 'Denne innstillingen angir maks antall filer som kan legges ved et foruminnlegg.';
$string['maxattachmentsize'] = 'Maksimum størrelse på vedlegg';
$string['maxattachmentsize_help'] = '<p>
Den person som har laget forumet kan (snart) sette begrensninger for hvor store
vedlegg kan være.&nbsp;
</p>
<p>
Noen ganger er det mulig å laste opp større filer enn dette, men de blir ikke
lagret, og du kan få en feilmelding.
</p>';
$string['maxtimehaspassed'] = 'Beklager, men makstiden ({$a}) for å kunne redigere dette innlegget har gått ut.';
$string['message'] = 'Melding';
$string['messageinboundattachmentdisallowed'] = 'Kan ikke poste svaret ditt siden det inneholder et vedlegg og dette forumet tillater ikke vedlegg.';
$string['messageinboundfilecountexceeded'] = 'Kan ikke poste svaret ditt siden det inneholder flere vedlegg enn det som er tillatt i dette forumet ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Kan ikke poste svaret ditt siden totalstørrelsen ({$a->filesize}) på vedleggene er større enn det som er tillatt i dette forumet ({$a->forum->maxbytes}).';
$string['messageinboundforumhidden'] = 'Kan ikke poste svaret ditt, siden forumet for tiden er utilgjengelig.';
$string['messageinboundnopostforum'] = 'Kan ikke poste svaret ditt, siden du ikke har tillatelse til å poste i forumet: {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'Kan ikke poste svaret ditt. Du har nådd innleggsgrensen i dette forumet.';
$string['messageprovider:digests'] = 'Abonnerer på samlet utsending av foruminnlegg';
$string['messageprovider:posts'] = 'Foruminnlegg du abonnerer på';
$string['missingsearchterms'] = 'Følgende søkeord finnes bare i HTML-koden i denne meldingen:';
$string['modeflatnewestfirst'] = 'Vis svar flatt, nyeste innlegg først.';
$string['modeflatoldestfirst'] = 'Vis svar flatt, eldste innlegg først.';
$string['modenested'] = 'Vis svar nøstet (Overskrift og innhold)';
$string['modenestedv2'] = 'Vis svar i nøstet versjon';
$string['modethreaded'] = 'Vis svar som tråd (Kun overskrifter)';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Aktivitetsmodulen Forum gjør det mulig for deltakere å ha asynkrone diskusjoner, dvs. diskusjoner som finner sted i løpet av en lengre tidsperiode.

Du kan velge mellom flere forumtyper, for eksempel standard forum der hvem som helst, når som helst kan starte en ny diskusjon; forum der hver student kan starte bare en diskusjon hver; eller et spørsmål og svar-forum der studentene må poste et svar før de kan se de andre studentenes innlegg. Lærere kan tillate filopplasting i foruminnlegg. Bilder som lastes opp vises i innlegget.

Deltakere kan abonnere på forum for å få e-postkopier av nye foruminnlegg. Lærere kan sette abonneringinnstillingene til valgfritt, tvunget eller auto, eller slå av abonnering helt. Hvis nødvendig, kan elevene hindres fra å legge til mer enn et bestemt antall innlegg i en bestemt tidsperiode; dette kan hindre enkeltstudenter fra å dominere diskusjoner.

Foruminnlegg kan vurderes av lærere eller studenter. Vurderingene kan legges sammen til en sammenlagt karakter som registreres i karakterboken.

Forum har mange bruksområder, for eksempel:

* Et sosialt møtested der studenter kan bli kjent med hverandre
* Til kursrelaterte kunngjøringer (ved bruk av nyhetsforum med tvunget abonnement)
* Til diskusjon av kursinnhold eller litteratur
* Til å fortsette en diskusjon om et spørsmål som ble startet i klasserommet
* Til diskusjoner mellom lærere (ved bruk av skjult forum)
* Et hjelpesenter der lærere og studenter kan gi hverandre råd
* Som et støtteområde for privat kommunikasjon mellom student og lærer (ved bruk av forum med separate grupper og kun en student i hver gruppe)
* Til utvidede oppgaver/aktiviteter, for eksempel \'brain teasere\' som studenter kan tenke på og foreslå løsninger til';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Forum';
$string['more'] = 'mer';
$string['movedmarker'] = '(Flyttet)';
$string['movethisdiscussionlabel'] = 'Flytt den aktuelle diskusjonen til det spesifiserte forumet';
$string['movethisdiscussionto'] = 'Flytt diskusjonen til et annet forum';
$string['mustprovidediscussionorpost'] = 'Du må angi enten en diskusjons ID eller innleggs ID for å kunne eksportere';
$string['myprofileotherdis'] = 'Forumdiskusjoner';
$string['myprofileowndis'] = 'Mine forumdiskusjoner';
$string['myprofileownpost'] = 'Mine foruminnlegg';
$string['namenews'] = 'Oppslagstavle';
$string['namenews_help'] = 'Oppslagstavla er et forum som automatisk opprettes i alle nye kurs og på hovedsiden. Det er ment for generell informasjon og du kan bare ha en oppslagstavle pr. kurs.

Blokken "Siste nyheter" vil vise de nyeste innleggene fra Oppslagstavla (selv om du gir den et annet navn). Av denne årsaken blir alltid Oppslagstavla automatisk gjenopprettet hvis du legger til blokken "Siste nyheter".';
$string['namesocial'] = 'Sosialt forum';
$string['nameteacher'] = 'Lærerforum';
$string['newforumposts'] = 'Nye foruminnlegg';
$string['nextdiscussiona'] = 'Neste diskusjon: {$a}';
$string['nextuser'] = 'Lagre endringer og fortsett med neste bruker';
$string['noattachments'] = 'Det er ingen vedlegg til dette innlegget';
$string['nodiscussions'] = 'Ingen har skrevet i dette forumet ennå';
$string['nodiscussionsstartedby'] = '{$a} har ikke startet noen diskusjoner';
$string['nodiscussionsstartedbyyou'] = 'Du har ikke startet noen diskusjoner ennå';
$string['noguestpost'] = 'Beklager, gjester kan ikke skrive innlegg';
$string['noguestsubscribe'] = 'Beklager, gjester kan ikke abonnere.';
$string['noguesttracking'] = 'Beklager, gjester kan ikke sette sporingsinnstillinger.';
$string['nomorepostscontaining'] = 'Fant ingen flere innlegg som inneholder \'{$a}\'';
$string['nonews'] = 'Ingen nyheter er skrevet ennå';
$string['noonecansubscribenow'] = 'Abonnering er nå slått av';
$string['nopermissiontosubscribe'] = 'Du har ikke tillatelse til å se forumabonnenter';
$string['nopermissiontoview'] = 'Du har ikke tilgang til å se dette innlegget';
$string['nopostforum'] = 'Beklager, du kan ikke poste innlegg i dette forumet';
$string['noposts'] = 'Ingen innlegg';
$string['nopostsmadebyuser'] = '{$a} har ikke postet noen innlegg';
$string['nopostsmadebyyou'] = 'Du har ikke postet noen innlegg';
$string['noquestions'] = 'Det er ennå ingen spørsmål i dette forumet.';
$string['nosubscribers'] = 'Det er forløpig ingen abonnenter i dette forumet';
$string['notexists'] = 'Diskusjonen eksisterer ikke lenger';
$string['notgraded'] = 'Ikke vurdert';
$string['nothingnew'] = 'Ingenting nytt for {$a}';
$string['notingroup'] = 'Beklager, men du må være medlem i en gruppe for å se dette forumet.';
$string['notinstalled'] = 'Forummodulen er ikke installert';
$string['notlocked'] = 'Lås';
$string['notpartofdiscussion'] = 'Dette innlegget er ikke en del av en diskusjon!';
$string['notrackforum'] = 'Ikke hold orden på uleste innlegg';
$string['notsubscribed'] = 'Abonnere';
$string['nousersmatch'] = 'Ingen bruker(e) funnet med dette kriteriet';
$string['noviewdiscussionspermission'] = 'Du har ikke høye nok rettigheter til å se diskusjonene i dette forumet';
$string['nowallsubscribed'] = 'Du abonnerer nå på alle forum i {$a}';
$string['nowallunsubscribed'] = 'Du abonnerer ikke lengre på alle forum i {$a}';
$string['nowgradinguser'] = 'Vurderer nå {$a}';
$string['nownotsubscribed'] = '{$a->name} vil IKKE motta e-postkopier fra \'{$a->forum}\'.';
$string['nownottracking'] = '{$a->name} sporer ikke lenger \'{$a->forum}\'.';
$string['nowsubscribed'] = 'Du vil bli varslet om nye innlegg i forumet \'{$a->forum}\'.';
$string['nowtracking'] = '{$a->name} sporer nå \'{$a->forum}\'.';
$string['numberofreplies'] = 'Antall svar: {$a}';
$string['numposts'] = '{$a} innlegg';
$string['olderdiscussions'] = 'Eldre diskusjoner';
$string['oldertopics'] = 'Eldre tema';
$string['oldpostdays'] = 'Les etter dager';
$string['page-mod-forum-discuss'] = 'Side for diskusjontråd i forummodulen';
$string['page-mod-forum-view'] = 'Hovedsiden i forummodulen';
$string['page-mod-forum-x'] = 'Alle sider i forummodulen';
$string['parent'] = 'Les forrige innlegg';
$string['parentofthispost'] = 'Første innlegg i denne diskusjonen';
$string['permalink'] = 'Permanent lenke';
$string['permanentlinktoparentpost'] = 'Permanent lenke til dette innleggets forelder';
$string['permanentlinktopost'] = 'Permanent lenke til dette innlegget.';
$string['pindiscussion'] = 'Fest denne diskusjonen';
$string['pinupdated'] = 'Festevalget har blitt oppdatert';
$string['pluginadministration'] = 'Forumadministrasjon';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Innlegget ditt ble sendt.</p><p>Du har {$a} til å redigere det hvis du vil gjøre endringer. </p>';
$string['postaddedsuccess'] = 'Posting av innlegget ditt var vellykket.';
$string['postaddedtimeleft'] = 'Du har {$a} til å endre det dersom du vil gjøre forandringer.';
$string['postbymailsuccess'] = 'Gratulerer, foruminnlegget ditt med emnet "{$a->subject}" ble lagt til. Du kan se det på {$a->discussionurl}.';
$string['postbymailsuccess_html'] = 'Gratulerer, postingen av <a href="{$a->discussionurl}">foruminnelgget</a> med emnet "{$a->subject}" dirt var vellykket.';
$string['postbyuser'] = '{$a->post} av {$a->user}';
$string['postincontext'] = 'Se dette innlegget på nettsiden';
$string['postisprivatereply'] = 'Dette er et privat svar. (Lærere og andre brukere med mulighet til å se private svar kan også se det.)';
$string['postmailinfo'] = 'Dette er en <b>kopi</b> av en beskjed skrevet på {$a}.';
$string['postmailinfolink'] = 'Dette er en kopi av en melding fra {$a->coursename}. For å svare på meldingen, klikk på denne lenken: {$a->replylink}';
$string['postmailnow'] = '<p>Dette innlegget vil bli sendt ut umiddelbart til alle abonnenter på dette forum.</p>';
$string['postmailreply'] = 'Klikk på  {$a} for å svare.';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Mest individuell (rasjonell) læring';
$string['postrating2'] = 'Individuell (rasjonell) og sosial (empatisk)';
$string['postrating3'] = 'Mest sosial (empatisk) læring';
$string['posts'] = 'Innlegg';
$string['postsfrom'] = 'Innlegg fra';
$string['postsmadebyuser'] = 'Poster lagt til av {$a}';
$string['postsmadebyuserincourse'] = 'Poster lagt til av {$a->fullname} i {$a->coursename}';
$string['postsmadeincourse'] = 'Innlegg laget i {$a}';
$string['poststo'] = 'Innlegg til';
$string['posttoforum'] = 'Legg inn i forumet';
$string['posttomygroups'] = 'Send kopi til alle grupper';
$string['posttomygroups_help'] = 'Sender en kopi av denne meldingen til alle grupper du er medlem av. Gruppemedlemmer i andre grupper vil ikke se meldingen';
$string['postupdated'] = 'Innlegget ditt ble oppdatert';
$string['potentialsubscribers'] = 'Mulige abonnenter';
$string['prevdiscussiona'] = 'Forrige diskusjon {$a}';
$string['previoususer'] = 'Lagre endringer og fortsett med forrige bruker';
$string['privacy:digesttypenone'] = 'Vi beholder ingen data knyttet til en foretrukket forumsamlepost for dette forumet.';
$string['privacy:digesttypepreference'] = 'Du har valgt å motta følgende samlepost fra forumet: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Du har valgt følgende abonnement for dette forumet: "{$a->preference}".';
$string['privacy:metadata:core_rating'] = 'Dette forumet bruker vurderingssystemet for vurdering av innlegg.';
$string['privacy:metadata:core_tag'] = 'Dette forumet benytter undersystemefor tagger til å tagge foruminlegg.';
$string['privacy:metadata:forum_digests'] = 'Informasjon om samleepostpreferansene for hvert forum.';
$string['privacy:metadata:forum_digests:forum'] = 'Forumet du abonnerer på';
$string['privacy:metadata:forum_digests:maildigest'] = 'Preferanse for samleepost.';
$string['privacy:metadata:forum_digests:userid'] = 'ID\'en til brukeren med en samleepostpreferanse.';
$string['privacy:metadata:forum_discussion_subs'] = 'Informasjon om abonnement til individuelle forumdiskusjoner';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'ID\'en til diskusjonen som det abonneres på.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Starttidspunktet for abonnementet.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'ID\'en til brukeren med diskusjonsabonnementet.';
$string['privacy:metadata:forum_discussions'] = 'Informasjon om de individuelle diskusjonene som en bruker har opprettet';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - hva lagrer dette feltet';
$string['privacy:metadata:forum_discussions:name'] = 'Navnet på diskusjon, valgt av forfatteren.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Tidspunktet diskusjonen sist ble endret.';
$string['privacy:metadata:forum_discussions:userid'] = 'ID\'en til brukeren som opprettet diskusjonen.';
$string['privacy:metadata:forum_discussions:usermodified'] = 'ID\'en til brukeren som sist endret diskusjon på en eller annen måte.';
$string['privacy:metadata:forum_grades'] = 'Vurderingsdata fra forumet';
$string['privacy:metadata:forum_grades:forum'] = 'Forumet som ble vurdert';
$string['privacy:metadata:forum_grades:grade'] = 'Vurderingen';
$string['privacy:metadata:forum_grades:userid'] = 'Brukeren som ble vurdert';
$string['privacy:metadata:forum_posts'] = 'Informasjon om samleepostvalgene for hvert enkelt forum.';
$string['privacy:metadata:forum_posts:created'] = 'Når innlegget ble opprettet.';
$string['privacy:metadata:forum_posts:discussion'] = 'Diskusjonen innlegget er en del av.';
$string['privacy:metadata:forum_posts:message'] = 'Innholdet i foruminnlegget.';
$string['privacy:metadata:forum_posts:modified'] = 'Når innlegget ble endret.';
$string['privacy:metadata:forum_posts:parent'] = 'Innlegget som det ble svart på.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'BrukerIDen dette svaret ble sendt til.';
$string['privacy:metadata:forum_posts:subject'] = 'Foruminnleggets emne.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Foruminnleggets innhold.';
$string['privacy:metadata:forum_posts:userid'] = 'ID\'en til brukeren som skrev foruminnlegget.';
$string['privacy:metadata:forum_queue'] = 'Midlertidig logg med innlegg som skal sendes ut som samepost';
$string['privacy:metadata:forum_queue:discussionid'] = 'ForumdiskusjonsID';
$string['privacy:metadata:forum_queue:postid'] = 'ForuminnleggsID';
$string['privacy:metadata:forum_queue:timemodified'] = 'Endringstidspunkt for det opprinnelige innlegget';
$string['privacy:metadata:forum_queue:userid'] = 'Bruker som skal varsles om innlegget';
$string['privacy:metadata:forum_read'] = 'Informasjon om hvilke innlegg som har blitt lest av brukeren.';
$string['privacy:metadata:forum_read:discussionid'] = 'Diskusjonen innlegget er en del av.';
$string['privacy:metadata:forum_read:firstread'] = 'Første gangen innlegget ble lest.';
$string['privacy:metadata:forum_read:lastread'] = 'Siste gangen innlegget ble lest.';
$string['privacy:metadata:forum_read:postid'] = 'Innlegget som ble lest';
$string['privacy:metadata:forum_read:userid'] = 'ID\'en til brukeren som denne oppføringen er relatert til.';
$string['privacy:metadata:forum_subscriptions'] = 'Informasjon om hvilke forum brukeren abonnerer på.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Forumet som det ble opprettet abonnement på.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'ID\'en til brukeren som forumabonnementet er relatert til.';
$string['privacy:metadata:forum_track_prefs'] = 'Informasjon om hvilke forum brukeren har valgt å aktivere sporing i.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Forumet som har sporing aktivert.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'ID\'en til brukeren som denne forumsporingspreferansen er relatert til.';
$string['privacy:metadata:preference:autosubscribe'] = 'Om det skal abonneres på diskusjoner ved svar på innlegg i diskusjonen.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'Foretrukket sortering av diskusjonslisten';
$string['privacy:metadata:preference:maildigest'] = 'Portalens standardvalg for samleepost.';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Om foruminnlegg skal markeres som lest når de mottas som melding.';
$string['privacy:metadata:preference:trackforums'] = 'Om sporing skal aktiveres.';
$string['privacy:postwasread'] = 'Dette innlegget ble først lest {$a->firstdate} og sist lest {$a->lastread}.';
$string['privacy:readtrackingdisabled'] = 'Du har valgt å ikke spore hvilke innlegg du har lest i dette forumet.';
$string['privacy:request:delete:discussion:name'] = 'Slett på forespørsel fra forfatteren.';
$string['privacy:request:delete:post:message'] = 'Innholdet i dette foruminnlegget har blitt slettet etter forespørsel fra forfatteren.';
$string['privacy:request:delete:post:subject'] = 'Slett etter forespørsel fra forfatteren.';
$string['privacy:subscribedtoforum'] = 'Du abonnerer på dette forumet.';
$string['privatereply'] = 'Privat svar';
$string['privatereply_help'] = 'Når du svarer privat, er innlegget ditt også synlig for brukere med mulighet til å se private svar, for eksempel lærere.';
$string['processingdigest'] = 'Prosesserer samleepost for bruker {$a}';
$string['processingpost'] = 'Behandler innlegg {$a}';
$string['prune'] = 'Splitt';
$string['prunediscussion'] = 'Splitt diskusjonen';
$string['prunedpost'] = 'Startet ny diskusjon med innlegget';
$string['pruneheading'] = 'Splitt diskusjonen og flytt dette innlegget til en ny diskusjon.';
$string['qandaforum'] = 'Spørsmål og svar forum';
$string['qandanotify'] = 'Dette er et spørsmål og svar forum. For å kunne se andres svar på disse spørsmålene, må du først poste ditt eget svar.';
$string['re'] = 'Svar:';
$string['readtherest'] = 'Les resten av dette emnet';
$string['removeallforumtags'] = 'Fjern alle forumtagger';
$string['removefromfavourites'] = 'Fjern favorittmerking for denne diskusjonen';
$string['replies'] = 'Svar';
$string['repliesmany'] = '{$a} svar til nå';
$string['repliesone'] = '{$a} svar til nå';
$string['reply'] = 'Svar';
$string['reply_handler'] = 'Svar på foruminnlegg via epost';
$string['reply_handler_name'] = 'Svar på foruminnlegg';
$string['replyauthorself'] = '{$a} (deg)';
$string['replyforum'] = 'Svar i forumet';
$string['replyingtoauthor'] = 'Svarer {$a}...';
$string['replyplaceholder'] = 'Skriv ditt svar...';
$string['replypostdiscussion'] = 'Svar til diskusjonen';
$string['replytopostbyemail'] = 'Du kan svare via epost.';
$string['replytouser'] = 'Bruk e-postadresse i svar';
$string['resetdigests'] = 'Slett alle brukernes preferanser for sammendrag av foruminnlegg';
$string['resetforums'] = 'Slett innlegg fra';
$string['resetforumsall'] = 'Slett alle poster';
$string['resetsubscriptions'] = 'Slett alle forumabonnement';
$string['resettrackprefs'] = 'Slett alle sporingspreferanser i forum';
$string['rssarticles'] = 'Antall nylige RSS-artiker';
$string['rssarticles_help'] = '<p>Dette valget lar deg velge hvor mange innlegg som skal tas med i RSS-sendingen.</p> <p>Et antall mellom 5 og 20 kan være passende for de fleste forum. Øk antallet dersom forumet er mye brukt.</p>';
$string['rsssubscriberssdiscussions'] = 'RSS-mating av diskusjoner';
$string['rsssubscriberssposts'] = 'RSS-mating av innlegg';
$string['rsstype'] = 'RSS-mating av denne aktiviteten';
$string['rsstype_help'] = '<p>Dette valget lar deg aktivere RSS-utsending fra dette forumet.</p> <p>Du kan velge mellom to typer forum:</p> <ul> <li><b>Diskusjoner:</b> Ved å bruke denne vil RSS-utsendingene ta med nye diskusjoner i forumet, inkludert innledende innlegg.</li> <li><b>Innlegg:</b> Ved å bruke denne vil RSS-utsendingen ta med alle nye innlegg i forumet.</li> </ul>';
$string['rsstypedefault'] = 'Type RSS-feed';
$string['search'] = 'Søk';
$string['search:activity'] = 'Forum - aktivitetsinformasjon';
$string['search:post'] = 'Forum - innlegg';
$string['searchdatefrom'] = 'Innlegg må være nyere enn dette';
$string['searchdateto'] = 'Innlegg må være eldre enn dette';
$string['searchforumintro'] = 'Vær vennlig å skrive inn søketermer i en eller flere av de påfølgende felt';
$string['searchforums'] = 'Søk i fora';
$string['searchfullwords'] = 'Disse ord skal vises som hele ord';
$string['searchnotwords'] = 'Disse ord skal IKKE inkluderes';
$string['searcholderposts'] = 'Søk i eldre innlegg';
$string['searchphrase'] = 'Nøyaktig denne frase må finnes i innlegget';
$string['searchresults'] = 'Søkeresultater';
$string['searchsubject'] = 'Disse ordene skal finnes i tittel';
$string['searchtags'] = 'Er tagget med';
$string['searchuser'] = 'Dette navnet skal være likt forfatter';
$string['searchuserid'] = 'Moodle ID til forfatter';
$string['searchusers'] = 'Søk etter brukere';
$string['searchwhichforums'] = 'Velg hvilket forum du vil søke i';
$string['searchwords'] = 'Disse ordene kan forekomme hvor som helst i innlegget';
$string['seeallposts'] = 'Se alle innlegg skrevet av denne brukeren';
$string['sendstudentnotificationsdefault'] = 'Standardinnstilling for "Varsle studenter"';
$string['sendstudentnotificationsdefault_help'] = 'Bestemmer standardverdien for avkrysningsboksen "Varsle studenter" på vurderingsskjemaet.';
$string['sendstudentnotificationsno'] = 'Nei';
$string['sendstudentnotificationsyes'] = 'Ja, send varsel til student';
$string['settings'] = 'Innstillinger';
$string['shortpost'] = 'Kort innlegg';
$string['showgraderpanel'] = 'Vis vurderingspanel';
$string['showingcountoftotaldiscussions'] = 'Viser {$a->count} av {$a->total} diskusjoner';
$string['showmoreusers'] = 'Vis flere brukere';
$string['showpreviousrepliescount'] = 'Vis tidligere svar ($a)';
$string['showsubscribers'] = 'Vis abonnenter til dette forumet';
$string['showusersearch'] = 'Vis brukersøk';
$string['singleforum'] = 'En enkel diskusjon';
$string['smallmessage'] = '{$a->user} postet i {$a->forumname}';
$string['smallmessagedigest'] = 'Samleposten fra forum inneholder {$a} innlegg';
$string['starredonly'] = 'Søk kun i favorittmerkede diskusjoner';
$string['startedby'] = 'Startet av';
$string['subject'] = 'Emne';
$string['subplugintype_forumreport'] = 'Forumrapport';
$string['subplugintype_forumreport_plural'] = 'Forumrapporter';
$string['subscribe'] = 'Abonner på dette forumet';
$string['subscribeall'] = 'Meld alle på som abonnenter til dette forumet';
$string['subscribed'] = 'Abonnere';
$string['subscribediscussion'] = 'Abonner på denne diskusjonen';
$string['subscribeenrolledonly'] = 'Beklager, men bare påmeldte brukere kan abonnere og få foruminnlegg tilsendt via e-post.';
$string['subscribenone'] = 'Slett alle abonnement på dette forumet';
$string['subscribers'] = 'Abonnenter';
$string['subscriberstowithcount'] = 'Abonnenter på "{$a->name}" ({$a->count})';
$string['subscribestart'] = 'Jeg vil gjerne ha varsling om nye innlegg i dette forumet';
$string['subscribestop'] = 'Jeg ønsker ikke varsling om nye innlegg i dette forumet';
$string['subscription'] = 'Abonnement';
$string['subscription_help'] = 'Når du abonnerer på et forum, vil du motta kopier av innlegg skrevet i det på e-post. Vanligvis kan du selv velge om du ønsker å abonnere på et forum, men noen ganger er et slikt abonnement tvunget slik at alle mottar kopier av innlegg.';
$string['subscriptionandtracking'] = 'Abonnement og sporing';
$string['subscriptionauto'] = 'Autoabonnere';
$string['subscriptiondisabled'] = 'Abonnering avslått';
$string['subscriptionforced'] = 'Tvunget abonnement';
$string['subscriptionmode'] = 'Abonnementsmodus';
$string['subscriptionmode_help'] = 'Når en en bruker er abonnent på et forum betyr dette at de vil få varslinger om nye foruminnlegg. Det er 4 ulike abonnementsinnstliinger for forum:

* Valgfri - Deltakere kan selv velge om de vil abonnere eller ikke
* Tvunget - Alle må abonnere på forumet og ingen kan avslutte abonnementet sitt
* Automatisk - Alle abonnerer i utgangspunktet på forum, men deltakerne kan velge om de vil avslutte abonnementet
* Deaktivert - Ingen kan abonnere på foruminnlegg';
$string['subscriptionmodeconfirm'] = 'Er du sikker på at du vil endre abonnementsmodus til {$a}?';
$string['subscriptionoptional'] = 'Valgfritt abonnement';
$string['subscriptions'] = 'Abonnenter';
$string['tagarea_forum_posts'] = 'Foruminnlegg';
$string['tagsdeleted'] = 'Forumtagger har blitt fjernet';
$string['thisforumhasduedate'] = 'Fristen for å skrive innlegg i dette forumet er {$a}.';
$string['thisforumisdue'] = 'Fristen for å skrive innlegg i dette forumet var {$a}.';
$string['thisforumisthrottled'] = 'Dette forum har en begrensning på antall innlegg du kan skrive i en gitt tidsperiode - dette er nå satt til {$a->blockafter} innlegg på {$a->blockperiod}';
$string['timed'] = 'Tidsbestemt';
$string['timeddiscussion'] = 'Tidsbestemt diskusjon';
$string['timedhidden'] = 'Tidsinnstilling: Skjult for studenter';
$string['timedposts'] = 'Tidsstyrte innlegg';
$string['timedvisible'] = 'Tidsinnstilling: Synlig for alle';
$string['timestartenderror'] = 'Sluttdato for visning kan ikke være tidligere enn startdato';
$string['togglediscussionmenu'] = 'Slå på/av diskusjonsmenyen';
$string['togglefullscreen'] = 'Aktiver fullskjerm';
$string['togglesettingsdrawer'] = 'Vis/skjul innstillingsskuffen';
$string['trackforum'] = 'Spor uleste meldinger';
$string['tracking'] = 'Spor';
$string['trackingoff'] = 'Av';
$string['trackingon'] = 'Tvungent';
$string['trackingoptional'] = 'Valgfritt';
$string['trackingtype'] = 'Les sporing for dette forum?';
$string['trackingtype_help'] = 'Sporing lar deltakerne enkelt se hvilke innlegg de ikke har lest ved å markere alle uleste innlegg.

Hvis satt til "Valgfritt" kan deltakerne selv velge å slå sporing av eller på via en lenke i administrasjonsblokka (Brukere må også aktivere sporing i deres forumpreferanser)

 Dersom "Tillat tvungen sporing" er aktivert på portalen, er det også mulig å tvinge sporing. Da vil sporing alltid være på, også for de som har deaktivert sporing i forumpreferansene sine.';
$string['trackreadposts_header'] = 'Forumsporing';
$string['unlockdiscussion'] = 'Åpne denne diskusjonen';
$string['unpindiscussion'] = 'Fjern festing av denne diskusjonen';
$string['unread'] = 'Ulest';
$string['unreadpost'] = 'Ulest innlegg';
$string['unreadposts'] = 'Uleste innlegg';
$string['unreadpostsnumber'] = '{$a} uleste innlegg';
$string['unreadpostsone'] = '1 ulest innlegg';
$string['unsubscribe'] = 'Avmeld abonnement på forum';
$string['unsubscribeall'] = 'Si opp abonnementet på alle forum';
$string['unsubscribeallconfirm'] = 'Du er for tiden abonnent på {$a->forums} forum og {$a->discussions} diskusjoner.. Ønsker du virkelig å si opp abonnementet på alle forum og diskusjoner og deaktivere auto-abonnering?';
$string['unsubscribeallconfirmdiscussions'] = 'For tiden abonnerer du på {$a->discussions} diskusjoner. Ønsker du virkelig å avslutte alle disse abonnementene og å deaktivere automoatisk abonnering?';
$string['unsubscribeallconfirmforums'] = 'For tiden abonnerer du på {$a->forums} forum . Ønsker du virkelig å avslutte alle disse abonnementene og å deaktivere automatisk abonnering?';
$string['unsubscribealldone'] = 'Alle valgfrie forumabonnementer er nå sagt opp. Du kommer fortsatt til å motta meldinger fra forum med tvungne abonnement. For å administrere forummeldinger, gå til Meldinger i Min profil-innstillingene.';
$string['unsubscribeallempty'] = 'Du er ikke abonnent på noen forum. Dersom du ikke ønsker å motta noe e-post fra denne serveren, ber vi deg gå til Meldinger i Min profil-innstillingene.';
$string['unsubscribed'] = 'Ikke abonnent';
$string['unsubscribediscussion'] = 'Avslutt abonnementet på denne diskusjonen';
$string['unsubscribediscussionlink'] = 'Avslutt abonnementet på denne diskusjonen: {$a}';
$string['unsubscribelink'] = 'Avslutt abonnementet på dette forumet: {$a}';
$string['unsubscribeshort'] = 'Avslutt abonnement';
$string['useexperimentalui'] = 'Bruk nøstet diskusjonsvisning';
$string['usermarksread'] = 'Manuell merking av "Lest"';
$string['usernavigation'] = 'Brukernavigering';
$string['usersforumposts'] = 'Brukers foruminnlegg';
$string['viewalldiscussions'] = 'Se alle diskusjoner';
$string['viewconversation'] = 'Vis diskusjon';
$string['viewgrades'] = 'Vis vurderinger';
$string['viewparentpost'] = 'Vis overordnet innlegg';
$string['viewthediscussion'] = 'Vis diskusjonen';
$string['warnafter'] = 'Innleggsgrense for å få advarsel';
$string['warnafter_help'] = 'Konseptet for administrasjon av foruminnlegg er meget enkelt. Brukere vil bli hindret i å poste flere innlegg etter et gitt antall innlegg i en angitt periode. Straks de nærmer seg dette antallet vil de bli varslet om at de er i ferd med å nå sperregrensen for flere innlegg i den angitte perioden. Dersom du setter varslingsgrensen til 0 vil advarsler kobles ut. Med en blokkeringsgrense på 0 vil muligheten for blokkering av nye innlegg slås av. Hvis blokkering er deaktivert vil også advarsler automatisk bli slått av. <p>Ingen av disse innstillingene har betydning for lærerens posting av innlegg. </p>';
$string['warnformorepost'] = 'Advarsel: Det er mer enn en diskusjon i dette forumet. Bruk den nyeste av dem.';
$string['yournewquestion'] = 'Ditt nye spørsmål';
$string['yournewtopic'] = 'Ditt nye diskusjonsemne';
$string['yourreply'] = 'Ditt svar';
