<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'certificate', language 'el', version '4.1'.
 *
 * @package     certificate
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addlinklabel'] = 'Προσθήκη μιας ακόμη επιλογής συνδεδεμένης δραστηριότητας';
$string['addlinktitle'] = 'Κάντε κλικ για προσθήκη κι άλλης επιλογής συνδεδεμένης δραστηριότητας';
$string['areaintro'] = 'Εισαγωγή πιστοποιητικού';
$string['awarded'] = 'Απονεμήθηκε';
$string['awardedto'] = 'Απονεμήθηκε σε';
$string['back'] = 'Πίσω';
$string['border'] = 'Περίγραμμα';
$string['borderblack'] = 'Μαύρο';
$string['borderblue'] = 'Μπλε';
$string['borderbrown'] = 'Καφέ';
$string['bordercolor'] = 'Γραμμές περιγράμματος';
$string['bordergreen'] = 'Πράσινο';
$string['borderlines'] = 'Γραμμές';
$string['borderstyle'] = 'Εικόνα περιγράμματος';
$string['certificate'] = 'Επαλήθευση κωδικού πιστοποιητικού:';
$string['certificate:addinstance'] = 'Προσθήκη ενός στιγμιοτύπου πιστοποιητικού';
$string['certificate:manage'] = 'Διαχείριση ενός στιγμιοτύπου πιστοποιητικού';
$string['certificate:printteacher'] = 'Εκτύπωση διδάσκοντος';
$string['certificate:student'] = 'Ανάκτηση ενός πιστοποιητικού';
$string['certificate:view'] = 'Εμφάνιση ενός πιστοποιητικού';
$string['certificatename'] = 'Όνομα πιστοποιητικού';
$string['certificatereport'] = 'Αναφορά πιστοποιητικών';
$string['certificatesfor'] = 'Πιστοποιητικά για';
$string['certificatetype'] = 'Τύπος πιστοποιητικού';
$string['certificatetype_help'] = 'Εδώ καθορίζεται τη διάταξη του πιστοποιητικού. Ο φάκελος τύπου πιστοποιητικού περιλαμβάνει τέσσερα προεπιλεγμένα πιστοποιητικά:
Το A4 Embedded εκτυπώνει σε χαρτί μεγέθους A4 με ενσωματωμένη γραμματοσειρά.
Το A4 Non-Embedded εκτυπώνεται σε χαρτί μεγέθους A4 χωρίς ενσωματωμένες γραμματοσειρές.
Το Letter Embedded εκτυπώνει σε χαρτί μεγέθους γράμματος με ενσωματωμένη γραμματοσειρά.
Το Letter Non-Embedded εκτυπώνει σε χαρτί μεγέθους γράμματος χωρίς ενσωματωμένες γραμματοσειρές.

Οι μη ενσωματωμένοι τύποι χρησιμοποιούν τις γραμματοσειρές Helvetica και Times. Αν θεωρείτε ότι οι χρήστες σας δεν θα έχουν αυτές τις γραμματοσειρές στον υπολογιστή τους ή αν η γλώσσα σας χρησιμοποιεί χαρακτήρες ή σύμβολα που δεν περιλαμβάνονται στις γραμματοσειρές Helvetica και Times, τότε επιλέξτε έναν ενσωματωμένο τύπο. Οι ενσωματωμένοι τύποι χρησιμοποιούν τις γραμματοσειρές Dejavusans και Dejavuserif. Αυτό θα παράγει σχετικά μεγάλα αρχεία pdf, επομένως δεν συνιστάται η χρήση ενός ενσωματωμένου τύπου, εκτός αν πρέπει.

Μπορείτε να προσθέσετε νέους φακέλους τύπου στον φάκελο certificate/type (πιστοποιητικό/τύπος). Το όνομα του φακέλου και τα νέα αλφαριθμητικά γλωσσάς για τον νέο τύπο θα πρέπει να προστεθούν στο αρχείο γλώσσας πιστοποιητικού.';
$string['certify'] = 'Πιστοποιείται ότι';
$string['code'] = 'Κωδικός';
$string['completiondate'] = 'Ολοκλήρωση μαθήματος';
$string['course'] = 'Για';
$string['coursegrade'] = 'Βαθμός μαθήματος';
$string['coursename'] = 'Μάθημα';
$string['coursetimereq'] = 'Απαιτούμενα λεπτά στο μάθημα';
$string['coursetimereq_help'] = 'Δώστε εδώ τον ελάχιστο χρόνο, σε λεπτά, που ένας μαθητής πρέπει να είναι συνδεδεμένος στο μάθημα, για να είναι δυνατόν να λάβει την πιστοποίηση.';
$string['credithours'] = 'Ώρες πίστωσης';
$string['customtext'] = 'Προσαρμοσμένο κείμενο';
$string['date'] = 'Στις';
$string['datefmt'] = 'Μορφότυπος ημερομηνίας';
$string['datefmt_help'] = 'Επιλέξτε έναν μορφότυπο ημερομηνίας για να εκτυπώσετε την ημερομηνία στο πιστοποιητικό. Ή, επιλέξτε την τελευταία επιλογή για να τυπωθεί η ημερομηνία στον μορφότυπο της γλώσσας επιλογής του χρήστη.';
$string['datehelp'] = 'Ημερομηνία';
$string['deletissuedcertificates'] = 'Διαγραφή πιστοποιητικών που έχουν εκδοθεί';
$string['delivery'] = 'Παράδοση';
$string['delivery_help'] = 'Επιλέξτε εδώ πώς θέλετε οι μαθητές να λάβουν το πιστοποιητικό τους.
<ul>
<li>Άνοιγμα στον περιηγητή: Το πιστοποιητικό ανοίγει σε ένα νέο παράθυρο του περιηγητή.</li>
<li>Επιβολή λήψης: Ανοίγει το παράθυρο λήψης αρχείων του περιηγητή./li>
<li>Αποστολή πιστοποιητικού μέσω ηλε.ταχυδρομείου: Γίνεται αποστολή του πιστοποιητικού στον μαθητή ως συνημμένο ηλε.ταχυδρομείου.
Αφού ένας χρήστης λάβει το πιστοποιητικό του, αν πατήσει στο σύνδεσμο του πιστοποιητικού από την αρχική σελίδα του μαθήματος, θα δει την ημερομηνία που έλαβε το πιστοποιητικό και θα μπορεί να ελέγξει το πιστοποιητικό που έλαβε.</li>
</ul>';
$string['designoptions'] = 'Επιλογές σχεδίασης';
$string['download'] = 'Επιβολή λήψης';
$string['emailcertificate'] = 'Μήνυμα ηλε.ταχυδρομείου';
$string['emailothers'] = 'Αποστολή μηνύματος ηλε.ταχυδρομείου στους άλλους';
$string['emailothers_help'] = 'Δώστε τις διευθύνσεις ηλε.ταχυδρομείου εδώ, με διαχωριστικό το κόμμα, αυτών που πρέπει να ειδοποιούνται συναγερμικά με μήνυμα, οποτεδήποτε κάποιος μαθητής λαμβάνει ένα πιστοποιητικό.';
$string['emailstudenttext'] = 'Συνημμένα υπάρχει το πιστοποιητικό σας για το μάθημα «{$a->course}».';
$string['emailteachermail'] = 'Ο/Η {$a->student} έχει λάβει το πιστοποιητικό του/της: «{$a->certificate}»
για {$a->course}.

Μπορείτε να το εξετάσετε εδώ:

    {$a->url}';
$string['emailteachermailhtml'] = 'Ο/Η {$a->student} έχει λάβει το πιστοποιητικό του/της: «<i>{$a->certificate}</i>»
για {$a->course}.

Μπορείτε να το εξετάσετε εδώ:

    <a href="{$a->url}">Αναφορά πιστοποιητικού</a>.';
$string['emailteachers'] = 'Αποστολή μηνύματος ηλε.ταχυδρομείου στους διδάσκοντες';
$string['emailteachers_help'] = 'Αν ενεργοποιηθεί, τότε οι διδάσκοντες θα ειδοποιούνται με ένα μήνυμα ηλε.ταχυδρομείου οποτεδήποτε οι μαθητές λαμβάνουν ένα πιστοποιητικό.';
$string['entercode'] = 'Δώστε κωδικό πιστοποιητικού για επαλήθευση:';
$string['fontsans'] = 'Οικογένεια γραμματοσειρών Sans-serif';
$string['fontserif'] = 'Οικογένεια γραμματοσειρών Serif';
$string['getcertificate'] = 'Λάβετε το πιστοποιητικό σας';
$string['grade'] = 'Βαθμός';
$string['gradedate'] = 'Ημερομηνία βαθμού';
$string['gradefmt'] = 'Μορφότυπος βαθμού';
$string['gradefmt_help'] = 'Υπάρχουν 3 διαθέσιμοι μορφότυποι αν επιλέξετε να τυπώσετε ένα βαθμό στο πιστοποιητικό:

Βαθμός ποσοστού: Τυπώνει τον βαθμό ως ένα ποσοστό.
Βαθμός πόντων: Τυπώνει την τιμή των πόντων του βαθμού.
Βαθμός με γράμμα: Τυπώνει τον βαθμό ποσοστού ως ένα γράμμα.';
$string['gradeletter'] = 'Βαθμός με γράμμα';
$string['gradepercent'] = 'Βαθμός με ποσοστό';
$string['gradepoints'] = 'Βαθμός με πόντους';
$string['imagetype'] = 'Τύπος εικόνας';
$string['incompletemessage'] = 'Για να κατεβάσετε το πιστοποιητικό σας, πρέπει πρώτα να ολοκληρώσετε όλες τις απαιτούμενες δραστηριότητες. Παρακαλούμε, επιστρέψτε στο μάθημα και ολοκληρώστε τις εργασίες του μαθήματος.';
$string['intro'] = 'Εισαγωγή';
$string['issued'] = 'Εκδόθηκε';
$string['issueddate'] = 'Ημερομηνία έκδοσης';
$string['issueoptions'] = 'Επιλογές έκδοσης';
$string['landscape'] = 'Οριζόντια';
$string['lastviewed'] = 'Τελευταία φορά λάβατε αυτό το πιστοποιητικό στις:';
$string['letter'] = 'Γράμμα';
$string['lockingoptions'] = 'Επιλογές κλειδώματος';
$string['modulename'] = 'Πιστοποιητικό';
$string['modulename_help'] = 'Το άρθρωμα αυτό επιτρέπει την δυναμική δημιουργία πιστοποιητικών με βάση προκαθορισμένες συνθήκες που ορίζονται από τον διδάσκοντα.';
$string['modulename_link'] = '';
$string['modulenameplural'] = 'Πιστοποιητικά';
$string['mycertificates'] = 'Τα πιστοποιητικά μου';
$string['nocertificates'] = 'Δεν υπάρχουν καθόλου πιστοποιητικά';
$string['nocertificatesissued'] = 'Δεν υπάρχουν καθόλου πιστοποιητικά που να έχουν εκδοθεί';
$string['nocertificatesreceived'] = 'δεν έχει λάβει κανένα πιστοποιητικό μαθήματος.';
$string['nofileselected'] = 'Πρέπει να επιλεγεί ένα αρχείο για ανέβασμα!';
$string['nogrades'] = 'Καθόλου βαθμοί διαθέσιμοι';
$string['notapplicable'] = 'Δ/Υ';
$string['notfound'] = 'Ο αριθμός πιστοποιητικού δεν μπόρεσε να επικυρωθεί.';
$string['notissued'] = 'Μη εκδοθέν';
$string['notissuedyet'] = 'Μη εκδοθέν ακόμη';
$string['notreceived'] = 'Δεν λάβατε αυτό το πιστοποιητικό';
$string['openbrowser'] = 'Άνοιγμα σε νέο παράθυρο';
$string['opendownload'] = 'Πατήστε το πλήκτρο παρακάτω για να αποθηκευτεί το πιστοποιητικό σας στον υπολογιστή σας.';
$string['openemail'] = 'Πατήστε στο παρακάτω πλήκτρο και το πιστοποιητικό σας θα σας αποσταλεί ως συνημμένο ηλε.ταχυδρομείου.';
$string['openwindow'] = 'Πατήστε το πλήκτρο παρακάτω για να ανοίξει το πιστοποιητικό σας σε ένα νέο παράθυρο περιηγητή.';
$string['or'] = 'Ή';
$string['orientation'] = 'Προσανατολισμός';
$string['orientation_help'] = 'Επιλέξτε εάν θέλετε τον προσανατολισμό του πιστοποιητικού σας κατακόρυφο ή οριζόντιο.';
$string['pluginadministration'] = 'Διαχείριση πιστοποιητικών';
$string['pluginname'] = 'Πιστοποιητικό';
$string['portrait'] = 'Κατακόρυφος';
$string['printdate'] = 'Ημερομηνία προς εκτύπωση';
$string['printerfriendly'] = 'Έκδοση σελίδας φιλική για εκτύπωση';
$string['printgrade'] = 'Βαθμός προς εκτύπωση';
$string['printhours'] = 'Ώρες που πιστώνονται προς εκτύπωση';
$string['printhours_help'] = 'Εισάγετε εδώ τον αριθμό των ωρών που πιστώνονται (πιστωτικές μονάδες) που θα εκτυπωθεί στο πιστοποιητικό.';
$string['printnumber'] = 'Κωδικός προς εκτύπωση';
$string['printoutcome'] = 'Εκτύπωση μαθησιακών αποτελεσμάτων';
$string['printoutcome_help'] = 'Μπορείτε να επιλέξετε οποιοδήποτε μαθησιακό αποτέλεσμα προς εκτύπωση για να τυπωθούν το όνομα και το αποτέλεσμα στο πιστοποιητικό. Ένα παράδειγμα μπορεί να είναι: Μαθησιακό αποτέλεσμα εργασίας: Επαρκής.';
$string['printseal'] = 'Εικόνα σφραγίδας ή λογότυπου';
$string['printseal_help'] = 'Αυτή η επιλογή σάς επιτρέπει να επιλέξετε μια σφραγίδα ή λογότυπο για να τυπωθεί στο πιστοποιητικό, από το φάκελο «certificate/pix/seals». Από προεπιλογή, αυτή η εικόνα τοποθετείται στην κάτω δεξιά γωνία του πιστοποιητικού.';
$string['printsignature'] = 'Εικόνα υπογραφής';
$string['printsignature_help'] = 'Αυτή η επιλογή σάς επιτρέπει να τυπώσετε μια εικόνα υπογραφής από το φάκελο «certificate/pix/seals». Μπορείτε να τυπώσετε μια γραφική αναπαράσταση μιας υπογραφής, ή να τυπώσετε μια κενή γραμμή για μια χειρόγραφη υπογραφή. Από προεπιλογή, αυτή η εικόνα τοποθετείται στο κάτω αριστερό μέρος του πιστοποιητικού.';
$string['printteacher'] = 'Όνομα/Ονόματα διδάσκοντος/-όντων προς εκτύπωση';
$string['printwmark'] = 'Εικόνα υδατογραφήματος';
$string['printwmark_help'] = 'Ένα αρχείο υδατογραφήματος μπορεί να τοποθετηθεί στο υπόβαθρο του πιστοποιητικού. Το υδατογράφημα είναι ένα αχνό γραφικό. Ένα υδατογράφημα θα μπορούσε να είναι ένα λογότυπο, μια σφραγίδα, ένα οικόσημο, μια φράση, ή οτιδήποτε θέλετε να χρησιμοποιήσετε ως ένα γραφικό υπόβαθρου.';
$string['receivedcerts'] = 'Ληφθέντα πιστοποιητικά';
$string['receiveddate'] = 'Ημερομηνία παραλαβής';
$string['reissuecert'] = 'Επανέκδοση πιστοποιητικών';
$string['reissuecert_help'] = 'Εάν επιλέξετε ναι εδώ, τότε αυτό το πιστοποιητικό θα επανεκδοθεί με μια νέα ημερομηνία, βαθμό και κωδικό αριθμό κάθε φορά που ένας χρήστης κάνει κλικ στο σύνδεσμο πιστοποιητικού. Σημείωση: Παρόλο που ένας πίνακας θα εμφανίζει τις προηγούμενες ημερομηνίες λήψης από τον χρήστη, δεν θα υπάρχει διαθέσιμο κουμπί ελέγχου για τους χρήστες. Μόνο το τελευταίο πιστοποιητικό που εκδόθηκε θα εμφανίζεται στην αναφορά πιστοποιητικών.';
$string['removecert'] = 'Τα εκδοθέντα πιστοποιητικά αφαιρέθηκαν';
$string['report'] = 'Αναφορά';
$string['reportcert'] = 'Αναφορά πιστοποιητικών';
$string['reportcert_help'] = 'Εάν επιλέξετε ναι εδώ, τότε η ημερομηνία λήψης αυτού του πιστοποιητικού, ο κωδικός αριθμός και το όνομα του μαθήματος θα εμφανίζονται στις αναφορές πιστοποιητικών χρήστη. Εάν επιλέξετε να εκτυπώσετε έναν βαθμό σε αυτό το πιστοποιητικό, τότε αυτός ο βαθμός θα εμφανίζεται επίσης στην αναφορά πιστοποιητικού.';
$string['requiredtimenotmet'] = 'Πρέπει να περάσετε τουλάχιστον {$a->requiredtime} λεπτά στο μάθημα για να αποκτήσετε πρόσβαση σε αυτό το πιστοποιητικό';
$string['requiredtimenotvalid'] = 'Ο απαιτούμενος χρόνος πρέπει να είναι έγκυρος αριθμός μεγαλύτερος από 0';
$string['reviewcertificate'] = 'Εξετάστε το πιστοποιητικό σας';
$string['savecert'] = 'Αποθήκευση πιστοποιητικών';
$string['seal'] = 'Σφραγίδα';
$string['sigline'] = 'γραμμή';
$string['signature'] = 'Υπογραφή';
$string['statement'] = 'έχει ολοκληρώσει το μάθημα';
$string['summaryofattempts'] = 'Περίληψη των προηγουμένως ληφθέντων πιστοποιητικών';
$string['textoptions'] = 'Επιλογές κειμένου';
$string['title'] = 'ΠΙΣΤΟΠΟΙΗΤΙΚΌ ΕΠΙΤΥΧΙΑΣ';
$string['to'] = 'Απονέμεται στον/στην';
$string['typeA4_embedded'] = 'A4 ενσωματωμένο';
$string['typeA4_non_embedded'] = 'Α4 μη ενσωματωμένο';
$string['typeletter_embedded'] = 'Γράμμα ενσωματωμένο';
$string['typeletter_non_embedded'] = 'Γράμμα μη ενσωματωμένο';
$string['unsupportedfiletype'] = 'Το αρχείο πρέπει να είναι μορφότυπου jpeg ή png';
$string['uploadimage'] = 'Ανέβασμα εικόνας';
$string['uploadimagedesc'] = 'Αυτό το κουμπί οδηγεί σε μια νέα οθόνη όπου μπορούν να ανεβούν εικόνες.';
$string['userdateformat'] = 'Μορφότυπος ημερομηνίας γλώσσας χρήστη';
$string['validate'] = 'Επαλήθευση';
$string['verifycertificate'] = 'Επαλήθευση πιστοποιητικού';
$string['viewcertificateviews'] = 'Εμφάνιση {$a} εκδοθέντων πιστοποιητικών';
$string['viewed'] = 'Λάβατε αυτό το πιστοποιητικό στις:';
$string['viewtranscript'] = 'Εμφάνιση πιστοποιητικών';
$string['watermark'] = 'Υδατογράφημα';
