<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'sk', version '4.0'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Pridať novú rolu';
$string['addrole'] = 'Pridať novú rolu';
$string['advancedoverride'] = 'Pokročilé prepísanie roly';
$string['allow'] = 'Povoliť';
$string['allowassign'] = 'Povoliť priradenia rol';
$string['allowed'] = 'Povolené';
$string['allowoverride'] = 'Povoliť prepísanie rol';
$string['allowroletoassign'] = 'Povoliť používateľom s rolou {$a->fromrole} priradiť rolu {$a->targetrole}';
$string['allowroletooverride'] = 'Povoliť používateľom z rolou {$a->fromrole} prepísať rolu {$a->targetrole}';
$string['allowroletoswitch'] = 'Povoliť používateľom z rolou {$a->fromrole} sa prepnúť do roly {$a->targetrole}';
$string['allowroletoview'] = 'Povoliť používateľom s rolou {$a->fromrole} zobrazenie role {$a->targetrole}';
$string['allowswitch'] = 'Povoliť prepnutie rol';
$string['allowview'] = 'Povoliť role pre zobrazenie';
$string['allsiteusers'] = 'Všetci používatelia na portáli';
$string['analytics:listinsights'] = 'Zoznam poznatkov';
$string['analytics:listowninsights'] = 'Zoznam vlastných poznatkov';
$string['analytics:managemodels'] = 'Spravovať modely';
$string['archetype'] = 'Originál roly';
$string['archetype_help'] = 'Originál roly určuje oprávnenia, ktoré budú nastavené, ak je rola vrátená do pôvodného stavu. Tiež určuje nové oprávnenia v role, keď je portál aktualizovaný.';
$string['archetypecoursecreator'] = 'ORIGINÁL: Tvorca kurzov';
$string['archetypeeditingteacher'] = 'ORIGINÁL: Učiteľ s právom úprav';
$string['archetypefrontpage'] = 'ARCHETYPE: Overený používateľ na domovskej stránke webu';
$string['archetypeguest'] = 'ORIGINÁL: Hosť';
$string['archetypemanager'] = 'ORIGINÁL: Manažér';
$string['archetypestudent'] = 'ORIGINÁL: Študent';
$string['archetypeteacher'] = 'ORIGINÁL: Učiteľ bez práv úprav';
$string['archetypeuser'] = 'ORIGINÁL: Prihlásený používateľ';
$string['assignanotherrole'] = 'Priradiť inú rolu';
$string['assignedroles'] = 'Priradené roly';
$string['assignerror'] = 'Chyba pri priradení roly {$a->role} používateľovi {$a->user}.';
$string['assignglobalroles'] = 'Priradiť systémové roly';
$string['assignmentcontext'] = 'Kontext priradenia';
$string['assignmentoptions'] = 'Možnosti priradenia';
$string['assignrole'] = 'Priradiť rolu';
$string['assignrolenameincontext'] = 'Priradiť rolu \'{$a->role}\' v kontexte {$a->context}';
$string['assignroles'] = 'Priradiť roly';
$string['assignroles_help'] = 'Ak pridelíte používateľovi v určitom kontexte nejakú rolu, prideľujete mu oprávnenie definované touto rolou pre aktuálny kontext a pre všetky podradené
kontexty. Ak teda napr. rolu Študent pridelíte používateľovi v kurze, bude túto rolu mať pre daný kurz, ale tiež pre všetky bloky a aktivity v kurze.';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesin'] = 'Priradiť roly v {$a}';
$string['assignrolesrelativetothisuser'] = 'Priradiť roly relatívne k tomuto používateľovi';
$string['backtoallroles'] = 'Návrat k zoznamu všetkých rol';
$string['backup:anonymise'] = 'Odstrániť osobné údaje používateľov pri zálohovaní';
$string['backup:backupactivity'] = 'Zálohovať aktivity';
$string['backup:backupcourse'] = 'Zálohovať kurzy';
$string['backup:backupsection'] = 'Zálohovať sekcie';
$string['backup:backuptargetimport'] = 'Zálohovanie pre import';
$string['backup:configure'] = 'Konfigurovať možnosti zálohovania';
$string['backup:downloadfile'] = 'Stiahnuť súbory z priečinku záloh';
$string['backup:userinfo'] = 'Zálohovať používateľské údaje';
$string['badges:awardbadge'] = 'Udeliť používateľovi odznak';
$string['badges:configurecriteria'] = 'Nastaviť/upraviť kritériá získania odznaku';
$string['badges:configuredetails'] = 'Nastaviť/upraviť podrobnosti odznaku';
$string['badges:configuremessages'] = 'Konfigurácia správ o odznaku';
$string['badges:createbadge'] = 'Vytvoriť/kopírovať odznaky';
$string['badges:deletebadge'] = 'Odstrániť odznaky';
$string['badges:earnbadge'] = 'Získať odznak';
$string['badges:manageglobalsettings'] = 'Spravovať globálne nastavenia odznakov';
$string['badges:manageownbadges'] = 'Zobrazenie a správa vlastných odznakov';
$string['badges:revokebadge'] = 'Zrušiť odznak používateľa';
$string['badges:viewawarded'] = 'Zobraziť používateľov, ktorí získali konkrétny odznak bez toho, aby ho mohli udeliť';
$string['badges:viewbadges'] = 'Zobraziť dostupné odznaky, ktoré nie sú získané';
$string['badges:viewotherbadges'] = 'Zobraziť verejné odznaky v profiloch ostatných používateľov';
$string['block:edit'] = 'Upraviť nastavenia bloku';
$string['block:view'] = 'Vidieť blok';
$string['blog:create'] = 'Vytvoriť nové položky blogu';
$string['blog:manageentries'] = 'Upravovať a spravovať položky';
$string['blog:manageexternal'] = 'Upraviť a spravovať externé blogy';
$string['blog:search'] = 'Vyhľadávať v položkách blogov';
$string['blog:view'] = 'Prezerať položky blogu';
$string['blog:viewdrafts'] = 'Prezerať pracovné verzie blogov';
$string['calendar:manageentries'] = 'Spravovať ľubovoľné položky kalendára';
$string['calendar:managegroupentries'] = 'Spravovať skupinové položky kalendára';
$string['calendar:manageownentries'] = 'Spravovať svoje položky kalendára';
$string['capabilities'] = 'Schopnosti';
$string['capability'] = 'Schopnosť';
$string['category:create'] = 'Vytvoriť kategórie';
$string['category:delete'] = 'Vymazať kategórie';
$string['category:manage'] = 'Spravovať kategórie';
$string['category:update'] = 'Aktualizovať kategórie';
$string['category:viewcourselist'] = 'Zobraziť kategóriu kurzov a kurzy v nej';
$string['category:viewhiddencategories'] = 'Vidieť skryté kategórie';
$string['category:visibility'] = 'Prezerať skryté kategórie';
$string['checkglobalpermissions'] = 'Skontrolovať oprávnenia systému';
$string['checkpermissions'] = 'Skontrolovať oprávnenia';
$string['checkpermissionsin'] = 'Skontrolovať oprávnenia v {$a}';
$string['checksystempermissionsfor'] = 'Skontrolovať oprávnenia pre {$a->fullname}';
$string['checkuserspermissionshere'] = 'Skontrolovať oprávnenia pre {$a->fullname}, ktoré má v tomto kontexte: {$a->contextlevel}';
$string['chooseroletoassign'] = 'Prosím vyberte rolu na priradenie';
$string['cohort:assign'] = 'Pridať a odstrániť členov globálnej skupiny';
$string['cohort:manage'] = 'Vytvoriť, vymazať a presúvať členov globálnej skupiny';
$string['cohort:view'] = 'Prezerať globálne skupiny na portáli';
$string['comment:delete'] = 'Vymazať poznámky';
$string['comment:post'] = 'Publikovať poznámky';
$string['comment:view'] = 'Zobraziť poznámky';
$string['competency:competencygrade'] = 'Nastaviť hodnotenie kompetencie';
$string['competency:competencymanage'] = 'Spravovať rámce kompetencií';
$string['competency:competencyview'] = 'Zobraziť rámce kompetencií';
$string['competency:coursecompetencyconfigure'] = 'Konfigurácia nastavení kompetencií kurzu';
$string['competency:coursecompetencygradable'] = 'Prijať známky kompetencií';
$string['competency:coursecompetencymanage'] = 'Správa kompetencií kurzu';
$string['competency:coursecompetencyview'] = 'Zobraziť kompetencie kurzu';
$string['competency:evidencedelete'] = 'Odstrániť evidenciu';
$string['competency:plancomment'] = 'Komentovať študijný plán';
$string['competency:plancommentown'] = 'Komentovať vlastný študijný plán';
$string['competency:planmanage'] = 'Spravovať učebné plány';
$string['competency:planmanagedraft'] = 'Správa návrhov študijných plánov';
$string['competency:planmanageown'] = 'Správa vlastných študijných plánov';
$string['competency:planmanageowndraft'] = 'Správa vlastných návrhov študijných plánov';
$string['competency:planrequestreview'] = 'Žiadosť o revíziu študijného plánu';
$string['competency:planrequestreviewown'] = 'Žiadosť o revíziu vlastného študijného plánu';
$string['competency:planreview'] = 'Revízia študijného plánu';
$string['competency:planview'] = 'Zobraziť všetky plány učenia';
$string['competency:planviewdraft'] = 'Zobraziť vlastné plány učenia';
$string['competency:planviewown'] = 'Zobraziť vlastné plány učenia';
$string['competency:planviewowndraft'] = 'Pozrite si vlastné návrhy vzdelávacích plánov';
$string['competency:templatemanage'] = 'Správa šablón študijných plánov';
$string['competency:templateview'] = 'Zobraziť šablóny študijných plánov';
$string['competency:usercompetencycomment'] = 'Komentár k používateľským kompetenciám';
$string['competency:usercompetencycommentown'] = 'Komentár k vlastným používateľským kompetenciám';
$string['competency:usercompetencyrequestreview'] = 'Žiadosť o revíziu kompetencie používateľa';
$string['competency:usercompetencyrequestreviewown'] = 'Žiadosť o revíziu vlastnej kompetencie používateľa';
$string['competency:usercompetencyreview'] = 'Revízia kompetencie používateľa';
$string['competency:usercompetencyview'] = 'Zobrazenie kompetencie používateľa';
$string['competency:userevidencemanage'] = 'Správa evidencie predchádzajúceho štúdia';
$string['competency:userevidencemanageown'] = 'Správa vlastnej evidencie predchádzajúceho štúdia';
$string['competency:userevidenceview'] = 'Zobraziť evidenciu predchádzajúceho štúdia';
$string['confirmaddadmin'] = 'Naozaj chcete pridať používateľa <strong>{$a}</strong> ako nového administrátora portálu?';
$string['confirmdeladmin'] = 'Naozaj chcete ostrániť používateľa <strong>{$a}</strong> zo zoznamu administrátorov portálu?';
$string['confirmroleprevent'] = 'Naozaj chcete odstrániť rolu <strong>{$a->role}</strong> zo zoznamu povolených rol so schopnosťou {$a->cap} v kontexte {$a->context}?';
$string['confirmroleunprohibit'] = 'Naozaj chcete odstrániť rolu <strong>{$a->role}</strong> zo zoznamu zakázaných rol so schopnosťou {$a->cap} v kontexte {$a->context}?';
$string['confirmunassign'] = 'Naozaj chcete odstrániť túto rolu pre daného používateľa?';
$string['confirmunassignno'] = 'Zrušiť';
$string['confirmunassigntitle'] = 'Potvrdiť zmenu roly';
$string['confirmunassignyes'] = 'Odstrániť';
$string['contentbank:access'] = 'Prístup do banky obsahu';
$string['contentbank:deleteanycontent'] = 'Odstrániť všetok obsah z banky obsahu';
$string['contentbank:deleteowncontent'] = 'Odstrániť obsah z banky obsahu';
$string['contentbank:downloadcontent'] = 'Stiahnuť obsah z banky obsahu';
$string['contentbank:manageanycontent'] = 'Spravovať všetok obsah z banky obsahu';
$string['contentbank:manageowncontent'] = 'Spravovať obsah z vlastnej banky obsahu';
$string['contentbank:upload'] = 'Nahrať nový obsah do banky obsahu';
$string['contentbank:useeditor'] = 'Vytvoriť alebo upraviť obsah pomocou editora typov obsahu';
$string['contentbank:viewunlistedcontent'] = 'Zobraziť neverejný obsah z banky obsahu';
$string['context'] = 'Kontext';
$string['contextrolenotallowed'] = 'Rola {$a} nemá prístup k obsahu.';
$string['course:activityvisibility'] = 'Skryť/zobraziť aktivity';
$string['course:bulkmessaging'] = 'Poslať správu viacerým účastníkom';
$string['course:changecategory'] = 'Zmeniť kategóriu kurzu';
$string['course:changefullname'] = 'Zmeniť celé meno kurzu';
$string['course:changeidnumber'] = 'Zmeniť identifikátor kurzu';
$string['course:changelockedcustomfields'] = 'Zmeniť zamknuté vlastné pole';
$string['course:changeshortname'] = 'Zmeniť skrátené meno kurzu';
$string['course:changesummary'] = 'Zmeniť sumár kurzu';
$string['course:configurecustomfields'] = 'Nakonfigurovať vlastné pole';
$string['course:configuredownloadcontent'] = 'Konfigurácia sťahovania obsahu kurzu';
$string['course:create'] = 'Vytvoriť kurzy';
$string['course:creategroupconversations'] = 'Vytvoriť skupinové konverzácie';
$string['course:delete'] = 'Vymazať kurzy';
$string['course:downloadcoursecontent'] = 'Stiahnuť obsah kurzu';
$string['course:enrolconfig'] = 'Konfigurovať spôsoby zápisu v kurzoch';
$string['course:enrolreview'] = 'Preskúmať zápisy do kurzov';
$string['course:ignoreavailabilityrestrictions'] = 'Ignorovať obmedzenia dostupnosti';
$string['course:ignorefilesizelimits'] = 'Používať súbory väčšie ako je obmedzenie veľkosti súboru';
$string['course:isincompletionreports'] = 'Bude zobrazené na záver zostavy';
$string['course:manageactivities'] = 'Spravovať aktivity';
$string['course:managefiles'] = 'Spravovať súbory';
$string['course:managegrades'] = 'Spravovať známky';
$string['course:managegroups'] = 'Spravovať skupiny';
$string['course:managescales'] = 'Spravovať stupnice';
$string['course:markcomplete'] = 'Manuálne označovať absolvovanie kurzu';
$string['course:movesections'] = 'Presúvať sekcie';
$string['course:overridecompletion'] = 'Prepísať stav dokončenia aktivity';
$string['course:recommendactivity'] = 'Odporučiť aktivity v sprievodcovi pridania obsahu';
$string['course:renameroles'] = 'Premenovať roly';
$string['course:request'] = 'Žiadať nové kurzy';
$string['course:reset'] = 'Resetovať kurz';
$string['course:reviewotherusers'] = 'Skontrolujte ostatných používateľov';
$string['course:sectionvisibility'] = 'Riadiť viditeľnosť sekcií';
$string['course:setcurrentsection'] = 'Nastaviť súčasnú sekciu';
$string['course:setforcedlanguage'] = 'Vnútiť jazyk kurzu';
$string['course:tag'] = 'Zmeniť štítky kurzu';
$string['course:togglecompletion'] = 'Manuálne označiť aktivity za ukončené';
$string['course:update'] = 'Aktualizovať nastavenia kurzu';
$string['course:useremail'] = 'Povoliť/zakázať mailové adresy';
$string['course:view'] = 'Prezerať kurzy bez účasti v nich';
$string['course:viewcoursegrades'] = 'Prezerať známky';
$string['course:viewhiddenactivities'] = 'Prezerať skryté aktivity';
$string['course:viewhiddencourses'] = 'Prezerať skryté kurzy';
$string['course:viewhiddensections'] = 'Prezerať skryté sekcie';
$string['course:viewhiddenuserfields'] = 'Prezerať skryté užívateľské polia';
$string['course:viewparticipants'] = 'Prezerať účastníkov kurzov';
$string['course:viewscales'] = 'Prezerať stupnice';
$string['course:viewsuspendedusers'] = 'Zobraziť pozastavených používateľov';
$string['course:visibility'] = 'Skryť/ukázať kurzy';
$string['createrolebycopying'] = 'Vytvoriť novú rolu kopírovaním {$a}';
$string['createthisrole'] = 'Vytvoriť túto rolu';
$string['currentcontext'] = 'Súčasný kontext';
$string['currentrole'] = 'Súčasná rola';
$string['customroledescription'] = 'Vlastný opis';
$string['customroledescription_help'] = 'Ak je vlastný opis prázdny, sú opisy štandardných rolí nastavené automaticky.';
$string['customrolename'] = 'Vlastný názov';
$string['customrolename_help'] = 'Ak je vlastný názov role prázdny, bude použitý lokalizovaný štandardný názov role. Vo všetkých vlastných roliach musíte názov roly vyplniť.';
$string['defaultrole'] = 'Štandardná rola';
$string['defaultx'] = 'Východzí: {$a}';
$string['defineroles'] = 'Definovať roly';
$string['deletecourseoverrides'] = 'Vymazať všetky prestavenia rol v kurze';
$string['deletelocalroles'] = 'Vymazať všetky lokálne priradenia rol';
$string['deleterolesure'] = '<p>Naozaj chcete vymazať rolu "{$a->name} ({$a->shortname})"?</p><p>V súčasnosti je táto rola priradená {$a->count} používateľom.</p>';
$string['deletexrole'] = 'Vymazať {$a} rolu';
$string['duplicaterole'] = 'Duplikovať rolu';
$string['duplicaterolesure'] = '<p>Naozaj chcete duplikovať rolu "{$a->name} ({$a->shortname})"?</p>';
$string['editingrolex'] = 'Upravovanie roly \'{$a}\' ';
$string['editrole'] = 'Upraviť rolu';
$string['editxrole'] = 'Upraviť rolu {$a} ';
$string['errorbadrolename'] = 'Nesprávny názov roly';
$string['errorbadroleshortname'] = 'Nesprávny krátky názov roly';
$string['errorexistsrolename'] = 'Názov roly už existuje';
$string['errorexistsroleshortname'] = 'Názov roly už existuje';
$string['errorroleshortnametoolong'] = 'Krátky názov nesmie prekročiť 100 znakov';
$string['eventcapabilityassigned'] = 'Oprávnenie priradené';
$string['eventcapabilityunassigned'] = 'Oprávnenie odstránené';
$string['eventroleallowassignupdated'] = 'Aktualizované povolenie priraďovať roly';
$string['eventroleallowoverrideupdated'] = 'Aktualizované povolenie prepísať roly';
$string['eventroleallowswitchupdated'] = 'Aktualizované povolenie prepnúť roly';
$string['eventroleallowviewupdated'] = 'Povoliť zobrazenie roly';
$string['eventroleassigned'] = 'Rola priradená';
$string['eventrolecapabilitiesupdated'] = 'Oprávnenie role aktualizované';
$string['eventroledeleted'] = 'Rola odstránená';
$string['eventroleunassigned'] = 'Priradenie role odobrané';
$string['eventroleupdated'] = 'Rola bola aktualizovaná';
$string['existingadmins'] = 'Súčasní administrátori portálu';
$string['existingusers'] = '{$a} existujúcich používateľov';
$string['explanation'] = 'Vysvetlenie';
$string['export'] = 'Export';
$string['extusers'] = 'Existujúci používatelia';
$string['extusersmatching'] = 'Existujúci používatelia zhodujúci sa \'{$a}\'';
$string['filter:manage'] = 'Spravovať nastavenia lokálnych filtrov';
$string['frontpageuser'] = 'Prihlásený používateľ na titulnej stránke';
$string['frontpageuserdescription'] = 'Všetci prihlásení používatelia v kurze na titulnej stránke';
$string['globalrole'] = 'Systémová rola';
$string['globalroleswarning'] = 'Upozornenie! Všetky roly, ktoré pridelíte na tejto stránke, budú platné všade včítane titulnej stránky a všetkých kurzov.';
$string['gotoassignroles'] = 'Ísť na Priradiť roly pre tento kontext {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Ísť na Priradiť systémové roly';
$string['grade:edit'] = 'Upraviť známky';
$string['grade:export'] = 'Exportovať známky';
$string['grade:hide'] = 'Skryť/odkryť známky alebo položky';
$string['grade:import'] = 'Importovať známky';
$string['grade:lock'] = 'Zamknúť známky alebo položky';
$string['grade:manage'] = 'Spravovať položky známok';
$string['grade:managegradingforms'] = 'Spravovať pokročilé metódy hodnotenia';
$string['grade:manageletters'] = 'Spravovať písmená známok';
$string['grade:manageoutcomes'] = 'Spravovať ciele hodnotenia';
$string['grade:managesharedforms'] = 'Správa šablón pokročilého hodnotenia';
$string['grade:override'] = 'Prepísať známky';
$string['grade:sharegradingforms'] = 'Zdieľanie pokročilého hodnotenia ako šablóny';
$string['grade:unlock'] = 'Odomknúť známky alebo položky';
$string['grade:view'] = 'Vidieť vlastné známky';
$string['grade:viewall'] = 'Vidieť známky ostatných používateľov';
$string['grade:viewhidden'] = 'Vidieť skryté známky pre vlastníka';
$string['h5p:deploy'] = 'Nasadenie obsahu H5P';
$string['h5p:setdisplayoptions'] = 'Nastaviť možnosti zobrazenia H5P';
$string['h5p:updatelibraries'] = 'Spravovať typ obsahu H5P';
$string['highlightedcellsshowdefault'] = 'Zvýraznené bunky v tabuľke nižšie ukazujú východzie hodnoty pre túto rolu v náväznosti na aktuálne vybraný originálny typ roly.';
$string['highlightedcellsshowinherit'] = 'Zvýraznené bunky v tabuľke nižšie ukazujú prípadné oprávnenia, ktoré budú štandardne použité. Upravte oprávnenia iba u tých právomocí, ktoré chcete naozaj zmeniť. Všetko ostatné ponechajte na hodnote "Zdediť".';
$string['inactiveformorethan'] = 'neaktívny pre viac ako {$a->timeperiod}';
$string['ingroup'] = 'v skupine "{$a->group}"';
$string['inherit'] = 'Zdediť';
$string['invalidpresetfile'] = 'Neplatný súbor definície roly';
$string['legacy:admin'] = 'PÔVODNÁ ROLA: Administrátor';
$string['legacy:coursecreator'] = 'PÔVODNÁ ROLA: Tvorca kurzov';
$string['legacy:editingteacher'] = 'PÔVODNÁ ROLA: Učiteľ';
$string['legacy:guest'] = 'PÔVODNÁ ROLA: Hosť';
$string['legacy:student'] = 'PÔVODNÁ ROLA: Študent';
$string['legacy:teacher'] = 'PÔVODNÁ ROLA: Učiteľ (bez úprav)';
$string['legacy:user'] = 'PÔVODNÁ ROLA: Overený používateľ';
$string['legacytype'] = 'typ pôvodnej roly';
$string['listallroles'] = 'Zobraziť všetky roly';
$string['localroles'] = 'Lokálne priradené roly';
$string['mainadmin'] = 'Hlavný administrátor';
$string['mainadminset'] = 'Nastaviť hlavného administrátora';
$string['manageadmins'] = 'Spravovať administrátorov portálu';
$string['manager'] = 'Manažér';
$string['managerdescription'] = 'Manažéri majú prístup do kurzov, môžu ich upravovať, ale vo všeobecnosti sa ich nezúčastňujú.';
$string['manageroles'] = 'Spravovať roly';
$string['maybeassignedin'] = 'Typy kontextov, kde môže byť táto rola priradená';
$string['morethan'] = 'Viac ako {$a}';
$string['multipleroles'] = 'Viacnásobné roly';
$string['my:configsyspages'] = 'Konfigurovať systémové šablóny pre stránky Nástenka';
$string['my:manageblocks'] = 'Administrovať bloky stránky Nástenka';
$string['neededroles'] = 'Roly s oprávnením';
$string['nocapabilitiesincontext'] = 'V tomto kontexte nie sú dostupné žiadne schopnosti';
$string['noneinthisx'] = 'Nič v tomto {$a}';
$string['noneinthisxmatching'] = 'Žiadni používatelia sa nezhodujú s \'{$a->search}\' v kontexte {$a->contexttype}';
$string['norole'] = 'Žiadna rola';
$string['noroleassignments'] = 'Tento používateľ nemá žiadne priradenia rol nikde na portáli.';
$string['noroles'] = 'Žiadne roly';
$string['notabletoassignroleshere'] = 'Priradenie v tomto kontexte nebolo administrátorom povolené.';
$string['notabletooverrideroleshere'] = 'Na tomto mieste nemáte oprávnenie prepísať žiadne oprávnenia';
$string['notes:manage'] = 'Spravovať poznámky';
$string['notes:view'] = 'Vidieť poznámky';
$string['notset'] = 'Nenastavené';
$string['novisibleroles'] = 'Žiadne roly';
$string['overrideanotherrole'] = 'Prepísať inú rolu';
$string['overridecontext'] = 'Prestaviť kontext';
$string['overridepermissions'] = 'Prestaviť oprávnenia';
$string['overridepermissions_help'] = 'Prepísanie oprávnení umožňuje povoliť alebo zakázať určité oprávnenia v špecifickom kontexte';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overridepermissionsforrole'] = 'Prestaviť oprávnenia pre rolu \'{$a->role}\' v kontexte {$a->context}';
$string['overridepermissionsin'] = 'Prestaviť oprávnenia v {$a}';
$string['overrideroles'] = 'Prepísať roly';
$string['overriderolesin'] = 'Prepísať roly v {$a}';
$string['overrides'] = 'Prepísať';
$string['overridesbycontext'] = 'Prestavenia (podľa kontextu)';
$string['payment:manageaccounts'] = 'Spravovať účty';
$string['payment:viewpayments'] = 'Zobraziť platby';
$string['permission'] = 'Oprávenie';
$string['permission_help'] = 'Povolenia sú nastavenia schopností. Sú 4 možnosti:

* Nenastaviť
* Povoliť – pre schopnosť je udelené povolenie
* Zabrániť – Povolenie je pre funkciu odobraté, aj keď je povolené vo vyššom kontexte
* Zakázať – Povolenie je úplne odmietnuté a nemožno ho prepísať v žiadnom nižšom (konkrétnejšom) kontexte';
$string['permissions'] = 'Oprávnenia';
$string['permissionsforuser'] = 'Oprávnenia pre používateľa {$a}';
$string['permissionsincontext'] = 'Oprávnenia v {$a}';
$string['portfolio:export'] = 'Exportovať do portfólií';
$string['potentialusers'] = '{$a} potenciálnych používateľov';
$string['potusers'] = 'Potenciálni používatelia';
$string['potusersmatching'] = 'Potenciálni používatelia zhodujúci sa s \'{$a}\'';
$string['prevent'] = 'Zabrániť';
$string['privacy:metadata:preference:showadvanced'] = 'Použite prepínač pokročilého režimu';
$string['privacy:metadata:role_assignments'] = 'Priradenie rolí';
$string['privacy:metadata:role_assignments:component'] = 'Zásuvný modul zodpovedný za priradenie rolí prázdny pri ručnom priradení.';
$string['privacy:metadata:role_assignments:itemid'] = 'Identifikátor inštancie zápisu / autentifikácie zodpovednej za priradenie role';
$string['privacy:metadata:role_assignments:modifierid'] = 'ID používateľa, ktorý vytvoril alebo upravil priradenie rolí';
$string['privacy:metadata:role_assignments:roleid'] = 'ID role';
$string['privacy:metadata:role_assignments:tableexplanation'] = 'Táto tabuľka ukladá priradené role v každom kontexte';
$string['privacy:metadata:role_assignments:timemodified'] = 'Dátum, kedy bola rola priradená alebo upravená.';
$string['privacy:metadata:role_assignments:userid'] = 'ID používateľa';
$string['privacy:metadata:role_capabilities'] = 'Právomoci role';
$string['privacy:metadata:role_capabilities:capability'] = 'Názov právomoci';
$string['privacy:metadata:role_capabilities:modifierid'] = 'ID používateľa, ktorý vytvoril alebo zmenil právomoc';
$string['privacy:metadata:role_capabilities:permission'] = 'Oprávnenie k právomoci: zdediť, povoliť, nepovoliť alebo zakázať.';
$string['privacy:metadata:role_capabilities:roleid'] = 'ID role';
$string['privacy:metadata:role_capabilities:tableexplanation'] = 'Táto tabuľka ukladá právomoci a prepíše právomoci určitej role v konkrétnom kontexte';
$string['privacy:metadata:role_capabilities:timemodified'] = 'Dátum vytvorenia alebo úpravy právomoci.';
$string['privacy:metadata:role_cohortroles'] = 'Rola do globálnej skupiny';
$string['prohibit'] = 'Zakázať';
$string['prohibitedroles'] = 'Zakázaný';
$string['question:add'] = 'Pridať nové otázky';
$string['question:commentall'] = 'Komentovať všetky otázky';
$string['question:commentmine'] = 'Komentovať vlastné otázky';
$string['question:config'] = 'Konfigurovať typy otázok';
$string['question:editall'] = 'Upraviť všetky otázky';
$string['question:editmine'] = 'Upraviť vlastné otázky';
$string['question:flag'] = 'Označiť otázky počas pokusu';
$string['question:managecategory'] = 'Upravovať kategórie otázok';
$string['question:moveall'] = 'Presunúť všetky otázky';
$string['question:movemine'] = 'Presunúť vlastné otázky';
$string['question:tagall'] = 'Označiť všetky otázky';
$string['question:tagmine'] = 'Označiť svoje vlastné otázky';
$string['question:useall'] = 'Použiť všetky otázky';
$string['question:usemine'] = 'Použiť vlastné otázky';
$string['question:viewall'] = 'Prezrieť všetky otázky';
$string['question:viewmine'] = 'Prezrieť vlastné otázky';
$string['rating:rate'] = 'Pridať hodnotenia položkám';
$string['rating:view'] = 'Zobraziť celkové hodnotenie, ktoré ste dostali';
$string['rating:viewall'] = 'Vidieť všetky hodnotenia vložené jednotlivcami';
$string['rating:viewany'] = 'Vidieť celkové hodnotenia, ktoré každý dostal';
$string['reportbuilder:edit'] = 'Upraviť vlastné prehľady';
$string['reportbuilder:editall'] = 'Upraviť všetky vlastné prehľady';
$string['reportbuilder:scheduleviewas'] = 'Robraziť hlásenie rozvrhu ako iný užívateľ';
$string['reportbuilder:view'] = 'Ukázať vlastné prehľady';
$string['resetrole'] = 'Resetovať na východzie hodnoty';
$string['resettingrole'] = 'Obnovenie role "{$a}"';
$string['restore:configure'] = 'Konfigurovať možnosti obnovy';
$string['restore:createuser'] = 'Vytvoriť používateľov pri obnove kurzu';
$string['restore:restoreactivity'] = 'Obnoviť aktivity';
$string['restore:restorecourse'] = 'Obnoviť kurzy';
$string['restore:restoresection'] = 'Obnoviť sekcie';
$string['restore:restoretargetimport'] = 'Obnoviť zo súborov označených ako import';
$string['restore:rolldates'] = 'Povolenie zmeniť dátumy aktivít pri obnove kurzu';
$string['restore:uploadfile'] = 'Nahrať súbory z priestoru záloh';
$string['restore:userinfo'] = 'Obnoviť používateľské údaje';
$string['restore:viewautomatedfilearea'] = 'Obnoviť kurzy z automatických záloh';
$string['risks'] = 'Riziká';
$string['role:assign'] = 'Priradiť roly používateľom';
$string['role:manage'] = 'Vytvoriť a spravovať roly';
$string['role:override'] = 'Prepísať oprávnenia pre ostatných';
$string['role:review'] = 'Skontrolovať oprávnenia pre ostatných';
$string['role:safeoverride'] = 'Prepísať bezpečné oprávnenia pre ostatných';
$string['role:switchroles'] = 'Prepnúť na iné roly';
$string['roleallowheader'] = 'Povoliť rolu:';
$string['roleallowinfo'] = 'Vybrať rolu na pridanie do zoznamu povolených rol v kontexte {$a->context}, schopnosť {$a->cap}:';
$string['roleassignments'] = 'Priradenia rol';
$string['roledefinitions'] = 'Definície rol';
$string['rolefullname'] = 'Meno';
$string['roleincontext'] = '{$a->role} v {$a->context}';
$string['roleprohibitheader'] = 'Zabrániť rolu';
$string['roleprohibitinfo'] = 'Vybrať rolu na pridanie do zoznamu zabránených rol v kontexte {$a->context}, schopnosť {$a->cap}:';
$string['rolerepreset'] = 'Použiť predvoľby role';
$string['roleresetdefaults'] = 'Východzí';
$string['roleresetrole'] = 'Použiť rolu alebo archetyp';
$string['rolerisks'] = 'Riziká role';
$string['roles'] = 'Roly';
$string['roles_help'] = '<p>
Rola je súbor oprávnení, ktorý je definovaný pre celý portál
a ktorý možno v&nbsp;konkrétnych kontextoch prideľovať konkrétnym používateľom.
</p>

<p>
Môžete mať napr. rolu nazvanú "Učiteľ ", ktorá je nastavená tak, aby
umožňovala učiteľom vykonávať niektoré akcie (a iné zasa nie). Akonáhle
je táto rola vytvorená, môžete ju niekomu prideliť v&nbsp;kurze – tým
dotyčného používateľa definujete pre daný kurz "Učiteľom". Rovnakú rolu
môžete vybranému používateľovi prideliť v&nbsp;určitej kategórii kurzov – tym
z&nbsp;neho vytvoríte "Učiteľa" všetkých kurzov obsiahnutých v&nbsp;danej kategórii;
alebo môžete túto rolu používateľovi prideliť iba v&nbsp;jednom diskusnom fóre
– tým mu poskytnete oprávnenia "Učiteľa" iba pre toto fórum.
</p>

<p>
Rola musí mať <strong>meno</strong>. Ak potrebujete rolu pomenovať vo viacerých
jazykoch, môžete použiť viacjazyčnú syntax Moodle: <pre>
  &lt;span lang="en_utf8"&gt;Teacher&lt;/span&gt;
  &lt;span lang="sk_utf8"&gt;Učiteľ&lt;/span&gt;
  </pre>Ak túto možnosť využijete, je nutné mať súčasne v&nbsp;nastavení
inštalácie aktivovanú voľbu "Použiť filtre na všetky reťazce [filterall]".
</p>

<p>
<strong>Krátky názov</strong> role je nutný k&nbsp;tomu, aby sa na vašu rolu mohli
odkazovať iné časti Moodle (napr. pri hromadnom vkladaní používateľov
z&nbsp;textového súboru alebo pri nastavení zápisu do kurzov prostredníctvom
zásuvných modulov).
</p>

<p>
<strong>Popis</strong> slúži k definícii role vašimi vlastnými slovami tak, aby
ostatní používatelia mali predstavu, k&nbsp;čomu je rola určená.
</p>

<p>
Viď tiež
<a href="help.php?file=contexts.html">Kontexty</a>,
<a href="help.php?file=permissions.html">Oprávnenia</a>,
<a href="help.php?file=assignroles.html">Priradiť roly</a> a
<a href="help.php?file=overrides.html">Prepísať roly</a>.
</p>';
$string['roles_link'] = 'roles';
$string['roleselect'] = 'Vybrať rolu';
$string['rolesforuser'] = 'Rola pre používateľa {$a}';
$string['roleshortname'] = 'Skrátené meno';
$string['roleshortname_help'] = 'Krátky názov je nízkoúrovňový identifikátor roly, v ktorej sú povolené iba alfanumerické ASCII znaky.';
$string['roletoassign'] = 'Rola na priradenie';
$string['roletooverride'] = 'Rola na prepísanie';
$string['safeoverridenotice'] = 'Poznámka: schopnosti so zvýšeným rizikom sú zamknuté, pretože máte iba oprávnenie na zmenu bezpečných schopností.';
$string['search:query'] = 'Vykonajte vyhľadávanie cez celý porál';
$string['selectanotheruser'] = 'Vybrať iného používateľa';
$string['selectauser'] = 'Vybrať používateľa';
$string['selectrole'] = 'Vybrať rolu';
$string['showallroles'] = 'Ukázať všetky roly';
$string['showthisuserspermissions'] = 'Ukázať oprávnenia pre tohto používateľa';
$string['site:accessallgroups'] = 'Prístup k všetkým skupinám';
$string['site:approvecourse'] = 'Odsúhlasiť vytvorenie kurzu';
$string['site:backup'] = 'Zálohovať kurzy';
$string['site:config'] = 'Zmeniť konfiguráciu portálu';
$string['site:configview'] = 'Zobraziť strom administrácie webu (ale nie všetky stránky v ňom)';
$string['site:deleteanymessage'] = 'Odstrániť všetky správy na webe';
$string['site:deleteownmessage'] = 'Odstrániť správy odoslané používateľovi a používateľom';
$string['site:doanything'] = 'Povoliť robiť všetko';
$string['site:doclinks'] = 'Ukázať odkazy k dokumentom mimo portálu';
$string['site:forcelanguage'] = 'Prepísať jazyk kurzu';
$string['site:import'] = 'Importovať iné kurzy do kurzu';
$string['site:maintenanceaccess'] = 'Prístup k webu, ak je nastavený režim údržby';
$string['site:manageallmessaging'] = 'Pridať, odoberať, blokovať a odblokovať kontakty pre akéhokoľvek používateľa';
$string['site:manageblocks'] = 'Spravovať bloky na stránke';
$string['site:managecontextlocks'] = 'Správa zmrazenia kontextu';
$string['site:messageanyuser'] = 'Zablokujte predvoľby ochrany osobných údajov pre zasielanie správ používateľom';
$string['site:mnetloginfromremote'] = 'Prihlásiť sa zo vzdialeného MNet servera';
$string['site:mnetlogintoremote'] = 'Roamovať do vzdialeného MNet servera';
$string['site:readallmessages'] = 'Čítať všetky správy na portáli';
$string['site:restore'] = 'Obnovovať kurzy';
$string['site:senderrormessage'] = 'Odoslať správu používateľskej podpory s chybovej stránky';
$string['site:sendmessage'] = 'Posielať správy ľubovoľnému používateľovi';
$string['site:trustcontent'] = 'Dôverovať vloženému obsahu';
$string['site:uploadusers'] = 'Nahrať nových používateľov zo súboru';
$string['site:viewanonymousevents'] = 'Zobraziť anonymné udalosti v zostavách';
$string['site:viewfullnames'] = 'Vždy vidieť plné mená používateľov';
$string['site:viewparticipants'] = 'Prezerať účastníkov';
$string['site:viewreports'] = 'Prezerať správy';
$string['site:viewuseridentity'] = 'V zozname zobraziť celú identitu používateľa';
$string['siteadministrators'] = 'Administrátori portálu';
$string['tag:edit'] = 'Upraviť existujúce tagy';
$string['tag:editblocks'] = 'Upraviť bloky v stránkach tagov';
$string['tag:flag'] = 'Označiť štítok ako nevhodný';
$string['tag:manage'] = 'Spravovať všetky tagy';
$string['thisnewrole'] = 'Táto nová rola';
$string['thisusersroles'] = 'Priradenia rol tohto používateľa';
$string['unassignarole'] = 'Odobrať rolu {$a}';
$string['unassignconfirm'] = 'Naozaj chcete používateľovi "{$a->user}" odobrať rolu "{$a->role}" ?';
$string['unassignerror'] = 'Chyba pri odoberaní roly {$a->role} u používateľa {$a->user}.';
$string['user:changeownpassword'] = 'Zmeniť vlastné heslo';
$string['user:create'] = 'Vytvárať používateľov';
$string['user:delete'] = 'Vymazať používateľov';
$string['user:editmessageprofile'] = 'Upraviť profil správ používateľa';
$string['user:editownmessageprofile'] = 'Upraviť svoj profil správ používateľa';
$string['user:editownprofile'] = 'Upraviť vlastný používateľský profil';
$string['user:editprofile'] = 'Upraviť používateľký profil';
$string['user:ignoreuserquota'] = 'Ignorovať používateľské kvóty';
$string['user:loginas'] = 'Prihlásiť sa ako iní používatelia';
$string['user:manageblocks'] = 'Spravovať bloky na používateľskom profile iných používateľom';
$string['user:manageownblocks'] = 'Spravovať bloky na vlastnom používateľskom verejnom profile';
$string['user:manageownfiles'] = 'Spravovať súbory vo vlastných súkromných adresároch';
$string['user:managesyspages'] = 'Konfigurovať zobrazenie východzej stránky pre verejné profily používateľov';
$string['user:readuserblogs'] = 'Vidieť všetky blogy používateľa';
$string['user:readuserposts'] = 'Zobraziť diskusné príspevky všetkých používateľov';
$string['user:update'] = 'Aktualizovať používateľské profily';
$string['user:viewalldetails'] = 'Prezerať plnú informáciu o používateľovi';
$string['user:viewdetails'] = 'Prezerať používateľské profily';
$string['user:viewhiddendetails'] = 'Prezerať skryté detaily o používateľoch';
$string['user:viewlastip'] = 'Zobraziť poslednú IP adresu používateľa';
$string['user:viewuseractivitiesreport'] = 'Vidieť správy o aktivitách používateľa';
$string['user:viewusergrades'] = 'Prezerať známky používateľa';
$string['usersfrom'] = 'Používatelia z {$a}';
$string['usersfrommatching'] = 'Používatelia z {$a->contextname} vyhovujúci vyhľadávaniu  \'{$a->search}\'';
$string['usersinthisx'] = 'Používatelia v tomto {$a}';
$string['usersinthisxmatching'] = 'Používatelia z tohto kontextu {$a->contextname} vyhovujúci vyhľadávaniu  \'{$a->search}\'';
$string['userswithrole'] = 'Všetci používatelia s rolou';
$string['userswiththisrole'] = 'Používatelia s rolou';
$string['useshowadvancedtochange'] = 'Použiť \'Zobraziť pokročilé\' na zmenu';
$string['viewingdefinitionofrolex'] = 'Zobraziť definíciu roly \'{$a}\'';
$string['viewrole'] = 'Prezerať detaily roly';
$string['webservice:createmobiletoken'] = 'Generovať token webovej služby pre mobilný prístup';
$string['webservice:createtoken'] = 'Vytvoriť token web služby';
$string['webservice:managealltokens'] = 'Správa tokenov webových služieb všetkých používateľov';
$string['whydoesuserhavecap'] = 'Prečo má {$a->fullname} schopnosť {$a->capability} v kontexte {$a->context}?';
$string['whydoesusernothavecap'] = 'Prečo nemá {$a->fullname} schopnosť {$a->capability} v kontexte {$a->context}?';
$string['xroleassignments'] = 'Priradenia rol používateľa {$a}';
$string['xuserswiththerole'] = 'Používatelia s rolou "{$a->role}"';
