<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'nl', version '4.0'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Nieuwe rol toevoegen';
$string['addrole'] = 'Nieuwe rol toevoegen';
$string['advancedoverride'] = 'Geavanceerd rollen overschrijven';
$string['allow'] = 'Toelaten';
$string['allowassign'] = 'Toewijzen van rollen toestaan';
$string['allowed'] = 'Toegelaten';
$string['allowoverride'] = 'Overschrijven van rollen toestaan';
$string['allowroletoassign'] = 'Laat gebruikers met de rol {$a->fromrole} toe om de rol {$a->targetrole} toe te wijzen';
$string['allowroletooverride'] = 'Laat gebruikers met de rol {$a->fromrole} toe om de rol {$a->targetrole} te overschrijven';
$string['allowroletoswitch'] = 'Laat gebruikers met rol {$a->fromrole} van rol te veranderen naar de rol {$a->targetrole}';
$string['allowroletoview'] = 'Sta gebruikers met rol  {$a->fromrole} toe om de rol {$a->targetrole} te bekijken';
$string['allowswitch'] = 'Toestaan van rol te wisselen';
$string['allowview'] = 'Rol bekijken toestaan';
$string['allsiteusers'] = 'Alle sitegebruikers';
$string['analytics:listinsights'] = 'Lijst inzichten';
$string['analytics:listowninsights'] = 'Lijst eigen inzichten';
$string['analytics:managemodels'] = 'Beheer modellen';
$string['archetype'] = 'Rol archetype';
$string['archetype_help'] = 'De archetype rol bepaalt welke rechten een rol krijgt wanneer die terug op standaardinstellingen gezet wordt. Dit bepaalt ook de nieuwe rechten die een rol krijgt wanneer de site geüpgraded wordt';
$string['archetypecoursecreator'] = 'ARCHETYPE: cursusaanmaker';
$string['archetypeeditingteacher'] = 'ARCHETYPE: Leraar (bewerken)';
$string['archetypefrontpage'] = 'ARCHETYPE: Geauthenticeerde gebruikers op de site startpagina';
$string['archetypeguest'] = 'ARCHETYPE: Gast';
$string['archetypemanager'] = 'ARCHETYPE: Beheerder';
$string['archetypestudent'] = 'ARCHETYPE: Leerling';
$string['archetypeteacher'] = 'ARCHETYPE: Leraar (niet bewerken)';
$string['archetypeuser'] = 'ARCHETYPE: Geauthenticeerde gebruiker';
$string['assignanotherrole'] = 'Nog een rol toewijzen';
$string['assignedroles'] = 'Toegewezen rollen';
$string['assignerror'] = 'Fout tijdens het toewijzen van rol {$a->role} aan gebruiker {$a->user}.';
$string['assignglobalroles'] = 'Systeemrollen toewijzen';
$string['assignmentcontext'] = 'Opdrachtcontext';
$string['assignmentoptions'] = 'Opdracht opties';
$string['assignrole'] = 'Wijs rol toe';
$string['assignrolenameincontext'] = 'Wijs rol \'{$a->role}\' toe in {$a->context}';
$string['assignroles'] = 'Rollen toewijzen';
$string['assignroles_help'] = 'Door een gebruiker een rol toe te wijzen binnen een bepaalde context, geef je hem de rechten die bij die rol horen voor deze context en in alle "lagere" contexten.
Bijvoorbeeld: als je een gebruiker de rol "Leerling" geeft binnen een cursus, dan zal die gebruiker die rol hebben voor die cursus, maar ook voor alle blokken en activiteiten binnen die cursus. ';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesin'] = 'Rollen toewijzen in {$a}';
$string['assignrolesrelativetothisuser'] = 'Rollen, relatief tot deze gebruiker toewijzen';
$string['backtoallroles'] = 'Terug naar de lijst met alle rollen';
$string['backup:anonymise'] = 'Maak gebruikersgegevens anoniem tijdens een back-up';
$string['backup:backupactivity'] = 'Back-up activiteiten';
$string['backup:backupcourse'] = 'Back-up cursussen';
$string['backup:backupsection'] = 'Back-up secties';
$string['backup:backuptargetimport'] = 'Back-up voor import';
$string['backup:configure'] = 'Configureer back-upopties';
$string['backup:downloadfile'] = 'Download bestanden van back-upzone';
$string['backup:userinfo'] = 'Back-up van gebruikersgegevens maken';
$string['badges:awardbadge'] = 'Badge uitreiken aan gebruiker';
$string['badges:configurecriteria'] = 'Opstellen/bewerken van criteria voor een badge';
$string['badges:configuredetails'] = 'Opstellen/bewerken van badge-details';
$string['badges:configuremessages'] = 'Badge-berichten configureren';
$string['badges:createbadge'] = 'Badges maken/dupliceren';
$string['badges:deletebadge'] = 'Badges verwijderen';
$string['badges:earnbadge'] = 'Badges verdienen';
$string['badges:manageglobalsettings'] = 'Globale instellingen van badges beheren';
$string['badges:manageownbadges'] = 'Bekijken en beheren van eigen verdiende badges';
$string['badges:revokebadge'] = 'Badge van gebruiker intrekken';
$string['badges:viewawarded'] = 'Bekijk gebruikers die een specifieke badge verdienden zonder zelf badges te kunnen uitreiken';
$string['badges:viewbadges'] = 'Beschikbare badges bekijken zonder ze te verdienen';
$string['badges:viewotherbadges'] = 'Openbare badges in gebruikersprofielen kunnen zien';
$string['block:edit'] = 'Bewerk blokinstellingen';
$string['block:view'] = 'Blok zien';
$string['blog:create'] = 'Nieuwe blog items maken';
$string['blog:manageentries'] = 'Items bewerken en beheren';
$string['blog:manageexternal'] = 'Bewerk en beheer externe blogs';
$string['blog:search'] = 'Zoek blogitems';
$string['blog:view'] = 'Blogitems bekijken';
$string['blog:viewdrafts'] = 'Bekijk concepten van blogs';
$string['calendar:manageentries'] = 'Gelijk welke kalenderitems beheren';
$string['calendar:managegroupentries'] = 'Groepskalenderitems beheren';
$string['calendar:manageownentries'] = 'Eigen kalenderitems beheren';
$string['capabilities'] = 'Mogelijkheden';
$string['capability'] = 'Mogelijkheid';
$string['category:create'] = 'Categorieën maken';
$string['category:delete'] = 'Categorieën verwijderen';
$string['category:manage'] = 'Beheer categorieën';
$string['category:update'] = 'Categorieën updaten';
$string['category:viewcourselist'] = 'Bekijk de cursuscategorie en de cursussen die er in zitten';
$string['category:viewhiddencategories'] = 'Verborgen categorieën bekijken';
$string['category:visibility'] = 'Verborgen categorieën bekijken';
$string['checkglobalpermissions'] = 'Controleer systeemrechten';
$string['checkpermissions'] = 'Controleer rechten';
$string['checkpermissionsin'] = 'Controleer rechten in {$a}';
$string['checksystempermissionsfor'] = 'Controleer systeemrechten voor {$a->fullname}';
$string['checkuserspermissionshere'] = 'Controleer rechten van {$a->fullname} in {$a->contextlevel}';
$string['chooseroletoassign'] = 'Kies een toe te wijzen rol';
$string['cohort:assign'] = 'Site-groepsleden toevoegen en verwijderen';
$string['cohort:manage'] = 'Site-groepen maken, verwijderen en verplaatsen';
$string['cohort:view'] = 'Bekijk site-groepen';
$string['comment:delete'] = 'Verwijder notities';
$string['comment:post'] = 'Post notities';
$string['comment:view'] = 'Bekijk notities';
$string['competency:competencygrade'] = 'Stel het competentiecijfer in';
$string['competency:competencymanage'] = 'Beheer competentiekaders';
$string['competency:competencyview'] = 'Bekijk competentiekaders';
$string['competency:coursecompetencyconfigure'] = 'Configureer competentie instellingen van de cursus';
$string['competency:coursecompetencygradable'] = 'Ontvangen competentiemarkeringen';
$string['competency:coursecompetencymanage'] = 'Beheer cursuscompetenties';
$string['competency:coursecompetencyview'] = 'Bekijk cursuscompetenties';
$string['competency:evidencedelete'] = 'Verwijder bewijsstukken';
$string['competency:plancomment'] = 'Reageer op een studieplan';
$string['competency:plancommentown'] = 'Reageer op je eigen studieplan';
$string['competency:planmanage'] = 'Beheer studieplannen';
$string['competency:planmanagedraft'] = 'Beheer concepten studieplannen';
$string['competency:planmanageown'] = 'Beheer eigen studieplannen';
$string['competency:planmanageowndraft'] = 'Beheer van eigen concepten van studieplannen';
$string['competency:planrequestreview'] = 'Vraag een mening over een studieplan';
$string['competency:planrequestreviewown'] = 'Vraag een mening over je eigen studieplan';
$string['competency:planreview'] = 'Geef je mening over een studieplan';
$string['competency:planview'] = 'Bekijk alle studieplannen';
$string['competency:planviewdraft'] = 'Bekijk concepten van studieplannen';
$string['competency:planviewown'] = 'Bekijk eigen studieplannen';
$string['competency:planviewowndraft'] = 'Bekijk eigen concepten van studieplannen';
$string['competency:templatemanage'] = 'Beheer studieplansjablonen';
$string['competency:templateview'] = 'Bekijk studieplansjablonen';
$string['competency:usercompetencycomment'] = 'Opmerking maken bij een gebruikerscompetentie';
$string['competency:usercompetencycommentown'] = 'Opmerking maken bij eigen gebruikerscompetentie';
$string['competency:usercompetencyrequestreview'] = 'Beoordeling vragen van een gebruikerscompetentie';
$string['competency:usercompetencyrequestreviewown'] = 'Beoordeling vragen van eigen gebruikerscompetentie';
$string['competency:usercompetencyreview'] = 'Beoordeel een gebruikerscompetentie';
$string['competency:usercompetencyview'] = 'Bekijk een gebruikerscompetentie';
$string['competency:userevidencemanage'] = 'Beheer bewijs van vroeger leren';
$string['competency:userevidencemanageown'] = 'Beheer eigen bewijs van vroeger leren';
$string['competency:userevidenceview'] = 'Bekijk bewijs van vroeger leren van een gebruiker';
$string['confirmaddadmin'] = 'Wil je echt gebruiker <strong>{$a}</strong> als nieuwe sitebeheerder toevoegen?';
$string['confirmdeladmin'] = 'Wil je echt gebruiker <strong>{$a}</strong> verwijderen uit de lijst van sitebeheerders?';
$string['confirmroleprevent'] = 'Wil je echt <strong>"{$a->role}"</strong> verwijderen van de lijst met toegelaten rollen voor mogelijkheid "{$a->cap}" in context "{$a->context}"?';
$string['confirmroleunprohibit'] = 'Wil je echt <strong>"{$a->role}"</strong> verwijderen van de lijst met verboden rollen voor mogelijkheid "{$a->cap}" in context "{$a->context}"?';
$string['confirmunassign'] = 'Wil je echt deze rol van deze gebruiker verwijderen?';
$string['confirmunassignno'] = 'Annuleer';
$string['confirmunassigntitle'] = 'Bevestig rolwijziging';
$string['confirmunassignyes'] = 'Verwijder';
$string['contentbank:access'] = 'Toegang tot de inhoudsbank';
$string['contentbank:deleteanycontent'] = 'Verwijder alle inhoud uit de inhoudsbank';
$string['contentbank:deleteowncontent'] = 'Verwijder inhoud uit je eigen inhoudsbank';
$string['contentbank:downloadcontent'] = 'Download inhoud van de inhoudsbank';
$string['contentbank:manageanycontent'] = 'Beheer alle inhoud van de inhoudsbank';
$string['contentbank:manageowncontent'] = 'Beheer inhoud van mijn eigen inhoudsbank';
$string['contentbank:upload'] = 'Upload nieuwe inhoud in de inhoudsbank';
$string['contentbank:useeditor'] = 'Maak of bewerk inhoud met de inhoudstype editor';
$string['contentbank:viewunlistedcontent'] = 'Bekijk niet-vermelde inhoud van de inhoudsbank';
$string['context'] = 'Context';
$string['contextrolenotallowed'] = 'Rol {$a} niet toegestaan in deze context.';
$string['course:activityvisibility'] = 'Tonen/verbergen van activiteiten';
$string['course:bulkmessaging'] = 'Stuur een boodschap naar meerdere gebruikers';
$string['course:changecategory'] = 'Cursuscategorie wijzigen';
$string['course:changefullname'] = 'Wijzig cursusnaam';
$string['course:changeidnumber'] = 'Wijzig cursus IDnummer';
$string['course:changelockedcustomfields'] = 'Verander vergrendelde aangepaste velden';
$string['course:changeshortname'] = 'Wijzig cursus korte naam';
$string['course:changesummary'] = 'Cursussamenvatting wijzigen';
$string['course:configurecustomfields'] = 'Aangepaste velden configureren';
$string['course:configuredownloadcontent'] = 'Configureer download cursusinhoud';
$string['course:create'] = 'Cursussen aanmaken';
$string['course:creategroupconversations'] = 'Maak groepsconversaties';
$string['course:delete'] = 'Cursussen verwijderen';
$string['course:downloadcoursecontent'] = 'Download cursusinhoud';
$string['course:enrolconfig'] = 'Configureer aanmeldingen in cursussen';
$string['course:enrolreview'] = 'Aanmeldingen in cursussen nakijken';
$string['course:ignoreavailabilityrestrictions'] = 'Negeer beschikbaarheidsbeperkingen';
$string['course:ignorefilesizelimits'] = 'Gebruik bestanden die groter zijn dan de bestandsgroottebeperkingen';
$string['course:isincompletionreports'] = 'Te tonen op voltooiingsrapporten';
$string['course:manageactivities'] = 'Activiteiten beheren';
$string['course:managefiles'] = 'Bestanden beheren';
$string['course:managegrades'] = 'Cijfers beheren';
$string['course:managegroups'] = 'Groepen beheren';
$string['course:managescales'] = 'Schalen beheren';
$string['course:markcomplete'] = 'Markeer gebruikers als voltooid in cursus voltooiing';
$string['course:movesections'] = 'Verplaats secties';
$string['course:overridecompletion'] = 'Overschrijf activiteitsvoltooiingsstatus';
$string['course:recommendactivity'] = 'Beveel activiteiten aan bij de activiteitenkiezer';
$string['course:renameroles'] = 'Rollen hernoemen';
$string['course:request'] = 'Nieuwe cursussen aanvragen';
$string['course:reset'] = 'Cursus opruimen';
$string['course:reviewotherusers'] = 'Beoordeel andere gebruikers';
$string['course:sectionvisibility'] = 'Zichtbaarheid van secties beheren';
$string['course:setcurrentsection'] = 'Huidige sectie instellen';
$string['course:setforcedlanguage'] = 'Cursustaal verplichten';
$string['course:tag'] = 'Wijzig cursus-tags';
$string['course:togglecompletion'] = 'Sta gebruikers toe om activiteiten handmatig als voltooid aan te duiden';
$string['course:update'] = 'Cursusinstellingen wijzigen';
$string['course:useremail'] = 'Inschakelen/uitschakelen e-mailadressen';
$string['course:view'] = 'Cursussen zien zonder deel te nemen';
$string['course:viewcoursegrades'] = 'Cijfers van de cursus zien';
$string['course:viewhiddenactivities'] = 'Verborgen activiteiten zien';
$string['course:viewhiddencourses'] = 'Verborgen cursussen zien';
$string['course:viewhiddensections'] = 'Verborgen secties zien';
$string['course:viewhiddenuserfields'] = 'Verborgen gebruikersvelden zien';
$string['course:viewparticipants'] = 'Deelnemers bekijken';
$string['course:viewscales'] = 'Schalen bekijken';
$string['course:viewsuspendedusers'] = 'Geschorste gebruikers zien';
$string['course:visibility'] = 'Cursussen verbergen/tonen';
$string['createrolebycopying'] = 'Een nieuwe rol maken door {$a} te kopiëren';
$string['createthisrole'] = 'Maak deze rol';
$string['currentcontext'] = 'Huidige context';
$string['currentrole'] = 'Huidige rol';
$string['customroledescription'] = 'Aangepaste beschrijving';
$string['customroledescription_help'] = 'Beschrijvingen van standaardrollen worden automatisch vertaald als de aangepaste beschrijving leeg is.';
$string['customrolename'] = 'Aangepaste volledige naam';
$string['customrolename_help'] = 'Namen van standaardrollen worden nu automatisch vertaald als de aangepaste naam leeg is. Je moet een volledige naam geven voor alle aangepaste rollen.';
$string['defaultrole'] = 'Standaard rol';
$string['defaultx'] = 'Standaard: {$a}';
$string['defineroles'] = 'Definieer rollen';
$string['deletecourseoverrides'] = 'Verwijder alle overschrijvingen in de cursus';
$string['deletelocalroles'] = 'Verwijder alle toegewezen rollen';
$string['deleterolesure'] = '<p>Ben je zeker dat je de rol "{$a->name} ({$a->shortname})" wil verwijderen?</p><p>Op dit moment is de rol aan {$a->count} gebruikers toegewezen.</p>';
$string['deletexrole'] = 'Verwijder {$a} rol';
$string['duplicaterole'] = 'Kopieer rol';
$string['duplicaterolesure'] = '<p>Ben je zeker dat je de rol "{$a->name} ({$a->shortname})" wil kopiëren?</p>';
$string['editingrolex'] = 'Rol \'{$a}\' bewerken';
$string['editrole'] = 'Bewerk rol';
$string['editxrole'] = 'Bewerk {$a} rol';
$string['errorbadrolename'] = 'Verkeerde rolnaam';
$string['errorbadroleshortname'] = 'Verkeerde korte rolnaam';
$string['errorexistsrolename'] = 'Rolnaam bestaat al';
$string['errorexistsroleshortname'] = 'Rolnaam bestaat al';
$string['errorroleshortnametoolong'] = 'De korte naam mag niet langer zijn dan 100 tekens';
$string['eventcapabilityassigned'] = 'Mogelijkheid toegewezen';
$string['eventcapabilityunassigned'] = 'Mogelijkheid niet toegewezen';
$string['eventroleallowassignupdated'] = 'Roltoewijzing toestaan';
$string['eventroleallowoverrideupdated'] = 'Rol overschrijven toestaan';
$string['eventroleallowswitchupdated'] = 'Rol wijzigen toestaan';
$string['eventroleallowviewupdated'] = 'Rol bekijken toestaan';
$string['eventroleassigned'] = 'Rol toegewezen';
$string['eventrolecapabilitiesupdated'] = 'Rolmogelijkheden aangepast';
$string['eventroledeleted'] = 'Rol verwijderd';
$string['eventroleunassigned'] = 'Rol niet meer toegewezen';
$string['eventroleupdated'] = 'Rol bijgewerkt';
$string['existingadmins'] = 'Huidige sitebeheerders';
$string['existingusers'] = '{$a} bestaande gebruikers';
$string['explanation'] = 'Verklaring';
$string['export'] = 'Exporteer';
$string['extusers'] = 'Bestaande gebruikers';
$string['extusersmatching'] = 'Bestaande gebruikers die overeen komen met \'{$a}\'';
$string['filter:manage'] = 'Beheer lokale filterinstellingen';
$string['frontpageuser'] = 'Authenticeer gebruikers op de site startpagina';
$string['frontpageuserdescription'] = 'Alle ingelogde gebruikers in de site startpaginacursus.';
$string['globalrole'] = 'Systeem rol';
$string['globalroleswarning'] = 'Waarschuwing: alle rollen die je vanaf deze pagina aan gebruikers toewijst, zullen voor de hele site gelden, de site startpagina en alle cursussen inbegrepen.';
$string['gotoassignroles'] = 'Ga naar Rollen toewijzen voor deze {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Ga naar Systeemrollen toewijzen';
$string['grade:edit'] = 'Cijfers bewerken';
$string['grade:export'] = 'Cijfers exporteren';
$string['grade:hide'] = 'Cijfers of items verbergen/zichtbaar maken';
$string['grade:import'] = 'Cijfers importeren';
$string['grade:lock'] = 'Cijfers of items blokkeren';
$string['grade:manage'] = 'Beoordelingsitems beheren';
$string['grade:managegradingforms'] = 'Beheer geavanceerde beoordelingsmethodes';
$string['grade:manageletters'] = 'Letterbeoordelingen beheren';
$string['grade:manageoutcomes'] = 'Beheer beoordelingsresultaten';
$string['grade:managesharedforms'] = 'Beheer sjablonen voor geavanceerde beoordelingsmethodes';
$string['grade:override'] = 'Beoordelingen wijzigen';
$string['grade:sharegradingforms'] = 'Deel geavanceerd beoordelingsformulier als sjabloon';
$string['grade:unlock'] = 'Beoordelingen of items vrijgeven';
$string['grade:view'] = 'Eigen cijfers bekijken';
$string['grade:viewall'] = 'Cijfers van andere gebruikers bekijken';
$string['grade:viewhidden'] = 'Verborgen cijfer zien';
$string['h5p:deploy'] = 'H5P-inhoud uitrollen';
$string['h5p:setdisplayoptions'] = 'Stel de weergave-opties in voor H5P-inhoud';
$string['h5p:updatelibraries'] = 'Beheer H5P-inhoudstypen';
$string['highlightedcellsshowdefault'] = 'De geselecteerde rechten in onderstaande tabel zijn de standaardrechten voor het hierboven geselecteerde rolarchetype.';
$string['highlightedcellsshowinherit'] = 'De opgelichte cellen in onderstaande tabel tonen de rechten (als die er zijn) die overgeërfd worden. Buiten de mogelijkheden waarvan je de rechten wil aanpassen, moet je alles op Overerven laten staan.';
$string['inactiveformorethan'] = 'langer dan {$a->timeperiod} niet actief';
$string['ingroup'] = 'in de groep "{$a->group}"';
$string['inherit'] = 'Overerven';
$string['invalidpresetfile'] = 'Ongeldig roldefinitiebestand';
$string['legacy:admin'] = 'PRE 1.7 ROL: Beheerder';
$string['legacy:coursecreator'] = 'VEROUDERDE ROL: Cursusaanmaker';
$string['legacy:editingteacher'] = 'PRE 1.7 ROL: Leraar (bewerken)';
$string['legacy:guest'] = 'PRE 1.7 ROL: Gast';
$string['legacy:student'] = 'PRE 1.7 ROL: Leerling';
$string['legacy:teacher'] = 'PRE 1.7 ROL: Leraar (niet bewerken)';
$string['legacy:user'] = 'PRE 1.7 ROL: Ingelogde gebruiker';
$string['legacytype'] = 'Verouderd roltype';
$string['listallroles'] = 'Toon alle rollen';
$string['localroles'] = 'Lokaal toegewezen rollen';
$string['mainadmin'] = 'Hoofdbeheerder';
$string['mainadminset'] = 'Hoofdbeheerder instellen';
$string['manageadmins'] = 'Beheer sitebeheerders';
$string['manager'] = 'Beheerder';
$string['managerdescription'] = 'Beheerders hebben toegang tot cursussen en kunnen die aanpassen, maar gewoonlijk doen zij niet mee in cursussen.';
$string['manageroles'] = 'Beheer rollen';
$string['maybeassignedin'] = 'Contexttypes waarin deze rol mag toegewezen worden';
$string['morethan'] = 'Meer dan {$a}';
$string['multipleroles'] = 'Meerdere rollen';
$string['my:configsyspages'] = 'Configureer systeemsjablonen voor Mijn startpagina\'s';
$string['my:manageblocks'] = 'Blokken op Mijn startpagina beheren';
$string['neededroles'] = 'Rollen met rechten';
$string['nocapabilitiesincontext'] = 'Geen mogelijkheden beschikbaar  in deze context';
$string['noneinthisx'] = 'Niets in deze {$a}';
$string['noneinthisxmatching'] = 'Er komen geen gebruikers overeen met \'{$a->search}\' in dit {$a->contexttype}';
$string['norole'] = 'Geen rol';
$string['noroleassignments'] = 'Deze gebruiker heeft geen roltoewijzingen in deze site';
$string['noroles'] = 'Geen rollen';
$string['notabletoassignroleshere'] = 'Het toewijzen van rollen in deze context is niet ingeschakeld door een beheerder.';
$string['notabletooverrideroleshere'] = 'Je kunt hier geen rollen overschrijven';
$string['notes:manage'] = 'Notities beheren';
$string['notes:view'] = 'Notities bekijken';
$string['notset'] = 'Niet ingesteld';
$string['novisibleroles'] = 'Geen rollen';
$string['overrideanotherrole'] = 'Nog een rol overschrijven';
$string['overridecontext'] = 'Context overschrijven';
$string['overridepermissions'] = 'Rechten overschrijven';
$string['overridepermissions_help'] = '<p>
Overschrijvingen zijn specifieke rechten, bedoeld om alleen in een bepaalde context een rol te overschrijven. Hiermee kun je de rechten van een gebruiker bijregelen waar nodig.
</p>

<p>
Bijvoorbeeld: als gebruikers met de leerling rol in jouw cursus gewoonlijk nieuwe discussies kunnen starten in een forum, maar er is één bepaald forum waar je dat recht wil beperken, dan kun je een overschrijving zetten die het recht van leerlingen om nieuwe discussies te starten VOORKOMT.
</p>

<p>
Overschrijvingen kunnen ook gebruikt worden om delen van je site en cursussen meer open te stellen en gebruikers daar extra rechten te geven waar nodig. Zo zou je bijvoorbeeld kunnen je leerlingen het recht geven om bepaalde opdrachten te beoordelen
</p>

<p>
De interface is gelijkaardig aan die van het definiëren van rollen, behalve dat soms enkel de relevante mogelijkheden getoond worden. Je zult ook sommige mogelijkheden opgelicht zien: die tonen je welke rechten voor die rol actief zouden zijn ZONDER overschrijven actief. (dit is als je overschrijving in ingesteld als OVERERVEN).
</p>

<p>
See also
<a href="help.php?file=roles.html">Rollen</a>,
<a href="help.php?file=contexts.html">Contexten</a>,
<a href="help.php?file=assignroles.html">Rollen toewijzen</a> en
<a href="help.php?file=permissions.html">Rechten</a>.
</p>';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overridepermissionsforrole'] = 'Rechten overschrijven voor de rol \'{$a->role}\' in {$a->context}';
$string['overridepermissionsin'] = 'Rechten overschrijven in {$a}';
$string['overrideroles'] = 'Rollen overschrijven';
$string['overriderolesin'] = 'Rollen overschrijven in {$a}';
$string['overrides'] = 'Rollen overschrijven';
$string['overridesbycontext'] = 'Overschrijvingen (per context)';
$string['payment:manageaccounts'] = 'Beheer accounts';
$string['payment:viewpayments'] = 'Bekijk betalingen';
$string['permission'] = 'Recht';
$string['permission_help'] = 'Rechten zijn instellingen van mogelijkheden. Er zijn 4 opties:

* Niet ingesteld
* Toestaan - Het recht wordt gegeven voor de mogelijkheid
* Blokkeren - Het recht wordt verwijderd voor de mogelijkheid, zelfs als dat toegestaan wordt in een hogere context
* Verbieden - Het recht wordt volledig ontzegd en kan niet overschreven worden in een lagere, meer specifieke context';
$string['permissions'] = 'Rechten';
$string['permissionsforuser'] = 'Rechten voor gebruiker {$a}';
$string['permissionsincontext'] = 'Rechten in {$a}';
$string['portfolio:export'] = 'Exporteer naar portfolio';
$string['potentialusers'] = '{$a} mogelijke gebruikers';
$string['potusers'] = 'Mogelijke gebruikers';
$string['potusersmatching'] = 'Mogelijke gebruikers die overeenkomen met \'{$a}\'';
$string['prevent'] = 'Blokkeren';
$string['privacy:metadata:preference:showadvanced'] = 'Gebruik de geavanceerde modus schakelaar.';
$string['privacy:metadata:role_assignments'] = 'Roltoewijzingen';
$string['privacy:metadata:role_assignments:component'] = 'Plugin, verantwoordelijk voor roltoewijzingen. Leeg wanneer manueel toegewezen.';
$string['privacy:metadata:role_assignments:itemid'] = 'De ID van de aanmelding/authenticatie-instantie die verantwoordelijk is voor deze roltoewijzing';
$string['privacy:metadata:role_assignments:modifierid'] = 'De ID van de gebruiker die deze roltoewijzing maakte of wijzigde';
$string['privacy:metadata:role_assignments:roleid'] = 'De ID van de rol';
$string['privacy:metadata:role_assignments:tableexplanation'] = 'Deze tabel bewaart de toegewezen rollen in elke context.';
$string['privacy:metadata:role_assignments:timemodified'] = 'De datum waarop de roltoewijzing gemaakt of gewijzigd was.';
$string['privacy:metadata:role_assignments:userid'] = 'De ID van de gebruiker';
$string['privacy:metadata:role_capabilities'] = 'Rolmogelijkheden';
$string['privacy:metadata:role_capabilities:capability'] = 'De naam van de mogelijkheid';
$string['privacy:metadata:role_capabilities:modifierid'] = 'De ID van de gebruiker die de mogelijkheid maakte of wijzigde';
$string['privacy:metadata:role_capabilities:permission'] = 'De rechten voor een mogelijkheid: overerven, toelaten, blokkeren, verbieden';
$string['privacy:metadata:role_capabilities:roleid'] = 'De ID van de rol';
$string['privacy:metadata:role_capabilities:tableexplanation'] = 'De mogelijkheden en overschreven mogelijkheden voor een bepaalde rol in een bepaalde context';
$string['privacy:metadata:role_capabilities:timemodified'] = 'De datum waarop de mogelijkheid was gemaakt of gewijzigd.';
$string['privacy:metadata:role_cohortroles'] = 'Rollen voor site-groep';
$string['prohibit'] = 'Verbieden';
$string['prohibitedroles'] = 'Verboden';
$string['question:add'] = 'Nieuwe vragen toevoegen';
$string['question:commentall'] = 'Geef een opmerking op alle vragen';
$string['question:commentmine'] = 'Geef een opmerking op je eigen vragen';
$string['question:config'] = 'Vraagtypes configureren';
$string['question:editall'] = 'Alle vragen bewerken';
$string['question:editmine'] = 'Eigen vragen bewerken';
$string['question:flag'] = 'Zet een vlag bij vragen terwijl je ze probeert';
$string['question:managecategory'] = 'Vraagcategorieën bewerken';
$string['question:moveall'] = 'Alle vragen verplaatsen';
$string['question:movemine'] = 'Eigen vragen verplaatsen';
$string['question:tagall'] = 'Tag alle vragen';
$string['question:tagmine'] = 'Tag je eigen vragen';
$string['question:useall'] = 'Alle vragen gebruiken';
$string['question:usemine'] = 'Eigen vragen gebruiken';
$string['question:viewall'] = 'Alle vragen bekijken';
$string['question:viewmine'] = 'Eigen vragen bekijken';
$string['rating:rate'] = 'Items beoordelen';
$string['rating:view'] = 'Het beoordelingstotaal zien dat je gekregen hebt';
$string['rating:viewall'] = 'Bekijk alle ruwe beoordelingen';
$string['rating:viewany'] = 'Bekijk alle totaalbeoordelingen';
$string['reportbuilder:edit'] = 'Bewerk je eigen aangepaste rapporten';
$string['reportbuilder:editall'] = 'Alle aangepaste rapporten bewerken';
$string['reportbuilder:scheduleviewas'] = 'Planningsrapporten om als andere gebruikers te worden bekeken';
$string['reportbuilder:view'] = 'Aangepaste rapporten bekijken';
$string['resetrole'] = 'Standaardinstellingen';
$string['resettingrole'] = 'Rol \'{$a}\' naar standaardinstellingen';
$string['restore:configure'] = 'Configureer terugzetopties';
$string['restore:createuser'] = 'Gebruikers aanmaken bij terugzetten';
$string['restore:restoreactivity'] = 'Activiteiten terugzetten';
$string['restore:restorecourse'] = 'Cursussen terugzetten';
$string['restore:restoresection'] = 'Secties terugzetten';
$string['restore:restoretargetimport'] = 'Terugzetten van bestanden die import als doel hebben';
$string['restore:rolldates'] = 'Mag data van activiteiten wijzigen bij terugzetten';
$string['restore:uploadfile'] = 'Bestanden uploaden naar back-upzone\'s';
$string['restore:userinfo'] = 'Gebruikersgegevens terugzetten';
$string['restore:viewautomatedfilearea'] = 'Cursussen terugzetten van automatische backups';
$string['risks'] = 'Risico\'s';
$string['role:assign'] = 'Toewijzen van rollen aan gebruikers';
$string['role:manage'] = 'Aanmaken en beheren van rollen';
$string['role:override'] = 'Rechten voor anderen overschrijven';
$string['role:review'] = 'Rechten voor anderen nakijken';
$string['role:safeoverride'] = 'Overschrijf veilige rechten voor anderen';
$string['role:switchroles'] = 'Schakel over naar andere rollen';
$string['roleallowheader'] = 'Rol toestaan:';
$string['roleallowinfo'] = 'Kies een rol om toe te voegen aan de lijst met rollen met toelating in context "{$a->context}", mogelijkheid "{$a->cap}":';
$string['roleassignments'] = 'Roltoewijzingen';
$string['roledefinitions'] = 'Roldefinities';
$string['rolefullname'] = 'Naam';
$string['roleincontext'] = '{$a->role} in {$a->context}';
$string['roleprohibitheader'] = 'Rol verbieden:';
$string['roleprohibitinfo'] = 'Kies een rol om toe te voegen aan de lijst met verboden rollen in context "{$a->context}", mogelijkheid "{$a->cap}":';
$string['rolerepreset'] = 'Gebruik voorinstellingen rol';
$string['roleresetdefaults'] = 'Standaarden';
$string['roleresetrole'] = 'Gebruik rol voor archetype';
$string['rolerisks'] = 'Risico\'s rol';
$string['roles'] = 'Rollen';
$string['roles_help'] = 'Een rol is een verzameling rechten vastgelegd voor het ganse systeem, die je in een specifieke context aan specifieke gebruikers kunt toekennen.';
$string['roles_link'] = 'roles';
$string['roleselect'] = 'Selecteer rol';
$string['rolesforuser'] = 'Rollen voor gebruiker {$a}';
$string['roleshortname'] = 'Korte naam';
$string['roleshortname_help'] = 'De korte rolnaam is een identificatie van de rol op systeemniveau waarin enkel ASCII alfanumerieke tekens toegestaan zijn.';
$string['roletoassign'] = 'Toe te wijzen rol';
$string['roletooverride'] = 'Te overschrijven rol';
$string['safeoverridenotice'] = 'Opmerking: mogelijkheden met hogere risico\'s zijn geblokkeerd omdat je alleen het recht hebt om veilige mogelijkheden te overschrijven';
$string['search:query'] = 'Zoek in heel de site';
$string['selectanotheruser'] = 'Selecteer nog een gebruiker';
$string['selectauser'] = 'Selecteer een gebruiker';
$string['selectrole'] = 'Kies een rol';
$string['showallroles'] = 'Toon alle rollen';
$string['showthisuserspermissions'] = 'Toon de rechten van deze gebruiker';
$string['site:accessallgroups'] = 'Toegang voor alle groepen';
$string['site:approvecourse'] = 'Cursus aanmaken goedkeuren';
$string['site:backup'] = 'Cursussen back-uppen';
$string['site:config'] = 'Site configuratie wijzigen';
$string['site:configview'] = 'Bekijk site-beheer (maar niet alle pagina\'s)';
$string['site:deleteanymessage'] = 'Verwijder berichten van de site';
$string['site:deleteownmessage'] = 'Verwijder berichten verzonden door en aan de gebruiker';
$string['site:doanything'] = 'Toelaten alles te doen';
$string['site:doclinks'] = 'Links naar documentatie buiten deze site tonen';
$string['site:forcelanguage'] = 'Cursustaal overschrijven';
$string['site:import'] = 'Importeren van andere cursussen in een cursus';
$string['site:maintenanceaccess'] = 'Toegang tot de site terwijl die in onderhoudsmodus is.';
$string['site:manageallmessaging'] = 'Toevoegen, verwijderen, blokkeren en deblokkeren contacten voor elke gebruiker';
$string['site:manageblocks'] = 'Beheer blokken op een pagina';
$string['site:managecontextlocks'] = 'Het bevriezen van contexten beheren';
$string['site:messageanyuser'] = 'Negeer privacy-instellingen van gebruikers om alle gebruikers een bericht te kunnen sturen';
$string['site:mnetloginfromremote'] = 'Aanmelden vanaf een externe Moodle met MNet';
$string['site:mnetlogintoremote'] = 'Ga naar een externe Moodle met MNet';
$string['site:readallmessages'] = 'Alle berichten op de site lezen';
$string['site:restore'] = 'Cursussen terugzetten';
$string['site:senderrormessage'] = 'Stuur een bericht naar de ondersteunende gebruiker vanaf de foutpagina';
$string['site:sendmessage'] = 'Stuur berichten naar gelijk welke gebruiker';
$string['site:trustcontent'] = 'Ingestuurde inhoud vertrouwen';
$string['site:uploadusers'] = 'Nieuwe gebruikers uploaden van een bestand';
$string['site:viewanonymousevents'] = 'Bekijk anonieme gebeurtenissen in rapporten';
$string['site:viewfullnames'] = 'Altijd volledige namen van gebruikers zien';
$string['site:viewparticipants'] = 'Deelnemers bekijken';
$string['site:viewreports'] = 'Rapporten bekijken';
$string['site:viewuseridentity'] = 'Bekijk de volledige gebruikersidentiteit in lijsten';
$string['siteadministrators'] = 'Sitebeheerders';
$string['tag:edit'] = 'Bestaande tags bewerken';
$string['tag:editblocks'] = 'Bewerk blokken op tag-pagina';
$string['tag:flag'] = 'Rapporteer als ongeschikt';
$string['tag:manage'] = 'Alle tags bewerken';
$string['thisnewrole'] = 'Deze nieuwe rol';
$string['thisusersroles'] = 'De roltoewijzingen van deze gebruiker';
$string['unassignarole'] = 'Verwijder toewijzing rol {$a}';
$string['unassignconfirm'] = 'Wil je echt de toewijzing van rol "{$a->role}" verwijderen van gebruiker "{$a->user}"?';
$string['unassignerror'] = 'Fout tijdens het verwijderen van de rol {$a->role} van gebruiker {$a->user}.';
$string['user:changeownpassword'] = 'Eigen wachtwoord wijzigen';
$string['user:create'] = 'Gebruikers aanmaken';
$string['user:delete'] = 'Gebruikers verwijderen';
$string['user:editmessageprofile'] = 'Bewerk berichtenprofiel';
$string['user:editownmessageprofile'] = 'Bewerk jouw berichtenprofiel';
$string['user:editownprofile'] = 'Eigen profiel wijzigen';
$string['user:editprofile'] = 'Gebruikersprofielen bewerken';
$string['user:ignoreuserquota'] = 'Gebruikersquota negeren';
$string['user:loginas'] = 'Aanmelden als andere gebruikers';
$string['user:manageblocks'] = 'Beheer blokken op gebruikersprofiel van anderen';
$string['user:manageownblocks'] = 'Beheer blokken op eigen publiek gebruikersprofiel';
$string['user:manageownfiles'] = 'Beheer bestanden op eigen private bestandszone';
$string['user:managesyspages'] = 'Configureer standaard pagina layout voor publieke gebruikersprofielen';
$string['user:readuserblogs'] = 'Blogs van alle gebruikers bekijken';
$string['user:readuserposts'] = 'Forumberichten van alle gebruikers bekijken';
$string['user:update'] = 'Gebruikersprofielen updaten';
$string['user:viewalldetails'] = 'Bekijk alle informatie van de gebruiker';
$string['user:viewdetails'] = 'Gebruikersprofielen bekijken';
$string['user:viewhiddendetails'] = 'Verborgen details van gebruikers bekijken';
$string['user:viewlastip'] = 'Laatste IP-adres van alle gebruikers bekijken';
$string['user:viewuseractivitiesreport'] = 'Activiteitenrapporten van gebruikers bekijken';
$string['user:viewusergrades'] = 'Cijfers van gebruikers bekijken';
$string['usersfrom'] = 'Gebruikers van {$a}';
$string['usersfrommatching'] = 'Gebruikers van  {$a->contextname} die overeenkomen met \'{$a->search}\'';
$string['usersinthisx'] = 'Gebruikers in deze {$a}';
$string['usersinthisxmatching'] = 'Gebruikers in dit {$a->contexttype} die overeenkomen met \'{$a->search}\'';
$string['userswithrole'] = 'Alle gebruikers met een rol';
$string['userswiththisrole'] = 'Gebruikers met rol';
$string['useshowadvancedtochange'] = 'Gebruik \'Toon geavanceerd\' om te wijzigen';
$string['viewingdefinitionofrolex'] = 'Bekijk de definities van rol \'{$a}\'';
$string['viewrole'] = 'Roldetails bekijken';
$string['webservice:createmobiletoken'] = 'Maak een web service token voor mobiele toegang';
$string['webservice:createtoken'] = 'Maak een webservice token';
$string['webservice:managealltokens'] = 'Beheer alle service tokens van gebruikers';
$string['whydoesuserhavecap'] = 'Waarom heeft  {$a->fullname} de mogelijkheid  {$a->capability} in context  {$a->context}?';
$string['whydoesusernothavecap'] = 'Waarom heeft  {$a->fullname} de mogelijkheid  {$a->capability} niet in context  {$a->context}?';
$string['xroleassignments'] = 'Roltoewijzingen van {$a}';
$string['xuserswiththerole'] = 'Gebruikers met de rol "{$a->role}"';
