<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_xp', language 'zh_cn', version '4.0'.
 *
 * @package     block_xp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = '动作';
$string['activityoresourceis'] = '活动或资源是{$a}';
$string['addacondition'] = '添加条件';
$string['addarule'] = '添加规则';
$string['addinstructions'] = '添加更多信息';
$string['additionalresources'] = '添加资源';
$string['addoninstallationerror'] = '我们检测到插件(local_xp)的问题，它似乎没有正确安装。管理员应完成其安装。';
$string['addrulesformhelp'] = '最后一列定义了满足条件时获得的经验点数。';
$string['admindefaultrulesintro'] = '以下规则将用作添加课程的默认规则。';
$string['admindefaultsettingsintro'] = '当将新板块添加到课程时，会使用以下默认设置。可以锁定某些设置，从而强制插件的所有实例都不能更改该项设置。';
$string['admindefaultvisualsintro'] = '这将是一种错误的做法，因为这是一个重要的问题。';
$string['anonymity'] = '匿名';
$string['anonymity_help'] = '此设置控制参与者是否可以看到彼此的姓名和头像。';
$string['awardaxpwhen'] = '<strong>{$a}</strong> 积分获得：';
$string['basexp'] = '算法库';
$string['blockappearance'] = '块外观';
$string['cachedef_filters'] = '等级过滤';
$string['cachedef_ruleevent_eventslist'] = '事件列表';
$string['cannotshowblockconfig'] = '我通常会在这里显示外观设置，但找不到您的块。要更改块的外观，请返回[here]({$a})（或添加块的位置），打开编辑模式，然后按照块下拉列表中的“配置”选项进行操作。如果找不到该块，请将其重新添加到课程中。';
$string['cannotshowblockconfigsys'] = '我通常会在这里显示外观设置，但找不到您的块。您的 [front page]({$a->fp}) 和[default dashboard]({$a->mysys})中可能缺少它，或者两者都存在。若要从此处编辑设置，请确保它仅显示在其中一个设置中。';
$string['changelevelformhelp'] = '如果更改级别，则将临时禁用自定义级别的徽章，以防止改级别没有徽章。
请转到“视觉”页，在保存此表单后重新启用自定义徽章。';
$string['cheatguard'] = '防作弊守护';
$string['clicktoselectcm'] = '单击以选择活动或资源';
$string['cmselector'] = '课程模块选择器';
$string['coefxp'] = '算法系数';
$string['colon'] = '{$a->a}: {$a->b}';
$string['configdescription'] = '介绍';
$string['configdescription_help'] = '一个简短的介绍显示在块中，低于学生等级。学生可以选择忽略，将不会再出现。';
$string['configheader'] = '设置';
$string['configrecentactivity'] = '显示最近的奖励';
$string['configrecentactivity_help'] = '启用后，该块将显示最近奖励学生分数事件的简短列表。';
$string['configtitle'] = '标题';
$string['configtitle_help'] = '块的标题。';
$string['congratulationsyouleveledup'] = '祝贺你！';
$string['coolthanks'] = '谢谢！';
$string['courselog'] = '课程日志';
$string['coursereport'] = '课程报告';
$string['courserules'] = '课程规则';
$string['courseselectedcolon'] = '所选课程：';
$string['coursesettings'] = '课程设置';
$string['coursevisuals'] = '默认视效';
$string['customizelevels'] = '自定义级别';
$string['dangerzone'] = '风险区域';
$string['defaultlevels'] = '默认级别';
$string['defaultrules'] = '默认规则';
$string['defaultrulesformhelp'] = '这些是插件提供的默认规则，它们自动给出默认点并忽略一些冗余事件。你自己的规则优先于它们。';
$string['defaultsettings'] = '默认设置';
$string['defaultvisuals'] = '默认视效';
$string['deletecondition'] = '删除条件';
$string['deleterule'] = '删除规则';
$string['description'] = '描述';
$string['difference'] = '差异';
$string['discoverlevelupplus'] = '获得等级提升。';
$string['dismissnotice'] = '驳回通知';
$string['displayeveryone'] = '显示所有人';
$string['displaynneighbours'] = '显示{$a}邻近用户。';
$string['displayoneneigbour'] = '显示一个邻近用户。';
$string['displayparticipantsidentity'] = '显示参与者身份';
$string['displayrank'] = '显示等级';
$string['displayrelativerank'] = '显示相对排名';
$string['documentation'] = '文档';
$string['editinstructions'] = '编辑信息';
$string['enablecheatguard'] = '启用防作弊';
$string['enablecheatguard_help'] = '防作弊提供了一种简单机制，防止学生作弊，例如不停地刷新同一页，或者反复重复相同的操作。

[详细信息](https://levelup.plus/docs/article/level-up-cheat-guard?ref=blockxp_help)';
$string['enableinfos'] = '启用信息页';
$string['enableinfos_help'] = '设置为“否”时，学生将无法查看信息页。';
$string['enableladder'] = '启用名次';
$string['enableladder_help'] = '当设置为“否”时，学生将无法查看名次。';
$string['enablelevelupnotif'] = '启用升级通知';
$string['enablelevelupnotif_help'] = '当设置为“是”时，学生将显示一个弹出窗口，祝贺他们达到新的水平。';
$string['enablelogging'] = '启用日志记录';
$string['enablexpgain'] = '启用积分获取';
$string['enablexpgain_help'] = '_block/xp:earnxp_.设置为“否”时，课程中无法获得分数。这有助于冻结获得的点，或在某个时间点启用它。

请注意，这也可以使用功能 _block/xp:earnxp_ 进行更精细的控制。';
$string['entersearchterm'] = '输入搜索词';
$string['errorcontextcoursemismatchforwholesite'] = '此<em>升级!</ em>页的URL与当前插件配置不匹配。当前的配置声明<em>升级!</ em>将“用于整个站点”，但此页面希望将其用于“每门课程”。请在 <a href="{$a-> nexturl}“>单击此处</a> 以导航到正确的页面。如要更改配置，请搜索管理员设置“block_xp_context”。';
$string['errorformvalues'] = '表单值中存在一些问题，请修复它们。';
$string['errorlevelsincorrect'] = '最低级别数为2';
$string['errornotalllevelsbadgesprovided'] = '没有提供所有级别的徽章。缺少: {$a}';
$string['errorunknownevent'] = '错误：未知事件';
$string['errorunknownmodule'] = '错误：未知模块';
$string['errorxprequiredlowerthanpreviouslevel'] = '所需分数低于或等于上一级。';
$string['event_user_leveledup'] = '用户升级';
$string['eventis'] = '事件是{$a}';
$string['eventname'] = '事件名称';
$string['eventproperty'] = '事件属性';
$string['eventsrules'] = '事件规则';
$string['eventtime'] = '事件时间';
$string['filtermodules'] = '过滤模块';
$string['for1day'] = '1天';
$string['for1month'] = '1月';
$string['for1week'] = '1星期';
$string['for3days'] = '3天';
$string['forever'] = '永远';
$string['forthewholesite'] = '整个站点';
$string['give'] = '给予';
$string['gotofullladder'] = '转到全部名次';
$string['hideparticipantsidentity'] = '隐藏参与者身份';
$string['hiderank'] = '隐藏等级';
$string['incourses'] = '在课程中';
$string['ineffective'] = '无效的';
$string['infos'] = '消息';
$string['invalidxp'] = '无效的分值';
$string['keeplogs'] = '保存日志';
$string['ladder'] = '';
$string['ladderadditionalcols'] = '附加列';
$string['ladderadditionalcols_help'] = '此设置确定名次上显示的其它列。单击以选择多个列或取消选择所选列时，请按ctrl或cmd键。';
$string['ladderempty'] = '名次当前是空的，请稍后再来！';
$string['level'] = '等级';
$string['levelbadges'] = '等级徽章';
$string['levelbadgesformhelp'] = '将文件命名为[level].[file extension]，例如1.png、2.jpg等。建议的图像大小为100x100。';
$string['levelcount'] = '等级总数';
$string['leveldesc'] = '等级描述';
$string['levels'] = '等级';
$string['levelswillbereset'] = '警告！保存此表单将重新计算所有人的级别！';
$string['levelup'] = '升级了！';
$string['levelupplus'] = '升级啦！';
$string['levelx'] = '等级 #{$a}';
$string['likenotice'] = '<strong>你喜欢这个插件吗？</strong>
请花点时间将其添加到您最喜欢的网站上。';
$string['limitparticipants'] = '限制参与者';
$string['limitparticipants_help'] = '此设置控制显示在排行榜中的人。邻居是指排名高于或低于当前用户的参与者。例如，当选择“显示2个邻居”时，只显示排名直接高于或低于当前用户的两个参与者。';
$string['logging'] = '登录中';
$string['maxactionspertime'] = '范围时间内的最大操作数';
$string['maxactionspertime_help'] = '在给定的时间范围内，将计算点数的最大操作数。任何后续操作都将被忽略。如果该值为空或等于零，则不适用。';
$string['movecondition'] = '移动条件';
$string['moverule'] = '移动规则';
$string['navinfos'] = '信息';
$string['navladder'] = '名次';
$string['navlevels'] = '等级';
$string['navlog'] = '日志';
$string['navpromo'] = '提升';
$string['navreport'] = '报告';
$string['navrules'] = '规则';
$string['navsettings'] = '设置';
$string['navvisuals'] = '视效';
$string['participant'] = '参与者';
$string['participatetolevelup'] = '参与课程，获得经验点并升级！';
$string['pickaconditiontype'] = '选择条件类型';
$string['pluginname'] = '升级啦！';
$string['pointsintimelinker'] = '每';
$string['pointsrequired'] = '需要积分';
$string['privacy:metadata:log'] = '存储事件日志';
$string['privacy:metadata:log:eventname'] = '事件名称';
$string['privacy:metadata:log:time'] = '发生的日期';
$string['privacy:metadata:log:userid'] = '获得分数的用户';
$string['privacy:metadata:log:xp'] = '本活动获得积分';
$string['privacy:metadata:prefintro'] = '记录用户是否取消块的简介';
$string['privacy:metadata:preflevelup'] = '记录用户是否应查看升级通知';
$string['privacy:metadata:prefnotices'] = '记录用户是否关闭支持通知';
$string['privacy:metadata:prefseenpromo'] = '用户查看促销页面时的记录';
$string['privacy:metadata:xp'] = '存储用户的点数和级别';
$string['privacy:metadata:xp:lvl'] = '用户级别';
$string['privacy:metadata:xp:userid'] = '用户';
$string['privacy:metadata:xp:xp'] = '用户积分';
$string['privacy:path:addon'] = '添加';
$string['privacy:path:level'] = '等级';
$string['privacy:path:logs'] = '日志';
$string['progress'] = '进展';
$string['promocontactintro'] = '更多信息请联系我们。我们不会咬人，我们会迅速回复！';
$string['promocontactus'] = '取得联系';
$string['promoemailusat'] = '邮件发送到 _levelup@branchup.tech_.';
$string['promoerrorsendingemail'] = '哎哟！我们无法发送消息…请直接发电子邮件至: {$a}。谢谢！';
$string['promoifpreferemailusat'] = 'PSST！如果您愿意，请直接发邮件到_{$a}_。';
$string['promointro'] = '升级的附加组件！释放出它的全部潜能！';
$string['promoyourmessagewassent'] = '谢谢，您的信息已发送。我们很快会给你答复的。';
$string['property:action'] = '事件动作';
$string['property:component'] = '事件组件';
$string['property:crud'] = '事件CRUD';
$string['property:eventname'] = '事件名称';
$string['property:target'] = '事件目标';
$string['rank'] = '等级';
$string['ranking'] = '排名';
$string['ranking_help'] = '等级是当前用户在名次中的绝对位置。相对排名是用户与其邻居在体验点上的差异。';
$string['reallyresetallcoursestodefaults'] = '是否将所有课程规则重置为默认规则？这个动作是不可逆的。';
$string['reallyresetcourserulestodefaults'] = '是否确定将课程规则重置为默认规则？这个动作是不可逆的。';
$string['reallyresetdata'] = '是否重置本课程中每个人的级别和点数？';
$string['reallyresetgroupdata'] = '确定要重置这个组中每个人的级别和点数吗？';
$string['reallyreverttopluginsdefaults'] = '确实要将默认规则重置为插件建议的默认值吗？这个动作是不可逆的。';
$string['recentrewards'] = '近期奖励';
$string['requires'] = '要求';
$string['resetallcoursestodefaults'] = '将所有课程重置为默认值';
$string['resetallcoursestodefaultsintro'] = '单击下面的按钮将所有课程重置为上述默认值。';
$string['resetcoursedata'] = '重置课程数据';
$string['resetcourserulestodefaults'] = '将课程规则重置为默认值';
$string['resetgroupdata'] = '重置组数据';
$string['reverttopluginsdefaults'] = '还原为插件的默认值';
$string['reverttopluginsdefaultsintro'] = '如果要将上述默认值恢复为插件的默认值，请使用下面的按钮。这不会影响现有课程中的规则。';
$string['reward'] = '奖赏';
$string['rule'] = '规则';
$string['rule:contains'] = '包含';
$string['rule:eq'] = '等于';
$string['rule:eqs'] = '严格等于';
$string['rule:gt'] = '大于';
$string['rule:gte'] = '大于或等于';
$string['rule:lt'] = '小于';
$string['rule:lte'] = '小于或等于';
$string['rule:regex'] = '匹配正则表达式';
$string['rulecm'] = '活动或资源';
$string['rulecm_help'] = '当事件发生在指定的活动或资源中时，满足此条件。';
$string['rulecmdesc'] = '活动或资源是\'{$a->contextname}\'.';
$string['rulecmdescwithcourse'] = '活动或资源是\'{$a->contextname}\' in \'{$a->coursename}\'.';
$string['ruleevent'] = '特定事件';
$string['ruleeventdesc'] = '事件是\'{$a->eventname}\\';
$string['ruleproperty'] = '事件属性';
$string['rulepropertydesc'] = '属性\'{$a->property}\' {$a->compare} \'{$a->value}\'.';
$string['ruleset'] = '条件集';
$string['ruleset:all'] = '所有的条件都是真';
$string['ruleset:any'] = '任何条件都是真';
$string['ruleset:none'] = '所有的条件都不是真';
$string['rulesformhelp'] = '<p>这个插件利用事件将点属性化为学生执行的操作。您可以使用下面的表单添加自己的规则并查看默认规则。</p>';
$string['searchandselectcourse'] = '搜索并选择课程';
$string['searchandselectmodule'] = '搜索并选择活动或资源';
$string['send'] = '发送';
$string['shortcode:xpbadge'] = '与当前用户级别匹配的徽章。';
$string['shortcode:xpiflevel'] = '当前用户级别匹配时显示内容。';
$string['shortcode:xpiflevel_help'] = '请参阅下面的示例来格式化此短代码。如果严格指定级别，则无论其他规则如何，都将显示内容。

“大于”和“小于”规则必须与要显示的内容完全匹配。当心，因为这有时会导致内容永远无法显示！

请注意，教师或其他具有编辑功能的用户将始终看到所有内容。
```
[xpiflevel 1 3 5]
    如果用户的级别正好是1、3或5，则显示。
[/xpiflevel]

[xpiflevel >3]
    用户级别大于3时显示。
[/xpiflevel]

[xpiflevel >=3]
    当用户级别大于或等于3时显示。
[/xpiflevel]

[xpiflevel >=10 <20 30]
    用户级别大于或等于10且严格小于20时显示
    或者正好等于30。
[/xpiflevel]

[xpiflevel <=10 >=20]
    从不显示，因为用户的级别不能小于或等于10，也不能大于或等于20。
[/xpiflevel]
```
注意，这些短代码不能相互嵌套。';
$string['shortcode:xpladder'] = '显示当前用户排名周围的部分名次。';
$string['shortcode:xpladder_help'] = '```
[xpladder]
```

到完整名次的链接将自动显示在表格下方，如果不想显示此类链接，请添加参数"hidelink"。

```
[xpladder hidelink]
```

默认情况下，该表不包括显示进度条的进度列。如果在名次设置的其他列中选择了此类列，则可以使用参数"withprogress"来显示它。

```
[xpladder withprogress]
```

请注意，当一个课程使用组时，梯形图最能猜测显示哪个组的梯形图。';
$string['shortcode:xpprogressbar'] = '当前用户进入下一级别的进度条。';
$string['someoneelse'] = '其他人';
$string['somethinghappened'] = '发生了什么事';
$string['taskcollectionloggerpurge'] = '清除收集日志';
$string['timebetweensameactions'] = '相同操作之间所需的时间';
$string['timebetweensameactions_help'] = '再次接受以前已发生操作之前所需的最短时间。如果一个行为被放在相同的上下文和对象中，那么它被认为是相同的；如果再次阅读同一篇文章，那么阅读论坛文章将被认为是相同的。如果该值为空或等于零，则不适用。';
$string['timeformaxactions'] = '最大动作的时间范围';
$string['timeformaxactions_help'] = '用户不应超过最大操作数的时间范围（秒）。';
$string['tinytimedays'] = '{$a}d';
$string['tinytimehours'] = '{$a}h';
$string['tinytimeminutes'] = '{$a}m';
$string['tinytimenow'] = 'now';
$string['tinytimeolderyearformat'] = '%b %Y';
$string['tinytimeseconds'] = '{$a}s';
$string['tinytimeweeks'] = '{$a}w';
$string['tinytimewithinayearformat'] = '%b %e';
$string['total'] = 'Total';
$string['unknowneventa'] = '未知事件 ({$a})';
$string['updateandpreview'] = '更新和预览';
$string['urlaccessdeprecated'] = '不推荐使用此URL访问，请更新链接。';
$string['usealgo'] = '使用算法';
$string['usecustomlevelbadges'] = '使用自定义级别徽章';
$string['usecustomlevelbadges_help'] = '当设置为“是”时，必须为每个级别提供图片。';
$string['value'] = '值';
$string['valuessaved'] = '值已成功保存。';
$string['viewtheladder'] = '名次视图';
$string['visualsintro'] = '上传图像以自定义级别的外观。';
$string['wewillreplyat'] = '我们将于答复 _{$a}_.';
$string['when'] = '如果';
$string['wherearexpused'] = '积分在哪里使用？';
$string['wherearexpused_desc'] = '当设置为“在课程中”时，获得的分数将仅说明添加了块的课程。当设置为“针对整个站点”时，用户将在站点中“升级”，而不是按课程选择，将使用整个站点获得的所有点。';
$string['whoops'] = '哎哟！';
$string['xp'] = '经验点数';
$string['xp:addinstance'] = '添加新的块';
$string['xp:earnxp'] = '赚取积分';
$string['xp:myaddinstance'] = '将块添加到我的仪表板';
$string['xp:view'] = '查看块及其相关页';
$string['xpgaindisabled'] = '禁止获得积分';
$string['xprequired'] = '需要的XP';
$string['xptogo'] = '[[{$a}]] 至';
$string['youreachedlevela'] = '你已升至{$a}级!';
$string['yourmessage'] = '你的信息';
$string['yourownrules'] = '你自己的规则';
