<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'feedback', language 'sl', version '4.0'.
 *
 * @package     feedback
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_item'] = 'Dodaj vprašanje';
$string['add_pagebreak'] = 'Dodajte prelom strani';
$string['adjustment'] = 'Prilagoditev';
$string['after_submit'] = 'Po oddaji';
$string['allowfullanonymous'] = 'Dovolite popolno anonimnost';
$string['analysis'] = 'Analiza';
$string['anonymous'] = 'Anonimno';
$string['anonymous_edit'] = 'Zapiši imena uporabnikov';
$string['anonymous_entries'] = 'Anonimni vnosi ({$a})';
$string['anonymous_user'] = 'Anonimen uporabnik';
$string['answerquestions'] = 'Odgovorite na vprašanja';
$string['append_new_items'] = 'Pripnite nove postavke';
$string['autonumbering'] = 'Samodejno oštevilčenje vprašanja';
$string['autonumbering_help'] = 'Omogočite ali onemogočite samodejno oštevilčenje vsakega vprašanja';
$string['average'] = 'Povprečje';
$string['bold'] = 'Krepko';
$string['calendarend'] = '{$a} se zapre';
$string['calendarstart'] = '{$a} se odpre';
$string['cannotaccess'] = 'Do te pripombe lahko dostopate samo iz predmeta';
$string['cannotsavetempl'] = 'Shranjevanje predlog ni dovoljeno';
$string['captcha'] = 'Test CAPTCHA';
$string['captchanotset'] = 'Captcha ni bil nastavljen.';
$string['check'] = 'Izbirno - več odgovorov';
$string['check_values'] = 'Možni odgovori';
$string['checkbox'] = 'Več izbir - dovoljenih je več odgovorov (označite polja)';
$string['choosefile'] = 'Izberite datoteko';
$string['chosen_feedback_response'] = 'Izbran odgovor na pripombo';
$string['closebeforeopen'] = 'Končni datum ste določili pred začetnim datumom.';
$string['complete_the_form'] = 'Odgovorite na vprašanja';
$string['completed'] = 'Zaključeno';
$string['completed_feedbacks'] = 'Oddani odgovori';
$string['completedon'] = 'Končano {$a}';
$string['completiondetail:submit'] = 'Oddajte vprašalnik';
$string['completionsubmit'] = 'Poglejte kot dokončano, če je oddana pripomba';
$string['configallowfullanonymous'] = 'Če je nastavljeno na \'ja\', lahko uporabniki zaključijo dejavnost pripombe na prvi strani brez predhodne prijave.';
$string['confirmdeleteentry'] = 'Ste prepričani, da želite izbrisati ta vnos?';
$string['confirmdeleteitem'] = 'Ste prepričani, da želite izbrisati ta element?';
$string['confirmdeletetemplate'] = 'Ste prepričani, da želite izbrisati to predlogo?';
$string['confirmusetemplate'] = 'Ste prepričani, da želite uporabiti to predlogo?';
$string['continue_the_form'] = 'Nadaljuj z odgovarjanjem na vprašanja';
$string['count_of_nums'] = 'Seštevek števil';
$string['courseid'] = 'ID predmeta';
$string['creating_templates'] = 'Shranite ta vprašanja kot novo predlogo';
$string['delete_entry'] = 'Izbriši vnos';
$string['delete_item'] = 'Izbrišite vprašanje';
$string['delete_old_items'] = 'Izbrišite stare elemente';
$string['delete_pagebreak'] = 'Izbrišite prelom strani';
$string['delete_template'] = 'Izbrišite predlogo';
$string['delete_templates'] = 'Izbrišite predlogo ...';
$string['depending'] = 'Odvisnosti';
$string['depending_help'] = 'Mogoče je pokazati element, ki je odvisen od vrednosti drugega elementa.<br />
<strong>Tukaj je primer:</strong><br />
<ul>
<li>Najprej ustvarite element, od katerega bo odvisen drug element.</li>
<li>Nato dodajte prelom strani.</li>
<li>Nato dodajte elemente, ki so odvisni od vrednosti prej ustvarjenih elementov. S seznama izberite element, ki je označen z "odvisni element" in v polje za besedilo vnesite zahtevano vrednost, ki je označena z "odvisna vrednost".</li>
</ul>
<strong>Struktura elementa bi morala biti prikazana tako.</strong>
<ol>
<li>Element Q: Ali imate avto? A: ja/ne</li>
<li>Prelom strani</li>
<li>Element Q: Kakšne barve je vaš avto?<br />
(ta element je odvisen od elementa 1 z vrednostjo = ja)</li>
<li>Element Q: Zakaj nimate avta?<br />
(ta element je odvisen od elementa 1 z vrednostjo = ne)</li>
<li> ... ostali elementi</li>
</ol>';
$string['dependitem'] = 'Odvisni element';
$string['dependvalue'] = 'Odvisna vrednost';
$string['description'] = 'Opis';
$string['do_not_analyse_empty_submits'] = 'Ne analizirajte praznih oddaj';
$string['downloadresponseas'] = 'Prenesi vse odgovore kot:';
$string['drop_feedback'] = 'Odstranite iz tega predmeta';
$string['dropdown'] = 'Več izbir - dovoljen je samo en odgovor (spustni meni)';
$string['dropdown_values'] = 'Odgovori';
$string['dropdownlist'] = 'Izbirno - en odgovor (spustni meni)';
$string['dropdownrated'] = 'Spustni seznam (ocenjen)';
$string['edit_item'] = 'Uredi vprašanje';
$string['edit_items'] = 'Uredi vprašanja';
$string['email_notification'] = 'Omogočite obvestila o oddajah';
$string['email_notification_help'] = 'Če je omogočeno, bodo učitelji prejeli obvestilo o oddaji pripomb.';
$string['emailteachermail'] = 'Oseba {$a->username} je zaključila dejavnost pripomb: \'{$a->feedback}\'

Lahko si jih ogledate tukaj:

{$a->url}';
$string['emailteachermailhtml'] = '<p>{$a->username} je zaključil odziv: <i>\'{$a->feedback}\'</i><br /><br />
Lahko ga pogledate <a href="{$a->url}">here</a>.</p>';
$string['entries_saved'] = 'Vaši odgovori so shranjeni. Hvala.';
$string['eventresponsedeleted'] = 'Odgovor je izbrisan';
$string['eventresponsesubmitted'] = 'Odgovor je oddan';
$string['export_questions'] = 'Izvozite vprašanja';
$string['export_to_excel'] = 'Izvozite v Excel';
$string['feedback:addinstance'] = 'Dodajte nove odzive';
$string['feedback:complete'] = 'Zaključite odziv';
$string['feedback:createprivatetemplate'] = 'Ustvarite zasebno predlogo';
$string['feedback:createpublictemplate'] = 'Ustvarite javno predlogo';
$string['feedback:deletesubmissions'] = 'Izbrišite končane prispevke';
$string['feedback:deletetemplate'] = 'Izbrišite predlogo';
$string['feedback:edititems'] = 'Uredite elemente';
$string['feedback:mapcourse'] = 'Preslikajte predmete v globalne pripombe';
$string['feedback:receivemail'] = 'Prejmite e-obvestilo';
$string['feedback:view'] = 'Oglejte si pripombo';
$string['feedback:viewanalysepage'] = 'Oglejte si stran z analizo po oddaji';
$string['feedback:viewreports'] = 'Ogled poročil';
$string['feedback_is_not_for_anonymous'] = 'Odziv ni za anonimne uporabnike';
$string['feedback_is_not_open'] = 'Pripombe niso odprte';
$string['feedbackclose'] = 'Dovolite odgovore na';
$string['feedbackcompleted'] = '{$a->username} je zaključil {$a->feedbackname}';
$string['feedbackopen'] = 'Dovolite odgovore iz';
$string['file'] = 'Datoteka';
$string['filter_by_course'] = 'Filtriraj po predmetu';
$string['handling_error'] = 'Prišlo je do napake pri upravljanju z dejavnostjo modula pripomb';
$string['hide_no_select_option'] = 'Skrijte "neoznačene" nastavitve';
$string['horizontal'] = 'Vodoravno';
$string['import_questions'] = 'Uvozite vprašanja';
$string['import_successfully'] = 'Uvoz je uspel';
$string['importfromthisfile'] = 'Uvozi iz te datoteke';
$string['includeuserinrecipientslist'] = 'Vključi {$a} v seznam prejemnikov';
$string['indicator:cognitivedepth'] = 'Odziv kognitivno';
$string['indicator:cognitivedepth_help'] = 'Ta identifikator temelji na kognitivni globini, ki jo je udeleženec dosegel v dejavnosti odziva.';
$string['indicator:cognitivedepthdef'] = 'Odziv kognitivno';
$string['indicator:cognitivedepthdef_help'] = 'Sodelujoči je dosegel ta odstotek kognitivnega udejstvovanja, ki ga ponuja dejavnost Odziv med izbranim intervalom analize (ravni= brez ogleda, ogled, oddaja)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Odziv socialno';
$string['indicator:socialbreadth_help'] = 'Ta identifikator temelji na socialni globini, ki jo je udeleženec dosegel v dejavnosti odziva.';
$string['indicator:socialbreadthdef'] = 'Odziv socialno';
$string['indicator:socialbreadthdef_help'] = 'Udeleženec je dosegel ta odstotek socialnega udejstvovanja, ki ga ponuja dejavnost Odziv med izbranim intervalom analize (ravni= brez sodelovanja, sodelovanje, sodelovanje z drugimi)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Informacije';
$string['infotype'] = 'Vrsta podatkov';
$string['insufficient_responses'] = 'nezadostni odogovori';
$string['insufficient_responses_for_this_group'] = 'Za to skupino obstajajo nezadostni odogovori';
$string['insufficient_responses_help'] = 'Če želite obdržati anonimnost odzivov, je potrebno podati minimalno 2 odgovora.';
$string['item_label'] = 'Oznaka';
$string['item_name'] = 'Vprašanje';
$string['label'] = 'Oznaka';
$string['labelcontents'] = 'Vsebina';
$string['mapcourse'] = 'Preslikajte odziv na predmete';
$string['mapcourse_help'] = 'Privzeto so obrazci za odziv, ustvarjeni na vaši domači strani, dostopni po celotni strani
in bodo prikazani v vseh predmetih, ki uporabljajo blok Odzivi. Prisilite lahko prikaz obrazca za odziv, če ga spremenite v samolepilni blok, ali pa omejite predmete, pri katerih prikaže obrazec za odziv s preslikanjem obrazca na določen predmet.';
$string['mapcourseinfo'] = 'To je odziv po celotni strani, ki je na voljo vsem predmetom ki uporabljajo blok Odzivi. Lahko pa s preslikanjem omejite predmete, v katerih bo prikazan. Poiščite predmet in ga preslikajte do tega odziva.';
$string['mapcoursenone'] = 'Ni preslikanih predmetov. Pripombe za vse predmete so omogočene';
$string['mapcourses'] = 'Preslikajte odziv na predmete';
$string['mappedcourses'] = 'Preslikani predmeti';
$string['mappingchanged'] = 'Preslikovanje predmeta je bilo spremenjeno';
$string['maximal'] = 'Maksimum';
$string['messageprovider:message'] = 'Opomnik o odzivih';
$string['messageprovider:submission'] = 'Obvestila o pripombah';
$string['minimal'] = 'Minimum';
$string['mode'] = 'Način';
$string['modulename'] = 'Pripombe';
$string['modulename_help'] = 'Modul dejavnosti odziva omogoči ustvarjanje raziskav po meri. Tako lahko zbirate odzive udeležencev, ki uporabljajo različne vrste vprašanj, na primer vprašanje z več možnimi odgovori, vprašanja z odgovori ja/ne, vnos besedila.

Če želite, so lahko odgovori na odziv anonimni, rezultati pa vidni vsem udeležencem ali le učiteljem. Katero koli dejavnost odziva na naslovni strani spletnega mesta lahko izvedejo tudi nevpisani uporabniki.

Uporabite lahko dejavnost odziva

* Za vrednotnenje predmeta, kar pomaga pri izboljševanju vsebine za nadaljnje udeležence.
* Da omogočite udeležencem, da se prijavijo na module predmetov, dogodkov itd.
* Za gostujoče ankete o izbiri predmetov, o šolski politiki itd.
* Za ankete o nasilju, v katerih lahko udeleženci anonimno prijavijo incident';
$string['modulename_link'] = 'mod/feedback/view';
$string['modulenameplural'] = 'Pripombe';
$string['move_item'] = 'Premaknite to vprašanje';
$string['multichoice'] = 'Izbirni tip vprašanja';
$string['multichoice_values'] = 'Vrednosti več izbir';
$string['multichoiceoption'] = '<span class="weight">({$a->weight}) </span>{$a->name}';
$string['multichoicerated'] = 'Izbirno (ocenjeno)';
$string['multichoicetype'] = 'Vrsta več odgovorov';
$string['multiplesubmit'] = 'Dovolite več oddaj';
$string['multiplesubmit_help'] = 'Če je omogočeno za anonimne ankete, lahko uporabniki neomejeno oddajajo odziv.';
$string['name'] = 'Ime';
$string['name_required'] = 'Ime je zahtevano';
$string['nameandlabelformat'] = '({$a->label}) {$a->name}';
$string['next_page'] = 'Naslednja stran';
$string['no_handler'] = 'Upravitelj dejanj ne obstaja za';
$string['no_itemlabel'] = 'Brez nalepke';
$string['no_itemname'] = 'Ni imena elementa';
$string['no_items_available_yet'] = 'Zaenkrat še ni bilo postavljenih vprašanj';
$string['no_templates_available_yet'] = 'Trenutno še ni predlog na voljo';
$string['non_anonymous'] = 'Ime uporabnika bo zabeleženo in prikazano z odgovori';
$string['non_anonymous_entries'] = 'Neanonimni vnosi ({$a})';
$string['non_respondents_students'] = 'Udeleženci brez odziva ({$a})';
$string['not_completed_yet'] = 'Ni še zaključeno';
$string['not_selected'] = 'Ni izbrano';
$string['not_started'] = 'Ni začeto';
$string['numberoutofrange'] = 'Število izven dosega';
$string['numeric'] = 'Številčni odgovor';
$string['numeric_range_from'] = 'Obseg od';
$string['numeric_range_to'] = 'Obseg do';
$string['of'] = 'od';
$string['oldvaluespreserved'] = 'Vsa stara vprašanja in določene vrednosti bodo ohranjene';
$string['oldvalueswillbedeleted'] = 'Trenutna vprašanja in vsi vaši odgovori bodo izbrisani.';
$string['only_one_captcha_allowed'] = 'Samo en test CAPTCHA na pripombo je dovoljen';
$string['openafterclose'] = 'Začetni datum ste določili po končnem datumu';
$string['overview'] = 'Pregled';
$string['page'] = 'Stran';
$string['page-mod-feedback-x'] = 'Vsaka stran modula odziva';
$string['page_after_submit'] = 'Sporočilo ob zaključku';
$string['pagebreak'] = 'Prelom strani';
$string['pluginadministration'] = 'Skrbništvo odzivov';
$string['pluginname'] = 'Pripombe';
$string['position'] = 'Pozicija';
$string['previous_page'] = 'Prejšnja stran';
$string['privacy:metadata:completed'] = 'Zapis o oddaji odziva';
$string['privacy:metadata:completed:anonymousresponse'] = 'Ta nastavitev določa, če bo oddaja uporabljena anonimno.';
$string['privacy:metadata:completed:timemodified'] = 'Čas, ko je bila oddaja nazadnje spremenjena.';
$string['privacy:metadata:completed:userid'] = 'ID uporabnika, ki je končal dejavnost odziva.';
$string['privacy:metadata:completedtmp'] = 'Zapis o oddajah, ki so še v teku.';
$string['privacy:metadata:value'] = 'Zapis o odgovorih na vprašanje.';
$string['privacy:metadata:value:value'] = 'Izbran odgovor.';
$string['privacy:metadata:valuetmp'] = 'Zapis o odgovoru na vprašanje v oddaji, ki je še v teku.';
$string['public'] = 'Javno';
$string['question'] = 'Vprašanje';
$string['questionandsubmission'] = 'Nastavitve vprašanj in oddaj';
$string['questions'] = 'Vprašanja';
$string['questionslimited'] = 'Prikaz samo {$a} prvih vprašanj; oglejte si posamezne odgovore ali prenesite podatkovne tabele za ogled vseh.';
$string['radio'] = 'Več izbir - en odgovor';
$string['radio_values'] = 'Odgovori';
$string['ready_feedbacks'] = 'Pripravite odzive';
$string['required'] = 'Zahtevano';
$string['resetting_data'] = 'Ponastavi odgovore na odzive';
$string['resetting_feedbacks'] = 'Ponastavljanje pripomb';
$string['response_nr'] = 'Številka odgovora';
$string['responses'] = 'Odgovori';
$string['responsetime'] = 'Čas odgovora';
$string['save_as_new_item'] = 'Shrani kot novo vprašanje';
$string['save_as_new_template'] = 'Shranite kot novo predlogo';
$string['save_entries'] = 'Oddajte svoje odgovore';
$string['save_item'] = 'Shranite vprašanje';
$string['saving_failed'] = 'Shranjevanje je neuspešno';
$string['search:activity'] = 'Odziv – podatki o dejavnosti';
$string['search_course'] = 'Iščite predmet';
$string['searchcourses'] = 'Išči predmete';
$string['searchcourses_help'] = 'Iščite po kodi ali imenu predmeta(ov), ki jih želite povezati s tem odzivom.';
$string['selected_dump'] = 'Izbrani indeksi za različico $SESSION so izpisani spodaj:';
$string['send'] = 'Pošlji';
$string['send_message'] = 'Pošljite sporočilo';
$string['show_all'] = 'Prikaži vse';
$string['show_analysepage_after_submit'] = 'Prikaži stran z analizo';
$string['show_entries'] = 'Prikaži odgovore';
$string['show_entry'] = 'Prikaži odgovor';
$string['show_nonrespondents'] = 'Prikaži neanketirance';
$string['site_after_submit'] = 'Spletno mesto po oddaji';
$string['sort_by_course'] = 'Razvrsti po predmetih';
$string['started'] = 'Začeto';
$string['startedon'] = 'Začeto {$a}';
$string['subject'] = 'Zadeva';
$string['switch_item_to_not_required'] = 'Nastavite kot nezahtevano';
$string['switch_item_to_required'] = 'Nastavite kot zahtevano';
$string['template'] = 'Predloga';
$string['template_deleted'] = 'Predloga izbrisana';
$string['template_saved'] = 'Predloga je shranjena';
$string['templates'] = 'Predloge';
$string['textarea'] = 'Daljši besedilni odgovor';
$string['textarea_height'] = 'Število vrstic';
$string['textarea_width'] = 'Širina';
$string['textfield'] = 'Kratek besedilni odgovor';
$string['textfield_maxlength'] = 'Največje število sprejetih znakov';
$string['textfield_size'] = 'Širina polja za besedilo';
$string['there_are_no_settings_for_recaptcha'] = 'Za test CAPTCHA ni nastavitev';
$string['this_feedback_is_already_submitted'] = 'To dejavnost ste že zaključili.';
$string['typemissing'] = 'Manjkajoča vrednost »vrsta"';
$string['update_item'] = 'Shranite spremembe vprašanja';
$string['url_for_continue'] = 'Povezava na naslednjo dejavnost';
$string['url_for_continue_help'] = 'Po oddaji odziva se prikaže gumb za nadaljevanje, ki vas preusmeri na stran predmeta. Če pa je tukaj vpisan spletni naslov dejavnosti, vas lahko preusmeri tudi na naslednjo dejavnost.';
$string['use_one_line_for_each_value'] = 'Za vsak odgovor uporabite eno vrstico!';
$string['use_this_template'] = 'Uporabite to predlogo';
$string['using_templates'] = 'Uporabite predlogo';
$string['vertical'] = 'Navpično';
