<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_certificate', language 'pt_br', version '4.0'.
 *
 * @package     tool_certificate
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcertpage'] = 'Nova página';
$string['addelement'] = 'Adicionar elemento';
$string['addelementwithname'] = 'Adicionar elemento \'{$a}\'';
$string['after'] = 'Após';
$string['aissueswerecreated'] = '{$a} certificados foram emitidos';
$string['aligncentre'] = 'Centro';
$string['alignleft'] = 'Esquerda';
$string['alignment'] = 'Alinhamento do texto';
$string['alignment_help'] = 'O alinhamento do texto à direita significa que as coordenadas do elemento (Posição X e Posição Y) farão referência ao canto superior direito da caixa de texto, no alinhamento no centro a referência será no topo ao centro e o alinhamento à esquerda o canto superior esquerdo será a referência';
$string['alignright'] = 'Direita';
$string['allowfilters'] = 'Filtros permitidos para o conteúdo do PDF';
$string['allowfilters_desc'] = 'Somente os filtros selecionados (se ativados) serão aplicados aos textos dentro dos PDFs do certificado';
$string['archived'] = 'Arquivado';
$string['availableincourses'] = 'Disponível em sub-categorias e cursos';
$string['availableincourses_help'] = 'Habilitando essa opção, os usuários (com permissão de emitir certificados) poderão usar esse modelo em todos os cursos dentro da categoria selecionada e também nos cursos em suas sub-categorias. Se essa opção estiver desabilitada, o modelo ficará disponível exclusivamente aos usuários com permissão de emitir certificados na categoria selecionada.';
$string['certificate'] = 'Certificado';
$string['certificate:image'] = 'Gerenciar imagens de certificados';
$string['certificate:issue'] = 'Emitir certificado para usuários';
$string['certificate:manage'] = 'Gerenciar certificados';
$string['certificate:verify'] = 'Verificar quaisquer certificados';
$string['certificate:viewallcertificates'] = 'Ver todos os modelos de certificados e certificados emitidos';
$string['certificate_customfield'] = 'Campos personalizados do certificado';
$string['certificatecopy'] = '{$a} (cópia)';
$string['certificateelement'] = 'Elemento do certificado';
$string['certificateimages'] = 'Imagens de certificados';
$string['certificates'] = 'Certificados';
$string['certificatesettings'] = 'Configurações de certificados';
$string['certificatesissues'] = 'Certificados emitidos';
$string['certificatetemplate'] = 'Modelo de certificado';
$string['certificatetemplatename'] = 'Nome do modelo de certificado';
$string['certificatetemplates'] = 'Modelos de certificados';
$string['changeelementsequence'] = 'Trazer para frente ou mover para trás';
$string['code'] = 'Código';
$string['codewithlink'] = 'Código com link';
$string['coursecategorywithlink'] = 'Categoria do curso com link';
$string['createtemplate'] = 'Novo modelo de certificado';
$string['customfield_previewvalue'] = 'Valor para pré-visualização';
$string['customfield_previewvalue_help'] = 'Valor mostrado quando pré-visualizando o modelo de certificado';
$string['customfield_visible'] = 'Visível';
$string['customfield_visible_help'] = 'Permitir selecionar este campo no modelo de certificado';
$string['customfieldsettings'] = 'Configurações comuns de campos personalizados de certificado';
$string['deleteelement'] = 'Excluir elemento';
$string['deleteelementconfirm'] = 'Você tem certeza que quer excluir o elemento \'{$a}\'?';
$string['deletepage'] = 'Excluir página';
$string['deletepageconfirm'] = 'Você tem certeza que quer excluir essa página de certificado?';
$string['deletetemplateconfirm'] = 'Você tem certeza que quer excluir o modelo de certificado \'{$a}\' e todos os dados associados? Essa ação não pode ser desfeita.';
$string['demotmpl'] = 'Demonstração do modelo de certificado';
$string['demotmplawardedon'] = 'Concedido em';
$string['demotmplawardedto'] = 'Este certificado é concedido a';
$string['demotmplbackground'] = 'Imagem de fundo';
$string['demotmplcoursefullname'] = 'Nome completo do curso';
$string['demotmpldirector'] = 'Diretor da escola';
$string['demotmplforcompleting'] = 'Por concluir o curso';
$string['demotmplissueddate'] = 'Data de emissão';
$string['demotmplqrcode'] = 'QR code';
$string['demotmplsignature'] = 'Assinatura';
$string['demotmplusername'] = 'Nome do usuário';
$string['duplicate'] = 'Duplicar';
$string['duplicatetemplateconfirm'] = 'Você tem certeza que quer duplicar o modelo \'{$a}\'?';
$string['editcertificate'] = 'Editar modelo do certificado \'{$a}\'';
$string['editelement'] = 'Editar \'{$a}\'';
$string['editelementname'] = 'Editar nome do elemento';
$string['editpage'] = 'Editar página {$a}';
$string['edittemplatename'] = 'Editar o nome do modelo';
$string['elementname'] = 'Nome do elemento';
$string['elementname_help'] = 'Esse será o nome usado para identificar esse elemento quando editando umc ertificado. Note que esse nome não será mostrado no PDF.';
$string['elementwidth'] = 'Largura';
$string['elementwidth_help'] = 'Especifique a largura do elemento. Zero (0) significa que não terá um limite para largura.';
$string['entitycertificate'] = 'Certificado';
$string['entitycertificateissue'] = 'Certificado emitido';
$string['eventcertificateissued'] = 'Certificado emitido';
$string['eventcertificaterevoked'] = 'Certificado revogado';
$string['eventcertificateverified'] = 'Certificado verificado';
$string['eventtemplatecreated'] = 'Modelo criado';
$string['eventtemplatedeleted'] = 'Modelo excluído';
$string['eventtemplateupdated'] = 'Modelo atualizado';
$string['expired'] = 'Expirado';
$string['expiredcertificate'] = 'Este certificado expirou';
$string['expirydate'] = 'Data de expiração';
$string['expirydatetype'] = 'Tipo de data de expiração';
$string['font'] = 'Fonte';
$string['font_help'] = 'A fonte utilizada quando gerando esse elemento.';
$string['fontcolour'] = 'Cor';
$string['fontcolour_help'] = 'A cor da fonte.';
$string['fontsize'] = 'Tamanho';
$string['fontsize_help'] = 'O tamanho da fonte em pontos.';
$string['hideshow'] = 'Esconder/mostrar';
$string['invalidcolour'] = 'Cor inválida escolhida. Por favor, insira um nome de cor válido em HTML ou uma cor em hexadecimal representada com três ou seis dígitos.';
$string['invalidelementwidth'] = 'Por favor, insira um número positivo.';
$string['invalidheight'] = 'A altura deve ser um número válido maior que zero.';
$string['invalidmargin'] = 'A margem deve ser um número válido maior que zero.';
$string['invalidposition'] = 'Por favor, selecione um número positivo para posicionar {$a}';
$string['invalidwidth'] = 'A largura deve ser um número válido maior que zero.';
$string['issuecertificates'] = 'Emitir certificados';
$string['issuedcertificates'] = 'Certificados emitidos';
$string['issueddate'] = 'Data de emissão';
$string['issuelang'] = 'Emitir certificados no idioma do usuário';
$string['issuelangdesc'] = 'Em sites multi-idiomas, quando o idioma do usuário for diferente do idioma do site, os certificados serão gerados no idioma do usuário, caso contrário, todos os certificados serão gerados no idioma padrão do site.';
$string['issuenewcertificate'] = 'Emitir certificados a partir desse modelo';
$string['issuenotallowed'] = 'Você não tem permissão para emitir certificados a partir desse modelo';
$string['issueormangenotallowed'] = 'Você não tem permissão para emitir certificados a partir desse modelo nem para gerenciar o modelo';
$string['leftmargin'] = 'Margem esquerda';
$string['leftmargin_help'] = 'Esta é a margem esquerda do PDF do certificado em mm.';
$string['linkedinorganizationid'] = 'ID da organização no LinkedIn';
$string['linkedinorganizationid_desc'] = 'O ID da organização no LinkedIn que emite certificados.

Onde encontro o ID da minha organização no LinkedIn?

1. Faça login no LinkedIn como administrador da página da organização da sua empresa
2. Verifique o URL usado quando você estiver conectado como administrador. (A URL deve ser semelhante a "https://linkedin.com/company/xxxxxxx/admin")
3. O ID da sua organização no LinkedIn será o número de sete dígitos no URL (exibido como "xxxxxxx" na etapa acima)';
$string['manageelementplugins'] = 'Gerenciar plugins de elementos de certificados';
$string['managetemplates'] = 'Gerenciar modelos de certificados';
$string['messageprovider:certificateissued'] = 'Certificado recebido';
$string['milimeter'] = 'mm';
$string['mycertificates'] = 'Meus certificados';
$string['mycertificatesdescription'] = 'Esses são os certificados que você emitiu por email ou fez o download manualmente.';
$string['name'] = 'Nome';
$string['nametoolong'] = 'Você excedeu o comprimento máximo permitido para o nome';
$string['never'] = 'Nunca';
$string['noimage'] = 'Sem imagem';
$string['noissueswerecreated'] = 'Nenhum certificado foi emitido';
$string['nopermissionform'] = 'Você não tem permissão para acessar este formulário.';
$string['notificationmsgcertificateissued'] = 'Olá {$a->fullname},<br /><br />Seu certificado está disponível! Você vai encontrá-lo aqui:
<a href="{$a->url}">Meus certificados</a>';
$string['notificationsubjectcertificateissued'] = 'Seu certificado está disponível!';
$string['notverified'] = 'Não verificado';
$string['numberofpages'] = 'Número de páginas';
$string['oneissuewascreated'] = 'Um certificado foi emitido';
$string['page'] = 'Página {$a}';
$string['pageheight'] = 'Altura da página';
$string['pageheight_help'] = 'Essa é a altura do PDF do certificado em mm. Para referência, uma folha de papel A4 tem 297mm de altura e um papel de carta tem 279mm de altura.';
$string['pagewidth'] = 'Largura da página';
$string['pagewidth_help'] = 'Essa é a largura do PDF do certificado em mm. Para referência, uma folha de papel A4 tem 210mm de largura e um papel de carta tem 216mm de largura.';
$string['pluginname'] = 'Gerenciador de certificados';
$string['posx'] = 'Posição X';
$string['posx_help'] = 'Essa é a posição em mm, à partir do canto superior esquerdo, na qual você quer que o ponto de referência do elemento fique localizado na direção x.';
$string['posy'] = 'Posição Y';
$string['posy_help'] = 'Essa é a posição em mm, à partir do canto superior esquerdo, na qual você quer que o ponto de referência do elemento fique localizado na direção y.';
$string['privacy:metadata:tool_certificate:issues'] = 'A lista dos certificados emitidos';
$string['privacy:metadata:tool_certificate_issues:code'] = 'O código que pertence ao certificado';
$string['privacy:metadata:tool_certificate_issues:expires'] = 'O momento em que o certificado expira. Informar 0 se ele não expira.';
$string['privacy:metadata:tool_certificate_issues:templateid'] = 'O ID do certificado';
$string['privacy:metadata:tool_certificate_issues:timecreated'] = 'O momento em que o certificado foi emitido';
$string['privacy:metadata:tool_certificate_issues:userid'] = 'O ID do usuário que emitiu o certificado';
$string['reg_wpcertificates'] = 'Número de certificados ({$a})';
$string['reg_wpcertificatesissues'] = 'Número de certificados emitidos ({$a})';
$string['regenerate'] = 'Gerar novamente';
$string['regeneratefileconfirm'] = 'Você tem certeza que quer gerar novamente o certificado emitido para o usuário?';
$string['regenerateissuefile'] = 'Gerar novamente o arquivo do certificado emitido';
$string['revoke'] = 'Revogar';
$string['revokecertificateconfirm'] = 'Você tem certeza que quer revogar esse certificado emitido para este usuário?';
$string['rightmargin'] = 'Margem direita';
$string['rightmargin_help'] = 'Essa é a margem direita do PDF em mm.';
$string['selectdate'] = 'Selecionar a data';
$string['selectuserstoissuecertificatefor'] = 'Selecionar os usuários para quem emitir o certificado';
$string['shared'] = 'Compartilhado';
$string['shareonlinkedin'] = 'Compartilhar no LinkedIn';
$string['show_shareonlinkedin'] = 'Mostrar compartilhar no LinkedIn';
$string['show_shareonlinkedin_desc'] = 'Se o botão "Compartilhar no LinkedIn" deve ser exibido na página meus certificados';
$string['status'] = 'Status';
$string['subplugintype_certificateelement_plural'] = 'Plugins de elemento de certificado';
$string['template'] = 'Modelo';
$string['templatepermission'] = 'Permissão para acessar o modelo';
$string['templatepermissionany'] = 'Não verificar';
$string['templatepermissionyes'] = 'Verificar a permissão do usuário atual';
$string['timecreated'] = 'Data/Hora da criação';
$string['uploadimage'] = 'Enviar imagem';
$string['valid'] = 'Válido';
$string['validcertificate'] = 'Esse certificado é válido';
$string['verified'] = 'Verificado';
$string['verify'] = 'Verificar';
$string['verifycertificates'] = 'Verificar certificados';
$string['verifynotallowed'] = 'Você não tem permissão para verificar certificados.';
$string['viewcertificate'] = 'Ver certificado';
