<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_xp', language 'pt_br', version '4.0'.
 *
 * @package     block_xp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Ações';
$string['activityoresourceis'] = 'A atividade ou recurso é {$a}';
$string['addacondition'] = 'Adicione uma condição';
$string['addarule'] = 'Adicione uma regra';
$string['addinstructions'] = 'Adicionar mais informações';
$string['additionalresources'] = 'Recursos adicionais';
$string['addoninstallationerror'] = 'Foi encontrado um problema com o complemento (local_xp), que parece não estar instalado corretamente. O administrador deve finalizar a instalação.';
$string['addonnotactivated'] = 'O recurso complementar não está ativado.';
$string['addrulesformhelp'] = 'A última coluna define a quantidade de pontos de experiência ganhos quando um critério é satisfeito.';
$string['admindefaultrulesintro'] = 'As regras a seguir serão utilizadas como padrão para cursos onde o bloco for adicionado.';
$string['admindefaultsettingsintro'] = 'As configurações abaixo serão utilizadas como padrão quando o bloco for adicionado novamente a um curso.';
$string['admindefaultvisualsintro'] = 'As configurações seguintes serão utilizadas como padrão quando o bloco for adicionado novamente a um curso.';
$string['anonymity'] = 'Anonimato';
$string['anonymity_help'] = 'Esta configuração controla se os participantes podem ver o nome e o avatar uns dos outros.';
$string['awardaxpwhen'] = '<strong>{$a}</strong> pontos de experiência são ganhos quando:';
$string['basexp'] = 'Algoritmo base';
$string['blockappearance'] = 'Aparência do bloco';
$string['blockappearancemovedtopluginsettings'] = 'As configurações de aparência do bloco foram movidas para a página de configurações do plugin.';
$string['cachedef_filters'] = 'Filtros de nível';
$string['cachedef_ruleevent_eventslist'] = 'Lista de alguns eventos';
$string['cannotshowblockconfig'] = 'Normalmente mostro as configurações de aparência aqui, mas não consegui encontrar seu bloco. Para alterar a aparência do bloco, volte [aqui]({$a}) (ou onde você adicionou o bloco), ative o modo de edição e clique na opção "Configurar" na lista suspensa do bloco. Se você não conseguir encontrar o bloco, adicione-o novamente ao seu curso.';
$string['cannotshowblockconfigsys'] = 'Normalmente, mostro as configurações de aparência aqui, mas não consegui encontrar seu bloco. Pode estar faltando na
 [página inicial]({$a->fp}) e no [painel]({$a->mysys}) de seus usuários, ou presente em ambos. Para editar as configurações aqui, verifique se elas aparecem apenas em uma delas.';
$string['changelevelformhelp'] = 'Se você alterar o número de níveis, os emblemas personalizados de níveis serão temporariamente desabilitados para prevenir níveis sem emblemas. Se você alterar o número de níveis vá para a página \'Visuais\' para re-habilitar os emblemas personalizados uma vez que tenha salvo esse formulário.';
$string['cheatguard'] = 'Proteção contra fraude';
$string['clicktoselectcm'] = 'Clique para selecionar uma atividade ou recurso';
$string['cmselector'] = 'Seletor de módulo de curso';
$string['coefxp'] = 'Coeficiente do algoritmo';
$string['colon'] = '{$a->a}: {$a->b}';
$string['configblockrankingsnapshot'] = 'Exibir amostra do ranking';
$string['configblockrankingsnapshot_help'] = 'A amostra do ranking exibe a classificação do usuário. Ele também tentará exibir as duas pessoas ao redor do usuário. Esse recurso requer que a tabela de classificação seja ativada e suas classificações sejam exibidas.';
$string['configdescription'] = 'Introdução';
$string['configdescription_help'] = 'Uma pequena mensagem de introdução exibida no bloco. Os estudantes podem descartar a mensagem e, nesse caso, eles não a verão novamente.';
$string['configheader'] = 'Configurações';
$string['configrecentactivity'] = 'Mostrar recompensas recentes';
$string['configrecentactivity_help'] = 'Quando ativado, o bloco exibirá uma pequena lista de eventos recentes que recompensaram o estudante com pontos.';
$string['configtitle'] = 'Título';
$string['configtitle_help'] = 'O título do bloco';
$string['congratulationsyouleveledup'] = 'Parabéns!';
$string['coolthanks'] = 'Muito bom, obrigado!';
$string['courselog'] = 'Log do curso';
$string['coursereport'] = 'Relatório do curso';
$string['courserules'] = 'Regras do curso';
$string['courseselectedcolon'] = 'Curso selecionado:';
$string['coursesettings'] = 'Configurações do curso';
$string['coursevisuals'] = 'Visuais do curso';
$string['customizelevels'] = 'Customizar os níveis';
$string['dangerzone'] = 'Zona de perigo';
$string['defaultlevels'] = 'Níveis padrão';
$string['defaultrules'] = 'Regras padrão';
$string['defaultrulesformhelp'] = 'Essas são regras padrão fornecidas pelo plugin que atribuem pontos de experiência automaticamente e ignoram alguns eventos redundantes. Regras personalizadas têm precedência sobre elas.';
$string['defaultsettings'] = 'Configurações padrão';
$string['defaultvisuals'] = 'Visual padrão';
$string['deletecondition'] = 'Condição de exclusão';
$string['deleterule'] = 'Regra de exclusão';
$string['description'] = 'Descrição';
$string['difference'] = 'Diferença';
$string['discoverlevelupplus'] = 'Descubra o Level Up XP+';
$string['dismissnotice'] = 'Ignorar aviso';
$string['displayeveryone'] = 'Exibir todos';
$string['displaynneighbours'] = 'Exibir {$a} vizinhos';
$string['displayoneneigbour'] = 'Exibir um vizinho';
$string['displayparticipantsidentity'] = 'Exibir a identidade dos participantes';
$string['displayrank'] = 'Mostrar classificação';
$string['displayrelativerank'] = 'Mostrar uma classificação relativa';
$string['documentation'] = 'Documentação';
$string['editinstructions'] = 'Editar informação';
$string['enablecheatguard'] = 'Ativar proteção contra fraude';
$string['enablecheatguard_help'] = 'A proteção contra fraude oferece um mecanismo simples e barato para evitar que os estudantes abusem do sistema usando técnicas óbvias, como atualizar a mesma página indefinidamente ou repetir a mesma ação repetidas vezes.

[Mais informação] (https://docs.levelup.plus/xp/docs/getting-started/cheat-guard?ref=blockxp_help)';
$string['enableinfos'] = 'Habilitar a página de informações';
$string['enableinfos_help'] = 'Quando setado para \'Não\', os estudantes não serão capazes de ver a página de informações.';
$string['enableladder'] = 'Habilitar ranking';
$string['enableladder_help'] = 'Quando setado para \'Não\', os estudantes não serão capazes de ver o ranking.';
$string['enablelevelupnotif'] = 'Habilitar notificações de mudança de nível';
$string['enablelevelupnotif_help'] = 'Quando setado para \'Sim\', os estudantes verão um popup parabenizando-os pelo novo nível alcançado.';
$string['enablelogging'] = 'Habilitar registros de log';
$string['enablexpgain'] = 'Habilitar ganho de pontos XP';
$string['enablexpgain_help'] = 'Quando setado para \'Não\', ninguém ganhará pontos de experiência no curso. Isso é útil para congelar a experiência ganha, ou para habilitar por um certo período de tempo.

Por favor, note que isto pode ser controlado de forma mais precisa usando a capacidade \'block/xp:earnxp\'.';
$string['entersearchterm'] = 'Digite um termo de pesquisa';
$string['errorcontextcoursemismatchforwholesite'] = 'A URL desta página para o <em>Level Up XP</em> não corresponde à configuração atual do módulo. A configuração atual do <em>Level Up XP</em> determina que ele pode ser usado \'Em todo o site\'; no entanto, esta página espera que ele seja usado \'Por disciplina\'. Por favor, <a href="{$a->nexturl}">clique aqui</a> para acessar a página correta. Procure a configuração de administrador \'block_xp_context\' se pretender alterar esta definição.';
$string['errorcontextcoursemismatchpercourse'] = 'A URL desta página para o <em>Level Up XP</em> não corresponde à configuração atual do módulo. A configuração atual do <em>Level Up XP</em> determina que ele pode ser usado \'Por disciplina\'; no entanto, esta página espera que seja usado \'Em todo o site\'. Provavelmente, foi originado de um <em>bloco</em> que foi adicionado ao painel ou à primeira página em uma configuração diferente. O bloco precisará ser removido das últimas páginas e usado apenas em disciplinas individuais.';
$string['errorformvalues'] = 'Existem alguns erros nos valores do formulário, por favor, resolva-os.';
$string['errorlevelsincorrect'] = 'O número mínimo de níveis é 2';
$string['errornotalllevelsbadgesprovided'] = 'Nem todos os emblemas de níveis foram informados. Faltando: {$a}';
$string['errorunknownevent'] = 'Erro: evento desconhecido';
$string['errorunknownmodule'] = 'Erro: módulo desconhecido';
$string['errorxprequiredlowerthanpreviouslevel'] = 'A experiência necessária é menor ou igual ao nível anterior.';
$string['event_user_leveledup'] = 'Usuário subiu de nível';
$string['eventis'] = 'O evento é {$a}';
$string['eventname'] = 'Nome do evento';
$string['eventproperty'] = 'Propriedades do evento';
$string['eventsrules'] = 'Regras dos eventos';
$string['eventsrules_help'] = 'Este recurso usa os eventos para atribuir pontos às ações executadas pelos estudantes.
Utilize o formulário abaixo para adicionar as suas próprias regras e modificar as pré-definidas.

É recomendável verificar os logs do módulo para identificar quais eventos são acionados à medida que os estudantes realizam ações na disciplina.

Recursos adicionais (em inglês):

- [Como são calculados os pontos de experiência?](https://levelup.plus/docs/article/how-are-experience-points-calculated?ref=blockxp_help
- [Regras de resolução de problemas](https://levelup.plus/docs/article/event-rule-not-working?ref=blockxp_help)';
$string['eventtime'] = 'Data do evento';
$string['filterbyuser'] = 'Filtrar por usuário';
$string['filtermodules'] = 'Módulos de filtro';
$string['for1day'] = 'Por um dia';
$string['for1month'] = 'Por um mês';
$string['for1week'] = 'Por uma semana';
$string['for3days'] = 'Por 3 dias';
$string['forever'] = 'Para sempre';
$string['forthewholesite'] = 'Para todo o site';
$string['give'] = 'dar';
$string['gotofullladder'] = 'Ir para o ranking completo';
$string['grid'] = 'Grade';
$string['hideparticipantsidentity'] = 'Ocultar identidade dos participantes';
$string['hiderank'] = 'Ocultar classificação';
$string['incourses'] = 'Em cursos';
$string['ineffective'] = 'Ineficaz';
$string['infos'] = 'Informação';
$string['installed'] = 'Instalado';
$string['instructions'] = 'Mais Informações';
$string['invalidxp'] = 'Valores inválidos';
$string['keeplogs'] = 'Manter logs';
$string['ladder'] = 'Ranking';
$string['ladderadditionalcols'] = 'Colunas adicionais';
$string['ladderadditionalcols_help'] = 'Essa configuração determina quais colunas adicionais são exibidas no ranking. Pressione a tecla CTRL ou CMD enquanto clica para selecionar mais de uma coluna ou para desmarcar uma coluna selecionada.';
$string['ladderempty'] = 'O ranking está vazio, volte mais tarde!';
$string['learnmore'] = 'Saiba mais';
$string['level'] = 'Nível';
$string['levelbadges'] = 'Emblemas de nível';
$string['levelbadgesformhelp'] = 'Nome dos arquivos [nivel].[extensão do arquivo], por exemplo: 1.png, 2.jpg, etc... O tamanho recomendado da imagem é 100x100.';
$string['levelcount'] = 'Quantidade de níveis';
$string['leveldesc'] = 'Descrição do nível';
$string['leveldesc_help'] = 'Uma descrição breve do nível, isto é exibido na pagina de informações junto com o próprio nível. Você pode utilizar isto para descrever uma recompensa para os estudantes que alcançam o nível, para incluir instruções de como atingir este nível, ou para descrever o nível de maneira divertida (por exemplo, _Diz-se que somente as almas mais destemidas conseguem atingir este nível_), etc.';
$string['levelname'] = 'Nome do nível';
$string['levelname_help'] = 'Um nome de nível curto para exibição ao invés do padrão _Nível #1_, _Nível #2_, etc. que algumas vezes é exibido. Se você dar nome a alguns níveis, nós recomendamos que você dê nome a todos!';
$string['levels'] = 'Níveis';
$string['levelswillbereset'] = 'Atenção! Ao salvar este formulário os níveis de todos serão recalculados!';
$string['levelup'] = 'Passou de nível!';
$string['levelupplus'] = 'Level Up XP+';
$string['levelx'] = 'Nível #{$a}';
$string['likenotice'] = '<strong>Você gosta do plugin?</strong> Por favor, aguarde um momento para <a href="{$a->moodleorg}" target="_blank">adicioná-lo aos seus favoritos</a> em Moodle.org e <a href="{$a->github}" target="_blank">marque-o com uma estrela no GitHub</a>.';
$string['limitparticipants'] = 'Limite de participantes';
$string['limitparticipants_help'] = 'Esta configuração controla quem é exibido no placar. Vizinhos são os participantes classificados acima e abaixo do usuário atual. Por exemplo, ao escolher \'Exibir 2 vizinhos\', somente os dois participantes classificados diretamente acima e abaixo do usuário atual serão exibidos.';
$string['list'] = 'Lista';
$string['logging'] = 'Logging';
$string['manually'] = 'Manualmente';
$string['maxactionspertime'] = 'Max. ações no intervalo de tempo';
$string['maxactionspertime_help'] = 'O número máximo de ações que contarão para ganho de pontos de experiência durante o intervalo de tempo fornecido. Qualquer ação subsequente será ignorada. Quando este valor está vazio ou é igual a zero, não é aplicado.';
$string['maxlevelexcl'] = 'nível máximo!';
$string['menu'] = 'Menu';
$string['missing'] = 'Ausente';
$string['movecondition'] = 'Condição de movimento';
$string['moverule'] = 'Regra de movimento';
$string['name'] = 'Nome';
$string['navinfos'] = 'Informações';
$string['navladder'] = 'Ranking';
$string['navlevels'] = 'Níveis';
$string['navlevelssetup'] = 'Configuração';
$string['navlog'] = 'Log';
$string['navpoints'] = 'Pontos';
$string['navpromo'] = 'XP+';
$string['navreport'] = 'Relatório';
$string['navrules'] = 'Regras';
$string['navsettings'] = 'Configurações';
$string['navvisuals'] = 'Visuais';
$string['nextlevelin'] = 'próximo nível em';
$string['nodescription'] = 'Sem descrição';
$string['nologsrecordedyet'] = 'Os logs ainda não foram registrados.';
$string['noname'] = 'Sem nome';
$string['notesomesettingslocked'] = 'Observe que algumas configurações podem não ser editáveis se forem bloqueadas por um administrador.';
$string['occasionally'] = 'Ocasionalmente';
$string['participant'] = 'Participante';
$string['participants'] = 'Participantes';
$string['participatetolevelup'] = 'Participe do curso para ganhar pontos de experiência e passar de nível!';
$string['perpagecolon'] = 'Por página:';
$string['pickaconditiontype'] = 'Escolha um tipo de condição';
$string['pluginavailabilityxpdesc'] = 'Este plugin permite que os professores restrinjam o acesso às atividades com base nos níveis dos alunos.';
$string['pluginenrolxpdesc'] = 'Este plugin permite a inscrição automática em cursos a partir do nível do aluno em outro curso.';
$string['pluginname'] = 'Level Up XP';
$string['pluginshortcodesdesc'] = 'Este plugin permite que os instrutores personalizem seu material incluindo elementos relacionados aos XP (pontos, nível, ranking…) no conteúdo, além de ocultar ou exibir itens com base no nível do aluno.';
$string['pluginsoutofsync'] = '__Os plugins não estão sincronizados!__

Isto significa que o _Level Up XP_ foi atualizado, mas o _Level Up XP+_ ainda não. Embora sejam feitas tentativas para evitar problemas, alguns recursos podem não funcionar corretamente, incluindo o próprio _Level Up XP_. Recomendamos que o _Level Up XP+_ seja atualizado para a última versão. [Leia mais]({$a->url})';
$string['pointsintimelinker'] = 'por';
$string['pointsrequired'] = 'Pontos requeridos';
$string['privacy:metadata:log'] = 'Armazena um log de eventos';
$string['privacy:metadata:log:eventname'] = 'O nome do evento';
$string['privacy:metadata:log:time'] = 'A data em que aconteceu';
$string['privacy:metadata:log:userid'] = 'O usuário que ganhou os pontos';
$string['privacy:metadata:log:xp'] = 'Os pontos atribuídos para o evento';
$string['privacy:metadata:prefintro'] = 'Registra se o usuário descartou a introdução do bloco';
$string['privacy:metadata:prefladderpagesize'] = 'O tamanho de página preferido do usuário ao visualizar o ranking';
$string['privacy:metadata:preflevelup'] = 'Registra se o usuário deve ver a notificação de aumento de nível';
$string['privacy:metadata:prefnotices'] = 'Registra se o usuário fechou o aviso de suporte';
$string['privacy:metadata:prefseenpromo'] = 'Registra quando o usuário visualizou a página promocional';
$string['privacy:metadata:xp'] = 'Armazena os pontos e o nível dos usuários';
$string['privacy:metadata:xp:lvl'] = 'O nível do usuário';
$string['privacy:metadata:xp:userid'] = 'O usuário';
$string['privacy:metadata:xp:xp'] = 'Os pontos do usuário';
$string['privacy:path:addon'] = 'Add-on';
$string['privacy:path:level'] = 'Nível';
$string['privacy:path:logs'] = 'Logs';
$string['progress'] = 'Progresso';
$string['progressbar'] = 'Barra de progresso';
$string['promocheatguard'] = 'A proteção contra fraude não foi projetada para cobrir longos períodos de tempo . Por favor, considere atualizar para a versão <em>Level Up XP+</em>, a fim de desbloquear prazos maiores e outros recursos. <a href="{$a->url} ">Leia mais</a>.';
$string['promocontactintro'] = 'Contacte-nos para mais informações. Nós não mordemos e nós respondemos rapidamente!';
$string['promocontactus'] = 'Entrar em contato';
$string['promoemailusat'] = 'Nos envie um e-mail em _levelup@branchup.tech_.';
$string['promoerrorsendingemail'] = 'Ai! Não foi possível enviar a mensagem ... envie um e-mail diretamente para: {$a}. Obrigado!';
$string['promoifpreferemailusat'] = 'Psiu! Se preferir, envie-nos um e-mail diretamente para  _{$a}_.';
$string['promointro'] = 'O plugin adicional _Level Up XP+_ possui recursos que motivam os estudantes e liberam todo o seu potencial!';
$string['promointroinstalled'] = 'O plugin adicional _Level Up XP+_ está instalado no sistema e todos os recursos foram habilitados.';
$string['promorulesdidyouknow'] = 'Você sabia que com o <em>Level Up XP+</em> os estudantes podem receber pontos para <em>concluir os cursos</em> e <em>as atividades</em> ou, até mesmo, receber pontos de acordo com as suas <em>notas</em>? <a href="{$a->url}">Leia mais</a>.';
$string['promoyourmessagewassent'] = 'Obrigado, sua mensagem foi enviada. Nós entraremos em contato com você em breve';
$string['property:action'] = 'Ação do evento';
$string['property:component'] = 'Componente do evento';
$string['property:crud'] = 'CRUD do evento';
$string['property:eventname'] = 'Nome do evento';
$string['property:target'] = 'Alvo do evento';
$string['rank'] = 'Classificação';
$string['ranking'] = 'Ranking';
$string['ranking_help'] = 'A classificação é a posição absoluta do usuário atual no ranking. A classificação relativa é a diferença dos pontos de experiência entre um usuário e seus vizinhos.';
$string['reallydeleteuserstate'] = 'Excluir um usuário é útil apenas para removê-lo do ranking. Para outras razões, nós recomendamos definir seus pontos para 0. Note que excluí-los não o impede de ganhar pontos no futuro.

Importante! Quando utilizar o _Level Up XP_ para todo o site, excluir usuários fará com que eles desapareçam do relatório e não será possível atribuir pontos a eles. Entretanto, se você estiver usando o _Level Up XP_ para cursos específicos, o estudante ainda pode aparecer no relatório se estiver inscrito no curso.

Você realmente deseja excluir os pontos deste usuário?';
$string['reallydeleteuserstateandlogs'] = 'A exclusão de um usuário o remove do ranking e exclui todos os logs associados.

A exclusão de logs pode permitir que um usuário ganhe novamente pontos por ações anteriores. Se sua intenção é apenas redefinir seus pontos, recomendamos definir seus pontos como 0. Observe que excluir um usuário não afeta sua capacidade de ganhar pontos no futuro.

É importante ressaltar que, ao usar _Level Up XP_ para todo o site, excluí-los os fará desaparecer do relatório, caso em que você não poderá reatribuir pontos a eles. No entanto, se você estiver usando _Level Up XP_ por curso, o estudante ainda poderá aparecer no relatório se estiver matriculado no curso.

Deseja mesmo deletar os pontos e logs deste usuário?';
$string['reallyresetallcoursestodefaults'] = 'Você deseja realmente redefinir todas as regras de cursos para as regras padrão? Esta ação não pode ser desfeita.';
$string['reallyresetcourserulestodefaults'] = 'Você deseja realmente redefinir todas as regras de cursos para as regras padrão? Esta ação não pode ser desfeita.';
$string['reallyresetdata'] = 'Deseja realmente zerar os níveis e pontos de todos neste curso?';
$string['reallyresetgroupdata'] = 'Deseja realmente zerar os níveis e pontos  para todos neste grupo?';
$string['reallyreverttopluginsdefaults'] = 'Deseja realmente redefinir as regras padrão para os parâmetros sugeridos pelo plugin? Esta ação não pode ser desfeita.';
$string['recentrewards'] = 'Recompensas recentes';
$string['recommendedplugins'] = 'Plugins recomendados';
$string['releasenotes'] = 'Notas da versão';
$string['remaining'] = 'restante(s)';
$string['removefilter'] = 'Remover filtro';
$string['reportisempty'] = 'O relatório está vazio. Os esstudantes ainda irão ganhar pontos.';
$string['reportisemptyenrolstudents'] = 'O relatório está vazio. Há estudantes inscritos neste curso?';
$string['requires'] = 'Requer';
$string['resetallcoursestodefaults'] = 'Redefinir todos os cursos para o padrão';
$string['resetallcoursestodefaultsintro'] = 'Clique no botão abaixo para redefinir todos os cursos para o padrão acima';
$string['resetcoursedata'] = 'Resetar os dados do curso';
$string['resetcourserulestodefaults'] = 'Redefinir as regras do curso para o padrão';
$string['resetgroupdata'] = 'Redefinir as informações do grupo';
$string['resultsfilteredforn'] = 'Resultados filtrados por {$a}.';
$string['reverttopluginsdefaults'] = 'Redefinir para os padrões do plugin';
$string['reverttopluginsdefaultsintro'] = 'Use o botão abaixo se desejar reverter os parâmetros acima para os padrões do plugin. Isto não afeta as regras dos cursos existentes';
$string['reward'] = 'Recompensa';
$string['rule'] = 'Regra';
$string['rule:contains'] = 'contêm';
$string['rule:eq'] = 'é igual a';
$string['rule:eqs'] = 'é estritamente igual a';
$string['rule:gt'] = 'é maior que';
$string['rule:gte'] = 'é maior ou igual a';
$string['rule:lt'] = 'é menor que';
$string['rule:lte'] = 'é menor ou igual a';
$string['rule:regex'] = 'corresponde ao regex';
$string['rulecm'] = 'Atividade ou recurso';
$string['rulecm_help'] = 'Essa condição é atendida quando o evento ocorre na atividade ou recurso especificado.';
$string['rulecmdesc'] = 'A atividade ou recurso é \'{$a->contextname}\'.';
$string['rulecmdescwithcourse'] = 'A atividade ou recurso é: \'{$a->contextname}\' em \'{$a->coursename}\'.';
$string['rulecminfo'] = 'Essa condição exige que a ação ocorra em uma atividade específica.';
$string['ruleevent'] = 'Evento específico';
$string['ruleeventdesc'] = 'O evento é \'{$a->eventname}\'';
$string['ruleeventinfo'] = 'Escolha a ação que os usuários devem executar na lista de eventos selecionados.';
$string['ruleproperty'] = 'Propriedades do evento';
$string['rulepropertydesc'] = 'A propriedade \'{$a->property}\' {$a->compare} \'{$a->value}\'.';
$string['rulepropertyinfo'] = 'Esta condição é para usuários avançados, com conhecimento técnico sobre os eventos do Moodle e suas propriedades.';
$string['ruleset'] = 'Conjunto de condições';
$string['ruleset:all'] = 'TODAS as condições são verdadeiras';
$string['ruleset:any'] = 'Quaisquer das condições são verdadeiras';
$string['ruleset:none'] = 'Nenhuma das condições é verdadeira';
$string['rulesetinfo'] = 'Combinar várias condições em uma.';
$string['rulesformhelp'] = '<p>Este plugin é feito usando os eventos para atribuir pontos por ações executadas pelos estudantes. Você pode usar o formulário abaixo para adicionar suas próprias regras e visualizar as padrões.</p>
<p>É aconselhável verificar o <a href="{$a->log}">log</a> do plugin para identificar quais eventos são disparados conforme você executa ações no curso, e também ler mais sobre esses eventos: <a href="{$a->list}">lista de todos os eventos</a>, <a href="{$a->doc}">documentação para desenvolvedores</a>.</p>
<p>Finalmente, por favor, note que o plugin sempre ignora:
<ul>
    <li>Ações executadas por administradores, visitantes ou usuários não logados.</li>
    <li>Ações executadas por usuários que não tem a capacidade <em>block/xp:earnxp</em>.</li>
    <li>Ações repetidas em um curto espaço de tempo, para prevenir trapaças.</li>
    <li>E os eventos que o nível educacional não é igual a <em>Participar</em>.</li>
</ul>
</p>';
$string['searchandselectcourse'] = 'Pesquise e selecione um curso';
$string['searchandselectmodule'] = 'Pesquise e selecione uma atividade ou recurso';
$string['send'] = 'Enviar';
$string['setpoints'] = 'Definir pontos';
$string['shortcode:xpbadge'] = 'O emblema que corresponde ao nível do usuário atual';
$string['shortcode:xpiflevel'] = 'Exibe o conteúdo quando o nível atual do usuário corresponde.';
$string['shortcode:xpiflevel_help'] = 'Consulte os exemplos abaixo para formatar este shortcode. Quando um nível é estritamente especificado, o conteúdo será exibido independentemente das outras regras. As regras _maior que_ and _menor que_ devem corresponder ao conteúdo a ser exibido. Tenha cuidado pois isso pode, às vezes, resultar em conteúdo nunca exibido! Observe que os professores ou usuários com recursos de edição, sempre verão tudo.

```
[xpiflevel 1 3 5]
    Exibido se o nível do usuário for exatamente 1, 3 ou 5.
[/xpiflevel]

[xpiflevel >3]
    Exibido se o nível do usuário for maior que 3.
[/xpiflevel]

[xpiflevel >=3]
    Exibido se o nível do usuário for maior ou igual a 3.
[/xpiflevel]

[xpiflevel >=10 <20 30]
    Exibido se o nível do usuário for maior ou igual a 10 E é estritamente menor que 20  OU é exatamente igual a 30.
[/xpiflevel]

[xpiflevel <=10 >=20]
    Nunca exibido porque o nível do usuário nunca pode ser menor ou igual a 10 E mais ou igual a 20.
[/xpiflevel]
```

Note que estes códigos de acesso NÃO PODEM ser aninhados uns dentro dos outros.';
$string['shortcode:xpladder'] = 'Exibe uma parte do ranking.';
$string['shortcode:xpladder_help'] = 'Por padrão, uma parte do ranking próxima do usuário será exibida.

```
[xpladder]
```

Para exibir os 10 primeiros estudantes ao invés dos vizinhos do usuário, insira o parâmetro `top`. Você pode também setar o número de usuários que você gostaria de exibir, como `top=20`.

```
[xpladder top]
[xpladder top=15]
```

Um link para o ranking todo será automaticamente exibido abaixo da tabela. Se você não quiser que o link apareça, adicione o argumento `hidelink`.

```
[xpladder hidelink]
```

Por padrão, a tabela não inclui a coluna de progresso, que mostra a barra de progresso. Se essa coluna foi selecionada nas colunas adicionais dentro das configurações do ranking, você pode utilizar o argurmento `withprogress` para exibi-la.

```
[xpladder withprogress]
```

Note que quando um curso utiliza grupos, o ranking vai fazer o malhor chute de qual grupo exibir o ranking.';
$string['shortcode:xplevelname'] = 'Mostrar o nome do nível';
$string['shortcode:xplevelname_help'] = 'Por padrão, é exibido o nome do nível atual do usuário.
Outra opção é usar o argumento \'level\' para exibir o nome de um nível específico.

`` ``
[xplevelname]
[xplevelname level = 5]
`` ``

Se o argumento \'level\' for indicado e o nível não existir, nada será exibido.';
$string['shortcode:xppoints'] = 'Exibe um número de pontos formatados como pontos de experiência.';
$string['shortcode:xpprogressbar'] = 'Barra de progresso do usuário atual para o próximo nível.';
$string['somefeaturesrequireotherplugins'] = 'Alguns recursos requerem a instalação de plugins adicionais.';
$string['someoneelse'] = 'Outra pessoa';
$string['somethinghappened'] = 'Algo aconteceu';
$string['taskcollectionloggerpurge'] = 'Limpar registros de log';
$string['taskusagereport'] = 'Relatório de uso';
$string['thankyou'] = 'Obrigado!';
$string['timebetweensameactions'] = 'Tempo requerido entre ações idênticas';
$string['timebetweensameactions_help'] = 'O tempo mínimo requerido antes de uma ação idêntica seja aceita novamente. Uma ação é considerada idêntica se foi realizada no mesmo contexto e objeto. Por exemplo, ler um post de um fórum será considerado idêntico se o mesmo post é lido novamente. Quando este valor está vazio ou é igual a zero, isto não é aplicado.';
$string['timeformaxactions'] = 'Intervalo de tempo para max. ações';
$string['timeformaxactions_help'] = 'O intervalo de tempo (em segundos) durante o qual o usuário não deve exceder um número máximo de ações.';
$string['tinytimedays'] = '{$a}d';
$string['tinytimehours'] = '{$a}h';
$string['tinytimeminutes'] = '{$a}m';
$string['tinytimenow'] = 'agora';
$string['tinytimeolderyearformat'] = '%b %Y';
$string['tinytimeseconds'] = '{$a}s';
$string['tinytimeweeks'] = '{$a}semanas';
$string['tinytimewithinayearformat'] = '%b %e';
$string['total'] = 'Total';
$string['unknowneventa'] = 'Evento desconhecido ({$a})';
$string['updateandpreview'] = 'Atualizar e visualizar';
$string['upgradingplugins'] = 'Atualizando os plugins';
$string['urlaccessdeprecated'] = 'O acesso através desta URL está obsoleto; por favor, atualize seus links.';
$string['usagereport'] = 'Compartilhar relatório de uso';
$string['usagereport_desc'] = 'Compartilhe periodicamente informações de uso anônimas com os desenvolvedores do plugin. Essas informações ajudarão a entender melhor como o plugin está sendo usado e influenciarão seu desenvolvimento. As informações compartilhadas contêm dados básicos sobre o site Moodle (URL, versão) e informações de uso sobre o plugin (número de usuários que ganham pontos, visão geral das configurações, regras usadas...).';
$string['usealgo'] = 'Usar o algoritmo';
$string['usecustomlevelbadges'] = 'Usar emblemas de níveis personalizados';
$string['usecustomlevelbadges_help'] = 'Quando setado para sim, você deve fornecer uma imagem para cada nível.';
$string['usingalgo'] = 'Usando algoritmo';
$string['value'] = 'Valor';
$string['valuessaved'] = 'Os valores foram salvos com sucesso.';
$string['viewas'] = 'Visualizar como';
$string['viewlogs'] = 'Ver logs';
$string['viewtheladder'] = 'Visualizar o ranking';
$string['visualsintro'] = 'Carregue imagens para personalizar a aparência dos níveis.';
$string['wewillreplyat'] = 'Vamos responder em: _ {$a} _.';
$string['when'] = 'Quando';
$string['wherearexpused'] = 'Onde os pontos são usados?';
$string['wherearexpused_desc'] = 'Quando escolher \'Em cursos\', os pontos de experiência ganhos apenas serão computados no curso no qual o bloco foi adicionado. Quando escolher \'Para todo o site\', um usuário irá "subir de nível" em todo o site, ao invés de apenas por curso. Todas as experiências obtidas ao longo do site serão usadas.';
$string['whoops'] = 'Ooops!';
$string['xp'] = 'Pontos de experiência';
$string['xp:addinstance'] = 'Adicionar um novo bloco';
$string['xp:earnxp'] = 'Ganhando pontos';
$string['xp:manage'] = 'Gerenciar todos os aspectos dos pontos de experiência';
$string['xp:myaddinstance'] = 'Adicionar o bloco ao meu painel';
$string['xp:view'] = 'Visualizar o bloco e páginas relacionadas';
$string['xp:viewlogs'] = 'Acessar os logs';
$string['xp:viewreport'] = 'Ver o relatório';
$string['xpgaindisabled'] = 'Ganho de pontos desabilitado';
$string['xprequired'] = 'Pontos necessários';
$string['xptogo'] = '[[{$a}]] para ir';
$string['youreachedlevel'] = 'Você alcançou o nível:';
$string['youreachedlevela'] = 'Você alcançou o nível {$a}!';
$string['yourmessage'] = 'Sua mensagem';
$string['yourownrules'] = 'Suas prórpias regras';
