<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_fordson', language 'es', version '4.0'.
 *
 * @package     theme_fordson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityiconsize'] = 'Tamaño del icono de Actividad';
$string['activityiconsize_desc'] = 'Ajusta el tamaño de los iconos de actividad utilizados en los cursos.';
$string['activitylinkstitle'] = 'Actividades';
$string['activitylinkstitle_desc'] = 'Mostrar todas las actividades del curso';
$string['activitymenu'] = 'Mostrar el menú de actividades agrupadas';
$string['activitymenu_desc'] = 'Muestra los listados de actividades agrupadas en los paneles de estudiantes y profesores. Este menú muestra una lista agrupada de todas las actividades para el estudiante y el profesor.';
$string['advancedsettings'] = 'Ajustes avanzados';
$string['alert'] = 'Alerta de la página principal';
$string['alert_desc'] = 'Este es un mensaje de alerta especial que aparecerá en la página principal.';
$string['backgroundimage'] = 'Imagen de fondo predeterminada de la página';
$string['backgroundimage_desc'] = 'Imagen de fondo para las páginas';
$string['backtotop'] = 'Volver arriba y Scrollspy';
$string['badges'] = 'Insignias';
$string['badges_desc'] = 'Premia a tus estudiantes';
$string['blockdisplay'] = 'Opciones de ubicación de visualización de bloque';
$string['blockdisplay_desc'] = 'Elige cómo mostrar bloques en la página de inicio y las páginas del curso. Fordson añade un panel de bloques desplegable de 3 columnas que puede ser ocultado por el usuario. Elige la opción predeterminada de Boost para usar una única columna lateral derecha para los bloques. La opción predeterminada de Boost también mueve el botón Agregar un Bloque al Cajón de Navegación a la izquierda de la página. También recomendamos utilizar "Valor predeterminado Boost de columna única" cuando se utiliza cualquiera de los diseños de página de Boost desde la configuración anterior.';
$string['blockdisplay_off'] = 'Valor predeterminado Boost de columna única';
$string['blockdisplay_on'] = 'Valor predeterminado de Fordson de tres columnas';
$string['blockwidthfordson'] = 'Ancho de la columna del bloque';
$string['blockwidthfordson_desc'] = 'Ajuste del ancho de la columna del bloque.';
$string['blog'] = 'URL del Blog';
$string['blogdesc'] = 'Introduce la URL del blog de su institución. (p.e http://miinstituto.org)';
$string['bodybackground'] = 'Color de fondo del cuerpo';
$string['bodybackground_desc'] = 'El color principal para el fondo.';
$string['brandColour'] = 'Color de la marca';
$string['brandColour_desc'] = 'El color principal de tu marca';
$string['branddanger'] = 'Marca para las alertas';
$string['branddanger_desc'] = 'Color de marca para alertas de peligro y paneles, etc.';
$string['brandemail'] = 'Email de la organización';
$string['brandemaildesc'] = 'Dirección de correo electrónico de la organización que aparece en el pie de página.';
$string['brandinfo'] = 'Información de la marca';
$string['brandinfo_desc'] = 'Color de marca para alertas y paneles de información, etc';
$string['brandorganization'] = 'Nombre de la organización';
$string['brandorganizationdesc'] = 'Nombre de la organización que aparecerá en el pie de página.';
$string['brandphone'] = 'Teléfono de la organización';
$string['brandphonedesc'] = 'Número de teléfono que aparecerá en el pie de página.';
$string['brandprimary'] = 'Color principal';
$string['brandprimary_desc'] = 'Tu color principal de marca';
$string['brandsuccess'] = 'Color de éxito';
$string['brandsuccess_desc'] = 'Color de marca para alertas exitosas, paneles positivos, botones, etc';
$string['brandwarning'] = 'Color de avisos';
$string['brandwarning_desc'] = 'Color de marca para alertas de peligro y paneles, etc';
$string['brandwebsite'] = 'Sitio Web de la organización';
$string['brandwebsitedesc'] = 'Dirección del sitio web de la organización que aparecerá en el pie de página.';
$string['breadcrumbbkg'] = 'Color de fondo de la ruta de navegación';
$string['breadcrumbbkg_desc'] = 'Color de fondo de la ruta de navegación.';
$string['cardbkg'] = 'Color de Fondo del Contenido';
$string['cardbkg_desc'] = 'Color de fondo para el contenido y bloques del curso.';
$string['catsicon'] = 'Icono de Categoría';
$string['catsicon_desc'] = 'Elige un icono para representar las categorías de los cursos.';
$string['choosereadme'] = 'Fordson proporciona una experiencia visual única para el tema predeterminado Boost con funciones de personalización como selectores de color, navegación mejorada y una experiencia de página principal destacada.';
$string['collapsibletopics'] = 'Formato Curso de temas plegables';
$string['collapsibletopics_desc'] = 'Si instalas el formato de temas plegables (<a href="https://moodle.org/plugins/format_collapsibletopics"> format_collapsibletopics </a>), el tema de Fordson puede proporcionar una vista de formato de curso mejorada y un estilo especial que se integra mejor con aspecto general de Fordson. Se ha desarrollado con un cuidado y atención especiales para proporcionar una experiencia de usuario más fluida para usuarios de todas las edades y habilidades.';
$string['colours_desc'] = 'Los selectores de color te permiten personalizar la apariencia de los elementos principales de la página. Si utilizas un ajuste distinto del tema Predefinido, tendrás que eliminar los colores personalizados que siguen para obtener mejores resultados ya que estos modificarán el Predefinido, con resultados no deseados. Generalmente, el tema Predefinido tendrá colores predeterminados que desearás ver antes de personalizarlos aquí.';
$string['colours_headingsub'] = 'Ajustes de Colores';
$string['colours_settings'] = 'Colores';
$string['configtitle'] = 'Fordson';
$string['contentsettings'] = 'Áreas de contenido';
$string['courseactivities'] = 'Actividades del curso';
$string['courseblockpanelbtn'] = 'Bloques del Curso';
$string['courseblockpanelbtnclose'] = 'Cerrar';
$string['courseboxheight'] = 'Altura del mosaico del curso';
$string['courseboxheight_desc'] = 'Controla la altura del mosaico del Curso en la primera página y categorías del curso.';
$string['courseeditingcog'] = 'Mostrar el menú de configuración predeterminada del curso';
$string['courseeditingcog_desc'] = 'Si utilizas el Panel de Administración del Curso, el menú predeterminado está oculto. Al activar esta opción, puedes mostrar el menú predeterminado, así como el panel de administración del curso del profesor. Es ideal si se utiliza un complemento de terceros que utiliza el menú de curso para acceder a la configuración.';
$string['coursehome'] = 'Página de Inicio';
$string['courseinfo'] = 'Descripción del curso';
$string['coursemanage'] = 'Configuración del curso';
$string['coursemanage_desc'] = 'Gestiona tu curso';
$string['coursemanagementbutton'] = 'Gestión del curso';
$string['coursemanagementinfo'] = 'Menú Panel de Administración del Curso';
$string['coursemanagementinfodesc'] = 'Fordson ofrece un Panel de Administración de Cursos único y organizado al que los profesores pueden acceder desde cualquier lugar de un curso para acceder a los enlaces de administración de su curso. Los estudiantes también pueden acceder a un Tablero del Curso del Estudiante que incluye información relevante del curso. Es muy recomendable que lo mantengas activado.';
$string['coursemanagementtextbox'] = 'Mensaje de gestión del curso';
$string['coursemanagementtextbox_desc'] = 'Añade un mensaje para los profesores en el panel de administración del curso en cada página del curso.';
$string['coursemanagementtoggle'] = 'Mostrar los Paneles de Gestión Curso de alumnos y profesores';
$string['coursemanagementtoggle_desc'] = 'Muestra los enlaces de Administración del Curso en un panel organizado para profesores que proporciona un tablero de todos los enlaces que necesitan para administrar el curso y los usuarios. También mostrará un panel de descripción general del curso para los estudiantes con calificaciones, finalización del curso y otros elementos del curso.';
$string['coursestaff'] = 'Profesores del curso';
$string['coursestyle1'] = 'Estilo Uno de Mosaico';
$string['coursestyle10'] = 'Pantalla predeterminada del Curso Moodle';
$string['coursestyle2'] = 'Estilo Dos de Mosaico';
$string['coursestyle3'] = 'Estilo Tres de Mosaico';
$string['coursestyle4'] = 'Estilo Cuatro de Mosaico con resumen del curso';
$string['coursestyle5'] = 'Estilo Uno Horizontal';
$string['coursestyle6'] = 'Imagen horizontal de fondo con detalles completos';
$string['coursestyle7'] = 'Imagen horizontal de fondo solo título y profesores';
$string['coursestyle8'] = 'Columna Horizontal Dos';
$string['coursestyle9'] = 'Formación corporativa: mínimo con la barra de progreso de finalización';
$string['coursetileinfo'] = 'Opciones de visualización del curso';
$string['coursetileinfodesc'] = 'Estos ajustes te permiten personalizar cómo se mostrarán los cursos en la página principal, así como en las categorías de los cursos.';
$string['coursetilestyle'] = 'Mostrar Mosaico del curso';
$string['coursetilestyle_desc'] = 'A la hora de ver las categorías de curso, puedes elegir entre los siguientes estilos para mostrar los cursos. <a href="https://goo.gl/fMXzSo" target="_new"> Instrucciones para el tema Fordson 3.5</a>';
$string['createinfo'] = 'Botón especial para crear un curso';
$string['createinfodesc'] = 'Este botón aparece en la página de inicio cuando un usuario puede crear nuevos cursos. Aquellos con el rol de Creador de Cursos a nivel del sitio verán este botón.';
$string['currentinparentheses'] = '(actual)';
$string['customloginheading'] = 'Página de inicio de sesión personalizada';
$string['customlogininfo'] = 'Configuración de la página de inicio de sesión personalizada';
$string['customlogininfo_desc'] = 'Permite crear una página de inicio de sesión personalizada. Otras configuraciones del tema que se mostrarán en la página de inicio de sesión incluyen las siguientes: <br>
<b> * Administración del sitio > Seguridad > Políticas del sitio > Forzar usuarios a identificarse = Asegúrate de que esté marcado para que los usuarios ingresen en tu página de inicio de sesión personalizada. <br>
* Administración del sitio > Apariencia > Logotipos > Logotipo = Subir una imagen aquí y aparecerá encima del formulario de inicio de sesión. <br>
* Fordson > Ajustes imagen personalizada > Imagen predeterminada del acceso se puede usar para cambiar la imagen de fondo de la página de inicio de sesión. <br>
* Fordson > Áreas de contenido > La alerta de página principal se puede utilizar para proporcionar un aviso en la parte superior de la página. </b>';
$string['dashactivityoverview'] = 'RESUMEN DE ACTIVIDADES';
$string['displaybottom'] = 'Mostrarlo al final de la página';
$string['displaymycourses'] = 'Mostrar cursos matriculados';
$string['displaymycoursesdesc'] = 'Mostrar los cursos en los que están matriculados los usuarios en la barra de navegación superior.';
$string['displaythiscourse'] = 'Mostrar el menú Este curso';
$string['displaythiscoursedesc'] = 'Muestra el salto a sección en el menú del curso en la barra de navegación superior para los usuarios. Contiene elementos de menú situados previamente en el cajón de navegación.';
$string['displaytop'] = 'Mostrar en la parte superior de la página';
$string['drawerbkg'] = 'Color del fondo del Cajón lateral';
$string['drawerbkg_desc'] = 'Color de fondo del cajón lateral para el menú del lado izquierdo de la página.';
$string['easyenrollmentintegration'] = 'Complemento Easy Enrollmen';
$string['easyenrollmentintegration_desc'] = 'El complemento Easy Enrollment (<a href="https://moodle.org/plugins/enrol_easy"> Easy Enrollment Plugin </a>) permite a los estudiantes inscribirse en cursos directamente desde la página de inicio de Moodle. El complemento de inscripción utiliza un código de 6 dígitos o un código QR generado automáticamente con soporte para cámara web para inscribir a los estudiantes. El estudiante ingresa el código o escanea el código QR y se inscribe instantáneamente en el curso o grupo previsto dentro del curso. Este complemento se activa automáticamente una vez que instala Easy Enrollment y lo activa en Administración del Sitio. Solo se activa si el complemento está instalado y configurado correctamente.';
$string['editoff'] = 'Desactivar Edición';
$string['editon'] = 'Activar Edición';
$string['enablecategoryicon'] = 'Iconos para mostrar categorías';
$string['enablecategoryicon_desc'] = 'Cuando se selecciona esta opción se mostrarán las categorías de cursos como iconos';
$string['enhancedmydashboard'] = 'Mi Área personal mejorada';
$string['enhancedmydashboard_desc'] = 'Activarlo mejorará la página de área personal para incluir todas las funciones de Fordson, como el Formulario de inscripción fácil, los controles deslizantes de bloque, la barra de navegación de iconos, el texto personalizado de la página de inicio, la presentación de diapositivas y más.';
$string['enrollcoursecard'] = 'Entrar';
$string['facebook'] = 'URL Facebook';
$string['facebookdesc'] = 'Introduce la URL de tu página de Facebook. (p.e http://www.facebook.com/)';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Cambiar el favicon de Fordson. Las imágenes con un fondo transparente y una altura de 32px funcionarán mejor. Tipos permitidos: PNG, JPG, ICO';
$string['feature1info'] = 'Característica uno';
$string['feature2info'] = 'Característica dos';
$string['feature3info'] = 'Característica tres';
$string['featureimage'] = 'Imagen de la característica';
$string['featureimage_desc'] = 'Esta imagen aparecerá en una fila junto al texto de la característica.';
$string['featureinfo_desc'] = 'Una característica consiste en una imagen y texto que aparecerá en la página de inicio de sesión personalizada, en una fila. Debes agregar una imagen y un texto para que la característica aparezca.';
$string['featuretext'] = 'Texto de la característica';
$string['featuretext_desc'] = 'Este texto aparecerá en una fila junto a la imagen de la característica. Utiliza un encabezado 4 para generar un título especial dentro del cuadro de texto. En el Editor de Atto, H4 es un Encabezado(medio).';
$string['flickr'] = 'URL Flickr';
$string['flickrdesc'] = 'Introduce la URL de tu página en Flickr. (p.e http://www.flickr.com/)';
$string['footerbkg'] = 'Color del Fondo del Pie de Página';
$string['footerbkg_desc'] = 'Color de fondo del pie de página para la parte inferior de la página.';
$string['footerdesc'] = 'Los elementos que siguen permiten construir una marca al pie de página del tema.';
$string['footerheading'] = 'Pie de página';
$string['footerheadingsocial'] = 'Iconos sociales';
$string['footerheadingsub'] = 'Personalizar el pie de la página principal';
$string['footnote'] = 'Nota al pie';
$string['footnotedesc'] = 'Editor del contenido de la nota al pie para el pie de página principal';
$string['fploginform'] = 'Color del formulario de Inicio de sesión';
$string['fploginform_desc'] = 'Color de fondo del formulario de inicio de sesión en la página de inicio personalizada.';
$string['fpsignup'] = 'Registrarse';
$string['fptextbox'] = 'Caja de texto Página Principal usuario autentificado';
$string['fptextbox_desc'] = 'Este cuadro de texto aparece en la página principal una vez que el usuario se autentica. Es ideal para poner un mensaje de bienvenida y proporcionar instrucciones para el alumno.';
$string['fptextboxlogout'] = 'Caja de texto Página Principal visitante';
$string['fptextboxlogout_desc'] = 'Este cuadro de texto aparece en la página principal para los visitantes y es ideal para poner un mensaje de bienvenida o un enlace a la página de inicio de sesión.';
$string['frontpagemycoursessorting'] = 'Ordena la página Mis cursos por el último acceso';
$string['frontpagemycoursessorting_desc'] = 'Cuando está marcada, se clasificará la página Mis cursos (cursos inscritos) por el último acceso del usuario. Esto anulará la configuración "Ordenar mis cursos" en Navegación. Si no está marcada, la página Mis cursos se mostrará de forma normal.';
$string['generalcontentinfo'] = 'Configuración general de la visualización de contenido';
$string['generalcontentinfodesc'] = 'Las opciones siguientes te ayudan a personalizar la forma en que se muestra el contenido y activar funciones adicionales de Fordson.';
$string['generalsettings'] = 'Ajustes generales';
$string['googleplus'] = 'URL Google+';
$string['googleplusdesc'] = 'Introduce la URL de tu perfil de Google+. (p.e https://google.com/)';
$string['gutterwidth'] = 'Relleno del contenido';
$string['gutterwidth_desc'] = 'Este ajuste determina cuánto espacio se utiliza a la izquierda y derecha del contenido principal.';
$string['headerdefaultimage'] = 'Imagen predeterminada de la cabecera';
$string['headerdefaultimage_desc'] = 'Imagen predeterminada para los encabezados de los cursos y las páginas que no son del curso';
$string['headerimagepadding'] = 'Altura de la imagen del encabezado';
$string['headerimagepadding_desc'] = 'Controla el relleno y la altura de la imagen de cabecera de los cursos.';
$string['headerlogo'] = 'Logotipo Cabecera';
$string['headerlogo_desc'] = 'Este logotipo se mostrará en la parte superior de la página en el área de encabezado. Utiliza escalado de imágenes responsive de bootstrap.';
$string['homemyclasses'] = 'Página de inicio de la clase';
$string['homemycomp'] = 'Página de inicio de competencias';
$string['homemycourses'] = 'Página de inicio del curso';
$string['homemycred'] = 'Página de inicio de credenciales';
$string['homemylectures'] = 'Página de inicio de conferencias';
$string['homemylessons'] = 'Página de inicio de la lección';
$string['homemymodules'] = 'Página de inicio del módulo';
$string['homemyplans'] = 'Página de inicio del plan';
$string['homemyprofessionaldevelopment'] = 'Página inicio DP';
$string['homemyprograms'] = 'Página de inicio del programa';
$string['homemytraining'] = 'Página de inicio de formación';
$string['homemyunits'] = 'Página de inicio de la unidad';
$string['iconnavheading'] = 'Icono de Navegación';
$string['iconnavheadingsub'] = 'Crear botones con iconos para utilizarlos en la página de inicio.  Los enlaces pueden apuntar a cualquier sitio.';
$string['iconwidth'] = 'Ancho del icono de la página principal';
$string['iconwidth_desc'] = 'Ancho de los 8 iconos individuales en la barra de navegación de iconos de la página principal.';
$string['iconwidthinfo'] = 'Ajuste del ancho del botón icono';
$string['iconwidthinfodesc'] = 'Seleccionar un ancho que permita que el texto del enlace entre dentro de los botones icono de navegación.';
$string['ilearnsecurebrowser'] = 'Este Cuestionario está asegurado con iLearn Secure Browser (se debe usar un Chromebook con la aplicación iLearn para intentar esta prueba)';
$string['imagesettings'] = 'Ajustes imágenes personalizadas';
$string['instagram'] = 'URL Instagram';
$string['instagramdesc'] = 'Introduce la URL de tu página en Instagram. (p.e http://instagram.com/)';
$string['integrationinfo'] = 'Integración de complementos';
$string['integrationinfo_desc'] = 'Fordson puede activar funciones mejoradas e integrarse mejor con ciertos complementos. La configuración que sigue te permitirá utilizar el comportamiento del complemento predeterminado o activar las funciones avanzadas que los desarrolladores de Fordson han implementado.';
$string['integrationoff'] = 'Desactivar integración';
$string['integrationon'] = 'Activar integración';
$string['jitsibuttontext'] = 'Botón para Reunión Automática con Jitsi';
$string['jitsibuttontextdesc'] = 'El texto del botón que se añadirá a la parte superior de cada curso de Moodle. Este botón llevará a los usuarios a una sala de Jitsi Meeting que forma la URL a partir del nombre del curso y el número de ID del curso. Debes contar con un servidor de conferencia web Jitsi.';
$string['jitsibuttonurl'] = 'URL del servidor Jitsi';
$string['jitsibuttonurldesc'] = 'Un ejemplo de servidor público: https://meet.jit.si <br>NO AÑADAS UNA BARRA INVERTIDA<br> Esta URL se utilizará para el botón que se añadirá automáticamente a cada curso de Moodle en el área de encabezado. Te recomendamos configurar tu propio servidor Jitsi y forzar el inicio de sesión en la sala de reuniones Jitsi.';
$string['layoutinfo'] = 'Ajustes de diseño';
$string['layoutinfodesc'] = 'Controla el diseño de la página eligiendo un diseño.';
$string['learningcontentpadding'] = 'Espaciado del contenido de aprendizaje';
$string['learningcontentpadding_desc'] = 'Controla el espacio entre la parte superior de la página y el contenido del curso. Normalmente, preferirás que sea menor que la altura de la imagen de encabezado.';
$string['linkedin'] = 'URL LinkedIn';
$string['linkedindesc'] = 'Introduce la URL de tu perfil LinkedIn. (p.e http://www.linkedin.com/)';
$string['loginimage'] = 'Imagen por defecto del acceso';
$string['loginimage_desc'] = 'Imagen de fondo de la página de acceso';
$string['loginnavicon1'] = 'Icono uno';
$string['loginnavicon2'] = 'Icono dos';
$string['loginnavicon3'] = 'Icono tres';
$string['loginnavicon4'] = 'Icono cuatro';
$string['loginnavicontext'] = 'Texto del icono';
$string['loginnavicontextdesc'] = 'Texto que aparecerá debajo del ícono. Mantenlo corto para obtener mejores resultados.';
$string['loginnavicontitletext'] = 'Título del icono';
$string['loginnavicontitletextdesc'] = 'Texto para que aparezca debajo del ícono como título.';
$string['logintopimage'] = 'Imagen del banner de la página de inicio de sesión';
$string['logintopimage_desc'] = 'Esta imagen aparece en la página de inicio de sesión a la derecha del formulario de inicio de sesión. Es ideal para un logotipo o banner con un fondo transparente';
$string['marketboxbuttoncolor'] = 'Color del botón del anuncio';
$string['marketboxbuttoncolor_desc'] = 'El color del fondo para el botón del anuncio.';
$string['marketboxcolor'] = 'Color de fondo de la caja del anuncio';
$string['marketboxcolor_desc'] = 'El color del fondo para la caja del anuncio.';
$string['marketboxcontentcolor'] = 'Color de fondo del contenido del anuncio';
$string['marketboxcontentcolor_desc'] = 'El color del fondo para el contenido de la caja del anuncio. Aquí es donde el texto del anuncio aparece y puede ser diferente del color de fondo de la caja para llamar la atención sobre el texto.';
$string['marketing1'] = 'Anuncio Uno';
$string['marketing2'] = 'Anuncio Dos';
$string['marketing3'] = 'Anuncio Tres';
$string['marketing4'] = 'Anuncio Cuatro';
$string['marketing5'] = 'Anuncio Cinco';
$string['marketing6'] = 'Anuncio Seis';
$string['marketing7'] = 'Anuncio Siete';
$string['marketing8'] = 'Anuncio Ocho';
$string['marketing9'] = 'Anuncio Nueve';
$string['marketingbuttontext'] = 'Texto del enlace';
$string['marketingbuttontextdesc'] = 'Texto que aparece en el botón.';
$string['marketingbuttonurl'] = 'Enlace URL';
$string['marketingbuttonurldesc'] = 'URL a la que apunta el botón.';
$string['marketingcontent'] = 'Contenido';
$string['marketingcontentdesc'] = 'Contenido para mostrar en el cuadro de marketing. Que sea bueno y breve.';
$string['marketingdesc'] = 'Este tema ofrece la opción de habilitar tres puntos de "marketing" o "anuncios" justo debajo de la presentación de diapositivas. Éstos te permiten identificar fácilmente la información básica para tus usuarios y proporcionarles enlaces directos.';
$string['marketingheading'] = 'Mosaico de anuncios';
$string['marketingheadingsub'] = 'Tres ubicaciones en la página de inicio para agregar información y enlaces';
$string['marketingheight'] = 'Altura de las imágenes de los anuncios';
$string['marketingheightdesc'] = 'Si deseas mostrar imágenes en los anuncios puedes especificar su altura aquí.';
$string['marketingicon'] = 'Enlace del icono';
$string['marketingicondesc'] = 'Nombre del icono que quieres que se utilice en el botón URL del anuncio. La lista está <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">aquí</a>. Solo introduce lo que está después de "fa-", por ejemplo, "star".';
$string['marketingimage'] = 'Imagen';
$string['marketingimage_desc'] = 'Ofrece la opción de mostrar una imagen en el anuncio';
$string['marketinginfodesc'] = 'Introduce los ajustes para tu anuncio. Debes incluir un título para que aparezca el anuncio. El título activará los anuncios individuales.';
$string['marketingstyle'] = 'Selector de estilo de mosaico de marketing';
$string['marketingstyle1'] = 'Destacado de la barra superior';
$string['marketingstyle2'] = 'Nota adhesiva';
$string['marketingstyle3'] = 'Sencilla';
$string['marketingstyle4'] = 'Sombra en la caja';
$string['marketingstyle_desc'] = 'Elige entre los siguientes estilos de marketing. Cambiará la apariencia y el estilo de los cuadros de marketing en la página principal del sitio.';
$string['marketingtitle'] = 'Título';
$string['marketingtitledesc'] = 'Título que se mostrará en este anuncio. Debes incluir un título para que aparezca el mosaico de anuncios.';
$string['marketingurltarget'] = 'Enlace de destino';
$string['marketingurltargetdesc'] = 'Elige dónde debe abrirse el enlace';
$string['marketingurltargetnew'] = 'Nueva página';
$string['marketingurltargetparent'] = 'Marco padre';
$string['marketingurltargetself'] = 'Página actual';
$string['markettextbg'] = 'Fondo del texto del mosaico de anuncios';
$string['markettextbg_desc'] = 'Color de fondo para el área de texto del mosaico de anuncios.';
$string['menusettings'] = 'Ajustes del menú';
$string['myclasses'] = 'Mis clases';
$string['mycomp'] = 'Mis competencias';
$string['mycourses'] = 'Mis cursos';
$string['mycoursesinfo'] = 'Lista dinámica de cursos matriculados y menús de navegación del curso';
$string['mycoursesinfodesc'] = 'Muestra una lista dinámica con los cursos en los que está matriculado el usuario en la barra de navegación superior. También controlará el menú desplegable de navegación del curso para cada curso individual.';
$string['mycoursetitle'] = 'Terminología';
$string['mycoursetitledesc'] = 'Cambiar la terminología para el enlace "Mis Cursos" en el menú desplegable';
$string['mycred'] = 'Mis credenciales';
$string['mygradestext'] = 'Mis calificaciones';
$string['mylectures'] = 'Mis conferencias';
$string['mylessons'] = 'Mis lecciones';
$string['mymodules'] = 'Mis módulos';
$string['myplans'] = 'Mis planes';
$string['myprofessionaldevelopment'] = 'Mi DP';
$string['myprograms'] = 'Mis programas';
$string['myprogresspercentage'] = '% Completado';
$string['myprogresstext'] = 'Mi progreso';
$string['mytraining'] = 'Mi formación';
$string['myunits'] = 'Mis unidades';
$string['navbarcolorswitch'] = 'Cambio del color de la barra de navegación';
$string['navbarcolorswitch_desc'] = 'Esta función cambia el color de la barra de navegación según el rol del usuario. Un estudiante verá un color y un profesor verá otro color. Es útil cuando un profesor cambia los roles y ayuda a distinguir entre la vista de un estudiante y la vista de un profesor.';
$string['navbarcolorswitch_off'] = 'No cambiar el color de la barra de navegación según el rol.';
$string['navbarcolorswitch_on'] = 'Cambiar el color de la barra de navegación según el rol.';
$string['navdrawerbtn'] = 'Navegación';
$string['navicon'] = 'Icono';
$string['navicon1'] = 'Icono página principal uno';
$string['navicon2'] = 'Icono página principal dos';
$string['navicon3'] = 'Icono página principal tres';
$string['navicon4'] = 'Icono página principal cuatro';
$string['navicon5'] = 'Icono página principal cinco';
$string['navicon6'] = 'Icono página principal seis';
$string['navicon7'] = 'Icono página principal siete';
$string['navicon8'] = 'Icono página principal ocho';
$string['naviconbutton1textdefault'] = 'Área personal';
$string['naviconbutton2textdefault'] = 'Calendario';
$string['naviconbutton3textdefault'] = 'Insignias';
$string['naviconbutton4textdefault'] = 'Todos los cursos';
$string['naviconbuttoncreatetextdefault'] = 'Crear un curso';
$string['naviconbuttontext'] = 'Texto del enlace';
$string['naviconbuttontextdesc'] = 'Texto que aparece debajo del icono.';
$string['naviconbuttonurl'] = 'URL del enlace';
$string['naviconbuttonurldesc'] = 'URL a la que apuntará el botón. Puedes enlazar a cualquier sitio, incluyendo sitios web externos, poniendo la URL apropiada. Si tu sitio Moodle está en un subdirectorio, la URL predeterminada no funcionará. Ajústala para reflejar el subdirectorio. Ejemplo: si "moodle" fuera tu carpeta subdirectorio, entonces la URL tendría que cambiarse a /moodle/my/';
$string['navicondesc'] = 'Nombre del icono que quieres que se utilice. La lista está <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">aquí</a>. Introduce solo lo que está después de "fa-", por ejemplo, "star".';
$string['naviconslidedesc'] = 'Texto del icono sugerido: arrow-circle-down. O escoge uno de la lista que está <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">aquí</a>. Introduce solo lo que está después de "fa-", por ejemplo, "star".';
$string['noenrolments'] = 'Ahora mismo no tiene matriculaciones';
$string['nomycourses'] = 'No estás inscrito en ningún curso.';
$string['pagelayout'] = 'Selector de diseño';
$string['pagelayout1'] = 'Diseño predeterminado de Boost';
$string['pagelayout2'] = 'Ancho completo/Imagen de encabezado arriba';
$string['pagelayout3'] = 'Contenido centrado/Imagen de encabezado arriba superpuesta';
$string['pagelayout4'] = 'Contenido centrado/Imagen de encabezado pantalla completa';
$string['pagelayout5'] = 'Diseño por defecto de Boost/Imagen de encabezado en el cuadro del título del curso';
$string['pagelayout_desc'] = 'Elige entre los siguientes diseños. Ciertos diseños de página requieren ajustes adicionales en la página \'Ajustes preestablecidos\'. Asegúrate de prestar atención a las opciones: Espaciado del contenido de aprendizaje, Altura de la imagen del encabezado y Relleno de contenido, ya que ten ayudarán a ajustar la ubicación y el relleno de la imagen del encabezado a la izquierda y la derecha del contenido de aprendizaje principal. <a href="https://goo.gl/fMXzSo" target="_new"> Instrucciones para el tema Fordson 3.5 </a>';
$string['pinterest'] = 'URL Pinterest';
$string['pinterestdesc'] = 'Introduce la URL de tu página en Pinterest. (p.e http://pinterest.com/)';
$string['pluginname'] = 'Fordson';
$string['preset'] = 'Tema predefinido';
$string['preset_desc'] = 'Elige un ajuste predefinido para cambiar totalmente el aspecto del tema. <a href="https://goo.gl/fMXzSo" target="_new">Instrucciones del tema Fordson 3.5</a>';
$string['presetadjustmentsettings'] = 'Ajustes preestablecidos';
$string['presetfiles'] = 'Archivos del tema predefinido adicional';
$string['presetfiles_desc'] = 'Los archivos predefinidos pueden utilizarse para alterar radicalmente la apariencia del tema. Visita https://docs.moodle.org/dev/Boost_Presets para obtener información sobre cómo crear y compartir tus propios archivos preestablecidos.';
$string['presets_settings'] = 'Predefinidos';
$string['privacy:metadata'] = 'El tema Fordson no almacena datos individuales del usuario.';
$string['qbank'] = 'Banco de preguntas';
$string['qbank_desc'] = 'Crea y organiza preguntas de examen';
$string['rawscss'] = 'Código SCSS';
$string['rawscss_desc'] = 'Utiliza este campo para proporcionar el código SCSS que se incluirá al final de la hoja de estilo.';
$string['rawscsspre'] = 'Código SCSS inicial';
$string['rawscsspre_desc'] = 'En este campo puedes introducir el código SCSS de inicialización que se incluirá antes de todo lo demás.  La mayoría de las veces podrás usar esta configuración para definir variables.';
$string['region-fp-a'] = 'Columna A';
$string['region-fp-b'] = 'Columna B';
$string['region-fp-c'] = 'Columna C';
$string['region-side-pre'] = 'Derecha';
$string['section_mods'] = 'Módulos:';
$string['sectionlayout'] = 'Selector de estilo de sección';
$string['sectionlayout1'] = 'Predeterminado de Boost';
$string['sectionlayout2'] = 'Tarjetas';
$string['sectionlayout3'] = 'Pestañas de carpeta';
$string['sectionlayout4'] = 'Portapapeles';
$string['sectionlayout5'] = 'Caja sencilla';
$string['sectionlayout6'] = 'Título de sección resaltada';
$string['sectionlayout7'] = 'Estudiante universitario';
$string['sectionlayout8'] = 'Estudiante corporativo';
$string['sectionlayout_desc'] = 'Elige entre los siguientes estilos de temas/sección semanal. <a href="https://goo.gl/fMXzSo" target="_new">Instrucciones del tema Fordson 3.5</a>';
$string['setting_navdrawersettings'] = 'Configuración del cajón de navegación';
$string['setting_navdrawersettings_desc'] = 'Habilita la función Boost del cajón de navegación. Fordson no necesita el cajón de navegación para la navegación. Lo hemos reemplazado con un menú desplegable Saltar a la sección. Puede volver a habilitar el cajón de navegación a más abajo.';
$string['showactivitynav'] = 'Mostrar navegación de actividades';
$string['showactivitynav_desc'] = 'Desmarcar para desactivar la navegación de actividades en la parte inferior de las páginas de actividades.';
$string['showblockregions'] = 'Mostrar bloques de regiones adicionales de la página principal';
$string['showblockregions_desc'] = 'Activa tres regiones más de bloques en la página principal del sitio. Aparecen justo debajo de la barra de navegación de iconos.';
$string['showcourseadminstudents'] = 'Mostrar el menú Administrador del Curso al Estudiante';
$string['showcourseadminstudents_desc'] = 'Muestra la configuración del curso a los estudiantes. Esto es necesario si deseas permitirles cancelar su inscripción en los cursos.';
$string['showcourseheaderimage'] = 'Mostrar imágenes del curso';
$string['showcourseheaderimage_desc'] = 'Permite a los profesores personalizar la imagen del encabezado del curso subiendo una imagen a la configuración del curso.';
$string['showcustomlogin'] = 'Activar inicio de sesión personalizado';
$string['showcustomlogin_desc'] = 'Debes marcarlo para activar la configuración personalizada que sigue.';
$string['showloginform'] = 'Mostrar formulario de inicio de sesión';
$string['showloginform_desc'] = 'Desmarca esta opción para ocultar el formulario de inicio de sesión personalizado en la página de inicio para usuarios desconectados.';
$string['shownavclosed'] = 'Cajón de navegación cerrado por defecto';
$string['shownavclosed_desc'] = 'Mostrar el cajón de navegación colapsado para todos los usuarios de forma predeterminada en cada página.';
$string['shownavdrawer'] = 'Mostrar cajón de navegación';
$string['shownavdrawer_desc'] = 'Fordson ha eliminado la necesidad del cajón de navegación mediante la utilización de un menú desplegable para la navegación en el curso. Si debe usar el cajón de navegación, puede marcar esta casilla para volver a habilitarlo.';
$string['showonlygroupteachers'] = 'Mostrar solo profesores del grupo';
$string['showonlygroupteachers_desc'] = 'Cuando se habilita, solo se mostrarán los profesores del mismo grupo que el estudiante en el Panel de administración del curso del estudiante.';
$string['showslideshow'] = 'Activar presentación';
$string['showslideshow_desc'] = 'Marca esta opción para activar la función de presentación.';
$string['showstudentcompletion'] = 'Mostrar la consecución del alumno';
$string['showstudentcompletion_desc'] = 'Mostrar la consecución del alumno en el área personal del estudiante. Aunque esté activado, para que se muestre, el curso debe tener activada la opción de "Habilitar rastreo del grado de finalización".';
$string['showstudentgrades'] = 'Mostrar calificaciones de los estudiantes';
$string['showstudentgrades_desc'] = 'Mostrar el enlace al libro de calificaciones del alumno en el área personal del estudiante. Aunque esté activado, para que se muestre, el curso debe tener activada la opción de "Mostrar libro de calificaciones a los estudiantes".';
$string['siteadminquicklink'] = 'Administración del Sitio';
$string['skype'] = 'Cuenta Skype';
$string['skypedesc'] = 'Introduce el nombre de usuario de Skype de la cuenta Skype de tu organización';
$string['slide1info'] = 'Diapositiva 1';
$string['slide1infodesc'] = 'Detalles de la diapositiva 1.';
$string['slide2info'] = 'Diapositiva 2';
$string['slide2infodesc'] = 'Detalles de la diapositiva 2.';
$string['slide3info'] = 'Diapositiva 3';
$string['slide3infodesc'] = 'Detalles de la diapositiva 3.';
$string['slidecontent'] = 'Descripción de la diapositiva';
$string['slidecontent_desc'] = 'Añade una descripción para esta diapositiva.';
$string['slideimage'] = 'Imagen de la diapositiva';
$string['slideimage_desc'] = 'Añade una imagen de fondo para esta diapositiva.';
$string['sliderinfo'] = 'Botón icono especial deslizante';
$string['sliderinfodesc'] = 'Este botón mostrará/ocultará un cuadro de texto especial que se desliza hacia abajo desde la barra de navegación de iconos. Es ideal para ofrecer cursos, proporcionar ayuda o listar la capacitación necesaria del personal.';
$string['slideshowheight'] = 'Altura de la Presentación';
$string['slideshowheight_desc'] = 'Ajustar la altura de la presentación.';
$string['slideshowpages'] = 'Páginas de la Presentación';
$string['slideshowpages0'] = 'Mostrar solo en la página de inicio de sesión personalizada';
$string['slideshowpages1'] = 'Mostrar solo en la Página Principal y el Panel de control';
$string['slideshowpages2'] = 'Mostrar en todas partes';
$string['slideshowpages_desc'] = 'Determina en qué páginas principales debe aparecer la presentación de diapositivas. Si usas la presentación de diapositivas en la página de inicio de sesión personalizada, se recomienda cargar solo imágenes y no usar las siguientes opciones de texto de diapositiva. NOTA: La presentación de diapositivas no aparecerá en dispositivos móviles.';
$string['slideshowsettings'] = 'Presentación';
$string['slideshowspacer'] = 'Separación de la Presentación en la página de inicio de sesión personalizada';
$string['slideshowspacer_desc'] = 'Esta configuración se utiliza, en la página de inicio de sesión personalizada,  para agregar separación debajo del formulario de inicio de sesión en caso de que coloque texto en las diapositivas.';
$string['slidetextbox'] = 'Cuadro de texto de la diapositiva';
$string['slidetextbox_desc'] = 'El contenido del cuadro de texto se mostrará cuando se presione el botón de la diapositiva.';
$string['slidetitle'] = 'Título de la diapositiva';
$string['slidetitle_desc'] = 'Introduce un título para esta diapositiva.';
$string['sociallink'] = 'Enlace social personalizado';
$string['sociallinkdesc'] = 'Introduce la URL de su enlace social personalizado. (p.e http://dearbornschools.org)';
$string['sociallinkicon'] = 'Icono del enlace';
$string['sociallinkicondesc'] = 'Introduce el nombre fontawesome para el icono de su enlace<br />Puede encontrar la lista completa de iconos FontAwesome en https://fontawesome.com/v4.7.0/icons/';
$string['socialnetworks'] = 'Redes sociales';
$string['studentdashboardtextbox'] = 'Mensaje en el área personal del alumno';
$string['studentdashboardtextbox_desc'] = 'Agrega un mensaje para los estudiantes en el panel personal del estudiante en cada página del curso.';
$string['studentdashbutton'] = 'Este curso';
$string['textcontentinfo'] = 'Contenido personalizado';
$string['textcontentinfodesc'] = 'Utiliza los cuadros de texto siguientes para agregar información personalizada a los usuarios.';
$string['thiscourse'] = 'Este curso';
$string['thismyclasses'] = 'Esta clase';
$string['thismycomp'] = 'Esta competencia';
$string['thismycourses'] = 'Este curso';
$string['thismycred'] = 'Este credencial';
$string['thismylectures'] = 'Esta conferencia';
$string['thismylessons'] = 'Esta lección';
$string['thismymodules'] = 'Este módulo';
$string['thismyplans'] = 'Este plan';
$string['thismyprofessionaldevelopment'] = 'Esta DP';
$string['thismyprograms'] = 'Este programa';
$string['thismytraining'] = 'Esta formación';
$string['thismyunits'] = 'Esta unidad';
$string['titletooltip'] = 'Sugerencias en Títulos de Curso';
$string['titletooltip_desc'] = 'Si utilizas el recorte del título de curso se pueden utilizar sugerencias para mostrar el título completo del curso en un mensaje emergente. Marca esta casilla para activar las sugerencias.';
$string['togglemarketing'] = 'Posición del mosaico de marketing';
$string['togglemarketing_desc'] = 'Determina dónde se ubicará el mosaico de marketing en la página principal.';
$string['topnavbarbg'] = 'Barra superior de navegación por defecto';
$string['topnavbarbg_desc'] = 'Color de fondo del contenido para la barra superior de navegación.';
$string['topnavbarteacherbg'] = 'Barra superior de navegación rol de profesor';
$string['topnavbarteacherbg_desc'] = 'Color de fondo del contenido para la barra de navegación superior cuando un usuario es un profesor. Esta función debe estar activada en la configuración del menú. Por favor, vea la configuración de navbarcolorswitch.';
$string['trimsummary'] = 'Ajustar el resumen del curso';
$string['trimsummary_desc'] = 'Introduce un número para ajustar la longitud del resumen del curso. El número representa los caracteres que se mostrarán.';
$string['trimtitle'] = 'Ajustar el título del curso';
$string['trimtitle_desc'] = 'Introduce un número para ajustar la longitud del título del curso. El número representa los caracteres que se mostrarán.';
$string['tumblr'] = 'URL Tumblr';
$string['tumblrdesc'] = 'Introduce la URL de tu Tumblr. (p.e http://www.tumblr.com)';
$string['twitter'] = 'URL Twitter';
$string['twitterdesc'] = 'Introduce la URL de tu Twitter. (p.e http://www.twitter.com/)';
$string['userlinks'] = 'Enlaces del usuario';
$string['userlinks_desc'] = 'Gestiona tus estudiantes';
$string['viewfcfmodules'] = 'Ver Actividades y Recursos';
$string['viewsectionmodules'] = 'Ver módulos de sección';
$string['vimeo'] = 'URL Vimeo';
$string['vimeodesc'] = 'Introduce la URL de tu canal Vimeo. (p.e http://vimeo.com/)';
$string['vk'] = 'URL VKontakte';
$string['vkdesc'] = 'Introduce la URL de tu página en Vkontakte. (p.e http://www.vk.com/)';
$string['website'] = 'URL sitio web';
$string['websitedesc'] = 'Introduce la URL de tu sitio web. (p.e http://dearbornschools.org)';
$string['youtube'] = 'URL YouTube';
$string['youtubedesc'] = 'Introduce la URL de tu canal YouTube. (p.e http://www.youtube.com/)';
